// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package xray

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
)

type UpdateSamplingRuleInput struct {
	_ struct{} `type:"structure"`

	// The rule and fields to change.
	//
	// SamplingRuleUpdate is a required field
	SamplingRuleUpdate *SamplingRuleUpdate `type:"structure" required:"true"`
}

// String returns the string representation
func (s UpdateSamplingRuleInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateSamplingRuleInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "UpdateSamplingRuleInput"}

	if s.SamplingRuleUpdate == nil {
		invalidParams.Add(aws.NewErrParamRequired("SamplingRuleUpdate"))
	}
	if s.SamplingRuleUpdate != nil {
		if err := s.SamplingRuleUpdate.Validate(); err != nil {
			invalidParams.AddNested("SamplingRuleUpdate", err.(aws.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s UpdateSamplingRuleInput) MarshalFields(e protocol.FieldEncoder) error {
	e.SetValue(protocol.HeaderTarget, "Content-Type", protocol.StringValue("application/json"), protocol.Metadata{})

	if s.SamplingRuleUpdate != nil {
		v := s.SamplingRuleUpdate

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "SamplingRuleUpdate", v, metadata)
	}
	return nil
}

type UpdateSamplingRuleOutput struct {
	_ struct{} `type:"structure"`

	// The updated rule definition and metadata.
	SamplingRuleRecord *SamplingRuleRecord `type:"structure"`
}

// String returns the string representation
func (s UpdateSamplingRuleOutput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s UpdateSamplingRuleOutput) MarshalFields(e protocol.FieldEncoder) error {
	if s.SamplingRuleRecord != nil {
		v := s.SamplingRuleRecord

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "SamplingRuleRecord", v, metadata)
	}
	return nil
}

const opUpdateSamplingRule = "UpdateSamplingRule"

// UpdateSamplingRuleRequest returns a request value for making API operation for
// AWS X-Ray.
//
// Modifies a sampling rule's configuration.
//
//    // Example sending a request using UpdateSamplingRuleRequest.
//    req := client.UpdateSamplingRuleRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/xray-2016-04-12/UpdateSamplingRule
func (c *Client) UpdateSamplingRuleRequest(input *UpdateSamplingRuleInput) UpdateSamplingRuleRequest {
	op := &aws.Operation{
		Name:       opUpdateSamplingRule,
		HTTPMethod: "POST",
		HTTPPath:   "/UpdateSamplingRule",
	}

	if input == nil {
		input = &UpdateSamplingRuleInput{}
	}

	req := c.newRequest(op, input, &UpdateSamplingRuleOutput{})
	return UpdateSamplingRuleRequest{Request: req, Input: input, Copy: c.UpdateSamplingRuleRequest}
}

// UpdateSamplingRuleRequest is the request type for the
// UpdateSamplingRule API operation.
type UpdateSamplingRuleRequest struct {
	*aws.Request
	Input *UpdateSamplingRuleInput
	Copy  func(*UpdateSamplingRuleInput) UpdateSamplingRuleRequest
}

// Send marshals and sends the UpdateSamplingRule API request.
func (r UpdateSamplingRuleRequest) Send(ctx context.Context) (*UpdateSamplingRuleResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &UpdateSamplingRuleResponse{
		UpdateSamplingRuleOutput: r.Request.Data.(*UpdateSamplingRuleOutput),
		response:                 &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// UpdateSamplingRuleResponse is the response type for the
// UpdateSamplingRule API operation.
type UpdateSamplingRuleResponse struct {
	*UpdateSamplingRuleOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// UpdateSamplingRule request.
func (r *UpdateSamplingRuleResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
