# Examples

These two examples represent the usage of `controller-runtime` libraries for built-in Kubernetes resources as well as custom resources.

### builtins/

This example implements a custom controller and webhooks for the *existing* ReplicaSet resource.

* `controller.go`: implements a reconciler for ReplicaSets
* `mutatingwebhook.go`: implements a mutating webhook that adds an annotation to every incoming Pod ("example-mutating-admission-webhook" = "foo")
* `validatingwebhook.go`: implements a validating webhook that checks to see if a Pod has the aforementioned annotation
* `main.go`
    1. Creates a new manager
    2. Creates a new controller that watches both ReplicaSets and Pods and reconciles the objects with the implemented reconciler
    3. Registers the mutating and validating webhooks with the manager
    4. Starts the manager

### crd/

This example implements a *new* Kubernetes resource, ChaosPod, and creates a custom controller that watches it and webhooks that mutate and validate.

* `pkg/`
    * `resource.go`: defines the schema for the ChaosPod API and implements validate and mutate webhooks
    * `groupversion_info.go`: specifies the Group and Version for the ChaosPod API
    * `zz_generated.deepcopy.go`: deep copy functions generated by kubebuilder
* `main.go`
    1. Creates a new manager
    2. Adds ChaosPod resource to the manager's schema
    3. Implements a reconciler to execute the desired behavior of the ChaosPod API
    4. Creates a new controller that watches ChaosPods and reconciles the objects with the implemented reconciler
    5. Adds ChaosPod webhooks to manager
    6. Starts the manager

## Deploying and Running

To install and run the provided examples, see the Kubebuilder [Quick Start](https://book.kubebuilder.io/quick-start.html).