---
title: Testing Operator Deployment with OLM
linkTitle: Test Deployment
weight: 4
---

The [Operator Lifecycle Manager (OLM)][olm] is a set of cluster resources that
manage the lifecycle of an Operator. The Operator SDK provides an entrypoint for
deploying your Operator using an OLM-enabled Kubernetes cluster through
[`operator-sdk run packagemanifests`][cli-run-olm]. This command is currently
intended for testing only.

This document assumes you are familiar with OLM and related terminology, and have
read the SDK-OLM integration [design proposal][sdk-olm-design].

`run packagemanifests` assumes OLM is already installed and running on your cluster.
If not, you can install OLM by running [`operator-sdk olm install`][cli-olm-install].
You can check the status of OLM by running [`operator-sdk olm status`][cli-olm-status].

`run packagemanifests` also assumes you have valid [Operator bundle][operator-bundle]
manifests and metadata available on disk. You can create manifests using
[`operator-sdk generate csv`][cli-generate-csv], which will create a [`ClusterServiceVersion` (CSV)][csv]
in and copy your `CustomResourceDefinition`'s to a manifests directory.
Then create metadata using [`operator-sdk bundle create --generate-only`][cli-bundle-create].

**Note:** before continuing, please read the [caveats](#caveats) section below.

## `operator-sdk run packagemanifests` command overview

Let's look at the anatomy of the `run packagemanifests` configuration model:

- **kubeconfig-path**: the local path to a kubeconfig.
  - This uses well-defined default loading rules to load the config if empty.
- **olm-namespace**: the namespace in which OLM is installed.
- **operator-namespace**: the cluster namespace in which Operator resources are created.
  - This namespace must already exist in the cluster or be defined in a manifest passed to **include-paths**.
- **manifests-dir**: a directory containing the Operator's metadata and manifests.
- **operator-version**: the version of the Operator to deploy. It must be a semantic version, ex. 0.1.0.
  - This version must match the version of the CSV manifest found in **manifests-dir**,
    ex. `deploy/olm-catalog/<operator-name>/manifests` in an Operator SDK project.
- **install-mode**: specifies which supported [`installMode`][csv-install-modes] should be used to
  create an `OperatorGroup` by configuring its `spec.targetNamespaces` field.
  - The `InstallModeType` string passed must be marked as "supported" in the CSV being installed.
    The namespaces passed must exist or be created by passing a `Namespace` manifest to IncludePaths.
  - This option understands the following strings (assuming your CSV does as well):
      - `OwnNamespace`: the Operator will watch its own namespace
        (from **operator-namespace** or the kubeconfig default). This is the default.
      - `SingleNamespace="my-ns"`: the Operator will watch a namespace, not necessarily its own.
      - `MultiNamespace="my-ns-1,my-ns-2"`: the Operator will watch multiple namespaces.
      - `AllNamespaces=""`: the Operator will watch all namespaces (cluster-scoped Operators).
- **include-paths**: a list of paths to manifests of Kubernetes resources that either
  supplement or supplant defaults generated by `run`, ex. RBAC kinds.
  - This option can be used if you have an existing set of manifests outside your bundle
    (ex. catalog manifests like a `Subscription`, `CatalogSource`, and/or `OperatorGroup`)
    you wish to create for Operator deployment.
      - Paths supplied to this command will be created with the same behavior of `kubectl create -f <path>`.
  - Kinds that are overridden if supplied: `CatalogSource`, `Subscription`, `OperatorGroup`.
      - If a `Subscription` or `CatalogSource` are supplied, the other must be supplied
        since they are linked by field references.
- **timeout**: a time string dictating the maximum time that `run` can run. The command will
  return an error if the timeout is exceeded.

### Caveats

- `<run|cleanup> packagemanifests` are intended to be used for testing purposes
only as of now, since this command creates a transient image registry that should
not be used in production. Typically a registry is deployed separately and a set
of catalog manifests are created in the cluster to inform OLM of that registry
and which Operator versions it can deploy and where to deploy the Operator.
- `run packagemanifests` can only deploy one Operator and one version of that Operator
at a time, hence its intended purpose being testing only.


[olm]:https://github.com/operator-framework/operator-lifecycle-manager/
[csv]:https://github.com/operator-framework/operator-lifecycle-manager/blob/master/doc/design/building-your-csv.md
[csv-install-modes]:https://github.com/operator-framework/operator-lifecycle-manager/blob/master/doc/design/building-your-csv.md#operator-metadata[operator-bundle]:https://github.com/operator-framework/operator-registry/tree/v1.5.3#manifest-format
[sdk-olm-design]:https://github.com/operator-framework/operator-sdk/blob/master/proposals/sdk-integration-with-olm.md
[cli-olm-install]:/docs/cli/operator-sdk_olm_install
[cli-olm-status]:/docs/cli/operator-sdk_olm_status
[cli-run-olm]:/docs/cli/operator-sdk_run_packagemanifests
[cli-generate-csv]:/docs/cli/operator-sdk_generate_csv
[cli-bundle-create]:/docs/cli/operator-sdk_bundle_create
