// Code generated by client-gen. DO NOT EDIT.

package v1alpha1

import (
	"context"
	"time"

	scheme "github.com/open-cluster-management/api/client/cluster/clientset/versioned/scheme"
	v1alpha1 "github.com/open-cluster-management/api/cluster/v1alpha1"
	v1 "k8s.io/apimachinery/pkg/apis/meta/v1"
	types "k8s.io/apimachinery/pkg/types"
	watch "k8s.io/apimachinery/pkg/watch"
	rest "k8s.io/client-go/rest"
)

// ManagedClusterSetBindingsGetter has a method to return a ManagedClusterSetBindingInterface.
// A group's client should implement this interface.
type ManagedClusterSetBindingsGetter interface {
	ManagedClusterSetBindings(namespace string) ManagedClusterSetBindingInterface
}

// ManagedClusterSetBindingInterface has methods to work with ManagedClusterSetBinding resources.
type ManagedClusterSetBindingInterface interface {
	Create(ctx context.Context, managedClusterSetBinding *v1alpha1.ManagedClusterSetBinding, opts v1.CreateOptions) (*v1alpha1.ManagedClusterSetBinding, error)
	Update(ctx context.Context, managedClusterSetBinding *v1alpha1.ManagedClusterSetBinding, opts v1.UpdateOptions) (*v1alpha1.ManagedClusterSetBinding, error)
	Delete(ctx context.Context, name string, opts v1.DeleteOptions) error
	DeleteCollection(ctx context.Context, opts v1.DeleteOptions, listOpts v1.ListOptions) error
	Get(ctx context.Context, name string, opts v1.GetOptions) (*v1alpha1.ManagedClusterSetBinding, error)
	List(ctx context.Context, opts v1.ListOptions) (*v1alpha1.ManagedClusterSetBindingList, error)
	Watch(ctx context.Context, opts v1.ListOptions) (watch.Interface, error)
	Patch(ctx context.Context, name string, pt types.PatchType, data []byte, opts v1.PatchOptions, subresources ...string) (result *v1alpha1.ManagedClusterSetBinding, err error)
	ManagedClusterSetBindingExpansion
}

// managedClusterSetBindings implements ManagedClusterSetBindingInterface
type managedClusterSetBindings struct {
	client rest.Interface
	ns     string
}

// newManagedClusterSetBindings returns a ManagedClusterSetBindings
func newManagedClusterSetBindings(c *ClusterV1alpha1Client, namespace string) *managedClusterSetBindings {
	return &managedClusterSetBindings{
		client: c.RESTClient(),
		ns:     namespace,
	}
}

// Get takes name of the managedClusterSetBinding, and returns the corresponding managedClusterSetBinding object, and an error if there is any.
func (c *managedClusterSetBindings) Get(ctx context.Context, name string, options v1.GetOptions) (result *v1alpha1.ManagedClusterSetBinding, err error) {
	result = &v1alpha1.ManagedClusterSetBinding{}
	err = c.client.Get().
		Namespace(c.ns).
		Resource("managedclustersetbindings").
		Name(name).
		VersionedParams(&options, scheme.ParameterCodec).
		Do(ctx).
		Into(result)
	return
}

// List takes label and field selectors, and returns the list of ManagedClusterSetBindings that match those selectors.
func (c *managedClusterSetBindings) List(ctx context.Context, opts v1.ListOptions) (result *v1alpha1.ManagedClusterSetBindingList, err error) {
	var timeout time.Duration
	if opts.TimeoutSeconds != nil {
		timeout = time.Duration(*opts.TimeoutSeconds) * time.Second
	}
	result = &v1alpha1.ManagedClusterSetBindingList{}
	err = c.client.Get().
		Namespace(c.ns).
		Resource("managedclustersetbindings").
		VersionedParams(&opts, scheme.ParameterCodec).
		Timeout(timeout).
		Do(ctx).
		Into(result)
	return
}

// Watch returns a watch.Interface that watches the requested managedClusterSetBindings.
func (c *managedClusterSetBindings) Watch(ctx context.Context, opts v1.ListOptions) (watch.Interface, error) {
	var timeout time.Duration
	if opts.TimeoutSeconds != nil {
		timeout = time.Duration(*opts.TimeoutSeconds) * time.Second
	}
	opts.Watch = true
	return c.client.Get().
		Namespace(c.ns).
		Resource("managedclustersetbindings").
		VersionedParams(&opts, scheme.ParameterCodec).
		Timeout(timeout).
		Watch(ctx)
}

// Create takes the representation of a managedClusterSetBinding and creates it.  Returns the server's representation of the managedClusterSetBinding, and an error, if there is any.
func (c *managedClusterSetBindings) Create(ctx context.Context, managedClusterSetBinding *v1alpha1.ManagedClusterSetBinding, opts v1.CreateOptions) (result *v1alpha1.ManagedClusterSetBinding, err error) {
	result = &v1alpha1.ManagedClusterSetBinding{}
	err = c.client.Post().
		Namespace(c.ns).
		Resource("managedclustersetbindings").
		VersionedParams(&opts, scheme.ParameterCodec).
		Body(managedClusterSetBinding).
		Do(ctx).
		Into(result)
	return
}

// Update takes the representation of a managedClusterSetBinding and updates it. Returns the server's representation of the managedClusterSetBinding, and an error, if there is any.
func (c *managedClusterSetBindings) Update(ctx context.Context, managedClusterSetBinding *v1alpha1.ManagedClusterSetBinding, opts v1.UpdateOptions) (result *v1alpha1.ManagedClusterSetBinding, err error) {
	result = &v1alpha1.ManagedClusterSetBinding{}
	err = c.client.Put().
		Namespace(c.ns).
		Resource("managedclustersetbindings").
		Name(managedClusterSetBinding.Name).
		VersionedParams(&opts, scheme.ParameterCodec).
		Body(managedClusterSetBinding).
		Do(ctx).
		Into(result)
	return
}

// Delete takes name of the managedClusterSetBinding and deletes it. Returns an error if one occurs.
func (c *managedClusterSetBindings) Delete(ctx context.Context, name string, opts v1.DeleteOptions) error {
	return c.client.Delete().
		Namespace(c.ns).
		Resource("managedclustersetbindings").
		Name(name).
		Body(&opts).
		Do(ctx).
		Error()
}

// DeleteCollection deletes a collection of objects.
func (c *managedClusterSetBindings) DeleteCollection(ctx context.Context, opts v1.DeleteOptions, listOpts v1.ListOptions) error {
	var timeout time.Duration
	if listOpts.TimeoutSeconds != nil {
		timeout = time.Duration(*listOpts.TimeoutSeconds) * time.Second
	}
	return c.client.Delete().
		Namespace(c.ns).
		Resource("managedclustersetbindings").
		VersionedParams(&listOpts, scheme.ParameterCodec).
		Timeout(timeout).
		Body(&opts).
		Do(ctx).
		Error()
}

// Patch applies the patch and returns the patched managedClusterSetBinding.
func (c *managedClusterSetBindings) Patch(ctx context.Context, name string, pt types.PatchType, data []byte, opts v1.PatchOptions, subresources ...string) (result *v1alpha1.ManagedClusterSetBinding, err error) {
	result = &v1alpha1.ManagedClusterSetBinding{}
	err = c.client.Patch(pt).
		Namespace(c.ns).
		Resource("managedclustersetbindings").
		Name(name).
		SubResource(subresources...).
		VersionedParams(&opts, scheme.ParameterCodec).
		Body(data).
		Do(ctx).
		Into(result)
	return
}
