package servicefabric

// Copyright (c) Microsoft and contributors.  All rights reserved.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
// http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//
// See the License for the specific language governing permissions and
// limitations under the License.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"context"
	"github.com/Azure/go-autorest/autorest"
	"github.com/Azure/go-autorest/autorest/azure"
	"net/http"
)

// ApplicationHealthsClient is the client for the ApplicationHealths methods of the Servicefabric service.
type ApplicationHealthsClient struct {
	BaseClient
}

// NewApplicationHealthsClient creates an instance of the ApplicationHealthsClient client.
func NewApplicationHealthsClient(timeout *int32) ApplicationHealthsClient {
	return NewApplicationHealthsClientWithBaseURI(DefaultBaseURI, timeout)
}

// NewApplicationHealthsClientWithBaseURI creates an instance of the ApplicationHealthsClient client.
func NewApplicationHealthsClientWithBaseURI(baseURI string, timeout *int32) ApplicationHealthsClient {
	return ApplicationHealthsClient{NewWithBaseURI(baseURI, timeout)}
}

// Get get application healths
// Parameters:
// applicationName - the name of the application
// eventsHealthStateFilter - the filter of the events health state
// deployedApplicationsHealthStateFilter - the filter of the deployed application health state
func (client ApplicationHealthsClient) Get(ctx context.Context, applicationName string, eventsHealthStateFilter string, deployedApplicationsHealthStateFilter string) (result ApplicationHealth, err error) {
	req, err := client.GetPreparer(ctx, applicationName, eventsHealthStateFilter, deployedApplicationsHealthStateFilter)
	if err != nil {
		err = autorest.NewErrorWithError(err, "servicefabric.ApplicationHealthsClient", "Get", nil, "Failure preparing request")
		return
	}

	resp, err := client.GetSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "servicefabric.ApplicationHealthsClient", "Get", resp, "Failure sending request")
		return
	}

	result, err = client.GetResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "servicefabric.ApplicationHealthsClient", "Get", resp, "Failure responding to request")
	}

	return
}

// GetPreparer prepares the Get request.
func (client ApplicationHealthsClient) GetPreparer(ctx context.Context, applicationName string, eventsHealthStateFilter string, deployedApplicationsHealthStateFilter string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"applicationName": applicationName,
	}

	const APIVersion = "1.0.0"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}
	if len(eventsHealthStateFilter) > 0 {
		queryParameters["EventsHealthStateFilter"] = autorest.Encode("query", eventsHealthStateFilter)
	}
	if len(deployedApplicationsHealthStateFilter) > 0 {
		queryParameters["DeployedApplicationsHealthStateFilter"] = autorest.Encode("query", deployedApplicationsHealthStateFilter)
	}
	if client.Timeout != nil {
		queryParameters["timeout"] = autorest.Encode("query", *client.Timeout)
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/Applications/{applicationName}/$/GetHealth", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// GetSender sends the Get request. The method will close the
// http.Response Body if it receives an error.
func (client ApplicationHealthsClient) GetSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req,
		autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
}

// GetResponder handles the response to the Get request. The method always
// closes the http.Response Body.
func (client ApplicationHealthsClient) GetResponder(resp *http.Response) (result ApplicationHealth, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// Send send application health
// Parameters:
// applicationName - the name of the application
// applicationHealthReport - the report of the application health
func (client ApplicationHealthsClient) Send(ctx context.Context, applicationName string, applicationHealthReport ApplicationHealthReport) (result String, err error) {
	req, err := client.SendPreparer(ctx, applicationName, applicationHealthReport)
	if err != nil {
		err = autorest.NewErrorWithError(err, "servicefabric.ApplicationHealthsClient", "Send", nil, "Failure preparing request")
		return
	}

	resp, err := client.SendSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "servicefabric.ApplicationHealthsClient", "Send", resp, "Failure sending request")
		return
	}

	result, err = client.SendResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "servicefabric.ApplicationHealthsClient", "Send", resp, "Failure responding to request")
	}

	return
}

// SendPreparer prepares the Send request.
func (client ApplicationHealthsClient) SendPreparer(ctx context.Context, applicationName string, applicationHealthReport ApplicationHealthReport) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"applicationName": applicationName,
	}

	const APIVersion = "1.0.0"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}
	if client.Timeout != nil {
		queryParameters["timeout"] = autorest.Encode("query", *client.Timeout)
	}

	preparer := autorest.CreatePreparer(
		autorest.AsContentType("application/json; charset=utf-8"),
		autorest.AsPost(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/Applications/{applicationName}/$/ReportHealth", pathParameters),
		autorest.WithJSON(applicationHealthReport),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// SendSender sends the Send request. The method will close the
// http.Response Body if it receives an error.
func (client ApplicationHealthsClient) SendSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req,
		autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
}

// SendResponder handles the response to the Send request. The method always
// closes the http.Response Body.
func (client ApplicationHealthsClient) SendResponder(resp *http.Response) (result String, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result.Value),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}
