// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package cloudwatchevents

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type RemoveTargetsInput struct {
	_ struct{} `type:"structure"`

	// The name of the event bus associated with the rule.
	EventBusName *string `min:"1" type:"string"`

	// If this is a managed rule created by an AWS service on your behalf, you must
	// specify Force as True to remove targets. This parameter is ignored for rules
	// that aren't managed rules. You can check whether a rule is a managed rule
	// by using DescribeRule or ListRules and checking the ManagedBy field of the
	// response.
	Force *bool `type:"boolean"`

	// The IDs of the targets to remove from the rule.
	//
	// Ids is a required field
	Ids []string `min:"1" type:"list" required:"true"`

	// The name of the rule.
	//
	// Rule is a required field
	Rule *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s RemoveTargetsInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *RemoveTargetsInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "RemoveTargetsInput"}
	if s.EventBusName != nil && len(*s.EventBusName) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("EventBusName", 1))
	}

	if s.Ids == nil {
		invalidParams.Add(aws.NewErrParamRequired("Ids"))
	}
	if s.Ids != nil && len(s.Ids) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("Ids", 1))
	}

	if s.Rule == nil {
		invalidParams.Add(aws.NewErrParamRequired("Rule"))
	}
	if s.Rule != nil && len(*s.Rule) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("Rule", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type RemoveTargetsOutput struct {
	_ struct{} `type:"structure"`

	// The failed target entries.
	FailedEntries []RemoveTargetsResultEntry `type:"list"`

	// The number of failed entries.
	FailedEntryCount *int64 `type:"integer"`
}

// String returns the string representation
func (s RemoveTargetsOutput) String() string {
	return awsutil.Prettify(s)
}

const opRemoveTargets = "RemoveTargets"

// RemoveTargetsRequest returns a request value for making API operation for
// Amazon CloudWatch Events.
//
// Removes the specified targets from the specified rule. When the rule is triggered,
// those targets are no longer be invoked.
//
// When you remove a target, when the associated rule triggers, removed targets
// might continue to be invoked. Allow a short period of time for changes to
// take effect.
//
// This action can partially fail if too many requests are made at the same
// time. If that happens, FailedEntryCount is non-zero in the response and each
// entry in FailedEntries provides the ID of the failed target and the error
// code.
//
//    // Example sending a request using RemoveTargetsRequest.
//    req := client.RemoveTargetsRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/events-2015-10-07/RemoveTargets
func (c *Client) RemoveTargetsRequest(input *RemoveTargetsInput) RemoveTargetsRequest {
	op := &aws.Operation{
		Name:       opRemoveTargets,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &RemoveTargetsInput{}
	}

	req := c.newRequest(op, input, &RemoveTargetsOutput{})
	return RemoveTargetsRequest{Request: req, Input: input, Copy: c.RemoveTargetsRequest}
}

// RemoveTargetsRequest is the request type for the
// RemoveTargets API operation.
type RemoveTargetsRequest struct {
	*aws.Request
	Input *RemoveTargetsInput
	Copy  func(*RemoveTargetsInput) RemoveTargetsRequest
}

// Send marshals and sends the RemoveTargets API request.
func (r RemoveTargetsRequest) Send(ctx context.Context) (*RemoveTargetsResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &RemoveTargetsResponse{
		RemoveTargetsOutput: r.Request.Data.(*RemoveTargetsOutput),
		response:            &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// RemoveTargetsResponse is the response type for the
// RemoveTargets API operation.
type RemoveTargetsResponse struct {
	*RemoveTargetsOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// RemoveTargets request.
func (r *RemoveTargetsResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
