// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package ec2

import (
	"context"
	"time"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type ModifyInstanceEventStartTimeInput struct {
	_ struct{} `type:"structure"`

	// Checks whether you have the required permissions for the action, without
	// actually making the request, and provides an error response. If you have
	// the required permissions, the error response is DryRunOperation. Otherwise,
	// it is UnauthorizedOperation.
	DryRun *bool `type:"boolean"`

	// The ID of the event whose date and time you are modifying.
	//
	// InstanceEventId is a required field
	InstanceEventId *string `type:"string" required:"true"`

	// The ID of the instance with the scheduled event.
	//
	// InstanceId is a required field
	InstanceId *string `type:"string" required:"true"`

	// The new date and time when the event will take place.
	//
	// NotBefore is a required field
	NotBefore *time.Time `type:"timestamp" required:"true"`
}

// String returns the string representation
func (s ModifyInstanceEventStartTimeInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ModifyInstanceEventStartTimeInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "ModifyInstanceEventStartTimeInput"}

	if s.InstanceEventId == nil {
		invalidParams.Add(aws.NewErrParamRequired("InstanceEventId"))
	}

	if s.InstanceId == nil {
		invalidParams.Add(aws.NewErrParamRequired("InstanceId"))
	}

	if s.NotBefore == nil {
		invalidParams.Add(aws.NewErrParamRequired("NotBefore"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type ModifyInstanceEventStartTimeOutput struct {
	_ struct{} `type:"structure"`

	// Describes a scheduled event for an instance.
	Event *InstanceStatusEvent `locationName:"event" type:"structure"`
}

// String returns the string representation
func (s ModifyInstanceEventStartTimeOutput) String() string {
	return awsutil.Prettify(s)
}

const opModifyInstanceEventStartTime = "ModifyInstanceEventStartTime"

// ModifyInstanceEventStartTimeRequest returns a request value for making API operation for
// Amazon Elastic Compute Cloud.
//
// Modifies the start time for a scheduled Amazon EC2 instance event.
//
//    // Example sending a request using ModifyInstanceEventStartTimeRequest.
//    req := client.ModifyInstanceEventStartTimeRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/ModifyInstanceEventStartTime
func (c *Client) ModifyInstanceEventStartTimeRequest(input *ModifyInstanceEventStartTimeInput) ModifyInstanceEventStartTimeRequest {
	op := &aws.Operation{
		Name:       opModifyInstanceEventStartTime,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ModifyInstanceEventStartTimeInput{}
	}

	req := c.newRequest(op, input, &ModifyInstanceEventStartTimeOutput{})
	return ModifyInstanceEventStartTimeRequest{Request: req, Input: input, Copy: c.ModifyInstanceEventStartTimeRequest}
}

// ModifyInstanceEventStartTimeRequest is the request type for the
// ModifyInstanceEventStartTime API operation.
type ModifyInstanceEventStartTimeRequest struct {
	*aws.Request
	Input *ModifyInstanceEventStartTimeInput
	Copy  func(*ModifyInstanceEventStartTimeInput) ModifyInstanceEventStartTimeRequest
}

// Send marshals and sends the ModifyInstanceEventStartTime API request.
func (r ModifyInstanceEventStartTimeRequest) Send(ctx context.Context) (*ModifyInstanceEventStartTimeResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &ModifyInstanceEventStartTimeResponse{
		ModifyInstanceEventStartTimeOutput: r.Request.Data.(*ModifyInstanceEventStartTimeOutput),
		response:                           &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// ModifyInstanceEventStartTimeResponse is the response type for the
// ModifyInstanceEventStartTime API operation.
type ModifyInstanceEventStartTimeResponse struct {
	*ModifyInstanceEventStartTimeOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// ModifyInstanceEventStartTime request.
func (r *ModifyInstanceEventStartTimeResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
