// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package autoscalingplans

import (
	"fmt"
	"time"

	"github.com/aws/aws-sdk-go/aws"
	"github.com/aws/aws-sdk-go/aws/awsutil"
	"github.com/aws/aws-sdk-go/aws/request"
)

const opCreateScalingPlan = "CreateScalingPlan"

// CreateScalingPlanRequest generates a "aws/request.Request" representing the
// client's request for the CreateScalingPlan operation. The "output" return
// value will be populated with the request's response once the request completes
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateScalingPlan for more information on using the CreateScalingPlan
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateScalingPlanRequest method.
//    req, resp := client.CreateScalingPlanRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/autoscaling-plans-2018-01-06/CreateScalingPlan
func (c *AutoScalingPlans) CreateScalingPlanRequest(input *CreateScalingPlanInput) (req *request.Request, output *CreateScalingPlanOutput) {
	op := &request.Operation{
		Name:       opCreateScalingPlan,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateScalingPlanInput{}
	}

	output = &CreateScalingPlanOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateScalingPlan API operation for AWS Auto Scaling Plans.
//
// Creates a scaling plan.
//
// A scaling plan contains a set of instructions used to configure dynamic scaling
// for the scalable resources in your application. AWS Auto Scaling creates
// target tracking scaling policies based on the scaling instructions in your
// scaling plan.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Auto Scaling Plans's
// API operation CreateScalingPlan for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeValidationException "ValidationException"
//   An exception was thrown for a validation issue. Review the parameters provided.
//
//   * ErrCodeLimitExceededException "LimitExceededException"
//   Your account exceeded a limit. This exception is thrown when a per-account
//   resource limit is exceeded.
//
//   * ErrCodeConcurrentUpdateException "ConcurrentUpdateException"
//   Concurrent updates caused an exception, for example, if you request an update
//   to a scaling plan that already has a pending update.
//
//   * ErrCodeInternalServiceException "InternalServiceException"
//   The service encountered an internal error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/autoscaling-plans-2018-01-06/CreateScalingPlan
func (c *AutoScalingPlans) CreateScalingPlan(input *CreateScalingPlanInput) (*CreateScalingPlanOutput, error) {
	req, out := c.CreateScalingPlanRequest(input)
	return out, req.Send()
}

// CreateScalingPlanWithContext is the same as CreateScalingPlan with the addition of
// the ability to pass a context and additional request options.
//
// See CreateScalingPlan for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *AutoScalingPlans) CreateScalingPlanWithContext(ctx aws.Context, input *CreateScalingPlanInput, opts ...request.Option) (*CreateScalingPlanOutput, error) {
	req, out := c.CreateScalingPlanRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteScalingPlan = "DeleteScalingPlan"

// DeleteScalingPlanRequest generates a "aws/request.Request" representing the
// client's request for the DeleteScalingPlan operation. The "output" return
// value will be populated with the request's response once the request completes
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteScalingPlan for more information on using the DeleteScalingPlan
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteScalingPlanRequest method.
//    req, resp := client.DeleteScalingPlanRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/autoscaling-plans-2018-01-06/DeleteScalingPlan
func (c *AutoScalingPlans) DeleteScalingPlanRequest(input *DeleteScalingPlanInput) (req *request.Request, output *DeleteScalingPlanOutput) {
	op := &request.Operation{
		Name:       opDeleteScalingPlan,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteScalingPlanInput{}
	}

	output = &DeleteScalingPlanOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteScalingPlan API operation for AWS Auto Scaling Plans.
//
// Deletes the specified scaling plan.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Auto Scaling Plans's
// API operation DeleteScalingPlan for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeValidationException "ValidationException"
//   An exception was thrown for a validation issue. Review the parameters provided.
//
//   * ErrCodeObjectNotFoundException "ObjectNotFoundException"
//   The specified object could not be found.
//
//   * ErrCodeConcurrentUpdateException "ConcurrentUpdateException"
//   Concurrent updates caused an exception, for example, if you request an update
//   to a scaling plan that already has a pending update.
//
//   * ErrCodeInternalServiceException "InternalServiceException"
//   The service encountered an internal error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/autoscaling-plans-2018-01-06/DeleteScalingPlan
func (c *AutoScalingPlans) DeleteScalingPlan(input *DeleteScalingPlanInput) (*DeleteScalingPlanOutput, error) {
	req, out := c.DeleteScalingPlanRequest(input)
	return out, req.Send()
}

// DeleteScalingPlanWithContext is the same as DeleteScalingPlan with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteScalingPlan for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *AutoScalingPlans) DeleteScalingPlanWithContext(ctx aws.Context, input *DeleteScalingPlanInput, opts ...request.Option) (*DeleteScalingPlanOutput, error) {
	req, out := c.DeleteScalingPlanRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeScalingPlanResources = "DescribeScalingPlanResources"

// DescribeScalingPlanResourcesRequest generates a "aws/request.Request" representing the
// client's request for the DescribeScalingPlanResources operation. The "output" return
// value will be populated with the request's response once the request completes
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeScalingPlanResources for more information on using the DescribeScalingPlanResources
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeScalingPlanResourcesRequest method.
//    req, resp := client.DescribeScalingPlanResourcesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/autoscaling-plans-2018-01-06/DescribeScalingPlanResources
func (c *AutoScalingPlans) DescribeScalingPlanResourcesRequest(input *DescribeScalingPlanResourcesInput) (req *request.Request, output *DescribeScalingPlanResourcesOutput) {
	op := &request.Operation{
		Name:       opDescribeScalingPlanResources,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeScalingPlanResourcesInput{}
	}

	output = &DescribeScalingPlanResourcesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeScalingPlanResources API operation for AWS Auto Scaling Plans.
//
// Describes the scalable resources in the specified scaling plan.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Auto Scaling Plans's
// API operation DescribeScalingPlanResources for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeValidationException "ValidationException"
//   An exception was thrown for a validation issue. Review the parameters provided.
//
//   * ErrCodeInvalidNextTokenException "InvalidNextTokenException"
//   The token provided is not valid.
//
//   * ErrCodeConcurrentUpdateException "ConcurrentUpdateException"
//   Concurrent updates caused an exception, for example, if you request an update
//   to a scaling plan that already has a pending update.
//
//   * ErrCodeInternalServiceException "InternalServiceException"
//   The service encountered an internal error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/autoscaling-plans-2018-01-06/DescribeScalingPlanResources
func (c *AutoScalingPlans) DescribeScalingPlanResources(input *DescribeScalingPlanResourcesInput) (*DescribeScalingPlanResourcesOutput, error) {
	req, out := c.DescribeScalingPlanResourcesRequest(input)
	return out, req.Send()
}

// DescribeScalingPlanResourcesWithContext is the same as DescribeScalingPlanResources with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeScalingPlanResources for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *AutoScalingPlans) DescribeScalingPlanResourcesWithContext(ctx aws.Context, input *DescribeScalingPlanResourcesInput, opts ...request.Option) (*DescribeScalingPlanResourcesOutput, error) {
	req, out := c.DescribeScalingPlanResourcesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeScalingPlans = "DescribeScalingPlans"

// DescribeScalingPlansRequest generates a "aws/request.Request" representing the
// client's request for the DescribeScalingPlans operation. The "output" return
// value will be populated with the request's response once the request completes
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeScalingPlans for more information on using the DescribeScalingPlans
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeScalingPlansRequest method.
//    req, resp := client.DescribeScalingPlansRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/autoscaling-plans-2018-01-06/DescribeScalingPlans
func (c *AutoScalingPlans) DescribeScalingPlansRequest(input *DescribeScalingPlansInput) (req *request.Request, output *DescribeScalingPlansOutput) {
	op := &request.Operation{
		Name:       opDescribeScalingPlans,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeScalingPlansInput{}
	}

	output = &DescribeScalingPlansOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeScalingPlans API operation for AWS Auto Scaling Plans.
//
// Describes the specified scaling plans or all of your scaling plans.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Auto Scaling Plans's
// API operation DescribeScalingPlans for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeValidationException "ValidationException"
//   An exception was thrown for a validation issue. Review the parameters provided.
//
//   * ErrCodeInvalidNextTokenException "InvalidNextTokenException"
//   The token provided is not valid.
//
//   * ErrCodeConcurrentUpdateException "ConcurrentUpdateException"
//   Concurrent updates caused an exception, for example, if you request an update
//   to a scaling plan that already has a pending update.
//
//   * ErrCodeInternalServiceException "InternalServiceException"
//   The service encountered an internal error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/autoscaling-plans-2018-01-06/DescribeScalingPlans
func (c *AutoScalingPlans) DescribeScalingPlans(input *DescribeScalingPlansInput) (*DescribeScalingPlansOutput, error) {
	req, out := c.DescribeScalingPlansRequest(input)
	return out, req.Send()
}

// DescribeScalingPlansWithContext is the same as DescribeScalingPlans with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeScalingPlans for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *AutoScalingPlans) DescribeScalingPlansWithContext(ctx aws.Context, input *DescribeScalingPlansInput, opts ...request.Option) (*DescribeScalingPlansOutput, error) {
	req, out := c.DescribeScalingPlansRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateScalingPlan = "UpdateScalingPlan"

// UpdateScalingPlanRequest generates a "aws/request.Request" representing the
// client's request for the UpdateScalingPlan operation. The "output" return
// value will be populated with the request's response once the request completes
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateScalingPlan for more information on using the UpdateScalingPlan
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdateScalingPlanRequest method.
//    req, resp := client.UpdateScalingPlanRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/autoscaling-plans-2018-01-06/UpdateScalingPlan
func (c *AutoScalingPlans) UpdateScalingPlanRequest(input *UpdateScalingPlanInput) (req *request.Request, output *UpdateScalingPlanOutput) {
	op := &request.Operation{
		Name:       opUpdateScalingPlan,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdateScalingPlanInput{}
	}

	output = &UpdateScalingPlanOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateScalingPlan API operation for AWS Auto Scaling Plans.
//
// Updates the scaling plan for the specified scaling plan.
//
// You cannot update a scaling plan if it is in the process of being created,
// updated, or deleted.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Auto Scaling Plans's
// API operation UpdateScalingPlan for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeValidationException "ValidationException"
//   An exception was thrown for a validation issue. Review the parameters provided.
//
//   * ErrCodeConcurrentUpdateException "ConcurrentUpdateException"
//   Concurrent updates caused an exception, for example, if you request an update
//   to a scaling plan that already has a pending update.
//
//   * ErrCodeInternalServiceException "InternalServiceException"
//   The service encountered an internal error.
//
//   * ErrCodeObjectNotFoundException "ObjectNotFoundException"
//   The specified object could not be found.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/autoscaling-plans-2018-01-06/UpdateScalingPlan
func (c *AutoScalingPlans) UpdateScalingPlan(input *UpdateScalingPlanInput) (*UpdateScalingPlanOutput, error) {
	req, out := c.UpdateScalingPlanRequest(input)
	return out, req.Send()
}

// UpdateScalingPlanWithContext is the same as UpdateScalingPlan with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateScalingPlan for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *AutoScalingPlans) UpdateScalingPlanWithContext(ctx aws.Context, input *UpdateScalingPlanInput, opts ...request.Option) (*UpdateScalingPlanOutput, error) {
	req, out := c.UpdateScalingPlanRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// Represents an application source.
type ApplicationSource struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of a CloudFormation stack.
	CloudFormationStackARN *string `type:"string"`

	// A set of tags (up to 50).
	TagFilters []*TagFilter `type:"list"`
}

// String returns the string representation
func (s ApplicationSource) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ApplicationSource) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ApplicationSource) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ApplicationSource"}
	if s.TagFilters != nil {
		for i, v := range s.TagFilters {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "TagFilters", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCloudFormationStackARN sets the CloudFormationStackARN field's value.
func (s *ApplicationSource) SetCloudFormationStackARN(v string) *ApplicationSource {
	s.CloudFormationStackARN = &v
	return s
}

// SetTagFilters sets the TagFilters field's value.
func (s *ApplicationSource) SetTagFilters(v []*TagFilter) *ApplicationSource {
	s.TagFilters = v
	return s
}

type CreateScalingPlanInput struct {
	_ struct{} `type:"structure"`

	// A CloudFormation stack or set of tags. You can create one scaling plan per
	// application source.
	//
	// ApplicationSource is a required field
	ApplicationSource *ApplicationSource `type:"structure" required:"true"`

	// The scaling instructions.
	//
	// ScalingInstructions is a required field
	ScalingInstructions []*ScalingInstruction `type:"list" required:"true"`

	// The name of the scaling plan. Names cannot contain vertical bars, colons,
	// or forward slashes.
	//
	// ScalingPlanName is a required field
	ScalingPlanName *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s CreateScalingPlanInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateScalingPlanInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateScalingPlanInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateScalingPlanInput"}
	if s.ApplicationSource == nil {
		invalidParams.Add(request.NewErrParamRequired("ApplicationSource"))
	}
	if s.ScalingInstructions == nil {
		invalidParams.Add(request.NewErrParamRequired("ScalingInstructions"))
	}
	if s.ScalingPlanName == nil {
		invalidParams.Add(request.NewErrParamRequired("ScalingPlanName"))
	}
	if s.ScalingPlanName != nil && len(*s.ScalingPlanName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ScalingPlanName", 1))
	}
	if s.ApplicationSource != nil {
		if err := s.ApplicationSource.Validate(); err != nil {
			invalidParams.AddNested("ApplicationSource", err.(request.ErrInvalidParams))
		}
	}
	if s.ScalingInstructions != nil {
		for i, v := range s.ScalingInstructions {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "ScalingInstructions", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetApplicationSource sets the ApplicationSource field's value.
func (s *CreateScalingPlanInput) SetApplicationSource(v *ApplicationSource) *CreateScalingPlanInput {
	s.ApplicationSource = v
	return s
}

// SetScalingInstructions sets the ScalingInstructions field's value.
func (s *CreateScalingPlanInput) SetScalingInstructions(v []*ScalingInstruction) *CreateScalingPlanInput {
	s.ScalingInstructions = v
	return s
}

// SetScalingPlanName sets the ScalingPlanName field's value.
func (s *CreateScalingPlanInput) SetScalingPlanName(v string) *CreateScalingPlanInput {
	s.ScalingPlanName = &v
	return s
}

type CreateScalingPlanOutput struct {
	_ struct{} `type:"structure"`

	// The version of the scaling plan. This value is always 1.
	//
	// ScalingPlanVersion is a required field
	ScalingPlanVersion *int64 `type:"long" required:"true"`
}

// String returns the string representation
func (s CreateScalingPlanOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateScalingPlanOutput) GoString() string {
	return s.String()
}

// SetScalingPlanVersion sets the ScalingPlanVersion field's value.
func (s *CreateScalingPlanOutput) SetScalingPlanVersion(v int64) *CreateScalingPlanOutput {
	s.ScalingPlanVersion = &v
	return s
}

// Represents a customized metric for a target tracking policy.
type CustomizedScalingMetricSpecification struct {
	_ struct{} `type:"structure"`

	// The dimensions of the metric.
	Dimensions []*MetricDimension `type:"list"`

	// The name of the metric.
	//
	// MetricName is a required field
	MetricName *string `type:"string" required:"true"`

	// The namespace of the metric.
	//
	// Namespace is a required field
	Namespace *string `type:"string" required:"true"`

	// The statistic of the metric.
	//
	// Statistic is a required field
	Statistic *string `type:"string" required:"true" enum:"MetricStatistic"`

	// The unit of the metric.
	Unit *string `type:"string"`
}

// String returns the string representation
func (s CustomizedScalingMetricSpecification) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CustomizedScalingMetricSpecification) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CustomizedScalingMetricSpecification) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CustomizedScalingMetricSpecification"}
	if s.MetricName == nil {
		invalidParams.Add(request.NewErrParamRequired("MetricName"))
	}
	if s.Namespace == nil {
		invalidParams.Add(request.NewErrParamRequired("Namespace"))
	}
	if s.Statistic == nil {
		invalidParams.Add(request.NewErrParamRequired("Statistic"))
	}
	if s.Dimensions != nil {
		for i, v := range s.Dimensions {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Dimensions", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDimensions sets the Dimensions field's value.
func (s *CustomizedScalingMetricSpecification) SetDimensions(v []*MetricDimension) *CustomizedScalingMetricSpecification {
	s.Dimensions = v
	return s
}

// SetMetricName sets the MetricName field's value.
func (s *CustomizedScalingMetricSpecification) SetMetricName(v string) *CustomizedScalingMetricSpecification {
	s.MetricName = &v
	return s
}

// SetNamespace sets the Namespace field's value.
func (s *CustomizedScalingMetricSpecification) SetNamespace(v string) *CustomizedScalingMetricSpecification {
	s.Namespace = &v
	return s
}

// SetStatistic sets the Statistic field's value.
func (s *CustomizedScalingMetricSpecification) SetStatistic(v string) *CustomizedScalingMetricSpecification {
	s.Statistic = &v
	return s
}

// SetUnit sets the Unit field's value.
func (s *CustomizedScalingMetricSpecification) SetUnit(v string) *CustomizedScalingMetricSpecification {
	s.Unit = &v
	return s
}

type DeleteScalingPlanInput struct {
	_ struct{} `type:"structure"`

	// The name of the scaling plan.
	//
	// ScalingPlanName is a required field
	ScalingPlanName *string `min:"1" type:"string" required:"true"`

	// The version of the scaling plan.
	//
	// ScalingPlanVersion is a required field
	ScalingPlanVersion *int64 `type:"long" required:"true"`
}

// String returns the string representation
func (s DeleteScalingPlanInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteScalingPlanInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteScalingPlanInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteScalingPlanInput"}
	if s.ScalingPlanName == nil {
		invalidParams.Add(request.NewErrParamRequired("ScalingPlanName"))
	}
	if s.ScalingPlanName != nil && len(*s.ScalingPlanName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ScalingPlanName", 1))
	}
	if s.ScalingPlanVersion == nil {
		invalidParams.Add(request.NewErrParamRequired("ScalingPlanVersion"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetScalingPlanName sets the ScalingPlanName field's value.
func (s *DeleteScalingPlanInput) SetScalingPlanName(v string) *DeleteScalingPlanInput {
	s.ScalingPlanName = &v
	return s
}

// SetScalingPlanVersion sets the ScalingPlanVersion field's value.
func (s *DeleteScalingPlanInput) SetScalingPlanVersion(v int64) *DeleteScalingPlanInput {
	s.ScalingPlanVersion = &v
	return s
}

type DeleteScalingPlanOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteScalingPlanOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteScalingPlanOutput) GoString() string {
	return s.String()
}

type DescribeScalingPlanResourcesInput struct {
	_ struct{} `type:"structure"`

	// The maximum number of scalable resources to return. This value can be between
	// 1 and 50. The default value is 50.
	MaxResults *int64 `type:"integer"`

	// The token for the next set of results.
	NextToken *string `type:"string"`

	// The name of the scaling plan.
	//
	// ScalingPlanName is a required field
	ScalingPlanName *string `min:"1" type:"string" required:"true"`

	// The version of the scaling plan.
	//
	// ScalingPlanVersion is a required field
	ScalingPlanVersion *int64 `type:"long" required:"true"`
}

// String returns the string representation
func (s DescribeScalingPlanResourcesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeScalingPlanResourcesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeScalingPlanResourcesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeScalingPlanResourcesInput"}
	if s.ScalingPlanName == nil {
		invalidParams.Add(request.NewErrParamRequired("ScalingPlanName"))
	}
	if s.ScalingPlanName != nil && len(*s.ScalingPlanName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ScalingPlanName", 1))
	}
	if s.ScalingPlanVersion == nil {
		invalidParams.Add(request.NewErrParamRequired("ScalingPlanVersion"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxResults sets the MaxResults field's value.
func (s *DescribeScalingPlanResourcesInput) SetMaxResults(v int64) *DescribeScalingPlanResourcesInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *DescribeScalingPlanResourcesInput) SetNextToken(v string) *DescribeScalingPlanResourcesInput {
	s.NextToken = &v
	return s
}

// SetScalingPlanName sets the ScalingPlanName field's value.
func (s *DescribeScalingPlanResourcesInput) SetScalingPlanName(v string) *DescribeScalingPlanResourcesInput {
	s.ScalingPlanName = &v
	return s
}

// SetScalingPlanVersion sets the ScalingPlanVersion field's value.
func (s *DescribeScalingPlanResourcesInput) SetScalingPlanVersion(v int64) *DescribeScalingPlanResourcesInput {
	s.ScalingPlanVersion = &v
	return s
}

type DescribeScalingPlanResourcesOutput struct {
	_ struct{} `type:"structure"`

	// The token required to get the next set of results. This value is null if
	// there are no more results to return.
	NextToken *string `type:"string"`

	// Information about the scalable resources.
	ScalingPlanResources []*ScalingPlanResource `type:"list"`
}

// String returns the string representation
func (s DescribeScalingPlanResourcesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeScalingPlanResourcesOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *DescribeScalingPlanResourcesOutput) SetNextToken(v string) *DescribeScalingPlanResourcesOutput {
	s.NextToken = &v
	return s
}

// SetScalingPlanResources sets the ScalingPlanResources field's value.
func (s *DescribeScalingPlanResourcesOutput) SetScalingPlanResources(v []*ScalingPlanResource) *DescribeScalingPlanResourcesOutput {
	s.ScalingPlanResources = v
	return s
}

type DescribeScalingPlansInput struct {
	_ struct{} `type:"structure"`

	// The sources for the applications (up to 10). If you specify scaling plan
	// names, you cannot specify application sources.
	ApplicationSources []*ApplicationSource `type:"list"`

	// The maximum number of scalable resources to return. This value can be between
	// 1 and 50. The default value is 50.
	MaxResults *int64 `type:"integer"`

	// The token for the next set of results.
	NextToken *string `type:"string"`

	// The names of the scaling plans (up to 10). If you specify application sources,
	// you cannot specify scaling plan names.
	ScalingPlanNames []*string `type:"list"`

	// The version of the scaling plan. If you specify a scaling plan version, you
	// must also specify a scaling plan name.
	ScalingPlanVersion *int64 `type:"long"`
}

// String returns the string representation
func (s DescribeScalingPlansInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeScalingPlansInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeScalingPlansInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeScalingPlansInput"}
	if s.ApplicationSources != nil {
		for i, v := range s.ApplicationSources {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "ApplicationSources", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetApplicationSources sets the ApplicationSources field's value.
func (s *DescribeScalingPlansInput) SetApplicationSources(v []*ApplicationSource) *DescribeScalingPlansInput {
	s.ApplicationSources = v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *DescribeScalingPlansInput) SetMaxResults(v int64) *DescribeScalingPlansInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *DescribeScalingPlansInput) SetNextToken(v string) *DescribeScalingPlansInput {
	s.NextToken = &v
	return s
}

// SetScalingPlanNames sets the ScalingPlanNames field's value.
func (s *DescribeScalingPlansInput) SetScalingPlanNames(v []*string) *DescribeScalingPlansInput {
	s.ScalingPlanNames = v
	return s
}

// SetScalingPlanVersion sets the ScalingPlanVersion field's value.
func (s *DescribeScalingPlansInput) SetScalingPlanVersion(v int64) *DescribeScalingPlansInput {
	s.ScalingPlanVersion = &v
	return s
}

type DescribeScalingPlansOutput struct {
	_ struct{} `type:"structure"`

	// The token required to get the next set of results. This value is null if
	// there are no more results to return.
	NextToken *string `type:"string"`

	// Information about the scaling plans.
	ScalingPlans []*ScalingPlan `type:"list"`
}

// String returns the string representation
func (s DescribeScalingPlansOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeScalingPlansOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *DescribeScalingPlansOutput) SetNextToken(v string) *DescribeScalingPlansOutput {
	s.NextToken = &v
	return s
}

// SetScalingPlans sets the ScalingPlans field's value.
func (s *DescribeScalingPlansOutput) SetScalingPlans(v []*ScalingPlan) *DescribeScalingPlansOutput {
	s.ScalingPlans = v
	return s
}

// Represents a dimension for a customized metric.
type MetricDimension struct {
	_ struct{} `type:"structure"`

	// The name of the dimension.
	//
	// Name is a required field
	Name *string `type:"string" required:"true"`

	// The value of the dimension.
	//
	// Value is a required field
	Value *string `type:"string" required:"true"`
}

// String returns the string representation
func (s MetricDimension) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s MetricDimension) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *MetricDimension) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "MetricDimension"}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Value == nil {
		invalidParams.Add(request.NewErrParamRequired("Value"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetName sets the Name field's value.
func (s *MetricDimension) SetName(v string) *MetricDimension {
	s.Name = &v
	return s
}

// SetValue sets the Value field's value.
func (s *MetricDimension) SetValue(v string) *MetricDimension {
	s.Value = &v
	return s
}

// Represents a predefined metric for a target tracking policy.
type PredefinedScalingMetricSpecification struct {
	_ struct{} `type:"structure"`

	// The metric type. The ALBRequestCountPerTarget metric type applies only to
	// Auto Scaling groups, Sport Fleet requests, and ECS services.
	//
	// PredefinedScalingMetricType is a required field
	PredefinedScalingMetricType *string `type:"string" required:"true" enum:"ScalingMetricType"`

	// Identifies the resource associated with the metric type. You can't specify
	// a resource label unless the metric type is ALBRequestCountPerTarget and there
	// is a target group for an Application Load Balancer attached to the Auto Scaling
	// group, Spot Fleet request, or ECS service.
	//
	// The format is app/<load-balancer-name>/<load-balancer-id>/targetgroup/<target-group-name>/<target-group-id>,
	// where:
	//
	//    * app/<load-balancer-name>/<load-balancer-id> is the final portion of
	//    the load balancer ARN
	//
	//    * targetgroup/<target-group-name>/<target-group-id> is the final portion
	//    of the target group ARN.
	ResourceLabel *string `min:"1" type:"string"`
}

// String returns the string representation
func (s PredefinedScalingMetricSpecification) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PredefinedScalingMetricSpecification) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *PredefinedScalingMetricSpecification) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "PredefinedScalingMetricSpecification"}
	if s.PredefinedScalingMetricType == nil {
		invalidParams.Add(request.NewErrParamRequired("PredefinedScalingMetricType"))
	}
	if s.ResourceLabel != nil && len(*s.ResourceLabel) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceLabel", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetPredefinedScalingMetricType sets the PredefinedScalingMetricType field's value.
func (s *PredefinedScalingMetricSpecification) SetPredefinedScalingMetricType(v string) *PredefinedScalingMetricSpecification {
	s.PredefinedScalingMetricType = &v
	return s
}

// SetResourceLabel sets the ResourceLabel field's value.
func (s *PredefinedScalingMetricSpecification) SetResourceLabel(v string) *PredefinedScalingMetricSpecification {
	s.ResourceLabel = &v
	return s
}

// Specifies the scaling configuration for a scalable resource.
type ScalingInstruction struct {
	_ struct{} `type:"structure"`

	// The maximum value to scale to in response to a scale out event.
	//
	// MaxCapacity is a required field
	MaxCapacity *int64 `type:"integer" required:"true"`

	// The minimum value to scale to in response to a scale in event.
	//
	// MinCapacity is a required field
	MinCapacity *int64 `type:"integer" required:"true"`

	// The ID of the resource. This string consists of the resource type and unique
	// identifier.
	//
	//    * Auto Scaling group - The resource type is autoScalingGroup and the unique
	//    identifier is the name of the Auto Scaling group. Example: autoScalingGroup/my-asg.
	//
	//    * ECS service - The resource type is service and the unique identifier
	//    is the cluster name and service name. Example: service/default/sample-webapp.
	//
	//    * Spot fleet request - The resource type is spot-fleet-request and the
	//    unique identifier is the Spot fleet request ID. Example: spot-fleet-request/sfr-73fbd2ce-aa30-494c-8788-1cee4EXAMPLE.
	//
	//    * DynamoDB table - The resource type is table and the unique identifier
	//    is the resource ID. Example: table/my-table.
	//
	//    * DynamoDB global secondary index - The resource type is index and the
	//    unique identifier is the resource ID. Example: table/my-table/index/my-table-index.
	//
	//    * Aurora DB cluster - The resource type is cluster and the unique identifier
	//    is the cluster name. Example: cluster:my-db-cluster.
	//
	// ResourceId is a required field
	ResourceId *string `min:"1" type:"string" required:"true"`

	// The scalable dimension associated with the resource.
	//
	//    * autoscaling:autoScalingGroup:DesiredCapacity - The desired capacity
	//    of an Auto Scaling group.
	//
	//    * ecs:service:DesiredCount - The desired task count of an ECS service.
	//
	//    * ec2:spot-fleet-request:TargetCapacity - The target capacity of a Spot
	//    fleet request.
	//
	//    * dynamodb:table:ReadCapacityUnits - The provisioned read capacity for
	//    a DynamoDB table.
	//
	//    * dynamodb:table:WriteCapacityUnits - The provisioned write capacity for
	//    a DynamoDB table.
	//
	//    * dynamodb:index:ReadCapacityUnits - The provisioned read capacity for
	//    a DynamoDB global secondary index.
	//
	//    * dynamodb:index:WriteCapacityUnits - The provisioned write capacity for
	//    a DynamoDB global secondary index.
	//
	//    * rds:cluster:ReadReplicaCount - The count of Aurora Replicas in an Aurora
	//    DB cluster. Available for Aurora MySQL-compatible edition.
	//
	// ScalableDimension is a required field
	ScalableDimension *string `type:"string" required:"true" enum:"ScalableDimension"`

	// The namespace of the AWS service.
	//
	// ServiceNamespace is a required field
	ServiceNamespace *string `type:"string" required:"true" enum:"ServiceNamespace"`

	// The target tracking scaling policies (up to 10).
	//
	// TargetTrackingConfigurations is a required field
	TargetTrackingConfigurations []*TargetTrackingConfiguration `type:"list" required:"true"`
}

// String returns the string representation
func (s ScalingInstruction) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ScalingInstruction) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ScalingInstruction) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ScalingInstruction"}
	if s.MaxCapacity == nil {
		invalidParams.Add(request.NewErrParamRequired("MaxCapacity"))
	}
	if s.MinCapacity == nil {
		invalidParams.Add(request.NewErrParamRequired("MinCapacity"))
	}
	if s.ResourceId == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceId"))
	}
	if s.ResourceId != nil && len(*s.ResourceId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceId", 1))
	}
	if s.ScalableDimension == nil {
		invalidParams.Add(request.NewErrParamRequired("ScalableDimension"))
	}
	if s.ServiceNamespace == nil {
		invalidParams.Add(request.NewErrParamRequired("ServiceNamespace"))
	}
	if s.TargetTrackingConfigurations == nil {
		invalidParams.Add(request.NewErrParamRequired("TargetTrackingConfigurations"))
	}
	if s.TargetTrackingConfigurations != nil {
		for i, v := range s.TargetTrackingConfigurations {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "TargetTrackingConfigurations", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxCapacity sets the MaxCapacity field's value.
func (s *ScalingInstruction) SetMaxCapacity(v int64) *ScalingInstruction {
	s.MaxCapacity = &v
	return s
}

// SetMinCapacity sets the MinCapacity field's value.
func (s *ScalingInstruction) SetMinCapacity(v int64) *ScalingInstruction {
	s.MinCapacity = &v
	return s
}

// SetResourceId sets the ResourceId field's value.
func (s *ScalingInstruction) SetResourceId(v string) *ScalingInstruction {
	s.ResourceId = &v
	return s
}

// SetScalableDimension sets the ScalableDimension field's value.
func (s *ScalingInstruction) SetScalableDimension(v string) *ScalingInstruction {
	s.ScalableDimension = &v
	return s
}

// SetServiceNamespace sets the ServiceNamespace field's value.
func (s *ScalingInstruction) SetServiceNamespace(v string) *ScalingInstruction {
	s.ServiceNamespace = &v
	return s
}

// SetTargetTrackingConfigurations sets the TargetTrackingConfigurations field's value.
func (s *ScalingInstruction) SetTargetTrackingConfigurations(v []*TargetTrackingConfiguration) *ScalingInstruction {
	s.TargetTrackingConfigurations = v
	return s
}

// Represents a scaling plan.
type ScalingPlan struct {
	_ struct{} `type:"structure"`

	// The application source.
	//
	// ApplicationSource is a required field
	ApplicationSource *ApplicationSource `type:"structure" required:"true"`

	// The Unix timestamp when the scaling plan was created.
	CreationTime *time.Time `type:"timestamp"`

	// The scaling instructions.
	//
	// ScalingInstructions is a required field
	ScalingInstructions []*ScalingInstruction `type:"list" required:"true"`

	// The name of the scaling plan.
	//
	// ScalingPlanName is a required field
	ScalingPlanName *string `min:"1" type:"string" required:"true"`

	// The version of the scaling plan.
	//
	// ScalingPlanVersion is a required field
	ScalingPlanVersion *int64 `type:"long" required:"true"`

	// The status of the scaling plan.
	//
	//    * Active - The scaling plan is active.
	//
	//    * ActiveWithProblems - The scaling plan is active, but the scaling configuration
	//    for one or more resources could not be applied.
	//
	//    * CreationInProgress - The scaling plan is being created.
	//
	//    * CreationFailed - The scaling plan could not be created.
	//
	//    * DeletionInProgress - The scaling plan is being deleted.
	//
	//    * DeletionFailed - The scaling plan could not be deleted.
	//
	// StatusCode is a required field
	StatusCode *string `type:"string" required:"true" enum:"ScalingPlanStatusCode"`

	// A simple message about the current status of the scaling plan.
	StatusMessage *string `type:"string"`

	// The Unix timestamp when the scaling plan entered the current status.
	StatusStartTime *time.Time `type:"timestamp"`
}

// String returns the string representation
func (s ScalingPlan) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ScalingPlan) GoString() string {
	return s.String()
}

// SetApplicationSource sets the ApplicationSource field's value.
func (s *ScalingPlan) SetApplicationSource(v *ApplicationSource) *ScalingPlan {
	s.ApplicationSource = v
	return s
}

// SetCreationTime sets the CreationTime field's value.
func (s *ScalingPlan) SetCreationTime(v time.Time) *ScalingPlan {
	s.CreationTime = &v
	return s
}

// SetScalingInstructions sets the ScalingInstructions field's value.
func (s *ScalingPlan) SetScalingInstructions(v []*ScalingInstruction) *ScalingPlan {
	s.ScalingInstructions = v
	return s
}

// SetScalingPlanName sets the ScalingPlanName field's value.
func (s *ScalingPlan) SetScalingPlanName(v string) *ScalingPlan {
	s.ScalingPlanName = &v
	return s
}

// SetScalingPlanVersion sets the ScalingPlanVersion field's value.
func (s *ScalingPlan) SetScalingPlanVersion(v int64) *ScalingPlan {
	s.ScalingPlanVersion = &v
	return s
}

// SetStatusCode sets the StatusCode field's value.
func (s *ScalingPlan) SetStatusCode(v string) *ScalingPlan {
	s.StatusCode = &v
	return s
}

// SetStatusMessage sets the StatusMessage field's value.
func (s *ScalingPlan) SetStatusMessage(v string) *ScalingPlan {
	s.StatusMessage = &v
	return s
}

// SetStatusStartTime sets the StatusStartTime field's value.
func (s *ScalingPlan) SetStatusStartTime(v time.Time) *ScalingPlan {
	s.StatusStartTime = &v
	return s
}

// Represents a scalable resource.
type ScalingPlanResource struct {
	_ struct{} `type:"structure"`

	// The ID of the resource. This string consists of the resource type and unique
	// identifier.
	//
	//    * Auto Scaling group - The resource type is autoScalingGroup and the unique
	//    identifier is the name of the Auto Scaling group. Example: autoScalingGroup/my-asg.
	//
	//    * ECS service - The resource type is service and the unique identifier
	//    is the cluster name and service name. Example: service/default/sample-webapp.
	//
	//    * Spot fleet request - The resource type is spot-fleet-request and the
	//    unique identifier is the Spot fleet request ID. Example: spot-fleet-request/sfr-73fbd2ce-aa30-494c-8788-1cee4EXAMPLE.
	//
	//    * DynamoDB table - The resource type is table and the unique identifier
	//    is the resource ID. Example: table/my-table.
	//
	//    * DynamoDB global secondary index - The resource type is index and the
	//    unique identifier is the resource ID. Example: table/my-table/index/my-table-index.
	//
	//    * Aurora DB cluster - The resource type is cluster and the unique identifier
	//    is the cluster name. Example: cluster:my-db-cluster.
	//
	// ResourceId is a required field
	ResourceId *string `min:"1" type:"string" required:"true"`

	// The scalable dimension for the resource.
	//
	//    * autoscaling:autoScalingGroup:DesiredCapacity - The desired capacity
	//    of an Auto Scaling group.
	//
	//    * ecs:service:DesiredCount - The desired task count of an ECS service.
	//
	//    * ec2:spot-fleet-request:TargetCapacity - The target capacity of a Spot
	//    fleet request.
	//
	//    * dynamodb:table:ReadCapacityUnits - The provisioned read capacity for
	//    a DynamoDB table.
	//
	//    * dynamodb:table:WriteCapacityUnits - The provisioned write capacity for
	//    a DynamoDB table.
	//
	//    * dynamodb:index:ReadCapacityUnits - The provisioned read capacity for
	//    a DynamoDB global secondary index.
	//
	//    * dynamodb:index:WriteCapacityUnits - The provisioned write capacity for
	//    a DynamoDB global secondary index.
	//
	//    * rds:cluster:ReadReplicaCount - The count of Aurora Replicas in an Aurora
	//    DB cluster. Available for Aurora MySQL-compatible edition.
	//
	// ScalableDimension is a required field
	ScalableDimension *string `type:"string" required:"true" enum:"ScalableDimension"`

	// The name of the scaling plan.
	//
	// ScalingPlanName is a required field
	ScalingPlanName *string `min:"1" type:"string" required:"true"`

	// The version of the scaling plan.
	//
	// ScalingPlanVersion is a required field
	ScalingPlanVersion *int64 `type:"long" required:"true"`

	// The scaling policies.
	ScalingPolicies []*ScalingPolicy `type:"list"`

	// The scaling status of the resource.
	//
	//    * Active - The scaling configuration is active.
	//
	//    * Inactive - The scaling configuration is not active because the scaling
	//    plan is being created or the scaling configuration could not be applied.
	//    Check the status message for more information.
	//
	//    * PartiallyActive - The scaling configuration is partially active because
	//    the scaling plan is being created or deleted or the scaling configuration
	//    could not be fully applied. Check the status message for more information.
	//
	// ScalingStatusCode is a required field
	ScalingStatusCode *string `type:"string" required:"true" enum:"ScalingStatusCode"`

	// A simple message about the current scaling status of the resource.
	ScalingStatusMessage *string `type:"string"`

	// The namespace of the AWS service.
	//
	// ServiceNamespace is a required field
	ServiceNamespace *string `type:"string" required:"true" enum:"ServiceNamespace"`
}

// String returns the string representation
func (s ScalingPlanResource) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ScalingPlanResource) GoString() string {
	return s.String()
}

// SetResourceId sets the ResourceId field's value.
func (s *ScalingPlanResource) SetResourceId(v string) *ScalingPlanResource {
	s.ResourceId = &v
	return s
}

// SetScalableDimension sets the ScalableDimension field's value.
func (s *ScalingPlanResource) SetScalableDimension(v string) *ScalingPlanResource {
	s.ScalableDimension = &v
	return s
}

// SetScalingPlanName sets the ScalingPlanName field's value.
func (s *ScalingPlanResource) SetScalingPlanName(v string) *ScalingPlanResource {
	s.ScalingPlanName = &v
	return s
}

// SetScalingPlanVersion sets the ScalingPlanVersion field's value.
func (s *ScalingPlanResource) SetScalingPlanVersion(v int64) *ScalingPlanResource {
	s.ScalingPlanVersion = &v
	return s
}

// SetScalingPolicies sets the ScalingPolicies field's value.
func (s *ScalingPlanResource) SetScalingPolicies(v []*ScalingPolicy) *ScalingPlanResource {
	s.ScalingPolicies = v
	return s
}

// SetScalingStatusCode sets the ScalingStatusCode field's value.
func (s *ScalingPlanResource) SetScalingStatusCode(v string) *ScalingPlanResource {
	s.ScalingStatusCode = &v
	return s
}

// SetScalingStatusMessage sets the ScalingStatusMessage field's value.
func (s *ScalingPlanResource) SetScalingStatusMessage(v string) *ScalingPlanResource {
	s.ScalingStatusMessage = &v
	return s
}

// SetServiceNamespace sets the ServiceNamespace field's value.
func (s *ScalingPlanResource) SetServiceNamespace(v string) *ScalingPlanResource {
	s.ServiceNamespace = &v
	return s
}

// Represents a scaling policy.
type ScalingPolicy struct {
	_ struct{} `type:"structure"`

	// The name of the scaling policy.
	//
	// PolicyName is a required field
	PolicyName *string `min:"1" type:"string" required:"true"`

	// The type of scaling policy.
	//
	// PolicyType is a required field
	PolicyType *string `type:"string" required:"true" enum:"PolicyType"`

	// The target tracking scaling policy.
	TargetTrackingConfiguration *TargetTrackingConfiguration `type:"structure"`
}

// String returns the string representation
func (s ScalingPolicy) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ScalingPolicy) GoString() string {
	return s.String()
}

// SetPolicyName sets the PolicyName field's value.
func (s *ScalingPolicy) SetPolicyName(v string) *ScalingPolicy {
	s.PolicyName = &v
	return s
}

// SetPolicyType sets the PolicyType field's value.
func (s *ScalingPolicy) SetPolicyType(v string) *ScalingPolicy {
	s.PolicyType = &v
	return s
}

// SetTargetTrackingConfiguration sets the TargetTrackingConfiguration field's value.
func (s *ScalingPolicy) SetTargetTrackingConfiguration(v *TargetTrackingConfiguration) *ScalingPolicy {
	s.TargetTrackingConfiguration = v
	return s
}

// Represents a tag.
type TagFilter struct {
	_ struct{} `type:"structure"`

	// The tag key.
	Key *string `min:"1" type:"string"`

	// The tag values (0 to 20).
	Values []*string `type:"list"`
}

// String returns the string representation
func (s TagFilter) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s TagFilter) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *TagFilter) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "TagFilter"}
	if s.Key != nil && len(*s.Key) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Key", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetKey sets the Key field's value.
func (s *TagFilter) SetKey(v string) *TagFilter {
	s.Key = &v
	return s
}

// SetValues sets the Values field's value.
func (s *TagFilter) SetValues(v []*string) *TagFilter {
	s.Values = v
	return s
}

// Represents a target tracking scaling policy.
type TargetTrackingConfiguration struct {
	_ struct{} `type:"structure"`

	// A customized metric.
	CustomizedScalingMetricSpecification *CustomizedScalingMetricSpecification `type:"structure"`

	// Indicates whether scale in by the target tracking policy is disabled. If
	// the value is true, scale in is disabled and the target tracking policy won't
	// remove capacity from the scalable resource. Otherwise, scale in is enabled
	// and the target tracking policy can remove capacity from the scalable resource.
	// The default value is false.
	DisableScaleIn *bool `type:"boolean"`

	// The estimated time, in seconds, until a newly launched instance can contribute
	// to the CloudWatch metrics. This value is used only if the resource is an
	// Auto Scaling group.
	EstimatedInstanceWarmup *int64 `type:"integer"`

	// A predefined metric.
	PredefinedScalingMetricSpecification *PredefinedScalingMetricSpecification `type:"structure"`

	// The amount of time, in seconds, after a scale in activity completes before
	// another scale in activity can start. This value is not used if the scalable
	// resource is an Auto Scaling group.
	//
	// The cooldown period is used to block subsequent scale in requests until it
	// has expired. The intention is to scale in conservatively to protect your
	// application's availability. However, if another alarm triggers a scale out
	// policy during the cooldown period after a scale-in, AWS Auto Scaling scales
	// out your scalable target immediately.
	ScaleInCooldown *int64 `type:"integer"`

	// The amount of time, in seconds, after a scale out activity completes before
	// another scale out activity can start. This value is not used if the scalable
	// resource is an Auto Scaling group.
	//
	// While the cooldown period is in effect, the capacity that has been added
	// by the previous scale out event that initiated the cooldown is calculated
	// as part of the desired capacity for the next scale out. The intention is
	// to continuously (but not excessively) scale out.
	ScaleOutCooldown *int64 `type:"integer"`

	// The target value for the metric. The range is 8.515920e-109 to 1.174271e+108
	// (Base 10) or 2e-360 to 2e360 (Base 2).
	//
	// TargetValue is a required field
	TargetValue *float64 `type:"double" required:"true"`
}

// String returns the string representation
func (s TargetTrackingConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s TargetTrackingConfiguration) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *TargetTrackingConfiguration) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "TargetTrackingConfiguration"}
	if s.TargetValue == nil {
		invalidParams.Add(request.NewErrParamRequired("TargetValue"))
	}
	if s.CustomizedScalingMetricSpecification != nil {
		if err := s.CustomizedScalingMetricSpecification.Validate(); err != nil {
			invalidParams.AddNested("CustomizedScalingMetricSpecification", err.(request.ErrInvalidParams))
		}
	}
	if s.PredefinedScalingMetricSpecification != nil {
		if err := s.PredefinedScalingMetricSpecification.Validate(); err != nil {
			invalidParams.AddNested("PredefinedScalingMetricSpecification", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCustomizedScalingMetricSpecification sets the CustomizedScalingMetricSpecification field's value.
func (s *TargetTrackingConfiguration) SetCustomizedScalingMetricSpecification(v *CustomizedScalingMetricSpecification) *TargetTrackingConfiguration {
	s.CustomizedScalingMetricSpecification = v
	return s
}

// SetDisableScaleIn sets the DisableScaleIn field's value.
func (s *TargetTrackingConfiguration) SetDisableScaleIn(v bool) *TargetTrackingConfiguration {
	s.DisableScaleIn = &v
	return s
}

// SetEstimatedInstanceWarmup sets the EstimatedInstanceWarmup field's value.
func (s *TargetTrackingConfiguration) SetEstimatedInstanceWarmup(v int64) *TargetTrackingConfiguration {
	s.EstimatedInstanceWarmup = &v
	return s
}

// SetPredefinedScalingMetricSpecification sets the PredefinedScalingMetricSpecification field's value.
func (s *TargetTrackingConfiguration) SetPredefinedScalingMetricSpecification(v *PredefinedScalingMetricSpecification) *TargetTrackingConfiguration {
	s.PredefinedScalingMetricSpecification = v
	return s
}

// SetScaleInCooldown sets the ScaleInCooldown field's value.
func (s *TargetTrackingConfiguration) SetScaleInCooldown(v int64) *TargetTrackingConfiguration {
	s.ScaleInCooldown = &v
	return s
}

// SetScaleOutCooldown sets the ScaleOutCooldown field's value.
func (s *TargetTrackingConfiguration) SetScaleOutCooldown(v int64) *TargetTrackingConfiguration {
	s.ScaleOutCooldown = &v
	return s
}

// SetTargetValue sets the TargetValue field's value.
func (s *TargetTrackingConfiguration) SetTargetValue(v float64) *TargetTrackingConfiguration {
	s.TargetValue = &v
	return s
}

type UpdateScalingPlanInput struct {
	_ struct{} `type:"structure"`

	// A CloudFormation stack or set of tags.
	ApplicationSource *ApplicationSource `type:"structure"`

	// The scaling instructions.
	ScalingInstructions []*ScalingInstruction `type:"list"`

	// The name of the scaling plan.
	//
	// ScalingPlanName is a required field
	ScalingPlanName *string `min:"1" type:"string" required:"true"`

	// The version number.
	//
	// ScalingPlanVersion is a required field
	ScalingPlanVersion *int64 `type:"long" required:"true"`
}

// String returns the string representation
func (s UpdateScalingPlanInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateScalingPlanInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateScalingPlanInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateScalingPlanInput"}
	if s.ScalingPlanName == nil {
		invalidParams.Add(request.NewErrParamRequired("ScalingPlanName"))
	}
	if s.ScalingPlanName != nil && len(*s.ScalingPlanName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ScalingPlanName", 1))
	}
	if s.ScalingPlanVersion == nil {
		invalidParams.Add(request.NewErrParamRequired("ScalingPlanVersion"))
	}
	if s.ApplicationSource != nil {
		if err := s.ApplicationSource.Validate(); err != nil {
			invalidParams.AddNested("ApplicationSource", err.(request.ErrInvalidParams))
		}
	}
	if s.ScalingInstructions != nil {
		for i, v := range s.ScalingInstructions {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "ScalingInstructions", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetApplicationSource sets the ApplicationSource field's value.
func (s *UpdateScalingPlanInput) SetApplicationSource(v *ApplicationSource) *UpdateScalingPlanInput {
	s.ApplicationSource = v
	return s
}

// SetScalingInstructions sets the ScalingInstructions field's value.
func (s *UpdateScalingPlanInput) SetScalingInstructions(v []*ScalingInstruction) *UpdateScalingPlanInput {
	s.ScalingInstructions = v
	return s
}

// SetScalingPlanName sets the ScalingPlanName field's value.
func (s *UpdateScalingPlanInput) SetScalingPlanName(v string) *UpdateScalingPlanInput {
	s.ScalingPlanName = &v
	return s
}

// SetScalingPlanVersion sets the ScalingPlanVersion field's value.
func (s *UpdateScalingPlanInput) SetScalingPlanVersion(v int64) *UpdateScalingPlanInput {
	s.ScalingPlanVersion = &v
	return s
}

type UpdateScalingPlanOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s UpdateScalingPlanOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateScalingPlanOutput) GoString() string {
	return s.String()
}

const (
	// MetricStatisticAverage is a MetricStatistic enum value
	MetricStatisticAverage = "Average"

	// MetricStatisticMinimum is a MetricStatistic enum value
	MetricStatisticMinimum = "Minimum"

	// MetricStatisticMaximum is a MetricStatistic enum value
	MetricStatisticMaximum = "Maximum"

	// MetricStatisticSampleCount is a MetricStatistic enum value
	MetricStatisticSampleCount = "SampleCount"

	// MetricStatisticSum is a MetricStatistic enum value
	MetricStatisticSum = "Sum"
)

const (
	// PolicyTypeTargetTrackingScaling is a PolicyType enum value
	PolicyTypeTargetTrackingScaling = "TargetTrackingScaling"
)

const (
	// ScalableDimensionAutoscalingAutoScalingGroupDesiredCapacity is a ScalableDimension enum value
	ScalableDimensionAutoscalingAutoScalingGroupDesiredCapacity = "autoscaling:autoScalingGroup:DesiredCapacity"

	// ScalableDimensionEcsServiceDesiredCount is a ScalableDimension enum value
	ScalableDimensionEcsServiceDesiredCount = "ecs:service:DesiredCount"

	// ScalableDimensionEc2SpotFleetRequestTargetCapacity is a ScalableDimension enum value
	ScalableDimensionEc2SpotFleetRequestTargetCapacity = "ec2:spot-fleet-request:TargetCapacity"

	// ScalableDimensionRdsClusterReadReplicaCount is a ScalableDimension enum value
	ScalableDimensionRdsClusterReadReplicaCount = "rds:cluster:ReadReplicaCount"

	// ScalableDimensionDynamodbTableReadCapacityUnits is a ScalableDimension enum value
	ScalableDimensionDynamodbTableReadCapacityUnits = "dynamodb:table:ReadCapacityUnits"

	// ScalableDimensionDynamodbTableWriteCapacityUnits is a ScalableDimension enum value
	ScalableDimensionDynamodbTableWriteCapacityUnits = "dynamodb:table:WriteCapacityUnits"

	// ScalableDimensionDynamodbIndexReadCapacityUnits is a ScalableDimension enum value
	ScalableDimensionDynamodbIndexReadCapacityUnits = "dynamodb:index:ReadCapacityUnits"

	// ScalableDimensionDynamodbIndexWriteCapacityUnits is a ScalableDimension enum value
	ScalableDimensionDynamodbIndexWriteCapacityUnits = "dynamodb:index:WriteCapacityUnits"
)

const (
	// ScalingMetricTypeAsgaverageCpuutilization is a ScalingMetricType enum value
	ScalingMetricTypeAsgaverageCpuutilization = "ASGAverageCPUUtilization"

	// ScalingMetricTypeAsgaverageNetworkIn is a ScalingMetricType enum value
	ScalingMetricTypeAsgaverageNetworkIn = "ASGAverageNetworkIn"

	// ScalingMetricTypeAsgaverageNetworkOut is a ScalingMetricType enum value
	ScalingMetricTypeAsgaverageNetworkOut = "ASGAverageNetworkOut"

	// ScalingMetricTypeDynamoDbreadCapacityUtilization is a ScalingMetricType enum value
	ScalingMetricTypeDynamoDbreadCapacityUtilization = "DynamoDBReadCapacityUtilization"

	// ScalingMetricTypeDynamoDbwriteCapacityUtilization is a ScalingMetricType enum value
	ScalingMetricTypeDynamoDbwriteCapacityUtilization = "DynamoDBWriteCapacityUtilization"

	// ScalingMetricTypeEcsserviceAverageCpuutilization is a ScalingMetricType enum value
	ScalingMetricTypeEcsserviceAverageCpuutilization = "ECSServiceAverageCPUUtilization"

	// ScalingMetricTypeEcsserviceAverageMemoryUtilization is a ScalingMetricType enum value
	ScalingMetricTypeEcsserviceAverageMemoryUtilization = "ECSServiceAverageMemoryUtilization"

	// ScalingMetricTypeAlbrequestCountPerTarget is a ScalingMetricType enum value
	ScalingMetricTypeAlbrequestCountPerTarget = "ALBRequestCountPerTarget"

	// ScalingMetricTypeRdsreaderAverageCpuutilization is a ScalingMetricType enum value
	ScalingMetricTypeRdsreaderAverageCpuutilization = "RDSReaderAverageCPUUtilization"

	// ScalingMetricTypeRdsreaderAverageDatabaseConnections is a ScalingMetricType enum value
	ScalingMetricTypeRdsreaderAverageDatabaseConnections = "RDSReaderAverageDatabaseConnections"

	// ScalingMetricTypeEc2spotFleetRequestAverageCpuutilization is a ScalingMetricType enum value
	ScalingMetricTypeEc2spotFleetRequestAverageCpuutilization = "EC2SpotFleetRequestAverageCPUUtilization"

	// ScalingMetricTypeEc2spotFleetRequestAverageNetworkIn is a ScalingMetricType enum value
	ScalingMetricTypeEc2spotFleetRequestAverageNetworkIn = "EC2SpotFleetRequestAverageNetworkIn"

	// ScalingMetricTypeEc2spotFleetRequestAverageNetworkOut is a ScalingMetricType enum value
	ScalingMetricTypeEc2spotFleetRequestAverageNetworkOut = "EC2SpotFleetRequestAverageNetworkOut"
)

const (
	// ScalingPlanStatusCodeActive is a ScalingPlanStatusCode enum value
	ScalingPlanStatusCodeActive = "Active"

	// ScalingPlanStatusCodeActiveWithProblems is a ScalingPlanStatusCode enum value
	ScalingPlanStatusCodeActiveWithProblems = "ActiveWithProblems"

	// ScalingPlanStatusCodeCreationInProgress is a ScalingPlanStatusCode enum value
	ScalingPlanStatusCodeCreationInProgress = "CreationInProgress"

	// ScalingPlanStatusCodeCreationFailed is a ScalingPlanStatusCode enum value
	ScalingPlanStatusCodeCreationFailed = "CreationFailed"

	// ScalingPlanStatusCodeDeletionInProgress is a ScalingPlanStatusCode enum value
	ScalingPlanStatusCodeDeletionInProgress = "DeletionInProgress"

	// ScalingPlanStatusCodeDeletionFailed is a ScalingPlanStatusCode enum value
	ScalingPlanStatusCodeDeletionFailed = "DeletionFailed"

	// ScalingPlanStatusCodeUpdateInProgress is a ScalingPlanStatusCode enum value
	ScalingPlanStatusCodeUpdateInProgress = "UpdateInProgress"

	// ScalingPlanStatusCodeUpdateFailed is a ScalingPlanStatusCode enum value
	ScalingPlanStatusCodeUpdateFailed = "UpdateFailed"
)

const (
	// ScalingStatusCodeInactive is a ScalingStatusCode enum value
	ScalingStatusCodeInactive = "Inactive"

	// ScalingStatusCodePartiallyActive is a ScalingStatusCode enum value
	ScalingStatusCodePartiallyActive = "PartiallyActive"

	// ScalingStatusCodeActive is a ScalingStatusCode enum value
	ScalingStatusCodeActive = "Active"
)

const (
	// ServiceNamespaceAutoscaling is a ServiceNamespace enum value
	ServiceNamespaceAutoscaling = "autoscaling"

	// ServiceNamespaceEcs is a ServiceNamespace enum value
	ServiceNamespaceEcs = "ecs"

	// ServiceNamespaceEc2 is a ServiceNamespace enum value
	ServiceNamespaceEc2 = "ec2"

	// ServiceNamespaceRds is a ServiceNamespace enum value
	ServiceNamespaceRds = "rds"

	// ServiceNamespaceDynamodb is a ServiceNamespace enum value
	ServiceNamespaceDynamodb = "dynamodb"
)
