package botservice

// Copyright (c) Microsoft and contributors.  All rights reserved.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
// http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//
// See the License for the specific language governing permissions and
// limitations under the License.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"encoding/json"
	"github.com/Azure/go-autorest/autorest"
	"github.com/Azure/go-autorest/autorest/to"
	"net/http"
)

// ChannelName enumerates the values for channel name.
type ChannelName string

const (
	// ChannelNameDirectLineChannel ...
	ChannelNameDirectLineChannel ChannelName = "DirectLineChannel"
	// ChannelNameEmailChannel ...
	ChannelNameEmailChannel ChannelName = "EmailChannel"
	// ChannelNameFacebookChannel ...
	ChannelNameFacebookChannel ChannelName = "FacebookChannel"
	// ChannelNameKikChannel ...
	ChannelNameKikChannel ChannelName = "KikChannel"
	// ChannelNameMsTeamsChannel ...
	ChannelNameMsTeamsChannel ChannelName = "MsTeamsChannel"
	// ChannelNameSkypeChannel ...
	ChannelNameSkypeChannel ChannelName = "SkypeChannel"
	// ChannelNameSlackChannel ...
	ChannelNameSlackChannel ChannelName = "SlackChannel"
	// ChannelNameSmsChannel ...
	ChannelNameSmsChannel ChannelName = "SmsChannel"
	// ChannelNameTelegramChannel ...
	ChannelNameTelegramChannel ChannelName = "TelegramChannel"
	// ChannelNameWebChatChannel ...
	ChannelNameWebChatChannel ChannelName = "WebChatChannel"
)

// PossibleChannelNameValues returns an array of possible values for the ChannelName const type.
func PossibleChannelNameValues() []ChannelName {
	return []ChannelName{ChannelNameDirectLineChannel, ChannelNameEmailChannel, ChannelNameFacebookChannel, ChannelNameKikChannel, ChannelNameMsTeamsChannel, ChannelNameSkypeChannel, ChannelNameSlackChannel, ChannelNameSmsChannel, ChannelNameTelegramChannel, ChannelNameWebChatChannel}
}

// ChannelNameBasicChannel enumerates the values for channel name basic channel.
type ChannelNameBasicChannel string

const (
	// ChannelNameChannel ...
	ChannelNameChannel ChannelNameBasicChannel = "Channel"
	// ChannelNameDirectLineChannel1 ...
	ChannelNameDirectLineChannel1 ChannelNameBasicChannel = "DirectLineChannel"
	// ChannelNameEmailChannel1 ...
	ChannelNameEmailChannel1 ChannelNameBasicChannel = "EmailChannel"
	// ChannelNameFacebookChannel1 ...
	ChannelNameFacebookChannel1 ChannelNameBasicChannel = "FacebookChannel"
	// ChannelNameKikChannel1 ...
	ChannelNameKikChannel1 ChannelNameBasicChannel = "KikChannel"
	// ChannelNameMsTeamsChannel1 ...
	ChannelNameMsTeamsChannel1 ChannelNameBasicChannel = "MsTeamsChannel"
	// ChannelNameSkypeChannel1 ...
	ChannelNameSkypeChannel1 ChannelNameBasicChannel = "SkypeChannel"
	// ChannelNameSlackChannel1 ...
	ChannelNameSlackChannel1 ChannelNameBasicChannel = "SlackChannel"
	// ChannelNameSmsChannel1 ...
	ChannelNameSmsChannel1 ChannelNameBasicChannel = "SmsChannel"
	// ChannelNameTelegramChannel1 ...
	ChannelNameTelegramChannel1 ChannelNameBasicChannel = "TelegramChannel"
	// ChannelNameWebChatChannel1 ...
	ChannelNameWebChatChannel1 ChannelNameBasicChannel = "WebChatChannel"
)

// PossibleChannelNameBasicChannelValues returns an array of possible values for the ChannelNameBasicChannel const type.
func PossibleChannelNameBasicChannelValues() []ChannelNameBasicChannel {
	return []ChannelNameBasicChannel{ChannelNameChannel, ChannelNameDirectLineChannel1, ChannelNameEmailChannel1, ChannelNameFacebookChannel1, ChannelNameKikChannel1, ChannelNameMsTeamsChannel1, ChannelNameSkypeChannel1, ChannelNameSlackChannel1, ChannelNameSmsChannel1, ChannelNameTelegramChannel1, ChannelNameWebChatChannel1}
}

// Kind enumerates the values for kind.
type Kind string

const (
	// KindBot ...
	KindBot Kind = "bot"
	// KindDesigner ...
	KindDesigner Kind = "designer"
	// KindFunction ...
	KindFunction Kind = "function"
	// KindSdk ...
	KindSdk Kind = "sdk"
)

// PossibleKindValues returns an array of possible values for the Kind const type.
func PossibleKindValues() []Kind {
	return []Kind{KindBot, KindDesigner, KindFunction, KindSdk}
}

// SkuName enumerates the values for sku name.
type SkuName string

const (
	// F0 ...
	F0 SkuName = "F0"
	// S1 ...
	S1 SkuName = "S1"
)

// PossibleSkuNameValues returns an array of possible values for the SkuName const type.
func PossibleSkuNameValues() []SkuName {
	return []SkuName{F0, S1}
}

// SkuTier enumerates the values for sku tier.
type SkuTier string

const (
	// Free ...
	Free SkuTier = "Free"
	// Standard ...
	Standard SkuTier = "Standard"
)

// PossibleSkuTierValues returns an array of possible values for the SkuTier const type.
func PossibleSkuTierValues() []SkuTier {
	return []SkuTier{Free, Standard}
}

// Bot bot resource definition
type Bot struct {
	autorest.Response `json:"-"`
	// Properties - The set of properties specific to bot resource
	Properties *BotProperties `json:"properties,omitempty"`
	// ID - Specifies the resource ID.
	ID *string `json:"id,omitempty"`
	// Name - Specifies the name of the resource.
	Name *string `json:"name,omitempty"`
	// Location - Specifies the location of the resource.
	Location *string `json:"location,omitempty"`
	// Type - Specifies the type of the resource.
	Type *string `json:"type,omitempty"`
	// Tags - Contains resource tags defined as key/value pairs.
	Tags map[string]*string `json:"tags"`
	// Sku - Gets or sets the SKU of the resource.
	Sku *Sku `json:"sku,omitempty"`
	// Kind - Required. Gets or sets the Kind of the resource. Possible values include: 'KindSdk', 'KindDesigner', 'KindBot', 'KindFunction'
	Kind Kind `json:"kind,omitempty"`
	// Etag - Entity Tag
	Etag *string `json:"etag,omitempty"`
}

// MarshalJSON is the custom marshaler for Bot.
func (b Bot) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if b.Properties != nil {
		objectMap["properties"] = b.Properties
	}
	if b.ID != nil {
		objectMap["id"] = b.ID
	}
	if b.Name != nil {
		objectMap["name"] = b.Name
	}
	if b.Location != nil {
		objectMap["location"] = b.Location
	}
	if b.Type != nil {
		objectMap["type"] = b.Type
	}
	if b.Tags != nil {
		objectMap["tags"] = b.Tags
	}
	if b.Sku != nil {
		objectMap["sku"] = b.Sku
	}
	if b.Kind != "" {
		objectMap["kind"] = b.Kind
	}
	if b.Etag != nil {
		objectMap["etag"] = b.Etag
	}
	return json.Marshal(objectMap)
}

// BotChannel bot channel resource definition
type BotChannel struct {
	autorest.Response `json:"-"`
	// Properties - The set of properties specific to bot channel resource
	Properties BasicChannel `json:"properties,omitempty"`
	// ID - Specifies the resource ID.
	ID *string `json:"id,omitempty"`
	// Name - Specifies the name of the resource.
	Name *string `json:"name,omitempty"`
	// Location - Specifies the location of the resource.
	Location *string `json:"location,omitempty"`
	// Type - Specifies the type of the resource.
	Type *string `json:"type,omitempty"`
	// Tags - Contains resource tags defined as key/value pairs.
	Tags map[string]*string `json:"tags"`
	// Sku - Gets or sets the SKU of the resource.
	Sku *Sku `json:"sku,omitempty"`
	// Kind - Required. Gets or sets the Kind of the resource. Possible values include: 'KindSdk', 'KindDesigner', 'KindBot', 'KindFunction'
	Kind Kind `json:"kind,omitempty"`
	// Etag - Entity Tag
	Etag *string `json:"etag,omitempty"`
}

// MarshalJSON is the custom marshaler for BotChannel.
func (bc BotChannel) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	objectMap["properties"] = bc.Properties
	if bc.ID != nil {
		objectMap["id"] = bc.ID
	}
	if bc.Name != nil {
		objectMap["name"] = bc.Name
	}
	if bc.Location != nil {
		objectMap["location"] = bc.Location
	}
	if bc.Type != nil {
		objectMap["type"] = bc.Type
	}
	if bc.Tags != nil {
		objectMap["tags"] = bc.Tags
	}
	if bc.Sku != nil {
		objectMap["sku"] = bc.Sku
	}
	if bc.Kind != "" {
		objectMap["kind"] = bc.Kind
	}
	if bc.Etag != nil {
		objectMap["etag"] = bc.Etag
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for BotChannel struct.
func (bc *BotChannel) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				properties, err := unmarshalBasicChannel(*v)
				if err != nil {
					return err
				}
				bc.Properties = properties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				bc.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				bc.Name = &name
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				bc.Location = &location
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				bc.Type = &typeVar
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				bc.Tags = tags
			}
		case "sku":
			if v != nil {
				var sku Sku
				err = json.Unmarshal(*v, &sku)
				if err != nil {
					return err
				}
				bc.Sku = &sku
			}
		case "kind":
			if v != nil {
				var kind Kind
				err = json.Unmarshal(*v, &kind)
				if err != nil {
					return err
				}
				bc.Kind = kind
			}
		case "etag":
			if v != nil {
				var etag string
				err = json.Unmarshal(*v, &etag)
				if err != nil {
					return err
				}
				bc.Etag = &etag
			}
		}
	}

	return nil
}

// BotProperties the parameters to provide for the Bot.
type BotProperties struct {
	// DisplayName - The Name of the bot
	DisplayName *string `json:"displayName,omitempty"`
	// Description - The description of the bot
	Description *string `json:"description,omitempty"`
	// IconURL - The Icon Url of the bot
	IconURL *string `json:"iconUrl,omitempty"`
	// Endpoint - The bot's endpoint
	Endpoint *string `json:"endpoint,omitempty"`
	// EndpointVersion - The bot's endpoint version
	EndpointVersion *string `json:"endpointVersion,omitempty"`
	// MsaAppID - Microsoft App Id for the bot
	MsaAppID *string `json:"msaAppId,omitempty"`
	// ConfiguredChannels - Collection of channels for which the bot is configured
	ConfiguredChannels *[]string `json:"configuredChannels,omitempty"`
	// EnabledChannels - Collection of channels for which the bot is enabled
	EnabledChannels *[]string `json:"enabledChannels,omitempty"`
	// DeveloperAppInsightKey - The Application Insights key
	DeveloperAppInsightKey *string `json:"developerAppInsightKey,omitempty"`
	// DeveloperAppInsightsAPIKey - The Application Insights Api Key
	DeveloperAppInsightsAPIKey *string `json:"developerAppInsightsApiKey,omitempty"`
	// DeveloperAppInsightsApplicationID - The Application Insights App Id
	DeveloperAppInsightsApplicationID *string `json:"developerAppInsightsApplicationId,omitempty"`
	// LuisAppIds - Collection of LUIS App Ids
	LuisAppIds *[]string `json:"luisAppIds,omitempty"`
	// LuisKey - The LUIS Key
	LuisKey *string `json:"luisKey,omitempty"`
}

// BotResponseList the list of  bot service operation response.
type BotResponseList struct {
	autorest.Response `json:"-"`
	// NextLink - The link used to get the next page of bot service resources.
	NextLink *string `json:"nextLink,omitempty"`
	// Value - Gets the list of bot service results and their properties.
	Value *[]Bot `json:"value,omitempty"`
}

// BotResponseListIterator provides access to a complete listing of Bot values.
type BotResponseListIterator struct {
	i    int
	page BotResponseListPage
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *BotResponseListIterator) Next() error {
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err := iter.page.Next()
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter BotResponseListIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter BotResponseListIterator) Response() BotResponseList {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter BotResponseListIterator) Value() Bot {
	if !iter.page.NotDone() {
		return Bot{}
	}
	return iter.page.Values()[iter.i]
}

// IsEmpty returns true if the ListResult contains no values.
func (brl BotResponseList) IsEmpty() bool {
	return brl.Value == nil || len(*brl.Value) == 0
}

// botResponseListPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (brl BotResponseList) botResponseListPreparer() (*http.Request, error) {
	if brl.NextLink == nil || len(to.String(brl.NextLink)) < 1 {
		return nil, nil
	}
	return autorest.Prepare(&http.Request{},
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(brl.NextLink)))
}

// BotResponseListPage contains a page of Bot values.
type BotResponseListPage struct {
	fn  func(BotResponseList) (BotResponseList, error)
	brl BotResponseList
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *BotResponseListPage) Next() error {
	next, err := page.fn(page.brl)
	if err != nil {
		return err
	}
	page.brl = next
	return nil
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page BotResponseListPage) NotDone() bool {
	return !page.brl.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page BotResponseListPage) Response() BotResponseList {
	return page.brl
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page BotResponseListPage) Values() []Bot {
	if page.brl.IsEmpty() {
		return nil
	}
	return *page.brl.Value
}

// BasicChannel channel definition
type BasicChannel interface {
	AsFacebookChannel() (*FacebookChannel, bool)
	AsEmailChannel() (*EmailChannel, bool)
	AsMsTeamsChannel() (*MsTeamsChannel, bool)
	AsSkypeChannel() (*SkypeChannel, bool)
	AsKikChannel() (*KikChannel, bool)
	AsWebChatChannel() (*WebChatChannel, bool)
	AsDirectLineChannel() (*DirectLineChannel, bool)
	AsTelegramChannel() (*TelegramChannel, bool)
	AsSmsChannel() (*SmsChannel, bool)
	AsSlackChannel() (*SlackChannel, bool)
	AsChannel() (*Channel, bool)
}

// Channel channel definition
type Channel struct {
	// ChannelName - Possible values include: 'ChannelNameChannel', 'ChannelNameFacebookChannel1', 'ChannelNameEmailChannel1', 'ChannelNameMsTeamsChannel1', 'ChannelNameSkypeChannel1', 'ChannelNameKikChannel1', 'ChannelNameWebChatChannel1', 'ChannelNameDirectLineChannel1', 'ChannelNameTelegramChannel1', 'ChannelNameSmsChannel1', 'ChannelNameSlackChannel1'
	ChannelName ChannelNameBasicChannel `json:"channelName,omitempty"`
}

func unmarshalBasicChannel(body []byte) (BasicChannel, error) {
	var m map[string]interface{}
	err := json.Unmarshal(body, &m)
	if err != nil {
		return nil, err
	}

	switch m["channelName"] {
	case string(ChannelNameFacebookChannel1):
		var fc FacebookChannel
		err := json.Unmarshal(body, &fc)
		return fc, err
	case string(ChannelNameEmailChannel1):
		var ec EmailChannel
		err := json.Unmarshal(body, &ec)
		return ec, err
	case string(ChannelNameMsTeamsChannel1):
		var mtc MsTeamsChannel
		err := json.Unmarshal(body, &mtc)
		return mtc, err
	case string(ChannelNameSkypeChannel1):
		var sc SkypeChannel
		err := json.Unmarshal(body, &sc)
		return sc, err
	case string(ChannelNameKikChannel1):
		var kc KikChannel
		err := json.Unmarshal(body, &kc)
		return kc, err
	case string(ChannelNameWebChatChannel1):
		var wcc WebChatChannel
		err := json.Unmarshal(body, &wcc)
		return wcc, err
	case string(ChannelNameDirectLineChannel1):
		var dlc DirectLineChannel
		err := json.Unmarshal(body, &dlc)
		return dlc, err
	case string(ChannelNameTelegramChannel1):
		var tc TelegramChannel
		err := json.Unmarshal(body, &tc)
		return tc, err
	case string(ChannelNameSmsChannel1):
		var sc SmsChannel
		err := json.Unmarshal(body, &sc)
		return sc, err
	case string(ChannelNameSlackChannel1):
		var sc SlackChannel
		err := json.Unmarshal(body, &sc)
		return sc, err
	default:
		var c Channel
		err := json.Unmarshal(body, &c)
		return c, err
	}
}
func unmarshalBasicChannelArray(body []byte) ([]BasicChannel, error) {
	var rawMessages []*json.RawMessage
	err := json.Unmarshal(body, &rawMessages)
	if err != nil {
		return nil, err
	}

	cArray := make([]BasicChannel, len(rawMessages))

	for index, rawMessage := range rawMessages {
		c, err := unmarshalBasicChannel(*rawMessage)
		if err != nil {
			return nil, err
		}
		cArray[index] = c
	}
	return cArray, nil
}

// MarshalJSON is the custom marshaler for Channel.
func (c Channel) MarshalJSON() ([]byte, error) {
	c.ChannelName = ChannelNameChannel
	objectMap := make(map[string]interface{})
	if c.ChannelName != "" {
		objectMap["channelName"] = c.ChannelName
	}
	return json.Marshal(objectMap)
}

// AsFacebookChannel is the BasicChannel implementation for Channel.
func (c Channel) AsFacebookChannel() (*FacebookChannel, bool) {
	return nil, false
}

// AsEmailChannel is the BasicChannel implementation for Channel.
func (c Channel) AsEmailChannel() (*EmailChannel, bool) {
	return nil, false
}

// AsMsTeamsChannel is the BasicChannel implementation for Channel.
func (c Channel) AsMsTeamsChannel() (*MsTeamsChannel, bool) {
	return nil, false
}

// AsSkypeChannel is the BasicChannel implementation for Channel.
func (c Channel) AsSkypeChannel() (*SkypeChannel, bool) {
	return nil, false
}

// AsKikChannel is the BasicChannel implementation for Channel.
func (c Channel) AsKikChannel() (*KikChannel, bool) {
	return nil, false
}

// AsWebChatChannel is the BasicChannel implementation for Channel.
func (c Channel) AsWebChatChannel() (*WebChatChannel, bool) {
	return nil, false
}

// AsDirectLineChannel is the BasicChannel implementation for Channel.
func (c Channel) AsDirectLineChannel() (*DirectLineChannel, bool) {
	return nil, false
}

// AsTelegramChannel is the BasicChannel implementation for Channel.
func (c Channel) AsTelegramChannel() (*TelegramChannel, bool) {
	return nil, false
}

// AsSmsChannel is the BasicChannel implementation for Channel.
func (c Channel) AsSmsChannel() (*SmsChannel, bool) {
	return nil, false
}

// AsSlackChannel is the BasicChannel implementation for Channel.
func (c Channel) AsSlackChannel() (*SlackChannel, bool) {
	return nil, false
}

// AsChannel is the BasicChannel implementation for Channel.
func (c Channel) AsChannel() (*Channel, bool) {
	return &c, true
}

// AsBasicChannel is the BasicChannel implementation for Channel.
func (c Channel) AsBasicChannel() (BasicChannel, bool) {
	return &c, true
}

// ChannelResponseList the list of bot service channel operation response.
type ChannelResponseList struct {
	autorest.Response `json:"-"`
	// NextLink - The link used to get the next page of bot service channel resources.
	NextLink *string `json:"nextLink,omitempty"`
	// Value - Gets the list of bot service channel results and their properties.
	Value *[]BotChannel `json:"value,omitempty"`
}

// ChannelResponseListIterator provides access to a complete listing of BotChannel values.
type ChannelResponseListIterator struct {
	i    int
	page ChannelResponseListPage
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *ChannelResponseListIterator) Next() error {
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err := iter.page.Next()
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter ChannelResponseListIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter ChannelResponseListIterator) Response() ChannelResponseList {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter ChannelResponseListIterator) Value() BotChannel {
	if !iter.page.NotDone() {
		return BotChannel{}
	}
	return iter.page.Values()[iter.i]
}

// IsEmpty returns true if the ListResult contains no values.
func (crl ChannelResponseList) IsEmpty() bool {
	return crl.Value == nil || len(*crl.Value) == 0
}

// channelResponseListPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (crl ChannelResponseList) channelResponseListPreparer() (*http.Request, error) {
	if crl.NextLink == nil || len(to.String(crl.NextLink)) < 1 {
		return nil, nil
	}
	return autorest.Prepare(&http.Request{},
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(crl.NextLink)))
}

// ChannelResponseListPage contains a page of BotChannel values.
type ChannelResponseListPage struct {
	fn  func(ChannelResponseList) (ChannelResponseList, error)
	crl ChannelResponseList
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *ChannelResponseListPage) Next() error {
	next, err := page.fn(page.crl)
	if err != nil {
		return err
	}
	page.crl = next
	return nil
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page ChannelResponseListPage) NotDone() bool {
	return !page.crl.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page ChannelResponseListPage) Response() ChannelResponseList {
	return page.crl
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page ChannelResponseListPage) Values() []BotChannel {
	if page.crl.IsEmpty() {
		return nil
	}
	return *page.crl.Value
}

// CheckNameAvailabilityRequestBody the request body for a request to Bot Service Management to check availability
// of a bot name.
type CheckNameAvailabilityRequestBody struct {
	// Name - the name of the bot for which availability needs to be checked.
	Name *string `json:"name,omitempty"`
	// Type - the type of the bot for which availability needs to be checked
	Type *string `json:"type,omitempty"`
}

// CheckNameAvailabilityResponseBody the response body returned for a request to Bot Service Management to check
// availability of a bot name.
type CheckNameAvailabilityResponseBody struct {
	autorest.Response `json:"-"`
	// Valid - indicates if the bot name is valid.
	Valid *bool `json:"valid,omitempty"`
	// Message - additional message from the bot management api showing why a bot name is not available
	Message *string `json:"message,omitempty"`
}

// DirectLineChannel direct Line channel definition
type DirectLineChannel struct {
	// Properties - The set of properties specific to Direct Line channel resource
	Properties *DirectLineChannelProperties `json:"properties,omitempty"`
	// ChannelName - Possible values include: 'ChannelNameChannel', 'ChannelNameFacebookChannel1', 'ChannelNameEmailChannel1', 'ChannelNameMsTeamsChannel1', 'ChannelNameSkypeChannel1', 'ChannelNameKikChannel1', 'ChannelNameWebChatChannel1', 'ChannelNameDirectLineChannel1', 'ChannelNameTelegramChannel1', 'ChannelNameSmsChannel1', 'ChannelNameSlackChannel1'
	ChannelName ChannelNameBasicChannel `json:"channelName,omitempty"`
}

// MarshalJSON is the custom marshaler for DirectLineChannel.
func (dlc DirectLineChannel) MarshalJSON() ([]byte, error) {
	dlc.ChannelName = ChannelNameDirectLineChannel1
	objectMap := make(map[string]interface{})
	if dlc.Properties != nil {
		objectMap["properties"] = dlc.Properties
	}
	if dlc.ChannelName != "" {
		objectMap["channelName"] = dlc.ChannelName
	}
	return json.Marshal(objectMap)
}

// AsFacebookChannel is the BasicChannel implementation for DirectLineChannel.
func (dlc DirectLineChannel) AsFacebookChannel() (*FacebookChannel, bool) {
	return nil, false
}

// AsEmailChannel is the BasicChannel implementation for DirectLineChannel.
func (dlc DirectLineChannel) AsEmailChannel() (*EmailChannel, bool) {
	return nil, false
}

// AsMsTeamsChannel is the BasicChannel implementation for DirectLineChannel.
func (dlc DirectLineChannel) AsMsTeamsChannel() (*MsTeamsChannel, bool) {
	return nil, false
}

// AsSkypeChannel is the BasicChannel implementation for DirectLineChannel.
func (dlc DirectLineChannel) AsSkypeChannel() (*SkypeChannel, bool) {
	return nil, false
}

// AsKikChannel is the BasicChannel implementation for DirectLineChannel.
func (dlc DirectLineChannel) AsKikChannel() (*KikChannel, bool) {
	return nil, false
}

// AsWebChatChannel is the BasicChannel implementation for DirectLineChannel.
func (dlc DirectLineChannel) AsWebChatChannel() (*WebChatChannel, bool) {
	return nil, false
}

// AsDirectLineChannel is the BasicChannel implementation for DirectLineChannel.
func (dlc DirectLineChannel) AsDirectLineChannel() (*DirectLineChannel, bool) {
	return &dlc, true
}

// AsTelegramChannel is the BasicChannel implementation for DirectLineChannel.
func (dlc DirectLineChannel) AsTelegramChannel() (*TelegramChannel, bool) {
	return nil, false
}

// AsSmsChannel is the BasicChannel implementation for DirectLineChannel.
func (dlc DirectLineChannel) AsSmsChannel() (*SmsChannel, bool) {
	return nil, false
}

// AsSlackChannel is the BasicChannel implementation for DirectLineChannel.
func (dlc DirectLineChannel) AsSlackChannel() (*SlackChannel, bool) {
	return nil, false
}

// AsChannel is the BasicChannel implementation for DirectLineChannel.
func (dlc DirectLineChannel) AsChannel() (*Channel, bool) {
	return nil, false
}

// AsBasicChannel is the BasicChannel implementation for DirectLineChannel.
func (dlc DirectLineChannel) AsBasicChannel() (BasicChannel, bool) {
	return &dlc, true
}

// DirectLineChannelProperties the parameters to provide for the Direct Line channel.
type DirectLineChannelProperties struct {
	// Sites - The list of Direct Line sites
	Sites *[]DirectLineSite `json:"sites,omitempty"`
}

// DirectLineSite a site for the Direct Line channel
type DirectLineSite struct {
	// SiteID - Site Id
	SiteID *string `json:"siteId,omitempty"`
	// SiteName - Site name
	SiteName *string `json:"siteName,omitempty"`
	// Key - Primary key. Value only returned through POST to the action Channel List API, otherwise empty.
	Key *string `json:"key,omitempty"`
	// Key2 - Secondary key. Value only returned through POST to the action Channel List API, otherwise empty.
	Key2 *string `json:"key2,omitempty"`
	// IsEnabled - Whether this site is enabled for DirectLine channel
	IsEnabled *bool `json:"isEnabled,omitempty"`
	// IsV1Enabled - Whether this site is enabled for Bot Framework V1 protocol
	IsV1Enabled *bool `json:"isV1Enabled,omitempty"`
	// IsV3Enabled - Whether this site is enabled for Bot Framework V1 protocol
	IsV3Enabled *bool `json:"isV3Enabled,omitempty"`
}

// EmailChannel email channel definition
type EmailChannel struct {
	// Properties - The set of properties specific to email channel resource
	Properties *EmailChannelProperties `json:"properties,omitempty"`
	// ChannelName - Possible values include: 'ChannelNameChannel', 'ChannelNameFacebookChannel1', 'ChannelNameEmailChannel1', 'ChannelNameMsTeamsChannel1', 'ChannelNameSkypeChannel1', 'ChannelNameKikChannel1', 'ChannelNameWebChatChannel1', 'ChannelNameDirectLineChannel1', 'ChannelNameTelegramChannel1', 'ChannelNameSmsChannel1', 'ChannelNameSlackChannel1'
	ChannelName ChannelNameBasicChannel `json:"channelName,omitempty"`
}

// MarshalJSON is the custom marshaler for EmailChannel.
func (ec EmailChannel) MarshalJSON() ([]byte, error) {
	ec.ChannelName = ChannelNameEmailChannel1
	objectMap := make(map[string]interface{})
	if ec.Properties != nil {
		objectMap["properties"] = ec.Properties
	}
	if ec.ChannelName != "" {
		objectMap["channelName"] = ec.ChannelName
	}
	return json.Marshal(objectMap)
}

// AsFacebookChannel is the BasicChannel implementation for EmailChannel.
func (ec EmailChannel) AsFacebookChannel() (*FacebookChannel, bool) {
	return nil, false
}

// AsEmailChannel is the BasicChannel implementation for EmailChannel.
func (ec EmailChannel) AsEmailChannel() (*EmailChannel, bool) {
	return &ec, true
}

// AsMsTeamsChannel is the BasicChannel implementation for EmailChannel.
func (ec EmailChannel) AsMsTeamsChannel() (*MsTeamsChannel, bool) {
	return nil, false
}

// AsSkypeChannel is the BasicChannel implementation for EmailChannel.
func (ec EmailChannel) AsSkypeChannel() (*SkypeChannel, bool) {
	return nil, false
}

// AsKikChannel is the BasicChannel implementation for EmailChannel.
func (ec EmailChannel) AsKikChannel() (*KikChannel, bool) {
	return nil, false
}

// AsWebChatChannel is the BasicChannel implementation for EmailChannel.
func (ec EmailChannel) AsWebChatChannel() (*WebChatChannel, bool) {
	return nil, false
}

// AsDirectLineChannel is the BasicChannel implementation for EmailChannel.
func (ec EmailChannel) AsDirectLineChannel() (*DirectLineChannel, bool) {
	return nil, false
}

// AsTelegramChannel is the BasicChannel implementation for EmailChannel.
func (ec EmailChannel) AsTelegramChannel() (*TelegramChannel, bool) {
	return nil, false
}

// AsSmsChannel is the BasicChannel implementation for EmailChannel.
func (ec EmailChannel) AsSmsChannel() (*SmsChannel, bool) {
	return nil, false
}

// AsSlackChannel is the BasicChannel implementation for EmailChannel.
func (ec EmailChannel) AsSlackChannel() (*SlackChannel, bool) {
	return nil, false
}

// AsChannel is the BasicChannel implementation for EmailChannel.
func (ec EmailChannel) AsChannel() (*Channel, bool) {
	return nil, false
}

// AsBasicChannel is the BasicChannel implementation for EmailChannel.
func (ec EmailChannel) AsBasicChannel() (BasicChannel, bool) {
	return &ec, true
}

// EmailChannelProperties the parameters to provide for the Email channel.
type EmailChannelProperties struct {
	// EmailAddress - The email address
	EmailAddress *string `json:"emailAddress,omitempty"`
	// Password - The password for the email address. Value only returned through POST to the action Channel List API, otherwise empty.
	Password *string `json:"password,omitempty"`
	// IsEnabled - Whether this channel is enabled for the bot
	IsEnabled *bool `json:"isEnabled,omitempty"`
}

// Error bot Service error object.
type Error struct {
	// Error - The error body.
	Error *ErrorBody `json:"error,omitempty"`
}

// ErrorBody bot Service error body.
type ErrorBody struct {
	// Code - error code
	Code *string `json:"code,omitempty"`
	// Message - error message
	Message *string `json:"message,omitempty"`
}

// FacebookChannel facebook channel definition
type FacebookChannel struct {
	// Properties - The set of properties specific to bot facebook channel
	Properties *FacebookChannelProperties `json:"properties,omitempty"`
	// ChannelName - Possible values include: 'ChannelNameChannel', 'ChannelNameFacebookChannel1', 'ChannelNameEmailChannel1', 'ChannelNameMsTeamsChannel1', 'ChannelNameSkypeChannel1', 'ChannelNameKikChannel1', 'ChannelNameWebChatChannel1', 'ChannelNameDirectLineChannel1', 'ChannelNameTelegramChannel1', 'ChannelNameSmsChannel1', 'ChannelNameSlackChannel1'
	ChannelName ChannelNameBasicChannel `json:"channelName,omitempty"`
}

// MarshalJSON is the custom marshaler for FacebookChannel.
func (fc FacebookChannel) MarshalJSON() ([]byte, error) {
	fc.ChannelName = ChannelNameFacebookChannel1
	objectMap := make(map[string]interface{})
	if fc.Properties != nil {
		objectMap["properties"] = fc.Properties
	}
	if fc.ChannelName != "" {
		objectMap["channelName"] = fc.ChannelName
	}
	return json.Marshal(objectMap)
}

// AsFacebookChannel is the BasicChannel implementation for FacebookChannel.
func (fc FacebookChannel) AsFacebookChannel() (*FacebookChannel, bool) {
	return &fc, true
}

// AsEmailChannel is the BasicChannel implementation for FacebookChannel.
func (fc FacebookChannel) AsEmailChannel() (*EmailChannel, bool) {
	return nil, false
}

// AsMsTeamsChannel is the BasicChannel implementation for FacebookChannel.
func (fc FacebookChannel) AsMsTeamsChannel() (*MsTeamsChannel, bool) {
	return nil, false
}

// AsSkypeChannel is the BasicChannel implementation for FacebookChannel.
func (fc FacebookChannel) AsSkypeChannel() (*SkypeChannel, bool) {
	return nil, false
}

// AsKikChannel is the BasicChannel implementation for FacebookChannel.
func (fc FacebookChannel) AsKikChannel() (*KikChannel, bool) {
	return nil, false
}

// AsWebChatChannel is the BasicChannel implementation for FacebookChannel.
func (fc FacebookChannel) AsWebChatChannel() (*WebChatChannel, bool) {
	return nil, false
}

// AsDirectLineChannel is the BasicChannel implementation for FacebookChannel.
func (fc FacebookChannel) AsDirectLineChannel() (*DirectLineChannel, bool) {
	return nil, false
}

// AsTelegramChannel is the BasicChannel implementation for FacebookChannel.
func (fc FacebookChannel) AsTelegramChannel() (*TelegramChannel, bool) {
	return nil, false
}

// AsSmsChannel is the BasicChannel implementation for FacebookChannel.
func (fc FacebookChannel) AsSmsChannel() (*SmsChannel, bool) {
	return nil, false
}

// AsSlackChannel is the BasicChannel implementation for FacebookChannel.
func (fc FacebookChannel) AsSlackChannel() (*SlackChannel, bool) {
	return nil, false
}

// AsChannel is the BasicChannel implementation for FacebookChannel.
func (fc FacebookChannel) AsChannel() (*Channel, bool) {
	return nil, false
}

// AsBasicChannel is the BasicChannel implementation for FacebookChannel.
func (fc FacebookChannel) AsBasicChannel() (BasicChannel, bool) {
	return &fc, true
}

// FacebookChannelProperties the parameters to provide for the Facebook channel.
type FacebookChannelProperties struct {
	// VerifyToken - Verify token. Value only returned through POST to the action Channel List API, otherwise empty.
	VerifyToken *string `json:"verifyToken,omitempty"`
	// Pages - The list of Facebook pages
	Pages *[]FacebookPage `json:"pages,omitempty"`
	// AppID - Facebook application id
	AppID *string `json:"appId,omitempty"`
	// AppSecret - Facebook application secret. Value only returned through POST to the action Channel List API, otherwise empty.
	AppSecret *string `json:"appSecret,omitempty"`
	// CallbackURL - Callback Url
	CallbackURL *string `json:"callbackUrl,omitempty"`
	// IsEnabled - Whether this channel is enabled for the bot
	IsEnabled *bool `json:"isEnabled,omitempty"`
}

// FacebookPage a Facebook page for Facebook channel registration
type FacebookPage struct {
	// ID - Page id
	ID *string `json:"id,omitempty"`
	// AccessToken - Facebook application access token. Value only returned through POST to the action Channel List API, otherwise empty.
	AccessToken *string `json:"accessToken,omitempty"`
}

// KikChannel kik channel definition
type KikChannel struct {
	// Properties - The set of properties specific to Kik channel resource
	Properties *KikChannelProperties `json:"properties,omitempty"`
	// ChannelName - Possible values include: 'ChannelNameChannel', 'ChannelNameFacebookChannel1', 'ChannelNameEmailChannel1', 'ChannelNameMsTeamsChannel1', 'ChannelNameSkypeChannel1', 'ChannelNameKikChannel1', 'ChannelNameWebChatChannel1', 'ChannelNameDirectLineChannel1', 'ChannelNameTelegramChannel1', 'ChannelNameSmsChannel1', 'ChannelNameSlackChannel1'
	ChannelName ChannelNameBasicChannel `json:"channelName,omitempty"`
}

// MarshalJSON is the custom marshaler for KikChannel.
func (kc KikChannel) MarshalJSON() ([]byte, error) {
	kc.ChannelName = ChannelNameKikChannel1
	objectMap := make(map[string]interface{})
	if kc.Properties != nil {
		objectMap["properties"] = kc.Properties
	}
	if kc.ChannelName != "" {
		objectMap["channelName"] = kc.ChannelName
	}
	return json.Marshal(objectMap)
}

// AsFacebookChannel is the BasicChannel implementation for KikChannel.
func (kc KikChannel) AsFacebookChannel() (*FacebookChannel, bool) {
	return nil, false
}

// AsEmailChannel is the BasicChannel implementation for KikChannel.
func (kc KikChannel) AsEmailChannel() (*EmailChannel, bool) {
	return nil, false
}

// AsMsTeamsChannel is the BasicChannel implementation for KikChannel.
func (kc KikChannel) AsMsTeamsChannel() (*MsTeamsChannel, bool) {
	return nil, false
}

// AsSkypeChannel is the BasicChannel implementation for KikChannel.
func (kc KikChannel) AsSkypeChannel() (*SkypeChannel, bool) {
	return nil, false
}

// AsKikChannel is the BasicChannel implementation for KikChannel.
func (kc KikChannel) AsKikChannel() (*KikChannel, bool) {
	return &kc, true
}

// AsWebChatChannel is the BasicChannel implementation for KikChannel.
func (kc KikChannel) AsWebChatChannel() (*WebChatChannel, bool) {
	return nil, false
}

// AsDirectLineChannel is the BasicChannel implementation for KikChannel.
func (kc KikChannel) AsDirectLineChannel() (*DirectLineChannel, bool) {
	return nil, false
}

// AsTelegramChannel is the BasicChannel implementation for KikChannel.
func (kc KikChannel) AsTelegramChannel() (*TelegramChannel, bool) {
	return nil, false
}

// AsSmsChannel is the BasicChannel implementation for KikChannel.
func (kc KikChannel) AsSmsChannel() (*SmsChannel, bool) {
	return nil, false
}

// AsSlackChannel is the BasicChannel implementation for KikChannel.
func (kc KikChannel) AsSlackChannel() (*SlackChannel, bool) {
	return nil, false
}

// AsChannel is the BasicChannel implementation for KikChannel.
func (kc KikChannel) AsChannel() (*Channel, bool) {
	return nil, false
}

// AsBasicChannel is the BasicChannel implementation for KikChannel.
func (kc KikChannel) AsBasicChannel() (BasicChannel, bool) {
	return &kc, true
}

// KikChannelProperties the parameters to provide for the Kik channel.
type KikChannelProperties struct {
	// UserName - The Kik user name
	UserName *string `json:"userName,omitempty"`
	// APIKey - Kik API key. Value only returned through POST to the action Channel List API, otherwise empty.
	APIKey *string `json:"apiKey,omitempty"`
	// IsValidated - Whether this channel is validated for the bot
	IsValidated *bool `json:"isValidated,omitempty"`
	// IsEnabled - Whether this channel is enabled for the bot
	IsEnabled *bool `json:"isEnabled,omitempty"`
}

// MsTeamsChannel microsoft Teams channel definition
type MsTeamsChannel struct {
	// Properties - The set of properties specific to Microsoft Teams channel resource
	Properties *MsTeamsChannelProperties `json:"properties,omitempty"`
	// ChannelName - Possible values include: 'ChannelNameChannel', 'ChannelNameFacebookChannel1', 'ChannelNameEmailChannel1', 'ChannelNameMsTeamsChannel1', 'ChannelNameSkypeChannel1', 'ChannelNameKikChannel1', 'ChannelNameWebChatChannel1', 'ChannelNameDirectLineChannel1', 'ChannelNameTelegramChannel1', 'ChannelNameSmsChannel1', 'ChannelNameSlackChannel1'
	ChannelName ChannelNameBasicChannel `json:"channelName,omitempty"`
}

// MarshalJSON is the custom marshaler for MsTeamsChannel.
func (mtc MsTeamsChannel) MarshalJSON() ([]byte, error) {
	mtc.ChannelName = ChannelNameMsTeamsChannel1
	objectMap := make(map[string]interface{})
	if mtc.Properties != nil {
		objectMap["properties"] = mtc.Properties
	}
	if mtc.ChannelName != "" {
		objectMap["channelName"] = mtc.ChannelName
	}
	return json.Marshal(objectMap)
}

// AsFacebookChannel is the BasicChannel implementation for MsTeamsChannel.
func (mtc MsTeamsChannel) AsFacebookChannel() (*FacebookChannel, bool) {
	return nil, false
}

// AsEmailChannel is the BasicChannel implementation for MsTeamsChannel.
func (mtc MsTeamsChannel) AsEmailChannel() (*EmailChannel, bool) {
	return nil, false
}

// AsMsTeamsChannel is the BasicChannel implementation for MsTeamsChannel.
func (mtc MsTeamsChannel) AsMsTeamsChannel() (*MsTeamsChannel, bool) {
	return &mtc, true
}

// AsSkypeChannel is the BasicChannel implementation for MsTeamsChannel.
func (mtc MsTeamsChannel) AsSkypeChannel() (*SkypeChannel, bool) {
	return nil, false
}

// AsKikChannel is the BasicChannel implementation for MsTeamsChannel.
func (mtc MsTeamsChannel) AsKikChannel() (*KikChannel, bool) {
	return nil, false
}

// AsWebChatChannel is the BasicChannel implementation for MsTeamsChannel.
func (mtc MsTeamsChannel) AsWebChatChannel() (*WebChatChannel, bool) {
	return nil, false
}

// AsDirectLineChannel is the BasicChannel implementation for MsTeamsChannel.
func (mtc MsTeamsChannel) AsDirectLineChannel() (*DirectLineChannel, bool) {
	return nil, false
}

// AsTelegramChannel is the BasicChannel implementation for MsTeamsChannel.
func (mtc MsTeamsChannel) AsTelegramChannel() (*TelegramChannel, bool) {
	return nil, false
}

// AsSmsChannel is the BasicChannel implementation for MsTeamsChannel.
func (mtc MsTeamsChannel) AsSmsChannel() (*SmsChannel, bool) {
	return nil, false
}

// AsSlackChannel is the BasicChannel implementation for MsTeamsChannel.
func (mtc MsTeamsChannel) AsSlackChannel() (*SlackChannel, bool) {
	return nil, false
}

// AsChannel is the BasicChannel implementation for MsTeamsChannel.
func (mtc MsTeamsChannel) AsChannel() (*Channel, bool) {
	return nil, false
}

// AsBasicChannel is the BasicChannel implementation for MsTeamsChannel.
func (mtc MsTeamsChannel) AsBasicChannel() (BasicChannel, bool) {
	return &mtc, true
}

// MsTeamsChannelProperties the parameters to provide for the Microsoft Teams channel.
type MsTeamsChannelProperties struct {
	// EnableMessaging - Enable messaging for Microsoft Teams channel
	EnableMessaging *bool `json:"enableMessaging,omitempty"`
	// EnableMediaCards - Enable media cards for Microsoft Teams channel
	EnableMediaCards *bool `json:"enableMediaCards,omitempty"`
	// EnableVideo - Enable video for Microsoft Teams channel
	EnableVideo *bool `json:"enableVideo,omitempty"`
	// EnableCalling - Enable calling for Microsoft Teams channel
	EnableCalling *bool `json:"enableCalling,omitempty"`
	// CallMode - Enable messaging for Microsoft Teams channel
	CallMode *string `json:"callMode,omitempty"`
	// IsEnabled - Whether this channel is enabled for the bot
	IsEnabled *bool `json:"isEnabled,omitempty"`
}

// OperationDisplayInfo the operation supported by Bot Service Management.
type OperationDisplayInfo struct {
	// Description - The description of the operation.
	Description *string `json:"description,omitempty"`
	// Operation - The action that users can perform, based on their permission level.
	Operation *string `json:"operation,omitempty"`
	// Provider - Service provider: Microsoft Bot Service.
	Provider *string `json:"provider,omitempty"`
	// Resource - Resource on which the operation is performed.
	Resource *string `json:"resource,omitempty"`
}

// OperationEntity the operations supported by Bot Service Management.
type OperationEntity struct {
	// Name - Operation name: {provider}/{resource}/{operation}.
	Name *string `json:"name,omitempty"`
	// Display - The operation supported by Bot Service Management.
	Display *OperationDisplayInfo `json:"display,omitempty"`
	// Origin - The origin of the operation.
	Origin *string `json:"origin,omitempty"`
	// Properties - Additional properties.
	Properties interface{} `json:"properties,omitempty"`
}

// OperationEntityListResult the list of bot service operation response.
type OperationEntityListResult struct {
	autorest.Response `json:"-"`
	// NextLink - The link used to get the next page of operations.
	NextLink *string `json:"nextLink,omitempty"`
	// Value - The list of operations.
	Value *[]OperationEntity `json:"value,omitempty"`
}

// OperationEntityListResultIterator provides access to a complete listing of OperationEntity values.
type OperationEntityListResultIterator struct {
	i    int
	page OperationEntityListResultPage
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *OperationEntityListResultIterator) Next() error {
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err := iter.page.Next()
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter OperationEntityListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter OperationEntityListResultIterator) Response() OperationEntityListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter OperationEntityListResultIterator) Value() OperationEntity {
	if !iter.page.NotDone() {
		return OperationEntity{}
	}
	return iter.page.Values()[iter.i]
}

// IsEmpty returns true if the ListResult contains no values.
func (oelr OperationEntityListResult) IsEmpty() bool {
	return oelr.Value == nil || len(*oelr.Value) == 0
}

// operationEntityListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (oelr OperationEntityListResult) operationEntityListResultPreparer() (*http.Request, error) {
	if oelr.NextLink == nil || len(to.String(oelr.NextLink)) < 1 {
		return nil, nil
	}
	return autorest.Prepare(&http.Request{},
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(oelr.NextLink)))
}

// OperationEntityListResultPage contains a page of OperationEntity values.
type OperationEntityListResultPage struct {
	fn   func(OperationEntityListResult) (OperationEntityListResult, error)
	oelr OperationEntityListResult
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *OperationEntityListResultPage) Next() error {
	next, err := page.fn(page.oelr)
	if err != nil {
		return err
	}
	page.oelr = next
	return nil
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page OperationEntityListResultPage) NotDone() bool {
	return !page.oelr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page OperationEntityListResultPage) Response() OperationEntityListResult {
	return page.oelr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page OperationEntityListResultPage) Values() []OperationEntity {
	if page.oelr.IsEmpty() {
		return nil
	}
	return *page.oelr.Value
}

// Resource azure resource
type Resource struct {
	// ID - Specifies the resource ID.
	ID *string `json:"id,omitempty"`
	// Name - Specifies the name of the resource.
	Name *string `json:"name,omitempty"`
	// Location - Specifies the location of the resource.
	Location *string `json:"location,omitempty"`
	// Type - Specifies the type of the resource.
	Type *string `json:"type,omitempty"`
	// Tags - Contains resource tags defined as key/value pairs.
	Tags map[string]*string `json:"tags"`
	// Sku - Gets or sets the SKU of the resource.
	Sku *Sku `json:"sku,omitempty"`
	// Kind - Required. Gets or sets the Kind of the resource. Possible values include: 'KindSdk', 'KindDesigner', 'KindBot', 'KindFunction'
	Kind Kind `json:"kind,omitempty"`
	// Etag - Entity Tag
	Etag *string `json:"etag,omitempty"`
}

// MarshalJSON is the custom marshaler for Resource.
func (r Resource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if r.ID != nil {
		objectMap["id"] = r.ID
	}
	if r.Name != nil {
		objectMap["name"] = r.Name
	}
	if r.Location != nil {
		objectMap["location"] = r.Location
	}
	if r.Type != nil {
		objectMap["type"] = r.Type
	}
	if r.Tags != nil {
		objectMap["tags"] = r.Tags
	}
	if r.Sku != nil {
		objectMap["sku"] = r.Sku
	}
	if r.Kind != "" {
		objectMap["kind"] = r.Kind
	}
	if r.Etag != nil {
		objectMap["etag"] = r.Etag
	}
	return json.Marshal(objectMap)
}

// Sku the SKU of the cognitive services account.
type Sku struct {
	// Name - The sku name. Possible values include: 'F0', 'S1'
	Name SkuName `json:"name,omitempty"`
	// Tier - Gets the sku tier. This is based on the SKU name. Possible values include: 'Free', 'Standard'
	Tier SkuTier `json:"tier,omitempty"`
}

// SkypeChannel skype channel definition
type SkypeChannel struct {
	// Properties - The set of properties specific to Skype channel resource
	Properties *SkypeChannelProperties `json:"properties,omitempty"`
	// ChannelName - Possible values include: 'ChannelNameChannel', 'ChannelNameFacebookChannel1', 'ChannelNameEmailChannel1', 'ChannelNameMsTeamsChannel1', 'ChannelNameSkypeChannel1', 'ChannelNameKikChannel1', 'ChannelNameWebChatChannel1', 'ChannelNameDirectLineChannel1', 'ChannelNameTelegramChannel1', 'ChannelNameSmsChannel1', 'ChannelNameSlackChannel1'
	ChannelName ChannelNameBasicChannel `json:"channelName,omitempty"`
}

// MarshalJSON is the custom marshaler for SkypeChannel.
func (sc SkypeChannel) MarshalJSON() ([]byte, error) {
	sc.ChannelName = ChannelNameSkypeChannel1
	objectMap := make(map[string]interface{})
	if sc.Properties != nil {
		objectMap["properties"] = sc.Properties
	}
	if sc.ChannelName != "" {
		objectMap["channelName"] = sc.ChannelName
	}
	return json.Marshal(objectMap)
}

// AsFacebookChannel is the BasicChannel implementation for SkypeChannel.
func (sc SkypeChannel) AsFacebookChannel() (*FacebookChannel, bool) {
	return nil, false
}

// AsEmailChannel is the BasicChannel implementation for SkypeChannel.
func (sc SkypeChannel) AsEmailChannel() (*EmailChannel, bool) {
	return nil, false
}

// AsMsTeamsChannel is the BasicChannel implementation for SkypeChannel.
func (sc SkypeChannel) AsMsTeamsChannel() (*MsTeamsChannel, bool) {
	return nil, false
}

// AsSkypeChannel is the BasicChannel implementation for SkypeChannel.
func (sc SkypeChannel) AsSkypeChannel() (*SkypeChannel, bool) {
	return &sc, true
}

// AsKikChannel is the BasicChannel implementation for SkypeChannel.
func (sc SkypeChannel) AsKikChannel() (*KikChannel, bool) {
	return nil, false
}

// AsWebChatChannel is the BasicChannel implementation for SkypeChannel.
func (sc SkypeChannel) AsWebChatChannel() (*WebChatChannel, bool) {
	return nil, false
}

// AsDirectLineChannel is the BasicChannel implementation for SkypeChannel.
func (sc SkypeChannel) AsDirectLineChannel() (*DirectLineChannel, bool) {
	return nil, false
}

// AsTelegramChannel is the BasicChannel implementation for SkypeChannel.
func (sc SkypeChannel) AsTelegramChannel() (*TelegramChannel, bool) {
	return nil, false
}

// AsSmsChannel is the BasicChannel implementation for SkypeChannel.
func (sc SkypeChannel) AsSmsChannel() (*SmsChannel, bool) {
	return nil, false
}

// AsSlackChannel is the BasicChannel implementation for SkypeChannel.
func (sc SkypeChannel) AsSlackChannel() (*SlackChannel, bool) {
	return nil, false
}

// AsChannel is the BasicChannel implementation for SkypeChannel.
func (sc SkypeChannel) AsChannel() (*Channel, bool) {
	return nil, false
}

// AsBasicChannel is the BasicChannel implementation for SkypeChannel.
func (sc SkypeChannel) AsBasicChannel() (BasicChannel, bool) {
	return &sc, true
}

// SkypeChannelProperties the parameters to provide for the Microsoft Teams channel.
type SkypeChannelProperties struct {
	// EnableMessaging - Enable messaging for Skype channel
	EnableMessaging *bool `json:"enableMessaging,omitempty"`
	// EnableMediaCards - Enable media cards for Skype channel
	EnableMediaCards *bool `json:"enableMediaCards,omitempty"`
	// EnableVideo - Enable video for Skype channel
	EnableVideo *bool `json:"enableVideo,omitempty"`
	// EnableCalling - Enable calling for Skype channel
	EnableCalling *bool `json:"enableCalling,omitempty"`
	// EnableScreenSharing - Enable screen sharing for Skype channel
	EnableScreenSharing *bool `json:"enableScreenSharing,omitempty"`
	// EnableGroups - Enable groups for Skype channel
	EnableGroups *bool `json:"enableGroups,omitempty"`
	// GroupsMode - Group mode for Skype channel
	GroupsMode *string `json:"groupsMode,omitempty"`
	// CallingWebHook - Calling web hook for Skype channel
	CallingWebHook *string `json:"callingWebHook,omitempty"`
	// IsEnabled - Whether this channel is enabled for the bot
	IsEnabled *bool `json:"isEnabled,omitempty"`
}

// SlackChannel slack channel definition
type SlackChannel struct {
	// Properties - The set of properties specific to Slack channel resource
	Properties *SlackChannelProperties `json:"properties,omitempty"`
	// ChannelName - Possible values include: 'ChannelNameChannel', 'ChannelNameFacebookChannel1', 'ChannelNameEmailChannel1', 'ChannelNameMsTeamsChannel1', 'ChannelNameSkypeChannel1', 'ChannelNameKikChannel1', 'ChannelNameWebChatChannel1', 'ChannelNameDirectLineChannel1', 'ChannelNameTelegramChannel1', 'ChannelNameSmsChannel1', 'ChannelNameSlackChannel1'
	ChannelName ChannelNameBasicChannel `json:"channelName,omitempty"`
}

// MarshalJSON is the custom marshaler for SlackChannel.
func (sc SlackChannel) MarshalJSON() ([]byte, error) {
	sc.ChannelName = ChannelNameSlackChannel1
	objectMap := make(map[string]interface{})
	if sc.Properties != nil {
		objectMap["properties"] = sc.Properties
	}
	if sc.ChannelName != "" {
		objectMap["channelName"] = sc.ChannelName
	}
	return json.Marshal(objectMap)
}

// AsFacebookChannel is the BasicChannel implementation for SlackChannel.
func (sc SlackChannel) AsFacebookChannel() (*FacebookChannel, bool) {
	return nil, false
}

// AsEmailChannel is the BasicChannel implementation for SlackChannel.
func (sc SlackChannel) AsEmailChannel() (*EmailChannel, bool) {
	return nil, false
}

// AsMsTeamsChannel is the BasicChannel implementation for SlackChannel.
func (sc SlackChannel) AsMsTeamsChannel() (*MsTeamsChannel, bool) {
	return nil, false
}

// AsSkypeChannel is the BasicChannel implementation for SlackChannel.
func (sc SlackChannel) AsSkypeChannel() (*SkypeChannel, bool) {
	return nil, false
}

// AsKikChannel is the BasicChannel implementation for SlackChannel.
func (sc SlackChannel) AsKikChannel() (*KikChannel, bool) {
	return nil, false
}

// AsWebChatChannel is the BasicChannel implementation for SlackChannel.
func (sc SlackChannel) AsWebChatChannel() (*WebChatChannel, bool) {
	return nil, false
}

// AsDirectLineChannel is the BasicChannel implementation for SlackChannel.
func (sc SlackChannel) AsDirectLineChannel() (*DirectLineChannel, bool) {
	return nil, false
}

// AsTelegramChannel is the BasicChannel implementation for SlackChannel.
func (sc SlackChannel) AsTelegramChannel() (*TelegramChannel, bool) {
	return nil, false
}

// AsSmsChannel is the BasicChannel implementation for SlackChannel.
func (sc SlackChannel) AsSmsChannel() (*SmsChannel, bool) {
	return nil, false
}

// AsSlackChannel is the BasicChannel implementation for SlackChannel.
func (sc SlackChannel) AsSlackChannel() (*SlackChannel, bool) {
	return &sc, true
}

// AsChannel is the BasicChannel implementation for SlackChannel.
func (sc SlackChannel) AsChannel() (*Channel, bool) {
	return nil, false
}

// AsBasicChannel is the BasicChannel implementation for SlackChannel.
func (sc SlackChannel) AsBasicChannel() (BasicChannel, bool) {
	return &sc, true
}

// SlackChannelProperties the parameters to provide for the Slack channel.
type SlackChannelProperties struct {
	// ClientID - The Slack client id
	ClientID *string `json:"clientId,omitempty"`
	// ClientSecret - The Slack client secret. Value only returned through POST to the action Channel List API, otherwise empty.
	ClientSecret *string `json:"clientSecret,omitempty"`
	// VerificationToken - The Slack verification token. Value only returned through POST to the action Channel List API, otherwise empty.
	VerificationToken *string `json:"verificationToken,omitempty"`
	// LandingPageURL - The Slack landing page Url
	LandingPageURL *string `json:"landingPageUrl,omitempty"`
	// RedirectAction - The Slack redirect action
	RedirectAction *string `json:"redirectAction,omitempty"`
	// LastSubmissionID - The Sms auth token
	LastSubmissionID *string `json:"lastSubmissionId,omitempty"`
	// RegisterBeforeOAuthFlow - Whether to register the settings before OAuth validation is performed. Recommended to True.
	RegisterBeforeOAuthFlow *bool `json:"registerBeforeOAuthFlow,omitempty"`
	// IsValidated - Whether this channel is validated for the bot
	IsValidated *bool `json:"isValidated,omitempty"`
	// IsEnabled - Whether this channel is enabled for the bot
	IsEnabled *bool `json:"isEnabled,omitempty"`
}

// SmsChannel sms channel definition
type SmsChannel struct {
	// Properties - The set of properties specific to Sms channel resource
	Properties *SmsChannelProperties `json:"properties,omitempty"`
	// ChannelName - Possible values include: 'ChannelNameChannel', 'ChannelNameFacebookChannel1', 'ChannelNameEmailChannel1', 'ChannelNameMsTeamsChannel1', 'ChannelNameSkypeChannel1', 'ChannelNameKikChannel1', 'ChannelNameWebChatChannel1', 'ChannelNameDirectLineChannel1', 'ChannelNameTelegramChannel1', 'ChannelNameSmsChannel1', 'ChannelNameSlackChannel1'
	ChannelName ChannelNameBasicChannel `json:"channelName,omitempty"`
}

// MarshalJSON is the custom marshaler for SmsChannel.
func (sc SmsChannel) MarshalJSON() ([]byte, error) {
	sc.ChannelName = ChannelNameSmsChannel1
	objectMap := make(map[string]interface{})
	if sc.Properties != nil {
		objectMap["properties"] = sc.Properties
	}
	if sc.ChannelName != "" {
		objectMap["channelName"] = sc.ChannelName
	}
	return json.Marshal(objectMap)
}

// AsFacebookChannel is the BasicChannel implementation for SmsChannel.
func (sc SmsChannel) AsFacebookChannel() (*FacebookChannel, bool) {
	return nil, false
}

// AsEmailChannel is the BasicChannel implementation for SmsChannel.
func (sc SmsChannel) AsEmailChannel() (*EmailChannel, bool) {
	return nil, false
}

// AsMsTeamsChannel is the BasicChannel implementation for SmsChannel.
func (sc SmsChannel) AsMsTeamsChannel() (*MsTeamsChannel, bool) {
	return nil, false
}

// AsSkypeChannel is the BasicChannel implementation for SmsChannel.
func (sc SmsChannel) AsSkypeChannel() (*SkypeChannel, bool) {
	return nil, false
}

// AsKikChannel is the BasicChannel implementation for SmsChannel.
func (sc SmsChannel) AsKikChannel() (*KikChannel, bool) {
	return nil, false
}

// AsWebChatChannel is the BasicChannel implementation for SmsChannel.
func (sc SmsChannel) AsWebChatChannel() (*WebChatChannel, bool) {
	return nil, false
}

// AsDirectLineChannel is the BasicChannel implementation for SmsChannel.
func (sc SmsChannel) AsDirectLineChannel() (*DirectLineChannel, bool) {
	return nil, false
}

// AsTelegramChannel is the BasicChannel implementation for SmsChannel.
func (sc SmsChannel) AsTelegramChannel() (*TelegramChannel, bool) {
	return nil, false
}

// AsSmsChannel is the BasicChannel implementation for SmsChannel.
func (sc SmsChannel) AsSmsChannel() (*SmsChannel, bool) {
	return &sc, true
}

// AsSlackChannel is the BasicChannel implementation for SmsChannel.
func (sc SmsChannel) AsSlackChannel() (*SlackChannel, bool) {
	return nil, false
}

// AsChannel is the BasicChannel implementation for SmsChannel.
func (sc SmsChannel) AsChannel() (*Channel, bool) {
	return nil, false
}

// AsBasicChannel is the BasicChannel implementation for SmsChannel.
func (sc SmsChannel) AsBasicChannel() (BasicChannel, bool) {
	return &sc, true
}

// SmsChannelProperties the parameters to provide for the Sms channel.
type SmsChannelProperties struct {
	// Phone - The Sms phone
	Phone *string `json:"phone,omitempty"`
	// AccountSID - The Sms account SID. Value only returned through POST to the action Channel List API, otherwise empty.
	AccountSID *string `json:"accountSID,omitempty"`
	// AuthToken - The Sms auth token. Value only returned through POST to the action Channel List API, otherwise empty.
	AuthToken *string `json:"authToken,omitempty"`
	// IsValidated - Whether this channel is validated for the bot
	IsValidated *bool `json:"isValidated,omitempty"`
	// IsEnabled - Whether this channel is enabled for the bot
	IsEnabled *bool `json:"isEnabled,omitempty"`
}

// TelegramChannel telegram channel definition
type TelegramChannel struct {
	// Properties - The set of properties specific to Telegram channel resource
	Properties *TelegramChannelProperties `json:"properties,omitempty"`
	// ChannelName - Possible values include: 'ChannelNameChannel', 'ChannelNameFacebookChannel1', 'ChannelNameEmailChannel1', 'ChannelNameMsTeamsChannel1', 'ChannelNameSkypeChannel1', 'ChannelNameKikChannel1', 'ChannelNameWebChatChannel1', 'ChannelNameDirectLineChannel1', 'ChannelNameTelegramChannel1', 'ChannelNameSmsChannel1', 'ChannelNameSlackChannel1'
	ChannelName ChannelNameBasicChannel `json:"channelName,omitempty"`
}

// MarshalJSON is the custom marshaler for TelegramChannel.
func (tc TelegramChannel) MarshalJSON() ([]byte, error) {
	tc.ChannelName = ChannelNameTelegramChannel1
	objectMap := make(map[string]interface{})
	if tc.Properties != nil {
		objectMap["properties"] = tc.Properties
	}
	if tc.ChannelName != "" {
		objectMap["channelName"] = tc.ChannelName
	}
	return json.Marshal(objectMap)
}

// AsFacebookChannel is the BasicChannel implementation for TelegramChannel.
func (tc TelegramChannel) AsFacebookChannel() (*FacebookChannel, bool) {
	return nil, false
}

// AsEmailChannel is the BasicChannel implementation for TelegramChannel.
func (tc TelegramChannel) AsEmailChannel() (*EmailChannel, bool) {
	return nil, false
}

// AsMsTeamsChannel is the BasicChannel implementation for TelegramChannel.
func (tc TelegramChannel) AsMsTeamsChannel() (*MsTeamsChannel, bool) {
	return nil, false
}

// AsSkypeChannel is the BasicChannel implementation for TelegramChannel.
func (tc TelegramChannel) AsSkypeChannel() (*SkypeChannel, bool) {
	return nil, false
}

// AsKikChannel is the BasicChannel implementation for TelegramChannel.
func (tc TelegramChannel) AsKikChannel() (*KikChannel, bool) {
	return nil, false
}

// AsWebChatChannel is the BasicChannel implementation for TelegramChannel.
func (tc TelegramChannel) AsWebChatChannel() (*WebChatChannel, bool) {
	return nil, false
}

// AsDirectLineChannel is the BasicChannel implementation for TelegramChannel.
func (tc TelegramChannel) AsDirectLineChannel() (*DirectLineChannel, bool) {
	return nil, false
}

// AsTelegramChannel is the BasicChannel implementation for TelegramChannel.
func (tc TelegramChannel) AsTelegramChannel() (*TelegramChannel, bool) {
	return &tc, true
}

// AsSmsChannel is the BasicChannel implementation for TelegramChannel.
func (tc TelegramChannel) AsSmsChannel() (*SmsChannel, bool) {
	return nil, false
}

// AsSlackChannel is the BasicChannel implementation for TelegramChannel.
func (tc TelegramChannel) AsSlackChannel() (*SlackChannel, bool) {
	return nil, false
}

// AsChannel is the BasicChannel implementation for TelegramChannel.
func (tc TelegramChannel) AsChannel() (*Channel, bool) {
	return nil, false
}

// AsBasicChannel is the BasicChannel implementation for TelegramChannel.
func (tc TelegramChannel) AsBasicChannel() (BasicChannel, bool) {
	return &tc, true
}

// TelegramChannelProperties the parameters to provide for the Telegram channel.
type TelegramChannelProperties struct {
	// AccessToken - The Telegram access token. Value only returned through POST to the action Channel List API, otherwise empty.
	AccessToken *string `json:"accessToken,omitempty"`
	// IsValidated - Whether this channel is validated for the bot
	IsValidated *bool `json:"isValidated,omitempty"`
	// IsEnabled - Whether this channel is enabled for the bot
	IsEnabled *bool `json:"isEnabled,omitempty"`
}

// WebChatChannel web Chat channel definition
type WebChatChannel struct {
	// Properties - The set of properties specific to Web Chat channel resource
	Properties *WebChatChannelProperties `json:"properties,omitempty"`
	// ChannelName - Possible values include: 'ChannelNameChannel', 'ChannelNameFacebookChannel1', 'ChannelNameEmailChannel1', 'ChannelNameMsTeamsChannel1', 'ChannelNameSkypeChannel1', 'ChannelNameKikChannel1', 'ChannelNameWebChatChannel1', 'ChannelNameDirectLineChannel1', 'ChannelNameTelegramChannel1', 'ChannelNameSmsChannel1', 'ChannelNameSlackChannel1'
	ChannelName ChannelNameBasicChannel `json:"channelName,omitempty"`
}

// MarshalJSON is the custom marshaler for WebChatChannel.
func (wcc WebChatChannel) MarshalJSON() ([]byte, error) {
	wcc.ChannelName = ChannelNameWebChatChannel1
	objectMap := make(map[string]interface{})
	if wcc.Properties != nil {
		objectMap["properties"] = wcc.Properties
	}
	if wcc.ChannelName != "" {
		objectMap["channelName"] = wcc.ChannelName
	}
	return json.Marshal(objectMap)
}

// AsFacebookChannel is the BasicChannel implementation for WebChatChannel.
func (wcc WebChatChannel) AsFacebookChannel() (*FacebookChannel, bool) {
	return nil, false
}

// AsEmailChannel is the BasicChannel implementation for WebChatChannel.
func (wcc WebChatChannel) AsEmailChannel() (*EmailChannel, bool) {
	return nil, false
}

// AsMsTeamsChannel is the BasicChannel implementation for WebChatChannel.
func (wcc WebChatChannel) AsMsTeamsChannel() (*MsTeamsChannel, bool) {
	return nil, false
}

// AsSkypeChannel is the BasicChannel implementation for WebChatChannel.
func (wcc WebChatChannel) AsSkypeChannel() (*SkypeChannel, bool) {
	return nil, false
}

// AsKikChannel is the BasicChannel implementation for WebChatChannel.
func (wcc WebChatChannel) AsKikChannel() (*KikChannel, bool) {
	return nil, false
}

// AsWebChatChannel is the BasicChannel implementation for WebChatChannel.
func (wcc WebChatChannel) AsWebChatChannel() (*WebChatChannel, bool) {
	return &wcc, true
}

// AsDirectLineChannel is the BasicChannel implementation for WebChatChannel.
func (wcc WebChatChannel) AsDirectLineChannel() (*DirectLineChannel, bool) {
	return nil, false
}

// AsTelegramChannel is the BasicChannel implementation for WebChatChannel.
func (wcc WebChatChannel) AsTelegramChannel() (*TelegramChannel, bool) {
	return nil, false
}

// AsSmsChannel is the BasicChannel implementation for WebChatChannel.
func (wcc WebChatChannel) AsSmsChannel() (*SmsChannel, bool) {
	return nil, false
}

// AsSlackChannel is the BasicChannel implementation for WebChatChannel.
func (wcc WebChatChannel) AsSlackChannel() (*SlackChannel, bool) {
	return nil, false
}

// AsChannel is the BasicChannel implementation for WebChatChannel.
func (wcc WebChatChannel) AsChannel() (*Channel, bool) {
	return nil, false
}

// AsBasicChannel is the BasicChannel implementation for WebChatChannel.
func (wcc WebChatChannel) AsBasicChannel() (BasicChannel, bool) {
	return &wcc, true
}

// WebChatChannelProperties the parameters to provide for the Web Chat channel.
type WebChatChannelProperties struct {
	// WebChatEmbedCode - Web chat control embed code
	WebChatEmbedCode *string `json:"webChatEmbedCode,omitempty"`
	// Sites - The list of Web Chat sites
	Sites *[]WebChatSite `json:"sites,omitempty"`
}

// WebChatSite a site for the Webchat channel
type WebChatSite struct {
	// SiteID - Site Id
	SiteID *string `json:"siteId,omitempty"`
	// SiteName - Site name
	SiteName *string `json:"siteName,omitempty"`
	// Key - Primary key. Value only returned through POST to the action Channel List API, otherwise empty.
	Key *string `json:"key,omitempty"`
	// Key2 - Secondary key. Value only returned through POST to the action Channel List API, otherwise empty.
	Key2 *string `json:"key2,omitempty"`
	// IsEnabled - Whether this site is enabled for DirectLine channel
	IsEnabled *bool `json:"isEnabled,omitempty"`
	// EnablePreview - Whether this site is enabled for preview versions of Webchat
	EnablePreview *bool `json:"enablePreview,omitempty"`
}
