// Code generated by protoc-gen-go. DO NOT EDIT.
// source: google/ads/googleads/v2/services/mutate_job_service.proto

package services

import (
	context "context"
	fmt "fmt"
	math "math"

	proto "github.com/golang/protobuf/proto"
	resources "google.golang.org/genproto/googleapis/ads/googleads/v2/resources"
	_ "google.golang.org/genproto/googleapis/api/annotations"
	longrunning "google.golang.org/genproto/googleapis/longrunning"
	status "google.golang.org/genproto/googleapis/rpc/status"
	grpc "google.golang.org/grpc"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.ProtoPackageIsVersion3 // please upgrade the proto package

// Request message for [MutateJobService.CreateMutateJobRequest][]
type CreateMutateJobRequest struct {
	// The ID of the customer for which to create a mutate job.
	CustomerId           string   `protobuf:"bytes,1,opt,name=customer_id,json=customerId,proto3" json:"customer_id,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *CreateMutateJobRequest) Reset()         { *m = CreateMutateJobRequest{} }
func (m *CreateMutateJobRequest) String() string { return proto.CompactTextString(m) }
func (*CreateMutateJobRequest) ProtoMessage()    {}
func (*CreateMutateJobRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_af26f119a5b9156e, []int{0}
}

func (m *CreateMutateJobRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_CreateMutateJobRequest.Unmarshal(m, b)
}
func (m *CreateMutateJobRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_CreateMutateJobRequest.Marshal(b, m, deterministic)
}
func (m *CreateMutateJobRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_CreateMutateJobRequest.Merge(m, src)
}
func (m *CreateMutateJobRequest) XXX_Size() int {
	return xxx_messageInfo_CreateMutateJobRequest.Size(m)
}
func (m *CreateMutateJobRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_CreateMutateJobRequest.DiscardUnknown(m)
}

var xxx_messageInfo_CreateMutateJobRequest proto.InternalMessageInfo

func (m *CreateMutateJobRequest) GetCustomerId() string {
	if m != nil {
		return m.CustomerId
	}
	return ""
}

// Response message for [MutateJobService.CreateMutateJobResponse][]
type CreateMutateJobResponse struct {
	// The resource name of the MutateJob.
	ResourceName         string   `protobuf:"bytes,1,opt,name=resource_name,json=resourceName,proto3" json:"resource_name,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *CreateMutateJobResponse) Reset()         { *m = CreateMutateJobResponse{} }
func (m *CreateMutateJobResponse) String() string { return proto.CompactTextString(m) }
func (*CreateMutateJobResponse) ProtoMessage()    {}
func (*CreateMutateJobResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_af26f119a5b9156e, []int{1}
}

func (m *CreateMutateJobResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_CreateMutateJobResponse.Unmarshal(m, b)
}
func (m *CreateMutateJobResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_CreateMutateJobResponse.Marshal(b, m, deterministic)
}
func (m *CreateMutateJobResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_CreateMutateJobResponse.Merge(m, src)
}
func (m *CreateMutateJobResponse) XXX_Size() int {
	return xxx_messageInfo_CreateMutateJobResponse.Size(m)
}
func (m *CreateMutateJobResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_CreateMutateJobResponse.DiscardUnknown(m)
}

var xxx_messageInfo_CreateMutateJobResponse proto.InternalMessageInfo

func (m *CreateMutateJobResponse) GetResourceName() string {
	if m != nil {
		return m.ResourceName
	}
	return ""
}

// Request message for [MutateJobService.GetMutateJob][google.ads.googleads.v2.services.MutateJobService.GetMutateJob]
type GetMutateJobRequest struct {
	// The resource name of the MutateJob to get.
	ResourceName         string   `protobuf:"bytes,1,opt,name=resource_name,json=resourceName,proto3" json:"resource_name,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *GetMutateJobRequest) Reset()         { *m = GetMutateJobRequest{} }
func (m *GetMutateJobRequest) String() string { return proto.CompactTextString(m) }
func (*GetMutateJobRequest) ProtoMessage()    {}
func (*GetMutateJobRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_af26f119a5b9156e, []int{2}
}

func (m *GetMutateJobRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_GetMutateJobRequest.Unmarshal(m, b)
}
func (m *GetMutateJobRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_GetMutateJobRequest.Marshal(b, m, deterministic)
}
func (m *GetMutateJobRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_GetMutateJobRequest.Merge(m, src)
}
func (m *GetMutateJobRequest) XXX_Size() int {
	return xxx_messageInfo_GetMutateJobRequest.Size(m)
}
func (m *GetMutateJobRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_GetMutateJobRequest.DiscardUnknown(m)
}

var xxx_messageInfo_GetMutateJobRequest proto.InternalMessageInfo

func (m *GetMutateJobRequest) GetResourceName() string {
	if m != nil {
		return m.ResourceName
	}
	return ""
}

// Request message for [MutateJobService.RunMutateJob][google.ads.googleads.v2.services.MutateJobService.RunMutateJob]
type RunMutateJobRequest struct {
	// The resource name of the MutateJob to run.
	ResourceName         string   `protobuf:"bytes,1,opt,name=resource_name,json=resourceName,proto3" json:"resource_name,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *RunMutateJobRequest) Reset()         { *m = RunMutateJobRequest{} }
func (m *RunMutateJobRequest) String() string { return proto.CompactTextString(m) }
func (*RunMutateJobRequest) ProtoMessage()    {}
func (*RunMutateJobRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_af26f119a5b9156e, []int{3}
}

func (m *RunMutateJobRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_RunMutateJobRequest.Unmarshal(m, b)
}
func (m *RunMutateJobRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_RunMutateJobRequest.Marshal(b, m, deterministic)
}
func (m *RunMutateJobRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_RunMutateJobRequest.Merge(m, src)
}
func (m *RunMutateJobRequest) XXX_Size() int {
	return xxx_messageInfo_RunMutateJobRequest.Size(m)
}
func (m *RunMutateJobRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_RunMutateJobRequest.DiscardUnknown(m)
}

var xxx_messageInfo_RunMutateJobRequest proto.InternalMessageInfo

func (m *RunMutateJobRequest) GetResourceName() string {
	if m != nil {
		return m.ResourceName
	}
	return ""
}

// Request message for [MutateJobService.AddMutateJobOperations][google.ads.googleads.v2.services.MutateJobService.AddMutateJobOperations]
type AddMutateJobOperationsRequest struct {
	// The resource name of the MutateJob.
	ResourceName string `protobuf:"bytes,1,opt,name=resource_name,json=resourceName,proto3" json:"resource_name,omitempty"`
	// A token used to enforce sequencing.
	//
	// The first AddMutateJobOperations request for a MutateJob should not set
	// sequence_token. Subsequent requests must set sequence_token to the value of
	// next_sequence_token received in the previous AddMutateJobOperations
	// response.
	SequenceToken string `protobuf:"bytes,2,opt,name=sequence_token,json=sequenceToken,proto3" json:"sequence_token,omitempty"`
	// The list of mutates being added.
	//
	// Operations can use negative integers as temp ids to signify dependencies
	// between entities created in this MutateJob. For example, a customer with
	// id = 1234 can create a campaign and an ad group in that same campaign by
	// creating a campaign in the first operation with the resource name
	// explicitly set to "customers/1234/campaigns/-1", and creating an ad group
	// in the second operation with the campaign field also set to
	// "customers/1234/campaigns/-1".
	MutateOperations     []*MutateOperation `protobuf:"bytes,3,rep,name=mutate_operations,json=mutateOperations,proto3" json:"mutate_operations,omitempty"`
	XXX_NoUnkeyedLiteral struct{}           `json:"-"`
	XXX_unrecognized     []byte             `json:"-"`
	XXX_sizecache        int32              `json:"-"`
}

func (m *AddMutateJobOperationsRequest) Reset()         { *m = AddMutateJobOperationsRequest{} }
func (m *AddMutateJobOperationsRequest) String() string { return proto.CompactTextString(m) }
func (*AddMutateJobOperationsRequest) ProtoMessage()    {}
func (*AddMutateJobOperationsRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_af26f119a5b9156e, []int{4}
}

func (m *AddMutateJobOperationsRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_AddMutateJobOperationsRequest.Unmarshal(m, b)
}
func (m *AddMutateJobOperationsRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_AddMutateJobOperationsRequest.Marshal(b, m, deterministic)
}
func (m *AddMutateJobOperationsRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_AddMutateJobOperationsRequest.Merge(m, src)
}
func (m *AddMutateJobOperationsRequest) XXX_Size() int {
	return xxx_messageInfo_AddMutateJobOperationsRequest.Size(m)
}
func (m *AddMutateJobOperationsRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_AddMutateJobOperationsRequest.DiscardUnknown(m)
}

var xxx_messageInfo_AddMutateJobOperationsRequest proto.InternalMessageInfo

func (m *AddMutateJobOperationsRequest) GetResourceName() string {
	if m != nil {
		return m.ResourceName
	}
	return ""
}

func (m *AddMutateJobOperationsRequest) GetSequenceToken() string {
	if m != nil {
		return m.SequenceToken
	}
	return ""
}

func (m *AddMutateJobOperationsRequest) GetMutateOperations() []*MutateOperation {
	if m != nil {
		return m.MutateOperations
	}
	return nil
}

// Response message for [MutateJobService.AddMutateJobOperations][google.ads.googleads.v2.services.MutateJobService.AddMutateJobOperations]
type AddMutateJobOperationsResponse struct {
	// The total number of operations added so far for this job.
	TotalOperations int64 `protobuf:"varint,1,opt,name=total_operations,json=totalOperations,proto3" json:"total_operations,omitempty"`
	// The sequence token to be used when calling AddMutateJobOperations again if
	// more operations need to be added. The next AddMutateJobOperations request
	// must set the sequence_token field to the value of this field.
	NextSequenceToken    string   `protobuf:"bytes,2,opt,name=next_sequence_token,json=nextSequenceToken,proto3" json:"next_sequence_token,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *AddMutateJobOperationsResponse) Reset()         { *m = AddMutateJobOperationsResponse{} }
func (m *AddMutateJobOperationsResponse) String() string { return proto.CompactTextString(m) }
func (*AddMutateJobOperationsResponse) ProtoMessage()    {}
func (*AddMutateJobOperationsResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_af26f119a5b9156e, []int{5}
}

func (m *AddMutateJobOperationsResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_AddMutateJobOperationsResponse.Unmarshal(m, b)
}
func (m *AddMutateJobOperationsResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_AddMutateJobOperationsResponse.Marshal(b, m, deterministic)
}
func (m *AddMutateJobOperationsResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_AddMutateJobOperationsResponse.Merge(m, src)
}
func (m *AddMutateJobOperationsResponse) XXX_Size() int {
	return xxx_messageInfo_AddMutateJobOperationsResponse.Size(m)
}
func (m *AddMutateJobOperationsResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_AddMutateJobOperationsResponse.DiscardUnknown(m)
}

var xxx_messageInfo_AddMutateJobOperationsResponse proto.InternalMessageInfo

func (m *AddMutateJobOperationsResponse) GetTotalOperations() int64 {
	if m != nil {
		return m.TotalOperations
	}
	return 0
}

func (m *AddMutateJobOperationsResponse) GetNextSequenceToken() string {
	if m != nil {
		return m.NextSequenceToken
	}
	return ""
}

// Request message for [MutateJobService.ListMutateJobResults][google.ads.googleads.v2.services.MutateJobService.ListMutateJobResults].
type ListMutateJobResultsRequest struct {
	// The resource name of the MutateJob whose results are being listed.
	ResourceName string `protobuf:"bytes,1,opt,name=resource_name,json=resourceName,proto3" json:"resource_name,omitempty"`
	// Token of the page to retrieve. If not specified, the first
	// page of results will be returned. Use the value obtained from
	// `next_page_token` in the previous response in order to request
	// the next page of results.
	PageToken string `protobuf:"bytes,2,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
	// Number of elements to retrieve in a single page.
	// When a page request is too large, the server may decide to
	// further limit the number of returned resources.
	PageSize             int32    `protobuf:"varint,3,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ListMutateJobResultsRequest) Reset()         { *m = ListMutateJobResultsRequest{} }
func (m *ListMutateJobResultsRequest) String() string { return proto.CompactTextString(m) }
func (*ListMutateJobResultsRequest) ProtoMessage()    {}
func (*ListMutateJobResultsRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_af26f119a5b9156e, []int{6}
}

func (m *ListMutateJobResultsRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ListMutateJobResultsRequest.Unmarshal(m, b)
}
func (m *ListMutateJobResultsRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ListMutateJobResultsRequest.Marshal(b, m, deterministic)
}
func (m *ListMutateJobResultsRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ListMutateJobResultsRequest.Merge(m, src)
}
func (m *ListMutateJobResultsRequest) XXX_Size() int {
	return xxx_messageInfo_ListMutateJobResultsRequest.Size(m)
}
func (m *ListMutateJobResultsRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_ListMutateJobResultsRequest.DiscardUnknown(m)
}

var xxx_messageInfo_ListMutateJobResultsRequest proto.InternalMessageInfo

func (m *ListMutateJobResultsRequest) GetResourceName() string {
	if m != nil {
		return m.ResourceName
	}
	return ""
}

func (m *ListMutateJobResultsRequest) GetPageToken() string {
	if m != nil {
		return m.PageToken
	}
	return ""
}

func (m *ListMutateJobResultsRequest) GetPageSize() int32 {
	if m != nil {
		return m.PageSize
	}
	return 0
}

// Response message for [MutateJobService.ListMutateJobResults][google.ads.googleads.v2.services.MutateJobService.ListMutateJobResults].
type ListMutateJobResultsResponse struct {
	// The list of rows that matched the query.
	Results []*MutateJobResult `protobuf:"bytes,1,rep,name=results,proto3" json:"results,omitempty"`
	// Pagination token used to retrieve the next page of results.
	// Pass the content of this string as the `page_token` attribute of
	// the next request. `next_page_token` is not returned for the last
	// page.
	NextPageToken        string   `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ListMutateJobResultsResponse) Reset()         { *m = ListMutateJobResultsResponse{} }
func (m *ListMutateJobResultsResponse) String() string { return proto.CompactTextString(m) }
func (*ListMutateJobResultsResponse) ProtoMessage()    {}
func (*ListMutateJobResultsResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_af26f119a5b9156e, []int{7}
}

func (m *ListMutateJobResultsResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ListMutateJobResultsResponse.Unmarshal(m, b)
}
func (m *ListMutateJobResultsResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ListMutateJobResultsResponse.Marshal(b, m, deterministic)
}
func (m *ListMutateJobResultsResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ListMutateJobResultsResponse.Merge(m, src)
}
func (m *ListMutateJobResultsResponse) XXX_Size() int {
	return xxx_messageInfo_ListMutateJobResultsResponse.Size(m)
}
func (m *ListMutateJobResultsResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_ListMutateJobResultsResponse.DiscardUnknown(m)
}

var xxx_messageInfo_ListMutateJobResultsResponse proto.InternalMessageInfo

func (m *ListMutateJobResultsResponse) GetResults() []*MutateJobResult {
	if m != nil {
		return m.Results
	}
	return nil
}

func (m *ListMutateJobResultsResponse) GetNextPageToken() string {
	if m != nil {
		return m.NextPageToken
	}
	return ""
}

// MutateJob result.
type MutateJobResult struct {
	// Index of the mutate operation.
	OperationIndex int64 `protobuf:"varint,1,opt,name=operation_index,json=operationIndex,proto3" json:"operation_index,omitempty"`
	// Response for the mutate.
	// May be empty if errors occurred.
	MutateOperationResponse *MutateOperationResponse `protobuf:"bytes,2,opt,name=mutate_operation_response,json=mutateOperationResponse,proto3" json:"mutate_operation_response,omitempty"`
	// Details of the errors when processing the operation.
	Status               *status.Status `protobuf:"bytes,3,opt,name=status,proto3" json:"status,omitempty"`
	XXX_NoUnkeyedLiteral struct{}       `json:"-"`
	XXX_unrecognized     []byte         `json:"-"`
	XXX_sizecache        int32          `json:"-"`
}

func (m *MutateJobResult) Reset()         { *m = MutateJobResult{} }
func (m *MutateJobResult) String() string { return proto.CompactTextString(m) }
func (*MutateJobResult) ProtoMessage()    {}
func (*MutateJobResult) Descriptor() ([]byte, []int) {
	return fileDescriptor_af26f119a5b9156e, []int{8}
}

func (m *MutateJobResult) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_MutateJobResult.Unmarshal(m, b)
}
func (m *MutateJobResult) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_MutateJobResult.Marshal(b, m, deterministic)
}
func (m *MutateJobResult) XXX_Merge(src proto.Message) {
	xxx_messageInfo_MutateJobResult.Merge(m, src)
}
func (m *MutateJobResult) XXX_Size() int {
	return xxx_messageInfo_MutateJobResult.Size(m)
}
func (m *MutateJobResult) XXX_DiscardUnknown() {
	xxx_messageInfo_MutateJobResult.DiscardUnknown(m)
}

var xxx_messageInfo_MutateJobResult proto.InternalMessageInfo

func (m *MutateJobResult) GetOperationIndex() int64 {
	if m != nil {
		return m.OperationIndex
	}
	return 0
}

func (m *MutateJobResult) GetMutateOperationResponse() *MutateOperationResponse {
	if m != nil {
		return m.MutateOperationResponse
	}
	return nil
}

func (m *MutateJobResult) GetStatus() *status.Status {
	if m != nil {
		return m.Status
	}
	return nil
}

func init() {
	proto.RegisterType((*CreateMutateJobRequest)(nil), "google.ads.googleads.v2.services.CreateMutateJobRequest")
	proto.RegisterType((*CreateMutateJobResponse)(nil), "google.ads.googleads.v2.services.CreateMutateJobResponse")
	proto.RegisterType((*GetMutateJobRequest)(nil), "google.ads.googleads.v2.services.GetMutateJobRequest")
	proto.RegisterType((*RunMutateJobRequest)(nil), "google.ads.googleads.v2.services.RunMutateJobRequest")
	proto.RegisterType((*AddMutateJobOperationsRequest)(nil), "google.ads.googleads.v2.services.AddMutateJobOperationsRequest")
	proto.RegisterType((*AddMutateJobOperationsResponse)(nil), "google.ads.googleads.v2.services.AddMutateJobOperationsResponse")
	proto.RegisterType((*ListMutateJobResultsRequest)(nil), "google.ads.googleads.v2.services.ListMutateJobResultsRequest")
	proto.RegisterType((*ListMutateJobResultsResponse)(nil), "google.ads.googleads.v2.services.ListMutateJobResultsResponse")
	proto.RegisterType((*MutateJobResult)(nil), "google.ads.googleads.v2.services.MutateJobResult")
}

func init() {
	proto.RegisterFile("google/ads/googleads/v2/services/mutate_job_service.proto", fileDescriptor_af26f119a5b9156e)
}

var fileDescriptor_af26f119a5b9156e = []byte{
	// 884 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0x9c, 0x56, 0x4d, 0x8f, 0xdb, 0x44,
	0x18, 0xd6, 0x24, 0xa2, 0xb4, 0x93, 0xdd, 0x66, 0x3b, 0x85, 0x6e, 0xf0, 0x76, 0x21, 0x72, 0x0b,
	0x2c, 0x51, 0x65, 0x83, 0x69, 0xa5, 0x66, 0xaa, 0x6d, 0x9b, 0x22, 0xb4, 0xb4, 0x7c, 0xad, 0x1c,
	0xb4, 0x07, 0x14, 0x61, 0x39, 0xf6, 0xc8, 0x32, 0xc4, 0x33, 0xc6, 0x33, 0x5e, 0x55, 0x5d, 0x95,
	0x03, 0xfc, 0x84, 0xfe, 0x02, 0xb8, 0xc1, 0xcf, 0xe0, 0x58, 0x8e, 0x1c, 0x38, 0x71, 0x41, 0x9c,
	0xf8, 0x0d, 0x1c, 0x2a, 0xdb, 0x33, 0x8e, 0x93, 0x75, 0x9a, 0x4d, 0x6e, 0x93, 0xe7, 0xfd, 0x7a,
	0x9e, 0x77, 0xde, 0xbc, 0x63, 0xd8, 0x0f, 0x18, 0x0b, 0x26, 0xc4, 0x74, 0x7d, 0x6e, 0x16, 0xc7,
	0xec, 0x74, 0x6c, 0x99, 0x9c, 0x24, 0xc7, 0xa1, 0x47, 0xb8, 0x19, 0xa5, 0xc2, 0x15, 0xc4, 0xf9,
	0x96, 0x8d, 0x1d, 0x89, 0x19, 0x71, 0xc2, 0x04, 0x43, 0xdd, 0xc2, 0xdf, 0x70, 0x7d, 0x6e, 0x94,
	0xa1, 0xc6, 0xb1, 0x65, 0xa8, 0x50, 0xcd, 0x5a, 0x94, 0x3c, 0x21, 0x9c, 0xa5, 0xc9, 0x6c, 0xf6,
	0x22, 0xab, 0xb6, 0x9c, 0x50, 0x81, 0x3a, 0xae, 0xcf, 0x67, 0x09, 0x69, 0x57, 0x55, 0x68, 0x1c,
	0x9a, 0x2e, 0xa5, 0x4c, 0xb8, 0x22, 0x64, 0x94, 0x4b, 0xeb, 0x35, 0x69, 0x9d, 0x30, 0x1a, 0x24,
	0x29, 0xa5, 0x21, 0x0d, 0x4c, 0x16, 0x93, 0x64, 0xc6, 0x69, 0x5b, 0x3a, 0x25, 0xb1, 0x67, 0x72,
	0xe1, 0x8a, 0x74, 0xde, 0x90, 0xe5, 0xf6, 0x26, 0x21, 0xa1, 0xa2, 0x30, 0xe8, 0x7d, 0x78, 0xe5,
	0xa3, 0x84, 0xb8, 0x82, 0x7c, 0x9e, 0x2b, 0x79, 0xc4, 0xc6, 0x36, 0xf9, 0x3e, 0x25, 0x5c, 0xa0,
	0xb7, 0x60, 0xcb, 0x4b, 0xb9, 0x60, 0x11, 0x49, 0x9c, 0xd0, 0xef, 0x80, 0x2e, 0xd8, 0xbb, 0x60,
	0x43, 0x05, 0x3d, 0xf4, 0xf5, 0xbb, 0x70, 0xfb, 0x54, 0x28, 0x8f, 0x19, 0xe5, 0x04, 0x5d, 0x83,
	0x9b, 0xaa, 0x47, 0x0e, 0x75, 0x23, 0x22, 0xa3, 0x37, 0x14, 0xf8, 0x85, 0x1b, 0x11, 0x1d, 0xc3,
	0xcb, 0x07, 0x44, 0x9c, 0xaa, 0x7b, 0xd6, 0x58, 0x3b, 0xa5, 0xeb, 0xc5, 0xfe, 0x01, 0xe0, 0xee,
	0xc0, 0xf7, 0xcb, 0xe0, 0x2f, 0xcb, 0x2e, 0xae, 0x92, 0x06, 0xbd, 0x0d, 0x2f, 0xf2, 0xcc, 0x9f,
	0x7a, 0xc4, 0x11, 0xec, 0x3b, 0x42, 0x3b, 0x8d, 0xdc, 0x6b, 0x53, 0xa1, 0x5f, 0x65, 0x20, 0xfa,
	0x06, 0x5e, 0x92, 0x43, 0x32, 0xbd, 0xad, 0x4e, 0xb3, 0xdb, 0xdc, 0x6b, 0x59, 0x1f, 0x18, 0xcb,
	0x46, 0xd0, 0x28, 0x48, 0x96, 0x0c, 0xed, 0xad, 0x68, 0x16, 0xe0, 0xfa, 0x09, 0x7c, 0x73, 0x91,
	0x18, 0x79, 0x19, 0xef, 0xc1, 0x2d, 0xc1, 0x84, 0x3b, 0xa9, 0x12, 0xc8, 0x04, 0x35, 0xed, 0x76,
	0x8e, 0x4f, 0x43, 0x90, 0x01, 0x2f, 0x53, 0xf2, 0x58, 0x38, 0xb5, 0xc2, 0x2e, 0x65, 0xa6, 0x61,
	0x55, 0x9c, 0xfe, 0x03, 0xdc, 0xf9, 0x2c, 0xe4, 0xd5, 0x3b, 0xe4, 0xe9, 0x44, 0xac, 0xd6, 0xc7,
	0x5d, 0x08, 0x63, 0x37, 0x98, 0x2d, 0x75, 0x21, 0x43, 0x8a, 0xfe, 0xed, 0xc0, 0xfc, 0x87, 0xc3,
	0xc3, 0x27, 0xa4, 0xd3, 0xec, 0x82, 0xbd, 0x57, 0xec, 0xf3, 0x19, 0x30, 0x0c, 0x9f, 0x10, 0xfd,
	0x19, 0x80, 0x57, 0xeb, 0x09, 0x48, 0xed, 0x9f, 0xc2, 0x57, 0x93, 0x02, 0xea, 0x80, 0xd5, 0x7a,
	0x5e, 0x26, 0xb3, 0x55, 0x06, 0xf4, 0x0e, 0x6c, 0xe7, 0xdd, 0x39, 0x45, 0x77, 0x33, 0x83, 0x0f,
	0x15, 0x65, 0xfd, 0x6f, 0x00, 0xdb, 0x73, 0x49, 0xd0, 0xbb, 0xb0, 0x5d, 0xb6, 0xdf, 0x09, 0xa9,
	0x4f, 0x1e, 0xcb, 0x3b, 0xb8, 0x58, 0xc2, 0x0f, 0x33, 0x14, 0xa5, 0xf0, 0x8d, 0xf9, 0x79, 0x71,
	0x12, 0x29, 0x27, 0x2f, 0xd7, 0xb2, 0xfa, 0xab, 0xcf, 0x8d, 0x4c, 0x60, 0x6f, 0x47, 0xf5, 0x06,
	0xd4, 0x83, 0xe7, 0x8a, 0x85, 0x91, 0xf7, 0xb8, 0x65, 0x21, 0x55, 0x23, 0x89, 0x3d, 0x63, 0x98,
	0x5b, 0x6c, 0xe9, 0x61, 0xfd, 0x74, 0x1e, 0x6e, 0x95, 0xfa, 0x86, 0x45, 0x49, 0xf4, 0x3b, 0x80,
	0xed, 0xb9, 0x75, 0x80, 0x6e, 0x2f, 0x27, 0x5a, 0xbf, 0x7c, 0xb4, 0xfe, 0x1a, 0x91, 0x85, 0x12,
	0x1d, 0xff, 0xf8, 0xe7, 0xbf, 0xcf, 0x1a, 0x37, 0x75, 0x33, 0xdb, 0xba, 0x6a, 0x5d, 0x71, 0xf3,
	0xa4, 0xb2, 0xcc, 0xf6, 0x7b, 0x4f, 0xe5, 0xe6, 0x7e, 0xc4, 0xc6, 0x1c, 0x7b, 0x79, 0x26, 0x0c,
	0x7a, 0xe8, 0x57, 0x00, 0x37, 0xaa, 0x3b, 0x09, 0xdd, 0x5a, 0xce, 0xa3, 0x66, 0x87, 0x69, 0x37,
	0x16, 0x86, 0x95, 0x4f, 0xc7, 0x74, 0xcc, 0xf4, 0x9b, 0x39, 0x63, 0x03, 0xdd, 0xc8, 0x18, 0x9f,
	0xcc, 0xfc, 0x63, 0xf6, 0xa7, 0x02, 0x7a, 0x15, 0xca, 0x66, 0xef, 0x29, 0xfa, 0x0b, 0xc0, 0xd7,
	0xea, 0x66, 0x1f, 0xed, 0x2f, 0xe7, 0xfc, 0x92, 0x3f, 0xad, 0x76, 0x77, 0xdd, 0x70, 0xd9, 0xff,
	0xfb, 0xb9, 0x1a, 0x8c, 0x6e, 0xaf, 0xa2, 0x06, 0x4f, 0x42, 0x2e, 0x94, 0x80, 0x9f, 0x01, 0xdc,
	0xa8, 0x6e, 0xf7, 0xb3, 0xdc, 0x42, 0xcd, 0x6b, 0xa0, 0xed, 0xaa, 0xb0, 0xca, 0x9b, 0x69, 0x94,
	0xa3, 0xaf, 0xdf, 0xc9, 0x89, 0xde, 0xd2, 0xdf, 0x5f, 0x89, 0x68, 0x92, 0xd2, 0x6c, 0x52, 0xfe,
	0x01, 0xf0, 0x4a, 0xfd, 0xde, 0x45, 0xf7, 0x96, 0xb3, 0x7d, 0xe9, 0xf3, 0xa3, 0xdd, 0x5f, 0x3f,
	0x81, 0xbc, 0x83, 0x8f, 0x73, 0x69, 0xf7, 0x74, 0xbc, 0x92, 0x34, 0xd7, 0xf7, 0xa7, 0xb9, 0x30,
	0xe8, 0x69, 0x3b, 0xcf, 0x07, 0x9d, 0x69, 0x7d, 0x79, 0x8a, 0x43, 0x6e, 0x78, 0x2c, 0x7a, 0xf0,
	0x3f, 0x80, 0xd7, 0x3d, 0x16, 0x2d, 0xe5, 0xfa, 0xe0, 0xf5, 0xf9, 0x5d, 0x71, 0x98, 0x7d, 0x79,
	0x1c, 0x82, 0xaf, 0x3f, 0x91, 0xa1, 0x01, 0x9b, 0xb8, 0x34, 0x30, 0x58, 0x12, 0x98, 0x01, 0xa1,
	0xf9, 0x77, 0x89, 0x39, 0x2d, 0xb6, 0xf8, 0x53, 0xea, 0x8e, 0x3a, 0xfc, 0xd2, 0x68, 0x1e, 0x0c,
	0x06, 0xbf, 0x35, 0xba, 0x07, 0x45, 0xc2, 0x81, 0xcf, 0x8d, 0xe2, 0x98, 0x9d, 0x8e, 0x2c, 0x43,
	0x16, 0xe6, 0xcf, 0x95, 0xcb, 0x68, 0xe0, 0xf3, 0x51, 0xe9, 0x32, 0x3a, 0xb2, 0x46, 0xca, 0xe5,
	0xbf, 0xc6, 0xf5, 0x02, 0xc7, 0x78, 0xe0, 0x73, 0x8c, 0x4b, 0x27, 0x8c, 0x8f, 0x2c, 0x8c, 0x95,
	0xdb, 0xf8, 0x5c, 0xce, 0xf3, 0xc3, 0x17, 0x01, 0x00, 0x00, 0xff, 0xff, 0x66, 0x31, 0xf6, 0xb6,
	0x82, 0x0a, 0x00, 0x00,
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConn

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion4

// MutateJobServiceClient is the client API for MutateJobService service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
type MutateJobServiceClient interface {
	// Creates a mutate job.
	CreateMutateJob(ctx context.Context, in *CreateMutateJobRequest, opts ...grpc.CallOption) (*CreateMutateJobResponse, error)
	// Returns the mutate job.
	GetMutateJob(ctx context.Context, in *GetMutateJobRequest, opts ...grpc.CallOption) (*resources.MutateJob, error)
	// Returns the results of the mutate job. The job must be done.
	// Supports standard list paging.
	ListMutateJobResults(ctx context.Context, in *ListMutateJobResultsRequest, opts ...grpc.CallOption) (*ListMutateJobResultsResponse, error)
	// Runs the mutate job.
	//
	// The Operation.metadata field type is MutateJobMetadata. When finished, the
	// long running operation will not contain errors or a response. Instead, use
	// ListMutateJobResults to get the results of the job.
	RunMutateJob(ctx context.Context, in *RunMutateJobRequest, opts ...grpc.CallOption) (*longrunning.Operation, error)
	// Add operations to the mutate job.
	AddMutateJobOperations(ctx context.Context, in *AddMutateJobOperationsRequest, opts ...grpc.CallOption) (*AddMutateJobOperationsResponse, error)
}

type mutateJobServiceClient struct {
	cc *grpc.ClientConn
}

func NewMutateJobServiceClient(cc *grpc.ClientConn) MutateJobServiceClient {
	return &mutateJobServiceClient{cc}
}

func (c *mutateJobServiceClient) CreateMutateJob(ctx context.Context, in *CreateMutateJobRequest, opts ...grpc.CallOption) (*CreateMutateJobResponse, error) {
	out := new(CreateMutateJobResponse)
	err := c.cc.Invoke(ctx, "/google.ads.googleads.v2.services.MutateJobService/CreateMutateJob", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *mutateJobServiceClient) GetMutateJob(ctx context.Context, in *GetMutateJobRequest, opts ...grpc.CallOption) (*resources.MutateJob, error) {
	out := new(resources.MutateJob)
	err := c.cc.Invoke(ctx, "/google.ads.googleads.v2.services.MutateJobService/GetMutateJob", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *mutateJobServiceClient) ListMutateJobResults(ctx context.Context, in *ListMutateJobResultsRequest, opts ...grpc.CallOption) (*ListMutateJobResultsResponse, error) {
	out := new(ListMutateJobResultsResponse)
	err := c.cc.Invoke(ctx, "/google.ads.googleads.v2.services.MutateJobService/ListMutateJobResults", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *mutateJobServiceClient) RunMutateJob(ctx context.Context, in *RunMutateJobRequest, opts ...grpc.CallOption) (*longrunning.Operation, error) {
	out := new(longrunning.Operation)
	err := c.cc.Invoke(ctx, "/google.ads.googleads.v2.services.MutateJobService/RunMutateJob", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *mutateJobServiceClient) AddMutateJobOperations(ctx context.Context, in *AddMutateJobOperationsRequest, opts ...grpc.CallOption) (*AddMutateJobOperationsResponse, error) {
	out := new(AddMutateJobOperationsResponse)
	err := c.cc.Invoke(ctx, "/google.ads.googleads.v2.services.MutateJobService/AddMutateJobOperations", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// MutateJobServiceServer is the server API for MutateJobService service.
type MutateJobServiceServer interface {
	// Creates a mutate job.
	CreateMutateJob(context.Context, *CreateMutateJobRequest) (*CreateMutateJobResponse, error)
	// Returns the mutate job.
	GetMutateJob(context.Context, *GetMutateJobRequest) (*resources.MutateJob, error)
	// Returns the results of the mutate job. The job must be done.
	// Supports standard list paging.
	ListMutateJobResults(context.Context, *ListMutateJobResultsRequest) (*ListMutateJobResultsResponse, error)
	// Runs the mutate job.
	//
	// The Operation.metadata field type is MutateJobMetadata. When finished, the
	// long running operation will not contain errors or a response. Instead, use
	// ListMutateJobResults to get the results of the job.
	RunMutateJob(context.Context, *RunMutateJobRequest) (*longrunning.Operation, error)
	// Add operations to the mutate job.
	AddMutateJobOperations(context.Context, *AddMutateJobOperationsRequest) (*AddMutateJobOperationsResponse, error)
}

func RegisterMutateJobServiceServer(s *grpc.Server, srv MutateJobServiceServer) {
	s.RegisterService(&_MutateJobService_serviceDesc, srv)
}

func _MutateJobService_CreateMutateJob_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateMutateJobRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(MutateJobServiceServer).CreateMutateJob(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.ads.googleads.v2.services.MutateJobService/CreateMutateJob",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(MutateJobServiceServer).CreateMutateJob(ctx, req.(*CreateMutateJobRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _MutateJobService_GetMutateJob_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetMutateJobRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(MutateJobServiceServer).GetMutateJob(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.ads.googleads.v2.services.MutateJobService/GetMutateJob",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(MutateJobServiceServer).GetMutateJob(ctx, req.(*GetMutateJobRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _MutateJobService_ListMutateJobResults_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListMutateJobResultsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(MutateJobServiceServer).ListMutateJobResults(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.ads.googleads.v2.services.MutateJobService/ListMutateJobResults",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(MutateJobServiceServer).ListMutateJobResults(ctx, req.(*ListMutateJobResultsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _MutateJobService_RunMutateJob_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(RunMutateJobRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(MutateJobServiceServer).RunMutateJob(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.ads.googleads.v2.services.MutateJobService/RunMutateJob",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(MutateJobServiceServer).RunMutateJob(ctx, req.(*RunMutateJobRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _MutateJobService_AddMutateJobOperations_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(AddMutateJobOperationsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(MutateJobServiceServer).AddMutateJobOperations(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.ads.googleads.v2.services.MutateJobService/AddMutateJobOperations",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(MutateJobServiceServer).AddMutateJobOperations(ctx, req.(*AddMutateJobOperationsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _MutateJobService_serviceDesc = grpc.ServiceDesc{
	ServiceName: "google.ads.googleads.v2.services.MutateJobService",
	HandlerType: (*MutateJobServiceServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "CreateMutateJob",
			Handler:    _MutateJobService_CreateMutateJob_Handler,
		},
		{
			MethodName: "GetMutateJob",
			Handler:    _MutateJobService_GetMutateJob_Handler,
		},
		{
			MethodName: "ListMutateJobResults",
			Handler:    _MutateJobService_ListMutateJobResults_Handler,
		},
		{
			MethodName: "RunMutateJob",
			Handler:    _MutateJobService_RunMutateJob_Handler,
		},
		{
			MethodName: "AddMutateJobOperations",
			Handler:    _MutateJobService_AddMutateJobOperations_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/ads/googleads/v2/services/mutate_job_service.proto",
}
