// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package applicationdiscoveryservice

import (
	"context"
	"fmt"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type DescribeAgentsInput struct {
	_ struct{} `type:"structure"`

	// The agent or the Connector IDs for which you want information. If you specify
	// no IDs, the system returns information about all agents/Connectors associated
	// with your AWS user account.
	AgentIds []string `locationName:"agentIds" type:"list"`

	// You can filter the request using various logical operators and a key-value
	// format. For example:
	//
	// {"key": "collectionStatus", "value": "STARTED"}
	Filters []Filter `locationName:"filters" type:"list"`

	// The total number of agents/Connectors to return in a single page of output.
	// The maximum value is 100.
	MaxResults *int64 `locationName:"maxResults" type:"integer"`

	// Token to retrieve the next set of results. For example, if you previously
	// specified 100 IDs for DescribeAgentsRequest$agentIds but set DescribeAgentsRequest$maxResults
	// to 10, you received a set of 10 results along with a token. Use that token
	// in this query to get the next set of 10.
	NextToken *string `locationName:"nextToken" type:"string"`
}

// String returns the string representation
func (s DescribeAgentsInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeAgentsInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "DescribeAgentsInput"}
	if s.Filters != nil {
		for i, v := range s.Filters {
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Filters", i), err.(aws.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type DescribeAgentsOutput struct {
	_ struct{} `type:"structure"`

	// Lists agents or the Connector by ID or lists all agents/Connectors associated
	// with your user account if you did not specify an agent/Connector ID. The
	// output includes agent/Connector IDs, IP addresses, media access control (MAC)
	// addresses, agent/Connector health, host name where the agent/Connector resides,
	// and the version number of each agent/Connector.
	AgentsInfo []AgentInfo `locationName:"agentsInfo" type:"list"`

	// Token to retrieve the next set of results. For example, if you specified
	// 100 IDs for DescribeAgentsRequest$agentIds but set DescribeAgentsRequest$maxResults
	// to 10, you received a set of 10 results along with this token. Use this token
	// in the next query to retrieve the next set of 10.
	NextToken *string `locationName:"nextToken" type:"string"`
}

// String returns the string representation
func (s DescribeAgentsOutput) String() string {
	return awsutil.Prettify(s)
}

const opDescribeAgents = "DescribeAgents"

// DescribeAgentsRequest returns a request value for making API operation for
// AWS Application Discovery Service.
//
// Lists agents or connectors as specified by ID or other filters. All agents/connectors
// associated with your user account can be listed if you call DescribeAgents
// as is without passing any parameters.
//
//    // Example sending a request using DescribeAgentsRequest.
//    req := client.DescribeAgentsRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/discovery-2015-11-01/DescribeAgents
func (c *Client) DescribeAgentsRequest(input *DescribeAgentsInput) DescribeAgentsRequest {
	op := &aws.Operation{
		Name:       opDescribeAgents,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeAgentsInput{}
	}

	req := c.newRequest(op, input, &DescribeAgentsOutput{})
	return DescribeAgentsRequest{Request: req, Input: input, Copy: c.DescribeAgentsRequest}
}

// DescribeAgentsRequest is the request type for the
// DescribeAgents API operation.
type DescribeAgentsRequest struct {
	*aws.Request
	Input *DescribeAgentsInput
	Copy  func(*DescribeAgentsInput) DescribeAgentsRequest
}

// Send marshals and sends the DescribeAgents API request.
func (r DescribeAgentsRequest) Send(ctx context.Context) (*DescribeAgentsResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &DescribeAgentsResponse{
		DescribeAgentsOutput: r.Request.Data.(*DescribeAgentsOutput),
		response:             &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// DescribeAgentsResponse is the response type for the
// DescribeAgents API operation.
type DescribeAgentsResponse struct {
	*DescribeAgentsOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// DescribeAgents request.
func (r *DescribeAgentsResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
