// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package appmesh

import (
	"fmt"
	"time"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
)

var _ aws.Config
var _ = awsutil.Prettify

// An object that represents the access logging information for a virtual node.
type AccessLog struct {
	_ struct{} `type:"structure"`

	// An object that represents an access log file.
	File *FileAccessLog `locationName:"file" type:"structure"`
}

// String returns the string representation
func (s AccessLog) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AccessLog) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "AccessLog"}
	if s.File != nil {
		if err := s.File.Validate(); err != nil {
			invalidParams.AddNested("File", err.(aws.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s AccessLog) MarshalFields(e protocol.FieldEncoder) error {
	if s.File != nil {
		v := s.File

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "file", v, metadata)
	}
	return nil
}

// An object that represents the AWS Cloud Map attribute information for your
// virtual node.
type AwsCloudMapInstanceAttribute struct {
	_ struct{} `type:"structure"`

	// Key is a required field
	Key *string `locationName:"key" min:"1" type:"string" required:"true"`

	// Value is a required field
	Value *string `locationName:"value" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s AwsCloudMapInstanceAttribute) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AwsCloudMapInstanceAttribute) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "AwsCloudMapInstanceAttribute"}

	if s.Key == nil {
		invalidParams.Add(aws.NewErrParamRequired("Key"))
	}
	if s.Key != nil && len(*s.Key) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("Key", 1))
	}

	if s.Value == nil {
		invalidParams.Add(aws.NewErrParamRequired("Value"))
	}
	if s.Value != nil && len(*s.Value) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("Value", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s AwsCloudMapInstanceAttribute) MarshalFields(e protocol.FieldEncoder) error {
	if s.Key != nil {
		v := *s.Key

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "key", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Value != nil {
		v := *s.Value

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "value", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// An object that represents the AWS Cloud Map service discovery information
// for your virtual node.
type AwsCloudMapServiceDiscovery struct {
	_ struct{} `type:"structure"`

	Attributes []AwsCloudMapInstanceAttribute `locationName:"attributes" type:"list"`

	// NamespaceName is a required field
	NamespaceName *string `locationName:"namespaceName" min:"1" type:"string" required:"true"`

	// ServiceName is a required field
	ServiceName *string `locationName:"serviceName" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s AwsCloudMapServiceDiscovery) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AwsCloudMapServiceDiscovery) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "AwsCloudMapServiceDiscovery"}

	if s.NamespaceName == nil {
		invalidParams.Add(aws.NewErrParamRequired("NamespaceName"))
	}
	if s.NamespaceName != nil && len(*s.NamespaceName) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("NamespaceName", 1))
	}

	if s.ServiceName == nil {
		invalidParams.Add(aws.NewErrParamRequired("ServiceName"))
	}
	if s.ServiceName != nil && len(*s.ServiceName) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("ServiceName", 1))
	}
	if s.Attributes != nil {
		for i, v := range s.Attributes {
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Attributes", i), err.(aws.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s AwsCloudMapServiceDiscovery) MarshalFields(e protocol.FieldEncoder) error {
	if s.Attributes != nil {
		v := s.Attributes

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "attributes", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	if s.NamespaceName != nil {
		v := *s.NamespaceName

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "namespaceName", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.ServiceName != nil {
		v := *s.ServiceName

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "serviceName", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// An object that represents the backends that a virtual node is expected to
// send outbound traffic to.
type Backend struct {
	_ struct{} `type:"structure"`

	// An object that represents a virtual service backend for a virtual node.
	VirtualService *VirtualServiceBackend `locationName:"virtualService" type:"structure"`
}

// String returns the string representation
func (s Backend) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Backend) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "Backend"}
	if s.VirtualService != nil {
		if err := s.VirtualService.Validate(); err != nil {
			invalidParams.AddNested("VirtualService", err.(aws.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s Backend) MarshalFields(e protocol.FieldEncoder) error {
	if s.VirtualService != nil {
		v := s.VirtualService

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "virtualService", v, metadata)
	}
	return nil
}

// An object that represents the DNS service discovery information for your
// virtual node.
type DnsServiceDiscovery struct {
	_ struct{} `type:"structure"`

	// Hostname is a required field
	Hostname *string `locationName:"hostname" type:"string" required:"true"`
}

// String returns the string representation
func (s DnsServiceDiscovery) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DnsServiceDiscovery) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "DnsServiceDiscovery"}

	if s.Hostname == nil {
		invalidParams.Add(aws.NewErrParamRequired("Hostname"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s DnsServiceDiscovery) MarshalFields(e protocol.FieldEncoder) error {
	if s.Hostname != nil {
		v := *s.Hostname

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "hostname", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// An object that represents a duration of time.
type Duration struct {
	_ struct{} `type:"structure"`

	Unit DurationUnit `locationName:"unit" type:"string" enum:"true"`

	Value *int64 `locationName:"value" type:"long"`
}

// String returns the string representation
func (s Duration) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s Duration) MarshalFields(e protocol.FieldEncoder) error {
	if len(s.Unit) > 0 {
		v := s.Unit

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "unit", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	if s.Value != nil {
		v := *s.Value

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "value", protocol.Int64Value(v), metadata)
	}
	return nil
}

// An object that represents the egress filter rules for a service mesh.
type EgressFilter struct {
	_ struct{} `type:"structure"`

	// Type is a required field
	Type EgressFilterType `locationName:"type" type:"string" required:"true" enum:"true"`
}

// String returns the string representation
func (s EgressFilter) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *EgressFilter) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "EgressFilter"}
	if len(s.Type) == 0 {
		invalidParams.Add(aws.NewErrParamRequired("Type"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s EgressFilter) MarshalFields(e protocol.FieldEncoder) error {
	if len(s.Type) > 0 {
		v := s.Type

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "type", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	return nil
}

// An object that represents an access log file.
type FileAccessLog struct {
	_ struct{} `type:"structure"`

	// Path is a required field
	Path *string `locationName:"path" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s FileAccessLog) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *FileAccessLog) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "FileAccessLog"}

	if s.Path == nil {
		invalidParams.Add(aws.NewErrParamRequired("Path"))
	}
	if s.Path != nil && len(*s.Path) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("Path", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s FileAccessLog) MarshalFields(e protocol.FieldEncoder) error {
	if s.Path != nil {
		v := *s.Path

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "path", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// An object that represents a retry policy. Specify at least one value for
// at least one of the types of RetryEvents, a value for maxRetries, and a value
// for perRetryTimeout.
type GrpcRetryPolicy struct {
	_ struct{} `type:"structure"`

	GrpcRetryEvents []GrpcRetryPolicyEvent `locationName:"grpcRetryEvents" min:"1" type:"list"`

	HttpRetryEvents []string `locationName:"httpRetryEvents" min:"1" type:"list"`

	// MaxRetries is a required field
	MaxRetries *int64 `locationName:"maxRetries" type:"long" required:"true"`

	// An object that represents a duration of time.
	//
	// PerRetryTimeout is a required field
	PerRetryTimeout *Duration `locationName:"perRetryTimeout" type:"structure" required:"true"`

	TcpRetryEvents []TcpRetryPolicyEvent `locationName:"tcpRetryEvents" min:"1" type:"list"`
}

// String returns the string representation
func (s GrpcRetryPolicy) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GrpcRetryPolicy) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "GrpcRetryPolicy"}
	if s.GrpcRetryEvents != nil && len(s.GrpcRetryEvents) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("GrpcRetryEvents", 1))
	}
	if s.HttpRetryEvents != nil && len(s.HttpRetryEvents) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("HttpRetryEvents", 1))
	}

	if s.MaxRetries == nil {
		invalidParams.Add(aws.NewErrParamRequired("MaxRetries"))
	}

	if s.PerRetryTimeout == nil {
		invalidParams.Add(aws.NewErrParamRequired("PerRetryTimeout"))
	}
	if s.TcpRetryEvents != nil && len(s.TcpRetryEvents) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("TcpRetryEvents", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s GrpcRetryPolicy) MarshalFields(e protocol.FieldEncoder) error {
	if s.GrpcRetryEvents != nil {
		v := s.GrpcRetryEvents

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "grpcRetryEvents", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddValue(protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v1)})
		}
		ls0.End()

	}
	if s.HttpRetryEvents != nil {
		v := s.HttpRetryEvents

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "httpRetryEvents", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddValue(protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v1)})
		}
		ls0.End()

	}
	if s.MaxRetries != nil {
		v := *s.MaxRetries

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "maxRetries", protocol.Int64Value(v), metadata)
	}
	if s.PerRetryTimeout != nil {
		v := s.PerRetryTimeout

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "perRetryTimeout", v, metadata)
	}
	if s.TcpRetryEvents != nil {
		v := s.TcpRetryEvents

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "tcpRetryEvents", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddValue(protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v1)})
		}
		ls0.End()

	}
	return nil
}

// An object that represents a GRPC route type.
type GrpcRoute struct {
	_ struct{} `type:"structure"`

	// An object that represents the action to take if a match is determined.
	//
	// Action is a required field
	Action *GrpcRouteAction `locationName:"action" type:"structure" required:"true"`

	// An object that represents the criteria for determining a request match.
	//
	// Match is a required field
	Match *GrpcRouteMatch `locationName:"match" type:"structure" required:"true"`

	// An object that represents a retry policy. Specify at least one value for
	// at least one of the types of RetryEvents, a value for maxRetries, and a value
	// for perRetryTimeout.
	RetryPolicy *GrpcRetryPolicy `locationName:"retryPolicy" type:"structure"`
}

// String returns the string representation
func (s GrpcRoute) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GrpcRoute) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "GrpcRoute"}

	if s.Action == nil {
		invalidParams.Add(aws.NewErrParamRequired("Action"))
	}

	if s.Match == nil {
		invalidParams.Add(aws.NewErrParamRequired("Match"))
	}
	if s.Action != nil {
		if err := s.Action.Validate(); err != nil {
			invalidParams.AddNested("Action", err.(aws.ErrInvalidParams))
		}
	}
	if s.Match != nil {
		if err := s.Match.Validate(); err != nil {
			invalidParams.AddNested("Match", err.(aws.ErrInvalidParams))
		}
	}
	if s.RetryPolicy != nil {
		if err := s.RetryPolicy.Validate(); err != nil {
			invalidParams.AddNested("RetryPolicy", err.(aws.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s GrpcRoute) MarshalFields(e protocol.FieldEncoder) error {
	if s.Action != nil {
		v := s.Action

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "action", v, metadata)
	}
	if s.Match != nil {
		v := s.Match

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "match", v, metadata)
	}
	if s.RetryPolicy != nil {
		v := s.RetryPolicy

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "retryPolicy", v, metadata)
	}
	return nil
}

// An object that represents the action to take if a match is determined.
type GrpcRouteAction struct {
	_ struct{} `type:"structure"`

	// WeightedTargets is a required field
	WeightedTargets []WeightedTarget `locationName:"weightedTargets" min:"1" type:"list" required:"true"`
}

// String returns the string representation
func (s GrpcRouteAction) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GrpcRouteAction) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "GrpcRouteAction"}

	if s.WeightedTargets == nil {
		invalidParams.Add(aws.NewErrParamRequired("WeightedTargets"))
	}
	if s.WeightedTargets != nil && len(s.WeightedTargets) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("WeightedTargets", 1))
	}
	if s.WeightedTargets != nil {
		for i, v := range s.WeightedTargets {
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "WeightedTargets", i), err.(aws.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s GrpcRouteAction) MarshalFields(e protocol.FieldEncoder) error {
	if s.WeightedTargets != nil {
		v := s.WeightedTargets

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "weightedTargets", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	return nil
}

// An object that represents the criteria for determining a request match.
type GrpcRouteMatch struct {
	_ struct{} `type:"structure"`

	Metadata []GrpcRouteMetadata `locationName:"metadata" min:"1" type:"list"`

	MethodName *string `locationName:"methodName" min:"1" type:"string"`

	ServiceName *string `locationName:"serviceName" type:"string"`
}

// String returns the string representation
func (s GrpcRouteMatch) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GrpcRouteMatch) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "GrpcRouteMatch"}
	if s.Metadata != nil && len(s.Metadata) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("Metadata", 1))
	}
	if s.MethodName != nil && len(*s.MethodName) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("MethodName", 1))
	}
	if s.Metadata != nil {
		for i, v := range s.Metadata {
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Metadata", i), err.(aws.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s GrpcRouteMatch) MarshalFields(e protocol.FieldEncoder) error {
	if s.Metadata != nil {
		v := s.Metadata

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "metadata", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	if s.MethodName != nil {
		v := *s.MethodName

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "methodName", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.ServiceName != nil {
		v := *s.ServiceName

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "serviceName", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// An object that represents the match metadata for the route.
type GrpcRouteMetadata struct {
	_ struct{} `type:"structure"`

	Invert *bool `locationName:"invert" type:"boolean"`

	// An object that represents the match method. Specify one of the match values.
	Match *GrpcRouteMetadataMatchMethod `locationName:"match" type:"structure"`

	// Name is a required field
	Name *string `locationName:"name" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s GrpcRouteMetadata) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GrpcRouteMetadata) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "GrpcRouteMetadata"}

	if s.Name == nil {
		invalidParams.Add(aws.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("Name", 1))
	}
	if s.Match != nil {
		if err := s.Match.Validate(); err != nil {
			invalidParams.AddNested("Match", err.(aws.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s GrpcRouteMetadata) MarshalFields(e protocol.FieldEncoder) error {
	if s.Invert != nil {
		v := *s.Invert

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "invert", protocol.BoolValue(v), metadata)
	}
	if s.Match != nil {
		v := s.Match

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "match", v, metadata)
	}
	if s.Name != nil {
		v := *s.Name

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "name", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// An object that represents the match method. Specify one of the match values.
type GrpcRouteMetadataMatchMethod struct {
	_ struct{} `type:"structure"`

	Exact *string `locationName:"exact" min:"1" type:"string"`

	Prefix *string `locationName:"prefix" min:"1" type:"string"`

	// An object that represents the range of values to match on. The first character
	// of the range is included in the range, though the last character is not.
	// For example, if the range specified were 1-100, only values 1-99 would be
	// matched.
	Range *MatchRange `locationName:"range" type:"structure"`

	Regex *string `locationName:"regex" min:"1" type:"string"`

	Suffix *string `locationName:"suffix" min:"1" type:"string"`
}

// String returns the string representation
func (s GrpcRouteMetadataMatchMethod) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GrpcRouteMetadataMatchMethod) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "GrpcRouteMetadataMatchMethod"}
	if s.Exact != nil && len(*s.Exact) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("Exact", 1))
	}
	if s.Prefix != nil && len(*s.Prefix) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("Prefix", 1))
	}
	if s.Regex != nil && len(*s.Regex) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("Regex", 1))
	}
	if s.Suffix != nil && len(*s.Suffix) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("Suffix", 1))
	}
	if s.Range != nil {
		if err := s.Range.Validate(); err != nil {
			invalidParams.AddNested("Range", err.(aws.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s GrpcRouteMetadataMatchMethod) MarshalFields(e protocol.FieldEncoder) error {
	if s.Exact != nil {
		v := *s.Exact

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "exact", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Prefix != nil {
		v := *s.Prefix

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "prefix", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Range != nil {
		v := s.Range

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "range", v, metadata)
	}
	if s.Regex != nil {
		v := *s.Regex

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "regex", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Suffix != nil {
		v := *s.Suffix

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "suffix", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// An object that represents the method and value to match with the header value
// sent in a request. Specify one match method.
type HeaderMatchMethod struct {
	_ struct{} `type:"structure"`

	Exact *string `locationName:"exact" min:"1" type:"string"`

	Prefix *string `locationName:"prefix" min:"1" type:"string"`

	// An object that represents the range of values to match on. The first character
	// of the range is included in the range, though the last character is not.
	// For example, if the range specified were 1-100, only values 1-99 would be
	// matched.
	Range *MatchRange `locationName:"range" type:"structure"`

	Regex *string `locationName:"regex" min:"1" type:"string"`

	Suffix *string `locationName:"suffix" min:"1" type:"string"`
}

// String returns the string representation
func (s HeaderMatchMethod) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *HeaderMatchMethod) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "HeaderMatchMethod"}
	if s.Exact != nil && len(*s.Exact) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("Exact", 1))
	}
	if s.Prefix != nil && len(*s.Prefix) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("Prefix", 1))
	}
	if s.Regex != nil && len(*s.Regex) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("Regex", 1))
	}
	if s.Suffix != nil && len(*s.Suffix) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("Suffix", 1))
	}
	if s.Range != nil {
		if err := s.Range.Validate(); err != nil {
			invalidParams.AddNested("Range", err.(aws.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s HeaderMatchMethod) MarshalFields(e protocol.FieldEncoder) error {
	if s.Exact != nil {
		v := *s.Exact

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "exact", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Prefix != nil {
		v := *s.Prefix

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "prefix", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Range != nil {
		v := s.Range

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "range", v, metadata)
	}
	if s.Regex != nil {
		v := *s.Regex

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "regex", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Suffix != nil {
		v := *s.Suffix

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "suffix", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// An object that represents the health check policy for a virtual node's listener.
type HealthCheckPolicy struct {
	_ struct{} `type:"structure"`

	// HealthyThreshold is a required field
	HealthyThreshold *int64 `locationName:"healthyThreshold" min:"2" type:"integer" required:"true"`

	// IntervalMillis is a required field
	IntervalMillis *int64 `locationName:"intervalMillis" min:"5000" type:"long" required:"true"`

	Path *string `locationName:"path" type:"string"`

	Port *int64 `locationName:"port" min:"1" type:"integer"`

	// Protocol is a required field
	Protocol PortProtocol `locationName:"protocol" type:"string" required:"true" enum:"true"`

	// TimeoutMillis is a required field
	TimeoutMillis *int64 `locationName:"timeoutMillis" min:"2000" type:"long" required:"true"`

	// UnhealthyThreshold is a required field
	UnhealthyThreshold *int64 `locationName:"unhealthyThreshold" min:"2" type:"integer" required:"true"`
}

// String returns the string representation
func (s HealthCheckPolicy) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *HealthCheckPolicy) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "HealthCheckPolicy"}

	if s.HealthyThreshold == nil {
		invalidParams.Add(aws.NewErrParamRequired("HealthyThreshold"))
	}
	if s.HealthyThreshold != nil && *s.HealthyThreshold < 2 {
		invalidParams.Add(aws.NewErrParamMinValue("HealthyThreshold", 2))
	}

	if s.IntervalMillis == nil {
		invalidParams.Add(aws.NewErrParamRequired("IntervalMillis"))
	}
	if s.IntervalMillis != nil && *s.IntervalMillis < 5000 {
		invalidParams.Add(aws.NewErrParamMinValue("IntervalMillis", 5000))
	}
	if s.Port != nil && *s.Port < 1 {
		invalidParams.Add(aws.NewErrParamMinValue("Port", 1))
	}
	if len(s.Protocol) == 0 {
		invalidParams.Add(aws.NewErrParamRequired("Protocol"))
	}

	if s.TimeoutMillis == nil {
		invalidParams.Add(aws.NewErrParamRequired("TimeoutMillis"))
	}
	if s.TimeoutMillis != nil && *s.TimeoutMillis < 2000 {
		invalidParams.Add(aws.NewErrParamMinValue("TimeoutMillis", 2000))
	}

	if s.UnhealthyThreshold == nil {
		invalidParams.Add(aws.NewErrParamRequired("UnhealthyThreshold"))
	}
	if s.UnhealthyThreshold != nil && *s.UnhealthyThreshold < 2 {
		invalidParams.Add(aws.NewErrParamMinValue("UnhealthyThreshold", 2))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s HealthCheckPolicy) MarshalFields(e protocol.FieldEncoder) error {
	if s.HealthyThreshold != nil {
		v := *s.HealthyThreshold

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "healthyThreshold", protocol.Int64Value(v), metadata)
	}
	if s.IntervalMillis != nil {
		v := *s.IntervalMillis

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "intervalMillis", protocol.Int64Value(v), metadata)
	}
	if s.Path != nil {
		v := *s.Path

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "path", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Port != nil {
		v := *s.Port

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "port", protocol.Int64Value(v), metadata)
	}
	if len(s.Protocol) > 0 {
		v := s.Protocol

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "protocol", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	if s.TimeoutMillis != nil {
		v := *s.TimeoutMillis

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "timeoutMillis", protocol.Int64Value(v), metadata)
	}
	if s.UnhealthyThreshold != nil {
		v := *s.UnhealthyThreshold

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "unhealthyThreshold", protocol.Int64Value(v), metadata)
	}
	return nil
}

// An object that represents a retry policy. Specify at least one value for
// at least one of the types of RetryEvents, a value for maxRetries, and a value
// for perRetryTimeout.
type HttpRetryPolicy struct {
	_ struct{} `type:"structure"`

	HttpRetryEvents []string `locationName:"httpRetryEvents" min:"1" type:"list"`

	// MaxRetries is a required field
	MaxRetries *int64 `locationName:"maxRetries" type:"long" required:"true"`

	// An object that represents a duration of time.
	//
	// PerRetryTimeout is a required field
	PerRetryTimeout *Duration `locationName:"perRetryTimeout" type:"structure" required:"true"`

	TcpRetryEvents []TcpRetryPolicyEvent `locationName:"tcpRetryEvents" min:"1" type:"list"`
}

// String returns the string representation
func (s HttpRetryPolicy) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *HttpRetryPolicy) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "HttpRetryPolicy"}
	if s.HttpRetryEvents != nil && len(s.HttpRetryEvents) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("HttpRetryEvents", 1))
	}

	if s.MaxRetries == nil {
		invalidParams.Add(aws.NewErrParamRequired("MaxRetries"))
	}

	if s.PerRetryTimeout == nil {
		invalidParams.Add(aws.NewErrParamRequired("PerRetryTimeout"))
	}
	if s.TcpRetryEvents != nil && len(s.TcpRetryEvents) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("TcpRetryEvents", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s HttpRetryPolicy) MarshalFields(e protocol.FieldEncoder) error {
	if s.HttpRetryEvents != nil {
		v := s.HttpRetryEvents

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "httpRetryEvents", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddValue(protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v1)})
		}
		ls0.End()

	}
	if s.MaxRetries != nil {
		v := *s.MaxRetries

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "maxRetries", protocol.Int64Value(v), metadata)
	}
	if s.PerRetryTimeout != nil {
		v := s.PerRetryTimeout

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "perRetryTimeout", v, metadata)
	}
	if s.TcpRetryEvents != nil {
		v := s.TcpRetryEvents

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "tcpRetryEvents", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddValue(protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v1)})
		}
		ls0.End()

	}
	return nil
}

// An object that represents an HTTP or HTTP2 route type.
type HttpRoute struct {
	_ struct{} `type:"structure"`

	// An object that represents the action to take if a match is determined.
	//
	// Action is a required field
	Action *HttpRouteAction `locationName:"action" type:"structure" required:"true"`

	// An object that represents the requirements for a route to match HTTP requests
	// for a virtual router.
	//
	// Match is a required field
	Match *HttpRouteMatch `locationName:"match" type:"structure" required:"true"`

	// An object that represents a retry policy. Specify at least one value for
	// at least one of the types of RetryEvents, a value for maxRetries, and a value
	// for perRetryTimeout.
	RetryPolicy *HttpRetryPolicy `locationName:"retryPolicy" type:"structure"`
}

// String returns the string representation
func (s HttpRoute) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *HttpRoute) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "HttpRoute"}

	if s.Action == nil {
		invalidParams.Add(aws.NewErrParamRequired("Action"))
	}

	if s.Match == nil {
		invalidParams.Add(aws.NewErrParamRequired("Match"))
	}
	if s.Action != nil {
		if err := s.Action.Validate(); err != nil {
			invalidParams.AddNested("Action", err.(aws.ErrInvalidParams))
		}
	}
	if s.Match != nil {
		if err := s.Match.Validate(); err != nil {
			invalidParams.AddNested("Match", err.(aws.ErrInvalidParams))
		}
	}
	if s.RetryPolicy != nil {
		if err := s.RetryPolicy.Validate(); err != nil {
			invalidParams.AddNested("RetryPolicy", err.(aws.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s HttpRoute) MarshalFields(e protocol.FieldEncoder) error {
	if s.Action != nil {
		v := s.Action

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "action", v, metadata)
	}
	if s.Match != nil {
		v := s.Match

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "match", v, metadata)
	}
	if s.RetryPolicy != nil {
		v := s.RetryPolicy

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "retryPolicy", v, metadata)
	}
	return nil
}

// An object that represents the action to take if a match is determined.
type HttpRouteAction struct {
	_ struct{} `type:"structure"`

	// WeightedTargets is a required field
	WeightedTargets []WeightedTarget `locationName:"weightedTargets" min:"1" type:"list" required:"true"`
}

// String returns the string representation
func (s HttpRouteAction) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *HttpRouteAction) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "HttpRouteAction"}

	if s.WeightedTargets == nil {
		invalidParams.Add(aws.NewErrParamRequired("WeightedTargets"))
	}
	if s.WeightedTargets != nil && len(s.WeightedTargets) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("WeightedTargets", 1))
	}
	if s.WeightedTargets != nil {
		for i, v := range s.WeightedTargets {
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "WeightedTargets", i), err.(aws.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s HttpRouteAction) MarshalFields(e protocol.FieldEncoder) error {
	if s.WeightedTargets != nil {
		v := s.WeightedTargets

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "weightedTargets", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	return nil
}

// An object that represents the HTTP header in the request.
type HttpRouteHeader struct {
	_ struct{} `type:"structure"`

	Invert *bool `locationName:"invert" type:"boolean"`

	// An object that represents the method and value to match with the header value
	// sent in a request. Specify one match method.
	Match *HeaderMatchMethod `locationName:"match" type:"structure"`

	// Name is a required field
	Name *string `locationName:"name" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s HttpRouteHeader) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *HttpRouteHeader) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "HttpRouteHeader"}

	if s.Name == nil {
		invalidParams.Add(aws.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("Name", 1))
	}
	if s.Match != nil {
		if err := s.Match.Validate(); err != nil {
			invalidParams.AddNested("Match", err.(aws.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s HttpRouteHeader) MarshalFields(e protocol.FieldEncoder) error {
	if s.Invert != nil {
		v := *s.Invert

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "invert", protocol.BoolValue(v), metadata)
	}
	if s.Match != nil {
		v := s.Match

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "match", v, metadata)
	}
	if s.Name != nil {
		v := *s.Name

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "name", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// An object that represents the requirements for a route to match HTTP requests
// for a virtual router.
type HttpRouteMatch struct {
	_ struct{} `type:"structure"`

	Headers []HttpRouteHeader `locationName:"headers" min:"1" type:"list"`

	Method HttpMethod `locationName:"method" type:"string" enum:"true"`

	// Prefix is a required field
	Prefix *string `locationName:"prefix" type:"string" required:"true"`

	Scheme HttpScheme `locationName:"scheme" type:"string" enum:"true"`
}

// String returns the string representation
func (s HttpRouteMatch) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *HttpRouteMatch) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "HttpRouteMatch"}
	if s.Headers != nil && len(s.Headers) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("Headers", 1))
	}

	if s.Prefix == nil {
		invalidParams.Add(aws.NewErrParamRequired("Prefix"))
	}
	if s.Headers != nil {
		for i, v := range s.Headers {
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Headers", i), err.(aws.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s HttpRouteMatch) MarshalFields(e protocol.FieldEncoder) error {
	if s.Headers != nil {
		v := s.Headers

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "headers", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	if len(s.Method) > 0 {
		v := s.Method

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "method", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	if s.Prefix != nil {
		v := *s.Prefix

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "prefix", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if len(s.Scheme) > 0 {
		v := s.Scheme

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "scheme", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	return nil
}

// An object that represents a listener for a virtual node.
type Listener struct {
	_ struct{} `type:"structure"`

	// An object that represents the health check policy for a virtual node's listener.
	HealthCheck *HealthCheckPolicy `locationName:"healthCheck" type:"structure"`

	// An object that represents a port mapping.
	//
	// PortMapping is a required field
	PortMapping *PortMapping `locationName:"portMapping" type:"structure" required:"true"`
}

// String returns the string representation
func (s Listener) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Listener) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "Listener"}

	if s.PortMapping == nil {
		invalidParams.Add(aws.NewErrParamRequired("PortMapping"))
	}
	if s.HealthCheck != nil {
		if err := s.HealthCheck.Validate(); err != nil {
			invalidParams.AddNested("HealthCheck", err.(aws.ErrInvalidParams))
		}
	}
	if s.PortMapping != nil {
		if err := s.PortMapping.Validate(); err != nil {
			invalidParams.AddNested("PortMapping", err.(aws.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s Listener) MarshalFields(e protocol.FieldEncoder) error {
	if s.HealthCheck != nil {
		v := s.HealthCheck

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "healthCheck", v, metadata)
	}
	if s.PortMapping != nil {
		v := s.PortMapping

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "portMapping", v, metadata)
	}
	return nil
}

// An object that represents the logging information for a virtual node.
type Logging struct {
	_ struct{} `type:"structure"`

	// An object that represents the access logging information for a virtual node.
	AccessLog *AccessLog `locationName:"accessLog" type:"structure"`
}

// String returns the string representation
func (s Logging) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Logging) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "Logging"}
	if s.AccessLog != nil {
		if err := s.AccessLog.Validate(); err != nil {
			invalidParams.AddNested("AccessLog", err.(aws.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s Logging) MarshalFields(e protocol.FieldEncoder) error {
	if s.AccessLog != nil {
		v := s.AccessLog

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "accessLog", v, metadata)
	}
	return nil
}

// An object that represents the range of values to match on. The first character
// of the range is included in the range, though the last character is not.
// For example, if the range specified were 1-100, only values 1-99 would be
// matched.
type MatchRange struct {
	_ struct{} `type:"structure"`

	// End is a required field
	End *int64 `locationName:"end" type:"long" required:"true"`

	// Start is a required field
	Start *int64 `locationName:"start" type:"long" required:"true"`
}

// String returns the string representation
func (s MatchRange) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *MatchRange) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "MatchRange"}

	if s.End == nil {
		invalidParams.Add(aws.NewErrParamRequired("End"))
	}

	if s.Start == nil {
		invalidParams.Add(aws.NewErrParamRequired("Start"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s MatchRange) MarshalFields(e protocol.FieldEncoder) error {
	if s.End != nil {
		v := *s.End

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "end", protocol.Int64Value(v), metadata)
	}
	if s.Start != nil {
		v := *s.Start

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "start", protocol.Int64Value(v), metadata)
	}
	return nil
}

// An object that represents a service mesh returned by a describe operation.
type MeshData struct {
	_ struct{} `type:"structure"`

	// MeshName is a required field
	MeshName *string `locationName:"meshName" min:"1" type:"string" required:"true"`

	// An object that represents metadata for a resource.
	//
	// Metadata is a required field
	Metadata *ResourceMetadata `locationName:"metadata" type:"structure" required:"true"`

	// An object that represents the specification of a service mesh.
	//
	// Spec is a required field
	Spec *MeshSpec `locationName:"spec" type:"structure" required:"true"`

	// An object that represents the status of a service mesh.
	//
	// Status is a required field
	Status *MeshStatus `locationName:"status" type:"structure" required:"true"`
}

// String returns the string representation
func (s MeshData) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s MeshData) MarshalFields(e protocol.FieldEncoder) error {
	if s.MeshName != nil {
		v := *s.MeshName

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "meshName", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Metadata != nil {
		v := s.Metadata

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "metadata", v, metadata)
	}
	if s.Spec != nil {
		v := s.Spec

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "spec", v, metadata)
	}
	if s.Status != nil {
		v := s.Status

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "status", v, metadata)
	}
	return nil
}

// An object that represents a service mesh returned by a list operation.
type MeshRef struct {
	_ struct{} `type:"structure"`

	// Arn is a required field
	Arn *string `locationName:"arn" type:"string" required:"true"`

	// MeshName is a required field
	MeshName *string `locationName:"meshName" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s MeshRef) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s MeshRef) MarshalFields(e protocol.FieldEncoder) error {
	if s.Arn != nil {
		v := *s.Arn

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "arn", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.MeshName != nil {
		v := *s.MeshName

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "meshName", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// An object that represents the specification of a service mesh.
type MeshSpec struct {
	_ struct{} `type:"structure"`

	// An object that represents the egress filter rules for a service mesh.
	EgressFilter *EgressFilter `locationName:"egressFilter" type:"structure"`
}

// String returns the string representation
func (s MeshSpec) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *MeshSpec) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "MeshSpec"}
	if s.EgressFilter != nil {
		if err := s.EgressFilter.Validate(); err != nil {
			invalidParams.AddNested("EgressFilter", err.(aws.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s MeshSpec) MarshalFields(e protocol.FieldEncoder) error {
	if s.EgressFilter != nil {
		v := s.EgressFilter

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "egressFilter", v, metadata)
	}
	return nil
}

// An object that represents the status of a service mesh.
type MeshStatus struct {
	_ struct{} `type:"structure"`

	Status MeshStatusCode `locationName:"status" type:"string" enum:"true"`
}

// String returns the string representation
func (s MeshStatus) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s MeshStatus) MarshalFields(e protocol.FieldEncoder) error {
	if len(s.Status) > 0 {
		v := s.Status

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "status", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	return nil
}

// An object that represents a port mapping.
type PortMapping struct {
	_ struct{} `type:"structure"`

	// Port is a required field
	Port *int64 `locationName:"port" min:"1" type:"integer" required:"true"`

	// Protocol is a required field
	Protocol PortProtocol `locationName:"protocol" type:"string" required:"true" enum:"true"`
}

// String returns the string representation
func (s PortMapping) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *PortMapping) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "PortMapping"}

	if s.Port == nil {
		invalidParams.Add(aws.NewErrParamRequired("Port"))
	}
	if s.Port != nil && *s.Port < 1 {
		invalidParams.Add(aws.NewErrParamMinValue("Port", 1))
	}
	if len(s.Protocol) == 0 {
		invalidParams.Add(aws.NewErrParamRequired("Protocol"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s PortMapping) MarshalFields(e protocol.FieldEncoder) error {
	if s.Port != nil {
		v := *s.Port

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "port", protocol.Int64Value(v), metadata)
	}
	if len(s.Protocol) > 0 {
		v := s.Protocol

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "protocol", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	return nil
}

// An object that represents metadata for a resource.
type ResourceMetadata struct {
	_ struct{} `type:"structure"`

	// Arn is a required field
	Arn *string `locationName:"arn" type:"string" required:"true"`

	// CreatedAt is a required field
	CreatedAt *time.Time `locationName:"createdAt" type:"timestamp" required:"true"`

	// LastUpdatedAt is a required field
	LastUpdatedAt *time.Time `locationName:"lastUpdatedAt" type:"timestamp" required:"true"`

	// Uid is a required field
	Uid *string `locationName:"uid" type:"string" required:"true"`

	// Version is a required field
	Version *int64 `locationName:"version" type:"long" required:"true"`
}

// String returns the string representation
func (s ResourceMetadata) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s ResourceMetadata) MarshalFields(e protocol.FieldEncoder) error {
	if s.Arn != nil {
		v := *s.Arn

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "arn", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.CreatedAt != nil {
		v := *s.CreatedAt

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "createdAt",
			protocol.TimeValue{V: v, Format: protocol.UnixTimeFormatName, QuotedFormatTime: true}, metadata)
	}
	if s.LastUpdatedAt != nil {
		v := *s.LastUpdatedAt

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "lastUpdatedAt",
			protocol.TimeValue{V: v, Format: protocol.UnixTimeFormatName, QuotedFormatTime: true}, metadata)
	}
	if s.Uid != nil {
		v := *s.Uid

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "uid", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Version != nil {
		v := *s.Version

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "version", protocol.Int64Value(v), metadata)
	}
	return nil
}

// An object that represents a route returned by a describe operation.
type RouteData struct {
	_ struct{} `type:"structure"`

	// MeshName is a required field
	MeshName *string `locationName:"meshName" min:"1" type:"string" required:"true"`

	// An object that represents metadata for a resource.
	//
	// Metadata is a required field
	Metadata *ResourceMetadata `locationName:"metadata" type:"structure" required:"true"`

	// RouteName is a required field
	RouteName *string `locationName:"routeName" min:"1" type:"string" required:"true"`

	// An object that represents a route specification. Specify one route type.
	//
	// Spec is a required field
	Spec *RouteSpec `locationName:"spec" type:"structure" required:"true"`

	// An object that represents the current status of a route.
	//
	// Status is a required field
	Status *RouteStatus `locationName:"status" type:"structure" required:"true"`

	// VirtualRouterName is a required field
	VirtualRouterName *string `locationName:"virtualRouterName" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s RouteData) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s RouteData) MarshalFields(e protocol.FieldEncoder) error {
	if s.MeshName != nil {
		v := *s.MeshName

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "meshName", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Metadata != nil {
		v := s.Metadata

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "metadata", v, metadata)
	}
	if s.RouteName != nil {
		v := *s.RouteName

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "routeName", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Spec != nil {
		v := s.Spec

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "spec", v, metadata)
	}
	if s.Status != nil {
		v := s.Status

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "status", v, metadata)
	}
	if s.VirtualRouterName != nil {
		v := *s.VirtualRouterName

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "virtualRouterName", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// An object that represents a route returned by a list operation.
type RouteRef struct {
	_ struct{} `type:"structure"`

	// Arn is a required field
	Arn *string `locationName:"arn" type:"string" required:"true"`

	// MeshName is a required field
	MeshName *string `locationName:"meshName" min:"1" type:"string" required:"true"`

	// RouteName is a required field
	RouteName *string `locationName:"routeName" min:"1" type:"string" required:"true"`

	// VirtualRouterName is a required field
	VirtualRouterName *string `locationName:"virtualRouterName" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s RouteRef) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s RouteRef) MarshalFields(e protocol.FieldEncoder) error {
	if s.Arn != nil {
		v := *s.Arn

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "arn", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.MeshName != nil {
		v := *s.MeshName

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "meshName", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.RouteName != nil {
		v := *s.RouteName

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "routeName", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.VirtualRouterName != nil {
		v := *s.VirtualRouterName

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "virtualRouterName", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// An object that represents a route specification. Specify one route type.
type RouteSpec struct {
	_ struct{} `type:"structure"`

	// An object that represents a GRPC route type.
	GrpcRoute *GrpcRoute `locationName:"grpcRoute" type:"structure"`

	// An object that represents an HTTP or HTTP2 route type.
	Http2Route *HttpRoute `locationName:"http2Route" type:"structure"`

	// An object that represents an HTTP or HTTP2 route type.
	HttpRoute *HttpRoute `locationName:"httpRoute" type:"structure"`

	Priority *int64 `locationName:"priority" type:"integer"`

	// An object that represents a TCP route type.
	TcpRoute *TcpRoute `locationName:"tcpRoute" type:"structure"`
}

// String returns the string representation
func (s RouteSpec) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *RouteSpec) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "RouteSpec"}
	if s.GrpcRoute != nil {
		if err := s.GrpcRoute.Validate(); err != nil {
			invalidParams.AddNested("GrpcRoute", err.(aws.ErrInvalidParams))
		}
	}
	if s.Http2Route != nil {
		if err := s.Http2Route.Validate(); err != nil {
			invalidParams.AddNested("Http2Route", err.(aws.ErrInvalidParams))
		}
	}
	if s.HttpRoute != nil {
		if err := s.HttpRoute.Validate(); err != nil {
			invalidParams.AddNested("HttpRoute", err.(aws.ErrInvalidParams))
		}
	}
	if s.TcpRoute != nil {
		if err := s.TcpRoute.Validate(); err != nil {
			invalidParams.AddNested("TcpRoute", err.(aws.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s RouteSpec) MarshalFields(e protocol.FieldEncoder) error {
	if s.GrpcRoute != nil {
		v := s.GrpcRoute

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "grpcRoute", v, metadata)
	}
	if s.Http2Route != nil {
		v := s.Http2Route

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "http2Route", v, metadata)
	}
	if s.HttpRoute != nil {
		v := s.HttpRoute

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "httpRoute", v, metadata)
	}
	if s.Priority != nil {
		v := *s.Priority

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "priority", protocol.Int64Value(v), metadata)
	}
	if s.TcpRoute != nil {
		v := s.TcpRoute

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "tcpRoute", v, metadata)
	}
	return nil
}

// An object that represents the current status of a route.
type RouteStatus struct {
	_ struct{} `type:"structure"`

	// Status is a required field
	Status RouteStatusCode `locationName:"status" type:"string" required:"true" enum:"true"`
}

// String returns the string representation
func (s RouteStatus) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s RouteStatus) MarshalFields(e protocol.FieldEncoder) error {
	if len(s.Status) > 0 {
		v := s.Status

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "status", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	return nil
}

// An object that represents the service discovery information for a virtual
// node.
type ServiceDiscovery struct {
	_ struct{} `type:"structure"`

	// An object that represents the AWS Cloud Map service discovery information
	// for your virtual node.
	AwsCloudMap *AwsCloudMapServiceDiscovery `locationName:"awsCloudMap" type:"structure"`

	// An object that represents the DNS service discovery information for your
	// virtual node.
	Dns *DnsServiceDiscovery `locationName:"dns" type:"structure"`
}

// String returns the string representation
func (s ServiceDiscovery) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ServiceDiscovery) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "ServiceDiscovery"}
	if s.AwsCloudMap != nil {
		if err := s.AwsCloudMap.Validate(); err != nil {
			invalidParams.AddNested("AwsCloudMap", err.(aws.ErrInvalidParams))
		}
	}
	if s.Dns != nil {
		if err := s.Dns.Validate(); err != nil {
			invalidParams.AddNested("Dns", err.(aws.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s ServiceDiscovery) MarshalFields(e protocol.FieldEncoder) error {
	if s.AwsCloudMap != nil {
		v := s.AwsCloudMap

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "awsCloudMap", v, metadata)
	}
	if s.Dns != nil {
		v := s.Dns

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "dns", v, metadata)
	}
	return nil
}

// Optional metadata that you apply to a resource to assist with categorization
// and organization. Each tag consists of a key and an optional value, both
// of which you define. Tag keys can have a maximum character length of 128
// characters, and tag values can have a maximum length of 256 characters.
type TagRef struct {
	_ struct{} `type:"structure"`

	// Key is a required field
	Key *string `locationName:"key" min:"1" type:"string" required:"true"`

	Value *string `locationName:"value" type:"string"`
}

// String returns the string representation
func (s TagRef) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *TagRef) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "TagRef"}

	if s.Key == nil {
		invalidParams.Add(aws.NewErrParamRequired("Key"))
	}
	if s.Key != nil && len(*s.Key) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("Key", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s TagRef) MarshalFields(e protocol.FieldEncoder) error {
	if s.Key != nil {
		v := *s.Key

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "key", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Value != nil {
		v := *s.Value

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "value", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// An object that represents a TCP route type.
type TcpRoute struct {
	_ struct{} `type:"structure"`

	// An object that represents the action to take if a match is determined.
	//
	// Action is a required field
	Action *TcpRouteAction `locationName:"action" type:"structure" required:"true"`
}

// String returns the string representation
func (s TcpRoute) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *TcpRoute) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "TcpRoute"}

	if s.Action == nil {
		invalidParams.Add(aws.NewErrParamRequired("Action"))
	}
	if s.Action != nil {
		if err := s.Action.Validate(); err != nil {
			invalidParams.AddNested("Action", err.(aws.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s TcpRoute) MarshalFields(e protocol.FieldEncoder) error {
	if s.Action != nil {
		v := s.Action

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "action", v, metadata)
	}
	return nil
}

// An object that represents the action to take if a match is determined.
type TcpRouteAction struct {
	_ struct{} `type:"structure"`

	// WeightedTargets is a required field
	WeightedTargets []WeightedTarget `locationName:"weightedTargets" min:"1" type:"list" required:"true"`
}

// String returns the string representation
func (s TcpRouteAction) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *TcpRouteAction) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "TcpRouteAction"}

	if s.WeightedTargets == nil {
		invalidParams.Add(aws.NewErrParamRequired("WeightedTargets"))
	}
	if s.WeightedTargets != nil && len(s.WeightedTargets) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("WeightedTargets", 1))
	}
	if s.WeightedTargets != nil {
		for i, v := range s.WeightedTargets {
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "WeightedTargets", i), err.(aws.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s TcpRouteAction) MarshalFields(e protocol.FieldEncoder) error {
	if s.WeightedTargets != nil {
		v := s.WeightedTargets

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "weightedTargets", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	return nil
}

// An object that represents a virtual node returned by a describe operation.
type VirtualNodeData struct {
	_ struct{} `type:"structure"`

	// MeshName is a required field
	MeshName *string `locationName:"meshName" min:"1" type:"string" required:"true"`

	// An object that represents metadata for a resource.
	//
	// Metadata is a required field
	Metadata *ResourceMetadata `locationName:"metadata" type:"structure" required:"true"`

	// An object that represents the specification of a virtual node.
	//
	// Spec is a required field
	Spec *VirtualNodeSpec `locationName:"spec" type:"structure" required:"true"`

	// An object that represents the current status of the virtual node.
	//
	// Status is a required field
	Status *VirtualNodeStatus `locationName:"status" type:"structure" required:"true"`

	// VirtualNodeName is a required field
	VirtualNodeName *string `locationName:"virtualNodeName" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s VirtualNodeData) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s VirtualNodeData) MarshalFields(e protocol.FieldEncoder) error {
	if s.MeshName != nil {
		v := *s.MeshName

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "meshName", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Metadata != nil {
		v := s.Metadata

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "metadata", v, metadata)
	}
	if s.Spec != nil {
		v := s.Spec

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "spec", v, metadata)
	}
	if s.Status != nil {
		v := s.Status

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "status", v, metadata)
	}
	if s.VirtualNodeName != nil {
		v := *s.VirtualNodeName

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "virtualNodeName", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// An object that represents a virtual node returned by a list operation.
type VirtualNodeRef struct {
	_ struct{} `type:"structure"`

	// Arn is a required field
	Arn *string `locationName:"arn" type:"string" required:"true"`

	// MeshName is a required field
	MeshName *string `locationName:"meshName" min:"1" type:"string" required:"true"`

	// VirtualNodeName is a required field
	VirtualNodeName *string `locationName:"virtualNodeName" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s VirtualNodeRef) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s VirtualNodeRef) MarshalFields(e protocol.FieldEncoder) error {
	if s.Arn != nil {
		v := *s.Arn

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "arn", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.MeshName != nil {
		v := *s.MeshName

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "meshName", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.VirtualNodeName != nil {
		v := *s.VirtualNodeName

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "virtualNodeName", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// An object that represents a virtual node service provider.
type VirtualNodeServiceProvider struct {
	_ struct{} `type:"structure"`

	// VirtualNodeName is a required field
	VirtualNodeName *string `locationName:"virtualNodeName" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s VirtualNodeServiceProvider) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *VirtualNodeServiceProvider) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "VirtualNodeServiceProvider"}

	if s.VirtualNodeName == nil {
		invalidParams.Add(aws.NewErrParamRequired("VirtualNodeName"))
	}
	if s.VirtualNodeName != nil && len(*s.VirtualNodeName) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("VirtualNodeName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s VirtualNodeServiceProvider) MarshalFields(e protocol.FieldEncoder) error {
	if s.VirtualNodeName != nil {
		v := *s.VirtualNodeName

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "virtualNodeName", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// An object that represents the specification of a virtual node.
type VirtualNodeSpec struct {
	_ struct{} `type:"structure"`

	Backends []Backend `locationName:"backends" type:"list"`

	Listeners []Listener `locationName:"listeners" type:"list"`

	// An object that represents the logging information for a virtual node.
	Logging *Logging `locationName:"logging" type:"structure"`

	// An object that represents the service discovery information for a virtual
	// node.
	ServiceDiscovery *ServiceDiscovery `locationName:"serviceDiscovery" type:"structure"`
}

// String returns the string representation
func (s VirtualNodeSpec) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *VirtualNodeSpec) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "VirtualNodeSpec"}
	if s.Backends != nil {
		for i, v := range s.Backends {
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Backends", i), err.(aws.ErrInvalidParams))
			}
		}
	}
	if s.Listeners != nil {
		for i, v := range s.Listeners {
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Listeners", i), err.(aws.ErrInvalidParams))
			}
		}
	}
	if s.Logging != nil {
		if err := s.Logging.Validate(); err != nil {
			invalidParams.AddNested("Logging", err.(aws.ErrInvalidParams))
		}
	}
	if s.ServiceDiscovery != nil {
		if err := s.ServiceDiscovery.Validate(); err != nil {
			invalidParams.AddNested("ServiceDiscovery", err.(aws.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s VirtualNodeSpec) MarshalFields(e protocol.FieldEncoder) error {
	if s.Backends != nil {
		v := s.Backends

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "backends", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	if s.Listeners != nil {
		v := s.Listeners

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "listeners", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	if s.Logging != nil {
		v := s.Logging

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "logging", v, metadata)
	}
	if s.ServiceDiscovery != nil {
		v := s.ServiceDiscovery

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "serviceDiscovery", v, metadata)
	}
	return nil
}

// An object that represents the current status of the virtual node.
type VirtualNodeStatus struct {
	_ struct{} `type:"structure"`

	// Status is a required field
	Status VirtualNodeStatusCode `locationName:"status" type:"string" required:"true" enum:"true"`
}

// String returns the string representation
func (s VirtualNodeStatus) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s VirtualNodeStatus) MarshalFields(e protocol.FieldEncoder) error {
	if len(s.Status) > 0 {
		v := s.Status

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "status", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	return nil
}

// An object that represents a virtual router returned by a describe operation.
type VirtualRouterData struct {
	_ struct{} `type:"structure"`

	// MeshName is a required field
	MeshName *string `locationName:"meshName" min:"1" type:"string" required:"true"`

	// An object that represents metadata for a resource.
	//
	// Metadata is a required field
	Metadata *ResourceMetadata `locationName:"metadata" type:"structure" required:"true"`

	// An object that represents the specification of a virtual router.
	//
	// Spec is a required field
	Spec *VirtualRouterSpec `locationName:"spec" type:"structure" required:"true"`

	// An object that represents the status of a virtual router.
	//
	// Status is a required field
	Status *VirtualRouterStatus `locationName:"status" type:"structure" required:"true"`

	// VirtualRouterName is a required field
	VirtualRouterName *string `locationName:"virtualRouterName" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s VirtualRouterData) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s VirtualRouterData) MarshalFields(e protocol.FieldEncoder) error {
	if s.MeshName != nil {
		v := *s.MeshName

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "meshName", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Metadata != nil {
		v := s.Metadata

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "metadata", v, metadata)
	}
	if s.Spec != nil {
		v := s.Spec

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "spec", v, metadata)
	}
	if s.Status != nil {
		v := s.Status

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "status", v, metadata)
	}
	if s.VirtualRouterName != nil {
		v := *s.VirtualRouterName

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "virtualRouterName", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// An object that represents a virtual router listener.
type VirtualRouterListener struct {
	_ struct{} `type:"structure"`

	// An object that represents a port mapping.
	//
	// PortMapping is a required field
	PortMapping *PortMapping `locationName:"portMapping" type:"structure" required:"true"`
}

// String returns the string representation
func (s VirtualRouterListener) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *VirtualRouterListener) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "VirtualRouterListener"}

	if s.PortMapping == nil {
		invalidParams.Add(aws.NewErrParamRequired("PortMapping"))
	}
	if s.PortMapping != nil {
		if err := s.PortMapping.Validate(); err != nil {
			invalidParams.AddNested("PortMapping", err.(aws.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s VirtualRouterListener) MarshalFields(e protocol.FieldEncoder) error {
	if s.PortMapping != nil {
		v := s.PortMapping

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "portMapping", v, metadata)
	}
	return nil
}

// An object that represents a virtual router returned by a list operation.
type VirtualRouterRef struct {
	_ struct{} `type:"structure"`

	// Arn is a required field
	Arn *string `locationName:"arn" type:"string" required:"true"`

	// MeshName is a required field
	MeshName *string `locationName:"meshName" min:"1" type:"string" required:"true"`

	// VirtualRouterName is a required field
	VirtualRouterName *string `locationName:"virtualRouterName" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s VirtualRouterRef) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s VirtualRouterRef) MarshalFields(e protocol.FieldEncoder) error {
	if s.Arn != nil {
		v := *s.Arn

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "arn", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.MeshName != nil {
		v := *s.MeshName

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "meshName", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.VirtualRouterName != nil {
		v := *s.VirtualRouterName

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "virtualRouterName", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// An object that represents a virtual node service provider.
type VirtualRouterServiceProvider struct {
	_ struct{} `type:"structure"`

	// VirtualRouterName is a required field
	VirtualRouterName *string `locationName:"virtualRouterName" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s VirtualRouterServiceProvider) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *VirtualRouterServiceProvider) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "VirtualRouterServiceProvider"}

	if s.VirtualRouterName == nil {
		invalidParams.Add(aws.NewErrParamRequired("VirtualRouterName"))
	}
	if s.VirtualRouterName != nil && len(*s.VirtualRouterName) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("VirtualRouterName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s VirtualRouterServiceProvider) MarshalFields(e protocol.FieldEncoder) error {
	if s.VirtualRouterName != nil {
		v := *s.VirtualRouterName

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "virtualRouterName", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// An object that represents the specification of a virtual router.
type VirtualRouterSpec struct {
	_ struct{} `type:"structure"`

	Listeners []VirtualRouterListener `locationName:"listeners" min:"1" type:"list"`
}

// String returns the string representation
func (s VirtualRouterSpec) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *VirtualRouterSpec) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "VirtualRouterSpec"}
	if s.Listeners != nil && len(s.Listeners) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("Listeners", 1))
	}
	if s.Listeners != nil {
		for i, v := range s.Listeners {
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Listeners", i), err.(aws.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s VirtualRouterSpec) MarshalFields(e protocol.FieldEncoder) error {
	if s.Listeners != nil {
		v := s.Listeners

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "listeners", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	return nil
}

// An object that represents the status of a virtual router.
type VirtualRouterStatus struct {
	_ struct{} `type:"structure"`

	// Status is a required field
	Status VirtualRouterStatusCode `locationName:"status" type:"string" required:"true" enum:"true"`
}

// String returns the string representation
func (s VirtualRouterStatus) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s VirtualRouterStatus) MarshalFields(e protocol.FieldEncoder) error {
	if len(s.Status) > 0 {
		v := s.Status

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "status", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	return nil
}

// An object that represents a virtual service backend for a virtual node.
type VirtualServiceBackend struct {
	_ struct{} `type:"structure"`

	// VirtualServiceName is a required field
	VirtualServiceName *string `locationName:"virtualServiceName" type:"string" required:"true"`
}

// String returns the string representation
func (s VirtualServiceBackend) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *VirtualServiceBackend) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "VirtualServiceBackend"}

	if s.VirtualServiceName == nil {
		invalidParams.Add(aws.NewErrParamRequired("VirtualServiceName"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s VirtualServiceBackend) MarshalFields(e protocol.FieldEncoder) error {
	if s.VirtualServiceName != nil {
		v := *s.VirtualServiceName

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "virtualServiceName", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// An object that represents a virtual service returned by a describe operation.
type VirtualServiceData struct {
	_ struct{} `type:"structure"`

	// MeshName is a required field
	MeshName *string `locationName:"meshName" min:"1" type:"string" required:"true"`

	// An object that represents metadata for a resource.
	//
	// Metadata is a required field
	Metadata *ResourceMetadata `locationName:"metadata" type:"structure" required:"true"`

	// An object that represents the specification of a virtual service.
	//
	// Spec is a required field
	Spec *VirtualServiceSpec `locationName:"spec" type:"structure" required:"true"`

	// An object that represents the status of a virtual service.
	//
	// Status is a required field
	Status *VirtualServiceStatus `locationName:"status" type:"structure" required:"true"`

	// VirtualServiceName is a required field
	VirtualServiceName *string `locationName:"virtualServiceName" type:"string" required:"true"`
}

// String returns the string representation
func (s VirtualServiceData) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s VirtualServiceData) MarshalFields(e protocol.FieldEncoder) error {
	if s.MeshName != nil {
		v := *s.MeshName

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "meshName", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Metadata != nil {
		v := s.Metadata

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "metadata", v, metadata)
	}
	if s.Spec != nil {
		v := s.Spec

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "spec", v, metadata)
	}
	if s.Status != nil {
		v := s.Status

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "status", v, metadata)
	}
	if s.VirtualServiceName != nil {
		v := *s.VirtualServiceName

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "virtualServiceName", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// An object that represents the provider for a virtual service.
type VirtualServiceProvider struct {
	_ struct{} `type:"structure"`

	// An object that represents a virtual node service provider.
	VirtualNode *VirtualNodeServiceProvider `locationName:"virtualNode" type:"structure"`

	// An object that represents a virtual node service provider.
	VirtualRouter *VirtualRouterServiceProvider `locationName:"virtualRouter" type:"structure"`
}

// String returns the string representation
func (s VirtualServiceProvider) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *VirtualServiceProvider) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "VirtualServiceProvider"}
	if s.VirtualNode != nil {
		if err := s.VirtualNode.Validate(); err != nil {
			invalidParams.AddNested("VirtualNode", err.(aws.ErrInvalidParams))
		}
	}
	if s.VirtualRouter != nil {
		if err := s.VirtualRouter.Validate(); err != nil {
			invalidParams.AddNested("VirtualRouter", err.(aws.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s VirtualServiceProvider) MarshalFields(e protocol.FieldEncoder) error {
	if s.VirtualNode != nil {
		v := s.VirtualNode

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "virtualNode", v, metadata)
	}
	if s.VirtualRouter != nil {
		v := s.VirtualRouter

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "virtualRouter", v, metadata)
	}
	return nil
}

// An object that represents a virtual service returned by a list operation.
type VirtualServiceRef struct {
	_ struct{} `type:"structure"`

	// Arn is a required field
	Arn *string `locationName:"arn" type:"string" required:"true"`

	// MeshName is a required field
	MeshName *string `locationName:"meshName" min:"1" type:"string" required:"true"`

	// VirtualServiceName is a required field
	VirtualServiceName *string `locationName:"virtualServiceName" type:"string" required:"true"`
}

// String returns the string representation
func (s VirtualServiceRef) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s VirtualServiceRef) MarshalFields(e protocol.FieldEncoder) error {
	if s.Arn != nil {
		v := *s.Arn

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "arn", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.MeshName != nil {
		v := *s.MeshName

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "meshName", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.VirtualServiceName != nil {
		v := *s.VirtualServiceName

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "virtualServiceName", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// An object that represents the specification of a virtual service.
type VirtualServiceSpec struct {
	_ struct{} `type:"structure"`

	// An object that represents the provider for a virtual service.
	Provider *VirtualServiceProvider `locationName:"provider" type:"structure"`
}

// String returns the string representation
func (s VirtualServiceSpec) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *VirtualServiceSpec) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "VirtualServiceSpec"}
	if s.Provider != nil {
		if err := s.Provider.Validate(); err != nil {
			invalidParams.AddNested("Provider", err.(aws.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s VirtualServiceSpec) MarshalFields(e protocol.FieldEncoder) error {
	if s.Provider != nil {
		v := s.Provider

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "provider", v, metadata)
	}
	return nil
}

// An object that represents the status of a virtual service.
type VirtualServiceStatus struct {
	_ struct{} `type:"structure"`

	// Status is a required field
	Status VirtualServiceStatusCode `locationName:"status" type:"string" required:"true" enum:"true"`
}

// String returns the string representation
func (s VirtualServiceStatus) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s VirtualServiceStatus) MarshalFields(e protocol.FieldEncoder) error {
	if len(s.Status) > 0 {
		v := s.Status

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "status", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	return nil
}

// An object that represents a target and its relative weight. Traffic is distributed
// across targets according to their relative weight. For example, a weighted
// target with a relative weight of 50 receives five times as much traffic as
// one with a relative weight of 10. The total weight for all targets combined
// must be less than or equal to 100.
type WeightedTarget struct {
	_ struct{} `type:"structure"`

	// VirtualNode is a required field
	VirtualNode *string `locationName:"virtualNode" min:"1" type:"string" required:"true"`

	// Weight is a required field
	Weight *int64 `locationName:"weight" type:"integer" required:"true"`
}

// String returns the string representation
func (s WeightedTarget) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *WeightedTarget) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "WeightedTarget"}

	if s.VirtualNode == nil {
		invalidParams.Add(aws.NewErrParamRequired("VirtualNode"))
	}
	if s.VirtualNode != nil && len(*s.VirtualNode) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("VirtualNode", 1))
	}

	if s.Weight == nil {
		invalidParams.Add(aws.NewErrParamRequired("Weight"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s WeightedTarget) MarshalFields(e protocol.FieldEncoder) error {
	if s.VirtualNode != nil {
		v := *s.VirtualNode

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "virtualNode", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Weight != nil {
		v := *s.Weight

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "weight", protocol.Int64Value(v), metadata)
	}
	return nil
}
