// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package cloudwatchlogs

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type TestMetricFilterInput struct {
	_ struct{} `type:"structure"`

	// A symbolic description of how CloudWatch Logs should interpret the data in
	// each log event. For example, a log event may contain timestamps, IP addresses,
	// strings, and so on. You use the filter pattern to specify what to look for
	// in the log event message.
	//
	// FilterPattern is a required field
	FilterPattern *string `locationName:"filterPattern" type:"string" required:"true"`

	// The log event messages to test.
	//
	// LogEventMessages is a required field
	LogEventMessages []string `locationName:"logEventMessages" min:"1" type:"list" required:"true"`
}

// String returns the string representation
func (s TestMetricFilterInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *TestMetricFilterInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "TestMetricFilterInput"}

	if s.FilterPattern == nil {
		invalidParams.Add(aws.NewErrParamRequired("FilterPattern"))
	}

	if s.LogEventMessages == nil {
		invalidParams.Add(aws.NewErrParamRequired("LogEventMessages"))
	}
	if s.LogEventMessages != nil && len(s.LogEventMessages) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("LogEventMessages", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type TestMetricFilterOutput struct {
	_ struct{} `type:"structure"`

	// The matched events.
	Matches []MetricFilterMatchRecord `locationName:"matches" type:"list"`
}

// String returns the string representation
func (s TestMetricFilterOutput) String() string {
	return awsutil.Prettify(s)
}

const opTestMetricFilter = "TestMetricFilter"

// TestMetricFilterRequest returns a request value for making API operation for
// Amazon CloudWatch Logs.
//
// Tests the filter pattern of a metric filter against a sample of log event
// messages. You can use this operation to validate the correctness of a metric
// filter pattern.
//
//    // Example sending a request using TestMetricFilterRequest.
//    req := client.TestMetricFilterRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/logs-2014-03-28/TestMetricFilter
func (c *Client) TestMetricFilterRequest(input *TestMetricFilterInput) TestMetricFilterRequest {
	op := &aws.Operation{
		Name:       opTestMetricFilter,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &TestMetricFilterInput{}
	}

	req := c.newRequest(op, input, &TestMetricFilterOutput{})
	return TestMetricFilterRequest{Request: req, Input: input, Copy: c.TestMetricFilterRequest}
}

// TestMetricFilterRequest is the request type for the
// TestMetricFilter API operation.
type TestMetricFilterRequest struct {
	*aws.Request
	Input *TestMetricFilterInput
	Copy  func(*TestMetricFilterInput) TestMetricFilterRequest
}

// Send marshals and sends the TestMetricFilter API request.
func (r TestMetricFilterRequest) Send(ctx context.Context) (*TestMetricFilterResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &TestMetricFilterResponse{
		TestMetricFilterOutput: r.Request.Data.(*TestMetricFilterOutput),
		response:               &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// TestMetricFilterResponse is the response type for the
// TestMetricFilter API operation.
type TestMetricFilterResponse struct {
	*TestMetricFilterOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// TestMetricFilter request.
func (r *TestMetricFilterResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
