// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package codeguruprofiler

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
)

// Request for CreateProfilingGroup operation.
type CreateProfilingGroupInput struct {
	_ struct{} `type:"structure"`

	// Configuration to orchestrate agents to create and report agent profiles of
	// the profiling group. Agents are orchestrated if they follow the agent orchestration
	// protocol.
	AgentOrchestrationConfig *AgentOrchestrationConfig `locationName:"agentOrchestrationConfig" type:"structure"`

	// Client token for the request.
	//
	// ClientToken is a required field
	ClientToken *string `location:"querystring" locationName:"clientToken" min:"1" type:"string" required:"true" idempotencyToken:"true"`

	// The name of the profiling group.
	//
	// ProfilingGroupName is a required field
	ProfilingGroupName *string `locationName:"profilingGroupName" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s CreateProfilingGroupInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateProfilingGroupInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "CreateProfilingGroupInput"}

	if s.ClientToken == nil {
		invalidParams.Add(aws.NewErrParamRequired("ClientToken"))
	}
	if s.ClientToken != nil && len(*s.ClientToken) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("ClientToken", 1))
	}

	if s.ProfilingGroupName == nil {
		invalidParams.Add(aws.NewErrParamRequired("ProfilingGroupName"))
	}
	if s.ProfilingGroupName != nil && len(*s.ProfilingGroupName) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("ProfilingGroupName", 1))
	}
	if s.AgentOrchestrationConfig != nil {
		if err := s.AgentOrchestrationConfig.Validate(); err != nil {
			invalidParams.AddNested("AgentOrchestrationConfig", err.(aws.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s CreateProfilingGroupInput) MarshalFields(e protocol.FieldEncoder) error {
	e.SetValue(protocol.HeaderTarget, "Content-Type", protocol.StringValue("application/json"), protocol.Metadata{})

	if s.AgentOrchestrationConfig != nil {
		v := s.AgentOrchestrationConfig

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "agentOrchestrationConfig", v, metadata)
	}
	if s.ProfilingGroupName != nil {
		v := *s.ProfilingGroupName

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "profilingGroupName", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	var ClientToken string
	if s.ClientToken != nil {
		ClientToken = *s.ClientToken
	} else {
		ClientToken = protocol.GetIdempotencyToken()
	}
	{
		v := ClientToken

		metadata := protocol.Metadata{}
		e.SetValue(protocol.QueryTarget, "clientToken", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// Response for CreateProfilingGroup operation.
type CreateProfilingGroupOutput struct {
	_ struct{} `type:"structure" payload:"ProfilingGroup"`

	// The description of a profiling group.
	//
	// ProfilingGroup is a required field
	ProfilingGroup *ProfilingGroupDescription `locationName:"profilingGroup" type:"structure" required:"true"`
}

// String returns the string representation
func (s CreateProfilingGroupOutput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s CreateProfilingGroupOutput) MarshalFields(e protocol.FieldEncoder) error {
	if s.ProfilingGroup != nil {
		v := s.ProfilingGroup

		metadata := protocol.Metadata{}
		e.SetFields(protocol.PayloadTarget, "profilingGroup", v, metadata)
	}
	return nil
}

const opCreateProfilingGroup = "CreateProfilingGroup"

// CreateProfilingGroupRequest returns a request value for making API operation for
// Amazon CodeGuru Profiler.
//
// Create a profiling group.
//
//    // Example sending a request using CreateProfilingGroupRequest.
//    req := client.CreateProfilingGroupRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/codeguruprofiler-2019-07-18/CreateProfilingGroup
func (c *Client) CreateProfilingGroupRequest(input *CreateProfilingGroupInput) CreateProfilingGroupRequest {
	op := &aws.Operation{
		Name:       opCreateProfilingGroup,
		HTTPMethod: "POST",
		HTTPPath:   "/profilingGroups",
	}

	if input == nil {
		input = &CreateProfilingGroupInput{}
	}

	req := c.newRequest(op, input, &CreateProfilingGroupOutput{})
	return CreateProfilingGroupRequest{Request: req, Input: input, Copy: c.CreateProfilingGroupRequest}
}

// CreateProfilingGroupRequest is the request type for the
// CreateProfilingGroup API operation.
type CreateProfilingGroupRequest struct {
	*aws.Request
	Input *CreateProfilingGroupInput
	Copy  func(*CreateProfilingGroupInput) CreateProfilingGroupRequest
}

// Send marshals and sends the CreateProfilingGroup API request.
func (r CreateProfilingGroupRequest) Send(ctx context.Context) (*CreateProfilingGroupResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &CreateProfilingGroupResponse{
		CreateProfilingGroupOutput: r.Request.Data.(*CreateProfilingGroupOutput),
		response:                   &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// CreateProfilingGroupResponse is the response type for the
// CreateProfilingGroup API operation.
type CreateProfilingGroupResponse struct {
	*CreateProfilingGroupOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// CreateProfilingGroup request.
func (r *CreateProfilingGroupResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
