// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package ec2

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type DescribeByoipCidrsInput struct {
	_ struct{} `type:"structure"`

	// Checks whether you have the required permissions for the action, without
	// actually making the request, and provides an error response. If you have
	// the required permissions, the error response is DryRunOperation. Otherwise,
	// it is UnauthorizedOperation.
	DryRun *bool `type:"boolean"`

	// The maximum number of results to return with a single call. To retrieve the
	// remaining results, make another call with the returned nextToken value.
	//
	// MaxResults is a required field
	MaxResults *int64 `min:"1" type:"integer" required:"true"`

	// The token for the next page of results.
	NextToken *string `type:"string"`
}

// String returns the string representation
func (s DescribeByoipCidrsInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeByoipCidrsInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "DescribeByoipCidrsInput"}

	if s.MaxResults == nil {
		invalidParams.Add(aws.NewErrParamRequired("MaxResults"))
	}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(aws.NewErrParamMinValue("MaxResults", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type DescribeByoipCidrsOutput struct {
	_ struct{} `type:"structure"`

	// Information about your address ranges.
	ByoipCidrs []ByoipCidr `locationName:"byoipCidrSet" locationNameList:"item" type:"list"`

	// The token to use to retrieve the next page of results. This value is null
	// when there are no more results to return.
	NextToken *string `locationName:"nextToken" type:"string"`
}

// String returns the string representation
func (s DescribeByoipCidrsOutput) String() string {
	return awsutil.Prettify(s)
}

const opDescribeByoipCidrs = "DescribeByoipCidrs"

// DescribeByoipCidrsRequest returns a request value for making API operation for
// Amazon Elastic Compute Cloud.
//
// Describes the IP address ranges that were specified in calls to ProvisionByoipCidr.
//
// To describe the address pools that were created when you provisioned the
// address ranges, use DescribePublicIpv4Pools.
//
//    // Example sending a request using DescribeByoipCidrsRequest.
//    req := client.DescribeByoipCidrsRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeByoipCidrs
func (c *Client) DescribeByoipCidrsRequest(input *DescribeByoipCidrsInput) DescribeByoipCidrsRequest {
	op := &aws.Operation{
		Name:       opDescribeByoipCidrs,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &aws.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &DescribeByoipCidrsInput{}
	}

	req := c.newRequest(op, input, &DescribeByoipCidrsOutput{})
	return DescribeByoipCidrsRequest{Request: req, Input: input, Copy: c.DescribeByoipCidrsRequest}
}

// DescribeByoipCidrsRequest is the request type for the
// DescribeByoipCidrs API operation.
type DescribeByoipCidrsRequest struct {
	*aws.Request
	Input *DescribeByoipCidrsInput
	Copy  func(*DescribeByoipCidrsInput) DescribeByoipCidrsRequest
}

// Send marshals and sends the DescribeByoipCidrs API request.
func (r DescribeByoipCidrsRequest) Send(ctx context.Context) (*DescribeByoipCidrsResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &DescribeByoipCidrsResponse{
		DescribeByoipCidrsOutput: r.Request.Data.(*DescribeByoipCidrsOutput),
		response:                 &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// NewDescribeByoipCidrsRequestPaginator returns a paginator for DescribeByoipCidrs.
// Use Next method to get the next page, and CurrentPage to get the current
// response page from the paginator. Next will return false, if there are
// no more pages, or an error was encountered.
//
// Note: This operation can generate multiple requests to a service.
//
//   // Example iterating over pages.
//   req := client.DescribeByoipCidrsRequest(input)
//   p := ec2.NewDescribeByoipCidrsRequestPaginator(req)
//
//   for p.Next(context.TODO()) {
//       page := p.CurrentPage()
//   }
//
//   if err := p.Err(); err != nil {
//       return err
//   }
//
func NewDescribeByoipCidrsPaginator(req DescribeByoipCidrsRequest) DescribeByoipCidrsPaginator {
	return DescribeByoipCidrsPaginator{
		Pager: aws.Pager{
			NewRequest: func(ctx context.Context) (*aws.Request, error) {
				var inCpy *DescribeByoipCidrsInput
				if req.Input != nil {
					tmp := *req.Input
					inCpy = &tmp
				}

				newReq := req.Copy(inCpy)
				newReq.SetContext(ctx)
				return newReq.Request, nil
			},
		},
	}
}

// DescribeByoipCidrsPaginator is used to paginate the request. This can be done by
// calling Next and CurrentPage.
type DescribeByoipCidrsPaginator struct {
	aws.Pager
}

func (p *DescribeByoipCidrsPaginator) CurrentPage() *DescribeByoipCidrsOutput {
	return p.Pager.CurrentPage().(*DescribeByoipCidrsOutput)
}

// DescribeByoipCidrsResponse is the response type for the
// DescribeByoipCidrs API operation.
type DescribeByoipCidrsResponse struct {
	*DescribeByoipCidrsOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// DescribeByoipCidrs request.
func (r *DescribeByoipCidrsResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
