// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package ec2

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type DescribeInstancesInput struct {
	_ struct{} `type:"structure"`

	// Checks whether you have the required permissions for the action, without
	// actually making the request, and provides an error response. If you have
	// the required permissions, the error response is DryRunOperation. Otherwise,
	// it is UnauthorizedOperation.
	DryRun *bool `locationName:"dryRun" type:"boolean"`

	// The filters.
	//
	//    * affinity - The affinity setting for an instance running on a Dedicated
	//    Host (default | host).
	//
	//    * architecture - The instance architecture (i386 | x86_64 | arm64).
	//
	//    * availability-zone - The Availability Zone of the instance.
	//
	//    * block-device-mapping.attach-time - The attach time for an EBS volume
	//    mapped to the instance, for example, 2010-09-15T17:15:20.000Z.
	//
	//    * block-device-mapping.delete-on-termination - A Boolean that indicates
	//    whether the EBS volume is deleted on instance termination.
	//
	//    * block-device-mapping.device-name - The device name specified in the
	//    block device mapping (for example, /dev/sdh or xvdh).
	//
	//    * block-device-mapping.status - The status for the EBS volume (attaching
	//    | attached | detaching | detached).
	//
	//    * block-device-mapping.volume-id - The volume ID of the EBS volume.
	//
	//    * client-token - The idempotency token you provided when you launched
	//    the instance.
	//
	//    * dns-name - The public DNS name of the instance.
	//
	//    * group-id - The ID of the security group for the instance. EC2-Classic
	//    only.
	//
	//    * group-name - The name of the security group for the instance. EC2-Classic
	//    only.
	//
	//    * hibernation-options.configured - A Boolean that indicates whether the
	//    instance is enabled for hibernation. A value of true means that the instance
	//    is enabled for hibernation.
	//
	//    * host-id - The ID of the Dedicated Host on which the instance is running,
	//    if applicable.
	//
	//    * hypervisor - The hypervisor type of the instance (ovm | xen).
	//
	//    * iam-instance-profile.arn - The instance profile associated with the
	//    instance. Specified as an ARN. image-id - The ID of the image used to
	//    launch the instance.
	//
	//    * instance-id - The ID of the instance.
	//
	//    * instance-lifecycle - Indicates whether this is a Spot Instance or a
	//    Scheduled Instance (spot | scheduled).
	//
	//    * instance-state-code - The state of the instance, as a 16-bit unsigned
	//    integer. The high byte is used for internal purposes and should be ignored.
	//    The low byte is set based on the state represented. The valid values are:
	//    0 (pending), 16 (running), 32 (shutting-down), 48 (terminated), 64 (stopping),
	//    and 80 (stopped).
	//
	//    * instance-state-name - The state of the instance (pending | running |
	//    shutting-down | terminated | stopping | stopped).
	//
	//    * instance-type - The type of instance (for example, t2.micro).
	//
	//    * instance.group-id - The ID of the security group for the instance.
	//
	//    * instance.group-name - The name of the security group for the instance.
	//
	//    * ip-address - The public IPv4 address of the instance.
	//
	//    * kernel-id - The kernel ID.
	//
	//    * key-name - The name of the key pair used when the instance was launched.
	//
	//    * launch-index - When launching multiple instances, this is the index
	//    for the instance in the launch group (for example, 0, 1, 2, and so on).
	//
	//    * launch-time - The time when the instance was launched.
	//
	//    * metadata-options.http-tokens - The metadata request authorization state
	//    (optional | required)
	//
	//    * metadata-options.http-put-response-hop-limit - The http metadata request
	//    put response hop limit (integer, possible values 1 to 64)
	//
	//    * metadata-options.http-endpoint - Enable or disable metadata access on
	//    http endpoint (enabled | disabled)
	//
	//    * monitoring-state - Indicates whether detailed monitoring is enabled
	//    (disabled | enabled).
	//
	//    * network-interface.addresses.private-ip-address - The private IPv4 address
	//    associated with the network interface.
	//
	//    * network-interface.addresses.primary - Specifies whether the IPv4 address
	//    of the network interface is the primary private IPv4 address.
	//
	//    * network-interface.addresses.association.public-ip - The ID of the association
	//    of an Elastic IP address (IPv4) with a network interface.
	//
	//    * network-interface.addresses.association.ip-owner-id - The owner ID of
	//    the private IPv4 address associated with the network interface.
	//
	//    * network-interface.association.public-ip - The address of the Elastic
	//    IP address (IPv4) bound to the network interface.
	//
	//    * network-interface.association.ip-owner-id - The owner of the Elastic
	//    IP address (IPv4) associated with the network interface.
	//
	//    * network-interface.association.allocation-id - The allocation ID returned
	//    when you allocated the Elastic IP address (IPv4) for your network interface.
	//
	//    * network-interface.association.association-id - The association ID returned
	//    when the network interface was associated with an IPv4 address.
	//
	//    * network-interface.attachment.attachment-id - The ID of the interface
	//    attachment.
	//
	//    * network-interface.attachment.instance-id - The ID of the instance to
	//    which the network interface is attached.
	//
	//    * network-interface.attachment.instance-owner-id - The owner ID of the
	//    instance to which the network interface is attached.
	//
	//    * network-interface.attachment.device-index - The device index to which
	//    the network interface is attached.
	//
	//    * network-interface.attachment.status - The status of the attachment (attaching
	//    | attached | detaching | detached).
	//
	//    * network-interface.attachment.attach-time - The time that the network
	//    interface was attached to an instance.
	//
	//    * network-interface.attachment.delete-on-termination - Specifies whether
	//    the attachment is deleted when an instance is terminated.
	//
	//    * network-interface.availability-zone - The Availability Zone for the
	//    network interface.
	//
	//    * network-interface.description - The description of the network interface.
	//
	//    * network-interface.group-id - The ID of a security group associated with
	//    the network interface.
	//
	//    * network-interface.group-name - The name of a security group associated
	//    with the network interface.
	//
	//    * network-interface.ipv6-addresses.ipv6-address - The IPv6 address associated
	//    with the network interface.
	//
	//    * network-interface.mac-address - The MAC address of the network interface.
	//
	//    * network-interface.network-interface-id - The ID of the network interface.
	//
	//    * network-interface.owner-id - The ID of the owner of the network interface.
	//
	//    * network-interface.private-dns-name - The private DNS name of the network
	//    interface.
	//
	//    * network-interface.requester-id - The requester ID for the network interface.
	//
	//    * network-interface.requester-managed - Indicates whether the network
	//    interface is being managed by AWS.
	//
	//    * network-interface.status - The status of the network interface (available)
	//    | in-use).
	//
	//    * network-interface.source-dest-check - Whether the network interface
	//    performs source/destination checking. A value of true means that checking
	//    is enabled, and false means that checking is disabled. The value must
	//    be false for the network interface to perform network address translation
	//    (NAT) in your VPC.
	//
	//    * network-interface.subnet-id - The ID of the subnet for the network interface.
	//
	//    * network-interface.vpc-id - The ID of the VPC for the network interface.
	//
	//    * owner-id - The AWS account ID of the instance owner.
	//
	//    * placement-group-name - The name of the placement group for the instance.
	//
	//    * placement-partition-number - The partition in which the instance is
	//    located.
	//
	//    * platform - The platform. To list only Windows instances, use windows.
	//
	//    * private-dns-name - The private IPv4 DNS name of the instance.
	//
	//    * private-ip-address - The private IPv4 address of the instance.
	//
	//    * product-code - The product code associated with the AMI used to launch
	//    the instance.
	//
	//    * product-code.type - The type of product code (devpay | marketplace).
	//
	//    * ramdisk-id - The RAM disk ID.
	//
	//    * reason - The reason for the current state of the instance (for example,
	//    shows "User Initiated [date]" when you stop or terminate the instance).
	//    Similar to the state-reason-code filter.
	//
	//    * requester-id - The ID of the entity that launched the instance on your
	//    behalf (for example, AWS Management Console, Auto Scaling, and so on).
	//
	//    * reservation-id - The ID of the instance's reservation. A reservation
	//    ID is created any time you launch an instance. A reservation ID has a
	//    one-to-one relationship with an instance launch request, but can be associated
	//    with more than one instance if you launch multiple instances using the
	//    same launch request. For example, if you launch one instance, you get
	//    one reservation ID. If you launch ten instances using the same launch
	//    request, you also get one reservation ID.
	//
	//    * root-device-name - The device name of the root device volume (for example,
	//    /dev/sda1).
	//
	//    * root-device-type - The type of the root device volume (ebs | instance-store).
	//
	//    * source-dest-check - Indicates whether the instance performs source/destination
	//    checking. A value of true means that checking is enabled, and false means
	//    that checking is disabled. The value must be false for the instance to
	//    perform network address translation (NAT) in your VPC.
	//
	//    * spot-instance-request-id - The ID of the Spot Instance request.
	//
	//    * state-reason-code - The reason code for the state change.
	//
	//    * state-reason-message - A message that describes the state change.
	//
	//    * subnet-id - The ID of the subnet for the instance.
	//
	//    * tag:<key> - The key/value combination of a tag assigned to the resource.
	//    Use the tag key in the filter name and the tag value as the filter value.
	//    For example, to find all resources that have a tag with the key Owner
	//    and the value TeamA, specify tag:Owner for the filter name and TeamA for
	//    the filter value.
	//
	//    * tag-key - The key of a tag assigned to the resource. Use this filter
	//    to find all resources that have a tag with a specific key, regardless
	//    of the tag value.
	//
	//    * tenancy - The tenancy of an instance (dedicated | default | host).
	//
	//    * virtualization-type - The virtualization type of the instance (paravirtual
	//    | hvm).
	//
	//    * vpc-id - The ID of the VPC that the instance is running in.
	Filters []Filter `locationName:"Filter" locationNameList:"Filter" type:"list"`

	// The instance IDs.
	//
	// Default: Describes all your instances.
	InstanceIds []string `locationName:"InstanceId" locationNameList:"InstanceId" type:"list"`

	// The maximum number of results to return in a single call. To retrieve the
	// remaining results, make another call with the returned NextToken value. This
	// value can be between 5 and 1000. You cannot specify this parameter and the
	// instance IDs parameter in the same call.
	MaxResults *int64 `locationName:"maxResults" type:"integer"`

	// The token to request the next page of results.
	NextToken *string `locationName:"nextToken" type:"string"`
}

// String returns the string representation
func (s DescribeInstancesInput) String() string {
	return awsutil.Prettify(s)
}

type DescribeInstancesOutput struct {
	_ struct{} `type:"structure"`

	// The token to use to retrieve the next page of results. This value is null
	// when there are no more results to return.
	NextToken *string `locationName:"nextToken" type:"string"`

	// Information about the reservations.
	Reservations []Reservation `locationName:"reservationSet" locationNameList:"item" type:"list"`
}

// String returns the string representation
func (s DescribeInstancesOutput) String() string {
	return awsutil.Prettify(s)
}

const opDescribeInstances = "DescribeInstances"

// DescribeInstancesRequest returns a request value for making API operation for
// Amazon Elastic Compute Cloud.
//
// Describes the specified instances or all of AWS account's instances.
//
// If you specify one or more instance IDs, Amazon EC2 returns information for
// those instances. If you do not specify instance IDs, Amazon EC2 returns information
// for all relevant instances. If you specify an instance ID that is not valid,
// an error is returned. If you specify an instance that you do not own, it
// is not included in the returned results.
//
// Recently terminated instances might appear in the returned results. This
// interval is usually less than one hour.
//
// If you describe instances in the rare case where an Availability Zone is
// experiencing a service disruption and you specify instance IDs that are in
// the affected zone, or do not specify any instance IDs at all, the call fails.
// If you describe instances and specify only instance IDs that are in an unaffected
// zone, the call works normally.
//
//    // Example sending a request using DescribeInstancesRequest.
//    req := client.DescribeInstancesRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeInstances
func (c *Client) DescribeInstancesRequest(input *DescribeInstancesInput) DescribeInstancesRequest {
	op := &aws.Operation{
		Name:       opDescribeInstances,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &aws.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &DescribeInstancesInput{}
	}

	req := c.newRequest(op, input, &DescribeInstancesOutput{})
	return DescribeInstancesRequest{Request: req, Input: input, Copy: c.DescribeInstancesRequest}
}

// DescribeInstancesRequest is the request type for the
// DescribeInstances API operation.
type DescribeInstancesRequest struct {
	*aws.Request
	Input *DescribeInstancesInput
	Copy  func(*DescribeInstancesInput) DescribeInstancesRequest
}

// Send marshals and sends the DescribeInstances API request.
func (r DescribeInstancesRequest) Send(ctx context.Context) (*DescribeInstancesResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &DescribeInstancesResponse{
		DescribeInstancesOutput: r.Request.Data.(*DescribeInstancesOutput),
		response:                &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// NewDescribeInstancesRequestPaginator returns a paginator for DescribeInstances.
// Use Next method to get the next page, and CurrentPage to get the current
// response page from the paginator. Next will return false, if there are
// no more pages, or an error was encountered.
//
// Note: This operation can generate multiple requests to a service.
//
//   // Example iterating over pages.
//   req := client.DescribeInstancesRequest(input)
//   p := ec2.NewDescribeInstancesRequestPaginator(req)
//
//   for p.Next(context.TODO()) {
//       page := p.CurrentPage()
//   }
//
//   if err := p.Err(); err != nil {
//       return err
//   }
//
func NewDescribeInstancesPaginator(req DescribeInstancesRequest) DescribeInstancesPaginator {
	return DescribeInstancesPaginator{
		Pager: aws.Pager{
			NewRequest: func(ctx context.Context) (*aws.Request, error) {
				var inCpy *DescribeInstancesInput
				if req.Input != nil {
					tmp := *req.Input
					inCpy = &tmp
				}

				newReq := req.Copy(inCpy)
				newReq.SetContext(ctx)
				return newReq.Request, nil
			},
		},
	}
}

// DescribeInstancesPaginator is used to paginate the request. This can be done by
// calling Next and CurrentPage.
type DescribeInstancesPaginator struct {
	aws.Pager
}

func (p *DescribeInstancesPaginator) CurrentPage() *DescribeInstancesOutput {
	return p.Pager.CurrentPage().(*DescribeInstancesOutput)
}

// DescribeInstancesResponse is the response type for the
// DescribeInstances API operation.
type DescribeInstancesResponse struct {
	*DescribeInstancesOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// DescribeInstances request.
func (r *DescribeInstancesResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
