// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package elasticache

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

// Represents the input of a ModifyCacheParameterGroup operation.
type ModifyCacheParameterGroupInput struct {
	_ struct{} `type:"structure"`

	// The name of the cache parameter group to modify.
	//
	// CacheParameterGroupName is a required field
	CacheParameterGroupName *string `type:"string" required:"true"`

	// An array of parameter names and values for the parameter update. You must
	// supply at least one parameter name and value; subsequent arguments are optional.
	// A maximum of 20 parameters may be modified per request.
	//
	// ParameterNameValues is a required field
	ParameterNameValues []ParameterNameValue `locationNameList:"ParameterNameValue" type:"list" required:"true"`
}

// String returns the string representation
func (s ModifyCacheParameterGroupInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ModifyCacheParameterGroupInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "ModifyCacheParameterGroupInput"}

	if s.CacheParameterGroupName == nil {
		invalidParams.Add(aws.NewErrParamRequired("CacheParameterGroupName"))
	}

	if s.ParameterNameValues == nil {
		invalidParams.Add(aws.NewErrParamRequired("ParameterNameValues"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Represents the output of one of the following operations:
//
//    * ModifyCacheParameterGroup
//
//    * ResetCacheParameterGroup
type ModifyCacheParameterGroupOutput struct {
	_ struct{} `type:"structure"`

	// The name of the cache parameter group.
	CacheParameterGroupName *string `type:"string"`
}

// String returns the string representation
func (s ModifyCacheParameterGroupOutput) String() string {
	return awsutil.Prettify(s)
}

const opModifyCacheParameterGroup = "ModifyCacheParameterGroup"

// ModifyCacheParameterGroupRequest returns a request value for making API operation for
// Amazon ElastiCache.
//
// Modifies the parameters of a cache parameter group. You can modify up to
// 20 parameters in a single request by submitting a list parameter name and
// value pairs.
//
//    // Example sending a request using ModifyCacheParameterGroupRequest.
//    req := client.ModifyCacheParameterGroupRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/elasticache-2015-02-02/ModifyCacheParameterGroup
func (c *Client) ModifyCacheParameterGroupRequest(input *ModifyCacheParameterGroupInput) ModifyCacheParameterGroupRequest {
	op := &aws.Operation{
		Name:       opModifyCacheParameterGroup,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ModifyCacheParameterGroupInput{}
	}

	req := c.newRequest(op, input, &ModifyCacheParameterGroupOutput{})
	return ModifyCacheParameterGroupRequest{Request: req, Input: input, Copy: c.ModifyCacheParameterGroupRequest}
}

// ModifyCacheParameterGroupRequest is the request type for the
// ModifyCacheParameterGroup API operation.
type ModifyCacheParameterGroupRequest struct {
	*aws.Request
	Input *ModifyCacheParameterGroupInput
	Copy  func(*ModifyCacheParameterGroupInput) ModifyCacheParameterGroupRequest
}

// Send marshals and sends the ModifyCacheParameterGroup API request.
func (r ModifyCacheParameterGroupRequest) Send(ctx context.Context) (*ModifyCacheParameterGroupResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &ModifyCacheParameterGroupResponse{
		ModifyCacheParameterGroupOutput: r.Request.Data.(*ModifyCacheParameterGroupOutput),
		response:                        &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// ModifyCacheParameterGroupResponse is the response type for the
// ModifyCacheParameterGroup API operation.
type ModifyCacheParameterGroupResponse struct {
	*ModifyCacheParameterGroupOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// ModifyCacheParameterGroup request.
func (r *ModifyCacheParameterGroupResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
