// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package elasticbeanstalk

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

// Request to execute a scheduled managed action immediately.
type ApplyEnvironmentManagedActionInput struct {
	_ struct{} `type:"structure"`

	// The action ID of the scheduled managed action to execute.
	//
	// ActionId is a required field
	ActionId *string `type:"string" required:"true"`

	// The environment ID of the target environment.
	EnvironmentId *string `type:"string"`

	// The name of the target environment.
	EnvironmentName *string `type:"string"`
}

// String returns the string representation
func (s ApplyEnvironmentManagedActionInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ApplyEnvironmentManagedActionInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "ApplyEnvironmentManagedActionInput"}

	if s.ActionId == nil {
		invalidParams.Add(aws.NewErrParamRequired("ActionId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// The result message containing information about the managed action.
type ApplyEnvironmentManagedActionOutput struct {
	_ struct{} `type:"structure"`

	// A description of the managed action.
	ActionDescription *string `type:"string"`

	// The action ID of the managed action.
	ActionId *string `type:"string"`

	// The type of managed action.
	ActionType ActionType `type:"string" enum:"true"`

	// The status of the managed action.
	Status *string `type:"string"`
}

// String returns the string representation
func (s ApplyEnvironmentManagedActionOutput) String() string {
	return awsutil.Prettify(s)
}

const opApplyEnvironmentManagedAction = "ApplyEnvironmentManagedAction"

// ApplyEnvironmentManagedActionRequest returns a request value for making API operation for
// AWS Elastic Beanstalk.
//
// Applies a scheduled managed action immediately. A managed action can be applied
// only if its status is Scheduled. Get the status and action ID of a managed
// action with DescribeEnvironmentManagedActions.
//
//    // Example sending a request using ApplyEnvironmentManagedActionRequest.
//    req := client.ApplyEnvironmentManagedActionRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/elasticbeanstalk-2010-12-01/ApplyEnvironmentManagedAction
func (c *Client) ApplyEnvironmentManagedActionRequest(input *ApplyEnvironmentManagedActionInput) ApplyEnvironmentManagedActionRequest {
	op := &aws.Operation{
		Name:       opApplyEnvironmentManagedAction,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ApplyEnvironmentManagedActionInput{}
	}

	req := c.newRequest(op, input, &ApplyEnvironmentManagedActionOutput{})
	return ApplyEnvironmentManagedActionRequest{Request: req, Input: input, Copy: c.ApplyEnvironmentManagedActionRequest}
}

// ApplyEnvironmentManagedActionRequest is the request type for the
// ApplyEnvironmentManagedAction API operation.
type ApplyEnvironmentManagedActionRequest struct {
	*aws.Request
	Input *ApplyEnvironmentManagedActionInput
	Copy  func(*ApplyEnvironmentManagedActionInput) ApplyEnvironmentManagedActionRequest
}

// Send marshals and sends the ApplyEnvironmentManagedAction API request.
func (r ApplyEnvironmentManagedActionRequest) Send(ctx context.Context) (*ApplyEnvironmentManagedActionResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &ApplyEnvironmentManagedActionResponse{
		ApplyEnvironmentManagedActionOutput: r.Request.Data.(*ApplyEnvironmentManagedActionOutput),
		response:                            &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// ApplyEnvironmentManagedActionResponse is the response type for the
// ApplyEnvironmentManagedAction API operation.
type ApplyEnvironmentManagedActionResponse struct {
	*ApplyEnvironmentManagedActionOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// ApplyEnvironmentManagedAction request.
func (r *ApplyEnvironmentManagedActionResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
