// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package iotanalytics

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
	"github.com/aws/aws-sdk-go-v2/private/protocol/restjson"
)

type DeleteChannelInput struct {
	_ struct{} `type:"structure"`

	// The name of the channel to delete.
	//
	// ChannelName is a required field
	ChannelName *string `location:"uri" locationName:"channelName" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteChannelInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteChannelInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "DeleteChannelInput"}

	if s.ChannelName == nil {
		invalidParams.Add(aws.NewErrParamRequired("ChannelName"))
	}
	if s.ChannelName != nil && len(*s.ChannelName) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("ChannelName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s DeleteChannelInput) MarshalFields(e protocol.FieldEncoder) error {
	e.SetValue(protocol.HeaderTarget, "Content-Type", protocol.StringValue("application/json"), protocol.Metadata{})

	if s.ChannelName != nil {
		v := *s.ChannelName

		metadata := protocol.Metadata{}
		e.SetValue(protocol.PathTarget, "channelName", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

type DeleteChannelOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteChannelOutput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s DeleteChannelOutput) MarshalFields(e protocol.FieldEncoder) error {
	return nil
}

const opDeleteChannel = "DeleteChannel"

// DeleteChannelRequest returns a request value for making API operation for
// AWS IoT Analytics.
//
// Deletes the specified channel.
//
//    // Example sending a request using DeleteChannelRequest.
//    req := client.DeleteChannelRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/iotanalytics-2017-11-27/DeleteChannel
func (c *Client) DeleteChannelRequest(input *DeleteChannelInput) DeleteChannelRequest {
	op := &aws.Operation{
		Name:       opDeleteChannel,
		HTTPMethod: "DELETE",
		HTTPPath:   "/channels/{channelName}",
	}

	if input == nil {
		input = &DeleteChannelInput{}
	}

	req := c.newRequest(op, input, &DeleteChannelOutput{})
	req.Handlers.Unmarshal.Remove(restjson.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)
	return DeleteChannelRequest{Request: req, Input: input, Copy: c.DeleteChannelRequest}
}

// DeleteChannelRequest is the request type for the
// DeleteChannel API operation.
type DeleteChannelRequest struct {
	*aws.Request
	Input *DeleteChannelInput
	Copy  func(*DeleteChannelInput) DeleteChannelRequest
}

// Send marshals and sends the DeleteChannel API request.
func (r DeleteChannelRequest) Send(ctx context.Context) (*DeleteChannelResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &DeleteChannelResponse{
		DeleteChannelOutput: r.Request.Data.(*DeleteChannelOutput),
		response:            &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// DeleteChannelResponse is the response type for the
// DeleteChannel API operation.
type DeleteChannelResponse struct {
	*DeleteChannelOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// DeleteChannel request.
func (r *DeleteChannelResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
