// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

// Package kinesisanalyticsiface provides an interface to enable mocking the Amazon Kinesis Analytics service client
// for testing your code.
//
// It is important to note that this interface will have breaking changes
// when the service model is updated and adds new API operations, paginators,
// and waiters.
package kinesisanalyticsiface

import (
	"github.com/aws/aws-sdk-go-v2/service/kinesisanalytics"
)

// ClientAPI provides an interface to enable mocking the
// kinesisanalytics.Client methods. This make unit testing your code that
// calls out to the SDK's service client's calls easier.
//
// The best way to use this interface is so the SDK's service client's calls
// can be stubbed out for unit testing your code with the SDK without needing
// to inject custom request handlers into the SDK's request pipeline.
//
//    // myFunc uses an SDK service client to make a request to
//    // Kinesis Analytics.
//    func myFunc(svc kinesisanalyticsiface.ClientAPI) bool {
//        // Make svc.AddApplicationCloudWatchLoggingOption request
//    }
//
//    func main() {
//        cfg, err := external.LoadDefaultAWSConfig()
//        if err != nil {
//            panic("failed to load config, " + err.Error())
//        }
//
//        svc := kinesisanalytics.New(cfg)
//
//        myFunc(svc)
//    }
//
// In your _test.go file:
//
//    // Define a mock struct to be used in your unit tests of myFunc.
//    type mockClientClient struct {
//        kinesisanalyticsiface.ClientPI
//    }
//    func (m *mockClientClient) AddApplicationCloudWatchLoggingOption(input *kinesisanalytics.AddApplicationCloudWatchLoggingOptionInput) (*kinesisanalytics.AddApplicationCloudWatchLoggingOptionOutput, error) {
//        // mock response/functionality
//    }
//
//    func TestMyFunc(t *testing.T) {
//        // Setup Test
//        mockSvc := &mockClientClient{}
//
//        myfunc(mockSvc)
//
//        // Verify myFunc's functionality
//    }
//
// It is important to note that this interface will have breaking changes
// when the service model is updated and adds new API operations, paginators,
// and waiters. Its suggested to use the pattern above for testing, or using
// tooling to generate mocks to satisfy the interfaces.
type ClientAPI interface {
	AddApplicationCloudWatchLoggingOptionRequest(*kinesisanalytics.AddApplicationCloudWatchLoggingOptionInput) kinesisanalytics.AddApplicationCloudWatchLoggingOptionRequest

	AddApplicationInputRequest(*kinesisanalytics.AddApplicationInputInput) kinesisanalytics.AddApplicationInputRequest

	AddApplicationInputProcessingConfigurationRequest(*kinesisanalytics.AddApplicationInputProcessingConfigurationInput) kinesisanalytics.AddApplicationInputProcessingConfigurationRequest

	AddApplicationOutputRequest(*kinesisanalytics.AddApplicationOutputInput) kinesisanalytics.AddApplicationOutputRequest

	AddApplicationReferenceDataSourceRequest(*kinesisanalytics.AddApplicationReferenceDataSourceInput) kinesisanalytics.AddApplicationReferenceDataSourceRequest

	CreateApplicationRequest(*kinesisanalytics.CreateApplicationInput) kinesisanalytics.CreateApplicationRequest

	DeleteApplicationRequest(*kinesisanalytics.DeleteApplicationInput) kinesisanalytics.DeleteApplicationRequest

	DeleteApplicationCloudWatchLoggingOptionRequest(*kinesisanalytics.DeleteApplicationCloudWatchLoggingOptionInput) kinesisanalytics.DeleteApplicationCloudWatchLoggingOptionRequest

	DeleteApplicationInputProcessingConfigurationRequest(*kinesisanalytics.DeleteApplicationInputProcessingConfigurationInput) kinesisanalytics.DeleteApplicationInputProcessingConfigurationRequest

	DeleteApplicationOutputRequest(*kinesisanalytics.DeleteApplicationOutputInput) kinesisanalytics.DeleteApplicationOutputRequest

	DeleteApplicationReferenceDataSourceRequest(*kinesisanalytics.DeleteApplicationReferenceDataSourceInput) kinesisanalytics.DeleteApplicationReferenceDataSourceRequest

	DescribeApplicationRequest(*kinesisanalytics.DescribeApplicationInput) kinesisanalytics.DescribeApplicationRequest

	DiscoverInputSchemaRequest(*kinesisanalytics.DiscoverInputSchemaInput) kinesisanalytics.DiscoverInputSchemaRequest

	ListApplicationsRequest(*kinesisanalytics.ListApplicationsInput) kinesisanalytics.ListApplicationsRequest

	ListTagsForResourceRequest(*kinesisanalytics.ListTagsForResourceInput) kinesisanalytics.ListTagsForResourceRequest

	StartApplicationRequest(*kinesisanalytics.StartApplicationInput) kinesisanalytics.StartApplicationRequest

	StopApplicationRequest(*kinesisanalytics.StopApplicationInput) kinesisanalytics.StopApplicationRequest

	TagResourceRequest(*kinesisanalytics.TagResourceInput) kinesisanalytics.TagResourceRequest

	UntagResourceRequest(*kinesisanalytics.UntagResourceInput) kinesisanalytics.UntagResourceRequest

	UpdateApplicationRequest(*kinesisanalytics.UpdateApplicationInput) kinesisanalytics.UpdateApplicationRequest
}

var _ ClientAPI = (*kinesisanalytics.Client)(nil)
