// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package organizations

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type UpdatePolicyInput struct {
	_ struct{} `type:"structure"`

	// If provided, the new content for the policy. The text must be correctly formatted
	// JSON that complies with the syntax for the policy's type. For more information,
	// see Service Control Policy Syntax (https://docs.aws.amazon.com/organizations/latest/userguide/orgs_reference_scp-syntax.html)
	// in the AWS Organizations User Guide.
	Content *string `min:"1" type:"string"`

	// If provided, the new description for the policy.
	Description *string `type:"string"`

	// If provided, the new name for the policy.
	//
	// The regex pattern (http://wikipedia.org/wiki/regex) that is used to validate
	// this parameter is a string of any of the characters in the ASCII character
	// range.
	Name *string `min:"1" type:"string"`

	// The unique identifier (ID) of the policy that you want to update.
	//
	// The regex pattern (http://wikipedia.org/wiki/regex) for a policy ID string
	// requires "p-" followed by from 8 to 128 lowercase letters or digits.
	//
	// PolicyId is a required field
	PolicyId *string `type:"string" required:"true"`
}

// String returns the string representation
func (s UpdatePolicyInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdatePolicyInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "UpdatePolicyInput"}
	if s.Content != nil && len(*s.Content) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("Content", 1))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("Name", 1))
	}

	if s.PolicyId == nil {
		invalidParams.Add(aws.NewErrParamRequired("PolicyId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type UpdatePolicyOutput struct {
	_ struct{} `type:"structure"`

	// A structure that contains details about the updated policy, showing the requested
	// changes.
	Policy *Policy `type:"structure"`
}

// String returns the string representation
func (s UpdatePolicyOutput) String() string {
	return awsutil.Prettify(s)
}

const opUpdatePolicy = "UpdatePolicy"

// UpdatePolicyRequest returns a request value for making API operation for
// AWS Organizations.
//
// Updates an existing policy with a new name, description, or content. If you
// don't supply any parameter, that value remains unchanged. You can't change
// a policy's type.
//
// This operation can be called only from the organization's master account.
//
//    // Example sending a request using UpdatePolicyRequest.
//    req := client.UpdatePolicyRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/organizations-2016-11-28/UpdatePolicy
func (c *Client) UpdatePolicyRequest(input *UpdatePolicyInput) UpdatePolicyRequest {
	op := &aws.Operation{
		Name:       opUpdatePolicy,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdatePolicyInput{}
	}

	req := c.newRequest(op, input, &UpdatePolicyOutput{})
	return UpdatePolicyRequest{Request: req, Input: input, Copy: c.UpdatePolicyRequest}
}

// UpdatePolicyRequest is the request type for the
// UpdatePolicy API operation.
type UpdatePolicyRequest struct {
	*aws.Request
	Input *UpdatePolicyInput
	Copy  func(*UpdatePolicyInput) UpdatePolicyRequest
}

// Send marshals and sends the UpdatePolicy API request.
func (r UpdatePolicyRequest) Send(ctx context.Context) (*UpdatePolicyResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &UpdatePolicyResponse{
		UpdatePolicyOutput: r.Request.Data.(*UpdatePolicyOutput),
		response:           &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// UpdatePolicyResponse is the response type for the
// UpdatePolicy API operation.
type UpdatePolicyResponse struct {
	*UpdatePolicyOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// UpdatePolicy request.
func (r *UpdatePolicyResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
