// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package rds

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type DeleteDBProxyInput struct {
	_ struct{} `type:"structure"`

	// The name of the DB proxy to delete.
	//
	// DBProxyName is a required field
	DBProxyName *string `type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteDBProxyInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteDBProxyInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "DeleteDBProxyInput"}

	if s.DBProxyName == nil {
		invalidParams.Add(aws.NewErrParamRequired("DBProxyName"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type DeleteDBProxyOutput struct {
	_ struct{} `type:"structure"`

	// The data structure representing the details of the DB proxy that you delete.
	DBProxy *DBProxy `type:"structure"`
}

// String returns the string representation
func (s DeleteDBProxyOutput) String() string {
	return awsutil.Prettify(s)
}

const opDeleteDBProxy = "DeleteDBProxy"

// DeleteDBProxyRequest returns a request value for making API operation for
// Amazon Relational Database Service.
//
//
// This is prerelease documentation for the RDS Database Proxy feature in preview
// release. It is subject to change.
//
// Deletes an existing proxy.
//
//    // Example sending a request using DeleteDBProxyRequest.
//    req := client.DeleteDBProxyRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DeleteDBProxy
func (c *Client) DeleteDBProxyRequest(input *DeleteDBProxyInput) DeleteDBProxyRequest {
	op := &aws.Operation{
		Name:       opDeleteDBProxy,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteDBProxyInput{}
	}

	req := c.newRequest(op, input, &DeleteDBProxyOutput{})
	return DeleteDBProxyRequest{Request: req, Input: input, Copy: c.DeleteDBProxyRequest}
}

// DeleteDBProxyRequest is the request type for the
// DeleteDBProxy API operation.
type DeleteDBProxyRequest struct {
	*aws.Request
	Input *DeleteDBProxyInput
	Copy  func(*DeleteDBProxyInput) DeleteDBProxyRequest
}

// Send marshals and sends the DeleteDBProxy API request.
func (r DeleteDBProxyRequest) Send(ctx context.Context) (*DeleteDBProxyResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &DeleteDBProxyResponse{
		DeleteDBProxyOutput: r.Request.Data.(*DeleteDBProxyOutput),
		response:            &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// DeleteDBProxyResponse is the response type for the
// DeleteDBProxy API operation.
type DeleteDBProxyResponse struct {
	*DeleteDBProxyOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// DeleteDBProxy request.
func (r *DeleteDBProxyResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
