// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package databasemigrationservice

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type DescribeRefreshSchemasStatusInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) string that uniquely identifies the endpoint.
	//
	// EndpointArn is a required field
	EndpointArn *string `type:"string" required:"true"`
}

// String returns the string representation
func (s DescribeRefreshSchemasStatusInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeRefreshSchemasStatusInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "DescribeRefreshSchemasStatusInput"}

	if s.EndpointArn == nil {
		invalidParams.Add(aws.NewErrParamRequired("EndpointArn"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type DescribeRefreshSchemasStatusOutput struct {
	_ struct{} `type:"structure"`

	// The status of the schema.
	RefreshSchemasStatus *RefreshSchemasStatus `type:"structure"`
}

// String returns the string representation
func (s DescribeRefreshSchemasStatusOutput) String() string {
	return awsutil.Prettify(s)
}

const opDescribeRefreshSchemasStatus = "DescribeRefreshSchemasStatus"

// DescribeRefreshSchemasStatusRequest returns a request value for making API operation for
// AWS Database Migration Service.
//
// Returns the status of the RefreshSchemas operation.
//
//    // Example sending a request using DescribeRefreshSchemasStatusRequest.
//    req := client.DescribeRefreshSchemasStatusRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DescribeRefreshSchemasStatus
func (c *Client) DescribeRefreshSchemasStatusRequest(input *DescribeRefreshSchemasStatusInput) DescribeRefreshSchemasStatusRequest {
	op := &aws.Operation{
		Name:       opDescribeRefreshSchemasStatus,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeRefreshSchemasStatusInput{}
	}

	req := c.newRequest(op, input, &DescribeRefreshSchemasStatusOutput{})
	return DescribeRefreshSchemasStatusRequest{Request: req, Input: input, Copy: c.DescribeRefreshSchemasStatusRequest}
}

// DescribeRefreshSchemasStatusRequest is the request type for the
// DescribeRefreshSchemasStatus API operation.
type DescribeRefreshSchemasStatusRequest struct {
	*aws.Request
	Input *DescribeRefreshSchemasStatusInput
	Copy  func(*DescribeRefreshSchemasStatusInput) DescribeRefreshSchemasStatusRequest
}

// Send marshals and sends the DescribeRefreshSchemasStatus API request.
func (r DescribeRefreshSchemasStatusRequest) Send(ctx context.Context) (*DescribeRefreshSchemasStatusResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &DescribeRefreshSchemasStatusResponse{
		DescribeRefreshSchemasStatusOutput: r.Request.Data.(*DescribeRefreshSchemasStatusOutput),
		response:                           &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// DescribeRefreshSchemasStatusResponse is the response type for the
// DescribeRefreshSchemasStatus API operation.
type DescribeRefreshSchemasStatusResponse struct {
	*DescribeRefreshSchemasStatusOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// DescribeRefreshSchemasStatus request.
func (r *DescribeRefreshSchemasStatusResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
