// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package fsx

import (
	"fmt"
	"time"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

var _ aws.Config
var _ = awsutil.Prettify

// The Microsoft AD attributes of the Amazon FSx for Windows File Server file
// system.
type ActiveDirectoryBackupAttributes struct {
	_ struct{} `type:"structure"`

	// The ID of the AWS Managed Microsoft Active Directory instance to which the
	// file system is joined.
	ActiveDirectoryId *string `min:"12" type:"string"`

	// The fully qualified domain name of the self-managed AD directory.
	DomainName *string `type:"string"`
}

// String returns the string representation
func (s ActiveDirectoryBackupAttributes) String() string {
	return awsutil.Prettify(s)
}

// A backup of an Amazon FSx for Windows File Server file system. You can create
// a new file system from a backup to protect against data loss.
type Backup struct {
	_ struct{} `type:"structure"`

	// The ID of the backup.
	//
	// BackupId is a required field
	BackupId *string `min:"12" type:"string" required:"true"`

	// The time when a particular backup was created.
	//
	// CreationTime is a required field
	CreationTime *time.Time `type:"timestamp" required:"true"`

	// The configuration of the self-managed Microsoft Active Directory (AD) to
	// which the Windows File Server instance is joined.
	DirectoryInformation *ActiveDirectoryBackupAttributes `type:"structure"`

	// Details explaining any failures that occur when creating a backup.
	FailureDetails *BackupFailureDetails `type:"structure"`

	// Metadata of the file system associated with the backup. This metadata is
	// persisted even if the file system is deleted.
	//
	// FileSystem is a required field
	FileSystem *FileSystem `type:"structure" required:"true"`

	// The ID of the AWS Key Management Service (AWS KMS) key used to encrypt this
	// backup's data.
	KmsKeyId *string `min:"1" type:"string"`

	// The lifecycle status of the backup.
	//
	// Lifecycle is a required field
	Lifecycle BackupLifecycle `type:"string" required:"true" enum:"true"`

	// The current percent of progress of an asynchronous task.
	ProgressPercent *int64 `type:"integer"`

	// The Amazon Resource Name (ARN) for the backup resource.
	ResourceARN *string `min:"8" type:"string"`

	// Tags associated with a particular file system.
	Tags []Tag `min:"1" type:"list"`

	// The type of the backup.
	//
	// Type is a required field
	Type BackupType `type:"string" required:"true" enum:"true"`
}

// String returns the string representation
func (s Backup) String() string {
	return awsutil.Prettify(s)
}

// If backup creation fails, this structure contains the details of that failure.
type BackupFailureDetails struct {
	_ struct{} `type:"structure"`

	// A message describing the backup creation failure.
	Message *string `min:"1" type:"string"`
}

// String returns the string representation
func (s BackupFailureDetails) String() string {
	return awsutil.Prettify(s)
}

// The Lustre configuration for the file system being created. This value is
// required if FileSystemType is set to LUSTRE.
type CreateFileSystemLustreConfiguration struct {
	_ struct{} `type:"structure"`

	// (Optional) The path in Amazon S3 where the root of your Amazon FSx file system
	// is exported. The path must use the same Amazon S3 bucket as specified in
	// ImportPath. You can provide an optional prefix to which new and changed data
	// is to be exported from your Amazon FSx for Lustre file system. If an ExportPath
	// value is not provided, Amazon FSx sets a default export path, s3://import-bucket/FSxLustre[creation-timestamp].
	// The timestamp is in UTC format, for example s3://import-bucket/FSxLustre20181105T222312Z.
	//
	// The Amazon S3 export bucket must be the same as the import bucket specified
	// by ImportPath. If you only specify a bucket name, such as s3://import-bucket,
	// you get a 1:1 mapping of file system objects to S3 bucket objects. This mapping
	// means that the input data in S3 is overwritten on export. If you provide
	// a custom prefix in the export path, such as s3://import-bucket/[custom-optional-prefix],
	// Amazon FSx exports the contents of your file system to that export prefix
	// in the Amazon S3 bucket.
	ExportPath *string `min:"3" type:"string"`

	// (Optional) The path to the Amazon S3 bucket (including the optional prefix)
	// that you're using as the data repository for your Amazon FSx for Lustre file
	// system. The root of your FSx for Lustre file system will be mapped to the
	// root of the Amazon S3 bucket you select. An example is s3://import-bucket/optional-prefix.
	// If you specify a prefix after the Amazon S3 bucket name, only object keys
	// with that prefix are loaded into the file system.
	ImportPath *string `min:"3" type:"string"`

	// (Optional) For files imported from a data repository, this value determines
	// the stripe count and maximum amount of data per file (in MiB) stored on a
	// single physical disk. The maximum number of disks that a single file can
	// be striped across is limited by the total number of disks that make up the
	// file system.
	//
	// The chunk size default is 1,024 MiB (1 GiB) and can go as high as 512,000
	// MiB (500 GiB). Amazon S3 objects have a maximum size of 5 TB.
	ImportedFileChunkSize *int64 `min:"1" type:"integer"`

	// The preferred time to perform weekly maintenance, in the UTC time zone.
	WeeklyMaintenanceStartTime *string `min:"7" type:"string"`
}

// String returns the string representation
func (s CreateFileSystemLustreConfiguration) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateFileSystemLustreConfiguration) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "CreateFileSystemLustreConfiguration"}
	if s.ExportPath != nil && len(*s.ExportPath) < 3 {
		invalidParams.Add(aws.NewErrParamMinLen("ExportPath", 3))
	}
	if s.ImportPath != nil && len(*s.ImportPath) < 3 {
		invalidParams.Add(aws.NewErrParamMinLen("ImportPath", 3))
	}
	if s.ImportedFileChunkSize != nil && *s.ImportedFileChunkSize < 1 {
		invalidParams.Add(aws.NewErrParamMinValue("ImportedFileChunkSize", 1))
	}
	if s.WeeklyMaintenanceStartTime != nil && len(*s.WeeklyMaintenanceStartTime) < 7 {
		invalidParams.Add(aws.NewErrParamMinLen("WeeklyMaintenanceStartTime", 7))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// The configuration object for the Microsoft Windows file system used in CreateFileSystem
// and CreateFileSystemFromBackup operations.
type CreateFileSystemWindowsConfiguration struct {
	_ struct{} `type:"structure"`

	// The ID for an existing AWS Managed Microsoft Active Directory (AD) instance
	// that the file system should join when it's created.
	ActiveDirectoryId *string `min:"12" type:"string"`

	// The number of days to retain automatic backups. The default is to retain
	// backups for 7 days. Setting this value to 0 disables the creation of automatic
	// backups. The maximum retention period for backups is 35 days.
	AutomaticBackupRetentionDays *int64 `type:"integer"`

	// A boolean flag indicating whether tags for the file system should be copied
	// to backups. This value defaults to false. If it's set to true, all tags for
	// the file system are copied to all automatic and user-initiated backups where
	// the user doesn't specify tags. If this value is true, and you specify one
	// or more tags, only the specified tags are copied to backups.
	CopyTagsToBackups *bool `type:"boolean"`

	// The preferred time to take daily automatic backups, formatted HH:MM in the
	// UTC time zone.
	DailyAutomaticBackupStartTime *string `min:"5" type:"string"`

	// Specifies the file system deployment type, valid values are the following:
	//
	//    * MULTI_AZ_1 - Deploys a high availability file system that is configured
	//    for Multi-AZ redundancy to tolerate temporary Availability Zone (AZ) unavailability.
	//    You can only deploy a Multi-AZ file system in AWS Regions that have a
	//    minimum of three Availability Zones.
	//
	//    * SINGLE_AZ_1 - (Default) Choose to deploy a file system that is configured
	//    for single AZ redundancy.
	//
	// To learn more about high availability Multi-AZ file systems, see High Availability
	// for Amazon FSx for Windows File Server (https://docs.aws.amazon.com/fsx/latest/WindowsGuide/high-availability-multiAZ.html).
	DeploymentType WindowsDeploymentType `type:"string" enum:"true"`

	// Required when DeploymentType is set to MULTI_AZ_1. This specifies the subnet
	// in which you want the preferred file server to be located. For in-AWS applications,
	// we recommend that you launch your clients in the same Availability Zone (AZ)
	// as your preferred file server to reduce cross-AZ data transfer costs and
	// minimize latency.
	PreferredSubnetId *string `min:"15" type:"string"`

	// The configuration that Amazon FSx uses to join the Windows File Server instance
	// to your self-managed (including on-premises) Microsoft Active Directory (AD)
	// directory.
	SelfManagedActiveDirectoryConfiguration *SelfManagedActiveDirectoryConfiguration `type:"structure"`

	// The throughput of an Amazon FSx file system, measured in megabytes per second,
	// in 2 to the nth increments, between 2^3 (8) and 2^11 (2048).
	//
	// ThroughputCapacity is a required field
	ThroughputCapacity *int64 `min:"8" type:"integer" required:"true"`

	// The preferred start time to perform weekly maintenance, formatted d:HH:MM
	// in the UTC time zone.
	WeeklyMaintenanceStartTime *string `min:"7" type:"string"`
}

// String returns the string representation
func (s CreateFileSystemWindowsConfiguration) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateFileSystemWindowsConfiguration) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "CreateFileSystemWindowsConfiguration"}
	if s.ActiveDirectoryId != nil && len(*s.ActiveDirectoryId) < 12 {
		invalidParams.Add(aws.NewErrParamMinLen("ActiveDirectoryId", 12))
	}
	if s.DailyAutomaticBackupStartTime != nil && len(*s.DailyAutomaticBackupStartTime) < 5 {
		invalidParams.Add(aws.NewErrParamMinLen("DailyAutomaticBackupStartTime", 5))
	}
	if s.PreferredSubnetId != nil && len(*s.PreferredSubnetId) < 15 {
		invalidParams.Add(aws.NewErrParamMinLen("PreferredSubnetId", 15))
	}

	if s.ThroughputCapacity == nil {
		invalidParams.Add(aws.NewErrParamRequired("ThroughputCapacity"))
	}
	if s.ThroughputCapacity != nil && *s.ThroughputCapacity < 8 {
		invalidParams.Add(aws.NewErrParamMinValue("ThroughputCapacity", 8))
	}
	if s.WeeklyMaintenanceStartTime != nil && len(*s.WeeklyMaintenanceStartTime) < 7 {
		invalidParams.Add(aws.NewErrParamMinLen("WeeklyMaintenanceStartTime", 7))
	}
	if s.SelfManagedActiveDirectoryConfiguration != nil {
		if err := s.SelfManagedActiveDirectoryConfiguration.Validate(); err != nil {
			invalidParams.AddNested("SelfManagedActiveDirectoryConfiguration", err.(aws.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// The data repository configuration object for Lustre file systems returned
// in the response of the CreateFileSystem operation.
type DataRepositoryConfiguration struct {
	_ struct{} `type:"structure"`

	// The export path to the Amazon S3 bucket (and prefix) that you are using to
	// store new and changed Lustre file system files in S3.
	ExportPath *string `min:"3" type:"string"`

	// The import path to the Amazon S3 bucket (and optional prefix) that you're
	// using as the data repository for your FSx for Lustre file system, for example
	// s3://import-bucket/optional-prefix. If a prefix is specified after the Amazon
	// S3 bucket name, only object keys with that prefix are loaded into the file
	// system.
	ImportPath *string `min:"3" type:"string"`

	// For files imported from a data repository, this value determines the stripe
	// count and maximum amount of data per file (in MiB) stored on a single physical
	// disk. The maximum number of disks that a single file can be striped across
	// is limited by the total number of disks that make up the file system.
	//
	// The default chunk size is 1,024 MiB (1 GiB) and can go as high as 512,000
	// MiB (500 GiB). Amazon S3 objects have a maximum size of 5 TB.
	ImportedFileChunkSize *int64 `min:"1" type:"integer"`
}

// String returns the string representation
func (s DataRepositoryConfiguration) String() string {
	return awsutil.Prettify(s)
}

// The configuration object for the Microsoft Windows file system used in the
// DeleteFileSystem operation.
type DeleteFileSystemWindowsConfiguration struct {
	_ struct{} `type:"structure"`

	// A set of tags for your final backup.
	FinalBackupTags []Tag `min:"1" type:"list"`

	// By default, Amazon FSx for Windows takes a final backup on your behalf when
	// the DeleteFileSystem operation is invoked. Doing this helps protect you from
	// data loss, and we highly recommend taking the final backup. If you want to
	// skip this backup, use this flag to do so.
	SkipFinalBackup *bool `type:"boolean"`
}

// String returns the string representation
func (s DeleteFileSystemWindowsConfiguration) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteFileSystemWindowsConfiguration) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "DeleteFileSystemWindowsConfiguration"}
	if s.FinalBackupTags != nil && len(s.FinalBackupTags) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("FinalBackupTags", 1))
	}
	if s.FinalBackupTags != nil {
		for i, v := range s.FinalBackupTags {
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "FinalBackupTags", i), err.(aws.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// The response object for the Microsoft Windows file system used in the DeleteFileSystem
// operation.
type DeleteFileSystemWindowsResponse struct {
	_ struct{} `type:"structure"`

	// The ID of the final backup for this file system.
	FinalBackupId *string `min:"12" type:"string"`

	// The set of tags applied to the final backup.
	FinalBackupTags []Tag `min:"1" type:"list"`
}

// String returns the string representation
func (s DeleteFileSystemWindowsResponse) String() string {
	return awsutil.Prettify(s)
}

// A description of a specific Amazon FSx file system.
type FileSystem struct {
	_ struct{} `type:"structure"`

	// The time that the file system was created, in seconds (since 1970-01-01T00:00:00Z),
	// also known as Unix time.
	CreationTime *time.Time `type:"timestamp"`

	// The DNS name for the file system.
	DNSName *string `min:"16" type:"string"`

	// A structure providing details of any failures that occur when creating the
	// file system has failed.
	FailureDetails *FileSystemFailureDetails `type:"structure"`

	// The system-generated, unique 17-digit ID of the file system.
	FileSystemId *string `min:"11" type:"string"`

	// The type of Amazon FSx file system, either LUSTRE or WINDOWS.
	FileSystemType FileSystemType `type:"string" enum:"true"`

	// The ID of the AWS Key Management Service (AWS KMS) key used to encrypt the
	// file system's data for an Amazon FSx for Windows File Server file system.
	KmsKeyId *string `min:"1" type:"string"`

	// The lifecycle status of the file system, following are the possible values
	// and what they mean:
	//
	//    * AVAILABLE - The file system is in a healthy state, and is reachable
	//    and available for use.
	//
	//    * CREATING - Amazon FSx is creating the new file system.
	//
	//    * DELETING - Amazon FSx is deleting an existing file system.
	//
	//    * FAILED - An existing file system has experienced an unrecoverable failure.
	//    When creating a new file system, Amazon FSx was unable to create the file
	//    system.
	//
	//    * MISCONFIGURED indicates that the file system is in a failed but recoverable
	//    state.
	//
	//    * UPDATING indicates that the file system is undergoing a customer initiated
	//    update.
	Lifecycle FileSystemLifecycle `type:"string" enum:"true"`

	// The configuration for the Amazon FSx for Lustre file system.
	LustreConfiguration *LustreFileSystemConfiguration `type:"structure"`

	// The IDs of the elastic network interface from which a specific file system
	// is accessible. The elastic network interface is automatically created in
	// the same VPC that the Amazon FSx file system was created in. For more information,
	// see Elastic Network Interfaces (https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/using-eni.html)
	// in the Amazon EC2 User Guide.
	//
	// For an Amazon FSx for Windows File Server file system, you can have one network
	// interface ID. For an Amazon FSx for Lustre file system, you can have more
	// than one.
	NetworkInterfaceIds []string `type:"list"`

	// The AWS account that created the file system. If the file system was created
	// by an AWS Identity and Access Management (IAM) user, the AWS account to which
	// the IAM user belongs is the owner.
	OwnerId *string `min:"12" type:"string"`

	// The Amazon Resource Name (ARN) for the file system resource.
	ResourceARN *string `min:"8" type:"string"`

	// The storage capacity of the file system in gigabytes (GB).
	StorageCapacity *int64 `min:"1" type:"integer"`

	// The ID of the subnet to contain the endpoint for the file system. One and
	// only one is supported. The file system is launched in the Availability Zone
	// associated with this subnet.
	SubnetIds []string `type:"list"`

	// The tags to associate with the file system. For more information, see Tagging
	// Your Amazon EC2 Resources (https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/Using_Tags.html)
	// in the Amazon EC2 User Guide.
	Tags []Tag `min:"1" type:"list"`

	// The ID of the primary VPC for the file system.
	VpcId *string `min:"12" type:"string"`

	// The configuration for this Microsoft Windows file system.
	WindowsConfiguration *WindowsFileSystemConfiguration `type:"structure"`
}

// String returns the string representation
func (s FileSystem) String() string {
	return awsutil.Prettify(s)
}

// A structure providing details of any failures that occur when creating the
// file system has failed.
type FileSystemFailureDetails struct {
	_ struct{} `type:"structure"`

	// A message describing any failures that occurred during file system creation.
	Message *string `min:"1" type:"string"`
}

// String returns the string representation
func (s FileSystemFailureDetails) String() string {
	return awsutil.Prettify(s)
}

// A filter used to restrict the results of describe calls. You can use multiple
// filters to return results that meet all applied filter requirements.
type Filter struct {
	_ struct{} `type:"structure"`

	// The name for this filter.
	Name FilterName `type:"string" enum:"true"`

	// The values of the filter. These are all the values for any of the applied
	// filters.
	Values []string `type:"list"`
}

// String returns the string representation
func (s Filter) String() string {
	return awsutil.Prettify(s)
}

// The configuration for the Amazon FSx for Lustre file system.
type LustreFileSystemConfiguration struct {
	_ struct{} `type:"structure"`

	// The data repository configuration object for Lustre file systems returned
	// in the response of the CreateFileSystem operation.
	DataRepositoryConfiguration *DataRepositoryConfiguration `type:"structure"`

	// The UTC time that you want to begin your weekly maintenance window.
	WeeklyMaintenanceStartTime *string `min:"7" type:"string"`
}

// String returns the string representation
func (s LustreFileSystemConfiguration) String() string {
	return awsutil.Prettify(s)
}

// The configuration of the self-managed Microsoft Active Directory (AD) directory
// to which the Windows File Server instance is joined.
type SelfManagedActiveDirectoryAttributes struct {
	_ struct{} `type:"structure"`

	// A list of up to two IP addresses of DNS servers or domain controllers in
	// the self-managed AD directory.
	DnsIps []string `min:"1" type:"list"`

	// The fully qualified domain name of the self-managed AD directory.
	DomainName *string `type:"string"`

	// The name of the domain group whose members have administrative privileges
	// for the FSx file system.
	FileSystemAdministratorsGroup *string `min:"1" type:"string"`

	// The fully qualified distinguished name of the organizational unit within
	// the self-managed AD directory to which the Windows File Server instance is
	// joined.
	OrganizationalUnitDistinguishedName *string `min:"1" type:"string"`

	// The user name for the service account on your self-managed AD domain that
	// FSx uses to join to your AD domain.
	UserName *string `min:"1" type:"string"`
}

// String returns the string representation
func (s SelfManagedActiveDirectoryAttributes) String() string {
	return awsutil.Prettify(s)
}

// The configuration that Amazon FSx uses to join the Windows File Server instance
// to your self-managed (including on-premises) Microsoft Active Directory (AD)
// directory.
type SelfManagedActiveDirectoryConfiguration struct {
	_ struct{} `type:"structure"`

	// A list of up to two IP addresses of DNS servers or domain controllers in
	// the self-managed AD directory. The IP addresses need to be either in the
	// same VPC CIDR range as the one in which your Amazon FSx file system is being
	// created, or in the private IP version 4 (Iv4) address ranges, as specified
	// in RFC 1918 (http://www.faqs.org/rfcs/rfc1918.html):
	//
	//    * 10.0.0.0 - 10.255.255.255 (10/8 prefix)
	//
	//    * 172.16.0.0 - 172.31.255.255 (172.16/12 prefix)
	//
	//    * 192.168.0.0 - 192.168.255.255 (192.168/16 prefix)
	//
	// DnsIps is a required field
	DnsIps []string `min:"1" type:"list" required:"true"`

	// The fully qualified domain name of the self-managed AD directory, such as
	// corp.example.com.
	//
	// DomainName is a required field
	DomainName *string `type:"string" required:"true"`

	// (Optional) The name of the domain group whose members are granted administrative
	// privileges for the file system. Administrative privileges include taking
	// ownership of files and folders, setting audit controls (audit ACLs) on files
	// and folders, and administering the file system remotely by using the FSx
	// Remote PowerShell. The group that you specify must already exist in your
	// domain. If you don't provide one, your AD domain's Domain Admins group is
	// used.
	FileSystemAdministratorsGroup *string `min:"1" type:"string"`

	// (Optional) The fully qualified distinguished name of the organizational unit
	// within your self-managed AD directory that the Windows File Server instance
	// will join. Amazon FSx only accepts OU as the direct parent of the file system.
	// An example is OU=FSx,DC=yourdomain,DC=corp,DC=com. To learn more, see RFC
	// 2253 (https://tools.ietf.org/html/rfc2253). If none is provided, the FSx
	// file system is created in the default location of your self-managed AD directory.
	//
	// Only Organizational Unit (OU) objects can be the direct parent of the file
	// system that you're creating.
	OrganizationalUnitDistinguishedName *string `min:"1" type:"string"`

	// The password for the service account on your self-managed AD domain that
	// Amazon FSx will use to join to your AD domain.
	//
	// Password is a required field
	Password *string `min:"1" type:"string" required:"true" sensitive:"true"`

	// The user name for the service account on your self-managed AD domain that
	// Amazon FSx will use to join to your AD domain. This account must have the
	// permission to join computers to the domain in the organizational unit provided
	// in OrganizationalUnitDistinguishedName, or in the default location of your
	// AD domain.
	//
	// UserName is a required field
	UserName *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s SelfManagedActiveDirectoryConfiguration) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *SelfManagedActiveDirectoryConfiguration) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "SelfManagedActiveDirectoryConfiguration"}

	if s.DnsIps == nil {
		invalidParams.Add(aws.NewErrParamRequired("DnsIps"))
	}
	if s.DnsIps != nil && len(s.DnsIps) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("DnsIps", 1))
	}

	if s.DomainName == nil {
		invalidParams.Add(aws.NewErrParamRequired("DomainName"))
	}
	if s.FileSystemAdministratorsGroup != nil && len(*s.FileSystemAdministratorsGroup) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("FileSystemAdministratorsGroup", 1))
	}
	if s.OrganizationalUnitDistinguishedName != nil && len(*s.OrganizationalUnitDistinguishedName) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("OrganizationalUnitDistinguishedName", 1))
	}

	if s.Password == nil {
		invalidParams.Add(aws.NewErrParamRequired("Password"))
	}
	if s.Password != nil && len(*s.Password) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("Password", 1))
	}

	if s.UserName == nil {
		invalidParams.Add(aws.NewErrParamRequired("UserName"))
	}
	if s.UserName != nil && len(*s.UserName) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("UserName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// The configuration that Amazon FSx uses to join the Windows File Server instance
// to the self-managed Microsoft Active Directory (AD) directory.
type SelfManagedActiveDirectoryConfigurationUpdates struct {
	_ struct{} `type:"structure"`

	// A list of up to two IP addresses of DNS servers or domain controllers in
	// the self-managed AD directory.
	DnsIps []string `min:"1" type:"list"`

	// The password for the service account on your self-managed AD domain that
	// Amazon FSx will use to join to your AD domain.
	Password *string `min:"1" type:"string" sensitive:"true"`

	// The user name for the service account on your self-managed AD domain that
	// Amazon FSx will use to join to your AD domain. This account must have the
	// permission to join computers to the domain in the organizational unit provided
	// in OrganizationalUnitDistinguishedName.
	UserName *string `min:"1" type:"string"`
}

// String returns the string representation
func (s SelfManagedActiveDirectoryConfigurationUpdates) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *SelfManagedActiveDirectoryConfigurationUpdates) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "SelfManagedActiveDirectoryConfigurationUpdates"}
	if s.DnsIps != nil && len(s.DnsIps) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("DnsIps", 1))
	}
	if s.Password != nil && len(*s.Password) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("Password", 1))
	}
	if s.UserName != nil && len(*s.UserName) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("UserName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Specifies a key-value pair for a resource tag.
type Tag struct {
	_ struct{} `type:"structure"`

	// A value that specifies the TagKey, the name of the tag. Tag keys must be
	// unique for the resource to which they are attached.
	Key *string `min:"1" type:"string"`

	// A value that specifies the TagValue, the value assigned to the corresponding
	// tag key. Tag values can be null and don't have to be unique in a tag set.
	// For example, you can have a key-value pair in a tag set of finances : April
	// and also of payroll : April.
	Value *string `type:"string"`
}

// String returns the string representation
func (s Tag) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Tag) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "Tag"}
	if s.Key != nil && len(*s.Key) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("Key", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// The configuration object for Amazon FSx for Lustre file systems used in the
// UpdateFileSystem operation.
type UpdateFileSystemLustreConfiguration struct {
	_ struct{} `type:"structure"`

	// The preferred time to perform weekly maintenance, in the UTC time zone.
	WeeklyMaintenanceStartTime *string `min:"7" type:"string"`
}

// String returns the string representation
func (s UpdateFileSystemLustreConfiguration) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateFileSystemLustreConfiguration) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "UpdateFileSystemLustreConfiguration"}
	if s.WeeklyMaintenanceStartTime != nil && len(*s.WeeklyMaintenanceStartTime) < 7 {
		invalidParams.Add(aws.NewErrParamMinLen("WeeklyMaintenanceStartTime", 7))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Updates the Microsoft Windows configuration for an existing Amazon FSx for
// Windows File Server file system. Amazon FSx overwrites existing properties
// with non-null values provided in the request. If you don't specify a non-null
// value for a property, that property is not updated.
type UpdateFileSystemWindowsConfiguration struct {
	_ struct{} `type:"structure"`

	// The number of days to retain automatic backups. Setting this to 0 disables
	// automatic backups. You can retain automatic backups for a maximum of 35 days.
	AutomaticBackupRetentionDays *int64 `type:"integer"`

	// The preferred time to take daily automatic backups, in the UTC time zone.
	DailyAutomaticBackupStartTime *string `min:"5" type:"string"`

	// The configuration Amazon FSx uses to join the Windows File Server instance
	// to the self-managed Microsoft AD directory.
	SelfManagedActiveDirectoryConfiguration *SelfManagedActiveDirectoryConfigurationUpdates `type:"structure"`

	// The preferred time to perform weekly maintenance, in the UTC time zone.
	WeeklyMaintenanceStartTime *string `min:"7" type:"string"`
}

// String returns the string representation
func (s UpdateFileSystemWindowsConfiguration) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateFileSystemWindowsConfiguration) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "UpdateFileSystemWindowsConfiguration"}
	if s.DailyAutomaticBackupStartTime != nil && len(*s.DailyAutomaticBackupStartTime) < 5 {
		invalidParams.Add(aws.NewErrParamMinLen("DailyAutomaticBackupStartTime", 5))
	}
	if s.WeeklyMaintenanceStartTime != nil && len(*s.WeeklyMaintenanceStartTime) < 7 {
		invalidParams.Add(aws.NewErrParamMinLen("WeeklyMaintenanceStartTime", 7))
	}
	if s.SelfManagedActiveDirectoryConfiguration != nil {
		if err := s.SelfManagedActiveDirectoryConfiguration.Validate(); err != nil {
			invalidParams.AddNested("SelfManagedActiveDirectoryConfiguration", err.(aws.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// The configuration for this Microsoft Windows file system.
type WindowsFileSystemConfiguration struct {
	_ struct{} `type:"structure"`

	// The ID for an existing Microsoft Active Directory instance that the file
	// system should join when it's created.
	ActiveDirectoryId *string `min:"12" type:"string"`

	// The number of days to retain automatic backups. Setting this to 0 disables
	// automatic backups. You can retain automatic backups for a maximum of 35 days.
	AutomaticBackupRetentionDays *int64 `type:"integer"`

	// A boolean flag indicating whether tags on the file system should be copied
	// to backups. This value defaults to false. If it's set to true, all tags on
	// the file system are copied to all automatic backups and any user-initiated
	// backups where the user doesn't specify any tags. If this value is true, and
	// you specify one or more tags, only the specified tags are copied to backups.
	CopyTagsToBackups *bool `type:"boolean"`

	// The preferred time to take daily automatic backups, in the UTC time zone.
	DailyAutomaticBackupStartTime *string `min:"5" type:"string"`

	// Specifies the file system deployment type, valid values are the following:
	//
	//    * MULTI_AZ_1 - Specifies a high availability file system that is configured
	//    for Multi-AZ redundancy to tolerate temporary Availability Zone (AZ) unavailability.
	//
	//    * SINGLE_AZ_1 - (Default) Specifies a file system that is configured for
	//    single AZ redundancy.
	DeploymentType WindowsDeploymentType `type:"string" enum:"true"`

	// The list of maintenance operations in progress for this file system.
	MaintenanceOperationsInProgress []FileSystemMaintenanceOperation `type:"list"`

	// For MULTI_AZ_1 deployment types, the IP address of the primary, or preferred,
	// file server.
	//
	// Use this IP address when mounting the file system on Linux SMB clients or
	// Windows SMB clients that are not joined to a Microsoft Active Directory.
	// Applicable for both SINGLE_AZ_1 and MULTI_AZ_1 deployment types. This IP
	// address is temporarily unavailable when the file system is undergoing maintenance.
	// For Linux and Windows SMB clients that are joined to an Active Directory,
	// use the file system's DNSName instead. For more information and instruction
	// on mapping and mounting file shares, see https://docs.aws.amazon.com/fsx/latest/WindowsGuide/accessing-file-shares.html
	// (https://docs.aws.amazon.com/fsx/latest/WindowsGuide/accessing-file-shares.html).
	PreferredFileServerIp *string `type:"string"`

	// For MULTI_AZ_1 deployment types, it specifies the ID of the subnet where
	// the preferred file server is located. Must be one of the two subnet IDs specified
	// in SubnetIds property. Amazon FSx serves traffic from this subnet except
	// in the event of a failover to the secondary file server.
	//
	// For SINGLE_AZ_1 deployment types, this value is the same as that for SubnetIDs.
	PreferredSubnetId *string `min:"15" type:"string"`

	// For MULTI_AZ_1 deployment types, use this endpoint when performing administrative
	// tasks on the file system using Amazon FSx Remote PowerShell.
	//
	// For SINGLE_AZ_1 deployment types, this is the DNS name of the file system.
	//
	// This endpoint is temporarily unavailable when the file system is undergoing
	// maintenance.
	RemoteAdministrationEndpoint *string `min:"16" type:"string"`

	// The configuration of the self-managed Microsoft Active Directory (AD) directory
	// to which the Windows File Server instance is joined.
	SelfManagedActiveDirectoryConfiguration *SelfManagedActiveDirectoryAttributes `type:"structure"`

	// The throughput of an Amazon FSx file system, measured in megabytes per second.
	ThroughputCapacity *int64 `min:"8" type:"integer"`

	// The preferred time to perform weekly maintenance, in the UTC time zone.
	WeeklyMaintenanceStartTime *string `min:"7" type:"string"`
}

// String returns the string representation
func (s WindowsFileSystemConfiguration) String() string {
	return awsutil.Prettify(s)
}
