// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package rds

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type ModifyDBSubnetGroupInput struct {
	_ struct{} `type:"structure"`

	// The description for the DB subnet group.
	DBSubnetGroupDescription *string `type:"string"`

	// The name for the DB subnet group. This value is stored as a lowercase string.
	// You can't modify the default subnet group.
	//
	// Constraints: Must match the name of an existing DBSubnetGroup. Must not be
	// default.
	//
	// Example: mySubnetgroup
	//
	// DBSubnetGroupName is a required field
	DBSubnetGroupName *string `type:"string" required:"true"`

	// The EC2 subnet IDs for the DB subnet group.
	//
	// SubnetIds is a required field
	SubnetIds []string `locationNameList:"SubnetIdentifier" type:"list" required:"true"`
}

// String returns the string representation
func (s ModifyDBSubnetGroupInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ModifyDBSubnetGroupInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "ModifyDBSubnetGroupInput"}

	if s.DBSubnetGroupName == nil {
		invalidParams.Add(aws.NewErrParamRequired("DBSubnetGroupName"))
	}

	if s.SubnetIds == nil {
		invalidParams.Add(aws.NewErrParamRequired("SubnetIds"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type ModifyDBSubnetGroupOutput struct {
	_ struct{} `type:"structure"`

	// Contains the details of an Amazon RDS DB subnet group.
	//
	// This data type is used as a response element in the DescribeDBSubnetGroups
	// action.
	DBSubnetGroup *DBSubnetGroup `type:"structure"`
}

// String returns the string representation
func (s ModifyDBSubnetGroupOutput) String() string {
	return awsutil.Prettify(s)
}

const opModifyDBSubnetGroup = "ModifyDBSubnetGroup"

// ModifyDBSubnetGroupRequest returns a request value for making API operation for
// Amazon Relational Database Service.
//
// Modifies an existing DB subnet group. DB subnet groups must contain at least
// one subnet in at least two AZs in the AWS Region.
//
//    // Example sending a request using ModifyDBSubnetGroupRequest.
//    req := client.ModifyDBSubnetGroupRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/ModifyDBSubnetGroup
func (c *Client) ModifyDBSubnetGroupRequest(input *ModifyDBSubnetGroupInput) ModifyDBSubnetGroupRequest {
	op := &aws.Operation{
		Name:       opModifyDBSubnetGroup,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ModifyDBSubnetGroupInput{}
	}

	req := c.newRequest(op, input, &ModifyDBSubnetGroupOutput{})
	return ModifyDBSubnetGroupRequest{Request: req, Input: input, Copy: c.ModifyDBSubnetGroupRequest}
}

// ModifyDBSubnetGroupRequest is the request type for the
// ModifyDBSubnetGroup API operation.
type ModifyDBSubnetGroupRequest struct {
	*aws.Request
	Input *ModifyDBSubnetGroupInput
	Copy  func(*ModifyDBSubnetGroupInput) ModifyDBSubnetGroupRequest
}

// Send marshals and sends the ModifyDBSubnetGroup API request.
func (r ModifyDBSubnetGroupRequest) Send(ctx context.Context) (*ModifyDBSubnetGroupResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &ModifyDBSubnetGroupResponse{
		ModifyDBSubnetGroupOutput: r.Request.Data.(*ModifyDBSubnetGroupOutput),
		response:                  &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// ModifyDBSubnetGroupResponse is the response type for the
// ModifyDBSubnetGroup API operation.
type ModifyDBSubnetGroupResponse struct {
	*ModifyDBSubnetGroupOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// ModifyDBSubnetGroup request.
func (r *ModifyDBSubnetGroupResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
