package security

// Copyright (c) Microsoft and contributors.  All rights reserved.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
// http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//
// See the License for the specific language governing permissions and
// limitations under the License.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"context"
	"encoding/json"
	"github.com/Azure/go-autorest/autorest"
	"github.com/Azure/go-autorest/autorest/date"
	"github.com/Azure/go-autorest/autorest/to"
	"github.com/Azure/go-autorest/tracing"
	"github.com/satori/go.uuid"
	"net/http"
)

// The package's fully qualified name.
const fqdn = "github.com/Azure/azure-sdk-for-go/services/preview/security/mgmt/v3.0/security"

// AadConnectivityState enumerates the values for aad connectivity state.
type AadConnectivityState string

const (
	// Connected ...
	Connected AadConnectivityState = "Connected"
	// Discovered ...
	Discovered AadConnectivityState = "Discovered"
	// NotLicensed ...
	NotLicensed AadConnectivityState = "NotLicensed"
)

// PossibleAadConnectivityStateValues returns an array of possible values for the AadConnectivityState const type.
func PossibleAadConnectivityStateValues() []AadConnectivityState {
	return []AadConnectivityState{Connected, Discovered, NotLicensed}
}

// Action enumerates the values for action.
type Action string

const (
	// Add ...
	Add Action = "Add"
	// Recommended ...
	Recommended Action = "Recommended"
	// Remove ...
	Remove Action = "Remove"
)

// PossibleActionValues returns an array of possible values for the Action const type.
func PossibleActionValues() []Action {
	return []Action{Add, Recommended, Remove}
}

// ActionType enumerates the values for action type.
type ActionType string

const (
	// ActionTypeAutomationAction ...
	ActionTypeAutomationAction ActionType = "AutomationAction"
	// ActionTypeEventHub ...
	ActionTypeEventHub ActionType = "EventHub"
	// ActionTypeLogicApp ...
	ActionTypeLogicApp ActionType = "LogicApp"
	// ActionTypeWorkspace ...
	ActionTypeWorkspace ActionType = "Workspace"
)

// PossibleActionTypeValues returns an array of possible values for the ActionType const type.
func PossibleActionTypeValues() []ActionType {
	return []ActionType{ActionTypeAutomationAction, ActionTypeEventHub, ActionTypeLogicApp, ActionTypeWorkspace}
}

// AlertNotifications enumerates the values for alert notifications.
type AlertNotifications string

const (
	// Off Don't get notifications on new alerts
	Off AlertNotifications = "Off"
	// On Get notifications on new alerts
	On AlertNotifications = "On"
)

// PossibleAlertNotificationsValues returns an array of possible values for the AlertNotifications const type.
func PossibleAlertNotificationsValues() []AlertNotifications {
	return []AlertNotifications{Off, On}
}

// AlertsToAdmins enumerates the values for alerts to admins.
type AlertsToAdmins string

const (
	// AlertsToAdminsOff Don't send notification on new alerts to the subscription's admins
	AlertsToAdminsOff AlertsToAdmins = "Off"
	// AlertsToAdminsOn Send notification on new alerts to the subscription's admins
	AlertsToAdminsOn AlertsToAdmins = "On"
)

// PossibleAlertsToAdminsValues returns an array of possible values for the AlertsToAdmins const type.
func PossibleAlertsToAdminsValues() []AlertsToAdmins {
	return []AlertsToAdmins{AlertsToAdminsOff, AlertsToAdminsOn}
}

// AssessedResourceType enumerates the values for assessed resource type.
type AssessedResourceType string

const (
	// AssessedResourceTypeAdditionalData ...
	AssessedResourceTypeAdditionalData AssessedResourceType = "AdditionalData"
	// AssessedResourceTypeContainerRegistryVulnerability ...
	AssessedResourceTypeContainerRegistryVulnerability AssessedResourceType = "ContainerRegistryVulnerability"
	// AssessedResourceTypeServerVulnerabilityAssessment ...
	AssessedResourceTypeServerVulnerabilityAssessment AssessedResourceType = "ServerVulnerabilityAssessment"
	// AssessedResourceTypeSQLServerVulnerability ...
	AssessedResourceTypeSQLServerVulnerability AssessedResourceType = "SqlServerVulnerability"
)

// PossibleAssessedResourceTypeValues returns an array of possible values for the AssessedResourceType const type.
func PossibleAssessedResourceTypeValues() []AssessedResourceType {
	return []AssessedResourceType{AssessedResourceTypeAdditionalData, AssessedResourceTypeContainerRegistryVulnerability, AssessedResourceTypeServerVulnerabilityAssessment, AssessedResourceTypeSQLServerVulnerability}
}

// AssessmentStatusCode enumerates the values for assessment status code.
type AssessmentStatusCode string

const (
	// Healthy The resource is healthy
	Healthy AssessmentStatusCode = "Healthy"
	// NotApplicable Assessment for this resource did not happen
	NotApplicable AssessmentStatusCode = "NotApplicable"
	// Unhealthy The resource has a security issue that needs to be addressed
	Unhealthy AssessmentStatusCode = "Unhealthy"
)

// PossibleAssessmentStatusCodeValues returns an array of possible values for the AssessmentStatusCode const type.
func PossibleAssessmentStatusCodeValues() []AssessmentStatusCode {
	return []AssessmentStatusCode{Healthy, NotApplicable, Unhealthy}
}

// AssessmentType enumerates the values for assessment type.
type AssessmentType string

const (
	// BuiltIn Azure Security Center managed assessments
	BuiltIn AssessmentType = "BuiltIn"
	// CustomerManaged User assessments pushed directly by the user or other third party to Azure Security
	// Center
	CustomerManaged AssessmentType = "CustomerManaged"
	// CustomPolicy User defined policies that are automatically ingested from Azure Policy to Azure Security
	// Center
	CustomPolicy AssessmentType = "CustomPolicy"
)

// PossibleAssessmentTypeValues returns an array of possible values for the AssessmentType const type.
func PossibleAssessmentTypeValues() []AssessmentType {
	return []AssessmentType{BuiltIn, CustomerManaged, CustomPolicy}
}

// AutoProvision enumerates the values for auto provision.
type AutoProvision string

const (
	// AutoProvisionOff Do not install security agent on the VMs automatically
	AutoProvisionOff AutoProvision = "Off"
	// AutoProvisionOn Install missing security agent on VMs automatically
	AutoProvisionOn AutoProvision = "On"
)

// PossibleAutoProvisionValues returns an array of possible values for the AutoProvision const type.
func PossibleAutoProvisionValues() []AutoProvision {
	return []AutoProvision{AutoProvisionOff, AutoProvisionOn}
}

// Category enumerates the values for category.
type Category string

const (
	// Compute ...
	Compute Category = "Compute"
	// Data ...
	Data Category = "Data"
	// IdentityAndAccess ...
	IdentityAndAccess Category = "IdentityAndAccess"
	// IoT ...
	IoT Category = "IoT"
	// Networking ...
	Networking Category = "Networking"
)

// PossibleCategoryValues returns an array of possible values for the Category const type.
func PossibleCategoryValues() []Category {
	return []Category{Compute, Data, IdentityAndAccess, IoT, Networking}
}

// ConfigurationStatus enumerates the values for configuration status.
type ConfigurationStatus string

const (
	// Configured ...
	Configured ConfigurationStatus = "Configured"
	// Failed ...
	Failed ConfigurationStatus = "Failed"
	// InProgress ...
	InProgress ConfigurationStatus = "InProgress"
	// NoStatus ...
	NoStatus ConfigurationStatus = "NoStatus"
	// NotConfigured ...
	NotConfigured ConfigurationStatus = "NotConfigured"
)

// PossibleConfigurationStatusValues returns an array of possible values for the ConfigurationStatus const type.
func PossibleConfigurationStatusValues() []ConfigurationStatus {
	return []ConfigurationStatus{Configured, Failed, InProgress, NoStatus, NotConfigured}
}

// ConfigurationStatus1 enumerates the values for configuration status 1.
type ConfigurationStatus1 string

const (
	// ConfigurationStatus1Configured ...
	ConfigurationStatus1Configured ConfigurationStatus1 = "Configured"
	// ConfigurationStatus1Failed ...
	ConfigurationStatus1Failed ConfigurationStatus1 = "Failed"
	// ConfigurationStatus1InProgress ...
	ConfigurationStatus1InProgress ConfigurationStatus1 = "InProgress"
	// ConfigurationStatus1NoStatus ...
	ConfigurationStatus1NoStatus ConfigurationStatus1 = "NoStatus"
	// ConfigurationStatus1NotConfigured ...
	ConfigurationStatus1NotConfigured ConfigurationStatus1 = "NotConfigured"
)

// PossibleConfigurationStatus1Values returns an array of possible values for the ConfigurationStatus1 const type.
func PossibleConfigurationStatus1Values() []ConfigurationStatus1 {
	return []ConfigurationStatus1{ConfigurationStatus1Configured, ConfigurationStatus1Failed, ConfigurationStatus1InProgress, ConfigurationStatus1NoStatus, ConfigurationStatus1NotConfigured}
}

// ConfigurationStatus2 enumerates the values for configuration status 2.
type ConfigurationStatus2 string

const (
	// ConfigurationStatus2Configured ...
	ConfigurationStatus2Configured ConfigurationStatus2 = "Configured"
	// ConfigurationStatus2Failed ...
	ConfigurationStatus2Failed ConfigurationStatus2 = "Failed"
	// ConfigurationStatus2InProgress ...
	ConfigurationStatus2InProgress ConfigurationStatus2 = "InProgress"
	// ConfigurationStatus2NoStatus ...
	ConfigurationStatus2NoStatus ConfigurationStatus2 = "NoStatus"
	// ConfigurationStatus2NotConfigured ...
	ConfigurationStatus2NotConfigured ConfigurationStatus2 = "NotConfigured"
)

// PossibleConfigurationStatus2Values returns an array of possible values for the ConfigurationStatus2 const type.
func PossibleConfigurationStatus2Values() []ConfigurationStatus2 {
	return []ConfigurationStatus2{ConfigurationStatus2Configured, ConfigurationStatus2Failed, ConfigurationStatus2InProgress, ConfigurationStatus2NoStatus, ConfigurationStatus2NotConfigured}
}

// ConnectionType enumerates the values for connection type.
type ConnectionType string

const (
	// External ...
	External ConnectionType = "External"
	// Internal ...
	Internal ConnectionType = "Internal"
)

// PossibleConnectionTypeValues returns an array of possible values for the ConnectionType const type.
func PossibleConnectionTypeValues() []ConnectionType {
	return []ConnectionType{External, Internal}
}

// DataSource enumerates the values for data source.
type DataSource string

const (
	// TwinData Devices twin data
	TwinData DataSource = "TwinData"
)

// PossibleDataSourceValues returns an array of possible values for the DataSource const type.
func PossibleDataSourceValues() []DataSource {
	return []DataSource{TwinData}
}

// EnforcementMode enumerates the values for enforcement mode.
type EnforcementMode string

const (
	// Audit ...
	Audit EnforcementMode = "Audit"
	// Enforce ...
	Enforce EnforcementMode = "Enforce"
	// None ...
	None EnforcementMode = "None"
)

// PossibleEnforcementModeValues returns an array of possible values for the EnforcementMode const type.
func PossibleEnforcementModeValues() []EnforcementMode {
	return []EnforcementMode{Audit, Enforce, None}
}

// EnforcementMode1 enumerates the values for enforcement mode 1.
type EnforcementMode1 string

const (
	// EnforcementMode1Audit ...
	EnforcementMode1Audit EnforcementMode1 = "Audit"
	// EnforcementMode1Enforce ...
	EnforcementMode1Enforce EnforcementMode1 = "Enforce"
	// EnforcementMode1None ...
	EnforcementMode1None EnforcementMode1 = "None"
)

// PossibleEnforcementMode1Values returns an array of possible values for the EnforcementMode1 const type.
func PossibleEnforcementMode1Values() []EnforcementMode1 {
	return []EnforcementMode1{EnforcementMode1Audit, EnforcementMode1Enforce, EnforcementMode1None}
}

// EventSource enumerates the values for event source.
type EventSource string

const (
	// Alerts ...
	Alerts EventSource = "Alerts"
	// Assessments ...
	Assessments EventSource = "Assessments"
)

// PossibleEventSourceValues returns an array of possible values for the EventSource const type.
func PossibleEventSourceValues() []EventSource {
	return []EventSource{Alerts, Assessments}
}

// Exe enumerates the values for exe.
type Exe string

const (
	// ExeAudit ...
	ExeAudit Exe = "Audit"
	// ExeEnforce ...
	ExeEnforce Exe = "Enforce"
	// ExeNone ...
	ExeNone Exe = "None"
)

// PossibleExeValues returns an array of possible values for the Exe const type.
func PossibleExeValues() []Exe {
	return []Exe{ExeAudit, ExeEnforce, ExeNone}
}

// Executable enumerates the values for executable.
type Executable string

const (
	// ExecutableAudit ...
	ExecutableAudit Executable = "Audit"
	// ExecutableEnforce ...
	ExecutableEnforce Executable = "Enforce"
	// ExecutableNone ...
	ExecutableNone Executable = "None"
)

// PossibleExecutableValues returns an array of possible values for the Executable const type.
func PossibleExecutableValues() []Executable {
	return []Executable{ExecutableAudit, ExecutableEnforce, ExecutableNone}
}

// ExpandEnum enumerates the values for expand enum.
type ExpandEnum string

const (
	// Links All links associated with an assessment
	Links ExpandEnum = "links"
	// Metadata Assessment metadata
	Metadata ExpandEnum = "metadata"
)

// PossibleExpandEnumValues returns an array of possible values for the ExpandEnum const type.
func PossibleExpandEnumValues() []ExpandEnum {
	return []ExpandEnum{Links, Metadata}
}

// ExportData enumerates the values for export data.
type ExportData string

const (
	// RawEvents Agent raw events
	RawEvents ExportData = "RawEvents"
)

// PossibleExportDataValues returns an array of possible values for the ExportData const type.
func PossibleExportDataValues() []ExportData {
	return []ExportData{RawEvents}
}

// ExternalSecuritySolutionKind enumerates the values for external security solution kind.
type ExternalSecuritySolutionKind string

const (
	// AAD ...
	AAD ExternalSecuritySolutionKind = "AAD"
	// ATA ...
	ATA ExternalSecuritySolutionKind = "ATA"
	// CEF ...
	CEF ExternalSecuritySolutionKind = "CEF"
)

// PossibleExternalSecuritySolutionKindValues returns an array of possible values for the ExternalSecuritySolutionKind const type.
func PossibleExternalSecuritySolutionKindValues() []ExternalSecuritySolutionKind {
	return []ExternalSecuritySolutionKind{AAD, ATA, CEF}
}

// Family enumerates the values for family.
type Family string

const (
	// Ngfw ...
	Ngfw Family = "Ngfw"
	// SaasWaf ...
	SaasWaf Family = "SaasWaf"
	// Va ...
	Va Family = "Va"
	// Waf ...
	Waf Family = "Waf"
)

// PossibleFamilyValues returns an array of possible values for the Family const type.
func PossibleFamilyValues() []Family {
	return []Family{Ngfw, SaasWaf, Va, Waf}
}

// FileType enumerates the values for file type.
type FileType string

const (
	// FileTypeDll ...
	FileTypeDll FileType = "Dll"
	// FileTypeExe ...
	FileTypeExe FileType = "Exe"
	// FileTypeExecutable ...
	FileTypeExecutable FileType = "Executable"
	// FileTypeMsi ...
	FileTypeMsi FileType = "Msi"
	// FileTypeScript ...
	FileTypeScript FileType = "Script"
	// FileTypeUnknown ...
	FileTypeUnknown FileType = "Unknown"
)

// PossibleFileTypeValues returns an array of possible values for the FileType const type.
func PossibleFileTypeValues() []FileType {
	return []FileType{FileTypeDll, FileTypeExe, FileTypeExecutable, FileTypeMsi, FileTypeScript, FileTypeUnknown}
}

// ImplementationEffort enumerates the values for implementation effort.
type ImplementationEffort string

const (
	// High ...
	High ImplementationEffort = "High"
	// Low ...
	Low ImplementationEffort = "Low"
	// Moderate ...
	Moderate ImplementationEffort = "Moderate"
)

// PossibleImplementationEffortValues returns an array of possible values for the ImplementationEffort const type.
func PossibleImplementationEffortValues() []ImplementationEffort {
	return []ImplementationEffort{High, Low, Moderate}
}

// Issue enumerates the values for issue.
type Issue string

const (
	// ExecutableViolationsAudited ...
	ExecutableViolationsAudited Issue = "ExecutableViolationsAudited"
	// MsiAndScriptViolationsAudited ...
	MsiAndScriptViolationsAudited Issue = "MsiAndScriptViolationsAudited"
	// MsiAndScriptViolationsBlocked ...
	MsiAndScriptViolationsBlocked Issue = "MsiAndScriptViolationsBlocked"
	// RulesViolatedManually ...
	RulesViolatedManually Issue = "RulesViolatedManually"
	// ViolationsAudited ...
	ViolationsAudited Issue = "ViolationsAudited"
	// ViolationsBlocked ...
	ViolationsBlocked Issue = "ViolationsBlocked"
)

// PossibleIssueValues returns an array of possible values for the Issue const type.
func PossibleIssueValues() []Issue {
	return []Issue{ExecutableViolationsAudited, MsiAndScriptViolationsAudited, MsiAndScriptViolationsBlocked, RulesViolatedManually, ViolationsAudited, ViolationsBlocked}
}

// KindEnum enumerates the values for kind enum.
type KindEnum string

const (
	// KindAAD ...
	KindAAD KindEnum = "AAD"
	// KindATA ...
	KindATA KindEnum = "ATA"
	// KindCEF ...
	KindCEF KindEnum = "CEF"
	// KindExternalSecuritySolution ...
	KindExternalSecuritySolution KindEnum = "ExternalSecuritySolution"
)

// PossibleKindEnumValues returns an array of possible values for the KindEnum const type.
func PossibleKindEnumValues() []KindEnum {
	return []KindEnum{KindAAD, KindATA, KindCEF, KindExternalSecuritySolution}
}

// Msi enumerates the values for msi.
type Msi string

const (
	// MsiAudit ...
	MsiAudit Msi = "Audit"
	// MsiEnforce ...
	MsiEnforce Msi = "Enforce"
	// MsiNone ...
	MsiNone Msi = "None"
)

// PossibleMsiValues returns an array of possible values for the Msi const type.
func PossibleMsiValues() []Msi {
	return []Msi{MsiAudit, MsiEnforce, MsiNone}
}

// Operator enumerates the values for operator.
type Operator string

const (
	// Contains ...
	Contains Operator = "Contains"
	// EndsWith ...
	EndsWith Operator = "EndsWith"
	// Equals ...
	Equals Operator = "Equals"
	// GreaterThan ...
	GreaterThan Operator = "GreaterThan"
	// GreaterThanOrEqualTo ...
	GreaterThanOrEqualTo Operator = "GreaterThanOrEqualTo"
	// LesserThan ...
	LesserThan Operator = "LesserThan"
	// LesserThanOrEqualTo ...
	LesserThanOrEqualTo Operator = "LesserThanOrEqualTo"
	// NotEquals ...
	NotEquals Operator = "NotEquals"
	// StartsWith ...
	StartsWith Operator = "StartsWith"
)

// PossibleOperatorValues returns an array of possible values for the Operator const type.
func PossibleOperatorValues() []Operator {
	return []Operator{Contains, EndsWith, Equals, GreaterThan, GreaterThanOrEqualTo, LesserThan, LesserThanOrEqualTo, NotEquals, StartsWith}
}

// PricingTier enumerates the values for pricing tier.
type PricingTier string

const (
	// Free Get free Azure security center experience with basic security features
	Free PricingTier = "Free"
	// Standard Get the standard Azure security center experience with advanced security features
	Standard PricingTier = "Standard"
)

// PossiblePricingTierValues returns an array of possible values for the PricingTier const type.
func PossiblePricingTierValues() []PricingTier {
	return []PricingTier{Free, Standard}
}

// PropertyType enumerates the values for property type.
type PropertyType string

const (
	// Boolean ...
	Boolean PropertyType = "Boolean"
	// Integer ...
	Integer PropertyType = "Integer"
	// Number ...
	Number PropertyType = "Number"
	// String ...
	String PropertyType = "String"
)

// PossiblePropertyTypeValues returns an array of possible values for the PropertyType const type.
func PossiblePropertyTypeValues() []PropertyType {
	return []PropertyType{Boolean, Integer, Number, String}
}

// Protocol enumerates the values for protocol.
type Protocol string

const (
	// All ...
	All Protocol = "*"
	// TCP ...
	TCP Protocol = "TCP"
	// UDP ...
	UDP Protocol = "UDP"
)

// PossibleProtocolValues returns an array of possible values for the Protocol const type.
func PossibleProtocolValues() []Protocol {
	return []Protocol{All, TCP, UDP}
}

// ProvisioningState enumerates the values for provisioning state.
type ProvisioningState string

const (
	// ProvisioningStateCanceled ...
	ProvisioningStateCanceled ProvisioningState = "Canceled"
	// ProvisioningStateDeprovisioning ...
	ProvisioningStateDeprovisioning ProvisioningState = "Deprovisioning"
	// ProvisioningStateFailed ...
	ProvisioningStateFailed ProvisioningState = "Failed"
	// ProvisioningStateProvisioning ...
	ProvisioningStateProvisioning ProvisioningState = "Provisioning"
	// ProvisioningStateSucceeded ...
	ProvisioningStateSucceeded ProvisioningState = "Succeeded"
)

// PossibleProvisioningStateValues returns an array of possible values for the ProvisioningState const type.
func PossibleProvisioningStateValues() []ProvisioningState {
	return []ProvisioningState{ProvisioningStateCanceled, ProvisioningStateDeprovisioning, ProvisioningStateFailed, ProvisioningStateProvisioning, ProvisioningStateSucceeded}
}

// RecommendationAction enumerates the values for recommendation action.
type RecommendationAction string

const (
	// RecommendationActionAdd ...
	RecommendationActionAdd RecommendationAction = "Add"
	// RecommendationActionRecommended ...
	RecommendationActionRecommended RecommendationAction = "Recommended"
	// RecommendationActionRemove ...
	RecommendationActionRemove RecommendationAction = "Remove"
)

// PossibleRecommendationActionValues returns an array of possible values for the RecommendationAction const type.
func PossibleRecommendationActionValues() []RecommendationAction {
	return []RecommendationAction{RecommendationActionAdd, RecommendationActionRecommended, RecommendationActionRemove}
}

// RecommendationAction1 enumerates the values for recommendation action 1.
type RecommendationAction1 string

const (
	// RecommendationAction1Add ...
	RecommendationAction1Add RecommendationAction1 = "Add"
	// RecommendationAction1Recommended ...
	RecommendationAction1Recommended RecommendationAction1 = "Recommended"
	// RecommendationAction1Remove ...
	RecommendationAction1Remove RecommendationAction1 = "Remove"
)

// PossibleRecommendationAction1Values returns an array of possible values for the RecommendationAction1 const type.
func PossibleRecommendationAction1Values() []RecommendationAction1 {
	return []RecommendationAction1{RecommendationAction1Add, RecommendationAction1Recommended, RecommendationAction1Remove}
}

// RecommendationConfigStatus enumerates the values for recommendation config status.
type RecommendationConfigStatus string

const (
	// Disabled ...
	Disabled RecommendationConfigStatus = "Disabled"
	// Enabled ...
	Enabled RecommendationConfigStatus = "Enabled"
)

// PossibleRecommendationConfigStatusValues returns an array of possible values for the RecommendationConfigStatus const type.
func PossibleRecommendationConfigStatusValues() []RecommendationConfigStatus {
	return []RecommendationConfigStatus{Disabled, Enabled}
}

// RecommendationStatus enumerates the values for recommendation status.
type RecommendationStatus string

const (
	// RecommendationStatusNoStatus ...
	RecommendationStatusNoStatus RecommendationStatus = "NoStatus"
	// RecommendationStatusNotAvailable ...
	RecommendationStatusNotAvailable RecommendationStatus = "NotAvailable"
	// RecommendationStatusNotRecommended ...
	RecommendationStatusNotRecommended RecommendationStatus = "NotRecommended"
	// RecommendationStatusRecommended ...
	RecommendationStatusRecommended RecommendationStatus = "Recommended"
)

// PossibleRecommendationStatusValues returns an array of possible values for the RecommendationStatus const type.
func PossibleRecommendationStatusValues() []RecommendationStatus {
	return []RecommendationStatus{RecommendationStatusNoStatus, RecommendationStatusNotAvailable, RecommendationStatusNotRecommended, RecommendationStatusRecommended}
}

// RecommendationType enumerates the values for recommendation type.
type RecommendationType string

const (
	// IoTACRAuthentication Authentication schema used for pull an edge module from an ACR repository does not
	// use Service Principal Authentication.
	IoTACRAuthentication RecommendationType = "IoT_ACRAuthentication"
	// IoTAgentSendsUnutilizedMessages IoT agent message size capacity is currently underutilized, causing an
	// increase in the number of sent messages. Adjust message intervals for better utilization.
	IoTAgentSendsUnutilizedMessages RecommendationType = "IoT_AgentSendsUnutilizedMessages"
	// IoTBaseline Identified security related system configuration issues.
	IoTBaseline RecommendationType = "IoT_Baseline"
	// IoTEdgeHubMemOptimize You can optimize Edge Hub memory usage by turning off protocol heads for any
	// protocols not used by Edge modules in your solution.
	IoTEdgeHubMemOptimize RecommendationType = "IoT_EdgeHubMemOptimize"
	// IoTEdgeLoggingOptions Logging is disabled for this edge module.
	IoTEdgeLoggingOptions RecommendationType = "IoT_EdgeLoggingOptions"
	// IoTInconsistentModuleSettings A minority within a device security group has inconsistent Edge Module
	// settings with the rest of their group.
	IoTInconsistentModuleSettings RecommendationType = "IoT_InconsistentModuleSettings"
	// IoTInstallAgent Install the Azure Security of Things Agent.
	IoTInstallAgent RecommendationType = "IoT_InstallAgent"
	// IoTIPFilterDenyAll IP Filter Configuration should have rules defined for allowed traffic and should deny
	// all other traffic by default.
	IoTIPFilterDenyAll RecommendationType = "IoT_IPFilter_DenyAll"
	// IoTIPFilterPermissiveRule An Allow IP Filter rules source IP range is too large. Overly permissive rules
	// might expose your IoT hub to malicious intenders.
	IoTIPFilterPermissiveRule RecommendationType = "IoT_IPFilter_PermissiveRule"
	// IoTOpenPorts A listening endpoint was found on the device.
	IoTOpenPorts RecommendationType = "IoT_OpenPorts"
	// IoTPermissiveFirewallPolicy An Allowed firewall policy was found (INPUT/OUTPUT). The policy should Deny
	// all traffic by default and define rules to allow necessary communication to/from the device.
	IoTPermissiveFirewallPolicy RecommendationType = "IoT_PermissiveFirewallPolicy"
	// IoTPermissiveInputFirewallRules A rule in the firewall has been found that contains a permissive pattern
	// for a wide range of IP addresses or Ports.
	IoTPermissiveInputFirewallRules RecommendationType = "IoT_PermissiveInputFirewallRules"
	// IoTPermissiveOutputFirewallRules A rule in the firewall has been found that contains a permissive
	// pattern for a wide range of IP addresses or Ports.
	IoTPermissiveOutputFirewallRules RecommendationType = "IoT_PermissiveOutputFirewallRules"
	// IoTPrivilegedDockerOptions Edge module is configured to run in privileged mode, with extensive Linux
	// capabilities or with host-level network access (send/receive data to host machine).
	IoTPrivilegedDockerOptions RecommendationType = "IoT_PrivilegedDockerOptions"
	// IoTSharedCredentials Same authentication credentials to the IoT Hub used by multiple devices. This could
	// indicate an illegitimate device impersonating a legitimate device. It also exposes the risk of device
	// impersonation by an attacker.
	IoTSharedCredentials RecommendationType = "IoT_SharedCredentials"
	// IoTVulnerableTLSCipherSuite Insecure TLS configurations detected. Immediate upgrade recommended.
	IoTVulnerableTLSCipherSuite RecommendationType = "IoT_VulnerableTLSCipherSuite"
)

// PossibleRecommendationTypeValues returns an array of possible values for the RecommendationType const type.
func PossibleRecommendationTypeValues() []RecommendationType {
	return []RecommendationType{IoTACRAuthentication, IoTAgentSendsUnutilizedMessages, IoTBaseline, IoTEdgeHubMemOptimize, IoTEdgeLoggingOptions, IoTInconsistentModuleSettings, IoTInstallAgent, IoTIPFilterDenyAll, IoTIPFilterPermissiveRule, IoTOpenPorts, IoTPermissiveFirewallPolicy, IoTPermissiveInputFirewallRules, IoTPermissiveOutputFirewallRules, IoTPrivilegedDockerOptions, IoTSharedCredentials, IoTVulnerableTLSCipherSuite}
}

// ReportedSeverity enumerates the values for reported severity.
type ReportedSeverity string

const (
	// ReportedSeverityHigh ...
	ReportedSeverityHigh ReportedSeverity = "High"
	// ReportedSeverityInformational ...
	ReportedSeverityInformational ReportedSeverity = "Informational"
	// ReportedSeverityLow ...
	ReportedSeverityLow ReportedSeverity = "Low"
	// ReportedSeverityMedium ...
	ReportedSeverityMedium ReportedSeverity = "Medium"
)

// PossibleReportedSeverityValues returns an array of possible values for the ReportedSeverity const type.
func PossibleReportedSeverityValues() []ReportedSeverity {
	return []ReportedSeverity{ReportedSeverityHigh, ReportedSeverityInformational, ReportedSeverityLow, ReportedSeverityMedium}
}

// ResourceStatus enumerates the values for resource status.
type ResourceStatus string

const (
	// ResourceStatusHealthy This assessment on the resource is healthy
	ResourceStatusHealthy ResourceStatus = "Healthy"
	// ResourceStatusNotApplicable This assessment is not applicable to this resource
	ResourceStatusNotApplicable ResourceStatus = "NotApplicable"
	// ResourceStatusNotHealthy This assessment on the resource is not healthy
	ResourceStatusNotHealthy ResourceStatus = "NotHealthy"
	// ResourceStatusOffByPolicy This assessment is turned off by policy on this subscription
	ResourceStatusOffByPolicy ResourceStatus = "OffByPolicy"
)

// PossibleResourceStatusValues returns an array of possible values for the ResourceStatus const type.
func PossibleResourceStatusValues() []ResourceStatus {
	return []ResourceStatus{ResourceStatusHealthy, ResourceStatusNotApplicable, ResourceStatusNotHealthy, ResourceStatusOffByPolicy}
}

// Script enumerates the values for script.
type Script string

const (
	// ScriptAudit ...
	ScriptAudit Script = "Audit"
	// ScriptEnforce ...
	ScriptEnforce Script = "Enforce"
	// ScriptNone ...
	ScriptNone Script = "None"
)

// PossibleScriptValues returns an array of possible values for the Script const type.
func PossibleScriptValues() []Script {
	return []Script{ScriptAudit, ScriptEnforce, ScriptNone}
}

// SettingKind enumerates the values for setting kind.
type SettingKind string

const (
	// SettingKindAlertSuppressionSetting ...
	SettingKindAlertSuppressionSetting SettingKind = "AlertSuppressionSetting"
	// SettingKindDataExportSetting ...
	SettingKindDataExportSetting SettingKind = "DataExportSetting"
)

// PossibleSettingKindValues returns an array of possible values for the SettingKind const type.
func PossibleSettingKindValues() []SettingKind {
	return []SettingKind{SettingKindAlertSuppressionSetting, SettingKindDataExportSetting}
}

// Severity enumerates the values for severity.
type Severity string

const (
	// SeverityHigh ...
	SeverityHigh Severity = "High"
	// SeverityLow ...
	SeverityLow Severity = "Low"
	// SeverityMedium ...
	SeverityMedium Severity = "Medium"
)

// PossibleSeverityValues returns an array of possible values for the Severity const type.
func PossibleSeverityValues() []Severity {
	return []Severity{SeverityHigh, SeverityLow, SeverityMedium}
}

// SolutionStatus enumerates the values for solution status.
type SolutionStatus string

const (
	// SolutionStatusDisabled ...
	SolutionStatusDisabled SolutionStatus = "Disabled"
	// SolutionStatusEnabled ...
	SolutionStatusEnabled SolutionStatus = "Enabled"
)

// PossibleSolutionStatusValues returns an array of possible values for the SolutionStatus const type.
func PossibleSolutionStatusValues() []SolutionStatus {
	return []SolutionStatus{SolutionStatusDisabled, SolutionStatusEnabled}
}

// Source enumerates the values for source.
type Source string

const (
	// SourceAzure ...
	SourceAzure Source = "Azure"
	// SourceOnPremise ...
	SourceOnPremise Source = "OnPremise"
	// SourceResourceDetails ...
	SourceResourceDetails Source = "ResourceDetails"
)

// PossibleSourceValues returns an array of possible values for the Source const type.
func PossibleSourceValues() []Source {
	return []Source{SourceAzure, SourceOnPremise, SourceResourceDetails}
}

// SourceSystem enumerates the values for source system.
type SourceSystem string

const (
	// SourceSystemAzureAppLocker ...
	SourceSystemAzureAppLocker SourceSystem = "Azure_AppLocker"
	// SourceSystemAzureAuditD ...
	SourceSystemAzureAuditD SourceSystem = "Azure_AuditD"
	// SourceSystemNonAzureAppLocker ...
	SourceSystemNonAzureAppLocker SourceSystem = "NonAzure_AppLocker"
	// SourceSystemNonAzureAuditD ...
	SourceSystemNonAzureAuditD SourceSystem = "NonAzure_AuditD"
	// SourceSystemNone ...
	SourceSystemNone SourceSystem = "None"
)

// PossibleSourceSystemValues returns an array of possible values for the SourceSystem const type.
func PossibleSourceSystemValues() []SourceSystem {
	return []SourceSystem{SourceSystemAzureAppLocker, SourceSystemAzureAuditD, SourceSystemNonAzureAppLocker, SourceSystemNonAzureAuditD, SourceSystemNone}
}

// State enumerates the values for state.
type State string

const (
	// StateFailed At least one supported regulatory compliance control in the given standard has a state of
	// failed
	StateFailed State = "Failed"
	// StatePassed All supported regulatory compliance controls in the given standard have a passed state
	StatePassed State = "Passed"
	// StateSkipped All supported regulatory compliance controls in the given standard have a state of skipped
	StateSkipped State = "Skipped"
	// StateUnsupported No supported regulatory compliance data for the given standard
	StateUnsupported State = "Unsupported"
)

// PossibleStateValues returns an array of possible values for the State const type.
func PossibleStateValues() []State {
	return []State{StateFailed, StatePassed, StateSkipped, StateUnsupported}
}

// Status enumerates the values for status.
type Status string

const (
	// Initiated ...
	Initiated Status = "Initiated"
	// Revoked ...
	Revoked Status = "Revoked"
)

// PossibleStatusValues returns an array of possible values for the Status const type.
func PossibleStatusValues() []Status {
	return []Status{Initiated, Revoked}
}

// StatusReason enumerates the values for status reason.
type StatusReason string

const (
	// Expired ...
	Expired StatusReason = "Expired"
	// NewerRequestInitiated ...
	NewerRequestInitiated StatusReason = "NewerRequestInitiated"
	// UserRequested ...
	UserRequested StatusReason = "UserRequested"
)

// PossibleStatusReasonValues returns an array of possible values for the StatusReason const type.
func PossibleStatusReasonValues() []StatusReason {
	return []StatusReason{Expired, NewerRequestInitiated, UserRequested}
}

// SubAssessmentStatusCode enumerates the values for sub assessment status code.
type SubAssessmentStatusCode string

const (
	// SubAssessmentStatusCodeHealthy The resource is healthy
	SubAssessmentStatusCodeHealthy SubAssessmentStatusCode = "Healthy"
	// SubAssessmentStatusCodeNotApplicable Assessment for this resource did not happen
	SubAssessmentStatusCodeNotApplicable SubAssessmentStatusCode = "NotApplicable"
	// SubAssessmentStatusCodeUnhealthy The resource has a security issue that needs to be addressed
	SubAssessmentStatusCodeUnhealthy SubAssessmentStatusCode = "Unhealthy"
)

// PossibleSubAssessmentStatusCodeValues returns an array of possible values for the SubAssessmentStatusCode const type.
func PossibleSubAssessmentStatusCodeValues() []SubAssessmentStatusCode {
	return []SubAssessmentStatusCode{SubAssessmentStatusCodeHealthy, SubAssessmentStatusCodeNotApplicable, SubAssessmentStatusCodeUnhealthy}
}

// Threats enumerates the values for threats.
type Threats string

const (
	// AccountBreach ...
	AccountBreach Threats = "accountBreach"
	// DataExfiltration ...
	DataExfiltration Threats = "dataExfiltration"
	// DataSpillage ...
	DataSpillage Threats = "dataSpillage"
	// DenialOfService ...
	DenialOfService Threats = "denialOfService"
	// ElevationOfPrivilege ...
	ElevationOfPrivilege Threats = "elevationOfPrivilege"
	// MaliciousInsider ...
	MaliciousInsider Threats = "maliciousInsider"
	// MissingCoverage ...
	MissingCoverage Threats = "missingCoverage"
	// ThreatResistance ...
	ThreatResistance Threats = "threatResistance"
)

// PossibleThreatsValues returns an array of possible values for the Threats const type.
func PossibleThreatsValues() []Threats {
	return []Threats{AccountBreach, DataExfiltration, DataSpillage, DenialOfService, ElevationOfPrivilege, MaliciousInsider, MissingCoverage, ThreatResistance}
}

// Type enumerates the values for type.
type Type string

const (
	// BinarySignature ...
	BinarySignature Type = "BinarySignature"
	// File ...
	File Type = "File"
	// FileHash ...
	FileHash Type = "FileHash"
	// ProductSignature ...
	ProductSignature Type = "ProductSignature"
	// PublisherSignature ...
	PublisherSignature Type = "PublisherSignature"
	// VersionAndAboveSignature ...
	VersionAndAboveSignature Type = "VersionAndAboveSignature"
)

// PossibleTypeValues returns an array of possible values for the Type const type.
func PossibleTypeValues() []Type {
	return []Type{BinarySignature, File, FileHash, ProductSignature, PublisherSignature, VersionAndAboveSignature}
}

// UnmaskedIPLoggingStatus enumerates the values for unmasked ip logging status.
type UnmaskedIPLoggingStatus string

const (
	// UnmaskedIPLoggingStatusDisabled Unmasked IP logging is disabled
	UnmaskedIPLoggingStatusDisabled UnmaskedIPLoggingStatus = "Disabled"
	// UnmaskedIPLoggingStatusEnabled Unmasked IP logging is enabled
	UnmaskedIPLoggingStatusEnabled UnmaskedIPLoggingStatus = "Enabled"
)

// PossibleUnmaskedIPLoggingStatusValues returns an array of possible values for the UnmaskedIPLoggingStatus const type.
func PossibleUnmaskedIPLoggingStatusValues() []UnmaskedIPLoggingStatus {
	return []UnmaskedIPLoggingStatus{UnmaskedIPLoggingStatusDisabled, UnmaskedIPLoggingStatusEnabled}
}

// UserImpact enumerates the values for user impact.
type UserImpact string

const (
	// UserImpactHigh ...
	UserImpactHigh UserImpact = "High"
	// UserImpactLow ...
	UserImpactLow UserImpact = "Low"
	// UserImpactModerate ...
	UserImpactModerate UserImpact = "Moderate"
)

// PossibleUserImpactValues returns an array of possible values for the UserImpact const type.
func PossibleUserImpactValues() []UserImpact {
	return []UserImpact{UserImpactHigh, UserImpactLow, UserImpactModerate}
}

// ValueType enumerates the values for value type.
type ValueType string

const (
	// ValueTypeIPCidr An IP range in CIDR format (e.g. '192.168.0.1/8').
	ValueTypeIPCidr ValueType = "IpCidr"
	// ValueTypeString Any string value.
	ValueTypeString ValueType = "String"
)

// PossibleValueTypeValues returns an array of possible values for the ValueType const type.
func PossibleValueTypeValues() []ValueType {
	return []ValueType{ValueTypeIPCidr, ValueTypeString}
}

// AadConnectivityState1 describes an Azure resource with kind
type AadConnectivityState1 struct {
	// ConnectivityState - Possible values include: 'Discovered', 'NotLicensed', 'Connected'
	ConnectivityState AadConnectivityState `json:"connectivityState,omitempty"`
}

// AadExternalSecuritySolution represents an AAD identity protection solution which sends logs to an OMS
// workspace.
type AadExternalSecuritySolution struct {
	Properties *AadSolutionProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Resource Id
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type
	Type *string `json:"type,omitempty"`
	// Location - READ-ONLY; Location where the resource is stored
	Location *string `json:"location,omitempty"`
	// Kind - Possible values include: 'KindExternalSecuritySolution', 'KindCEF', 'KindATA', 'KindAAD'
	Kind KindEnum `json:"kind,omitempty"`
}

// MarshalJSON is the custom marshaler for AadExternalSecuritySolution.
func (aess AadExternalSecuritySolution) MarshalJSON() ([]byte, error) {
	aess.Kind = KindAAD
	objectMap := make(map[string]interface{})
	if aess.Properties != nil {
		objectMap["properties"] = aess.Properties
	}
	if aess.Kind != "" {
		objectMap["kind"] = aess.Kind
	}
	return json.Marshal(objectMap)
}

// AsCefExternalSecuritySolution is the BasicExternalSecuritySolution implementation for AadExternalSecuritySolution.
func (aess AadExternalSecuritySolution) AsCefExternalSecuritySolution() (*CefExternalSecuritySolution, bool) {
	return nil, false
}

// AsAtaExternalSecuritySolution is the BasicExternalSecuritySolution implementation for AadExternalSecuritySolution.
func (aess AadExternalSecuritySolution) AsAtaExternalSecuritySolution() (*AtaExternalSecuritySolution, bool) {
	return nil, false
}

// AsAadExternalSecuritySolution is the BasicExternalSecuritySolution implementation for AadExternalSecuritySolution.
func (aess AadExternalSecuritySolution) AsAadExternalSecuritySolution() (*AadExternalSecuritySolution, bool) {
	return &aess, true
}

// AsExternalSecuritySolution is the BasicExternalSecuritySolution implementation for AadExternalSecuritySolution.
func (aess AadExternalSecuritySolution) AsExternalSecuritySolution() (*ExternalSecuritySolution, bool) {
	return nil, false
}

// AsBasicExternalSecuritySolution is the BasicExternalSecuritySolution implementation for AadExternalSecuritySolution.
func (aess AadExternalSecuritySolution) AsBasicExternalSecuritySolution() (BasicExternalSecuritySolution, bool) {
	return &aess, true
}

// AadSolutionProperties ...
type AadSolutionProperties struct {
	DeviceVendor *string             `json:"deviceVendor,omitempty"`
	DeviceType   *string             `json:"deviceType,omitempty"`
	Workspace    *ConnectedWorkspace `json:"workspace,omitempty"`
	// ConnectivityState - Possible values include: 'Discovered', 'NotLicensed', 'Connected'
	ConnectivityState AadConnectivityState `json:"connectivityState,omitempty"`
}

// BasicAdditionalData details of the sub-assessment
type BasicAdditionalData interface {
	AsSQLServerVulnerabilityProperties() (*SQLServerVulnerabilityProperties, bool)
	AsContainerRegistryVulnerabilityProperties() (*ContainerRegistryVulnerabilityProperties, bool)
	AsServerVulnerabilityProperties() (*ServerVulnerabilityProperties, bool)
	AsAdditionalData() (*AdditionalData, bool)
}

// AdditionalData details of the sub-assessment
type AdditionalData struct {
	// AssessedResourceType - Possible values include: 'AssessedResourceTypeAdditionalData', 'AssessedResourceTypeSQLServerVulnerability', 'AssessedResourceTypeContainerRegistryVulnerability', 'AssessedResourceTypeServerVulnerabilityAssessment'
	AssessedResourceType AssessedResourceType `json:"assessedResourceType,omitempty"`
}

func unmarshalBasicAdditionalData(body []byte) (BasicAdditionalData, error) {
	var m map[string]interface{}
	err := json.Unmarshal(body, &m)
	if err != nil {
		return nil, err
	}

	switch m["assessedResourceType"] {
	case string(AssessedResourceTypeSQLServerVulnerability):
		var ssvp SQLServerVulnerabilityProperties
		err := json.Unmarshal(body, &ssvp)
		return ssvp, err
	case string(AssessedResourceTypeContainerRegistryVulnerability):
		var crvp ContainerRegistryVulnerabilityProperties
		err := json.Unmarshal(body, &crvp)
		return crvp, err
	case string(AssessedResourceTypeServerVulnerabilityAssessment):
		var svp ServerVulnerabilityProperties
		err := json.Unmarshal(body, &svp)
		return svp, err
	default:
		var ad AdditionalData
		err := json.Unmarshal(body, &ad)
		return ad, err
	}
}
func unmarshalBasicAdditionalDataArray(body []byte) ([]BasicAdditionalData, error) {
	var rawMessages []*json.RawMessage
	err := json.Unmarshal(body, &rawMessages)
	if err != nil {
		return nil, err
	}

	adArray := make([]BasicAdditionalData, len(rawMessages))

	for index, rawMessage := range rawMessages {
		ad, err := unmarshalBasicAdditionalData(*rawMessage)
		if err != nil {
			return nil, err
		}
		adArray[index] = ad
	}
	return adArray, nil
}

// MarshalJSON is the custom marshaler for AdditionalData.
func (ad AdditionalData) MarshalJSON() ([]byte, error) {
	ad.AssessedResourceType = AssessedResourceTypeAdditionalData
	objectMap := make(map[string]interface{})
	if ad.AssessedResourceType != "" {
		objectMap["assessedResourceType"] = ad.AssessedResourceType
	}
	return json.Marshal(objectMap)
}

// AsSQLServerVulnerabilityProperties is the BasicAdditionalData implementation for AdditionalData.
func (ad AdditionalData) AsSQLServerVulnerabilityProperties() (*SQLServerVulnerabilityProperties, bool) {
	return nil, false
}

// AsContainerRegistryVulnerabilityProperties is the BasicAdditionalData implementation for AdditionalData.
func (ad AdditionalData) AsContainerRegistryVulnerabilityProperties() (*ContainerRegistryVulnerabilityProperties, bool) {
	return nil, false
}

// AsServerVulnerabilityProperties is the BasicAdditionalData implementation for AdditionalData.
func (ad AdditionalData) AsServerVulnerabilityProperties() (*ServerVulnerabilityProperties, bool) {
	return nil, false
}

// AsAdditionalData is the BasicAdditionalData implementation for AdditionalData.
func (ad AdditionalData) AsAdditionalData() (*AdditionalData, bool) {
	return &ad, true
}

// AsBasicAdditionalData is the BasicAdditionalData implementation for AdditionalData.
func (ad AdditionalData) AsBasicAdditionalData() (BasicAdditionalData, bool) {
	return &ad, true
}

// AdvancedThreatProtectionProperties the Advanced Threat Protection settings.
type AdvancedThreatProtectionProperties struct {
	// IsEnabled - Indicates whether Advanced Threat Protection is enabled.
	IsEnabled *bool `json:"isEnabled,omitempty"`
}

// AdvancedThreatProtectionSetting the Advanced Threat Protection resource.
type AdvancedThreatProtectionSetting struct {
	autorest.Response                   `json:"-"`
	*AdvancedThreatProtectionProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Resource Id
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for AdvancedThreatProtectionSetting.
func (atps AdvancedThreatProtectionSetting) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if atps.AdvancedThreatProtectionProperties != nil {
		objectMap["properties"] = atps.AdvancedThreatProtectionProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for AdvancedThreatProtectionSetting struct.
func (atps *AdvancedThreatProtectionSetting) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var advancedThreatProtectionProperties AdvancedThreatProtectionProperties
				err = json.Unmarshal(*v, &advancedThreatProtectionProperties)
				if err != nil {
					return err
				}
				atps.AdvancedThreatProtectionProperties = &advancedThreatProtectionProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				atps.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				atps.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				atps.Type = &typeVar
			}
		}
	}

	return nil
}

// Alert security alert
type Alert struct {
	autorest.Response `json:"-"`
	*AlertProperties  `json:"properties,omitempty"`
	// ID - READ-ONLY; Resource Id
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for Alert.
func (a Alert) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if a.AlertProperties != nil {
		objectMap["properties"] = a.AlertProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for Alert struct.
func (a *Alert) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var alertProperties AlertProperties
				err = json.Unmarshal(*v, &alertProperties)
				if err != nil {
					return err
				}
				a.AlertProperties = &alertProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				a.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				a.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				a.Type = &typeVar
			}
		}
	}

	return nil
}

// AlertConfidenceReason factors that increase our confidence that the alert is a true positive
type AlertConfidenceReason struct {
	// Type - READ-ONLY; Type of confidence factor
	Type *string `json:"type,omitempty"`
	// Reason - READ-ONLY; description of the confidence reason
	Reason *string `json:"reason,omitempty"`
}

// AlertEntity changing set of properties depending on the entity type.
type AlertEntity struct {
	// AdditionalProperties - Unmatched properties from the message are deserialized this collection
	AdditionalProperties map[string]interface{} `json:""`
	// Type - READ-ONLY; Type of entity
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for AlertEntity.
func (ae AlertEntity) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	for k, v := range ae.AdditionalProperties {
		objectMap[k] = v
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for AlertEntity struct.
func (ae *AlertEntity) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		default:
			if v != nil {
				var additionalProperties interface{}
				err = json.Unmarshal(*v, &additionalProperties)
				if err != nil {
					return err
				}
				if ae.AdditionalProperties == nil {
					ae.AdditionalProperties = make(map[string]interface{})
				}
				ae.AdditionalProperties[k] = additionalProperties
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				ae.Type = &typeVar
			}
		}
	}

	return nil
}

// AlertList list of security alerts
type AlertList struct {
	autorest.Response `json:"-"`
	Value             *[]Alert `json:"value,omitempty"`
	// NextLink - READ-ONLY; The URI to fetch the next page.
	NextLink *string `json:"nextLink,omitempty"`
}

// AlertListIterator provides access to a complete listing of Alert values.
type AlertListIterator struct {
	i    int
	page AlertListPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *AlertListIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/AlertListIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *AlertListIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter AlertListIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter AlertListIterator) Response() AlertList {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter AlertListIterator) Value() Alert {
	if !iter.page.NotDone() {
		return Alert{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the AlertListIterator type.
func NewAlertListIterator(page AlertListPage) AlertListIterator {
	return AlertListIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (al AlertList) IsEmpty() bool {
	return al.Value == nil || len(*al.Value) == 0
}

// alertListPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (al AlertList) alertListPreparer(ctx context.Context) (*http.Request, error) {
	if al.NextLink == nil || len(to.String(al.NextLink)) < 1 {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(al.NextLink)))
}

// AlertListPage contains a page of Alert values.
type AlertListPage struct {
	fn func(context.Context, AlertList) (AlertList, error)
	al AlertList
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *AlertListPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/AlertListPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	next, err := page.fn(ctx, page.al)
	if err != nil {
		return err
	}
	page.al = next
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *AlertListPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page AlertListPage) NotDone() bool {
	return !page.al.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page AlertListPage) Response() AlertList {
	return page.al
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page AlertListPage) Values() []Alert {
	if page.al.IsEmpty() {
		return nil
	}
	return *page.al.Value
}

// Creates a new instance of the AlertListPage type.
func NewAlertListPage(getNextPage func(context.Context, AlertList) (AlertList, error)) AlertListPage {
	return AlertListPage{fn: getNextPage}
}

// AlertProperties describes security alert properties.
type AlertProperties struct {
	// State - READ-ONLY; State of the alert (Active, Dismissed etc.)
	State *string `json:"state,omitempty"`
	// ReportedTimeUtc - READ-ONLY; The time the incident was reported to Microsoft.Security in UTC
	ReportedTimeUtc *date.Time `json:"reportedTimeUtc,omitempty"`
	// VendorName - READ-ONLY; Name of the vendor that discovered the incident
	VendorName *string `json:"vendorName,omitempty"`
	// AlertName - READ-ONLY; Name of the alert type
	AlertName *string `json:"alertName,omitempty"`
	// AlertDisplayName - READ-ONLY; Display name of the alert type
	AlertDisplayName *string `json:"alertDisplayName,omitempty"`
	// DetectedTimeUtc - READ-ONLY; The time the incident was detected by the vendor
	DetectedTimeUtc *date.Time `json:"detectedTimeUtc,omitempty"`
	// Description - READ-ONLY; Description of the incident and what it means
	Description *string `json:"description,omitempty"`
	// RemediationSteps - READ-ONLY; Recommended steps to reradiate the incident
	RemediationSteps *string `json:"remediationSteps,omitempty"`
	// ActionTaken - READ-ONLY; The action that was taken as a response to the alert (Active, Blocked etc.)
	ActionTaken *string `json:"actionTaken,omitempty"`
	// ReportedSeverity - READ-ONLY; Estimated severity of this alert. Possible values include: 'ReportedSeverityInformational', 'ReportedSeverityLow', 'ReportedSeverityMedium', 'ReportedSeverityHigh'
	ReportedSeverity ReportedSeverity `json:"reportedSeverity,omitempty"`
	// CompromisedEntity - READ-ONLY; The entity that the incident happened on
	CompromisedEntity *string `json:"compromisedEntity,omitempty"`
	// AssociatedResource - READ-ONLY; Azure resource ID of the associated resource
	AssociatedResource *string                `json:"associatedResource,omitempty"`
	ExtendedProperties map[string]interface{} `json:"extendedProperties"`
	// SystemSource - READ-ONLY; The type of the alerted resource (Azure, Non-Azure)
	SystemSource *string `json:"systemSource,omitempty"`
	// CanBeInvestigated - READ-ONLY; Whether this alert can be investigated with Azure Security Center
	CanBeInvestigated *bool `json:"canBeInvestigated,omitempty"`
	// IsIncident - READ-ONLY; Whether this alert is for incident type or not (otherwise - single alert)
	IsIncident *bool `json:"isIncident,omitempty"`
	// Entities - objects that are related to this alerts
	Entities *[]AlertEntity `json:"entities,omitempty"`
	// ConfidenceScore - READ-ONLY; level of confidence we have on the alert
	ConfidenceScore *float64 `json:"confidenceScore,omitempty"`
	// ConfidenceReasons - reasons the alert got the confidenceScore value
	ConfidenceReasons *[]AlertConfidenceReason `json:"confidenceReasons,omitempty"`
	// SubscriptionID - READ-ONLY; Azure subscription ID of the resource that had the security alert or the subscription ID of the workspace that this resource reports to
	SubscriptionID *string `json:"subscriptionId,omitempty"`
	// InstanceID - READ-ONLY; Instance ID of the alert.
	InstanceID *string `json:"instanceId,omitempty"`
	// WorkspaceArmID - READ-ONLY; Azure resource ID of the workspace that the alert was reported to.
	WorkspaceArmID *string `json:"workspaceArmId,omitempty"`
	// CorrelationKey - READ-ONLY; Alerts with the same CorrelationKey will be grouped together in Ibiza.
	CorrelationKey *string `json:"correlationKey,omitempty"`
}

// MarshalJSON is the custom marshaler for AlertProperties.
func (ap AlertProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if ap.ExtendedProperties != nil {
		objectMap["extendedProperties"] = ap.ExtendedProperties
	}
	if ap.Entities != nil {
		objectMap["entities"] = ap.Entities
	}
	if ap.ConfidenceReasons != nil {
		objectMap["confidenceReasons"] = ap.ConfidenceReasons
	}
	return json.Marshal(objectMap)
}

// AllowedConnectionsList list of all possible traffic between Azure resources
type AllowedConnectionsList struct {
	autorest.Response `json:"-"`
	// Value - READ-ONLY
	Value *[]AllowedConnectionsResource `json:"value,omitempty"`
	// NextLink - READ-ONLY; The URI to fetch the next page.
	NextLink *string `json:"nextLink,omitempty"`
}

// AllowedConnectionsListIterator provides access to a complete listing of AllowedConnectionsResource
// values.
type AllowedConnectionsListIterator struct {
	i    int
	page AllowedConnectionsListPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *AllowedConnectionsListIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/AllowedConnectionsListIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *AllowedConnectionsListIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter AllowedConnectionsListIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter AllowedConnectionsListIterator) Response() AllowedConnectionsList {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter AllowedConnectionsListIterator) Value() AllowedConnectionsResource {
	if !iter.page.NotDone() {
		return AllowedConnectionsResource{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the AllowedConnectionsListIterator type.
func NewAllowedConnectionsListIterator(page AllowedConnectionsListPage) AllowedConnectionsListIterator {
	return AllowedConnectionsListIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (ACL AllowedConnectionsList) IsEmpty() bool {
	return ACL.Value == nil || len(*ACL.Value) == 0
}

// allowedConnectionsListPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (ACL AllowedConnectionsList) allowedConnectionsListPreparer(ctx context.Context) (*http.Request, error) {
	if ACL.NextLink == nil || len(to.String(ACL.NextLink)) < 1 {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(ACL.NextLink)))
}

// AllowedConnectionsListPage contains a page of AllowedConnectionsResource values.
type AllowedConnectionsListPage struct {
	fn  func(context.Context, AllowedConnectionsList) (AllowedConnectionsList, error)
	ACL AllowedConnectionsList
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *AllowedConnectionsListPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/AllowedConnectionsListPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	next, err := page.fn(ctx, page.ACL)
	if err != nil {
		return err
	}
	page.ACL = next
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *AllowedConnectionsListPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page AllowedConnectionsListPage) NotDone() bool {
	return !page.ACL.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page AllowedConnectionsListPage) Response() AllowedConnectionsList {
	return page.ACL
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page AllowedConnectionsListPage) Values() []AllowedConnectionsResource {
	if page.ACL.IsEmpty() {
		return nil
	}
	return *page.ACL.Value
}

// Creates a new instance of the AllowedConnectionsListPage type.
func NewAllowedConnectionsListPage(getNextPage func(context.Context, AllowedConnectionsList) (AllowedConnectionsList, error)) AllowedConnectionsListPage {
	return AllowedConnectionsListPage{fn: getNextPage}
}

// AllowedConnectionsResource the resource whose properties describes the allowed traffic between Azure
// resources
type AllowedConnectionsResource struct {
	autorest.Response `json:"-"`
	// ID - READ-ONLY; Resource Id
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type
	Type *string `json:"type,omitempty"`
	// Location - READ-ONLY; Location where the resource is stored
	Location *string `json:"location,omitempty"`
	// AllowedConnectionsResourceProperties - READ-ONLY
	*AllowedConnectionsResourceProperties `json:"properties,omitempty"`
}

// MarshalJSON is the custom marshaler for AllowedConnectionsResource.
func (acr AllowedConnectionsResource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for AllowedConnectionsResource struct.
func (acr *AllowedConnectionsResource) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				acr.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				acr.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				acr.Type = &typeVar
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				acr.Location = &location
			}
		case "properties":
			if v != nil {
				var allowedConnectionsResourceProperties AllowedConnectionsResourceProperties
				err = json.Unmarshal(*v, &allowedConnectionsResourceProperties)
				if err != nil {
					return err
				}
				acr.AllowedConnectionsResourceProperties = &allowedConnectionsResourceProperties
			}
		}
	}

	return nil
}

// AllowedConnectionsResourceProperties describes the allowed traffic between Azure resources
type AllowedConnectionsResourceProperties struct {
	// CalculatedDateTime - READ-ONLY; The UTC time on which the allowed connections resource was calculated
	CalculatedDateTime *date.Time `json:"calculatedDateTime,omitempty"`
	// ConnectableResources - READ-ONLY; List of connectable resources
	ConnectableResources *[]ConnectableResource `json:"connectableResources,omitempty"`
}

// AllowlistCustomAlertRule a custom alert rule that checks if a value (depends on the custom alert type)
// is allowed.
type AllowlistCustomAlertRule struct {
	// AllowlistValues - The values to allow. The format of the values depends on the rule type.
	AllowlistValues *[]string `json:"allowlistValues,omitempty"`
	// ValueType - READ-ONLY; The value type of the items in the list. Possible values include: 'ValueTypeIPCidr', 'ValueTypeString'
	ValueType ValueType `json:"valueType,omitempty"`
	// DisplayName - READ-ONLY; The display name of the custom alert.
	DisplayName *string `json:"displayName,omitempty"`
	// Description - READ-ONLY; The description of the custom alert.
	Description *string `json:"description,omitempty"`
	// IsEnabled - Status of the custom alert.
	IsEnabled *bool `json:"isEnabled,omitempty"`
	// RuleType - The type of the custom alert rule.
	RuleType *string `json:"ruleType,omitempty"`
}

// AppWhitelistingGroup ...
type AppWhitelistingGroup struct {
	autorest.Response `json:"-"`
	// ID - READ-ONLY; Resource Id
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type
	Type *string `json:"type,omitempty"`
	// Location - READ-ONLY; Location where the resource is stored
	Location                  *string `json:"location,omitempty"`
	*AppWhitelistingGroupData `json:"properties,omitempty"`
}

// MarshalJSON is the custom marshaler for AppWhitelistingGroup.
func (awg AppWhitelistingGroup) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if awg.AppWhitelistingGroupData != nil {
		objectMap["properties"] = awg.AppWhitelistingGroupData
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for AppWhitelistingGroup struct.
func (awg *AppWhitelistingGroup) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				awg.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				awg.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				awg.Type = &typeVar
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				awg.Location = &location
			}
		case "properties":
			if v != nil {
				var appWhitelistingGroupData AppWhitelistingGroupData
				err = json.Unmarshal(*v, &appWhitelistingGroupData)
				if err != nil {
					return err
				}
				awg.AppWhitelistingGroupData = &appWhitelistingGroupData
			}
		}
	}

	return nil
}

// AppWhitelistingGroupData represents a VM/server group and set of rules that are Recommended by Azure
// Security Center to be allowed
type AppWhitelistingGroupData struct {
	// EnforcementMode - Possible values include: 'Audit', 'Enforce', 'None'
	EnforcementMode EnforcementMode `json:"enforcementMode,omitempty"`
	ProtectionMode  *ProtectionMode `json:"protectionMode,omitempty"`
	// ConfigurationStatus - Possible values include: 'ConfigurationStatus2Configured', 'ConfigurationStatus2NotConfigured', 'ConfigurationStatus2InProgress', 'ConfigurationStatus2Failed', 'ConfigurationStatus2NoStatus'
	ConfigurationStatus ConfigurationStatus2 `json:"configurationStatus,omitempty"`
	// RecommendationStatus - Possible values include: 'RecommendationStatusRecommended', 'RecommendationStatusNotRecommended', 'RecommendationStatusNotAvailable', 'RecommendationStatusNoStatus'
	RecommendationStatus RecommendationStatus           `json:"recommendationStatus,omitempty"`
	Issues               *[]AppWhitelistingIssueSummary `json:"issues,omitempty"`
	// SourceSystem - Possible values include: 'SourceSystemAzureAppLocker', 'SourceSystemAzureAuditD', 'SourceSystemNonAzureAppLocker', 'SourceSystemNonAzureAuditD', 'SourceSystemNone'
	SourceSystem        SourceSystem          `json:"sourceSystem,omitempty"`
	VMRecommendations   *[]VMRecommendation   `json:"vmRecommendations,omitempty"`
	PathRecommendations *[]PathRecommendation `json:"pathRecommendations,omitempty"`
}

// AppWhitelistingGroups represents a list of VM/server groups and set of rules that are Recommended by
// Azure Security Center to be allowed
type AppWhitelistingGroups struct {
	autorest.Response `json:"-"`
	Value             *[]AppWhitelistingGroup `json:"value,omitempty"`
}

// AppWhitelistingIssueSummary represents a summary of the alerts of the VM/server group
type AppWhitelistingIssueSummary struct {
	// Issue - Possible values include: 'ViolationsAudited', 'ViolationsBlocked', 'MsiAndScriptViolationsAudited', 'MsiAndScriptViolationsBlocked', 'ExecutableViolationsAudited', 'RulesViolatedManually'
	Issue Issue `json:"issue,omitempty"`
	// NumberOfVms - The number of machines in the VM/server group that have this alert
	NumberOfVms *float64 `json:"numberOfVms,omitempty"`
}

// AppWhitelistingPutGroupData the altered data of the recommended VM/server group policy
type AppWhitelistingPutGroupData struct {
	// EnforcementMode - The enforcement mode of the group. Can also be defined per collection type by using ProtectionMode. Possible values include: 'EnforcementMode1Audit', 'EnforcementMode1Enforce', 'EnforcementMode1None'
	EnforcementMode EnforcementMode1 `json:"enforcementMode,omitempty"`
	// ProtectionMode - The protection mode of the group per collection type. Can also be defined for all collection types by using EnforcementMode
	ProtectionMode      *ProtectionMode       `json:"protectionMode,omitempty"`
	VMRecommendations   *[]VMRecommendation   `json:"vmRecommendations,omitempty"`
	PathRecommendations *[]PathRecommendation `json:"pathRecommendations,omitempty"`
}

// AscLocation the ASC location of the subscription is in the "name" field
type AscLocation struct {
	autorest.Response `json:"-"`
	Properties        interface{} `json:"properties,omitempty"`
	// ID - READ-ONLY; Resource Id
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type
	Type *string `json:"type,omitempty"`
}

// AscLocationList list of locations where ASC saves your data
type AscLocationList struct {
	autorest.Response `json:"-"`
	// Value - READ-ONLY
	Value *[]AscLocation `json:"value,omitempty"`
	// NextLink - READ-ONLY; The URI to fetch the next page.
	NextLink *string `json:"nextLink,omitempty"`
}

// AscLocationListIterator provides access to a complete listing of AscLocation values.
type AscLocationListIterator struct {
	i    int
	page AscLocationListPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *AscLocationListIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/AscLocationListIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *AscLocationListIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter AscLocationListIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter AscLocationListIterator) Response() AscLocationList {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter AscLocationListIterator) Value() AscLocation {
	if !iter.page.NotDone() {
		return AscLocation{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the AscLocationListIterator type.
func NewAscLocationListIterator(page AscLocationListPage) AscLocationListIterator {
	return AscLocationListIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (all AscLocationList) IsEmpty() bool {
	return all.Value == nil || len(*all.Value) == 0
}

// ascLocationListPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (all AscLocationList) ascLocationListPreparer(ctx context.Context) (*http.Request, error) {
	if all.NextLink == nil || len(to.String(all.NextLink)) < 1 {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(all.NextLink)))
}

// AscLocationListPage contains a page of AscLocation values.
type AscLocationListPage struct {
	fn  func(context.Context, AscLocationList) (AscLocationList, error)
	all AscLocationList
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *AscLocationListPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/AscLocationListPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	next, err := page.fn(ctx, page.all)
	if err != nil {
		return err
	}
	page.all = next
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *AscLocationListPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page AscLocationListPage) NotDone() bool {
	return !page.all.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page AscLocationListPage) Response() AscLocationList {
	return page.all
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page AscLocationListPage) Values() []AscLocation {
	if page.all.IsEmpty() {
		return nil
	}
	return *page.all.Value
}

// Creates a new instance of the AscLocationListPage type.
func NewAscLocationListPage(getNextPage func(context.Context, AscLocationList) (AscLocationList, error)) AscLocationListPage {
	return AscLocationListPage{fn: getNextPage}
}

// Assessment security assessment on a resource
type Assessment struct {
	autorest.Response     `json:"-"`
	*AssessmentProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Resource Id
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for Assessment.
func (a Assessment) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if a.AssessmentProperties != nil {
		objectMap["properties"] = a.AssessmentProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for Assessment struct.
func (a *Assessment) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var assessmentProperties AssessmentProperties
				err = json.Unmarshal(*v, &assessmentProperties)
				if err != nil {
					return err
				}
				a.AssessmentProperties = &assessmentProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				a.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				a.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				a.Type = &typeVar
			}
		}
	}

	return nil
}

// AssessmentLinks links relevant to the assessment
type AssessmentLinks struct {
	// AzurePortalURI - READ-ONLY; Link to assessment in Azure Portal
	AzurePortalURI *string `json:"azurePortalUri,omitempty"`
}

// AssessmentList page of a security assessments list
type AssessmentList struct {
	autorest.Response `json:"-"`
	// Value - READ-ONLY; Collection of security assessments in this page
	Value *[]Assessment `json:"value,omitempty"`
	// NextLink - READ-ONLY; The URI to fetch the next page.
	NextLink *string `json:"nextLink,omitempty"`
}

// AssessmentListIterator provides access to a complete listing of Assessment values.
type AssessmentListIterator struct {
	i    int
	page AssessmentListPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *AssessmentListIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/AssessmentListIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *AssessmentListIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter AssessmentListIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter AssessmentListIterator) Response() AssessmentList {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter AssessmentListIterator) Value() Assessment {
	if !iter.page.NotDone() {
		return Assessment{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the AssessmentListIterator type.
func NewAssessmentListIterator(page AssessmentListPage) AssessmentListIterator {
	return AssessmentListIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (al AssessmentList) IsEmpty() bool {
	return al.Value == nil || len(*al.Value) == 0
}

// assessmentListPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (al AssessmentList) assessmentListPreparer(ctx context.Context) (*http.Request, error) {
	if al.NextLink == nil || len(to.String(al.NextLink)) < 1 {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(al.NextLink)))
}

// AssessmentListPage contains a page of Assessment values.
type AssessmentListPage struct {
	fn func(context.Context, AssessmentList) (AssessmentList, error)
	al AssessmentList
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *AssessmentListPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/AssessmentListPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	next, err := page.fn(ctx, page.al)
	if err != nil {
		return err
	}
	page.al = next
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *AssessmentListPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page AssessmentListPage) NotDone() bool {
	return !page.al.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page AssessmentListPage) Response() AssessmentList {
	return page.al
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page AssessmentListPage) Values() []Assessment {
	if page.al.IsEmpty() {
		return nil
	}
	return *page.al.Value
}

// Creates a new instance of the AssessmentListPage type.
func NewAssessmentListPage(getNextPage func(context.Context, AssessmentList) (AssessmentList, error)) AssessmentListPage {
	return AssessmentListPage{fn: getNextPage}
}

// AssessmentMetadata security assessment metadata
type AssessmentMetadata struct {
	autorest.Response             `json:"-"`
	*AssessmentMetadataProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Resource Id
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for AssessmentMetadata.
func (am AssessmentMetadata) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if am.AssessmentMetadataProperties != nil {
		objectMap["properties"] = am.AssessmentMetadataProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for AssessmentMetadata struct.
func (am *AssessmentMetadata) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var assessmentMetadataProperties AssessmentMetadataProperties
				err = json.Unmarshal(*v, &assessmentMetadataProperties)
				if err != nil {
					return err
				}
				am.AssessmentMetadataProperties = &assessmentMetadataProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				am.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				am.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				am.Type = &typeVar
			}
		}
	}

	return nil
}

// AssessmentMetadataList list of security assessment metadata
type AssessmentMetadataList struct {
	autorest.Response `json:"-"`
	// Value - READ-ONLY
	Value *[]AssessmentMetadata `json:"value,omitempty"`
	// NextLink - READ-ONLY; The URI to fetch the next page.
	NextLink *string `json:"nextLink,omitempty"`
}

// AssessmentMetadataListIterator provides access to a complete listing of AssessmentMetadata values.
type AssessmentMetadataListIterator struct {
	i    int
	page AssessmentMetadataListPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *AssessmentMetadataListIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/AssessmentMetadataListIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *AssessmentMetadataListIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter AssessmentMetadataListIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter AssessmentMetadataListIterator) Response() AssessmentMetadataList {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter AssessmentMetadataListIterator) Value() AssessmentMetadata {
	if !iter.page.NotDone() {
		return AssessmentMetadata{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the AssessmentMetadataListIterator type.
func NewAssessmentMetadataListIterator(page AssessmentMetadataListPage) AssessmentMetadataListIterator {
	return AssessmentMetadataListIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (aml AssessmentMetadataList) IsEmpty() bool {
	return aml.Value == nil || len(*aml.Value) == 0
}

// assessmentMetadataListPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (aml AssessmentMetadataList) assessmentMetadataListPreparer(ctx context.Context) (*http.Request, error) {
	if aml.NextLink == nil || len(to.String(aml.NextLink)) < 1 {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(aml.NextLink)))
}

// AssessmentMetadataListPage contains a page of AssessmentMetadata values.
type AssessmentMetadataListPage struct {
	fn  func(context.Context, AssessmentMetadataList) (AssessmentMetadataList, error)
	aml AssessmentMetadataList
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *AssessmentMetadataListPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/AssessmentMetadataListPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	next, err := page.fn(ctx, page.aml)
	if err != nil {
		return err
	}
	page.aml = next
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *AssessmentMetadataListPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page AssessmentMetadataListPage) NotDone() bool {
	return !page.aml.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page AssessmentMetadataListPage) Response() AssessmentMetadataList {
	return page.aml
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page AssessmentMetadataListPage) Values() []AssessmentMetadata {
	if page.aml.IsEmpty() {
		return nil
	}
	return *page.aml.Value
}

// Creates a new instance of the AssessmentMetadataListPage type.
func NewAssessmentMetadataListPage(getNextPage func(context.Context, AssessmentMetadataList) (AssessmentMetadataList, error)) AssessmentMetadataListPage {
	return AssessmentMetadataListPage{fn: getNextPage}
}

// AssessmentMetadataProperties describes properties of an assessment metadata.
type AssessmentMetadataProperties struct {
	// DisplayName - User friendly display name of the assessment
	DisplayName *string `json:"displayName,omitempty"`
	// PolicyDefinitionID - READ-ONLY; Azure resource ID of the policy definition that turns this assessment calculation on
	PolicyDefinitionID *string `json:"policyDefinitionId,omitempty"`
	// Description - Human readable description of the assessment
	Description *string `json:"description,omitempty"`
	// RemediationDescription - Human readable description of what you should do to mitigate this security issue
	RemediationDescription *string     `json:"remediationDescription,omitempty"`
	Category               *[]Category `json:"category,omitempty"`
	// Severity - The severity level of the assessment. Possible values include: 'SeverityLow', 'SeverityMedium', 'SeverityHigh'
	Severity Severity `json:"severity,omitempty"`
	// UserImpact - The user impact of the assessment. Possible values include: 'UserImpactLow', 'UserImpactModerate', 'UserImpactHigh'
	UserImpact UserImpact `json:"userImpact,omitempty"`
	// ImplementationEffort - The implementation effort required to remediate this assessment. Possible values include: 'Low', 'Moderate', 'High'
	ImplementationEffort ImplementationEffort `json:"implementationEffort,omitempty"`
	Threats              *[]Threats           `json:"threats,omitempty"`
	// Preview - True if this assessment is in preview release status
	Preview *bool `json:"preview,omitempty"`
	// AssessmentType - BuiltIn if the assessment based on built-in Azure Policy definition, Custom if the assessment based on custom Azure Policy definition. Possible values include: 'BuiltIn', 'CustomPolicy', 'CustomerManaged'
	AssessmentType AssessmentType `json:"assessmentType,omitempty"`
}

// AssessmentProperties describes properties of an assessment.
type AssessmentProperties struct {
	ResourceDetails BasicResourceDetails `json:"resourceDetails,omitempty"`
	// DisplayName - READ-ONLY; User friendly display name of the assessment
	DisplayName *string           `json:"displayName,omitempty"`
	Status      *AssessmentStatus `json:"status,omitempty"`
	// AdditionalData - Additional data regarding the assessment
	AdditionalData map[string]*string `json:"additionalData"`
	Links          *AssessmentLinks   `json:"links,omitempty"`
}

// MarshalJSON is the custom marshaler for AssessmentProperties.
func (ap AssessmentProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	objectMap["resourceDetails"] = ap.ResourceDetails
	if ap.Status != nil {
		objectMap["status"] = ap.Status
	}
	if ap.AdditionalData != nil {
		objectMap["additionalData"] = ap.AdditionalData
	}
	if ap.Links != nil {
		objectMap["links"] = ap.Links
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for AssessmentProperties struct.
func (ap *AssessmentProperties) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "resourceDetails":
			if v != nil {
				resourceDetails, err := unmarshalBasicResourceDetails(*v)
				if err != nil {
					return err
				}
				ap.ResourceDetails = resourceDetails
			}
		case "displayName":
			if v != nil {
				var displayName string
				err = json.Unmarshal(*v, &displayName)
				if err != nil {
					return err
				}
				ap.DisplayName = &displayName
			}
		case "status":
			if v != nil {
				var status AssessmentStatus
				err = json.Unmarshal(*v, &status)
				if err != nil {
					return err
				}
				ap.Status = &status
			}
		case "additionalData":
			if v != nil {
				var additionalData map[string]*string
				err = json.Unmarshal(*v, &additionalData)
				if err != nil {
					return err
				}
				ap.AdditionalData = additionalData
			}
		case "links":
			if v != nil {
				var links AssessmentLinks
				err = json.Unmarshal(*v, &links)
				if err != nil {
					return err
				}
				ap.Links = &links
			}
		}
	}

	return nil
}

// AssessmentStatus the result of the assessment
type AssessmentStatus struct {
	// Code - Programmatic code for the status of the assessment. Possible values include: 'Healthy', 'Unhealthy', 'NotApplicable'
	Code AssessmentStatusCode `json:"code,omitempty"`
	// Cause - Programmatic code for the cause of the assessment status
	Cause *string `json:"cause,omitempty"`
	// Description - Human readable description of the assessment status
	Description *string `json:"description,omitempty"`
}

// AtaExternalSecuritySolution represents an ATA security solution which sends logs to an OMS workspace
type AtaExternalSecuritySolution struct {
	Properties *AtaSolutionProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Resource Id
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type
	Type *string `json:"type,omitempty"`
	// Location - READ-ONLY; Location where the resource is stored
	Location *string `json:"location,omitempty"`
	// Kind - Possible values include: 'KindExternalSecuritySolution', 'KindCEF', 'KindATA', 'KindAAD'
	Kind KindEnum `json:"kind,omitempty"`
}

// MarshalJSON is the custom marshaler for AtaExternalSecuritySolution.
func (aess AtaExternalSecuritySolution) MarshalJSON() ([]byte, error) {
	aess.Kind = KindATA
	objectMap := make(map[string]interface{})
	if aess.Properties != nil {
		objectMap["properties"] = aess.Properties
	}
	if aess.Kind != "" {
		objectMap["kind"] = aess.Kind
	}
	return json.Marshal(objectMap)
}

// AsCefExternalSecuritySolution is the BasicExternalSecuritySolution implementation for AtaExternalSecuritySolution.
func (aess AtaExternalSecuritySolution) AsCefExternalSecuritySolution() (*CefExternalSecuritySolution, bool) {
	return nil, false
}

// AsAtaExternalSecuritySolution is the BasicExternalSecuritySolution implementation for AtaExternalSecuritySolution.
func (aess AtaExternalSecuritySolution) AsAtaExternalSecuritySolution() (*AtaExternalSecuritySolution, bool) {
	return &aess, true
}

// AsAadExternalSecuritySolution is the BasicExternalSecuritySolution implementation for AtaExternalSecuritySolution.
func (aess AtaExternalSecuritySolution) AsAadExternalSecuritySolution() (*AadExternalSecuritySolution, bool) {
	return nil, false
}

// AsExternalSecuritySolution is the BasicExternalSecuritySolution implementation for AtaExternalSecuritySolution.
func (aess AtaExternalSecuritySolution) AsExternalSecuritySolution() (*ExternalSecuritySolution, bool) {
	return nil, false
}

// AsBasicExternalSecuritySolution is the BasicExternalSecuritySolution implementation for AtaExternalSecuritySolution.
func (aess AtaExternalSecuritySolution) AsBasicExternalSecuritySolution() (BasicExternalSecuritySolution, bool) {
	return &aess, true
}

// AtaSolutionProperties ...
type AtaSolutionProperties struct {
	LastEventReceived *string `json:"lastEventReceived,omitempty"`
	// AdditionalProperties - Unmatched properties from the message are deserialized this collection
	AdditionalProperties map[string]interface{} `json:""`
	DeviceVendor         *string                `json:"deviceVendor,omitempty"`
	DeviceType           *string                `json:"deviceType,omitempty"`
	Workspace            *ConnectedWorkspace    `json:"workspace,omitempty"`
}

// MarshalJSON is the custom marshaler for AtaSolutionProperties.
func (asp AtaSolutionProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if asp.LastEventReceived != nil {
		objectMap["lastEventReceived"] = asp.LastEventReceived
	}
	if asp.DeviceVendor != nil {
		objectMap["deviceVendor"] = asp.DeviceVendor
	}
	if asp.DeviceType != nil {
		objectMap["deviceType"] = asp.DeviceType
	}
	if asp.Workspace != nil {
		objectMap["workspace"] = asp.Workspace
	}
	for k, v := range asp.AdditionalProperties {
		objectMap[k] = v
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for AtaSolutionProperties struct.
func (asp *AtaSolutionProperties) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "lastEventReceived":
			if v != nil {
				var lastEventReceived string
				err = json.Unmarshal(*v, &lastEventReceived)
				if err != nil {
					return err
				}
				asp.LastEventReceived = &lastEventReceived
			}
		default:
			if v != nil {
				var additionalProperties interface{}
				err = json.Unmarshal(*v, &additionalProperties)
				if err != nil {
					return err
				}
				if asp.AdditionalProperties == nil {
					asp.AdditionalProperties = make(map[string]interface{})
				}
				asp.AdditionalProperties[k] = additionalProperties
			}
		case "deviceVendor":
			if v != nil {
				var deviceVendor string
				err = json.Unmarshal(*v, &deviceVendor)
				if err != nil {
					return err
				}
				asp.DeviceVendor = &deviceVendor
			}
		case "deviceType":
			if v != nil {
				var deviceType string
				err = json.Unmarshal(*v, &deviceType)
				if err != nil {
					return err
				}
				asp.DeviceType = &deviceType
			}
		case "workspace":
			if v != nil {
				var workspace ConnectedWorkspace
				err = json.Unmarshal(*v, &workspace)
				if err != nil {
					return err
				}
				asp.Workspace = &workspace
			}
		}
	}

	return nil
}

// Automation the security automation resource.
type Automation struct {
	autorest.Response `json:"-"`
	// AutomationProperties - Security automation data
	*AutomationProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Resource Id
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type
	Type *string `json:"type,omitempty"`
	// Location - READ-ONLY; Location where the resource is stored
	Location *string `json:"location,omitempty"`
	// Kind - Kind of the resource
	Kind *string `json:"kind,omitempty"`
	// Etag - Entity tag is used for comparing two or more entities from the same requested resource.
	Etag *string `json:"etag,omitempty"`
	// Tags - A list of key value pairs that describe the resource.
	Tags map[string]*string `json:"tags"`
}

// MarshalJSON is the custom marshaler for Automation.
func (a Automation) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if a.AutomationProperties != nil {
		objectMap["properties"] = a.AutomationProperties
	}
	if a.Kind != nil {
		objectMap["kind"] = a.Kind
	}
	if a.Etag != nil {
		objectMap["etag"] = a.Etag
	}
	if a.Tags != nil {
		objectMap["tags"] = a.Tags
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for Automation struct.
func (a *Automation) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var automationProperties AutomationProperties
				err = json.Unmarshal(*v, &automationProperties)
				if err != nil {
					return err
				}
				a.AutomationProperties = &automationProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				a.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				a.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				a.Type = &typeVar
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				a.Location = &location
			}
		case "kind":
			if v != nil {
				var kind string
				err = json.Unmarshal(*v, &kind)
				if err != nil {
					return err
				}
				a.Kind = &kind
			}
		case "etag":
			if v != nil {
				var etag string
				err = json.Unmarshal(*v, &etag)
				if err != nil {
					return err
				}
				a.Etag = &etag
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				a.Tags = tags
			}
		}
	}

	return nil
}

// BasicAutomationAction the action that should be triggered.
type BasicAutomationAction interface {
	AsAutomationActionLogicApp() (*AutomationActionLogicApp, bool)
	AsAutomationActionEventHub() (*AutomationActionEventHub, bool)
	AsAutomationActionWorkspace() (*AutomationActionWorkspace, bool)
	AsAutomationAction() (*AutomationAction, bool)
}

// AutomationAction the action that should be triggered.
type AutomationAction struct {
	// ActionType - Possible values include: 'ActionTypeAutomationAction', 'ActionTypeLogicApp', 'ActionTypeEventHub', 'ActionTypeWorkspace'
	ActionType ActionType `json:"actionType,omitempty"`
}

func unmarshalBasicAutomationAction(body []byte) (BasicAutomationAction, error) {
	var m map[string]interface{}
	err := json.Unmarshal(body, &m)
	if err != nil {
		return nil, err
	}

	switch m["actionType"] {
	case string(ActionTypeLogicApp):
		var aala AutomationActionLogicApp
		err := json.Unmarshal(body, &aala)
		return aala, err
	case string(ActionTypeEventHub):
		var aaeh AutomationActionEventHub
		err := json.Unmarshal(body, &aaeh)
		return aaeh, err
	case string(ActionTypeWorkspace):
		var aaw AutomationActionWorkspace
		err := json.Unmarshal(body, &aaw)
		return aaw, err
	default:
		var aa AutomationAction
		err := json.Unmarshal(body, &aa)
		return aa, err
	}
}
func unmarshalBasicAutomationActionArray(body []byte) ([]BasicAutomationAction, error) {
	var rawMessages []*json.RawMessage
	err := json.Unmarshal(body, &rawMessages)
	if err != nil {
		return nil, err
	}

	aaArray := make([]BasicAutomationAction, len(rawMessages))

	for index, rawMessage := range rawMessages {
		aa, err := unmarshalBasicAutomationAction(*rawMessage)
		if err != nil {
			return nil, err
		}
		aaArray[index] = aa
	}
	return aaArray, nil
}

// MarshalJSON is the custom marshaler for AutomationAction.
func (aa AutomationAction) MarshalJSON() ([]byte, error) {
	aa.ActionType = ActionTypeAutomationAction
	objectMap := make(map[string]interface{})
	if aa.ActionType != "" {
		objectMap["actionType"] = aa.ActionType
	}
	return json.Marshal(objectMap)
}

// AsAutomationActionLogicApp is the BasicAutomationAction implementation for AutomationAction.
func (aa AutomationAction) AsAutomationActionLogicApp() (*AutomationActionLogicApp, bool) {
	return nil, false
}

// AsAutomationActionEventHub is the BasicAutomationAction implementation for AutomationAction.
func (aa AutomationAction) AsAutomationActionEventHub() (*AutomationActionEventHub, bool) {
	return nil, false
}

// AsAutomationActionWorkspace is the BasicAutomationAction implementation for AutomationAction.
func (aa AutomationAction) AsAutomationActionWorkspace() (*AutomationActionWorkspace, bool) {
	return nil, false
}

// AsAutomationAction is the BasicAutomationAction implementation for AutomationAction.
func (aa AutomationAction) AsAutomationAction() (*AutomationAction, bool) {
	return &aa, true
}

// AsBasicAutomationAction is the BasicAutomationAction implementation for AutomationAction.
func (aa AutomationAction) AsBasicAutomationAction() (BasicAutomationAction, bool) {
	return &aa, true
}

// AutomationActionEventHub the target Event Hub to which event data will be exported. To learn more about
// Security Center continuous export capabilities, visit https://aka.ms/ASCExportLearnMore
type AutomationActionEventHub struct {
	// EventHubResourceID - The target Event Hub Azure Resource ID.
	EventHubResourceID *string `json:"eventHubResourceId,omitempty"`
	// SasPolicyName - READ-ONLY; The target Event Hub SAS policy name.
	SasPolicyName *string `json:"sasPolicyName,omitempty"`
	// ConnectionString - The target Event Hub connection string (it will not be included in any response).
	ConnectionString *string `json:"connectionString,omitempty"`
	// ActionType - Possible values include: 'ActionTypeAutomationAction', 'ActionTypeLogicApp', 'ActionTypeEventHub', 'ActionTypeWorkspace'
	ActionType ActionType `json:"actionType,omitempty"`
}

// MarshalJSON is the custom marshaler for AutomationActionEventHub.
func (aaeh AutomationActionEventHub) MarshalJSON() ([]byte, error) {
	aaeh.ActionType = ActionTypeEventHub
	objectMap := make(map[string]interface{})
	if aaeh.EventHubResourceID != nil {
		objectMap["eventHubResourceId"] = aaeh.EventHubResourceID
	}
	if aaeh.ConnectionString != nil {
		objectMap["connectionString"] = aaeh.ConnectionString
	}
	if aaeh.ActionType != "" {
		objectMap["actionType"] = aaeh.ActionType
	}
	return json.Marshal(objectMap)
}

// AsAutomationActionLogicApp is the BasicAutomationAction implementation for AutomationActionEventHub.
func (aaeh AutomationActionEventHub) AsAutomationActionLogicApp() (*AutomationActionLogicApp, bool) {
	return nil, false
}

// AsAutomationActionEventHub is the BasicAutomationAction implementation for AutomationActionEventHub.
func (aaeh AutomationActionEventHub) AsAutomationActionEventHub() (*AutomationActionEventHub, bool) {
	return &aaeh, true
}

// AsAutomationActionWorkspace is the BasicAutomationAction implementation for AutomationActionEventHub.
func (aaeh AutomationActionEventHub) AsAutomationActionWorkspace() (*AutomationActionWorkspace, bool) {
	return nil, false
}

// AsAutomationAction is the BasicAutomationAction implementation for AutomationActionEventHub.
func (aaeh AutomationActionEventHub) AsAutomationAction() (*AutomationAction, bool) {
	return nil, false
}

// AsBasicAutomationAction is the BasicAutomationAction implementation for AutomationActionEventHub.
func (aaeh AutomationActionEventHub) AsBasicAutomationAction() (BasicAutomationAction, bool) {
	return &aaeh, true
}

// AutomationActionLogicApp the logic app action that should be triggered. To learn more about Security
// Center's Workflow Automation capabilities, visit https://aka.ms/ASCWorkflowAutomationLearnMore
type AutomationActionLogicApp struct {
	// LogicAppResourceID - The triggered Logic App Azure Resource ID. This can also reside on other subscriptions, given that you have permissions to trigger the Logic App
	LogicAppResourceID *string `json:"logicAppResourceId,omitempty"`
	// URI - The Logic App trigger URI endpoint (it will not be included in any response).
	URI *string `json:"uri,omitempty"`
	// ActionType - Possible values include: 'ActionTypeAutomationAction', 'ActionTypeLogicApp', 'ActionTypeEventHub', 'ActionTypeWorkspace'
	ActionType ActionType `json:"actionType,omitempty"`
}

// MarshalJSON is the custom marshaler for AutomationActionLogicApp.
func (aala AutomationActionLogicApp) MarshalJSON() ([]byte, error) {
	aala.ActionType = ActionTypeLogicApp
	objectMap := make(map[string]interface{})
	if aala.LogicAppResourceID != nil {
		objectMap["logicAppResourceId"] = aala.LogicAppResourceID
	}
	if aala.URI != nil {
		objectMap["uri"] = aala.URI
	}
	if aala.ActionType != "" {
		objectMap["actionType"] = aala.ActionType
	}
	return json.Marshal(objectMap)
}

// AsAutomationActionLogicApp is the BasicAutomationAction implementation for AutomationActionLogicApp.
func (aala AutomationActionLogicApp) AsAutomationActionLogicApp() (*AutomationActionLogicApp, bool) {
	return &aala, true
}

// AsAutomationActionEventHub is the BasicAutomationAction implementation for AutomationActionLogicApp.
func (aala AutomationActionLogicApp) AsAutomationActionEventHub() (*AutomationActionEventHub, bool) {
	return nil, false
}

// AsAutomationActionWorkspace is the BasicAutomationAction implementation for AutomationActionLogicApp.
func (aala AutomationActionLogicApp) AsAutomationActionWorkspace() (*AutomationActionWorkspace, bool) {
	return nil, false
}

// AsAutomationAction is the BasicAutomationAction implementation for AutomationActionLogicApp.
func (aala AutomationActionLogicApp) AsAutomationAction() (*AutomationAction, bool) {
	return nil, false
}

// AsBasicAutomationAction is the BasicAutomationAction implementation for AutomationActionLogicApp.
func (aala AutomationActionLogicApp) AsBasicAutomationAction() (BasicAutomationAction, bool) {
	return &aala, true
}

// AutomationActionWorkspace the Log Analytics Workspace to which event data will be exported. Security
// alerts data will reside in the 'SecurityAlert' table and the assessments data will reside in the
// 'SecurityRecommendation' table (under the 'Security'/'SecurityCenterFree' solutions). Note that in order
// to view the data in the workspace, the Security Center Log Analytics free/standard solution needs to be
// enabled on that workspace. To learn more about Security Center continuous export capabilities, visit
// https://aka.ms/ASCExportLearnMore
type AutomationActionWorkspace struct {
	// WorkspaceResourceID - The fully qualified Log Analytics Workspace Azure Resource ID.
	WorkspaceResourceID *string `json:"workspaceResourceId,omitempty"`
	// ActionType - Possible values include: 'ActionTypeAutomationAction', 'ActionTypeLogicApp', 'ActionTypeEventHub', 'ActionTypeWorkspace'
	ActionType ActionType `json:"actionType,omitempty"`
}

// MarshalJSON is the custom marshaler for AutomationActionWorkspace.
func (aaw AutomationActionWorkspace) MarshalJSON() ([]byte, error) {
	aaw.ActionType = ActionTypeWorkspace
	objectMap := make(map[string]interface{})
	if aaw.WorkspaceResourceID != nil {
		objectMap["workspaceResourceId"] = aaw.WorkspaceResourceID
	}
	if aaw.ActionType != "" {
		objectMap["actionType"] = aaw.ActionType
	}
	return json.Marshal(objectMap)
}

// AsAutomationActionLogicApp is the BasicAutomationAction implementation for AutomationActionWorkspace.
func (aaw AutomationActionWorkspace) AsAutomationActionLogicApp() (*AutomationActionLogicApp, bool) {
	return nil, false
}

// AsAutomationActionEventHub is the BasicAutomationAction implementation for AutomationActionWorkspace.
func (aaw AutomationActionWorkspace) AsAutomationActionEventHub() (*AutomationActionEventHub, bool) {
	return nil, false
}

// AsAutomationActionWorkspace is the BasicAutomationAction implementation for AutomationActionWorkspace.
func (aaw AutomationActionWorkspace) AsAutomationActionWorkspace() (*AutomationActionWorkspace, bool) {
	return &aaw, true
}

// AsAutomationAction is the BasicAutomationAction implementation for AutomationActionWorkspace.
func (aaw AutomationActionWorkspace) AsAutomationAction() (*AutomationAction, bool) {
	return nil, false
}

// AsBasicAutomationAction is the BasicAutomationAction implementation for AutomationActionWorkspace.
func (aaw AutomationActionWorkspace) AsBasicAutomationAction() (BasicAutomationAction, bool) {
	return &aaw, true
}

// AutomationList list of security automations response.
type AutomationList struct {
	autorest.Response `json:"-"`
	// Value - The list of security automations under the given scope.
	Value *[]Automation `json:"value,omitempty"`
	// NextLink - READ-ONLY; The URI to fetch the next page.
	NextLink *string `json:"nextLink,omitempty"`
}

// AutomationListIterator provides access to a complete listing of Automation values.
type AutomationListIterator struct {
	i    int
	page AutomationListPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *AutomationListIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/AutomationListIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *AutomationListIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter AutomationListIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter AutomationListIterator) Response() AutomationList {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter AutomationListIterator) Value() Automation {
	if !iter.page.NotDone() {
		return Automation{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the AutomationListIterator type.
func NewAutomationListIterator(page AutomationListPage) AutomationListIterator {
	return AutomationListIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (al AutomationList) IsEmpty() bool {
	return al.Value == nil || len(*al.Value) == 0
}

// automationListPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (al AutomationList) automationListPreparer(ctx context.Context) (*http.Request, error) {
	if al.NextLink == nil || len(to.String(al.NextLink)) < 1 {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(al.NextLink)))
}

// AutomationListPage contains a page of Automation values.
type AutomationListPage struct {
	fn func(context.Context, AutomationList) (AutomationList, error)
	al AutomationList
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *AutomationListPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/AutomationListPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	next, err := page.fn(ctx, page.al)
	if err != nil {
		return err
	}
	page.al = next
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *AutomationListPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page AutomationListPage) NotDone() bool {
	return !page.al.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page AutomationListPage) Response() AutomationList {
	return page.al
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page AutomationListPage) Values() []Automation {
	if page.al.IsEmpty() {
		return nil
	}
	return *page.al.Value
}

// Creates a new instance of the AutomationListPage type.
func NewAutomationListPage(getNextPage func(context.Context, AutomationList) (AutomationList, error)) AutomationListPage {
	return AutomationListPage{fn: getNextPage}
}

// AutomationProperties a set of properties that defines the behavior of the automation configuration. To
// learn more about the supported security events data models schemas - please visit
// https://aka.ms/ASCAutomationSchemas.
type AutomationProperties struct {
	// Description - The security automation description.
	Description *string `json:"description,omitempty"`
	// IsEnabled - Indicates whether the security automation is enabled.
	IsEnabled *bool `json:"isEnabled,omitempty"`
	// Scopes - A collection of scopes on which the security automations logic is applied. Supported scopes are the subscription itself or a resource group under that subscription. The automation will only apply on defined scopes.
	Scopes *[]AutomationScope `json:"scopes,omitempty"`
	// Sources - A collection of the source event types which evaluate the security automation set of rules.
	Sources *[]AutomationSource `json:"sources,omitempty"`
	// Actions - A collection of the actions which are triggered if all the configured rules evaluations, within at least one rule set, are true.
	Actions *[]BasicAutomationAction `json:"actions,omitempty"`
}

// UnmarshalJSON is the custom unmarshaler for AutomationProperties struct.
func (ap *AutomationProperties) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "description":
			if v != nil {
				var description string
				err = json.Unmarshal(*v, &description)
				if err != nil {
					return err
				}
				ap.Description = &description
			}
		case "isEnabled":
			if v != nil {
				var isEnabled bool
				err = json.Unmarshal(*v, &isEnabled)
				if err != nil {
					return err
				}
				ap.IsEnabled = &isEnabled
			}
		case "scopes":
			if v != nil {
				var scopes []AutomationScope
				err = json.Unmarshal(*v, &scopes)
				if err != nil {
					return err
				}
				ap.Scopes = &scopes
			}
		case "sources":
			if v != nil {
				var sources []AutomationSource
				err = json.Unmarshal(*v, &sources)
				if err != nil {
					return err
				}
				ap.Sources = &sources
			}
		case "actions":
			if v != nil {
				actions, err := unmarshalBasicAutomationActionArray(*v)
				if err != nil {
					return err
				}
				ap.Actions = &actions
			}
		}
	}

	return nil
}

// AutomationRuleSet a rule set which evaluates all its rules upon an event interception. Only when all the
// included rules in the rule set will be evaluated as 'true', will the event trigger the defined actions.
type AutomationRuleSet struct {
	Rules *[]AutomationTriggeringRule `json:"rules,omitempty"`
}

// AutomationScope a single automation scope.
type AutomationScope struct {
	// Description - The resources scope description.
	Description *string `json:"description,omitempty"`
	// ScopePath - The resources scope path. Can be the subscription on which the automation is defined on or a resource group under that subscription (fully qualified Azure resource IDs).
	ScopePath *string `json:"scopePath,omitempty"`
}

// AutomationSource the source event types which evaluate the security automation set of rules. For example
// - security alerts and security assessments. To learn more about the supported security events data
// models schemas - please visit https://aka.ms/ASCAutomationSchemas.
type AutomationSource struct {
	// EventSource - A valid event source type. Possible values include: 'Assessments', 'Alerts'
	EventSource EventSource `json:"eventSource,omitempty"`
	// RuleSets - A set of rules which evaluate upon event interception. A logical disjunction is applied between defined rule sets (logical 'or').
	RuleSets *[]AutomationRuleSet `json:"ruleSets,omitempty"`
}

// AutomationTriggeringRule a rule which is evaluated upon event interception. The rule is configured by
// comparing a specific value from the event model to an expected value. This comparison is done by using
// one of the supported operators set.
type AutomationTriggeringRule struct {
	// PropertyJPath - The JPath of the entity model property that should be checked.
	PropertyJPath *string `json:"propertyJPath,omitempty"`
	// PropertyType - The data type of the compared operands (string, integer, floating point number or a boolean [true/false]]. Possible values include: 'String', 'Integer', 'Number', 'Boolean'
	PropertyType PropertyType `json:"propertyType,omitempty"`
	// ExpectedValue - The expected value.
	ExpectedValue *string `json:"expectedValue,omitempty"`
	// Operator - A valid comparer operator to use. A case-insensitive comparison will be applied for String PropertyType. Possible values include: 'Equals', 'GreaterThan', 'GreaterThanOrEqualTo', 'LesserThan', 'LesserThanOrEqualTo', 'NotEquals', 'Contains', 'StartsWith', 'EndsWith'
	Operator Operator `json:"operator,omitempty"`
}

// AutomationValidationStatus the security automation model state property bag.
type AutomationValidationStatus struct {
	autorest.Response `json:"-"`
	// IsValid - Indicates whether the model is valid or not.
	IsValid *bool `json:"isValid,omitempty"`
	// Message - The validation message.
	Message *string `json:"message,omitempty"`
}

// AutoProvisioningSetting auto provisioning setting
type AutoProvisioningSetting struct {
	autorest.Response `json:"-"`
	// AutoProvisioningSettingProperties - Auto provisioning setting data
	*AutoProvisioningSettingProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Resource Id
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for AutoProvisioningSetting.
func (aps AutoProvisioningSetting) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if aps.AutoProvisioningSettingProperties != nil {
		objectMap["properties"] = aps.AutoProvisioningSettingProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for AutoProvisioningSetting struct.
func (aps *AutoProvisioningSetting) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var autoProvisioningSettingProperties AutoProvisioningSettingProperties
				err = json.Unmarshal(*v, &autoProvisioningSettingProperties)
				if err != nil {
					return err
				}
				aps.AutoProvisioningSettingProperties = &autoProvisioningSettingProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				aps.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				aps.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				aps.Type = &typeVar
			}
		}
	}

	return nil
}

// AutoProvisioningSettingList list of all the auto provisioning settings response
type AutoProvisioningSettingList struct {
	autorest.Response `json:"-"`
	// Value - List of all the auto provisioning settings
	Value *[]AutoProvisioningSetting `json:"value,omitempty"`
	// NextLink - READ-ONLY; The URI to fetch the next page.
	NextLink *string `json:"nextLink,omitempty"`
}

// AutoProvisioningSettingListIterator provides access to a complete listing of AutoProvisioningSetting
// values.
type AutoProvisioningSettingListIterator struct {
	i    int
	page AutoProvisioningSettingListPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *AutoProvisioningSettingListIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/AutoProvisioningSettingListIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *AutoProvisioningSettingListIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter AutoProvisioningSettingListIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter AutoProvisioningSettingListIterator) Response() AutoProvisioningSettingList {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter AutoProvisioningSettingListIterator) Value() AutoProvisioningSetting {
	if !iter.page.NotDone() {
		return AutoProvisioningSetting{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the AutoProvisioningSettingListIterator type.
func NewAutoProvisioningSettingListIterator(page AutoProvisioningSettingListPage) AutoProvisioningSettingListIterator {
	return AutoProvisioningSettingListIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (apsl AutoProvisioningSettingList) IsEmpty() bool {
	return apsl.Value == nil || len(*apsl.Value) == 0
}

// autoProvisioningSettingListPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (apsl AutoProvisioningSettingList) autoProvisioningSettingListPreparer(ctx context.Context) (*http.Request, error) {
	if apsl.NextLink == nil || len(to.String(apsl.NextLink)) < 1 {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(apsl.NextLink)))
}

// AutoProvisioningSettingListPage contains a page of AutoProvisioningSetting values.
type AutoProvisioningSettingListPage struct {
	fn   func(context.Context, AutoProvisioningSettingList) (AutoProvisioningSettingList, error)
	apsl AutoProvisioningSettingList
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *AutoProvisioningSettingListPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/AutoProvisioningSettingListPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	next, err := page.fn(ctx, page.apsl)
	if err != nil {
		return err
	}
	page.apsl = next
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *AutoProvisioningSettingListPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page AutoProvisioningSettingListPage) NotDone() bool {
	return !page.apsl.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page AutoProvisioningSettingListPage) Response() AutoProvisioningSettingList {
	return page.apsl
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page AutoProvisioningSettingListPage) Values() []AutoProvisioningSetting {
	if page.apsl.IsEmpty() {
		return nil
	}
	return *page.apsl.Value
}

// Creates a new instance of the AutoProvisioningSettingListPage type.
func NewAutoProvisioningSettingListPage(getNextPage func(context.Context, AutoProvisioningSettingList) (AutoProvisioningSettingList, error)) AutoProvisioningSettingListPage {
	return AutoProvisioningSettingListPage{fn: getNextPage}
}

// AutoProvisioningSettingProperties describes properties of an auto provisioning setting
type AutoProvisioningSettingProperties struct {
	// AutoProvision - Describes what kind of security agent provisioning action to take. Possible values include: 'AutoProvisionOn', 'AutoProvisionOff'
	AutoProvision AutoProvision `json:"autoProvision,omitempty"`
}

// AzureResourceDetails details of the Azure resource that was assessed
type AzureResourceDetails struct {
	// ID - READ-ONLY; Azure resource Id of the assessed resource
	ID *string `json:"id,omitempty"`
	// Source - Possible values include: 'SourceResourceDetails', 'SourceOnPremise', 'SourceAzure'
	Source Source `json:"source,omitempty"`
}

// MarshalJSON is the custom marshaler for AzureResourceDetails.
func (ard AzureResourceDetails) MarshalJSON() ([]byte, error) {
	ard.Source = SourceAzure
	objectMap := make(map[string]interface{})
	if ard.Source != "" {
		objectMap["source"] = ard.Source
	}
	return json.Marshal(objectMap)
}

// AsOnPremiseResourceDetails is the BasicResourceDetails implementation for AzureResourceDetails.
func (ard AzureResourceDetails) AsOnPremiseResourceDetails() (*OnPremiseResourceDetails, bool) {
	return nil, false
}

// AsAzureResourceDetails is the BasicResourceDetails implementation for AzureResourceDetails.
func (ard AzureResourceDetails) AsAzureResourceDetails() (*AzureResourceDetails, bool) {
	return &ard, true
}

// AsResourceDetails is the BasicResourceDetails implementation for AzureResourceDetails.
func (ard AzureResourceDetails) AsResourceDetails() (*ResourceDetails, bool) {
	return nil, false
}

// AsBasicResourceDetails is the BasicResourceDetails implementation for AzureResourceDetails.
func (ard AzureResourceDetails) AsBasicResourceDetails() (BasicResourceDetails, bool) {
	return &ard, true
}

// CefExternalSecuritySolution represents a security solution which sends CEF logs to an OMS workspace
type CefExternalSecuritySolution struct {
	Properties *CefSolutionProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Resource Id
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type
	Type *string `json:"type,omitempty"`
	// Location - READ-ONLY; Location where the resource is stored
	Location *string `json:"location,omitempty"`
	// Kind - Possible values include: 'KindExternalSecuritySolution', 'KindCEF', 'KindATA', 'KindAAD'
	Kind KindEnum `json:"kind,omitempty"`
}

// MarshalJSON is the custom marshaler for CefExternalSecuritySolution.
func (cess CefExternalSecuritySolution) MarshalJSON() ([]byte, error) {
	cess.Kind = KindCEF
	objectMap := make(map[string]interface{})
	if cess.Properties != nil {
		objectMap["properties"] = cess.Properties
	}
	if cess.Kind != "" {
		objectMap["kind"] = cess.Kind
	}
	return json.Marshal(objectMap)
}

// AsCefExternalSecuritySolution is the BasicExternalSecuritySolution implementation for CefExternalSecuritySolution.
func (cess CefExternalSecuritySolution) AsCefExternalSecuritySolution() (*CefExternalSecuritySolution, bool) {
	return &cess, true
}

// AsAtaExternalSecuritySolution is the BasicExternalSecuritySolution implementation for CefExternalSecuritySolution.
func (cess CefExternalSecuritySolution) AsAtaExternalSecuritySolution() (*AtaExternalSecuritySolution, bool) {
	return nil, false
}

// AsAadExternalSecuritySolution is the BasicExternalSecuritySolution implementation for CefExternalSecuritySolution.
func (cess CefExternalSecuritySolution) AsAadExternalSecuritySolution() (*AadExternalSecuritySolution, bool) {
	return nil, false
}

// AsExternalSecuritySolution is the BasicExternalSecuritySolution implementation for CefExternalSecuritySolution.
func (cess CefExternalSecuritySolution) AsExternalSecuritySolution() (*ExternalSecuritySolution, bool) {
	return nil, false
}

// AsBasicExternalSecuritySolution is the BasicExternalSecuritySolution implementation for CefExternalSecuritySolution.
func (cess CefExternalSecuritySolution) AsBasicExternalSecuritySolution() (BasicExternalSecuritySolution, bool) {
	return &cess, true
}

// CefSolutionProperties ...
type CefSolutionProperties struct {
	Hostname          *string `json:"hostname,omitempty"`
	Agent             *string `json:"agent,omitempty"`
	LastEventReceived *string `json:"lastEventReceived,omitempty"`
	// AdditionalProperties - Unmatched properties from the message are deserialized this collection
	AdditionalProperties map[string]interface{} `json:""`
	DeviceVendor         *string                `json:"deviceVendor,omitempty"`
	DeviceType           *string                `json:"deviceType,omitempty"`
	Workspace            *ConnectedWorkspace    `json:"workspace,omitempty"`
}

// MarshalJSON is the custom marshaler for CefSolutionProperties.
func (csp CefSolutionProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if csp.Hostname != nil {
		objectMap["hostname"] = csp.Hostname
	}
	if csp.Agent != nil {
		objectMap["agent"] = csp.Agent
	}
	if csp.LastEventReceived != nil {
		objectMap["lastEventReceived"] = csp.LastEventReceived
	}
	if csp.DeviceVendor != nil {
		objectMap["deviceVendor"] = csp.DeviceVendor
	}
	if csp.DeviceType != nil {
		objectMap["deviceType"] = csp.DeviceType
	}
	if csp.Workspace != nil {
		objectMap["workspace"] = csp.Workspace
	}
	for k, v := range csp.AdditionalProperties {
		objectMap[k] = v
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for CefSolutionProperties struct.
func (csp *CefSolutionProperties) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "hostname":
			if v != nil {
				var hostname string
				err = json.Unmarshal(*v, &hostname)
				if err != nil {
					return err
				}
				csp.Hostname = &hostname
			}
		case "agent":
			if v != nil {
				var agent string
				err = json.Unmarshal(*v, &agent)
				if err != nil {
					return err
				}
				csp.Agent = &agent
			}
		case "lastEventReceived":
			if v != nil {
				var lastEventReceived string
				err = json.Unmarshal(*v, &lastEventReceived)
				if err != nil {
					return err
				}
				csp.LastEventReceived = &lastEventReceived
			}
		default:
			if v != nil {
				var additionalProperties interface{}
				err = json.Unmarshal(*v, &additionalProperties)
				if err != nil {
					return err
				}
				if csp.AdditionalProperties == nil {
					csp.AdditionalProperties = make(map[string]interface{})
				}
				csp.AdditionalProperties[k] = additionalProperties
			}
		case "deviceVendor":
			if v != nil {
				var deviceVendor string
				err = json.Unmarshal(*v, &deviceVendor)
				if err != nil {
					return err
				}
				csp.DeviceVendor = &deviceVendor
			}
		case "deviceType":
			if v != nil {
				var deviceType string
				err = json.Unmarshal(*v, &deviceType)
				if err != nil {
					return err
				}
				csp.DeviceType = &deviceType
			}
		case "workspace":
			if v != nil {
				var workspace ConnectedWorkspace
				err = json.Unmarshal(*v, &workspace)
				if err != nil {
					return err
				}
				csp.Workspace = &workspace
			}
		}
	}

	return nil
}

// CloudError error response structure.
type CloudError struct {
	// CloudErrorBody - Error data
	*CloudErrorBody `json:"error,omitempty"`
}

// MarshalJSON is the custom marshaler for CloudError.
func (ce CloudError) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if ce.CloudErrorBody != nil {
		objectMap["error"] = ce.CloudErrorBody
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for CloudError struct.
func (ce *CloudError) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "error":
			if v != nil {
				var cloudErrorBody CloudErrorBody
				err = json.Unmarshal(*v, &cloudErrorBody)
				if err != nil {
					return err
				}
				ce.CloudErrorBody = &cloudErrorBody
			}
		}
	}

	return nil
}

// CloudErrorBody error details.
type CloudErrorBody struct {
	// Code - READ-ONLY; An identifier for the error. Codes are invariant and are intended to be consumed programmatically.
	Code *string `json:"code,omitempty"`
	// Message - READ-ONLY; A message describing the error, intended to be suitable for display in a user interface.
	Message *string `json:"message,omitempty"`
}

// Compliance compliance of a scope
type Compliance struct {
	autorest.Response `json:"-"`
	// ComplianceProperties - Compliance data
	*ComplianceProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Resource Id
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for Compliance.
func (c Compliance) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if c.ComplianceProperties != nil {
		objectMap["properties"] = c.ComplianceProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for Compliance struct.
func (c *Compliance) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var complianceProperties ComplianceProperties
				err = json.Unmarshal(*v, &complianceProperties)
				if err != nil {
					return err
				}
				c.ComplianceProperties = &complianceProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				c.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				c.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				c.Type = &typeVar
			}
		}
	}

	return nil
}

// ComplianceList list of Compliance objects response
type ComplianceList struct {
	autorest.Response `json:"-"`
	// Value - List of Compliance objects
	Value *[]Compliance `json:"value,omitempty"`
	// NextLink - READ-ONLY; The URI to fetch the next page.
	NextLink *string `json:"nextLink,omitempty"`
}

// ComplianceListIterator provides access to a complete listing of Compliance values.
type ComplianceListIterator struct {
	i    int
	page ComplianceListPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *ComplianceListIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ComplianceListIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *ComplianceListIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter ComplianceListIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter ComplianceListIterator) Response() ComplianceList {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter ComplianceListIterator) Value() Compliance {
	if !iter.page.NotDone() {
		return Compliance{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the ComplianceListIterator type.
func NewComplianceListIterator(page ComplianceListPage) ComplianceListIterator {
	return ComplianceListIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (cl ComplianceList) IsEmpty() bool {
	return cl.Value == nil || len(*cl.Value) == 0
}

// complianceListPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (cl ComplianceList) complianceListPreparer(ctx context.Context) (*http.Request, error) {
	if cl.NextLink == nil || len(to.String(cl.NextLink)) < 1 {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(cl.NextLink)))
}

// ComplianceListPage contains a page of Compliance values.
type ComplianceListPage struct {
	fn func(context.Context, ComplianceList) (ComplianceList, error)
	cl ComplianceList
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *ComplianceListPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ComplianceListPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	next, err := page.fn(ctx, page.cl)
	if err != nil {
		return err
	}
	page.cl = next
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *ComplianceListPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page ComplianceListPage) NotDone() bool {
	return !page.cl.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page ComplianceListPage) Response() ComplianceList {
	return page.cl
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page ComplianceListPage) Values() []Compliance {
	if page.cl.IsEmpty() {
		return nil
	}
	return *page.cl.Value
}

// Creates a new instance of the ComplianceListPage type.
func NewComplianceListPage(getNextPage func(context.Context, ComplianceList) (ComplianceList, error)) ComplianceListPage {
	return ComplianceListPage{fn: getNextPage}
}

// ComplianceProperties the Compliance score (percentage) of a Subscription is a sum of all Resources'
// Compliances under the given Subscription. A Resource Compliance is defined as the compliant ('healthy')
// Policy Definitions out of all Policy Definitions applicable to a given resource.
type ComplianceProperties struct {
	// AssessmentTimestampUtcDate - READ-ONLY; The timestamp when the Compliance calculation was conducted.
	AssessmentTimestampUtcDate *date.Time `json:"assessmentTimestampUtcDate,omitempty"`
	// ResourceCount - READ-ONLY; The resource count of the given subscription for which the Compliance calculation was conducted (needed for Management Group Compliance calculation).
	ResourceCount *int32 `json:"resourceCount,omitempty"`
	// AssessmentResult - READ-ONLY; An array of segment, which is the actually the compliance assessment.
	AssessmentResult *[]ComplianceSegment `json:"assessmentResult,omitempty"`
}

// ComplianceResult a compliance result
type ComplianceResult struct {
	autorest.Response `json:"-"`
	// ComplianceResultProperties - Compliance result data
	*ComplianceResultProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Resource Id
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for ComplianceResult.
func (cr ComplianceResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if cr.ComplianceResultProperties != nil {
		objectMap["properties"] = cr.ComplianceResultProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for ComplianceResult struct.
func (cr *ComplianceResult) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var complianceResultProperties ComplianceResultProperties
				err = json.Unmarshal(*v, &complianceResultProperties)
				if err != nil {
					return err
				}
				cr.ComplianceResultProperties = &complianceResultProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				cr.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				cr.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				cr.Type = &typeVar
			}
		}
	}

	return nil
}

// ComplianceResultList list of compliance results response
type ComplianceResultList struct {
	autorest.Response `json:"-"`
	// Value - List of compliance results
	Value *[]ComplianceResult `json:"value,omitempty"`
	// NextLink - READ-ONLY; The URI to fetch the next page.
	NextLink *string `json:"nextLink,omitempty"`
}

// ComplianceResultListIterator provides access to a complete listing of ComplianceResult values.
type ComplianceResultListIterator struct {
	i    int
	page ComplianceResultListPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *ComplianceResultListIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ComplianceResultListIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *ComplianceResultListIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter ComplianceResultListIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter ComplianceResultListIterator) Response() ComplianceResultList {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter ComplianceResultListIterator) Value() ComplianceResult {
	if !iter.page.NotDone() {
		return ComplianceResult{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the ComplianceResultListIterator type.
func NewComplianceResultListIterator(page ComplianceResultListPage) ComplianceResultListIterator {
	return ComplianceResultListIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (crl ComplianceResultList) IsEmpty() bool {
	return crl.Value == nil || len(*crl.Value) == 0
}

// complianceResultListPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (crl ComplianceResultList) complianceResultListPreparer(ctx context.Context) (*http.Request, error) {
	if crl.NextLink == nil || len(to.String(crl.NextLink)) < 1 {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(crl.NextLink)))
}

// ComplianceResultListPage contains a page of ComplianceResult values.
type ComplianceResultListPage struct {
	fn  func(context.Context, ComplianceResultList) (ComplianceResultList, error)
	crl ComplianceResultList
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *ComplianceResultListPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ComplianceResultListPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	next, err := page.fn(ctx, page.crl)
	if err != nil {
		return err
	}
	page.crl = next
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *ComplianceResultListPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page ComplianceResultListPage) NotDone() bool {
	return !page.crl.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page ComplianceResultListPage) Response() ComplianceResultList {
	return page.crl
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page ComplianceResultListPage) Values() []ComplianceResult {
	if page.crl.IsEmpty() {
		return nil
	}
	return *page.crl.Value
}

// Creates a new instance of the ComplianceResultListPage type.
func NewComplianceResultListPage(getNextPage func(context.Context, ComplianceResultList) (ComplianceResultList, error)) ComplianceResultListPage {
	return ComplianceResultListPage{fn: getNextPage}
}

// ComplianceResultProperties compliance result data
type ComplianceResultProperties struct {
	// ResourceStatus - READ-ONLY; The status of the resource regarding a single assessment. Possible values include: 'ResourceStatusHealthy', 'ResourceStatusNotApplicable', 'ResourceStatusOffByPolicy', 'ResourceStatusNotHealthy'
	ResourceStatus ResourceStatus `json:"resourceStatus,omitempty"`
}

// ComplianceSegment a segment of a compliance assessment.
type ComplianceSegment struct {
	// SegmentType - READ-ONLY; The segment type, e.g. compliant, non-compliance, insufficient coverage, N/A, etc.
	SegmentType *string `json:"segmentType,omitempty"`
	// Percentage - READ-ONLY; The size (%) of the segment.
	Percentage *float64 `json:"percentage,omitempty"`
}

// ConnectableResource describes the allowed inbound and outbound traffic of an Azure resource
type ConnectableResource struct {
	// ID - READ-ONLY; The Azure resource id
	ID *string `json:"id,omitempty"`
	// InboundConnectedResources - READ-ONLY; The list of Azure resources that the resource has inbound allowed connection from
	InboundConnectedResources *[]ConnectedResource `json:"inboundConnectedResources,omitempty"`
	// OutboundConnectedResources - READ-ONLY; The list of Azure resources that the resource has outbound allowed connection to
	OutboundConnectedResources *[]ConnectedResource `json:"outboundConnectedResources,omitempty"`
}

// ConnectedResource describes properties of a connected resource
type ConnectedResource struct {
	// ConnectedResourceID - READ-ONLY; The Azure resource id of the connected resource
	ConnectedResourceID *string `json:"connectedResourceId,omitempty"`
	// TCPPorts - READ-ONLY; The allowed tcp ports
	TCPPorts *string `json:"tcpPorts,omitempty"`
	// UDPPorts - READ-ONLY; The allowed udp ports
	UDPPorts *string `json:"udpPorts,omitempty"`
}

// ConnectedWorkspace ...
type ConnectedWorkspace struct {
	// ID - Azure resource ID of the connected OMS workspace
	ID *string `json:"id,omitempty"`
}

// Contact contact details for security issues
type Contact struct {
	autorest.Response `json:"-"`
	// ContactProperties - Security contact data
	*ContactProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Resource Id
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for Contact.
func (c Contact) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if c.ContactProperties != nil {
		objectMap["properties"] = c.ContactProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for Contact struct.
func (c *Contact) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var contactProperties ContactProperties
				err = json.Unmarshal(*v, &contactProperties)
				if err != nil {
					return err
				}
				c.ContactProperties = &contactProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				c.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				c.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				c.Type = &typeVar
			}
		}
	}

	return nil
}

// ContactList list of security contacts response
type ContactList struct {
	autorest.Response `json:"-"`
	// Value - READ-ONLY; List of security contacts
	Value *[]Contact `json:"value,omitempty"`
	// NextLink - READ-ONLY; The URI to fetch the next page.
	NextLink *string `json:"nextLink,omitempty"`
}

// ContactListIterator provides access to a complete listing of Contact values.
type ContactListIterator struct {
	i    int
	page ContactListPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *ContactListIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ContactListIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *ContactListIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter ContactListIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter ContactListIterator) Response() ContactList {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter ContactListIterator) Value() Contact {
	if !iter.page.NotDone() {
		return Contact{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the ContactListIterator type.
func NewContactListIterator(page ContactListPage) ContactListIterator {
	return ContactListIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (cl ContactList) IsEmpty() bool {
	return cl.Value == nil || len(*cl.Value) == 0
}

// contactListPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (cl ContactList) contactListPreparer(ctx context.Context) (*http.Request, error) {
	if cl.NextLink == nil || len(to.String(cl.NextLink)) < 1 {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(cl.NextLink)))
}

// ContactListPage contains a page of Contact values.
type ContactListPage struct {
	fn func(context.Context, ContactList) (ContactList, error)
	cl ContactList
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *ContactListPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ContactListPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	next, err := page.fn(ctx, page.cl)
	if err != nil {
		return err
	}
	page.cl = next
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *ContactListPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page ContactListPage) NotDone() bool {
	return !page.cl.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page ContactListPage) Response() ContactList {
	return page.cl
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page ContactListPage) Values() []Contact {
	if page.cl.IsEmpty() {
		return nil
	}
	return *page.cl.Value
}

// Creates a new instance of the ContactListPage type.
func NewContactListPage(getNextPage func(context.Context, ContactList) (ContactList, error)) ContactListPage {
	return ContactListPage{fn: getNextPage}
}

// ContactProperties describes security contact properties
type ContactProperties struct {
	// Email - The email of this security contact
	Email *string `json:"email,omitempty"`
	// Phone - The phone number of this security contact
	Phone *string `json:"phone,omitempty"`
	// AlertNotifications - Whether to send security alerts notifications to the security contact. Possible values include: 'On', 'Off'
	AlertNotifications AlertNotifications `json:"alertNotifications,omitempty"`
	// AlertsToAdmins - Whether to send security alerts notifications to subscription admins. Possible values include: 'AlertsToAdminsOn', 'AlertsToAdminsOff'
	AlertsToAdmins AlertsToAdmins `json:"alertsToAdmins,omitempty"`
}

// ContainerRegistryVulnerabilityProperties additional context fields for container registry Vulnerability
// assessment
type ContainerRegistryVulnerabilityProperties struct {
	// Type - READ-ONLY; Vulnerability Type. e.g: Vulnerability, Potential Vulnerability, Information Gathered, Vulnerability
	Type *string `json:"type,omitempty"`
	// Cvss - READ-ONLY; Dictionary from cvss version to cvss details object
	Cvss map[string]*CVSS `json:"cvss"`
	// Patchable - READ-ONLY; Indicates whether a patch is available or not
	Patchable *bool `json:"patchable,omitempty"`
	// Cve - READ-ONLY; List of CVEs
	Cve *[]CVE `json:"cve,omitempty"`
	// PublishedTime - READ-ONLY; Published time
	PublishedTime *date.Time `json:"publishedTime,omitempty"`
	// VendorReferences - READ-ONLY
	VendorReferences *[]VendorReference `json:"vendorReferences,omitempty"`
	// RepositoryName - READ-ONLY; Name of the repository which the vulnerable image belongs to
	RepositoryName *string `json:"repositoryName,omitempty"`
	// ImageDigest - READ-ONLY; Digest of the vulnerable image
	ImageDigest *string `json:"imageDigest,omitempty"`
	// AssessedResourceType - Possible values include: 'AssessedResourceTypeAdditionalData', 'AssessedResourceTypeSQLServerVulnerability', 'AssessedResourceTypeContainerRegistryVulnerability', 'AssessedResourceTypeServerVulnerabilityAssessment'
	AssessedResourceType AssessedResourceType `json:"assessedResourceType,omitempty"`
}

// MarshalJSON is the custom marshaler for ContainerRegistryVulnerabilityProperties.
func (crvp ContainerRegistryVulnerabilityProperties) MarshalJSON() ([]byte, error) {
	crvp.AssessedResourceType = AssessedResourceTypeContainerRegistryVulnerability
	objectMap := make(map[string]interface{})
	if crvp.AssessedResourceType != "" {
		objectMap["assessedResourceType"] = crvp.AssessedResourceType
	}
	return json.Marshal(objectMap)
}

// AsSQLServerVulnerabilityProperties is the BasicAdditionalData implementation for ContainerRegistryVulnerabilityProperties.
func (crvp ContainerRegistryVulnerabilityProperties) AsSQLServerVulnerabilityProperties() (*SQLServerVulnerabilityProperties, bool) {
	return nil, false
}

// AsContainerRegistryVulnerabilityProperties is the BasicAdditionalData implementation for ContainerRegistryVulnerabilityProperties.
func (crvp ContainerRegistryVulnerabilityProperties) AsContainerRegistryVulnerabilityProperties() (*ContainerRegistryVulnerabilityProperties, bool) {
	return &crvp, true
}

// AsServerVulnerabilityProperties is the BasicAdditionalData implementation for ContainerRegistryVulnerabilityProperties.
func (crvp ContainerRegistryVulnerabilityProperties) AsServerVulnerabilityProperties() (*ServerVulnerabilityProperties, bool) {
	return nil, false
}

// AsAdditionalData is the BasicAdditionalData implementation for ContainerRegistryVulnerabilityProperties.
func (crvp ContainerRegistryVulnerabilityProperties) AsAdditionalData() (*AdditionalData, bool) {
	return nil, false
}

// AsBasicAdditionalData is the BasicAdditionalData implementation for ContainerRegistryVulnerabilityProperties.
func (crvp ContainerRegistryVulnerabilityProperties) AsBasicAdditionalData() (BasicAdditionalData, bool) {
	return &crvp, true
}

// CustomAlertRule a custom alert rule.
type CustomAlertRule struct {
	// DisplayName - READ-ONLY; The display name of the custom alert.
	DisplayName *string `json:"displayName,omitempty"`
	// Description - READ-ONLY; The description of the custom alert.
	Description *string `json:"description,omitempty"`
	// IsEnabled - Status of the custom alert.
	IsEnabled *bool `json:"isEnabled,omitempty"`
	// RuleType - The type of the custom alert rule.
	RuleType *string `json:"ruleType,omitempty"`
}

// CVE CVE details
type CVE struct {
	// Title - READ-ONLY; CVE title
	Title *string `json:"title,omitempty"`
	// Link - READ-ONLY; Link url
	Link *string `json:"link,omitempty"`
}

// CVSS CVSS details
type CVSS struct {
	// Base - READ-ONLY; CVSS base
	Base *float64 `json:"base,omitempty"`
}

// DataExportSetting represents a data export setting
type DataExportSetting struct {
	// DataExportSettingProperties - Data export setting data
	*DataExportSettingProperties `json:"properties,omitempty"`
	// Kind - the kind of the settings string (DataExportSetting). Possible values include: 'SettingKindDataExportSetting', 'SettingKindAlertSuppressionSetting'
	Kind SettingKind `json:"kind,omitempty"`
	// ID - READ-ONLY; Resource Id
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for DataExportSetting.
func (desVar DataExportSetting) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if desVar.DataExportSettingProperties != nil {
		objectMap["properties"] = desVar.DataExportSettingProperties
	}
	if desVar.Kind != "" {
		objectMap["kind"] = desVar.Kind
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for DataExportSetting struct.
func (desVar *DataExportSetting) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var dataExportSettingProperties DataExportSettingProperties
				err = json.Unmarshal(*v, &dataExportSettingProperties)
				if err != nil {
					return err
				}
				desVar.DataExportSettingProperties = &dataExportSettingProperties
			}
		case "kind":
			if v != nil {
				var kind SettingKind
				err = json.Unmarshal(*v, &kind)
				if err != nil {
					return err
				}
				desVar.Kind = kind
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				desVar.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				desVar.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				desVar.Type = &typeVar
			}
		}
	}

	return nil
}

// DataExportSettingProperties the data export setting properties
type DataExportSettingProperties struct {
	// Enabled - Is the data export setting is enabled
	Enabled *bool `json:"enabled,omitempty"`
}

// DenylistCustomAlertRule a custom alert rule that checks if a value (depends on the custom alert type) is
// denied.
type DenylistCustomAlertRule struct {
	// DenylistValues - The values to deny. The format of the values depends on the rule type.
	DenylistValues *[]string `json:"denylistValues,omitempty"`
	// ValueType - READ-ONLY; The value type of the items in the list. Possible values include: 'ValueTypeIPCidr', 'ValueTypeString'
	ValueType ValueType `json:"valueType,omitempty"`
	// DisplayName - READ-ONLY; The display name of the custom alert.
	DisplayName *string `json:"displayName,omitempty"`
	// Description - READ-ONLY; The description of the custom alert.
	Description *string `json:"description,omitempty"`
	// IsEnabled - Status of the custom alert.
	IsEnabled *bool `json:"isEnabled,omitempty"`
	// RuleType - The type of the custom alert rule.
	RuleType *string `json:"ruleType,omitempty"`
}

// DeviceSecurityGroup the device security group resource
type DeviceSecurityGroup struct {
	autorest.Response `json:"-"`
	// DeviceSecurityGroupProperties - Device Security group data
	*DeviceSecurityGroupProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Resource Id
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for DeviceSecurityGroup.
func (dsg DeviceSecurityGroup) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if dsg.DeviceSecurityGroupProperties != nil {
		objectMap["properties"] = dsg.DeviceSecurityGroupProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for DeviceSecurityGroup struct.
func (dsg *DeviceSecurityGroup) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var deviceSecurityGroupProperties DeviceSecurityGroupProperties
				err = json.Unmarshal(*v, &deviceSecurityGroupProperties)
				if err != nil {
					return err
				}
				dsg.DeviceSecurityGroupProperties = &deviceSecurityGroupProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				dsg.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				dsg.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				dsg.Type = &typeVar
			}
		}
	}

	return nil
}

// DeviceSecurityGroupList list of device security groups
type DeviceSecurityGroupList struct {
	autorest.Response `json:"-"`
	// Value - List of device security group objects
	Value *[]DeviceSecurityGroup `json:"value,omitempty"`
	// NextLink - READ-ONLY; The URI to fetch the next page.
	NextLink *string `json:"nextLink,omitempty"`
}

// DeviceSecurityGroupListIterator provides access to a complete listing of DeviceSecurityGroup values.
type DeviceSecurityGroupListIterator struct {
	i    int
	page DeviceSecurityGroupListPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *DeviceSecurityGroupListIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/DeviceSecurityGroupListIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *DeviceSecurityGroupListIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter DeviceSecurityGroupListIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter DeviceSecurityGroupListIterator) Response() DeviceSecurityGroupList {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter DeviceSecurityGroupListIterator) Value() DeviceSecurityGroup {
	if !iter.page.NotDone() {
		return DeviceSecurityGroup{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the DeviceSecurityGroupListIterator type.
func NewDeviceSecurityGroupListIterator(page DeviceSecurityGroupListPage) DeviceSecurityGroupListIterator {
	return DeviceSecurityGroupListIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (dsgl DeviceSecurityGroupList) IsEmpty() bool {
	return dsgl.Value == nil || len(*dsgl.Value) == 0
}

// deviceSecurityGroupListPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (dsgl DeviceSecurityGroupList) deviceSecurityGroupListPreparer(ctx context.Context) (*http.Request, error) {
	if dsgl.NextLink == nil || len(to.String(dsgl.NextLink)) < 1 {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(dsgl.NextLink)))
}

// DeviceSecurityGroupListPage contains a page of DeviceSecurityGroup values.
type DeviceSecurityGroupListPage struct {
	fn   func(context.Context, DeviceSecurityGroupList) (DeviceSecurityGroupList, error)
	dsgl DeviceSecurityGroupList
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *DeviceSecurityGroupListPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/DeviceSecurityGroupListPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	next, err := page.fn(ctx, page.dsgl)
	if err != nil {
		return err
	}
	page.dsgl = next
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *DeviceSecurityGroupListPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page DeviceSecurityGroupListPage) NotDone() bool {
	return !page.dsgl.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page DeviceSecurityGroupListPage) Response() DeviceSecurityGroupList {
	return page.dsgl
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page DeviceSecurityGroupListPage) Values() []DeviceSecurityGroup {
	if page.dsgl.IsEmpty() {
		return nil
	}
	return *page.dsgl.Value
}

// Creates a new instance of the DeviceSecurityGroupListPage type.
func NewDeviceSecurityGroupListPage(getNextPage func(context.Context, DeviceSecurityGroupList) (DeviceSecurityGroupList, error)) DeviceSecurityGroupListPage {
	return DeviceSecurityGroupListPage{fn: getNextPage}
}

// DeviceSecurityGroupProperties describes properties of a security group.
type DeviceSecurityGroupProperties struct {
	// ThresholdRules - The list of custom alert threshold rules.
	ThresholdRules *[]ThresholdCustomAlertRule `json:"thresholdRules,omitempty"`
	// TimeWindowRules - The list of custom alert time-window rules.
	TimeWindowRules *[]TimeWindowCustomAlertRule `json:"timeWindowRules,omitempty"`
	// AllowlistRules - The allow-list custom alert rules.
	AllowlistRules *[]AllowlistCustomAlertRule `json:"allowlistRules,omitempty"`
	// DenylistRules - The deny-list custom alert rules.
	DenylistRules *[]DenylistCustomAlertRule `json:"denylistRules,omitempty"`
}

// DiscoveredSecuritySolution ...
type DiscoveredSecuritySolution struct {
	autorest.Response `json:"-"`
	// ID - READ-ONLY; Resource Id
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type
	Type *string `json:"type,omitempty"`
	// Location - READ-ONLY; Location where the resource is stored
	Location                              *string `json:"location,omitempty"`
	*DiscoveredSecuritySolutionProperties `json:"properties,omitempty"`
}

// MarshalJSON is the custom marshaler for DiscoveredSecuritySolution.
func (dss DiscoveredSecuritySolution) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if dss.DiscoveredSecuritySolutionProperties != nil {
		objectMap["properties"] = dss.DiscoveredSecuritySolutionProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for DiscoveredSecuritySolution struct.
func (dss *DiscoveredSecuritySolution) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				dss.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				dss.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				dss.Type = &typeVar
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				dss.Location = &location
			}
		case "properties":
			if v != nil {
				var discoveredSecuritySolutionProperties DiscoveredSecuritySolutionProperties
				err = json.Unmarshal(*v, &discoveredSecuritySolutionProperties)
				if err != nil {
					return err
				}
				dss.DiscoveredSecuritySolutionProperties = &discoveredSecuritySolutionProperties
			}
		}
	}

	return nil
}

// DiscoveredSecuritySolutionList ...
type DiscoveredSecuritySolutionList struct {
	autorest.Response `json:"-"`
	Value             *[]DiscoveredSecuritySolution `json:"value,omitempty"`
	// NextLink - READ-ONLY; The URI to fetch the next page.
	NextLink *string `json:"nextLink,omitempty"`
}

// DiscoveredSecuritySolutionListIterator provides access to a complete listing of
// DiscoveredSecuritySolution values.
type DiscoveredSecuritySolutionListIterator struct {
	i    int
	page DiscoveredSecuritySolutionListPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *DiscoveredSecuritySolutionListIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/DiscoveredSecuritySolutionListIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *DiscoveredSecuritySolutionListIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter DiscoveredSecuritySolutionListIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter DiscoveredSecuritySolutionListIterator) Response() DiscoveredSecuritySolutionList {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter DiscoveredSecuritySolutionListIterator) Value() DiscoveredSecuritySolution {
	if !iter.page.NotDone() {
		return DiscoveredSecuritySolution{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the DiscoveredSecuritySolutionListIterator type.
func NewDiscoveredSecuritySolutionListIterator(page DiscoveredSecuritySolutionListPage) DiscoveredSecuritySolutionListIterator {
	return DiscoveredSecuritySolutionListIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (dssl DiscoveredSecuritySolutionList) IsEmpty() bool {
	return dssl.Value == nil || len(*dssl.Value) == 0
}

// discoveredSecuritySolutionListPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (dssl DiscoveredSecuritySolutionList) discoveredSecuritySolutionListPreparer(ctx context.Context) (*http.Request, error) {
	if dssl.NextLink == nil || len(to.String(dssl.NextLink)) < 1 {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(dssl.NextLink)))
}

// DiscoveredSecuritySolutionListPage contains a page of DiscoveredSecuritySolution values.
type DiscoveredSecuritySolutionListPage struct {
	fn   func(context.Context, DiscoveredSecuritySolutionList) (DiscoveredSecuritySolutionList, error)
	dssl DiscoveredSecuritySolutionList
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *DiscoveredSecuritySolutionListPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/DiscoveredSecuritySolutionListPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	next, err := page.fn(ctx, page.dssl)
	if err != nil {
		return err
	}
	page.dssl = next
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *DiscoveredSecuritySolutionListPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page DiscoveredSecuritySolutionListPage) NotDone() bool {
	return !page.dssl.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page DiscoveredSecuritySolutionListPage) Response() DiscoveredSecuritySolutionList {
	return page.dssl
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page DiscoveredSecuritySolutionListPage) Values() []DiscoveredSecuritySolution {
	if page.dssl.IsEmpty() {
		return nil
	}
	return *page.dssl.Value
}

// Creates a new instance of the DiscoveredSecuritySolutionListPage type.
func NewDiscoveredSecuritySolutionListPage(getNextPage func(context.Context, DiscoveredSecuritySolutionList) (DiscoveredSecuritySolutionList, error)) DiscoveredSecuritySolutionListPage {
	return DiscoveredSecuritySolutionListPage{fn: getNextPage}
}

// DiscoveredSecuritySolutionProperties ...
type DiscoveredSecuritySolutionProperties struct {
	// SecurityFamily - The security family of the discovered solution. Possible values include: 'Waf', 'Ngfw', 'SaasWaf', 'Va'
	SecurityFamily Family `json:"securityFamily,omitempty"`
	// Offer - The security solutions' image offer
	Offer *string `json:"offer,omitempty"`
	// Publisher - The security solutions' image publisher
	Publisher *string `json:"publisher,omitempty"`
	// Sku - The security solutions' image sku
	Sku *string `json:"sku,omitempty"`
}

// ETag entity tag is used for comparing two or more entities from the same requested resource.
type ETag struct {
	// Etag - Entity tag is used for comparing two or more entities from the same requested resource.
	Etag *string `json:"etag,omitempty"`
}

// BasicExternalSecuritySolution represents a security solution external to Azure Security Center which sends
// information to an OMS workspace and whose data is displayed by Azure Security Center.
type BasicExternalSecuritySolution interface {
	AsCefExternalSecuritySolution() (*CefExternalSecuritySolution, bool)
	AsAtaExternalSecuritySolution() (*AtaExternalSecuritySolution, bool)
	AsAadExternalSecuritySolution() (*AadExternalSecuritySolution, bool)
	AsExternalSecuritySolution() (*ExternalSecuritySolution, bool)
}

// ExternalSecuritySolution represents a security solution external to Azure Security Center which sends
// information to an OMS workspace and whose data is displayed by Azure Security Center.
type ExternalSecuritySolution struct {
	autorest.Response `json:"-"`
	// ID - READ-ONLY; Resource Id
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type
	Type *string `json:"type,omitempty"`
	// Location - READ-ONLY; Location where the resource is stored
	Location *string `json:"location,omitempty"`
	// Kind - Possible values include: 'KindExternalSecuritySolution', 'KindCEF', 'KindATA', 'KindAAD'
	Kind KindEnum `json:"kind,omitempty"`
}

func unmarshalBasicExternalSecuritySolution(body []byte) (BasicExternalSecuritySolution, error) {
	var m map[string]interface{}
	err := json.Unmarshal(body, &m)
	if err != nil {
		return nil, err
	}

	switch m["kind"] {
	case string(KindCEF):
		var cess CefExternalSecuritySolution
		err := json.Unmarshal(body, &cess)
		return cess, err
	case string(KindATA):
		var aess AtaExternalSecuritySolution
		err := json.Unmarshal(body, &aess)
		return aess, err
	case string(KindAAD):
		var aess AadExternalSecuritySolution
		err := json.Unmarshal(body, &aess)
		return aess, err
	default:
		var ess ExternalSecuritySolution
		err := json.Unmarshal(body, &ess)
		return ess, err
	}
}
func unmarshalBasicExternalSecuritySolutionArray(body []byte) ([]BasicExternalSecuritySolution, error) {
	var rawMessages []*json.RawMessage
	err := json.Unmarshal(body, &rawMessages)
	if err != nil {
		return nil, err
	}

	essArray := make([]BasicExternalSecuritySolution, len(rawMessages))

	for index, rawMessage := range rawMessages {
		ess, err := unmarshalBasicExternalSecuritySolution(*rawMessage)
		if err != nil {
			return nil, err
		}
		essArray[index] = ess
	}
	return essArray, nil
}

// MarshalJSON is the custom marshaler for ExternalSecuritySolution.
func (ess ExternalSecuritySolution) MarshalJSON() ([]byte, error) {
	ess.Kind = KindExternalSecuritySolution
	objectMap := make(map[string]interface{})
	if ess.Kind != "" {
		objectMap["kind"] = ess.Kind
	}
	return json.Marshal(objectMap)
}

// AsCefExternalSecuritySolution is the BasicExternalSecuritySolution implementation for ExternalSecuritySolution.
func (ess ExternalSecuritySolution) AsCefExternalSecuritySolution() (*CefExternalSecuritySolution, bool) {
	return nil, false
}

// AsAtaExternalSecuritySolution is the BasicExternalSecuritySolution implementation for ExternalSecuritySolution.
func (ess ExternalSecuritySolution) AsAtaExternalSecuritySolution() (*AtaExternalSecuritySolution, bool) {
	return nil, false
}

// AsAadExternalSecuritySolution is the BasicExternalSecuritySolution implementation for ExternalSecuritySolution.
func (ess ExternalSecuritySolution) AsAadExternalSecuritySolution() (*AadExternalSecuritySolution, bool) {
	return nil, false
}

// AsExternalSecuritySolution is the BasicExternalSecuritySolution implementation for ExternalSecuritySolution.
func (ess ExternalSecuritySolution) AsExternalSecuritySolution() (*ExternalSecuritySolution, bool) {
	return &ess, true
}

// AsBasicExternalSecuritySolution is the BasicExternalSecuritySolution implementation for ExternalSecuritySolution.
func (ess ExternalSecuritySolution) AsBasicExternalSecuritySolution() (BasicExternalSecuritySolution, bool) {
	return &ess, true
}

// ExternalSecuritySolutionKind1 describes an Azure resource with kind
type ExternalSecuritySolutionKind1 struct {
	// Kind - The kind of the external solution. Possible values include: 'CEF', 'ATA', 'AAD'
	Kind ExternalSecuritySolutionKind `json:"kind,omitempty"`
}

// ExternalSecuritySolutionList ...
type ExternalSecuritySolutionList struct {
	autorest.Response `json:"-"`
	Value             *[]BasicExternalSecuritySolution `json:"value,omitempty"`
	// NextLink - READ-ONLY; The URI to fetch the next page.
	NextLink *string `json:"nextLink,omitempty"`
}

// UnmarshalJSON is the custom unmarshaler for ExternalSecuritySolutionList struct.
func (essl *ExternalSecuritySolutionList) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "value":
			if v != nil {
				value, err := unmarshalBasicExternalSecuritySolutionArray(*v)
				if err != nil {
					return err
				}
				essl.Value = &value
			}
		case "nextLink":
			if v != nil {
				var nextLink string
				err = json.Unmarshal(*v, &nextLink)
				if err != nil {
					return err
				}
				essl.NextLink = &nextLink
			}
		}
	}

	return nil
}

// ExternalSecuritySolutionListIterator provides access to a complete listing of ExternalSecuritySolution
// values.
type ExternalSecuritySolutionListIterator struct {
	i    int
	page ExternalSecuritySolutionListPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *ExternalSecuritySolutionListIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ExternalSecuritySolutionListIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *ExternalSecuritySolutionListIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter ExternalSecuritySolutionListIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter ExternalSecuritySolutionListIterator) Response() ExternalSecuritySolutionList {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter ExternalSecuritySolutionListIterator) Value() BasicExternalSecuritySolution {
	if !iter.page.NotDone() {
		return ExternalSecuritySolution{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the ExternalSecuritySolutionListIterator type.
func NewExternalSecuritySolutionListIterator(page ExternalSecuritySolutionListPage) ExternalSecuritySolutionListIterator {
	return ExternalSecuritySolutionListIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (essl ExternalSecuritySolutionList) IsEmpty() bool {
	return essl.Value == nil || len(*essl.Value) == 0
}

// externalSecuritySolutionListPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (essl ExternalSecuritySolutionList) externalSecuritySolutionListPreparer(ctx context.Context) (*http.Request, error) {
	if essl.NextLink == nil || len(to.String(essl.NextLink)) < 1 {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(essl.NextLink)))
}

// ExternalSecuritySolutionListPage contains a page of BasicExternalSecuritySolution values.
type ExternalSecuritySolutionListPage struct {
	fn   func(context.Context, ExternalSecuritySolutionList) (ExternalSecuritySolutionList, error)
	essl ExternalSecuritySolutionList
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *ExternalSecuritySolutionListPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ExternalSecuritySolutionListPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	next, err := page.fn(ctx, page.essl)
	if err != nil {
		return err
	}
	page.essl = next
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *ExternalSecuritySolutionListPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page ExternalSecuritySolutionListPage) NotDone() bool {
	return !page.essl.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page ExternalSecuritySolutionListPage) Response() ExternalSecuritySolutionList {
	return page.essl
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page ExternalSecuritySolutionListPage) Values() []BasicExternalSecuritySolution {
	if page.essl.IsEmpty() {
		return nil
	}
	return *page.essl.Value
}

// Creates a new instance of the ExternalSecuritySolutionListPage type.
func NewExternalSecuritySolutionListPage(getNextPage func(context.Context, ExternalSecuritySolutionList) (ExternalSecuritySolutionList, error)) ExternalSecuritySolutionListPage {
	return ExternalSecuritySolutionListPage{fn: getNextPage}
}

// ExternalSecuritySolutionModel ...
type ExternalSecuritySolutionModel struct {
	autorest.Response `json:"-"`
	Value             BasicExternalSecuritySolution `json:"value,omitempty"`
}

// UnmarshalJSON is the custom unmarshaler for ExternalSecuritySolutionModel struct.
func (essm *ExternalSecuritySolutionModel) UnmarshalJSON(body []byte) error {
	ess, err := unmarshalBasicExternalSecuritySolution(body)
	if err != nil {
		return err
	}
	essm.Value = ess

	return nil
}

// ExternalSecuritySolutionProperties the solution properties (correspond to the solution kind)
type ExternalSecuritySolutionProperties struct {
	// AdditionalProperties - Unmatched properties from the message are deserialized this collection
	AdditionalProperties map[string]interface{} `json:""`
	DeviceVendor         *string                `json:"deviceVendor,omitempty"`
	DeviceType           *string                `json:"deviceType,omitempty"`
	Workspace            *ConnectedWorkspace    `json:"workspace,omitempty"`
}

// MarshalJSON is the custom marshaler for ExternalSecuritySolutionProperties.
func (essp ExternalSecuritySolutionProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if essp.DeviceVendor != nil {
		objectMap["deviceVendor"] = essp.DeviceVendor
	}
	if essp.DeviceType != nil {
		objectMap["deviceType"] = essp.DeviceType
	}
	if essp.Workspace != nil {
		objectMap["workspace"] = essp.Workspace
	}
	for k, v := range essp.AdditionalProperties {
		objectMap[k] = v
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for ExternalSecuritySolutionProperties struct.
func (essp *ExternalSecuritySolutionProperties) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		default:
			if v != nil {
				var additionalProperties interface{}
				err = json.Unmarshal(*v, &additionalProperties)
				if err != nil {
					return err
				}
				if essp.AdditionalProperties == nil {
					essp.AdditionalProperties = make(map[string]interface{})
				}
				essp.AdditionalProperties[k] = additionalProperties
			}
		case "deviceVendor":
			if v != nil {
				var deviceVendor string
				err = json.Unmarshal(*v, &deviceVendor)
				if err != nil {
					return err
				}
				essp.DeviceVendor = &deviceVendor
			}
		case "deviceType":
			if v != nil {
				var deviceType string
				err = json.Unmarshal(*v, &deviceType)
				if err != nil {
					return err
				}
				essp.DeviceType = &deviceType
			}
		case "workspace":
			if v != nil {
				var workspace ConnectedWorkspace
				err = json.Unmarshal(*v, &workspace)
				if err != nil {
					return err
				}
				essp.Workspace = &workspace
			}
		}
	}

	return nil
}

// InformationProtectionKeyword the information type keyword.
type InformationProtectionKeyword struct {
	// Pattern - The keyword pattern.
	Pattern *string `json:"pattern,omitempty"`
	// Custom - Indicates whether the keyword is custom or not.
	Custom *bool `json:"custom,omitempty"`
	// CanBeNumeric - Indicates whether the keyword can be applied on numeric types or not.
	CanBeNumeric *bool `json:"canBeNumeric,omitempty"`
	// Excluded - Indicates whether the keyword is excluded or not.
	Excluded *bool `json:"excluded,omitempty"`
}

// InformationProtectionPolicy information protection policy.
type InformationProtectionPolicy struct {
	autorest.Response `json:"-"`
	// InformationProtectionPolicyProperties - Information protection policy data
	*InformationProtectionPolicyProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Resource Id
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for InformationProtectionPolicy.
func (ipp InformationProtectionPolicy) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if ipp.InformationProtectionPolicyProperties != nil {
		objectMap["properties"] = ipp.InformationProtectionPolicyProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for InformationProtectionPolicy struct.
func (ipp *InformationProtectionPolicy) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var informationProtectionPolicyProperties InformationProtectionPolicyProperties
				err = json.Unmarshal(*v, &informationProtectionPolicyProperties)
				if err != nil {
					return err
				}
				ipp.InformationProtectionPolicyProperties = &informationProtectionPolicyProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				ipp.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				ipp.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				ipp.Type = &typeVar
			}
		}
	}

	return nil
}

// InformationProtectionPolicyList information protection policies response.
type InformationProtectionPolicyList struct {
	autorest.Response `json:"-"`
	// Value - List of information protection policies.
	Value *[]InformationProtectionPolicy `json:"value,omitempty"`
	// NextLink - READ-ONLY; The URI to fetch the next page.
	NextLink *string `json:"nextLink,omitempty"`
}

// InformationProtectionPolicyListIterator provides access to a complete listing of
// InformationProtectionPolicy values.
type InformationProtectionPolicyListIterator struct {
	i    int
	page InformationProtectionPolicyListPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *InformationProtectionPolicyListIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/InformationProtectionPolicyListIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *InformationProtectionPolicyListIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter InformationProtectionPolicyListIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter InformationProtectionPolicyListIterator) Response() InformationProtectionPolicyList {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter InformationProtectionPolicyListIterator) Value() InformationProtectionPolicy {
	if !iter.page.NotDone() {
		return InformationProtectionPolicy{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the InformationProtectionPolicyListIterator type.
func NewInformationProtectionPolicyListIterator(page InformationProtectionPolicyListPage) InformationProtectionPolicyListIterator {
	return InformationProtectionPolicyListIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (ippl InformationProtectionPolicyList) IsEmpty() bool {
	return ippl.Value == nil || len(*ippl.Value) == 0
}

// informationProtectionPolicyListPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (ippl InformationProtectionPolicyList) informationProtectionPolicyListPreparer(ctx context.Context) (*http.Request, error) {
	if ippl.NextLink == nil || len(to.String(ippl.NextLink)) < 1 {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(ippl.NextLink)))
}

// InformationProtectionPolicyListPage contains a page of InformationProtectionPolicy values.
type InformationProtectionPolicyListPage struct {
	fn   func(context.Context, InformationProtectionPolicyList) (InformationProtectionPolicyList, error)
	ippl InformationProtectionPolicyList
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *InformationProtectionPolicyListPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/InformationProtectionPolicyListPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	next, err := page.fn(ctx, page.ippl)
	if err != nil {
		return err
	}
	page.ippl = next
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *InformationProtectionPolicyListPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page InformationProtectionPolicyListPage) NotDone() bool {
	return !page.ippl.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page InformationProtectionPolicyListPage) Response() InformationProtectionPolicyList {
	return page.ippl
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page InformationProtectionPolicyListPage) Values() []InformationProtectionPolicy {
	if page.ippl.IsEmpty() {
		return nil
	}
	return *page.ippl.Value
}

// Creates a new instance of the InformationProtectionPolicyListPage type.
func NewInformationProtectionPolicyListPage(getNextPage func(context.Context, InformationProtectionPolicyList) (InformationProtectionPolicyList, error)) InformationProtectionPolicyListPage {
	return InformationProtectionPolicyListPage{fn: getNextPage}
}

// InformationProtectionPolicyProperties describes properties of an information protection policy.
type InformationProtectionPolicyProperties struct {
	// LastModifiedUtc - READ-ONLY; Describes the last UTC time the policy was modified.
	LastModifiedUtc *date.Time `json:"lastModifiedUtc,omitempty"`
	// Labels - Dictionary of sensitivity labels.
	Labels map[string]*SensitivityLabel `json:"labels"`
	// InformationTypes - The sensitivity information types.
	InformationTypes map[string]*InformationType `json:"informationTypes"`
}

// MarshalJSON is the custom marshaler for InformationProtectionPolicyProperties.
func (ippp InformationProtectionPolicyProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if ippp.Labels != nil {
		objectMap["labels"] = ippp.Labels
	}
	if ippp.InformationTypes != nil {
		objectMap["informationTypes"] = ippp.InformationTypes
	}
	return json.Marshal(objectMap)
}

// InformationType the information type.
type InformationType struct {
	// DisplayName - The name of the information type.
	DisplayName *string `json:"displayName,omitempty"`
	// Order - The order of the information type.
	Order *float64 `json:"order,omitempty"`
	// RecommendedLabelID - The recommended label id to be associated with this information type.
	RecommendedLabelID *uuid.UUID `json:"recommendedLabelId,omitempty"`
	// Enabled - Indicates whether the information type is enabled or not.
	Enabled *bool `json:"enabled,omitempty"`
	// Custom - Indicates whether the information type is custom or not.
	Custom *bool `json:"custom,omitempty"`
	// Keywords - The information type keywords.
	Keywords *[]InformationProtectionKeyword `json:"keywords,omitempty"`
}

// IoTSecurityAggregatedAlert security Solution Aggregated Alert information
type IoTSecurityAggregatedAlert struct {
	autorest.Response `json:"-"`
	// ID - READ-ONLY; Resource Id
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type
	Type *string `json:"type,omitempty"`
	// Tags - Resource tags
	Tags map[string]*string `json:"tags"`
	// IoTSecurityAggregatedAlertProperties - IoT Security solution aggregated alert details.
	*IoTSecurityAggregatedAlertProperties `json:"properties,omitempty"`
}

// MarshalJSON is the custom marshaler for IoTSecurityAggregatedAlert.
func (itsaa IoTSecurityAggregatedAlert) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if itsaa.Tags != nil {
		objectMap["tags"] = itsaa.Tags
	}
	if itsaa.IoTSecurityAggregatedAlertProperties != nil {
		objectMap["properties"] = itsaa.IoTSecurityAggregatedAlertProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for IoTSecurityAggregatedAlert struct.
func (itsaa *IoTSecurityAggregatedAlert) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				itsaa.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				itsaa.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				itsaa.Type = &typeVar
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				itsaa.Tags = tags
			}
		case "properties":
			if v != nil {
				var ioTSecurityAggregatedAlertProperties IoTSecurityAggregatedAlertProperties
				err = json.Unmarshal(*v, &ioTSecurityAggregatedAlertProperties)
				if err != nil {
					return err
				}
				itsaa.IoTSecurityAggregatedAlertProperties = &ioTSecurityAggregatedAlertProperties
			}
		}
	}

	return nil
}

// IoTSecurityAggregatedAlertList list of IoT Security solution aggregated alert data.
type IoTSecurityAggregatedAlertList struct {
	autorest.Response `json:"-"`
	// Value - List of aggregated alerts data.
	Value *[]IoTSecurityAggregatedAlert `json:"value,omitempty"`
	// NextLink - READ-ONLY; When there is too much alert data for one page, use this URI to fetch the next page.
	NextLink *string `json:"nextLink,omitempty"`
}

// IoTSecurityAggregatedAlertListIterator provides access to a complete listing of
// IoTSecurityAggregatedAlert values.
type IoTSecurityAggregatedAlertListIterator struct {
	i    int
	page IoTSecurityAggregatedAlertListPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *IoTSecurityAggregatedAlertListIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/IoTSecurityAggregatedAlertListIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *IoTSecurityAggregatedAlertListIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter IoTSecurityAggregatedAlertListIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter IoTSecurityAggregatedAlertListIterator) Response() IoTSecurityAggregatedAlertList {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter IoTSecurityAggregatedAlertListIterator) Value() IoTSecurityAggregatedAlert {
	if !iter.page.NotDone() {
		return IoTSecurityAggregatedAlert{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the IoTSecurityAggregatedAlertListIterator type.
func NewIoTSecurityAggregatedAlertListIterator(page IoTSecurityAggregatedAlertListPage) IoTSecurityAggregatedAlertListIterator {
	return IoTSecurityAggregatedAlertListIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (itsaal IoTSecurityAggregatedAlertList) IsEmpty() bool {
	return itsaal.Value == nil || len(*itsaal.Value) == 0
}

// ioTSecurityAggregatedAlertListPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (itsaal IoTSecurityAggregatedAlertList) ioTSecurityAggregatedAlertListPreparer(ctx context.Context) (*http.Request, error) {
	if itsaal.NextLink == nil || len(to.String(itsaal.NextLink)) < 1 {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(itsaal.NextLink)))
}

// IoTSecurityAggregatedAlertListPage contains a page of IoTSecurityAggregatedAlert values.
type IoTSecurityAggregatedAlertListPage struct {
	fn     func(context.Context, IoTSecurityAggregatedAlertList) (IoTSecurityAggregatedAlertList, error)
	itsaal IoTSecurityAggregatedAlertList
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *IoTSecurityAggregatedAlertListPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/IoTSecurityAggregatedAlertListPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	next, err := page.fn(ctx, page.itsaal)
	if err != nil {
		return err
	}
	page.itsaal = next
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *IoTSecurityAggregatedAlertListPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page IoTSecurityAggregatedAlertListPage) NotDone() bool {
	return !page.itsaal.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page IoTSecurityAggregatedAlertListPage) Response() IoTSecurityAggregatedAlertList {
	return page.itsaal
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page IoTSecurityAggregatedAlertListPage) Values() []IoTSecurityAggregatedAlert {
	if page.itsaal.IsEmpty() {
		return nil
	}
	return *page.itsaal.Value
}

// Creates a new instance of the IoTSecurityAggregatedAlertListPage type.
func NewIoTSecurityAggregatedAlertListPage(getNextPage func(context.Context, IoTSecurityAggregatedAlertList) (IoTSecurityAggregatedAlertList, error)) IoTSecurityAggregatedAlertListPage {
	return IoTSecurityAggregatedAlertListPage{fn: getNextPage}
}

// IoTSecurityAggregatedAlertProperties ioT Security solution aggregated alert details.
type IoTSecurityAggregatedAlertProperties struct {
	// AlertType - READ-ONLY; Name of the alert type.
	AlertType *string `json:"alertType,omitempty"`
	// AlertDisplayName - READ-ONLY; Display name of the alert type.
	AlertDisplayName *string `json:"alertDisplayName,omitempty"`
	// AggregatedDateUtc - READ-ONLY; Date of detection.
	AggregatedDateUtc *date.Date `json:"aggregatedDateUtc,omitempty"`
	// VendorName - READ-ONLY; Name of the organization that raised the alert.
	VendorName *string `json:"vendorName,omitempty"`
	// ReportedSeverity - READ-ONLY; Assessed alert severity. Possible values include: 'ReportedSeverityInformational', 'ReportedSeverityLow', 'ReportedSeverityMedium', 'ReportedSeverityHigh'
	ReportedSeverity ReportedSeverity `json:"reportedSeverity,omitempty"`
	// RemediationSteps - READ-ONLY; Recommended steps for remediation.
	RemediationSteps *string `json:"remediationSteps,omitempty"`
	// Description - READ-ONLY; Description of the suspected vulnerability and meaning.
	Description *string `json:"description,omitempty"`
	// Count - READ-ONLY; Number of alerts occurrences within the aggregated time window.
	Count *int32 `json:"count,omitempty"`
	// EffectedResourceType - READ-ONLY; Azure resource ID of the resource that received the alerts.
	EffectedResourceType *string `json:"effectedResourceType,omitempty"`
	// SystemSource - READ-ONLY; The type of the alerted resource (Azure, Non-Azure).
	SystemSource *string `json:"systemSource,omitempty"`
	// ActionTaken - READ-ONLY; IoT Security solution alert response.
	ActionTaken *string `json:"actionTaken,omitempty"`
	// LogAnalyticsQuery - READ-ONLY; Log analytics query for getting the list of affected devices/alerts.
	LogAnalyticsQuery *string `json:"logAnalyticsQuery,omitempty"`
	// TopDevicesList - READ-ONLY; 10 devices with the highest number of occurrences of this alert type, on this day.
	TopDevicesList *[]IoTSecurityAggregatedAlertPropertiesTopDevicesListItem `json:"topDevicesList,omitempty"`
}

// IoTSecurityAggregatedAlertPropertiesTopDevicesListItem ...
type IoTSecurityAggregatedAlertPropertiesTopDevicesListItem struct {
	// DeviceID - READ-ONLY; Name of the device.
	DeviceID *string `json:"deviceId,omitempty"`
	// AlertsCount - READ-ONLY; Number of alerts raised for this device.
	AlertsCount *int32 `json:"alertsCount,omitempty"`
	// LastOccurrence - READ-ONLY; Most recent time this alert was raised for this device, on this day.
	LastOccurrence *string `json:"lastOccurrence,omitempty"`
}

// IoTSecurityAggregatedRecommendation ioT Security solution recommendation information.
type IoTSecurityAggregatedRecommendation struct {
	autorest.Response `json:"-"`
	// ID - READ-ONLY; Resource Id
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type
	Type *string `json:"type,omitempty"`
	// Tags - Resource tags
	Tags map[string]*string `json:"tags"`
	// IoTSecurityAggregatedRecommendationProperties - Security Solution data
	*IoTSecurityAggregatedRecommendationProperties `json:"properties,omitempty"`
}

// MarshalJSON is the custom marshaler for IoTSecurityAggregatedRecommendation.
func (itsar IoTSecurityAggregatedRecommendation) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if itsar.Tags != nil {
		objectMap["tags"] = itsar.Tags
	}
	if itsar.IoTSecurityAggregatedRecommendationProperties != nil {
		objectMap["properties"] = itsar.IoTSecurityAggregatedRecommendationProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for IoTSecurityAggregatedRecommendation struct.
func (itsar *IoTSecurityAggregatedRecommendation) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				itsar.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				itsar.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				itsar.Type = &typeVar
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				itsar.Tags = tags
			}
		case "properties":
			if v != nil {
				var ioTSecurityAggregatedRecommendationProperties IoTSecurityAggregatedRecommendationProperties
				err = json.Unmarshal(*v, &ioTSecurityAggregatedRecommendationProperties)
				if err != nil {
					return err
				}
				itsar.IoTSecurityAggregatedRecommendationProperties = &ioTSecurityAggregatedRecommendationProperties
			}
		}
	}

	return nil
}

// IoTSecurityAggregatedRecommendationList list of IoT Security solution aggregated recommendations.
type IoTSecurityAggregatedRecommendationList struct {
	autorest.Response `json:"-"`
	// Value - List of aggregated recommendations data.
	Value *[]IoTSecurityAggregatedRecommendation `json:"value,omitempty"`
	// NextLink - READ-ONLY; When there is too much alert data for one page, use this URI to fetch the next page.
	NextLink *string `json:"nextLink,omitempty"`
}

// IoTSecurityAggregatedRecommendationListIterator provides access to a complete listing of
// IoTSecurityAggregatedRecommendation values.
type IoTSecurityAggregatedRecommendationListIterator struct {
	i    int
	page IoTSecurityAggregatedRecommendationListPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *IoTSecurityAggregatedRecommendationListIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/IoTSecurityAggregatedRecommendationListIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *IoTSecurityAggregatedRecommendationListIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter IoTSecurityAggregatedRecommendationListIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter IoTSecurityAggregatedRecommendationListIterator) Response() IoTSecurityAggregatedRecommendationList {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter IoTSecurityAggregatedRecommendationListIterator) Value() IoTSecurityAggregatedRecommendation {
	if !iter.page.NotDone() {
		return IoTSecurityAggregatedRecommendation{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the IoTSecurityAggregatedRecommendationListIterator type.
func NewIoTSecurityAggregatedRecommendationListIterator(page IoTSecurityAggregatedRecommendationListPage) IoTSecurityAggregatedRecommendationListIterator {
	return IoTSecurityAggregatedRecommendationListIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (itsarl IoTSecurityAggregatedRecommendationList) IsEmpty() bool {
	return itsarl.Value == nil || len(*itsarl.Value) == 0
}

// ioTSecurityAggregatedRecommendationListPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (itsarl IoTSecurityAggregatedRecommendationList) ioTSecurityAggregatedRecommendationListPreparer(ctx context.Context) (*http.Request, error) {
	if itsarl.NextLink == nil || len(to.String(itsarl.NextLink)) < 1 {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(itsarl.NextLink)))
}

// IoTSecurityAggregatedRecommendationListPage contains a page of IoTSecurityAggregatedRecommendation
// values.
type IoTSecurityAggregatedRecommendationListPage struct {
	fn     func(context.Context, IoTSecurityAggregatedRecommendationList) (IoTSecurityAggregatedRecommendationList, error)
	itsarl IoTSecurityAggregatedRecommendationList
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *IoTSecurityAggregatedRecommendationListPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/IoTSecurityAggregatedRecommendationListPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	next, err := page.fn(ctx, page.itsarl)
	if err != nil {
		return err
	}
	page.itsarl = next
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *IoTSecurityAggregatedRecommendationListPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page IoTSecurityAggregatedRecommendationListPage) NotDone() bool {
	return !page.itsarl.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page IoTSecurityAggregatedRecommendationListPage) Response() IoTSecurityAggregatedRecommendationList {
	return page.itsarl
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page IoTSecurityAggregatedRecommendationListPage) Values() []IoTSecurityAggregatedRecommendation {
	if page.itsarl.IsEmpty() {
		return nil
	}
	return *page.itsarl.Value
}

// Creates a new instance of the IoTSecurityAggregatedRecommendationListPage type.
func NewIoTSecurityAggregatedRecommendationListPage(getNextPage func(context.Context, IoTSecurityAggregatedRecommendationList) (IoTSecurityAggregatedRecommendationList, error)) IoTSecurityAggregatedRecommendationListPage {
	return IoTSecurityAggregatedRecommendationListPage{fn: getNextPage}
}

// IoTSecurityAggregatedRecommendationProperties ioT Security solution aggregated recommendation
// information
type IoTSecurityAggregatedRecommendationProperties struct {
	// RecommendationName - Name of the recommendation.
	RecommendationName *string `json:"recommendationName,omitempty"`
	// RecommendationDisplayName - READ-ONLY; Display name of the recommendation type.
	RecommendationDisplayName *string `json:"recommendationDisplayName,omitempty"`
	// Description - READ-ONLY; Description of the suspected vulnerability and meaning.
	Description *string `json:"description,omitempty"`
	// RecommendationTypeID - READ-ONLY; Recommendation-type GUID.
	RecommendationTypeID *string `json:"recommendationTypeId,omitempty"`
	// DetectedBy - READ-ONLY; Name of the organization that made the recommendation.
	DetectedBy *string `json:"detectedBy,omitempty"`
	// RemediationSteps - READ-ONLY; Recommended steps for remediation
	RemediationSteps *string `json:"remediationSteps,omitempty"`
	// ReportedSeverity - READ-ONLY; Assessed recommendation severity. Possible values include: 'ReportedSeverityInformational', 'ReportedSeverityLow', 'ReportedSeverityMedium', 'ReportedSeverityHigh'
	ReportedSeverity ReportedSeverity `json:"reportedSeverity,omitempty"`
	// HealthyDevices - READ-ONLY; Number of healthy devices within the IoT Security solution.
	HealthyDevices *int32 `json:"healthyDevices,omitempty"`
	// UnhealthyDeviceCount - READ-ONLY; Number of unhealthy devices within the IoT Security solution.
	UnhealthyDeviceCount *int32 `json:"unhealthyDeviceCount,omitempty"`
	// LogAnalyticsQuery - READ-ONLY; Log analytics query for getting the list of affected devices/alerts.
	LogAnalyticsQuery *string `json:"logAnalyticsQuery,omitempty"`
}

// IoTSecurityAlertedDevice statistical information about the number of alerts per device during last set
// number of days.
type IoTSecurityAlertedDevice struct {
	// DeviceID - READ-ONLY; Device identifier.
	DeviceID *string `json:"deviceId,omitempty"`
	// AlertsCount - READ-ONLY; Number of alerts raised for this device.
	AlertsCount *int32 `json:"alertsCount,omitempty"`
}

// IoTSecurityDeviceAlert statistical information about the number of alerts per alert type during last set
// number of days
type IoTSecurityDeviceAlert struct {
	// AlertDisplayName - READ-ONLY; Display name of the alert
	AlertDisplayName *string `json:"alertDisplayName,omitempty"`
	// ReportedSeverity - READ-ONLY; Assessed Alert severity. Possible values include: 'ReportedSeverityInformational', 'ReportedSeverityLow', 'ReportedSeverityMedium', 'ReportedSeverityHigh'
	ReportedSeverity ReportedSeverity `json:"reportedSeverity,omitempty"`
	// AlertsCount - READ-ONLY; Number of alerts raised for this alert type.
	AlertsCount *int32 `json:"alertsCount,omitempty"`
}

// IoTSecurityDeviceRecommendation statistical information about the number of recommendations per device,
// per recommendation type.
type IoTSecurityDeviceRecommendation struct {
	// RecommendationDisplayName - READ-ONLY; Display name of the recommendation.
	RecommendationDisplayName *string `json:"recommendationDisplayName,omitempty"`
	// ReportedSeverity - READ-ONLY; Assessed recommendation severity. Possible values include: 'ReportedSeverityInformational', 'ReportedSeverityLow', 'ReportedSeverityMedium', 'ReportedSeverityHigh'
	ReportedSeverity ReportedSeverity `json:"reportedSeverity,omitempty"`
	// DevicesCount - READ-ONLY; Number of devices with this recommendation.
	DevicesCount *int32 `json:"devicesCount,omitempty"`
}

// IoTSecuritySolutionAnalyticsModel security analytics of your IoT Security solution
type IoTSecuritySolutionAnalyticsModel struct {
	autorest.Response `json:"-"`
	// IoTSecuritySolutionAnalyticsModelProperties - Security Solution  Aggregated Alert data
	*IoTSecuritySolutionAnalyticsModelProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Resource Id
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for IoTSecuritySolutionAnalyticsModel.
func (itssam IoTSecuritySolutionAnalyticsModel) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if itssam.IoTSecuritySolutionAnalyticsModelProperties != nil {
		objectMap["properties"] = itssam.IoTSecuritySolutionAnalyticsModelProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for IoTSecuritySolutionAnalyticsModel struct.
func (itssam *IoTSecuritySolutionAnalyticsModel) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var ioTSecuritySolutionAnalyticsModelProperties IoTSecuritySolutionAnalyticsModelProperties
				err = json.Unmarshal(*v, &ioTSecuritySolutionAnalyticsModelProperties)
				if err != nil {
					return err
				}
				itssam.IoTSecuritySolutionAnalyticsModelProperties = &ioTSecuritySolutionAnalyticsModelProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				itssam.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				itssam.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				itssam.Type = &typeVar
			}
		}
	}

	return nil
}

// IoTSecuritySolutionAnalyticsModelList list of Security analytics of your IoT Security solution
type IoTSecuritySolutionAnalyticsModelList struct {
	autorest.Response `json:"-"`
	// Value - List of Security analytics of your IoT Security solution
	Value *[]IoTSecuritySolutionAnalyticsModel `json:"value,omitempty"`
	// NextLink - READ-ONLY; When there is too much alert data for one page, use this URI to fetch the next page.
	NextLink *string `json:"nextLink,omitempty"`
}

// IoTSecuritySolutionAnalyticsModelProperties security analytics properties of your IoT Security solution
type IoTSecuritySolutionAnalyticsModelProperties struct {
	// Metrics - READ-ONLY; Security analytics of your IoT Security solution.
	Metrics *IoTSeverityMetrics `json:"metrics,omitempty"`
	// UnhealthyDeviceCount - READ-ONLY; Number of unhealthy devices within your IoT Security solution.
	UnhealthyDeviceCount *int32 `json:"unhealthyDeviceCount,omitempty"`
	// DevicesMetrics - READ-ONLY; List of device metrics by the aggregation date.
	DevicesMetrics *[]IoTSecuritySolutionAnalyticsModelPropertiesDevicesMetricsItem `json:"devicesMetrics,omitempty"`
	// TopAlertedDevices - List of the 3 devices with the most alerts.
	TopAlertedDevices *[]IoTSecurityAlertedDevice `json:"topAlertedDevices,omitempty"`
	// MostPrevalentDeviceAlerts - List of the 3 most prevalent device alerts.
	MostPrevalentDeviceAlerts *[]IoTSecurityDeviceAlert `json:"mostPrevalentDeviceAlerts,omitempty"`
	// MostPrevalentDeviceRecommendations - List of the 3 most prevalent device recommendations.
	MostPrevalentDeviceRecommendations *[]IoTSecurityDeviceRecommendation `json:"mostPrevalentDeviceRecommendations,omitempty"`
}

// IoTSecuritySolutionAnalyticsModelPropertiesDevicesMetricsItem ...
type IoTSecuritySolutionAnalyticsModelPropertiesDevicesMetricsItem struct {
	// Date - Aggregation of IoT Security solution device alert metrics by date.
	Date *date.Time `json:"date,omitempty"`
	// DevicesMetrics - Device alert count by severity.
	DevicesMetrics *IoTSeverityMetrics `json:"devicesMetrics,omitempty"`
}

// IoTSecuritySolutionModel ioT Security solution configuration and resource information.
type IoTSecuritySolutionModel struct {
	autorest.Response `json:"-"`
	// ID - READ-ONLY; Resource Id
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type
	Type *string `json:"type,omitempty"`
	// Tags - Resource tags
	Tags map[string]*string `json:"tags"`
	// Location - The resource location.
	Location *string `json:"location,omitempty"`
	// IoTSecuritySolutionProperties - Security Solution data
	*IoTSecuritySolutionProperties `json:"properties,omitempty"`
}

// MarshalJSON is the custom marshaler for IoTSecuritySolutionModel.
func (itssm IoTSecuritySolutionModel) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if itssm.Tags != nil {
		objectMap["tags"] = itssm.Tags
	}
	if itssm.Location != nil {
		objectMap["location"] = itssm.Location
	}
	if itssm.IoTSecuritySolutionProperties != nil {
		objectMap["properties"] = itssm.IoTSecuritySolutionProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for IoTSecuritySolutionModel struct.
func (itssm *IoTSecuritySolutionModel) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				itssm.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				itssm.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				itssm.Type = &typeVar
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				itssm.Tags = tags
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				itssm.Location = &location
			}
		case "properties":
			if v != nil {
				var ioTSecuritySolutionProperties IoTSecuritySolutionProperties
				err = json.Unmarshal(*v, &ioTSecuritySolutionProperties)
				if err != nil {
					return err
				}
				itssm.IoTSecuritySolutionProperties = &ioTSecuritySolutionProperties
			}
		}
	}

	return nil
}

// IoTSecuritySolutionProperties security Solution setting data
type IoTSecuritySolutionProperties struct {
	// Workspace - Workspace resource ID
	Workspace *string `json:"workspace,omitempty"`
	// DisplayName - Resource display name.
	DisplayName *string `json:"displayName,omitempty"`
	// Status - Status of the IoT Security solution. Possible values include: 'SolutionStatusEnabled', 'SolutionStatusDisabled'
	Status SolutionStatus `json:"status,omitempty"`
	// Export - List of additional options for exporting to workspace data.
	Export *[]ExportData `json:"export,omitempty"`
	// DisabledDataSources - Disabled data sources. Disabling these data sources compromises the system.
	DisabledDataSources *[]DataSource `json:"disabledDataSources,omitempty"`
	// IotHubs - IoT Hub resource IDs
	IotHubs              *[]string                       `json:"iotHubs,omitempty"`
	UserDefinedResources *UserDefinedResourcesProperties `json:"userDefinedResources,omitempty"`
	// AutoDiscoveredResources - READ-ONLY; List of resources that were automatically discovered as relevant to the security solution.
	AutoDiscoveredResources      *[]string                                `json:"autoDiscoveredResources,omitempty"`
	RecommendationsConfiguration *[]RecommendationConfigurationProperties `json:"recommendationsConfiguration,omitempty"`
	// UnmaskedIPLoggingStatus - Unmasked IP address logging status. Possible values include: 'UnmaskedIPLoggingStatusDisabled', 'UnmaskedIPLoggingStatusEnabled'
	UnmaskedIPLoggingStatus UnmaskedIPLoggingStatus `json:"unmaskedIpLoggingStatus,omitempty"`
}

// IoTSecuritySolutionsList list of IoT Security solutions.
type IoTSecuritySolutionsList struct {
	autorest.Response `json:"-"`
	// Value - List of IoT Security solutions
	Value *[]IoTSecuritySolutionModel `json:"value,omitempty"`
	// NextLink - READ-ONLY; The URI to fetch the next page.
	NextLink *string `json:"nextLink,omitempty"`
}

// IoTSecuritySolutionsListIterator provides access to a complete listing of IoTSecuritySolutionModel
// values.
type IoTSecuritySolutionsListIterator struct {
	i    int
	page IoTSecuritySolutionsListPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *IoTSecuritySolutionsListIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/IoTSecuritySolutionsListIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *IoTSecuritySolutionsListIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter IoTSecuritySolutionsListIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter IoTSecuritySolutionsListIterator) Response() IoTSecuritySolutionsList {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter IoTSecuritySolutionsListIterator) Value() IoTSecuritySolutionModel {
	if !iter.page.NotDone() {
		return IoTSecuritySolutionModel{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the IoTSecuritySolutionsListIterator type.
func NewIoTSecuritySolutionsListIterator(page IoTSecuritySolutionsListPage) IoTSecuritySolutionsListIterator {
	return IoTSecuritySolutionsListIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (itssl IoTSecuritySolutionsList) IsEmpty() bool {
	return itssl.Value == nil || len(*itssl.Value) == 0
}

// ioTSecuritySolutionsListPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (itssl IoTSecuritySolutionsList) ioTSecuritySolutionsListPreparer(ctx context.Context) (*http.Request, error) {
	if itssl.NextLink == nil || len(to.String(itssl.NextLink)) < 1 {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(itssl.NextLink)))
}

// IoTSecuritySolutionsListPage contains a page of IoTSecuritySolutionModel values.
type IoTSecuritySolutionsListPage struct {
	fn    func(context.Context, IoTSecuritySolutionsList) (IoTSecuritySolutionsList, error)
	itssl IoTSecuritySolutionsList
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *IoTSecuritySolutionsListPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/IoTSecuritySolutionsListPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	next, err := page.fn(ctx, page.itssl)
	if err != nil {
		return err
	}
	page.itssl = next
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *IoTSecuritySolutionsListPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page IoTSecuritySolutionsListPage) NotDone() bool {
	return !page.itssl.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page IoTSecuritySolutionsListPage) Response() IoTSecuritySolutionsList {
	return page.itssl
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page IoTSecuritySolutionsListPage) Values() []IoTSecuritySolutionModel {
	if page.itssl.IsEmpty() {
		return nil
	}
	return *page.itssl.Value
}

// Creates a new instance of the IoTSecuritySolutionsListPage type.
func NewIoTSecuritySolutionsListPage(getNextPage func(context.Context, IoTSecuritySolutionsList) (IoTSecuritySolutionsList, error)) IoTSecuritySolutionsListPage {
	return IoTSecuritySolutionsListPage{fn: getNextPage}
}

// IoTSeverityMetrics ioT Security solution analytics severity metrics.
type IoTSeverityMetrics struct {
	// High - Count of high severity alerts/recommendations.
	High *int32 `json:"high,omitempty"`
	// Medium - Count of medium severity alerts/recommendations.
	Medium *int32 `json:"medium,omitempty"`
	// Low - Count of low severity alerts/recommendations.
	Low *int32 `json:"low,omitempty"`
}

// JitNetworkAccessPoliciesList ...
type JitNetworkAccessPoliciesList struct {
	autorest.Response `json:"-"`
	Value             *[]JitNetworkAccessPolicy `json:"value,omitempty"`
	// NextLink - READ-ONLY; The URI to fetch the next page.
	NextLink *string `json:"nextLink,omitempty"`
}

// JitNetworkAccessPoliciesListIterator provides access to a complete listing of JitNetworkAccessPolicy
// values.
type JitNetworkAccessPoliciesListIterator struct {
	i    int
	page JitNetworkAccessPoliciesListPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *JitNetworkAccessPoliciesListIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/JitNetworkAccessPoliciesListIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *JitNetworkAccessPoliciesListIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter JitNetworkAccessPoliciesListIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter JitNetworkAccessPoliciesListIterator) Response() JitNetworkAccessPoliciesList {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter JitNetworkAccessPoliciesListIterator) Value() JitNetworkAccessPolicy {
	if !iter.page.NotDone() {
		return JitNetworkAccessPolicy{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the JitNetworkAccessPoliciesListIterator type.
func NewJitNetworkAccessPoliciesListIterator(page JitNetworkAccessPoliciesListPage) JitNetworkAccessPoliciesListIterator {
	return JitNetworkAccessPoliciesListIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (jnapl JitNetworkAccessPoliciesList) IsEmpty() bool {
	return jnapl.Value == nil || len(*jnapl.Value) == 0
}

// jitNetworkAccessPoliciesListPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (jnapl JitNetworkAccessPoliciesList) jitNetworkAccessPoliciesListPreparer(ctx context.Context) (*http.Request, error) {
	if jnapl.NextLink == nil || len(to.String(jnapl.NextLink)) < 1 {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(jnapl.NextLink)))
}

// JitNetworkAccessPoliciesListPage contains a page of JitNetworkAccessPolicy values.
type JitNetworkAccessPoliciesListPage struct {
	fn    func(context.Context, JitNetworkAccessPoliciesList) (JitNetworkAccessPoliciesList, error)
	jnapl JitNetworkAccessPoliciesList
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *JitNetworkAccessPoliciesListPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/JitNetworkAccessPoliciesListPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	next, err := page.fn(ctx, page.jnapl)
	if err != nil {
		return err
	}
	page.jnapl = next
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *JitNetworkAccessPoliciesListPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page JitNetworkAccessPoliciesListPage) NotDone() bool {
	return !page.jnapl.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page JitNetworkAccessPoliciesListPage) Response() JitNetworkAccessPoliciesList {
	return page.jnapl
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page JitNetworkAccessPoliciesListPage) Values() []JitNetworkAccessPolicy {
	if page.jnapl.IsEmpty() {
		return nil
	}
	return *page.jnapl.Value
}

// Creates a new instance of the JitNetworkAccessPoliciesListPage type.
func NewJitNetworkAccessPoliciesListPage(getNextPage func(context.Context, JitNetworkAccessPoliciesList) (JitNetworkAccessPoliciesList, error)) JitNetworkAccessPoliciesListPage {
	return JitNetworkAccessPoliciesListPage{fn: getNextPage}
}

// JitNetworkAccessPolicy ...
type JitNetworkAccessPolicy struct {
	autorest.Response `json:"-"`
	// ID - READ-ONLY; Resource Id
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type
	Type *string `json:"type,omitempty"`
	// Kind - Kind of the resource
	Kind *string `json:"kind,omitempty"`
	// Location - READ-ONLY; Location where the resource is stored
	Location                          *string `json:"location,omitempty"`
	*JitNetworkAccessPolicyProperties `json:"properties,omitempty"`
}

// MarshalJSON is the custom marshaler for JitNetworkAccessPolicy.
func (jnap JitNetworkAccessPolicy) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if jnap.Kind != nil {
		objectMap["kind"] = jnap.Kind
	}
	if jnap.JitNetworkAccessPolicyProperties != nil {
		objectMap["properties"] = jnap.JitNetworkAccessPolicyProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for JitNetworkAccessPolicy struct.
func (jnap *JitNetworkAccessPolicy) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				jnap.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				jnap.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				jnap.Type = &typeVar
			}
		case "kind":
			if v != nil {
				var kind string
				err = json.Unmarshal(*v, &kind)
				if err != nil {
					return err
				}
				jnap.Kind = &kind
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				jnap.Location = &location
			}
		case "properties":
			if v != nil {
				var jitNetworkAccessPolicyProperties JitNetworkAccessPolicyProperties
				err = json.Unmarshal(*v, &jitNetworkAccessPolicyProperties)
				if err != nil {
					return err
				}
				jnap.JitNetworkAccessPolicyProperties = &jitNetworkAccessPolicyProperties
			}
		}
	}

	return nil
}

// JitNetworkAccessPolicyInitiatePort ...
type JitNetworkAccessPolicyInitiatePort struct {
	Number *int32 `json:"number,omitempty"`
	// AllowedSourceAddressPrefix - Source of the allowed traffic. If omitted, the request will be for the source IP address of the initiate request.
	AllowedSourceAddressPrefix *string `json:"allowedSourceAddressPrefix,omitempty"`
	// EndTimeUtc - The time to close the request in UTC
	EndTimeUtc *date.Time `json:"endTimeUtc,omitempty"`
}

// JitNetworkAccessPolicyInitiateRequest ...
type JitNetworkAccessPolicyInitiateRequest struct {
	// VirtualMachines - A list of virtual machines & ports to open access for
	VirtualMachines *[]JitNetworkAccessPolicyInitiateVirtualMachine `json:"virtualMachines,omitempty"`
	// Justification - The justification for making the initiate request
	Justification *string `json:"justification,omitempty"`
}

// JitNetworkAccessPolicyInitiateVirtualMachine ...
type JitNetworkAccessPolicyInitiateVirtualMachine struct {
	// ID - Resource ID of the virtual machine that is linked to this policy
	ID *string `json:"id,omitempty"`
	// Ports - The ports to open for the resource with the `id`
	Ports *[]JitNetworkAccessPolicyInitiatePort `json:"ports,omitempty"`
}

// JitNetworkAccessPolicyProperties ...
type JitNetworkAccessPolicyProperties struct {
	// VirtualMachines - Configurations for Microsoft.Compute/virtualMachines resource type.
	VirtualMachines *[]JitNetworkAccessPolicyVirtualMachine `json:"virtualMachines,omitempty"`
	Requests        *[]JitNetworkAccessRequest              `json:"requests,omitempty"`
	// ProvisioningState - READ-ONLY; Gets the provisioning state of the Just-in-Time policy.
	ProvisioningState *string `json:"provisioningState,omitempty"`
}

// JitNetworkAccessPolicyVirtualMachine ...
type JitNetworkAccessPolicyVirtualMachine struct {
	// ID - Resource ID of the virtual machine that is linked to this policy
	ID *string `json:"id,omitempty"`
	// Ports - Port configurations for the virtual machine
	Ports *[]JitNetworkAccessPortRule `json:"ports,omitempty"`
	// PublicIPAddress - Public IP address of the Azure Firewall that is linked to this policy, if applicable
	PublicIPAddress *string `json:"publicIpAddress,omitempty"`
}

// JitNetworkAccessPortRule ...
type JitNetworkAccessPortRule struct {
	Number *int32 `json:"number,omitempty"`
	// Protocol - Possible values include: 'TCP', 'UDP', 'All'
	Protocol Protocol `json:"protocol,omitempty"`
	// AllowedSourceAddressPrefix - Mutually exclusive with the "allowedSourceAddressPrefixes" parameter. Should be an IP address or CIDR, for example "192.168.0.3" or "192.168.0.0/16".
	AllowedSourceAddressPrefix *string `json:"allowedSourceAddressPrefix,omitempty"`
	// AllowedSourceAddressPrefixes - Mutually exclusive with the "allowedSourceAddressPrefix" parameter.
	AllowedSourceAddressPrefixes *[]string `json:"allowedSourceAddressPrefixes,omitempty"`
	// MaxRequestAccessDuration - Maximum duration requests can be made for. In ISO 8601 duration format. Minimum 5 minutes, maximum 1 day
	MaxRequestAccessDuration *string `json:"maxRequestAccessDuration,omitempty"`
}

// JitNetworkAccessRequest ...
type JitNetworkAccessRequest struct {
	autorest.Response `json:"-"`
	VirtualMachines   *[]JitNetworkAccessRequestVirtualMachine `json:"virtualMachines,omitempty"`
	// StartTimeUtc - The start time of the request in UTC
	StartTimeUtc *date.Time `json:"startTimeUtc,omitempty"`
	// Requestor - The identity of the person who made the request
	Requestor *string `json:"requestor,omitempty"`
	// Justification - The justification for making the initiate request
	Justification *string `json:"justification,omitempty"`
}

// JitNetworkAccessRequestPort ...
type JitNetworkAccessRequestPort struct {
	Number *int32 `json:"number,omitempty"`
	// AllowedSourceAddressPrefix - Mutually exclusive with the "allowedSourceAddressPrefixes" parameter. Should be an IP address or CIDR, for example "192.168.0.3" or "192.168.0.0/16".
	AllowedSourceAddressPrefix *string `json:"allowedSourceAddressPrefix,omitempty"`
	// AllowedSourceAddressPrefixes - Mutually exclusive with the "allowedSourceAddressPrefix" parameter.
	AllowedSourceAddressPrefixes *[]string `json:"allowedSourceAddressPrefixes,omitempty"`
	// EndTimeUtc - The date & time at which the request ends in UTC
	EndTimeUtc *date.Time `json:"endTimeUtc,omitempty"`
	// Status - The status of the port. Possible values include: 'Revoked', 'Initiated'
	Status Status `json:"status,omitempty"`
	// StatusReason - A description of why the `status` has its value. Possible values include: 'Expired', 'UserRequested', 'NewerRequestInitiated'
	StatusReason StatusReason `json:"statusReason,omitempty"`
	// MappedPort - The port which is mapped to this port's `number` in the Azure Firewall, if applicable
	MappedPort *int32 `json:"mappedPort,omitempty"`
}

// JitNetworkAccessRequestVirtualMachine ...
type JitNetworkAccessRequestVirtualMachine struct {
	// ID - Resource ID of the virtual machine that is linked to this policy
	ID *string `json:"id,omitempty"`
	// Ports - The ports that were opened for the virtual machine
	Ports *[]JitNetworkAccessRequestPort `json:"ports,omitempty"`
}

// Kind describes an Azure resource with kind
type Kind struct {
	// Kind - Kind of the resource
	Kind *string `json:"kind,omitempty"`
}

// ListCustomAlertRule a List custom alert rule.
type ListCustomAlertRule struct {
	// ValueType - READ-ONLY; The value type of the items in the list. Possible values include: 'ValueTypeIPCidr', 'ValueTypeString'
	ValueType ValueType `json:"valueType,omitempty"`
	// DisplayName - READ-ONLY; The display name of the custom alert.
	DisplayName *string `json:"displayName,omitempty"`
	// Description - READ-ONLY; The description of the custom alert.
	Description *string `json:"description,omitempty"`
	// IsEnabled - Status of the custom alert.
	IsEnabled *bool `json:"isEnabled,omitempty"`
	// RuleType - The type of the custom alert rule.
	RuleType *string `json:"ruleType,omitempty"`
}

// Location describes an Azure resource with location
type Location struct {
	// Location - READ-ONLY; Location where the resource is stored
	Location *string `json:"location,omitempty"`
}

// OnPremiseResourceDetails details of the On Premise resource that was assessed
type OnPremiseResourceDetails struct {
	// WorkspaceID - Azure resource Id of the workspace the machine is attached to
	WorkspaceID *string `json:"workspaceId,omitempty"`
	// Vmuuid - The unique Id of the machine
	Vmuuid *string `json:"vmuuid,omitempty"`
	// SourceComputerID - The oms agent Id installed on the machine
	SourceComputerID *string `json:"sourceComputerId,omitempty"`
	// MachineName - The name of the machine
	MachineName *string `json:"machineName,omitempty"`
	// Source - Possible values include: 'SourceResourceDetails', 'SourceOnPremise', 'SourceAzure'
	Source Source `json:"source,omitempty"`
}

// MarshalJSON is the custom marshaler for OnPremiseResourceDetails.
func (oprd OnPremiseResourceDetails) MarshalJSON() ([]byte, error) {
	oprd.Source = SourceOnPremise
	objectMap := make(map[string]interface{})
	if oprd.WorkspaceID != nil {
		objectMap["workspaceId"] = oprd.WorkspaceID
	}
	if oprd.Vmuuid != nil {
		objectMap["vmuuid"] = oprd.Vmuuid
	}
	if oprd.SourceComputerID != nil {
		objectMap["sourceComputerId"] = oprd.SourceComputerID
	}
	if oprd.MachineName != nil {
		objectMap["machineName"] = oprd.MachineName
	}
	if oprd.Source != "" {
		objectMap["source"] = oprd.Source
	}
	return json.Marshal(objectMap)
}

// AsOnPremiseResourceDetails is the BasicResourceDetails implementation for OnPremiseResourceDetails.
func (oprd OnPremiseResourceDetails) AsOnPremiseResourceDetails() (*OnPremiseResourceDetails, bool) {
	return &oprd, true
}

// AsAzureResourceDetails is the BasicResourceDetails implementation for OnPremiseResourceDetails.
func (oprd OnPremiseResourceDetails) AsAzureResourceDetails() (*AzureResourceDetails, bool) {
	return nil, false
}

// AsResourceDetails is the BasicResourceDetails implementation for OnPremiseResourceDetails.
func (oprd OnPremiseResourceDetails) AsResourceDetails() (*ResourceDetails, bool) {
	return nil, false
}

// AsBasicResourceDetails is the BasicResourceDetails implementation for OnPremiseResourceDetails.
func (oprd OnPremiseResourceDetails) AsBasicResourceDetails() (BasicResourceDetails, bool) {
	return &oprd, true
}

// Operation possible operation in the REST API of Microsoft.Security
type Operation struct {
	// Name - READ-ONLY; Name of the operation
	Name *string `json:"name,omitempty"`
	// Origin - READ-ONLY; Where the operation is originated
	Origin  *string           `json:"origin,omitempty"`
	Display *OperationDisplay `json:"display,omitempty"`
}

// OperationDisplay security operation display
type OperationDisplay struct {
	// Provider - READ-ONLY; The resource provider for the operation.
	Provider *string `json:"provider,omitempty"`
	// Resource - READ-ONLY; The display name of the resource the operation applies to.
	Resource *string `json:"resource,omitempty"`
	// Operation - READ-ONLY; The display name of the security operation.
	Operation *string `json:"operation,omitempty"`
	// Description - READ-ONLY; The description of the operation.
	Description *string `json:"description,omitempty"`
}

// OperationList list of possible operations for Microsoft.Security resource provider
type OperationList struct {
	autorest.Response `json:"-"`
	// Value - List of Security operations
	Value *[]Operation `json:"value,omitempty"`
	// NextLink - READ-ONLY; The URI to fetch the next page.
	NextLink *string `json:"nextLink,omitempty"`
}

// OperationListIterator provides access to a complete listing of Operation values.
type OperationListIterator struct {
	i    int
	page OperationListPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *OperationListIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/OperationListIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *OperationListIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter OperationListIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter OperationListIterator) Response() OperationList {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter OperationListIterator) Value() Operation {
	if !iter.page.NotDone() {
		return Operation{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the OperationListIterator type.
func NewOperationListIterator(page OperationListPage) OperationListIterator {
	return OperationListIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (ol OperationList) IsEmpty() bool {
	return ol.Value == nil || len(*ol.Value) == 0
}

// operationListPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (ol OperationList) operationListPreparer(ctx context.Context) (*http.Request, error) {
	if ol.NextLink == nil || len(to.String(ol.NextLink)) < 1 {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(ol.NextLink)))
}

// OperationListPage contains a page of Operation values.
type OperationListPage struct {
	fn func(context.Context, OperationList) (OperationList, error)
	ol OperationList
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *OperationListPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/OperationListPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	next, err := page.fn(ctx, page.ol)
	if err != nil {
		return err
	}
	page.ol = next
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *OperationListPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page OperationListPage) NotDone() bool {
	return !page.ol.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page OperationListPage) Response() OperationList {
	return page.ol
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page OperationListPage) Values() []Operation {
	if page.ol.IsEmpty() {
		return nil
	}
	return *page.ol.Value
}

// Creates a new instance of the OperationListPage type.
func NewOperationListPage(getNextPage func(context.Context, OperationList) (OperationList, error)) OperationListPage {
	return OperationListPage{fn: getNextPage}
}

// PathRecommendation represents a path that is recommended to be allowed and its properties
type PathRecommendation struct {
	// Path - The full path to whitelist
	Path *string `json:"path,omitempty"`
	// Action - Possible values include: 'Recommended', 'Add', 'Remove'
	Action Action `json:"action,omitempty"`
	// Type - Possible values include: 'File', 'FileHash', 'PublisherSignature', 'ProductSignature', 'BinarySignature', 'VersionAndAboveSignature'
	Type          Type           `json:"type,omitempty"`
	PublisherInfo *PublisherInfo `json:"publisherInfo,omitempty"`
	// Common - Whether the path is commonly run on the machine
	Common    *bool                 `json:"common,omitempty"`
	UserSids  *[]string             `json:"userSids,omitempty"`
	Usernames *[]UserRecommendation `json:"usernames,omitempty"`
	// FileType - Possible values include: 'FileTypeExe', 'FileTypeDll', 'FileTypeMsi', 'FileTypeScript', 'FileTypeExecutable', 'FileTypeUnknown'
	FileType FileType `json:"fileType,omitempty"`
	// ConfigurationStatus - Possible values include: 'ConfigurationStatus1Configured', 'ConfigurationStatus1NotConfigured', 'ConfigurationStatus1InProgress', 'ConfigurationStatus1Failed', 'ConfigurationStatus1NoStatus'
	ConfigurationStatus ConfigurationStatus1 `json:"configurationStatus,omitempty"`
}

// Pricing azure Security Center is provided in two pricing tiers: free and standard, with the standard
// tier available with a trial period. The standard tier offers advanced security capabilities, while the
// free tier offers basic security features.
type Pricing struct {
	autorest.Response `json:"-"`
	// PricingProperties - Pricing data
	*PricingProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Resource Id
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for Pricing.
func (p Pricing) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if p.PricingProperties != nil {
		objectMap["properties"] = p.PricingProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for Pricing struct.
func (p *Pricing) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var pricingProperties PricingProperties
				err = json.Unmarshal(*v, &pricingProperties)
				if err != nil {
					return err
				}
				p.PricingProperties = &pricingProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				p.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				p.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				p.Type = &typeVar
			}
		}
	}

	return nil
}

// PricingList list of pricing configurations response.
type PricingList struct {
	autorest.Response `json:"-"`
	// Value - List of pricing configurations
	Value *[]Pricing `json:"value,omitempty"`
}

// PricingProperties pricing properties for the relevant scope
type PricingProperties struct {
	// PricingTier - The pricing tier value. Azure Security Center is provided in two pricing tiers: free and standard, with the standard tier available with a trial period. The standard tier offers advanced security capabilities, while the free tier offers basic security features. Possible values include: 'Free', 'Standard'
	PricingTier PricingTier `json:"pricingTier,omitempty"`
	// FreeTrialRemainingTime - READ-ONLY; The duration left for the subscriptions free trial period - in ISO 8601 format (e.g. P3Y6M4DT12H30M5S).
	FreeTrialRemainingTime *string `json:"freeTrialRemainingTime,omitempty"`
}

// ProtectionMode the protection mode of the collection/file types. Exe/Msi/Script are used for Windows,
// Executable is used for Linux.
type ProtectionMode struct {
	// Exe - Possible values include: 'ExeAudit', 'ExeEnforce', 'ExeNone'
	Exe Exe `json:"exe,omitempty"`
	// Msi - Possible values include: 'MsiAudit', 'MsiEnforce', 'MsiNone'
	Msi Msi `json:"msi,omitempty"`
	// Script - Possible values include: 'ScriptAudit', 'ScriptEnforce', 'ScriptNone'
	Script Script `json:"script,omitempty"`
	// Executable - Possible values include: 'ExecutableAudit', 'ExecutableEnforce', 'ExecutableNone'
	Executable Executable `json:"executable,omitempty"`
}

// PublisherInfo represents the publisher information of a process/rule
type PublisherInfo struct {
	// PublisherName - The Subject field of the x.509 certificate used to sign the code, using the following fields -  O = Organization, L = Locality, S = State or Province, and C = Country
	PublisherName *string `json:"publisherName,omitempty"`
	// ProductName - The product name taken from the file's version resource
	ProductName *string `json:"productName,omitempty"`
	// BinaryName - The "OriginalName" field taken from the file's version resource
	BinaryName *string `json:"binaryName,omitempty"`
	// Version - The binary file version taken from the file's version resource
	Version *string `json:"version,omitempty"`
}

// RecommendationConfigurationProperties the type of IoT Security recommendation.
type RecommendationConfigurationProperties struct {
	// RecommendationType - The type of IoT Security recommendation. Possible values include: 'IoTACRAuthentication', 'IoTAgentSendsUnutilizedMessages', 'IoTBaseline', 'IoTEdgeHubMemOptimize', 'IoTEdgeLoggingOptions', 'IoTInconsistentModuleSettings', 'IoTInstallAgent', 'IoTIPFilterDenyAll', 'IoTIPFilterPermissiveRule', 'IoTOpenPorts', 'IoTPermissiveFirewallPolicy', 'IoTPermissiveInputFirewallRules', 'IoTPermissiveOutputFirewallRules', 'IoTPrivilegedDockerOptions', 'IoTSharedCredentials', 'IoTVulnerableTLSCipherSuite'
	RecommendationType RecommendationType `json:"recommendationType,omitempty"`
	// Name - READ-ONLY
	Name *string `json:"name,omitempty"`
	// Status - Recommendation status. When the recommendation status is disabled recommendations are not generated. Possible values include: 'Disabled', 'Enabled'
	Status RecommendationConfigStatus `json:"status,omitempty"`
}

// RegulatoryComplianceAssessment regulatory compliance assessment details and state
type RegulatoryComplianceAssessment struct {
	autorest.Response `json:"-"`
	// RegulatoryComplianceAssessmentProperties - Regulatory compliance assessment data
	*RegulatoryComplianceAssessmentProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Resource Id
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for RegulatoryComplianceAssessment.
func (rca RegulatoryComplianceAssessment) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if rca.RegulatoryComplianceAssessmentProperties != nil {
		objectMap["properties"] = rca.RegulatoryComplianceAssessmentProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for RegulatoryComplianceAssessment struct.
func (rca *RegulatoryComplianceAssessment) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var regulatoryComplianceAssessmentProperties RegulatoryComplianceAssessmentProperties
				err = json.Unmarshal(*v, &regulatoryComplianceAssessmentProperties)
				if err != nil {
					return err
				}
				rca.RegulatoryComplianceAssessmentProperties = &regulatoryComplianceAssessmentProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				rca.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				rca.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				rca.Type = &typeVar
			}
		}
	}

	return nil
}

// RegulatoryComplianceAssessmentList list of regulatory compliance assessment response
type RegulatoryComplianceAssessmentList struct {
	autorest.Response `json:"-"`
	Value             *[]RegulatoryComplianceAssessment `json:"value,omitempty"`
	// NextLink - READ-ONLY; The URI to fetch the next page.
	NextLink *string `json:"nextLink,omitempty"`
}

// RegulatoryComplianceAssessmentListIterator provides access to a complete listing of
// RegulatoryComplianceAssessment values.
type RegulatoryComplianceAssessmentListIterator struct {
	i    int
	page RegulatoryComplianceAssessmentListPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *RegulatoryComplianceAssessmentListIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/RegulatoryComplianceAssessmentListIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *RegulatoryComplianceAssessmentListIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter RegulatoryComplianceAssessmentListIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter RegulatoryComplianceAssessmentListIterator) Response() RegulatoryComplianceAssessmentList {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter RegulatoryComplianceAssessmentListIterator) Value() RegulatoryComplianceAssessment {
	if !iter.page.NotDone() {
		return RegulatoryComplianceAssessment{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the RegulatoryComplianceAssessmentListIterator type.
func NewRegulatoryComplianceAssessmentListIterator(page RegulatoryComplianceAssessmentListPage) RegulatoryComplianceAssessmentListIterator {
	return RegulatoryComplianceAssessmentListIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (rcal RegulatoryComplianceAssessmentList) IsEmpty() bool {
	return rcal.Value == nil || len(*rcal.Value) == 0
}

// regulatoryComplianceAssessmentListPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (rcal RegulatoryComplianceAssessmentList) regulatoryComplianceAssessmentListPreparer(ctx context.Context) (*http.Request, error) {
	if rcal.NextLink == nil || len(to.String(rcal.NextLink)) < 1 {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(rcal.NextLink)))
}

// RegulatoryComplianceAssessmentListPage contains a page of RegulatoryComplianceAssessment values.
type RegulatoryComplianceAssessmentListPage struct {
	fn   func(context.Context, RegulatoryComplianceAssessmentList) (RegulatoryComplianceAssessmentList, error)
	rcal RegulatoryComplianceAssessmentList
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *RegulatoryComplianceAssessmentListPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/RegulatoryComplianceAssessmentListPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	next, err := page.fn(ctx, page.rcal)
	if err != nil {
		return err
	}
	page.rcal = next
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *RegulatoryComplianceAssessmentListPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page RegulatoryComplianceAssessmentListPage) NotDone() bool {
	return !page.rcal.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page RegulatoryComplianceAssessmentListPage) Response() RegulatoryComplianceAssessmentList {
	return page.rcal
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page RegulatoryComplianceAssessmentListPage) Values() []RegulatoryComplianceAssessment {
	if page.rcal.IsEmpty() {
		return nil
	}
	return *page.rcal.Value
}

// Creates a new instance of the RegulatoryComplianceAssessmentListPage type.
func NewRegulatoryComplianceAssessmentListPage(getNextPage func(context.Context, RegulatoryComplianceAssessmentList) (RegulatoryComplianceAssessmentList, error)) RegulatoryComplianceAssessmentListPage {
	return RegulatoryComplianceAssessmentListPage{fn: getNextPage}
}

// RegulatoryComplianceAssessmentProperties regulatory compliance assessment data
type RegulatoryComplianceAssessmentProperties struct {
	// Description - READ-ONLY; The description of the regulatory compliance assessment
	Description *string `json:"description,omitempty"`
	// AssessmentType - READ-ONLY; The expected type of assessment contained in the AssessmentDetailsLink
	AssessmentType *string `json:"assessmentType,omitempty"`
	// AssessmentDetailsLink - READ-ONLY; Link to more detailed assessment results data. The response type will be according to the assessmentType field
	AssessmentDetailsLink *string `json:"assessmentDetailsLink,omitempty"`
	// State - Aggregative state based on the assessment's scanned resources states. Possible values include: 'StatePassed', 'StateFailed', 'StateSkipped', 'StateUnsupported'
	State State `json:"state,omitempty"`
	// PassedResources - READ-ONLY; The given assessment's related resources count with passed state.
	PassedResources *int32 `json:"passedResources,omitempty"`
	// FailedResources - READ-ONLY; The given assessment's related resources count with failed state.
	FailedResources *int32 `json:"failedResources,omitempty"`
	// SkippedResources - READ-ONLY; The given assessment's related resources count with skipped state.
	SkippedResources *int32 `json:"skippedResources,omitempty"`
	// UnsupportedResources - READ-ONLY; The given assessment's related resources count with unsupported state.
	UnsupportedResources *int32 `json:"unsupportedResources,omitempty"`
}

// RegulatoryComplianceControl regulatory compliance control details and state
type RegulatoryComplianceControl struct {
	autorest.Response `json:"-"`
	// RegulatoryComplianceControlProperties - Regulatory compliance control data
	*RegulatoryComplianceControlProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Resource Id
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for RegulatoryComplianceControl.
func (rcc RegulatoryComplianceControl) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if rcc.RegulatoryComplianceControlProperties != nil {
		objectMap["properties"] = rcc.RegulatoryComplianceControlProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for RegulatoryComplianceControl struct.
func (rcc *RegulatoryComplianceControl) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var regulatoryComplianceControlProperties RegulatoryComplianceControlProperties
				err = json.Unmarshal(*v, &regulatoryComplianceControlProperties)
				if err != nil {
					return err
				}
				rcc.RegulatoryComplianceControlProperties = &regulatoryComplianceControlProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				rcc.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				rcc.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				rcc.Type = &typeVar
			}
		}
	}

	return nil
}

// RegulatoryComplianceControlList list of regulatory compliance controls response
type RegulatoryComplianceControlList struct {
	autorest.Response `json:"-"`
	// Value - List of regulatory compliance controls
	Value *[]RegulatoryComplianceControl `json:"value,omitempty"`
	// NextLink - READ-ONLY; The URI to fetch the next page.
	NextLink *string `json:"nextLink,omitempty"`
}

// RegulatoryComplianceControlListIterator provides access to a complete listing of
// RegulatoryComplianceControl values.
type RegulatoryComplianceControlListIterator struct {
	i    int
	page RegulatoryComplianceControlListPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *RegulatoryComplianceControlListIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/RegulatoryComplianceControlListIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *RegulatoryComplianceControlListIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter RegulatoryComplianceControlListIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter RegulatoryComplianceControlListIterator) Response() RegulatoryComplianceControlList {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter RegulatoryComplianceControlListIterator) Value() RegulatoryComplianceControl {
	if !iter.page.NotDone() {
		return RegulatoryComplianceControl{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the RegulatoryComplianceControlListIterator type.
func NewRegulatoryComplianceControlListIterator(page RegulatoryComplianceControlListPage) RegulatoryComplianceControlListIterator {
	return RegulatoryComplianceControlListIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (rccl RegulatoryComplianceControlList) IsEmpty() bool {
	return rccl.Value == nil || len(*rccl.Value) == 0
}

// regulatoryComplianceControlListPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (rccl RegulatoryComplianceControlList) regulatoryComplianceControlListPreparer(ctx context.Context) (*http.Request, error) {
	if rccl.NextLink == nil || len(to.String(rccl.NextLink)) < 1 {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(rccl.NextLink)))
}

// RegulatoryComplianceControlListPage contains a page of RegulatoryComplianceControl values.
type RegulatoryComplianceControlListPage struct {
	fn   func(context.Context, RegulatoryComplianceControlList) (RegulatoryComplianceControlList, error)
	rccl RegulatoryComplianceControlList
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *RegulatoryComplianceControlListPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/RegulatoryComplianceControlListPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	next, err := page.fn(ctx, page.rccl)
	if err != nil {
		return err
	}
	page.rccl = next
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *RegulatoryComplianceControlListPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page RegulatoryComplianceControlListPage) NotDone() bool {
	return !page.rccl.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page RegulatoryComplianceControlListPage) Response() RegulatoryComplianceControlList {
	return page.rccl
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page RegulatoryComplianceControlListPage) Values() []RegulatoryComplianceControl {
	if page.rccl.IsEmpty() {
		return nil
	}
	return *page.rccl.Value
}

// Creates a new instance of the RegulatoryComplianceControlListPage type.
func NewRegulatoryComplianceControlListPage(getNextPage func(context.Context, RegulatoryComplianceControlList) (RegulatoryComplianceControlList, error)) RegulatoryComplianceControlListPage {
	return RegulatoryComplianceControlListPage{fn: getNextPage}
}

// RegulatoryComplianceControlProperties regulatory compliance control data
type RegulatoryComplianceControlProperties struct {
	// Description - READ-ONLY; The description of the regulatory compliance control
	Description *string `json:"description,omitempty"`
	// State - Aggregative state based on the control's supported assessments states. Possible values include: 'StatePassed', 'StateFailed', 'StateSkipped', 'StateUnsupported'
	State State `json:"state,omitempty"`
	// PassedAssessments - READ-ONLY; The number of supported regulatory compliance assessments of the given control with a passed state
	PassedAssessments *int32 `json:"passedAssessments,omitempty"`
	// FailedAssessments - READ-ONLY; The number of supported regulatory compliance assessments of the given control with a failed state
	FailedAssessments *int32 `json:"failedAssessments,omitempty"`
	// SkippedAssessments - READ-ONLY; The number of supported regulatory compliance assessments of the given control with a skipped state
	SkippedAssessments *int32 `json:"skippedAssessments,omitempty"`
}

// RegulatoryComplianceStandard regulatory compliance standard details and state
type RegulatoryComplianceStandard struct {
	autorest.Response `json:"-"`
	// RegulatoryComplianceStandardProperties - Regulatory compliance standard data
	*RegulatoryComplianceStandardProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Resource Id
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for RegulatoryComplianceStandard.
func (rcs RegulatoryComplianceStandard) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if rcs.RegulatoryComplianceStandardProperties != nil {
		objectMap["properties"] = rcs.RegulatoryComplianceStandardProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for RegulatoryComplianceStandard struct.
func (rcs *RegulatoryComplianceStandard) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var regulatoryComplianceStandardProperties RegulatoryComplianceStandardProperties
				err = json.Unmarshal(*v, &regulatoryComplianceStandardProperties)
				if err != nil {
					return err
				}
				rcs.RegulatoryComplianceStandardProperties = &regulatoryComplianceStandardProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				rcs.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				rcs.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				rcs.Type = &typeVar
			}
		}
	}

	return nil
}

// RegulatoryComplianceStandardList list of regulatory compliance standards response
type RegulatoryComplianceStandardList struct {
	autorest.Response `json:"-"`
	Value             *[]RegulatoryComplianceStandard `json:"value,omitempty"`
	// NextLink - READ-ONLY; The URI to fetch the next page.
	NextLink *string `json:"nextLink,omitempty"`
}

// RegulatoryComplianceStandardListIterator provides access to a complete listing of
// RegulatoryComplianceStandard values.
type RegulatoryComplianceStandardListIterator struct {
	i    int
	page RegulatoryComplianceStandardListPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *RegulatoryComplianceStandardListIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/RegulatoryComplianceStandardListIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *RegulatoryComplianceStandardListIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter RegulatoryComplianceStandardListIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter RegulatoryComplianceStandardListIterator) Response() RegulatoryComplianceStandardList {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter RegulatoryComplianceStandardListIterator) Value() RegulatoryComplianceStandard {
	if !iter.page.NotDone() {
		return RegulatoryComplianceStandard{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the RegulatoryComplianceStandardListIterator type.
func NewRegulatoryComplianceStandardListIterator(page RegulatoryComplianceStandardListPage) RegulatoryComplianceStandardListIterator {
	return RegulatoryComplianceStandardListIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (rcsl RegulatoryComplianceStandardList) IsEmpty() bool {
	return rcsl.Value == nil || len(*rcsl.Value) == 0
}

// regulatoryComplianceStandardListPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (rcsl RegulatoryComplianceStandardList) regulatoryComplianceStandardListPreparer(ctx context.Context) (*http.Request, error) {
	if rcsl.NextLink == nil || len(to.String(rcsl.NextLink)) < 1 {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(rcsl.NextLink)))
}

// RegulatoryComplianceStandardListPage contains a page of RegulatoryComplianceStandard values.
type RegulatoryComplianceStandardListPage struct {
	fn   func(context.Context, RegulatoryComplianceStandardList) (RegulatoryComplianceStandardList, error)
	rcsl RegulatoryComplianceStandardList
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *RegulatoryComplianceStandardListPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/RegulatoryComplianceStandardListPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	next, err := page.fn(ctx, page.rcsl)
	if err != nil {
		return err
	}
	page.rcsl = next
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *RegulatoryComplianceStandardListPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page RegulatoryComplianceStandardListPage) NotDone() bool {
	return !page.rcsl.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page RegulatoryComplianceStandardListPage) Response() RegulatoryComplianceStandardList {
	return page.rcsl
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page RegulatoryComplianceStandardListPage) Values() []RegulatoryComplianceStandard {
	if page.rcsl.IsEmpty() {
		return nil
	}
	return *page.rcsl.Value
}

// Creates a new instance of the RegulatoryComplianceStandardListPage type.
func NewRegulatoryComplianceStandardListPage(getNextPage func(context.Context, RegulatoryComplianceStandardList) (RegulatoryComplianceStandardList, error)) RegulatoryComplianceStandardListPage {
	return RegulatoryComplianceStandardListPage{fn: getNextPage}
}

// RegulatoryComplianceStandardProperties regulatory compliance standard data
type RegulatoryComplianceStandardProperties struct {
	// State - Aggregative state based on the standard's supported controls states. Possible values include: 'StatePassed', 'StateFailed', 'StateSkipped', 'StateUnsupported'
	State State `json:"state,omitempty"`
	// PassedControls - READ-ONLY; The number of supported regulatory compliance controls of the given standard with a passed state
	PassedControls *int32 `json:"passedControls,omitempty"`
	// FailedControls - READ-ONLY; The number of supported regulatory compliance controls of the given standard with a failed state
	FailedControls *int32 `json:"failedControls,omitempty"`
	// SkippedControls - READ-ONLY; The number of supported regulatory compliance controls of the given standard with a skipped state
	SkippedControls *int32 `json:"skippedControls,omitempty"`
	// UnsupportedControls - READ-ONLY; The number of regulatory compliance controls of the given standard which are unsupported by automated assessments
	UnsupportedControls *int32 `json:"unsupportedControls,omitempty"`
}

// Resource describes an Azure resource.
type Resource struct {
	// ID - READ-ONLY; Resource Id
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type
	Type *string `json:"type,omitempty"`
}

// BasicResourceDetails details of the resource that was assessed
type BasicResourceDetails interface {
	AsOnPremiseResourceDetails() (*OnPremiseResourceDetails, bool)
	AsAzureResourceDetails() (*AzureResourceDetails, bool)
	AsResourceDetails() (*ResourceDetails, bool)
}

// ResourceDetails details of the resource that was assessed
type ResourceDetails struct {
	// Source - Possible values include: 'SourceResourceDetails', 'SourceOnPremise', 'SourceAzure'
	Source Source `json:"source,omitempty"`
}

func unmarshalBasicResourceDetails(body []byte) (BasicResourceDetails, error) {
	var m map[string]interface{}
	err := json.Unmarshal(body, &m)
	if err != nil {
		return nil, err
	}

	switch m["source"] {
	case string(SourceOnPremise):
		var oprd OnPremiseResourceDetails
		err := json.Unmarshal(body, &oprd)
		return oprd, err
	case string(SourceAzure):
		var ard AzureResourceDetails
		err := json.Unmarshal(body, &ard)
		return ard, err
	default:
		var rd ResourceDetails
		err := json.Unmarshal(body, &rd)
		return rd, err
	}
}
func unmarshalBasicResourceDetailsArray(body []byte) ([]BasicResourceDetails, error) {
	var rawMessages []*json.RawMessage
	err := json.Unmarshal(body, &rawMessages)
	if err != nil {
		return nil, err
	}

	rdArray := make([]BasicResourceDetails, len(rawMessages))

	for index, rawMessage := range rawMessages {
		rd, err := unmarshalBasicResourceDetails(*rawMessage)
		if err != nil {
			return nil, err
		}
		rdArray[index] = rd
	}
	return rdArray, nil
}

// MarshalJSON is the custom marshaler for ResourceDetails.
func (rd ResourceDetails) MarshalJSON() ([]byte, error) {
	rd.Source = SourceResourceDetails
	objectMap := make(map[string]interface{})
	if rd.Source != "" {
		objectMap["source"] = rd.Source
	}
	return json.Marshal(objectMap)
}

// AsOnPremiseResourceDetails is the BasicResourceDetails implementation for ResourceDetails.
func (rd ResourceDetails) AsOnPremiseResourceDetails() (*OnPremiseResourceDetails, bool) {
	return nil, false
}

// AsAzureResourceDetails is the BasicResourceDetails implementation for ResourceDetails.
func (rd ResourceDetails) AsAzureResourceDetails() (*AzureResourceDetails, bool) {
	return nil, false
}

// AsResourceDetails is the BasicResourceDetails implementation for ResourceDetails.
func (rd ResourceDetails) AsResourceDetails() (*ResourceDetails, bool) {
	return &rd, true
}

// AsBasicResourceDetails is the BasicResourceDetails implementation for ResourceDetails.
func (rd ResourceDetails) AsBasicResourceDetails() (BasicResourceDetails, bool) {
	return &rd, true
}

// SensitivityLabel the sensitivity label.
type SensitivityLabel struct {
	// DisplayName - The name of the sensitivity label.
	DisplayName *string `json:"displayName,omitempty"`
	// Order - The order of the sensitivity label.
	Order *float64 `json:"order,omitempty"`
	// Enabled - Indicates whether the label is enabled or not.
	Enabled *bool `json:"enabled,omitempty"`
}

// ServerVulnerabilityAssessment describes the server vulnerability assessment details on a resource
type ServerVulnerabilityAssessment struct {
	autorest.Response                        `json:"-"`
	*ServerVulnerabilityAssessmentProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Resource Id
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for ServerVulnerabilityAssessment.
func (sva ServerVulnerabilityAssessment) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if sva.ServerVulnerabilityAssessmentProperties != nil {
		objectMap["properties"] = sva.ServerVulnerabilityAssessmentProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for ServerVulnerabilityAssessment struct.
func (sva *ServerVulnerabilityAssessment) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var serverVulnerabilityAssessmentProperties ServerVulnerabilityAssessmentProperties
				err = json.Unmarshal(*v, &serverVulnerabilityAssessmentProperties)
				if err != nil {
					return err
				}
				sva.ServerVulnerabilityAssessmentProperties = &serverVulnerabilityAssessmentProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				sva.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				sva.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				sva.Type = &typeVar
			}
		}
	}

	return nil
}

// ServerVulnerabilityAssessmentProperties describes ServerVulnerabilityAssessment properties.
type ServerVulnerabilityAssessmentProperties struct {
	// ProvisioningState - READ-ONLY; The provisioningState of the vulnerability assessment capability on the VM. Possible values include: 'ProvisioningStateSucceeded', 'ProvisioningStateFailed', 'ProvisioningStateCanceled', 'ProvisioningStateProvisioning', 'ProvisioningStateDeprovisioning'
	ProvisioningState ProvisioningState `json:"provisioningState,omitempty"`
}

// ServerVulnerabilityAssessmentsList list of server vulnerability assessments
type ServerVulnerabilityAssessmentsList struct {
	autorest.Response `json:"-"`
	Value             *[]ServerVulnerabilityAssessment `json:"value,omitempty"`
}

// ServerVulnerabilityProperties additional context fields for server vulnerability assessment
type ServerVulnerabilityProperties struct {
	// Type - READ-ONLY; Vulnerability Type. e.g: Vulnerability, Potential Vulnerability, Information Gathered
	Type *string `json:"type,omitempty"`
	// Cvss - READ-ONLY; Dictionary from cvss version to cvss details object
	Cvss map[string]*CVSS `json:"cvss"`
	// Patchable - READ-ONLY; Indicates whether a patch is available or not
	Patchable *bool `json:"patchable,omitempty"`
	// Cve - READ-ONLY; List of CVEs
	Cve *[]CVE `json:"cve,omitempty"`
	// Threat - READ-ONLY; Threat name
	Threat *string `json:"threat,omitempty"`
	// PublishedTime - READ-ONLY; Published time
	PublishedTime *date.Time `json:"publishedTime,omitempty"`
	// VendorReferences - READ-ONLY
	VendorReferences *[]VendorReference `json:"vendorReferences,omitempty"`
	// AssessedResourceType - Possible values include: 'AssessedResourceTypeAdditionalData', 'AssessedResourceTypeSQLServerVulnerability', 'AssessedResourceTypeContainerRegistryVulnerability', 'AssessedResourceTypeServerVulnerabilityAssessment'
	AssessedResourceType AssessedResourceType `json:"assessedResourceType,omitempty"`
}

// MarshalJSON is the custom marshaler for ServerVulnerabilityProperties.
func (svp ServerVulnerabilityProperties) MarshalJSON() ([]byte, error) {
	svp.AssessedResourceType = AssessedResourceTypeServerVulnerabilityAssessment
	objectMap := make(map[string]interface{})
	if svp.AssessedResourceType != "" {
		objectMap["assessedResourceType"] = svp.AssessedResourceType
	}
	return json.Marshal(objectMap)
}

// AsSQLServerVulnerabilityProperties is the BasicAdditionalData implementation for ServerVulnerabilityProperties.
func (svp ServerVulnerabilityProperties) AsSQLServerVulnerabilityProperties() (*SQLServerVulnerabilityProperties, bool) {
	return nil, false
}

// AsContainerRegistryVulnerabilityProperties is the BasicAdditionalData implementation for ServerVulnerabilityProperties.
func (svp ServerVulnerabilityProperties) AsContainerRegistryVulnerabilityProperties() (*ContainerRegistryVulnerabilityProperties, bool) {
	return nil, false
}

// AsServerVulnerabilityProperties is the BasicAdditionalData implementation for ServerVulnerabilityProperties.
func (svp ServerVulnerabilityProperties) AsServerVulnerabilityProperties() (*ServerVulnerabilityProperties, bool) {
	return &svp, true
}

// AsAdditionalData is the BasicAdditionalData implementation for ServerVulnerabilityProperties.
func (svp ServerVulnerabilityProperties) AsAdditionalData() (*AdditionalData, bool) {
	return nil, false
}

// AsBasicAdditionalData is the BasicAdditionalData implementation for ServerVulnerabilityProperties.
func (svp ServerVulnerabilityProperties) AsBasicAdditionalData() (BasicAdditionalData, bool) {
	return &svp, true
}

// Setting represents a security setting in Azure Security Center.
type Setting struct {
	autorest.Response `json:"-"`
	// Kind - the kind of the settings string (DataExportSetting). Possible values include: 'SettingKindDataExportSetting', 'SettingKindAlertSuppressionSetting'
	Kind SettingKind `json:"kind,omitempty"`
	// ID - READ-ONLY; Resource Id
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type
	Type *string `json:"type,omitempty"`
}

// SettingResource the kind of the security setting
type SettingResource struct {
	// Kind - the kind of the settings string (DataExportSetting). Possible values include: 'SettingKindDataExportSetting', 'SettingKindAlertSuppressionSetting'
	Kind SettingKind `json:"kind,omitempty"`
	// ID - READ-ONLY; Resource Id
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type
	Type *string `json:"type,omitempty"`
}

// SettingsList subscription settings list.
type SettingsList struct {
	autorest.Response `json:"-"`
	// Value - The settings list.
	Value *[]Setting `json:"value,omitempty"`
	// NextLink - READ-ONLY; The URI to fetch the next page.
	NextLink *string `json:"nextLink,omitempty"`
}

// SettingsListIterator provides access to a complete listing of Setting values.
type SettingsListIterator struct {
	i    int
	page SettingsListPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *SettingsListIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/SettingsListIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *SettingsListIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter SettingsListIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter SettingsListIterator) Response() SettingsList {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter SettingsListIterator) Value() Setting {
	if !iter.page.NotDone() {
		return Setting{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the SettingsListIterator type.
func NewSettingsListIterator(page SettingsListPage) SettingsListIterator {
	return SettingsListIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (sl SettingsList) IsEmpty() bool {
	return sl.Value == nil || len(*sl.Value) == 0
}

// settingsListPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (sl SettingsList) settingsListPreparer(ctx context.Context) (*http.Request, error) {
	if sl.NextLink == nil || len(to.String(sl.NextLink)) < 1 {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(sl.NextLink)))
}

// SettingsListPage contains a page of Setting values.
type SettingsListPage struct {
	fn func(context.Context, SettingsList) (SettingsList, error)
	sl SettingsList
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *SettingsListPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/SettingsListPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	next, err := page.fn(ctx, page.sl)
	if err != nil {
		return err
	}
	page.sl = next
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *SettingsListPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page SettingsListPage) NotDone() bool {
	return !page.sl.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page SettingsListPage) Response() SettingsList {
	return page.sl
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page SettingsListPage) Values() []Setting {
	if page.sl.IsEmpty() {
		return nil
	}
	return *page.sl.Value
}

// Creates a new instance of the SettingsListPage type.
func NewSettingsListPage(getNextPage func(context.Context, SettingsList) (SettingsList, error)) SettingsListPage {
	return SettingsListPage{fn: getNextPage}
}

// SQLServerVulnerabilityProperties details of the resource that was assessed
type SQLServerVulnerabilityProperties struct {
	// Type - READ-ONLY; The resource type the sub assessment refers to in its resource details
	Type *string `json:"type,omitempty"`
	// Query - READ-ONLY; The T-SQL query that runs on your SQL database to perform the particular check
	Query *string `json:"query,omitempty"`
	// AssessedResourceType - Possible values include: 'AssessedResourceTypeAdditionalData', 'AssessedResourceTypeSQLServerVulnerability', 'AssessedResourceTypeContainerRegistryVulnerability', 'AssessedResourceTypeServerVulnerabilityAssessment'
	AssessedResourceType AssessedResourceType `json:"assessedResourceType,omitempty"`
}

// MarshalJSON is the custom marshaler for SQLServerVulnerabilityProperties.
func (ssvp SQLServerVulnerabilityProperties) MarshalJSON() ([]byte, error) {
	ssvp.AssessedResourceType = AssessedResourceTypeSQLServerVulnerability
	objectMap := make(map[string]interface{})
	if ssvp.AssessedResourceType != "" {
		objectMap["assessedResourceType"] = ssvp.AssessedResourceType
	}
	return json.Marshal(objectMap)
}

// AsSQLServerVulnerabilityProperties is the BasicAdditionalData implementation for SQLServerVulnerabilityProperties.
func (ssvp SQLServerVulnerabilityProperties) AsSQLServerVulnerabilityProperties() (*SQLServerVulnerabilityProperties, bool) {
	return &ssvp, true
}

// AsContainerRegistryVulnerabilityProperties is the BasicAdditionalData implementation for SQLServerVulnerabilityProperties.
func (ssvp SQLServerVulnerabilityProperties) AsContainerRegistryVulnerabilityProperties() (*ContainerRegistryVulnerabilityProperties, bool) {
	return nil, false
}

// AsServerVulnerabilityProperties is the BasicAdditionalData implementation for SQLServerVulnerabilityProperties.
func (ssvp SQLServerVulnerabilityProperties) AsServerVulnerabilityProperties() (*ServerVulnerabilityProperties, bool) {
	return nil, false
}

// AsAdditionalData is the BasicAdditionalData implementation for SQLServerVulnerabilityProperties.
func (ssvp SQLServerVulnerabilityProperties) AsAdditionalData() (*AdditionalData, bool) {
	return nil, false
}

// AsBasicAdditionalData is the BasicAdditionalData implementation for SQLServerVulnerabilityProperties.
func (ssvp SQLServerVulnerabilityProperties) AsBasicAdditionalData() (BasicAdditionalData, bool) {
	return &ssvp, true
}

// SubAssessment security sub-assessment on a resource
type SubAssessment struct {
	autorest.Response        `json:"-"`
	*SubAssessmentProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Resource Id
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for SubAssessment.
func (sa SubAssessment) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if sa.SubAssessmentProperties != nil {
		objectMap["properties"] = sa.SubAssessmentProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for SubAssessment struct.
func (sa *SubAssessment) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var subAssessmentProperties SubAssessmentProperties
				err = json.Unmarshal(*v, &subAssessmentProperties)
				if err != nil {
					return err
				}
				sa.SubAssessmentProperties = &subAssessmentProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				sa.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				sa.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				sa.Type = &typeVar
			}
		}
	}

	return nil
}

// SubAssessmentList list of security sub-assessments
type SubAssessmentList struct {
	autorest.Response `json:"-"`
	// Value - READ-ONLY
	Value *[]SubAssessment `json:"value,omitempty"`
	// NextLink - READ-ONLY; The URI to fetch the next page.
	NextLink *string `json:"nextLink,omitempty"`
}

// SubAssessmentListIterator provides access to a complete listing of SubAssessment values.
type SubAssessmentListIterator struct {
	i    int
	page SubAssessmentListPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *SubAssessmentListIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/SubAssessmentListIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *SubAssessmentListIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter SubAssessmentListIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter SubAssessmentListIterator) Response() SubAssessmentList {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter SubAssessmentListIterator) Value() SubAssessment {
	if !iter.page.NotDone() {
		return SubAssessment{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the SubAssessmentListIterator type.
func NewSubAssessmentListIterator(page SubAssessmentListPage) SubAssessmentListIterator {
	return SubAssessmentListIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (sal SubAssessmentList) IsEmpty() bool {
	return sal.Value == nil || len(*sal.Value) == 0
}

// subAssessmentListPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (sal SubAssessmentList) subAssessmentListPreparer(ctx context.Context) (*http.Request, error) {
	if sal.NextLink == nil || len(to.String(sal.NextLink)) < 1 {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(sal.NextLink)))
}

// SubAssessmentListPage contains a page of SubAssessment values.
type SubAssessmentListPage struct {
	fn  func(context.Context, SubAssessmentList) (SubAssessmentList, error)
	sal SubAssessmentList
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *SubAssessmentListPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/SubAssessmentListPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	next, err := page.fn(ctx, page.sal)
	if err != nil {
		return err
	}
	page.sal = next
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *SubAssessmentListPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page SubAssessmentListPage) NotDone() bool {
	return !page.sal.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page SubAssessmentListPage) Response() SubAssessmentList {
	return page.sal
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page SubAssessmentListPage) Values() []SubAssessment {
	if page.sal.IsEmpty() {
		return nil
	}
	return *page.sal.Value
}

// Creates a new instance of the SubAssessmentListPage type.
func NewSubAssessmentListPage(getNextPage func(context.Context, SubAssessmentList) (SubAssessmentList, error)) SubAssessmentListPage {
	return SubAssessmentListPage{fn: getNextPage}
}

// SubAssessmentProperties describes properties of an sub-assessment.
type SubAssessmentProperties struct {
	// ID - READ-ONLY; Vulnerability ID
	ID *string `json:"id,omitempty"`
	// DisplayName - READ-ONLY; User friendly display name of the sub-assessment
	DisplayName *string              `json:"displayName,omitempty"`
	Status      *SubAssessmentStatus `json:"status,omitempty"`
	// Remediation - READ-ONLY; Information on how to remediate this sub-assessment
	Remediation *string `json:"remediation,omitempty"`
	// Impact - READ-ONLY; Description of the impact of this sub-assessment
	Impact *string `json:"impact,omitempty"`
	// Category - READ-ONLY; Category of the sub-assessment
	Category *string `json:"category,omitempty"`
	// Description - READ-ONLY; Human readable description of the assessment status
	Description *string `json:"description,omitempty"`
	// TimeGenerated - READ-ONLY; The date and time the sub-assessment was generated
	TimeGenerated   *date.Time           `json:"timeGenerated,omitempty"`
	ResourceDetails BasicResourceDetails `json:"resourceDetails,omitempty"`
	AdditionalData  BasicAdditionalData  `json:"additionalData,omitempty"`
}

// UnmarshalJSON is the custom unmarshaler for SubAssessmentProperties struct.
func (sap *SubAssessmentProperties) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				sap.ID = &ID
			}
		case "displayName":
			if v != nil {
				var displayName string
				err = json.Unmarshal(*v, &displayName)
				if err != nil {
					return err
				}
				sap.DisplayName = &displayName
			}
		case "status":
			if v != nil {
				var status SubAssessmentStatus
				err = json.Unmarshal(*v, &status)
				if err != nil {
					return err
				}
				sap.Status = &status
			}
		case "remediation":
			if v != nil {
				var remediation string
				err = json.Unmarshal(*v, &remediation)
				if err != nil {
					return err
				}
				sap.Remediation = &remediation
			}
		case "impact":
			if v != nil {
				var impact string
				err = json.Unmarshal(*v, &impact)
				if err != nil {
					return err
				}
				sap.Impact = &impact
			}
		case "category":
			if v != nil {
				var category string
				err = json.Unmarshal(*v, &category)
				if err != nil {
					return err
				}
				sap.Category = &category
			}
		case "description":
			if v != nil {
				var description string
				err = json.Unmarshal(*v, &description)
				if err != nil {
					return err
				}
				sap.Description = &description
			}
		case "timeGenerated":
			if v != nil {
				var timeGenerated date.Time
				err = json.Unmarshal(*v, &timeGenerated)
				if err != nil {
					return err
				}
				sap.TimeGenerated = &timeGenerated
			}
		case "resourceDetails":
			if v != nil {
				resourceDetails, err := unmarshalBasicResourceDetails(*v)
				if err != nil {
					return err
				}
				sap.ResourceDetails = resourceDetails
			}
		case "additionalData":
			if v != nil {
				additionalData, err := unmarshalBasicAdditionalData(*v)
				if err != nil {
					return err
				}
				sap.AdditionalData = additionalData
			}
		}
	}

	return nil
}

// SubAssessmentStatus status of the sub-assessment
type SubAssessmentStatus struct {
	// Code - READ-ONLY; Programmatic code for the status of the assessment. Possible values include: 'SubAssessmentStatusCodeHealthy', 'SubAssessmentStatusCodeUnhealthy', 'SubAssessmentStatusCodeNotApplicable'
	Code SubAssessmentStatusCode `json:"code,omitempty"`
	// Cause - READ-ONLY; Programmatic code for the cause of the assessment status
	Cause *string `json:"cause,omitempty"`
	// Description - READ-ONLY; Human readable description of the assessment status
	Description *string `json:"description,omitempty"`
	// Severity - READ-ONLY; The sub-assessment severity level. Possible values include: 'SeverityLow', 'SeverityMedium', 'SeverityHigh'
	Severity Severity `json:"severity,omitempty"`
}

// Tags a list of key value pairs that describe the resource.
type Tags struct {
	// Tags - A list of key value pairs that describe the resource.
	Tags map[string]*string `json:"tags"`
}

// MarshalJSON is the custom marshaler for Tags.
func (t Tags) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if t.Tags != nil {
		objectMap["tags"] = t.Tags
	}
	return json.Marshal(objectMap)
}

// TagsResource a container holding only the Tags for a resource, allowing the user to update the tags.
type TagsResource struct {
	// Tags - Resource tags
	Tags map[string]*string `json:"tags"`
}

// MarshalJSON is the custom marshaler for TagsResource.
func (tr TagsResource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if tr.Tags != nil {
		objectMap["tags"] = tr.Tags
	}
	return json.Marshal(objectMap)
}

// Task security task that we recommend to do in order to strengthen security
type Task struct {
	autorest.Response `json:"-"`
	*TaskProperties   `json:"properties,omitempty"`
	// ID - READ-ONLY; Resource Id
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for Task.
func (t Task) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if t.TaskProperties != nil {
		objectMap["properties"] = t.TaskProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for Task struct.
func (t *Task) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var taskProperties TaskProperties
				err = json.Unmarshal(*v, &taskProperties)
				if err != nil {
					return err
				}
				t.TaskProperties = &taskProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				t.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				t.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				t.Type = &typeVar
			}
		}
	}

	return nil
}

// TaskList list of security task recommendations
type TaskList struct {
	autorest.Response `json:"-"`
	// Value - READ-ONLY
	Value *[]Task `json:"value,omitempty"`
	// NextLink - READ-ONLY; The URI to fetch the next page.
	NextLink *string `json:"nextLink,omitempty"`
}

// TaskListIterator provides access to a complete listing of Task values.
type TaskListIterator struct {
	i    int
	page TaskListPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *TaskListIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/TaskListIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *TaskListIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter TaskListIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter TaskListIterator) Response() TaskList {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter TaskListIterator) Value() Task {
	if !iter.page.NotDone() {
		return Task{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the TaskListIterator type.
func NewTaskListIterator(page TaskListPage) TaskListIterator {
	return TaskListIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (tl TaskList) IsEmpty() bool {
	return tl.Value == nil || len(*tl.Value) == 0
}

// taskListPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (tl TaskList) taskListPreparer(ctx context.Context) (*http.Request, error) {
	if tl.NextLink == nil || len(to.String(tl.NextLink)) < 1 {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(tl.NextLink)))
}

// TaskListPage contains a page of Task values.
type TaskListPage struct {
	fn func(context.Context, TaskList) (TaskList, error)
	tl TaskList
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *TaskListPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/TaskListPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	next, err := page.fn(ctx, page.tl)
	if err != nil {
		return err
	}
	page.tl = next
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *TaskListPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page TaskListPage) NotDone() bool {
	return !page.tl.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page TaskListPage) Response() TaskList {
	return page.tl
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page TaskListPage) Values() []Task {
	if page.tl.IsEmpty() {
		return nil
	}
	return *page.tl.Value
}

// Creates a new instance of the TaskListPage type.
func NewTaskListPage(getNextPage func(context.Context, TaskList) (TaskList, error)) TaskListPage {
	return TaskListPage{fn: getNextPage}
}

// TaskParameters changing set of properties, depending on the task type that is derived from the name
// field
type TaskParameters struct {
	// AdditionalProperties - Unmatched properties from the message are deserialized this collection
	AdditionalProperties map[string]interface{} `json:""`
	// Name - READ-ONLY; Name of the task type
	Name *string `json:"name,omitempty"`
}

// MarshalJSON is the custom marshaler for TaskParameters.
func (tp TaskParameters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	for k, v := range tp.AdditionalProperties {
		objectMap[k] = v
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for TaskParameters struct.
func (tp *TaskParameters) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		default:
			if v != nil {
				var additionalProperties interface{}
				err = json.Unmarshal(*v, &additionalProperties)
				if err != nil {
					return err
				}
				if tp.AdditionalProperties == nil {
					tp.AdditionalProperties = make(map[string]interface{})
				}
				tp.AdditionalProperties[k] = additionalProperties
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				tp.Name = &name
			}
		}
	}

	return nil
}

// TaskProperties describes properties of a task.
type TaskProperties struct {
	// State - READ-ONLY; State of the task (Active, Resolved etc.)
	State *string `json:"state,omitempty"`
	// CreationTimeUtc - READ-ONLY; The time this task was discovered in UTC
	CreationTimeUtc        *date.Time      `json:"creationTimeUtc,omitempty"`
	SecurityTaskParameters *TaskParameters `json:"securityTaskParameters,omitempty"`
	// LastStateChangeTimeUtc - READ-ONLY; The time this task's details were last changed in UTC
	LastStateChangeTimeUtc *date.Time `json:"lastStateChangeTimeUtc,omitempty"`
	// SubState - READ-ONLY; Additional data on the state of the task
	SubState *string `json:"subState,omitempty"`
}

// ThresholdCustomAlertRule a custom alert rule that checks if a value (depends on the custom alert type)
// is within the given range.
type ThresholdCustomAlertRule struct {
	// MinThreshold - The minimum threshold.
	MinThreshold *int32 `json:"minThreshold,omitempty"`
	// MaxThreshold - The maximum threshold.
	MaxThreshold *int32 `json:"maxThreshold,omitempty"`
	// DisplayName - READ-ONLY; The display name of the custom alert.
	DisplayName *string `json:"displayName,omitempty"`
	// Description - READ-ONLY; The description of the custom alert.
	Description *string `json:"description,omitempty"`
	// IsEnabled - Status of the custom alert.
	IsEnabled *bool `json:"isEnabled,omitempty"`
	// RuleType - The type of the custom alert rule.
	RuleType *string `json:"ruleType,omitempty"`
}

// TimeWindowCustomAlertRule a custom alert rule that checks if the number of activities (depends on the
// custom alert type) in a time window is within the given range.
type TimeWindowCustomAlertRule struct {
	// TimeWindowSize - The time window size in iso8601 format.
	TimeWindowSize *string `json:"timeWindowSize,omitempty"`
	// MinThreshold - The minimum threshold.
	MinThreshold *int32 `json:"minThreshold,omitempty"`
	// MaxThreshold - The maximum threshold.
	MaxThreshold *int32 `json:"maxThreshold,omitempty"`
	// DisplayName - READ-ONLY; The display name of the custom alert.
	DisplayName *string `json:"displayName,omitempty"`
	// Description - READ-ONLY; The description of the custom alert.
	Description *string `json:"description,omitempty"`
	// IsEnabled - Status of the custom alert.
	IsEnabled *bool `json:"isEnabled,omitempty"`
	// RuleType - The type of the custom alert rule.
	RuleType *string `json:"ruleType,omitempty"`
}

// TopologyList ...
type TopologyList struct {
	autorest.Response `json:"-"`
	// Value - READ-ONLY
	Value *[]TopologyResource `json:"value,omitempty"`
	// NextLink - READ-ONLY; The URI to fetch the next page.
	NextLink *string `json:"nextLink,omitempty"`
}

// TopologyListIterator provides access to a complete listing of TopologyResource values.
type TopologyListIterator struct {
	i    int
	page TopologyListPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *TopologyListIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/TopologyListIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *TopologyListIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter TopologyListIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter TopologyListIterator) Response() TopologyList {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter TopologyListIterator) Value() TopologyResource {
	if !iter.page.NotDone() {
		return TopologyResource{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the TopologyListIterator type.
func NewTopologyListIterator(page TopologyListPage) TopologyListIterator {
	return TopologyListIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (tl TopologyList) IsEmpty() bool {
	return tl.Value == nil || len(*tl.Value) == 0
}

// topologyListPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (tl TopologyList) topologyListPreparer(ctx context.Context) (*http.Request, error) {
	if tl.NextLink == nil || len(to.String(tl.NextLink)) < 1 {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(tl.NextLink)))
}

// TopologyListPage contains a page of TopologyResource values.
type TopologyListPage struct {
	fn func(context.Context, TopologyList) (TopologyList, error)
	tl TopologyList
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *TopologyListPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/TopologyListPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	next, err := page.fn(ctx, page.tl)
	if err != nil {
		return err
	}
	page.tl = next
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *TopologyListPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page TopologyListPage) NotDone() bool {
	return !page.tl.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page TopologyListPage) Response() TopologyList {
	return page.tl
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page TopologyListPage) Values() []TopologyResource {
	if page.tl.IsEmpty() {
		return nil
	}
	return *page.tl.Value
}

// Creates a new instance of the TopologyListPage type.
func NewTopologyListPage(getNextPage func(context.Context, TopologyList) (TopologyList, error)) TopologyListPage {
	return TopologyListPage{fn: getNextPage}
}

// TopologyResource ...
type TopologyResource struct {
	autorest.Response `json:"-"`
	// ID - READ-ONLY; Resource Id
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type
	Type *string `json:"type,omitempty"`
	// Location - READ-ONLY; Location where the resource is stored
	Location *string `json:"location,omitempty"`
	// TopologyResourceProperties - READ-ONLY
	*TopologyResourceProperties `json:"properties,omitempty"`
}

// MarshalJSON is the custom marshaler for TopologyResource.
func (tr TopologyResource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for TopologyResource struct.
func (tr *TopologyResource) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				tr.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				tr.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				tr.Type = &typeVar
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				tr.Location = &location
			}
		case "properties":
			if v != nil {
				var topologyResourceProperties TopologyResourceProperties
				err = json.Unmarshal(*v, &topologyResourceProperties)
				if err != nil {
					return err
				}
				tr.TopologyResourceProperties = &topologyResourceProperties
			}
		}
	}

	return nil
}

// TopologyResourceProperties ...
type TopologyResourceProperties struct {
	// CalculatedDateTime - READ-ONLY; The UTC time on which the topology was calculated
	CalculatedDateTime *date.Time `json:"calculatedDateTime,omitempty"`
	// TopologyResources - READ-ONLY; Azure resources which are part of this topology resource
	TopologyResources *[]TopologySingleResource `json:"topologyResources,omitempty"`
}

// TopologySingleResource ...
type TopologySingleResource struct {
	// ResourceID - READ-ONLY; Azure resource id
	ResourceID *string `json:"resourceId,omitempty"`
	// Severity - READ-ONLY; The security severity of the resource
	Severity *string `json:"severity,omitempty"`
	// RecommendationsExist - READ-ONLY; Indicates if the resource has security recommendations
	RecommendationsExist *bool `json:"recommendationsExist,omitempty"`
	// NetworkZones - READ-ONLY; Indicates the resource connectivity level to the Internet (InternetFacing, Internal ,etc.)
	NetworkZones *string `json:"networkZones,omitempty"`
	// TopologyScore - READ-ONLY; Score of the resource based on its security severity
	TopologyScore *int32 `json:"topologyScore,omitempty"`
	// Location - READ-ONLY; The location of this resource
	Location *string `json:"location,omitempty"`
	// Parents - READ-ONLY; Azure resources connected to this resource which are in higher level in the topology view
	Parents *[]TopologySingleResourceParent `json:"parents,omitempty"`
	// Children - READ-ONLY; Azure resources connected to this resource which are in lower level in the topology view
	Children *[]TopologySingleResourceChild `json:"children,omitempty"`
}

// TopologySingleResourceChild ...
type TopologySingleResourceChild struct {
	// ResourceID - READ-ONLY; Azure resource id which serves as child resource in topology view
	ResourceID *string `json:"resourceId,omitempty"`
}

// TopologySingleResourceParent ...
type TopologySingleResourceParent struct {
	// ResourceID - READ-ONLY; Azure resource id which serves as parent resource in topology view
	ResourceID *string `json:"resourceId,omitempty"`
}

// TrackedResource describes an Azure tracked resource.
type TrackedResource struct {
	// ID - READ-ONLY; Resource Id
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type
	Type *string `json:"type,omitempty"`
	// Location - READ-ONLY; Location where the resource is stored
	Location *string `json:"location,omitempty"`
	// Kind - Kind of the resource
	Kind *string `json:"kind,omitempty"`
	// Etag - Entity tag is used for comparing two or more entities from the same requested resource.
	Etag *string `json:"etag,omitempty"`
	// Tags - A list of key value pairs that describe the resource.
	Tags map[string]*string `json:"tags"`
}

// MarshalJSON is the custom marshaler for TrackedResource.
func (tr TrackedResource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if tr.Kind != nil {
		objectMap["kind"] = tr.Kind
	}
	if tr.Etag != nil {
		objectMap["etag"] = tr.Etag
	}
	if tr.Tags != nil {
		objectMap["tags"] = tr.Tags
	}
	return json.Marshal(objectMap)
}

// UpdateIotSecuritySolutionData ...
type UpdateIotSecuritySolutionData struct {
	// UpdateIoTSecuritySolutionProperties - Security Solution data
	*UpdateIoTSecuritySolutionProperties `json:"properties,omitempty"`
	// Tags - Resource tags
	Tags map[string]*string `json:"tags"`
}

// MarshalJSON is the custom marshaler for UpdateIotSecuritySolutionData.
func (uissd UpdateIotSecuritySolutionData) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if uissd.UpdateIoTSecuritySolutionProperties != nil {
		objectMap["properties"] = uissd.UpdateIoTSecuritySolutionProperties
	}
	if uissd.Tags != nil {
		objectMap["tags"] = uissd.Tags
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for UpdateIotSecuritySolutionData struct.
func (uissd *UpdateIotSecuritySolutionData) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var updateIoTSecuritySolutionProperties UpdateIoTSecuritySolutionProperties
				err = json.Unmarshal(*v, &updateIoTSecuritySolutionProperties)
				if err != nil {
					return err
				}
				uissd.UpdateIoTSecuritySolutionProperties = &updateIoTSecuritySolutionProperties
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				uissd.Tags = tags
			}
		}
	}

	return nil
}

// UpdateIoTSecuritySolutionProperties update Security Solution setting data
type UpdateIoTSecuritySolutionProperties struct {
	UserDefinedResources         *UserDefinedResourcesProperties          `json:"userDefinedResources,omitempty"`
	RecommendationsConfiguration *[]RecommendationConfigurationProperties `json:"recommendationsConfiguration,omitempty"`
}

// UserDefinedResourcesProperties properties of the IoT Security solution's user defined resources.
type UserDefinedResourcesProperties struct {
	// Query - Azure Resource Graph query which represents the security solution's user defined resources. Required to start with "where type != "Microsoft.Devices/IotHubs""
	Query *string `json:"query,omitempty"`
	// QuerySubscriptions - List of Azure subscription ids on which the user defined resources query should be executed.
	QuerySubscriptions *[]string `json:"querySubscriptions,omitempty"`
}

// UserRecommendation represents a user that is recommended to be allowed for a certain rule
type UserRecommendation struct {
	// Username - Represents a user that is recommended to be allowed for a certain rule
	Username *string `json:"username,omitempty"`
	// RecommendationAction - Possible values include: 'RecommendationAction1Recommended', 'RecommendationAction1Add', 'RecommendationAction1Remove'
	RecommendationAction RecommendationAction1 `json:"recommendationAction,omitempty"`
}

// VendorReference vendor reference
type VendorReference struct {
	// Title - READ-ONLY; Link title
	Title *string `json:"title,omitempty"`
	// Link - READ-ONLY; Link url
	Link *string `json:"link,omitempty"`
}

// VMRecommendation represents a machine that is part of a VM/server group
type VMRecommendation struct {
	// ConfigurationStatus - Possible values include: 'Configured', 'NotConfigured', 'InProgress', 'Failed', 'NoStatus'
	ConfigurationStatus ConfigurationStatus `json:"configurationStatus,omitempty"`
	// RecommendationAction - Possible values include: 'RecommendationActionRecommended', 'RecommendationActionAdd', 'RecommendationActionRemove'
	RecommendationAction RecommendationAction `json:"recommendationAction,omitempty"`
	ResourceID           *string              `json:"resourceId,omitempty"`
}

// WorkspaceSetting configures where to store the OMS agent data for workspaces under a scope
type WorkspaceSetting struct {
	autorest.Response `json:"-"`
	// WorkspaceSettingProperties - Workspace setting data
	*WorkspaceSettingProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Resource Id
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for WorkspaceSetting.
func (ws WorkspaceSetting) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if ws.WorkspaceSettingProperties != nil {
		objectMap["properties"] = ws.WorkspaceSettingProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for WorkspaceSetting struct.
func (ws *WorkspaceSetting) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var workspaceSettingProperties WorkspaceSettingProperties
				err = json.Unmarshal(*v, &workspaceSettingProperties)
				if err != nil {
					return err
				}
				ws.WorkspaceSettingProperties = &workspaceSettingProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				ws.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				ws.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				ws.Type = &typeVar
			}
		}
	}

	return nil
}

// WorkspaceSettingList list of workspace settings response
type WorkspaceSettingList struct {
	autorest.Response `json:"-"`
	// Value - List of workspace settings
	Value *[]WorkspaceSetting `json:"value,omitempty"`
	// NextLink - READ-ONLY; The URI to fetch the next page.
	NextLink *string `json:"nextLink,omitempty"`
}

// WorkspaceSettingListIterator provides access to a complete listing of WorkspaceSetting values.
type WorkspaceSettingListIterator struct {
	i    int
	page WorkspaceSettingListPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *WorkspaceSettingListIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/WorkspaceSettingListIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *WorkspaceSettingListIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter WorkspaceSettingListIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter WorkspaceSettingListIterator) Response() WorkspaceSettingList {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter WorkspaceSettingListIterator) Value() WorkspaceSetting {
	if !iter.page.NotDone() {
		return WorkspaceSetting{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the WorkspaceSettingListIterator type.
func NewWorkspaceSettingListIterator(page WorkspaceSettingListPage) WorkspaceSettingListIterator {
	return WorkspaceSettingListIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (wsl WorkspaceSettingList) IsEmpty() bool {
	return wsl.Value == nil || len(*wsl.Value) == 0
}

// workspaceSettingListPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (wsl WorkspaceSettingList) workspaceSettingListPreparer(ctx context.Context) (*http.Request, error) {
	if wsl.NextLink == nil || len(to.String(wsl.NextLink)) < 1 {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(wsl.NextLink)))
}

// WorkspaceSettingListPage contains a page of WorkspaceSetting values.
type WorkspaceSettingListPage struct {
	fn  func(context.Context, WorkspaceSettingList) (WorkspaceSettingList, error)
	wsl WorkspaceSettingList
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *WorkspaceSettingListPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/WorkspaceSettingListPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	next, err := page.fn(ctx, page.wsl)
	if err != nil {
		return err
	}
	page.wsl = next
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *WorkspaceSettingListPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page WorkspaceSettingListPage) NotDone() bool {
	return !page.wsl.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page WorkspaceSettingListPage) Response() WorkspaceSettingList {
	return page.wsl
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page WorkspaceSettingListPage) Values() []WorkspaceSetting {
	if page.wsl.IsEmpty() {
		return nil
	}
	return *page.wsl.Value
}

// Creates a new instance of the WorkspaceSettingListPage type.
func NewWorkspaceSettingListPage(getNextPage func(context.Context, WorkspaceSettingList) (WorkspaceSettingList, error)) WorkspaceSettingListPage {
	return WorkspaceSettingListPage{fn: getNextPage}
}

// WorkspaceSettingProperties workspace setting data
type WorkspaceSettingProperties struct {
	// WorkspaceID - The full Azure ID of the workspace to save the data in
	WorkspaceID *string `json:"workspaceId,omitempty"`
	// Scope - All the VMs in this scope will send their security data to the mentioned workspace unless overridden by a setting with more specific scope
	Scope *string `json:"scope,omitempty"`
}
