// Code generated by protoc-gen-go. DO NOT EDIT.
// source: api/api.proto

package api

import (
	context "context"
	fmt "fmt"
	proto "github.com/golang/protobuf/proto"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
	math "math"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.ProtoPackageIsVersion3 // please upgrade the proto package

// Client represents an OAuth2 client.
type Client struct {
	Id                   string   `protobuf:"bytes,1,opt,name=id,proto3" json:"id,omitempty"`
	Secret               string   `protobuf:"bytes,2,opt,name=secret,proto3" json:"secret,omitempty"`
	RedirectUris         []string `protobuf:"bytes,3,rep,name=redirect_uris,json=redirectUris,proto3" json:"redirect_uris,omitempty"`
	TrustedPeers         []string `protobuf:"bytes,4,rep,name=trusted_peers,json=trustedPeers,proto3" json:"trusted_peers,omitempty"`
	Public               bool     `protobuf:"varint,5,opt,name=public,proto3" json:"public,omitempty"`
	Name                 string   `protobuf:"bytes,6,opt,name=name,proto3" json:"name,omitempty"`
	LogoUrl              string   `protobuf:"bytes,7,opt,name=logo_url,json=logoUrl,proto3" json:"logo_url,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *Client) Reset()         { *m = Client{} }
func (m *Client) String() string { return proto.CompactTextString(m) }
func (*Client) ProtoMessage()    {}
func (*Client) Descriptor() ([]byte, []int) {
	return fileDescriptor_1b40cafcd4234784, []int{0}
}

func (m *Client) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Client.Unmarshal(m, b)
}
func (m *Client) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Client.Marshal(b, m, deterministic)
}
func (m *Client) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Client.Merge(m, src)
}
func (m *Client) XXX_Size() int {
	return xxx_messageInfo_Client.Size(m)
}
func (m *Client) XXX_DiscardUnknown() {
	xxx_messageInfo_Client.DiscardUnknown(m)
}

var xxx_messageInfo_Client proto.InternalMessageInfo

func (m *Client) GetId() string {
	if m != nil {
		return m.Id
	}
	return ""
}

func (m *Client) GetSecret() string {
	if m != nil {
		return m.Secret
	}
	return ""
}

func (m *Client) GetRedirectUris() []string {
	if m != nil {
		return m.RedirectUris
	}
	return nil
}

func (m *Client) GetTrustedPeers() []string {
	if m != nil {
		return m.TrustedPeers
	}
	return nil
}

func (m *Client) GetPublic() bool {
	if m != nil {
		return m.Public
	}
	return false
}

func (m *Client) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *Client) GetLogoUrl() string {
	if m != nil {
		return m.LogoUrl
	}
	return ""
}

// CreateClientReq is a request to make a client.
type CreateClientReq struct {
	Client               *Client  `protobuf:"bytes,1,opt,name=client,proto3" json:"client,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *CreateClientReq) Reset()         { *m = CreateClientReq{} }
func (m *CreateClientReq) String() string { return proto.CompactTextString(m) }
func (*CreateClientReq) ProtoMessage()    {}
func (*CreateClientReq) Descriptor() ([]byte, []int) {
	return fileDescriptor_1b40cafcd4234784, []int{1}
}

func (m *CreateClientReq) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_CreateClientReq.Unmarshal(m, b)
}
func (m *CreateClientReq) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_CreateClientReq.Marshal(b, m, deterministic)
}
func (m *CreateClientReq) XXX_Merge(src proto.Message) {
	xxx_messageInfo_CreateClientReq.Merge(m, src)
}
func (m *CreateClientReq) XXX_Size() int {
	return xxx_messageInfo_CreateClientReq.Size(m)
}
func (m *CreateClientReq) XXX_DiscardUnknown() {
	xxx_messageInfo_CreateClientReq.DiscardUnknown(m)
}

var xxx_messageInfo_CreateClientReq proto.InternalMessageInfo

func (m *CreateClientReq) GetClient() *Client {
	if m != nil {
		return m.Client
	}
	return nil
}

// CreateClientResp returns the response from creating a client.
type CreateClientResp struct {
	AlreadyExists        bool     `protobuf:"varint,1,opt,name=already_exists,json=alreadyExists,proto3" json:"already_exists,omitempty"`
	Client               *Client  `protobuf:"bytes,2,opt,name=client,proto3" json:"client,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *CreateClientResp) Reset()         { *m = CreateClientResp{} }
func (m *CreateClientResp) String() string { return proto.CompactTextString(m) }
func (*CreateClientResp) ProtoMessage()    {}
func (*CreateClientResp) Descriptor() ([]byte, []int) {
	return fileDescriptor_1b40cafcd4234784, []int{2}
}

func (m *CreateClientResp) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_CreateClientResp.Unmarshal(m, b)
}
func (m *CreateClientResp) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_CreateClientResp.Marshal(b, m, deterministic)
}
func (m *CreateClientResp) XXX_Merge(src proto.Message) {
	xxx_messageInfo_CreateClientResp.Merge(m, src)
}
func (m *CreateClientResp) XXX_Size() int {
	return xxx_messageInfo_CreateClientResp.Size(m)
}
func (m *CreateClientResp) XXX_DiscardUnknown() {
	xxx_messageInfo_CreateClientResp.DiscardUnknown(m)
}

var xxx_messageInfo_CreateClientResp proto.InternalMessageInfo

func (m *CreateClientResp) GetAlreadyExists() bool {
	if m != nil {
		return m.AlreadyExists
	}
	return false
}

func (m *CreateClientResp) GetClient() *Client {
	if m != nil {
		return m.Client
	}
	return nil
}

// DeleteClientReq is a request to delete a client.
type DeleteClientReq struct {
	// The ID of the client.
	Id                   string   `protobuf:"bytes,1,opt,name=id,proto3" json:"id,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *DeleteClientReq) Reset()         { *m = DeleteClientReq{} }
func (m *DeleteClientReq) String() string { return proto.CompactTextString(m) }
func (*DeleteClientReq) ProtoMessage()    {}
func (*DeleteClientReq) Descriptor() ([]byte, []int) {
	return fileDescriptor_1b40cafcd4234784, []int{3}
}

func (m *DeleteClientReq) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_DeleteClientReq.Unmarshal(m, b)
}
func (m *DeleteClientReq) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_DeleteClientReq.Marshal(b, m, deterministic)
}
func (m *DeleteClientReq) XXX_Merge(src proto.Message) {
	xxx_messageInfo_DeleteClientReq.Merge(m, src)
}
func (m *DeleteClientReq) XXX_Size() int {
	return xxx_messageInfo_DeleteClientReq.Size(m)
}
func (m *DeleteClientReq) XXX_DiscardUnknown() {
	xxx_messageInfo_DeleteClientReq.DiscardUnknown(m)
}

var xxx_messageInfo_DeleteClientReq proto.InternalMessageInfo

func (m *DeleteClientReq) GetId() string {
	if m != nil {
		return m.Id
	}
	return ""
}

// DeleteClientResp determines if the client is deleted successfully.
type DeleteClientResp struct {
	NotFound             bool     `protobuf:"varint,1,opt,name=not_found,json=notFound,proto3" json:"not_found,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *DeleteClientResp) Reset()         { *m = DeleteClientResp{} }
func (m *DeleteClientResp) String() string { return proto.CompactTextString(m) }
func (*DeleteClientResp) ProtoMessage()    {}
func (*DeleteClientResp) Descriptor() ([]byte, []int) {
	return fileDescriptor_1b40cafcd4234784, []int{4}
}

func (m *DeleteClientResp) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_DeleteClientResp.Unmarshal(m, b)
}
func (m *DeleteClientResp) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_DeleteClientResp.Marshal(b, m, deterministic)
}
func (m *DeleteClientResp) XXX_Merge(src proto.Message) {
	xxx_messageInfo_DeleteClientResp.Merge(m, src)
}
func (m *DeleteClientResp) XXX_Size() int {
	return xxx_messageInfo_DeleteClientResp.Size(m)
}
func (m *DeleteClientResp) XXX_DiscardUnknown() {
	xxx_messageInfo_DeleteClientResp.DiscardUnknown(m)
}

var xxx_messageInfo_DeleteClientResp proto.InternalMessageInfo

func (m *DeleteClientResp) GetNotFound() bool {
	if m != nil {
		return m.NotFound
	}
	return false
}

// UpdateClientReq is a request to update an exisitng client.
type UpdateClientReq struct {
	Id                   string   `protobuf:"bytes,1,opt,name=id,proto3" json:"id,omitempty"`
	RedirectUris         []string `protobuf:"bytes,2,rep,name=redirect_uris,json=redirectUris,proto3" json:"redirect_uris,omitempty"`
	TrustedPeers         []string `protobuf:"bytes,3,rep,name=trusted_peers,json=trustedPeers,proto3" json:"trusted_peers,omitempty"`
	Name                 string   `protobuf:"bytes,4,opt,name=name,proto3" json:"name,omitempty"`
	LogoUrl              string   `protobuf:"bytes,5,opt,name=logo_url,json=logoUrl,proto3" json:"logo_url,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *UpdateClientReq) Reset()         { *m = UpdateClientReq{} }
func (m *UpdateClientReq) String() string { return proto.CompactTextString(m) }
func (*UpdateClientReq) ProtoMessage()    {}
func (*UpdateClientReq) Descriptor() ([]byte, []int) {
	return fileDescriptor_1b40cafcd4234784, []int{5}
}

func (m *UpdateClientReq) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_UpdateClientReq.Unmarshal(m, b)
}
func (m *UpdateClientReq) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_UpdateClientReq.Marshal(b, m, deterministic)
}
func (m *UpdateClientReq) XXX_Merge(src proto.Message) {
	xxx_messageInfo_UpdateClientReq.Merge(m, src)
}
func (m *UpdateClientReq) XXX_Size() int {
	return xxx_messageInfo_UpdateClientReq.Size(m)
}
func (m *UpdateClientReq) XXX_DiscardUnknown() {
	xxx_messageInfo_UpdateClientReq.DiscardUnknown(m)
}

var xxx_messageInfo_UpdateClientReq proto.InternalMessageInfo

func (m *UpdateClientReq) GetId() string {
	if m != nil {
		return m.Id
	}
	return ""
}

func (m *UpdateClientReq) GetRedirectUris() []string {
	if m != nil {
		return m.RedirectUris
	}
	return nil
}

func (m *UpdateClientReq) GetTrustedPeers() []string {
	if m != nil {
		return m.TrustedPeers
	}
	return nil
}

func (m *UpdateClientReq) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *UpdateClientReq) GetLogoUrl() string {
	if m != nil {
		return m.LogoUrl
	}
	return ""
}

// UpdateClientResp returns the reponse form updating a client.
type UpdateClientResp struct {
	NotFound             bool     `protobuf:"varint,1,opt,name=not_found,json=notFound,proto3" json:"not_found,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *UpdateClientResp) Reset()         { *m = UpdateClientResp{} }
func (m *UpdateClientResp) String() string { return proto.CompactTextString(m) }
func (*UpdateClientResp) ProtoMessage()    {}
func (*UpdateClientResp) Descriptor() ([]byte, []int) {
	return fileDescriptor_1b40cafcd4234784, []int{6}
}

func (m *UpdateClientResp) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_UpdateClientResp.Unmarshal(m, b)
}
func (m *UpdateClientResp) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_UpdateClientResp.Marshal(b, m, deterministic)
}
func (m *UpdateClientResp) XXX_Merge(src proto.Message) {
	xxx_messageInfo_UpdateClientResp.Merge(m, src)
}
func (m *UpdateClientResp) XXX_Size() int {
	return xxx_messageInfo_UpdateClientResp.Size(m)
}
func (m *UpdateClientResp) XXX_DiscardUnknown() {
	xxx_messageInfo_UpdateClientResp.DiscardUnknown(m)
}

var xxx_messageInfo_UpdateClientResp proto.InternalMessageInfo

func (m *UpdateClientResp) GetNotFound() bool {
	if m != nil {
		return m.NotFound
	}
	return false
}

// Password is an email for password mapping managed by the storage.
type Password struct {
	Email string `protobuf:"bytes,1,opt,name=email,proto3" json:"email,omitempty"`
	// Currently we do not accept plain text passwords. Could be an option in the future.
	Hash                 []byte   `protobuf:"bytes,2,opt,name=hash,proto3" json:"hash,omitempty"`
	Username             string   `protobuf:"bytes,3,opt,name=username,proto3" json:"username,omitempty"`
	UserId               string   `protobuf:"bytes,4,opt,name=user_id,json=userId,proto3" json:"user_id,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *Password) Reset()         { *m = Password{} }
func (m *Password) String() string { return proto.CompactTextString(m) }
func (*Password) ProtoMessage()    {}
func (*Password) Descriptor() ([]byte, []int) {
	return fileDescriptor_1b40cafcd4234784, []int{7}
}

func (m *Password) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Password.Unmarshal(m, b)
}
func (m *Password) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Password.Marshal(b, m, deterministic)
}
func (m *Password) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Password.Merge(m, src)
}
func (m *Password) XXX_Size() int {
	return xxx_messageInfo_Password.Size(m)
}
func (m *Password) XXX_DiscardUnknown() {
	xxx_messageInfo_Password.DiscardUnknown(m)
}

var xxx_messageInfo_Password proto.InternalMessageInfo

func (m *Password) GetEmail() string {
	if m != nil {
		return m.Email
	}
	return ""
}

func (m *Password) GetHash() []byte {
	if m != nil {
		return m.Hash
	}
	return nil
}

func (m *Password) GetUsername() string {
	if m != nil {
		return m.Username
	}
	return ""
}

func (m *Password) GetUserId() string {
	if m != nil {
		return m.UserId
	}
	return ""
}

// CreatePasswordReq is a request to make a password.
type CreatePasswordReq struct {
	Password             *Password `protobuf:"bytes,1,opt,name=password,proto3" json:"password,omitempty"`
	XXX_NoUnkeyedLiteral struct{}  `json:"-"`
	XXX_unrecognized     []byte    `json:"-"`
	XXX_sizecache        int32     `json:"-"`
}

func (m *CreatePasswordReq) Reset()         { *m = CreatePasswordReq{} }
func (m *CreatePasswordReq) String() string { return proto.CompactTextString(m) }
func (*CreatePasswordReq) ProtoMessage()    {}
func (*CreatePasswordReq) Descriptor() ([]byte, []int) {
	return fileDescriptor_1b40cafcd4234784, []int{8}
}

func (m *CreatePasswordReq) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_CreatePasswordReq.Unmarshal(m, b)
}
func (m *CreatePasswordReq) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_CreatePasswordReq.Marshal(b, m, deterministic)
}
func (m *CreatePasswordReq) XXX_Merge(src proto.Message) {
	xxx_messageInfo_CreatePasswordReq.Merge(m, src)
}
func (m *CreatePasswordReq) XXX_Size() int {
	return xxx_messageInfo_CreatePasswordReq.Size(m)
}
func (m *CreatePasswordReq) XXX_DiscardUnknown() {
	xxx_messageInfo_CreatePasswordReq.DiscardUnknown(m)
}

var xxx_messageInfo_CreatePasswordReq proto.InternalMessageInfo

func (m *CreatePasswordReq) GetPassword() *Password {
	if m != nil {
		return m.Password
	}
	return nil
}

// CreatePasswordResp returns the response from creating a password.
type CreatePasswordResp struct {
	AlreadyExists        bool     `protobuf:"varint,1,opt,name=already_exists,json=alreadyExists,proto3" json:"already_exists,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *CreatePasswordResp) Reset()         { *m = CreatePasswordResp{} }
func (m *CreatePasswordResp) String() string { return proto.CompactTextString(m) }
func (*CreatePasswordResp) ProtoMessage()    {}
func (*CreatePasswordResp) Descriptor() ([]byte, []int) {
	return fileDescriptor_1b40cafcd4234784, []int{9}
}

func (m *CreatePasswordResp) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_CreatePasswordResp.Unmarshal(m, b)
}
func (m *CreatePasswordResp) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_CreatePasswordResp.Marshal(b, m, deterministic)
}
func (m *CreatePasswordResp) XXX_Merge(src proto.Message) {
	xxx_messageInfo_CreatePasswordResp.Merge(m, src)
}
func (m *CreatePasswordResp) XXX_Size() int {
	return xxx_messageInfo_CreatePasswordResp.Size(m)
}
func (m *CreatePasswordResp) XXX_DiscardUnknown() {
	xxx_messageInfo_CreatePasswordResp.DiscardUnknown(m)
}

var xxx_messageInfo_CreatePasswordResp proto.InternalMessageInfo

func (m *CreatePasswordResp) GetAlreadyExists() bool {
	if m != nil {
		return m.AlreadyExists
	}
	return false
}

// UpdatePasswordReq is a request to modify an existing password.
type UpdatePasswordReq struct {
	// The email used to lookup the password. This field cannot be modified
	Email                string   `protobuf:"bytes,1,opt,name=email,proto3" json:"email,omitempty"`
	NewHash              []byte   `protobuf:"bytes,2,opt,name=new_hash,json=newHash,proto3" json:"new_hash,omitempty"`
	NewUsername          string   `protobuf:"bytes,3,opt,name=new_username,json=newUsername,proto3" json:"new_username,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *UpdatePasswordReq) Reset()         { *m = UpdatePasswordReq{} }
func (m *UpdatePasswordReq) String() string { return proto.CompactTextString(m) }
func (*UpdatePasswordReq) ProtoMessage()    {}
func (*UpdatePasswordReq) Descriptor() ([]byte, []int) {
	return fileDescriptor_1b40cafcd4234784, []int{10}
}

func (m *UpdatePasswordReq) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_UpdatePasswordReq.Unmarshal(m, b)
}
func (m *UpdatePasswordReq) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_UpdatePasswordReq.Marshal(b, m, deterministic)
}
func (m *UpdatePasswordReq) XXX_Merge(src proto.Message) {
	xxx_messageInfo_UpdatePasswordReq.Merge(m, src)
}
func (m *UpdatePasswordReq) XXX_Size() int {
	return xxx_messageInfo_UpdatePasswordReq.Size(m)
}
func (m *UpdatePasswordReq) XXX_DiscardUnknown() {
	xxx_messageInfo_UpdatePasswordReq.DiscardUnknown(m)
}

var xxx_messageInfo_UpdatePasswordReq proto.InternalMessageInfo

func (m *UpdatePasswordReq) GetEmail() string {
	if m != nil {
		return m.Email
	}
	return ""
}

func (m *UpdatePasswordReq) GetNewHash() []byte {
	if m != nil {
		return m.NewHash
	}
	return nil
}

func (m *UpdatePasswordReq) GetNewUsername() string {
	if m != nil {
		return m.NewUsername
	}
	return ""
}

// UpdatePasswordResp returns the response from modifying an existing password.
type UpdatePasswordResp struct {
	NotFound             bool     `protobuf:"varint,1,opt,name=not_found,json=notFound,proto3" json:"not_found,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *UpdatePasswordResp) Reset()         { *m = UpdatePasswordResp{} }
func (m *UpdatePasswordResp) String() string { return proto.CompactTextString(m) }
func (*UpdatePasswordResp) ProtoMessage()    {}
func (*UpdatePasswordResp) Descriptor() ([]byte, []int) {
	return fileDescriptor_1b40cafcd4234784, []int{11}
}

func (m *UpdatePasswordResp) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_UpdatePasswordResp.Unmarshal(m, b)
}
func (m *UpdatePasswordResp) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_UpdatePasswordResp.Marshal(b, m, deterministic)
}
func (m *UpdatePasswordResp) XXX_Merge(src proto.Message) {
	xxx_messageInfo_UpdatePasswordResp.Merge(m, src)
}
func (m *UpdatePasswordResp) XXX_Size() int {
	return xxx_messageInfo_UpdatePasswordResp.Size(m)
}
func (m *UpdatePasswordResp) XXX_DiscardUnknown() {
	xxx_messageInfo_UpdatePasswordResp.DiscardUnknown(m)
}

var xxx_messageInfo_UpdatePasswordResp proto.InternalMessageInfo

func (m *UpdatePasswordResp) GetNotFound() bool {
	if m != nil {
		return m.NotFound
	}
	return false
}

// DeletePasswordReq is a request to delete a password.
type DeletePasswordReq struct {
	Email                string   `protobuf:"bytes,1,opt,name=email,proto3" json:"email,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *DeletePasswordReq) Reset()         { *m = DeletePasswordReq{} }
func (m *DeletePasswordReq) String() string { return proto.CompactTextString(m) }
func (*DeletePasswordReq) ProtoMessage()    {}
func (*DeletePasswordReq) Descriptor() ([]byte, []int) {
	return fileDescriptor_1b40cafcd4234784, []int{12}
}

func (m *DeletePasswordReq) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_DeletePasswordReq.Unmarshal(m, b)
}
func (m *DeletePasswordReq) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_DeletePasswordReq.Marshal(b, m, deterministic)
}
func (m *DeletePasswordReq) XXX_Merge(src proto.Message) {
	xxx_messageInfo_DeletePasswordReq.Merge(m, src)
}
func (m *DeletePasswordReq) XXX_Size() int {
	return xxx_messageInfo_DeletePasswordReq.Size(m)
}
func (m *DeletePasswordReq) XXX_DiscardUnknown() {
	xxx_messageInfo_DeletePasswordReq.DiscardUnknown(m)
}

var xxx_messageInfo_DeletePasswordReq proto.InternalMessageInfo

func (m *DeletePasswordReq) GetEmail() string {
	if m != nil {
		return m.Email
	}
	return ""
}

// DeletePasswordResp returns the response from deleting a password.
type DeletePasswordResp struct {
	NotFound             bool     `protobuf:"varint,1,opt,name=not_found,json=notFound,proto3" json:"not_found,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *DeletePasswordResp) Reset()         { *m = DeletePasswordResp{} }
func (m *DeletePasswordResp) String() string { return proto.CompactTextString(m) }
func (*DeletePasswordResp) ProtoMessage()    {}
func (*DeletePasswordResp) Descriptor() ([]byte, []int) {
	return fileDescriptor_1b40cafcd4234784, []int{13}
}

func (m *DeletePasswordResp) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_DeletePasswordResp.Unmarshal(m, b)
}
func (m *DeletePasswordResp) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_DeletePasswordResp.Marshal(b, m, deterministic)
}
func (m *DeletePasswordResp) XXX_Merge(src proto.Message) {
	xxx_messageInfo_DeletePasswordResp.Merge(m, src)
}
func (m *DeletePasswordResp) XXX_Size() int {
	return xxx_messageInfo_DeletePasswordResp.Size(m)
}
func (m *DeletePasswordResp) XXX_DiscardUnknown() {
	xxx_messageInfo_DeletePasswordResp.DiscardUnknown(m)
}

var xxx_messageInfo_DeletePasswordResp proto.InternalMessageInfo

func (m *DeletePasswordResp) GetNotFound() bool {
	if m != nil {
		return m.NotFound
	}
	return false
}

// ListPasswordReq is a request to enumerate passwords.
type ListPasswordReq struct {
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ListPasswordReq) Reset()         { *m = ListPasswordReq{} }
func (m *ListPasswordReq) String() string { return proto.CompactTextString(m) }
func (*ListPasswordReq) ProtoMessage()    {}
func (*ListPasswordReq) Descriptor() ([]byte, []int) {
	return fileDescriptor_1b40cafcd4234784, []int{14}
}

func (m *ListPasswordReq) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ListPasswordReq.Unmarshal(m, b)
}
func (m *ListPasswordReq) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ListPasswordReq.Marshal(b, m, deterministic)
}
func (m *ListPasswordReq) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ListPasswordReq.Merge(m, src)
}
func (m *ListPasswordReq) XXX_Size() int {
	return xxx_messageInfo_ListPasswordReq.Size(m)
}
func (m *ListPasswordReq) XXX_DiscardUnknown() {
	xxx_messageInfo_ListPasswordReq.DiscardUnknown(m)
}

var xxx_messageInfo_ListPasswordReq proto.InternalMessageInfo

// ListPasswordResp returns a list of passwords.
type ListPasswordResp struct {
	Passwords            []*Password `protobuf:"bytes,1,rep,name=passwords,proto3" json:"passwords,omitempty"`
	XXX_NoUnkeyedLiteral struct{}    `json:"-"`
	XXX_unrecognized     []byte      `json:"-"`
	XXX_sizecache        int32       `json:"-"`
}

func (m *ListPasswordResp) Reset()         { *m = ListPasswordResp{} }
func (m *ListPasswordResp) String() string { return proto.CompactTextString(m) }
func (*ListPasswordResp) ProtoMessage()    {}
func (*ListPasswordResp) Descriptor() ([]byte, []int) {
	return fileDescriptor_1b40cafcd4234784, []int{15}
}

func (m *ListPasswordResp) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ListPasswordResp.Unmarshal(m, b)
}
func (m *ListPasswordResp) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ListPasswordResp.Marshal(b, m, deterministic)
}
func (m *ListPasswordResp) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ListPasswordResp.Merge(m, src)
}
func (m *ListPasswordResp) XXX_Size() int {
	return xxx_messageInfo_ListPasswordResp.Size(m)
}
func (m *ListPasswordResp) XXX_DiscardUnknown() {
	xxx_messageInfo_ListPasswordResp.DiscardUnknown(m)
}

var xxx_messageInfo_ListPasswordResp proto.InternalMessageInfo

func (m *ListPasswordResp) GetPasswords() []*Password {
	if m != nil {
		return m.Passwords
	}
	return nil
}

// VersionReq is a request to fetch version info.
type VersionReq struct {
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *VersionReq) Reset()         { *m = VersionReq{} }
func (m *VersionReq) String() string { return proto.CompactTextString(m) }
func (*VersionReq) ProtoMessage()    {}
func (*VersionReq) Descriptor() ([]byte, []int) {
	return fileDescriptor_1b40cafcd4234784, []int{16}
}

func (m *VersionReq) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_VersionReq.Unmarshal(m, b)
}
func (m *VersionReq) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_VersionReq.Marshal(b, m, deterministic)
}
func (m *VersionReq) XXX_Merge(src proto.Message) {
	xxx_messageInfo_VersionReq.Merge(m, src)
}
func (m *VersionReq) XXX_Size() int {
	return xxx_messageInfo_VersionReq.Size(m)
}
func (m *VersionReq) XXX_DiscardUnknown() {
	xxx_messageInfo_VersionReq.DiscardUnknown(m)
}

var xxx_messageInfo_VersionReq proto.InternalMessageInfo

// VersionResp holds the version info of components.
type VersionResp struct {
	// Semantic version of the server.
	Server string `protobuf:"bytes,1,opt,name=server,proto3" json:"server,omitempty"`
	// Numeric version of the API. It increases everytime a new call is added to the API.
	// Clients should use this info to determine if the server supports specific features.
	Api                  int32    `protobuf:"varint,2,opt,name=api,proto3" json:"api,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *VersionResp) Reset()         { *m = VersionResp{} }
func (m *VersionResp) String() string { return proto.CompactTextString(m) }
func (*VersionResp) ProtoMessage()    {}
func (*VersionResp) Descriptor() ([]byte, []int) {
	return fileDescriptor_1b40cafcd4234784, []int{17}
}

func (m *VersionResp) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_VersionResp.Unmarshal(m, b)
}
func (m *VersionResp) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_VersionResp.Marshal(b, m, deterministic)
}
func (m *VersionResp) XXX_Merge(src proto.Message) {
	xxx_messageInfo_VersionResp.Merge(m, src)
}
func (m *VersionResp) XXX_Size() int {
	return xxx_messageInfo_VersionResp.Size(m)
}
func (m *VersionResp) XXX_DiscardUnknown() {
	xxx_messageInfo_VersionResp.DiscardUnknown(m)
}

var xxx_messageInfo_VersionResp proto.InternalMessageInfo

func (m *VersionResp) GetServer() string {
	if m != nil {
		return m.Server
	}
	return ""
}

func (m *VersionResp) GetApi() int32 {
	if m != nil {
		return m.Api
	}
	return 0
}

// RefreshTokenRef contains the metadata for a refresh token that is managed by the storage.
type RefreshTokenRef struct {
	// ID of the refresh token.
	Id                   string   `protobuf:"bytes,1,opt,name=id,proto3" json:"id,omitempty"`
	ClientId             string   `protobuf:"bytes,2,opt,name=client_id,json=clientId,proto3" json:"client_id,omitempty"`
	CreatedAt            int64    `protobuf:"varint,5,opt,name=created_at,json=createdAt,proto3" json:"created_at,omitempty"`
	LastUsed             int64    `protobuf:"varint,6,opt,name=last_used,json=lastUsed,proto3" json:"last_used,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *RefreshTokenRef) Reset()         { *m = RefreshTokenRef{} }
func (m *RefreshTokenRef) String() string { return proto.CompactTextString(m) }
func (*RefreshTokenRef) ProtoMessage()    {}
func (*RefreshTokenRef) Descriptor() ([]byte, []int) {
	return fileDescriptor_1b40cafcd4234784, []int{18}
}

func (m *RefreshTokenRef) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_RefreshTokenRef.Unmarshal(m, b)
}
func (m *RefreshTokenRef) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_RefreshTokenRef.Marshal(b, m, deterministic)
}
func (m *RefreshTokenRef) XXX_Merge(src proto.Message) {
	xxx_messageInfo_RefreshTokenRef.Merge(m, src)
}
func (m *RefreshTokenRef) XXX_Size() int {
	return xxx_messageInfo_RefreshTokenRef.Size(m)
}
func (m *RefreshTokenRef) XXX_DiscardUnknown() {
	xxx_messageInfo_RefreshTokenRef.DiscardUnknown(m)
}

var xxx_messageInfo_RefreshTokenRef proto.InternalMessageInfo

func (m *RefreshTokenRef) GetId() string {
	if m != nil {
		return m.Id
	}
	return ""
}

func (m *RefreshTokenRef) GetClientId() string {
	if m != nil {
		return m.ClientId
	}
	return ""
}

func (m *RefreshTokenRef) GetCreatedAt() int64 {
	if m != nil {
		return m.CreatedAt
	}
	return 0
}

func (m *RefreshTokenRef) GetLastUsed() int64 {
	if m != nil {
		return m.LastUsed
	}
	return 0
}

// ListRefreshReq is a request to enumerate the refresh tokens of a user.
type ListRefreshReq struct {
	// The "sub" claim returned in the ID Token.
	UserId               string   `protobuf:"bytes,1,opt,name=user_id,json=userId,proto3" json:"user_id,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ListRefreshReq) Reset()         { *m = ListRefreshReq{} }
func (m *ListRefreshReq) String() string { return proto.CompactTextString(m) }
func (*ListRefreshReq) ProtoMessage()    {}
func (*ListRefreshReq) Descriptor() ([]byte, []int) {
	return fileDescriptor_1b40cafcd4234784, []int{19}
}

func (m *ListRefreshReq) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ListRefreshReq.Unmarshal(m, b)
}
func (m *ListRefreshReq) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ListRefreshReq.Marshal(b, m, deterministic)
}
func (m *ListRefreshReq) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ListRefreshReq.Merge(m, src)
}
func (m *ListRefreshReq) XXX_Size() int {
	return xxx_messageInfo_ListRefreshReq.Size(m)
}
func (m *ListRefreshReq) XXX_DiscardUnknown() {
	xxx_messageInfo_ListRefreshReq.DiscardUnknown(m)
}

var xxx_messageInfo_ListRefreshReq proto.InternalMessageInfo

func (m *ListRefreshReq) GetUserId() string {
	if m != nil {
		return m.UserId
	}
	return ""
}

// ListRefreshResp returns a list of refresh tokens for a user.
type ListRefreshResp struct {
	RefreshTokens        []*RefreshTokenRef `protobuf:"bytes,1,rep,name=refresh_tokens,json=refreshTokens,proto3" json:"refresh_tokens,omitempty"`
	XXX_NoUnkeyedLiteral struct{}           `json:"-"`
	XXX_unrecognized     []byte             `json:"-"`
	XXX_sizecache        int32              `json:"-"`
}

func (m *ListRefreshResp) Reset()         { *m = ListRefreshResp{} }
func (m *ListRefreshResp) String() string { return proto.CompactTextString(m) }
func (*ListRefreshResp) ProtoMessage()    {}
func (*ListRefreshResp) Descriptor() ([]byte, []int) {
	return fileDescriptor_1b40cafcd4234784, []int{20}
}

func (m *ListRefreshResp) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ListRefreshResp.Unmarshal(m, b)
}
func (m *ListRefreshResp) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ListRefreshResp.Marshal(b, m, deterministic)
}
func (m *ListRefreshResp) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ListRefreshResp.Merge(m, src)
}
func (m *ListRefreshResp) XXX_Size() int {
	return xxx_messageInfo_ListRefreshResp.Size(m)
}
func (m *ListRefreshResp) XXX_DiscardUnknown() {
	xxx_messageInfo_ListRefreshResp.DiscardUnknown(m)
}

var xxx_messageInfo_ListRefreshResp proto.InternalMessageInfo

func (m *ListRefreshResp) GetRefreshTokens() []*RefreshTokenRef {
	if m != nil {
		return m.RefreshTokens
	}
	return nil
}

// RevokeRefreshReq is a request to revoke the refresh token of the user-client pair.
type RevokeRefreshReq struct {
	// The "sub" claim returned in the ID Token.
	UserId               string   `protobuf:"bytes,1,opt,name=user_id,json=userId,proto3" json:"user_id,omitempty"`
	ClientId             string   `protobuf:"bytes,2,opt,name=client_id,json=clientId,proto3" json:"client_id,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *RevokeRefreshReq) Reset()         { *m = RevokeRefreshReq{} }
func (m *RevokeRefreshReq) String() string { return proto.CompactTextString(m) }
func (*RevokeRefreshReq) ProtoMessage()    {}
func (*RevokeRefreshReq) Descriptor() ([]byte, []int) {
	return fileDescriptor_1b40cafcd4234784, []int{21}
}

func (m *RevokeRefreshReq) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_RevokeRefreshReq.Unmarshal(m, b)
}
func (m *RevokeRefreshReq) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_RevokeRefreshReq.Marshal(b, m, deterministic)
}
func (m *RevokeRefreshReq) XXX_Merge(src proto.Message) {
	xxx_messageInfo_RevokeRefreshReq.Merge(m, src)
}
func (m *RevokeRefreshReq) XXX_Size() int {
	return xxx_messageInfo_RevokeRefreshReq.Size(m)
}
func (m *RevokeRefreshReq) XXX_DiscardUnknown() {
	xxx_messageInfo_RevokeRefreshReq.DiscardUnknown(m)
}

var xxx_messageInfo_RevokeRefreshReq proto.InternalMessageInfo

func (m *RevokeRefreshReq) GetUserId() string {
	if m != nil {
		return m.UserId
	}
	return ""
}

func (m *RevokeRefreshReq) GetClientId() string {
	if m != nil {
		return m.ClientId
	}
	return ""
}

// RevokeRefreshResp determines if the refresh token is revoked successfully.
type RevokeRefreshResp struct {
	// Set to true is refresh token was not found and token could not be revoked.
	NotFound             bool     `protobuf:"varint,1,opt,name=not_found,json=notFound,proto3" json:"not_found,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *RevokeRefreshResp) Reset()         { *m = RevokeRefreshResp{} }
func (m *RevokeRefreshResp) String() string { return proto.CompactTextString(m) }
func (*RevokeRefreshResp) ProtoMessage()    {}
func (*RevokeRefreshResp) Descriptor() ([]byte, []int) {
	return fileDescriptor_1b40cafcd4234784, []int{22}
}

func (m *RevokeRefreshResp) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_RevokeRefreshResp.Unmarshal(m, b)
}
func (m *RevokeRefreshResp) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_RevokeRefreshResp.Marshal(b, m, deterministic)
}
func (m *RevokeRefreshResp) XXX_Merge(src proto.Message) {
	xxx_messageInfo_RevokeRefreshResp.Merge(m, src)
}
func (m *RevokeRefreshResp) XXX_Size() int {
	return xxx_messageInfo_RevokeRefreshResp.Size(m)
}
func (m *RevokeRefreshResp) XXX_DiscardUnknown() {
	xxx_messageInfo_RevokeRefreshResp.DiscardUnknown(m)
}

var xxx_messageInfo_RevokeRefreshResp proto.InternalMessageInfo

func (m *RevokeRefreshResp) GetNotFound() bool {
	if m != nil {
		return m.NotFound
	}
	return false
}

type VerifyPasswordReq struct {
	Email                string   `protobuf:"bytes,1,opt,name=email,proto3" json:"email,omitempty"`
	Password             string   `protobuf:"bytes,2,opt,name=password,proto3" json:"password,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *VerifyPasswordReq) Reset()         { *m = VerifyPasswordReq{} }
func (m *VerifyPasswordReq) String() string { return proto.CompactTextString(m) }
func (*VerifyPasswordReq) ProtoMessage()    {}
func (*VerifyPasswordReq) Descriptor() ([]byte, []int) {
	return fileDescriptor_1b40cafcd4234784, []int{23}
}

func (m *VerifyPasswordReq) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_VerifyPasswordReq.Unmarshal(m, b)
}
func (m *VerifyPasswordReq) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_VerifyPasswordReq.Marshal(b, m, deterministic)
}
func (m *VerifyPasswordReq) XXX_Merge(src proto.Message) {
	xxx_messageInfo_VerifyPasswordReq.Merge(m, src)
}
func (m *VerifyPasswordReq) XXX_Size() int {
	return xxx_messageInfo_VerifyPasswordReq.Size(m)
}
func (m *VerifyPasswordReq) XXX_DiscardUnknown() {
	xxx_messageInfo_VerifyPasswordReq.DiscardUnknown(m)
}

var xxx_messageInfo_VerifyPasswordReq proto.InternalMessageInfo

func (m *VerifyPasswordReq) GetEmail() string {
	if m != nil {
		return m.Email
	}
	return ""
}

func (m *VerifyPasswordReq) GetPassword() string {
	if m != nil {
		return m.Password
	}
	return ""
}

type VerifyPasswordResp struct {
	Verified             bool     `protobuf:"varint,1,opt,name=verified,proto3" json:"verified,omitempty"`
	NotFound             bool     `protobuf:"varint,2,opt,name=not_found,json=notFound,proto3" json:"not_found,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *VerifyPasswordResp) Reset()         { *m = VerifyPasswordResp{} }
func (m *VerifyPasswordResp) String() string { return proto.CompactTextString(m) }
func (*VerifyPasswordResp) ProtoMessage()    {}
func (*VerifyPasswordResp) Descriptor() ([]byte, []int) {
	return fileDescriptor_1b40cafcd4234784, []int{24}
}

func (m *VerifyPasswordResp) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_VerifyPasswordResp.Unmarshal(m, b)
}
func (m *VerifyPasswordResp) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_VerifyPasswordResp.Marshal(b, m, deterministic)
}
func (m *VerifyPasswordResp) XXX_Merge(src proto.Message) {
	xxx_messageInfo_VerifyPasswordResp.Merge(m, src)
}
func (m *VerifyPasswordResp) XXX_Size() int {
	return xxx_messageInfo_VerifyPasswordResp.Size(m)
}
func (m *VerifyPasswordResp) XXX_DiscardUnknown() {
	xxx_messageInfo_VerifyPasswordResp.DiscardUnknown(m)
}

var xxx_messageInfo_VerifyPasswordResp proto.InternalMessageInfo

func (m *VerifyPasswordResp) GetVerified() bool {
	if m != nil {
		return m.Verified
	}
	return false
}

func (m *VerifyPasswordResp) GetNotFound() bool {
	if m != nil {
		return m.NotFound
	}
	return false
}

func init() {
	proto.RegisterType((*Client)(nil), "api.Client")
	proto.RegisterType((*CreateClientReq)(nil), "api.CreateClientReq")
	proto.RegisterType((*CreateClientResp)(nil), "api.CreateClientResp")
	proto.RegisterType((*DeleteClientReq)(nil), "api.DeleteClientReq")
	proto.RegisterType((*DeleteClientResp)(nil), "api.DeleteClientResp")
	proto.RegisterType((*UpdateClientReq)(nil), "api.UpdateClientReq")
	proto.RegisterType((*UpdateClientResp)(nil), "api.UpdateClientResp")
	proto.RegisterType((*Password)(nil), "api.Password")
	proto.RegisterType((*CreatePasswordReq)(nil), "api.CreatePasswordReq")
	proto.RegisterType((*CreatePasswordResp)(nil), "api.CreatePasswordResp")
	proto.RegisterType((*UpdatePasswordReq)(nil), "api.UpdatePasswordReq")
	proto.RegisterType((*UpdatePasswordResp)(nil), "api.UpdatePasswordResp")
	proto.RegisterType((*DeletePasswordReq)(nil), "api.DeletePasswordReq")
	proto.RegisterType((*DeletePasswordResp)(nil), "api.DeletePasswordResp")
	proto.RegisterType((*ListPasswordReq)(nil), "api.ListPasswordReq")
	proto.RegisterType((*ListPasswordResp)(nil), "api.ListPasswordResp")
	proto.RegisterType((*VersionReq)(nil), "api.VersionReq")
	proto.RegisterType((*VersionResp)(nil), "api.VersionResp")
	proto.RegisterType((*RefreshTokenRef)(nil), "api.RefreshTokenRef")
	proto.RegisterType((*ListRefreshReq)(nil), "api.ListRefreshReq")
	proto.RegisterType((*ListRefreshResp)(nil), "api.ListRefreshResp")
	proto.RegisterType((*RevokeRefreshReq)(nil), "api.RevokeRefreshReq")
	proto.RegisterType((*RevokeRefreshResp)(nil), "api.RevokeRefreshResp")
	proto.RegisterType((*VerifyPasswordReq)(nil), "api.VerifyPasswordReq")
	proto.RegisterType((*VerifyPasswordResp)(nil), "api.VerifyPasswordResp")
}

func init() { proto.RegisterFile("api/api.proto", fileDescriptor_1b40cafcd4234784) }

var fileDescriptor_1b40cafcd4234784 = []byte{
	// 905 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0x8c, 0x56, 0xeb, 0x6e, 0xdb, 0x36,
	0x14, 0xb6, 0xad, 0xd8, 0x96, 0x8f, 0xef, 0x9c, 0x9b, 0xba, 0x2e, 0x06, 0xa4, 0x2c, 0x06, 0xa4,
	0x18, 0xe0, 0xac, 0x1d, 0xb0, 0x01, 0x2b, 0xd6, 0x5d, 0xd2, 0x6e, 0x2d, 0xb0, 0x0d, 0x85, 0x30,
	0xe7, 0xe7, 0x04, 0xc5, 0x3a, 0x4e, 0x88, 0x28, 0x92, 0x46, 0xd2, 0x71, 0xb2, 0x47, 0xd9, 0xdb,
	0xec, 0xd7, 0x5e, 0xab, 0x20, 0x45, 0x29, 0xba, 0x38, 0x71, 0xfe, 0xf9, 0x7c, 0xe2, 0xb9, 0x7d,
	0x87, 0xe7, 0xa3, 0xa1, 0xef, 0xc5, 0xec, 0xc8, 0x8b, 0xd9, 0x3c, 0xe6, 0x91, 0x8c, 0x88, 0xe5,
	0xc5, 0x8c, 0xfe, 0x57, 0x87, 0xd6, 0x71, 0xc0, 0x30, 0x94, 0x64, 0x00, 0x0d, 0xe6, 0x4f, 0xeb,
	0x07, 0xf5, 0xc3, 0x8e, 0xd3, 0x60, 0x3e, 0xd9, 0x87, 0x96, 0xc0, 0x25, 0x47, 0x39, 0x6d, 0x68,
	0xcc, 0x58, 0xe4, 0x39, 0xf4, 0x39, 0xfa, 0x8c, 0xe3, 0x52, 0xba, 0x6b, 0xce, 0xc4, 0xd4, 0x3a,
	0xb0, 0x0e, 0x3b, 0x4e, 0x2f, 0x05, 0x17, 0x9c, 0x09, 0x75, 0x48, 0xf2, 0xb5, 0x90, 0xe8, 0xbb,
	0x31, 0x22, 0x17, 0xd3, 0xbd, 0xe4, 0x90, 0x01, 0x3f, 0x2a, 0x4c, 0x65, 0x88, 0xd7, 0xa7, 0x01,
	0x5b, 0x4e, 0x9b, 0x07, 0xf5, 0x43, 0xdb, 0x31, 0x16, 0x21, 0xb0, 0x17, 0x7a, 0x97, 0x38, 0x6d,
	0xe9, 0xbc, 0xfa, 0x37, 0x79, 0x02, 0x76, 0x10, 0x9d, 0x45, 0xee, 0x9a, 0x07, 0xd3, 0xb6, 0xc6,
	0xdb, 0xca, 0x5e, 0xf0, 0x80, 0x7e, 0x03, 0xc3, 0x63, 0x8e, 0x9e, 0xc4, 0xa4, 0x11, 0x07, 0xff,
	0x26, 0xcf, 0xa1, 0xb5, 0xd4, 0x86, 0xee, 0xa7, 0xfb, 0xaa, 0x3b, 0x57, 0x7d, 0x9b, 0xef, 0xe6,
	0x13, 0xfd, 0x0b, 0x46, 0x45, 0x3f, 0x11, 0x93, 0x2f, 0x60, 0xe0, 0x05, 0x1c, 0x3d, 0xff, 0xc6,
	0xc5, 0x6b, 0x26, 0xa4, 0xd0, 0x01, 0x6c, 0xa7, 0x6f, 0xd0, 0x77, 0x1a, 0xcc, 0xc5, 0x6f, 0xdc,
	0x1d, 0xff, 0x19, 0x0c, 0xdf, 0x62, 0x80, 0xf9, 0xba, 0x4a, 0x1c, 0xd3, 0x23, 0x18, 0x15, 0x8f,
	0x88, 0x98, 0x3c, 0x85, 0x4e, 0x18, 0x49, 0x77, 0x15, 0xad, 0x43, 0xdf, 0x64, 0xb7, 0xc3, 0x48,
	0xfe, 0xa2, 0x6c, 0xfa, 0x6f, 0x1d, 0x86, 0x8b, 0xd8, 0xf7, 0xee, 0x09, 0x5a, 0x1d, 0x50, 0xe3,
	0x21, 0x03, 0xb2, 0xb6, 0x0c, 0x28, 0x1d, 0xc4, 0xde, 0x1d, 0x83, 0x68, 0x16, 0x07, 0x71, 0x04,
	0xa3, 0x62, 0x6d, 0xbb, 0xba, 0x61, 0x60, 0x7f, 0xf4, 0x84, 0xd8, 0x44, 0xdc, 0x27, 0x13, 0x68,
	0xe2, 0xa5, 0xc7, 0x02, 0xd3, 0x48, 0x62, 0xa8, 0x0a, 0xce, 0x3d, 0x71, 0xae, 0x69, 0xee, 0x39,
	0xfa, 0x37, 0x99, 0x81, 0xbd, 0x16, 0xc8, 0x75, 0x65, 0x96, 0x3e, 0x9c, 0xd9, 0xe4, 0x31, 0xb4,
	0xd5, 0x6f, 0x97, 0xf9, 0xa6, 0xe8, 0x96, 0x32, 0x3f, 0xf8, 0xf4, 0x0d, 0x8c, 0x93, 0x61, 0xa7,
	0x09, 0x15, 0x73, 0x2f, 0xc0, 0x8e, 0x8d, 0x69, 0x2e, 0x4a, 0x5f, 0x0f, 0x32, 0x3b, 0x93, 0x7d,
	0xa6, 0xaf, 0x81, 0x94, 0xfd, 0x1f, 0x7c, 0x5d, 0xe8, 0x19, 0x8c, 0x13, 0x62, 0xf2, 0xc9, 0xb7,
	0x37, 0xfc, 0x04, 0xec, 0x10, 0x37, 0x6e, 0xae, 0xe9, 0x76, 0x88, 0x9b, 0xf7, 0xaa, 0xef, 0x67,
	0xd0, 0x53, 0x9f, 0x4a, 0xbd, 0x77, 0x43, 0xdc, 0x2c, 0x0c, 0x44, 0x5f, 0x02, 0x29, 0x27, 0xda,
	0x35, 0x83, 0x17, 0x30, 0x4e, 0xae, 0xe0, 0xce, 0xda, 0x54, 0xf4, 0xf2, 0xd1, 0x5d, 0xd1, 0xc7,
	0x30, 0xfc, 0x8d, 0x09, 0x99, 0x8b, 0x4d, 0x7f, 0x80, 0x51, 0x11, 0x12, 0x31, 0xf9, 0x12, 0x3a,
	0x29, 0xd3, 0x8a, 0x42, 0xab, 0x3a, 0x89, 0xdb, 0xef, 0xb4, 0x07, 0x70, 0x82, 0x5c, 0xb0, 0x28,
	0x54, 0xe1, 0xbe, 0x85, 0x6e, 0x66, 0x89, 0x38, 0x51, 0x2d, 0x7e, 0x85, 0xdc, 0x94, 0x6e, 0x2c,
	0x32, 0x02, 0xa5, 0x77, 0x9a, 0xd2, 0xa6, 0xa3, 0xa5, 0xef, 0x1f, 0x18, 0x3a, 0xb8, 0xe2, 0x28,
	0xce, 0xff, 0x8c, 0x2e, 0x30, 0x74, 0x70, 0x55, 0xd9, 0xa4, 0xa7, 0xd0, 0x49, 0x76, 0x59, 0xdd,
	0xa7, 0x44, 0x05, 0xed, 0x04, 0xf8, 0xe0, 0x93, 0xcf, 0x01, 0x96, 0xfa, 0x46, 0xf8, 0xae, 0x27,
	0xf5, 0x2a, 0x58, 0x4e, 0xc7, 0x20, 0x3f, 0x49, 0xe5, 0x1b, 0x78, 0x42, 0xaa, 0x71, 0xf9, 0x5a,
	0xc9, 0x2c, 0xc7, 0x56, 0xc0, 0x42, 0xa0, 0x22, 0x7d, 0xa0, 0x38, 0x30, 0xf9, 0x15, 0xe3, 0xb9,
	0x8b, 0x5b, 0x2f, 0x5c, 0xdc, 0x3f, 0x12, 0x06, 0xb3, 0xa3, 0x22, 0x26, 0xaf, 0x61, 0xc0, 0x13,
	0xd3, 0x95, 0xaa, 0xf4, 0x94, 0xb2, 0x89, 0xa6, 0xac, 0xd4, 0x94, 0xd3, 0xe7, 0x39, 0x40, 0xd0,
	0xf7, 0x30, 0x72, 0xf0, 0x2a, 0xba, 0xc0, 0x07, 0x24, 0xbf, 0x97, 0x00, 0xfa, 0x15, 0x8c, 0x4b,
	0x91, 0x76, 0xdd, 0x86, 0x77, 0x30, 0x3e, 0x41, 0xce, 0x56, 0x37, 0xbb, 0xf7, 0x60, 0x96, 0x5b,
	0x4d, 0x93, 0x38, 0xdb, 0xc5, 0xdf, 0x81, 0x94, 0xc3, 0x88, 0x58, 0x79, 0x5c, 0x29, 0x94, 0x61,
	0x96, 0x38, 0xb5, 0x8b, 0x55, 0x35, 0x8a, 0x55, 0xbd, 0xfa, 0xbf, 0x09, 0xd6, 0x5b, 0xbc, 0x26,
	0xdf, 0x43, 0x2f, 0xff, 0x1e, 0x90, 0x84, 0xce, 0xd2, 0xd3, 0x32, 0x7b, 0xb4, 0x05, 0x15, 0x31,
	0xad, 0x29, 0xf7, 0xbc, 0xfa, 0x19, 0xf7, 0x92, 0x58, 0x1b, 0xf7, 0xb2, 0x4c, 0x26, 0xee, 0xf9,
	0xa7, 0xc0, 0xb8, 0x97, 0x1e, 0x10, 0xe3, 0x5e, 0x7e, 0x33, 0x68, 0x8d, 0x1c, 0xc3, 0xa0, 0xa8,
	0x4f, 0x64, 0x3f, 0x57, 0x68, 0x8e, 0xef, 0xd9, 0xe3, 0xad, 0x78, 0x1a, 0xa4, 0x28, 0x1f, 0x26,
	0x48, 0x45, 0xbc, 0x4c, 0x90, 0xaa, 0xd6, 0x24, 0x41, 0x8a, 0x2a, 0x61, 0x82, 0x54, 0x54, 0xc6,
	0x04, 0xa9, 0x4a, 0x0a, 0xad, 0x91, 0x37, 0xd0, 0xcf, 0x8b, 0x84, 0x30, 0x74, 0x94, 0xb4, 0xc4,
	0xd0, 0x51, 0x96, 0x13, 0x5a, 0x23, 0x2f, 0x01, 0x7e, 0x45, 0x69, 0x84, 0x81, 0x0c, 0xf5, 0xb1,
	0x5b, 0xd1, 0x98, 0x8d, 0x8a, 0x80, 0x76, 0xf9, 0x0e, 0xba, 0xb9, 0x45, 0x23, 0x9f, 0x65, 0xa1,
	0x6f, 0x17, 0x65, 0x36, 0xa9, 0x82, 0xda, 0xf7, 0x47, 0xe8, 0x17, 0x56, 0x81, 0x3c, 0x32, 0xab,
	0x58, 0x5c, 0xb4, 0xd9, 0xfe, 0x36, 0x38, 0x65, 0xad, 0x78, 0xa7, 0x0d, 0x6b, 0x95, 0x7d, 0x31,
	0xac, 0x55, 0x17, 0x80, 0xd6, 0x7e, 0x9e, 0x00, 0x59, 0x46, 0x97, 0xf3, 0x65, 0xc4, 0x31, 0x12,
	0x73, 0x1f, 0xaf, 0xd5, 0xd1, 0xd3, 0x96, 0xfe, 0xbf, 0xf7, 0xf5, 0xa7, 0x00, 0x00, 0x00, 0xff,
	0xff, 0x49, 0x46, 0x0e, 0xa3, 0x00, 0x0a, 0x00, 0x00,
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConn

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion4

// DexClient is the client API for Dex service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
type DexClient interface {
	// CreateClient creates a client.
	CreateClient(ctx context.Context, in *CreateClientReq, opts ...grpc.CallOption) (*CreateClientResp, error)
	// UpdateClient updates an existing client
	UpdateClient(ctx context.Context, in *UpdateClientReq, opts ...grpc.CallOption) (*UpdateClientResp, error)
	// DeleteClient deletes the provided client.
	DeleteClient(ctx context.Context, in *DeleteClientReq, opts ...grpc.CallOption) (*DeleteClientResp, error)
	// CreatePassword creates a password.
	CreatePassword(ctx context.Context, in *CreatePasswordReq, opts ...grpc.CallOption) (*CreatePasswordResp, error)
	// UpdatePassword modifies existing password.
	UpdatePassword(ctx context.Context, in *UpdatePasswordReq, opts ...grpc.CallOption) (*UpdatePasswordResp, error)
	// DeletePassword deletes the password.
	DeletePassword(ctx context.Context, in *DeletePasswordReq, opts ...grpc.CallOption) (*DeletePasswordResp, error)
	// ListPassword lists all password entries.
	ListPasswords(ctx context.Context, in *ListPasswordReq, opts ...grpc.CallOption) (*ListPasswordResp, error)
	// GetVersion returns version information of the server.
	GetVersion(ctx context.Context, in *VersionReq, opts ...grpc.CallOption) (*VersionResp, error)
	// ListRefresh lists all the refresh token entries for a particular user.
	ListRefresh(ctx context.Context, in *ListRefreshReq, opts ...grpc.CallOption) (*ListRefreshResp, error)
	// RevokeRefresh revokes the refresh token for the provided user-client pair.
	//
	// Note that each user-client pair can have only one refresh token at a time.
	RevokeRefresh(ctx context.Context, in *RevokeRefreshReq, opts ...grpc.CallOption) (*RevokeRefreshResp, error)
	// VerifyPassword returns whether a password matches a hash for a specific email or not.
	VerifyPassword(ctx context.Context, in *VerifyPasswordReq, opts ...grpc.CallOption) (*VerifyPasswordResp, error)
}

type dexClient struct {
	cc *grpc.ClientConn
}

func NewDexClient(cc *grpc.ClientConn) DexClient {
	return &dexClient{cc}
}

func (c *dexClient) CreateClient(ctx context.Context, in *CreateClientReq, opts ...grpc.CallOption) (*CreateClientResp, error) {
	out := new(CreateClientResp)
	err := c.cc.Invoke(ctx, "/api.Dex/CreateClient", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *dexClient) UpdateClient(ctx context.Context, in *UpdateClientReq, opts ...grpc.CallOption) (*UpdateClientResp, error) {
	out := new(UpdateClientResp)
	err := c.cc.Invoke(ctx, "/api.Dex/UpdateClient", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *dexClient) DeleteClient(ctx context.Context, in *DeleteClientReq, opts ...grpc.CallOption) (*DeleteClientResp, error) {
	out := new(DeleteClientResp)
	err := c.cc.Invoke(ctx, "/api.Dex/DeleteClient", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *dexClient) CreatePassword(ctx context.Context, in *CreatePasswordReq, opts ...grpc.CallOption) (*CreatePasswordResp, error) {
	out := new(CreatePasswordResp)
	err := c.cc.Invoke(ctx, "/api.Dex/CreatePassword", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *dexClient) UpdatePassword(ctx context.Context, in *UpdatePasswordReq, opts ...grpc.CallOption) (*UpdatePasswordResp, error) {
	out := new(UpdatePasswordResp)
	err := c.cc.Invoke(ctx, "/api.Dex/UpdatePassword", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *dexClient) DeletePassword(ctx context.Context, in *DeletePasswordReq, opts ...grpc.CallOption) (*DeletePasswordResp, error) {
	out := new(DeletePasswordResp)
	err := c.cc.Invoke(ctx, "/api.Dex/DeletePassword", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *dexClient) ListPasswords(ctx context.Context, in *ListPasswordReq, opts ...grpc.CallOption) (*ListPasswordResp, error) {
	out := new(ListPasswordResp)
	err := c.cc.Invoke(ctx, "/api.Dex/ListPasswords", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *dexClient) GetVersion(ctx context.Context, in *VersionReq, opts ...grpc.CallOption) (*VersionResp, error) {
	out := new(VersionResp)
	err := c.cc.Invoke(ctx, "/api.Dex/GetVersion", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *dexClient) ListRefresh(ctx context.Context, in *ListRefreshReq, opts ...grpc.CallOption) (*ListRefreshResp, error) {
	out := new(ListRefreshResp)
	err := c.cc.Invoke(ctx, "/api.Dex/ListRefresh", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *dexClient) RevokeRefresh(ctx context.Context, in *RevokeRefreshReq, opts ...grpc.CallOption) (*RevokeRefreshResp, error) {
	out := new(RevokeRefreshResp)
	err := c.cc.Invoke(ctx, "/api.Dex/RevokeRefresh", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *dexClient) VerifyPassword(ctx context.Context, in *VerifyPasswordReq, opts ...grpc.CallOption) (*VerifyPasswordResp, error) {
	out := new(VerifyPasswordResp)
	err := c.cc.Invoke(ctx, "/api.Dex/VerifyPassword", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// DexServer is the server API for Dex service.
type DexServer interface {
	// CreateClient creates a client.
	CreateClient(context.Context, *CreateClientReq) (*CreateClientResp, error)
	// UpdateClient updates an existing client
	UpdateClient(context.Context, *UpdateClientReq) (*UpdateClientResp, error)
	// DeleteClient deletes the provided client.
	DeleteClient(context.Context, *DeleteClientReq) (*DeleteClientResp, error)
	// CreatePassword creates a password.
	CreatePassword(context.Context, *CreatePasswordReq) (*CreatePasswordResp, error)
	// UpdatePassword modifies existing password.
	UpdatePassword(context.Context, *UpdatePasswordReq) (*UpdatePasswordResp, error)
	// DeletePassword deletes the password.
	DeletePassword(context.Context, *DeletePasswordReq) (*DeletePasswordResp, error)
	// ListPassword lists all password entries.
	ListPasswords(context.Context, *ListPasswordReq) (*ListPasswordResp, error)
	// GetVersion returns version information of the server.
	GetVersion(context.Context, *VersionReq) (*VersionResp, error)
	// ListRefresh lists all the refresh token entries for a particular user.
	ListRefresh(context.Context, *ListRefreshReq) (*ListRefreshResp, error)
	// RevokeRefresh revokes the refresh token for the provided user-client pair.
	//
	// Note that each user-client pair can have only one refresh token at a time.
	RevokeRefresh(context.Context, *RevokeRefreshReq) (*RevokeRefreshResp, error)
	// VerifyPassword returns whether a password matches a hash for a specific email or not.
	VerifyPassword(context.Context, *VerifyPasswordReq) (*VerifyPasswordResp, error)
}

// UnimplementedDexServer can be embedded to have forward compatible implementations.
type UnimplementedDexServer struct {
}

func (*UnimplementedDexServer) CreateClient(ctx context.Context, req *CreateClientReq) (*CreateClientResp, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateClient not implemented")
}
func (*UnimplementedDexServer) UpdateClient(ctx context.Context, req *UpdateClientReq) (*UpdateClientResp, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateClient not implemented")
}
func (*UnimplementedDexServer) DeleteClient(ctx context.Context, req *DeleteClientReq) (*DeleteClientResp, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteClient not implemented")
}
func (*UnimplementedDexServer) CreatePassword(ctx context.Context, req *CreatePasswordReq) (*CreatePasswordResp, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreatePassword not implemented")
}
func (*UnimplementedDexServer) UpdatePassword(ctx context.Context, req *UpdatePasswordReq) (*UpdatePasswordResp, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdatePassword not implemented")
}
func (*UnimplementedDexServer) DeletePassword(ctx context.Context, req *DeletePasswordReq) (*DeletePasswordResp, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeletePassword not implemented")
}
func (*UnimplementedDexServer) ListPasswords(ctx context.Context, req *ListPasswordReq) (*ListPasswordResp, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListPasswords not implemented")
}
func (*UnimplementedDexServer) GetVersion(ctx context.Context, req *VersionReq) (*VersionResp, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetVersion not implemented")
}
func (*UnimplementedDexServer) ListRefresh(ctx context.Context, req *ListRefreshReq) (*ListRefreshResp, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListRefresh not implemented")
}
func (*UnimplementedDexServer) RevokeRefresh(ctx context.Context, req *RevokeRefreshReq) (*RevokeRefreshResp, error) {
	return nil, status.Errorf(codes.Unimplemented, "method RevokeRefresh not implemented")
}
func (*UnimplementedDexServer) VerifyPassword(ctx context.Context, req *VerifyPasswordReq) (*VerifyPasswordResp, error) {
	return nil, status.Errorf(codes.Unimplemented, "method VerifyPassword not implemented")
}

func RegisterDexServer(s *grpc.Server, srv DexServer) {
	s.RegisterService(&_Dex_serviceDesc, srv)
}

func _Dex_CreateClient_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateClientReq)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DexServer).CreateClient(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/api.Dex/CreateClient",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DexServer).CreateClient(ctx, req.(*CreateClientReq))
	}
	return interceptor(ctx, in, info, handler)
}

func _Dex_UpdateClient_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateClientReq)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DexServer).UpdateClient(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/api.Dex/UpdateClient",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DexServer).UpdateClient(ctx, req.(*UpdateClientReq))
	}
	return interceptor(ctx, in, info, handler)
}

func _Dex_DeleteClient_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteClientReq)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DexServer).DeleteClient(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/api.Dex/DeleteClient",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DexServer).DeleteClient(ctx, req.(*DeleteClientReq))
	}
	return interceptor(ctx, in, info, handler)
}

func _Dex_CreatePassword_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreatePasswordReq)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DexServer).CreatePassword(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/api.Dex/CreatePassword",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DexServer).CreatePassword(ctx, req.(*CreatePasswordReq))
	}
	return interceptor(ctx, in, info, handler)
}

func _Dex_UpdatePassword_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdatePasswordReq)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DexServer).UpdatePassword(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/api.Dex/UpdatePassword",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DexServer).UpdatePassword(ctx, req.(*UpdatePasswordReq))
	}
	return interceptor(ctx, in, info, handler)
}

func _Dex_DeletePassword_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeletePasswordReq)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DexServer).DeletePassword(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/api.Dex/DeletePassword",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DexServer).DeletePassword(ctx, req.(*DeletePasswordReq))
	}
	return interceptor(ctx, in, info, handler)
}

func _Dex_ListPasswords_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListPasswordReq)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DexServer).ListPasswords(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/api.Dex/ListPasswords",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DexServer).ListPasswords(ctx, req.(*ListPasswordReq))
	}
	return interceptor(ctx, in, info, handler)
}

func _Dex_GetVersion_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(VersionReq)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DexServer).GetVersion(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/api.Dex/GetVersion",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DexServer).GetVersion(ctx, req.(*VersionReq))
	}
	return interceptor(ctx, in, info, handler)
}

func _Dex_ListRefresh_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListRefreshReq)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DexServer).ListRefresh(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/api.Dex/ListRefresh",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DexServer).ListRefresh(ctx, req.(*ListRefreshReq))
	}
	return interceptor(ctx, in, info, handler)
}

func _Dex_RevokeRefresh_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(RevokeRefreshReq)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DexServer).RevokeRefresh(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/api.Dex/RevokeRefresh",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DexServer).RevokeRefresh(ctx, req.(*RevokeRefreshReq))
	}
	return interceptor(ctx, in, info, handler)
}

func _Dex_VerifyPassword_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(VerifyPasswordReq)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DexServer).VerifyPassword(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/api.Dex/VerifyPassword",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DexServer).VerifyPassword(ctx, req.(*VerifyPasswordReq))
	}
	return interceptor(ctx, in, info, handler)
}

var _Dex_serviceDesc = grpc.ServiceDesc{
	ServiceName: "api.Dex",
	HandlerType: (*DexServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "CreateClient",
			Handler:    _Dex_CreateClient_Handler,
		},
		{
			MethodName: "UpdateClient",
			Handler:    _Dex_UpdateClient_Handler,
		},
		{
			MethodName: "DeleteClient",
			Handler:    _Dex_DeleteClient_Handler,
		},
		{
			MethodName: "CreatePassword",
			Handler:    _Dex_CreatePassword_Handler,
		},
		{
			MethodName: "UpdatePassword",
			Handler:    _Dex_UpdatePassword_Handler,
		},
		{
			MethodName: "DeletePassword",
			Handler:    _Dex_DeletePassword_Handler,
		},
		{
			MethodName: "ListPasswords",
			Handler:    _Dex_ListPasswords_Handler,
		},
		{
			MethodName: "GetVersion",
			Handler:    _Dex_GetVersion_Handler,
		},
		{
			MethodName: "ListRefresh",
			Handler:    _Dex_ListRefresh_Handler,
		},
		{
			MethodName: "RevokeRefresh",
			Handler:    _Dex_RevokeRefresh_Handler,
		},
		{
			MethodName: "VerifyPassword",
			Handler:    _Dex_VerifyPassword_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "api/api.proto",
}
