// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package eventbridge

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type ListRuleNamesByTargetInput struct {
	_ struct{} `type:"structure"`

	// Limits the results to show only the rules associated with the specified event
	// bus.
	EventBusName *string `min:"1" type:"string"`

	// The maximum number of results to return.
	Limit *int64 `min:"1" type:"integer"`

	// The token returned by a previous call to retrieve the next set of results.
	NextToken *string `min:"1" type:"string"`

	// The Amazon Resource Name (ARN) of the target resource.
	//
	// TargetArn is a required field
	TargetArn *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s ListRuleNamesByTargetInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListRuleNamesByTargetInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "ListRuleNamesByTargetInput"}
	if s.EventBusName != nil && len(*s.EventBusName) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("EventBusName", 1))
	}
	if s.Limit != nil && *s.Limit < 1 {
		invalidParams.Add(aws.NewErrParamMinValue("Limit", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("NextToken", 1))
	}

	if s.TargetArn == nil {
		invalidParams.Add(aws.NewErrParamRequired("TargetArn"))
	}
	if s.TargetArn != nil && len(*s.TargetArn) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("TargetArn", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type ListRuleNamesByTargetOutput struct {
	_ struct{} `type:"structure"`

	// Indicates whether there are additional results to retrieve. If there are
	// no more results, the value is null.
	NextToken *string `min:"1" type:"string"`

	// The names of the rules that can invoke the given target.
	RuleNames []string `type:"list"`
}

// String returns the string representation
func (s ListRuleNamesByTargetOutput) String() string {
	return awsutil.Prettify(s)
}

const opListRuleNamesByTarget = "ListRuleNamesByTarget"

// ListRuleNamesByTargetRequest returns a request value for making API operation for
// Amazon EventBridge.
//
// Lists the rules for the specified target. You can see which rules can invoke
// a specific target in your account.
//
//    // Example sending a request using ListRuleNamesByTargetRequest.
//    req := client.ListRuleNamesByTargetRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/eventbridge-2015-10-07/ListRuleNamesByTarget
func (c *Client) ListRuleNamesByTargetRequest(input *ListRuleNamesByTargetInput) ListRuleNamesByTargetRequest {
	op := &aws.Operation{
		Name:       opListRuleNamesByTarget,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ListRuleNamesByTargetInput{}
	}

	req := c.newRequest(op, input, &ListRuleNamesByTargetOutput{})
	return ListRuleNamesByTargetRequest{Request: req, Input: input, Copy: c.ListRuleNamesByTargetRequest}
}

// ListRuleNamesByTargetRequest is the request type for the
// ListRuleNamesByTarget API operation.
type ListRuleNamesByTargetRequest struct {
	*aws.Request
	Input *ListRuleNamesByTargetInput
	Copy  func(*ListRuleNamesByTargetInput) ListRuleNamesByTargetRequest
}

// Send marshals and sends the ListRuleNamesByTarget API request.
func (r ListRuleNamesByTargetRequest) Send(ctx context.Context) (*ListRuleNamesByTargetResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &ListRuleNamesByTargetResponse{
		ListRuleNamesByTargetOutput: r.Request.Data.(*ListRuleNamesByTargetOutput),
		response:                    &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// ListRuleNamesByTargetResponse is the response type for the
// ListRuleNamesByTarget API operation.
type ListRuleNamesByTargetResponse struct {
	*ListRuleNamesByTargetOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// ListRuleNamesByTarget request.
func (r *ListRuleNamesByTargetResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
