// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package kendra

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
	"github.com/aws/aws-sdk-go-v2/private/protocol/jsonrpc"
)

type DeleteFaqInput struct {
	_ struct{} `type:"structure"`

	// The identifier of the FAQ to remove.
	//
	// Id is a required field
	Id *string `min:"1" type:"string" required:"true"`

	// The index to remove the FAQ from.
	//
	// IndexId is a required field
	IndexId *string `min:"36" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteFaqInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteFaqInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "DeleteFaqInput"}

	if s.Id == nil {
		invalidParams.Add(aws.NewErrParamRequired("Id"))
	}
	if s.Id != nil && len(*s.Id) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("Id", 1))
	}

	if s.IndexId == nil {
		invalidParams.Add(aws.NewErrParamRequired("IndexId"))
	}
	if s.IndexId != nil && len(*s.IndexId) < 36 {
		invalidParams.Add(aws.NewErrParamMinLen("IndexId", 36))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type DeleteFaqOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteFaqOutput) String() string {
	return awsutil.Prettify(s)
}

const opDeleteFaq = "DeleteFaq"

// DeleteFaqRequest returns a request value for making API operation for
// AWSKendraFrontendService.
//
// Removes an FAQ from an index.
//
//    // Example sending a request using DeleteFaqRequest.
//    req := client.DeleteFaqRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/kendra-2019-02-03/DeleteFaq
func (c *Client) DeleteFaqRequest(input *DeleteFaqInput) DeleteFaqRequest {
	op := &aws.Operation{
		Name:       opDeleteFaq,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteFaqInput{}
	}

	req := c.newRequest(op, input, &DeleteFaqOutput{})
	req.Handlers.Unmarshal.Remove(jsonrpc.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)
	return DeleteFaqRequest{Request: req, Input: input, Copy: c.DeleteFaqRequest}
}

// DeleteFaqRequest is the request type for the
// DeleteFaq API operation.
type DeleteFaqRequest struct {
	*aws.Request
	Input *DeleteFaqInput
	Copy  func(*DeleteFaqInput) DeleteFaqRequest
}

// Send marshals and sends the DeleteFaq API request.
func (r DeleteFaqRequest) Send(ctx context.Context) (*DeleteFaqResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &DeleteFaqResponse{
		DeleteFaqOutput: r.Request.Data.(*DeleteFaqOutput),
		response:        &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// DeleteFaqResponse is the response type for the
// DeleteFaq API operation.
type DeleteFaqResponse struct {
	*DeleteFaqOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// DeleteFaq request.
func (r *DeleteFaqResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
