// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package kms

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type SignInput struct {
	_ struct{} `type:"structure"`

	// A list of grant tokens.
	//
	// For more information, see Grant Tokens (https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#grant_token)
	// in the AWS Key Management Service Developer Guide.
	GrantTokens []string `type:"list"`

	// Identifies an asymmetric CMK. AWS KMS uses the private key in the asymmetric
	// CMK to sign the message. The KeyUsage type of the CMK must be SIGN_VERIFY.
	// To find the KeyUsage of a CMK, use the DescribeKey operation.
	//
	// To specify a CMK, use its key ID, Amazon Resource Name (ARN), alias name,
	// or alias ARN. When using an alias name, prefix it with "alias/". To specify
	// a CMK in a different AWS account, you must use the key ARN or alias ARN.
	//
	// For example:
	//
	//    * Key ID: 1234abcd-12ab-34cd-56ef-1234567890ab
	//
	//    * Key ARN: arn:aws:kms:us-east-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab
	//
	//    * Alias name: alias/ExampleAlias
	//
	//    * Alias ARN: arn:aws:kms:us-east-2:111122223333:alias/ExampleAlias
	//
	// To get the key ID and key ARN for a CMK, use ListKeys or DescribeKey. To
	// get the alias name and alias ARN, use ListAliases.
	//
	// KeyId is a required field
	KeyId *string `min:"1" type:"string" required:"true"`

	// Specifies the message or message digest to sign. Messages can be 0-4096 bytes.
	// To sign a larger message, provide the message digest.
	//
	// If you provide a message, AWS KMS generates a hash digest of the message
	// and then signs it.
	//
	// Message is automatically base64 encoded/decoded by the SDK.
	//
	// Message is a required field
	Message []byte `min:"1" type:"blob" required:"true" sensitive:"true"`

	// Tells AWS KMS whether the value of the Message parameter is a message or
	// message digest. To indicate a message, enter RAW. To indicate a message digest,
	// enter DIGEST.
	MessageType MessageType `type:"string" enum:"true"`

	// Specifies the signing algorithm to use when signing the message.
	//
	// Choose an algorithm that is compatible with the type and size of the specified
	// asymmetric CMK.
	//
	// SigningAlgorithm is a required field
	SigningAlgorithm SigningAlgorithmSpec `type:"string" required:"true" enum:"true"`
}

// String returns the string representation
func (s SignInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *SignInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "SignInput"}

	if s.KeyId == nil {
		invalidParams.Add(aws.NewErrParamRequired("KeyId"))
	}
	if s.KeyId != nil && len(*s.KeyId) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("KeyId", 1))
	}

	if s.Message == nil {
		invalidParams.Add(aws.NewErrParamRequired("Message"))
	}
	if s.Message != nil && len(s.Message) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("Message", 1))
	}
	if len(s.SigningAlgorithm) == 0 {
		invalidParams.Add(aws.NewErrParamRequired("SigningAlgorithm"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type SignOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the asymmetric CMK that was used to sign
	// the message.
	KeyId *string `min:"1" type:"string"`

	// The cryptographic signature that was generated for the message.
	//
	// Signature is automatically base64 encoded/decoded by the SDK.
	Signature []byte `min:"1" type:"blob"`

	// The signing algorithm that was used to sign the message.
	SigningAlgorithm SigningAlgorithmSpec `type:"string" enum:"true"`
}

// String returns the string representation
func (s SignOutput) String() string {
	return awsutil.Prettify(s)
}

const opSign = "Sign"

// SignRequest returns a request value for making API operation for
// AWS Key Management Service.
//
// Creates a digital signature (https://en.wikipedia.org/wiki/Digital_signature)
// for a message or message digest by using the private key in an asymmetric
// CMK. To verify the signature, use the Verify operation, or use the public
// key in the same asymmetric CMK outside of AWS KMS. For information about
// symmetric and asymmetric CMKs, see Using Symmetric and Asymmetric CMKs (https://docs.aws.amazon.com/kms/latest/developerguide/symmetric-asymmetric.html)
// in the AWS Key Management Service Developer Guide.
//
// Digital signatures are generated and verified by using asymmetric key pair,
// such as an RSA or ECC pair that is represented by an asymmetric customer
// master key (CMK). The key owner (or an authorized user) uses their private
// key to sign a message. Anyone with the public key can verify that the message
// was signed with that particular private key and that the message hasn't changed
// since it was signed.
//
// To use the Sign operation, provide the following information:
//
//    * Use the KeyId parameter to identify an asymmetric CMK with a KeyUsage
//    value of SIGN_VERIFY. To get the KeyUsage value of a CMK, use the DescribeKey
//    operation. The caller must have kms:Sign permission on the CMK.
//
//    * Use the Message parameter to specify the message or message digest to
//    sign. You can submit messages of up to 4096 bytes. To sign a larger message,
//    generate a hash digest of the message, and then provide the hash digest
//    in the Message parameter. To indicate whether the message is a full message
//    or a digest, use the MessageType parameter.
//
//    * Choose a signing algorithm that is compatible with the CMK.
//
// When signing a message, be sure to record the CMK and the signing algorithm.
// This information is required to verify the signature.
//
// To verify the signature that this operation generates, use the Verify operation.
// Or use the GetPublicKey operation to download the public key and then use
// the public key to verify the signature outside of AWS KMS.
//
// The CMK that you use for this operation must be in a compatible key state.
// For details, see How Key State Affects Use of a Customer Master Key (https://docs.aws.amazon.com/kms/latest/developerguide/key-state.html)
// in the AWS Key Management Service Developer Guide.
//
//    // Example sending a request using SignRequest.
//    req := client.SignRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/kms-2014-11-01/Sign
func (c *Client) SignRequest(input *SignInput) SignRequest {
	op := &aws.Operation{
		Name:       opSign,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &SignInput{}
	}

	req := c.newRequest(op, input, &SignOutput{})
	return SignRequest{Request: req, Input: input, Copy: c.SignRequest}
}

// SignRequest is the request type for the
// Sign API operation.
type SignRequest struct {
	*aws.Request
	Input *SignInput
	Copy  func(*SignInput) SignRequest
}

// Send marshals and sends the Sign API request.
func (r SignRequest) Send(ctx context.Context) (*SignResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &SignResponse{
		SignOutput: r.Request.Data.(*SignOutput),
		response:   &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// SignResponse is the response type for the
// Sign API operation.
type SignResponse struct {
	*SignOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// Sign request.
func (r *SignResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
