// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package sms

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type DeleteAppInput struct {
	_ struct{} `type:"structure"`

	// ID of the application to delete.
	AppId *string `locationName:"appId" type:"string"`

	// While deleting the application, stop all replication jobs corresponding to
	// the servers in the application.
	ForceStopAppReplication *bool `locationName:"forceStopAppReplication" type:"boolean"`

	// While deleting the application, terminate the stack corresponding to the
	// application.
	ForceTerminateApp *bool `locationName:"forceTerminateApp" type:"boolean"`
}

// String returns the string representation
func (s DeleteAppInput) String() string {
	return awsutil.Prettify(s)
}

type DeleteAppOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteAppOutput) String() string {
	return awsutil.Prettify(s)
}

const opDeleteApp = "DeleteApp"

// DeleteAppRequest returns a request value for making API operation for
// AWS Server Migration Service.
//
// Deletes an existing application. Optionally deletes the launched stack associated
// with the application and all AWS SMS replication jobs for servers in the
// application.
//
//    // Example sending a request using DeleteAppRequest.
//    req := client.DeleteAppRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/sms-2016-10-24/DeleteApp
func (c *Client) DeleteAppRequest(input *DeleteAppInput) DeleteAppRequest {
	op := &aws.Operation{
		Name:       opDeleteApp,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteAppInput{}
	}

	req := c.newRequest(op, input, &DeleteAppOutput{})
	return DeleteAppRequest{Request: req, Input: input, Copy: c.DeleteAppRequest}
}

// DeleteAppRequest is the request type for the
// DeleteApp API operation.
type DeleteAppRequest struct {
	*aws.Request
	Input *DeleteAppInput
	Copy  func(*DeleteAppInput) DeleteAppRequest
}

// Send marshals and sends the DeleteApp API request.
func (r DeleteAppRequest) Send(ctx context.Context) (*DeleteAppResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &DeleteAppResponse{
		DeleteAppOutput: r.Request.Data.(*DeleteAppOutput),
		response:        &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// DeleteAppResponse is the response type for the
// DeleteApp API operation.
type DeleteAppResponse struct {
	*DeleteAppOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// DeleteApp request.
func (r *DeleteAppResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
