package migrate

// Copyright (c) Microsoft and contributors.  All rights reserved.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
// http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//
// See the License for the specific language governing permissions and
// limitations under the License.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"context"
	"github.com/Azure/go-autorest/autorest"
	"github.com/Azure/go-autorest/autorest/azure"
	"github.com/Azure/go-autorest/tracing"
	"net/http"
)

// MachinesClient is the migrate your workloads to Azure.
type MachinesClient struct {
	BaseClient
}

// NewMachinesClient creates an instance of the MachinesClient client.
func NewMachinesClient(subscriptionID string, acceptLanguage string) MachinesClient {
	return NewMachinesClientWithBaseURI(DefaultBaseURI, subscriptionID, acceptLanguage)
}

// NewMachinesClientWithBaseURI creates an instance of the MachinesClient client using a custom endpoint.  Use this
// when interacting with an Azure cloud that uses a non-standard base URI (sovereign clouds, Azure stack).
func NewMachinesClientWithBaseURI(baseURI string, subscriptionID string, acceptLanguage string) MachinesClient {
	return MachinesClient{NewWithBaseURI(baseURI, subscriptionID, acceptLanguage)}
}

// EnumerateMachines sends the enumerate machines request.
// Parameters:
// resourceGroupName - name of the Azure Resource Group that migrate project is part of.
// migrateProjectName - name of the Azure Migrate project.
// continuationToken - the continuation token.
// pageSize - the number of items to be returned in a single page. This value is honored only if it is less
// than the 100.
func (client MachinesClient) EnumerateMachines(ctx context.Context, resourceGroupName string, migrateProjectName string, continuationToken string, pageSize *int32) (result MachineCollection, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/MachinesClient.EnumerateMachines")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	req, err := client.EnumerateMachinesPreparer(ctx, resourceGroupName, migrateProjectName, continuationToken, pageSize)
	if err != nil {
		err = autorest.NewErrorWithError(err, "migrate.MachinesClient", "EnumerateMachines", nil, "Failure preparing request")
		return
	}

	resp, err := client.EnumerateMachinesSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "migrate.MachinesClient", "EnumerateMachines", resp, "Failure sending request")
		return
	}

	result, err = client.EnumerateMachinesResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "migrate.MachinesClient", "EnumerateMachines", resp, "Failure responding to request")
	}

	return
}

// EnumerateMachinesPreparer prepares the EnumerateMachines request.
func (client MachinesClient) EnumerateMachinesPreparer(ctx context.Context, resourceGroupName string, migrateProjectName string, continuationToken string, pageSize *int32) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"migrateProjectName": autorest.Encode("path", migrateProjectName),
		"resourceGroupName":  autorest.Encode("path", resourceGroupName),
		"subscriptionId":     autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2018-09-01-preview"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}
	if len(continuationToken) > 0 {
		queryParameters["continuationToken"] = autorest.Encode("query", continuationToken)
	}
	if pageSize != nil {
		queryParameters["pageSize"] = autorest.Encode("query", *pageSize)
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Migrate/migrateProjects/{migrateProjectName}/machines", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// EnumerateMachinesSender sends the EnumerateMachines request. The method will close the
// http.Response Body if it receives an error.
func (client MachinesClient) EnumerateMachinesSender(req *http.Request) (*http.Response, error) {
	sd := autorest.GetSendDecorators(req.Context(), azure.DoRetryWithRegistration(client.Client))
	return autorest.SendWithSender(client, req, sd...)
}

// EnumerateMachinesResponder handles the response to the EnumerateMachines request. The method always
// closes the http.Response Body.
func (client MachinesClient) EnumerateMachinesResponder(resp *http.Response) (result MachineCollection, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// GetMachine sends the get machine request.
// Parameters:
// resourceGroupName - name of the Azure Resource Group that migrate project is part of.
// migrateProjectName - name of the Azure Migrate project.
// machineName - unique name of a machine in Azure migration hub.
func (client MachinesClient) GetMachine(ctx context.Context, resourceGroupName string, migrateProjectName string, machineName string) (result Machine, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/MachinesClient.GetMachine")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	req, err := client.GetMachinePreparer(ctx, resourceGroupName, migrateProjectName, machineName)
	if err != nil {
		err = autorest.NewErrorWithError(err, "migrate.MachinesClient", "GetMachine", nil, "Failure preparing request")
		return
	}

	resp, err := client.GetMachineSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "migrate.MachinesClient", "GetMachine", resp, "Failure sending request")
		return
	}

	result, err = client.GetMachineResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "migrate.MachinesClient", "GetMachine", resp, "Failure responding to request")
	}

	return
}

// GetMachinePreparer prepares the GetMachine request.
func (client MachinesClient) GetMachinePreparer(ctx context.Context, resourceGroupName string, migrateProjectName string, machineName string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"machineName":        autorest.Encode("path", machineName),
		"migrateProjectName": autorest.Encode("path", migrateProjectName),
		"resourceGroupName":  autorest.Encode("path", resourceGroupName),
		"subscriptionId":     autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2018-09-01-preview"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Migrate/migrateProjects/{migrateProjectName}/machines/{machineName}", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// GetMachineSender sends the GetMachine request. The method will close the
// http.Response Body if it receives an error.
func (client MachinesClient) GetMachineSender(req *http.Request) (*http.Response, error) {
	sd := autorest.GetSendDecorators(req.Context(), azure.DoRetryWithRegistration(client.Client))
	return autorest.SendWithSender(client, req, sd...)
}

// GetMachineResponder handles the response to the GetMachine request. The method always
// closes the http.Response Body.
func (client MachinesClient) GetMachineResponder(resp *http.Response) (result Machine, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}
