// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package acm

import (
	"context"
	"fmt"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
	"github.com/aws/aws-sdk-go-v2/private/protocol/jsonrpc"
)

type RemoveTagsFromCertificateInput struct {
	_ struct{} `type:"structure"`

	// String that contains the ARN of the ACM Certificate with one or more tags
	// that you want to remove. This must be of the form:
	//
	// arn:aws:acm:region:123456789012:certificate/12345678-1234-1234-1234-123456789012
	//
	// For more information about ARNs, see Amazon Resource Names (ARNs) and AWS
	// Service Namespaces (https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html).
	//
	// CertificateArn is a required field
	CertificateArn *string `min:"20" type:"string" required:"true"`

	// The key-value pair that defines the tag to remove.
	//
	// Tags is a required field
	Tags []Tag `min:"1" type:"list" required:"true"`
}

// String returns the string representation
func (s RemoveTagsFromCertificateInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *RemoveTagsFromCertificateInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "RemoveTagsFromCertificateInput"}

	if s.CertificateArn == nil {
		invalidParams.Add(aws.NewErrParamRequired("CertificateArn"))
	}
	if s.CertificateArn != nil && len(*s.CertificateArn) < 20 {
		invalidParams.Add(aws.NewErrParamMinLen("CertificateArn", 20))
	}

	if s.Tags == nil {
		invalidParams.Add(aws.NewErrParamRequired("Tags"))
	}
	if s.Tags != nil && len(s.Tags) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("Tags", 1))
	}
	if s.Tags != nil {
		for i, v := range s.Tags {
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Tags", i), err.(aws.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type RemoveTagsFromCertificateOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s RemoveTagsFromCertificateOutput) String() string {
	return awsutil.Prettify(s)
}

const opRemoveTagsFromCertificate = "RemoveTagsFromCertificate"

// RemoveTagsFromCertificateRequest returns a request value for making API operation for
// AWS Certificate Manager.
//
// Remove one or more tags from an ACM certificate. A tag consists of a key-value
// pair. If you do not specify the value portion of the tag when calling this
// function, the tag will be removed regardless of value. If you specify a value,
// the tag is removed only if it is associated with the specified value.
//
// To add tags to a certificate, use the AddTagsToCertificate action. To view
// all of the tags that have been applied to a specific ACM certificate, use
// the ListTagsForCertificate action.
//
//    // Example sending a request using RemoveTagsFromCertificateRequest.
//    req := client.RemoveTagsFromCertificateRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/acm-2015-12-08/RemoveTagsFromCertificate
func (c *Client) RemoveTagsFromCertificateRequest(input *RemoveTagsFromCertificateInput) RemoveTagsFromCertificateRequest {
	op := &aws.Operation{
		Name:       opRemoveTagsFromCertificate,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &RemoveTagsFromCertificateInput{}
	}

	req := c.newRequest(op, input, &RemoveTagsFromCertificateOutput{})
	req.Handlers.Unmarshal.Remove(jsonrpc.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)
	return RemoveTagsFromCertificateRequest{Request: req, Input: input, Copy: c.RemoveTagsFromCertificateRequest}
}

// RemoveTagsFromCertificateRequest is the request type for the
// RemoveTagsFromCertificate API operation.
type RemoveTagsFromCertificateRequest struct {
	*aws.Request
	Input *RemoveTagsFromCertificateInput
	Copy  func(*RemoveTagsFromCertificateInput) RemoveTagsFromCertificateRequest
}

// Send marshals and sends the RemoveTagsFromCertificate API request.
func (r RemoveTagsFromCertificateRequest) Send(ctx context.Context) (*RemoveTagsFromCertificateResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &RemoveTagsFromCertificateResponse{
		RemoveTagsFromCertificateOutput: r.Request.Data.(*RemoveTagsFromCertificateOutput),
		response:                        &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// RemoveTagsFromCertificateResponse is the response type for the
// RemoveTagsFromCertificate API operation.
type RemoveTagsFromCertificateResponse struct {
	*RemoveTagsFromCertificateOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// RemoveTagsFromCertificate request.
func (r *RemoveTagsFromCertificateResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
