// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package cognitoidentityprovider

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type SetUserMFAPreferenceInput struct {
	_ struct{} `type:"structure"`

	// The access token for the user.
	//
	// AccessToken is a required field
	AccessToken *string `type:"string" required:"true" sensitive:"true"`

	// The SMS text message multi-factor authentication (MFA) settings.
	SMSMfaSettings *SMSMfaSettingsType `type:"structure"`

	// The time-based one-time password software token MFA settings.
	SoftwareTokenMfaSettings *SoftwareTokenMfaSettingsType `type:"structure"`
}

// String returns the string representation
func (s SetUserMFAPreferenceInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *SetUserMFAPreferenceInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "SetUserMFAPreferenceInput"}

	if s.AccessToken == nil {
		invalidParams.Add(aws.NewErrParamRequired("AccessToken"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type SetUserMFAPreferenceOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s SetUserMFAPreferenceOutput) String() string {
	return awsutil.Prettify(s)
}

const opSetUserMFAPreference = "SetUserMFAPreference"

// SetUserMFAPreferenceRequest returns a request value for making API operation for
// Amazon Cognito Identity Provider.
//
// Set the user's multi-factor authentication (MFA) method preference, including
// which MFA factors are enabled and if any are preferred. Only one factor can
// be set as preferred. The preferred MFA factor will be used to authenticate
// a user if multiple factors are enabled. If multiple options are enabled and
// no preference is set, a challenge to choose an MFA option will be returned
// during sign in.
//
//    // Example sending a request using SetUserMFAPreferenceRequest.
//    req := client.SetUserMFAPreferenceRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/SetUserMFAPreference
func (c *Client) SetUserMFAPreferenceRequest(input *SetUserMFAPreferenceInput) SetUserMFAPreferenceRequest {
	op := &aws.Operation{
		Name:       opSetUserMFAPreference,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &SetUserMFAPreferenceInput{}
	}

	req := c.newRequest(op, input, &SetUserMFAPreferenceOutput{})
	return SetUserMFAPreferenceRequest{Request: req, Input: input, Copy: c.SetUserMFAPreferenceRequest}
}

// SetUserMFAPreferenceRequest is the request type for the
// SetUserMFAPreference API operation.
type SetUserMFAPreferenceRequest struct {
	*aws.Request
	Input *SetUserMFAPreferenceInput
	Copy  func(*SetUserMFAPreferenceInput) SetUserMFAPreferenceRequest
}

// Send marshals and sends the SetUserMFAPreference API request.
func (r SetUserMFAPreferenceRequest) Send(ctx context.Context) (*SetUserMFAPreferenceResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &SetUserMFAPreferenceResponse{
		SetUserMFAPreferenceOutput: r.Request.Data.(*SetUserMFAPreferenceOutput),
		response:                   &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// SetUserMFAPreferenceResponse is the response type for the
// SetUserMFAPreference API operation.
type SetUserMFAPreferenceResponse struct {
	*SetUserMFAPreferenceOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// SetUserMFAPreference request.
func (r *SetUserMFAPreferenceResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
