// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package datapipeline

import (
	"context"
	"fmt"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

// Contains the parameters for PutPipelineDefinition.
type PutPipelineDefinitionInput struct {
	_ struct{} `type:"structure"`

	// The parameter objects used with the pipeline.
	ParameterObjects []ParameterObject `locationName:"parameterObjects" type:"list"`

	// The parameter values used with the pipeline.
	ParameterValues []ParameterValue `locationName:"parameterValues" type:"list"`

	// The ID of the pipeline.
	//
	// PipelineId is a required field
	PipelineId *string `locationName:"pipelineId" min:"1" type:"string" required:"true"`

	// The objects that define the pipeline. These objects overwrite the existing
	// pipeline definition.
	//
	// PipelineObjects is a required field
	PipelineObjects []PipelineObject `locationName:"pipelineObjects" type:"list" required:"true"`
}

// String returns the string representation
func (s PutPipelineDefinitionInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *PutPipelineDefinitionInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "PutPipelineDefinitionInput"}

	if s.PipelineId == nil {
		invalidParams.Add(aws.NewErrParamRequired("PipelineId"))
	}
	if s.PipelineId != nil && len(*s.PipelineId) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("PipelineId", 1))
	}

	if s.PipelineObjects == nil {
		invalidParams.Add(aws.NewErrParamRequired("PipelineObjects"))
	}
	if s.ParameterObjects != nil {
		for i, v := range s.ParameterObjects {
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "ParameterObjects", i), err.(aws.ErrInvalidParams))
			}
		}
	}
	if s.ParameterValues != nil {
		for i, v := range s.ParameterValues {
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "ParameterValues", i), err.(aws.ErrInvalidParams))
			}
		}
	}
	if s.PipelineObjects != nil {
		for i, v := range s.PipelineObjects {
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "PipelineObjects", i), err.(aws.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Contains the output of PutPipelineDefinition.
type PutPipelineDefinitionOutput struct {
	_ struct{} `type:"structure"`

	// Indicates whether there were validation errors, and the pipeline definition
	// is stored but cannot be activated until you correct the pipeline and call
	// PutPipelineDefinition to commit the corrected pipeline.
	//
	// Errored is a required field
	Errored *bool `locationName:"errored" type:"boolean" required:"true"`

	// The validation errors that are associated with the objects defined in pipelineObjects.
	ValidationErrors []ValidationError `locationName:"validationErrors" type:"list"`

	// The validation warnings that are associated with the objects defined in pipelineObjects.
	ValidationWarnings []ValidationWarning `locationName:"validationWarnings" type:"list"`
}

// String returns the string representation
func (s PutPipelineDefinitionOutput) String() string {
	return awsutil.Prettify(s)
}

const opPutPipelineDefinition = "PutPipelineDefinition"

// PutPipelineDefinitionRequest returns a request value for making API operation for
// AWS Data Pipeline.
//
// Adds tasks, schedules, and preconditions to the specified pipeline. You can
// use PutPipelineDefinition to populate a new pipeline.
//
// PutPipelineDefinition also validates the configuration as it adds it to the
// pipeline. Changes to the pipeline are saved unless one of the following three
// validation errors exists in the pipeline.
//   An object is missing a name or identifier field. A string or reference
//   field is empty. The number of objects in the pipeline exceeds the maximum
//   allowed objects. The pipeline is in a FINISHED state.
// Pipeline object definitions are passed to the PutPipelineDefinition action
// and returned by the GetPipelineDefinition action.
//
//    // Example sending a request using PutPipelineDefinitionRequest.
//    req := client.PutPipelineDefinitionRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/datapipeline-2012-10-29/PutPipelineDefinition
func (c *Client) PutPipelineDefinitionRequest(input *PutPipelineDefinitionInput) PutPipelineDefinitionRequest {
	op := &aws.Operation{
		Name:       opPutPipelineDefinition,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &PutPipelineDefinitionInput{}
	}

	req := c.newRequest(op, input, &PutPipelineDefinitionOutput{})
	return PutPipelineDefinitionRequest{Request: req, Input: input, Copy: c.PutPipelineDefinitionRequest}
}

// PutPipelineDefinitionRequest is the request type for the
// PutPipelineDefinition API operation.
type PutPipelineDefinitionRequest struct {
	*aws.Request
	Input *PutPipelineDefinitionInput
	Copy  func(*PutPipelineDefinitionInput) PutPipelineDefinitionRequest
}

// Send marshals and sends the PutPipelineDefinition API request.
func (r PutPipelineDefinitionRequest) Send(ctx context.Context) (*PutPipelineDefinitionResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &PutPipelineDefinitionResponse{
		PutPipelineDefinitionOutput: r.Request.Data.(*PutPipelineDefinitionOutput),
		response:                    &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// PutPipelineDefinitionResponse is the response type for the
// PutPipelineDefinition API operation.
type PutPipelineDefinitionResponse struct {
	*PutPipelineDefinitionOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// PutPipelineDefinition request.
func (r *PutPipelineDefinitionResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
