//
// Copyright (c) 2020 huihui <huihui.fu@cs2c.com.cn>.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//   http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
//

package examples

import (
	"fmt"
	"os"
	"time"

	ovirtsdk4 "github.com/ovirt/go-ovirt"
)

func downloadVmOvf() {
	inputRawURL := "https://10.1.111.229/ovirt-engine/api"

	conn, err := ovirtsdk4.NewConnectionBuilder().
		URL(inputRawURL).
		Username("admin@internal").
		Password("qwer1234").
		Insecure(true).
		Compress(true).
		Timeout(time.Second * 10).
		Build()
	if err != nil {
		fmt.Printf("Make connection failed, reason: %v\n", err)
		return
	}
	defer conn.Close()

	// To use `Must` methods, you should recover it if panics
	defer func() {
		if err := recover(); err != nil {
			fmt.Printf("Panics occurs, try the non-Must methods to find the reason")
		}
	}()

	// Get a reference to the vm service:
	vmsService := conn.SystemService().VmsService()

	//# Look up fot the vm by name:
	vmResp, err := vmsService.List().
		Search("name=myvm").
		AllContent(true).
		Send()
	if err != nil {
		fmt.Printf("Failed to search vm list, reason: %v\n", err)
		return
	}
	vmSlice, _ := vmResp.Vms()
	vm := vmSlice.Slice()[0]

	ovfFileName := fmt.Sprintf("%v.ovf", vm.MustId())

	file, err := os.Open(ovfFileName)
	if err != nil {
		fmt.Printf("Failed to open the file, reason: %v\n", err)
		return
	}
	defer file.Close()

	file.WriteString(vm.MustInitialization().MustConfiguration().MustData())

}
