# Contributing guidelines

If you're looking for something to work on, please look at our
[milestones](https://github.com/kubernetes/cluster-registry/milestones) or our
[open issues](https://github.com/kubernetes/cluster-registry/issues) and pick an
issue to start working on. If you are a member of the Kubernetes org, you can
assign issues to yourself; otherwise, there is a process for giving new
contributors READ access to repos in the Kubernetes org. For more information
about community membership and READ access, please refer to the
[Kubernetes community membership documentation](https://github.com/kubernetes/community/blob/master/community-membership.md).

## How to become a contributor and submit your own code

### Contributor License Agreements

We'd love to accept your patches! Before we can take them, we have to jump a
couple of legal hurdles.

Please fill out either the individual or corporate Contributor License Agreement
(CLA).

  * If you are an individual writing original source code and you're sure you
    own the intellectual property, then you'll need to sign an
    [individual CLA](https://identity.linuxfoundation.org/node/285/node/285/individual-signup).
  * If you work for a company that wants to allow you to contribute your work,
    then you'll need to sign a
    [corporate CLA](https://identity.linuxfoundation.org/node/285/organization-signup).

Follow either of the two links above to access the appropriate CLA and
instructions for how to sign and return it. Once we receive it, we'll be able
to accept your pull requests.

### Getting started with development

Please refer to the [development documentation](/docs/development.md) to get
started with running and developing the cluster registry.

## Feature requests/bug reports

If you have an idea for a feature, or believe you've found a bug, please open a
[new issue](https://github.com/kubernetes/cluster-registry/issues/new).
