// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package sagemakerfeaturestoreruntime

import (
	"fmt"

	"github.com/aws/aws-sdk-go/aws"
	"github.com/aws/aws-sdk-go/aws/awsutil"
	"github.com/aws/aws-sdk-go/aws/request"
	"github.com/aws/aws-sdk-go/private/protocol"
	"github.com/aws/aws-sdk-go/private/protocol/restjson"
)

const opDeleteRecord = "DeleteRecord"

// DeleteRecordRequest generates a "aws/request.Request" representing the
// client's request for the DeleteRecord operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteRecord for more information on using the DeleteRecord
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteRecordRequest method.
//    req, resp := client.DeleteRecordRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sagemaker-featurestore-runtime-2020-07-01/DeleteRecord
func (c *SageMakerFeatureStoreRuntime) DeleteRecordRequest(input *DeleteRecordInput) (req *request.Request, output *DeleteRecordOutput) {
	op := &request.Operation{
		Name:       opDeleteRecord,
		HTTPMethod: "DELETE",
		HTTPPath:   "/FeatureGroup/{FeatureGroupName}",
	}

	if input == nil {
		input = &DeleteRecordInput{}
	}

	output = &DeleteRecordOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteRecord API operation for Amazon SageMaker Feature Store Runtime.
//
// Deletes a Record from a FeatureGroup. A new record will show up in the OfflineStore
// when the DeleteRecord API is called. This record will have a value of True
// in the is_deleted column.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon SageMaker Feature Store Runtime's
// API operation DeleteRecord for usage and error information.
//
// Returned Error Types:
//   * ValidationError
//   There was an error validating your request.
//
//   * InternalFailure
//   An internal failure occurred. Try your request again. If the problem persists,
//   contact AWS customer support.
//
//   * ServiceUnavailable
//   The service is currently unavailable.
//
//   * AccessForbidden
//   You do not have permission to perform an action.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sagemaker-featurestore-runtime-2020-07-01/DeleteRecord
func (c *SageMakerFeatureStoreRuntime) DeleteRecord(input *DeleteRecordInput) (*DeleteRecordOutput, error) {
	req, out := c.DeleteRecordRequest(input)
	return out, req.Send()
}

// DeleteRecordWithContext is the same as DeleteRecord with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteRecord for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SageMakerFeatureStoreRuntime) DeleteRecordWithContext(ctx aws.Context, input *DeleteRecordInput, opts ...request.Option) (*DeleteRecordOutput, error) {
	req, out := c.DeleteRecordRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetRecord = "GetRecord"

// GetRecordRequest generates a "aws/request.Request" representing the
// client's request for the GetRecord operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetRecord for more information on using the GetRecord
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetRecordRequest method.
//    req, resp := client.GetRecordRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sagemaker-featurestore-runtime-2020-07-01/GetRecord
func (c *SageMakerFeatureStoreRuntime) GetRecordRequest(input *GetRecordInput) (req *request.Request, output *GetRecordOutput) {
	op := &request.Operation{
		Name:       opGetRecord,
		HTTPMethod: "GET",
		HTTPPath:   "/FeatureGroup/{FeatureGroupName}",
	}

	if input == nil {
		input = &GetRecordInput{}
	}

	output = &GetRecordOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetRecord API operation for Amazon SageMaker Feature Store Runtime.
//
// Use for OnlineStore serving from a FeatureStore. Only the latest records
// stored in the OnlineStore can be retrieved. If no Record with RecordIdentifierValue
// is found, then an empty result is returned.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon SageMaker Feature Store Runtime's
// API operation GetRecord for usage and error information.
//
// Returned Error Types:
//   * ValidationError
//   There was an error validating your request.
//
//   * ResourceNotFound
//   A resource that is required to perform an action was not found.
//
//   * InternalFailure
//   An internal failure occurred. Try your request again. If the problem persists,
//   contact AWS customer support.
//
//   * ServiceUnavailable
//   The service is currently unavailable.
//
//   * AccessForbidden
//   You do not have permission to perform an action.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sagemaker-featurestore-runtime-2020-07-01/GetRecord
func (c *SageMakerFeatureStoreRuntime) GetRecord(input *GetRecordInput) (*GetRecordOutput, error) {
	req, out := c.GetRecordRequest(input)
	return out, req.Send()
}

// GetRecordWithContext is the same as GetRecord with the addition of
// the ability to pass a context and additional request options.
//
// See GetRecord for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SageMakerFeatureStoreRuntime) GetRecordWithContext(ctx aws.Context, input *GetRecordInput, opts ...request.Option) (*GetRecordOutput, error) {
	req, out := c.GetRecordRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opPutRecord = "PutRecord"

// PutRecordRequest generates a "aws/request.Request" representing the
// client's request for the PutRecord operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See PutRecord for more information on using the PutRecord
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the PutRecordRequest method.
//    req, resp := client.PutRecordRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sagemaker-featurestore-runtime-2020-07-01/PutRecord
func (c *SageMakerFeatureStoreRuntime) PutRecordRequest(input *PutRecordInput) (req *request.Request, output *PutRecordOutput) {
	op := &request.Operation{
		Name:       opPutRecord,
		HTTPMethod: "PUT",
		HTTPPath:   "/FeatureGroup/{FeatureGroupName}",
	}

	if input == nil {
		input = &PutRecordInput{}
	}

	output = &PutRecordOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// PutRecord API operation for Amazon SageMaker Feature Store Runtime.
//
// Used for data ingestion into the FeatureStore. The PutRecord API writes to
// both the OnlineStore and OfflineStore. If the record is the latest record
// for the recordIdentifier, the record is written to both the OnlineStore and
// OfflineStore. If the record is a historic record, it is written only to the
// OfflineStore.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon SageMaker Feature Store Runtime's
// API operation PutRecord for usage and error information.
//
// Returned Error Types:
//   * ValidationError
//   There was an error validating your request.
//
//   * InternalFailure
//   An internal failure occurred. Try your request again. If the problem persists,
//   contact AWS customer support.
//
//   * ServiceUnavailable
//   The service is currently unavailable.
//
//   * AccessForbidden
//   You do not have permission to perform an action.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sagemaker-featurestore-runtime-2020-07-01/PutRecord
func (c *SageMakerFeatureStoreRuntime) PutRecord(input *PutRecordInput) (*PutRecordOutput, error) {
	req, out := c.PutRecordRequest(input)
	return out, req.Send()
}

// PutRecordWithContext is the same as PutRecord with the addition of
// the ability to pass a context and additional request options.
//
// See PutRecord for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SageMakerFeatureStoreRuntime) PutRecordWithContext(ctx aws.Context, input *PutRecordInput, opts ...request.Option) (*PutRecordOutput, error) {
	req, out := c.PutRecordRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// You do not have permission to perform an action.
type AccessForbidden struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation
func (s AccessForbidden) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AccessForbidden) GoString() string {
	return s.String()
}

func newErrorAccessForbidden(v protocol.ResponseMetadata) error {
	return &AccessForbidden{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *AccessForbidden) Code() string {
	return "AccessForbidden"
}

// Message returns the exception's message.
func (s *AccessForbidden) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *AccessForbidden) OrigErr() error {
	return nil
}

func (s *AccessForbidden) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *AccessForbidden) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *AccessForbidden) RequestID() string {
	return s.RespMetadata.RequestID
}

type DeleteRecordInput struct {
	_ struct{} `type:"structure"`

	// Timestamp indicating when the deletion event occurred. EventTime can be used
	// to query data at a certain point in time.
	//
	// EventTime is a required field
	EventTime *string `location:"querystring" locationName:"EventTime" type:"string" required:"true"`

	// The name of the feature group to delete the record from.
	//
	// FeatureGroupName is a required field
	FeatureGroupName *string `location:"uri" locationName:"FeatureGroupName" min:"1" type:"string" required:"true"`

	// The value for the RecordIdentifier that uniquely identifies the record, in
	// string format.
	//
	// RecordIdentifierValueAsString is a required field
	RecordIdentifierValueAsString *string `location:"querystring" locationName:"RecordIdentifierValueAsString" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteRecordInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteRecordInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteRecordInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteRecordInput"}
	if s.EventTime == nil {
		invalidParams.Add(request.NewErrParamRequired("EventTime"))
	}
	if s.FeatureGroupName == nil {
		invalidParams.Add(request.NewErrParamRequired("FeatureGroupName"))
	}
	if s.FeatureGroupName != nil && len(*s.FeatureGroupName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("FeatureGroupName", 1))
	}
	if s.RecordIdentifierValueAsString == nil {
		invalidParams.Add(request.NewErrParamRequired("RecordIdentifierValueAsString"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetEventTime sets the EventTime field's value.
func (s *DeleteRecordInput) SetEventTime(v string) *DeleteRecordInput {
	s.EventTime = &v
	return s
}

// SetFeatureGroupName sets the FeatureGroupName field's value.
func (s *DeleteRecordInput) SetFeatureGroupName(v string) *DeleteRecordInput {
	s.FeatureGroupName = &v
	return s
}

// SetRecordIdentifierValueAsString sets the RecordIdentifierValueAsString field's value.
func (s *DeleteRecordInput) SetRecordIdentifierValueAsString(v string) *DeleteRecordInput {
	s.RecordIdentifierValueAsString = &v
	return s
}

type DeleteRecordOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteRecordOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteRecordOutput) GoString() string {
	return s.String()
}

// The value associated with a feature.
type FeatureValue struct {
	_ struct{} `type:"structure"`

	// The name of a feature that a feature value corresponds to.
	//
	// FeatureName is a required field
	FeatureName *string `min:"1" type:"string" required:"true"`

	// The value associated with a feature, in string format. Note that features
	// types can be String, Integral, or Fractional. This value represents all three
	// types as a string.
	//
	// ValueAsString is a required field
	ValueAsString *string `type:"string" required:"true"`
}

// String returns the string representation
func (s FeatureValue) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s FeatureValue) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *FeatureValue) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "FeatureValue"}
	if s.FeatureName == nil {
		invalidParams.Add(request.NewErrParamRequired("FeatureName"))
	}
	if s.FeatureName != nil && len(*s.FeatureName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("FeatureName", 1))
	}
	if s.ValueAsString == nil {
		invalidParams.Add(request.NewErrParamRequired("ValueAsString"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFeatureName sets the FeatureName field's value.
func (s *FeatureValue) SetFeatureName(v string) *FeatureValue {
	s.FeatureName = &v
	return s
}

// SetValueAsString sets the ValueAsString field's value.
func (s *FeatureValue) SetValueAsString(v string) *FeatureValue {
	s.ValueAsString = &v
	return s
}

type GetRecordInput struct {
	_ struct{} `type:"structure"`

	// The name of the feature group in which you want to put the records.
	//
	// FeatureGroupName is a required field
	FeatureGroupName *string `location:"uri" locationName:"FeatureGroupName" min:"1" type:"string" required:"true"`

	// List of names of Features to be retrieved. If not specified, the latest value
	// for all the Features are returned.
	FeatureNames []*string `location:"querystring" locationName:"FeatureName" min:"1" type:"list"`

	// The value that corresponds to RecordIdentifier type and uniquely identifies
	// the record in the FeatureGroup.
	//
	// RecordIdentifierValueAsString is a required field
	RecordIdentifierValueAsString *string `location:"querystring" locationName:"RecordIdentifierValueAsString" type:"string" required:"true"`
}

// String returns the string representation
func (s GetRecordInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetRecordInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetRecordInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetRecordInput"}
	if s.FeatureGroupName == nil {
		invalidParams.Add(request.NewErrParamRequired("FeatureGroupName"))
	}
	if s.FeatureGroupName != nil && len(*s.FeatureGroupName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("FeatureGroupName", 1))
	}
	if s.FeatureNames != nil && len(s.FeatureNames) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("FeatureNames", 1))
	}
	if s.RecordIdentifierValueAsString == nil {
		invalidParams.Add(request.NewErrParamRequired("RecordIdentifierValueAsString"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFeatureGroupName sets the FeatureGroupName field's value.
func (s *GetRecordInput) SetFeatureGroupName(v string) *GetRecordInput {
	s.FeatureGroupName = &v
	return s
}

// SetFeatureNames sets the FeatureNames field's value.
func (s *GetRecordInput) SetFeatureNames(v []*string) *GetRecordInput {
	s.FeatureNames = v
	return s
}

// SetRecordIdentifierValueAsString sets the RecordIdentifierValueAsString field's value.
func (s *GetRecordInput) SetRecordIdentifierValueAsString(v string) *GetRecordInput {
	s.RecordIdentifierValueAsString = &v
	return s
}

type GetRecordOutput struct {
	_ struct{} `type:"structure"`

	// The record you requested. A list of FeatureValues.
	Record []*FeatureValue `min:"1" type:"list"`
}

// String returns the string representation
func (s GetRecordOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetRecordOutput) GoString() string {
	return s.String()
}

// SetRecord sets the Record field's value.
func (s *GetRecordOutput) SetRecord(v []*FeatureValue) *GetRecordOutput {
	s.Record = v
	return s
}

// An internal failure occurred. Try your request again. If the problem persists,
// contact AWS customer support.
type InternalFailure struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation
func (s InternalFailure) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s InternalFailure) GoString() string {
	return s.String()
}

func newErrorInternalFailure(v protocol.ResponseMetadata) error {
	return &InternalFailure{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *InternalFailure) Code() string {
	return "InternalFailure"
}

// Message returns the exception's message.
func (s *InternalFailure) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *InternalFailure) OrigErr() error {
	return nil
}

func (s *InternalFailure) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *InternalFailure) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *InternalFailure) RequestID() string {
	return s.RespMetadata.RequestID
}

type PutRecordInput struct {
	_ struct{} `type:"structure"`

	// The name of the feature group that you want to insert the record into.
	//
	// FeatureGroupName is a required field
	FeatureGroupName *string `location:"uri" locationName:"FeatureGroupName" min:"1" type:"string" required:"true"`

	// List of FeatureValues to be inserted. This will be a full over-write. If
	// you only want to update few of the feature values, do the following:
	//
	//    * Use GetRecord to retrieve the latest record.
	//
	//    * Update the record returned from GetRecord.
	//
	//    * Use PutRecord to update feature values.
	//
	// Record is a required field
	Record []*FeatureValue `min:"1" type:"list" required:"true"`
}

// String returns the string representation
func (s PutRecordInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PutRecordInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *PutRecordInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "PutRecordInput"}
	if s.FeatureGroupName == nil {
		invalidParams.Add(request.NewErrParamRequired("FeatureGroupName"))
	}
	if s.FeatureGroupName != nil && len(*s.FeatureGroupName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("FeatureGroupName", 1))
	}
	if s.Record == nil {
		invalidParams.Add(request.NewErrParamRequired("Record"))
	}
	if s.Record != nil && len(s.Record) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Record", 1))
	}
	if s.Record != nil {
		for i, v := range s.Record {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Record", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFeatureGroupName sets the FeatureGroupName field's value.
func (s *PutRecordInput) SetFeatureGroupName(v string) *PutRecordInput {
	s.FeatureGroupName = &v
	return s
}

// SetRecord sets the Record field's value.
func (s *PutRecordInput) SetRecord(v []*FeatureValue) *PutRecordInput {
	s.Record = v
	return s
}

type PutRecordOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s PutRecordOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PutRecordOutput) GoString() string {
	return s.String()
}

// A resource that is required to perform an action was not found.
type ResourceNotFound struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation
func (s ResourceNotFound) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ResourceNotFound) GoString() string {
	return s.String()
}

func newErrorResourceNotFound(v protocol.ResponseMetadata) error {
	return &ResourceNotFound{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ResourceNotFound) Code() string {
	return "ResourceNotFound"
}

// Message returns the exception's message.
func (s *ResourceNotFound) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ResourceNotFound) OrigErr() error {
	return nil
}

func (s *ResourceNotFound) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ResourceNotFound) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ResourceNotFound) RequestID() string {
	return s.RespMetadata.RequestID
}

// The service is currently unavailable.
type ServiceUnavailable struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation
func (s ServiceUnavailable) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ServiceUnavailable) GoString() string {
	return s.String()
}

func newErrorServiceUnavailable(v protocol.ResponseMetadata) error {
	return &ServiceUnavailable{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ServiceUnavailable) Code() string {
	return "ServiceUnavailable"
}

// Message returns the exception's message.
func (s *ServiceUnavailable) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ServiceUnavailable) OrigErr() error {
	return nil
}

func (s *ServiceUnavailable) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ServiceUnavailable) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ServiceUnavailable) RequestID() string {
	return s.RespMetadata.RequestID
}

// There was an error validating your request.
type ValidationError struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation
func (s ValidationError) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ValidationError) GoString() string {
	return s.String()
}

func newErrorValidationError(v protocol.ResponseMetadata) error {
	return &ValidationError{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ValidationError) Code() string {
	return "ValidationError"
}

// Message returns the exception's message.
func (s *ValidationError) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ValidationError) OrigErr() error {
	return nil
}

func (s *ValidationError) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ValidationError) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ValidationError) RequestID() string {
	return s.RespMetadata.RequestID
}
