package adhybridhealthservice

// Copyright (c) Microsoft and contributors.  All rights reserved.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
// http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//
// See the License for the specific language governing permissions and
// limitations under the License.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"context"
	"encoding/json"
	"github.com/Azure/go-autorest/autorest"
	"github.com/Azure/go-autorest/autorest/date"
	"github.com/Azure/go-autorest/autorest/to"
	"github.com/Azure/go-autorest/tracing"
	"github.com/satori/go.uuid"
	"net/http"
)

// The package's fully qualified name.
const fqdn = "github.com/Azure/azure-sdk-for-go/services/adhybridhealthservice/mgmt/2014-01-01/adhybridhealthservice"

// AdditionalInformation the additional information for a property.
type AdditionalInformation struct {
	// TitleName - The title name for the property.
	TitleName *string `json:"titleName,omitempty"`
	// TitleValue - The title value for the property.
	TitleValue *string `json:"titleValue,omitempty"`
	// Properties - The list of properties which are included in the additional information.
	Properties interface{} `json:"properties,omitempty"`
	// HasProperties - Indicates if properties are present or not.
	HasProperties *bool `json:"hasProperties,omitempty"`
}

// AddsConfiguration the list of key value properties.
type AddsConfiguration struct {
	autorest.Response `json:"-"`
	// NextLink - The link used to get the next page of operations.
	NextLink *string `json:"nextLink,omitempty"`
	// Value - The value returned by the operation.
	Value *[]Item `json:"value,omitempty"`
	// TotalCount - The total count of configuration.
	TotalCount *int32 `json:"totalCount,omitempty"`
	// ContinuationToken - The continuation token for paginated calls.
	ContinuationToken *string `json:"continuationToken,omitempty"`
}

// AddsConfigurationIterator provides access to a complete listing of Item values.
type AddsConfigurationIterator struct {
	i    int
	page AddsConfigurationPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *AddsConfigurationIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/AddsConfigurationIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *AddsConfigurationIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter AddsConfigurationIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter AddsConfigurationIterator) Response() AddsConfiguration {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter AddsConfigurationIterator) Value() Item {
	if !iter.page.NotDone() {
		return Item{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the AddsConfigurationIterator type.
func NewAddsConfigurationIterator(page AddsConfigurationPage) AddsConfigurationIterator {
	return AddsConfigurationIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (ac AddsConfiguration) IsEmpty() bool {
	return ac.Value == nil || len(*ac.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (ac AddsConfiguration) hasNextLink() bool {
	return ac.NextLink != nil && len(*ac.NextLink) != 0
}

// addsConfigurationPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (ac AddsConfiguration) addsConfigurationPreparer(ctx context.Context) (*http.Request, error) {
	if !ac.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(ac.NextLink)))
}

// AddsConfigurationPage contains a page of Item values.
type AddsConfigurationPage struct {
	fn func(context.Context, AddsConfiguration) (AddsConfiguration, error)
	ac AddsConfiguration
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *AddsConfigurationPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/AddsConfigurationPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.ac)
		if err != nil {
			return err
		}
		page.ac = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *AddsConfigurationPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page AddsConfigurationPage) NotDone() bool {
	return !page.ac.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page AddsConfigurationPage) Response() AddsConfiguration {
	return page.ac
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page AddsConfigurationPage) Values() []Item {
	if page.ac.IsEmpty() {
		return nil
	}
	return *page.ac.Value
}

// Creates a new instance of the AddsConfigurationPage type.
func NewAddsConfigurationPage(getNextPage func(context.Context, AddsConfiguration) (AddsConfiguration, error)) AddsConfigurationPage {
	return AddsConfigurationPage{fn: getNextPage}
}

// AddsServiceMember the server details for ADDS service.
type AddsServiceMember struct {
	// DomainName - The domain name.
	DomainName *string `json:"domainName,omitempty"`
	// SiteName - The site name.
	SiteName *string `json:"siteName,omitempty"`
	// AddsRoles - The list of ADDS roles.
	AddsRoles *[]string `json:"addsRoles,omitempty"`
	// GcReachable - Indicates if the global catalog for this domain is reachable or not.
	GcReachable *bool `json:"gcReachable,omitempty"`
	// IsAdvertising - Indicates if the Dc is advertising or not.
	IsAdvertising *bool `json:"isAdvertising,omitempty"`
	// PdcReachable - Indicates if the primary domain controller is reachable or not.
	PdcReachable *bool `json:"pdcReachable,omitempty"`
	// SysvolState - Indicates if the SYSVOL state is healthy or not.
	SysvolState *bool `json:"sysvolState,omitempty"`
	// DcTypes - The list of domain controller types.
	DcTypes *[]string `json:"dcTypes,omitempty"`
	// ServiceMemberID - The id of the server.
	ServiceMemberID *string `json:"serviceMemberId,omitempty"`
	// ServiceID - The service id to whom this server belongs.
	ServiceID *string `json:"serviceId,omitempty"`
	// TenantID - The tenant id to whom this server belongs.
	TenantID *string `json:"tenantId,omitempty"`
	// ActiveAlerts - The total number of alerts that are currently active for the server.
	ActiveAlerts *int32 `json:"activeAlerts,omitempty"`
	// AdditionalInformation - The additional information, if any, for the server.
	AdditionalInformation *string `json:"additionalInformation,omitempty"`
	// CreatedDate - The date time , in UTC, when the server was onboarded to Azure Active Directory Connect Health.
	CreatedDate *date.Time `json:"createdDate,omitempty"`
	// Dimensions - The server specific configuration related dimensions.
	Dimensions *[]Item `json:"dimensions,omitempty"`
	// Disabled - Indicates if the server is disabled or not.
	Disabled *bool `json:"disabled,omitempty"`
	// DisabledReason - The reason for disabling the server.
	DisabledReason *int32 `json:"disabledReason,omitempty"`
	// InstalledQfes - The list of installed QFEs for the server.
	InstalledQfes *[]Hotfix `json:"installedQfes,omitempty"`
	// LastDisabled - The date and time , in UTC, when the server was last disabled.
	LastDisabled *date.Time `json:"lastDisabled,omitempty"`
	// LastReboot - The date and time, in UTC, when the server was last rebooted.
	LastReboot *date.Time `json:"lastReboot,omitempty"`
	// LastServerReportedMonitoringLevelChange - The date and time, in UTC, when the server's data monitoring configuration was last changed.
	LastServerReportedMonitoringLevelChange *date.Time `json:"lastServerReportedMonitoringLevelChange,omitempty"`
	// LastUpdated - The date and time, in UTC, when the server properties were last updated.
	LastUpdated *date.Time `json:"lastUpdated,omitempty"`
	// MachineID - The id of the machine.
	MachineID *string `json:"machineId,omitempty"`
	// MachineName - The name of the server.
	MachineName *string `json:"machineName,omitempty"`
	// MonitoringConfigurationsComputed - The monitoring configuration of the server which determines what activities are monitored by Azure Active Directory Connect Health.
	MonitoringConfigurationsComputed *[]Item `json:"monitoringConfigurationsComputed,omitempty"`
	// MonitoringConfigurationsCustomized - The customized monitoring configuration of the server which determines what activities are monitored by Azure Active Directory Connect Health.
	MonitoringConfigurationsCustomized *[]Item `json:"monitoringConfigurationsCustomized,omitempty"`
	// OsName - The name of the operating system installed in the machine.
	OsName *string `json:"osName,omitempty"`
	// OsVersion - The version of the operating system installed in the machine.
	OsVersion *string `json:"osVersion,omitempty"`
	// Properties - Server specific properties.
	Properties *[]Item `json:"properties,omitempty"`
	// RecommendedQfes - The list of recommended hotfixes for the server.
	RecommendedQfes *[]Hotfix `json:"recommendedQfes,omitempty"`
	// ResolvedAlerts - The total count of alerts that are resolved for this server.
	ResolvedAlerts *int32 `json:"resolvedAlerts,omitempty"`
	// Role - The service role that is being monitored in the server.
	Role *string `json:"role,omitempty"`
	// ServerReportedMonitoringLevel - The monitoring level reported by the server. Possible values include: 'Partial', 'Full', 'Off'
	ServerReportedMonitoringLevel MonitoringLevel `json:"serverReportedMonitoringLevel,omitempty"`
	// Status - The health status of the server.
	Status *string `json:"status,omitempty"`
}

// AddsServiceMembers the list of  ADDS service members.
type AddsServiceMembers struct {
	autorest.Response `json:"-"`
	// NextLink - The link used to get the next page of operations.
	NextLink *string `json:"nextLink,omitempty"`
	// Value - The value returned by the operation.
	Value *[]AddsServiceMember `json:"value,omitempty"`
	// TotalCount - The total count of service members.
	TotalCount *int32 `json:"totalCount,omitempty"`
	// ContinuationToken - The continuation token for paginated calls.
	ContinuationToken *string `json:"continuationToken,omitempty"`
}

// AddsServiceMembersIterator provides access to a complete listing of AddsServiceMember values.
type AddsServiceMembersIterator struct {
	i    int
	page AddsServiceMembersPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *AddsServiceMembersIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/AddsServiceMembersIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *AddsServiceMembersIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter AddsServiceMembersIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter AddsServiceMembersIterator) Response() AddsServiceMembers {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter AddsServiceMembersIterator) Value() AddsServiceMember {
	if !iter.page.NotDone() {
		return AddsServiceMember{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the AddsServiceMembersIterator type.
func NewAddsServiceMembersIterator(page AddsServiceMembersPage) AddsServiceMembersIterator {
	return AddsServiceMembersIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (asm AddsServiceMembers) IsEmpty() bool {
	return asm.Value == nil || len(*asm.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (asm AddsServiceMembers) hasNextLink() bool {
	return asm.NextLink != nil && len(*asm.NextLink) != 0
}

// addsServiceMembersPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (asm AddsServiceMembers) addsServiceMembersPreparer(ctx context.Context) (*http.Request, error) {
	if !asm.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(asm.NextLink)))
}

// AddsServiceMembersPage contains a page of AddsServiceMember values.
type AddsServiceMembersPage struct {
	fn  func(context.Context, AddsServiceMembers) (AddsServiceMembers, error)
	asm AddsServiceMembers
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *AddsServiceMembersPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/AddsServiceMembersPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.asm)
		if err != nil {
			return err
		}
		page.asm = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *AddsServiceMembersPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page AddsServiceMembersPage) NotDone() bool {
	return !page.asm.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page AddsServiceMembersPage) Response() AddsServiceMembers {
	return page.asm
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page AddsServiceMembersPage) Values() []AddsServiceMember {
	if page.asm.IsEmpty() {
		return nil
	}
	return *page.asm.Value
}

// Creates a new instance of the AddsServiceMembersPage type.
func NewAddsServiceMembersPage(getNextPage func(context.Context, AddsServiceMembers) (AddsServiceMembers, error)) AddsServiceMembersPage {
	return AddsServiceMembersPage{fn: getNextPage}
}

// Agent the agent details.
type Agent struct {
	// TenantID - The tenant Id.
	TenantID *string `json:"tenantId,omitempty"`
	// MachineID - The machine Id.
	MachineID *string `json:"machineId,omitempty"`
	// Credential - The agent credential details.
	Credential interface{} `json:"credential,omitempty"`
	// MachineName - The machine name.
	MachineName *string `json:"machineName,omitempty"`
	// AgentVersion - The agent version.
	AgentVersion *string `json:"agentVersion,omitempty"`
	// CreatedDate - The date and time, in UTC, when the agent was created.
	CreatedDate *date.Time `json:"createdDate,omitempty"`
	// Key -  The connector hash key.
	Key *string `json:"key,omitempty"`
}

// Alert the alert details indicating an issue with service or server.
type Alert struct {
	// AlertID - The alert Id.
	AlertID *uuid.UUID `json:"alertId,omitempty"`
	// Level - The alert level which indicates the severity of the alert. Possible values include: 'LevelWarning', 'LevelError', 'LevelPreWarning'
	Level Level `json:"level,omitempty"`
	// State - The alert state which can be either active or resolved with multiple resolution types. Possible values include: 'Active', 'ResolvedByPositiveResult', 'ResolvedManually', 'ResolvedByTimer', 'ResolvedByStateChange'
	State State `json:"state,omitempty"`
	// ShortName - The alert short name.
	ShortName *string `json:"shortName,omitempty"`
	// DisplayName - The display name for the alert.
	DisplayName *string `json:"displayName,omitempty"`
	// Description - The alert description.
	Description *string `json:"description,omitempty"`
	// Remediation - The alert remediation.
	Remediation *string `json:"remediation,omitempty"`
	// RelatedLinks - The help links to get more information related to the alert.
	RelatedLinks *[]HelpLink `json:"relatedLinks,omitempty"`
	// Scope - The scope of the alert. Indicates if it is a service or a server related alert.
	Scope *string `json:"scope,omitempty"`
	// AdditionalInformation - Additional information related to the alert.
	AdditionalInformation *[]AdditionalInformation `json:"additionalInformation,omitempty"`
	// CreatedDate - The date and time,in UTC,when the alert was created.
	CreatedDate *date.Time `json:"createdDate,omitempty"`
	// ResolvedDate - The date and time, in UTC, when the alert was resolved.
	ResolvedDate *date.Time `json:"resolvedDate,omitempty"`
	// LastUpdated - The date and time, in UTC, when the alert was last updated.
	LastUpdated *date.Time `json:"lastUpdated,omitempty"`
	// MonitorRoleType - The monitoring role type for which the alert was raised.
	MonitorRoleType *string `json:"monitorRoleType,omitempty"`
	// ActiveAlertProperties - The active alert properties.
	ActiveAlertProperties *[]Item `json:"activeAlertProperties,omitempty"`
	// ResolvedAlertProperties - The resolved alert properties.
	ResolvedAlertProperties *[]Item `json:"resolvedAlertProperties,omitempty"`
	// TenantID - The tenant Id.
	TenantID *uuid.UUID `json:"tenantId,omitempty"`
	// ServiceID - The service Id.
	ServiceID *uuid.UUID `json:"serviceId,omitempty"`
	// ServiceMemberID - The server Id.
	ServiceMemberID *uuid.UUID `json:"serviceMemberId,omitempty"`
}

// AlertFeedback the alert feedback details.
type AlertFeedback struct {
	autorest.Response `json:"-"`
	// Level - The alert level which indicates the severity of the alert.
	Level *string `json:"level,omitempty"`
	// State - The alert state which can be either active or resolved with multiple resolution types.
	State *string `json:"state,omitempty"`
	// ShortName - The alert short name.
	ShortName *string `json:"shortName,omitempty"`
	// Feedback - The feedback for the alert which indicates if the customer likes or dislikes the alert.
	Feedback *string `json:"feedback,omitempty"`
	// Comment - Additional comments related to the alert.
	Comment *string `json:"comment,omitempty"`
	// ConsentedToShare - Indicates if the alert feedback can be shared from product team.
	ConsentedToShare *bool `json:"consentedToShare,omitempty"`
	// ServiceMemberID - The server Id of the alert.
	ServiceMemberID *string `json:"serviceMemberId,omitempty"`
	// CreatedDate - The date and time,in UTC,when the alert was created.
	CreatedDate *date.Time `json:"createdDate,omitempty"`
}

// AlertFeedbacks the list of alert feedback.
type AlertFeedbacks struct {
	autorest.Response `json:"-"`
	// Value - The value returned by the operation.
	Value *[]AlertFeedback `json:"value,omitempty"`
}

// Alerts the list of alerts for a service.
type Alerts struct {
	autorest.Response `json:"-"`
	// Value - The value returned by the operation.
	Value *[]Alert `json:"value,omitempty"`
	// NextLink - The link used to get the next page of operations.
	NextLink *string `json:"nextLink,omitempty"`
	// TotalCount - The total count of alert elements.
	TotalCount *int32 `json:"totalCount,omitempty"`
	// ContinuationToken - The continuation token for paginated calls.
	ContinuationToken *string `json:"continuationToken,omitempty"`
}

// AlertsIterator provides access to a complete listing of Alert values.
type AlertsIterator struct {
	i    int
	page AlertsPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *AlertsIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/AlertsIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *AlertsIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter AlertsIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter AlertsIterator) Response() Alerts {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter AlertsIterator) Value() Alert {
	if !iter.page.NotDone() {
		return Alert{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the AlertsIterator type.
func NewAlertsIterator(page AlertsPage) AlertsIterator {
	return AlertsIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (a Alerts) IsEmpty() bool {
	return a.Value == nil || len(*a.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (a Alerts) hasNextLink() bool {
	return a.NextLink != nil && len(*a.NextLink) != 0
}

// alertsPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (a Alerts) alertsPreparer(ctx context.Context) (*http.Request, error) {
	if !a.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(a.NextLink)))
}

// AlertsPage contains a page of Alert values.
type AlertsPage struct {
	fn func(context.Context, Alerts) (Alerts, error)
	a  Alerts
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *AlertsPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/AlertsPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.a)
		if err != nil {
			return err
		}
		page.a = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *AlertsPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page AlertsPage) NotDone() bool {
	return !page.a.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page AlertsPage) Response() Alerts {
	return page.a
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page AlertsPage) Values() []Alert {
	if page.a.IsEmpty() {
		return nil
	}
	return *page.a.Value
}

// Creates a new instance of the AlertsPage type.
func NewAlertsPage(getNextPage func(context.Context, Alerts) (Alerts, error)) AlertsPage {
	return AlertsPage{fn: getNextPage}
}

// AssociatedObject object that hold sync object details.
type AssociatedObject struct {
	// DisplayName - The display name of the object.
	DisplayName *string `json:"displayName,omitempty"`
	// DistinguishedName - The distinguished name of the object.
	DistinguishedName *string `json:"distinguishedName,omitempty"`
	// LastDirSyncTime - The last dirSync time.
	LastDirSyncTime *date.Time `json:"lastDirSyncTime,omitempty"`
	// Mail - The email of the object.
	Mail *string `json:"mail,omitempty"`
	// ObjectGUID - The object guid.
	ObjectGUID *string `json:"objectGuid,omitempty"`
	// ObjectType - The object type.
	ObjectType *string `json:"objectType,omitempty"`
	// OnpremisesUserPrincipalName - The On-premises UPN.
	OnpremisesUserPrincipalName *string `json:"onpremisesUserPrincipalName,omitempty"`
	// ProxyAddresses - The proxy addresses.
	ProxyAddresses *string `json:"proxyAddresses,omitempty"`
	// SourceAnchor - The source anchor.
	SourceAnchor *string `json:"sourceAnchor,omitempty"`
	// SourceOfAuthority - The source of authority.
	SourceOfAuthority *string `json:"sourceOfAuthority,omitempty"`
	// TimeOccurred -  The time of the error.
	TimeOccurred *date.Time `json:"timeOccurred,omitempty"`
	// UserPrincipalName -  The UPN.
	UserPrincipalName *string `json:"userPrincipalName,omitempty"`
}

// AttributeDelta the delta attributes.
type AttributeDelta struct {
	// Values - The delta values.
	Values *[]ValueDelta `json:"values,omitempty"`
	// Name - The name of the attribute delta.
	Name *string `json:"name,omitempty"`
	// OperationType - The attribute delta operation type. Possible values include: 'AttributeDeltaOperationTypeUndefined', 'AttributeDeltaOperationTypeAdd', 'AttributeDeltaOperationTypeReplace', 'AttributeDeltaOperationTypeUpdate', 'AttributeDeltaOperationTypeDelete'
	OperationType AttributeDeltaOperationType `json:"operationType,omitempty"`
	// ValueType - The value type. Possible values include: 'ValueTypeUndefined', 'ValueTypeDn', 'ValueTypeBinary', 'ValueTypeString', 'ValueTypeInteger', 'ValueTypeBoolean'
	ValueType ValueType `json:"valueType,omitempty"`
	// MultiValued - Indicates if the attribute delta is multivalued or not.
	MultiValued *bool `json:"multiValued,omitempty"`
}

// AttributeMapping the attribute mapping details.
type AttributeMapping struct {
	// MappingSource - The mapping source.
	MappingSource *AttributeMppingSource `json:"mappingSource,omitempty"`
	// Type - The attribute mapping type. Possible values include: 'Constant', 'Direct', 'DnPart', 'Script'
	Type AttributeMappingType `json:"type,omitempty"`
	// DestinationAttribute - The destination attribute.
	DestinationAttribute *string `json:"destinationAttribute,omitempty"`
	// ContextID - The context Id.
	ContextID *string `json:"contextId,omitempty"`
}

// AttributeMppingSource the attribute mapping source.
type AttributeMppingSource struct {
	// SourceAttribute - The source attribute.
	SourceAttribute *[]string `json:"sourceAttribute,omitempty"`
	// DnPart - The value for dn part.
	DnPart *int32 `json:"dnPart,omitempty"`
	// ScriptContext - The script context.
	ScriptContext *string `json:"scriptContext,omitempty"`
	// ConstantValue - The constant value.
	ConstantValue *string `json:"constantValue,omitempty"`
}

// ChangeNotReimported the changes which are not re-imported.
type ChangeNotReimported struct {
	// Delta - The delta changes that is not re-imported.
	Delta *ChangeNotReimportedDelta `json:"delta,omitempty"`
	// Entry - The object entry in a change that is not re-imported.
	Entry *ChangeNotReimportedEntry `json:"entry,omitempty"`
}

// ChangeNotReimportedDelta the delta in a change that is not re-imported.
type ChangeNotReimportedDelta struct {
	// Anchor - The anchor.
	Anchor *string `json:"anchor,omitempty"`
	// DnAttributes - The delta attributes for distinguished names.
	DnAttributes *[]AttributeDelta `json:"dnAttributes,omitempty"`
	// Attributes - The attributes.
	Attributes *[]AttributeDelta `json:"attributes,omitempty"`
	// OperationType - The operation type. Possible values include: 'DeltaOperationTypeUndefined', 'DeltaOperationTypeNone', 'DeltaOperationTypeAdd', 'DeltaOperationTypeReplace', 'DeltaOperationTypeUpdate', 'DeltaOperationTypeDelete', 'DeltaOperationTypeObsolete', 'DeltaOperationTypeDeleteAdd'
	OperationType DeltaOperationType `json:"operationType,omitempty"`
}

// ChangeNotReimportedEntry the object entry in a change that is not re-imported.
type ChangeNotReimportedEntry struct {
	// Anchor - The anchor.
	Anchor *string `json:"anchor,omitempty"`
	// ParentAnchor - The parent anchor.
	ParentAnchor *string `json:"parentAnchor,omitempty"`
	// PrimaryObjectClass - The primary object class.
	PrimaryObjectClass *string `json:"primaryObjectClass,omitempty"`
	// ObjectClasses - The list of object classes.
	ObjectClasses *[]string `json:"objectClasses,omitempty"`
	// DnAttributes - The delta attributes for distinguished names.
	DnAttributes *[]AttributeDelta `json:"dnAttributes,omitempty"`
	// Attributes - The attributes.
	Attributes *[]AttributeDelta `json:"attributes,omitempty"`
	// Dn - The distinguished name.
	Dn *string `json:"dn,omitempty"`
}

// Connector the connect details.
type Connector struct {
	// ConnectorID - The connector Id.
	ConnectorID *string `json:"connectorId,omitempty"`
	// ID - The connector Id.
	ID *string `json:"id,omitempty"`
	// Name - The connector name.
	Name *string `json:"name,omitempty"`
	// Version - The connector version
	Version *int32 `json:"version,omitempty"`
	// Type - The connector type.
	Type *string `json:"type,omitempty"`
	// Description - The connector description.
	Description *string `json:"description,omitempty"`
	// SchemaXML - The schema xml for the connector.
	SchemaXML *string `json:"schemaXml,omitempty"`
	// PasswordManagementSettings - The password management settings of the connector.
	PasswordManagementSettings interface{} `json:"passwordManagementSettings,omitempty"`
	// PasswordHashSyncConfiguration - The password hash synchronization configuration of the connector.
	PasswordHashSyncConfiguration interface{} `json:"passwordHashSyncConfiguration,omitempty"`
	// TimeCreated - The date and time when this connector was created.
	TimeCreated *date.Time `json:"timeCreated,omitempty"`
	// TimeLastModified - The date and time when this connector was last modified.
	TimeLastModified *date.Time `json:"timeLastModified,omitempty"`
	// Partitions - The partitions of the connector.
	Partitions *[]Partition `json:"partitions,omitempty"`
	// RunProfiles - The run profiles of the connector.
	RunProfiles *[]RunProfile `json:"runProfiles,omitempty"`
	// ClassesIncluded - The class inclusion list of the connector.
	ClassesIncluded *[]string `json:"classesIncluded,omitempty"`
	// AttributesIncluded - The attribute inclusion list of the connector.
	AttributesIncluded *[]string `json:"attributesIncluded,omitempty"`
}

// ConnectorConnectionError the connector connection error.
type ConnectorConnectionError struct {
	// ID - The error Id.
	ID *string `json:"id,omitempty"`
	// RunStepResultID - The run step result Id.
	RunStepResultID *string `json:"runStepResultId,omitempty"`
	// ConnectorID - The connector Id.
	ConnectorID *string `json:"connectorId,omitempty"`
	// Type - The type of error.
	Type *string `json:"type,omitempty"`
	// ErrorCode - The error code.
	ErrorCode *string `json:"errorCode,omitempty"`
	// Message - The message for the connection error.
	Message *string `json:"message,omitempty"`
	// TimeOccured - The time when the connection error occurred.
	TimeOccured *date.Time `json:"timeOccured,omitempty"`
	// Server - The server where the connection error happened.
	Server *string `json:"server,omitempty"`
}

// ConnectorConnectionErrors the list of connector connection errors.
type ConnectorConnectionErrors struct {
	// Value - The value returned by the operation.
	Value *[]ConnectorConnectionError `json:"value,omitempty"`
}

// ConnectorMetadata gets the list of connectors and run profile names.
type ConnectorMetadata struct {
	autorest.Response `json:"-"`
	// Connectors - The list of connectors.
	Connectors *[]ConnectorMetadataDetails `json:"connectors,omitempty"`
	// RunProfileNames - The list of run profile names.
	RunProfileNames *[]string `json:"runProfileNames,omitempty"`
}

// ConnectorMetadataDetails details of the connector.
type ConnectorMetadataDetails struct {
	// ConnectorID - The Connector Id.
	ConnectorID *string `json:"connectorId,omitempty"`
	// ConnectorDisplayName - The Connector Display Name
	ConnectorDisplayName *string `json:"connectorDisplayName,omitempty"`
}

// ConnectorObjectError the connector object error.
type ConnectorObjectError struct {
	// ID - The error Id.
	ID *string `json:"id,omitempty"`
	// RunStepResultID - The run step result Id.
	RunStepResultID *string `json:"runStepResultId,omitempty"`
	// ConnectorID - The connector Id.
	ConnectorID *string `json:"connectorId,omitempty"`
	// Type - The type of error.
	Type *string `json:"type,omitempty"`
	// ErrorCode - The error code.
	ErrorCode *string `json:"errorCode,omitempty"`
	// Message - The message for the object error.
	Message *string `json:"message,omitempty"`
	// EntryNumber - The entry number for object error occurred.
	EntryNumber *int32 `json:"entryNumber,omitempty"`
	// LineNumber - The line number for the object error.
	LineNumber *int32 `json:"lineNumber,omitempty"`
	// ColumnNumber - The column number for the object error.
	ColumnNumber *int32 `json:"columnNumber,omitempty"`
	// Dn - The distinguished name of the object.
	Dn *string `json:"dn,omitempty"`
	// Anchor - The name for the anchor of the object.
	Anchor *string `json:"anchor,omitempty"`
	// AttributeName - The attribute name of the object.
	AttributeName *string `json:"attributeName,omitempty"`
	// ServerErrorDetail - The server side error details.
	ServerErrorDetail *string `json:"serverErrorDetail,omitempty"`
	// Values - The value corresponding to attribute name.
	Values *[]string `json:"values,omitempty"`
}

// ConnectorObjectErrors the list of connector object errors.
type ConnectorObjectErrors struct {
	// Value - The value returned by the operation.
	Value *[]ConnectorObjectError `json:"value,omitempty"`
}

// Connectors the list of connects for a service.
type Connectors struct {
	autorest.Response `json:"-"`
	// Value - The value returned by the operation.
	Value *[]Connector `json:"value,omitempty"`
}

// Credential the credential for a given server.
type Credential struct {
	// Identifier - The credential identifier.
	Identifier *string `json:"identifier,omitempty"`
	// Type - The type of credential.
	Type *string `json:"type,omitempty"`
	// CredentialData - The credential data.
	CredentialData *[]string `json:"credentialData,omitempty"`
}

// Credentials the list of agent credentials.
type Credentials struct {
	autorest.Response `json:"-"`
	// Value - The value returned by the operation.
	Value *[]Credential `json:"value,omitempty"`
}

// DataFreshnessDetails the data freshness details for the server.
type DataFreshnessDetails struct {
	autorest.Response `json:"-"`
	// Value - The value returned by the operation.
	Value *[]Item `json:"value,omitempty"`
}

// Dimension the connector object error.
type Dimension struct {
	// Health - The health status for the domain controller. Possible values include: 'Healthy', 'Warning', 'Error', 'NotMonitored', 'Missing'
	Health HealthStatus `json:"health,omitempty"`
	// SimpleProperties - List of service specific configuration properties.
	SimpleProperties interface{} `json:"simpleProperties,omitempty"`
	// ActiveAlerts - The count of alerts that are currently active for the service.
	ActiveAlerts *int32 `json:"activeAlerts,omitempty"`
	// AdditionalInformation - The additional information related to the service.
	AdditionalInformation *string `json:"additionalInformation,omitempty"`
	// LastUpdated - The date or time , in UTC, when the service properties were last updated.
	LastUpdated *date.Time `json:"lastUpdated,omitempty"`
	// DisplayName - The display name of the service.
	DisplayName *string `json:"displayName,omitempty"`
	// ResolvedAlerts - The total count of alerts that has been resolved for the service.
	ResolvedAlerts *int32 `json:"resolvedAlerts,omitempty"`
	// Signature - The signature of the service.
	Signature *string `json:"signature,omitempty"`
	// Type - The service type for the services onboarded to Azure Active Directory Connect Health. Depending on whether the service is monitoring, ADFS, Sync or ADDS roles, the service type can either be AdFederationService or AadSyncService or AdDomainService.
	Type *string `json:"type,omitempty"`
}

// Dimensions the list of dimensions.
type Dimensions struct {
	autorest.Response `json:"-"`
	// NextLink - The link used to get the next page of operations.
	NextLink *string `json:"nextLink,omitempty"`
	// Value - The value returned by the operation.
	Value *[]Dimension `json:"value,omitempty"`
	// TotalCount - The total count of dimensions.
	TotalCount *int32 `json:"totalCount,omitempty"`
	// ContinuationToken - The continuation token for paginated calls.
	ContinuationToken *string `json:"continuationToken,omitempty"`
}

// DimensionsIterator provides access to a complete listing of Dimension values.
type DimensionsIterator struct {
	i    int
	page DimensionsPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *DimensionsIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/DimensionsIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *DimensionsIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter DimensionsIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter DimensionsIterator) Response() Dimensions {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter DimensionsIterator) Value() Dimension {
	if !iter.page.NotDone() {
		return Dimension{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the DimensionsIterator type.
func NewDimensionsIterator(page DimensionsPage) DimensionsIterator {
	return DimensionsIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (d Dimensions) IsEmpty() bool {
	return d.Value == nil || len(*d.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (d Dimensions) hasNextLink() bool {
	return d.NextLink != nil && len(*d.NextLink) != 0
}

// dimensionsPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (d Dimensions) dimensionsPreparer(ctx context.Context) (*http.Request, error) {
	if !d.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(d.NextLink)))
}

// DimensionsPage contains a page of Dimension values.
type DimensionsPage struct {
	fn func(context.Context, Dimensions) (Dimensions, error)
	d  Dimensions
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *DimensionsPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/DimensionsPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.d)
		if err != nil {
			return err
		}
		page.d = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *DimensionsPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page DimensionsPage) NotDone() bool {
	return !page.d.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page DimensionsPage) Response() Dimensions {
	return page.d
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page DimensionsPage) Values() []Dimension {
	if page.d.IsEmpty() {
		return nil
	}
	return *page.d.Value
}

// Creates a new instance of the DimensionsPage type.
func NewDimensionsPage(getNextPage func(context.Context, Dimensions) (Dimensions, error)) DimensionsPage {
	return DimensionsPage{fn: getNextPage}
}

// Display displays the details related to operations supported by Azure Active Directory Connect Health.
type Display struct {
	// Description -  The description for the operation.
	Description *string `json:"description,omitempty"`
	// Operation - The details of the operation.
	Operation *string `json:"operation,omitempty"`
	// Provider - The provider name.
	Provider *string `json:"provider,omitempty"`
}

// ErrorCount the error count details.
type ErrorCount struct {
	// ErrorBucket - The error bucket.
	ErrorBucket *string `json:"errorBucket,omitempty"`
	// Count - The error count.
	Count *int32 `json:"count,omitempty"`
	// Truncated - Indicates if the error count is truncated or not.
	Truncated *bool `json:"truncated,omitempty"`
}

// ErrorCounts the list of error counts.
type ErrorCounts struct {
	autorest.Response `json:"-"`
	// Value - The value returned by the operation.
	Value *[]ErrorCount `json:"value,omitempty"`
}

// ErrorDetail the error details.
type ErrorDetail struct {
	// Description - The error description.
	Description *string `json:"description,omitempty"`
	// KbURL - The knowledge base article url which contains more information about the error.
	KbURL *string `json:"kbUrl,omitempty"`
	// Detail - Additional details related to the error.
	Detail *string `json:"detail,omitempty"`
	// ObjectsWithSyncError - The list of objects with sync errors.
	ObjectsWithSyncError *ObjectWithSyncError `json:"objectsWithSyncError,omitempty"`
	// ObjectWithSyncError -  The object with sync error.
	ObjectWithSyncError *MergedExportError `json:"objectWithSyncError,omitempty"`
}

// ErrorReportUsersEntries the list of bad password log in attempt entries.
type ErrorReportUsersEntries struct {
	autorest.Response `json:"-"`
	// Value - The value returned by the operation.
	Value *[]ErrorReportUsersEntry `json:"value,omitempty"`
}

// ErrorReportUsersEntry the bad password login attempt details.
type ErrorReportUsersEntry struct {
	// UserID - The user ID value.
	UserID *string `json:"userId,omitempty"`
	// IPAddress - The IP address corresponding to the last error event.
	IPAddress *string `json:"ipAddress,omitempty"`
	// LastUpdated - The date and time when the last error event was logged.
	LastUpdated *date.Time `json:"lastUpdated,omitempty"`
	// UniqueIPAddresses - The list of unique IP addresses.
	UniqueIPAddresses *string `json:"uniqueIpAddresses,omitempty"`
	// TotalErrorAttempts - The total count of specific error events.
	TotalErrorAttempts *int32 `json:"totalErrorAttempts,omitempty"`
}

// ExportError the export error details.
type ExportError struct {
	// ID - The error Id.
	ID *string `json:"id,omitempty"`
	// RunStepResultID - The run step result Id.
	RunStepResultID *string `json:"runStepResultId,omitempty"`
	// ConnectorID - The connector Id.
	ConnectorID *string `json:"connectorId,omitempty"`
	// Type - The type of error.
	Type *string `json:"type,omitempty"`
	// ErrorCode - The error code.
	ErrorCode *string `json:"errorCode,omitempty"`
	// Message - The export error message.
	Message *string `json:"message,omitempty"`
	// ServerErrorDetail - The server error detail.
	ServerErrorDetail *string `json:"serverErrorDetail,omitempty"`
	// TimeFirstOccured - The date and time when the export error first occurred.
	TimeFirstOccured *date.Time `json:"timeFirstOccured,omitempty"`
	// RetryCount - The retry count.
	RetryCount *int32 `json:"retryCount,omitempty"`
	// CsObjectID - The cloud object Id.
	CsObjectID *string `json:"csObjectId,omitempty"`
	// Dn - The distinguished name.
	Dn *string `json:"dn,omitempty"`
	// MinLimit - The minimum limit.
	MinLimit *string `json:"minLimit,omitempty"`
	// MaxLimit - The maximum limit.
	MaxLimit *string `json:"maxLimit,omitempty"`
	// CloudAnchor - The name of the cloud anchor.
	CloudAnchor *string `json:"cloudAnchor,omitempty"`
	// AttributeName - The attribute name.
	AttributeName *string `json:"attributeName,omitempty"`
	// AttributeValue - The attribute value.
	AttributeValue *string `json:"attributeValue,omitempty"`
	// AttributeMultiValue - Indicates if the attribute is multi valued or not.
	AttributeMultiValue *bool `json:"attributeMultiValue,omitempty"`
	// ObjectIDConflict - The object Id with which there was an attribute conflict.
	ObjectIDConflict *string `json:"objectIdConflict,omitempty"`
	// SamAccountName - The SAM account name.
	SamAccountName *string `json:"samAccountName,omitempty"`
	// AdObjectType - The AD object type
	AdObjectType *string `json:"adObjectType,omitempty"`
	// AdObjectGUID - The AD object guid.
	AdObjectGUID *string `json:"adObjectGuid,omitempty"`
	// AdDisplayName - The display name for the AD object.
	AdDisplayName *string `json:"adDisplayName,omitempty"`
	// AdSourceOfAuthority - The source of authority for the AD object.
	AdSourceOfAuthority *string `json:"adSourceOfAuthority,omitempty"`
	// AdSourceAnchor - The AD source anchor.
	AdSourceAnchor *string `json:"adSourceAnchor,omitempty"`
	// AdUserPrincipalName - The user principal name for the AD object.
	AdUserPrincipalName *string `json:"adUserPrincipalName,omitempty"`
	// AdDistinguishedName - The distinguished name for the AD object.
	AdDistinguishedName *string `json:"adDistinguishedName,omitempty"`
	// AdMail - The email for the AD object.
	AdMail *string `json:"adMail,omitempty"`
	// TimeOccured - The date and time of occurrence.
	TimeOccured *date.Time `json:"timeOccured,omitempty"`
	// AadObjectType - The AAD side object type.
	AadObjectType *string `json:"aadObjectType,omitempty"`
	// AadObjectGUID - The AAD side object guid.
	AadObjectGUID *string `json:"aadObjectGuid,omitempty"`
	// AadDisplayName - The AAD side display name
	AadDisplayName *string `json:"aadDisplayName,omitempty"`
	// AadSourceOfAuthority - The AAD side source of authority for the object.
	AadSourceOfAuthority *string `json:"aadSourceOfAuthority,omitempty"`
	// AadUserPrincipalName - The AAD side user principal name.
	AadUserPrincipalName *string `json:"aadUserPrincipalName,omitempty"`
	// AadDistinguishedName - The AAD side distinguished name for the object.
	AadDistinguishedName *string `json:"aadDistinguishedName,omitempty"`
	// AadMail - The AAD side email for the object.
	AadMail *string `json:"aadMail,omitempty"`
	// LastDirSyncTime - The date and time of last sync run.
	LastDirSyncTime *date.Time `json:"lastDirSyncTime,omitempty"`
	// ModifiedAttributeValue - The modified attribute value.
	ModifiedAttributeValue *string `json:"modifiedAttributeValue,omitempty"`
}

// ExportErrors the list of export errors.
type ExportErrors struct {
	// Value - The value returned by the operation.
	Value *[]ExportError `json:"value,omitempty"`
}

// ExportStatus the details of the export status.
type ExportStatus struct {
	// ServiceID - The id of the service for whom the export status is being reported.
	ServiceID *uuid.UUID `json:"serviceId,omitempty"`
	// ServiceMemberID - The server Id for whom the export status is being reported.
	ServiceMemberID *uuid.UUID `json:"serviceMemberId,omitempty"`
	// EndTime - The date and time when the export ended.
	EndTime *date.Time `json:"endTime,omitempty"`
	// RunStepResultID - The run step result Id.
	RunStepResultID *string `json:"runStepResultId,omitempty"`
}

// ExportStatuses the list of export statuses.
type ExportStatuses struct {
	autorest.Response `json:"-"`
	// NextLink - The link used to get the next page of operations.
	NextLink *string `json:"nextLink,omitempty"`
	// Value - The value returned by the operation.
	Value *[]ExportStatus `json:"value,omitempty"`
	// TotalCount - The total count of service elements.
	TotalCount *int32 `json:"totalCount,omitempty"`
	// ContinuationToken - The continuation token for paginated calls.
	ContinuationToken *string `json:"continuationToken,omitempty"`
}

// ExportStatusesIterator provides access to a complete listing of ExportStatus values.
type ExportStatusesIterator struct {
	i    int
	page ExportStatusesPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *ExportStatusesIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ExportStatusesIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *ExportStatusesIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter ExportStatusesIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter ExportStatusesIterator) Response() ExportStatuses {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter ExportStatusesIterator) Value() ExportStatus {
	if !iter.page.NotDone() {
		return ExportStatus{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the ExportStatusesIterator type.
func NewExportStatusesIterator(page ExportStatusesPage) ExportStatusesIterator {
	return ExportStatusesIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (es ExportStatuses) IsEmpty() bool {
	return es.Value == nil || len(*es.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (es ExportStatuses) hasNextLink() bool {
	return es.NextLink != nil && len(*es.NextLink) != 0
}

// exportStatusesPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (es ExportStatuses) exportStatusesPreparer(ctx context.Context) (*http.Request, error) {
	if !es.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(es.NextLink)))
}

// ExportStatusesPage contains a page of ExportStatus values.
type ExportStatusesPage struct {
	fn func(context.Context, ExportStatuses) (ExportStatuses, error)
	es ExportStatuses
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *ExportStatusesPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ExportStatusesPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.es)
		if err != nil {
			return err
		}
		page.es = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *ExportStatusesPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page ExportStatusesPage) NotDone() bool {
	return !page.es.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page ExportStatusesPage) Response() ExportStatuses {
	return page.es
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page ExportStatusesPage) Values() []ExportStatus {
	if page.es.IsEmpty() {
		return nil
	}
	return *page.es.Value
}

// Creates a new instance of the ExportStatusesPage type.
func NewExportStatusesPage(getNextPage func(context.Context, ExportStatuses) (ExportStatuses, error)) ExportStatusesPage {
	return ExportStatusesPage{fn: getNextPage}
}

// ExtensionErrorInfo the extension error details.
type ExtensionErrorInfo struct {
	// ExtensionName - The extension name.
	ExtensionName *string `json:"extensionName,omitempty"`
	// ExtensionContext - The extension context.
	ExtensionContext *string `json:"extensionContext,omitempty"`
	// CallStack - The call stack for the error.
	CallStack *string `json:"callStack,omitempty"`
}

// ForestSummary the forest summary for an ADDS domain.
type ForestSummary struct {
	autorest.Response `json:"-"`
	// ForestName - The forest name.
	ForestName *string `json:"forestName,omitempty"`
	// DomainCount - The domain count.
	DomainCount *int32 `json:"domainCount,omitempty"`
	// SiteCount - The site count.
	SiteCount *int32 `json:"siteCount,omitempty"`
	// MonitoredDcCount - The number of domain controllers that are monitored by Azure Active Directory Connect Health.
	MonitoredDcCount *int32 `json:"monitoredDcCount,omitempty"`
	// TotalDcCount - The total domain controllers.
	TotalDcCount *int32 `json:"totalDcCount,omitempty"`
	// Domains - The list of domain controller names.
	Domains *[]string `json:"domains,omitempty"`
	// Sites - The list of site names.
	Sites *[]string `json:"sites,omitempty"`
}

// GlobalConfiguration the global configuration settings.
type GlobalConfiguration struct {
	// Version - The version for the global configuration.
	Version *int32 `json:"version,omitempty"`
	// SchemaXML - The schema for the configuration.
	SchemaXML *string `json:"schemaXml,omitempty"`
	// PasswordSyncEnabled - Indicates if password sync is enabled or not.
	PasswordSyncEnabled *bool `json:"passwordSyncEnabled,omitempty"`
	// NumSavedPwdEvent - The number of saved password events.
	NumSavedPwdEvent *int32 `json:"numSavedPwdEvent,omitempty"`
	// FeatureSet - The list of additional feature sets.
	FeatureSet *[]Item `json:"featureSet,omitempty"`
}

// GlobalConfigurations the list of global configurations.
type GlobalConfigurations struct {
	autorest.Response `json:"-"`
	// Value - The value returned by the operation.
	Value *[]GlobalConfiguration `json:"value,omitempty"`
}

// HelpLink the help link which contains more information related to an alert.
type HelpLink struct {
	// Title - The title for the link.
	Title *string `json:"title,omitempty"`
	// URL - The url for the help document.
	URL *string `json:"url,omitempty"`
}

// Hotfix the details of the hotfix installed in the server.
type Hotfix struct {
	// KbName - The name of the hotfix KB.
	KbName *string `json:"kbName,omitempty"`
	// Link - The link to the KB Article.
	Link *string `json:"link,omitempty"`
	// InstalledDate - The date and time, in UTC, when the KB was installed in the server.
	InstalledDate *date.Time `json:"installedDate,omitempty"`
}

// Hotfixes the list of hotfixes installed in the server.
type Hotfixes struct {
	// Value - The value returned by the operation.
	Value *[]Hotfix `json:"value,omitempty"`
}

// ImportError the import error details.
type ImportError struct {
	// ID - The error Id.
	ID *string `json:"id,omitempty"`
	// RunStepResultID - The run step result Id.
	RunStepResultID *string `json:"runStepResultId,omitempty"`
	// ConnectorID - The connector Id.
	ConnectorID *string `json:"connectorId,omitempty"`
	// Type - The type of error.
	Type *string `json:"type,omitempty"`
	// TimeOccurred - The time when the import error occurred.
	TimeOccurred *date.Time `json:"timeOccurred,omitempty"`
	// TimeFirstOccurred - The time when the import error first occurred.
	TimeFirstOccurred *date.Time `json:"timeFirstOccurred,omitempty"`
	// RetryCount - The retry count.
	RetryCount *int32 `json:"retryCount,omitempty"`
	// AlgorithmStepType - The operation type specific  to error reporting. Possible values include: 'Undefined', 'Staging', 'ConnectorFilter', 'Join', 'Projection', 'ImportFlow', 'Provisioning', 'ValidateConnectorFilter', 'Deprovisioning', 'ExportFlow', 'MvDeletion', 'Recall', 'MvObjectTypeChange'
	AlgorithmStepType AlgorithmStepType `json:"algorithmStepType,omitempty"`
	// ChangeNotReimported - The change details that is not re-imported.
	ChangeNotReimported *ChangeNotReimported `json:"changeNotReimported,omitempty"`
	// ExtensionErrorInfo - The extension error information.
	ExtensionErrorInfo *ExtensionErrorInfo `json:"extensionErrorInfo,omitempty"`
	// RuleErrorInfo - The error details in legacy rule processing.
	RuleErrorInfo *RuleErrorInfo `json:"ruleErrorInfo,omitempty"`
	// CsObjectID - The object Id.
	CsObjectID *string `json:"csObjectId,omitempty"`
	// Dn - The distinguished name.
	Dn *string `json:"dn,omitempty"`
}

// ImportErrors the list of import errors.
type ImportErrors struct {
	// Value - The value returned by the operation.
	Value *[]ImportError `json:"value,omitempty"`
}

// InboundReplicationNeighbor the replication summary for the domain controller inbound neighbor.
type InboundReplicationNeighbor struct {
	// SourceDomainController - The name of the source domain controller.
	SourceDomainController *string `json:"sourceDomainController,omitempty"`
	// ConsecutiveFailureCount - The number of consecutive failure counts.
	ConsecutiveFailureCount *int32 `json:"consecutiveFailureCount,omitempty"`
	// NamingContext - The naming context.
	NamingContext *string `json:"namingContext,omitempty"`
	// Status - The health status for the domain controller
	Status *int32 `json:"status,omitempty"`
	// LastAttemptedSync - The last time a sync was attempted on the domain controller.
	LastAttemptedSync *date.Time `json:"lastAttemptedSync,omitempty"`
	// LastSuccessfulSync - The last time when a successful sync happened.
	LastSuccessfulSync *date.Time `json:"lastSuccessfulSync,omitempty"`
	// LastErrorCode - The last error code.
	LastErrorCode *int32 `json:"lastErrorCode,omitempty"`
	// LastErrorMessage - The error message of the last error.
	LastErrorMessage *string `json:"lastErrorMessage,omitempty"`
	// ErrorTitle - The error title.
	ErrorTitle *string `json:"errorTitle,omitempty"`
	// ErrorDescription - The error description.
	ErrorDescription *string `json:"errorDescription,omitempty"`
	// FixLink - The link for the fix of the error.
	FixLink *string `json:"fixLink,omitempty"`
	// FixDetails - The details of the fix.
	FixDetails *string `json:"fixDetails,omitempty"`
	// AdditionalInfo - The additional details.
	AdditionalInfo *string `json:"additionalInfo,omitempty"`
}

// InboundReplicationNeighbors the list of replication summary for the domain controller inbound neighbor.
type InboundReplicationNeighbors struct {
	// Value - The details of inbound replication neighbors.
	Value *[]InboundReplicationNeighbor `json:"value,omitempty"`
}

// IPAddressAggregate the key value pair for properties.
type IPAddressAggregate struct {
	// ID - Unique ID for the entree
	ID *string `json:"id,omitempty"`
	// TenantID - The tenant ID
	TenantID *string `json:"tenantId,omitempty"`
	// ServiceID - The service ID
	ServiceID *string `json:"serviceId,omitempty"`
	// IPAddress - The IP address from where the attempted login originated from.
	IPAddress *string `json:"ipAddress,omitempty"`
	// Timestamp - When the event occurred
	Timestamp *string `json:"timestamp,omitempty"`
	// FirstAuditTimestamp - The first audit timestamp
	FirstAuditTimestamp *string `json:"firstAuditTimestamp,omitempty"`
	// LastAuditTimestamp - The last audit timestamp
	LastAuditTimestamp *string `json:"lastAuditTimestamp,omitempty"`
	// ExtranetLockoutErrorCount - The extranet lockout error count
	ExtranetLockoutErrorCount *int32 `json:"extranetLockoutErrorCount,omitempty"`
	// BadPasswordErrorCount - The bad password error count
	BadPasswordErrorCount *int32 `json:"badPasswordErrorCount,omitempty"`
	// UniqueUsernamesAttemptedCount - The unique usernames attempted
	UniqueUsernamesAttemptedCount *int32 `json:"uniqueUsernamesAttemptedCount,omitempty"`
	// AttemptCountThresholdIsExceeded - A value indicating whether the attempt count threshold been exceeded
	AttemptCountThresholdIsExceeded *bool `json:"attemptCountThresholdIsExceeded,omitempty"`
	// TimeSpan - The duration of the event
	TimeSpan *string `json:"timeSpan,omitempty"`
	// IsWhitelistedIPAddress - A value indicating whether the IP address has been whitelisted.
	IsWhitelistedIPAddress *bool `json:"isWhitelistedIpAddress,omitempty"`
	// NetworkLocation - The network location
	NetworkLocation *string `json:"networkLocation,omitempty"`
	// AttemptCountThresholdOnTrigger - The attempted count threshold on trigger.
	AttemptCountThresholdOnTrigger *int32 `json:"attemptCountThresholdOnTrigger,omitempty"`
	// AttemptThresholdTypeOnTrigger - The attempted threshold type on trigger.
	AttemptThresholdTypeOnTrigger *string `json:"attemptThresholdTypeOnTrigger,omitempty"`
	// GeographicLocation - The geographic location.
	GeographicLocation *string `json:"geographicLocation,omitempty"`
}

// IPAddressAggregates IP address aggregates.
type IPAddressAggregates struct {
	autorest.Response `json:"-"`
	// Value - The value returned by the operation.
	Value *[]IPAddressAggregate `json:"value,omitempty"`
	// NextLink - URL to get the next set of IP Aggregate list results if there are any.
	NextLink *string `json:"nextLink,omitempty"`
	// TotalCount - The number of results.
	TotalCount *int32 `json:"totalCount,omitempty"`
	// ContinuationToken - The continuation token for paginated calls.
	ContinuationToken *string `json:"continuationToken,omitempty"`
}

// IPAddressAggregateSetting the key value pair for IP aggregate thresholds.
type IPAddressAggregateSetting struct {
	autorest.Response `json:"-"`
	// ID - Unique ID for the entree
	ID *string `json:"id,omitempty"`
	// BadPasswordAndExtranetLockoutCombinedDailyThreshold - This threshold setting defines the per day trigger for a new event to be generated in the report.
	BadPasswordAndExtranetLockoutCombinedDailyThreshold *int32 `json:"badPasswordAndExtranetLockoutCombinedDailyThreshold,omitempty"`
	// BadPasswordAndExtranetLockoutCombinedHourlyThreshold - This threshold setting defines the per hour trigger for a new event to be generated in the report.
	BadPasswordAndExtranetLockoutCombinedHourlyThreshold *int32 `json:"badPasswordAndExtranetLockoutCombinedHourlyThreshold,omitempty"`
	// ExtranetLockoutDailyThreshold - This threshold setting defines the per hour trigger for a new event to be generated in the report.
	ExtranetLockoutDailyThreshold *int32 `json:"extranetLockoutDailyThreshold,omitempty"`
	// ExtranetLockoutHourlyThreshold - This threshold setting defines the per hour trigger for a new event to be generated in the report.
	ExtranetLockoutHourlyThreshold *int32 `json:"extranetLockoutHourlyThreshold,omitempty"`
	// EmailNotificationEnabled - A value indicating whether email notification has been enabled.
	EmailNotificationEnabled *bool `json:"emailNotificationEnabled,omitempty"`
}

// IPAddressAggregatesIterator provides access to a complete listing of IPAddressAggregate values.
type IPAddressAggregatesIterator struct {
	i    int
	page IPAddressAggregatesPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *IPAddressAggregatesIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/IPAddressAggregatesIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *IPAddressAggregatesIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter IPAddressAggregatesIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter IPAddressAggregatesIterator) Response() IPAddressAggregates {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter IPAddressAggregatesIterator) Value() IPAddressAggregate {
	if !iter.page.NotDone() {
		return IPAddressAggregate{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the IPAddressAggregatesIterator type.
func NewIPAddressAggregatesIterator(page IPAddressAggregatesPage) IPAddressAggregatesIterator {
	return IPAddressAggregatesIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (iaa IPAddressAggregates) IsEmpty() bool {
	return iaa.Value == nil || len(*iaa.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (iaa IPAddressAggregates) hasNextLink() bool {
	return iaa.NextLink != nil && len(*iaa.NextLink) != 0
}

// iPAddressAggregatesPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (iaa IPAddressAggregates) iPAddressAggregatesPreparer(ctx context.Context) (*http.Request, error) {
	if !iaa.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(iaa.NextLink)))
}

// IPAddressAggregatesPage contains a page of IPAddressAggregate values.
type IPAddressAggregatesPage struct {
	fn  func(context.Context, IPAddressAggregates) (IPAddressAggregates, error)
	iaa IPAddressAggregates
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *IPAddressAggregatesPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/IPAddressAggregatesPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.iaa)
		if err != nil {
			return err
		}
		page.iaa = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *IPAddressAggregatesPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page IPAddressAggregatesPage) NotDone() bool {
	return !page.iaa.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page IPAddressAggregatesPage) Response() IPAddressAggregates {
	return page.iaa
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page IPAddressAggregatesPage) Values() []IPAddressAggregate {
	if page.iaa.IsEmpty() {
		return nil
	}
	return *page.iaa.Value
}

// Creates a new instance of the IPAddressAggregatesPage type.
func NewIPAddressAggregatesPage(getNextPage func(context.Context, IPAddressAggregates) (IPAddressAggregates, error)) IPAddressAggregatesPage {
	return IPAddressAggregatesPage{fn: getNextPage}
}

// Item the key value pair for properties.
type Item struct {
	// Key - The key for the property.
	Key *string `json:"key,omitempty"`
	// Value - The value for the key.
	Value *string `json:"value,omitempty"`
}

// Items the list of key value properties.
type Items struct {
	autorest.Response `json:"-"`
	// Value - The value returned by the operation.
	Value *[]Item `json:"value,omitempty"`
}

// MergedExportError the merged export error.
type MergedExportError struct {
	// ID - The error Id.
	ID *string `json:"id,omitempty"`
	// IncomingObjectDisplayName - The incoming object display name.
	IncomingObjectDisplayName *string `json:"incomingObjectDisplayName,omitempty"`
	// IncomingObjectType - The incoming object type.
	IncomingObjectType *string `json:"incomingObjectType,omitempty"`
	// UserPrincipalName - The user principal name
	UserPrincipalName *string `json:"userPrincipalName,omitempty"`
	// Type - The type of the error.
	Type *string `json:"type,omitempty"`
	// AttributeName - The attribute name.
	AttributeName *string `json:"attributeName,omitempty"`
	// AttributeValue - The attribute value.
	AttributeValue *string `json:"attributeValue,omitempty"`
	// TimeOccurred - The date and time when the error occurred.
	TimeOccurred *date.Time `json:"timeOccurred,omitempty"`
	// TimeFirstOccurred - The time when the error first occurred.
	TimeFirstOccurred *date.Time `json:"timeFirstOccurred,omitempty"`
	// CsObjectID -  the cs object Id.
	CsObjectID *string `json:"csObjectId,omitempty"`
	// Dn - the DN of the object.
	Dn *string `json:"dn,omitempty"`
	// IncomingObject - The incoming object details.
	IncomingObject *AssociatedObject `json:"incomingObject,omitempty"`
	// ExistingObject - The existing object
	ExistingObject *AssociatedObject `json:"existingObject,omitempty"`
	// ModifiedOrRemovedAttributeValue - The modified or removed attribute value.
	ModifiedOrRemovedAttributeValue *string `json:"modifiedOrRemovedAttributeValue,omitempty"`
	// RunStepResultID - The run step result Id.
	RunStepResultID *uuid.UUID `json:"runStepResultId,omitempty"`
	// SamAccountName - The sam account name.
	SamAccountName *string `json:"samAccountName,omitempty"`
	// ServerErrorDetail - The server error details.
	ServerErrorDetail *string `json:"serverErrorDetail,omitempty"`
	// ServiceID - The service Id.
	ServiceID *uuid.UUID `json:"serviceId,omitempty"`
	// ServiceMemberID - The server Id.
	ServiceMemberID *uuid.UUID `json:"serviceMemberId,omitempty"`
	// MergedEntityID - The merged entity Id.
	MergedEntityID *uuid.UUID `json:"mergedEntityId,omitempty"`
	// CreatedDate - The date and time, in UTC, when the error was created.
	CreatedDate *date.Time `json:"createdDate,omitempty"`
	// ExportErrorStatus - The export error status.
	ExportErrorStatus *int32 `json:"exportErrorStatus,omitempty"`
}

// MergedExportErrors the list of export errors.
type MergedExportErrors struct {
	autorest.Response `json:"-"`
	// Value - The value returned by the operation.
	Value *[]MergedExportError `json:"value,omitempty"`
}

// MetricGroup the metric group details.
type MetricGroup struct {
	// Key - The key for the group.
	Key *string `json:"key,omitempty"`
	// DisplayName - The display name for the group.
	DisplayName *string `json:"displayName,omitempty"`
	// InvisibleForUI - indicates if the metric group is displayed in Azure Active Directory Connect Health UI.
	InvisibleForUI *bool `json:"invisibleForUi,omitempty"`
}

// MetricMetadata the metric meta data
type MetricMetadata struct {
	autorest.Response `json:"-"`
	// MetricsProcessorClassName - The name of the class which retrieve and process the metric.
	MetricsProcessorClassName *string `json:"metricsProcessorClassName,omitempty"`
	// MetricName - The metric name
	MetricName *string `json:"metricName,omitempty"`
	// Groupings - The groupings for the metrics.
	Groupings *[]MetricGroup `json:"groupings,omitempty"`
	// DisplayName - The display name for the metric.
	DisplayName *string `json:"displayName,omitempty"`
	// ValueKind - Indicates if the metrics is a rate,value, percent or duration type.
	ValueKind *string `json:"valueKind,omitempty"`
	// MinValue - The minimum value.
	MinValue *int32 `json:"minValue,omitempty"`
	// MaxValue - The maximum value.
	MaxValue *int32 `json:"maxValue,omitempty"`
	// Kind - Indicates whether the dashboard to represent the metric is a line, bar,pie, area or donut chart.
	Kind *string `json:"kind,omitempty"`
	// IsDefault - Indicates if the metric is a default metric or not.
	IsDefault *bool `json:"isDefault,omitempty"`
	// IsPerfCounter - Indicates if the metric is a performance counter metric or not.
	IsPerfCounter *bool `json:"isPerfCounter,omitempty"`
	// IsDevOps - Indicates if the metric is visible to DevOps or not.
	IsDevOps *bool `json:"isDevOps,omitempty"`
}

// MetricMetadataList the list of metric metadata.
type MetricMetadataList struct {
	autorest.Response `json:"-"`
	// NextLink - The link used to get the next page of operations.
	NextLink *string `json:"nextLink,omitempty"`
	// Value - The value returned by the operation.
	Value *[]MetricMetadata `json:"value,omitempty"`
	// TotalCount - The total count of service elements.
	TotalCount *int32 `json:"totalCount,omitempty"`
	// ContinuationToken - The continuation token for paginated calls.
	ContinuationToken *string `json:"continuationToken,omitempty"`
}

// MetricMetadataListIterator provides access to a complete listing of MetricMetadata values.
type MetricMetadataListIterator struct {
	i    int
	page MetricMetadataListPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *MetricMetadataListIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/MetricMetadataListIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *MetricMetadataListIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter MetricMetadataListIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter MetricMetadataListIterator) Response() MetricMetadataList {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter MetricMetadataListIterator) Value() MetricMetadata {
	if !iter.page.NotDone() {
		return MetricMetadata{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the MetricMetadataListIterator type.
func NewMetricMetadataListIterator(page MetricMetadataListPage) MetricMetadataListIterator {
	return MetricMetadataListIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (mml MetricMetadataList) IsEmpty() bool {
	return mml.Value == nil || len(*mml.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (mml MetricMetadataList) hasNextLink() bool {
	return mml.NextLink != nil && len(*mml.NextLink) != 0
}

// metricMetadataListPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (mml MetricMetadataList) metricMetadataListPreparer(ctx context.Context) (*http.Request, error) {
	if !mml.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(mml.NextLink)))
}

// MetricMetadataListPage contains a page of MetricMetadata values.
type MetricMetadataListPage struct {
	fn  func(context.Context, MetricMetadataList) (MetricMetadataList, error)
	mml MetricMetadataList
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *MetricMetadataListPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/MetricMetadataListPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.mml)
		if err != nil {
			return err
		}
		page.mml = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *MetricMetadataListPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page MetricMetadataListPage) NotDone() bool {
	return !page.mml.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page MetricMetadataListPage) Response() MetricMetadataList {
	return page.mml
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page MetricMetadataListPage) Values() []MetricMetadata {
	if page.mml.IsEmpty() {
		return nil
	}
	return *page.mml.Value
}

// Creates a new instance of the MetricMetadataListPage type.
func NewMetricMetadataListPage(getNextPage func(context.Context, MetricMetadataList) (MetricMetadataList, error)) MetricMetadataListPage {
	return MetricMetadataListPage{fn: getNextPage}
}

// Metrics the list of metric items.
type Metrics struct {
	autorest.Response `json:"-"`
	// NextLink - The link used to get the next page of operations.
	NextLink *string `json:"nextLink,omitempty"`
	// Value - The value returned by the operation.
	Value *[]Item `json:"value,omitempty"`
	// TotalCount - The total count of metrics.
	TotalCount *int32 `json:"totalCount,omitempty"`
	// ContinuationToken - The continuation token for paginated calls.
	ContinuationToken *string `json:"continuationToken,omitempty"`
}

// MetricSet the set of metric values. Example of a MetricSet are Values of token requests for a Server1 or
// RelyingParty1.
type MetricSet struct {
	// SetName - The name of the set.
	SetName *string `json:"setName,omitempty"`
	// Values - The list of the metric values.
	Values *[]int32 `json:"values,omitempty"`
}

// MetricSets the metrics data represented set.
type MetricSets struct {
	autorest.Response `json:"-"`
	// Sets - The list of metric set.
	Sets *[]MetricSet `json:"sets,omitempty"`
	// TimeStamps - The list of timestamps for each metric in the metric set.
	TimeStamps *[]date.Time `json:"timeStamps,omitempty"`
}

// MetricsIterator provides access to a complete listing of Item values.
type MetricsIterator struct {
	i    int
	page MetricsPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *MetricsIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/MetricsIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *MetricsIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter MetricsIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter MetricsIterator) Response() Metrics {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter MetricsIterator) Value() Item {
	if !iter.page.NotDone() {
		return Item{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the MetricsIterator type.
func NewMetricsIterator(page MetricsPage) MetricsIterator {
	return MetricsIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (mVar Metrics) IsEmpty() bool {
	return mVar.Value == nil || len(*mVar.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (mVar Metrics) hasNextLink() bool {
	return mVar.NextLink != nil && len(*mVar.NextLink) != 0
}

// metricsPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (mVar Metrics) metricsPreparer(ctx context.Context) (*http.Request, error) {
	if !mVar.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(mVar.NextLink)))
}

// MetricsPage contains a page of Item values.
type MetricsPage struct {
	fn   func(context.Context, Metrics) (Metrics, error)
	mVar Metrics
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *MetricsPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/MetricsPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.mVar)
		if err != nil {
			return err
		}
		page.mVar = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *MetricsPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page MetricsPage) NotDone() bool {
	return !page.mVar.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page MetricsPage) Response() Metrics {
	return page.mVar
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page MetricsPage) Values() []Item {
	if page.mVar.IsEmpty() {
		return nil
	}
	return *page.mVar.Value
}

// Creates a new instance of the MetricsPage type.
func NewMetricsPage(getNextPage func(context.Context, Metrics) (Metrics, error)) MetricsPage {
	return MetricsPage{fn: getNextPage}
}

// ModuleConfiguration the module configuration as required by the Agent service.
type ModuleConfiguration struct {
	// AgentService - The name of agent service.
	AgentService *string `json:"agentService,omitempty"`
	// ModuleName - The name of the module for which the configuration is applicable.
	ModuleName *string `json:"moduleName,omitempty"`
	// Properties - The key value pairs of properties required for configuration.
	Properties map[string]*string `json:"properties"`
}

// MarshalJSON is the custom marshaler for ModuleConfiguration.
func (mc ModuleConfiguration) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if mc.AgentService != nil {
		objectMap["agentService"] = mc.AgentService
	}
	if mc.ModuleName != nil {
		objectMap["moduleName"] = mc.ModuleName
	}
	if mc.Properties != nil {
		objectMap["properties"] = mc.Properties
	}
	return json.Marshal(objectMap)
}

// ModuleConfigurations the list of module configurations.
type ModuleConfigurations struct {
	// Value - The value returned by the operation.
	Value *[]ModuleConfiguration `json:"value,omitempty"`
}

// ObjectWithSyncError the objects with sync errors.
type ObjectWithSyncError struct {
	// SourceOfAuthority - The source of authority.
	SourceOfAuthority *string `json:"sourceOfAuthority,omitempty"`
	// DisplayName - The display name.
	DisplayName *string `json:"displayName,omitempty"`
	// ObjectType - The object type.
	ObjectType *string `json:"objectType,omitempty"`
	// AttributeName - The attribute name.
	AttributeName *string `json:"attributeName,omitempty"`
	// AttributeValue - The attribute value.
	AttributeValue *string `json:"attributeValue,omitempty"`
	// ModififedValue - The modified value.
	ModififedValue *string `json:"modififedValue,omitempty"`
	// UserPrincipalName - The user principal name.
	UserPrincipalName *string `json:"userPrincipalName,omitempty"`
	// ObjectGUID - The object guid.
	ObjectGUID *string `json:"objectGuid,omitempty"`
	// AttributeMultiValues - Indicates if the attribute is multi-valued or not.
	AttributeMultiValues *bool `json:"attributeMultiValues,omitempty"`
	// MinLimit - The minimum limit.
	MinLimit *string `json:"minLimit,omitempty"`
	// MaxLimit - The maximum limit.
	MaxLimit *string `json:"maxLimit,omitempty"`
	// DistinguishedName - The distinguished name.
	DistinguishedName *string `json:"distinguishedName,omitempty"`
	// Mail - The email.
	Mail *string `json:"mail,omitempty"`
	// TimeOccured - The date and time of occurrence.
	TimeOccured *date.Time `json:"timeOccured,omitempty"`
	// ErrorType - The error type.
	ErrorType *string `json:"errorType,omitempty"`
	// SourceAnchor - The source anchor.
	SourceAnchor *string `json:"sourceAnchor,omitempty"`
}

// Operation the details of the operation.
type Operation struct {
	// Name - The name of the operation.
	Name *string `json:"name,omitempty"`
	// Display - The display details for the operation.
	Display interface{} `json:"display,omitempty"`
}

// OperationListResponse lists all of the available REST API operations for Azure Active Directory Connect
// Health.
type OperationListResponse struct {
	autorest.Response `json:"-"`
	// NextLink - READ-ONLY; URL to get the next set of operation list results if there are any.
	NextLink *string `json:"nextLink,omitempty"`
	// Value - READ-ONLY; List of operations supported by the Microsoft.ADHybridHealthService resource provider.
	Value *[]Operation `json:"value,omitempty"`
	// TotalCount - The total count of operations.
	TotalCount *int32 `json:"totalCount,omitempty"`
	// ContinuationToken - The continuation token to get next set of operations.
	ContinuationToken *string `json:"continuationToken,omitempty"`
}

// MarshalJSON is the custom marshaler for OperationListResponse.
func (olr OperationListResponse) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if olr.TotalCount != nil {
		objectMap["totalCount"] = olr.TotalCount
	}
	if olr.ContinuationToken != nil {
		objectMap["continuationToken"] = olr.ContinuationToken
	}
	return json.Marshal(objectMap)
}

// OperationListResponseIterator provides access to a complete listing of Operation values.
type OperationListResponseIterator struct {
	i    int
	page OperationListResponsePage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *OperationListResponseIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/OperationListResponseIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *OperationListResponseIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter OperationListResponseIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter OperationListResponseIterator) Response() OperationListResponse {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter OperationListResponseIterator) Value() Operation {
	if !iter.page.NotDone() {
		return Operation{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the OperationListResponseIterator type.
func NewOperationListResponseIterator(page OperationListResponsePage) OperationListResponseIterator {
	return OperationListResponseIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (olr OperationListResponse) IsEmpty() bool {
	return olr.Value == nil || len(*olr.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (olr OperationListResponse) hasNextLink() bool {
	return olr.NextLink != nil && len(*olr.NextLink) != 0
}

// operationListResponsePreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (olr OperationListResponse) operationListResponsePreparer(ctx context.Context) (*http.Request, error) {
	if !olr.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(olr.NextLink)))
}

// OperationListResponsePage contains a page of Operation values.
type OperationListResponsePage struct {
	fn  func(context.Context, OperationListResponse) (OperationListResponse, error)
	olr OperationListResponse
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *OperationListResponsePage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/OperationListResponsePage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.olr)
		if err != nil {
			return err
		}
		page.olr = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *OperationListResponsePage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page OperationListResponsePage) NotDone() bool {
	return !page.olr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page OperationListResponsePage) Response() OperationListResponse {
	return page.olr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page OperationListResponsePage) Values() []Operation {
	if page.olr.IsEmpty() {
		return nil
	}
	return *page.olr.Value
}

// Creates a new instance of the OperationListResponsePage type.
func NewOperationListResponsePage(getNextPage func(context.Context, OperationListResponse) (OperationListResponse, error)) OperationListResponsePage {
	return OperationListResponsePage{fn: getNextPage}
}

// Partition describes the partition in Synchronization service.
type Partition struct {
	// ID - The partition Id.
	ID *string `json:"id,omitempty"`
	// Dn - The distinguished name for the partition.
	Dn *string `json:"dn,omitempty"`
	// Enabled - Indicates if the partition object is selected or not.
	Enabled *bool `json:"enabled,omitempty"`
	// TimeCreated - The date and time when the partition is created.
	TimeCreated *date.Time `json:"timeCreated,omitempty"`
	// TimeLastModified - The time and date when the partition was last modified.
	TimeLastModified *date.Time `json:"timeLastModified,omitempty"`
	// PartitionScope - The scope of the partition.
	PartitionScope *PartitionScope `json:"partitionScope,omitempty"`
	// Name - The name of the partition.
	Name *string `json:"name,omitempty"`
	// IsDomain - Indicates if the partition is a domain or not.
	IsDomain *bool `json:"isDomain,omitempty"`
	// Type - The partition type.
	Type *string `json:"type,omitempty"`
}

// PartitionScope the connector partition scope.
type PartitionScope struct {
	// IsDefault - Indicates if the partition scope is default or not.
	IsDefault *bool `json:"isDefault,omitempty"`
	// ObjectClasses - The in-scope object classes.
	ObjectClasses *[]string `json:"objectClasses,omitempty"`
	// ContainersIncluded - The list of containers included.
	ContainersIncluded *[]string `json:"containersIncluded,omitempty"`
	// ContainersExcluded - The list of containers excluded.
	ContainersExcluded *[]string `json:"containersExcluded,omitempty"`
}

// PasswordHashSyncConfiguration the password has synchronization configuration settings.
type PasswordHashSyncConfiguration struct {
	// Enabled - Indicates if the password hash synchronization configuration settings is enabled.
	Enabled *bool `json:"enabled,omitempty"`
	// Target - The target.
	Target *string `json:"target,omitempty"`
}

// PasswordManagementSettings the password management settings.
type PasswordManagementSettings struct {
	// Enabled - Indicates if the password extension is enabled.
	Enabled *bool `json:"enabled,omitempty"`
	// ExtensionFilePath - The file path of the password management extension.
	ExtensionFilePath *string `json:"extensionFilePath,omitempty"`
	// ConnectTo - Connection point of password management.
	ConnectTo *string `json:"connectTo,omitempty"`
	// ConnectionTimeout - Connection timeout for password extension.
	ConnectionTimeout *int32 `json:"connectionTimeout,omitempty"`
	// User - User to execute password extension.
	User *string `json:"user,omitempty"`
	// SupportedPasswordOperations - The supported password operations. Possible values include: 'PasswordOperationTypesUndefined', 'PasswordOperationTypesSet', 'PasswordOperationTypesChange'
	SupportedPasswordOperations PasswordOperationTypes `json:"supportedPasswordOperations,omitempty"`
	// MaximumRetryCount - The maximum number of retries.
	MaximumRetryCount *int32 `json:"maximumRetryCount,omitempty"`
	// RetryIntervalInSeconds - The time between retries.
	RetryIntervalInSeconds *int32 `json:"retryIntervalInSeconds,omitempty"`
	// RequiresSecureConnection - Indicates if a secure connection is required for password management.
	RequiresSecureConnection *bool `json:"requiresSecureConnection,omitempty"`
	// UnlockAccount - Indicates if accounts should be unlocked when resetting password.
	UnlockAccount *bool `json:"unlockAccount,omitempty"`
}

// ReplicationDetailsList the list of replication details.
type ReplicationDetailsList struct {
	autorest.Response `json:"-"`
	// Value - The value returned by the operation.
	Value *[]ReplicationSummary `json:"value,omitempty"`
	// TotalCount - The total count of replication detail elements.
	TotalCount *int32 `json:"totalCount,omitempty"`
	// ContinuationToken - The continuation token for paginated calls.
	ContinuationToken *string `json:"continuationToken,omitempty"`
	// NextLink - The link used to get the next page of operations.
	NextLink *string `json:"nextLink,omitempty"`
}

// ReplicationStatus replication summary for a domain controller.
type ReplicationStatus struct {
	autorest.Response `json:"-"`
	// ForestName - The forest name.
	ForestName *string `json:"forestName,omitempty"`
	// TotalDcCount - The total number of domain controllers for a given forest.
	TotalDcCount *int32 `json:"totalDcCount,omitempty"`
	// ErrorDcCount - The total number of domain controllers with error in a given forest.
	ErrorDcCount *int32 `json:"errorDcCount,omitempty"`
}

// ReplicationSummary the replication summary for a domain controller.
type ReplicationSummary struct {
	// TargetServer - The domain controller name.
	TargetServer *string `json:"targetServer,omitempty"`
	// Site - The site name for a given domain controller.
	Site *string `json:"site,omitempty"`
	// Domain - The domain name for a given domain controller.
	Domain *string `json:"domain,omitempty"`
	// Status - The health status for a domain controller.
	Status *int32 `json:"status,omitempty"`
	// LastAttemptedSync - The last time when a sync was attempted for a given domain controller.
	LastAttemptedSync *date.Time `json:"lastAttemptedSync,omitempty"`
	// LastSuccessfulSync - The time when the last successful sync happened for a given domain controller.
	LastSuccessfulSync *date.Time `json:"lastSuccessfulSync,omitempty"`
	// InboundNeighborCollection - List of individual domain controller neighbor's inbound replication status.
	InboundNeighborCollection *[]InboundReplicationNeighbor `json:"inboundNeighborCollection,omitempty"`
}

// ReplicationSummaryList the list of replication summary details.
type ReplicationSummaryList struct {
	autorest.Response `json:"-"`
	// Value - The value returned by the operation.
	Value *[]ReplicationSummary `json:"value,omitempty"`
}

// Result the result for an operation.
type Result struct {
	autorest.Response `json:"-"`
	// Value - The value.
	Value *bool `json:"value,omitempty"`
}

// RiskyIPBlobURI the blob uri pointing to Risky IP Report.
type RiskyIPBlobURI struct {
	// TenantID - The tenant id for whom the report belongs to.
	TenantID *string `json:"tenantId,omitempty"`
	// ServiceID - The service id for whom the report belongs to.
	ServiceID *string `json:"serviceId,omitempty"`
	// ResultSasURI - The blob uri for the report.
	ResultSasURI *string `json:"resultSasUri,omitempty"`
	// BlobCreateDateTime - Time at which the new Risky IP report was requested.
	BlobCreateDateTime *date.Time `json:"blobCreateDateTime,omitempty"`
	// JobCompletionTime - Time at which the blob creation job for the new Risky IP report was completed.
	JobCompletionTime *date.Time `json:"jobCompletionTime,omitempty"`
	// Status - Status of the Risky IP report generation.
	Status *string `json:"status,omitempty"`
}

// RiskyIPBlobUris the list containing blob uris.
type RiskyIPBlobUris struct {
	autorest.Response `json:"-"`
	// Value - The list of blob uris.
	Value *[]RiskyIPBlobURI `json:"value,omitempty"`
}

// RuleErrorInfo the error details in legacy rule processing.
type RuleErrorInfo struct {
	// AttributeMapping - The attribute mapping details.
	AttributeMapping *AttributeMapping `json:"attributeMapping,omitempty"`
	// ConnectorID - The connector Id.
	ConnectorID *string `json:"connectorId,omitempty"`
	// ConnectorName - The connector name.
	ConnectorName *string `json:"connectorName,omitempty"`
	// CsObjectID - The object Id.
	CsObjectID *string `json:"csObjectId,omitempty"`
	// Dn - The distinguished name.
	Dn *string `json:"dn,omitempty"`
}

// RunProfile describes the run profile.
type RunProfile struct {
	// ID - The run profile Id.
	ID *string `json:"id,omitempty"`
	// Name - The run profile name
	Name *string `json:"name,omitempty"`
	// RunSteps - The run steps of the run profile.
	RunSteps *[]RunStep `json:"runSteps,omitempty"`
}

// RunProfiles the list of run profiles.
type RunProfiles struct {
	// Value - The value returned by the operation.
	Value *[]RunProfile `json:"value,omitempty"`
}

// RunStep the run step for a run profile.
type RunStep struct {
	// BatchSize - The batch size used by the run step.
	BatchSize *int32 `json:"batchSize,omitempty"`
	// ObjectProcessLimit - The object processing limit.
	ObjectProcessLimit *int32 `json:"objectProcessLimit,omitempty"`
	// ObjectDeleteLimit - The object deletion limit.
	ObjectDeleteLimit *int32 `json:"objectDeleteLimit,omitempty"`
	// PageSize - The page size of the run step.
	PageSize *int32 `json:"pageSize,omitempty"`
	// PartitionID - The Id of the partition that a current run step operation is executing.
	PartitionID *string `json:"partitionId,omitempty"`
	// OperationType - The run step operation types.
	OperationType *int32 `json:"operationType,omitempty"`
	// Timeout - The operation timeout.
	Timeout *int32 `json:"timeout,omitempty"`
}

// ServiceConfiguration the service configuration
type ServiceConfiguration struct {
	autorest.Response `json:"-"`
	// Version - The version of the sync service.
	Version *string `json:"version,omitempty"`
	// ServiceType - The service type of the server.
	ServiceType *int32 `json:"serviceType,omitempty"`
	// ServiceAccount - The service account.
	ServiceAccount *string `json:"serviceAccount,omitempty"`
	// SQLServer - The SQL server information.
	SQLServer *string `json:"sqlServer,omitempty"`
	// SQLVersion - The SQL version.
	SQLVersion *string `json:"sqlVersion,omitempty"`
	// SQLEdition - The SQL edition
	SQLEdition *string `json:"sqlEdition,omitempty"`
	// SQLInstance - The SQL instance details.
	SQLInstance *string `json:"sqlInstance,omitempty"`
	// SQLDatabaseName - The SQL database.
	SQLDatabaseName *string `json:"sqlDatabaseName,omitempty"`
	// SQLDatabaseSize - The SQL database size.
	SQLDatabaseSize *int32 `json:"sqlDatabaseSize,omitempty"`
}

// ServiceMember the server properties for a given service.
type ServiceMember struct {
	autorest.Response `json:"-"`
	// ServiceMemberID - The id of the server.
	ServiceMemberID *string `json:"serviceMemberId,omitempty"`
	// ServiceID - The service id to whom this server belongs.
	ServiceID *string `json:"serviceId,omitempty"`
	// TenantID - The tenant id to whom this server belongs.
	TenantID *string `json:"tenantId,omitempty"`
	// ActiveAlerts - The total number of alerts that are currently active for the server.
	ActiveAlerts *int32 `json:"activeAlerts,omitempty"`
	// AdditionalInformation - The additional information, if any, for the server.
	AdditionalInformation *string `json:"additionalInformation,omitempty"`
	// CreatedDate - The date time , in UTC, when the server was onboarded to Azure Active Directory Connect Health.
	CreatedDate *date.Time `json:"createdDate,omitempty"`
	// Dimensions - The server specific configuration related dimensions.
	Dimensions interface{} `json:"dimensions,omitempty"`
	// Disabled - Indicates if the server is disabled or not.
	Disabled *bool `json:"disabled,omitempty"`
	// DisabledReason - The reason for disabling the server.
	DisabledReason *int32 `json:"disabledReason,omitempty"`
	// InstalledQfes - The list of installed QFEs for the server.
	InstalledQfes interface{} `json:"installedQfes,omitempty"`
	// LastDisabled - The date and time , in UTC, when the server was last disabled.
	LastDisabled *date.Time `json:"lastDisabled,omitempty"`
	// LastReboot - The date and time, in UTC, when the server was last rebooted.
	LastReboot *date.Time `json:"lastReboot,omitempty"`
	// LastServerReportedMonitoringLevelChange - The date and time, in UTC, when the server's data monitoring configuration was last changed.
	LastServerReportedMonitoringLevelChange *date.Time `json:"lastServerReportedMonitoringLevelChange,omitempty"`
	// LastUpdated - The date and time, in UTC, when the server properties were last updated.
	LastUpdated *date.Time `json:"lastUpdated,omitempty"`
	// MachineID - The id of the machine.
	MachineID *string `json:"machineId,omitempty"`
	// MachineName - The name of the server.
	MachineName *string `json:"machineName,omitempty"`
	// MonitoringConfigurationsComputed - The monitoring configuration of the server which determines what activities are monitored by Azure Active Directory Connect Health.
	MonitoringConfigurationsComputed interface{} `json:"monitoringConfigurationsComputed,omitempty"`
	// MonitoringConfigurationsCustomized - The customized monitoring configuration of the server which determines what activities are monitored by Azure Active Directory Connect Health.
	MonitoringConfigurationsCustomized interface{} `json:"monitoringConfigurationsCustomized,omitempty"`
	// OsName - The name of the operating system installed in the machine.
	OsName *string `json:"osName,omitempty"`
	// OsVersion - The version of the operating system installed in the machine.
	OsVersion *string `json:"osVersion,omitempty"`
	// Properties - Server specific properties.
	Properties interface{} `json:"properties,omitempty"`
	// RecommendedQfes - The list of recommended hotfixes for the server.
	RecommendedQfes interface{} `json:"recommendedQfes,omitempty"`
	// ResolvedAlerts - The total count of alerts that are resolved for this server.
	ResolvedAlerts *int32 `json:"resolvedAlerts,omitempty"`
	// Role - The service role that is being monitored in the server.
	Role *string `json:"role,omitempty"`
	// ServerReportedMonitoringLevel - The monitoring level reported by the server. Possible values include: 'Partial', 'Full', 'Off'
	ServerReportedMonitoringLevel MonitoringLevel `json:"serverReportedMonitoringLevel,omitempty"`
	// Status - The health status of the server.
	Status *string `json:"status,omitempty"`
}

// ServiceMembers the list of servers that are onboarded for a given service.
type ServiceMembers struct {
	autorest.Response `json:"-"`
	// NextLink - The link used to get the next page of operations.
	NextLink *string `json:"nextLink,omitempty"`
	// Value - The value returned by the operation.
	Value *[]ServiceMember `json:"value,omitempty"`
	// TotalCount - The total count of service elements.
	TotalCount *int32 `json:"totalCount,omitempty"`
	// ContinuationToken - The continuation token for paginated calls.
	ContinuationToken *string `json:"continuationToken,omitempty"`
}

// ServiceMembersIterator provides access to a complete listing of ServiceMember values.
type ServiceMembersIterator struct {
	i    int
	page ServiceMembersPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *ServiceMembersIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ServiceMembersIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *ServiceMembersIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter ServiceMembersIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter ServiceMembersIterator) Response() ServiceMembers {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter ServiceMembersIterator) Value() ServiceMember {
	if !iter.page.NotDone() {
		return ServiceMember{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the ServiceMembersIterator type.
func NewServiceMembersIterator(page ServiceMembersPage) ServiceMembersIterator {
	return ServiceMembersIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (sm ServiceMembers) IsEmpty() bool {
	return sm.Value == nil || len(*sm.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (sm ServiceMembers) hasNextLink() bool {
	return sm.NextLink != nil && len(*sm.NextLink) != 0
}

// serviceMembersPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (sm ServiceMembers) serviceMembersPreparer(ctx context.Context) (*http.Request, error) {
	if !sm.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(sm.NextLink)))
}

// ServiceMembersPage contains a page of ServiceMember values.
type ServiceMembersPage struct {
	fn func(context.Context, ServiceMembers) (ServiceMembers, error)
	sm ServiceMembers
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *ServiceMembersPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ServiceMembersPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.sm)
		if err != nil {
			return err
		}
		page.sm = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *ServiceMembersPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page ServiceMembersPage) NotDone() bool {
	return !page.sm.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page ServiceMembersPage) Response() ServiceMembers {
	return page.sm
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page ServiceMembersPage) Values() []ServiceMember {
	if page.sm.IsEmpty() {
		return nil
	}
	return *page.sm.Value
}

// Creates a new instance of the ServiceMembersPage type.
func NewServiceMembersPage(getNextPage func(context.Context, ServiceMembers) (ServiceMembers, error)) ServiceMembersPage {
	return ServiceMembersPage{fn: getNextPage}
}

// ServiceProperties the service properties for a given service.
type ServiceProperties struct {
	autorest.Response `json:"-"`
	// ID - The id of the service.
	ID *string `json:"id,omitempty"`
	// ActiveAlerts - The count of alerts that are currently active for the service.
	ActiveAlerts *int32 `json:"activeAlerts,omitempty"`
	// AdditionalInformation - The additional information related to the service.
	AdditionalInformation *string `json:"additionalInformation,omitempty"`
	// CreatedDate - The date and time, in UTC, when the service was onboarded to Azure Active Directory Connect Health.
	CreatedDate *date.Time `json:"createdDate,omitempty"`
	// CustomNotificationEmails - The list of additional emails that are configured to receive notifications about the service.
	CustomNotificationEmails *[]string `json:"customNotificationEmails,omitempty"`
	// Disabled - Indicates if the service is disabled or not.
	Disabled *bool `json:"disabled,omitempty"`
	// DisplayName - The display name of the service.
	DisplayName *string `json:"displayName,omitempty"`
	// Health - The health of the service.
	Health *string `json:"health,omitempty"`
	// LastDisabled - The date and time, in UTC, when the service was last disabled.
	LastDisabled *date.Time `json:"lastDisabled,omitempty"`
	// LastUpdated - The date or time , in UTC, when the service properties were last updated.
	LastUpdated *date.Time `json:"lastUpdated,omitempty"`
	// MonitoringConfigurationsComputed - The monitoring configuration of the service which determines what activities are monitored by Azure Active Directory Connect Health.
	MonitoringConfigurationsComputed interface{} `json:"monitoringConfigurationsComputed,omitempty"`
	// MonitoringConfigurationsCustomized - The customized monitoring configuration of the service which determines what activities are monitored by Azure Active Directory Connect Health.
	MonitoringConfigurationsCustomized interface{} `json:"monitoringConfigurationsCustomized,omitempty"`
	// NotificationEmailEnabled - Indicates if email notification is enabled or not.
	NotificationEmailEnabled *bool `json:"notificationEmailEnabled,omitempty"`
	// NotificationEmailEnabledForGlobalAdmins - Indicates if email notification is enabled for global administrators of the tenant.
	NotificationEmailEnabledForGlobalAdmins *bool `json:"notificationEmailEnabledForGlobalAdmins,omitempty"`
	// NotificationEmailsEnabledForGlobalAdmins - Indicates if email notification is enabled for global administrators of the tenant.
	NotificationEmailsEnabledForGlobalAdmins *bool `json:"notificationEmailsEnabledForGlobalAdmins,omitempty"`
	// NotificationEmails - The list of emails to whom service notifications will be sent.
	NotificationEmails *[]string `json:"notificationEmails,omitempty"`
	// OriginalDisabledState - Gets the original disable state.
	OriginalDisabledState *bool `json:"originalDisabledState,omitempty"`
	// ResolvedAlerts - The total count of alerts that has been resolved for the service.
	ResolvedAlerts *int32 `json:"resolvedAlerts,omitempty"`
	// ServiceID - The id of the service.
	ServiceID *string `json:"serviceId,omitempty"`
	// ServiceName - The name of the service.
	ServiceName *string `json:"serviceName,omitempty"`
	// Signature - The signature of the service.
	Signature *string `json:"signature,omitempty"`
	// SimpleProperties - List of service specific configuration properties.
	SimpleProperties interface{} `json:"simpleProperties,omitempty"`
	// TenantID - The id of the tenant to which the service is registered to.
	TenantID *string `json:"tenantId,omitempty"`
	// Type - The service type for the services onboarded to Azure Active Directory Connect Health. Depending on whether the service is monitoring, ADFS, Sync or ADDS roles, the service type can either be AdFederationService or AadSyncService or AdDomainService.
	Type *string `json:"type,omitempty"`
}

// Services the list of services for a given onboarded tenant.
type Services struct {
	autorest.Response `json:"-"`
	// NextLink - The link used to get the next page of operations.
	NextLink *string `json:"nextLink,omitempty"`
	// Value - The value returned by the operation.
	Value *[]ServiceProperties `json:"value,omitempty"`
	// TotalCount - The total count of service elements.
	TotalCount *int32 `json:"totalCount,omitempty"`
	// ContinuationToken - The continuation token for paginated calls.
	ContinuationToken *string `json:"continuationToken,omitempty"`
}

// ServicesIterator provides access to a complete listing of ServiceProperties values.
type ServicesIterator struct {
	i    int
	page ServicesPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *ServicesIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ServicesIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *ServicesIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter ServicesIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter ServicesIterator) Response() Services {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter ServicesIterator) Value() ServiceProperties {
	if !iter.page.NotDone() {
		return ServiceProperties{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the ServicesIterator type.
func NewServicesIterator(page ServicesPage) ServicesIterator {
	return ServicesIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (s Services) IsEmpty() bool {
	return s.Value == nil || len(*s.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (s Services) hasNextLink() bool {
	return s.NextLink != nil && len(*s.NextLink) != 0
}

// servicesPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (s Services) servicesPreparer(ctx context.Context) (*http.Request, error) {
	if !s.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(s.NextLink)))
}

// ServicesPage contains a page of ServiceProperties values.
type ServicesPage struct {
	fn func(context.Context, Services) (Services, error)
	s  Services
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *ServicesPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ServicesPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.s)
		if err != nil {
			return err
		}
		page.s = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *ServicesPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page ServicesPage) NotDone() bool {
	return !page.s.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page ServicesPage) Response() Services {
	return page.s
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page ServicesPage) Values() []ServiceProperties {
	if page.s.IsEmpty() {
		return nil
	}
	return *page.s.Value
}

// Creates a new instance of the ServicesPage type.
func NewServicesPage(getNextPage func(context.Context, Services) (Services, error)) ServicesPage {
	return ServicesPage{fn: getNextPage}
}

// TabularExportError the details for export error.
type TabularExportError struct {
	// ServiceID - The service Id.
	ServiceID *uuid.UUID `json:"serviceId,omitempty"`
	// ServiceMemberID - The server Id.
	ServiceMemberID *uuid.UUID `json:"serviceMemberId,omitempty"`
	// MergedEntityID - The merged entity Id.
	MergedEntityID *uuid.UUID `json:"mergedEntityId,omitempty"`
	// TabularExportErrorData - The export error data.
	TabularExportErrorData *string `json:"tabularExportErrorData,omitempty"`
}

// Tenant the details of the onboarded tenant.
type Tenant struct {
	autorest.Response `json:"-"`
	// TenantID - The Id of the tenant.
	TenantID *string `json:"tenantId,omitempty"`
	// AadLicense - The Azure Active Directory license of the tenant.
	AadLicense *string `json:"aadLicense,omitempty"`
	// AadPremium - Indicate if the tenant has Azure Active Directory Premium license or not.
	AadPremium *bool `json:"aadPremium,omitempty"`
	// AgentAutoUpdate - Indicates if the tenant is configured to automatically receive updates for Azure Active Directory Connect Health client side features.
	AgentAutoUpdate *bool `json:"agentAutoUpdate,omitempty"`
	// AlertSuppressionTimeInMins - The time in minutes after which an alert will be auto-suppressed.
	AlertSuppressionTimeInMins *int32 `json:"alertSuppressionTimeInMins,omitempty"`
	// ConsentedToMicrosoftDevOps - Indicates if the tenant data can be seen by Microsoft through Azure portal.
	ConsentedToMicrosoftDevOps *bool `json:"consentedToMicrosoftDevOps,omitempty"`
	// CountryLetterCode - The country letter code of the tenant.
	CountryLetterCode *string `json:"countryLetterCode,omitempty"`
	// CreatedDate - The date, in UTC, when the tenant was onboarded to Azure Active Directory Connect Health.
	CreatedDate *date.Time `json:"createdDate,omitempty"`
	// DevOpsTTL - The date and time, in UTC, till when the tenant data can be seen by Microsoft through Azure portal.
	DevOpsTTL *date.Time `json:"devOpsTtl,omitempty"`
	// Disabled - Indicates if the tenant is disabled in Azure Active Directory Connect Health.
	Disabled *bool `json:"disabled,omitempty"`
	// DisabledReason - The reason due to which the tenant was disabled in Azure Active Directory Connect Health.
	DisabledReason *int32 `json:"disabledReason,omitempty"`
	// GlobalAdminsEmail - The list of global administrators for the tenant.
	GlobalAdminsEmail *[]string `json:"globalAdminsEmail,omitempty"`
	// InitialDomain - The initial domain of the tenant.
	InitialDomain *string `json:"initialDomain,omitempty"`
	// LastDisabled - The date and time, in UTC, when the tenant was last disabled in Azure Active Directory Connect Health.
	LastDisabled *date.Time `json:"lastDisabled,omitempty"`
	// LastVerified - The date and time, in UTC, when the tenant onboarding status in Azure Active Directory Connect Health was last verified.
	LastVerified *date.Time `json:"lastVerified,omitempty"`
	// OnboardingAllowed - Indicates if the tenant is allowed to  onboard to Azure Active Directory Connect Health.
	OnboardingAllowed *bool `json:"onboardingAllowed,omitempty"`
	// Onboarded - Indicates if the tenant is already onboarded to Azure Active Directory Connect Health.
	Onboarded *bool `json:"onboarded,omitempty"`
	// PksCertificate - The certificate associated with the tenant to onboard data to Azure Active Directory Connect Health.
	PksCertificate interface{} `json:"pksCertificate,omitempty"`
	// PrivatePreviewTenant - Indicates if the tenant has signed up for private preview of Azure Active Directory Connect Health features.
	PrivatePreviewTenant *bool `json:"privatePreviewTenant,omitempty"`
	// TenantInQuarantine - Indicates if data collection for this tenant is disabled or not.
	TenantInQuarantine *bool `json:"tenantInQuarantine,omitempty"`
	// TenantName - The name of the tenant.
	TenantName *string `json:"tenantName,omitempty"`
}

// TenantOnboardingDetails the tenant onboarding details.
type TenantOnboardingDetails struct {
	// TenantOnboarded - Indicates if the tenant is onboarded to Azure Active Directory Connect Health or not.
	TenantOnboarded *bool `json:"tenantOnboarded,omitempty"`
	// OnboardingDisplayURL - The display url, to help tenant navigate or onboard to Azure Active Directory Connect Health blade, based on tenant onboarding status.
	OnboardingDisplayURL *string `json:"onboardingDisplayUrl,omitempty"`
}

// UserPreference the user preference for a given feature.
type UserPreference struct {
	autorest.Response `json:"-"`
	// MetricNames - The name of the metric.
	MetricNames *[]string `json:"metricNames,omitempty"`
}

// ValueDelta the value of the delta.
type ValueDelta struct {
	// OperationType - The operation type. Possible values include: 'ValueDeltaOperationTypeUndefined', 'ValueDeltaOperationTypeAdd', 'ValueDeltaOperationTypeUpdate', 'ValueDeltaOperationTypeDelete'
	OperationType ValueDeltaOperationType `json:"operationType,omitempty"`
	// Value - The value of the delta.
	Value *string `json:"value,omitempty"`
}
