// Code generated by client-gen. DO NOT EDIT.

package v1

import (
	"context"
	"time"

	v1 "github.com/openshift/api/oauth/v1"
	scheme "github.com/openshift/client-go/oauth/clientset/versioned/scheme"
	metav1 "k8s.io/apimachinery/pkg/apis/meta/v1"
	types "k8s.io/apimachinery/pkg/types"
	watch "k8s.io/apimachinery/pkg/watch"
	rest "k8s.io/client-go/rest"
)

// OAuthClientsGetter has a method to return a OAuthClientInterface.
// A group's client should implement this interface.
type OAuthClientsGetter interface {
	OAuthClients() OAuthClientInterface
}

// OAuthClientInterface has methods to work with OAuthClient resources.
type OAuthClientInterface interface {
	Create(ctx context.Context, oAuthClient *v1.OAuthClient, opts metav1.CreateOptions) (*v1.OAuthClient, error)
	Update(ctx context.Context, oAuthClient *v1.OAuthClient, opts metav1.UpdateOptions) (*v1.OAuthClient, error)
	Delete(ctx context.Context, name string, opts metav1.DeleteOptions) error
	DeleteCollection(ctx context.Context, opts metav1.DeleteOptions, listOpts metav1.ListOptions) error
	Get(ctx context.Context, name string, opts metav1.GetOptions) (*v1.OAuthClient, error)
	List(ctx context.Context, opts metav1.ListOptions) (*v1.OAuthClientList, error)
	Watch(ctx context.Context, opts metav1.ListOptions) (watch.Interface, error)
	Patch(ctx context.Context, name string, pt types.PatchType, data []byte, opts metav1.PatchOptions, subresources ...string) (result *v1.OAuthClient, err error)
	OAuthClientExpansion
}

// oAuthClients implements OAuthClientInterface
type oAuthClients struct {
	client rest.Interface
}

// newOAuthClients returns a OAuthClients
func newOAuthClients(c *OauthV1Client) *oAuthClients {
	return &oAuthClients{
		client: c.RESTClient(),
	}
}

// Get takes name of the oAuthClient, and returns the corresponding oAuthClient object, and an error if there is any.
func (c *oAuthClients) Get(ctx context.Context, name string, options metav1.GetOptions) (result *v1.OAuthClient, err error) {
	result = &v1.OAuthClient{}
	err = c.client.Get().
		Resource("oauthclients").
		Name(name).
		VersionedParams(&options, scheme.ParameterCodec).
		Do(ctx).
		Into(result)
	return
}

// List takes label and field selectors, and returns the list of OAuthClients that match those selectors.
func (c *oAuthClients) List(ctx context.Context, opts metav1.ListOptions) (result *v1.OAuthClientList, err error) {
	var timeout time.Duration
	if opts.TimeoutSeconds != nil {
		timeout = time.Duration(*opts.TimeoutSeconds) * time.Second
	}
	result = &v1.OAuthClientList{}
	err = c.client.Get().
		Resource("oauthclients").
		VersionedParams(&opts, scheme.ParameterCodec).
		Timeout(timeout).
		Do(ctx).
		Into(result)
	return
}

// Watch returns a watch.Interface that watches the requested oAuthClients.
func (c *oAuthClients) Watch(ctx context.Context, opts metav1.ListOptions) (watch.Interface, error) {
	var timeout time.Duration
	if opts.TimeoutSeconds != nil {
		timeout = time.Duration(*opts.TimeoutSeconds) * time.Second
	}
	opts.Watch = true
	return c.client.Get().
		Resource("oauthclients").
		VersionedParams(&opts, scheme.ParameterCodec).
		Timeout(timeout).
		Watch(ctx)
}

// Create takes the representation of a oAuthClient and creates it.  Returns the server's representation of the oAuthClient, and an error, if there is any.
func (c *oAuthClients) Create(ctx context.Context, oAuthClient *v1.OAuthClient, opts metav1.CreateOptions) (result *v1.OAuthClient, err error) {
	result = &v1.OAuthClient{}
	err = c.client.Post().
		Resource("oauthclients").
		VersionedParams(&opts, scheme.ParameterCodec).
		Body(oAuthClient).
		Do(ctx).
		Into(result)
	return
}

// Update takes the representation of a oAuthClient and updates it. Returns the server's representation of the oAuthClient, and an error, if there is any.
func (c *oAuthClients) Update(ctx context.Context, oAuthClient *v1.OAuthClient, opts metav1.UpdateOptions) (result *v1.OAuthClient, err error) {
	result = &v1.OAuthClient{}
	err = c.client.Put().
		Resource("oauthclients").
		Name(oAuthClient.Name).
		VersionedParams(&opts, scheme.ParameterCodec).
		Body(oAuthClient).
		Do(ctx).
		Into(result)
	return
}

// Delete takes name of the oAuthClient and deletes it. Returns an error if one occurs.
func (c *oAuthClients) Delete(ctx context.Context, name string, opts metav1.DeleteOptions) error {
	return c.client.Delete().
		Resource("oauthclients").
		Name(name).
		Body(&opts).
		Do(ctx).
		Error()
}

// DeleteCollection deletes a collection of objects.
func (c *oAuthClients) DeleteCollection(ctx context.Context, opts metav1.DeleteOptions, listOpts metav1.ListOptions) error {
	var timeout time.Duration
	if listOpts.TimeoutSeconds != nil {
		timeout = time.Duration(*listOpts.TimeoutSeconds) * time.Second
	}
	return c.client.Delete().
		Resource("oauthclients").
		VersionedParams(&listOpts, scheme.ParameterCodec).
		Timeout(timeout).
		Body(&opts).
		Do(ctx).
		Error()
}

// Patch applies the patch and returns the patched oAuthClient.
func (c *oAuthClients) Patch(ctx context.Context, name string, pt types.PatchType, data []byte, opts metav1.PatchOptions, subresources ...string) (result *v1.OAuthClient, err error) {
	result = &v1.OAuthClient{}
	err = c.client.Patch(pt).
		Resource("oauthclients").
		Name(name).
		SubResource(subresources...).
		VersionedParams(&opts, scheme.ParameterCodec).
		Body(data).
		Do(ctx).
		Into(result)
	return
}
