package insights

// Copyright (c) Microsoft and contributors.  All rights reserved.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
// http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//
// See the License for the specific language governing permissions and
// limitations under the License.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"context"
	"github.com/Azure/go-autorest/autorest"
	"github.com/Azure/go-autorest/autorest/azure"
	"github.com/Azure/go-autorest/tracing"
	"net/http"
)

// EventsClient is the composite Swagger for Application Insights Data Client
type EventsClient struct {
	BaseClient
}

// NewEventsClient creates an instance of the EventsClient client.
func NewEventsClient() EventsClient {
	return NewEventsClientWithBaseURI(DefaultBaseURI)
}

// NewEventsClientWithBaseURI creates an instance of the EventsClient client using a custom endpoint.  Use this when
// interacting with an Azure cloud that uses a non-standard base URI (sovereign clouds, Azure stack).
func NewEventsClientWithBaseURI(baseURI string) EventsClient {
	return EventsClient{NewWithBaseURI(baseURI)}
}

// Get gets the data for a single event
// Parameters:
// appID - ID of the application. This is Application ID from the API Access settings blade in the Azure
// portal.
// eventType - the type of events to query; either a standard event type (`traces`, `customEvents`,
// `pageViews`, `requests`, `dependencies`, `exceptions`, `availabilityResults`) or `$all` to query across all
// event types.
// eventID - ID of event.
// timespan - optional. The timespan over which to retrieve events. This is an ISO8601 time period value.  This
// timespan is applied in addition to any that are specified in the Odata expression.
func (client EventsClient) Get(ctx context.Context, appID string, eventType EventType, eventID string, timespan string) (result EventsResults, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/EventsClient.Get")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	req, err := client.GetPreparer(ctx, appID, eventType, eventID, timespan)
	if err != nil {
		err = autorest.NewErrorWithError(err, "insights.EventsClient", "Get", nil, "Failure preparing request")
		return
	}

	resp, err := client.GetSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "insights.EventsClient", "Get", resp, "Failure sending request")
		return
	}

	result, err = client.GetResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "insights.EventsClient", "Get", resp, "Failure responding to request")
	}

	return
}

// GetPreparer prepares the Get request.
func (client EventsClient) GetPreparer(ctx context.Context, appID string, eventType EventType, eventID string, timespan string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"appId":     autorest.Encode("path", appID),
		"eventId":   autorest.Encode("path", eventID),
		"eventType": autorest.Encode("path", eventType),
	}

	queryParameters := map[string]interface{}{}
	if len(timespan) > 0 {
		queryParameters["timespan"] = autorest.Encode("query", timespan)
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/apps/{appId}/events/{eventType}/{eventId}", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// GetSender sends the Get request. The method will close the
// http.Response Body if it receives an error.
func (client EventsClient) GetSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
}

// GetResponder handles the response to the Get request. The method always
// closes the http.Response Body.
func (client EventsClient) GetResponder(resp *http.Response) (result EventsResults, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// GetByType executes an OData query for events
// Parameters:
// appID - ID of the application. This is Application ID from the API Access settings blade in the Azure
// portal.
// eventType - the type of events to query; either a standard event type (`traces`, `customEvents`,
// `pageViews`, `requests`, `dependencies`, `exceptions`, `availabilityResults`) or `$all` to query across all
// event types.
// timespan - optional. The timespan over which to retrieve events. This is an ISO8601 time period value.  This
// timespan is applied in addition to any that are specified in the Odata expression.
// filter - an expression used to filter the returned events
// search - a free-text search expression to match for whether a particular event should be returned
// orderby - a comma-separated list of properties with \"asc\" (the default) or \"desc\" to control the order
// of returned events
// selectParameter - limits the properties to just those requested on each returned event
// skip - the number of items to skip over before returning events
// top - the number of events to return
// formatParameter - format for the returned events
// count - request a count of matching items included with the returned events
// apply - an expression used for aggregation over returned events
func (client EventsClient) GetByType(ctx context.Context, appID string, eventType EventType, timespan string, filter string, search string, orderby string, selectParameter string, skip *int32, top *int32, formatParameter string, count *bool, apply string) (result EventsResults, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/EventsClient.GetByType")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	req, err := client.GetByTypePreparer(ctx, appID, eventType, timespan, filter, search, orderby, selectParameter, skip, top, formatParameter, count, apply)
	if err != nil {
		err = autorest.NewErrorWithError(err, "insights.EventsClient", "GetByType", nil, "Failure preparing request")
		return
	}

	resp, err := client.GetByTypeSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "insights.EventsClient", "GetByType", resp, "Failure sending request")
		return
	}

	result, err = client.GetByTypeResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "insights.EventsClient", "GetByType", resp, "Failure responding to request")
	}

	return
}

// GetByTypePreparer prepares the GetByType request.
func (client EventsClient) GetByTypePreparer(ctx context.Context, appID string, eventType EventType, timespan string, filter string, search string, orderby string, selectParameter string, skip *int32, top *int32, formatParameter string, count *bool, apply string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"appId":     autorest.Encode("path", appID),
		"eventType": autorest.Encode("path", eventType),
	}

	queryParameters := map[string]interface{}{}
	if len(timespan) > 0 {
		queryParameters["timespan"] = autorest.Encode("query", timespan)
	}
	if len(filter) > 0 {
		queryParameters["$filter"] = autorest.Encode("query", filter)
	}
	if len(search) > 0 {
		queryParameters["$search"] = autorest.Encode("query", search)
	}
	if len(orderby) > 0 {
		queryParameters["$orderby"] = autorest.Encode("query", orderby)
	}
	if len(selectParameter) > 0 {
		queryParameters["$select"] = autorest.Encode("query", selectParameter)
	}
	if skip != nil {
		queryParameters["$skip"] = autorest.Encode("query", *skip)
	}
	if top != nil {
		queryParameters["$top"] = autorest.Encode("query", *top)
	}
	if len(formatParameter) > 0 {
		queryParameters["$format"] = autorest.Encode("query", formatParameter)
	}
	if count != nil {
		queryParameters["$count"] = autorest.Encode("query", *count)
	}
	if len(apply) > 0 {
		queryParameters["$apply"] = autorest.Encode("query", apply)
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/apps/{appId}/events/{eventType}", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// GetByTypeSender sends the GetByType request. The method will close the
// http.Response Body if it receives an error.
func (client EventsClient) GetByTypeSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
}

// GetByTypeResponder handles the response to the GetByType request. The method always
// closes the http.Response Body.
func (client EventsClient) GetByTypeResponder(resp *http.Response) (result EventsResults, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// GetOdataMetadata gets OData EDMX metadata describing the event data model
// Parameters:
// appID - ID of the application. This is Application ID from the API Access settings blade in the Azure
// portal.
func (client EventsClient) GetOdataMetadata(ctx context.Context, appID string) (result SetObject, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/EventsClient.GetOdataMetadata")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	req, err := client.GetOdataMetadataPreparer(ctx, appID)
	if err != nil {
		err = autorest.NewErrorWithError(err, "insights.EventsClient", "GetOdataMetadata", nil, "Failure preparing request")
		return
	}

	resp, err := client.GetOdataMetadataSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "insights.EventsClient", "GetOdataMetadata", resp, "Failure sending request")
		return
	}

	result, err = client.GetOdataMetadataResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "insights.EventsClient", "GetOdataMetadata", resp, "Failure responding to request")
	}

	return
}

// GetOdataMetadataPreparer prepares the GetOdataMetadata request.
func (client EventsClient) GetOdataMetadataPreparer(ctx context.Context, appID string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"appId": autorest.Encode("path", appID),
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/apps/{appId}/events/$metadata", pathParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// GetOdataMetadataSender sends the GetOdataMetadata request. The method will close the
// http.Response Body if it receives an error.
func (client EventsClient) GetOdataMetadataSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
}

// GetOdataMetadataResponder handles the response to the GetOdataMetadata request. The method always
// closes the http.Response Body.
func (client EventsClient) GetOdataMetadataResponder(resp *http.Response) (result SetObject, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result.Value),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}
