// Code generated by client-gen. DO NOT EDIT.

package v1

import (
	rest "k8s.io/client-go/rest"
	"open-cluster-management.io/api/client/work/clientset/versioned/scheme"
	v1 "open-cluster-management.io/api/work/v1"
)

type WorkV1Interface interface {
	RESTClient() rest.Interface
	AppliedManifestWorksGetter
	ManifestWorksGetter
}

// WorkV1Client is used to interact with features provided by the work.open-cluster-management.io group.
type WorkV1Client struct {
	restClient rest.Interface
}

func (c *WorkV1Client) AppliedManifestWorks() AppliedManifestWorkInterface {
	return newAppliedManifestWorks(c)
}

func (c *WorkV1Client) ManifestWorks(namespace string) ManifestWorkInterface {
	return newManifestWorks(c, namespace)
}

// NewForConfig creates a new WorkV1Client for the given config.
func NewForConfig(c *rest.Config) (*WorkV1Client, error) {
	config := *c
	if err := setConfigDefaults(&config); err != nil {
		return nil, err
	}
	client, err := rest.RESTClientFor(&config)
	if err != nil {
		return nil, err
	}
	return &WorkV1Client{client}, nil
}

// NewForConfigOrDie creates a new WorkV1Client for the given config and
// panics if there is an error in the config.
func NewForConfigOrDie(c *rest.Config) *WorkV1Client {
	client, err := NewForConfig(c)
	if err != nil {
		panic(err)
	}
	return client
}

// New creates a new WorkV1Client for the given RESTClient.
func New(c rest.Interface) *WorkV1Client {
	return &WorkV1Client{c}
}

func setConfigDefaults(config *rest.Config) error {
	gv := v1.SchemeGroupVersion
	config.GroupVersion = &gv
	config.APIPath = "/apis"
	config.NegotiatedSerializer = scheme.Codecs.WithoutConversion()

	if config.UserAgent == "" {
		config.UserAgent = rest.DefaultKubernetesUserAgent()
	}

	return nil
}

// RESTClient returns a RESTClient that is used to communicate
// with API server by this client implementation.
func (c *WorkV1Client) RESTClient() rest.Interface {
	if c == nil {
		return nil
	}
	return c.restClient
}
