// Copyright 2020 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.25.0
// 	protoc        v3.13.0
// source: google/spanner/v1/spanner.proto

package spanner

import (
	context "context"
	reflect "reflect"
	sync "sync"

	proto "github.com/golang/protobuf/proto"
	_ "google.golang.org/genproto/googleapis/api/annotations"
	status "google.golang.org/genproto/googleapis/rpc/status"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status1 "google.golang.org/grpc/status"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	emptypb "google.golang.org/protobuf/types/known/emptypb"
	structpb "google.golang.org/protobuf/types/known/structpb"
	timestamppb "google.golang.org/protobuf/types/known/timestamppb"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// This is a compile-time assertion that a sufficiently up-to-date version
// of the legacy proto package is being used.
const _ = proto.ProtoPackageIsVersion4

// Mode in which the statement must be processed.
type ExecuteSqlRequest_QueryMode int32

const (
	// The default mode. Only the statement results are returned.
	ExecuteSqlRequest_NORMAL ExecuteSqlRequest_QueryMode = 0
	// This mode returns only the query plan, without any results or
	// execution statistics information.
	ExecuteSqlRequest_PLAN ExecuteSqlRequest_QueryMode = 1
	// This mode returns both the query plan and the execution statistics along
	// with the results.
	ExecuteSqlRequest_PROFILE ExecuteSqlRequest_QueryMode = 2
)

// Enum value maps for ExecuteSqlRequest_QueryMode.
var (
	ExecuteSqlRequest_QueryMode_name = map[int32]string{
		0: "NORMAL",
		1: "PLAN",
		2: "PROFILE",
	}
	ExecuteSqlRequest_QueryMode_value = map[string]int32{
		"NORMAL":  0,
		"PLAN":    1,
		"PROFILE": 2,
	}
)

func (x ExecuteSqlRequest_QueryMode) Enum() *ExecuteSqlRequest_QueryMode {
	p := new(ExecuteSqlRequest_QueryMode)
	*p = x
	return p
}

func (x ExecuteSqlRequest_QueryMode) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (ExecuteSqlRequest_QueryMode) Descriptor() protoreflect.EnumDescriptor {
	return file_google_spanner_v1_spanner_proto_enumTypes[0].Descriptor()
}

func (ExecuteSqlRequest_QueryMode) Type() protoreflect.EnumType {
	return &file_google_spanner_v1_spanner_proto_enumTypes[0]
}

func (x ExecuteSqlRequest_QueryMode) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use ExecuteSqlRequest_QueryMode.Descriptor instead.
func (ExecuteSqlRequest_QueryMode) EnumDescriptor() ([]byte, []int) {
	return file_google_spanner_v1_spanner_proto_rawDescGZIP(), []int{8, 0}
}

// The request for [CreateSession][google.spanner.v1.Spanner.CreateSession].
type CreateSessionRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The database in which the new session is created.
	Database string `protobuf:"bytes,1,opt,name=database,proto3" json:"database,omitempty"`
	// The session to create.
	Session *Session `protobuf:"bytes,2,opt,name=session,proto3" json:"session,omitempty"`
}

func (x *CreateSessionRequest) Reset() {
	*x = CreateSessionRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_spanner_v1_spanner_proto_msgTypes[0]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CreateSessionRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CreateSessionRequest) ProtoMessage() {}

func (x *CreateSessionRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_spanner_v1_spanner_proto_msgTypes[0]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CreateSessionRequest.ProtoReflect.Descriptor instead.
func (*CreateSessionRequest) Descriptor() ([]byte, []int) {
	return file_google_spanner_v1_spanner_proto_rawDescGZIP(), []int{0}
}

func (x *CreateSessionRequest) GetDatabase() string {
	if x != nil {
		return x.Database
	}
	return ""
}

func (x *CreateSessionRequest) GetSession() *Session {
	if x != nil {
		return x.Session
	}
	return nil
}

// The request for [BatchCreateSessions][google.spanner.v1.Spanner.BatchCreateSessions].
type BatchCreateSessionsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The database in which the new sessions are created.
	Database string `protobuf:"bytes,1,opt,name=database,proto3" json:"database,omitempty"`
	// Parameters to be applied to each created session.
	SessionTemplate *Session `protobuf:"bytes,2,opt,name=session_template,json=sessionTemplate,proto3" json:"session_template,omitempty"`
	// Required. The number of sessions to be created in this batch call.
	// The API may return fewer than the requested number of sessions. If a
	// specific number of sessions are desired, the client can make additional
	// calls to BatchCreateSessions (adjusting
	// [session_count][google.spanner.v1.BatchCreateSessionsRequest.session_count] as necessary).
	SessionCount int32 `protobuf:"varint,3,opt,name=session_count,json=sessionCount,proto3" json:"session_count,omitempty"`
}

func (x *BatchCreateSessionsRequest) Reset() {
	*x = BatchCreateSessionsRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_spanner_v1_spanner_proto_msgTypes[1]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *BatchCreateSessionsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*BatchCreateSessionsRequest) ProtoMessage() {}

func (x *BatchCreateSessionsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_spanner_v1_spanner_proto_msgTypes[1]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use BatchCreateSessionsRequest.ProtoReflect.Descriptor instead.
func (*BatchCreateSessionsRequest) Descriptor() ([]byte, []int) {
	return file_google_spanner_v1_spanner_proto_rawDescGZIP(), []int{1}
}

func (x *BatchCreateSessionsRequest) GetDatabase() string {
	if x != nil {
		return x.Database
	}
	return ""
}

func (x *BatchCreateSessionsRequest) GetSessionTemplate() *Session {
	if x != nil {
		return x.SessionTemplate
	}
	return nil
}

func (x *BatchCreateSessionsRequest) GetSessionCount() int32 {
	if x != nil {
		return x.SessionCount
	}
	return 0
}

// The response for [BatchCreateSessions][google.spanner.v1.Spanner.BatchCreateSessions].
type BatchCreateSessionsResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The freshly created sessions.
	Session []*Session `protobuf:"bytes,1,rep,name=session,proto3" json:"session,omitempty"`
}

func (x *BatchCreateSessionsResponse) Reset() {
	*x = BatchCreateSessionsResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_spanner_v1_spanner_proto_msgTypes[2]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *BatchCreateSessionsResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*BatchCreateSessionsResponse) ProtoMessage() {}

func (x *BatchCreateSessionsResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_spanner_v1_spanner_proto_msgTypes[2]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use BatchCreateSessionsResponse.ProtoReflect.Descriptor instead.
func (*BatchCreateSessionsResponse) Descriptor() ([]byte, []int) {
	return file_google_spanner_v1_spanner_proto_rawDescGZIP(), []int{2}
}

func (x *BatchCreateSessionsResponse) GetSession() []*Session {
	if x != nil {
		return x.Session
	}
	return nil
}

// A session in the Cloud Spanner API.
type Session struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The name of the session. This is always system-assigned; values provided
	// when creating a session are ignored.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// The labels for the session.
	//
	//  * Label keys must be between 1 and 63 characters long and must conform to
	//    the following regular expression: `[a-z]([-a-z0-9]*[a-z0-9])?`.
	//  * Label values must be between 0 and 63 characters long and must conform
	//    to the regular expression `([a-z]([-a-z0-9]*[a-z0-9])?)?`.
	//  * No more than 64 labels can be associated with a given session.
	//
	// See https://goo.gl/xmQnxf for more information on and examples of labels.
	Labels map[string]string `protobuf:"bytes,2,rep,name=labels,proto3" json:"labels,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// Output only. The timestamp when the session is created.
	CreateTime *timestamppb.Timestamp `protobuf:"bytes,3,opt,name=create_time,json=createTime,proto3" json:"create_time,omitempty"`
	// Output only. The approximate timestamp when the session is last used. It is
	// typically earlier than the actual last use time.
	ApproximateLastUseTime *timestamppb.Timestamp `protobuf:"bytes,4,opt,name=approximate_last_use_time,json=approximateLastUseTime,proto3" json:"approximate_last_use_time,omitempty"`
}

func (x *Session) Reset() {
	*x = Session{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_spanner_v1_spanner_proto_msgTypes[3]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Session) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Session) ProtoMessage() {}

func (x *Session) ProtoReflect() protoreflect.Message {
	mi := &file_google_spanner_v1_spanner_proto_msgTypes[3]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Session.ProtoReflect.Descriptor instead.
func (*Session) Descriptor() ([]byte, []int) {
	return file_google_spanner_v1_spanner_proto_rawDescGZIP(), []int{3}
}

func (x *Session) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *Session) GetLabels() map[string]string {
	if x != nil {
		return x.Labels
	}
	return nil
}

func (x *Session) GetCreateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.CreateTime
	}
	return nil
}

func (x *Session) GetApproximateLastUseTime() *timestamppb.Timestamp {
	if x != nil {
		return x.ApproximateLastUseTime
	}
	return nil
}

// The request for [GetSession][google.spanner.v1.Spanner.GetSession].
type GetSessionRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of the session to retrieve.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *GetSessionRequest) Reset() {
	*x = GetSessionRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_spanner_v1_spanner_proto_msgTypes[4]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetSessionRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetSessionRequest) ProtoMessage() {}

func (x *GetSessionRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_spanner_v1_spanner_proto_msgTypes[4]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetSessionRequest.ProtoReflect.Descriptor instead.
func (*GetSessionRequest) Descriptor() ([]byte, []int) {
	return file_google_spanner_v1_spanner_proto_rawDescGZIP(), []int{4}
}

func (x *GetSessionRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// The request for [ListSessions][google.spanner.v1.Spanner.ListSessions].
type ListSessionsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The database in which to list sessions.
	Database string `protobuf:"bytes,1,opt,name=database,proto3" json:"database,omitempty"`
	// Number of sessions to be returned in the response. If 0 or less, defaults
	// to the server's maximum allowed page size.
	PageSize int32 `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// If non-empty, `page_token` should contain a
	// [next_page_token][google.spanner.v1.ListSessionsResponse.next_page_token] from a previous
	// [ListSessionsResponse][google.spanner.v1.ListSessionsResponse].
	PageToken string `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
	// An expression for filtering the results of the request. Filter rules are
	// case insensitive. The fields eligible for filtering are:
	//
	//   * `labels.key` where key is the name of a label
	//
	// Some examples of using filters are:
	//
	//   * `labels.env:*` --> The session has the label "env".
	//   * `labels.env:dev` --> The session has the label "env" and the value of
	//                        the label contains the string "dev".
	Filter string `protobuf:"bytes,4,opt,name=filter,proto3" json:"filter,omitempty"`
}

func (x *ListSessionsRequest) Reset() {
	*x = ListSessionsRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_spanner_v1_spanner_proto_msgTypes[5]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListSessionsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListSessionsRequest) ProtoMessage() {}

func (x *ListSessionsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_spanner_v1_spanner_proto_msgTypes[5]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListSessionsRequest.ProtoReflect.Descriptor instead.
func (*ListSessionsRequest) Descriptor() ([]byte, []int) {
	return file_google_spanner_v1_spanner_proto_rawDescGZIP(), []int{5}
}

func (x *ListSessionsRequest) GetDatabase() string {
	if x != nil {
		return x.Database
	}
	return ""
}

func (x *ListSessionsRequest) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (x *ListSessionsRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

func (x *ListSessionsRequest) GetFilter() string {
	if x != nil {
		return x.Filter
	}
	return ""
}

// The response for [ListSessions][google.spanner.v1.Spanner.ListSessions].
type ListSessionsResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The list of requested sessions.
	Sessions []*Session `protobuf:"bytes,1,rep,name=sessions,proto3" json:"sessions,omitempty"`
	// `next_page_token` can be sent in a subsequent
	// [ListSessions][google.spanner.v1.Spanner.ListSessions] call to fetch more of the matching
	// sessions.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
}

func (x *ListSessionsResponse) Reset() {
	*x = ListSessionsResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_spanner_v1_spanner_proto_msgTypes[6]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListSessionsResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListSessionsResponse) ProtoMessage() {}

func (x *ListSessionsResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_spanner_v1_spanner_proto_msgTypes[6]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListSessionsResponse.ProtoReflect.Descriptor instead.
func (*ListSessionsResponse) Descriptor() ([]byte, []int) {
	return file_google_spanner_v1_spanner_proto_rawDescGZIP(), []int{6}
}

func (x *ListSessionsResponse) GetSessions() []*Session {
	if x != nil {
		return x.Sessions
	}
	return nil
}

func (x *ListSessionsResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

// The request for [DeleteSession][google.spanner.v1.Spanner.DeleteSession].
type DeleteSessionRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of the session to delete.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *DeleteSessionRequest) Reset() {
	*x = DeleteSessionRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_spanner_v1_spanner_proto_msgTypes[7]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DeleteSessionRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeleteSessionRequest) ProtoMessage() {}

func (x *DeleteSessionRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_spanner_v1_spanner_proto_msgTypes[7]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DeleteSessionRequest.ProtoReflect.Descriptor instead.
func (*DeleteSessionRequest) Descriptor() ([]byte, []int) {
	return file_google_spanner_v1_spanner_proto_rawDescGZIP(), []int{7}
}

func (x *DeleteSessionRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// The request for [ExecuteSql][google.spanner.v1.Spanner.ExecuteSql] and
// [ExecuteStreamingSql][google.spanner.v1.Spanner.ExecuteStreamingSql].
type ExecuteSqlRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The session in which the SQL query should be performed.
	Session string `protobuf:"bytes,1,opt,name=session,proto3" json:"session,omitempty"`
	// The transaction to use.
	//
	// For queries, if none is provided, the default is a temporary read-only
	// transaction with strong concurrency.
	//
	// Standard DML statements require a read-write transaction. To protect
	// against replays, single-use transactions are not supported.  The caller
	// must either supply an existing transaction ID or begin a new transaction.
	//
	// Partitioned DML requires an existing Partitioned DML transaction ID.
	Transaction *TransactionSelector `protobuf:"bytes,2,opt,name=transaction,proto3" json:"transaction,omitempty"`
	// Required. The SQL string.
	Sql string `protobuf:"bytes,3,opt,name=sql,proto3" json:"sql,omitempty"`
	// Parameter names and values that bind to placeholders in the SQL string.
	//
	// A parameter placeholder consists of the `@` character followed by the
	// parameter name (for example, `@firstName`). Parameter names can contain
	// letters, numbers, and underscores.
	//
	// Parameters can appear anywhere that a literal value is expected.  The same
	// parameter name can be used more than once, for example:
	//
	// `"WHERE id > @msg_id AND id < @msg_id + 100"`
	//
	// It is an error to execute a SQL statement with unbound parameters.
	Params *structpb.Struct `protobuf:"bytes,4,opt,name=params,proto3" json:"params,omitempty"`
	// It is not always possible for Cloud Spanner to infer the right SQL type
	// from a JSON value.  For example, values of type `BYTES` and values
	// of type `STRING` both appear in [params][google.spanner.v1.ExecuteSqlRequest.params] as JSON strings.
	//
	// In these cases, `param_types` can be used to specify the exact
	// SQL type for some or all of the SQL statement parameters. See the
	// definition of [Type][google.spanner.v1.Type] for more information
	// about SQL types.
	ParamTypes map[string]*Type `protobuf:"bytes,5,rep,name=param_types,json=paramTypes,proto3" json:"param_types,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// If this request is resuming a previously interrupted SQL statement
	// execution, `resume_token` should be copied from the last
	// [PartialResultSet][google.spanner.v1.PartialResultSet] yielded before the interruption. Doing this
	// enables the new SQL statement execution to resume where the last one left
	// off. The rest of the request parameters must exactly match the
	// request that yielded this token.
	ResumeToken []byte `protobuf:"bytes,6,opt,name=resume_token,json=resumeToken,proto3" json:"resume_token,omitempty"`
	// Used to control the amount of debugging information returned in
	// [ResultSetStats][google.spanner.v1.ResultSetStats]. If [partition_token][google.spanner.v1.ExecuteSqlRequest.partition_token] is set, [query_mode][google.spanner.v1.ExecuteSqlRequest.query_mode] can only
	// be set to [QueryMode.NORMAL][google.spanner.v1.ExecuteSqlRequest.QueryMode.NORMAL].
	QueryMode ExecuteSqlRequest_QueryMode `protobuf:"varint,7,opt,name=query_mode,json=queryMode,proto3,enum=google.spanner.v1.ExecuteSqlRequest_QueryMode" json:"query_mode,omitempty"`
	// If present, results will be restricted to the specified partition
	// previously created using PartitionQuery().  There must be an exact
	// match for the values of fields common to this message and the
	// PartitionQueryRequest message used to create this partition_token.
	PartitionToken []byte `protobuf:"bytes,8,opt,name=partition_token,json=partitionToken,proto3" json:"partition_token,omitempty"`
	// A per-transaction sequence number used to identify this request. This field
	// makes each request idempotent such that if the request is received multiple
	// times, at most one will succeed.
	//
	// The sequence number must be monotonically increasing within the
	// transaction. If a request arrives for the first time with an out-of-order
	// sequence number, the transaction may be aborted. Replays of previously
	// handled requests will yield the same response as the first execution.
	//
	// Required for DML statements. Ignored for queries.
	Seqno int64 `protobuf:"varint,9,opt,name=seqno,proto3" json:"seqno,omitempty"`
	// Query optimizer configuration to use for the given query.
	QueryOptions *ExecuteSqlRequest_QueryOptions `protobuf:"bytes,10,opt,name=query_options,json=queryOptions,proto3" json:"query_options,omitempty"`
}

func (x *ExecuteSqlRequest) Reset() {
	*x = ExecuteSqlRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_spanner_v1_spanner_proto_msgTypes[8]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ExecuteSqlRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ExecuteSqlRequest) ProtoMessage() {}

func (x *ExecuteSqlRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_spanner_v1_spanner_proto_msgTypes[8]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ExecuteSqlRequest.ProtoReflect.Descriptor instead.
func (*ExecuteSqlRequest) Descriptor() ([]byte, []int) {
	return file_google_spanner_v1_spanner_proto_rawDescGZIP(), []int{8}
}

func (x *ExecuteSqlRequest) GetSession() string {
	if x != nil {
		return x.Session
	}
	return ""
}

func (x *ExecuteSqlRequest) GetTransaction() *TransactionSelector {
	if x != nil {
		return x.Transaction
	}
	return nil
}

func (x *ExecuteSqlRequest) GetSql() string {
	if x != nil {
		return x.Sql
	}
	return ""
}

func (x *ExecuteSqlRequest) GetParams() *structpb.Struct {
	if x != nil {
		return x.Params
	}
	return nil
}

func (x *ExecuteSqlRequest) GetParamTypes() map[string]*Type {
	if x != nil {
		return x.ParamTypes
	}
	return nil
}

func (x *ExecuteSqlRequest) GetResumeToken() []byte {
	if x != nil {
		return x.ResumeToken
	}
	return nil
}

func (x *ExecuteSqlRequest) GetQueryMode() ExecuteSqlRequest_QueryMode {
	if x != nil {
		return x.QueryMode
	}
	return ExecuteSqlRequest_NORMAL
}

func (x *ExecuteSqlRequest) GetPartitionToken() []byte {
	if x != nil {
		return x.PartitionToken
	}
	return nil
}

func (x *ExecuteSqlRequest) GetSeqno() int64 {
	if x != nil {
		return x.Seqno
	}
	return 0
}

func (x *ExecuteSqlRequest) GetQueryOptions() *ExecuteSqlRequest_QueryOptions {
	if x != nil {
		return x.QueryOptions
	}
	return nil
}

// The request for [ExecuteBatchDml][google.spanner.v1.Spanner.ExecuteBatchDml].
type ExecuteBatchDmlRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The session in which the DML statements should be performed.
	Session string `protobuf:"bytes,1,opt,name=session,proto3" json:"session,omitempty"`
	// Required. The transaction to use. Must be a read-write transaction.
	//
	// To protect against replays, single-use transactions are not supported. The
	// caller must either supply an existing transaction ID or begin a new
	// transaction.
	Transaction *TransactionSelector `protobuf:"bytes,2,opt,name=transaction,proto3" json:"transaction,omitempty"`
	// Required. The list of statements to execute in this batch. Statements are executed
	// serially, such that the effects of statement `i` are visible to statement
	// `i+1`. Each statement must be a DML statement. Execution stops at the
	// first failed statement; the remaining statements are not executed.
	//
	// Callers must provide at least one statement.
	Statements []*ExecuteBatchDmlRequest_Statement `protobuf:"bytes,3,rep,name=statements,proto3" json:"statements,omitempty"`
	// Required. A per-transaction sequence number used to identify this request. This field
	// makes each request idempotent such that if the request is received multiple
	// times, at most one will succeed.
	//
	// The sequence number must be monotonically increasing within the
	// transaction. If a request arrives for the first time with an out-of-order
	// sequence number, the transaction may be aborted. Replays of previously
	// handled requests will yield the same response as the first execution.
	Seqno int64 `protobuf:"varint,4,opt,name=seqno,proto3" json:"seqno,omitempty"`
}

func (x *ExecuteBatchDmlRequest) Reset() {
	*x = ExecuteBatchDmlRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_spanner_v1_spanner_proto_msgTypes[9]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ExecuteBatchDmlRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ExecuteBatchDmlRequest) ProtoMessage() {}

func (x *ExecuteBatchDmlRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_spanner_v1_spanner_proto_msgTypes[9]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ExecuteBatchDmlRequest.ProtoReflect.Descriptor instead.
func (*ExecuteBatchDmlRequest) Descriptor() ([]byte, []int) {
	return file_google_spanner_v1_spanner_proto_rawDescGZIP(), []int{9}
}

func (x *ExecuteBatchDmlRequest) GetSession() string {
	if x != nil {
		return x.Session
	}
	return ""
}

func (x *ExecuteBatchDmlRequest) GetTransaction() *TransactionSelector {
	if x != nil {
		return x.Transaction
	}
	return nil
}

func (x *ExecuteBatchDmlRequest) GetStatements() []*ExecuteBatchDmlRequest_Statement {
	if x != nil {
		return x.Statements
	}
	return nil
}

func (x *ExecuteBatchDmlRequest) GetSeqno() int64 {
	if x != nil {
		return x.Seqno
	}
	return 0
}

// The response for [ExecuteBatchDml][google.spanner.v1.Spanner.ExecuteBatchDml]. Contains a list
// of [ResultSet][google.spanner.v1.ResultSet] messages, one for each DML statement that has successfully
// executed, in the same order as the statements in the request. If a statement
// fails, the status in the response body identifies the cause of the failure.
//
// To check for DML statements that failed, use the following approach:
//
// 1. Check the status in the response message. The [google.rpc.Code][google.rpc.Code] enum
//    value `OK` indicates that all statements were executed successfully.
// 2. If the status was not `OK`, check the number of result sets in the
//    response. If the response contains `N` [ResultSet][google.spanner.v1.ResultSet] messages, then
//    statement `N+1` in the request failed.
//
// Example 1:
//
// * Request: 5 DML statements, all executed successfully.
// * Response: 5 [ResultSet][google.spanner.v1.ResultSet] messages, with the status `OK`.
//
// Example 2:
//
// * Request: 5 DML statements. The third statement has a syntax error.
// * Response: 2 [ResultSet][google.spanner.v1.ResultSet] messages, and a syntax error (`INVALID_ARGUMENT`)
//   status. The number of [ResultSet][google.spanner.v1.ResultSet] messages indicates that the third
//   statement failed, and the fourth and fifth statements were not executed.
type ExecuteBatchDmlResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// One [ResultSet][google.spanner.v1.ResultSet] for each statement in the request that ran successfully,
	// in the same order as the statements in the request. Each [ResultSet][google.spanner.v1.ResultSet] does
	// not contain any rows. The [ResultSetStats][google.spanner.v1.ResultSetStats] in each [ResultSet][google.spanner.v1.ResultSet] contain
	// the number of rows modified by the statement.
	//
	// Only the first [ResultSet][google.spanner.v1.ResultSet] in the response contains valid
	// [ResultSetMetadata][google.spanner.v1.ResultSetMetadata].
	ResultSets []*ResultSet `protobuf:"bytes,1,rep,name=result_sets,json=resultSets,proto3" json:"result_sets,omitempty"`
	// If all DML statements are executed successfully, the status is `OK`.
	// Otherwise, the error status of the first failed statement.
	Status *status.Status `protobuf:"bytes,2,opt,name=status,proto3" json:"status,omitempty"`
}

func (x *ExecuteBatchDmlResponse) Reset() {
	*x = ExecuteBatchDmlResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_spanner_v1_spanner_proto_msgTypes[10]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ExecuteBatchDmlResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ExecuteBatchDmlResponse) ProtoMessage() {}

func (x *ExecuteBatchDmlResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_spanner_v1_spanner_proto_msgTypes[10]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ExecuteBatchDmlResponse.ProtoReflect.Descriptor instead.
func (*ExecuteBatchDmlResponse) Descriptor() ([]byte, []int) {
	return file_google_spanner_v1_spanner_proto_rawDescGZIP(), []int{10}
}

func (x *ExecuteBatchDmlResponse) GetResultSets() []*ResultSet {
	if x != nil {
		return x.ResultSets
	}
	return nil
}

func (x *ExecuteBatchDmlResponse) GetStatus() *status.Status {
	if x != nil {
		return x.Status
	}
	return nil
}

// Options for a PartitionQueryRequest and
// PartitionReadRequest.
type PartitionOptions struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// **Note:** This hint is currently ignored by PartitionQuery and
	// PartitionRead requests.
	//
	// The desired data size for each partition generated.  The default for this
	// option is currently 1 GiB.  This is only a hint. The actual size of each
	// partition may be smaller or larger than this size request.
	PartitionSizeBytes int64 `protobuf:"varint,1,opt,name=partition_size_bytes,json=partitionSizeBytes,proto3" json:"partition_size_bytes,omitempty"`
	// **Note:** This hint is currently ignored by PartitionQuery and
	// PartitionRead requests.
	//
	// The desired maximum number of partitions to return.  For example, this may
	// be set to the number of workers available.  The default for this option
	// is currently 10,000. The maximum value is currently 200,000.  This is only
	// a hint.  The actual number of partitions returned may be smaller or larger
	// than this maximum count request.
	MaxPartitions int64 `protobuf:"varint,2,opt,name=max_partitions,json=maxPartitions,proto3" json:"max_partitions,omitempty"`
}

func (x *PartitionOptions) Reset() {
	*x = PartitionOptions{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_spanner_v1_spanner_proto_msgTypes[11]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *PartitionOptions) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PartitionOptions) ProtoMessage() {}

func (x *PartitionOptions) ProtoReflect() protoreflect.Message {
	mi := &file_google_spanner_v1_spanner_proto_msgTypes[11]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PartitionOptions.ProtoReflect.Descriptor instead.
func (*PartitionOptions) Descriptor() ([]byte, []int) {
	return file_google_spanner_v1_spanner_proto_rawDescGZIP(), []int{11}
}

func (x *PartitionOptions) GetPartitionSizeBytes() int64 {
	if x != nil {
		return x.PartitionSizeBytes
	}
	return 0
}

func (x *PartitionOptions) GetMaxPartitions() int64 {
	if x != nil {
		return x.MaxPartitions
	}
	return 0
}

// The request for [PartitionQuery][google.spanner.v1.Spanner.PartitionQuery]
type PartitionQueryRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The session used to create the partitions.
	Session string `protobuf:"bytes,1,opt,name=session,proto3" json:"session,omitempty"`
	// Read only snapshot transactions are supported, read/write and single use
	// transactions are not.
	Transaction *TransactionSelector `protobuf:"bytes,2,opt,name=transaction,proto3" json:"transaction,omitempty"`
	// Required. The query request to generate partitions for. The request will fail if
	// the query is not root partitionable. The query plan of a root
	// partitionable query has a single distributed union operator. A distributed
	// union operator conceptually divides one or more tables into multiple
	// splits, remotely evaluates a subquery independently on each split, and
	// then unions all results.
	//
	// This must not contain DML commands, such as INSERT, UPDATE, or
	// DELETE. Use [ExecuteStreamingSql][google.spanner.v1.Spanner.ExecuteStreamingSql] with a
	// PartitionedDml transaction for large, partition-friendly DML operations.
	Sql string `protobuf:"bytes,3,opt,name=sql,proto3" json:"sql,omitempty"`
	// Parameter names and values that bind to placeholders in the SQL string.
	//
	// A parameter placeholder consists of the `@` character followed by the
	// parameter name (for example, `@firstName`). Parameter names can contain
	// letters, numbers, and underscores.
	//
	// Parameters can appear anywhere that a literal value is expected.  The same
	// parameter name can be used more than once, for example:
	//
	// `"WHERE id > @msg_id AND id < @msg_id + 100"`
	//
	// It is an error to execute a SQL statement with unbound parameters.
	Params *structpb.Struct `protobuf:"bytes,4,opt,name=params,proto3" json:"params,omitempty"`
	// It is not always possible for Cloud Spanner to infer the right SQL type
	// from a JSON value.  For example, values of type `BYTES` and values
	// of type `STRING` both appear in [params][google.spanner.v1.PartitionQueryRequest.params] as JSON strings.
	//
	// In these cases, `param_types` can be used to specify the exact
	// SQL type for some or all of the SQL query parameters. See the
	// definition of [Type][google.spanner.v1.Type] for more information
	// about SQL types.
	ParamTypes map[string]*Type `protobuf:"bytes,5,rep,name=param_types,json=paramTypes,proto3" json:"param_types,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// Additional options that affect how many partitions are created.
	PartitionOptions *PartitionOptions `protobuf:"bytes,6,opt,name=partition_options,json=partitionOptions,proto3" json:"partition_options,omitempty"`
}

func (x *PartitionQueryRequest) Reset() {
	*x = PartitionQueryRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_spanner_v1_spanner_proto_msgTypes[12]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *PartitionQueryRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PartitionQueryRequest) ProtoMessage() {}

func (x *PartitionQueryRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_spanner_v1_spanner_proto_msgTypes[12]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PartitionQueryRequest.ProtoReflect.Descriptor instead.
func (*PartitionQueryRequest) Descriptor() ([]byte, []int) {
	return file_google_spanner_v1_spanner_proto_rawDescGZIP(), []int{12}
}

func (x *PartitionQueryRequest) GetSession() string {
	if x != nil {
		return x.Session
	}
	return ""
}

func (x *PartitionQueryRequest) GetTransaction() *TransactionSelector {
	if x != nil {
		return x.Transaction
	}
	return nil
}

func (x *PartitionQueryRequest) GetSql() string {
	if x != nil {
		return x.Sql
	}
	return ""
}

func (x *PartitionQueryRequest) GetParams() *structpb.Struct {
	if x != nil {
		return x.Params
	}
	return nil
}

func (x *PartitionQueryRequest) GetParamTypes() map[string]*Type {
	if x != nil {
		return x.ParamTypes
	}
	return nil
}

func (x *PartitionQueryRequest) GetPartitionOptions() *PartitionOptions {
	if x != nil {
		return x.PartitionOptions
	}
	return nil
}

// The request for [PartitionRead][google.spanner.v1.Spanner.PartitionRead]
type PartitionReadRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The session used to create the partitions.
	Session string `protobuf:"bytes,1,opt,name=session,proto3" json:"session,omitempty"`
	// Read only snapshot transactions are supported, read/write and single use
	// transactions are not.
	Transaction *TransactionSelector `protobuf:"bytes,2,opt,name=transaction,proto3" json:"transaction,omitempty"`
	// Required. The name of the table in the database to be read.
	Table string `protobuf:"bytes,3,opt,name=table,proto3" json:"table,omitempty"`
	// If non-empty, the name of an index on [table][google.spanner.v1.PartitionReadRequest.table]. This index is
	// used instead of the table primary key when interpreting [key_set][google.spanner.v1.PartitionReadRequest.key_set]
	// and sorting result rows. See [key_set][google.spanner.v1.PartitionReadRequest.key_set] for further information.
	Index string `protobuf:"bytes,4,opt,name=index,proto3" json:"index,omitempty"`
	// The columns of [table][google.spanner.v1.PartitionReadRequest.table] to be returned for each row matching
	// this request.
	Columns []string `protobuf:"bytes,5,rep,name=columns,proto3" json:"columns,omitempty"`
	// Required. `key_set` identifies the rows to be yielded. `key_set` names the
	// primary keys of the rows in [table][google.spanner.v1.PartitionReadRequest.table] to be yielded, unless [index][google.spanner.v1.PartitionReadRequest.index]
	// is present. If [index][google.spanner.v1.PartitionReadRequest.index] is present, then [key_set][google.spanner.v1.PartitionReadRequest.key_set] instead names
	// index keys in [index][google.spanner.v1.PartitionReadRequest.index].
	//
	// It is not an error for the `key_set` to name rows that do not
	// exist in the database. Read yields nothing for nonexistent rows.
	KeySet *KeySet `protobuf:"bytes,6,opt,name=key_set,json=keySet,proto3" json:"key_set,omitempty"`
	// Additional options that affect how many partitions are created.
	PartitionOptions *PartitionOptions `protobuf:"bytes,9,opt,name=partition_options,json=partitionOptions,proto3" json:"partition_options,omitempty"`
}

func (x *PartitionReadRequest) Reset() {
	*x = PartitionReadRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_spanner_v1_spanner_proto_msgTypes[13]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *PartitionReadRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PartitionReadRequest) ProtoMessage() {}

func (x *PartitionReadRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_spanner_v1_spanner_proto_msgTypes[13]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PartitionReadRequest.ProtoReflect.Descriptor instead.
func (*PartitionReadRequest) Descriptor() ([]byte, []int) {
	return file_google_spanner_v1_spanner_proto_rawDescGZIP(), []int{13}
}

func (x *PartitionReadRequest) GetSession() string {
	if x != nil {
		return x.Session
	}
	return ""
}

func (x *PartitionReadRequest) GetTransaction() *TransactionSelector {
	if x != nil {
		return x.Transaction
	}
	return nil
}

func (x *PartitionReadRequest) GetTable() string {
	if x != nil {
		return x.Table
	}
	return ""
}

func (x *PartitionReadRequest) GetIndex() string {
	if x != nil {
		return x.Index
	}
	return ""
}

func (x *PartitionReadRequest) GetColumns() []string {
	if x != nil {
		return x.Columns
	}
	return nil
}

func (x *PartitionReadRequest) GetKeySet() *KeySet {
	if x != nil {
		return x.KeySet
	}
	return nil
}

func (x *PartitionReadRequest) GetPartitionOptions() *PartitionOptions {
	if x != nil {
		return x.PartitionOptions
	}
	return nil
}

// Information returned for each partition returned in a
// PartitionResponse.
type Partition struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// This token can be passed to Read, StreamingRead, ExecuteSql, or
	// ExecuteStreamingSql requests to restrict the results to those identified by
	// this partition token.
	PartitionToken []byte `protobuf:"bytes,1,opt,name=partition_token,json=partitionToken,proto3" json:"partition_token,omitempty"`
}

func (x *Partition) Reset() {
	*x = Partition{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_spanner_v1_spanner_proto_msgTypes[14]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Partition) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Partition) ProtoMessage() {}

func (x *Partition) ProtoReflect() protoreflect.Message {
	mi := &file_google_spanner_v1_spanner_proto_msgTypes[14]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Partition.ProtoReflect.Descriptor instead.
func (*Partition) Descriptor() ([]byte, []int) {
	return file_google_spanner_v1_spanner_proto_rawDescGZIP(), []int{14}
}

func (x *Partition) GetPartitionToken() []byte {
	if x != nil {
		return x.PartitionToken
	}
	return nil
}

// The response for [PartitionQuery][google.spanner.v1.Spanner.PartitionQuery]
// or [PartitionRead][google.spanner.v1.Spanner.PartitionRead]
type PartitionResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Partitions created by this request.
	Partitions []*Partition `protobuf:"bytes,1,rep,name=partitions,proto3" json:"partitions,omitempty"`
	// Transaction created by this request.
	Transaction *Transaction `protobuf:"bytes,2,opt,name=transaction,proto3" json:"transaction,omitempty"`
}

func (x *PartitionResponse) Reset() {
	*x = PartitionResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_spanner_v1_spanner_proto_msgTypes[15]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *PartitionResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PartitionResponse) ProtoMessage() {}

func (x *PartitionResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_spanner_v1_spanner_proto_msgTypes[15]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PartitionResponse.ProtoReflect.Descriptor instead.
func (*PartitionResponse) Descriptor() ([]byte, []int) {
	return file_google_spanner_v1_spanner_proto_rawDescGZIP(), []int{15}
}

func (x *PartitionResponse) GetPartitions() []*Partition {
	if x != nil {
		return x.Partitions
	}
	return nil
}

func (x *PartitionResponse) GetTransaction() *Transaction {
	if x != nil {
		return x.Transaction
	}
	return nil
}

// The request for [Read][google.spanner.v1.Spanner.Read] and
// [StreamingRead][google.spanner.v1.Spanner.StreamingRead].
type ReadRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The session in which the read should be performed.
	Session string `protobuf:"bytes,1,opt,name=session,proto3" json:"session,omitempty"`
	// The transaction to use. If none is provided, the default is a
	// temporary read-only transaction with strong concurrency.
	Transaction *TransactionSelector `protobuf:"bytes,2,opt,name=transaction,proto3" json:"transaction,omitempty"`
	// Required. The name of the table in the database to be read.
	Table string `protobuf:"bytes,3,opt,name=table,proto3" json:"table,omitempty"`
	// If non-empty, the name of an index on [table][google.spanner.v1.ReadRequest.table]. This index is
	// used instead of the table primary key when interpreting [key_set][google.spanner.v1.ReadRequest.key_set]
	// and sorting result rows. See [key_set][google.spanner.v1.ReadRequest.key_set] for further information.
	Index string `protobuf:"bytes,4,opt,name=index,proto3" json:"index,omitempty"`
	// Required. The columns of [table][google.spanner.v1.ReadRequest.table] to be returned for each row matching
	// this request.
	Columns []string `protobuf:"bytes,5,rep,name=columns,proto3" json:"columns,omitempty"`
	// Required. `key_set` identifies the rows to be yielded. `key_set` names the
	// primary keys of the rows in [table][google.spanner.v1.ReadRequest.table] to be yielded, unless [index][google.spanner.v1.ReadRequest.index]
	// is present. If [index][google.spanner.v1.ReadRequest.index] is present, then [key_set][google.spanner.v1.ReadRequest.key_set] instead names
	// index keys in [index][google.spanner.v1.ReadRequest.index].
	//
	// If the [partition_token][google.spanner.v1.ReadRequest.partition_token] field is empty, rows are yielded
	// in table primary key order (if [index][google.spanner.v1.ReadRequest.index] is empty) or index key order
	// (if [index][google.spanner.v1.ReadRequest.index] is non-empty).  If the [partition_token][google.spanner.v1.ReadRequest.partition_token] field is not
	// empty, rows will be yielded in an unspecified order.
	//
	// It is not an error for the `key_set` to name rows that do not
	// exist in the database. Read yields nothing for nonexistent rows.
	KeySet *KeySet `protobuf:"bytes,6,opt,name=key_set,json=keySet,proto3" json:"key_set,omitempty"`
	// If greater than zero, only the first `limit` rows are yielded. If `limit`
	// is zero, the default is no limit. A limit cannot be specified if
	// `partition_token` is set.
	Limit int64 `protobuf:"varint,8,opt,name=limit,proto3" json:"limit,omitempty"`
	// If this request is resuming a previously interrupted read,
	// `resume_token` should be copied from the last
	// [PartialResultSet][google.spanner.v1.PartialResultSet] yielded before the interruption. Doing this
	// enables the new read to resume where the last read left off. The
	// rest of the request parameters must exactly match the request
	// that yielded this token.
	ResumeToken []byte `protobuf:"bytes,9,opt,name=resume_token,json=resumeToken,proto3" json:"resume_token,omitempty"`
	// If present, results will be restricted to the specified partition
	// previously created using PartitionRead().    There must be an exact
	// match for the values of fields common to this message and the
	// PartitionReadRequest message used to create this partition_token.
	PartitionToken []byte `protobuf:"bytes,10,opt,name=partition_token,json=partitionToken,proto3" json:"partition_token,omitempty"`
}

func (x *ReadRequest) Reset() {
	*x = ReadRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_spanner_v1_spanner_proto_msgTypes[16]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ReadRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ReadRequest) ProtoMessage() {}

func (x *ReadRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_spanner_v1_spanner_proto_msgTypes[16]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ReadRequest.ProtoReflect.Descriptor instead.
func (*ReadRequest) Descriptor() ([]byte, []int) {
	return file_google_spanner_v1_spanner_proto_rawDescGZIP(), []int{16}
}

func (x *ReadRequest) GetSession() string {
	if x != nil {
		return x.Session
	}
	return ""
}

func (x *ReadRequest) GetTransaction() *TransactionSelector {
	if x != nil {
		return x.Transaction
	}
	return nil
}

func (x *ReadRequest) GetTable() string {
	if x != nil {
		return x.Table
	}
	return ""
}

func (x *ReadRequest) GetIndex() string {
	if x != nil {
		return x.Index
	}
	return ""
}

func (x *ReadRequest) GetColumns() []string {
	if x != nil {
		return x.Columns
	}
	return nil
}

func (x *ReadRequest) GetKeySet() *KeySet {
	if x != nil {
		return x.KeySet
	}
	return nil
}

func (x *ReadRequest) GetLimit() int64 {
	if x != nil {
		return x.Limit
	}
	return 0
}

func (x *ReadRequest) GetResumeToken() []byte {
	if x != nil {
		return x.ResumeToken
	}
	return nil
}

func (x *ReadRequest) GetPartitionToken() []byte {
	if x != nil {
		return x.PartitionToken
	}
	return nil
}

// The request for [BeginTransaction][google.spanner.v1.Spanner.BeginTransaction].
type BeginTransactionRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The session in which the transaction runs.
	Session string `protobuf:"bytes,1,opt,name=session,proto3" json:"session,omitempty"`
	// Required. Options for the new transaction.
	Options *TransactionOptions `protobuf:"bytes,2,opt,name=options,proto3" json:"options,omitempty"`
}

func (x *BeginTransactionRequest) Reset() {
	*x = BeginTransactionRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_spanner_v1_spanner_proto_msgTypes[17]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *BeginTransactionRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*BeginTransactionRequest) ProtoMessage() {}

func (x *BeginTransactionRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_spanner_v1_spanner_proto_msgTypes[17]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use BeginTransactionRequest.ProtoReflect.Descriptor instead.
func (*BeginTransactionRequest) Descriptor() ([]byte, []int) {
	return file_google_spanner_v1_spanner_proto_rawDescGZIP(), []int{17}
}

func (x *BeginTransactionRequest) GetSession() string {
	if x != nil {
		return x.Session
	}
	return ""
}

func (x *BeginTransactionRequest) GetOptions() *TransactionOptions {
	if x != nil {
		return x.Options
	}
	return nil
}

// The request for [Commit][google.spanner.v1.Spanner.Commit].
type CommitRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The session in which the transaction to be committed is running.
	Session string `protobuf:"bytes,1,opt,name=session,proto3" json:"session,omitempty"`
	// Required. The transaction in which to commit.
	//
	// Types that are assignable to Transaction:
	//	*CommitRequest_TransactionId
	//	*CommitRequest_SingleUseTransaction
	Transaction isCommitRequest_Transaction `protobuf_oneof:"transaction"`
	// The mutations to be executed when this transaction commits. All
	// mutations are applied atomically, in the order they appear in
	// this list.
	Mutations []*Mutation `protobuf:"bytes,4,rep,name=mutations,proto3" json:"mutations,omitempty"`
}

func (x *CommitRequest) Reset() {
	*x = CommitRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_spanner_v1_spanner_proto_msgTypes[18]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CommitRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CommitRequest) ProtoMessage() {}

func (x *CommitRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_spanner_v1_spanner_proto_msgTypes[18]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CommitRequest.ProtoReflect.Descriptor instead.
func (*CommitRequest) Descriptor() ([]byte, []int) {
	return file_google_spanner_v1_spanner_proto_rawDescGZIP(), []int{18}
}

func (x *CommitRequest) GetSession() string {
	if x != nil {
		return x.Session
	}
	return ""
}

func (m *CommitRequest) GetTransaction() isCommitRequest_Transaction {
	if m != nil {
		return m.Transaction
	}
	return nil
}

func (x *CommitRequest) GetTransactionId() []byte {
	if x, ok := x.GetTransaction().(*CommitRequest_TransactionId); ok {
		return x.TransactionId
	}
	return nil
}

func (x *CommitRequest) GetSingleUseTransaction() *TransactionOptions {
	if x, ok := x.GetTransaction().(*CommitRequest_SingleUseTransaction); ok {
		return x.SingleUseTransaction
	}
	return nil
}

func (x *CommitRequest) GetMutations() []*Mutation {
	if x != nil {
		return x.Mutations
	}
	return nil
}

type isCommitRequest_Transaction interface {
	isCommitRequest_Transaction()
}

type CommitRequest_TransactionId struct {
	// Commit a previously-started transaction.
	TransactionId []byte `protobuf:"bytes,2,opt,name=transaction_id,json=transactionId,proto3,oneof"`
}

type CommitRequest_SingleUseTransaction struct {
	// Execute mutations in a temporary transaction. Note that unlike
	// commit of a previously-started transaction, commit with a
	// temporary transaction is non-idempotent. That is, if the
	// `CommitRequest` is sent to Cloud Spanner more than once (for
	// instance, due to retries in the application, or in the
	// transport library), it is possible that the mutations are
	// executed more than once. If this is undesirable, use
	// [BeginTransaction][google.spanner.v1.Spanner.BeginTransaction] and
	// [Commit][google.spanner.v1.Spanner.Commit] instead.
	SingleUseTransaction *TransactionOptions `protobuf:"bytes,3,opt,name=single_use_transaction,json=singleUseTransaction,proto3,oneof"`
}

func (*CommitRequest_TransactionId) isCommitRequest_Transaction() {}

func (*CommitRequest_SingleUseTransaction) isCommitRequest_Transaction() {}

// The response for [Commit][google.spanner.v1.Spanner.Commit].
type CommitResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The Cloud Spanner timestamp at which the transaction committed.
	CommitTimestamp *timestamppb.Timestamp `protobuf:"bytes,1,opt,name=commit_timestamp,json=commitTimestamp,proto3" json:"commit_timestamp,omitempty"`
}

func (x *CommitResponse) Reset() {
	*x = CommitResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_spanner_v1_spanner_proto_msgTypes[19]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CommitResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CommitResponse) ProtoMessage() {}

func (x *CommitResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_spanner_v1_spanner_proto_msgTypes[19]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CommitResponse.ProtoReflect.Descriptor instead.
func (*CommitResponse) Descriptor() ([]byte, []int) {
	return file_google_spanner_v1_spanner_proto_rawDescGZIP(), []int{19}
}

func (x *CommitResponse) GetCommitTimestamp() *timestamppb.Timestamp {
	if x != nil {
		return x.CommitTimestamp
	}
	return nil
}

// The request for [Rollback][google.spanner.v1.Spanner.Rollback].
type RollbackRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The session in which the transaction to roll back is running.
	Session string `protobuf:"bytes,1,opt,name=session,proto3" json:"session,omitempty"`
	// Required. The transaction to roll back.
	TransactionId []byte `protobuf:"bytes,2,opt,name=transaction_id,json=transactionId,proto3" json:"transaction_id,omitempty"`
}

func (x *RollbackRequest) Reset() {
	*x = RollbackRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_spanner_v1_spanner_proto_msgTypes[20]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *RollbackRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RollbackRequest) ProtoMessage() {}

func (x *RollbackRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_spanner_v1_spanner_proto_msgTypes[20]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use RollbackRequest.ProtoReflect.Descriptor instead.
func (*RollbackRequest) Descriptor() ([]byte, []int) {
	return file_google_spanner_v1_spanner_proto_rawDescGZIP(), []int{20}
}

func (x *RollbackRequest) GetSession() string {
	if x != nil {
		return x.Session
	}
	return ""
}

func (x *RollbackRequest) GetTransactionId() []byte {
	if x != nil {
		return x.TransactionId
	}
	return nil
}

// Query optimizer configuration.
type ExecuteSqlRequest_QueryOptions struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// An option to control the selection of optimizer version.
	//
	// This parameter allows individual queries to pick different query
	// optimizer versions.
	//
	// Specifying "latest" as a value instructs Cloud Spanner to use the
	// latest supported query optimizer version. If not specified, Cloud Spanner
	// uses optimizer version set at the database level options. Any other
	// positive integer (from the list of supported optimizer versions)
	// overrides the default optimizer version for query execution.
	// The list of supported optimizer versions can be queried from
	// SPANNER_SYS.SUPPORTED_OPTIMIZER_VERSIONS. Executing a SQL statement
	// with an invalid optimizer version will fail with a syntax error
	// (`INVALID_ARGUMENT`) status.
	//
	// The `optimizer_version` statement hint has precedence over this setting.
	OptimizerVersion string `protobuf:"bytes,1,opt,name=optimizer_version,json=optimizerVersion,proto3" json:"optimizer_version,omitempty"`
}

func (x *ExecuteSqlRequest_QueryOptions) Reset() {
	*x = ExecuteSqlRequest_QueryOptions{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_spanner_v1_spanner_proto_msgTypes[22]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ExecuteSqlRequest_QueryOptions) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ExecuteSqlRequest_QueryOptions) ProtoMessage() {}

func (x *ExecuteSqlRequest_QueryOptions) ProtoReflect() protoreflect.Message {
	mi := &file_google_spanner_v1_spanner_proto_msgTypes[22]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ExecuteSqlRequest_QueryOptions.ProtoReflect.Descriptor instead.
func (*ExecuteSqlRequest_QueryOptions) Descriptor() ([]byte, []int) {
	return file_google_spanner_v1_spanner_proto_rawDescGZIP(), []int{8, 0}
}

func (x *ExecuteSqlRequest_QueryOptions) GetOptimizerVersion() string {
	if x != nil {
		return x.OptimizerVersion
	}
	return ""
}

// A single DML statement.
type ExecuteBatchDmlRequest_Statement struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The DML string.
	Sql string `protobuf:"bytes,1,opt,name=sql,proto3" json:"sql,omitempty"`
	// Parameter names and values that bind to placeholders in the DML string.
	//
	// A parameter placeholder consists of the `@` character followed by the
	// parameter name (for example, `@firstName`). Parameter names can contain
	// letters, numbers, and underscores.
	//
	// Parameters can appear anywhere that a literal value is expected.  The
	// same parameter name can be used more than once, for example:
	//
	// `"WHERE id > @msg_id AND id < @msg_id + 100"`
	//
	// It is an error to execute a SQL statement with unbound parameters.
	Params *structpb.Struct `protobuf:"bytes,2,opt,name=params,proto3" json:"params,omitempty"`
	// It is not always possible for Cloud Spanner to infer the right SQL type
	// from a JSON value.  For example, values of type `BYTES` and values
	// of type `STRING` both appear in [params][google.spanner.v1.ExecuteBatchDmlRequest.Statement.params] as JSON strings.
	//
	// In these cases, `param_types` can be used to specify the exact
	// SQL type for some or all of the SQL statement parameters. See the
	// definition of [Type][google.spanner.v1.Type] for more information
	// about SQL types.
	ParamTypes map[string]*Type `protobuf:"bytes,3,rep,name=param_types,json=paramTypes,proto3" json:"param_types,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
}

func (x *ExecuteBatchDmlRequest_Statement) Reset() {
	*x = ExecuteBatchDmlRequest_Statement{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_spanner_v1_spanner_proto_msgTypes[24]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ExecuteBatchDmlRequest_Statement) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ExecuteBatchDmlRequest_Statement) ProtoMessage() {}

func (x *ExecuteBatchDmlRequest_Statement) ProtoReflect() protoreflect.Message {
	mi := &file_google_spanner_v1_spanner_proto_msgTypes[24]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ExecuteBatchDmlRequest_Statement.ProtoReflect.Descriptor instead.
func (*ExecuteBatchDmlRequest_Statement) Descriptor() ([]byte, []int) {
	return file_google_spanner_v1_spanner_proto_rawDescGZIP(), []int{9, 0}
}

func (x *ExecuteBatchDmlRequest_Statement) GetSql() string {
	if x != nil {
		return x.Sql
	}
	return ""
}

func (x *ExecuteBatchDmlRequest_Statement) GetParams() *structpb.Struct {
	if x != nil {
		return x.Params
	}
	return nil
}

func (x *ExecuteBatchDmlRequest_Statement) GetParamTypes() map[string]*Type {
	if x != nil {
		return x.ParamTypes
	}
	return nil
}

var File_google_spanner_v1_spanner_proto protoreflect.FileDescriptor

var file_google_spanner_v1_spanner_proto_rawDesc = []byte{
	0x0a, 0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x73, 0x70, 0x61, 0x6e, 0x6e, 0x65, 0x72,
	0x2f, 0x76, 0x31, 0x2f, 0x73, 0x70, 0x61, 0x6e, 0x6e, 0x65, 0x72, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x12, 0x11, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x70, 0x61, 0x6e, 0x6e, 0x65,
	0x72, 0x2e, 0x76, 0x31, 0x1a, 0x1c, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69,
	0x2f, 0x61, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x1a, 0x17, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x63,
	0x6c, 0x69, 0x65, 0x6e, 0x74, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1f, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x5f, 0x62, 0x65,
	0x68, 0x61, 0x76, 0x69, 0x6f, 0x72, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x19, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63,
	0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1b, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x65, 0x6d, 0x70, 0x74, 0x79, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1c, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x73, 0x74, 0x72, 0x75, 0x63, 0x74, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x1a, 0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x62, 0x75, 0x66, 0x2f, 0x74, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x1a, 0x17, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x72, 0x70, 0x63, 0x2f,
	0x73, 0x74, 0x61, 0x74, 0x75, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1c, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x73, 0x70, 0x61, 0x6e, 0x6e, 0x65, 0x72, 0x2f, 0x76, 0x31, 0x2f,
	0x6b, 0x65, 0x79, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x20, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2f, 0x73, 0x70, 0x61, 0x6e, 0x6e, 0x65, 0x72, 0x2f, 0x76, 0x31, 0x2f, 0x6d, 0x75,
	0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x22, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x73, 0x70, 0x61, 0x6e, 0x6e, 0x65, 0x72, 0x2f, 0x76, 0x31, 0x2f,
	0x72, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x5f, 0x73, 0x65, 0x74, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x1a, 0x23, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x73, 0x70, 0x61, 0x6e, 0x6e, 0x65, 0x72,
	0x2f, 0x76, 0x31, 0x2f, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1c, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x73, 0x70,
	0x61, 0x6e, 0x6e, 0x65, 0x72, 0x2f, 0x76, 0x31, 0x2f, 0x74, 0x79, 0x70, 0x65, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x22, 0x91, 0x01, 0x0a, 0x14, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x53, 0x65,
	0x73, 0x73, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x43, 0x0a, 0x08,
	0x64, 0x61, 0x74, 0x61, 0x62, 0x61, 0x73, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x27,
	0xe0, 0x41, 0x02, 0xfa, 0x41, 0x21, 0x0a, 0x1f, 0x73, 0x70, 0x61, 0x6e, 0x6e, 0x65, 0x72, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x44,
	0x61, 0x74, 0x61, 0x62, 0x61, 0x73, 0x65, 0x52, 0x08, 0x64, 0x61, 0x74, 0x61, 0x62, 0x61, 0x73,
	0x65, 0x12, 0x34, 0x0a, 0x07, 0x73, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x70, 0x61, 0x6e,
	0x6e, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x52, 0x07,
	0x73, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x22, 0xd2, 0x01, 0x0a, 0x1a, 0x42, 0x61, 0x74, 0x63,
	0x68, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x53, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x52,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x43, 0x0a, 0x08, 0x64, 0x61, 0x74, 0x61, 0x62, 0x61,
	0x73, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x27, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x21,
	0x0a, 0x1f, 0x73, 0x70, 0x61, 0x6e, 0x6e, 0x65, 0x72, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x44, 0x61, 0x74, 0x61, 0x62, 0x61, 0x73,
	0x65, 0x52, 0x08, 0x64, 0x61, 0x74, 0x61, 0x62, 0x61, 0x73, 0x65, 0x12, 0x45, 0x0a, 0x10, 0x73,
	0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x5f, 0x74, 0x65, 0x6d, 0x70, 0x6c, 0x61, 0x74, 0x65, 0x18,
	0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73,
	0x70, 0x61, 0x6e, 0x6e, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x65, 0x73, 0x73, 0x69, 0x6f,
	0x6e, 0x52, 0x0f, 0x73, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x54, 0x65, 0x6d, 0x70, 0x6c, 0x61,
	0x74, 0x65, 0x12, 0x28, 0x0a, 0x0d, 0x73, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x5f, 0x63, 0x6f,
	0x75, 0x6e, 0x74, 0x18, 0x03, 0x20, 0x01, 0x28, 0x05, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0c,
	0x73, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x43, 0x6f, 0x75, 0x6e, 0x74, 0x22, 0x53, 0x0a, 0x1b,
	0x42, 0x61, 0x74, 0x63, 0x68, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x53, 0x65, 0x73, 0x73, 0x69,
	0x6f, 0x6e, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x34, 0x0a, 0x07, 0x73,
	0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x70, 0x61, 0x6e, 0x6e, 0x65, 0x72, 0x2e, 0x76, 0x31,
	0x2e, 0x53, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x52, 0x07, 0x73, 0x65, 0x73, 0x73, 0x69, 0x6f,
	0x6e, 0x22, 0xa2, 0x03, 0x0a, 0x07, 0x53, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x12, 0x12, 0x0a,
	0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x6e, 0x61, 0x6d,
	0x65, 0x12, 0x3e, 0x0a, 0x06, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28,
	0x0b, 0x32, 0x26, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x70, 0x61, 0x6e, 0x6e,
	0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x2e, 0x4c, 0x61,
	0x62, 0x65, 0x6c, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x52, 0x06, 0x6c, 0x61, 0x62, 0x65, 0x6c,
	0x73, 0x12, 0x3b, 0x0a, 0x0b, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65,
	0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61,
	0x6d, 0x70, 0x52, 0x0a, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x55,
	0x0a, 0x19, 0x61, 0x70, 0x70, 0x72, 0x6f, 0x78, 0x69, 0x6d, 0x61, 0x74, 0x65, 0x5f, 0x6c, 0x61,
	0x73, 0x74, 0x5f, 0x75, 0x73, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x52, 0x16, 0x61,
	0x70, 0x70, 0x72, 0x6f, 0x78, 0x69, 0x6d, 0x61, 0x74, 0x65, 0x4c, 0x61, 0x73, 0x74, 0x55, 0x73,
	0x65, 0x54, 0x69, 0x6d, 0x65, 0x1a, 0x39, 0x0a, 0x0b, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x45,
	0x6e, 0x74, 0x72, 0x79, 0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x14, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18,
	0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x3a, 0x02, 0x38, 0x01,
	0x3a, 0x74, 0xea, 0x41, 0x71, 0x0a, 0x1e, 0x73, 0x70, 0x61, 0x6e, 0x6e, 0x65, 0x72, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x53, 0x65,
	0x73, 0x73, 0x69, 0x6f, 0x6e, 0x12, 0x4f, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f,
	0x7b, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x7d, 0x2f, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e,
	0x63, 0x65, 0x73, 0x2f, 0x7b, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x7d, 0x2f, 0x64,
	0x61, 0x74, 0x61, 0x62, 0x61, 0x73, 0x65, 0x73, 0x2f, 0x7b, 0x64, 0x61, 0x74, 0x61, 0x62, 0x61,
	0x73, 0x65, 0x7d, 0x2f, 0x73, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x7b, 0x73, 0x65,
	0x73, 0x73, 0x69, 0x6f, 0x6e, 0x7d, 0x22, 0x4f, 0x0a, 0x11, 0x47, 0x65, 0x74, 0x53, 0x65, 0x73,
	0x73, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x3a, 0x0a, 0x04, 0x6e,
	0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x26, 0xe0, 0x41, 0x02, 0xfa, 0x41,
	0x20, 0x0a, 0x1e, 0x73, 0x70, 0x61, 0x6e, 0x6e, 0x65, 0x72, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x53, 0x65, 0x73, 0x73, 0x69, 0x6f,
	0x6e, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x22, 0xae, 0x01, 0x0a, 0x13, 0x4c, 0x69, 0x73, 0x74,
	0x53, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12,
	0x43, 0x0a, 0x08, 0x64, 0x61, 0x74, 0x61, 0x62, 0x61, 0x73, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x09, 0x42, 0x27, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x21, 0x0a, 0x1f, 0x73, 0x70, 0x61, 0x6e, 0x6e,
	0x65, 0x72, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f,
	0x6d, 0x2f, 0x44, 0x61, 0x74, 0x61, 0x62, 0x61, 0x73, 0x65, 0x52, 0x08, 0x64, 0x61, 0x74, 0x61,
	0x62, 0x61, 0x73, 0x65, 0x12, 0x1b, 0x0a, 0x09, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x73, 0x69, 0x7a,
	0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x05, 0x52, 0x08, 0x70, 0x61, 0x67, 0x65, 0x53, 0x69, 0x7a,
	0x65, 0x12, 0x1d, 0x0a, 0x0a, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18,
	0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x70, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e,
	0x12, 0x16, 0x0a, 0x06, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x06, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x22, 0x76, 0x0a, 0x14, 0x4c, 0x69, 0x73, 0x74,
	0x53, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65,
	0x12, 0x36, 0x0a, 0x08, 0x73, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x01, 0x20, 0x03,
	0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x70, 0x61, 0x6e,
	0x6e, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x52, 0x08,
	0x73, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0x26, 0x0a, 0x0f, 0x6e, 0x65, 0x78, 0x74,
	0x5f, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x0d, 0x6e, 0x65, 0x78, 0x74, 0x50, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e,
	0x22, 0x52, 0x0a, 0x14, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x53, 0x65, 0x73, 0x73, 0x69, 0x6f,
	0x6e, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x3a, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x26, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x20, 0x0a, 0x1e,
	0x73, 0x70, 0x61, 0x6e, 0x6e, 0x65, 0x72, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70,
	0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x53, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x52, 0x04,
	0x6e, 0x61, 0x6d, 0x65, 0x22, 0x8c, 0x06, 0x0a, 0x11, 0x45, 0x78, 0x65, 0x63, 0x75, 0x74, 0x65,
	0x53, 0x71, 0x6c, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x40, 0x0a, 0x07, 0x73, 0x65,
	0x73, 0x73, 0x69, 0x6f, 0x6e, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x26, 0xe0, 0x41, 0x02,
	0xfa, 0x41, 0x20, 0x0a, 0x1e, 0x73, 0x70, 0x61, 0x6e, 0x6e, 0x65, 0x72, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x53, 0x65, 0x73, 0x73,
	0x69, 0x6f, 0x6e, 0x52, 0x07, 0x73, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x12, 0x48, 0x0a, 0x0b,
	0x74, 0x72, 0x61, 0x6e, 0x73, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x26, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x70, 0x61, 0x6e, 0x6e,
	0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x54, 0x72, 0x61, 0x6e, 0x73, 0x61, 0x63, 0x74, 0x69, 0x6f,
	0x6e, 0x53, 0x65, 0x6c, 0x65, 0x63, 0x74, 0x6f, 0x72, 0x52, 0x0b, 0x74, 0x72, 0x61, 0x6e, 0x73,
	0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x15, 0x0a, 0x03, 0x73, 0x71, 0x6c, 0x18, 0x03, 0x20,
	0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x03, 0x73, 0x71, 0x6c, 0x12, 0x2f, 0x0a,
	0x06, 0x70, 0x61, 0x72, 0x61, 0x6d, 0x73, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x17, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e,
	0x53, 0x74, 0x72, 0x75, 0x63, 0x74, 0x52, 0x06, 0x70, 0x61, 0x72, 0x61, 0x6d, 0x73, 0x12, 0x55,
	0x0a, 0x0b, 0x70, 0x61, 0x72, 0x61, 0x6d, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x73, 0x18, 0x05, 0x20,
	0x03, 0x28, 0x0b, 0x32, 0x34, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x70, 0x61,
	0x6e, 0x6e, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x45, 0x78, 0x65, 0x63, 0x75, 0x74, 0x65, 0x53,
	0x71, 0x6c, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x2e, 0x50, 0x61, 0x72, 0x61, 0x6d, 0x54,
	0x79, 0x70, 0x65, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x52, 0x0a, 0x70, 0x61, 0x72, 0x61, 0x6d,
	0x54, 0x79, 0x70, 0x65, 0x73, 0x12, 0x21, 0x0a, 0x0c, 0x72, 0x65, 0x73, 0x75, 0x6d, 0x65, 0x5f,
	0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x06, 0x20, 0x01, 0x28, 0x0c, 0x52, 0x0b, 0x72, 0x65, 0x73,
	0x75, 0x6d, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x12, 0x4d, 0x0a, 0x0a, 0x71, 0x75, 0x65, 0x72,
	0x79, 0x5f, 0x6d, 0x6f, 0x64, 0x65, 0x18, 0x07, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x2e, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x70, 0x61, 0x6e, 0x6e, 0x65, 0x72, 0x2e, 0x76, 0x31,
	0x2e, 0x45, 0x78, 0x65, 0x63, 0x75, 0x74, 0x65, 0x53, 0x71, 0x6c, 0x52, 0x65, 0x71, 0x75, 0x65,
	0x73, 0x74, 0x2e, 0x51, 0x75, 0x65, 0x72, 0x79, 0x4d, 0x6f, 0x64, 0x65, 0x52, 0x09, 0x71, 0x75,
	0x65, 0x72, 0x79, 0x4d, 0x6f, 0x64, 0x65, 0x12, 0x27, 0x0a, 0x0f, 0x70, 0x61, 0x72, 0x74, 0x69,
	0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x08, 0x20, 0x01, 0x28, 0x0c,
	0x52, 0x0e, 0x70, 0x61, 0x72, 0x74, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x54, 0x6f, 0x6b, 0x65, 0x6e,
	0x12, 0x14, 0x0a, 0x05, 0x73, 0x65, 0x71, 0x6e, 0x6f, 0x18, 0x09, 0x20, 0x01, 0x28, 0x03, 0x52,
	0x05, 0x73, 0x65, 0x71, 0x6e, 0x6f, 0x12, 0x56, 0x0a, 0x0d, 0x71, 0x75, 0x65, 0x72, 0x79, 0x5f,
	0x6f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x0a, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x31, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x70, 0x61, 0x6e, 0x6e, 0x65, 0x72, 0x2e, 0x76,
	0x31, 0x2e, 0x45, 0x78, 0x65, 0x63, 0x75, 0x74, 0x65, 0x53, 0x71, 0x6c, 0x52, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x2e, 0x51, 0x75, 0x65, 0x72, 0x79, 0x4f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73,
	0x52, 0x0c, 0x71, 0x75, 0x65, 0x72, 0x79, 0x4f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x1a, 0x3b,
	0x0a, 0x0c, 0x51, 0x75, 0x65, 0x72, 0x79, 0x4f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0x2b,
	0x0a, 0x11, 0x6f, 0x70, 0x74, 0x69, 0x6d, 0x69, 0x7a, 0x65, 0x72, 0x5f, 0x76, 0x65, 0x72, 0x73,
	0x69, 0x6f, 0x6e, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x10, 0x6f, 0x70, 0x74, 0x69, 0x6d,
	0x69, 0x7a, 0x65, 0x72, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x1a, 0x56, 0x0a, 0x0f, 0x50,
	0x61, 0x72, 0x61, 0x6d, 0x54, 0x79, 0x70, 0x65, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x12, 0x10,
	0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x6b, 0x65, 0x79,
	0x12, 0x2d, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x17, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x70, 0x61, 0x6e, 0x6e, 0x65, 0x72,
	0x2e, 0x76, 0x31, 0x2e, 0x54, 0x79, 0x70, 0x65, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x3a,
	0x02, 0x38, 0x01, 0x22, 0x2e, 0x0a, 0x09, 0x51, 0x75, 0x65, 0x72, 0x79, 0x4d, 0x6f, 0x64, 0x65,
	0x12, 0x0a, 0x0a, 0x06, 0x4e, 0x4f, 0x52, 0x4d, 0x41, 0x4c, 0x10, 0x00, 0x12, 0x08, 0x0a, 0x04,
	0x50, 0x4c, 0x41, 0x4e, 0x10, 0x01, 0x12, 0x0b, 0x0a, 0x07, 0x50, 0x52, 0x4f, 0x46, 0x49, 0x4c,
	0x45, 0x10, 0x02, 0x22, 0xad, 0x04, 0x0a, 0x16, 0x45, 0x78, 0x65, 0x63, 0x75, 0x74, 0x65, 0x42,
	0x61, 0x74, 0x63, 0x68, 0x44, 0x6d, 0x6c, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x40,
	0x0a, 0x07, 0x73, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42,
	0x26, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x20, 0x0a, 0x1e, 0x73, 0x70, 0x61, 0x6e, 0x6e, 0x65, 0x72,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f,
	0x53, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x52, 0x07, 0x73, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e,
	0x12, 0x4d, 0x0a, 0x0b, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x18,
	0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x26, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73,
	0x70, 0x61, 0x6e, 0x6e, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x54, 0x72, 0x61, 0x6e, 0x73, 0x61,
	0x63, 0x74, 0x69, 0x6f, 0x6e, 0x53, 0x65, 0x6c, 0x65, 0x63, 0x74, 0x6f, 0x72, 0x42, 0x03, 0xe0,
	0x41, 0x02, 0x52, 0x0b, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x12,
	0x58, 0x0a, 0x0a, 0x73, 0x74, 0x61, 0x74, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x73, 0x18, 0x03, 0x20,
	0x03, 0x28, 0x0b, 0x32, 0x33, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x70, 0x61,
	0x6e, 0x6e, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x45, 0x78, 0x65, 0x63, 0x75, 0x74, 0x65, 0x42,
	0x61, 0x74, 0x63, 0x68, 0x44, 0x6d, 0x6c, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x2e, 0x53,
	0x74, 0x61, 0x74, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0a, 0x73,
	0x74, 0x61, 0x74, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x73, 0x12, 0x19, 0x0a, 0x05, 0x73, 0x65, 0x71,
	0x6e, 0x6f, 0x18, 0x04, 0x20, 0x01, 0x28, 0x03, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x05, 0x73,
	0x65, 0x71, 0x6e, 0x6f, 0x1a, 0x8c, 0x02, 0x0a, 0x09, 0x53, 0x74, 0x61, 0x74, 0x65, 0x6d, 0x65,
	0x6e, 0x74, 0x12, 0x10, 0x0a, 0x03, 0x73, 0x71, 0x6c, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x03, 0x73, 0x71, 0x6c, 0x12, 0x2f, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x61, 0x6d, 0x73, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x17, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x53, 0x74, 0x72, 0x75, 0x63, 0x74, 0x52, 0x06, 0x70,
	0x61, 0x72, 0x61, 0x6d, 0x73, 0x12, 0x64, 0x0a, 0x0b, 0x70, 0x61, 0x72, 0x61, 0x6d, 0x5f, 0x74,
	0x79, 0x70, 0x65, 0x73, 0x18, 0x03, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x43, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x73, 0x70, 0x61, 0x6e, 0x6e, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x45,
	0x78, 0x65, 0x63, 0x75, 0x74, 0x65, 0x42, 0x61, 0x74, 0x63, 0x68, 0x44, 0x6d, 0x6c, 0x52, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x2e, 0x53, 0x74, 0x61, 0x74, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x2e,
	0x50, 0x61, 0x72, 0x61, 0x6d, 0x54, 0x79, 0x70, 0x65, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x52,
	0x0a, 0x70, 0x61, 0x72, 0x61, 0x6d, 0x54, 0x79, 0x70, 0x65, 0x73, 0x1a, 0x56, 0x0a, 0x0f, 0x50,
	0x61, 0x72, 0x61, 0x6d, 0x54, 0x79, 0x70, 0x65, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x12, 0x10,
	0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x6b, 0x65, 0x79,
	0x12, 0x2d, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x17, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x70, 0x61, 0x6e, 0x6e, 0x65, 0x72,
	0x2e, 0x76, 0x31, 0x2e, 0x54, 0x79, 0x70, 0x65, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x3a,
	0x02, 0x38, 0x01, 0x22, 0x84, 0x01, 0x0a, 0x17, 0x45, 0x78, 0x65, 0x63, 0x75, 0x74, 0x65, 0x42,
	0x61, 0x74, 0x63, 0x68, 0x44, 0x6d, 0x6c, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12,
	0x3d, 0x0a, 0x0b, 0x72, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x5f, 0x73, 0x65, 0x74, 0x73, 0x18, 0x01,
	0x20, 0x03, 0x28, 0x0b, 0x32, 0x1c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x70,
	0x61, 0x6e, 0x6e, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x53,
	0x65, 0x74, 0x52, 0x0a, 0x72, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x53, 0x65, 0x74, 0x73, 0x12, 0x2a,
	0x0a, 0x06, 0x73, 0x74, 0x61, 0x74, 0x75, 0x73, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x12,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x72, 0x70, 0x63, 0x2e, 0x53, 0x74, 0x61, 0x74,
	0x75, 0x73, 0x52, 0x06, 0x73, 0x74, 0x61, 0x74, 0x75, 0x73, 0x22, 0x6b, 0x0a, 0x10, 0x50, 0x61,
	0x72, 0x74, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x4f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0x30,
	0x0a, 0x14, 0x70, 0x61, 0x72, 0x74, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x73, 0x69, 0x7a, 0x65,
	0x5f, 0x62, 0x79, 0x74, 0x65, 0x73, 0x18, 0x01, 0x20, 0x01, 0x28, 0x03, 0x52, 0x12, 0x70, 0x61,
	0x72, 0x74, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x53, 0x69, 0x7a, 0x65, 0x42, 0x79, 0x74, 0x65, 0x73,
	0x12, 0x25, 0x0a, 0x0e, 0x6d, 0x61, 0x78, 0x5f, 0x70, 0x61, 0x72, 0x74, 0x69, 0x74, 0x69, 0x6f,
	0x6e, 0x73, 0x18, 0x02, 0x20, 0x01, 0x28, 0x03, 0x52, 0x0d, 0x6d, 0x61, 0x78, 0x50, 0x61, 0x72,
	0x74, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x22, 0xf0, 0x03, 0x0a, 0x15, 0x50, 0x61, 0x72, 0x74,
	0x69, 0x74, 0x69, 0x6f, 0x6e, 0x51, 0x75, 0x65, 0x72, 0x79, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x12, 0x40, 0x0a, 0x07, 0x73, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x09, 0x42, 0x26, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x20, 0x0a, 0x1e, 0x73, 0x70, 0x61, 0x6e,
	0x6e, 0x65, 0x72, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63,
	0x6f, 0x6d, 0x2f, 0x53, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x52, 0x07, 0x73, 0x65, 0x73, 0x73,
	0x69, 0x6f, 0x6e, 0x12, 0x48, 0x0a, 0x0b, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x61, 0x63, 0x74, 0x69,
	0x6f, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x26, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x73, 0x70, 0x61, 0x6e, 0x6e, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x54, 0x72, 0x61,
	0x6e, 0x73, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x53, 0x65, 0x6c, 0x65, 0x63, 0x74, 0x6f, 0x72,
	0x52, 0x0b, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x15, 0x0a,
	0x03, 0x73, 0x71, 0x6c, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52,
	0x03, 0x73, 0x71, 0x6c, 0x12, 0x2f, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x61, 0x6d, 0x73, 0x18, 0x04,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x17, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x53, 0x74, 0x72, 0x75, 0x63, 0x74, 0x52, 0x06, 0x70,
	0x61, 0x72, 0x61, 0x6d, 0x73, 0x12, 0x59, 0x0a, 0x0b, 0x70, 0x61, 0x72, 0x61, 0x6d, 0x5f, 0x74,
	0x79, 0x70, 0x65, 0x73, 0x18, 0x05, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x38, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x73, 0x70, 0x61, 0x6e, 0x6e, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x50,
	0x61, 0x72, 0x74, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x51, 0x75, 0x65, 0x72, 0x79, 0x52, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x2e, 0x50, 0x61, 0x72, 0x61, 0x6d, 0x54, 0x79, 0x70, 0x65, 0x73, 0x45,
	0x6e, 0x74, 0x72, 0x79, 0x52, 0x0a, 0x70, 0x61, 0x72, 0x61, 0x6d, 0x54, 0x79, 0x70, 0x65, 0x73,
	0x12, 0x50, 0x0a, 0x11, 0x70, 0x61, 0x72, 0x74, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x6f, 0x70,
	0x74, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x06, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x23, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x70, 0x61, 0x6e, 0x6e, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e,
	0x50, 0x61, 0x72, 0x74, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x4f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73,
	0x52, 0x10, 0x70, 0x61, 0x72, 0x74, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x4f, 0x70, 0x74, 0x69, 0x6f,
	0x6e, 0x73, 0x1a, 0x56, 0x0a, 0x0f, 0x50, 0x61, 0x72, 0x61, 0x6d, 0x54, 0x79, 0x70, 0x65, 0x73,
	0x45, 0x6e, 0x74, 0x72, 0x79, 0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x2d, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x17, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x73, 0x70, 0x61, 0x6e, 0x6e, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x54, 0x79, 0x70, 0x65, 0x52,
	0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x3a, 0x02, 0x38, 0x01, 0x22, 0xf8, 0x02, 0x0a, 0x14, 0x50,
	0x61, 0x72, 0x74, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x61, 0x64, 0x52, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x12, 0x40, 0x0a, 0x07, 0x73, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x09, 0x42, 0x26, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x20, 0x0a, 0x1e, 0x73, 0x70,
	0x61, 0x6e, 0x6e, 0x65, 0x72, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73,
	0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x53, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x52, 0x07, 0x73, 0x65,
	0x73, 0x73, 0x69, 0x6f, 0x6e, 0x12, 0x48, 0x0a, 0x0b, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x61, 0x63,
	0x74, 0x69, 0x6f, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x26, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x73, 0x70, 0x61, 0x6e, 0x6e, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x54,
	0x72, 0x61, 0x6e, 0x73, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x53, 0x65, 0x6c, 0x65, 0x63, 0x74,
	0x6f, 0x72, 0x52, 0x0b, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x12,
	0x19, 0x0a, 0x05, 0x74, 0x61, 0x62, 0x6c, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03,
	0xe0, 0x41, 0x02, 0x52, 0x05, 0x74, 0x61, 0x62, 0x6c, 0x65, 0x12, 0x14, 0x0a, 0x05, 0x69, 0x6e,
	0x64, 0x65, 0x78, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x69, 0x6e, 0x64, 0x65, 0x78,
	0x12, 0x18, 0x0a, 0x07, 0x63, 0x6f, 0x6c, 0x75, 0x6d, 0x6e, 0x73, 0x18, 0x05, 0x20, 0x03, 0x28,
	0x09, 0x52, 0x07, 0x63, 0x6f, 0x6c, 0x75, 0x6d, 0x6e, 0x73, 0x12, 0x37, 0x0a, 0x07, 0x6b, 0x65,
	0x79, 0x5f, 0x73, 0x65, 0x74, 0x18, 0x06, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x19, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x70, 0x61, 0x6e, 0x6e, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e,
	0x4b, 0x65, 0x79, 0x53, 0x65, 0x74, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x06, 0x6b, 0x65, 0x79,
	0x53, 0x65, 0x74, 0x12, 0x50, 0x0a, 0x11, 0x70, 0x61, 0x72, 0x74, 0x69, 0x74, 0x69, 0x6f, 0x6e,
	0x5f, 0x6f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x09, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x23,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x70, 0x61, 0x6e, 0x6e, 0x65, 0x72, 0x2e,
	0x76, 0x31, 0x2e, 0x50, 0x61, 0x72, 0x74, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x4f, 0x70, 0x74, 0x69,
	0x6f, 0x6e, 0x73, 0x52, 0x10, 0x70, 0x61, 0x72, 0x74, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x4f, 0x70,
	0x74, 0x69, 0x6f, 0x6e, 0x73, 0x22, 0x34, 0x0a, 0x09, 0x50, 0x61, 0x72, 0x74, 0x69, 0x74, 0x69,
	0x6f, 0x6e, 0x12, 0x27, 0x0a, 0x0f, 0x70, 0x61, 0x72, 0x74, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x5f,
	0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0c, 0x52, 0x0e, 0x70, 0x61, 0x72,
	0x74, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x22, 0x93, 0x01, 0x0a, 0x11,
	0x50, 0x61, 0x72, 0x74, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73,
	0x65, 0x12, 0x3c, 0x0a, 0x0a, 0x70, 0x61, 0x72, 0x74, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x18,
	0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x1c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73,
	0x70, 0x61, 0x6e, 0x6e, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x50, 0x61, 0x72, 0x74, 0x69, 0x74,
	0x69, 0x6f, 0x6e, 0x52, 0x0a, 0x70, 0x61, 0x72, 0x74, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x12,
	0x40, 0x0a, 0x0b, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x1e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x70,
	0x61, 0x6e, 0x6e, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x54, 0x72, 0x61, 0x6e, 0x73, 0x61, 0x63,
	0x74, 0x69, 0x6f, 0x6e, 0x52, 0x0b, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x61, 0x63, 0x74, 0x69, 0x6f,
	0x6e, 0x22, 0x84, 0x03, 0x0a, 0x0b, 0x52, 0x65, 0x61, 0x64, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x12, 0x40, 0x0a, 0x07, 0x73, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x09, 0x42, 0x26, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x20, 0x0a, 0x1e, 0x73, 0x70, 0x61, 0x6e,
	0x6e, 0x65, 0x72, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63,
	0x6f, 0x6d, 0x2f, 0x53, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x52, 0x07, 0x73, 0x65, 0x73, 0x73,
	0x69, 0x6f, 0x6e, 0x12, 0x48, 0x0a, 0x0b, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x61, 0x63, 0x74, 0x69,
	0x6f, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x26, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x73, 0x70, 0x61, 0x6e, 0x6e, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x54, 0x72, 0x61,
	0x6e, 0x73, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x53, 0x65, 0x6c, 0x65, 0x63, 0x74, 0x6f, 0x72,
	0x52, 0x0b, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x19, 0x0a,
	0x05, 0x74, 0x61, 0x62, 0x6c, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41,
	0x02, 0x52, 0x05, 0x74, 0x61, 0x62, 0x6c, 0x65, 0x12, 0x14, 0x0a, 0x05, 0x69, 0x6e, 0x64, 0x65,
	0x78, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x69, 0x6e, 0x64, 0x65, 0x78, 0x12, 0x1d,
	0x0a, 0x07, 0x63, 0x6f, 0x6c, 0x75, 0x6d, 0x6e, 0x73, 0x18, 0x05, 0x20, 0x03, 0x28, 0x09, 0x42,
	0x03, 0xe0, 0x41, 0x02, 0x52, 0x07, 0x63, 0x6f, 0x6c, 0x75, 0x6d, 0x6e, 0x73, 0x12, 0x37, 0x0a,
	0x07, 0x6b, 0x65, 0x79, 0x5f, 0x73, 0x65, 0x74, 0x18, 0x06, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x19,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x70, 0x61, 0x6e, 0x6e, 0x65, 0x72, 0x2e,
	0x76, 0x31, 0x2e, 0x4b, 0x65, 0x79, 0x53, 0x65, 0x74, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x06,
	0x6b, 0x65, 0x79, 0x53, 0x65, 0x74, 0x12, 0x14, 0x0a, 0x05, 0x6c, 0x69, 0x6d, 0x69, 0x74, 0x18,
	0x08, 0x20, 0x01, 0x28, 0x03, 0x52, 0x05, 0x6c, 0x69, 0x6d, 0x69, 0x74, 0x12, 0x21, 0x0a, 0x0c,
	0x72, 0x65, 0x73, 0x75, 0x6d, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x09, 0x20, 0x01,
	0x28, 0x0c, 0x52, 0x0b, 0x72, 0x65, 0x73, 0x75, 0x6d, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x12,
	0x27, 0x0a, 0x0f, 0x70, 0x61, 0x72, 0x74, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x74, 0x6f, 0x6b,
	0x65, 0x6e, 0x18, 0x0a, 0x20, 0x01, 0x28, 0x0c, 0x52, 0x0e, 0x70, 0x61, 0x72, 0x74, 0x69, 0x74,
	0x69, 0x6f, 0x6e, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x22, 0xa1, 0x01, 0x0a, 0x17, 0x42, 0x65, 0x67,
	0x69, 0x6e, 0x54, 0x72, 0x61, 0x6e, 0x73, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x12, 0x40, 0x0a, 0x07, 0x73, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x26, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x20, 0x0a, 0x1e, 0x73,
	0x70, 0x61, 0x6e, 0x6e, 0x65, 0x72, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69,
	0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x53, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x52, 0x07, 0x73,
	0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x12, 0x44, 0x0a, 0x07, 0x6f, 0x70, 0x74, 0x69, 0x6f, 0x6e,
	0x73, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x25, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x73, 0x70, 0x61, 0x6e, 0x6e, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x54, 0x72, 0x61, 0x6e,
	0x73, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x4f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x42, 0x03,
	0xe0, 0x41, 0x02, 0x52, 0x07, 0x6f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x22, 0xa3, 0x02, 0x0a,
	0x0d, 0x43, 0x6f, 0x6d, 0x6d, 0x69, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x40,
	0x0a, 0x07, 0x73, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42,
	0x26, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x20, 0x0a, 0x1e, 0x73, 0x70, 0x61, 0x6e, 0x6e, 0x65, 0x72,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f,
	0x53, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x52, 0x07, 0x73, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e,
	0x12, 0x27, 0x0a, 0x0e, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x5f,
	0x69, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0c, 0x48, 0x00, 0x52, 0x0d, 0x74, 0x72, 0x61, 0x6e,
	0x73, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x49, 0x64, 0x12, 0x5d, 0x0a, 0x16, 0x73, 0x69, 0x6e,
	0x67, 0x6c, 0x65, 0x5f, 0x75, 0x73, 0x65, 0x5f, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x61, 0x63, 0x74,
	0x69, 0x6f, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x25, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x73, 0x70, 0x61, 0x6e, 0x6e, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x54, 0x72,
	0x61, 0x6e, 0x73, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x4f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73,
	0x48, 0x00, 0x52, 0x14, 0x73, 0x69, 0x6e, 0x67, 0x6c, 0x65, 0x55, 0x73, 0x65, 0x54, 0x72, 0x61,
	0x6e, 0x73, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x39, 0x0a, 0x09, 0x6d, 0x75, 0x74, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x04, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x1b, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x70, 0x61, 0x6e, 0x6e, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e,
	0x4d, 0x75, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x09, 0x6d, 0x75, 0x74, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x73, 0x42, 0x0d, 0x0a, 0x0b, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x61, 0x63, 0x74, 0x69,
	0x6f, 0x6e, 0x22, 0x57, 0x0a, 0x0e, 0x43, 0x6f, 0x6d, 0x6d, 0x69, 0x74, 0x52, 0x65, 0x73, 0x70,
	0x6f, 0x6e, 0x73, 0x65, 0x12, 0x45, 0x0a, 0x10, 0x63, 0x6f, 0x6d, 0x6d, 0x69, 0x74, 0x5f, 0x74,
	0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66,
	0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x52, 0x0f, 0x63, 0x6f, 0x6d, 0x6d,
	0x69, 0x74, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x22, 0x7f, 0x0a, 0x0f, 0x52,
	0x6f, 0x6c, 0x6c, 0x62, 0x61, 0x63, 0x6b, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x40,
	0x0a, 0x07, 0x73, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42,
	0x26, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x20, 0x0a, 0x1e, 0x73, 0x70, 0x61, 0x6e, 0x6e, 0x65, 0x72,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f,
	0x53, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x52, 0x07, 0x73, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e,
	0x12, 0x2a, 0x0a, 0x0e, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x5f,
	0x69, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0c, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0d, 0x74,
	0x72, 0x61, 0x6e, 0x73, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x49, 0x64, 0x32, 0xc0, 0x16, 0x0a,
	0x07, 0x53, 0x70, 0x61, 0x6e, 0x6e, 0x65, 0x72, 0x12, 0xa6, 0x01, 0x0a, 0x0d, 0x43, 0x72, 0x65,
	0x61, 0x74, 0x65, 0x53, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x12, 0x27, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x73, 0x70, 0x61, 0x6e, 0x6e, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x43,
	0x72, 0x65, 0x61, 0x74, 0x65, 0x53, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x1a, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x70, 0x61,
	0x6e, 0x6e, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x22,
	0x50, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x3f, 0x22, 0x3a, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x64, 0x61,
	0x74, 0x61, 0x62, 0x61, 0x73, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f,
	0x2a, 0x2f, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x73, 0x2f, 0x2a, 0x2f, 0x64, 0x61,
	0x74, 0x61, 0x62, 0x61, 0x73, 0x65, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x73, 0x65, 0x73, 0x73, 0x69,
	0x6f, 0x6e, 0x73, 0x3a, 0x01, 0x2a, 0xda, 0x41, 0x08, 0x64, 0x61, 0x74, 0x61, 0x62, 0x61, 0x73,
	0x65, 0x12, 0xe0, 0x01, 0x0a, 0x13, 0x42, 0x61, 0x74, 0x63, 0x68, 0x43, 0x72, 0x65, 0x61, 0x74,
	0x65, 0x53, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0x2d, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x73, 0x70, 0x61, 0x6e, 0x6e, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x42, 0x61,
	0x74, 0x63, 0x68, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x53, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e,
	0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x2e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x73, 0x70, 0x61, 0x6e, 0x6e, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x42, 0x61, 0x74,
	0x63, 0x68, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x53, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x73,
	0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x6a, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x4b,
	0x22, 0x46, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x64, 0x61, 0x74, 0x61, 0x62, 0x61, 0x73, 0x65, 0x3d,
	0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x69, 0x6e, 0x73, 0x74, 0x61,
	0x6e, 0x63, 0x65, 0x73, 0x2f, 0x2a, 0x2f, 0x64, 0x61, 0x74, 0x61, 0x62, 0x61, 0x73, 0x65, 0x73,
	0x2f, 0x2a, 0x7d, 0x2f, 0x73, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x3a, 0x62, 0x61, 0x74,
	0x63, 0x68, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x3a, 0x01, 0x2a, 0xda, 0x41, 0x16, 0x64, 0x61,
	0x74, 0x61, 0x62, 0x61, 0x73, 0x65, 0x2c, 0x73, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x5f, 0x63,
	0x6f, 0x75, 0x6e, 0x74, 0x12, 0x97, 0x01, 0x0a, 0x0a, 0x47, 0x65, 0x74, 0x53, 0x65, 0x73, 0x73,
	0x69, 0x6f, 0x6e, 0x12, 0x24, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x70, 0x61,
	0x6e, 0x6e, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x47, 0x65, 0x74, 0x53, 0x65, 0x73, 0x73, 0x69,
	0x6f, 0x6e, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x73, 0x70, 0x61, 0x6e, 0x6e, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x65,
	0x73, 0x73, 0x69, 0x6f, 0x6e, 0x22, 0x47, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x3a, 0x12, 0x38, 0x2f,
	0x76, 0x31, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74,
	0x73, 0x2f, 0x2a, 0x2f, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x73, 0x2f, 0x2a, 0x2f,
	0x64, 0x61, 0x74, 0x61, 0x62, 0x61, 0x73, 0x65, 0x73, 0x2f, 0x2a, 0x2f, 0x73, 0x65, 0x73, 0x73,
	0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x7d, 0xda, 0x41, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0xae,
	0x01, 0x0a, 0x0c, 0x4c, 0x69, 0x73, 0x74, 0x53, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x12,
	0x26, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x70, 0x61, 0x6e, 0x6e, 0x65, 0x72,
	0x2e, 0x76, 0x31, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x53, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x73,
	0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x27, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x73, 0x70, 0x61, 0x6e, 0x6e, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x4c, 0x69, 0x73, 0x74,
	0x53, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65,
	0x22, 0x4d, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x3c, 0x12, 0x3a, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x64,
	0x61, 0x74, 0x61, 0x62, 0x61, 0x73, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73,
	0x2f, 0x2a, 0x2f, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x73, 0x2f, 0x2a, 0x2f, 0x64,
	0x61, 0x74, 0x61, 0x62, 0x61, 0x73, 0x65, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x73, 0x65, 0x73, 0x73,
	0x69, 0x6f, 0x6e, 0x73, 0xda, 0x41, 0x08, 0x64, 0x61, 0x74, 0x61, 0x62, 0x61, 0x73, 0x65, 0x12,
	0x99, 0x01, 0x0a, 0x0d, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x53, 0x65, 0x73, 0x73, 0x69, 0x6f,
	0x6e, 0x12, 0x27, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x70, 0x61, 0x6e, 0x6e,
	0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x53, 0x65, 0x73, 0x73,
	0x69, 0x6f, 0x6e, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x16, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x45, 0x6d, 0x70,
	0x74, 0x79, 0x22, 0x47, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x3a, 0x2a, 0x38, 0x2f, 0x76, 0x31, 0x2f,
	0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a,
	0x2f, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x73, 0x2f, 0x2a, 0x2f, 0x64, 0x61, 0x74,
	0x61, 0x62, 0x61, 0x73, 0x65, 0x73, 0x2f, 0x2a, 0x2f, 0x73, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e,
	0x73, 0x2f, 0x2a, 0x7d, 0xda, 0x41, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0xa3, 0x01, 0x0a, 0x0a,
	0x45, 0x78, 0x65, 0x63, 0x75, 0x74, 0x65, 0x53, 0x71, 0x6c, 0x12, 0x24, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x73, 0x70, 0x61, 0x6e, 0x6e, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x45,
	0x78, 0x65, 0x63, 0x75, 0x74, 0x65, 0x53, 0x71, 0x6c, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x1a, 0x1c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x70, 0x61, 0x6e, 0x6e, 0x65,
	0x72, 0x2e, 0x76, 0x31, 0x2e, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x53, 0x65, 0x74, 0x22, 0x51,
	0x82, 0xd3, 0xe4, 0x93, 0x02, 0x4b, 0x22, 0x46, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x73, 0x65, 0x73,
	0x73, 0x69, 0x6f, 0x6e, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f,
	0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x73, 0x2f, 0x2a, 0x2f, 0x64, 0x61, 0x74, 0x61,
	0x62, 0x61, 0x73, 0x65, 0x73, 0x2f, 0x2a, 0x2f, 0x73, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x73,
	0x2f, 0x2a, 0x7d, 0x3a, 0x65, 0x78, 0x65, 0x63, 0x75, 0x74, 0x65, 0x53, 0x71, 0x6c, 0x3a, 0x01,
	0x2a, 0x12, 0xbe, 0x01, 0x0a, 0x13, 0x45, 0x78, 0x65, 0x63, 0x75, 0x74, 0x65, 0x53, 0x74, 0x72,
	0x65, 0x61, 0x6d, 0x69, 0x6e, 0x67, 0x53, 0x71, 0x6c, 0x12, 0x24, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x73, 0x70, 0x61, 0x6e, 0x6e, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x45, 0x78,
	0x65, 0x63, 0x75, 0x74, 0x65, 0x53, 0x71, 0x6c, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a,
	0x23, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x70, 0x61, 0x6e, 0x6e, 0x65, 0x72,
	0x2e, 0x76, 0x31, 0x2e, 0x50, 0x61, 0x72, 0x74, 0x69, 0x61, 0x6c, 0x52, 0x65, 0x73, 0x75, 0x6c,
	0x74, 0x53, 0x65, 0x74, 0x22, 0x5a, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x54, 0x22, 0x4f, 0x2f, 0x76,
	0x31, 0x2f, 0x7b, 0x73, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65,
	0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x73, 0x2f,
	0x2a, 0x2f, 0x64, 0x61, 0x74, 0x61, 0x62, 0x61, 0x73, 0x65, 0x73, 0x2f, 0x2a, 0x2f, 0x73, 0x65,
	0x73, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x7d, 0x3a, 0x65, 0x78, 0x65, 0x63, 0x75, 0x74,
	0x65, 0x53, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x69, 0x6e, 0x67, 0x53, 0x71, 0x6c, 0x3a, 0x01, 0x2a,
	0x30, 0x01, 0x12, 0xc0, 0x01, 0x0a, 0x0f, 0x45, 0x78, 0x65, 0x63, 0x75, 0x74, 0x65, 0x42, 0x61,
	0x74, 0x63, 0x68, 0x44, 0x6d, 0x6c, 0x12, 0x29, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x73, 0x70, 0x61, 0x6e, 0x6e, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x45, 0x78, 0x65, 0x63, 0x75,
	0x74, 0x65, 0x42, 0x61, 0x74, 0x63, 0x68, 0x44, 0x6d, 0x6c, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x1a, 0x2a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x70, 0x61, 0x6e, 0x6e,
	0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x45, 0x78, 0x65, 0x63, 0x75, 0x74, 0x65, 0x42, 0x61, 0x74,
	0x63, 0x68, 0x44, 0x6d, 0x6c, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x56, 0x82,
	0xd3, 0xe4, 0x93, 0x02, 0x50, 0x22, 0x4b, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x73, 0x65, 0x73, 0x73,
	0x69, 0x6f, 0x6e, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x69,
	0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x73, 0x2f, 0x2a, 0x2f, 0x64, 0x61, 0x74, 0x61, 0x62,
	0x61, 0x73, 0x65, 0x73, 0x2f, 0x2a, 0x2f, 0x73, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x2f,
	0x2a, 0x7d, 0x3a, 0x65, 0x78, 0x65, 0x63, 0x75, 0x74, 0x65, 0x42, 0x61, 0x74, 0x63, 0x68, 0x44,
	0x6d, 0x6c, 0x3a, 0x01, 0x2a, 0x12, 0x91, 0x01, 0x0a, 0x04, 0x52, 0x65, 0x61, 0x64, 0x12, 0x1e,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x70, 0x61, 0x6e, 0x6e, 0x65, 0x72, 0x2e,
	0x76, 0x31, 0x2e, 0x52, 0x65, 0x61, 0x64, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x1c,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x70, 0x61, 0x6e, 0x6e, 0x65, 0x72, 0x2e,
	0x76, 0x31, 0x2e, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x53, 0x65, 0x74, 0x22, 0x4b, 0x82, 0xd3,
	0xe4, 0x93, 0x02, 0x45, 0x22, 0x40, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x73, 0x65, 0x73, 0x73, 0x69,
	0x6f, 0x6e, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x69, 0x6e,
	0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x73, 0x2f, 0x2a, 0x2f, 0x64, 0x61, 0x74, 0x61, 0x62, 0x61,
	0x73, 0x65, 0x73, 0x2f, 0x2a, 0x2f, 0x73, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a,
	0x7d, 0x3a, 0x72, 0x65, 0x61, 0x64, 0x3a, 0x01, 0x2a, 0x12, 0xac, 0x01, 0x0a, 0x0d, 0x53, 0x74,
	0x72, 0x65, 0x61, 0x6d, 0x69, 0x6e, 0x67, 0x52, 0x65, 0x61, 0x64, 0x12, 0x1e, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x70, 0x61, 0x6e, 0x6e, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e,
	0x52, 0x65, 0x61, 0x64, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x23, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x70, 0x61, 0x6e, 0x6e, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e,
	0x50, 0x61, 0x72, 0x74, 0x69, 0x61, 0x6c, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x53, 0x65, 0x74,
	0x22, 0x54, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x4e, 0x22, 0x49, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x73,
	0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f,
	0x2a, 0x2f, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x73, 0x2f, 0x2a, 0x2f, 0x64, 0x61,
	0x74, 0x61, 0x62, 0x61, 0x73, 0x65, 0x73, 0x2f, 0x2a, 0x2f, 0x73, 0x65, 0x73, 0x73, 0x69, 0x6f,
	0x6e, 0x73, 0x2f, 0x2a, 0x7d, 0x3a, 0x73, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x69, 0x6e, 0x67, 0x52,
	0x65, 0x61, 0x64, 0x3a, 0x01, 0x2a, 0x30, 0x01, 0x12, 0xc9, 0x01, 0x0a, 0x10, 0x42, 0x65, 0x67,
	0x69, 0x6e, 0x54, 0x72, 0x61, 0x6e, 0x73, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x2a, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x70, 0x61, 0x6e, 0x6e, 0x65, 0x72, 0x2e, 0x76,
	0x31, 0x2e, 0x42, 0x65, 0x67, 0x69, 0x6e, 0x54, 0x72, 0x61, 0x6e, 0x73, 0x61, 0x63, 0x74, 0x69,
	0x6f, 0x6e, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x1e, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x73, 0x70, 0x61, 0x6e, 0x6e, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x54, 0x72,
	0x61, 0x6e, 0x73, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0x69, 0x82, 0xd3, 0xe4, 0x93, 0x02,
	0x51, 0x22, 0x4c, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x73, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x3d,
	0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x69, 0x6e, 0x73, 0x74, 0x61,
	0x6e, 0x63, 0x65, 0x73, 0x2f, 0x2a, 0x2f, 0x64, 0x61, 0x74, 0x61, 0x62, 0x61, 0x73, 0x65, 0x73,
	0x2f, 0x2a, 0x2f, 0x73, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x7d, 0x3a, 0x62,
	0x65, 0x67, 0x69, 0x6e, 0x54, 0x72, 0x61, 0x6e, 0x73, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x3a,
	0x01, 0x2a, 0xda, 0x41, 0x0f, 0x73, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x2c, 0x6f, 0x70, 0x74,
	0x69, 0x6f, 0x6e, 0x73, 0x12, 0xeb, 0x01, 0x0a, 0x06, 0x43, 0x6f, 0x6d, 0x6d, 0x69, 0x74, 0x12,
	0x20, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x70, 0x61, 0x6e, 0x6e, 0x65, 0x72,
	0x2e, 0x76, 0x31, 0x2e, 0x43, 0x6f, 0x6d, 0x6d, 0x69, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x1a, 0x21, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x70, 0x61, 0x6e, 0x6e,
	0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x6f, 0x6d, 0x6d, 0x69, 0x74, 0x52, 0x65, 0x73, 0x70,
	0x6f, 0x6e, 0x73, 0x65, 0x22, 0x9b, 0x01, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x47, 0x22, 0x42, 0x2f,
	0x76, 0x31, 0x2f, 0x7b, 0x73, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x3d, 0x70, 0x72, 0x6f, 0x6a,
	0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x73,
	0x2f, 0x2a, 0x2f, 0x64, 0x61, 0x74, 0x61, 0x62, 0x61, 0x73, 0x65, 0x73, 0x2f, 0x2a, 0x2f, 0x73,
	0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x7d, 0x3a, 0x63, 0x6f, 0x6d, 0x6d, 0x69,
	0x74, 0x3a, 0x01, 0x2a, 0xda, 0x41, 0x20, 0x73, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x2c, 0x74,
	0x72, 0x61, 0x6e, 0x73, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x69, 0x64, 0x2c, 0x6d, 0x75,
	0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0xda, 0x41, 0x28, 0x73, 0x65, 0x73, 0x73, 0x69, 0x6f,
	0x6e, 0x2c, 0x73, 0x69, 0x6e, 0x67, 0x6c, 0x65, 0x5f, 0x75, 0x73, 0x65, 0x5f, 0x74, 0x72, 0x61,
	0x6e, 0x73, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x2c, 0x6d, 0x75, 0x74, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x73, 0x12, 0xb0, 0x01, 0x0a, 0x08, 0x52, 0x6f, 0x6c, 0x6c, 0x62, 0x61, 0x63, 0x6b, 0x12,
	0x22, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x70, 0x61, 0x6e, 0x6e, 0x65, 0x72,
	0x2e, 0x76, 0x31, 0x2e, 0x52, 0x6f, 0x6c, 0x6c, 0x62, 0x61, 0x63, 0x6b, 0x52, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x1a, 0x16, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x45, 0x6d, 0x70, 0x74, 0x79, 0x22, 0x68, 0x82, 0xd3, 0xe4,
	0x93, 0x02, 0x49, 0x22, 0x44, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x73, 0x65, 0x73, 0x73, 0x69, 0x6f,
	0x6e, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x69, 0x6e, 0x73,
	0x74, 0x61, 0x6e, 0x63, 0x65, 0x73, 0x2f, 0x2a, 0x2f, 0x64, 0x61, 0x74, 0x61, 0x62, 0x61, 0x73,
	0x65, 0x73, 0x2f, 0x2a, 0x2f, 0x73, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x7d,
	0x3a, 0x72, 0x6f, 0x6c, 0x6c, 0x62, 0x61, 0x63, 0x6b, 0x3a, 0x01, 0x2a, 0xda, 0x41, 0x16, 0x73,
	0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x2c, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x61, 0x63, 0x74, 0x69,
	0x6f, 0x6e, 0x5f, 0x69, 0x64, 0x12, 0xb7, 0x01, 0x0a, 0x0e, 0x50, 0x61, 0x72, 0x74, 0x69, 0x74,
	0x69, 0x6f, 0x6e, 0x51, 0x75, 0x65, 0x72, 0x79, 0x12, 0x28, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x73, 0x70, 0x61, 0x6e, 0x6e, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x50, 0x61, 0x72,
	0x74, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x51, 0x75, 0x65, 0x72, 0x79, 0x52, 0x65, 0x71, 0x75, 0x65,
	0x73, 0x74, 0x1a, 0x24, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x70, 0x61, 0x6e,
	0x6e, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x50, 0x61, 0x72, 0x74, 0x69, 0x74, 0x69, 0x6f, 0x6e,
	0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x55, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x4f,
	0x22, 0x4a, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x73, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x3d, 0x70,
	0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e,
	0x63, 0x65, 0x73, 0x2f, 0x2a, 0x2f, 0x64, 0x61, 0x74, 0x61, 0x62, 0x61, 0x73, 0x65, 0x73, 0x2f,
	0x2a, 0x2f, 0x73, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x7d, 0x3a, 0x70, 0x61,
	0x72, 0x74, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x51, 0x75, 0x65, 0x72, 0x79, 0x3a, 0x01, 0x2a, 0x12,
	0xb4, 0x01, 0x0a, 0x0d, 0x50, 0x61, 0x72, 0x74, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x61,
	0x64, 0x12, 0x27, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x70, 0x61, 0x6e, 0x6e,
	0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x50, 0x61, 0x72, 0x74, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x52,
	0x65, 0x61, 0x64, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x24, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x73, 0x70, 0x61, 0x6e, 0x6e, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x50,
	0x61, 0x72, 0x74, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65,
	0x22, 0x54, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x4e, 0x22, 0x49, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x73,
	0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f,
	0x2a, 0x2f, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x73, 0x2f, 0x2a, 0x2f, 0x64, 0x61,
	0x74, 0x61, 0x62, 0x61, 0x73, 0x65, 0x73, 0x2f, 0x2a, 0x2f, 0x73, 0x65, 0x73, 0x73, 0x69, 0x6f,
	0x6e, 0x73, 0x2f, 0x2a, 0x7d, 0x3a, 0x70, 0x61, 0x72, 0x74, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x52,
	0x65, 0x61, 0x64, 0x3a, 0x01, 0x2a, 0x1a, 0x77, 0xca, 0x41, 0x16, 0x73, 0x70, 0x61, 0x6e, 0x6e,
	0x65, 0x72, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f,
	0x6d, 0xd2, 0x41, 0x5b, 0x68, 0x74, 0x74, 0x70, 0x73, 0x3a, 0x2f, 0x2f, 0x77, 0x77, 0x77, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x61,
	0x75, 0x74, 0x68, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2d, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f,
	0x72, 0x6d, 0x2c, 0x68, 0x74, 0x74, 0x70, 0x73, 0x3a, 0x2f, 0x2f, 0x77, 0x77, 0x77, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x61, 0x75,
	0x74, 0x68, 0x2f, 0x73, 0x70, 0x61, 0x6e, 0x6e, 0x65, 0x72, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x42,
	0x94, 0x02, 0x0a, 0x15, 0x63, 0x6f, 0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73,
	0x70, 0x61, 0x6e, 0x6e, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x42, 0x0c, 0x53, 0x70, 0x61, 0x6e, 0x6e,
	0x65, 0x72, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x50, 0x01, 0x5a, 0x38, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x67, 0x6f, 0x6c, 0x61, 0x6e, 0x67, 0x2e, 0x6f, 0x72, 0x67, 0x2f, 0x67, 0x65, 0x6e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x2f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73,
	0x2f, 0x73, 0x70, 0x61, 0x6e, 0x6e, 0x65, 0x72, 0x2f, 0x76, 0x31, 0x3b, 0x73, 0x70, 0x61, 0x6e,
	0x6e, 0x65, 0x72, 0xaa, 0x02, 0x17, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x43, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x53, 0x70, 0x61, 0x6e, 0x6e, 0x65, 0x72, 0x2e, 0x56, 0x31, 0xca, 0x02, 0x17,
	0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x5c, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x5c, 0x53, 0x70, 0x61,
	0x6e, 0x6e, 0x65, 0x72, 0x5c, 0x56, 0x31, 0xea, 0x02, 0x1a, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x3a, 0x3a, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x3a, 0x3a, 0x53, 0x70, 0x61, 0x6e, 0x6e, 0x65, 0x72,
	0x3a, 0x3a, 0x56, 0x31, 0xea, 0x41, 0x5f, 0x0a, 0x1f, 0x73, 0x70, 0x61, 0x6e, 0x6e, 0x65, 0x72,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f,
	0x44, 0x61, 0x74, 0x61, 0x62, 0x61, 0x73, 0x65, 0x12, 0x3c, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63,
	0x74, 0x73, 0x2f, 0x7b, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x7d, 0x2f, 0x69, 0x6e, 0x73,
	0x74, 0x61, 0x6e, 0x63, 0x65, 0x73, 0x2f, 0x7b, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65,
	0x7d, 0x2f, 0x64, 0x61, 0x74, 0x61, 0x62, 0x61, 0x73, 0x65, 0x73, 0x2f, 0x7b, 0x64, 0x61, 0x74,
	0x61, 0x62, 0x61, 0x73, 0x65, 0x7d, 0x62, 0x06, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_google_spanner_v1_spanner_proto_rawDescOnce sync.Once
	file_google_spanner_v1_spanner_proto_rawDescData = file_google_spanner_v1_spanner_proto_rawDesc
)

func file_google_spanner_v1_spanner_proto_rawDescGZIP() []byte {
	file_google_spanner_v1_spanner_proto_rawDescOnce.Do(func() {
		file_google_spanner_v1_spanner_proto_rawDescData = protoimpl.X.CompressGZIP(file_google_spanner_v1_spanner_proto_rawDescData)
	})
	return file_google_spanner_v1_spanner_proto_rawDescData
}

var file_google_spanner_v1_spanner_proto_enumTypes = make([]protoimpl.EnumInfo, 1)
var file_google_spanner_v1_spanner_proto_msgTypes = make([]protoimpl.MessageInfo, 27)
var file_google_spanner_v1_spanner_proto_goTypes = []interface{}{
	(ExecuteSqlRequest_QueryMode)(0),         // 0: google.spanner.v1.ExecuteSqlRequest.QueryMode
	(*CreateSessionRequest)(nil),             // 1: google.spanner.v1.CreateSessionRequest
	(*BatchCreateSessionsRequest)(nil),       // 2: google.spanner.v1.BatchCreateSessionsRequest
	(*BatchCreateSessionsResponse)(nil),      // 3: google.spanner.v1.BatchCreateSessionsResponse
	(*Session)(nil),                          // 4: google.spanner.v1.Session
	(*GetSessionRequest)(nil),                // 5: google.spanner.v1.GetSessionRequest
	(*ListSessionsRequest)(nil),              // 6: google.spanner.v1.ListSessionsRequest
	(*ListSessionsResponse)(nil),             // 7: google.spanner.v1.ListSessionsResponse
	(*DeleteSessionRequest)(nil),             // 8: google.spanner.v1.DeleteSessionRequest
	(*ExecuteSqlRequest)(nil),                // 9: google.spanner.v1.ExecuteSqlRequest
	(*ExecuteBatchDmlRequest)(nil),           // 10: google.spanner.v1.ExecuteBatchDmlRequest
	(*ExecuteBatchDmlResponse)(nil),          // 11: google.spanner.v1.ExecuteBatchDmlResponse
	(*PartitionOptions)(nil),                 // 12: google.spanner.v1.PartitionOptions
	(*PartitionQueryRequest)(nil),            // 13: google.spanner.v1.PartitionQueryRequest
	(*PartitionReadRequest)(nil),             // 14: google.spanner.v1.PartitionReadRequest
	(*Partition)(nil),                        // 15: google.spanner.v1.Partition
	(*PartitionResponse)(nil),                // 16: google.spanner.v1.PartitionResponse
	(*ReadRequest)(nil),                      // 17: google.spanner.v1.ReadRequest
	(*BeginTransactionRequest)(nil),          // 18: google.spanner.v1.BeginTransactionRequest
	(*CommitRequest)(nil),                    // 19: google.spanner.v1.CommitRequest
	(*CommitResponse)(nil),                   // 20: google.spanner.v1.CommitResponse
	(*RollbackRequest)(nil),                  // 21: google.spanner.v1.RollbackRequest
	nil,                                      // 22: google.spanner.v1.Session.LabelsEntry
	(*ExecuteSqlRequest_QueryOptions)(nil),   // 23: google.spanner.v1.ExecuteSqlRequest.QueryOptions
	nil,                                      // 24: google.spanner.v1.ExecuteSqlRequest.ParamTypesEntry
	(*ExecuteBatchDmlRequest_Statement)(nil), // 25: google.spanner.v1.ExecuteBatchDmlRequest.Statement
	nil,                                      // 26: google.spanner.v1.ExecuteBatchDmlRequest.Statement.ParamTypesEntry
	nil,                                      // 27: google.spanner.v1.PartitionQueryRequest.ParamTypesEntry
	(*timestamppb.Timestamp)(nil),            // 28: google.protobuf.Timestamp
	(*TransactionSelector)(nil),              // 29: google.spanner.v1.TransactionSelector
	(*structpb.Struct)(nil),                  // 30: google.protobuf.Struct
	(*ResultSet)(nil),                        // 31: google.spanner.v1.ResultSet
	(*status.Status)(nil),                    // 32: google.rpc.Status
	(*KeySet)(nil),                           // 33: google.spanner.v1.KeySet
	(*Transaction)(nil),                      // 34: google.spanner.v1.Transaction
	(*TransactionOptions)(nil),               // 35: google.spanner.v1.TransactionOptions
	(*Mutation)(nil),                         // 36: google.spanner.v1.Mutation
	(*Type)(nil),                             // 37: google.spanner.v1.Type
	(*emptypb.Empty)(nil),                    // 38: google.protobuf.Empty
	(*PartialResultSet)(nil),                 // 39: google.spanner.v1.PartialResultSet
}
var file_google_spanner_v1_spanner_proto_depIdxs = []int32{
	4,  // 0: google.spanner.v1.CreateSessionRequest.session:type_name -> google.spanner.v1.Session
	4,  // 1: google.spanner.v1.BatchCreateSessionsRequest.session_template:type_name -> google.spanner.v1.Session
	4,  // 2: google.spanner.v1.BatchCreateSessionsResponse.session:type_name -> google.spanner.v1.Session
	22, // 3: google.spanner.v1.Session.labels:type_name -> google.spanner.v1.Session.LabelsEntry
	28, // 4: google.spanner.v1.Session.create_time:type_name -> google.protobuf.Timestamp
	28, // 5: google.spanner.v1.Session.approximate_last_use_time:type_name -> google.protobuf.Timestamp
	4,  // 6: google.spanner.v1.ListSessionsResponse.sessions:type_name -> google.spanner.v1.Session
	29, // 7: google.spanner.v1.ExecuteSqlRequest.transaction:type_name -> google.spanner.v1.TransactionSelector
	30, // 8: google.spanner.v1.ExecuteSqlRequest.params:type_name -> google.protobuf.Struct
	24, // 9: google.spanner.v1.ExecuteSqlRequest.param_types:type_name -> google.spanner.v1.ExecuteSqlRequest.ParamTypesEntry
	0,  // 10: google.spanner.v1.ExecuteSqlRequest.query_mode:type_name -> google.spanner.v1.ExecuteSqlRequest.QueryMode
	23, // 11: google.spanner.v1.ExecuteSqlRequest.query_options:type_name -> google.spanner.v1.ExecuteSqlRequest.QueryOptions
	29, // 12: google.spanner.v1.ExecuteBatchDmlRequest.transaction:type_name -> google.spanner.v1.TransactionSelector
	25, // 13: google.spanner.v1.ExecuteBatchDmlRequest.statements:type_name -> google.spanner.v1.ExecuteBatchDmlRequest.Statement
	31, // 14: google.spanner.v1.ExecuteBatchDmlResponse.result_sets:type_name -> google.spanner.v1.ResultSet
	32, // 15: google.spanner.v1.ExecuteBatchDmlResponse.status:type_name -> google.rpc.Status
	29, // 16: google.spanner.v1.PartitionQueryRequest.transaction:type_name -> google.spanner.v1.TransactionSelector
	30, // 17: google.spanner.v1.PartitionQueryRequest.params:type_name -> google.protobuf.Struct
	27, // 18: google.spanner.v1.PartitionQueryRequest.param_types:type_name -> google.spanner.v1.PartitionQueryRequest.ParamTypesEntry
	12, // 19: google.spanner.v1.PartitionQueryRequest.partition_options:type_name -> google.spanner.v1.PartitionOptions
	29, // 20: google.spanner.v1.PartitionReadRequest.transaction:type_name -> google.spanner.v1.TransactionSelector
	33, // 21: google.spanner.v1.PartitionReadRequest.key_set:type_name -> google.spanner.v1.KeySet
	12, // 22: google.spanner.v1.PartitionReadRequest.partition_options:type_name -> google.spanner.v1.PartitionOptions
	15, // 23: google.spanner.v1.PartitionResponse.partitions:type_name -> google.spanner.v1.Partition
	34, // 24: google.spanner.v1.PartitionResponse.transaction:type_name -> google.spanner.v1.Transaction
	29, // 25: google.spanner.v1.ReadRequest.transaction:type_name -> google.spanner.v1.TransactionSelector
	33, // 26: google.spanner.v1.ReadRequest.key_set:type_name -> google.spanner.v1.KeySet
	35, // 27: google.spanner.v1.BeginTransactionRequest.options:type_name -> google.spanner.v1.TransactionOptions
	35, // 28: google.spanner.v1.CommitRequest.single_use_transaction:type_name -> google.spanner.v1.TransactionOptions
	36, // 29: google.spanner.v1.CommitRequest.mutations:type_name -> google.spanner.v1.Mutation
	28, // 30: google.spanner.v1.CommitResponse.commit_timestamp:type_name -> google.protobuf.Timestamp
	37, // 31: google.spanner.v1.ExecuteSqlRequest.ParamTypesEntry.value:type_name -> google.spanner.v1.Type
	30, // 32: google.spanner.v1.ExecuteBatchDmlRequest.Statement.params:type_name -> google.protobuf.Struct
	26, // 33: google.spanner.v1.ExecuteBatchDmlRequest.Statement.param_types:type_name -> google.spanner.v1.ExecuteBatchDmlRequest.Statement.ParamTypesEntry
	37, // 34: google.spanner.v1.ExecuteBatchDmlRequest.Statement.ParamTypesEntry.value:type_name -> google.spanner.v1.Type
	37, // 35: google.spanner.v1.PartitionQueryRequest.ParamTypesEntry.value:type_name -> google.spanner.v1.Type
	1,  // 36: google.spanner.v1.Spanner.CreateSession:input_type -> google.spanner.v1.CreateSessionRequest
	2,  // 37: google.spanner.v1.Spanner.BatchCreateSessions:input_type -> google.spanner.v1.BatchCreateSessionsRequest
	5,  // 38: google.spanner.v1.Spanner.GetSession:input_type -> google.spanner.v1.GetSessionRequest
	6,  // 39: google.spanner.v1.Spanner.ListSessions:input_type -> google.spanner.v1.ListSessionsRequest
	8,  // 40: google.spanner.v1.Spanner.DeleteSession:input_type -> google.spanner.v1.DeleteSessionRequest
	9,  // 41: google.spanner.v1.Spanner.ExecuteSql:input_type -> google.spanner.v1.ExecuteSqlRequest
	9,  // 42: google.spanner.v1.Spanner.ExecuteStreamingSql:input_type -> google.spanner.v1.ExecuteSqlRequest
	10, // 43: google.spanner.v1.Spanner.ExecuteBatchDml:input_type -> google.spanner.v1.ExecuteBatchDmlRequest
	17, // 44: google.spanner.v1.Spanner.Read:input_type -> google.spanner.v1.ReadRequest
	17, // 45: google.spanner.v1.Spanner.StreamingRead:input_type -> google.spanner.v1.ReadRequest
	18, // 46: google.spanner.v1.Spanner.BeginTransaction:input_type -> google.spanner.v1.BeginTransactionRequest
	19, // 47: google.spanner.v1.Spanner.Commit:input_type -> google.spanner.v1.CommitRequest
	21, // 48: google.spanner.v1.Spanner.Rollback:input_type -> google.spanner.v1.RollbackRequest
	13, // 49: google.spanner.v1.Spanner.PartitionQuery:input_type -> google.spanner.v1.PartitionQueryRequest
	14, // 50: google.spanner.v1.Spanner.PartitionRead:input_type -> google.spanner.v1.PartitionReadRequest
	4,  // 51: google.spanner.v1.Spanner.CreateSession:output_type -> google.spanner.v1.Session
	3,  // 52: google.spanner.v1.Spanner.BatchCreateSessions:output_type -> google.spanner.v1.BatchCreateSessionsResponse
	4,  // 53: google.spanner.v1.Spanner.GetSession:output_type -> google.spanner.v1.Session
	7,  // 54: google.spanner.v1.Spanner.ListSessions:output_type -> google.spanner.v1.ListSessionsResponse
	38, // 55: google.spanner.v1.Spanner.DeleteSession:output_type -> google.protobuf.Empty
	31, // 56: google.spanner.v1.Spanner.ExecuteSql:output_type -> google.spanner.v1.ResultSet
	39, // 57: google.spanner.v1.Spanner.ExecuteStreamingSql:output_type -> google.spanner.v1.PartialResultSet
	11, // 58: google.spanner.v1.Spanner.ExecuteBatchDml:output_type -> google.spanner.v1.ExecuteBatchDmlResponse
	31, // 59: google.spanner.v1.Spanner.Read:output_type -> google.spanner.v1.ResultSet
	39, // 60: google.spanner.v1.Spanner.StreamingRead:output_type -> google.spanner.v1.PartialResultSet
	34, // 61: google.spanner.v1.Spanner.BeginTransaction:output_type -> google.spanner.v1.Transaction
	20, // 62: google.spanner.v1.Spanner.Commit:output_type -> google.spanner.v1.CommitResponse
	38, // 63: google.spanner.v1.Spanner.Rollback:output_type -> google.protobuf.Empty
	16, // 64: google.spanner.v1.Spanner.PartitionQuery:output_type -> google.spanner.v1.PartitionResponse
	16, // 65: google.spanner.v1.Spanner.PartitionRead:output_type -> google.spanner.v1.PartitionResponse
	51, // [51:66] is the sub-list for method output_type
	36, // [36:51] is the sub-list for method input_type
	36, // [36:36] is the sub-list for extension type_name
	36, // [36:36] is the sub-list for extension extendee
	0,  // [0:36] is the sub-list for field type_name
}

func init() { file_google_spanner_v1_spanner_proto_init() }
func file_google_spanner_v1_spanner_proto_init() {
	if File_google_spanner_v1_spanner_proto != nil {
		return
	}
	file_google_spanner_v1_keys_proto_init()
	file_google_spanner_v1_mutation_proto_init()
	file_google_spanner_v1_result_set_proto_init()
	file_google_spanner_v1_transaction_proto_init()
	file_google_spanner_v1_type_proto_init()
	if !protoimpl.UnsafeEnabled {
		file_google_spanner_v1_spanner_proto_msgTypes[0].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CreateSessionRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_spanner_v1_spanner_proto_msgTypes[1].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*BatchCreateSessionsRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_spanner_v1_spanner_proto_msgTypes[2].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*BatchCreateSessionsResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_spanner_v1_spanner_proto_msgTypes[3].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Session); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_spanner_v1_spanner_proto_msgTypes[4].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GetSessionRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_spanner_v1_spanner_proto_msgTypes[5].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListSessionsRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_spanner_v1_spanner_proto_msgTypes[6].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListSessionsResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_spanner_v1_spanner_proto_msgTypes[7].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DeleteSessionRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_spanner_v1_spanner_proto_msgTypes[8].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ExecuteSqlRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_spanner_v1_spanner_proto_msgTypes[9].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ExecuteBatchDmlRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_spanner_v1_spanner_proto_msgTypes[10].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ExecuteBatchDmlResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_spanner_v1_spanner_proto_msgTypes[11].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*PartitionOptions); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_spanner_v1_spanner_proto_msgTypes[12].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*PartitionQueryRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_spanner_v1_spanner_proto_msgTypes[13].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*PartitionReadRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_spanner_v1_spanner_proto_msgTypes[14].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Partition); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_spanner_v1_spanner_proto_msgTypes[15].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*PartitionResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_spanner_v1_spanner_proto_msgTypes[16].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ReadRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_spanner_v1_spanner_proto_msgTypes[17].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*BeginTransactionRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_spanner_v1_spanner_proto_msgTypes[18].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CommitRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_spanner_v1_spanner_proto_msgTypes[19].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CommitResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_spanner_v1_spanner_proto_msgTypes[20].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*RollbackRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_spanner_v1_spanner_proto_msgTypes[22].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ExecuteSqlRequest_QueryOptions); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_spanner_v1_spanner_proto_msgTypes[24].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ExecuteBatchDmlRequest_Statement); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
	}
	file_google_spanner_v1_spanner_proto_msgTypes[18].OneofWrappers = []interface{}{
		(*CommitRequest_TransactionId)(nil),
		(*CommitRequest_SingleUseTransaction)(nil),
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_google_spanner_v1_spanner_proto_rawDesc,
			NumEnums:      1,
			NumMessages:   27,
			NumExtensions: 0,
			NumServices:   1,
		},
		GoTypes:           file_google_spanner_v1_spanner_proto_goTypes,
		DependencyIndexes: file_google_spanner_v1_spanner_proto_depIdxs,
		EnumInfos:         file_google_spanner_v1_spanner_proto_enumTypes,
		MessageInfos:      file_google_spanner_v1_spanner_proto_msgTypes,
	}.Build()
	File_google_spanner_v1_spanner_proto = out.File
	file_google_spanner_v1_spanner_proto_rawDesc = nil
	file_google_spanner_v1_spanner_proto_goTypes = nil
	file_google_spanner_v1_spanner_proto_depIdxs = nil
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConnInterface

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion6

// SpannerClient is the client API for Spanner service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
type SpannerClient interface {
	// Creates a new session. A session can be used to perform
	// transactions that read and/or modify data in a Cloud Spanner database.
	// Sessions are meant to be reused for many consecutive
	// transactions.
	//
	// Sessions can only execute one transaction at a time. To execute
	// multiple concurrent read-write/write-only transactions, create
	// multiple sessions. Note that standalone reads and queries use a
	// transaction internally, and count toward the one transaction
	// limit.
	//
	// Active sessions use additional server resources, so it is a good idea to
	// delete idle and unneeded sessions.
	// Aside from explicit deletes, Cloud Spanner may delete sessions for which no
	// operations are sent for more than an hour. If a session is deleted,
	// requests to it return `NOT_FOUND`.
	//
	// Idle sessions can be kept alive by sending a trivial SQL query
	// periodically, e.g., `"SELECT 1"`.
	CreateSession(ctx context.Context, in *CreateSessionRequest, opts ...grpc.CallOption) (*Session, error)
	// Creates multiple new sessions.
	//
	// This API can be used to initialize a session cache on the clients.
	// See https://goo.gl/TgSFN2 for best practices on session cache management.
	BatchCreateSessions(ctx context.Context, in *BatchCreateSessionsRequest, opts ...grpc.CallOption) (*BatchCreateSessionsResponse, error)
	// Gets a session. Returns `NOT_FOUND` if the session does not exist.
	// This is mainly useful for determining whether a session is still
	// alive.
	GetSession(ctx context.Context, in *GetSessionRequest, opts ...grpc.CallOption) (*Session, error)
	// Lists all sessions in a given database.
	ListSessions(ctx context.Context, in *ListSessionsRequest, opts ...grpc.CallOption) (*ListSessionsResponse, error)
	// Ends a session, releasing server resources associated with it. This will
	// asynchronously trigger cancellation of any operations that are running with
	// this session.
	DeleteSession(ctx context.Context, in *DeleteSessionRequest, opts ...grpc.CallOption) (*emptypb.Empty, error)
	// Executes an SQL statement, returning all results in a single reply. This
	// method cannot be used to return a result set larger than 10 MiB;
	// if the query yields more data than that, the query fails with
	// a `FAILED_PRECONDITION` error.
	//
	// Operations inside read-write transactions might return `ABORTED`. If
	// this occurs, the application should restart the transaction from
	// the beginning. See [Transaction][google.spanner.v1.Transaction] for more details.
	//
	// Larger result sets can be fetched in streaming fashion by calling
	// [ExecuteStreamingSql][google.spanner.v1.Spanner.ExecuteStreamingSql] instead.
	ExecuteSql(ctx context.Context, in *ExecuteSqlRequest, opts ...grpc.CallOption) (*ResultSet, error)
	// Like [ExecuteSql][google.spanner.v1.Spanner.ExecuteSql], except returns the result
	// set as a stream. Unlike [ExecuteSql][google.spanner.v1.Spanner.ExecuteSql], there
	// is no limit on the size of the returned result set. However, no
	// individual row in the result set can exceed 100 MiB, and no
	// column value can exceed 10 MiB.
	ExecuteStreamingSql(ctx context.Context, in *ExecuteSqlRequest, opts ...grpc.CallOption) (Spanner_ExecuteStreamingSqlClient, error)
	// Executes a batch of SQL DML statements. This method allows many statements
	// to be run with lower latency than submitting them sequentially with
	// [ExecuteSql][google.spanner.v1.Spanner.ExecuteSql].
	//
	// Statements are executed in sequential order. A request can succeed even if
	// a statement fails. The [ExecuteBatchDmlResponse.status][google.spanner.v1.ExecuteBatchDmlResponse.status] field in the
	// response provides information about the statement that failed. Clients must
	// inspect this field to determine whether an error occurred.
	//
	// Execution stops after the first failed statement; the remaining statements
	// are not executed.
	ExecuteBatchDml(ctx context.Context, in *ExecuteBatchDmlRequest, opts ...grpc.CallOption) (*ExecuteBatchDmlResponse, error)
	// Reads rows from the database using key lookups and scans, as a
	// simple key/value style alternative to
	// [ExecuteSql][google.spanner.v1.Spanner.ExecuteSql].  This method cannot be used to
	// return a result set larger than 10 MiB; if the read matches more
	// data than that, the read fails with a `FAILED_PRECONDITION`
	// error.
	//
	// Reads inside read-write transactions might return `ABORTED`. If
	// this occurs, the application should restart the transaction from
	// the beginning. See [Transaction][google.spanner.v1.Transaction] for more details.
	//
	// Larger result sets can be yielded in streaming fashion by calling
	// [StreamingRead][google.spanner.v1.Spanner.StreamingRead] instead.
	Read(ctx context.Context, in *ReadRequest, opts ...grpc.CallOption) (*ResultSet, error)
	// Like [Read][google.spanner.v1.Spanner.Read], except returns the result set as a
	// stream. Unlike [Read][google.spanner.v1.Spanner.Read], there is no limit on the
	// size of the returned result set. However, no individual row in
	// the result set can exceed 100 MiB, and no column value can exceed
	// 10 MiB.
	StreamingRead(ctx context.Context, in *ReadRequest, opts ...grpc.CallOption) (Spanner_StreamingReadClient, error)
	// Begins a new transaction. This step can often be skipped:
	// [Read][google.spanner.v1.Spanner.Read], [ExecuteSql][google.spanner.v1.Spanner.ExecuteSql] and
	// [Commit][google.spanner.v1.Spanner.Commit] can begin a new transaction as a
	// side-effect.
	BeginTransaction(ctx context.Context, in *BeginTransactionRequest, opts ...grpc.CallOption) (*Transaction, error)
	// Commits a transaction. The request includes the mutations to be
	// applied to rows in the database.
	//
	// `Commit` might return an `ABORTED` error. This can occur at any time;
	// commonly, the cause is conflicts with concurrent
	// transactions. However, it can also happen for a variety of other
	// reasons. If `Commit` returns `ABORTED`, the caller should re-attempt
	// the transaction from the beginning, re-using the same session.
	Commit(ctx context.Context, in *CommitRequest, opts ...grpc.CallOption) (*CommitResponse, error)
	// Rolls back a transaction, releasing any locks it holds. It is a good
	// idea to call this for any transaction that includes one or more
	// [Read][google.spanner.v1.Spanner.Read] or [ExecuteSql][google.spanner.v1.Spanner.ExecuteSql] requests and
	// ultimately decides not to commit.
	//
	// `Rollback` returns `OK` if it successfully aborts the transaction, the
	// transaction was already aborted, or the transaction is not
	// found. `Rollback` never returns `ABORTED`.
	Rollback(ctx context.Context, in *RollbackRequest, opts ...grpc.CallOption) (*emptypb.Empty, error)
	// Creates a set of partition tokens that can be used to execute a query
	// operation in parallel.  Each of the returned partition tokens can be used
	// by [ExecuteStreamingSql][google.spanner.v1.Spanner.ExecuteStreamingSql] to specify a subset
	// of the query result to read.  The same session and read-only transaction
	// must be used by the PartitionQueryRequest used to create the
	// partition tokens and the ExecuteSqlRequests that use the partition tokens.
	//
	// Partition tokens become invalid when the session used to create them
	// is deleted, is idle for too long, begins a new transaction, or becomes too
	// old.  When any of these happen, it is not possible to resume the query, and
	// the whole operation must be restarted from the beginning.
	PartitionQuery(ctx context.Context, in *PartitionQueryRequest, opts ...grpc.CallOption) (*PartitionResponse, error)
	// Creates a set of partition tokens that can be used to execute a read
	// operation in parallel.  Each of the returned partition tokens can be used
	// by [StreamingRead][google.spanner.v1.Spanner.StreamingRead] to specify a subset of the read
	// result to read.  The same session and read-only transaction must be used by
	// the PartitionReadRequest used to create the partition tokens and the
	// ReadRequests that use the partition tokens.  There are no ordering
	// guarantees on rows returned among the returned partition tokens, or even
	// within each individual StreamingRead call issued with a partition_token.
	//
	// Partition tokens become invalid when the session used to create them
	// is deleted, is idle for too long, begins a new transaction, or becomes too
	// old.  When any of these happen, it is not possible to resume the read, and
	// the whole operation must be restarted from the beginning.
	PartitionRead(ctx context.Context, in *PartitionReadRequest, opts ...grpc.CallOption) (*PartitionResponse, error)
}

type spannerClient struct {
	cc grpc.ClientConnInterface
}

func NewSpannerClient(cc grpc.ClientConnInterface) SpannerClient {
	return &spannerClient{cc}
}

func (c *spannerClient) CreateSession(ctx context.Context, in *CreateSessionRequest, opts ...grpc.CallOption) (*Session, error) {
	out := new(Session)
	err := c.cc.Invoke(ctx, "/google.spanner.v1.Spanner/CreateSession", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *spannerClient) BatchCreateSessions(ctx context.Context, in *BatchCreateSessionsRequest, opts ...grpc.CallOption) (*BatchCreateSessionsResponse, error) {
	out := new(BatchCreateSessionsResponse)
	err := c.cc.Invoke(ctx, "/google.spanner.v1.Spanner/BatchCreateSessions", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *spannerClient) GetSession(ctx context.Context, in *GetSessionRequest, opts ...grpc.CallOption) (*Session, error) {
	out := new(Session)
	err := c.cc.Invoke(ctx, "/google.spanner.v1.Spanner/GetSession", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *spannerClient) ListSessions(ctx context.Context, in *ListSessionsRequest, opts ...grpc.CallOption) (*ListSessionsResponse, error) {
	out := new(ListSessionsResponse)
	err := c.cc.Invoke(ctx, "/google.spanner.v1.Spanner/ListSessions", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *spannerClient) DeleteSession(ctx context.Context, in *DeleteSessionRequest, opts ...grpc.CallOption) (*emptypb.Empty, error) {
	out := new(emptypb.Empty)
	err := c.cc.Invoke(ctx, "/google.spanner.v1.Spanner/DeleteSession", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *spannerClient) ExecuteSql(ctx context.Context, in *ExecuteSqlRequest, opts ...grpc.CallOption) (*ResultSet, error) {
	out := new(ResultSet)
	err := c.cc.Invoke(ctx, "/google.spanner.v1.Spanner/ExecuteSql", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *spannerClient) ExecuteStreamingSql(ctx context.Context, in *ExecuteSqlRequest, opts ...grpc.CallOption) (Spanner_ExecuteStreamingSqlClient, error) {
	stream, err := c.cc.NewStream(ctx, &_Spanner_serviceDesc.Streams[0], "/google.spanner.v1.Spanner/ExecuteStreamingSql", opts...)
	if err != nil {
		return nil, err
	}
	x := &spannerExecuteStreamingSqlClient{stream}
	if err := x.ClientStream.SendMsg(in); err != nil {
		return nil, err
	}
	if err := x.ClientStream.CloseSend(); err != nil {
		return nil, err
	}
	return x, nil
}

type Spanner_ExecuteStreamingSqlClient interface {
	Recv() (*PartialResultSet, error)
	grpc.ClientStream
}

type spannerExecuteStreamingSqlClient struct {
	grpc.ClientStream
}

func (x *spannerExecuteStreamingSqlClient) Recv() (*PartialResultSet, error) {
	m := new(PartialResultSet)
	if err := x.ClientStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

func (c *spannerClient) ExecuteBatchDml(ctx context.Context, in *ExecuteBatchDmlRequest, opts ...grpc.CallOption) (*ExecuteBatchDmlResponse, error) {
	out := new(ExecuteBatchDmlResponse)
	err := c.cc.Invoke(ctx, "/google.spanner.v1.Spanner/ExecuteBatchDml", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *spannerClient) Read(ctx context.Context, in *ReadRequest, opts ...grpc.CallOption) (*ResultSet, error) {
	out := new(ResultSet)
	err := c.cc.Invoke(ctx, "/google.spanner.v1.Spanner/Read", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *spannerClient) StreamingRead(ctx context.Context, in *ReadRequest, opts ...grpc.CallOption) (Spanner_StreamingReadClient, error) {
	stream, err := c.cc.NewStream(ctx, &_Spanner_serviceDesc.Streams[1], "/google.spanner.v1.Spanner/StreamingRead", opts...)
	if err != nil {
		return nil, err
	}
	x := &spannerStreamingReadClient{stream}
	if err := x.ClientStream.SendMsg(in); err != nil {
		return nil, err
	}
	if err := x.ClientStream.CloseSend(); err != nil {
		return nil, err
	}
	return x, nil
}

type Spanner_StreamingReadClient interface {
	Recv() (*PartialResultSet, error)
	grpc.ClientStream
}

type spannerStreamingReadClient struct {
	grpc.ClientStream
}

func (x *spannerStreamingReadClient) Recv() (*PartialResultSet, error) {
	m := new(PartialResultSet)
	if err := x.ClientStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

func (c *spannerClient) BeginTransaction(ctx context.Context, in *BeginTransactionRequest, opts ...grpc.CallOption) (*Transaction, error) {
	out := new(Transaction)
	err := c.cc.Invoke(ctx, "/google.spanner.v1.Spanner/BeginTransaction", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *spannerClient) Commit(ctx context.Context, in *CommitRequest, opts ...grpc.CallOption) (*CommitResponse, error) {
	out := new(CommitResponse)
	err := c.cc.Invoke(ctx, "/google.spanner.v1.Spanner/Commit", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *spannerClient) Rollback(ctx context.Context, in *RollbackRequest, opts ...grpc.CallOption) (*emptypb.Empty, error) {
	out := new(emptypb.Empty)
	err := c.cc.Invoke(ctx, "/google.spanner.v1.Spanner/Rollback", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *spannerClient) PartitionQuery(ctx context.Context, in *PartitionQueryRequest, opts ...grpc.CallOption) (*PartitionResponse, error) {
	out := new(PartitionResponse)
	err := c.cc.Invoke(ctx, "/google.spanner.v1.Spanner/PartitionQuery", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *spannerClient) PartitionRead(ctx context.Context, in *PartitionReadRequest, opts ...grpc.CallOption) (*PartitionResponse, error) {
	out := new(PartitionResponse)
	err := c.cc.Invoke(ctx, "/google.spanner.v1.Spanner/PartitionRead", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// SpannerServer is the server API for Spanner service.
type SpannerServer interface {
	// Creates a new session. A session can be used to perform
	// transactions that read and/or modify data in a Cloud Spanner database.
	// Sessions are meant to be reused for many consecutive
	// transactions.
	//
	// Sessions can only execute one transaction at a time. To execute
	// multiple concurrent read-write/write-only transactions, create
	// multiple sessions. Note that standalone reads and queries use a
	// transaction internally, and count toward the one transaction
	// limit.
	//
	// Active sessions use additional server resources, so it is a good idea to
	// delete idle and unneeded sessions.
	// Aside from explicit deletes, Cloud Spanner may delete sessions for which no
	// operations are sent for more than an hour. If a session is deleted,
	// requests to it return `NOT_FOUND`.
	//
	// Idle sessions can be kept alive by sending a trivial SQL query
	// periodically, e.g., `"SELECT 1"`.
	CreateSession(context.Context, *CreateSessionRequest) (*Session, error)
	// Creates multiple new sessions.
	//
	// This API can be used to initialize a session cache on the clients.
	// See https://goo.gl/TgSFN2 for best practices on session cache management.
	BatchCreateSessions(context.Context, *BatchCreateSessionsRequest) (*BatchCreateSessionsResponse, error)
	// Gets a session. Returns `NOT_FOUND` if the session does not exist.
	// This is mainly useful for determining whether a session is still
	// alive.
	GetSession(context.Context, *GetSessionRequest) (*Session, error)
	// Lists all sessions in a given database.
	ListSessions(context.Context, *ListSessionsRequest) (*ListSessionsResponse, error)
	// Ends a session, releasing server resources associated with it. This will
	// asynchronously trigger cancellation of any operations that are running with
	// this session.
	DeleteSession(context.Context, *DeleteSessionRequest) (*emptypb.Empty, error)
	// Executes an SQL statement, returning all results in a single reply. This
	// method cannot be used to return a result set larger than 10 MiB;
	// if the query yields more data than that, the query fails with
	// a `FAILED_PRECONDITION` error.
	//
	// Operations inside read-write transactions might return `ABORTED`. If
	// this occurs, the application should restart the transaction from
	// the beginning. See [Transaction][google.spanner.v1.Transaction] for more details.
	//
	// Larger result sets can be fetched in streaming fashion by calling
	// [ExecuteStreamingSql][google.spanner.v1.Spanner.ExecuteStreamingSql] instead.
	ExecuteSql(context.Context, *ExecuteSqlRequest) (*ResultSet, error)
	// Like [ExecuteSql][google.spanner.v1.Spanner.ExecuteSql], except returns the result
	// set as a stream. Unlike [ExecuteSql][google.spanner.v1.Spanner.ExecuteSql], there
	// is no limit on the size of the returned result set. However, no
	// individual row in the result set can exceed 100 MiB, and no
	// column value can exceed 10 MiB.
	ExecuteStreamingSql(*ExecuteSqlRequest, Spanner_ExecuteStreamingSqlServer) error
	// Executes a batch of SQL DML statements. This method allows many statements
	// to be run with lower latency than submitting them sequentially with
	// [ExecuteSql][google.spanner.v1.Spanner.ExecuteSql].
	//
	// Statements are executed in sequential order. A request can succeed even if
	// a statement fails. The [ExecuteBatchDmlResponse.status][google.spanner.v1.ExecuteBatchDmlResponse.status] field in the
	// response provides information about the statement that failed. Clients must
	// inspect this field to determine whether an error occurred.
	//
	// Execution stops after the first failed statement; the remaining statements
	// are not executed.
	ExecuteBatchDml(context.Context, *ExecuteBatchDmlRequest) (*ExecuteBatchDmlResponse, error)
	// Reads rows from the database using key lookups and scans, as a
	// simple key/value style alternative to
	// [ExecuteSql][google.spanner.v1.Spanner.ExecuteSql].  This method cannot be used to
	// return a result set larger than 10 MiB; if the read matches more
	// data than that, the read fails with a `FAILED_PRECONDITION`
	// error.
	//
	// Reads inside read-write transactions might return `ABORTED`. If
	// this occurs, the application should restart the transaction from
	// the beginning. See [Transaction][google.spanner.v1.Transaction] for more details.
	//
	// Larger result sets can be yielded in streaming fashion by calling
	// [StreamingRead][google.spanner.v1.Spanner.StreamingRead] instead.
	Read(context.Context, *ReadRequest) (*ResultSet, error)
	// Like [Read][google.spanner.v1.Spanner.Read], except returns the result set as a
	// stream. Unlike [Read][google.spanner.v1.Spanner.Read], there is no limit on the
	// size of the returned result set. However, no individual row in
	// the result set can exceed 100 MiB, and no column value can exceed
	// 10 MiB.
	StreamingRead(*ReadRequest, Spanner_StreamingReadServer) error
	// Begins a new transaction. This step can often be skipped:
	// [Read][google.spanner.v1.Spanner.Read], [ExecuteSql][google.spanner.v1.Spanner.ExecuteSql] and
	// [Commit][google.spanner.v1.Spanner.Commit] can begin a new transaction as a
	// side-effect.
	BeginTransaction(context.Context, *BeginTransactionRequest) (*Transaction, error)
	// Commits a transaction. The request includes the mutations to be
	// applied to rows in the database.
	//
	// `Commit` might return an `ABORTED` error. This can occur at any time;
	// commonly, the cause is conflicts with concurrent
	// transactions. However, it can also happen for a variety of other
	// reasons. If `Commit` returns `ABORTED`, the caller should re-attempt
	// the transaction from the beginning, re-using the same session.
	Commit(context.Context, *CommitRequest) (*CommitResponse, error)
	// Rolls back a transaction, releasing any locks it holds. It is a good
	// idea to call this for any transaction that includes one or more
	// [Read][google.spanner.v1.Spanner.Read] or [ExecuteSql][google.spanner.v1.Spanner.ExecuteSql] requests and
	// ultimately decides not to commit.
	//
	// `Rollback` returns `OK` if it successfully aborts the transaction, the
	// transaction was already aborted, or the transaction is not
	// found. `Rollback` never returns `ABORTED`.
	Rollback(context.Context, *RollbackRequest) (*emptypb.Empty, error)
	// Creates a set of partition tokens that can be used to execute a query
	// operation in parallel.  Each of the returned partition tokens can be used
	// by [ExecuteStreamingSql][google.spanner.v1.Spanner.ExecuteStreamingSql] to specify a subset
	// of the query result to read.  The same session and read-only transaction
	// must be used by the PartitionQueryRequest used to create the
	// partition tokens and the ExecuteSqlRequests that use the partition tokens.
	//
	// Partition tokens become invalid when the session used to create them
	// is deleted, is idle for too long, begins a new transaction, or becomes too
	// old.  When any of these happen, it is not possible to resume the query, and
	// the whole operation must be restarted from the beginning.
	PartitionQuery(context.Context, *PartitionQueryRequest) (*PartitionResponse, error)
	// Creates a set of partition tokens that can be used to execute a read
	// operation in parallel.  Each of the returned partition tokens can be used
	// by [StreamingRead][google.spanner.v1.Spanner.StreamingRead] to specify a subset of the read
	// result to read.  The same session and read-only transaction must be used by
	// the PartitionReadRequest used to create the partition tokens and the
	// ReadRequests that use the partition tokens.  There are no ordering
	// guarantees on rows returned among the returned partition tokens, or even
	// within each individual StreamingRead call issued with a partition_token.
	//
	// Partition tokens become invalid when the session used to create them
	// is deleted, is idle for too long, begins a new transaction, or becomes too
	// old.  When any of these happen, it is not possible to resume the read, and
	// the whole operation must be restarted from the beginning.
	PartitionRead(context.Context, *PartitionReadRequest) (*PartitionResponse, error)
}

// UnimplementedSpannerServer can be embedded to have forward compatible implementations.
type UnimplementedSpannerServer struct {
}

func (*UnimplementedSpannerServer) CreateSession(context.Context, *CreateSessionRequest) (*Session, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method CreateSession not implemented")
}
func (*UnimplementedSpannerServer) BatchCreateSessions(context.Context, *BatchCreateSessionsRequest) (*BatchCreateSessionsResponse, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method BatchCreateSessions not implemented")
}
func (*UnimplementedSpannerServer) GetSession(context.Context, *GetSessionRequest) (*Session, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method GetSession not implemented")
}
func (*UnimplementedSpannerServer) ListSessions(context.Context, *ListSessionsRequest) (*ListSessionsResponse, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method ListSessions not implemented")
}
func (*UnimplementedSpannerServer) DeleteSession(context.Context, *DeleteSessionRequest) (*emptypb.Empty, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method DeleteSession not implemented")
}
func (*UnimplementedSpannerServer) ExecuteSql(context.Context, *ExecuteSqlRequest) (*ResultSet, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method ExecuteSql not implemented")
}
func (*UnimplementedSpannerServer) ExecuteStreamingSql(*ExecuteSqlRequest, Spanner_ExecuteStreamingSqlServer) error {
	return status1.Errorf(codes.Unimplemented, "method ExecuteStreamingSql not implemented")
}
func (*UnimplementedSpannerServer) ExecuteBatchDml(context.Context, *ExecuteBatchDmlRequest) (*ExecuteBatchDmlResponse, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method ExecuteBatchDml not implemented")
}
func (*UnimplementedSpannerServer) Read(context.Context, *ReadRequest) (*ResultSet, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method Read not implemented")
}
func (*UnimplementedSpannerServer) StreamingRead(*ReadRequest, Spanner_StreamingReadServer) error {
	return status1.Errorf(codes.Unimplemented, "method StreamingRead not implemented")
}
func (*UnimplementedSpannerServer) BeginTransaction(context.Context, *BeginTransactionRequest) (*Transaction, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method BeginTransaction not implemented")
}
func (*UnimplementedSpannerServer) Commit(context.Context, *CommitRequest) (*CommitResponse, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method Commit not implemented")
}
func (*UnimplementedSpannerServer) Rollback(context.Context, *RollbackRequest) (*emptypb.Empty, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method Rollback not implemented")
}
func (*UnimplementedSpannerServer) PartitionQuery(context.Context, *PartitionQueryRequest) (*PartitionResponse, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method PartitionQuery not implemented")
}
func (*UnimplementedSpannerServer) PartitionRead(context.Context, *PartitionReadRequest) (*PartitionResponse, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method PartitionRead not implemented")
}

func RegisterSpannerServer(s *grpc.Server, srv SpannerServer) {
	s.RegisterService(&_Spanner_serviceDesc, srv)
}

func _Spanner_CreateSession_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateSessionRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SpannerServer).CreateSession(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.spanner.v1.Spanner/CreateSession",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SpannerServer).CreateSession(ctx, req.(*CreateSessionRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Spanner_BatchCreateSessions_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(BatchCreateSessionsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SpannerServer).BatchCreateSessions(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.spanner.v1.Spanner/BatchCreateSessions",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SpannerServer).BatchCreateSessions(ctx, req.(*BatchCreateSessionsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Spanner_GetSession_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetSessionRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SpannerServer).GetSession(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.spanner.v1.Spanner/GetSession",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SpannerServer).GetSession(ctx, req.(*GetSessionRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Spanner_ListSessions_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListSessionsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SpannerServer).ListSessions(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.spanner.v1.Spanner/ListSessions",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SpannerServer).ListSessions(ctx, req.(*ListSessionsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Spanner_DeleteSession_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteSessionRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SpannerServer).DeleteSession(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.spanner.v1.Spanner/DeleteSession",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SpannerServer).DeleteSession(ctx, req.(*DeleteSessionRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Spanner_ExecuteSql_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ExecuteSqlRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SpannerServer).ExecuteSql(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.spanner.v1.Spanner/ExecuteSql",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SpannerServer).ExecuteSql(ctx, req.(*ExecuteSqlRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Spanner_ExecuteStreamingSql_Handler(srv interface{}, stream grpc.ServerStream) error {
	m := new(ExecuteSqlRequest)
	if err := stream.RecvMsg(m); err != nil {
		return err
	}
	return srv.(SpannerServer).ExecuteStreamingSql(m, &spannerExecuteStreamingSqlServer{stream})
}

type Spanner_ExecuteStreamingSqlServer interface {
	Send(*PartialResultSet) error
	grpc.ServerStream
}

type spannerExecuteStreamingSqlServer struct {
	grpc.ServerStream
}

func (x *spannerExecuteStreamingSqlServer) Send(m *PartialResultSet) error {
	return x.ServerStream.SendMsg(m)
}

func _Spanner_ExecuteBatchDml_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ExecuteBatchDmlRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SpannerServer).ExecuteBatchDml(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.spanner.v1.Spanner/ExecuteBatchDml",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SpannerServer).ExecuteBatchDml(ctx, req.(*ExecuteBatchDmlRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Spanner_Read_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ReadRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SpannerServer).Read(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.spanner.v1.Spanner/Read",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SpannerServer).Read(ctx, req.(*ReadRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Spanner_StreamingRead_Handler(srv interface{}, stream grpc.ServerStream) error {
	m := new(ReadRequest)
	if err := stream.RecvMsg(m); err != nil {
		return err
	}
	return srv.(SpannerServer).StreamingRead(m, &spannerStreamingReadServer{stream})
}

type Spanner_StreamingReadServer interface {
	Send(*PartialResultSet) error
	grpc.ServerStream
}

type spannerStreamingReadServer struct {
	grpc.ServerStream
}

func (x *spannerStreamingReadServer) Send(m *PartialResultSet) error {
	return x.ServerStream.SendMsg(m)
}

func _Spanner_BeginTransaction_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(BeginTransactionRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SpannerServer).BeginTransaction(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.spanner.v1.Spanner/BeginTransaction",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SpannerServer).BeginTransaction(ctx, req.(*BeginTransactionRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Spanner_Commit_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CommitRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SpannerServer).Commit(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.spanner.v1.Spanner/Commit",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SpannerServer).Commit(ctx, req.(*CommitRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Spanner_Rollback_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(RollbackRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SpannerServer).Rollback(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.spanner.v1.Spanner/Rollback",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SpannerServer).Rollback(ctx, req.(*RollbackRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Spanner_PartitionQuery_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(PartitionQueryRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SpannerServer).PartitionQuery(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.spanner.v1.Spanner/PartitionQuery",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SpannerServer).PartitionQuery(ctx, req.(*PartitionQueryRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Spanner_PartitionRead_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(PartitionReadRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SpannerServer).PartitionRead(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.spanner.v1.Spanner/PartitionRead",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SpannerServer).PartitionRead(ctx, req.(*PartitionReadRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _Spanner_serviceDesc = grpc.ServiceDesc{
	ServiceName: "google.spanner.v1.Spanner",
	HandlerType: (*SpannerServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "CreateSession",
			Handler:    _Spanner_CreateSession_Handler,
		},
		{
			MethodName: "BatchCreateSessions",
			Handler:    _Spanner_BatchCreateSessions_Handler,
		},
		{
			MethodName: "GetSession",
			Handler:    _Spanner_GetSession_Handler,
		},
		{
			MethodName: "ListSessions",
			Handler:    _Spanner_ListSessions_Handler,
		},
		{
			MethodName: "DeleteSession",
			Handler:    _Spanner_DeleteSession_Handler,
		},
		{
			MethodName: "ExecuteSql",
			Handler:    _Spanner_ExecuteSql_Handler,
		},
		{
			MethodName: "ExecuteBatchDml",
			Handler:    _Spanner_ExecuteBatchDml_Handler,
		},
		{
			MethodName: "Read",
			Handler:    _Spanner_Read_Handler,
		},
		{
			MethodName: "BeginTransaction",
			Handler:    _Spanner_BeginTransaction_Handler,
		},
		{
			MethodName: "Commit",
			Handler:    _Spanner_Commit_Handler,
		},
		{
			MethodName: "Rollback",
			Handler:    _Spanner_Rollback_Handler,
		},
		{
			MethodName: "PartitionQuery",
			Handler:    _Spanner_PartitionQuery_Handler,
		},
		{
			MethodName: "PartitionRead",
			Handler:    _Spanner_PartitionRead_Handler,
		},
	},
	Streams: []grpc.StreamDesc{
		{
			StreamName:    "ExecuteStreamingSql",
			Handler:       _Spanner_ExecuteStreamingSql_Handler,
			ServerStreams: true,
		},
		{
			StreamName:    "StreamingRead",
			Handler:       _Spanner_StreamingRead_Handler,
			ServerStreams: true,
		},
	},
	Metadata: "google/spanner/v1/spanner.proto",
}
