// Code generated by protoc-gen-go. DO NOT EDIT.
// source: google/api/backend.proto

package serviceconfig

import (
	fmt "fmt"
	math "math"

	proto "github.com/golang/protobuf/proto"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.ProtoPackageIsVersion3 // please upgrade the proto package

// Path Translation specifies how to combine the backend address with the
// request path in order to produce the appropriate forwarding URL for the
// request.
//
// Path Translation is applicable only to HTTP-based backends. Backends which
// do not accept requests over HTTP/HTTPS should leave `path_translation`
// unspecified.
type BackendRule_PathTranslation int32

const (
	BackendRule_PATH_TRANSLATION_UNSPECIFIED BackendRule_PathTranslation = 0
	// Use the backend address as-is, with no modification to the path. If the
	// URL pattern contains variables, the variable names and values will be
	// appended to the query string. If a query string parameter and a URL
	// pattern variable have the same name, this may result in duplicate keys in
	// the query string.
	//
	// # Examples
	//
	// Given the following operation config:
	//
	//     Method path:        /api/company/{cid}/user/{uid}
	//     Backend address:    https://example.cloudfunctions.net/getUser
	//
	// Requests to the following request paths will call the backend at the
	// translated path:
	//
	//     Request path: /api/company/widgetworks/user/johndoe
	//     Translated:
	//     https://example.cloudfunctions.net/getUser?cid=widgetworks&uid=johndoe
	//
	//     Request path: /api/company/widgetworks/user/johndoe?timezone=EST
	//     Translated:
	//     https://example.cloudfunctions.net/getUser?timezone=EST&cid=widgetworks&uid=johndoe
	BackendRule_CONSTANT_ADDRESS BackendRule_PathTranslation = 1
	// The request path will be appended to the backend address.
	//
	// # Examples
	//
	// Given the following operation config:
	//
	//     Method path:        /api/company/{cid}/user/{uid}
	//     Backend address:    https://example.appspot.com
	//
	// Requests to the following request paths will call the backend at the
	// translated path:
	//
	//     Request path: /api/company/widgetworks/user/johndoe
	//     Translated:
	//     https://example.appspot.com/api/company/widgetworks/user/johndoe
	//
	//     Request path: /api/company/widgetworks/user/johndoe?timezone=EST
	//     Translated:
	//     https://example.appspot.com/api/company/widgetworks/user/johndoe?timezone=EST
	BackendRule_APPEND_PATH_TO_ADDRESS BackendRule_PathTranslation = 2
)

var BackendRule_PathTranslation_name = map[int32]string{
	0: "PATH_TRANSLATION_UNSPECIFIED",
	1: "CONSTANT_ADDRESS",
	2: "APPEND_PATH_TO_ADDRESS",
}

var BackendRule_PathTranslation_value = map[string]int32{
	"PATH_TRANSLATION_UNSPECIFIED": 0,
	"CONSTANT_ADDRESS":             1,
	"APPEND_PATH_TO_ADDRESS":       2,
}

func (x BackendRule_PathTranslation) String() string {
	return proto.EnumName(BackendRule_PathTranslation_name, int32(x))
}

func (BackendRule_PathTranslation) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_87d0f28daa3f64f0, []int{1, 0}
}

// `Backend` defines the backend configuration for a service.
type Backend struct {
	// A list of API backend rules that apply to individual API methods.
	//
	// **NOTE:** All service configuration rules follow "last one wins" order.
	Rules                []*BackendRule `protobuf:"bytes,1,rep,name=rules,proto3" json:"rules,omitempty"`
	XXX_NoUnkeyedLiteral struct{}       `json:"-"`
	XXX_unrecognized     []byte         `json:"-"`
	XXX_sizecache        int32          `json:"-"`
}

func (m *Backend) Reset()         { *m = Backend{} }
func (m *Backend) String() string { return proto.CompactTextString(m) }
func (*Backend) ProtoMessage()    {}
func (*Backend) Descriptor() ([]byte, []int) {
	return fileDescriptor_87d0f28daa3f64f0, []int{0}
}

func (m *Backend) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Backend.Unmarshal(m, b)
}
func (m *Backend) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Backend.Marshal(b, m, deterministic)
}
func (m *Backend) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Backend.Merge(m, src)
}
func (m *Backend) XXX_Size() int {
	return xxx_messageInfo_Backend.Size(m)
}
func (m *Backend) XXX_DiscardUnknown() {
	xxx_messageInfo_Backend.DiscardUnknown(m)
}

var xxx_messageInfo_Backend proto.InternalMessageInfo

func (m *Backend) GetRules() []*BackendRule {
	if m != nil {
		return m.Rules
	}
	return nil
}

// A backend rule provides configuration for an individual API element.
type BackendRule struct {
	// Selects the methods to which this rule applies.
	//
	// Refer to [selector][google.api.DocumentationRule.selector] for syntax details.
	Selector string `protobuf:"bytes,1,opt,name=selector,proto3" json:"selector,omitempty"`
	// The address of the API backend.
	//
	// The scheme is used to determine the backend protocol and security.
	// The following schemes are accepted:
	//
	//    SCHEME        PROTOCOL    SECURITY
	//    http://       HTTP        None
	//    https://      HTTP        TLS
	//    grpc://       gRPC        None
	//    grpcs://      gRPC        TLS
	//
	// It is recommended to explicitly include a scheme. Leaving out the scheme
	// may cause constrasting behaviors across platforms.
	//
	// If the port is unspecified, the default is:
	// - 80 for schemes without TLS
	// - 443 for schemes with TLS
	//
	// For HTTP backends, use [protocol][google.api.BackendRule.protocol]
	// to specify the protocol version.
	Address string `protobuf:"bytes,2,opt,name=address,proto3" json:"address,omitempty"`
	// The number of seconds to wait for a response from a request. The default
	// varies based on the request protocol and deployment environment.
	Deadline float64 `protobuf:"fixed64,3,opt,name=deadline,proto3" json:"deadline,omitempty"`
	// Minimum deadline in seconds needed for this method. Calls having deadline
	// value lower than this will be rejected.
	MinDeadline float64 `protobuf:"fixed64,4,opt,name=min_deadline,json=minDeadline,proto3" json:"min_deadline,omitempty"`
	// The number of seconds to wait for the completion of a long running
	// operation. The default is no deadline.
	OperationDeadline float64                     `protobuf:"fixed64,5,opt,name=operation_deadline,json=operationDeadline,proto3" json:"operation_deadline,omitempty"`
	PathTranslation   BackendRule_PathTranslation `protobuf:"varint,6,opt,name=path_translation,json=pathTranslation,proto3,enum=google.api.BackendRule_PathTranslation" json:"path_translation,omitempty"`
	// Authentication settings used by the backend.
	//
	// These are typically used to provide service management functionality to
	// a backend served on a publicly-routable URL. The `authentication`
	// details should match the authentication behavior used by the backend.
	//
	// For example, specifying `jwt_audience` implies that the backend expects
	// authentication via a JWT.
	//
	// When authentication is unspecified, the resulting behavior is the same
	// as `disable_auth` set to `true`.
	//
	// Refer to https://developers.google.com/identity/protocols/OpenIDConnect for
	// JWT ID token.
	//
	// Types that are valid to be assigned to Authentication:
	//	*BackendRule_JwtAudience
	//	*BackendRule_DisableAuth
	Authentication isBackendRule_Authentication `protobuf_oneof:"authentication"`
	// The protocol used for sending a request to the backend.
	// The supported values are "http/1.1" and "h2".
	//
	// The default value is inferred from the scheme in the
	// [address][google.api.BackendRule.address] field:
	//
	//    SCHEME        PROTOCOL
	//    http://       http/1.1
	//    https://      http/1.1
	//    grpc://       h2
	//    grpcs://      h2
	//
	// For secure HTTP backends (https://) that support HTTP/2, set this field
	// to "h2" for improved performance.
	//
	// Configuring this field to non-default values is only supported for secure
	// HTTP backends. This field will be ignored for all other backends.
	//
	// See
	// https://www.iana.org/assignments/tls-extensiontype-values/tls-extensiontype-values.xhtml#alpn-protocol-ids
	// for more details on the supported values.
	Protocol             string   `protobuf:"bytes,9,opt,name=protocol,proto3" json:"protocol,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *BackendRule) Reset()         { *m = BackendRule{} }
func (m *BackendRule) String() string { return proto.CompactTextString(m) }
func (*BackendRule) ProtoMessage()    {}
func (*BackendRule) Descriptor() ([]byte, []int) {
	return fileDescriptor_87d0f28daa3f64f0, []int{1}
}

func (m *BackendRule) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_BackendRule.Unmarshal(m, b)
}
func (m *BackendRule) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_BackendRule.Marshal(b, m, deterministic)
}
func (m *BackendRule) XXX_Merge(src proto.Message) {
	xxx_messageInfo_BackendRule.Merge(m, src)
}
func (m *BackendRule) XXX_Size() int {
	return xxx_messageInfo_BackendRule.Size(m)
}
func (m *BackendRule) XXX_DiscardUnknown() {
	xxx_messageInfo_BackendRule.DiscardUnknown(m)
}

var xxx_messageInfo_BackendRule proto.InternalMessageInfo

func (m *BackendRule) GetSelector() string {
	if m != nil {
		return m.Selector
	}
	return ""
}

func (m *BackendRule) GetAddress() string {
	if m != nil {
		return m.Address
	}
	return ""
}

func (m *BackendRule) GetDeadline() float64 {
	if m != nil {
		return m.Deadline
	}
	return 0
}

func (m *BackendRule) GetMinDeadline() float64 {
	if m != nil {
		return m.MinDeadline
	}
	return 0
}

func (m *BackendRule) GetOperationDeadline() float64 {
	if m != nil {
		return m.OperationDeadline
	}
	return 0
}

func (m *BackendRule) GetPathTranslation() BackendRule_PathTranslation {
	if m != nil {
		return m.PathTranslation
	}
	return BackendRule_PATH_TRANSLATION_UNSPECIFIED
}

type isBackendRule_Authentication interface {
	isBackendRule_Authentication()
}

type BackendRule_JwtAudience struct {
	JwtAudience string `protobuf:"bytes,7,opt,name=jwt_audience,json=jwtAudience,proto3,oneof"`
}

type BackendRule_DisableAuth struct {
	DisableAuth bool `protobuf:"varint,8,opt,name=disable_auth,json=disableAuth,proto3,oneof"`
}

func (*BackendRule_JwtAudience) isBackendRule_Authentication() {}

func (*BackendRule_DisableAuth) isBackendRule_Authentication() {}

func (m *BackendRule) GetAuthentication() isBackendRule_Authentication {
	if m != nil {
		return m.Authentication
	}
	return nil
}

func (m *BackendRule) GetJwtAudience() string {
	if x, ok := m.GetAuthentication().(*BackendRule_JwtAudience); ok {
		return x.JwtAudience
	}
	return ""
}

func (m *BackendRule) GetDisableAuth() bool {
	if x, ok := m.GetAuthentication().(*BackendRule_DisableAuth); ok {
		return x.DisableAuth
	}
	return false
}

func (m *BackendRule) GetProtocol() string {
	if m != nil {
		return m.Protocol
	}
	return ""
}

// XXX_OneofWrappers is for the internal use of the proto package.
func (*BackendRule) XXX_OneofWrappers() []interface{} {
	return []interface{}{
		(*BackendRule_JwtAudience)(nil),
		(*BackendRule_DisableAuth)(nil),
	}
}

func init() {
	proto.RegisterEnum("google.api.BackendRule_PathTranslation", BackendRule_PathTranslation_name, BackendRule_PathTranslation_value)
	proto.RegisterType((*Backend)(nil), "google.api.Backend")
	proto.RegisterType((*BackendRule)(nil), "google.api.BackendRule")
}

func init() {
	proto.RegisterFile("google/api/backend.proto", fileDescriptor_87d0f28daa3f64f0)
}

var fileDescriptor_87d0f28daa3f64f0 = []byte{
	// 442 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0x74, 0x92, 0xc1, 0x6e, 0x9b, 0x40,
	0x10, 0x86, 0x43, 0x9c, 0xc4, 0xce, 0xda, 0x72, 0xe8, 0xaa, 0x6a, 0x57, 0x51, 0x0f, 0xd4, 0x3d,
	0x94, 0x4b, 0xb0, 0x94, 0x5e, 0x2a, 0xf5, 0x84, 0x03, 0x6d, 0x2c, 0x55, 0x18, 0x01, 0xbd, 0xf4,
	0x82, 0xd6, 0x30, 0xc5, 0x9b, 0xae, 0x77, 0x11, 0x2c, 0xcd, 0xfb, 0xf4, 0xd9, 0xfa, 0x20, 0x15,
	0x0b, 0x26, 0x4e, 0xa5, 0x1e, 0xff, 0xf9, 0xbe, 0x11, 0x33, 0xc3, 0x22, 0x52, 0x48, 0x59, 0x70,
	0x58, 0xd2, 0x92, 0x2d, 0xb7, 0x34, 0xfb, 0x09, 0x22, 0x77, 0xca, 0x4a, 0x2a, 0x89, 0x51, 0x47,
	0x1c, 0x5a, 0xb2, 0xc5, 0x47, 0x34, 0x5e, 0x75, 0x10, 0xdf, 0xa0, 0xf3, 0xaa, 0xe1, 0x50, 0x13,
	0xc3, 0x1a, 0xd9, 0xd3, 0xdb, 0xd7, 0xce, 0x93, 0xe6, 0xf4, 0x4e, 0xd4, 0x70, 0x88, 0x3a, 0x6b,
	0xf1, 0x67, 0x84, 0xa6, 0x47, 0x65, 0x7c, 0x8d, 0x26, 0x35, 0x70, 0xc8, 0x94, 0xac, 0x88, 0x61,
	0x19, 0xf6, 0x65, 0x34, 0x64, 0x4c, 0xd0, 0x98, 0xe6, 0x79, 0x05, 0x75, 0x4d, 0x4e, 0x35, 0x3a,
	0xc4, 0xb6, 0x2b, 0x07, 0x9a, 0x73, 0x26, 0x80, 0x8c, 0x2c, 0xc3, 0x36, 0xa2, 0x21, 0xe3, 0xb7,
	0x68, 0xb6, 0x67, 0x22, 0x1d, 0xf8, 0x99, 0xe6, 0xd3, 0x3d, 0x13, 0xde, 0x41, 0xb9, 0x41, 0x58,
	0x96, 0x50, 0x51, 0xc5, 0xe4, 0x91, 0x78, 0xae, 0xc5, 0x17, 0x03, 0x19, 0xf4, 0x08, 0x99, 0x25,
	0x55, 0xbb, 0x54, 0x55, 0x54, 0xd4, 0x5c, 0x33, 0x72, 0x61, 0x19, 0xf6, 0xfc, 0xf6, 0xfd, 0x7f,
	0xb6, 0x75, 0x42, 0xaa, 0x76, 0xc9, 0x93, 0x1e, 0x5d, 0x95, 0xcf, 0x0b, 0xf8, 0x1d, 0x9a, 0x3d,
	0x3c, 0xaa, 0x94, 0x36, 0x39, 0x03, 0x91, 0x01, 0x19, 0xb7, 0x0b, 0xde, 0x9f, 0x44, 0xd3, 0x87,
	0x47, 0xe5, 0xf6, 0xc5, 0x56, 0xca, 0x59, 0x4d, 0xb7, 0x1c, 0x52, 0xda, 0xa8, 0x1d, 0x99, 0x58,
	0x86, 0x3d, 0x69, 0xa5, 0xbe, 0xea, 0x36, 0x6a, 0xd7, 0xde, 0x42, 0xff, 0xa0, 0x4c, 0x72, 0x72,
	0xd9, 0x5d, 0xf0, 0x90, 0x17, 0x80, 0xae, 0xfe, 0x99, 0x04, 0x5b, 0xe8, 0x4d, 0xe8, 0x26, 0xf7,
	0x69, 0x12, 0xb9, 0x41, 0xfc, 0xd5, 0x4d, 0xd6, 0x9b, 0x20, 0xfd, 0x16, 0xc4, 0xa1, 0x7f, 0xb7,
	0xfe, 0xbc, 0xf6, 0x3d, 0xf3, 0x04, 0xbf, 0x44, 0xe6, 0xdd, 0x26, 0x88, 0x13, 0x37, 0x48, 0x52,
	0xd7, 0xf3, 0x22, 0x3f, 0x8e, 0x4d, 0x03, 0x5f, 0xa3, 0x57, 0x6e, 0x18, 0xfa, 0x81, 0x97, 0x76,
	0xed, 0x9b, 0x81, 0x9d, 0xae, 0x4c, 0x34, 0x6f, 0xe7, 0x03, 0xa1, 0x58, 0xa6, 0xbf, 0xb2, 0x12,
	0x68, 0x9e, 0xc9, 0xfd, 0xd1, 0x75, 0x56, 0xb3, 0xfe, 0x3c, 0x61, 0x3b, 0x5b, 0x68, 0x7c, 0xf7,
	0x7b, 0x56, 0x48, 0x4e, 0x45, 0xe1, 0xc8, 0xaa, 0x58, 0x16, 0x20, 0xf4, 0xe4, 0xcb, 0x0e, 0xd1,
	0x92, 0xd5, 0xfa, 0x1d, 0xd6, 0x50, 0xfd, 0x62, 0x19, 0x64, 0x52, 0xfc, 0x60, 0xc5, 0xa7, 0x67,
	0xe9, 0xf7, 0xe9, 0xd9, 0x17, 0x37, 0x5c, 0x6f, 0x2f, 0x74, 0xe3, 0x87, 0xbf, 0x01, 0x00, 0x00,
	0xff, 0xff, 0x78, 0x20, 0xfe, 0xd9, 0xbf, 0x02, 0x00, 0x00,
}
