// Code generated by protoc-gen-go. DO NOT EDIT.
// source: google/ads/googleads/v2/services/customer_feed_service.proto

package services

import (
	context "context"
	fmt "fmt"
	math "math"

	proto "github.com/golang/protobuf/proto"
	resources "google.golang.org/genproto/googleapis/ads/googleads/v2/resources"
	_ "google.golang.org/genproto/googleapis/api/annotations"
	status "google.golang.org/genproto/googleapis/rpc/status"
	field_mask "google.golang.org/genproto/protobuf/field_mask"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status1 "google.golang.org/grpc/status"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.ProtoPackageIsVersion3 // please upgrade the proto package

// Request message for [CustomerFeedService.GetCustomerFeed][google.ads.googleads.v2.services.CustomerFeedService.GetCustomerFeed].
type GetCustomerFeedRequest struct {
	// Required. The resource name of the customer feed to fetch.
	ResourceName         string   `protobuf:"bytes,1,opt,name=resource_name,json=resourceName,proto3" json:"resource_name,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *GetCustomerFeedRequest) Reset()         { *m = GetCustomerFeedRequest{} }
func (m *GetCustomerFeedRequest) String() string { return proto.CompactTextString(m) }
func (*GetCustomerFeedRequest) ProtoMessage()    {}
func (*GetCustomerFeedRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_17bd4bce188b63c7, []int{0}
}

func (m *GetCustomerFeedRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_GetCustomerFeedRequest.Unmarshal(m, b)
}
func (m *GetCustomerFeedRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_GetCustomerFeedRequest.Marshal(b, m, deterministic)
}
func (m *GetCustomerFeedRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_GetCustomerFeedRequest.Merge(m, src)
}
func (m *GetCustomerFeedRequest) XXX_Size() int {
	return xxx_messageInfo_GetCustomerFeedRequest.Size(m)
}
func (m *GetCustomerFeedRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_GetCustomerFeedRequest.DiscardUnknown(m)
}

var xxx_messageInfo_GetCustomerFeedRequest proto.InternalMessageInfo

func (m *GetCustomerFeedRequest) GetResourceName() string {
	if m != nil {
		return m.ResourceName
	}
	return ""
}

// Request message for [CustomerFeedService.MutateCustomerFeeds][google.ads.googleads.v2.services.CustomerFeedService.MutateCustomerFeeds].
type MutateCustomerFeedsRequest struct {
	// Required. The ID of the customer whose customer feeds are being modified.
	CustomerId string `protobuf:"bytes,1,opt,name=customer_id,json=customerId,proto3" json:"customer_id,omitempty"`
	// Required. The list of operations to perform on individual customer feeds.
	Operations []*CustomerFeedOperation `protobuf:"bytes,2,rep,name=operations,proto3" json:"operations,omitempty"`
	// If true, successful operations will be carried out and invalid
	// operations will return errors. If false, all operations will be carried
	// out in one transaction if and only if they are all valid.
	// Default is false.
	PartialFailure bool `protobuf:"varint,3,opt,name=partial_failure,json=partialFailure,proto3" json:"partial_failure,omitempty"`
	// If true, the request is validated but not executed. Only errors are
	// returned, not results.
	ValidateOnly         bool     `protobuf:"varint,4,opt,name=validate_only,json=validateOnly,proto3" json:"validate_only,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *MutateCustomerFeedsRequest) Reset()         { *m = MutateCustomerFeedsRequest{} }
func (m *MutateCustomerFeedsRequest) String() string { return proto.CompactTextString(m) }
func (*MutateCustomerFeedsRequest) ProtoMessage()    {}
func (*MutateCustomerFeedsRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_17bd4bce188b63c7, []int{1}
}

func (m *MutateCustomerFeedsRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_MutateCustomerFeedsRequest.Unmarshal(m, b)
}
func (m *MutateCustomerFeedsRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_MutateCustomerFeedsRequest.Marshal(b, m, deterministic)
}
func (m *MutateCustomerFeedsRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_MutateCustomerFeedsRequest.Merge(m, src)
}
func (m *MutateCustomerFeedsRequest) XXX_Size() int {
	return xxx_messageInfo_MutateCustomerFeedsRequest.Size(m)
}
func (m *MutateCustomerFeedsRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_MutateCustomerFeedsRequest.DiscardUnknown(m)
}

var xxx_messageInfo_MutateCustomerFeedsRequest proto.InternalMessageInfo

func (m *MutateCustomerFeedsRequest) GetCustomerId() string {
	if m != nil {
		return m.CustomerId
	}
	return ""
}

func (m *MutateCustomerFeedsRequest) GetOperations() []*CustomerFeedOperation {
	if m != nil {
		return m.Operations
	}
	return nil
}

func (m *MutateCustomerFeedsRequest) GetPartialFailure() bool {
	if m != nil {
		return m.PartialFailure
	}
	return false
}

func (m *MutateCustomerFeedsRequest) GetValidateOnly() bool {
	if m != nil {
		return m.ValidateOnly
	}
	return false
}

// A single operation (create, update, remove) on a customer feed.
type CustomerFeedOperation struct {
	// FieldMask that determines which resource fields are modified in an update.
	UpdateMask *field_mask.FieldMask `protobuf:"bytes,4,opt,name=update_mask,json=updateMask,proto3" json:"update_mask,omitempty"`
	// The mutate operation.
	//
	// Types that are valid to be assigned to Operation:
	//	*CustomerFeedOperation_Create
	//	*CustomerFeedOperation_Update
	//	*CustomerFeedOperation_Remove
	Operation            isCustomerFeedOperation_Operation `protobuf_oneof:"operation"`
	XXX_NoUnkeyedLiteral struct{}                          `json:"-"`
	XXX_unrecognized     []byte                            `json:"-"`
	XXX_sizecache        int32                             `json:"-"`
}

func (m *CustomerFeedOperation) Reset()         { *m = CustomerFeedOperation{} }
func (m *CustomerFeedOperation) String() string { return proto.CompactTextString(m) }
func (*CustomerFeedOperation) ProtoMessage()    {}
func (*CustomerFeedOperation) Descriptor() ([]byte, []int) {
	return fileDescriptor_17bd4bce188b63c7, []int{2}
}

func (m *CustomerFeedOperation) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_CustomerFeedOperation.Unmarshal(m, b)
}
func (m *CustomerFeedOperation) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_CustomerFeedOperation.Marshal(b, m, deterministic)
}
func (m *CustomerFeedOperation) XXX_Merge(src proto.Message) {
	xxx_messageInfo_CustomerFeedOperation.Merge(m, src)
}
func (m *CustomerFeedOperation) XXX_Size() int {
	return xxx_messageInfo_CustomerFeedOperation.Size(m)
}
func (m *CustomerFeedOperation) XXX_DiscardUnknown() {
	xxx_messageInfo_CustomerFeedOperation.DiscardUnknown(m)
}

var xxx_messageInfo_CustomerFeedOperation proto.InternalMessageInfo

func (m *CustomerFeedOperation) GetUpdateMask() *field_mask.FieldMask {
	if m != nil {
		return m.UpdateMask
	}
	return nil
}

type isCustomerFeedOperation_Operation interface {
	isCustomerFeedOperation_Operation()
}

type CustomerFeedOperation_Create struct {
	Create *resources.CustomerFeed `protobuf:"bytes,1,opt,name=create,proto3,oneof"`
}

type CustomerFeedOperation_Update struct {
	Update *resources.CustomerFeed `protobuf:"bytes,2,opt,name=update,proto3,oneof"`
}

type CustomerFeedOperation_Remove struct {
	Remove string `protobuf:"bytes,3,opt,name=remove,proto3,oneof"`
}

func (*CustomerFeedOperation_Create) isCustomerFeedOperation_Operation() {}

func (*CustomerFeedOperation_Update) isCustomerFeedOperation_Operation() {}

func (*CustomerFeedOperation_Remove) isCustomerFeedOperation_Operation() {}

func (m *CustomerFeedOperation) GetOperation() isCustomerFeedOperation_Operation {
	if m != nil {
		return m.Operation
	}
	return nil
}

func (m *CustomerFeedOperation) GetCreate() *resources.CustomerFeed {
	if x, ok := m.GetOperation().(*CustomerFeedOperation_Create); ok {
		return x.Create
	}
	return nil
}

func (m *CustomerFeedOperation) GetUpdate() *resources.CustomerFeed {
	if x, ok := m.GetOperation().(*CustomerFeedOperation_Update); ok {
		return x.Update
	}
	return nil
}

func (m *CustomerFeedOperation) GetRemove() string {
	if x, ok := m.GetOperation().(*CustomerFeedOperation_Remove); ok {
		return x.Remove
	}
	return ""
}

// XXX_OneofWrappers is for the internal use of the proto package.
func (*CustomerFeedOperation) XXX_OneofWrappers() []interface{} {
	return []interface{}{
		(*CustomerFeedOperation_Create)(nil),
		(*CustomerFeedOperation_Update)(nil),
		(*CustomerFeedOperation_Remove)(nil),
	}
}

// Response message for a customer feed mutate.
type MutateCustomerFeedsResponse struct {
	// Errors that pertain to operation failures in the partial failure mode.
	// Returned only when partial_failure = true and all errors occur inside the
	// operations. If any errors occur outside the operations (e.g. auth errors),
	// we return an RPC level error.
	PartialFailureError *status.Status `protobuf:"bytes,3,opt,name=partial_failure_error,json=partialFailureError,proto3" json:"partial_failure_error,omitempty"`
	// All results for the mutate.
	Results              []*MutateCustomerFeedResult `protobuf:"bytes,2,rep,name=results,proto3" json:"results,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                    `json:"-"`
	XXX_unrecognized     []byte                      `json:"-"`
	XXX_sizecache        int32                       `json:"-"`
}

func (m *MutateCustomerFeedsResponse) Reset()         { *m = MutateCustomerFeedsResponse{} }
func (m *MutateCustomerFeedsResponse) String() string { return proto.CompactTextString(m) }
func (*MutateCustomerFeedsResponse) ProtoMessage()    {}
func (*MutateCustomerFeedsResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_17bd4bce188b63c7, []int{3}
}

func (m *MutateCustomerFeedsResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_MutateCustomerFeedsResponse.Unmarshal(m, b)
}
func (m *MutateCustomerFeedsResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_MutateCustomerFeedsResponse.Marshal(b, m, deterministic)
}
func (m *MutateCustomerFeedsResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_MutateCustomerFeedsResponse.Merge(m, src)
}
func (m *MutateCustomerFeedsResponse) XXX_Size() int {
	return xxx_messageInfo_MutateCustomerFeedsResponse.Size(m)
}
func (m *MutateCustomerFeedsResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_MutateCustomerFeedsResponse.DiscardUnknown(m)
}

var xxx_messageInfo_MutateCustomerFeedsResponse proto.InternalMessageInfo

func (m *MutateCustomerFeedsResponse) GetPartialFailureError() *status.Status {
	if m != nil {
		return m.PartialFailureError
	}
	return nil
}

func (m *MutateCustomerFeedsResponse) GetResults() []*MutateCustomerFeedResult {
	if m != nil {
		return m.Results
	}
	return nil
}

// The result for the customer feed mutate.
type MutateCustomerFeedResult struct {
	// Returned for successful operations.
	ResourceName         string   `protobuf:"bytes,1,opt,name=resource_name,json=resourceName,proto3" json:"resource_name,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *MutateCustomerFeedResult) Reset()         { *m = MutateCustomerFeedResult{} }
func (m *MutateCustomerFeedResult) String() string { return proto.CompactTextString(m) }
func (*MutateCustomerFeedResult) ProtoMessage()    {}
func (*MutateCustomerFeedResult) Descriptor() ([]byte, []int) {
	return fileDescriptor_17bd4bce188b63c7, []int{4}
}

func (m *MutateCustomerFeedResult) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_MutateCustomerFeedResult.Unmarshal(m, b)
}
func (m *MutateCustomerFeedResult) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_MutateCustomerFeedResult.Marshal(b, m, deterministic)
}
func (m *MutateCustomerFeedResult) XXX_Merge(src proto.Message) {
	xxx_messageInfo_MutateCustomerFeedResult.Merge(m, src)
}
func (m *MutateCustomerFeedResult) XXX_Size() int {
	return xxx_messageInfo_MutateCustomerFeedResult.Size(m)
}
func (m *MutateCustomerFeedResult) XXX_DiscardUnknown() {
	xxx_messageInfo_MutateCustomerFeedResult.DiscardUnknown(m)
}

var xxx_messageInfo_MutateCustomerFeedResult proto.InternalMessageInfo

func (m *MutateCustomerFeedResult) GetResourceName() string {
	if m != nil {
		return m.ResourceName
	}
	return ""
}

func init() {
	proto.RegisterType((*GetCustomerFeedRequest)(nil), "google.ads.googleads.v2.services.GetCustomerFeedRequest")
	proto.RegisterType((*MutateCustomerFeedsRequest)(nil), "google.ads.googleads.v2.services.MutateCustomerFeedsRequest")
	proto.RegisterType((*CustomerFeedOperation)(nil), "google.ads.googleads.v2.services.CustomerFeedOperation")
	proto.RegisterType((*MutateCustomerFeedsResponse)(nil), "google.ads.googleads.v2.services.MutateCustomerFeedsResponse")
	proto.RegisterType((*MutateCustomerFeedResult)(nil), "google.ads.googleads.v2.services.MutateCustomerFeedResult")
}

func init() {
	proto.RegisterFile("google/ads/googleads/v2/services/customer_feed_service.proto", fileDescriptor_17bd4bce188b63c7)
}

var fileDescriptor_17bd4bce188b63c7 = []byte{
	// 781 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0x9c, 0x55, 0x4f, 0x6b, 0xe3, 0x46,
	0x14, 0xaf, 0xe4, 0x92, 0x36, 0xe3, 0xa4, 0x81, 0x09, 0x49, 0x55, 0xa7, 0x50, 0xa3, 0xa6, 0x24,
	0x98, 0x56, 0xa2, 0x2a, 0x25, 0x45, 0x49, 0x28, 0x72, 0xa9, 0x9d, 0x1c, 0xd2, 0x04, 0xa5, 0xf8,
	0x50, 0x0c, 0x66, 0x22, 0x8d, 0x5d, 0x11, 0x49, 0xa3, 0x9d, 0x91, 0x0c, 0x21, 0xe4, 0xb2, 0xdf,
	0x60, 0xd9, 0x6f, 0xb0, 0xc7, 0xfd, 0x0a, 0x7b, 0xde, 0x4b, 0xae, 0x7b, 0xcb, 0x29, 0x87, 0x85,
	0x85, 0x1c, 0xf6, 0x03, 0xec, 0x65, 0x17, 0x69, 0x66, 0x6c, 0x39, 0xb1, 0x31, 0x9b, 0xdb, 0xd3,
	0xbc, 0xdf, 0xfb, 0xbd, 0xff, 0x4f, 0x60, 0x6f, 0x40, 0xc8, 0x20, 0xc4, 0x26, 0xf2, 0x99, 0xc9,
	0xc5, 0x5c, 0x1a, 0x5a, 0x26, 0xc3, 0x74, 0x18, 0x78, 0x98, 0x99, 0x5e, 0xc6, 0x52, 0x12, 0x61,
	0xda, 0xeb, 0x63, 0xec, 0xf7, 0xc4, 0xb3, 0x91, 0x50, 0x92, 0x12, 0x58, 0xe7, 0x26, 0x06, 0xf2,
	0x99, 0x31, 0xb2, 0x36, 0x86, 0x96, 0x21, 0xad, 0x6b, 0xbf, 0xcf, 0xe2, 0xa7, 0x98, 0x91, 0x8c,
	0x3e, 0x70, 0xc0, 0x89, 0x6b, 0xdf, 0x4b, 0xb3, 0x24, 0x30, 0x51, 0x1c, 0x93, 0x14, 0xa5, 0x01,
	0x89, 0x99, 0xd0, 0x7e, 0x5b, 0xd2, 0x7a, 0x61, 0x80, 0xe3, 0x54, 0x28, 0x7e, 0x28, 0x29, 0xfa,
	0x01, 0x0e, 0xfd, 0xde, 0x19, 0xfe, 0x1f, 0x0d, 0x03, 0x42, 0x05, 0xe0, 0xbb, 0x12, 0x40, 0x46,
	0x20, 0x54, 0x22, 0x17, 0xb3, 0xf8, 0x3a, 0xcb, 0xfa, 0x82, 0x20, 0x42, 0xec, 0xfc, 0x9e, 0x5b,
	0x9a, 0x78, 0x26, 0x4b, 0x51, 0x9a, 0x89, 0x78, 0xf4, 0x10, 0xac, 0xb7, 0x71, 0xfa, 0x97, 0xc8,
	0xa3, 0x85, 0xb1, 0xef, 0xe2, 0x27, 0x19, 0x66, 0x29, 0x74, 0xc1, 0xb2, 0x74, 0xd3, 0x8b, 0x51,
	0x84, 0x35, 0xa5, 0xae, 0x6c, 0x2f, 0x36, 0x7f, 0xb9, 0x75, 0xd4, 0x0f, 0xce, 0x16, 0xf8, 0x69,
	0x5c, 0x34, 0x21, 0x25, 0x01, 0x33, 0x3c, 0x12, 0x99, 0x13, 0x64, 0x4b, 0x92, 0xe3, 0x1f, 0x14,
	0x61, 0xfd, 0xbd, 0x02, 0x6a, 0x47, 0x59, 0x8a, 0x52, 0x5c, 0x06, 0x31, 0xe9, 0x72, 0x13, 0x54,
	0x47, 0x15, 0x0d, 0x7c, 0xe1, 0xb0, 0x72, 0xeb, 0xa8, 0x2e, 0x90, 0xef, 0x87, 0x3e, 0xec, 0x02,
	0x40, 0x12, 0x4c, 0x79, 0x59, 0x35, 0xb5, 0x5e, 0xd9, 0xae, 0x5a, 0x3b, 0xc6, 0xbc, 0x76, 0x1a,
	0x65, 0x8f, 0xc7, 0xd2, 0x5e, 0xb0, 0x8f, 0xf9, 0xe0, 0x16, 0x58, 0x49, 0x10, 0x4d, 0x03, 0x14,
	0xf6, 0xfa, 0x28, 0x08, 0x33, 0x8a, 0xb5, 0x4a, 0x5d, 0xd9, 0xfe, 0xda, 0xfd, 0x46, 0x3c, 0xb7,
	0xf8, 0x2b, 0xfc, 0x11, 0x2c, 0x0f, 0x51, 0x18, 0xf8, 0x28, 0xc5, 0x3d, 0x12, 0x87, 0x17, 0xda,
	0x97, 0x05, 0x6c, 0x49, 0x3e, 0x1e, 0xc7, 0xe1, 0x85, 0xfe, 0x4c, 0x05, 0x6b, 0x53, 0x1d, 0xc3,
	0x5d, 0x50, 0xcd, 0x92, 0xc2, 0x38, 0x6f, 0x53, 0x61, 0x5c, 0xb5, 0x6a, 0x32, 0x0d, 0xd9, 0x49,
	0xa3, 0x95, 0x77, 0xf2, 0x08, 0xb1, 0x73, 0x17, 0x70, 0x78, 0x2e, 0xc3, 0x43, 0xb0, 0xe0, 0x51,
	0x8c, 0x52, 0xde, 0x94, 0xaa, 0x65, 0xce, 0x4c, 0x7f, 0x34, 0xab, 0x13, 0xf9, 0x1f, 0x7c, 0xe1,
	0x0a, 0x82, 0x9c, 0x8a, 0x13, 0x6b, 0xea, 0xa3, 0xa9, 0x38, 0x01, 0xd4, 0xc0, 0x02, 0xc5, 0x11,
	0x19, 0xf2, 0x8a, 0x2d, 0xe6, 0x1a, 0xfe, 0xdd, 0xac, 0x82, 0xc5, 0x51, 0x89, 0xf5, 0x57, 0x0a,
	0xd8, 0x98, 0x3a, 0x04, 0x2c, 0x21, 0x31, 0xc3, 0xb0, 0x05, 0xd6, 0xee, 0x75, 0xa0, 0x87, 0x29,
	0x25, 0xb4, 0x60, 0xad, 0x5a, 0x50, 0x06, 0x48, 0x13, 0xcf, 0x38, 0x2d, 0x66, 0xd9, 0x5d, 0x9d,
	0xec, 0xcd, 0xdf, 0x39, 0x1c, 0xfe, 0x0b, 0xbe, 0xa2, 0x98, 0x65, 0x61, 0x2a, 0x87, 0xc4, 0x9e,
	0x3f, 0x24, 0x0f, 0xe3, 0x72, 0x0b, 0x0a, 0x57, 0x52, 0xe9, 0x7f, 0x02, 0x6d, 0x16, 0x28, 0x1f,
	0x89, 0x29, 0x2b, 0x33, 0xb9, 0x03, 0xd6, 0xbb, 0x0a, 0x58, 0x2d, 0xdb, 0x9e, 0x72, 0xdf, 0xf0,
	0xb5, 0x02, 0x56, 0xee, 0xad, 0x22, 0xfc, 0x63, 0x7e, 0xc4, 0xd3, 0xb7, 0xb7, 0xf6, 0xb9, 0x6d,
	0xd4, 0xdb, 0x37, 0xce, 0x64, 0xf0, 0x4f, 0xdf, 0xbc, 0x7d, 0xae, 0xfe, 0x0a, 0xcd, 0xfc, 0xe2,
	0x5d, 0x4e, 0x68, 0xf6, 0xe5, 0x32, 0x32, 0xb3, 0x31, 0x3a, 0x81, 0x45, 0x0f, 0xcd, 0xc6, 0x15,
	0xbc, 0x53, 0xc0, 0xea, 0x94, 0xf6, 0xc2, 0xbd, 0xc7, 0x54, 0x5f, 0x9e, 0x86, 0xda, 0xfe, 0x23,
	0xad, 0xf9, 0x4c, 0xe9, 0x9d, 0x1b, 0x67, 0xbd, 0x74, 0x5a, 0x7e, 0x1e, 0x2f, 0x7c, 0x91, 0xe6,
	0x8e, 0x6e, 0xe5, 0x69, 0x8e, 0xf3, 0xba, 0x2c, 0x81, 0xf7, 0x1b, 0x57, 0x93, 0x59, 0xda, 0x51,
	0xe1, 0xc9, 0x56, 0x1a, 0xb5, 0x8d, 0x6b, 0x47, 0x9b, 0x75, 0x08, 0x9b, 0x1f, 0x15, 0xb0, 0xe9,
	0x91, 0x68, 0x6e, 0xe4, 0x4d, 0x6d, 0xca, 0x3c, 0x9c, 0xe4, 0x17, 0xe0, 0x44, 0xf9, 0xef, 0x40,
	0x58, 0x0f, 0x48, 0x88, 0xe2, 0x81, 0x41, 0xe8, 0xc0, 0x1c, 0xe0, 0xb8, 0xb8, 0x0f, 0xe6, 0xd8,
	0xdf, 0xec, 0x9f, 0xe0, 0xae, 0x14, 0x5e, 0xa8, 0x95, 0xb6, 0xe3, 0xbc, 0x54, 0xeb, 0x6d, 0x4e,
	0xe8, 0xf8, 0xcc, 0xe0, 0x62, 0x2e, 0x75, 0x2c, 0x43, 0x38, 0x66, 0xd7, 0x12, 0xd2, 0x75, 0x7c,
	0xd6, 0x1d, 0x41, 0xba, 0x1d, 0xab, 0x2b, 0x21, 0x77, 0xea, 0x26, 0x7f, 0xb7, 0x6d, 0xc7, 0x67,
	0xb6, 0x3d, 0x02, 0xd9, 0x76, 0xc7, 0xb2, 0x6d, 0x09, 0x3b, 0x5b, 0x28, 0xe2, 0xfc, 0xed, 0x53,
	0x00, 0x00, 0x00, 0xff, 0xff, 0x2a, 0x4d, 0xb6, 0x2e, 0xab, 0x07, 0x00, 0x00,
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConnInterface

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion6

// CustomerFeedServiceClient is the client API for CustomerFeedService service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
type CustomerFeedServiceClient interface {
	// Returns the requested customer feed in full detail.
	GetCustomerFeed(ctx context.Context, in *GetCustomerFeedRequest, opts ...grpc.CallOption) (*resources.CustomerFeed, error)
	// Creates, updates, or removes customer feeds. Operation statuses are
	// returned.
	MutateCustomerFeeds(ctx context.Context, in *MutateCustomerFeedsRequest, opts ...grpc.CallOption) (*MutateCustomerFeedsResponse, error)
}

type customerFeedServiceClient struct {
	cc grpc.ClientConnInterface
}

func NewCustomerFeedServiceClient(cc grpc.ClientConnInterface) CustomerFeedServiceClient {
	return &customerFeedServiceClient{cc}
}

func (c *customerFeedServiceClient) GetCustomerFeed(ctx context.Context, in *GetCustomerFeedRequest, opts ...grpc.CallOption) (*resources.CustomerFeed, error) {
	out := new(resources.CustomerFeed)
	err := c.cc.Invoke(ctx, "/google.ads.googleads.v2.services.CustomerFeedService/GetCustomerFeed", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *customerFeedServiceClient) MutateCustomerFeeds(ctx context.Context, in *MutateCustomerFeedsRequest, opts ...grpc.CallOption) (*MutateCustomerFeedsResponse, error) {
	out := new(MutateCustomerFeedsResponse)
	err := c.cc.Invoke(ctx, "/google.ads.googleads.v2.services.CustomerFeedService/MutateCustomerFeeds", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// CustomerFeedServiceServer is the server API for CustomerFeedService service.
type CustomerFeedServiceServer interface {
	// Returns the requested customer feed in full detail.
	GetCustomerFeed(context.Context, *GetCustomerFeedRequest) (*resources.CustomerFeed, error)
	// Creates, updates, or removes customer feeds. Operation statuses are
	// returned.
	MutateCustomerFeeds(context.Context, *MutateCustomerFeedsRequest) (*MutateCustomerFeedsResponse, error)
}

// UnimplementedCustomerFeedServiceServer can be embedded to have forward compatible implementations.
type UnimplementedCustomerFeedServiceServer struct {
}

func (*UnimplementedCustomerFeedServiceServer) GetCustomerFeed(ctx context.Context, req *GetCustomerFeedRequest) (*resources.CustomerFeed, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method GetCustomerFeed not implemented")
}
func (*UnimplementedCustomerFeedServiceServer) MutateCustomerFeeds(ctx context.Context, req *MutateCustomerFeedsRequest) (*MutateCustomerFeedsResponse, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method MutateCustomerFeeds not implemented")
}

func RegisterCustomerFeedServiceServer(s *grpc.Server, srv CustomerFeedServiceServer) {
	s.RegisterService(&_CustomerFeedService_serviceDesc, srv)
}

func _CustomerFeedService_GetCustomerFeed_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetCustomerFeedRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CustomerFeedServiceServer).GetCustomerFeed(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.ads.googleads.v2.services.CustomerFeedService/GetCustomerFeed",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CustomerFeedServiceServer).GetCustomerFeed(ctx, req.(*GetCustomerFeedRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _CustomerFeedService_MutateCustomerFeeds_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(MutateCustomerFeedsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CustomerFeedServiceServer).MutateCustomerFeeds(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.ads.googleads.v2.services.CustomerFeedService/MutateCustomerFeeds",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CustomerFeedServiceServer).MutateCustomerFeeds(ctx, req.(*MutateCustomerFeedsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _CustomerFeedService_serviceDesc = grpc.ServiceDesc{
	ServiceName: "google.ads.googleads.v2.services.CustomerFeedService",
	HandlerType: (*CustomerFeedServiceServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "GetCustomerFeed",
			Handler:    _CustomerFeedService_GetCustomerFeed_Handler,
		},
		{
			MethodName: "MutateCustomerFeeds",
			Handler:    _CustomerFeedService_MutateCustomerFeeds_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/ads/googleads/v2/services/customer_feed_service.proto",
}
