package web

// Copyright (c) Microsoft and contributors.  All rights reserved.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
// http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//
// See the License for the specific language governing permissions and
// limitations under the License.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"context"
	"github.com/Azure/go-autorest/autorest"
	"github.com/Azure/go-autorest/autorest/azure"
	"github.com/Azure/go-autorest/autorest/validation"
	"github.com/Azure/go-autorest/tracing"
	"net/http"
)

// AppsClient is the webSite Management Client
type AppsClient struct {
	BaseClient
}

// NewAppsClient creates an instance of the AppsClient client.
func NewAppsClient(subscriptionID string) AppsClient {
	return NewAppsClientWithBaseURI(DefaultBaseURI, subscriptionID)
}

// NewAppsClientWithBaseURI creates an instance of the AppsClient client using a custom endpoint.  Use this when
// interacting with an Azure cloud that uses a non-standard base URI (sovereign clouds, Azure stack).
func NewAppsClientWithBaseURI(baseURI string, subscriptionID string) AppsClient {
	return AppsClient{NewWithBaseURI(baseURI, subscriptionID)}
}

// AddPremierAddOn description for Updates a named add-on of an app.
// Parameters:
// resourceGroupName - name of the resource group to which the resource belongs.
// name - name of the app.
// premierAddOnName - add-on name.
// premierAddOn - a JSON representation of the edited premier add-on.
func (client AppsClient) AddPremierAddOn(ctx context.Context, resourceGroupName string, name string, premierAddOnName string, premierAddOn PremierAddOn) (result PremierAddOn, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/AppsClient.AddPremierAddOn")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewError("web.AppsClient", "AddPremierAddOn", err.Error())
	}

	req, err := client.AddPremierAddOnPreparer(ctx, resourceGroupName, name, premierAddOnName, premierAddOn)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "AddPremierAddOn", nil, "Failure preparing request")
		return
	}

	resp, err := client.AddPremierAddOnSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.AppsClient", "AddPremierAddOn", resp, "Failure sending request")
		return
	}

	result, err = client.AddPremierAddOnResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "AddPremierAddOn", resp, "Failure responding to request")
	}

	return
}

// AddPremierAddOnPreparer prepares the AddPremierAddOn request.
func (client AppsClient) AddPremierAddOnPreparer(ctx context.Context, resourceGroupName string, name string, premierAddOnName string, premierAddOn PremierAddOn) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"premierAddOnName":  autorest.Encode("path", premierAddOnName),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2019-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsContentType("application/json; charset=utf-8"),
		autorest.AsPut(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/premieraddons/{premierAddOnName}", pathParameters),
		autorest.WithJSON(premierAddOn),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// AddPremierAddOnSender sends the AddPremierAddOn request. The method will close the
// http.Response Body if it receives an error.
func (client AppsClient) AddPremierAddOnSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// AddPremierAddOnResponder handles the response to the AddPremierAddOn request. The method always
// closes the http.Response Body.
func (client AppsClient) AddPremierAddOnResponder(resp *http.Response) (result PremierAddOn, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// AddPremierAddOnSlot description for Updates a named add-on of an app.
// Parameters:
// resourceGroupName - name of the resource group to which the resource belongs.
// name - name of the app.
// premierAddOnName - add-on name.
// premierAddOn - a JSON representation of the edited premier add-on.
// slot - name of the deployment slot. If a slot is not specified, the API will update the named add-on for the
// production slot.
func (client AppsClient) AddPremierAddOnSlot(ctx context.Context, resourceGroupName string, name string, premierAddOnName string, premierAddOn PremierAddOn, slot string) (result PremierAddOn, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/AppsClient.AddPremierAddOnSlot")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewError("web.AppsClient", "AddPremierAddOnSlot", err.Error())
	}

	req, err := client.AddPremierAddOnSlotPreparer(ctx, resourceGroupName, name, premierAddOnName, premierAddOn, slot)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "AddPremierAddOnSlot", nil, "Failure preparing request")
		return
	}

	resp, err := client.AddPremierAddOnSlotSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.AppsClient", "AddPremierAddOnSlot", resp, "Failure sending request")
		return
	}

	result, err = client.AddPremierAddOnSlotResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "AddPremierAddOnSlot", resp, "Failure responding to request")
	}

	return
}

// AddPremierAddOnSlotPreparer prepares the AddPremierAddOnSlot request.
func (client AppsClient) AddPremierAddOnSlotPreparer(ctx context.Context, resourceGroupName string, name string, premierAddOnName string, premierAddOn PremierAddOn, slot string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"premierAddOnName":  autorest.Encode("path", premierAddOnName),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"slot":              autorest.Encode("path", slot),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2019-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsContentType("application/json; charset=utf-8"),
		autorest.AsPut(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/premieraddons/{premierAddOnName}", pathParameters),
		autorest.WithJSON(premierAddOn),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// AddPremierAddOnSlotSender sends the AddPremierAddOnSlot request. The method will close the
// http.Response Body if it receives an error.
func (client AppsClient) AddPremierAddOnSlotSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// AddPremierAddOnSlotResponder handles the response to the AddPremierAddOnSlot request. The method always
// closes the http.Response Body.
func (client AppsClient) AddPremierAddOnSlotResponder(resp *http.Response) (result PremierAddOn, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// AnalyzeCustomHostname description for Analyze a custom hostname.
// Parameters:
// resourceGroupName - name of the resource group to which the resource belongs.
// name - name of web app.
// hostName - custom hostname.
func (client AppsClient) AnalyzeCustomHostname(ctx context.Context, resourceGroupName string, name string, hostName string) (result CustomHostnameAnalysisResult, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/AppsClient.AnalyzeCustomHostname")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewError("web.AppsClient", "AnalyzeCustomHostname", err.Error())
	}

	req, err := client.AnalyzeCustomHostnamePreparer(ctx, resourceGroupName, name, hostName)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "AnalyzeCustomHostname", nil, "Failure preparing request")
		return
	}

	resp, err := client.AnalyzeCustomHostnameSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.AppsClient", "AnalyzeCustomHostname", resp, "Failure sending request")
		return
	}

	result, err = client.AnalyzeCustomHostnameResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "AnalyzeCustomHostname", resp, "Failure responding to request")
	}

	return
}

// AnalyzeCustomHostnamePreparer prepares the AnalyzeCustomHostname request.
func (client AppsClient) AnalyzeCustomHostnamePreparer(ctx context.Context, resourceGroupName string, name string, hostName string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2019-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}
	if len(hostName) > 0 {
		queryParameters["hostName"] = autorest.Encode("query", hostName)
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/analyzeCustomHostname", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// AnalyzeCustomHostnameSender sends the AnalyzeCustomHostname request. The method will close the
// http.Response Body if it receives an error.
func (client AppsClient) AnalyzeCustomHostnameSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// AnalyzeCustomHostnameResponder handles the response to the AnalyzeCustomHostname request. The method always
// closes the http.Response Body.
func (client AppsClient) AnalyzeCustomHostnameResponder(resp *http.Response) (result CustomHostnameAnalysisResult, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// AnalyzeCustomHostnameSlot description for Analyze a custom hostname.
// Parameters:
// resourceGroupName - name of the resource group to which the resource belongs.
// name - name of web app.
// slot - name of web app slot. If not specified then will default to production slot.
// hostName - custom hostname.
func (client AppsClient) AnalyzeCustomHostnameSlot(ctx context.Context, resourceGroupName string, name string, slot string, hostName string) (result CustomHostnameAnalysisResult, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/AppsClient.AnalyzeCustomHostnameSlot")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewError("web.AppsClient", "AnalyzeCustomHostnameSlot", err.Error())
	}

	req, err := client.AnalyzeCustomHostnameSlotPreparer(ctx, resourceGroupName, name, slot, hostName)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "AnalyzeCustomHostnameSlot", nil, "Failure preparing request")
		return
	}

	resp, err := client.AnalyzeCustomHostnameSlotSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.AppsClient", "AnalyzeCustomHostnameSlot", resp, "Failure sending request")
		return
	}

	result, err = client.AnalyzeCustomHostnameSlotResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "AnalyzeCustomHostnameSlot", resp, "Failure responding to request")
	}

	return
}

// AnalyzeCustomHostnameSlotPreparer prepares the AnalyzeCustomHostnameSlot request.
func (client AppsClient) AnalyzeCustomHostnameSlotPreparer(ctx context.Context, resourceGroupName string, name string, slot string, hostName string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"slot":              autorest.Encode("path", slot),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2019-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}
	if len(hostName) > 0 {
		queryParameters["hostName"] = autorest.Encode("query", hostName)
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/analyzeCustomHostname", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// AnalyzeCustomHostnameSlotSender sends the AnalyzeCustomHostnameSlot request. The method will close the
// http.Response Body if it receives an error.
func (client AppsClient) AnalyzeCustomHostnameSlotSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// AnalyzeCustomHostnameSlotResponder handles the response to the AnalyzeCustomHostnameSlot request. The method always
// closes the http.Response Body.
func (client AppsClient) AnalyzeCustomHostnameSlotResponder(resp *http.Response) (result CustomHostnameAnalysisResult, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// ApplySlotConfigToProduction description for Applies the configuration settings from the target slot onto the current
// slot.
// Parameters:
// resourceGroupName - name of the resource group to which the resource belongs.
// name - name of the app.
// slotSwapEntity - JSON object that contains the target slot name. See example.
func (client AppsClient) ApplySlotConfigToProduction(ctx context.Context, resourceGroupName string, name string, slotSwapEntity CsmSlotEntity) (result autorest.Response, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/AppsClient.ApplySlotConfigToProduction")
		defer func() {
			sc := -1
			if result.Response != nil {
				sc = result.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}},
		{TargetValue: slotSwapEntity,
			Constraints: []validation.Constraint{{Target: "slotSwapEntity.TargetSlot", Name: validation.Null, Rule: true, Chain: nil},
				{Target: "slotSwapEntity.PreserveVnet", Name: validation.Null, Rule: true, Chain: nil}}}}); err != nil {
		return result, validation.NewError("web.AppsClient", "ApplySlotConfigToProduction", err.Error())
	}

	req, err := client.ApplySlotConfigToProductionPreparer(ctx, resourceGroupName, name, slotSwapEntity)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "ApplySlotConfigToProduction", nil, "Failure preparing request")
		return
	}

	resp, err := client.ApplySlotConfigToProductionSender(req)
	if err != nil {
		result.Response = resp
		err = autorest.NewErrorWithError(err, "web.AppsClient", "ApplySlotConfigToProduction", resp, "Failure sending request")
		return
	}

	result, err = client.ApplySlotConfigToProductionResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "ApplySlotConfigToProduction", resp, "Failure responding to request")
	}

	return
}

// ApplySlotConfigToProductionPreparer prepares the ApplySlotConfigToProduction request.
func (client AppsClient) ApplySlotConfigToProductionPreparer(ctx context.Context, resourceGroupName string, name string, slotSwapEntity CsmSlotEntity) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2019-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsContentType("application/json; charset=utf-8"),
		autorest.AsPost(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/applySlotConfig", pathParameters),
		autorest.WithJSON(slotSwapEntity),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// ApplySlotConfigToProductionSender sends the ApplySlotConfigToProduction request. The method will close the
// http.Response Body if it receives an error.
func (client AppsClient) ApplySlotConfigToProductionSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// ApplySlotConfigToProductionResponder handles the response to the ApplySlotConfigToProduction request. The method always
// closes the http.Response Body.
func (client AppsClient) ApplySlotConfigToProductionResponder(resp *http.Response) (result autorest.Response, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByClosing())
	result.Response = resp
	return
}

// ApplySlotConfigurationSlot description for Applies the configuration settings from the target slot onto the current
// slot.
// Parameters:
// resourceGroupName - name of the resource group to which the resource belongs.
// name - name of the app.
// slotSwapEntity - JSON object that contains the target slot name. See example.
// slot - name of the source slot. If a slot is not specified, the production slot is used as the source slot.
func (client AppsClient) ApplySlotConfigurationSlot(ctx context.Context, resourceGroupName string, name string, slotSwapEntity CsmSlotEntity, slot string) (result autorest.Response, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/AppsClient.ApplySlotConfigurationSlot")
		defer func() {
			sc := -1
			if result.Response != nil {
				sc = result.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}},
		{TargetValue: slotSwapEntity,
			Constraints: []validation.Constraint{{Target: "slotSwapEntity.TargetSlot", Name: validation.Null, Rule: true, Chain: nil},
				{Target: "slotSwapEntity.PreserveVnet", Name: validation.Null, Rule: true, Chain: nil}}}}); err != nil {
		return result, validation.NewError("web.AppsClient", "ApplySlotConfigurationSlot", err.Error())
	}

	req, err := client.ApplySlotConfigurationSlotPreparer(ctx, resourceGroupName, name, slotSwapEntity, slot)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "ApplySlotConfigurationSlot", nil, "Failure preparing request")
		return
	}

	resp, err := client.ApplySlotConfigurationSlotSender(req)
	if err != nil {
		result.Response = resp
		err = autorest.NewErrorWithError(err, "web.AppsClient", "ApplySlotConfigurationSlot", resp, "Failure sending request")
		return
	}

	result, err = client.ApplySlotConfigurationSlotResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "ApplySlotConfigurationSlot", resp, "Failure responding to request")
	}

	return
}

// ApplySlotConfigurationSlotPreparer prepares the ApplySlotConfigurationSlot request.
func (client AppsClient) ApplySlotConfigurationSlotPreparer(ctx context.Context, resourceGroupName string, name string, slotSwapEntity CsmSlotEntity, slot string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"slot":              autorest.Encode("path", slot),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2019-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsContentType("application/json; charset=utf-8"),
		autorest.AsPost(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/applySlotConfig", pathParameters),
		autorest.WithJSON(slotSwapEntity),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// ApplySlotConfigurationSlotSender sends the ApplySlotConfigurationSlot request. The method will close the
// http.Response Body if it receives an error.
func (client AppsClient) ApplySlotConfigurationSlotSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// ApplySlotConfigurationSlotResponder handles the response to the ApplySlotConfigurationSlot request. The method always
// closes the http.Response Body.
func (client AppsClient) ApplySlotConfigurationSlotResponder(resp *http.Response) (result autorest.Response, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByClosing())
	result.Response = resp
	return
}

// Backup description for Creates a backup of an app.
// Parameters:
// resourceGroupName - name of the resource group to which the resource belongs.
// name - name of the app.
// request - backup configuration. You can use the JSON response from the POST action as input here.
func (client AppsClient) Backup(ctx context.Context, resourceGroupName string, name string, request BackupRequest) (result BackupItem, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/AppsClient.Backup")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}},
		{TargetValue: request,
			Constraints: []validation.Constraint{{Target: "request.BackupRequestProperties", Name: validation.Null, Rule: false,
				Chain: []validation.Constraint{{Target: "request.BackupRequestProperties.StorageAccountURL", Name: validation.Null, Rule: true, Chain: nil},
					{Target: "request.BackupRequestProperties.BackupSchedule", Name: validation.Null, Rule: false,
						Chain: []validation.Constraint{{Target: "request.BackupRequestProperties.BackupSchedule.FrequencyInterval", Name: validation.Null, Rule: true, Chain: nil},
							{Target: "request.BackupRequestProperties.BackupSchedule.KeepAtLeastOneBackup", Name: validation.Null, Rule: true, Chain: nil},
							{Target: "request.BackupRequestProperties.BackupSchedule.RetentionPeriodInDays", Name: validation.Null, Rule: true, Chain: nil},
						}},
				}}}}}); err != nil {
		return result, validation.NewError("web.AppsClient", "Backup", err.Error())
	}

	req, err := client.BackupPreparer(ctx, resourceGroupName, name, request)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "Backup", nil, "Failure preparing request")
		return
	}

	resp, err := client.BackupSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.AppsClient", "Backup", resp, "Failure sending request")
		return
	}

	result, err = client.BackupResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "Backup", resp, "Failure responding to request")
	}

	return
}

// BackupPreparer prepares the Backup request.
func (client AppsClient) BackupPreparer(ctx context.Context, resourceGroupName string, name string, request BackupRequest) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2019-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsContentType("application/json; charset=utf-8"),
		autorest.AsPost(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/backup", pathParameters),
		autorest.WithJSON(request),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// BackupSender sends the Backup request. The method will close the
// http.Response Body if it receives an error.
func (client AppsClient) BackupSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// BackupResponder handles the response to the Backup request. The method always
// closes the http.Response Body.
func (client AppsClient) BackupResponder(resp *http.Response) (result BackupItem, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// BackupSlot description for Creates a backup of an app.
// Parameters:
// resourceGroupName - name of the resource group to which the resource belongs.
// name - name of the app.
// request - backup configuration. You can use the JSON response from the POST action as input here.
// slot - name of the deployment slot. If a slot is not specified, the API will create a backup for the
// production slot.
func (client AppsClient) BackupSlot(ctx context.Context, resourceGroupName string, name string, request BackupRequest, slot string) (result BackupItem, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/AppsClient.BackupSlot")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}},
		{TargetValue: request,
			Constraints: []validation.Constraint{{Target: "request.BackupRequestProperties", Name: validation.Null, Rule: false,
				Chain: []validation.Constraint{{Target: "request.BackupRequestProperties.StorageAccountURL", Name: validation.Null, Rule: true, Chain: nil},
					{Target: "request.BackupRequestProperties.BackupSchedule", Name: validation.Null, Rule: false,
						Chain: []validation.Constraint{{Target: "request.BackupRequestProperties.BackupSchedule.FrequencyInterval", Name: validation.Null, Rule: true, Chain: nil},
							{Target: "request.BackupRequestProperties.BackupSchedule.KeepAtLeastOneBackup", Name: validation.Null, Rule: true, Chain: nil},
							{Target: "request.BackupRequestProperties.BackupSchedule.RetentionPeriodInDays", Name: validation.Null, Rule: true, Chain: nil},
						}},
				}}}}}); err != nil {
		return result, validation.NewError("web.AppsClient", "BackupSlot", err.Error())
	}

	req, err := client.BackupSlotPreparer(ctx, resourceGroupName, name, request, slot)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "BackupSlot", nil, "Failure preparing request")
		return
	}

	resp, err := client.BackupSlotSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.AppsClient", "BackupSlot", resp, "Failure sending request")
		return
	}

	result, err = client.BackupSlotResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "BackupSlot", resp, "Failure responding to request")
	}

	return
}

// BackupSlotPreparer prepares the BackupSlot request.
func (client AppsClient) BackupSlotPreparer(ctx context.Context, resourceGroupName string, name string, request BackupRequest, slot string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"slot":              autorest.Encode("path", slot),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2019-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsContentType("application/json; charset=utf-8"),
		autorest.AsPost(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/backup", pathParameters),
		autorest.WithJSON(request),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// BackupSlotSender sends the BackupSlot request. The method will close the
// http.Response Body if it receives an error.
func (client AppsClient) BackupSlotSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// BackupSlotResponder handles the response to the BackupSlot request. The method always
// closes the http.Response Body.
func (client AppsClient) BackupSlotResponder(resp *http.Response) (result BackupItem, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// CopyProductionSlot description for Copies a deployment slot to another deployment slot of an app.
// Parameters:
// resourceGroupName - name of the resource group to which the resource belongs.
// name - name of the app.
// copySlotEntity - JSON object that contains the target slot name and site config properties to override the
// source slot config. See example.
func (client AppsClient) CopyProductionSlot(ctx context.Context, resourceGroupName string, name string, copySlotEntity CsmCopySlotEntity) (result AppsCopyProductionSlotFuture, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/AppsClient.CopyProductionSlot")
		defer func() {
			sc := -1
			if result.Response() != nil {
				sc = result.Response().StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}},
		{TargetValue: copySlotEntity,
			Constraints: []validation.Constraint{{Target: "copySlotEntity.TargetSlot", Name: validation.Null, Rule: true, Chain: nil},
				{Target: "copySlotEntity.SiteConfig", Name: validation.Null, Rule: true,
					Chain: []validation.Constraint{{Target: "copySlotEntity.SiteConfig.Push", Name: validation.Null, Rule: false,
						Chain: []validation.Constraint{{Target: "copySlotEntity.SiteConfig.Push.PushSettingsProperties", Name: validation.Null, Rule: false,
							Chain: []validation.Constraint{{Target: "copySlotEntity.SiteConfig.Push.PushSettingsProperties.IsPushEnabled", Name: validation.Null, Rule: true, Chain: nil}}},
						}},
						{Target: "copySlotEntity.SiteConfig.PreWarmedInstanceCount", Name: validation.Null, Rule: false,
							Chain: []validation.Constraint{{Target: "copySlotEntity.SiteConfig.PreWarmedInstanceCount", Name: validation.InclusiveMaximum, Rule: int64(10), Chain: nil},
								{Target: "copySlotEntity.SiteConfig.PreWarmedInstanceCount", Name: validation.InclusiveMinimum, Rule: int64(0), Chain: nil},
							}},
					}}}}}); err != nil {
		return result, validation.NewError("web.AppsClient", "CopyProductionSlot", err.Error())
	}

	req, err := client.CopyProductionSlotPreparer(ctx, resourceGroupName, name, copySlotEntity)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "CopyProductionSlot", nil, "Failure preparing request")
		return
	}

	result, err = client.CopyProductionSlotSender(req)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "CopyProductionSlot", result.Response(), "Failure sending request")
		return
	}

	return
}

// CopyProductionSlotPreparer prepares the CopyProductionSlot request.
func (client AppsClient) CopyProductionSlotPreparer(ctx context.Context, resourceGroupName string, name string, copySlotEntity CsmCopySlotEntity) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2019-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsContentType("application/json; charset=utf-8"),
		autorest.AsPost(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slotcopy", pathParameters),
		autorest.WithJSON(copySlotEntity),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// CopyProductionSlotSender sends the CopyProductionSlot request. The method will close the
// http.Response Body if it receives an error.
func (client AppsClient) CopyProductionSlotSender(req *http.Request) (future AppsCopyProductionSlotFuture, err error) {
	var resp *http.Response
	resp, err = client.Send(req, azure.DoRetryWithRegistration(client.Client))
	if err != nil {
		return
	}
	future.Future, err = azure.NewFutureFromResponse(resp)
	return
}

// CopyProductionSlotResponder handles the response to the CopyProductionSlot request. The method always
// closes the http.Response Body.
func (client AppsClient) CopyProductionSlotResponder(resp *http.Response) (result autorest.Response, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusAccepted),
		autorest.ByClosing())
	result.Response = resp
	return
}

// CopySlotSlot description for Copies a deployment slot to another deployment slot of an app.
// Parameters:
// resourceGroupName - name of the resource group to which the resource belongs.
// name - name of the app.
// copySlotEntity - JSON object that contains the target slot name and site config properties to override the
// source slot config. See example.
// slot - name of the source slot. If a slot is not specified, the production slot is used as the source slot.
func (client AppsClient) CopySlotSlot(ctx context.Context, resourceGroupName string, name string, copySlotEntity CsmCopySlotEntity, slot string) (result AppsCopySlotSlotFuture, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/AppsClient.CopySlotSlot")
		defer func() {
			sc := -1
			if result.Response() != nil {
				sc = result.Response().StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}},
		{TargetValue: copySlotEntity,
			Constraints: []validation.Constraint{{Target: "copySlotEntity.TargetSlot", Name: validation.Null, Rule: true, Chain: nil},
				{Target: "copySlotEntity.SiteConfig", Name: validation.Null, Rule: true,
					Chain: []validation.Constraint{{Target: "copySlotEntity.SiteConfig.Push", Name: validation.Null, Rule: false,
						Chain: []validation.Constraint{{Target: "copySlotEntity.SiteConfig.Push.PushSettingsProperties", Name: validation.Null, Rule: false,
							Chain: []validation.Constraint{{Target: "copySlotEntity.SiteConfig.Push.PushSettingsProperties.IsPushEnabled", Name: validation.Null, Rule: true, Chain: nil}}},
						}},
						{Target: "copySlotEntity.SiteConfig.PreWarmedInstanceCount", Name: validation.Null, Rule: false,
							Chain: []validation.Constraint{{Target: "copySlotEntity.SiteConfig.PreWarmedInstanceCount", Name: validation.InclusiveMaximum, Rule: int64(10), Chain: nil},
								{Target: "copySlotEntity.SiteConfig.PreWarmedInstanceCount", Name: validation.InclusiveMinimum, Rule: int64(0), Chain: nil},
							}},
					}}}}}); err != nil {
		return result, validation.NewError("web.AppsClient", "CopySlotSlot", err.Error())
	}

	req, err := client.CopySlotSlotPreparer(ctx, resourceGroupName, name, copySlotEntity, slot)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "CopySlotSlot", nil, "Failure preparing request")
		return
	}

	result, err = client.CopySlotSlotSender(req)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "CopySlotSlot", result.Response(), "Failure sending request")
		return
	}

	return
}

// CopySlotSlotPreparer prepares the CopySlotSlot request.
func (client AppsClient) CopySlotSlotPreparer(ctx context.Context, resourceGroupName string, name string, copySlotEntity CsmCopySlotEntity, slot string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"slot":              autorest.Encode("path", slot),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2019-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsContentType("application/json; charset=utf-8"),
		autorest.AsPost(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/slotcopy", pathParameters),
		autorest.WithJSON(copySlotEntity),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// CopySlotSlotSender sends the CopySlotSlot request. The method will close the
// http.Response Body if it receives an error.
func (client AppsClient) CopySlotSlotSender(req *http.Request) (future AppsCopySlotSlotFuture, err error) {
	var resp *http.Response
	resp, err = client.Send(req, azure.DoRetryWithRegistration(client.Client))
	if err != nil {
		return
	}
	future.Future, err = azure.NewFutureFromResponse(resp)
	return
}

// CopySlotSlotResponder handles the response to the CopySlotSlot request. The method always
// closes the http.Response Body.
func (client AppsClient) CopySlotSlotResponder(resp *http.Response) (result autorest.Response, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusAccepted),
		autorest.ByClosing())
	result.Response = resp
	return
}

// CreateDeployment description for Create a deployment for an app, or a deployment slot.
// Parameters:
// resourceGroupName - name of the resource group to which the resource belongs.
// name - name of the app.
// ID - ID of an existing deployment.
// deployment - deployment details.
func (client AppsClient) CreateDeployment(ctx context.Context, resourceGroupName string, name string, ID string, deployment Deployment) (result Deployment, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/AppsClient.CreateDeployment")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewError("web.AppsClient", "CreateDeployment", err.Error())
	}

	req, err := client.CreateDeploymentPreparer(ctx, resourceGroupName, name, ID, deployment)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "CreateDeployment", nil, "Failure preparing request")
		return
	}

	resp, err := client.CreateDeploymentSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.AppsClient", "CreateDeployment", resp, "Failure sending request")
		return
	}

	result, err = client.CreateDeploymentResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "CreateDeployment", resp, "Failure responding to request")
	}

	return
}

// CreateDeploymentPreparer prepares the CreateDeployment request.
func (client AppsClient) CreateDeploymentPreparer(ctx context.Context, resourceGroupName string, name string, ID string, deployment Deployment) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"id":                autorest.Encode("path", ID),
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2019-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsContentType("application/json; charset=utf-8"),
		autorest.AsPut(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/deployments/{id}", pathParameters),
		autorest.WithJSON(deployment),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// CreateDeploymentSender sends the CreateDeployment request. The method will close the
// http.Response Body if it receives an error.
func (client AppsClient) CreateDeploymentSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// CreateDeploymentResponder handles the response to the CreateDeployment request. The method always
// closes the http.Response Body.
func (client AppsClient) CreateDeploymentResponder(resp *http.Response) (result Deployment, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// CreateDeploymentSlot description for Create a deployment for an app, or a deployment slot.
// Parameters:
// resourceGroupName - name of the resource group to which the resource belongs.
// name - name of the app.
// ID - ID of an existing deployment.
// slot - name of the deployment slot. If a slot is not specified, the API creates a deployment for the
// production slot.
// deployment - deployment details.
func (client AppsClient) CreateDeploymentSlot(ctx context.Context, resourceGroupName string, name string, ID string, slot string, deployment Deployment) (result Deployment, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/AppsClient.CreateDeploymentSlot")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewError("web.AppsClient", "CreateDeploymentSlot", err.Error())
	}

	req, err := client.CreateDeploymentSlotPreparer(ctx, resourceGroupName, name, ID, slot, deployment)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "CreateDeploymentSlot", nil, "Failure preparing request")
		return
	}

	resp, err := client.CreateDeploymentSlotSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.AppsClient", "CreateDeploymentSlot", resp, "Failure sending request")
		return
	}

	result, err = client.CreateDeploymentSlotResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "CreateDeploymentSlot", resp, "Failure responding to request")
	}

	return
}

// CreateDeploymentSlotPreparer prepares the CreateDeploymentSlot request.
func (client AppsClient) CreateDeploymentSlotPreparer(ctx context.Context, resourceGroupName string, name string, ID string, slot string, deployment Deployment) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"id":                autorest.Encode("path", ID),
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"slot":              autorest.Encode("path", slot),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2019-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsContentType("application/json; charset=utf-8"),
		autorest.AsPut(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/deployments/{id}", pathParameters),
		autorest.WithJSON(deployment),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// CreateDeploymentSlotSender sends the CreateDeploymentSlot request. The method will close the
// http.Response Body if it receives an error.
func (client AppsClient) CreateDeploymentSlotSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// CreateDeploymentSlotResponder handles the response to the CreateDeploymentSlot request. The method always
// closes the http.Response Body.
func (client AppsClient) CreateDeploymentSlotResponder(resp *http.Response) (result Deployment, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// CreateFunction description for Create function for web site, or a deployment slot.
// Parameters:
// resourceGroupName - name of the resource group to which the resource belongs.
// name - site name.
// functionName - function name.
// functionEnvelope - function details.
func (client AppsClient) CreateFunction(ctx context.Context, resourceGroupName string, name string, functionName string, functionEnvelope FunctionEnvelope) (result AppsCreateFunctionFuture, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/AppsClient.CreateFunction")
		defer func() {
			sc := -1
			if result.Response() != nil {
				sc = result.Response().StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewError("web.AppsClient", "CreateFunction", err.Error())
	}

	req, err := client.CreateFunctionPreparer(ctx, resourceGroupName, name, functionName, functionEnvelope)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "CreateFunction", nil, "Failure preparing request")
		return
	}

	result, err = client.CreateFunctionSender(req)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "CreateFunction", result.Response(), "Failure sending request")
		return
	}

	return
}

// CreateFunctionPreparer prepares the CreateFunction request.
func (client AppsClient) CreateFunctionPreparer(ctx context.Context, resourceGroupName string, name string, functionName string, functionEnvelope FunctionEnvelope) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"functionName":      autorest.Encode("path", functionName),
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2019-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsContentType("application/json; charset=utf-8"),
		autorest.AsPut(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/functions/{functionName}", pathParameters),
		autorest.WithJSON(functionEnvelope),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// CreateFunctionSender sends the CreateFunction request. The method will close the
// http.Response Body if it receives an error.
func (client AppsClient) CreateFunctionSender(req *http.Request) (future AppsCreateFunctionFuture, err error) {
	var resp *http.Response
	resp, err = client.Send(req, azure.DoRetryWithRegistration(client.Client))
	if err != nil {
		return
	}
	future.Future, err = azure.NewFutureFromResponse(resp)
	return
}

// CreateFunctionResponder handles the response to the CreateFunction request. The method always
// closes the http.Response Body.
func (client AppsClient) CreateFunctionResponder(resp *http.Response) (result FunctionEnvelope, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusCreated),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// CreateInstanceFunctionSlot description for Create function for web site, or a deployment slot.
// Parameters:
// resourceGroupName - name of the resource group to which the resource belongs.
// name - site name.
// functionName - function name.
// slot - name of the deployment slot.
// functionEnvelope - function details.
func (client AppsClient) CreateInstanceFunctionSlot(ctx context.Context, resourceGroupName string, name string, functionName string, slot string, functionEnvelope FunctionEnvelope) (result AppsCreateInstanceFunctionSlotFuture, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/AppsClient.CreateInstanceFunctionSlot")
		defer func() {
			sc := -1
			if result.Response() != nil {
				sc = result.Response().StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewError("web.AppsClient", "CreateInstanceFunctionSlot", err.Error())
	}

	req, err := client.CreateInstanceFunctionSlotPreparer(ctx, resourceGroupName, name, functionName, slot, functionEnvelope)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "CreateInstanceFunctionSlot", nil, "Failure preparing request")
		return
	}

	result, err = client.CreateInstanceFunctionSlotSender(req)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "CreateInstanceFunctionSlot", result.Response(), "Failure sending request")
		return
	}

	return
}

// CreateInstanceFunctionSlotPreparer prepares the CreateInstanceFunctionSlot request.
func (client AppsClient) CreateInstanceFunctionSlotPreparer(ctx context.Context, resourceGroupName string, name string, functionName string, slot string, functionEnvelope FunctionEnvelope) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"functionName":      autorest.Encode("path", functionName),
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"slot":              autorest.Encode("path", slot),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2019-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsContentType("application/json; charset=utf-8"),
		autorest.AsPut(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/functions/{functionName}", pathParameters),
		autorest.WithJSON(functionEnvelope),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// CreateInstanceFunctionSlotSender sends the CreateInstanceFunctionSlot request. The method will close the
// http.Response Body if it receives an error.
func (client AppsClient) CreateInstanceFunctionSlotSender(req *http.Request) (future AppsCreateInstanceFunctionSlotFuture, err error) {
	var resp *http.Response
	resp, err = client.Send(req, azure.DoRetryWithRegistration(client.Client))
	if err != nil {
		return
	}
	future.Future, err = azure.NewFutureFromResponse(resp)
	return
}

// CreateInstanceFunctionSlotResponder handles the response to the CreateInstanceFunctionSlot request. The method always
// closes the http.Response Body.
func (client AppsClient) CreateInstanceFunctionSlotResponder(resp *http.Response) (result FunctionEnvelope, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusCreated),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// CreateInstanceMSDeployOperation description for Invoke the MSDeploy web app extension.
// Parameters:
// resourceGroupName - name of the resource group to which the resource belongs.
// name - name of web app.
// instanceID - ID of web app instance.
// mSDeploy - details of MSDeploy operation
func (client AppsClient) CreateInstanceMSDeployOperation(ctx context.Context, resourceGroupName string, name string, instanceID string, mSDeploy MSDeploy) (result AppsCreateInstanceMSDeployOperationFuture, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/AppsClient.CreateInstanceMSDeployOperation")
		defer func() {
			sc := -1
			if result.Response() != nil {
				sc = result.Response().StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewError("web.AppsClient", "CreateInstanceMSDeployOperation", err.Error())
	}

	req, err := client.CreateInstanceMSDeployOperationPreparer(ctx, resourceGroupName, name, instanceID, mSDeploy)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "CreateInstanceMSDeployOperation", nil, "Failure preparing request")
		return
	}

	result, err = client.CreateInstanceMSDeployOperationSender(req)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "CreateInstanceMSDeployOperation", result.Response(), "Failure sending request")
		return
	}

	return
}

// CreateInstanceMSDeployOperationPreparer prepares the CreateInstanceMSDeployOperation request.
func (client AppsClient) CreateInstanceMSDeployOperationPreparer(ctx context.Context, resourceGroupName string, name string, instanceID string, mSDeploy MSDeploy) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"instanceId":        autorest.Encode("path", instanceID),
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2019-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsContentType("application/json; charset=utf-8"),
		autorest.AsPut(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/instances/{instanceId}/extensions/MSDeploy", pathParameters),
		autorest.WithJSON(mSDeploy),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// CreateInstanceMSDeployOperationSender sends the CreateInstanceMSDeployOperation request. The method will close the
// http.Response Body if it receives an error.
func (client AppsClient) CreateInstanceMSDeployOperationSender(req *http.Request) (future AppsCreateInstanceMSDeployOperationFuture, err error) {
	var resp *http.Response
	resp, err = client.Send(req, azure.DoRetryWithRegistration(client.Client))
	if err != nil {
		return
	}
	future.Future, err = azure.NewFutureFromResponse(resp)
	return
}

// CreateInstanceMSDeployOperationResponder handles the response to the CreateInstanceMSDeployOperation request. The method always
// closes the http.Response Body.
func (client AppsClient) CreateInstanceMSDeployOperationResponder(resp *http.Response) (result MSDeployStatus, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusCreated, http.StatusConflict),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// CreateInstanceMSDeployOperationSlot description for Invoke the MSDeploy web app extension.
// Parameters:
// resourceGroupName - name of the resource group to which the resource belongs.
// name - name of web app.
// slot - name of web app slot. If not specified then will default to production slot.
// instanceID - ID of web app instance.
// mSDeploy - details of MSDeploy operation
func (client AppsClient) CreateInstanceMSDeployOperationSlot(ctx context.Context, resourceGroupName string, name string, slot string, instanceID string, mSDeploy MSDeploy) (result AppsCreateInstanceMSDeployOperationSlotFuture, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/AppsClient.CreateInstanceMSDeployOperationSlot")
		defer func() {
			sc := -1
			if result.Response() != nil {
				sc = result.Response().StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewError("web.AppsClient", "CreateInstanceMSDeployOperationSlot", err.Error())
	}

	req, err := client.CreateInstanceMSDeployOperationSlotPreparer(ctx, resourceGroupName, name, slot, instanceID, mSDeploy)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "CreateInstanceMSDeployOperationSlot", nil, "Failure preparing request")
		return
	}

	result, err = client.CreateInstanceMSDeployOperationSlotSender(req)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "CreateInstanceMSDeployOperationSlot", result.Response(), "Failure sending request")
		return
	}

	return
}

// CreateInstanceMSDeployOperationSlotPreparer prepares the CreateInstanceMSDeployOperationSlot request.
func (client AppsClient) CreateInstanceMSDeployOperationSlotPreparer(ctx context.Context, resourceGroupName string, name string, slot string, instanceID string, mSDeploy MSDeploy) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"instanceId":        autorest.Encode("path", instanceID),
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"slot":              autorest.Encode("path", slot),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2019-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsContentType("application/json; charset=utf-8"),
		autorest.AsPut(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/instances/{instanceId}/extensions/MSDeploy", pathParameters),
		autorest.WithJSON(mSDeploy),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// CreateInstanceMSDeployOperationSlotSender sends the CreateInstanceMSDeployOperationSlot request. The method will close the
// http.Response Body if it receives an error.
func (client AppsClient) CreateInstanceMSDeployOperationSlotSender(req *http.Request) (future AppsCreateInstanceMSDeployOperationSlotFuture, err error) {
	var resp *http.Response
	resp, err = client.Send(req, azure.DoRetryWithRegistration(client.Client))
	if err != nil {
		return
	}
	future.Future, err = azure.NewFutureFromResponse(resp)
	return
}

// CreateInstanceMSDeployOperationSlotResponder handles the response to the CreateInstanceMSDeployOperationSlot request. The method always
// closes the http.Response Body.
func (client AppsClient) CreateInstanceMSDeployOperationSlotResponder(resp *http.Response) (result MSDeployStatus, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusCreated, http.StatusConflict),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// CreateMSDeployOperation description for Invoke the MSDeploy web app extension.
// Parameters:
// resourceGroupName - name of the resource group to which the resource belongs.
// name - name of web app.
// mSDeploy - details of MSDeploy operation
func (client AppsClient) CreateMSDeployOperation(ctx context.Context, resourceGroupName string, name string, mSDeploy MSDeploy) (result AppsCreateMSDeployOperationFuture, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/AppsClient.CreateMSDeployOperation")
		defer func() {
			sc := -1
			if result.Response() != nil {
				sc = result.Response().StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewError("web.AppsClient", "CreateMSDeployOperation", err.Error())
	}

	req, err := client.CreateMSDeployOperationPreparer(ctx, resourceGroupName, name, mSDeploy)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "CreateMSDeployOperation", nil, "Failure preparing request")
		return
	}

	result, err = client.CreateMSDeployOperationSender(req)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "CreateMSDeployOperation", result.Response(), "Failure sending request")
		return
	}

	return
}

// CreateMSDeployOperationPreparer prepares the CreateMSDeployOperation request.
func (client AppsClient) CreateMSDeployOperationPreparer(ctx context.Context, resourceGroupName string, name string, mSDeploy MSDeploy) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2019-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsContentType("application/json; charset=utf-8"),
		autorest.AsPut(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/extensions/MSDeploy", pathParameters),
		autorest.WithJSON(mSDeploy),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// CreateMSDeployOperationSender sends the CreateMSDeployOperation request. The method will close the
// http.Response Body if it receives an error.
func (client AppsClient) CreateMSDeployOperationSender(req *http.Request) (future AppsCreateMSDeployOperationFuture, err error) {
	var resp *http.Response
	resp, err = client.Send(req, azure.DoRetryWithRegistration(client.Client))
	if err != nil {
		return
	}
	future.Future, err = azure.NewFutureFromResponse(resp)
	return
}

// CreateMSDeployOperationResponder handles the response to the CreateMSDeployOperation request. The method always
// closes the http.Response Body.
func (client AppsClient) CreateMSDeployOperationResponder(resp *http.Response) (result MSDeployStatus, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusCreated, http.StatusConflict),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// CreateMSDeployOperationSlot description for Invoke the MSDeploy web app extension.
// Parameters:
// resourceGroupName - name of the resource group to which the resource belongs.
// name - name of web app.
// slot - name of web app slot. If not specified then will default to production slot.
// mSDeploy - details of MSDeploy operation
func (client AppsClient) CreateMSDeployOperationSlot(ctx context.Context, resourceGroupName string, name string, slot string, mSDeploy MSDeploy) (result AppsCreateMSDeployOperationSlotFuture, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/AppsClient.CreateMSDeployOperationSlot")
		defer func() {
			sc := -1
			if result.Response() != nil {
				sc = result.Response().StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewError("web.AppsClient", "CreateMSDeployOperationSlot", err.Error())
	}

	req, err := client.CreateMSDeployOperationSlotPreparer(ctx, resourceGroupName, name, slot, mSDeploy)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "CreateMSDeployOperationSlot", nil, "Failure preparing request")
		return
	}

	result, err = client.CreateMSDeployOperationSlotSender(req)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "CreateMSDeployOperationSlot", result.Response(), "Failure sending request")
		return
	}

	return
}

// CreateMSDeployOperationSlotPreparer prepares the CreateMSDeployOperationSlot request.
func (client AppsClient) CreateMSDeployOperationSlotPreparer(ctx context.Context, resourceGroupName string, name string, slot string, mSDeploy MSDeploy) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"slot":              autorest.Encode("path", slot),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2019-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsContentType("application/json; charset=utf-8"),
		autorest.AsPut(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/extensions/MSDeploy", pathParameters),
		autorest.WithJSON(mSDeploy),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// CreateMSDeployOperationSlotSender sends the CreateMSDeployOperationSlot request. The method will close the
// http.Response Body if it receives an error.
func (client AppsClient) CreateMSDeployOperationSlotSender(req *http.Request) (future AppsCreateMSDeployOperationSlotFuture, err error) {
	var resp *http.Response
	resp, err = client.Send(req, azure.DoRetryWithRegistration(client.Client))
	if err != nil {
		return
	}
	future.Future, err = azure.NewFutureFromResponse(resp)
	return
}

// CreateMSDeployOperationSlotResponder handles the response to the CreateMSDeployOperationSlot request. The method always
// closes the http.Response Body.
func (client AppsClient) CreateMSDeployOperationSlotResponder(resp *http.Response) (result MSDeployStatus, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusCreated, http.StatusConflict),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// CreateOrUpdate description for Creates a new web, mobile, or API app in an existing resource group, or updates an
// existing app.
// Parameters:
// resourceGroupName - name of the resource group to which the resource belongs.
// name - unique name of the app to create or update. To create or update a deployment slot, use the {slot}
// parameter.
// siteEnvelope - a JSON representation of the app properties. See example.
func (client AppsClient) CreateOrUpdate(ctx context.Context, resourceGroupName string, name string, siteEnvelope Site) (result AppsCreateOrUpdateFuture, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/AppsClient.CreateOrUpdate")
		defer func() {
			sc := -1
			if result.Response() != nil {
				sc = result.Response().StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}},
		{TargetValue: siteEnvelope,
			Constraints: []validation.Constraint{{Target: "siteEnvelope.SiteProperties", Name: validation.Null, Rule: false,
				Chain: []validation.Constraint{{Target: "siteEnvelope.SiteProperties.SiteConfig", Name: validation.Null, Rule: false,
					Chain: []validation.Constraint{{Target: "siteEnvelope.SiteProperties.SiteConfig.Push", Name: validation.Null, Rule: false,
						Chain: []validation.Constraint{{Target: "siteEnvelope.SiteProperties.SiteConfig.Push.PushSettingsProperties", Name: validation.Null, Rule: false,
							Chain: []validation.Constraint{{Target: "siteEnvelope.SiteProperties.SiteConfig.Push.PushSettingsProperties.IsPushEnabled", Name: validation.Null, Rule: true, Chain: nil}}},
						}},
						{Target: "siteEnvelope.SiteProperties.SiteConfig.PreWarmedInstanceCount", Name: validation.Null, Rule: false,
							Chain: []validation.Constraint{{Target: "siteEnvelope.SiteProperties.SiteConfig.PreWarmedInstanceCount", Name: validation.InclusiveMaximum, Rule: int64(10), Chain: nil},
								{Target: "siteEnvelope.SiteProperties.SiteConfig.PreWarmedInstanceCount", Name: validation.InclusiveMinimum, Rule: int64(0), Chain: nil},
							}},
					}},
					{Target: "siteEnvelope.SiteProperties.CloningInfo", Name: validation.Null, Rule: false,
						Chain: []validation.Constraint{{Target: "siteEnvelope.SiteProperties.CloningInfo.SourceWebAppID", Name: validation.Null, Rule: true, Chain: nil}}},
				}}}}}); err != nil {
		return result, validation.NewError("web.AppsClient", "CreateOrUpdate", err.Error())
	}

	req, err := client.CreateOrUpdatePreparer(ctx, resourceGroupName, name, siteEnvelope)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "CreateOrUpdate", nil, "Failure preparing request")
		return
	}

	result, err = client.CreateOrUpdateSender(req)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "CreateOrUpdate", result.Response(), "Failure sending request")
		return
	}

	return
}

// CreateOrUpdatePreparer prepares the CreateOrUpdate request.
func (client AppsClient) CreateOrUpdatePreparer(ctx context.Context, resourceGroupName string, name string, siteEnvelope Site) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2019-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsContentType("application/json; charset=utf-8"),
		autorest.AsPut(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}", pathParameters),
		autorest.WithJSON(siteEnvelope),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// CreateOrUpdateSender sends the CreateOrUpdate request. The method will close the
// http.Response Body if it receives an error.
func (client AppsClient) CreateOrUpdateSender(req *http.Request) (future AppsCreateOrUpdateFuture, err error) {
	var resp *http.Response
	resp, err = client.Send(req, azure.DoRetryWithRegistration(client.Client))
	if err != nil {
		return
	}
	future.Future, err = azure.NewFutureFromResponse(resp)
	return
}

// CreateOrUpdateResponder handles the response to the CreateOrUpdate request. The method always
// closes the http.Response Body.
func (client AppsClient) CreateOrUpdateResponder(resp *http.Response) (result Site, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusAccepted),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// CreateOrUpdateConfiguration description for Updates the configuration of an app.
// Parameters:
// resourceGroupName - name of the resource group to which the resource belongs.
// name - name of the app.
// siteConfig - JSON representation of a SiteConfig object. See example.
func (client AppsClient) CreateOrUpdateConfiguration(ctx context.Context, resourceGroupName string, name string, siteConfig SiteConfigResource) (result SiteConfigResource, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/AppsClient.CreateOrUpdateConfiguration")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}},
		{TargetValue: siteConfig,
			Constraints: []validation.Constraint{{Target: "siteConfig.SiteConfig", Name: validation.Null, Rule: false,
				Chain: []validation.Constraint{{Target: "siteConfig.SiteConfig.Push", Name: validation.Null, Rule: false,
					Chain: []validation.Constraint{{Target: "siteConfig.SiteConfig.Push.PushSettingsProperties", Name: validation.Null, Rule: false,
						Chain: []validation.Constraint{{Target: "siteConfig.SiteConfig.Push.PushSettingsProperties.IsPushEnabled", Name: validation.Null, Rule: true, Chain: nil}}},
					}},
					{Target: "siteConfig.SiteConfig.PreWarmedInstanceCount", Name: validation.Null, Rule: false,
						Chain: []validation.Constraint{{Target: "siteConfig.SiteConfig.PreWarmedInstanceCount", Name: validation.InclusiveMaximum, Rule: int64(10), Chain: nil},
							{Target: "siteConfig.SiteConfig.PreWarmedInstanceCount", Name: validation.InclusiveMinimum, Rule: int64(0), Chain: nil},
						}},
				}}}}}); err != nil {
		return result, validation.NewError("web.AppsClient", "CreateOrUpdateConfiguration", err.Error())
	}

	req, err := client.CreateOrUpdateConfigurationPreparer(ctx, resourceGroupName, name, siteConfig)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "CreateOrUpdateConfiguration", nil, "Failure preparing request")
		return
	}

	resp, err := client.CreateOrUpdateConfigurationSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.AppsClient", "CreateOrUpdateConfiguration", resp, "Failure sending request")
		return
	}

	result, err = client.CreateOrUpdateConfigurationResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "CreateOrUpdateConfiguration", resp, "Failure responding to request")
	}

	return
}

// CreateOrUpdateConfigurationPreparer prepares the CreateOrUpdateConfiguration request.
func (client AppsClient) CreateOrUpdateConfigurationPreparer(ctx context.Context, resourceGroupName string, name string, siteConfig SiteConfigResource) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2019-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsContentType("application/json; charset=utf-8"),
		autorest.AsPut(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/config/web", pathParameters),
		autorest.WithJSON(siteConfig),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// CreateOrUpdateConfigurationSender sends the CreateOrUpdateConfiguration request. The method will close the
// http.Response Body if it receives an error.
func (client AppsClient) CreateOrUpdateConfigurationSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// CreateOrUpdateConfigurationResponder handles the response to the CreateOrUpdateConfiguration request. The method always
// closes the http.Response Body.
func (client AppsClient) CreateOrUpdateConfigurationResponder(resp *http.Response) (result SiteConfigResource, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// CreateOrUpdateConfigurationSlot description for Updates the configuration of an app.
// Parameters:
// resourceGroupName - name of the resource group to which the resource belongs.
// name - name of the app.
// siteConfig - JSON representation of a SiteConfig object. See example.
// slot - name of the deployment slot. If a slot is not specified, the API will update configuration for the
// production slot.
func (client AppsClient) CreateOrUpdateConfigurationSlot(ctx context.Context, resourceGroupName string, name string, siteConfig SiteConfigResource, slot string) (result SiteConfigResource, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/AppsClient.CreateOrUpdateConfigurationSlot")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}},
		{TargetValue: siteConfig,
			Constraints: []validation.Constraint{{Target: "siteConfig.SiteConfig", Name: validation.Null, Rule: false,
				Chain: []validation.Constraint{{Target: "siteConfig.SiteConfig.Push", Name: validation.Null, Rule: false,
					Chain: []validation.Constraint{{Target: "siteConfig.SiteConfig.Push.PushSettingsProperties", Name: validation.Null, Rule: false,
						Chain: []validation.Constraint{{Target: "siteConfig.SiteConfig.Push.PushSettingsProperties.IsPushEnabled", Name: validation.Null, Rule: true, Chain: nil}}},
					}},
					{Target: "siteConfig.SiteConfig.PreWarmedInstanceCount", Name: validation.Null, Rule: false,
						Chain: []validation.Constraint{{Target: "siteConfig.SiteConfig.PreWarmedInstanceCount", Name: validation.InclusiveMaximum, Rule: int64(10), Chain: nil},
							{Target: "siteConfig.SiteConfig.PreWarmedInstanceCount", Name: validation.InclusiveMinimum, Rule: int64(0), Chain: nil},
						}},
				}}}}}); err != nil {
		return result, validation.NewError("web.AppsClient", "CreateOrUpdateConfigurationSlot", err.Error())
	}

	req, err := client.CreateOrUpdateConfigurationSlotPreparer(ctx, resourceGroupName, name, siteConfig, slot)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "CreateOrUpdateConfigurationSlot", nil, "Failure preparing request")
		return
	}

	resp, err := client.CreateOrUpdateConfigurationSlotSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.AppsClient", "CreateOrUpdateConfigurationSlot", resp, "Failure sending request")
		return
	}

	result, err = client.CreateOrUpdateConfigurationSlotResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "CreateOrUpdateConfigurationSlot", resp, "Failure responding to request")
	}

	return
}

// CreateOrUpdateConfigurationSlotPreparer prepares the CreateOrUpdateConfigurationSlot request.
func (client AppsClient) CreateOrUpdateConfigurationSlotPreparer(ctx context.Context, resourceGroupName string, name string, siteConfig SiteConfigResource, slot string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"slot":              autorest.Encode("path", slot),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2019-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsContentType("application/json; charset=utf-8"),
		autorest.AsPut(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/config/web", pathParameters),
		autorest.WithJSON(siteConfig),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// CreateOrUpdateConfigurationSlotSender sends the CreateOrUpdateConfigurationSlot request. The method will close the
// http.Response Body if it receives an error.
func (client AppsClient) CreateOrUpdateConfigurationSlotSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// CreateOrUpdateConfigurationSlotResponder handles the response to the CreateOrUpdateConfigurationSlot request. The method always
// closes the http.Response Body.
func (client AppsClient) CreateOrUpdateConfigurationSlotResponder(resp *http.Response) (result SiteConfigResource, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// CreateOrUpdateDomainOwnershipIdentifier description for Creates a domain ownership identifier for web app, or
// updates an existing ownership identifier.
// Parameters:
// resourceGroupName - name of the resource group to which the resource belongs.
// name - name of the app.
// domainOwnershipIdentifierName - name of domain ownership identifier.
// domainOwnershipIdentifier - a JSON representation of the domain ownership properties.
func (client AppsClient) CreateOrUpdateDomainOwnershipIdentifier(ctx context.Context, resourceGroupName string, name string, domainOwnershipIdentifierName string, domainOwnershipIdentifier Identifier) (result Identifier, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/AppsClient.CreateOrUpdateDomainOwnershipIdentifier")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewError("web.AppsClient", "CreateOrUpdateDomainOwnershipIdentifier", err.Error())
	}

	req, err := client.CreateOrUpdateDomainOwnershipIdentifierPreparer(ctx, resourceGroupName, name, domainOwnershipIdentifierName, domainOwnershipIdentifier)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "CreateOrUpdateDomainOwnershipIdentifier", nil, "Failure preparing request")
		return
	}

	resp, err := client.CreateOrUpdateDomainOwnershipIdentifierSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.AppsClient", "CreateOrUpdateDomainOwnershipIdentifier", resp, "Failure sending request")
		return
	}

	result, err = client.CreateOrUpdateDomainOwnershipIdentifierResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "CreateOrUpdateDomainOwnershipIdentifier", resp, "Failure responding to request")
	}

	return
}

// CreateOrUpdateDomainOwnershipIdentifierPreparer prepares the CreateOrUpdateDomainOwnershipIdentifier request.
func (client AppsClient) CreateOrUpdateDomainOwnershipIdentifierPreparer(ctx context.Context, resourceGroupName string, name string, domainOwnershipIdentifierName string, domainOwnershipIdentifier Identifier) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"domainOwnershipIdentifierName": autorest.Encode("path", domainOwnershipIdentifierName),
		"name":                          autorest.Encode("path", name),
		"resourceGroupName":             autorest.Encode("path", resourceGroupName),
		"subscriptionId":                autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2019-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsContentType("application/json; charset=utf-8"),
		autorest.AsPut(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/domainOwnershipIdentifiers/{domainOwnershipIdentifierName}", pathParameters),
		autorest.WithJSON(domainOwnershipIdentifier),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// CreateOrUpdateDomainOwnershipIdentifierSender sends the CreateOrUpdateDomainOwnershipIdentifier request. The method will close the
// http.Response Body if it receives an error.
func (client AppsClient) CreateOrUpdateDomainOwnershipIdentifierSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// CreateOrUpdateDomainOwnershipIdentifierResponder handles the response to the CreateOrUpdateDomainOwnershipIdentifier request. The method always
// closes the http.Response Body.
func (client AppsClient) CreateOrUpdateDomainOwnershipIdentifierResponder(resp *http.Response) (result Identifier, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// CreateOrUpdateDomainOwnershipIdentifierSlot description for Creates a domain ownership identifier for web app, or
// updates an existing ownership identifier.
// Parameters:
// resourceGroupName - name of the resource group to which the resource belongs.
// name - name of the app.
// domainOwnershipIdentifierName - name of domain ownership identifier.
// domainOwnershipIdentifier - a JSON representation of the domain ownership properties.
// slot - name of the deployment slot. If a slot is not specified, the API will delete the binding for the
// production slot.
func (client AppsClient) CreateOrUpdateDomainOwnershipIdentifierSlot(ctx context.Context, resourceGroupName string, name string, domainOwnershipIdentifierName string, domainOwnershipIdentifier Identifier, slot string) (result Identifier, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/AppsClient.CreateOrUpdateDomainOwnershipIdentifierSlot")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewError("web.AppsClient", "CreateOrUpdateDomainOwnershipIdentifierSlot", err.Error())
	}

	req, err := client.CreateOrUpdateDomainOwnershipIdentifierSlotPreparer(ctx, resourceGroupName, name, domainOwnershipIdentifierName, domainOwnershipIdentifier, slot)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "CreateOrUpdateDomainOwnershipIdentifierSlot", nil, "Failure preparing request")
		return
	}

	resp, err := client.CreateOrUpdateDomainOwnershipIdentifierSlotSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.AppsClient", "CreateOrUpdateDomainOwnershipIdentifierSlot", resp, "Failure sending request")
		return
	}

	result, err = client.CreateOrUpdateDomainOwnershipIdentifierSlotResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "CreateOrUpdateDomainOwnershipIdentifierSlot", resp, "Failure responding to request")
	}

	return
}

// CreateOrUpdateDomainOwnershipIdentifierSlotPreparer prepares the CreateOrUpdateDomainOwnershipIdentifierSlot request.
func (client AppsClient) CreateOrUpdateDomainOwnershipIdentifierSlotPreparer(ctx context.Context, resourceGroupName string, name string, domainOwnershipIdentifierName string, domainOwnershipIdentifier Identifier, slot string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"domainOwnershipIdentifierName": autorest.Encode("path", domainOwnershipIdentifierName),
		"name":                          autorest.Encode("path", name),
		"resourceGroupName":             autorest.Encode("path", resourceGroupName),
		"slot":                          autorest.Encode("path", slot),
		"subscriptionId":                autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2019-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsContentType("application/json; charset=utf-8"),
		autorest.AsPut(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/domainOwnershipIdentifiers/{domainOwnershipIdentifierName}", pathParameters),
		autorest.WithJSON(domainOwnershipIdentifier),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// CreateOrUpdateDomainOwnershipIdentifierSlotSender sends the CreateOrUpdateDomainOwnershipIdentifierSlot request. The method will close the
// http.Response Body if it receives an error.
func (client AppsClient) CreateOrUpdateDomainOwnershipIdentifierSlotSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// CreateOrUpdateDomainOwnershipIdentifierSlotResponder handles the response to the CreateOrUpdateDomainOwnershipIdentifierSlot request. The method always
// closes the http.Response Body.
func (client AppsClient) CreateOrUpdateDomainOwnershipIdentifierSlotResponder(resp *http.Response) (result Identifier, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// CreateOrUpdateFunctionSecret description for Add or update a function secret.
// Parameters:
// resourceGroupName - name of the resource group to which the resource belongs.
// name - site name.
// functionName - the name of the function.
// keyName - the name of the key.
// key - the key to create or update
func (client AppsClient) CreateOrUpdateFunctionSecret(ctx context.Context, resourceGroupName string, name string, functionName string, keyName string, key KeyInfo) (result KeyInfo, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/AppsClient.CreateOrUpdateFunctionSecret")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewError("web.AppsClient", "CreateOrUpdateFunctionSecret", err.Error())
	}

	req, err := client.CreateOrUpdateFunctionSecretPreparer(ctx, resourceGroupName, name, functionName, keyName, key)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "CreateOrUpdateFunctionSecret", nil, "Failure preparing request")
		return
	}

	resp, err := client.CreateOrUpdateFunctionSecretSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.AppsClient", "CreateOrUpdateFunctionSecret", resp, "Failure sending request")
		return
	}

	result, err = client.CreateOrUpdateFunctionSecretResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "CreateOrUpdateFunctionSecret", resp, "Failure responding to request")
	}

	return
}

// CreateOrUpdateFunctionSecretPreparer prepares the CreateOrUpdateFunctionSecret request.
func (client AppsClient) CreateOrUpdateFunctionSecretPreparer(ctx context.Context, resourceGroupName string, name string, functionName string, keyName string, key KeyInfo) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"functionName":      autorest.Encode("path", functionName),
		"keyName":           autorest.Encode("path", keyName),
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2019-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsContentType("application/json; charset=utf-8"),
		autorest.AsPut(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/functions/{functionName}/keys/{keyName}", pathParameters),
		autorest.WithJSON(key),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// CreateOrUpdateFunctionSecretSender sends the CreateOrUpdateFunctionSecret request. The method will close the
// http.Response Body if it receives an error.
func (client AppsClient) CreateOrUpdateFunctionSecretSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// CreateOrUpdateFunctionSecretResponder handles the response to the CreateOrUpdateFunctionSecret request. The method always
// closes the http.Response Body.
func (client AppsClient) CreateOrUpdateFunctionSecretResponder(resp *http.Response) (result KeyInfo, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusCreated),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// CreateOrUpdateFunctionSecretSlot description for Add or update a function secret.
// Parameters:
// resourceGroupName - name of the resource group to which the resource belongs.
// name - site name.
// functionName - the name of the function.
// keyName - the name of the key.
// slot - name of the deployment slot.
// key - the key to create or update
func (client AppsClient) CreateOrUpdateFunctionSecretSlot(ctx context.Context, resourceGroupName string, name string, functionName string, keyName string, slot string, key KeyInfo) (result KeyInfo, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/AppsClient.CreateOrUpdateFunctionSecretSlot")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewError("web.AppsClient", "CreateOrUpdateFunctionSecretSlot", err.Error())
	}

	req, err := client.CreateOrUpdateFunctionSecretSlotPreparer(ctx, resourceGroupName, name, functionName, keyName, slot, key)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "CreateOrUpdateFunctionSecretSlot", nil, "Failure preparing request")
		return
	}

	resp, err := client.CreateOrUpdateFunctionSecretSlotSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.AppsClient", "CreateOrUpdateFunctionSecretSlot", resp, "Failure sending request")
		return
	}

	result, err = client.CreateOrUpdateFunctionSecretSlotResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "CreateOrUpdateFunctionSecretSlot", resp, "Failure responding to request")
	}

	return
}

// CreateOrUpdateFunctionSecretSlotPreparer prepares the CreateOrUpdateFunctionSecretSlot request.
func (client AppsClient) CreateOrUpdateFunctionSecretSlotPreparer(ctx context.Context, resourceGroupName string, name string, functionName string, keyName string, slot string, key KeyInfo) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"functionName":      autorest.Encode("path", functionName),
		"keyName":           autorest.Encode("path", keyName),
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"slot":              autorest.Encode("path", slot),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2019-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsContentType("application/json; charset=utf-8"),
		autorest.AsPut(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/functions/{functionName}/keys/{keyName}", pathParameters),
		autorest.WithJSON(key),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// CreateOrUpdateFunctionSecretSlotSender sends the CreateOrUpdateFunctionSecretSlot request. The method will close the
// http.Response Body if it receives an error.
func (client AppsClient) CreateOrUpdateFunctionSecretSlotSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// CreateOrUpdateFunctionSecretSlotResponder handles the response to the CreateOrUpdateFunctionSecretSlot request. The method always
// closes the http.Response Body.
func (client AppsClient) CreateOrUpdateFunctionSecretSlotResponder(resp *http.Response) (result KeyInfo, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusCreated),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// CreateOrUpdateHostNameBinding description for Creates a hostname binding for an app.
// Parameters:
// resourceGroupName - name of the resource group to which the resource belongs.
// name - name of the app.
// hostName - hostname in the hostname binding.
// hostNameBinding - binding details. This is the JSON representation of a HostNameBinding object.
func (client AppsClient) CreateOrUpdateHostNameBinding(ctx context.Context, resourceGroupName string, name string, hostName string, hostNameBinding HostNameBinding) (result HostNameBinding, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/AppsClient.CreateOrUpdateHostNameBinding")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewError("web.AppsClient", "CreateOrUpdateHostNameBinding", err.Error())
	}

	req, err := client.CreateOrUpdateHostNameBindingPreparer(ctx, resourceGroupName, name, hostName, hostNameBinding)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "CreateOrUpdateHostNameBinding", nil, "Failure preparing request")
		return
	}

	resp, err := client.CreateOrUpdateHostNameBindingSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.AppsClient", "CreateOrUpdateHostNameBinding", resp, "Failure sending request")
		return
	}

	result, err = client.CreateOrUpdateHostNameBindingResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "CreateOrUpdateHostNameBinding", resp, "Failure responding to request")
	}

	return
}

// CreateOrUpdateHostNameBindingPreparer prepares the CreateOrUpdateHostNameBinding request.
func (client AppsClient) CreateOrUpdateHostNameBindingPreparer(ctx context.Context, resourceGroupName string, name string, hostName string, hostNameBinding HostNameBinding) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"hostName":          autorest.Encode("path", hostName),
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2019-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsContentType("application/json; charset=utf-8"),
		autorest.AsPut(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/hostNameBindings/{hostName}", pathParameters),
		autorest.WithJSON(hostNameBinding),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// CreateOrUpdateHostNameBindingSender sends the CreateOrUpdateHostNameBinding request. The method will close the
// http.Response Body if it receives an error.
func (client AppsClient) CreateOrUpdateHostNameBindingSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// CreateOrUpdateHostNameBindingResponder handles the response to the CreateOrUpdateHostNameBinding request. The method always
// closes the http.Response Body.
func (client AppsClient) CreateOrUpdateHostNameBindingResponder(resp *http.Response) (result HostNameBinding, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// CreateOrUpdateHostNameBindingSlot description for Creates a hostname binding for an app.
// Parameters:
// resourceGroupName - name of the resource group to which the resource belongs.
// name - name of the app.
// hostName - hostname in the hostname binding.
// hostNameBinding - binding details. This is the JSON representation of a HostNameBinding object.
// slot - name of the deployment slot. If a slot is not specified, the API will create a binding for the
// production slot.
func (client AppsClient) CreateOrUpdateHostNameBindingSlot(ctx context.Context, resourceGroupName string, name string, hostName string, hostNameBinding HostNameBinding, slot string) (result HostNameBinding, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/AppsClient.CreateOrUpdateHostNameBindingSlot")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewError("web.AppsClient", "CreateOrUpdateHostNameBindingSlot", err.Error())
	}

	req, err := client.CreateOrUpdateHostNameBindingSlotPreparer(ctx, resourceGroupName, name, hostName, hostNameBinding, slot)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "CreateOrUpdateHostNameBindingSlot", nil, "Failure preparing request")
		return
	}

	resp, err := client.CreateOrUpdateHostNameBindingSlotSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.AppsClient", "CreateOrUpdateHostNameBindingSlot", resp, "Failure sending request")
		return
	}

	result, err = client.CreateOrUpdateHostNameBindingSlotResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "CreateOrUpdateHostNameBindingSlot", resp, "Failure responding to request")
	}

	return
}

// CreateOrUpdateHostNameBindingSlotPreparer prepares the CreateOrUpdateHostNameBindingSlot request.
func (client AppsClient) CreateOrUpdateHostNameBindingSlotPreparer(ctx context.Context, resourceGroupName string, name string, hostName string, hostNameBinding HostNameBinding, slot string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"hostName":          autorest.Encode("path", hostName),
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"slot":              autorest.Encode("path", slot),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2019-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsContentType("application/json; charset=utf-8"),
		autorest.AsPut(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/hostNameBindings/{hostName}", pathParameters),
		autorest.WithJSON(hostNameBinding),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// CreateOrUpdateHostNameBindingSlotSender sends the CreateOrUpdateHostNameBindingSlot request. The method will close the
// http.Response Body if it receives an error.
func (client AppsClient) CreateOrUpdateHostNameBindingSlotSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// CreateOrUpdateHostNameBindingSlotResponder handles the response to the CreateOrUpdateHostNameBindingSlot request. The method always
// closes the http.Response Body.
func (client AppsClient) CreateOrUpdateHostNameBindingSlotResponder(resp *http.Response) (result HostNameBinding, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// CreateOrUpdateHostSecret description for Add or update a host level secret.
// Parameters:
// resourceGroupName - name of the resource group to which the resource belongs.
// name - site name.
// keyType - the type of host key.
// keyName - the name of the key.
// key - the key to create or update
func (client AppsClient) CreateOrUpdateHostSecret(ctx context.Context, resourceGroupName string, name string, keyType string, keyName string, key KeyInfo) (result KeyInfo, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/AppsClient.CreateOrUpdateHostSecret")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewError("web.AppsClient", "CreateOrUpdateHostSecret", err.Error())
	}

	req, err := client.CreateOrUpdateHostSecretPreparer(ctx, resourceGroupName, name, keyType, keyName, key)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "CreateOrUpdateHostSecret", nil, "Failure preparing request")
		return
	}

	resp, err := client.CreateOrUpdateHostSecretSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.AppsClient", "CreateOrUpdateHostSecret", resp, "Failure sending request")
		return
	}

	result, err = client.CreateOrUpdateHostSecretResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "CreateOrUpdateHostSecret", resp, "Failure responding to request")
	}

	return
}

// CreateOrUpdateHostSecretPreparer prepares the CreateOrUpdateHostSecret request.
func (client AppsClient) CreateOrUpdateHostSecretPreparer(ctx context.Context, resourceGroupName string, name string, keyType string, keyName string, key KeyInfo) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"keyName":           autorest.Encode("path", keyName),
		"keyType":           autorest.Encode("path", keyType),
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2019-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsContentType("application/json; charset=utf-8"),
		autorest.AsPut(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/host/default/{keyType}/{keyName}", pathParameters),
		autorest.WithJSON(key),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// CreateOrUpdateHostSecretSender sends the CreateOrUpdateHostSecret request. The method will close the
// http.Response Body if it receives an error.
func (client AppsClient) CreateOrUpdateHostSecretSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// CreateOrUpdateHostSecretResponder handles the response to the CreateOrUpdateHostSecret request. The method always
// closes the http.Response Body.
func (client AppsClient) CreateOrUpdateHostSecretResponder(resp *http.Response) (result KeyInfo, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusCreated),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// CreateOrUpdateHostSecretSlot description for Add or update a host level secret.
// Parameters:
// resourceGroupName - name of the resource group to which the resource belongs.
// name - site name.
// keyType - the type of host key.
// keyName - the name of the key.
// slot - name of the deployment slot.
// key - the key to create or update
func (client AppsClient) CreateOrUpdateHostSecretSlot(ctx context.Context, resourceGroupName string, name string, keyType string, keyName string, slot string, key KeyInfo) (result KeyInfo, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/AppsClient.CreateOrUpdateHostSecretSlot")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewError("web.AppsClient", "CreateOrUpdateHostSecretSlot", err.Error())
	}

	req, err := client.CreateOrUpdateHostSecretSlotPreparer(ctx, resourceGroupName, name, keyType, keyName, slot, key)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "CreateOrUpdateHostSecretSlot", nil, "Failure preparing request")
		return
	}

	resp, err := client.CreateOrUpdateHostSecretSlotSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.AppsClient", "CreateOrUpdateHostSecretSlot", resp, "Failure sending request")
		return
	}

	result, err = client.CreateOrUpdateHostSecretSlotResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "CreateOrUpdateHostSecretSlot", resp, "Failure responding to request")
	}

	return
}

// CreateOrUpdateHostSecretSlotPreparer prepares the CreateOrUpdateHostSecretSlot request.
func (client AppsClient) CreateOrUpdateHostSecretSlotPreparer(ctx context.Context, resourceGroupName string, name string, keyType string, keyName string, slot string, key KeyInfo) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"keyName":           autorest.Encode("path", keyName),
		"keyType":           autorest.Encode("path", keyType),
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"slot":              autorest.Encode("path", slot),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2019-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsContentType("application/json; charset=utf-8"),
		autorest.AsPut(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/host/default/{keyType}/{keyName}", pathParameters),
		autorest.WithJSON(key),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// CreateOrUpdateHostSecretSlotSender sends the CreateOrUpdateHostSecretSlot request. The method will close the
// http.Response Body if it receives an error.
func (client AppsClient) CreateOrUpdateHostSecretSlotSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// CreateOrUpdateHostSecretSlotResponder handles the response to the CreateOrUpdateHostSecretSlot request. The method always
// closes the http.Response Body.
func (client AppsClient) CreateOrUpdateHostSecretSlotResponder(resp *http.Response) (result KeyInfo, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusCreated),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// CreateOrUpdateHybridConnection description for Creates a new Hybrid Connection using a Service Bus relay.
// Parameters:
// resourceGroupName - name of the resource group to which the resource belongs.
// name - the name of the web app.
// namespaceName - the namespace for this hybrid connection.
// relayName - the relay name for this hybrid connection.
// connectionEnvelope - the details of the hybrid connection.
func (client AppsClient) CreateOrUpdateHybridConnection(ctx context.Context, resourceGroupName string, name string, namespaceName string, relayName string, connectionEnvelope HybridConnection) (result HybridConnection, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/AppsClient.CreateOrUpdateHybridConnection")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewError("web.AppsClient", "CreateOrUpdateHybridConnection", err.Error())
	}

	req, err := client.CreateOrUpdateHybridConnectionPreparer(ctx, resourceGroupName, name, namespaceName, relayName, connectionEnvelope)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "CreateOrUpdateHybridConnection", nil, "Failure preparing request")
		return
	}

	resp, err := client.CreateOrUpdateHybridConnectionSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.AppsClient", "CreateOrUpdateHybridConnection", resp, "Failure sending request")
		return
	}

	result, err = client.CreateOrUpdateHybridConnectionResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "CreateOrUpdateHybridConnection", resp, "Failure responding to request")
	}

	return
}

// CreateOrUpdateHybridConnectionPreparer prepares the CreateOrUpdateHybridConnection request.
func (client AppsClient) CreateOrUpdateHybridConnectionPreparer(ctx context.Context, resourceGroupName string, name string, namespaceName string, relayName string, connectionEnvelope HybridConnection) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"namespaceName":     autorest.Encode("path", namespaceName),
		"relayName":         autorest.Encode("path", relayName),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2019-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsContentType("application/json; charset=utf-8"),
		autorest.AsPut(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/hybridConnectionNamespaces/{namespaceName}/relays/{relayName}", pathParameters),
		autorest.WithJSON(connectionEnvelope),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// CreateOrUpdateHybridConnectionSender sends the CreateOrUpdateHybridConnection request. The method will close the
// http.Response Body if it receives an error.
func (client AppsClient) CreateOrUpdateHybridConnectionSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// CreateOrUpdateHybridConnectionResponder handles the response to the CreateOrUpdateHybridConnection request. The method always
// closes the http.Response Body.
func (client AppsClient) CreateOrUpdateHybridConnectionResponder(resp *http.Response) (result HybridConnection, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// CreateOrUpdateHybridConnectionSlot description for Creates a new Hybrid Connection using a Service Bus relay.
// Parameters:
// resourceGroupName - name of the resource group to which the resource belongs.
// name - the name of the web app.
// namespaceName - the namespace for this hybrid connection.
// relayName - the relay name for this hybrid connection.
// connectionEnvelope - the details of the hybrid connection.
// slot - the name of the slot for the web app.
func (client AppsClient) CreateOrUpdateHybridConnectionSlot(ctx context.Context, resourceGroupName string, name string, namespaceName string, relayName string, connectionEnvelope HybridConnection, slot string) (result HybridConnection, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/AppsClient.CreateOrUpdateHybridConnectionSlot")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewError("web.AppsClient", "CreateOrUpdateHybridConnectionSlot", err.Error())
	}

	req, err := client.CreateOrUpdateHybridConnectionSlotPreparer(ctx, resourceGroupName, name, namespaceName, relayName, connectionEnvelope, slot)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "CreateOrUpdateHybridConnectionSlot", nil, "Failure preparing request")
		return
	}

	resp, err := client.CreateOrUpdateHybridConnectionSlotSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.AppsClient", "CreateOrUpdateHybridConnectionSlot", resp, "Failure sending request")
		return
	}

	result, err = client.CreateOrUpdateHybridConnectionSlotResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "CreateOrUpdateHybridConnectionSlot", resp, "Failure responding to request")
	}

	return
}

// CreateOrUpdateHybridConnectionSlotPreparer prepares the CreateOrUpdateHybridConnectionSlot request.
func (client AppsClient) CreateOrUpdateHybridConnectionSlotPreparer(ctx context.Context, resourceGroupName string, name string, namespaceName string, relayName string, connectionEnvelope HybridConnection, slot string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"namespaceName":     autorest.Encode("path", namespaceName),
		"relayName":         autorest.Encode("path", relayName),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"slot":              autorest.Encode("path", slot),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2019-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsContentType("application/json; charset=utf-8"),
		autorest.AsPut(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/hybridConnectionNamespaces/{namespaceName}/relays/{relayName}", pathParameters),
		autorest.WithJSON(connectionEnvelope),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// CreateOrUpdateHybridConnectionSlotSender sends the CreateOrUpdateHybridConnectionSlot request. The method will close the
// http.Response Body if it receives an error.
func (client AppsClient) CreateOrUpdateHybridConnectionSlotSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// CreateOrUpdateHybridConnectionSlotResponder handles the response to the CreateOrUpdateHybridConnectionSlot request. The method always
// closes the http.Response Body.
func (client AppsClient) CreateOrUpdateHybridConnectionSlotResponder(resp *http.Response) (result HybridConnection, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// CreateOrUpdatePublicCertificate description for Creates a hostname binding for an app.
// Parameters:
// resourceGroupName - name of the resource group to which the resource belongs.
// name - name of the app.
// publicCertificateName - public certificate name.
// publicCertificate - public certificate details. This is the JSON representation of a PublicCertificate
// object.
func (client AppsClient) CreateOrUpdatePublicCertificate(ctx context.Context, resourceGroupName string, name string, publicCertificateName string, publicCertificate PublicCertificate) (result PublicCertificate, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/AppsClient.CreateOrUpdatePublicCertificate")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewError("web.AppsClient", "CreateOrUpdatePublicCertificate", err.Error())
	}

	req, err := client.CreateOrUpdatePublicCertificatePreparer(ctx, resourceGroupName, name, publicCertificateName, publicCertificate)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "CreateOrUpdatePublicCertificate", nil, "Failure preparing request")
		return
	}

	resp, err := client.CreateOrUpdatePublicCertificateSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.AppsClient", "CreateOrUpdatePublicCertificate", resp, "Failure sending request")
		return
	}

	result, err = client.CreateOrUpdatePublicCertificateResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "CreateOrUpdatePublicCertificate", resp, "Failure responding to request")
	}

	return
}

// CreateOrUpdatePublicCertificatePreparer prepares the CreateOrUpdatePublicCertificate request.
func (client AppsClient) CreateOrUpdatePublicCertificatePreparer(ctx context.Context, resourceGroupName string, name string, publicCertificateName string, publicCertificate PublicCertificate) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":                  autorest.Encode("path", name),
		"publicCertificateName": autorest.Encode("path", publicCertificateName),
		"resourceGroupName":     autorest.Encode("path", resourceGroupName),
		"subscriptionId":        autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2019-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsContentType("application/json; charset=utf-8"),
		autorest.AsPut(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/publicCertificates/{publicCertificateName}", pathParameters),
		autorest.WithJSON(publicCertificate),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// CreateOrUpdatePublicCertificateSender sends the CreateOrUpdatePublicCertificate request. The method will close the
// http.Response Body if it receives an error.
func (client AppsClient) CreateOrUpdatePublicCertificateSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// CreateOrUpdatePublicCertificateResponder handles the response to the CreateOrUpdatePublicCertificate request. The method always
// closes the http.Response Body.
func (client AppsClient) CreateOrUpdatePublicCertificateResponder(resp *http.Response) (result PublicCertificate, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// CreateOrUpdatePublicCertificateSlot description for Creates a hostname binding for an app.
// Parameters:
// resourceGroupName - name of the resource group to which the resource belongs.
// name - name of the app.
// publicCertificateName - public certificate name.
// publicCertificate - public certificate details. This is the JSON representation of a PublicCertificate
// object.
// slot - name of the deployment slot. If a slot is not specified, the API will create a binding for the
// production slot.
func (client AppsClient) CreateOrUpdatePublicCertificateSlot(ctx context.Context, resourceGroupName string, name string, publicCertificateName string, publicCertificate PublicCertificate, slot string) (result PublicCertificate, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/AppsClient.CreateOrUpdatePublicCertificateSlot")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewError("web.AppsClient", "CreateOrUpdatePublicCertificateSlot", err.Error())
	}

	req, err := client.CreateOrUpdatePublicCertificateSlotPreparer(ctx, resourceGroupName, name, publicCertificateName, publicCertificate, slot)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "CreateOrUpdatePublicCertificateSlot", nil, "Failure preparing request")
		return
	}

	resp, err := client.CreateOrUpdatePublicCertificateSlotSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.AppsClient", "CreateOrUpdatePublicCertificateSlot", resp, "Failure sending request")
		return
	}

	result, err = client.CreateOrUpdatePublicCertificateSlotResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "CreateOrUpdatePublicCertificateSlot", resp, "Failure responding to request")
	}

	return
}

// CreateOrUpdatePublicCertificateSlotPreparer prepares the CreateOrUpdatePublicCertificateSlot request.
func (client AppsClient) CreateOrUpdatePublicCertificateSlotPreparer(ctx context.Context, resourceGroupName string, name string, publicCertificateName string, publicCertificate PublicCertificate, slot string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":                  autorest.Encode("path", name),
		"publicCertificateName": autorest.Encode("path", publicCertificateName),
		"resourceGroupName":     autorest.Encode("path", resourceGroupName),
		"slot":                  autorest.Encode("path", slot),
		"subscriptionId":        autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2019-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsContentType("application/json; charset=utf-8"),
		autorest.AsPut(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/publicCertificates/{publicCertificateName}", pathParameters),
		autorest.WithJSON(publicCertificate),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// CreateOrUpdatePublicCertificateSlotSender sends the CreateOrUpdatePublicCertificateSlot request. The method will close the
// http.Response Body if it receives an error.
func (client AppsClient) CreateOrUpdatePublicCertificateSlotSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// CreateOrUpdatePublicCertificateSlotResponder handles the response to the CreateOrUpdatePublicCertificateSlot request. The method always
// closes the http.Response Body.
func (client AppsClient) CreateOrUpdatePublicCertificateSlotResponder(resp *http.Response) (result PublicCertificate, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// CreateOrUpdateRelayServiceConnection description for Creates a new hybrid connection configuration (PUT), or updates
// an existing one (PATCH).
// Parameters:
// resourceGroupName - name of the resource group to which the resource belongs.
// name - name of the app.
// entityName - name of the hybrid connection configuration.
// connectionEnvelope - details of the hybrid connection configuration.
func (client AppsClient) CreateOrUpdateRelayServiceConnection(ctx context.Context, resourceGroupName string, name string, entityName string, connectionEnvelope RelayServiceConnectionEntity) (result RelayServiceConnectionEntity, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/AppsClient.CreateOrUpdateRelayServiceConnection")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewError("web.AppsClient", "CreateOrUpdateRelayServiceConnection", err.Error())
	}

	req, err := client.CreateOrUpdateRelayServiceConnectionPreparer(ctx, resourceGroupName, name, entityName, connectionEnvelope)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "CreateOrUpdateRelayServiceConnection", nil, "Failure preparing request")
		return
	}

	resp, err := client.CreateOrUpdateRelayServiceConnectionSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.AppsClient", "CreateOrUpdateRelayServiceConnection", resp, "Failure sending request")
		return
	}

	result, err = client.CreateOrUpdateRelayServiceConnectionResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "CreateOrUpdateRelayServiceConnection", resp, "Failure responding to request")
	}

	return
}

// CreateOrUpdateRelayServiceConnectionPreparer prepares the CreateOrUpdateRelayServiceConnection request.
func (client AppsClient) CreateOrUpdateRelayServiceConnectionPreparer(ctx context.Context, resourceGroupName string, name string, entityName string, connectionEnvelope RelayServiceConnectionEntity) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"entityName":        autorest.Encode("path", entityName),
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2019-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsContentType("application/json; charset=utf-8"),
		autorest.AsPut(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/hybridconnection/{entityName}", pathParameters),
		autorest.WithJSON(connectionEnvelope),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// CreateOrUpdateRelayServiceConnectionSender sends the CreateOrUpdateRelayServiceConnection request. The method will close the
// http.Response Body if it receives an error.
func (client AppsClient) CreateOrUpdateRelayServiceConnectionSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// CreateOrUpdateRelayServiceConnectionResponder handles the response to the CreateOrUpdateRelayServiceConnection request. The method always
// closes the http.Response Body.
func (client AppsClient) CreateOrUpdateRelayServiceConnectionResponder(resp *http.Response) (result RelayServiceConnectionEntity, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// CreateOrUpdateRelayServiceConnectionSlot description for Creates a new hybrid connection configuration (PUT), or
// updates an existing one (PATCH).
// Parameters:
// resourceGroupName - name of the resource group to which the resource belongs.
// name - name of the app.
// entityName - name of the hybrid connection configuration.
// connectionEnvelope - details of the hybrid connection configuration.
// slot - name of the deployment slot. If a slot is not specified, the API will create or update a hybrid
// connection for the production slot.
func (client AppsClient) CreateOrUpdateRelayServiceConnectionSlot(ctx context.Context, resourceGroupName string, name string, entityName string, connectionEnvelope RelayServiceConnectionEntity, slot string) (result RelayServiceConnectionEntity, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/AppsClient.CreateOrUpdateRelayServiceConnectionSlot")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewError("web.AppsClient", "CreateOrUpdateRelayServiceConnectionSlot", err.Error())
	}

	req, err := client.CreateOrUpdateRelayServiceConnectionSlotPreparer(ctx, resourceGroupName, name, entityName, connectionEnvelope, slot)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "CreateOrUpdateRelayServiceConnectionSlot", nil, "Failure preparing request")
		return
	}

	resp, err := client.CreateOrUpdateRelayServiceConnectionSlotSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.AppsClient", "CreateOrUpdateRelayServiceConnectionSlot", resp, "Failure sending request")
		return
	}

	result, err = client.CreateOrUpdateRelayServiceConnectionSlotResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "CreateOrUpdateRelayServiceConnectionSlot", resp, "Failure responding to request")
	}

	return
}

// CreateOrUpdateRelayServiceConnectionSlotPreparer prepares the CreateOrUpdateRelayServiceConnectionSlot request.
func (client AppsClient) CreateOrUpdateRelayServiceConnectionSlotPreparer(ctx context.Context, resourceGroupName string, name string, entityName string, connectionEnvelope RelayServiceConnectionEntity, slot string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"entityName":        autorest.Encode("path", entityName),
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"slot":              autorest.Encode("path", slot),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2019-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsContentType("application/json; charset=utf-8"),
		autorest.AsPut(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/hybridconnection/{entityName}", pathParameters),
		autorest.WithJSON(connectionEnvelope),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// CreateOrUpdateRelayServiceConnectionSlotSender sends the CreateOrUpdateRelayServiceConnectionSlot request. The method will close the
// http.Response Body if it receives an error.
func (client AppsClient) CreateOrUpdateRelayServiceConnectionSlotSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// CreateOrUpdateRelayServiceConnectionSlotResponder handles the response to the CreateOrUpdateRelayServiceConnectionSlot request. The method always
// closes the http.Response Body.
func (client AppsClient) CreateOrUpdateRelayServiceConnectionSlotResponder(resp *http.Response) (result RelayServiceConnectionEntity, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// CreateOrUpdateSlot description for Creates a new web, mobile, or API app in an existing resource group, or updates
// an existing app.
// Parameters:
// resourceGroupName - name of the resource group to which the resource belongs.
// name - unique name of the app to create or update. To create or update a deployment slot, use the {slot}
// parameter.
// siteEnvelope - a JSON representation of the app properties. See example.
// slot - name of the deployment slot to create or update. By default, this API attempts to create or modify
// the production slot.
func (client AppsClient) CreateOrUpdateSlot(ctx context.Context, resourceGroupName string, name string, siteEnvelope Site, slot string) (result AppsCreateOrUpdateSlotFuture, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/AppsClient.CreateOrUpdateSlot")
		defer func() {
			sc := -1
			if result.Response() != nil {
				sc = result.Response().StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}},
		{TargetValue: siteEnvelope,
			Constraints: []validation.Constraint{{Target: "siteEnvelope.SiteProperties", Name: validation.Null, Rule: false,
				Chain: []validation.Constraint{{Target: "siteEnvelope.SiteProperties.SiteConfig", Name: validation.Null, Rule: false,
					Chain: []validation.Constraint{{Target: "siteEnvelope.SiteProperties.SiteConfig.Push", Name: validation.Null, Rule: false,
						Chain: []validation.Constraint{{Target: "siteEnvelope.SiteProperties.SiteConfig.Push.PushSettingsProperties", Name: validation.Null, Rule: false,
							Chain: []validation.Constraint{{Target: "siteEnvelope.SiteProperties.SiteConfig.Push.PushSettingsProperties.IsPushEnabled", Name: validation.Null, Rule: true, Chain: nil}}},
						}},
						{Target: "siteEnvelope.SiteProperties.SiteConfig.PreWarmedInstanceCount", Name: validation.Null, Rule: false,
							Chain: []validation.Constraint{{Target: "siteEnvelope.SiteProperties.SiteConfig.PreWarmedInstanceCount", Name: validation.InclusiveMaximum, Rule: int64(10), Chain: nil},
								{Target: "siteEnvelope.SiteProperties.SiteConfig.PreWarmedInstanceCount", Name: validation.InclusiveMinimum, Rule: int64(0), Chain: nil},
							}},
					}},
					{Target: "siteEnvelope.SiteProperties.CloningInfo", Name: validation.Null, Rule: false,
						Chain: []validation.Constraint{{Target: "siteEnvelope.SiteProperties.CloningInfo.SourceWebAppID", Name: validation.Null, Rule: true, Chain: nil}}},
				}}}}}); err != nil {
		return result, validation.NewError("web.AppsClient", "CreateOrUpdateSlot", err.Error())
	}

	req, err := client.CreateOrUpdateSlotPreparer(ctx, resourceGroupName, name, siteEnvelope, slot)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "CreateOrUpdateSlot", nil, "Failure preparing request")
		return
	}

	result, err = client.CreateOrUpdateSlotSender(req)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "CreateOrUpdateSlot", result.Response(), "Failure sending request")
		return
	}

	return
}

// CreateOrUpdateSlotPreparer prepares the CreateOrUpdateSlot request.
func (client AppsClient) CreateOrUpdateSlotPreparer(ctx context.Context, resourceGroupName string, name string, siteEnvelope Site, slot string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"slot":              autorest.Encode("path", slot),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2019-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsContentType("application/json; charset=utf-8"),
		autorest.AsPut(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}", pathParameters),
		autorest.WithJSON(siteEnvelope),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// CreateOrUpdateSlotSender sends the CreateOrUpdateSlot request. The method will close the
// http.Response Body if it receives an error.
func (client AppsClient) CreateOrUpdateSlotSender(req *http.Request) (future AppsCreateOrUpdateSlotFuture, err error) {
	var resp *http.Response
	resp, err = client.Send(req, azure.DoRetryWithRegistration(client.Client))
	if err != nil {
		return
	}
	future.Future, err = azure.NewFutureFromResponse(resp)
	return
}

// CreateOrUpdateSlotResponder handles the response to the CreateOrUpdateSlot request. The method always
// closes the http.Response Body.
func (client AppsClient) CreateOrUpdateSlotResponder(resp *http.Response) (result Site, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusAccepted),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// CreateOrUpdateSourceControl description for Updates the source control configuration of an app.
// Parameters:
// resourceGroupName - name of the resource group to which the resource belongs.
// name - name of the app.
// siteSourceControl - JSON representation of a SiteSourceControl object. See example.
func (client AppsClient) CreateOrUpdateSourceControl(ctx context.Context, resourceGroupName string, name string, siteSourceControl SiteSourceControl) (result AppsCreateOrUpdateSourceControlFuture, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/AppsClient.CreateOrUpdateSourceControl")
		defer func() {
			sc := -1
			if result.Response() != nil {
				sc = result.Response().StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewError("web.AppsClient", "CreateOrUpdateSourceControl", err.Error())
	}

	req, err := client.CreateOrUpdateSourceControlPreparer(ctx, resourceGroupName, name, siteSourceControl)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "CreateOrUpdateSourceControl", nil, "Failure preparing request")
		return
	}

	result, err = client.CreateOrUpdateSourceControlSender(req)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "CreateOrUpdateSourceControl", result.Response(), "Failure sending request")
		return
	}

	return
}

// CreateOrUpdateSourceControlPreparer prepares the CreateOrUpdateSourceControl request.
func (client AppsClient) CreateOrUpdateSourceControlPreparer(ctx context.Context, resourceGroupName string, name string, siteSourceControl SiteSourceControl) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2019-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsContentType("application/json; charset=utf-8"),
		autorest.AsPut(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/sourcecontrols/web", pathParameters),
		autorest.WithJSON(siteSourceControl),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// CreateOrUpdateSourceControlSender sends the CreateOrUpdateSourceControl request. The method will close the
// http.Response Body if it receives an error.
func (client AppsClient) CreateOrUpdateSourceControlSender(req *http.Request) (future AppsCreateOrUpdateSourceControlFuture, err error) {
	var resp *http.Response
	resp, err = client.Send(req, azure.DoRetryWithRegistration(client.Client))
	if err != nil {
		return
	}
	future.Future, err = azure.NewFutureFromResponse(resp)
	return
}

// CreateOrUpdateSourceControlResponder handles the response to the CreateOrUpdateSourceControl request. The method always
// closes the http.Response Body.
func (client AppsClient) CreateOrUpdateSourceControlResponder(resp *http.Response) (result SiteSourceControl, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusCreated, http.StatusAccepted),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// CreateOrUpdateSourceControlSlot description for Updates the source control configuration of an app.
// Parameters:
// resourceGroupName - name of the resource group to which the resource belongs.
// name - name of the app.
// siteSourceControl - JSON representation of a SiteSourceControl object. See example.
// slot - name of the deployment slot. If a slot is not specified, the API will update the source control
// configuration for the production slot.
func (client AppsClient) CreateOrUpdateSourceControlSlot(ctx context.Context, resourceGroupName string, name string, siteSourceControl SiteSourceControl, slot string) (result AppsCreateOrUpdateSourceControlSlotFuture, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/AppsClient.CreateOrUpdateSourceControlSlot")
		defer func() {
			sc := -1
			if result.Response() != nil {
				sc = result.Response().StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewError("web.AppsClient", "CreateOrUpdateSourceControlSlot", err.Error())
	}

	req, err := client.CreateOrUpdateSourceControlSlotPreparer(ctx, resourceGroupName, name, siteSourceControl, slot)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "CreateOrUpdateSourceControlSlot", nil, "Failure preparing request")
		return
	}

	result, err = client.CreateOrUpdateSourceControlSlotSender(req)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "CreateOrUpdateSourceControlSlot", result.Response(), "Failure sending request")
		return
	}

	return
}

// CreateOrUpdateSourceControlSlotPreparer prepares the CreateOrUpdateSourceControlSlot request.
func (client AppsClient) CreateOrUpdateSourceControlSlotPreparer(ctx context.Context, resourceGroupName string, name string, siteSourceControl SiteSourceControl, slot string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"slot":              autorest.Encode("path", slot),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2019-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsContentType("application/json; charset=utf-8"),
		autorest.AsPut(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/sourcecontrols/web", pathParameters),
		autorest.WithJSON(siteSourceControl),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// CreateOrUpdateSourceControlSlotSender sends the CreateOrUpdateSourceControlSlot request. The method will close the
// http.Response Body if it receives an error.
func (client AppsClient) CreateOrUpdateSourceControlSlotSender(req *http.Request) (future AppsCreateOrUpdateSourceControlSlotFuture, err error) {
	var resp *http.Response
	resp, err = client.Send(req, azure.DoRetryWithRegistration(client.Client))
	if err != nil {
		return
	}
	future.Future, err = azure.NewFutureFromResponse(resp)
	return
}

// CreateOrUpdateSourceControlSlotResponder handles the response to the CreateOrUpdateSourceControlSlot request. The method always
// closes the http.Response Body.
func (client AppsClient) CreateOrUpdateSourceControlSlotResponder(resp *http.Response) (result SiteSourceControl, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusCreated, http.StatusAccepted),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// CreateOrUpdateSwiftVirtualNetworkConnection description for Integrates this Web App with a Virtual Network. This
// requires that 1) "swiftSupported" is true when doing a GET against this resource, and 2) that the target Subnet has
// already been delegated, and is not
// in use by another App Service Plan other than the one this App is in.
// Parameters:
// resourceGroupName - name of the resource group to which the resource belongs.
// name - name of the app.
// connectionEnvelope - properties of the Virtual Network connection. See example.
func (client AppsClient) CreateOrUpdateSwiftVirtualNetworkConnection(ctx context.Context, resourceGroupName string, name string, connectionEnvelope SwiftVirtualNetwork) (result SwiftVirtualNetwork, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/AppsClient.CreateOrUpdateSwiftVirtualNetworkConnection")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewError("web.AppsClient", "CreateOrUpdateSwiftVirtualNetworkConnection", err.Error())
	}

	req, err := client.CreateOrUpdateSwiftVirtualNetworkConnectionPreparer(ctx, resourceGroupName, name, connectionEnvelope)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "CreateOrUpdateSwiftVirtualNetworkConnection", nil, "Failure preparing request")
		return
	}

	resp, err := client.CreateOrUpdateSwiftVirtualNetworkConnectionSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.AppsClient", "CreateOrUpdateSwiftVirtualNetworkConnection", resp, "Failure sending request")
		return
	}

	result, err = client.CreateOrUpdateSwiftVirtualNetworkConnectionResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "CreateOrUpdateSwiftVirtualNetworkConnection", resp, "Failure responding to request")
	}

	return
}

// CreateOrUpdateSwiftVirtualNetworkConnectionPreparer prepares the CreateOrUpdateSwiftVirtualNetworkConnection request.
func (client AppsClient) CreateOrUpdateSwiftVirtualNetworkConnectionPreparer(ctx context.Context, resourceGroupName string, name string, connectionEnvelope SwiftVirtualNetwork) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2019-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsContentType("application/json; charset=utf-8"),
		autorest.AsPut(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/networkConfig/virtualNetwork", pathParameters),
		autorest.WithJSON(connectionEnvelope),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// CreateOrUpdateSwiftVirtualNetworkConnectionSender sends the CreateOrUpdateSwiftVirtualNetworkConnection request. The method will close the
// http.Response Body if it receives an error.
func (client AppsClient) CreateOrUpdateSwiftVirtualNetworkConnectionSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// CreateOrUpdateSwiftVirtualNetworkConnectionResponder handles the response to the CreateOrUpdateSwiftVirtualNetworkConnection request. The method always
// closes the http.Response Body.
func (client AppsClient) CreateOrUpdateSwiftVirtualNetworkConnectionResponder(resp *http.Response) (result SwiftVirtualNetwork, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// CreateOrUpdateSwiftVirtualNetworkConnectionSlot description for Integrates this Web App with a Virtual Network. This
// requires that 1) "swiftSupported" is true when doing a GET against this resource, and 2) that the target Subnet has
// already been delegated, and is not
// in use by another App Service Plan other than the one this App is in.
// Parameters:
// resourceGroupName - name of the resource group to which the resource belongs.
// name - name of the app.
// connectionEnvelope - properties of the Virtual Network connection. See example.
// slot - name of the deployment slot. If a slot is not specified, the API will add or update connections for
// the production slot.
func (client AppsClient) CreateOrUpdateSwiftVirtualNetworkConnectionSlot(ctx context.Context, resourceGroupName string, name string, connectionEnvelope SwiftVirtualNetwork, slot string) (result SwiftVirtualNetwork, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/AppsClient.CreateOrUpdateSwiftVirtualNetworkConnectionSlot")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewError("web.AppsClient", "CreateOrUpdateSwiftVirtualNetworkConnectionSlot", err.Error())
	}

	req, err := client.CreateOrUpdateSwiftVirtualNetworkConnectionSlotPreparer(ctx, resourceGroupName, name, connectionEnvelope, slot)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "CreateOrUpdateSwiftVirtualNetworkConnectionSlot", nil, "Failure preparing request")
		return
	}

	resp, err := client.CreateOrUpdateSwiftVirtualNetworkConnectionSlotSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.AppsClient", "CreateOrUpdateSwiftVirtualNetworkConnectionSlot", resp, "Failure sending request")
		return
	}

	result, err = client.CreateOrUpdateSwiftVirtualNetworkConnectionSlotResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "CreateOrUpdateSwiftVirtualNetworkConnectionSlot", resp, "Failure responding to request")
	}

	return
}

// CreateOrUpdateSwiftVirtualNetworkConnectionSlotPreparer prepares the CreateOrUpdateSwiftVirtualNetworkConnectionSlot request.
func (client AppsClient) CreateOrUpdateSwiftVirtualNetworkConnectionSlotPreparer(ctx context.Context, resourceGroupName string, name string, connectionEnvelope SwiftVirtualNetwork, slot string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"slot":              autorest.Encode("path", slot),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2019-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsContentType("application/json; charset=utf-8"),
		autorest.AsPut(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/networkConfig/virtualNetwork", pathParameters),
		autorest.WithJSON(connectionEnvelope),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// CreateOrUpdateSwiftVirtualNetworkConnectionSlotSender sends the CreateOrUpdateSwiftVirtualNetworkConnectionSlot request. The method will close the
// http.Response Body if it receives an error.
func (client AppsClient) CreateOrUpdateSwiftVirtualNetworkConnectionSlotSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// CreateOrUpdateSwiftVirtualNetworkConnectionSlotResponder handles the response to the CreateOrUpdateSwiftVirtualNetworkConnectionSlot request. The method always
// closes the http.Response Body.
func (client AppsClient) CreateOrUpdateSwiftVirtualNetworkConnectionSlotResponder(resp *http.Response) (result SwiftVirtualNetwork, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// CreateOrUpdateVnetConnection description for Adds a Virtual Network connection to an app or slot (PUT) or updates
// the connection properties (PATCH).
// Parameters:
// resourceGroupName - name of the resource group to which the resource belongs.
// name - name of the app.
// vnetName - name of an existing Virtual Network.
// connectionEnvelope - properties of the Virtual Network connection. See example.
func (client AppsClient) CreateOrUpdateVnetConnection(ctx context.Context, resourceGroupName string, name string, vnetName string, connectionEnvelope VnetInfo) (result VnetInfo, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/AppsClient.CreateOrUpdateVnetConnection")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewError("web.AppsClient", "CreateOrUpdateVnetConnection", err.Error())
	}

	req, err := client.CreateOrUpdateVnetConnectionPreparer(ctx, resourceGroupName, name, vnetName, connectionEnvelope)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "CreateOrUpdateVnetConnection", nil, "Failure preparing request")
		return
	}

	resp, err := client.CreateOrUpdateVnetConnectionSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.AppsClient", "CreateOrUpdateVnetConnection", resp, "Failure sending request")
		return
	}

	result, err = client.CreateOrUpdateVnetConnectionResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "CreateOrUpdateVnetConnection", resp, "Failure responding to request")
	}

	return
}

// CreateOrUpdateVnetConnectionPreparer prepares the CreateOrUpdateVnetConnection request.
func (client AppsClient) CreateOrUpdateVnetConnectionPreparer(ctx context.Context, resourceGroupName string, name string, vnetName string, connectionEnvelope VnetInfo) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
		"vnetName":          autorest.Encode("path", vnetName),
	}

	const APIVersion = "2019-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsContentType("application/json; charset=utf-8"),
		autorest.AsPut(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/virtualNetworkConnections/{vnetName}", pathParameters),
		autorest.WithJSON(connectionEnvelope),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// CreateOrUpdateVnetConnectionSender sends the CreateOrUpdateVnetConnection request. The method will close the
// http.Response Body if it receives an error.
func (client AppsClient) CreateOrUpdateVnetConnectionSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// CreateOrUpdateVnetConnectionResponder handles the response to the CreateOrUpdateVnetConnection request. The method always
// closes the http.Response Body.
func (client AppsClient) CreateOrUpdateVnetConnectionResponder(resp *http.Response) (result VnetInfo, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// CreateOrUpdateVnetConnectionGateway description for Adds a gateway to a connected Virtual Network (PUT) or updates
// it (PATCH).
// Parameters:
// resourceGroupName - name of the resource group to which the resource belongs.
// name - name of the app.
// vnetName - name of the Virtual Network.
// gatewayName - name of the gateway. Currently, the only supported string is "primary".
// connectionEnvelope - the properties to update this gateway with.
func (client AppsClient) CreateOrUpdateVnetConnectionGateway(ctx context.Context, resourceGroupName string, name string, vnetName string, gatewayName string, connectionEnvelope VnetGateway) (result VnetGateway, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/AppsClient.CreateOrUpdateVnetConnectionGateway")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}},
		{TargetValue: connectionEnvelope,
			Constraints: []validation.Constraint{{Target: "connectionEnvelope.VnetGatewayProperties", Name: validation.Null, Rule: false,
				Chain: []validation.Constraint{{Target: "connectionEnvelope.VnetGatewayProperties.VpnPackageURI", Name: validation.Null, Rule: true, Chain: nil}}}}}}); err != nil {
		return result, validation.NewError("web.AppsClient", "CreateOrUpdateVnetConnectionGateway", err.Error())
	}

	req, err := client.CreateOrUpdateVnetConnectionGatewayPreparer(ctx, resourceGroupName, name, vnetName, gatewayName, connectionEnvelope)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "CreateOrUpdateVnetConnectionGateway", nil, "Failure preparing request")
		return
	}

	resp, err := client.CreateOrUpdateVnetConnectionGatewaySender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.AppsClient", "CreateOrUpdateVnetConnectionGateway", resp, "Failure sending request")
		return
	}

	result, err = client.CreateOrUpdateVnetConnectionGatewayResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "CreateOrUpdateVnetConnectionGateway", resp, "Failure responding to request")
	}

	return
}

// CreateOrUpdateVnetConnectionGatewayPreparer prepares the CreateOrUpdateVnetConnectionGateway request.
func (client AppsClient) CreateOrUpdateVnetConnectionGatewayPreparer(ctx context.Context, resourceGroupName string, name string, vnetName string, gatewayName string, connectionEnvelope VnetGateway) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"gatewayName":       autorest.Encode("path", gatewayName),
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
		"vnetName":          autorest.Encode("path", vnetName),
	}

	const APIVersion = "2019-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsContentType("application/json; charset=utf-8"),
		autorest.AsPut(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/virtualNetworkConnections/{vnetName}/gateways/{gatewayName}", pathParameters),
		autorest.WithJSON(connectionEnvelope),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// CreateOrUpdateVnetConnectionGatewaySender sends the CreateOrUpdateVnetConnectionGateway request. The method will close the
// http.Response Body if it receives an error.
func (client AppsClient) CreateOrUpdateVnetConnectionGatewaySender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// CreateOrUpdateVnetConnectionGatewayResponder handles the response to the CreateOrUpdateVnetConnectionGateway request. The method always
// closes the http.Response Body.
func (client AppsClient) CreateOrUpdateVnetConnectionGatewayResponder(resp *http.Response) (result VnetGateway, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// CreateOrUpdateVnetConnectionGatewaySlot description for Adds a gateway to a connected Virtual Network (PUT) or
// updates it (PATCH).
// Parameters:
// resourceGroupName - name of the resource group to which the resource belongs.
// name - name of the app.
// vnetName - name of the Virtual Network.
// gatewayName - name of the gateway. Currently, the only supported string is "primary".
// connectionEnvelope - the properties to update this gateway with.
// slot - name of the deployment slot. If a slot is not specified, the API will add or update a gateway for the
// production slot's Virtual Network.
func (client AppsClient) CreateOrUpdateVnetConnectionGatewaySlot(ctx context.Context, resourceGroupName string, name string, vnetName string, gatewayName string, connectionEnvelope VnetGateway, slot string) (result VnetGateway, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/AppsClient.CreateOrUpdateVnetConnectionGatewaySlot")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}},
		{TargetValue: connectionEnvelope,
			Constraints: []validation.Constraint{{Target: "connectionEnvelope.VnetGatewayProperties", Name: validation.Null, Rule: false,
				Chain: []validation.Constraint{{Target: "connectionEnvelope.VnetGatewayProperties.VpnPackageURI", Name: validation.Null, Rule: true, Chain: nil}}}}}}); err != nil {
		return result, validation.NewError("web.AppsClient", "CreateOrUpdateVnetConnectionGatewaySlot", err.Error())
	}

	req, err := client.CreateOrUpdateVnetConnectionGatewaySlotPreparer(ctx, resourceGroupName, name, vnetName, gatewayName, connectionEnvelope, slot)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "CreateOrUpdateVnetConnectionGatewaySlot", nil, "Failure preparing request")
		return
	}

	resp, err := client.CreateOrUpdateVnetConnectionGatewaySlotSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.AppsClient", "CreateOrUpdateVnetConnectionGatewaySlot", resp, "Failure sending request")
		return
	}

	result, err = client.CreateOrUpdateVnetConnectionGatewaySlotResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "CreateOrUpdateVnetConnectionGatewaySlot", resp, "Failure responding to request")
	}

	return
}

// CreateOrUpdateVnetConnectionGatewaySlotPreparer prepares the CreateOrUpdateVnetConnectionGatewaySlot request.
func (client AppsClient) CreateOrUpdateVnetConnectionGatewaySlotPreparer(ctx context.Context, resourceGroupName string, name string, vnetName string, gatewayName string, connectionEnvelope VnetGateway, slot string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"gatewayName":       autorest.Encode("path", gatewayName),
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"slot":              autorest.Encode("path", slot),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
		"vnetName":          autorest.Encode("path", vnetName),
	}

	const APIVersion = "2019-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsContentType("application/json; charset=utf-8"),
		autorest.AsPut(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/virtualNetworkConnections/{vnetName}/gateways/{gatewayName}", pathParameters),
		autorest.WithJSON(connectionEnvelope),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// CreateOrUpdateVnetConnectionGatewaySlotSender sends the CreateOrUpdateVnetConnectionGatewaySlot request. The method will close the
// http.Response Body if it receives an error.
func (client AppsClient) CreateOrUpdateVnetConnectionGatewaySlotSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// CreateOrUpdateVnetConnectionGatewaySlotResponder handles the response to the CreateOrUpdateVnetConnectionGatewaySlot request. The method always
// closes the http.Response Body.
func (client AppsClient) CreateOrUpdateVnetConnectionGatewaySlotResponder(resp *http.Response) (result VnetGateway, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// CreateOrUpdateVnetConnectionSlot description for Adds a Virtual Network connection to an app or slot (PUT) or
// updates the connection properties (PATCH).
// Parameters:
// resourceGroupName - name of the resource group to which the resource belongs.
// name - name of the app.
// vnetName - name of an existing Virtual Network.
// connectionEnvelope - properties of the Virtual Network connection. See example.
// slot - name of the deployment slot. If a slot is not specified, the API will add or update connections for
// the production slot.
func (client AppsClient) CreateOrUpdateVnetConnectionSlot(ctx context.Context, resourceGroupName string, name string, vnetName string, connectionEnvelope VnetInfo, slot string) (result VnetInfo, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/AppsClient.CreateOrUpdateVnetConnectionSlot")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewError("web.AppsClient", "CreateOrUpdateVnetConnectionSlot", err.Error())
	}

	req, err := client.CreateOrUpdateVnetConnectionSlotPreparer(ctx, resourceGroupName, name, vnetName, connectionEnvelope, slot)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "CreateOrUpdateVnetConnectionSlot", nil, "Failure preparing request")
		return
	}

	resp, err := client.CreateOrUpdateVnetConnectionSlotSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.AppsClient", "CreateOrUpdateVnetConnectionSlot", resp, "Failure sending request")
		return
	}

	result, err = client.CreateOrUpdateVnetConnectionSlotResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "CreateOrUpdateVnetConnectionSlot", resp, "Failure responding to request")
	}

	return
}

// CreateOrUpdateVnetConnectionSlotPreparer prepares the CreateOrUpdateVnetConnectionSlot request.
func (client AppsClient) CreateOrUpdateVnetConnectionSlotPreparer(ctx context.Context, resourceGroupName string, name string, vnetName string, connectionEnvelope VnetInfo, slot string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"slot":              autorest.Encode("path", slot),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
		"vnetName":          autorest.Encode("path", vnetName),
	}

	const APIVersion = "2019-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsContentType("application/json; charset=utf-8"),
		autorest.AsPut(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/virtualNetworkConnections/{vnetName}", pathParameters),
		autorest.WithJSON(connectionEnvelope),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// CreateOrUpdateVnetConnectionSlotSender sends the CreateOrUpdateVnetConnectionSlot request. The method will close the
// http.Response Body if it receives an error.
func (client AppsClient) CreateOrUpdateVnetConnectionSlotSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// CreateOrUpdateVnetConnectionSlotResponder handles the response to the CreateOrUpdateVnetConnectionSlot request. The method always
// closes the http.Response Body.
func (client AppsClient) CreateOrUpdateVnetConnectionSlotResponder(resp *http.Response) (result VnetInfo, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// Delete description for Deletes a web, mobile, or API app, or one of the deployment slots.
// Parameters:
// resourceGroupName - name of the resource group to which the resource belongs.
// name - name of the app to delete.
// deleteMetrics - if true, web app metrics are also deleted.
// deleteEmptyServerFarm - specify false if you want to keep empty App Service plan. By default, empty App
// Service plan is deleted.
func (client AppsClient) Delete(ctx context.Context, resourceGroupName string, name string, deleteMetrics *bool, deleteEmptyServerFarm *bool) (result autorest.Response, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/AppsClient.Delete")
		defer func() {
			sc := -1
			if result.Response != nil {
				sc = result.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewError("web.AppsClient", "Delete", err.Error())
	}

	req, err := client.DeletePreparer(ctx, resourceGroupName, name, deleteMetrics, deleteEmptyServerFarm)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "Delete", nil, "Failure preparing request")
		return
	}

	resp, err := client.DeleteSender(req)
	if err != nil {
		result.Response = resp
		err = autorest.NewErrorWithError(err, "web.AppsClient", "Delete", resp, "Failure sending request")
		return
	}

	result, err = client.DeleteResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "Delete", resp, "Failure responding to request")
	}

	return
}

// DeletePreparer prepares the Delete request.
func (client AppsClient) DeletePreparer(ctx context.Context, resourceGroupName string, name string, deleteMetrics *bool, deleteEmptyServerFarm *bool) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2019-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}
	if deleteMetrics != nil {
		queryParameters["deleteMetrics"] = autorest.Encode("query", *deleteMetrics)
	}
	if deleteEmptyServerFarm != nil {
		queryParameters["deleteEmptyServerFarm"] = autorest.Encode("query", *deleteEmptyServerFarm)
	}

	preparer := autorest.CreatePreparer(
		autorest.AsDelete(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// DeleteSender sends the Delete request. The method will close the
// http.Response Body if it receives an error.
func (client AppsClient) DeleteSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// DeleteResponder handles the response to the Delete request. The method always
// closes the http.Response Body.
func (client AppsClient) DeleteResponder(resp *http.Response) (result autorest.Response, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusNoContent, http.StatusNotFound),
		autorest.ByClosing())
	result.Response = resp
	return
}

// DeleteBackup description for Deletes a backup of an app by its ID.
// Parameters:
// resourceGroupName - name of the resource group to which the resource belongs.
// name - name of the app.
// backupID - ID of the backup.
func (client AppsClient) DeleteBackup(ctx context.Context, resourceGroupName string, name string, backupID string) (result autorest.Response, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/AppsClient.DeleteBackup")
		defer func() {
			sc := -1
			if result.Response != nil {
				sc = result.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewError("web.AppsClient", "DeleteBackup", err.Error())
	}

	req, err := client.DeleteBackupPreparer(ctx, resourceGroupName, name, backupID)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "DeleteBackup", nil, "Failure preparing request")
		return
	}

	resp, err := client.DeleteBackupSender(req)
	if err != nil {
		result.Response = resp
		err = autorest.NewErrorWithError(err, "web.AppsClient", "DeleteBackup", resp, "Failure sending request")
		return
	}

	result, err = client.DeleteBackupResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "DeleteBackup", resp, "Failure responding to request")
	}

	return
}

// DeleteBackupPreparer prepares the DeleteBackup request.
func (client AppsClient) DeleteBackupPreparer(ctx context.Context, resourceGroupName string, name string, backupID string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"backupId":          autorest.Encode("path", backupID),
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2019-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsDelete(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/backups/{backupId}", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// DeleteBackupSender sends the DeleteBackup request. The method will close the
// http.Response Body if it receives an error.
func (client AppsClient) DeleteBackupSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// DeleteBackupResponder handles the response to the DeleteBackup request. The method always
// closes the http.Response Body.
func (client AppsClient) DeleteBackupResponder(resp *http.Response) (result autorest.Response, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusNotFound),
		autorest.ByClosing())
	result.Response = resp
	return
}

// DeleteBackupConfiguration description for Deletes the backup configuration of an app.
// Parameters:
// resourceGroupName - name of the resource group to which the resource belongs.
// name - name of the app.
func (client AppsClient) DeleteBackupConfiguration(ctx context.Context, resourceGroupName string, name string) (result autorest.Response, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/AppsClient.DeleteBackupConfiguration")
		defer func() {
			sc := -1
			if result.Response != nil {
				sc = result.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewError("web.AppsClient", "DeleteBackupConfiguration", err.Error())
	}

	req, err := client.DeleteBackupConfigurationPreparer(ctx, resourceGroupName, name)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "DeleteBackupConfiguration", nil, "Failure preparing request")
		return
	}

	resp, err := client.DeleteBackupConfigurationSender(req)
	if err != nil {
		result.Response = resp
		err = autorest.NewErrorWithError(err, "web.AppsClient", "DeleteBackupConfiguration", resp, "Failure sending request")
		return
	}

	result, err = client.DeleteBackupConfigurationResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "DeleteBackupConfiguration", resp, "Failure responding to request")
	}

	return
}

// DeleteBackupConfigurationPreparer prepares the DeleteBackupConfiguration request.
func (client AppsClient) DeleteBackupConfigurationPreparer(ctx context.Context, resourceGroupName string, name string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2019-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsDelete(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/config/backup", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// DeleteBackupConfigurationSender sends the DeleteBackupConfiguration request. The method will close the
// http.Response Body if it receives an error.
func (client AppsClient) DeleteBackupConfigurationSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// DeleteBackupConfigurationResponder handles the response to the DeleteBackupConfiguration request. The method always
// closes the http.Response Body.
func (client AppsClient) DeleteBackupConfigurationResponder(resp *http.Response) (result autorest.Response, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByClosing())
	result.Response = resp
	return
}

// DeleteBackupConfigurationSlot description for Deletes the backup configuration of an app.
// Parameters:
// resourceGroupName - name of the resource group to which the resource belongs.
// name - name of the app.
// slot - name of the deployment slot. If a slot is not specified, the API will delete the backup configuration
// for the production slot.
func (client AppsClient) DeleteBackupConfigurationSlot(ctx context.Context, resourceGroupName string, name string, slot string) (result autorest.Response, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/AppsClient.DeleteBackupConfigurationSlot")
		defer func() {
			sc := -1
			if result.Response != nil {
				sc = result.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewError("web.AppsClient", "DeleteBackupConfigurationSlot", err.Error())
	}

	req, err := client.DeleteBackupConfigurationSlotPreparer(ctx, resourceGroupName, name, slot)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "DeleteBackupConfigurationSlot", nil, "Failure preparing request")
		return
	}

	resp, err := client.DeleteBackupConfigurationSlotSender(req)
	if err != nil {
		result.Response = resp
		err = autorest.NewErrorWithError(err, "web.AppsClient", "DeleteBackupConfigurationSlot", resp, "Failure sending request")
		return
	}

	result, err = client.DeleteBackupConfigurationSlotResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "DeleteBackupConfigurationSlot", resp, "Failure responding to request")
	}

	return
}

// DeleteBackupConfigurationSlotPreparer prepares the DeleteBackupConfigurationSlot request.
func (client AppsClient) DeleteBackupConfigurationSlotPreparer(ctx context.Context, resourceGroupName string, name string, slot string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"slot":              autorest.Encode("path", slot),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2019-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsDelete(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/config/backup", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// DeleteBackupConfigurationSlotSender sends the DeleteBackupConfigurationSlot request. The method will close the
// http.Response Body if it receives an error.
func (client AppsClient) DeleteBackupConfigurationSlotSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// DeleteBackupConfigurationSlotResponder handles the response to the DeleteBackupConfigurationSlot request. The method always
// closes the http.Response Body.
func (client AppsClient) DeleteBackupConfigurationSlotResponder(resp *http.Response) (result autorest.Response, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByClosing())
	result.Response = resp
	return
}

// DeleteBackupSlot description for Deletes a backup of an app by its ID.
// Parameters:
// resourceGroupName - name of the resource group to which the resource belongs.
// name - name of the app.
// backupID - ID of the backup.
// slot - name of the deployment slot. If a slot is not specified, the API will delete a backup of the
// production slot.
func (client AppsClient) DeleteBackupSlot(ctx context.Context, resourceGroupName string, name string, backupID string, slot string) (result autorest.Response, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/AppsClient.DeleteBackupSlot")
		defer func() {
			sc := -1
			if result.Response != nil {
				sc = result.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewError("web.AppsClient", "DeleteBackupSlot", err.Error())
	}

	req, err := client.DeleteBackupSlotPreparer(ctx, resourceGroupName, name, backupID, slot)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "DeleteBackupSlot", nil, "Failure preparing request")
		return
	}

	resp, err := client.DeleteBackupSlotSender(req)
	if err != nil {
		result.Response = resp
		err = autorest.NewErrorWithError(err, "web.AppsClient", "DeleteBackupSlot", resp, "Failure sending request")
		return
	}

	result, err = client.DeleteBackupSlotResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "DeleteBackupSlot", resp, "Failure responding to request")
	}

	return
}

// DeleteBackupSlotPreparer prepares the DeleteBackupSlot request.
func (client AppsClient) DeleteBackupSlotPreparer(ctx context.Context, resourceGroupName string, name string, backupID string, slot string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"backupId":          autorest.Encode("path", backupID),
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"slot":              autorest.Encode("path", slot),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2019-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsDelete(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/backups/{backupId}", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// DeleteBackupSlotSender sends the DeleteBackupSlot request. The method will close the
// http.Response Body if it receives an error.
func (client AppsClient) DeleteBackupSlotSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// DeleteBackupSlotResponder handles the response to the DeleteBackupSlot request. The method always
// closes the http.Response Body.
func (client AppsClient) DeleteBackupSlotResponder(resp *http.Response) (result autorest.Response, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusNotFound),
		autorest.ByClosing())
	result.Response = resp
	return
}

// DeleteContinuousWebJob description for Delete a continuous web job by its ID for an app, or a deployment slot.
// Parameters:
// resourceGroupName - name of the resource group to which the resource belongs.
// name - site name.
// webJobName - name of Web Job.
func (client AppsClient) DeleteContinuousWebJob(ctx context.Context, resourceGroupName string, name string, webJobName string) (result autorest.Response, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/AppsClient.DeleteContinuousWebJob")
		defer func() {
			sc := -1
			if result.Response != nil {
				sc = result.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewError("web.AppsClient", "DeleteContinuousWebJob", err.Error())
	}

	req, err := client.DeleteContinuousWebJobPreparer(ctx, resourceGroupName, name, webJobName)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "DeleteContinuousWebJob", nil, "Failure preparing request")
		return
	}

	resp, err := client.DeleteContinuousWebJobSender(req)
	if err != nil {
		result.Response = resp
		err = autorest.NewErrorWithError(err, "web.AppsClient", "DeleteContinuousWebJob", resp, "Failure sending request")
		return
	}

	result, err = client.DeleteContinuousWebJobResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "DeleteContinuousWebJob", resp, "Failure responding to request")
	}

	return
}

// DeleteContinuousWebJobPreparer prepares the DeleteContinuousWebJob request.
func (client AppsClient) DeleteContinuousWebJobPreparer(ctx context.Context, resourceGroupName string, name string, webJobName string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
		"webJobName":        autorest.Encode("path", webJobName),
	}

	const APIVersion = "2019-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsDelete(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/continuouswebjobs/{webJobName}", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// DeleteContinuousWebJobSender sends the DeleteContinuousWebJob request. The method will close the
// http.Response Body if it receives an error.
func (client AppsClient) DeleteContinuousWebJobSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// DeleteContinuousWebJobResponder handles the response to the DeleteContinuousWebJob request. The method always
// closes the http.Response Body.
func (client AppsClient) DeleteContinuousWebJobResponder(resp *http.Response) (result autorest.Response, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusNoContent),
		autorest.ByClosing())
	result.Response = resp
	return
}

// DeleteContinuousWebJobSlot description for Delete a continuous web job by its ID for an app, or a deployment slot.
// Parameters:
// resourceGroupName - name of the resource group to which the resource belongs.
// name - site name.
// webJobName - name of Web Job.
// slot - name of the deployment slot. If a slot is not specified, the API deletes a deployment for the
// production slot.
func (client AppsClient) DeleteContinuousWebJobSlot(ctx context.Context, resourceGroupName string, name string, webJobName string, slot string) (result autorest.Response, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/AppsClient.DeleteContinuousWebJobSlot")
		defer func() {
			sc := -1
			if result.Response != nil {
				sc = result.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewError("web.AppsClient", "DeleteContinuousWebJobSlot", err.Error())
	}

	req, err := client.DeleteContinuousWebJobSlotPreparer(ctx, resourceGroupName, name, webJobName, slot)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "DeleteContinuousWebJobSlot", nil, "Failure preparing request")
		return
	}

	resp, err := client.DeleteContinuousWebJobSlotSender(req)
	if err != nil {
		result.Response = resp
		err = autorest.NewErrorWithError(err, "web.AppsClient", "DeleteContinuousWebJobSlot", resp, "Failure sending request")
		return
	}

	result, err = client.DeleteContinuousWebJobSlotResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "DeleteContinuousWebJobSlot", resp, "Failure responding to request")
	}

	return
}

// DeleteContinuousWebJobSlotPreparer prepares the DeleteContinuousWebJobSlot request.
func (client AppsClient) DeleteContinuousWebJobSlotPreparer(ctx context.Context, resourceGroupName string, name string, webJobName string, slot string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"slot":              autorest.Encode("path", slot),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
		"webJobName":        autorest.Encode("path", webJobName),
	}

	const APIVersion = "2019-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsDelete(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/continuouswebjobs/{webJobName}", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// DeleteContinuousWebJobSlotSender sends the DeleteContinuousWebJobSlot request. The method will close the
// http.Response Body if it receives an error.
func (client AppsClient) DeleteContinuousWebJobSlotSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// DeleteContinuousWebJobSlotResponder handles the response to the DeleteContinuousWebJobSlot request. The method always
// closes the http.Response Body.
func (client AppsClient) DeleteContinuousWebJobSlotResponder(resp *http.Response) (result autorest.Response, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusNoContent),
		autorest.ByClosing())
	result.Response = resp
	return
}

// DeleteDeployment description for Delete a deployment by its ID for an app, or a deployment slot.
// Parameters:
// resourceGroupName - name of the resource group to which the resource belongs.
// name - name of the app.
// ID - deployment ID.
func (client AppsClient) DeleteDeployment(ctx context.Context, resourceGroupName string, name string, ID string) (result autorest.Response, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/AppsClient.DeleteDeployment")
		defer func() {
			sc := -1
			if result.Response != nil {
				sc = result.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewError("web.AppsClient", "DeleteDeployment", err.Error())
	}

	req, err := client.DeleteDeploymentPreparer(ctx, resourceGroupName, name, ID)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "DeleteDeployment", nil, "Failure preparing request")
		return
	}

	resp, err := client.DeleteDeploymentSender(req)
	if err != nil {
		result.Response = resp
		err = autorest.NewErrorWithError(err, "web.AppsClient", "DeleteDeployment", resp, "Failure sending request")
		return
	}

	result, err = client.DeleteDeploymentResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "DeleteDeployment", resp, "Failure responding to request")
	}

	return
}

// DeleteDeploymentPreparer prepares the DeleteDeployment request.
func (client AppsClient) DeleteDeploymentPreparer(ctx context.Context, resourceGroupName string, name string, ID string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"id":                autorest.Encode("path", ID),
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2019-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsDelete(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/deployments/{id}", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// DeleteDeploymentSender sends the DeleteDeployment request. The method will close the
// http.Response Body if it receives an error.
func (client AppsClient) DeleteDeploymentSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// DeleteDeploymentResponder handles the response to the DeleteDeployment request. The method always
// closes the http.Response Body.
func (client AppsClient) DeleteDeploymentResponder(resp *http.Response) (result autorest.Response, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusNoContent),
		autorest.ByClosing())
	result.Response = resp
	return
}

// DeleteDeploymentSlot description for Delete a deployment by its ID for an app, or a deployment slot.
// Parameters:
// resourceGroupName - name of the resource group to which the resource belongs.
// name - name of the app.
// ID - deployment ID.
// slot - name of the deployment slot. If a slot is not specified, the API deletes a deployment for the
// production slot.
func (client AppsClient) DeleteDeploymentSlot(ctx context.Context, resourceGroupName string, name string, ID string, slot string) (result autorest.Response, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/AppsClient.DeleteDeploymentSlot")
		defer func() {
			sc := -1
			if result.Response != nil {
				sc = result.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewError("web.AppsClient", "DeleteDeploymentSlot", err.Error())
	}

	req, err := client.DeleteDeploymentSlotPreparer(ctx, resourceGroupName, name, ID, slot)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "DeleteDeploymentSlot", nil, "Failure preparing request")
		return
	}

	resp, err := client.DeleteDeploymentSlotSender(req)
	if err != nil {
		result.Response = resp
		err = autorest.NewErrorWithError(err, "web.AppsClient", "DeleteDeploymentSlot", resp, "Failure sending request")
		return
	}

	result, err = client.DeleteDeploymentSlotResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "DeleteDeploymentSlot", resp, "Failure responding to request")
	}

	return
}

// DeleteDeploymentSlotPreparer prepares the DeleteDeploymentSlot request.
func (client AppsClient) DeleteDeploymentSlotPreparer(ctx context.Context, resourceGroupName string, name string, ID string, slot string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"id":                autorest.Encode("path", ID),
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"slot":              autorest.Encode("path", slot),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2019-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsDelete(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/deployments/{id}", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// DeleteDeploymentSlotSender sends the DeleteDeploymentSlot request. The method will close the
// http.Response Body if it receives an error.
func (client AppsClient) DeleteDeploymentSlotSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// DeleteDeploymentSlotResponder handles the response to the DeleteDeploymentSlot request. The method always
// closes the http.Response Body.
func (client AppsClient) DeleteDeploymentSlotResponder(resp *http.Response) (result autorest.Response, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusNoContent),
		autorest.ByClosing())
	result.Response = resp
	return
}

// DeleteDomainOwnershipIdentifier description for Deletes a domain ownership identifier for a web app.
// Parameters:
// resourceGroupName - name of the resource group to which the resource belongs.
// name - name of the app.
// domainOwnershipIdentifierName - name of domain ownership identifier.
func (client AppsClient) DeleteDomainOwnershipIdentifier(ctx context.Context, resourceGroupName string, name string, domainOwnershipIdentifierName string) (result autorest.Response, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/AppsClient.DeleteDomainOwnershipIdentifier")
		defer func() {
			sc := -1
			if result.Response != nil {
				sc = result.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewError("web.AppsClient", "DeleteDomainOwnershipIdentifier", err.Error())
	}

	req, err := client.DeleteDomainOwnershipIdentifierPreparer(ctx, resourceGroupName, name, domainOwnershipIdentifierName)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "DeleteDomainOwnershipIdentifier", nil, "Failure preparing request")
		return
	}

	resp, err := client.DeleteDomainOwnershipIdentifierSender(req)
	if err != nil {
		result.Response = resp
		err = autorest.NewErrorWithError(err, "web.AppsClient", "DeleteDomainOwnershipIdentifier", resp, "Failure sending request")
		return
	}

	result, err = client.DeleteDomainOwnershipIdentifierResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "DeleteDomainOwnershipIdentifier", resp, "Failure responding to request")
	}

	return
}

// DeleteDomainOwnershipIdentifierPreparer prepares the DeleteDomainOwnershipIdentifier request.
func (client AppsClient) DeleteDomainOwnershipIdentifierPreparer(ctx context.Context, resourceGroupName string, name string, domainOwnershipIdentifierName string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"domainOwnershipIdentifierName": autorest.Encode("path", domainOwnershipIdentifierName),
		"name":                          autorest.Encode("path", name),
		"resourceGroupName":             autorest.Encode("path", resourceGroupName),
		"subscriptionId":                autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2019-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsDelete(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/domainOwnershipIdentifiers/{domainOwnershipIdentifierName}", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// DeleteDomainOwnershipIdentifierSender sends the DeleteDomainOwnershipIdentifier request. The method will close the
// http.Response Body if it receives an error.
func (client AppsClient) DeleteDomainOwnershipIdentifierSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// DeleteDomainOwnershipIdentifierResponder handles the response to the DeleteDomainOwnershipIdentifier request. The method always
// closes the http.Response Body.
func (client AppsClient) DeleteDomainOwnershipIdentifierResponder(resp *http.Response) (result autorest.Response, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusNoContent),
		autorest.ByClosing())
	result.Response = resp
	return
}

// DeleteDomainOwnershipIdentifierSlot description for Deletes a domain ownership identifier for a web app.
// Parameters:
// resourceGroupName - name of the resource group to which the resource belongs.
// name - name of the app.
// domainOwnershipIdentifierName - name of domain ownership identifier.
// slot - name of the deployment slot. If a slot is not specified, the API will delete the binding for the
// production slot.
func (client AppsClient) DeleteDomainOwnershipIdentifierSlot(ctx context.Context, resourceGroupName string, name string, domainOwnershipIdentifierName string, slot string) (result autorest.Response, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/AppsClient.DeleteDomainOwnershipIdentifierSlot")
		defer func() {
			sc := -1
			if result.Response != nil {
				sc = result.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewError("web.AppsClient", "DeleteDomainOwnershipIdentifierSlot", err.Error())
	}

	req, err := client.DeleteDomainOwnershipIdentifierSlotPreparer(ctx, resourceGroupName, name, domainOwnershipIdentifierName, slot)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "DeleteDomainOwnershipIdentifierSlot", nil, "Failure preparing request")
		return
	}

	resp, err := client.DeleteDomainOwnershipIdentifierSlotSender(req)
	if err != nil {
		result.Response = resp
		err = autorest.NewErrorWithError(err, "web.AppsClient", "DeleteDomainOwnershipIdentifierSlot", resp, "Failure sending request")
		return
	}

	result, err = client.DeleteDomainOwnershipIdentifierSlotResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "DeleteDomainOwnershipIdentifierSlot", resp, "Failure responding to request")
	}

	return
}

// DeleteDomainOwnershipIdentifierSlotPreparer prepares the DeleteDomainOwnershipIdentifierSlot request.
func (client AppsClient) DeleteDomainOwnershipIdentifierSlotPreparer(ctx context.Context, resourceGroupName string, name string, domainOwnershipIdentifierName string, slot string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"domainOwnershipIdentifierName": autorest.Encode("path", domainOwnershipIdentifierName),
		"name":                          autorest.Encode("path", name),
		"resourceGroupName":             autorest.Encode("path", resourceGroupName),
		"slot":                          autorest.Encode("path", slot),
		"subscriptionId":                autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2019-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsDelete(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/domainOwnershipIdentifiers/{domainOwnershipIdentifierName}", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// DeleteDomainOwnershipIdentifierSlotSender sends the DeleteDomainOwnershipIdentifierSlot request. The method will close the
// http.Response Body if it receives an error.
func (client AppsClient) DeleteDomainOwnershipIdentifierSlotSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// DeleteDomainOwnershipIdentifierSlotResponder handles the response to the DeleteDomainOwnershipIdentifierSlot request. The method always
// closes the http.Response Body.
func (client AppsClient) DeleteDomainOwnershipIdentifierSlotResponder(resp *http.Response) (result autorest.Response, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusNoContent),
		autorest.ByClosing())
	result.Response = resp
	return
}

// DeleteFunction description for Delete a function for web site, or a deployment slot.
// Parameters:
// resourceGroupName - name of the resource group to which the resource belongs.
// name - site name.
// functionName - function name.
func (client AppsClient) DeleteFunction(ctx context.Context, resourceGroupName string, name string, functionName string) (result autorest.Response, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/AppsClient.DeleteFunction")
		defer func() {
			sc := -1
			if result.Response != nil {
				sc = result.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewError("web.AppsClient", "DeleteFunction", err.Error())
	}

	req, err := client.DeleteFunctionPreparer(ctx, resourceGroupName, name, functionName)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "DeleteFunction", nil, "Failure preparing request")
		return
	}

	resp, err := client.DeleteFunctionSender(req)
	if err != nil {
		result.Response = resp
		err = autorest.NewErrorWithError(err, "web.AppsClient", "DeleteFunction", resp, "Failure sending request")
		return
	}

	result, err = client.DeleteFunctionResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "DeleteFunction", resp, "Failure responding to request")
	}

	return
}

// DeleteFunctionPreparer prepares the DeleteFunction request.
func (client AppsClient) DeleteFunctionPreparer(ctx context.Context, resourceGroupName string, name string, functionName string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"functionName":      autorest.Encode("path", functionName),
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2019-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsDelete(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/functions/{functionName}", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// DeleteFunctionSender sends the DeleteFunction request. The method will close the
// http.Response Body if it receives an error.
func (client AppsClient) DeleteFunctionSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// DeleteFunctionResponder handles the response to the DeleteFunction request. The method always
// closes the http.Response Body.
func (client AppsClient) DeleteFunctionResponder(resp *http.Response) (result autorest.Response, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusNoContent, http.StatusNotFound),
		autorest.ByClosing())
	result.Response = resp
	return
}

// DeleteFunctionSecret description for Delete a function secret.
// Parameters:
// resourceGroupName - name of the resource group to which the resource belongs.
// name - site name.
// functionName - the name of the function.
// keyName - the name of the key.
func (client AppsClient) DeleteFunctionSecret(ctx context.Context, resourceGroupName string, name string, functionName string, keyName string) (result autorest.Response, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/AppsClient.DeleteFunctionSecret")
		defer func() {
			sc := -1
			if result.Response != nil {
				sc = result.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewError("web.AppsClient", "DeleteFunctionSecret", err.Error())
	}

	req, err := client.DeleteFunctionSecretPreparer(ctx, resourceGroupName, name, functionName, keyName)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "DeleteFunctionSecret", nil, "Failure preparing request")
		return
	}

	resp, err := client.DeleteFunctionSecretSender(req)
	if err != nil {
		result.Response = resp
		err = autorest.NewErrorWithError(err, "web.AppsClient", "DeleteFunctionSecret", resp, "Failure sending request")
		return
	}

	result, err = client.DeleteFunctionSecretResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "DeleteFunctionSecret", resp, "Failure responding to request")
	}

	return
}

// DeleteFunctionSecretPreparer prepares the DeleteFunctionSecret request.
func (client AppsClient) DeleteFunctionSecretPreparer(ctx context.Context, resourceGroupName string, name string, functionName string, keyName string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"functionName":      autorest.Encode("path", functionName),
		"keyName":           autorest.Encode("path", keyName),
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2019-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsDelete(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/functions/{functionName}/keys/{keyName}", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// DeleteFunctionSecretSender sends the DeleteFunctionSecret request. The method will close the
// http.Response Body if it receives an error.
func (client AppsClient) DeleteFunctionSecretSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// DeleteFunctionSecretResponder handles the response to the DeleteFunctionSecret request. The method always
// closes the http.Response Body.
func (client AppsClient) DeleteFunctionSecretResponder(resp *http.Response) (result autorest.Response, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusNoContent, http.StatusNotFound),
		autorest.ByClosing())
	result.Response = resp
	return
}

// DeleteFunctionSecretSlot description for Delete a function secret.
// Parameters:
// resourceGroupName - name of the resource group to which the resource belongs.
// name - site name.
// functionName - the name of the function.
// keyName - the name of the key.
// slot - name of the deployment slot.
func (client AppsClient) DeleteFunctionSecretSlot(ctx context.Context, resourceGroupName string, name string, functionName string, keyName string, slot string) (result autorest.Response, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/AppsClient.DeleteFunctionSecretSlot")
		defer func() {
			sc := -1
			if result.Response != nil {
				sc = result.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewError("web.AppsClient", "DeleteFunctionSecretSlot", err.Error())
	}

	req, err := client.DeleteFunctionSecretSlotPreparer(ctx, resourceGroupName, name, functionName, keyName, slot)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "DeleteFunctionSecretSlot", nil, "Failure preparing request")
		return
	}

	resp, err := client.DeleteFunctionSecretSlotSender(req)
	if err != nil {
		result.Response = resp
		err = autorest.NewErrorWithError(err, "web.AppsClient", "DeleteFunctionSecretSlot", resp, "Failure sending request")
		return
	}

	result, err = client.DeleteFunctionSecretSlotResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "DeleteFunctionSecretSlot", resp, "Failure responding to request")
	}

	return
}

// DeleteFunctionSecretSlotPreparer prepares the DeleteFunctionSecretSlot request.
func (client AppsClient) DeleteFunctionSecretSlotPreparer(ctx context.Context, resourceGroupName string, name string, functionName string, keyName string, slot string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"functionName":      autorest.Encode("path", functionName),
		"keyName":           autorest.Encode("path", keyName),
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"slot":              autorest.Encode("path", slot),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2019-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsDelete(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/functions/{functionName}/keys/{keyName}", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// DeleteFunctionSecretSlotSender sends the DeleteFunctionSecretSlot request. The method will close the
// http.Response Body if it receives an error.
func (client AppsClient) DeleteFunctionSecretSlotSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// DeleteFunctionSecretSlotResponder handles the response to the DeleteFunctionSecretSlot request. The method always
// closes the http.Response Body.
func (client AppsClient) DeleteFunctionSecretSlotResponder(resp *http.Response) (result autorest.Response, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusNoContent, http.StatusNotFound),
		autorest.ByClosing())
	result.Response = resp
	return
}

// DeleteHostNameBinding description for Deletes a hostname binding for an app.
// Parameters:
// resourceGroupName - name of the resource group to which the resource belongs.
// name - name of the app.
// hostName - hostname in the hostname binding.
func (client AppsClient) DeleteHostNameBinding(ctx context.Context, resourceGroupName string, name string, hostName string) (result autorest.Response, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/AppsClient.DeleteHostNameBinding")
		defer func() {
			sc := -1
			if result.Response != nil {
				sc = result.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewError("web.AppsClient", "DeleteHostNameBinding", err.Error())
	}

	req, err := client.DeleteHostNameBindingPreparer(ctx, resourceGroupName, name, hostName)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "DeleteHostNameBinding", nil, "Failure preparing request")
		return
	}

	resp, err := client.DeleteHostNameBindingSender(req)
	if err != nil {
		result.Response = resp
		err = autorest.NewErrorWithError(err, "web.AppsClient", "DeleteHostNameBinding", resp, "Failure sending request")
		return
	}

	result, err = client.DeleteHostNameBindingResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "DeleteHostNameBinding", resp, "Failure responding to request")
	}

	return
}

// DeleteHostNameBindingPreparer prepares the DeleteHostNameBinding request.
func (client AppsClient) DeleteHostNameBindingPreparer(ctx context.Context, resourceGroupName string, name string, hostName string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"hostName":          autorest.Encode("path", hostName),
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2019-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsDelete(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/hostNameBindings/{hostName}", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// DeleteHostNameBindingSender sends the DeleteHostNameBinding request. The method will close the
// http.Response Body if it receives an error.
func (client AppsClient) DeleteHostNameBindingSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// DeleteHostNameBindingResponder handles the response to the DeleteHostNameBinding request. The method always
// closes the http.Response Body.
func (client AppsClient) DeleteHostNameBindingResponder(resp *http.Response) (result autorest.Response, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusNoContent),
		autorest.ByClosing())
	result.Response = resp
	return
}

// DeleteHostNameBindingSlot description for Deletes a hostname binding for an app.
// Parameters:
// resourceGroupName - name of the resource group to which the resource belongs.
// name - name of the app.
// slot - name of the deployment slot. If a slot is not specified, the API will delete the binding for the
// production slot.
// hostName - hostname in the hostname binding.
func (client AppsClient) DeleteHostNameBindingSlot(ctx context.Context, resourceGroupName string, name string, slot string, hostName string) (result autorest.Response, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/AppsClient.DeleteHostNameBindingSlot")
		defer func() {
			sc := -1
			if result.Response != nil {
				sc = result.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewError("web.AppsClient", "DeleteHostNameBindingSlot", err.Error())
	}

	req, err := client.DeleteHostNameBindingSlotPreparer(ctx, resourceGroupName, name, slot, hostName)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "DeleteHostNameBindingSlot", nil, "Failure preparing request")
		return
	}

	resp, err := client.DeleteHostNameBindingSlotSender(req)
	if err != nil {
		result.Response = resp
		err = autorest.NewErrorWithError(err, "web.AppsClient", "DeleteHostNameBindingSlot", resp, "Failure sending request")
		return
	}

	result, err = client.DeleteHostNameBindingSlotResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "DeleteHostNameBindingSlot", resp, "Failure responding to request")
	}

	return
}

// DeleteHostNameBindingSlotPreparer prepares the DeleteHostNameBindingSlot request.
func (client AppsClient) DeleteHostNameBindingSlotPreparer(ctx context.Context, resourceGroupName string, name string, slot string, hostName string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"hostName":          autorest.Encode("path", hostName),
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"slot":              autorest.Encode("path", slot),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2019-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsDelete(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/hostNameBindings/{hostName}", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// DeleteHostNameBindingSlotSender sends the DeleteHostNameBindingSlot request. The method will close the
// http.Response Body if it receives an error.
func (client AppsClient) DeleteHostNameBindingSlotSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// DeleteHostNameBindingSlotResponder handles the response to the DeleteHostNameBindingSlot request. The method always
// closes the http.Response Body.
func (client AppsClient) DeleteHostNameBindingSlotResponder(resp *http.Response) (result autorest.Response, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusNoContent),
		autorest.ByClosing())
	result.Response = resp
	return
}

// DeleteHostSecret description for Delete a host level secret.
// Parameters:
// resourceGroupName - name of the resource group to which the resource belongs.
// name - site name.
// keyType - the type of host key.
// keyName - the name of the key.
func (client AppsClient) DeleteHostSecret(ctx context.Context, resourceGroupName string, name string, keyType string, keyName string) (result autorest.Response, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/AppsClient.DeleteHostSecret")
		defer func() {
			sc := -1
			if result.Response != nil {
				sc = result.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewError("web.AppsClient", "DeleteHostSecret", err.Error())
	}

	req, err := client.DeleteHostSecretPreparer(ctx, resourceGroupName, name, keyType, keyName)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "DeleteHostSecret", nil, "Failure preparing request")
		return
	}

	resp, err := client.DeleteHostSecretSender(req)
	if err != nil {
		result.Response = resp
		err = autorest.NewErrorWithError(err, "web.AppsClient", "DeleteHostSecret", resp, "Failure sending request")
		return
	}

	result, err = client.DeleteHostSecretResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "DeleteHostSecret", resp, "Failure responding to request")
	}

	return
}

// DeleteHostSecretPreparer prepares the DeleteHostSecret request.
func (client AppsClient) DeleteHostSecretPreparer(ctx context.Context, resourceGroupName string, name string, keyType string, keyName string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"keyName":           autorest.Encode("path", keyName),
		"keyType":           autorest.Encode("path", keyType),
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2019-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsDelete(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/host/default/{keyType}/{keyName}", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// DeleteHostSecretSender sends the DeleteHostSecret request. The method will close the
// http.Response Body if it receives an error.
func (client AppsClient) DeleteHostSecretSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// DeleteHostSecretResponder handles the response to the DeleteHostSecret request. The method always
// closes the http.Response Body.
func (client AppsClient) DeleteHostSecretResponder(resp *http.Response) (result autorest.Response, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusNoContent, http.StatusNotFound),
		autorest.ByClosing())
	result.Response = resp
	return
}

// DeleteHostSecretSlot description for Delete a host level secret.
// Parameters:
// resourceGroupName - name of the resource group to which the resource belongs.
// name - site name.
// keyType - the type of host key.
// keyName - the name of the key.
// slot - name of the deployment slot.
func (client AppsClient) DeleteHostSecretSlot(ctx context.Context, resourceGroupName string, name string, keyType string, keyName string, slot string) (result autorest.Response, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/AppsClient.DeleteHostSecretSlot")
		defer func() {
			sc := -1
			if result.Response != nil {
				sc = result.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewError("web.AppsClient", "DeleteHostSecretSlot", err.Error())
	}

	req, err := client.DeleteHostSecretSlotPreparer(ctx, resourceGroupName, name, keyType, keyName, slot)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "DeleteHostSecretSlot", nil, "Failure preparing request")
		return
	}

	resp, err := client.DeleteHostSecretSlotSender(req)
	if err != nil {
		result.Response = resp
		err = autorest.NewErrorWithError(err, "web.AppsClient", "DeleteHostSecretSlot", resp, "Failure sending request")
		return
	}

	result, err = client.DeleteHostSecretSlotResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "DeleteHostSecretSlot", resp, "Failure responding to request")
	}

	return
}

// DeleteHostSecretSlotPreparer prepares the DeleteHostSecretSlot request.
func (client AppsClient) DeleteHostSecretSlotPreparer(ctx context.Context, resourceGroupName string, name string, keyType string, keyName string, slot string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"keyName":           autorest.Encode("path", keyName),
		"keyType":           autorest.Encode("path", keyType),
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"slot":              autorest.Encode("path", slot),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2019-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsDelete(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/host/default/{keyType}/{keyName}", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// DeleteHostSecretSlotSender sends the DeleteHostSecretSlot request. The method will close the
// http.Response Body if it receives an error.
func (client AppsClient) DeleteHostSecretSlotSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// DeleteHostSecretSlotResponder handles the response to the DeleteHostSecretSlot request. The method always
// closes the http.Response Body.
func (client AppsClient) DeleteHostSecretSlotResponder(resp *http.Response) (result autorest.Response, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusNoContent, http.StatusNotFound),
		autorest.ByClosing())
	result.Response = resp
	return
}

// DeleteHybridConnection description for Removes a Hybrid Connection from this site.
// Parameters:
// resourceGroupName - name of the resource group to which the resource belongs.
// name - the name of the web app.
// namespaceName - the namespace for this hybrid connection.
// relayName - the relay name for this hybrid connection.
func (client AppsClient) DeleteHybridConnection(ctx context.Context, resourceGroupName string, name string, namespaceName string, relayName string) (result autorest.Response, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/AppsClient.DeleteHybridConnection")
		defer func() {
			sc := -1
			if result.Response != nil {
				sc = result.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewError("web.AppsClient", "DeleteHybridConnection", err.Error())
	}

	req, err := client.DeleteHybridConnectionPreparer(ctx, resourceGroupName, name, namespaceName, relayName)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "DeleteHybridConnection", nil, "Failure preparing request")
		return
	}

	resp, err := client.DeleteHybridConnectionSender(req)
	if err != nil {
		result.Response = resp
		err = autorest.NewErrorWithError(err, "web.AppsClient", "DeleteHybridConnection", resp, "Failure sending request")
		return
	}

	result, err = client.DeleteHybridConnectionResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "DeleteHybridConnection", resp, "Failure responding to request")
	}

	return
}

// DeleteHybridConnectionPreparer prepares the DeleteHybridConnection request.
func (client AppsClient) DeleteHybridConnectionPreparer(ctx context.Context, resourceGroupName string, name string, namespaceName string, relayName string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"namespaceName":     autorest.Encode("path", namespaceName),
		"relayName":         autorest.Encode("path", relayName),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2019-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsDelete(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/hybridConnectionNamespaces/{namespaceName}/relays/{relayName}", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// DeleteHybridConnectionSender sends the DeleteHybridConnection request. The method will close the
// http.Response Body if it receives an error.
func (client AppsClient) DeleteHybridConnectionSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// DeleteHybridConnectionResponder handles the response to the DeleteHybridConnection request. The method always
// closes the http.Response Body.
func (client AppsClient) DeleteHybridConnectionResponder(resp *http.Response) (result autorest.Response, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusNotFound),
		autorest.ByClosing())
	result.Response = resp
	return
}

// DeleteHybridConnectionSlot description for Removes a Hybrid Connection from this site.
// Parameters:
// resourceGroupName - name of the resource group to which the resource belongs.
// name - the name of the web app.
// namespaceName - the namespace for this hybrid connection.
// relayName - the relay name for this hybrid connection.
// slot - the name of the slot for the web app.
func (client AppsClient) DeleteHybridConnectionSlot(ctx context.Context, resourceGroupName string, name string, namespaceName string, relayName string, slot string) (result autorest.Response, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/AppsClient.DeleteHybridConnectionSlot")
		defer func() {
			sc := -1
			if result.Response != nil {
				sc = result.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewError("web.AppsClient", "DeleteHybridConnectionSlot", err.Error())
	}

	req, err := client.DeleteHybridConnectionSlotPreparer(ctx, resourceGroupName, name, namespaceName, relayName, slot)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "DeleteHybridConnectionSlot", nil, "Failure preparing request")
		return
	}

	resp, err := client.DeleteHybridConnectionSlotSender(req)
	if err != nil {
		result.Response = resp
		err = autorest.NewErrorWithError(err, "web.AppsClient", "DeleteHybridConnectionSlot", resp, "Failure sending request")
		return
	}

	result, err = client.DeleteHybridConnectionSlotResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "DeleteHybridConnectionSlot", resp, "Failure responding to request")
	}

	return
}

// DeleteHybridConnectionSlotPreparer prepares the DeleteHybridConnectionSlot request.
func (client AppsClient) DeleteHybridConnectionSlotPreparer(ctx context.Context, resourceGroupName string, name string, namespaceName string, relayName string, slot string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"namespaceName":     autorest.Encode("path", namespaceName),
		"relayName":         autorest.Encode("path", relayName),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"slot":              autorest.Encode("path", slot),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2019-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsDelete(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/hybridConnectionNamespaces/{namespaceName}/relays/{relayName}", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// DeleteHybridConnectionSlotSender sends the DeleteHybridConnectionSlot request. The method will close the
// http.Response Body if it receives an error.
func (client AppsClient) DeleteHybridConnectionSlotSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// DeleteHybridConnectionSlotResponder handles the response to the DeleteHybridConnectionSlot request. The method always
// closes the http.Response Body.
func (client AppsClient) DeleteHybridConnectionSlotResponder(resp *http.Response) (result autorest.Response, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusNotFound),
		autorest.ByClosing())
	result.Response = resp
	return
}

// DeleteInstanceFunctionSlot description for Delete a function for web site, or a deployment slot.
// Parameters:
// resourceGroupName - name of the resource group to which the resource belongs.
// name - site name.
// functionName - function name.
// slot - name of the deployment slot.
func (client AppsClient) DeleteInstanceFunctionSlot(ctx context.Context, resourceGroupName string, name string, functionName string, slot string) (result autorest.Response, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/AppsClient.DeleteInstanceFunctionSlot")
		defer func() {
			sc := -1
			if result.Response != nil {
				sc = result.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewError("web.AppsClient", "DeleteInstanceFunctionSlot", err.Error())
	}

	req, err := client.DeleteInstanceFunctionSlotPreparer(ctx, resourceGroupName, name, functionName, slot)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "DeleteInstanceFunctionSlot", nil, "Failure preparing request")
		return
	}

	resp, err := client.DeleteInstanceFunctionSlotSender(req)
	if err != nil {
		result.Response = resp
		err = autorest.NewErrorWithError(err, "web.AppsClient", "DeleteInstanceFunctionSlot", resp, "Failure sending request")
		return
	}

	result, err = client.DeleteInstanceFunctionSlotResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "DeleteInstanceFunctionSlot", resp, "Failure responding to request")
	}

	return
}

// DeleteInstanceFunctionSlotPreparer prepares the DeleteInstanceFunctionSlot request.
func (client AppsClient) DeleteInstanceFunctionSlotPreparer(ctx context.Context, resourceGroupName string, name string, functionName string, slot string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"functionName":      autorest.Encode("path", functionName),
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"slot":              autorest.Encode("path", slot),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2019-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsDelete(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/functions/{functionName}", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// DeleteInstanceFunctionSlotSender sends the DeleteInstanceFunctionSlot request. The method will close the
// http.Response Body if it receives an error.
func (client AppsClient) DeleteInstanceFunctionSlotSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// DeleteInstanceFunctionSlotResponder handles the response to the DeleteInstanceFunctionSlot request. The method always
// closes the http.Response Body.
func (client AppsClient) DeleteInstanceFunctionSlotResponder(resp *http.Response) (result autorest.Response, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusNoContent, http.StatusNotFound),
		autorest.ByClosing())
	result.Response = resp
	return
}

// DeleteInstanceProcess description for Terminate a process by its ID for a web site, or a deployment slot, or
// specific scaled-out instance in a web site.
// Parameters:
// resourceGroupName - name of the resource group to which the resource belongs.
// name - site name.
// processID - pID.
// instanceID - ID of a specific scaled-out instance. This is the value of the name property in the JSON
// response from "GET api/sites/{siteName}/instances".
func (client AppsClient) DeleteInstanceProcess(ctx context.Context, resourceGroupName string, name string, processID string, instanceID string) (result autorest.Response, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/AppsClient.DeleteInstanceProcess")
		defer func() {
			sc := -1
			if result.Response != nil {
				sc = result.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewError("web.AppsClient", "DeleteInstanceProcess", err.Error())
	}

	req, err := client.DeleteInstanceProcessPreparer(ctx, resourceGroupName, name, processID, instanceID)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "DeleteInstanceProcess", nil, "Failure preparing request")
		return
	}

	resp, err := client.DeleteInstanceProcessSender(req)
	if err != nil {
		result.Response = resp
		err = autorest.NewErrorWithError(err, "web.AppsClient", "DeleteInstanceProcess", resp, "Failure sending request")
		return
	}

	result, err = client.DeleteInstanceProcessResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "DeleteInstanceProcess", resp, "Failure responding to request")
	}

	return
}

// DeleteInstanceProcessPreparer prepares the DeleteInstanceProcess request.
func (client AppsClient) DeleteInstanceProcessPreparer(ctx context.Context, resourceGroupName string, name string, processID string, instanceID string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"instanceId":        autorest.Encode("path", instanceID),
		"name":              autorest.Encode("path", name),
		"processId":         autorest.Encode("path", processID),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2019-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsDelete(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/instances/{instanceId}/processes/{processId}", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// DeleteInstanceProcessSender sends the DeleteInstanceProcess request. The method will close the
// http.Response Body if it receives an error.
func (client AppsClient) DeleteInstanceProcessSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// DeleteInstanceProcessResponder handles the response to the DeleteInstanceProcess request. The method always
// closes the http.Response Body.
func (client AppsClient) DeleteInstanceProcessResponder(resp *http.Response) (result autorest.Response, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusNoContent, http.StatusNotFound),
		autorest.ByClosing())
	result.Response = resp
	return
}

// DeleteInstanceProcessSlot description for Terminate a process by its ID for a web site, or a deployment slot, or
// specific scaled-out instance in a web site.
// Parameters:
// resourceGroupName - name of the resource group to which the resource belongs.
// name - site name.
// processID - pID.
// slot - name of the deployment slot. If a slot is not specified, the API returns deployments for the
// production slot.
// instanceID - ID of a specific scaled-out instance. This is the value of the name property in the JSON
// response from "GET api/sites/{siteName}/instances".
func (client AppsClient) DeleteInstanceProcessSlot(ctx context.Context, resourceGroupName string, name string, processID string, slot string, instanceID string) (result autorest.Response, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/AppsClient.DeleteInstanceProcessSlot")
		defer func() {
			sc := -1
			if result.Response != nil {
				sc = result.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewError("web.AppsClient", "DeleteInstanceProcessSlot", err.Error())
	}

	req, err := client.DeleteInstanceProcessSlotPreparer(ctx, resourceGroupName, name, processID, slot, instanceID)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "DeleteInstanceProcessSlot", nil, "Failure preparing request")
		return
	}

	resp, err := client.DeleteInstanceProcessSlotSender(req)
	if err != nil {
		result.Response = resp
		err = autorest.NewErrorWithError(err, "web.AppsClient", "DeleteInstanceProcessSlot", resp, "Failure sending request")
		return
	}

	result, err = client.DeleteInstanceProcessSlotResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "DeleteInstanceProcessSlot", resp, "Failure responding to request")
	}

	return
}

// DeleteInstanceProcessSlotPreparer prepares the DeleteInstanceProcessSlot request.
func (client AppsClient) DeleteInstanceProcessSlotPreparer(ctx context.Context, resourceGroupName string, name string, processID string, slot string, instanceID string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"instanceId":        autorest.Encode("path", instanceID),
		"name":              autorest.Encode("path", name),
		"processId":         autorest.Encode("path", processID),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"slot":              autorest.Encode("path", slot),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2019-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsDelete(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/instances/{instanceId}/processes/{processId}", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// DeleteInstanceProcessSlotSender sends the DeleteInstanceProcessSlot request. The method will close the
// http.Response Body if it receives an error.
func (client AppsClient) DeleteInstanceProcessSlotSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// DeleteInstanceProcessSlotResponder handles the response to the DeleteInstanceProcessSlot request. The method always
// closes the http.Response Body.
func (client AppsClient) DeleteInstanceProcessSlotResponder(resp *http.Response) (result autorest.Response, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusNoContent, http.StatusNotFound),
		autorest.ByClosing())
	result.Response = resp
	return
}

// DeletePremierAddOn description for Delete a premier add-on from an app.
// Parameters:
// resourceGroupName - name of the resource group to which the resource belongs.
// name - name of the app.
// premierAddOnName - add-on name.
func (client AppsClient) DeletePremierAddOn(ctx context.Context, resourceGroupName string, name string, premierAddOnName string) (result autorest.Response, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/AppsClient.DeletePremierAddOn")
		defer func() {
			sc := -1
			if result.Response != nil {
				sc = result.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewError("web.AppsClient", "DeletePremierAddOn", err.Error())
	}

	req, err := client.DeletePremierAddOnPreparer(ctx, resourceGroupName, name, premierAddOnName)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "DeletePremierAddOn", nil, "Failure preparing request")
		return
	}

	resp, err := client.DeletePremierAddOnSender(req)
	if err != nil {
		result.Response = resp
		err = autorest.NewErrorWithError(err, "web.AppsClient", "DeletePremierAddOn", resp, "Failure sending request")
		return
	}

	result, err = client.DeletePremierAddOnResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "DeletePremierAddOn", resp, "Failure responding to request")
	}

	return
}

// DeletePremierAddOnPreparer prepares the DeletePremierAddOn request.
func (client AppsClient) DeletePremierAddOnPreparer(ctx context.Context, resourceGroupName string, name string, premierAddOnName string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"premierAddOnName":  autorest.Encode("path", premierAddOnName),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2019-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsDelete(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/premieraddons/{premierAddOnName}", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// DeletePremierAddOnSender sends the DeletePremierAddOn request. The method will close the
// http.Response Body if it receives an error.
func (client AppsClient) DeletePremierAddOnSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// DeletePremierAddOnResponder handles the response to the DeletePremierAddOn request. The method always
// closes the http.Response Body.
func (client AppsClient) DeletePremierAddOnResponder(resp *http.Response) (result autorest.Response, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByClosing())
	result.Response = resp
	return
}

// DeletePremierAddOnSlot description for Delete a premier add-on from an app.
// Parameters:
// resourceGroupName - name of the resource group to which the resource belongs.
// name - name of the app.
// premierAddOnName - add-on name.
// slot - name of the deployment slot. If a slot is not specified, the API will delete the named add-on for the
// production slot.
func (client AppsClient) DeletePremierAddOnSlot(ctx context.Context, resourceGroupName string, name string, premierAddOnName string, slot string) (result autorest.Response, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/AppsClient.DeletePremierAddOnSlot")
		defer func() {
			sc := -1
			if result.Response != nil {
				sc = result.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewError("web.AppsClient", "DeletePremierAddOnSlot", err.Error())
	}

	req, err := client.DeletePremierAddOnSlotPreparer(ctx, resourceGroupName, name, premierAddOnName, slot)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "DeletePremierAddOnSlot", nil, "Failure preparing request")
		return
	}

	resp, err := client.DeletePremierAddOnSlotSender(req)
	if err != nil {
		result.Response = resp
		err = autorest.NewErrorWithError(err, "web.AppsClient", "DeletePremierAddOnSlot", resp, "Failure sending request")
		return
	}

	result, err = client.DeletePremierAddOnSlotResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "DeletePremierAddOnSlot", resp, "Failure responding to request")
	}

	return
}

// DeletePremierAddOnSlotPreparer prepares the DeletePremierAddOnSlot request.
func (client AppsClient) DeletePremierAddOnSlotPreparer(ctx context.Context, resourceGroupName string, name string, premierAddOnName string, slot string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"premierAddOnName":  autorest.Encode("path", premierAddOnName),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"slot":              autorest.Encode("path", slot),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2019-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsDelete(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/premieraddons/{premierAddOnName}", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// DeletePremierAddOnSlotSender sends the DeletePremierAddOnSlot request. The method will close the
// http.Response Body if it receives an error.
func (client AppsClient) DeletePremierAddOnSlotSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// DeletePremierAddOnSlotResponder handles the response to the DeletePremierAddOnSlot request. The method always
// closes the http.Response Body.
func (client AppsClient) DeletePremierAddOnSlotResponder(resp *http.Response) (result autorest.Response, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByClosing())
	result.Response = resp
	return
}

// DeleteProcess description for Terminate a process by its ID for a web site, or a deployment slot, or specific
// scaled-out instance in a web site.
// Parameters:
// resourceGroupName - name of the resource group to which the resource belongs.
// name - site name.
// processID - pID.
func (client AppsClient) DeleteProcess(ctx context.Context, resourceGroupName string, name string, processID string) (result autorest.Response, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/AppsClient.DeleteProcess")
		defer func() {
			sc := -1
			if result.Response != nil {
				sc = result.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewError("web.AppsClient", "DeleteProcess", err.Error())
	}

	req, err := client.DeleteProcessPreparer(ctx, resourceGroupName, name, processID)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "DeleteProcess", nil, "Failure preparing request")
		return
	}

	resp, err := client.DeleteProcessSender(req)
	if err != nil {
		result.Response = resp
		err = autorest.NewErrorWithError(err, "web.AppsClient", "DeleteProcess", resp, "Failure sending request")
		return
	}

	result, err = client.DeleteProcessResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "DeleteProcess", resp, "Failure responding to request")
	}

	return
}

// DeleteProcessPreparer prepares the DeleteProcess request.
func (client AppsClient) DeleteProcessPreparer(ctx context.Context, resourceGroupName string, name string, processID string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"processId":         autorest.Encode("path", processID),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2019-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsDelete(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/processes/{processId}", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// DeleteProcessSender sends the DeleteProcess request. The method will close the
// http.Response Body if it receives an error.
func (client AppsClient) DeleteProcessSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// DeleteProcessResponder handles the response to the DeleteProcess request. The method always
// closes the http.Response Body.
func (client AppsClient) DeleteProcessResponder(resp *http.Response) (result autorest.Response, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusNoContent, http.StatusNotFound),
		autorest.ByClosing())
	result.Response = resp
	return
}

// DeleteProcessSlot description for Terminate a process by its ID for a web site, or a deployment slot, or specific
// scaled-out instance in a web site.
// Parameters:
// resourceGroupName - name of the resource group to which the resource belongs.
// name - site name.
// processID - pID.
// slot - name of the deployment slot. If a slot is not specified, the API returns deployments for the
// production slot.
func (client AppsClient) DeleteProcessSlot(ctx context.Context, resourceGroupName string, name string, processID string, slot string) (result autorest.Response, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/AppsClient.DeleteProcessSlot")
		defer func() {
			sc := -1
			if result.Response != nil {
				sc = result.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewError("web.AppsClient", "DeleteProcessSlot", err.Error())
	}

	req, err := client.DeleteProcessSlotPreparer(ctx, resourceGroupName, name, processID, slot)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "DeleteProcessSlot", nil, "Failure preparing request")
		return
	}

	resp, err := client.DeleteProcessSlotSender(req)
	if err != nil {
		result.Response = resp
		err = autorest.NewErrorWithError(err, "web.AppsClient", "DeleteProcessSlot", resp, "Failure sending request")
		return
	}

	result, err = client.DeleteProcessSlotResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "DeleteProcessSlot", resp, "Failure responding to request")
	}

	return
}

// DeleteProcessSlotPreparer prepares the DeleteProcessSlot request.
func (client AppsClient) DeleteProcessSlotPreparer(ctx context.Context, resourceGroupName string, name string, processID string, slot string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"processId":         autorest.Encode("path", processID),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"slot":              autorest.Encode("path", slot),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2019-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsDelete(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/processes/{processId}", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// DeleteProcessSlotSender sends the DeleteProcessSlot request. The method will close the
// http.Response Body if it receives an error.
func (client AppsClient) DeleteProcessSlotSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// DeleteProcessSlotResponder handles the response to the DeleteProcessSlot request. The method always
// closes the http.Response Body.
func (client AppsClient) DeleteProcessSlotResponder(resp *http.Response) (result autorest.Response, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusNoContent, http.StatusNotFound),
		autorest.ByClosing())
	result.Response = resp
	return
}

// DeletePublicCertificate description for Deletes a hostname binding for an app.
// Parameters:
// resourceGroupName - name of the resource group to which the resource belongs.
// name - name of the app.
// publicCertificateName - public certificate name.
func (client AppsClient) DeletePublicCertificate(ctx context.Context, resourceGroupName string, name string, publicCertificateName string) (result autorest.Response, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/AppsClient.DeletePublicCertificate")
		defer func() {
			sc := -1
			if result.Response != nil {
				sc = result.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewError("web.AppsClient", "DeletePublicCertificate", err.Error())
	}

	req, err := client.DeletePublicCertificatePreparer(ctx, resourceGroupName, name, publicCertificateName)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "DeletePublicCertificate", nil, "Failure preparing request")
		return
	}

	resp, err := client.DeletePublicCertificateSender(req)
	if err != nil {
		result.Response = resp
		err = autorest.NewErrorWithError(err, "web.AppsClient", "DeletePublicCertificate", resp, "Failure sending request")
		return
	}

	result, err = client.DeletePublicCertificateResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "DeletePublicCertificate", resp, "Failure responding to request")
	}

	return
}

// DeletePublicCertificatePreparer prepares the DeletePublicCertificate request.
func (client AppsClient) DeletePublicCertificatePreparer(ctx context.Context, resourceGroupName string, name string, publicCertificateName string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":                  autorest.Encode("path", name),
		"publicCertificateName": autorest.Encode("path", publicCertificateName),
		"resourceGroupName":     autorest.Encode("path", resourceGroupName),
		"subscriptionId":        autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2019-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsDelete(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/publicCertificates/{publicCertificateName}", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// DeletePublicCertificateSender sends the DeletePublicCertificate request. The method will close the
// http.Response Body if it receives an error.
func (client AppsClient) DeletePublicCertificateSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// DeletePublicCertificateResponder handles the response to the DeletePublicCertificate request. The method always
// closes the http.Response Body.
func (client AppsClient) DeletePublicCertificateResponder(resp *http.Response) (result autorest.Response, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusNoContent),
		autorest.ByClosing())
	result.Response = resp
	return
}

// DeletePublicCertificateSlot description for Deletes a hostname binding for an app.
// Parameters:
// resourceGroupName - name of the resource group to which the resource belongs.
// name - name of the app.
// slot - name of the deployment slot. If a slot is not specified, the API will delete the binding for the
// production slot.
// publicCertificateName - public certificate name.
func (client AppsClient) DeletePublicCertificateSlot(ctx context.Context, resourceGroupName string, name string, slot string, publicCertificateName string) (result autorest.Response, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/AppsClient.DeletePublicCertificateSlot")
		defer func() {
			sc := -1
			if result.Response != nil {
				sc = result.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewError("web.AppsClient", "DeletePublicCertificateSlot", err.Error())
	}

	req, err := client.DeletePublicCertificateSlotPreparer(ctx, resourceGroupName, name, slot, publicCertificateName)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "DeletePublicCertificateSlot", nil, "Failure preparing request")
		return
	}

	resp, err := client.DeletePublicCertificateSlotSender(req)
	if err != nil {
		result.Response = resp
		err = autorest.NewErrorWithError(err, "web.AppsClient", "DeletePublicCertificateSlot", resp, "Failure sending request")
		return
	}

	result, err = client.DeletePublicCertificateSlotResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "DeletePublicCertificateSlot", resp, "Failure responding to request")
	}

	return
}

// DeletePublicCertificateSlotPreparer prepares the DeletePublicCertificateSlot request.
func (client AppsClient) DeletePublicCertificateSlotPreparer(ctx context.Context, resourceGroupName string, name string, slot string, publicCertificateName string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":                  autorest.Encode("path", name),
		"publicCertificateName": autorest.Encode("path", publicCertificateName),
		"resourceGroupName":     autorest.Encode("path", resourceGroupName),
		"slot":                  autorest.Encode("path", slot),
		"subscriptionId":        autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2019-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsDelete(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/publicCertificates/{publicCertificateName}", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// DeletePublicCertificateSlotSender sends the DeletePublicCertificateSlot request. The method will close the
// http.Response Body if it receives an error.
func (client AppsClient) DeletePublicCertificateSlotSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// DeletePublicCertificateSlotResponder handles the response to the DeletePublicCertificateSlot request. The method always
// closes the http.Response Body.
func (client AppsClient) DeletePublicCertificateSlotResponder(resp *http.Response) (result autorest.Response, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusNoContent),
		autorest.ByClosing())
	result.Response = resp
	return
}

// DeleteRelayServiceConnection description for Deletes a relay service connection by its name.
// Parameters:
// resourceGroupName - name of the resource group to which the resource belongs.
// name - name of the app.
// entityName - name of the hybrid connection configuration.
func (client AppsClient) DeleteRelayServiceConnection(ctx context.Context, resourceGroupName string, name string, entityName string) (result autorest.Response, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/AppsClient.DeleteRelayServiceConnection")
		defer func() {
			sc := -1
			if result.Response != nil {
				sc = result.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewError("web.AppsClient", "DeleteRelayServiceConnection", err.Error())
	}

	req, err := client.DeleteRelayServiceConnectionPreparer(ctx, resourceGroupName, name, entityName)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "DeleteRelayServiceConnection", nil, "Failure preparing request")
		return
	}

	resp, err := client.DeleteRelayServiceConnectionSender(req)
	if err != nil {
		result.Response = resp
		err = autorest.NewErrorWithError(err, "web.AppsClient", "DeleteRelayServiceConnection", resp, "Failure sending request")
		return
	}

	result, err = client.DeleteRelayServiceConnectionResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "DeleteRelayServiceConnection", resp, "Failure responding to request")
	}

	return
}

// DeleteRelayServiceConnectionPreparer prepares the DeleteRelayServiceConnection request.
func (client AppsClient) DeleteRelayServiceConnectionPreparer(ctx context.Context, resourceGroupName string, name string, entityName string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"entityName":        autorest.Encode("path", entityName),
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2019-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsDelete(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/hybridconnection/{entityName}", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// DeleteRelayServiceConnectionSender sends the DeleteRelayServiceConnection request. The method will close the
// http.Response Body if it receives an error.
func (client AppsClient) DeleteRelayServiceConnectionSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// DeleteRelayServiceConnectionResponder handles the response to the DeleteRelayServiceConnection request. The method always
// closes the http.Response Body.
func (client AppsClient) DeleteRelayServiceConnectionResponder(resp *http.Response) (result autorest.Response, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusNotFound),
		autorest.ByClosing())
	result.Response = resp
	return
}

// DeleteRelayServiceConnectionSlot description for Deletes a relay service connection by its name.
// Parameters:
// resourceGroupName - name of the resource group to which the resource belongs.
// name - name of the app.
// entityName - name of the hybrid connection configuration.
// slot - name of the deployment slot. If a slot is not specified, the API will delete a hybrid connection for
// the production slot.
func (client AppsClient) DeleteRelayServiceConnectionSlot(ctx context.Context, resourceGroupName string, name string, entityName string, slot string) (result autorest.Response, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/AppsClient.DeleteRelayServiceConnectionSlot")
		defer func() {
			sc := -1
			if result.Response != nil {
				sc = result.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewError("web.AppsClient", "DeleteRelayServiceConnectionSlot", err.Error())
	}

	req, err := client.DeleteRelayServiceConnectionSlotPreparer(ctx, resourceGroupName, name, entityName, slot)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "DeleteRelayServiceConnectionSlot", nil, "Failure preparing request")
		return
	}

	resp, err := client.DeleteRelayServiceConnectionSlotSender(req)
	if err != nil {
		result.Response = resp
		err = autorest.NewErrorWithError(err, "web.AppsClient", "DeleteRelayServiceConnectionSlot", resp, "Failure sending request")
		return
	}

	result, err = client.DeleteRelayServiceConnectionSlotResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "DeleteRelayServiceConnectionSlot", resp, "Failure responding to request")
	}

	return
}

// DeleteRelayServiceConnectionSlotPreparer prepares the DeleteRelayServiceConnectionSlot request.
func (client AppsClient) DeleteRelayServiceConnectionSlotPreparer(ctx context.Context, resourceGroupName string, name string, entityName string, slot string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"entityName":        autorest.Encode("path", entityName),
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"slot":              autorest.Encode("path", slot),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2019-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsDelete(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/hybridconnection/{entityName}", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// DeleteRelayServiceConnectionSlotSender sends the DeleteRelayServiceConnectionSlot request. The method will close the
// http.Response Body if it receives an error.
func (client AppsClient) DeleteRelayServiceConnectionSlotSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// DeleteRelayServiceConnectionSlotResponder handles the response to the DeleteRelayServiceConnectionSlot request. The method always
// closes the http.Response Body.
func (client AppsClient) DeleteRelayServiceConnectionSlotResponder(resp *http.Response) (result autorest.Response, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusNotFound),
		autorest.ByClosing())
	result.Response = resp
	return
}

// DeleteSiteExtension description for Remove a site extension from a web site, or a deployment slot.
// Parameters:
// resourceGroupName - name of the resource group to which the resource belongs.
// name - site name.
// siteExtensionID - site extension name.
func (client AppsClient) DeleteSiteExtension(ctx context.Context, resourceGroupName string, name string, siteExtensionID string) (result autorest.Response, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/AppsClient.DeleteSiteExtension")
		defer func() {
			sc := -1
			if result.Response != nil {
				sc = result.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewError("web.AppsClient", "DeleteSiteExtension", err.Error())
	}

	req, err := client.DeleteSiteExtensionPreparer(ctx, resourceGroupName, name, siteExtensionID)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "DeleteSiteExtension", nil, "Failure preparing request")
		return
	}

	resp, err := client.DeleteSiteExtensionSender(req)
	if err != nil {
		result.Response = resp
		err = autorest.NewErrorWithError(err, "web.AppsClient", "DeleteSiteExtension", resp, "Failure sending request")
		return
	}

	result, err = client.DeleteSiteExtensionResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "DeleteSiteExtension", resp, "Failure responding to request")
	}

	return
}

// DeleteSiteExtensionPreparer prepares the DeleteSiteExtension request.
func (client AppsClient) DeleteSiteExtensionPreparer(ctx context.Context, resourceGroupName string, name string, siteExtensionID string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"siteExtensionId":   autorest.Encode("path", siteExtensionID),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2019-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsDelete(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/siteextensions/{siteExtensionId}", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// DeleteSiteExtensionSender sends the DeleteSiteExtension request. The method will close the
// http.Response Body if it receives an error.
func (client AppsClient) DeleteSiteExtensionSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// DeleteSiteExtensionResponder handles the response to the DeleteSiteExtension request. The method always
// closes the http.Response Body.
func (client AppsClient) DeleteSiteExtensionResponder(resp *http.Response) (result autorest.Response, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusNoContent, http.StatusNotFound),
		autorest.ByClosing())
	result.Response = resp
	return
}

// DeleteSiteExtensionSlot description for Remove a site extension from a web site, or a deployment slot.
// Parameters:
// resourceGroupName - name of the resource group to which the resource belongs.
// name - site name.
// siteExtensionID - site extension name.
// slot - name of the deployment slot. If a slot is not specified, the API deletes a deployment for the
// production slot.
func (client AppsClient) DeleteSiteExtensionSlot(ctx context.Context, resourceGroupName string, name string, siteExtensionID string, slot string) (result autorest.Response, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/AppsClient.DeleteSiteExtensionSlot")
		defer func() {
			sc := -1
			if result.Response != nil {
				sc = result.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewError("web.AppsClient", "DeleteSiteExtensionSlot", err.Error())
	}

	req, err := client.DeleteSiteExtensionSlotPreparer(ctx, resourceGroupName, name, siteExtensionID, slot)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "DeleteSiteExtensionSlot", nil, "Failure preparing request")
		return
	}

	resp, err := client.DeleteSiteExtensionSlotSender(req)
	if err != nil {
		result.Response = resp
		err = autorest.NewErrorWithError(err, "web.AppsClient", "DeleteSiteExtensionSlot", resp, "Failure sending request")
		return
	}

	result, err = client.DeleteSiteExtensionSlotResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "DeleteSiteExtensionSlot", resp, "Failure responding to request")
	}

	return
}

// DeleteSiteExtensionSlotPreparer prepares the DeleteSiteExtensionSlot request.
func (client AppsClient) DeleteSiteExtensionSlotPreparer(ctx context.Context, resourceGroupName string, name string, siteExtensionID string, slot string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"siteExtensionId":   autorest.Encode("path", siteExtensionID),
		"slot":              autorest.Encode("path", slot),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2019-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsDelete(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/siteextensions/{siteExtensionId}", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// DeleteSiteExtensionSlotSender sends the DeleteSiteExtensionSlot request. The method will close the
// http.Response Body if it receives an error.
func (client AppsClient) DeleteSiteExtensionSlotSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// DeleteSiteExtensionSlotResponder handles the response to the DeleteSiteExtensionSlot request. The method always
// closes the http.Response Body.
func (client AppsClient) DeleteSiteExtensionSlotResponder(resp *http.Response) (result autorest.Response, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusNoContent, http.StatusNotFound),
		autorest.ByClosing())
	result.Response = resp
	return
}

// DeleteSlot description for Deletes a web, mobile, or API app, or one of the deployment slots.
// Parameters:
// resourceGroupName - name of the resource group to which the resource belongs.
// name - name of the app to delete.
// slot - name of the deployment slot to delete. By default, the API deletes the production slot.
// deleteMetrics - if true, web app metrics are also deleted.
// deleteEmptyServerFarm - specify true if the App Service plan will be empty after app deletion and you want
// to delete the empty App Service plan. By default, the empty App Service plan is not deleted.
func (client AppsClient) DeleteSlot(ctx context.Context, resourceGroupName string, name string, slot string, deleteMetrics *bool, deleteEmptyServerFarm *bool) (result autorest.Response, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/AppsClient.DeleteSlot")
		defer func() {
			sc := -1
			if result.Response != nil {
				sc = result.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewError("web.AppsClient", "DeleteSlot", err.Error())
	}

	req, err := client.DeleteSlotPreparer(ctx, resourceGroupName, name, slot, deleteMetrics, deleteEmptyServerFarm)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "DeleteSlot", nil, "Failure preparing request")
		return
	}

	resp, err := client.DeleteSlotSender(req)
	if err != nil {
		result.Response = resp
		err = autorest.NewErrorWithError(err, "web.AppsClient", "DeleteSlot", resp, "Failure sending request")
		return
	}

	result, err = client.DeleteSlotResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "DeleteSlot", resp, "Failure responding to request")
	}

	return
}

// DeleteSlotPreparer prepares the DeleteSlot request.
func (client AppsClient) DeleteSlotPreparer(ctx context.Context, resourceGroupName string, name string, slot string, deleteMetrics *bool, deleteEmptyServerFarm *bool) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"slot":              autorest.Encode("path", slot),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2019-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}
	if deleteMetrics != nil {
		queryParameters["deleteMetrics"] = autorest.Encode("query", *deleteMetrics)
	}
	if deleteEmptyServerFarm != nil {
		queryParameters["deleteEmptyServerFarm"] = autorest.Encode("query", *deleteEmptyServerFarm)
	}

	preparer := autorest.CreatePreparer(
		autorest.AsDelete(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// DeleteSlotSender sends the DeleteSlot request. The method will close the
// http.Response Body if it receives an error.
func (client AppsClient) DeleteSlotSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// DeleteSlotResponder handles the response to the DeleteSlot request. The method always
// closes the http.Response Body.
func (client AppsClient) DeleteSlotResponder(resp *http.Response) (result autorest.Response, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusNoContent, http.StatusNotFound),
		autorest.ByClosing())
	result.Response = resp
	return
}

// DeleteSourceControl description for Deletes the source control configuration of an app.
// Parameters:
// resourceGroupName - name of the resource group to which the resource belongs.
// name - name of the app.
func (client AppsClient) DeleteSourceControl(ctx context.Context, resourceGroupName string, name string) (result autorest.Response, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/AppsClient.DeleteSourceControl")
		defer func() {
			sc := -1
			if result.Response != nil {
				sc = result.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewError("web.AppsClient", "DeleteSourceControl", err.Error())
	}

	req, err := client.DeleteSourceControlPreparer(ctx, resourceGroupName, name)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "DeleteSourceControl", nil, "Failure preparing request")
		return
	}

	resp, err := client.DeleteSourceControlSender(req)
	if err != nil {
		result.Response = resp
		err = autorest.NewErrorWithError(err, "web.AppsClient", "DeleteSourceControl", resp, "Failure sending request")
		return
	}

	result, err = client.DeleteSourceControlResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "DeleteSourceControl", resp, "Failure responding to request")
	}

	return
}

// DeleteSourceControlPreparer prepares the DeleteSourceControl request.
func (client AppsClient) DeleteSourceControlPreparer(ctx context.Context, resourceGroupName string, name string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2019-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsDelete(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/sourcecontrols/web", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// DeleteSourceControlSender sends the DeleteSourceControl request. The method will close the
// http.Response Body if it receives an error.
func (client AppsClient) DeleteSourceControlSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// DeleteSourceControlResponder handles the response to the DeleteSourceControl request. The method always
// closes the http.Response Body.
func (client AppsClient) DeleteSourceControlResponder(resp *http.Response) (result autorest.Response, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusAccepted, http.StatusNotFound),
		autorest.ByClosing())
	result.Response = resp
	return
}

// DeleteSourceControlSlot description for Deletes the source control configuration of an app.
// Parameters:
// resourceGroupName - name of the resource group to which the resource belongs.
// name - name of the app.
// slot - name of the deployment slot. If a slot is not specified, the API will delete the source control
// configuration for the production slot.
func (client AppsClient) DeleteSourceControlSlot(ctx context.Context, resourceGroupName string, name string, slot string) (result autorest.Response, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/AppsClient.DeleteSourceControlSlot")
		defer func() {
			sc := -1
			if result.Response != nil {
				sc = result.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewError("web.AppsClient", "DeleteSourceControlSlot", err.Error())
	}

	req, err := client.DeleteSourceControlSlotPreparer(ctx, resourceGroupName, name, slot)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "DeleteSourceControlSlot", nil, "Failure preparing request")
		return
	}

	resp, err := client.DeleteSourceControlSlotSender(req)
	if err != nil {
		result.Response = resp
		err = autorest.NewErrorWithError(err, "web.AppsClient", "DeleteSourceControlSlot", resp, "Failure sending request")
		return
	}

	result, err = client.DeleteSourceControlSlotResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "DeleteSourceControlSlot", resp, "Failure responding to request")
	}

	return
}

// DeleteSourceControlSlotPreparer prepares the DeleteSourceControlSlot request.
func (client AppsClient) DeleteSourceControlSlotPreparer(ctx context.Context, resourceGroupName string, name string, slot string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"slot":              autorest.Encode("path", slot),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2019-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsDelete(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/sourcecontrols/web", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// DeleteSourceControlSlotSender sends the DeleteSourceControlSlot request. The method will close the
// http.Response Body if it receives an error.
func (client AppsClient) DeleteSourceControlSlotSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// DeleteSourceControlSlotResponder handles the response to the DeleteSourceControlSlot request. The method always
// closes the http.Response Body.
func (client AppsClient) DeleteSourceControlSlotResponder(resp *http.Response) (result autorest.Response, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusAccepted, http.StatusNotFound),
		autorest.ByClosing())
	result.Response = resp
	return
}

// DeleteSwiftVirtualNetwork description for Deletes a Swift Virtual Network connection from an app (or deployment
// slot).
// Parameters:
// resourceGroupName - name of the resource group to which the resource belongs.
// name - name of the app.
func (client AppsClient) DeleteSwiftVirtualNetwork(ctx context.Context, resourceGroupName string, name string) (result autorest.Response, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/AppsClient.DeleteSwiftVirtualNetwork")
		defer func() {
			sc := -1
			if result.Response != nil {
				sc = result.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewError("web.AppsClient", "DeleteSwiftVirtualNetwork", err.Error())
	}

	req, err := client.DeleteSwiftVirtualNetworkPreparer(ctx, resourceGroupName, name)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "DeleteSwiftVirtualNetwork", nil, "Failure preparing request")
		return
	}

	resp, err := client.DeleteSwiftVirtualNetworkSender(req)
	if err != nil {
		result.Response = resp
		err = autorest.NewErrorWithError(err, "web.AppsClient", "DeleteSwiftVirtualNetwork", resp, "Failure sending request")
		return
	}

	result, err = client.DeleteSwiftVirtualNetworkResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "DeleteSwiftVirtualNetwork", resp, "Failure responding to request")
	}

	return
}

// DeleteSwiftVirtualNetworkPreparer prepares the DeleteSwiftVirtualNetwork request.
func (client AppsClient) DeleteSwiftVirtualNetworkPreparer(ctx context.Context, resourceGroupName string, name string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2019-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsDelete(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/networkConfig/virtualNetwork", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// DeleteSwiftVirtualNetworkSender sends the DeleteSwiftVirtualNetwork request. The method will close the
// http.Response Body if it receives an error.
func (client AppsClient) DeleteSwiftVirtualNetworkSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// DeleteSwiftVirtualNetworkResponder handles the response to the DeleteSwiftVirtualNetwork request. The method always
// closes the http.Response Body.
func (client AppsClient) DeleteSwiftVirtualNetworkResponder(resp *http.Response) (result autorest.Response, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusNotFound),
		autorest.ByClosing())
	result.Response = resp
	return
}

// DeleteSwiftVirtualNetworkSlot description for Deletes a Swift Virtual Network connection from an app (or deployment
// slot).
// Parameters:
// resourceGroupName - name of the resource group to which the resource belongs.
// name - name of the app.
// slot - name of the deployment slot. If a slot is not specified, the API will delete the connection for the
// production slot.
func (client AppsClient) DeleteSwiftVirtualNetworkSlot(ctx context.Context, resourceGroupName string, name string, slot string) (result autorest.Response, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/AppsClient.DeleteSwiftVirtualNetworkSlot")
		defer func() {
			sc := -1
			if result.Response != nil {
				sc = result.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewError("web.AppsClient", "DeleteSwiftVirtualNetworkSlot", err.Error())
	}

	req, err := client.DeleteSwiftVirtualNetworkSlotPreparer(ctx, resourceGroupName, name, slot)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "DeleteSwiftVirtualNetworkSlot", nil, "Failure preparing request")
		return
	}

	resp, err := client.DeleteSwiftVirtualNetworkSlotSender(req)
	if err != nil {
		result.Response = resp
		err = autorest.NewErrorWithError(err, "web.AppsClient", "DeleteSwiftVirtualNetworkSlot", resp, "Failure sending request")
		return
	}

	result, err = client.DeleteSwiftVirtualNetworkSlotResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "DeleteSwiftVirtualNetworkSlot", resp, "Failure responding to request")
	}

	return
}

// DeleteSwiftVirtualNetworkSlotPreparer prepares the DeleteSwiftVirtualNetworkSlot request.
func (client AppsClient) DeleteSwiftVirtualNetworkSlotPreparer(ctx context.Context, resourceGroupName string, name string, slot string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"slot":              autorest.Encode("path", slot),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2019-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsDelete(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/networkConfig/virtualNetwork", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// DeleteSwiftVirtualNetworkSlotSender sends the DeleteSwiftVirtualNetworkSlot request. The method will close the
// http.Response Body if it receives an error.
func (client AppsClient) DeleteSwiftVirtualNetworkSlotSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// DeleteSwiftVirtualNetworkSlotResponder handles the response to the DeleteSwiftVirtualNetworkSlot request. The method always
// closes the http.Response Body.
func (client AppsClient) DeleteSwiftVirtualNetworkSlotResponder(resp *http.Response) (result autorest.Response, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusNotFound),
		autorest.ByClosing())
	result.Response = resp
	return
}

// DeleteTriggeredWebJob description for Delete a triggered web job by its ID for an app, or a deployment slot.
// Parameters:
// resourceGroupName - name of the resource group to which the resource belongs.
// name - site name.
// webJobName - name of Web Job.
func (client AppsClient) DeleteTriggeredWebJob(ctx context.Context, resourceGroupName string, name string, webJobName string) (result autorest.Response, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/AppsClient.DeleteTriggeredWebJob")
		defer func() {
			sc := -1
			if result.Response != nil {
				sc = result.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewError("web.AppsClient", "DeleteTriggeredWebJob", err.Error())
	}

	req, err := client.DeleteTriggeredWebJobPreparer(ctx, resourceGroupName, name, webJobName)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "DeleteTriggeredWebJob", nil, "Failure preparing request")
		return
	}

	resp, err := client.DeleteTriggeredWebJobSender(req)
	if err != nil {
		result.Response = resp
		err = autorest.NewErrorWithError(err, "web.AppsClient", "DeleteTriggeredWebJob", resp, "Failure sending request")
		return
	}

	result, err = client.DeleteTriggeredWebJobResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "DeleteTriggeredWebJob", resp, "Failure responding to request")
	}

	return
}

// DeleteTriggeredWebJobPreparer prepares the DeleteTriggeredWebJob request.
func (client AppsClient) DeleteTriggeredWebJobPreparer(ctx context.Context, resourceGroupName string, name string, webJobName string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
		"webJobName":        autorest.Encode("path", webJobName),
	}

	const APIVersion = "2019-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsDelete(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/triggeredwebjobs/{webJobName}", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// DeleteTriggeredWebJobSender sends the DeleteTriggeredWebJob request. The method will close the
// http.Response Body if it receives an error.
func (client AppsClient) DeleteTriggeredWebJobSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// DeleteTriggeredWebJobResponder handles the response to the DeleteTriggeredWebJob request. The method always
// closes the http.Response Body.
func (client AppsClient) DeleteTriggeredWebJobResponder(resp *http.Response) (result autorest.Response, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusNoContent),
		autorest.ByClosing())
	result.Response = resp
	return
}

// DeleteTriggeredWebJobSlot description for Delete a triggered web job by its ID for an app, or a deployment slot.
// Parameters:
// resourceGroupName - name of the resource group to which the resource belongs.
// name - site name.
// webJobName - name of Web Job.
// slot - name of the deployment slot. If a slot is not specified, the API deletes web job for the production
// slot.
func (client AppsClient) DeleteTriggeredWebJobSlot(ctx context.Context, resourceGroupName string, name string, webJobName string, slot string) (result autorest.Response, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/AppsClient.DeleteTriggeredWebJobSlot")
		defer func() {
			sc := -1
			if result.Response != nil {
				sc = result.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewError("web.AppsClient", "DeleteTriggeredWebJobSlot", err.Error())
	}

	req, err := client.DeleteTriggeredWebJobSlotPreparer(ctx, resourceGroupName, name, webJobName, slot)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "DeleteTriggeredWebJobSlot", nil, "Failure preparing request")
		return
	}

	resp, err := client.DeleteTriggeredWebJobSlotSender(req)
	if err != nil {
		result.Response = resp
		err = autorest.NewErrorWithError(err, "web.AppsClient", "DeleteTriggeredWebJobSlot", resp, "Failure sending request")
		return
	}

	result, err = client.DeleteTriggeredWebJobSlotResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "DeleteTriggeredWebJobSlot", resp, "Failure responding to request")
	}

	return
}

// DeleteTriggeredWebJobSlotPreparer prepares the DeleteTriggeredWebJobSlot request.
func (client AppsClient) DeleteTriggeredWebJobSlotPreparer(ctx context.Context, resourceGroupName string, name string, webJobName string, slot string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"slot":              autorest.Encode("path", slot),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
		"webJobName":        autorest.Encode("path", webJobName),
	}

	const APIVersion = "2019-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsDelete(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/triggeredwebjobs/{webJobName}", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// DeleteTriggeredWebJobSlotSender sends the DeleteTriggeredWebJobSlot request. The method will close the
// http.Response Body if it receives an error.
func (client AppsClient) DeleteTriggeredWebJobSlotSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// DeleteTriggeredWebJobSlotResponder handles the response to the DeleteTriggeredWebJobSlot request. The method always
// closes the http.Response Body.
func (client AppsClient) DeleteTriggeredWebJobSlotResponder(resp *http.Response) (result autorest.Response, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusNoContent),
		autorest.ByClosing())
	result.Response = resp
	return
}

// DeleteVnetConnection description for Deletes a connection from an app (or deployment slot to a named virtual
// network.
// Parameters:
// resourceGroupName - name of the resource group to which the resource belongs.
// name - name of the app.
// vnetName - name of the virtual network.
func (client AppsClient) DeleteVnetConnection(ctx context.Context, resourceGroupName string, name string, vnetName string) (result autorest.Response, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/AppsClient.DeleteVnetConnection")
		defer func() {
			sc := -1
			if result.Response != nil {
				sc = result.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewError("web.AppsClient", "DeleteVnetConnection", err.Error())
	}

	req, err := client.DeleteVnetConnectionPreparer(ctx, resourceGroupName, name, vnetName)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "DeleteVnetConnection", nil, "Failure preparing request")
		return
	}

	resp, err := client.DeleteVnetConnectionSender(req)
	if err != nil {
		result.Response = resp
		err = autorest.NewErrorWithError(err, "web.AppsClient", "DeleteVnetConnection", resp, "Failure sending request")
		return
	}

	result, err = client.DeleteVnetConnectionResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "DeleteVnetConnection", resp, "Failure responding to request")
	}

	return
}

// DeleteVnetConnectionPreparer prepares the DeleteVnetConnection request.
func (client AppsClient) DeleteVnetConnectionPreparer(ctx context.Context, resourceGroupName string, name string, vnetName string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
		"vnetName":          autorest.Encode("path", vnetName),
	}

	const APIVersion = "2019-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsDelete(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/virtualNetworkConnections/{vnetName}", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// DeleteVnetConnectionSender sends the DeleteVnetConnection request. The method will close the
// http.Response Body if it receives an error.
func (client AppsClient) DeleteVnetConnectionSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// DeleteVnetConnectionResponder handles the response to the DeleteVnetConnection request. The method always
// closes the http.Response Body.
func (client AppsClient) DeleteVnetConnectionResponder(resp *http.Response) (result autorest.Response, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusNotFound),
		autorest.ByClosing())
	result.Response = resp
	return
}

// DeleteVnetConnectionSlot description for Deletes a connection from an app (or deployment slot to a named virtual
// network.
// Parameters:
// resourceGroupName - name of the resource group to which the resource belongs.
// name - name of the app.
// vnetName - name of the virtual network.
// slot - name of the deployment slot. If a slot is not specified, the API will delete the connection for the
// production slot.
func (client AppsClient) DeleteVnetConnectionSlot(ctx context.Context, resourceGroupName string, name string, vnetName string, slot string) (result autorest.Response, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/AppsClient.DeleteVnetConnectionSlot")
		defer func() {
			sc := -1
			if result.Response != nil {
				sc = result.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewError("web.AppsClient", "DeleteVnetConnectionSlot", err.Error())
	}

	req, err := client.DeleteVnetConnectionSlotPreparer(ctx, resourceGroupName, name, vnetName, slot)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "DeleteVnetConnectionSlot", nil, "Failure preparing request")
		return
	}

	resp, err := client.DeleteVnetConnectionSlotSender(req)
	if err != nil {
		result.Response = resp
		err = autorest.NewErrorWithError(err, "web.AppsClient", "DeleteVnetConnectionSlot", resp, "Failure sending request")
		return
	}

	result, err = client.DeleteVnetConnectionSlotResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "DeleteVnetConnectionSlot", resp, "Failure responding to request")
	}

	return
}

// DeleteVnetConnectionSlotPreparer prepares the DeleteVnetConnectionSlot request.
func (client AppsClient) DeleteVnetConnectionSlotPreparer(ctx context.Context, resourceGroupName string, name string, vnetName string, slot string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"slot":              autorest.Encode("path", slot),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
		"vnetName":          autorest.Encode("path", vnetName),
	}

	const APIVersion = "2019-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsDelete(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/virtualNetworkConnections/{vnetName}", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// DeleteVnetConnectionSlotSender sends the DeleteVnetConnectionSlot request. The method will close the
// http.Response Body if it receives an error.
func (client AppsClient) DeleteVnetConnectionSlotSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// DeleteVnetConnectionSlotResponder handles the response to the DeleteVnetConnectionSlot request. The method always
// closes the http.Response Body.
func (client AppsClient) DeleteVnetConnectionSlotResponder(resp *http.Response) (result autorest.Response, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusNotFound),
		autorest.ByClosing())
	result.Response = resp
	return
}

// DiscoverBackup description for Discovers an existing app backup that can be restored from a blob in Azure storage.
// Use this to get information about the databases stored in a backup.
// Parameters:
// resourceGroupName - name of the resource group to which the resource belongs.
// name - name of the app.
// request - a RestoreRequest object that includes Azure storage URL and blog name for discovery of backup.
func (client AppsClient) DiscoverBackup(ctx context.Context, resourceGroupName string, name string, request RestoreRequest) (result RestoreRequest, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/AppsClient.DiscoverBackup")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}},
		{TargetValue: request,
			Constraints: []validation.Constraint{{Target: "request.RestoreRequestProperties", Name: validation.Null, Rule: false,
				Chain: []validation.Constraint{{Target: "request.RestoreRequestProperties.StorageAccountURL", Name: validation.Null, Rule: true, Chain: nil},
					{Target: "request.RestoreRequestProperties.Overwrite", Name: validation.Null, Rule: true, Chain: nil},
				}}}}}); err != nil {
		return result, validation.NewError("web.AppsClient", "DiscoverBackup", err.Error())
	}

	req, err := client.DiscoverBackupPreparer(ctx, resourceGroupName, name, request)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "DiscoverBackup", nil, "Failure preparing request")
		return
	}

	resp, err := client.DiscoverBackupSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.AppsClient", "DiscoverBackup", resp, "Failure sending request")
		return
	}

	result, err = client.DiscoverBackupResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "DiscoverBackup", resp, "Failure responding to request")
	}

	return
}

// DiscoverBackupPreparer prepares the DiscoverBackup request.
func (client AppsClient) DiscoverBackupPreparer(ctx context.Context, resourceGroupName string, name string, request RestoreRequest) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2019-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsContentType("application/json; charset=utf-8"),
		autorest.AsPost(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/discoverbackup", pathParameters),
		autorest.WithJSON(request),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// DiscoverBackupSender sends the DiscoverBackup request. The method will close the
// http.Response Body if it receives an error.
func (client AppsClient) DiscoverBackupSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// DiscoverBackupResponder handles the response to the DiscoverBackup request. The method always
// closes the http.Response Body.
func (client AppsClient) DiscoverBackupResponder(resp *http.Response) (result RestoreRequest, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// DiscoverBackupSlot description for Discovers an existing app backup that can be restored from a blob in Azure
// storage. Use this to get information about the databases stored in a backup.
// Parameters:
// resourceGroupName - name of the resource group to which the resource belongs.
// name - name of the app.
// request - a RestoreRequest object that includes Azure storage URL and blog name for discovery of backup.
// slot - name of the deployment slot. If a slot is not specified, the API will perform discovery for the
// production slot.
func (client AppsClient) DiscoverBackupSlot(ctx context.Context, resourceGroupName string, name string, request RestoreRequest, slot string) (result RestoreRequest, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/AppsClient.DiscoverBackupSlot")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}},
		{TargetValue: request,
			Constraints: []validation.Constraint{{Target: "request.RestoreRequestProperties", Name: validation.Null, Rule: false,
				Chain: []validation.Constraint{{Target: "request.RestoreRequestProperties.StorageAccountURL", Name: validation.Null, Rule: true, Chain: nil},
					{Target: "request.RestoreRequestProperties.Overwrite", Name: validation.Null, Rule: true, Chain: nil},
				}}}}}); err != nil {
		return result, validation.NewError("web.AppsClient", "DiscoverBackupSlot", err.Error())
	}

	req, err := client.DiscoverBackupSlotPreparer(ctx, resourceGroupName, name, request, slot)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "DiscoverBackupSlot", nil, "Failure preparing request")
		return
	}

	resp, err := client.DiscoverBackupSlotSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.AppsClient", "DiscoverBackupSlot", resp, "Failure sending request")
		return
	}

	result, err = client.DiscoverBackupSlotResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "DiscoverBackupSlot", resp, "Failure responding to request")
	}

	return
}

// DiscoverBackupSlotPreparer prepares the DiscoverBackupSlot request.
func (client AppsClient) DiscoverBackupSlotPreparer(ctx context.Context, resourceGroupName string, name string, request RestoreRequest, slot string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"slot":              autorest.Encode("path", slot),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2019-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsContentType("application/json; charset=utf-8"),
		autorest.AsPost(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/discoverbackup", pathParameters),
		autorest.WithJSON(request),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// DiscoverBackupSlotSender sends the DiscoverBackupSlot request. The method will close the
// http.Response Body if it receives an error.
func (client AppsClient) DiscoverBackupSlotSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// DiscoverBackupSlotResponder handles the response to the DiscoverBackupSlot request. The method always
// closes the http.Response Body.
func (client AppsClient) DiscoverBackupSlotResponder(resp *http.Response) (result RestoreRequest, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// GenerateNewSitePublishingPassword description for Generates a new publishing password for an app (or deployment
// slot, if specified).
// Parameters:
// resourceGroupName - name of the resource group to which the resource belongs.
// name - name of the app.
func (client AppsClient) GenerateNewSitePublishingPassword(ctx context.Context, resourceGroupName string, name string) (result autorest.Response, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/AppsClient.GenerateNewSitePublishingPassword")
		defer func() {
			sc := -1
			if result.Response != nil {
				sc = result.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewError("web.AppsClient", "GenerateNewSitePublishingPassword", err.Error())
	}

	req, err := client.GenerateNewSitePublishingPasswordPreparer(ctx, resourceGroupName, name)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "GenerateNewSitePublishingPassword", nil, "Failure preparing request")
		return
	}

	resp, err := client.GenerateNewSitePublishingPasswordSender(req)
	if err != nil {
		result.Response = resp
		err = autorest.NewErrorWithError(err, "web.AppsClient", "GenerateNewSitePublishingPassword", resp, "Failure sending request")
		return
	}

	result, err = client.GenerateNewSitePublishingPasswordResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "GenerateNewSitePublishingPassword", resp, "Failure responding to request")
	}

	return
}

// GenerateNewSitePublishingPasswordPreparer prepares the GenerateNewSitePublishingPassword request.
func (client AppsClient) GenerateNewSitePublishingPasswordPreparer(ctx context.Context, resourceGroupName string, name string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2019-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsPost(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/newpassword", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// GenerateNewSitePublishingPasswordSender sends the GenerateNewSitePublishingPassword request. The method will close the
// http.Response Body if it receives an error.
func (client AppsClient) GenerateNewSitePublishingPasswordSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// GenerateNewSitePublishingPasswordResponder handles the response to the GenerateNewSitePublishingPassword request. The method always
// closes the http.Response Body.
func (client AppsClient) GenerateNewSitePublishingPasswordResponder(resp *http.Response) (result autorest.Response, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusNoContent),
		autorest.ByClosing())
	result.Response = resp
	return
}

// GenerateNewSitePublishingPasswordSlot description for Generates a new publishing password for an app (or deployment
// slot, if specified).
// Parameters:
// resourceGroupName - name of the resource group to which the resource belongs.
// name - name of the app.
// slot - name of the deployment slot. If a slot is not specified, the API generate a new publishing password
// for the production slot.
func (client AppsClient) GenerateNewSitePublishingPasswordSlot(ctx context.Context, resourceGroupName string, name string, slot string) (result autorest.Response, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/AppsClient.GenerateNewSitePublishingPasswordSlot")
		defer func() {
			sc := -1
			if result.Response != nil {
				sc = result.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewError("web.AppsClient", "GenerateNewSitePublishingPasswordSlot", err.Error())
	}

	req, err := client.GenerateNewSitePublishingPasswordSlotPreparer(ctx, resourceGroupName, name, slot)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "GenerateNewSitePublishingPasswordSlot", nil, "Failure preparing request")
		return
	}

	resp, err := client.GenerateNewSitePublishingPasswordSlotSender(req)
	if err != nil {
		result.Response = resp
		err = autorest.NewErrorWithError(err, "web.AppsClient", "GenerateNewSitePublishingPasswordSlot", resp, "Failure sending request")
		return
	}

	result, err = client.GenerateNewSitePublishingPasswordSlotResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "GenerateNewSitePublishingPasswordSlot", resp, "Failure responding to request")
	}

	return
}

// GenerateNewSitePublishingPasswordSlotPreparer prepares the GenerateNewSitePublishingPasswordSlot request.
func (client AppsClient) GenerateNewSitePublishingPasswordSlotPreparer(ctx context.Context, resourceGroupName string, name string, slot string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"slot":              autorest.Encode("path", slot),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2019-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsPost(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/newpassword", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// GenerateNewSitePublishingPasswordSlotSender sends the GenerateNewSitePublishingPasswordSlot request. The method will close the
// http.Response Body if it receives an error.
func (client AppsClient) GenerateNewSitePublishingPasswordSlotSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// GenerateNewSitePublishingPasswordSlotResponder handles the response to the GenerateNewSitePublishingPasswordSlot request. The method always
// closes the http.Response Body.
func (client AppsClient) GenerateNewSitePublishingPasswordSlotResponder(resp *http.Response) (result autorest.Response, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusNoContent),
		autorest.ByClosing())
	result.Response = resp
	return
}

// Get description for Gets the details of a web, mobile, or API app.
// Parameters:
// resourceGroupName - name of the resource group to which the resource belongs.
// name - name of the app.
func (client AppsClient) Get(ctx context.Context, resourceGroupName string, name string) (result Site, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/AppsClient.Get")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewError("web.AppsClient", "Get", err.Error())
	}

	req, err := client.GetPreparer(ctx, resourceGroupName, name)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "Get", nil, "Failure preparing request")
		return
	}

	resp, err := client.GetSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.AppsClient", "Get", resp, "Failure sending request")
		return
	}

	result, err = client.GetResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "Get", resp, "Failure responding to request")
	}

	return
}

// GetPreparer prepares the Get request.
func (client AppsClient) GetPreparer(ctx context.Context, resourceGroupName string, name string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2019-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// GetSender sends the Get request. The method will close the
// http.Response Body if it receives an error.
func (client AppsClient) GetSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// GetResponder handles the response to the Get request. The method always
// closes the http.Response Body.
func (client AppsClient) GetResponder(resp *http.Response) (result Site, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusNotFound),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// GetAppSettingKeyVaultReference description for Gets the config reference and status of an app
// Parameters:
// resourceGroupName - name of the resource group to which the resource belongs.
// name - name of the app.
// appSettingKey - app Setting key name.
func (client AppsClient) GetAppSettingKeyVaultReference(ctx context.Context, resourceGroupName string, name string, appSettingKey string) (result KeyVaultReferenceResource, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/AppsClient.GetAppSettingKeyVaultReference")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewError("web.AppsClient", "GetAppSettingKeyVaultReference", err.Error())
	}

	req, err := client.GetAppSettingKeyVaultReferencePreparer(ctx, resourceGroupName, name, appSettingKey)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "GetAppSettingKeyVaultReference", nil, "Failure preparing request")
		return
	}

	resp, err := client.GetAppSettingKeyVaultReferenceSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.AppsClient", "GetAppSettingKeyVaultReference", resp, "Failure sending request")
		return
	}

	result, err = client.GetAppSettingKeyVaultReferenceResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "GetAppSettingKeyVaultReference", resp, "Failure responding to request")
	}

	return
}

// GetAppSettingKeyVaultReferencePreparer prepares the GetAppSettingKeyVaultReference request.
func (client AppsClient) GetAppSettingKeyVaultReferencePreparer(ctx context.Context, resourceGroupName string, name string, appSettingKey string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"appSettingKey":     autorest.Encode("path", appSettingKey),
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2019-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/config/configreferences/appsettings/{appSettingKey}", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// GetAppSettingKeyVaultReferenceSender sends the GetAppSettingKeyVaultReference request. The method will close the
// http.Response Body if it receives an error.
func (client AppsClient) GetAppSettingKeyVaultReferenceSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// GetAppSettingKeyVaultReferenceResponder handles the response to the GetAppSettingKeyVaultReference request. The method always
// closes the http.Response Body.
func (client AppsClient) GetAppSettingKeyVaultReferenceResponder(resp *http.Response) (result KeyVaultReferenceResource, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// GetAppSettingsKeyVaultReferences description for Gets the config reference app settings and status of an app
// Parameters:
// resourceGroupName - name of the resource group to which the resource belongs.
// name - name of the app.
func (client AppsClient) GetAppSettingsKeyVaultReferences(ctx context.Context, resourceGroupName string, name string) (result KeyVaultReferenceCollection, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/AppsClient.GetAppSettingsKeyVaultReferences")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewError("web.AppsClient", "GetAppSettingsKeyVaultReferences", err.Error())
	}

	req, err := client.GetAppSettingsKeyVaultReferencesPreparer(ctx, resourceGroupName, name)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "GetAppSettingsKeyVaultReferences", nil, "Failure preparing request")
		return
	}

	resp, err := client.GetAppSettingsKeyVaultReferencesSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.AppsClient", "GetAppSettingsKeyVaultReferences", resp, "Failure sending request")
		return
	}

	result, err = client.GetAppSettingsKeyVaultReferencesResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "GetAppSettingsKeyVaultReferences", resp, "Failure responding to request")
	}

	return
}

// GetAppSettingsKeyVaultReferencesPreparer prepares the GetAppSettingsKeyVaultReferences request.
func (client AppsClient) GetAppSettingsKeyVaultReferencesPreparer(ctx context.Context, resourceGroupName string, name string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2019-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/config/configreferences/appsettings", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// GetAppSettingsKeyVaultReferencesSender sends the GetAppSettingsKeyVaultReferences request. The method will close the
// http.Response Body if it receives an error.
func (client AppsClient) GetAppSettingsKeyVaultReferencesSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// GetAppSettingsKeyVaultReferencesResponder handles the response to the GetAppSettingsKeyVaultReferences request. The method always
// closes the http.Response Body.
func (client AppsClient) GetAppSettingsKeyVaultReferencesResponder(resp *http.Response) (result KeyVaultReferenceCollection, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// GetAuthSettings description for Gets the Authentication/Authorization settings of an app.
// Parameters:
// resourceGroupName - name of the resource group to which the resource belongs.
// name - name of the app.
func (client AppsClient) GetAuthSettings(ctx context.Context, resourceGroupName string, name string) (result SiteAuthSettings, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/AppsClient.GetAuthSettings")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewError("web.AppsClient", "GetAuthSettings", err.Error())
	}

	req, err := client.GetAuthSettingsPreparer(ctx, resourceGroupName, name)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "GetAuthSettings", nil, "Failure preparing request")
		return
	}

	resp, err := client.GetAuthSettingsSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.AppsClient", "GetAuthSettings", resp, "Failure sending request")
		return
	}

	result, err = client.GetAuthSettingsResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "GetAuthSettings", resp, "Failure responding to request")
	}

	return
}

// GetAuthSettingsPreparer prepares the GetAuthSettings request.
func (client AppsClient) GetAuthSettingsPreparer(ctx context.Context, resourceGroupName string, name string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2019-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsPost(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/config/authsettings/list", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// GetAuthSettingsSender sends the GetAuthSettings request. The method will close the
// http.Response Body if it receives an error.
func (client AppsClient) GetAuthSettingsSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// GetAuthSettingsResponder handles the response to the GetAuthSettings request. The method always
// closes the http.Response Body.
func (client AppsClient) GetAuthSettingsResponder(resp *http.Response) (result SiteAuthSettings, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// GetAuthSettingsSlot description for Gets the Authentication/Authorization settings of an app.
// Parameters:
// resourceGroupName - name of the resource group to which the resource belongs.
// name - name of the app.
// slot - name of the deployment slot. If a slot is not specified, the API will get the settings for the
// production slot.
func (client AppsClient) GetAuthSettingsSlot(ctx context.Context, resourceGroupName string, name string, slot string) (result SiteAuthSettings, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/AppsClient.GetAuthSettingsSlot")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewError("web.AppsClient", "GetAuthSettingsSlot", err.Error())
	}

	req, err := client.GetAuthSettingsSlotPreparer(ctx, resourceGroupName, name, slot)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "GetAuthSettingsSlot", nil, "Failure preparing request")
		return
	}

	resp, err := client.GetAuthSettingsSlotSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.AppsClient", "GetAuthSettingsSlot", resp, "Failure sending request")
		return
	}

	result, err = client.GetAuthSettingsSlotResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "GetAuthSettingsSlot", resp, "Failure responding to request")
	}

	return
}

// GetAuthSettingsSlotPreparer prepares the GetAuthSettingsSlot request.
func (client AppsClient) GetAuthSettingsSlotPreparer(ctx context.Context, resourceGroupName string, name string, slot string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"slot":              autorest.Encode("path", slot),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2019-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsPost(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/config/authsettings/list", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// GetAuthSettingsSlotSender sends the GetAuthSettingsSlot request. The method will close the
// http.Response Body if it receives an error.
func (client AppsClient) GetAuthSettingsSlotSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// GetAuthSettingsSlotResponder handles the response to the GetAuthSettingsSlot request. The method always
// closes the http.Response Body.
func (client AppsClient) GetAuthSettingsSlotResponder(resp *http.Response) (result SiteAuthSettings, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// GetBackupConfiguration description for Gets the backup configuration of an app.
// Parameters:
// resourceGroupName - name of the resource group to which the resource belongs.
// name - name of the app.
func (client AppsClient) GetBackupConfiguration(ctx context.Context, resourceGroupName string, name string) (result BackupRequest, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/AppsClient.GetBackupConfiguration")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewError("web.AppsClient", "GetBackupConfiguration", err.Error())
	}

	req, err := client.GetBackupConfigurationPreparer(ctx, resourceGroupName, name)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "GetBackupConfiguration", nil, "Failure preparing request")
		return
	}

	resp, err := client.GetBackupConfigurationSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.AppsClient", "GetBackupConfiguration", resp, "Failure sending request")
		return
	}

	result, err = client.GetBackupConfigurationResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "GetBackupConfiguration", resp, "Failure responding to request")
	}

	return
}

// GetBackupConfigurationPreparer prepares the GetBackupConfiguration request.
func (client AppsClient) GetBackupConfigurationPreparer(ctx context.Context, resourceGroupName string, name string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2019-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsPost(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/config/backup/list", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// GetBackupConfigurationSender sends the GetBackupConfiguration request. The method will close the
// http.Response Body if it receives an error.
func (client AppsClient) GetBackupConfigurationSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// GetBackupConfigurationResponder handles the response to the GetBackupConfiguration request. The method always
// closes the http.Response Body.
func (client AppsClient) GetBackupConfigurationResponder(resp *http.Response) (result BackupRequest, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// GetBackupConfigurationSlot description for Gets the backup configuration of an app.
// Parameters:
// resourceGroupName - name of the resource group to which the resource belongs.
// name - name of the app.
// slot - name of the deployment slot. If a slot is not specified, the API will get the backup configuration
// for the production slot.
func (client AppsClient) GetBackupConfigurationSlot(ctx context.Context, resourceGroupName string, name string, slot string) (result BackupRequest, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/AppsClient.GetBackupConfigurationSlot")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewError("web.AppsClient", "GetBackupConfigurationSlot", err.Error())
	}

	req, err := client.GetBackupConfigurationSlotPreparer(ctx, resourceGroupName, name, slot)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "GetBackupConfigurationSlot", nil, "Failure preparing request")
		return
	}

	resp, err := client.GetBackupConfigurationSlotSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.AppsClient", "GetBackupConfigurationSlot", resp, "Failure sending request")
		return
	}

	result, err = client.GetBackupConfigurationSlotResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "GetBackupConfigurationSlot", resp, "Failure responding to request")
	}

	return
}

// GetBackupConfigurationSlotPreparer prepares the GetBackupConfigurationSlot request.
func (client AppsClient) GetBackupConfigurationSlotPreparer(ctx context.Context, resourceGroupName string, name string, slot string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"slot":              autorest.Encode("path", slot),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2019-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsPost(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/config/backup/list", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// GetBackupConfigurationSlotSender sends the GetBackupConfigurationSlot request. The method will close the
// http.Response Body if it receives an error.
func (client AppsClient) GetBackupConfigurationSlotSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// GetBackupConfigurationSlotResponder handles the response to the GetBackupConfigurationSlot request. The method always
// closes the http.Response Body.
func (client AppsClient) GetBackupConfigurationSlotResponder(resp *http.Response) (result BackupRequest, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// GetBackupStatus description for Gets a backup of an app by its ID.
// Parameters:
// resourceGroupName - name of the resource group to which the resource belongs.
// name - name of the app.
// backupID - ID of the backup.
func (client AppsClient) GetBackupStatus(ctx context.Context, resourceGroupName string, name string, backupID string) (result BackupItem, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/AppsClient.GetBackupStatus")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewError("web.AppsClient", "GetBackupStatus", err.Error())
	}

	req, err := client.GetBackupStatusPreparer(ctx, resourceGroupName, name, backupID)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "GetBackupStatus", nil, "Failure preparing request")
		return
	}

	resp, err := client.GetBackupStatusSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.AppsClient", "GetBackupStatus", resp, "Failure sending request")
		return
	}

	result, err = client.GetBackupStatusResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "GetBackupStatus", resp, "Failure responding to request")
	}

	return
}

// GetBackupStatusPreparer prepares the GetBackupStatus request.
func (client AppsClient) GetBackupStatusPreparer(ctx context.Context, resourceGroupName string, name string, backupID string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"backupId":          autorest.Encode("path", backupID),
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2019-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/backups/{backupId}", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// GetBackupStatusSender sends the GetBackupStatus request. The method will close the
// http.Response Body if it receives an error.
func (client AppsClient) GetBackupStatusSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// GetBackupStatusResponder handles the response to the GetBackupStatus request. The method always
// closes the http.Response Body.
func (client AppsClient) GetBackupStatusResponder(resp *http.Response) (result BackupItem, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// GetBackupStatusSlot description for Gets a backup of an app by its ID.
// Parameters:
// resourceGroupName - name of the resource group to which the resource belongs.
// name - name of the app.
// backupID - ID of the backup.
// slot - name of the deployment slot. If a slot is not specified, the API will get a backup of the production
// slot.
func (client AppsClient) GetBackupStatusSlot(ctx context.Context, resourceGroupName string, name string, backupID string, slot string) (result BackupItem, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/AppsClient.GetBackupStatusSlot")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewError("web.AppsClient", "GetBackupStatusSlot", err.Error())
	}

	req, err := client.GetBackupStatusSlotPreparer(ctx, resourceGroupName, name, backupID, slot)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "GetBackupStatusSlot", nil, "Failure preparing request")
		return
	}

	resp, err := client.GetBackupStatusSlotSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.AppsClient", "GetBackupStatusSlot", resp, "Failure sending request")
		return
	}

	result, err = client.GetBackupStatusSlotResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "GetBackupStatusSlot", resp, "Failure responding to request")
	}

	return
}

// GetBackupStatusSlotPreparer prepares the GetBackupStatusSlot request.
func (client AppsClient) GetBackupStatusSlotPreparer(ctx context.Context, resourceGroupName string, name string, backupID string, slot string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"backupId":          autorest.Encode("path", backupID),
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"slot":              autorest.Encode("path", slot),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2019-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/backups/{backupId}", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// GetBackupStatusSlotSender sends the GetBackupStatusSlot request. The method will close the
// http.Response Body if it receives an error.
func (client AppsClient) GetBackupStatusSlotSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// GetBackupStatusSlotResponder handles the response to the GetBackupStatusSlot request. The method always
// closes the http.Response Body.
func (client AppsClient) GetBackupStatusSlotResponder(resp *http.Response) (result BackupItem, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// GetConfiguration description for Gets the configuration of an app, such as platform version and bitness, default
// documents, virtual applications, Always On, etc.
// Parameters:
// resourceGroupName - name of the resource group to which the resource belongs.
// name - name of the app.
func (client AppsClient) GetConfiguration(ctx context.Context, resourceGroupName string, name string) (result SiteConfigResource, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/AppsClient.GetConfiguration")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewError("web.AppsClient", "GetConfiguration", err.Error())
	}

	req, err := client.GetConfigurationPreparer(ctx, resourceGroupName, name)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "GetConfiguration", nil, "Failure preparing request")
		return
	}

	resp, err := client.GetConfigurationSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.AppsClient", "GetConfiguration", resp, "Failure sending request")
		return
	}

	result, err = client.GetConfigurationResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "GetConfiguration", resp, "Failure responding to request")
	}

	return
}

// GetConfigurationPreparer prepares the GetConfiguration request.
func (client AppsClient) GetConfigurationPreparer(ctx context.Context, resourceGroupName string, name string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2019-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/config/web", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// GetConfigurationSender sends the GetConfiguration request. The method will close the
// http.Response Body if it receives an error.
func (client AppsClient) GetConfigurationSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// GetConfigurationResponder handles the response to the GetConfiguration request. The method always
// closes the http.Response Body.
func (client AppsClient) GetConfigurationResponder(resp *http.Response) (result SiteConfigResource, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// GetConfigurationSlot description for Gets the configuration of an app, such as platform version and bitness, default
// documents, virtual applications, Always On, etc.
// Parameters:
// resourceGroupName - name of the resource group to which the resource belongs.
// name - name of the app.
// slot - name of the deployment slot. If a slot is not specified, the API will return configuration for the
// production slot.
func (client AppsClient) GetConfigurationSlot(ctx context.Context, resourceGroupName string, name string, slot string) (result SiteConfigResource, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/AppsClient.GetConfigurationSlot")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewError("web.AppsClient", "GetConfigurationSlot", err.Error())
	}

	req, err := client.GetConfigurationSlotPreparer(ctx, resourceGroupName, name, slot)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "GetConfigurationSlot", nil, "Failure preparing request")
		return
	}

	resp, err := client.GetConfigurationSlotSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.AppsClient", "GetConfigurationSlot", resp, "Failure sending request")
		return
	}

	result, err = client.GetConfigurationSlotResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "GetConfigurationSlot", resp, "Failure responding to request")
	}

	return
}

// GetConfigurationSlotPreparer prepares the GetConfigurationSlot request.
func (client AppsClient) GetConfigurationSlotPreparer(ctx context.Context, resourceGroupName string, name string, slot string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"slot":              autorest.Encode("path", slot),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2019-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/config/web", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// GetConfigurationSlotSender sends the GetConfigurationSlot request. The method will close the
// http.Response Body if it receives an error.
func (client AppsClient) GetConfigurationSlotSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// GetConfigurationSlotResponder handles the response to the GetConfigurationSlot request. The method always
// closes the http.Response Body.
func (client AppsClient) GetConfigurationSlotResponder(resp *http.Response) (result SiteConfigResource, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// GetConfigurationSnapshot description for Gets a snapshot of the configuration of an app at a previous point in time.
// Parameters:
// resourceGroupName - name of the resource group to which the resource belongs.
// name - name of the app.
// snapshotID - the ID of the snapshot to read.
func (client AppsClient) GetConfigurationSnapshot(ctx context.Context, resourceGroupName string, name string, snapshotID string) (result SiteConfigResource, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/AppsClient.GetConfigurationSnapshot")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewError("web.AppsClient", "GetConfigurationSnapshot", err.Error())
	}

	req, err := client.GetConfigurationSnapshotPreparer(ctx, resourceGroupName, name, snapshotID)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "GetConfigurationSnapshot", nil, "Failure preparing request")
		return
	}

	resp, err := client.GetConfigurationSnapshotSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.AppsClient", "GetConfigurationSnapshot", resp, "Failure sending request")
		return
	}

	result, err = client.GetConfigurationSnapshotResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "GetConfigurationSnapshot", resp, "Failure responding to request")
	}

	return
}

// GetConfigurationSnapshotPreparer prepares the GetConfigurationSnapshot request.
func (client AppsClient) GetConfigurationSnapshotPreparer(ctx context.Context, resourceGroupName string, name string, snapshotID string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"snapshotId":        autorest.Encode("path", snapshotID),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2019-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/config/web/snapshots/{snapshotId}", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// GetConfigurationSnapshotSender sends the GetConfigurationSnapshot request. The method will close the
// http.Response Body if it receives an error.
func (client AppsClient) GetConfigurationSnapshotSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// GetConfigurationSnapshotResponder handles the response to the GetConfigurationSnapshot request. The method always
// closes the http.Response Body.
func (client AppsClient) GetConfigurationSnapshotResponder(resp *http.Response) (result SiteConfigResource, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// GetConfigurationSnapshotSlot description for Gets a snapshot of the configuration of an app at a previous point in
// time.
// Parameters:
// resourceGroupName - name of the resource group to which the resource belongs.
// name - name of the app.
// snapshotID - the ID of the snapshot to read.
// slot - name of the deployment slot. If a slot is not specified, the API will return configuration for the
// production slot.
func (client AppsClient) GetConfigurationSnapshotSlot(ctx context.Context, resourceGroupName string, name string, snapshotID string, slot string) (result SiteConfigResource, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/AppsClient.GetConfigurationSnapshotSlot")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewError("web.AppsClient", "GetConfigurationSnapshotSlot", err.Error())
	}

	req, err := client.GetConfigurationSnapshotSlotPreparer(ctx, resourceGroupName, name, snapshotID, slot)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "GetConfigurationSnapshotSlot", nil, "Failure preparing request")
		return
	}

	resp, err := client.GetConfigurationSnapshotSlotSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.AppsClient", "GetConfigurationSnapshotSlot", resp, "Failure sending request")
		return
	}

	result, err = client.GetConfigurationSnapshotSlotResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "GetConfigurationSnapshotSlot", resp, "Failure responding to request")
	}

	return
}

// GetConfigurationSnapshotSlotPreparer prepares the GetConfigurationSnapshotSlot request.
func (client AppsClient) GetConfigurationSnapshotSlotPreparer(ctx context.Context, resourceGroupName string, name string, snapshotID string, slot string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"slot":              autorest.Encode("path", slot),
		"snapshotId":        autorest.Encode("path", snapshotID),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2019-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/config/web/snapshots/{snapshotId}", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// GetConfigurationSnapshotSlotSender sends the GetConfigurationSnapshotSlot request. The method will close the
// http.Response Body if it receives an error.
func (client AppsClient) GetConfigurationSnapshotSlotSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// GetConfigurationSnapshotSlotResponder handles the response to the GetConfigurationSnapshotSlot request. The method always
// closes the http.Response Body.
func (client AppsClient) GetConfigurationSnapshotSlotResponder(resp *http.Response) (result SiteConfigResource, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// GetContainerLogsZip description for Gets the ZIP archived docker log files for the given site
// Parameters:
// resourceGroupName - name of the resource group to which the resource belongs.
// name - name of web app.
func (client AppsClient) GetContainerLogsZip(ctx context.Context, resourceGroupName string, name string) (result ReadCloser, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/AppsClient.GetContainerLogsZip")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewError("web.AppsClient", "GetContainerLogsZip", err.Error())
	}

	req, err := client.GetContainerLogsZipPreparer(ctx, resourceGroupName, name)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "GetContainerLogsZip", nil, "Failure preparing request")
		return
	}

	resp, err := client.GetContainerLogsZipSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.AppsClient", "GetContainerLogsZip", resp, "Failure sending request")
		return
	}

	result, err = client.GetContainerLogsZipResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "GetContainerLogsZip", resp, "Failure responding to request")
	}

	return
}

// GetContainerLogsZipPreparer prepares the GetContainerLogsZip request.
func (client AppsClient) GetContainerLogsZipPreparer(ctx context.Context, resourceGroupName string, name string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2019-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsPost(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/containerlogs/zip/download", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// GetContainerLogsZipSender sends the GetContainerLogsZip request. The method will close the
// http.Response Body if it receives an error.
func (client AppsClient) GetContainerLogsZipSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// GetContainerLogsZipResponder handles the response to the GetContainerLogsZip request. The method always
// closes the http.Response Body.
func (client AppsClient) GetContainerLogsZipResponder(resp *http.Response) (result ReadCloser, err error) {
	result.Value = &resp.Body
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusNoContent))
	result.Response = autorest.Response{Response: resp}
	return
}

// GetContainerLogsZipSlot description for Gets the ZIP archived docker log files for the given site
// Parameters:
// resourceGroupName - name of the resource group to which the resource belongs.
// name - name of web app.
// slot - name of web app slot. If not specified then will default to production slot.
func (client AppsClient) GetContainerLogsZipSlot(ctx context.Context, resourceGroupName string, name string, slot string) (result ReadCloser, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/AppsClient.GetContainerLogsZipSlot")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewError("web.AppsClient", "GetContainerLogsZipSlot", err.Error())
	}

	req, err := client.GetContainerLogsZipSlotPreparer(ctx, resourceGroupName, name, slot)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "GetContainerLogsZipSlot", nil, "Failure preparing request")
		return
	}

	resp, err := client.GetContainerLogsZipSlotSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.AppsClient", "GetContainerLogsZipSlot", resp, "Failure sending request")
		return
	}

	result, err = client.GetContainerLogsZipSlotResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "GetContainerLogsZipSlot", resp, "Failure responding to request")
	}

	return
}

// GetContainerLogsZipSlotPreparer prepares the GetContainerLogsZipSlot request.
func (client AppsClient) GetContainerLogsZipSlotPreparer(ctx context.Context, resourceGroupName string, name string, slot string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"slot":              autorest.Encode("path", slot),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2019-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsPost(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/containerlogs/zip/download", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// GetContainerLogsZipSlotSender sends the GetContainerLogsZipSlot request. The method will close the
// http.Response Body if it receives an error.
func (client AppsClient) GetContainerLogsZipSlotSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// GetContainerLogsZipSlotResponder handles the response to the GetContainerLogsZipSlot request. The method always
// closes the http.Response Body.
func (client AppsClient) GetContainerLogsZipSlotResponder(resp *http.Response) (result ReadCloser, err error) {
	result.Value = &resp.Body
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusNoContent))
	result.Response = autorest.Response{Response: resp}
	return
}

// GetContinuousWebJob description for Gets a continuous web job by its ID for an app, or a deployment slot.
// Parameters:
// resourceGroupName - name of the resource group to which the resource belongs.
// name - site name.
// webJobName - name of Web Job.
func (client AppsClient) GetContinuousWebJob(ctx context.Context, resourceGroupName string, name string, webJobName string) (result ContinuousWebJob, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/AppsClient.GetContinuousWebJob")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewError("web.AppsClient", "GetContinuousWebJob", err.Error())
	}

	req, err := client.GetContinuousWebJobPreparer(ctx, resourceGroupName, name, webJobName)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "GetContinuousWebJob", nil, "Failure preparing request")
		return
	}

	resp, err := client.GetContinuousWebJobSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.AppsClient", "GetContinuousWebJob", resp, "Failure sending request")
		return
	}

	result, err = client.GetContinuousWebJobResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "GetContinuousWebJob", resp, "Failure responding to request")
	}

	return
}

// GetContinuousWebJobPreparer prepares the GetContinuousWebJob request.
func (client AppsClient) GetContinuousWebJobPreparer(ctx context.Context, resourceGroupName string, name string, webJobName string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
		"webJobName":        autorest.Encode("path", webJobName),
	}

	const APIVersion = "2019-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/continuouswebjobs/{webJobName}", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// GetContinuousWebJobSender sends the GetContinuousWebJob request. The method will close the
// http.Response Body if it receives an error.
func (client AppsClient) GetContinuousWebJobSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// GetContinuousWebJobResponder handles the response to the GetContinuousWebJob request. The method always
// closes the http.Response Body.
func (client AppsClient) GetContinuousWebJobResponder(resp *http.Response) (result ContinuousWebJob, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusNotFound),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// GetContinuousWebJobSlot description for Gets a continuous web job by its ID for an app, or a deployment slot.
// Parameters:
// resourceGroupName - name of the resource group to which the resource belongs.
// name - site name.
// webJobName - name of Web Job.
// slot - name of the deployment slot. If a slot is not specified, the API deletes a deployment for the
// production slot.
func (client AppsClient) GetContinuousWebJobSlot(ctx context.Context, resourceGroupName string, name string, webJobName string, slot string) (result ContinuousWebJob, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/AppsClient.GetContinuousWebJobSlot")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewError("web.AppsClient", "GetContinuousWebJobSlot", err.Error())
	}

	req, err := client.GetContinuousWebJobSlotPreparer(ctx, resourceGroupName, name, webJobName, slot)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "GetContinuousWebJobSlot", nil, "Failure preparing request")
		return
	}

	resp, err := client.GetContinuousWebJobSlotSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.AppsClient", "GetContinuousWebJobSlot", resp, "Failure sending request")
		return
	}

	result, err = client.GetContinuousWebJobSlotResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "GetContinuousWebJobSlot", resp, "Failure responding to request")
	}

	return
}

// GetContinuousWebJobSlotPreparer prepares the GetContinuousWebJobSlot request.
func (client AppsClient) GetContinuousWebJobSlotPreparer(ctx context.Context, resourceGroupName string, name string, webJobName string, slot string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"slot":              autorest.Encode("path", slot),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
		"webJobName":        autorest.Encode("path", webJobName),
	}

	const APIVersion = "2019-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/continuouswebjobs/{webJobName}", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// GetContinuousWebJobSlotSender sends the GetContinuousWebJobSlot request. The method will close the
// http.Response Body if it receives an error.
func (client AppsClient) GetContinuousWebJobSlotSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// GetContinuousWebJobSlotResponder handles the response to the GetContinuousWebJobSlot request. The method always
// closes the http.Response Body.
func (client AppsClient) GetContinuousWebJobSlotResponder(resp *http.Response) (result ContinuousWebJob, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusNotFound),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// GetDeployment description for Get a deployment by its ID for an app, or a deployment slot.
// Parameters:
// resourceGroupName - name of the resource group to which the resource belongs.
// name - name of the app.
// ID - deployment ID.
func (client AppsClient) GetDeployment(ctx context.Context, resourceGroupName string, name string, ID string) (result Deployment, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/AppsClient.GetDeployment")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewError("web.AppsClient", "GetDeployment", err.Error())
	}

	req, err := client.GetDeploymentPreparer(ctx, resourceGroupName, name, ID)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "GetDeployment", nil, "Failure preparing request")
		return
	}

	resp, err := client.GetDeploymentSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.AppsClient", "GetDeployment", resp, "Failure sending request")
		return
	}

	result, err = client.GetDeploymentResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "GetDeployment", resp, "Failure responding to request")
	}

	return
}

// GetDeploymentPreparer prepares the GetDeployment request.
func (client AppsClient) GetDeploymentPreparer(ctx context.Context, resourceGroupName string, name string, ID string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"id":                autorest.Encode("path", ID),
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2019-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/deployments/{id}", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// GetDeploymentSender sends the GetDeployment request. The method will close the
// http.Response Body if it receives an error.
func (client AppsClient) GetDeploymentSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// GetDeploymentResponder handles the response to the GetDeployment request. The method always
// closes the http.Response Body.
func (client AppsClient) GetDeploymentResponder(resp *http.Response) (result Deployment, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// GetDeploymentSlot description for Get a deployment by its ID for an app, or a deployment slot.
// Parameters:
// resourceGroupName - name of the resource group to which the resource belongs.
// name - name of the app.
// ID - deployment ID.
// slot - name of the deployment slot. If a slot is not specified, the API gets a deployment for the production
// slot.
func (client AppsClient) GetDeploymentSlot(ctx context.Context, resourceGroupName string, name string, ID string, slot string) (result Deployment, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/AppsClient.GetDeploymentSlot")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewError("web.AppsClient", "GetDeploymentSlot", err.Error())
	}

	req, err := client.GetDeploymentSlotPreparer(ctx, resourceGroupName, name, ID, slot)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "GetDeploymentSlot", nil, "Failure preparing request")
		return
	}

	resp, err := client.GetDeploymentSlotSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.AppsClient", "GetDeploymentSlot", resp, "Failure sending request")
		return
	}

	result, err = client.GetDeploymentSlotResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "GetDeploymentSlot", resp, "Failure responding to request")
	}

	return
}

// GetDeploymentSlotPreparer prepares the GetDeploymentSlot request.
func (client AppsClient) GetDeploymentSlotPreparer(ctx context.Context, resourceGroupName string, name string, ID string, slot string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"id":                autorest.Encode("path", ID),
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"slot":              autorest.Encode("path", slot),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2019-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/deployments/{id}", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// GetDeploymentSlotSender sends the GetDeploymentSlot request. The method will close the
// http.Response Body if it receives an error.
func (client AppsClient) GetDeploymentSlotSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// GetDeploymentSlotResponder handles the response to the GetDeploymentSlot request. The method always
// closes the http.Response Body.
func (client AppsClient) GetDeploymentSlotResponder(resp *http.Response) (result Deployment, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// GetDiagnosticLogsConfiguration description for Gets the logging configuration of an app.
// Parameters:
// resourceGroupName - name of the resource group to which the resource belongs.
// name - name of the app.
func (client AppsClient) GetDiagnosticLogsConfiguration(ctx context.Context, resourceGroupName string, name string) (result SiteLogsConfig, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/AppsClient.GetDiagnosticLogsConfiguration")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewError("web.AppsClient", "GetDiagnosticLogsConfiguration", err.Error())
	}

	req, err := client.GetDiagnosticLogsConfigurationPreparer(ctx, resourceGroupName, name)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "GetDiagnosticLogsConfiguration", nil, "Failure preparing request")
		return
	}

	resp, err := client.GetDiagnosticLogsConfigurationSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.AppsClient", "GetDiagnosticLogsConfiguration", resp, "Failure sending request")
		return
	}

	result, err = client.GetDiagnosticLogsConfigurationResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "GetDiagnosticLogsConfiguration", resp, "Failure responding to request")
	}

	return
}

// GetDiagnosticLogsConfigurationPreparer prepares the GetDiagnosticLogsConfiguration request.
func (client AppsClient) GetDiagnosticLogsConfigurationPreparer(ctx context.Context, resourceGroupName string, name string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2019-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/config/logs", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// GetDiagnosticLogsConfigurationSender sends the GetDiagnosticLogsConfiguration request. The method will close the
// http.Response Body if it receives an error.
func (client AppsClient) GetDiagnosticLogsConfigurationSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// GetDiagnosticLogsConfigurationResponder handles the response to the GetDiagnosticLogsConfiguration request. The method always
// closes the http.Response Body.
func (client AppsClient) GetDiagnosticLogsConfigurationResponder(resp *http.Response) (result SiteLogsConfig, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// GetDiagnosticLogsConfigurationSlot description for Gets the logging configuration of an app.
// Parameters:
// resourceGroupName - name of the resource group to which the resource belongs.
// name - name of the app.
// slot - name of the deployment slot. If a slot is not specified, the API will get the logging configuration
// for the production slot.
func (client AppsClient) GetDiagnosticLogsConfigurationSlot(ctx context.Context, resourceGroupName string, name string, slot string) (result SiteLogsConfig, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/AppsClient.GetDiagnosticLogsConfigurationSlot")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewError("web.AppsClient", "GetDiagnosticLogsConfigurationSlot", err.Error())
	}

	req, err := client.GetDiagnosticLogsConfigurationSlotPreparer(ctx, resourceGroupName, name, slot)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "GetDiagnosticLogsConfigurationSlot", nil, "Failure preparing request")
		return
	}

	resp, err := client.GetDiagnosticLogsConfigurationSlotSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.AppsClient", "GetDiagnosticLogsConfigurationSlot", resp, "Failure sending request")
		return
	}

	result, err = client.GetDiagnosticLogsConfigurationSlotResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "GetDiagnosticLogsConfigurationSlot", resp, "Failure responding to request")
	}

	return
}

// GetDiagnosticLogsConfigurationSlotPreparer prepares the GetDiagnosticLogsConfigurationSlot request.
func (client AppsClient) GetDiagnosticLogsConfigurationSlotPreparer(ctx context.Context, resourceGroupName string, name string, slot string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"slot":              autorest.Encode("path", slot),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2019-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/config/logs", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// GetDiagnosticLogsConfigurationSlotSender sends the GetDiagnosticLogsConfigurationSlot request. The method will close the
// http.Response Body if it receives an error.
func (client AppsClient) GetDiagnosticLogsConfigurationSlotSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// GetDiagnosticLogsConfigurationSlotResponder handles the response to the GetDiagnosticLogsConfigurationSlot request. The method always
// closes the http.Response Body.
func (client AppsClient) GetDiagnosticLogsConfigurationSlotResponder(resp *http.Response) (result SiteLogsConfig, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// GetDomainOwnershipIdentifier description for Get domain ownership identifier for web app.
// Parameters:
// resourceGroupName - name of the resource group to which the resource belongs.
// name - name of the app.
// domainOwnershipIdentifierName - name of domain ownership identifier.
func (client AppsClient) GetDomainOwnershipIdentifier(ctx context.Context, resourceGroupName string, name string, domainOwnershipIdentifierName string) (result Identifier, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/AppsClient.GetDomainOwnershipIdentifier")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewError("web.AppsClient", "GetDomainOwnershipIdentifier", err.Error())
	}

	req, err := client.GetDomainOwnershipIdentifierPreparer(ctx, resourceGroupName, name, domainOwnershipIdentifierName)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "GetDomainOwnershipIdentifier", nil, "Failure preparing request")
		return
	}

	resp, err := client.GetDomainOwnershipIdentifierSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.AppsClient", "GetDomainOwnershipIdentifier", resp, "Failure sending request")
		return
	}

	result, err = client.GetDomainOwnershipIdentifierResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "GetDomainOwnershipIdentifier", resp, "Failure responding to request")
	}

	return
}

// GetDomainOwnershipIdentifierPreparer prepares the GetDomainOwnershipIdentifier request.
func (client AppsClient) GetDomainOwnershipIdentifierPreparer(ctx context.Context, resourceGroupName string, name string, domainOwnershipIdentifierName string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"domainOwnershipIdentifierName": autorest.Encode("path", domainOwnershipIdentifierName),
		"name":                          autorest.Encode("path", name),
		"resourceGroupName":             autorest.Encode("path", resourceGroupName),
		"subscriptionId":                autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2019-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/domainOwnershipIdentifiers/{domainOwnershipIdentifierName}", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// GetDomainOwnershipIdentifierSender sends the GetDomainOwnershipIdentifier request. The method will close the
// http.Response Body if it receives an error.
func (client AppsClient) GetDomainOwnershipIdentifierSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// GetDomainOwnershipIdentifierResponder handles the response to the GetDomainOwnershipIdentifier request. The method always
// closes the http.Response Body.
func (client AppsClient) GetDomainOwnershipIdentifierResponder(resp *http.Response) (result Identifier, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// GetDomainOwnershipIdentifierSlot description for Get domain ownership identifier for web app.
// Parameters:
// resourceGroupName - name of the resource group to which the resource belongs.
// name - name of the app.
// domainOwnershipIdentifierName - name of domain ownership identifier.
// slot - name of the deployment slot. If a slot is not specified, the API will delete the binding for the
// production slot.
func (client AppsClient) GetDomainOwnershipIdentifierSlot(ctx context.Context, resourceGroupName string, name string, domainOwnershipIdentifierName string, slot string) (result Identifier, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/AppsClient.GetDomainOwnershipIdentifierSlot")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewError("web.AppsClient", "GetDomainOwnershipIdentifierSlot", err.Error())
	}

	req, err := client.GetDomainOwnershipIdentifierSlotPreparer(ctx, resourceGroupName, name, domainOwnershipIdentifierName, slot)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "GetDomainOwnershipIdentifierSlot", nil, "Failure preparing request")
		return
	}

	resp, err := client.GetDomainOwnershipIdentifierSlotSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.AppsClient", "GetDomainOwnershipIdentifierSlot", resp, "Failure sending request")
		return
	}

	result, err = client.GetDomainOwnershipIdentifierSlotResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "GetDomainOwnershipIdentifierSlot", resp, "Failure responding to request")
	}

	return
}

// GetDomainOwnershipIdentifierSlotPreparer prepares the GetDomainOwnershipIdentifierSlot request.
func (client AppsClient) GetDomainOwnershipIdentifierSlotPreparer(ctx context.Context, resourceGroupName string, name string, domainOwnershipIdentifierName string, slot string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"domainOwnershipIdentifierName": autorest.Encode("path", domainOwnershipIdentifierName),
		"name":                          autorest.Encode("path", name),
		"resourceGroupName":             autorest.Encode("path", resourceGroupName),
		"slot":                          autorest.Encode("path", slot),
		"subscriptionId":                autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2019-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/domainOwnershipIdentifiers/{domainOwnershipIdentifierName}", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// GetDomainOwnershipIdentifierSlotSender sends the GetDomainOwnershipIdentifierSlot request. The method will close the
// http.Response Body if it receives an error.
func (client AppsClient) GetDomainOwnershipIdentifierSlotSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// GetDomainOwnershipIdentifierSlotResponder handles the response to the GetDomainOwnershipIdentifierSlot request. The method always
// closes the http.Response Body.
func (client AppsClient) GetDomainOwnershipIdentifierSlotResponder(resp *http.Response) (result Identifier, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// GetFunction description for Get function information by its ID for web site, or a deployment slot.
// Parameters:
// resourceGroupName - name of the resource group to which the resource belongs.
// name - site name.
// functionName - function name.
func (client AppsClient) GetFunction(ctx context.Context, resourceGroupName string, name string, functionName string) (result FunctionEnvelope, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/AppsClient.GetFunction")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewError("web.AppsClient", "GetFunction", err.Error())
	}

	req, err := client.GetFunctionPreparer(ctx, resourceGroupName, name, functionName)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "GetFunction", nil, "Failure preparing request")
		return
	}

	resp, err := client.GetFunctionSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.AppsClient", "GetFunction", resp, "Failure sending request")
		return
	}

	result, err = client.GetFunctionResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "GetFunction", resp, "Failure responding to request")
	}

	return
}

// GetFunctionPreparer prepares the GetFunction request.
func (client AppsClient) GetFunctionPreparer(ctx context.Context, resourceGroupName string, name string, functionName string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"functionName":      autorest.Encode("path", functionName),
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2019-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/functions/{functionName}", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// GetFunctionSender sends the GetFunction request. The method will close the
// http.Response Body if it receives an error.
func (client AppsClient) GetFunctionSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// GetFunctionResponder handles the response to the GetFunction request. The method always
// closes the http.Response Body.
func (client AppsClient) GetFunctionResponder(resp *http.Response) (result FunctionEnvelope, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusNotFound),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// GetFunctionsAdminToken description for Fetch a short lived token that can be exchanged for a master key.
// Parameters:
// resourceGroupName - name of the resource group to which the resource belongs.
// name - name of web app.
func (client AppsClient) GetFunctionsAdminToken(ctx context.Context, resourceGroupName string, name string) (result String, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/AppsClient.GetFunctionsAdminToken")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewError("web.AppsClient", "GetFunctionsAdminToken", err.Error())
	}

	req, err := client.GetFunctionsAdminTokenPreparer(ctx, resourceGroupName, name)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "GetFunctionsAdminToken", nil, "Failure preparing request")
		return
	}

	resp, err := client.GetFunctionsAdminTokenSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.AppsClient", "GetFunctionsAdminToken", resp, "Failure sending request")
		return
	}

	result, err = client.GetFunctionsAdminTokenResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "GetFunctionsAdminToken", resp, "Failure responding to request")
	}

	return
}

// GetFunctionsAdminTokenPreparer prepares the GetFunctionsAdminToken request.
func (client AppsClient) GetFunctionsAdminTokenPreparer(ctx context.Context, resourceGroupName string, name string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2019-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/functions/admin/token", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// GetFunctionsAdminTokenSender sends the GetFunctionsAdminToken request. The method will close the
// http.Response Body if it receives an error.
func (client AppsClient) GetFunctionsAdminTokenSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// GetFunctionsAdminTokenResponder handles the response to the GetFunctionsAdminToken request. The method always
// closes the http.Response Body.
func (client AppsClient) GetFunctionsAdminTokenResponder(resp *http.Response) (result String, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result.Value),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// GetFunctionsAdminTokenSlot description for Fetch a short lived token that can be exchanged for a master key.
// Parameters:
// resourceGroupName - name of the resource group to which the resource belongs.
// name - name of web app.
// slot - name of web app slot. If not specified then will default to production slot.
func (client AppsClient) GetFunctionsAdminTokenSlot(ctx context.Context, resourceGroupName string, name string, slot string) (result String, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/AppsClient.GetFunctionsAdminTokenSlot")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewError("web.AppsClient", "GetFunctionsAdminTokenSlot", err.Error())
	}

	req, err := client.GetFunctionsAdminTokenSlotPreparer(ctx, resourceGroupName, name, slot)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "GetFunctionsAdminTokenSlot", nil, "Failure preparing request")
		return
	}

	resp, err := client.GetFunctionsAdminTokenSlotSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.AppsClient", "GetFunctionsAdminTokenSlot", resp, "Failure sending request")
		return
	}

	result, err = client.GetFunctionsAdminTokenSlotResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "GetFunctionsAdminTokenSlot", resp, "Failure responding to request")
	}

	return
}

// GetFunctionsAdminTokenSlotPreparer prepares the GetFunctionsAdminTokenSlot request.
func (client AppsClient) GetFunctionsAdminTokenSlotPreparer(ctx context.Context, resourceGroupName string, name string, slot string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"slot":              autorest.Encode("path", slot),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2019-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/functions/admin/token", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// GetFunctionsAdminTokenSlotSender sends the GetFunctionsAdminTokenSlot request. The method will close the
// http.Response Body if it receives an error.
func (client AppsClient) GetFunctionsAdminTokenSlotSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// GetFunctionsAdminTokenSlotResponder handles the response to the GetFunctionsAdminTokenSlot request. The method always
// closes the http.Response Body.
func (client AppsClient) GetFunctionsAdminTokenSlotResponder(resp *http.Response) (result String, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result.Value),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// GetHostNameBinding description for Get the named hostname binding for an app (or deployment slot, if specified).
// Parameters:
// resourceGroupName - name of the resource group to which the resource belongs.
// name - name of the app.
// hostName - hostname in the hostname binding.
func (client AppsClient) GetHostNameBinding(ctx context.Context, resourceGroupName string, name string, hostName string) (result HostNameBinding, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/AppsClient.GetHostNameBinding")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewError("web.AppsClient", "GetHostNameBinding", err.Error())
	}

	req, err := client.GetHostNameBindingPreparer(ctx, resourceGroupName, name, hostName)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "GetHostNameBinding", nil, "Failure preparing request")
		return
	}

	resp, err := client.GetHostNameBindingSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.AppsClient", "GetHostNameBinding", resp, "Failure sending request")
		return
	}

	result, err = client.GetHostNameBindingResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "GetHostNameBinding", resp, "Failure responding to request")
	}

	return
}

// GetHostNameBindingPreparer prepares the GetHostNameBinding request.
func (client AppsClient) GetHostNameBindingPreparer(ctx context.Context, resourceGroupName string, name string, hostName string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"hostName":          autorest.Encode("path", hostName),
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2019-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/hostNameBindings/{hostName}", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// GetHostNameBindingSender sends the GetHostNameBinding request. The method will close the
// http.Response Body if it receives an error.
func (client AppsClient) GetHostNameBindingSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// GetHostNameBindingResponder handles the response to the GetHostNameBinding request. The method always
// closes the http.Response Body.
func (client AppsClient) GetHostNameBindingResponder(resp *http.Response) (result HostNameBinding, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// GetHostNameBindingSlot description for Get the named hostname binding for an app (or deployment slot, if specified).
// Parameters:
// resourceGroupName - name of the resource group to which the resource belongs.
// name - name of the app.
// slot - name of the deployment slot. If a slot is not specified, the API the named binding for the production
// slot.
// hostName - hostname in the hostname binding.
func (client AppsClient) GetHostNameBindingSlot(ctx context.Context, resourceGroupName string, name string, slot string, hostName string) (result HostNameBinding, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/AppsClient.GetHostNameBindingSlot")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewError("web.AppsClient", "GetHostNameBindingSlot", err.Error())
	}

	req, err := client.GetHostNameBindingSlotPreparer(ctx, resourceGroupName, name, slot, hostName)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "GetHostNameBindingSlot", nil, "Failure preparing request")
		return
	}

	resp, err := client.GetHostNameBindingSlotSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.AppsClient", "GetHostNameBindingSlot", resp, "Failure sending request")
		return
	}

	result, err = client.GetHostNameBindingSlotResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "GetHostNameBindingSlot", resp, "Failure responding to request")
	}

	return
}

// GetHostNameBindingSlotPreparer prepares the GetHostNameBindingSlot request.
func (client AppsClient) GetHostNameBindingSlotPreparer(ctx context.Context, resourceGroupName string, name string, slot string, hostName string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"hostName":          autorest.Encode("path", hostName),
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"slot":              autorest.Encode("path", slot),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2019-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/hostNameBindings/{hostName}", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// GetHostNameBindingSlotSender sends the GetHostNameBindingSlot request. The method will close the
// http.Response Body if it receives an error.
func (client AppsClient) GetHostNameBindingSlotSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// GetHostNameBindingSlotResponder handles the response to the GetHostNameBindingSlot request. The method always
// closes the http.Response Body.
func (client AppsClient) GetHostNameBindingSlotResponder(resp *http.Response) (result HostNameBinding, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// GetHybridConnection description for Retrieves a specific Service Bus Hybrid Connection used by this Web App.
// Parameters:
// resourceGroupName - name of the resource group to which the resource belongs.
// name - the name of the web app.
// namespaceName - the namespace for this hybrid connection.
// relayName - the relay name for this hybrid connection.
func (client AppsClient) GetHybridConnection(ctx context.Context, resourceGroupName string, name string, namespaceName string, relayName string) (result HybridConnection, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/AppsClient.GetHybridConnection")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewError("web.AppsClient", "GetHybridConnection", err.Error())
	}

	req, err := client.GetHybridConnectionPreparer(ctx, resourceGroupName, name, namespaceName, relayName)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "GetHybridConnection", nil, "Failure preparing request")
		return
	}

	resp, err := client.GetHybridConnectionSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.AppsClient", "GetHybridConnection", resp, "Failure sending request")
		return
	}

	result, err = client.GetHybridConnectionResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "GetHybridConnection", resp, "Failure responding to request")
	}

	return
}

// GetHybridConnectionPreparer prepares the GetHybridConnection request.
func (client AppsClient) GetHybridConnectionPreparer(ctx context.Context, resourceGroupName string, name string, namespaceName string, relayName string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"namespaceName":     autorest.Encode("path", namespaceName),
		"relayName":         autorest.Encode("path", relayName),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2019-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/hybridConnectionNamespaces/{namespaceName}/relays/{relayName}", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// GetHybridConnectionSender sends the GetHybridConnection request. The method will close the
// http.Response Body if it receives an error.
func (client AppsClient) GetHybridConnectionSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// GetHybridConnectionResponder handles the response to the GetHybridConnection request. The method always
// closes the http.Response Body.
func (client AppsClient) GetHybridConnectionResponder(resp *http.Response) (result HybridConnection, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// GetHybridConnectionSlot description for Retrieves a specific Service Bus Hybrid Connection used by this Web App.
// Parameters:
// resourceGroupName - name of the resource group to which the resource belongs.
// name - the name of the web app.
// namespaceName - the namespace for this hybrid connection.
// relayName - the relay name for this hybrid connection.
// slot - the name of the slot for the web app.
func (client AppsClient) GetHybridConnectionSlot(ctx context.Context, resourceGroupName string, name string, namespaceName string, relayName string, slot string) (result HybridConnection, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/AppsClient.GetHybridConnectionSlot")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewError("web.AppsClient", "GetHybridConnectionSlot", err.Error())
	}

	req, err := client.GetHybridConnectionSlotPreparer(ctx, resourceGroupName, name, namespaceName, relayName, slot)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "GetHybridConnectionSlot", nil, "Failure preparing request")
		return
	}

	resp, err := client.GetHybridConnectionSlotSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.AppsClient", "GetHybridConnectionSlot", resp, "Failure sending request")
		return
	}

	result, err = client.GetHybridConnectionSlotResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "GetHybridConnectionSlot", resp, "Failure responding to request")
	}

	return
}

// GetHybridConnectionSlotPreparer prepares the GetHybridConnectionSlot request.
func (client AppsClient) GetHybridConnectionSlotPreparer(ctx context.Context, resourceGroupName string, name string, namespaceName string, relayName string, slot string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"namespaceName":     autorest.Encode("path", namespaceName),
		"relayName":         autorest.Encode("path", relayName),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"slot":              autorest.Encode("path", slot),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2019-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/hybridConnectionNamespaces/{namespaceName}/relays/{relayName}", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// GetHybridConnectionSlotSender sends the GetHybridConnectionSlot request. The method will close the
// http.Response Body if it receives an error.
func (client AppsClient) GetHybridConnectionSlotSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// GetHybridConnectionSlotResponder handles the response to the GetHybridConnectionSlot request. The method always
// closes the http.Response Body.
func (client AppsClient) GetHybridConnectionSlotResponder(resp *http.Response) (result HybridConnection, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// GetInstanceFunctionSlot description for Get function information by its ID for web site, or a deployment slot.
// Parameters:
// resourceGroupName - name of the resource group to which the resource belongs.
// name - site name.
// functionName - function name.
// slot - name of the deployment slot.
func (client AppsClient) GetInstanceFunctionSlot(ctx context.Context, resourceGroupName string, name string, functionName string, slot string) (result FunctionEnvelope, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/AppsClient.GetInstanceFunctionSlot")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewError("web.AppsClient", "GetInstanceFunctionSlot", err.Error())
	}

	req, err := client.GetInstanceFunctionSlotPreparer(ctx, resourceGroupName, name, functionName, slot)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "GetInstanceFunctionSlot", nil, "Failure preparing request")
		return
	}

	resp, err := client.GetInstanceFunctionSlotSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.AppsClient", "GetInstanceFunctionSlot", resp, "Failure sending request")
		return
	}

	result, err = client.GetInstanceFunctionSlotResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "GetInstanceFunctionSlot", resp, "Failure responding to request")
	}

	return
}

// GetInstanceFunctionSlotPreparer prepares the GetInstanceFunctionSlot request.
func (client AppsClient) GetInstanceFunctionSlotPreparer(ctx context.Context, resourceGroupName string, name string, functionName string, slot string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"functionName":      autorest.Encode("path", functionName),
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"slot":              autorest.Encode("path", slot),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2019-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/functions/{functionName}", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// GetInstanceFunctionSlotSender sends the GetInstanceFunctionSlot request. The method will close the
// http.Response Body if it receives an error.
func (client AppsClient) GetInstanceFunctionSlotSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// GetInstanceFunctionSlotResponder handles the response to the GetInstanceFunctionSlot request. The method always
// closes the http.Response Body.
func (client AppsClient) GetInstanceFunctionSlotResponder(resp *http.Response) (result FunctionEnvelope, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusNotFound),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// GetInstanceInfo description for Gets all scale-out instances of an app.
// Parameters:
// resourceGroupName - name of the resource group to which the resource belongs.
// name - name of the app.
func (client AppsClient) GetInstanceInfo(ctx context.Context, resourceGroupName string, name string, instanceID string) (result SiteInstanceStatus, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/AppsClient.GetInstanceInfo")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewError("web.AppsClient", "GetInstanceInfo", err.Error())
	}

	req, err := client.GetInstanceInfoPreparer(ctx, resourceGroupName, name, instanceID)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "GetInstanceInfo", nil, "Failure preparing request")
		return
	}

	resp, err := client.GetInstanceInfoSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.AppsClient", "GetInstanceInfo", resp, "Failure sending request")
		return
	}

	result, err = client.GetInstanceInfoResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "GetInstanceInfo", resp, "Failure responding to request")
	}

	return
}

// GetInstanceInfoPreparer prepares the GetInstanceInfo request.
func (client AppsClient) GetInstanceInfoPreparer(ctx context.Context, resourceGroupName string, name string, instanceID string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"instanceId":        autorest.Encode("path", instanceID),
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2019-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/instances/{instanceId}", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// GetInstanceInfoSender sends the GetInstanceInfo request. The method will close the
// http.Response Body if it receives an error.
func (client AppsClient) GetInstanceInfoSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// GetInstanceInfoResponder handles the response to the GetInstanceInfo request. The method always
// closes the http.Response Body.
func (client AppsClient) GetInstanceInfoResponder(resp *http.Response) (result SiteInstanceStatus, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// GetInstanceInfoSlot description for Gets all scale-out instances of an app.
// Parameters:
// resourceGroupName - name of the resource group to which the resource belongs.
// name - name of the app.
// slot - name of the deployment slot. If a slot is not specified, the API gets the production slot instances.
func (client AppsClient) GetInstanceInfoSlot(ctx context.Context, resourceGroupName string, name string, instanceID string, slot string) (result SiteInstanceStatus, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/AppsClient.GetInstanceInfoSlot")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewError("web.AppsClient", "GetInstanceInfoSlot", err.Error())
	}

	req, err := client.GetInstanceInfoSlotPreparer(ctx, resourceGroupName, name, instanceID, slot)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "GetInstanceInfoSlot", nil, "Failure preparing request")
		return
	}

	resp, err := client.GetInstanceInfoSlotSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.AppsClient", "GetInstanceInfoSlot", resp, "Failure sending request")
		return
	}

	result, err = client.GetInstanceInfoSlotResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "GetInstanceInfoSlot", resp, "Failure responding to request")
	}

	return
}

// GetInstanceInfoSlotPreparer prepares the GetInstanceInfoSlot request.
func (client AppsClient) GetInstanceInfoSlotPreparer(ctx context.Context, resourceGroupName string, name string, instanceID string, slot string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"instanceId":        autorest.Encode("path", instanceID),
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"slot":              autorest.Encode("path", slot),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2019-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/instances/{instanceId}", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// GetInstanceInfoSlotSender sends the GetInstanceInfoSlot request. The method will close the
// http.Response Body if it receives an error.
func (client AppsClient) GetInstanceInfoSlotSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// GetInstanceInfoSlotResponder handles the response to the GetInstanceInfoSlot request. The method always
// closes the http.Response Body.
func (client AppsClient) GetInstanceInfoSlotResponder(resp *http.Response) (result SiteInstanceStatus, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// GetInstanceMSDeployLog description for Get the MSDeploy Log for the last MSDeploy operation.
// Parameters:
// resourceGroupName - name of the resource group to which the resource belongs.
// name - name of web app.
// instanceID - ID of web app instance.
func (client AppsClient) GetInstanceMSDeployLog(ctx context.Context, resourceGroupName string, name string, instanceID string) (result MSDeployLog, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/AppsClient.GetInstanceMSDeployLog")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewError("web.AppsClient", "GetInstanceMSDeployLog", err.Error())
	}

	req, err := client.GetInstanceMSDeployLogPreparer(ctx, resourceGroupName, name, instanceID)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "GetInstanceMSDeployLog", nil, "Failure preparing request")
		return
	}

	resp, err := client.GetInstanceMSDeployLogSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.AppsClient", "GetInstanceMSDeployLog", resp, "Failure sending request")
		return
	}

	result, err = client.GetInstanceMSDeployLogResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "GetInstanceMSDeployLog", resp, "Failure responding to request")
	}

	return
}

// GetInstanceMSDeployLogPreparer prepares the GetInstanceMSDeployLog request.
func (client AppsClient) GetInstanceMSDeployLogPreparer(ctx context.Context, resourceGroupName string, name string, instanceID string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"instanceId":        autorest.Encode("path", instanceID),
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2019-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/instances/{instanceId}/extensions/MSDeploy/log", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// GetInstanceMSDeployLogSender sends the GetInstanceMSDeployLog request. The method will close the
// http.Response Body if it receives an error.
func (client AppsClient) GetInstanceMSDeployLogSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// GetInstanceMSDeployLogResponder handles the response to the GetInstanceMSDeployLog request. The method always
// closes the http.Response Body.
func (client AppsClient) GetInstanceMSDeployLogResponder(resp *http.Response) (result MSDeployLog, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusNotFound),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// GetInstanceMSDeployLogSlot description for Get the MSDeploy Log for the last MSDeploy operation.
// Parameters:
// resourceGroupName - name of the resource group to which the resource belongs.
// name - name of web app.
// slot - name of web app slot. If not specified then will default to production slot.
// instanceID - ID of web app instance.
func (client AppsClient) GetInstanceMSDeployLogSlot(ctx context.Context, resourceGroupName string, name string, slot string, instanceID string) (result MSDeployLog, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/AppsClient.GetInstanceMSDeployLogSlot")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewError("web.AppsClient", "GetInstanceMSDeployLogSlot", err.Error())
	}

	req, err := client.GetInstanceMSDeployLogSlotPreparer(ctx, resourceGroupName, name, slot, instanceID)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "GetInstanceMSDeployLogSlot", nil, "Failure preparing request")
		return
	}

	resp, err := client.GetInstanceMSDeployLogSlotSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.AppsClient", "GetInstanceMSDeployLogSlot", resp, "Failure sending request")
		return
	}

	result, err = client.GetInstanceMSDeployLogSlotResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "GetInstanceMSDeployLogSlot", resp, "Failure responding to request")
	}

	return
}

// GetInstanceMSDeployLogSlotPreparer prepares the GetInstanceMSDeployLogSlot request.
func (client AppsClient) GetInstanceMSDeployLogSlotPreparer(ctx context.Context, resourceGroupName string, name string, slot string, instanceID string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"instanceId":        autorest.Encode("path", instanceID),
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"slot":              autorest.Encode("path", slot),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2019-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/instances/{instanceId}/extensions/MSDeploy/log", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// GetInstanceMSDeployLogSlotSender sends the GetInstanceMSDeployLogSlot request. The method will close the
// http.Response Body if it receives an error.
func (client AppsClient) GetInstanceMSDeployLogSlotSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// GetInstanceMSDeployLogSlotResponder handles the response to the GetInstanceMSDeployLogSlot request. The method always
// closes the http.Response Body.
func (client AppsClient) GetInstanceMSDeployLogSlotResponder(resp *http.Response) (result MSDeployLog, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusNotFound),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// GetInstanceMsDeployStatus description for Get the status of the last MSDeploy operation.
// Parameters:
// resourceGroupName - name of the resource group to which the resource belongs.
// name - name of web app.
// instanceID - ID of web app instance.
func (client AppsClient) GetInstanceMsDeployStatus(ctx context.Context, resourceGroupName string, name string, instanceID string) (result MSDeployStatus, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/AppsClient.GetInstanceMsDeployStatus")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewError("web.AppsClient", "GetInstanceMsDeployStatus", err.Error())
	}

	req, err := client.GetInstanceMsDeployStatusPreparer(ctx, resourceGroupName, name, instanceID)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "GetInstanceMsDeployStatus", nil, "Failure preparing request")
		return
	}

	resp, err := client.GetInstanceMsDeployStatusSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.AppsClient", "GetInstanceMsDeployStatus", resp, "Failure sending request")
		return
	}

	result, err = client.GetInstanceMsDeployStatusResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "GetInstanceMsDeployStatus", resp, "Failure responding to request")
	}

	return
}

// GetInstanceMsDeployStatusPreparer prepares the GetInstanceMsDeployStatus request.
func (client AppsClient) GetInstanceMsDeployStatusPreparer(ctx context.Context, resourceGroupName string, name string, instanceID string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"instanceId":        autorest.Encode("path", instanceID),
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2019-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/instances/{instanceId}/extensions/MSDeploy", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// GetInstanceMsDeployStatusSender sends the GetInstanceMsDeployStatus request. The method will close the
// http.Response Body if it receives an error.
func (client AppsClient) GetInstanceMsDeployStatusSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// GetInstanceMsDeployStatusResponder handles the response to the GetInstanceMsDeployStatus request. The method always
// closes the http.Response Body.
func (client AppsClient) GetInstanceMsDeployStatusResponder(resp *http.Response) (result MSDeployStatus, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// GetInstanceMsDeployStatusSlot description for Get the status of the last MSDeploy operation.
// Parameters:
// resourceGroupName - name of the resource group to which the resource belongs.
// name - name of web app.
// slot - name of web app slot. If not specified then will default to production slot.
// instanceID - ID of web app instance.
func (client AppsClient) GetInstanceMsDeployStatusSlot(ctx context.Context, resourceGroupName string, name string, slot string, instanceID string) (result MSDeployStatus, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/AppsClient.GetInstanceMsDeployStatusSlot")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewError("web.AppsClient", "GetInstanceMsDeployStatusSlot", err.Error())
	}

	req, err := client.GetInstanceMsDeployStatusSlotPreparer(ctx, resourceGroupName, name, slot, instanceID)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "GetInstanceMsDeployStatusSlot", nil, "Failure preparing request")
		return
	}

	resp, err := client.GetInstanceMsDeployStatusSlotSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.AppsClient", "GetInstanceMsDeployStatusSlot", resp, "Failure sending request")
		return
	}

	result, err = client.GetInstanceMsDeployStatusSlotResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "GetInstanceMsDeployStatusSlot", resp, "Failure responding to request")
	}

	return
}

// GetInstanceMsDeployStatusSlotPreparer prepares the GetInstanceMsDeployStatusSlot request.
func (client AppsClient) GetInstanceMsDeployStatusSlotPreparer(ctx context.Context, resourceGroupName string, name string, slot string, instanceID string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"instanceId":        autorest.Encode("path", instanceID),
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"slot":              autorest.Encode("path", slot),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2019-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/instances/{instanceId}/extensions/MSDeploy", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// GetInstanceMsDeployStatusSlotSender sends the GetInstanceMsDeployStatusSlot request. The method will close the
// http.Response Body if it receives an error.
func (client AppsClient) GetInstanceMsDeployStatusSlotSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// GetInstanceMsDeployStatusSlotResponder handles the response to the GetInstanceMsDeployStatusSlot request. The method always
// closes the http.Response Body.
func (client AppsClient) GetInstanceMsDeployStatusSlotResponder(resp *http.Response) (result MSDeployStatus, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// GetInstanceProcess description for Get process information by its ID for a specific scaled-out instance in a web
// site.
// Parameters:
// resourceGroupName - name of the resource group to which the resource belongs.
// name - site name.
// processID - pID.
// instanceID - ID of a specific scaled-out instance. This is the value of the name property in the JSON
// response from "GET api/sites/{siteName}/instances".
func (client AppsClient) GetInstanceProcess(ctx context.Context, resourceGroupName string, name string, processID string, instanceID string) (result ProcessInfo, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/AppsClient.GetInstanceProcess")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewError("web.AppsClient", "GetInstanceProcess", err.Error())
	}

	req, err := client.GetInstanceProcessPreparer(ctx, resourceGroupName, name, processID, instanceID)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "GetInstanceProcess", nil, "Failure preparing request")
		return
	}

	resp, err := client.GetInstanceProcessSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.AppsClient", "GetInstanceProcess", resp, "Failure sending request")
		return
	}

	result, err = client.GetInstanceProcessResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "GetInstanceProcess", resp, "Failure responding to request")
	}

	return
}

// GetInstanceProcessPreparer prepares the GetInstanceProcess request.
func (client AppsClient) GetInstanceProcessPreparer(ctx context.Context, resourceGroupName string, name string, processID string, instanceID string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"instanceId":        autorest.Encode("path", instanceID),
		"name":              autorest.Encode("path", name),
		"processId":         autorest.Encode("path", processID),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2019-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/instances/{instanceId}/processes/{processId}", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// GetInstanceProcessSender sends the GetInstanceProcess request. The method will close the
// http.Response Body if it receives an error.
func (client AppsClient) GetInstanceProcessSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// GetInstanceProcessResponder handles the response to the GetInstanceProcess request. The method always
// closes the http.Response Body.
func (client AppsClient) GetInstanceProcessResponder(resp *http.Response) (result ProcessInfo, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusNotFound),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// GetInstanceProcessDump description for Get a memory dump of a process by its ID for a specific scaled-out instance
// in a web site.
// Parameters:
// resourceGroupName - name of the resource group to which the resource belongs.
// name - site name.
// processID - pID.
// instanceID - ID of a specific scaled-out instance. This is the value of the name property in the JSON
// response from "GET api/sites/{siteName}/instances".
func (client AppsClient) GetInstanceProcessDump(ctx context.Context, resourceGroupName string, name string, processID string, instanceID string) (result ReadCloser, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/AppsClient.GetInstanceProcessDump")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewError("web.AppsClient", "GetInstanceProcessDump", err.Error())
	}

	req, err := client.GetInstanceProcessDumpPreparer(ctx, resourceGroupName, name, processID, instanceID)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "GetInstanceProcessDump", nil, "Failure preparing request")
		return
	}

	resp, err := client.GetInstanceProcessDumpSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.AppsClient", "GetInstanceProcessDump", resp, "Failure sending request")
		return
	}

	result, err = client.GetInstanceProcessDumpResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "GetInstanceProcessDump", resp, "Failure responding to request")
	}

	return
}

// GetInstanceProcessDumpPreparer prepares the GetInstanceProcessDump request.
func (client AppsClient) GetInstanceProcessDumpPreparer(ctx context.Context, resourceGroupName string, name string, processID string, instanceID string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"instanceId":        autorest.Encode("path", instanceID),
		"name":              autorest.Encode("path", name),
		"processId":         autorest.Encode("path", processID),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2019-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/instances/{instanceId}/processes/{processId}/dump", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// GetInstanceProcessDumpSender sends the GetInstanceProcessDump request. The method will close the
// http.Response Body if it receives an error.
func (client AppsClient) GetInstanceProcessDumpSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// GetInstanceProcessDumpResponder handles the response to the GetInstanceProcessDump request. The method always
// closes the http.Response Body.
func (client AppsClient) GetInstanceProcessDumpResponder(resp *http.Response) (result ReadCloser, err error) {
	result.Value = &resp.Body
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusNotFound))
	result.Response = autorest.Response{Response: resp}
	return
}

// GetInstanceProcessDumpSlot description for Get a memory dump of a process by its ID for a specific scaled-out
// instance in a web site.
// Parameters:
// resourceGroupName - name of the resource group to which the resource belongs.
// name - site name.
// processID - pID.
// slot - name of the deployment slot. If a slot is not specified, the API returns deployments for the
// production slot.
// instanceID - ID of a specific scaled-out instance. This is the value of the name property in the JSON
// response from "GET api/sites/{siteName}/instances".
func (client AppsClient) GetInstanceProcessDumpSlot(ctx context.Context, resourceGroupName string, name string, processID string, slot string, instanceID string) (result ReadCloser, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/AppsClient.GetInstanceProcessDumpSlot")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewError("web.AppsClient", "GetInstanceProcessDumpSlot", err.Error())
	}

	req, err := client.GetInstanceProcessDumpSlotPreparer(ctx, resourceGroupName, name, processID, slot, instanceID)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "GetInstanceProcessDumpSlot", nil, "Failure preparing request")
		return
	}

	resp, err := client.GetInstanceProcessDumpSlotSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.AppsClient", "GetInstanceProcessDumpSlot", resp, "Failure sending request")
		return
	}

	result, err = client.GetInstanceProcessDumpSlotResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "GetInstanceProcessDumpSlot", resp, "Failure responding to request")
	}

	return
}

// GetInstanceProcessDumpSlotPreparer prepares the GetInstanceProcessDumpSlot request.
func (client AppsClient) GetInstanceProcessDumpSlotPreparer(ctx context.Context, resourceGroupName string, name string, processID string, slot string, instanceID string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"instanceId":        autorest.Encode("path", instanceID),
		"name":              autorest.Encode("path", name),
		"processId":         autorest.Encode("path", processID),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"slot":              autorest.Encode("path", slot),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2019-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/instances/{instanceId}/processes/{processId}/dump", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// GetInstanceProcessDumpSlotSender sends the GetInstanceProcessDumpSlot request. The method will close the
// http.Response Body if it receives an error.
func (client AppsClient) GetInstanceProcessDumpSlotSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// GetInstanceProcessDumpSlotResponder handles the response to the GetInstanceProcessDumpSlot request. The method always
// closes the http.Response Body.
func (client AppsClient) GetInstanceProcessDumpSlotResponder(resp *http.Response) (result ReadCloser, err error) {
	result.Value = &resp.Body
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusNotFound))
	result.Response = autorest.Response{Response: resp}
	return
}

// GetInstanceProcessModule description for Get process information by its ID for a specific scaled-out instance in a
// web site.
// Parameters:
// resourceGroupName - name of the resource group to which the resource belongs.
// name - site name.
// processID - pID.
// baseAddress - module base address.
// instanceID - ID of a specific scaled-out instance. This is the value of the name property in the JSON
// response from "GET api/sites/{siteName}/instances".
func (client AppsClient) GetInstanceProcessModule(ctx context.Context, resourceGroupName string, name string, processID string, baseAddress string, instanceID string) (result ProcessModuleInfo, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/AppsClient.GetInstanceProcessModule")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewError("web.AppsClient", "GetInstanceProcessModule", err.Error())
	}

	req, err := client.GetInstanceProcessModulePreparer(ctx, resourceGroupName, name, processID, baseAddress, instanceID)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "GetInstanceProcessModule", nil, "Failure preparing request")
		return
	}

	resp, err := client.GetInstanceProcessModuleSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.AppsClient", "GetInstanceProcessModule", resp, "Failure sending request")
		return
	}

	result, err = client.GetInstanceProcessModuleResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "GetInstanceProcessModule", resp, "Failure responding to request")
	}

	return
}

// GetInstanceProcessModulePreparer prepares the GetInstanceProcessModule request.
func (client AppsClient) GetInstanceProcessModulePreparer(ctx context.Context, resourceGroupName string, name string, processID string, baseAddress string, instanceID string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"baseAddress":       autorest.Encode("path", baseAddress),
		"instanceId":        autorest.Encode("path", instanceID),
		"name":              autorest.Encode("path", name),
		"processId":         autorest.Encode("path", processID),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2019-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/instances/{instanceId}/processes/{processId}/modules/{baseAddress}", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// GetInstanceProcessModuleSender sends the GetInstanceProcessModule request. The method will close the
// http.Response Body if it receives an error.
func (client AppsClient) GetInstanceProcessModuleSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// GetInstanceProcessModuleResponder handles the response to the GetInstanceProcessModule request. The method always
// closes the http.Response Body.
func (client AppsClient) GetInstanceProcessModuleResponder(resp *http.Response) (result ProcessModuleInfo, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusNotFound),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// GetInstanceProcessModuleSlot description for Get process information by its ID for a specific scaled-out instance in
// a web site.
// Parameters:
// resourceGroupName - name of the resource group to which the resource belongs.
// name - site name.
// processID - pID.
// baseAddress - module base address.
// slot - name of the deployment slot. If a slot is not specified, the API returns deployments for the
// production slot.
// instanceID - ID of a specific scaled-out instance. This is the value of the name property in the JSON
// response from "GET api/sites/{siteName}/instances".
func (client AppsClient) GetInstanceProcessModuleSlot(ctx context.Context, resourceGroupName string, name string, processID string, baseAddress string, slot string, instanceID string) (result ProcessModuleInfo, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/AppsClient.GetInstanceProcessModuleSlot")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewError("web.AppsClient", "GetInstanceProcessModuleSlot", err.Error())
	}

	req, err := client.GetInstanceProcessModuleSlotPreparer(ctx, resourceGroupName, name, processID, baseAddress, slot, instanceID)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "GetInstanceProcessModuleSlot", nil, "Failure preparing request")
		return
	}

	resp, err := client.GetInstanceProcessModuleSlotSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.AppsClient", "GetInstanceProcessModuleSlot", resp, "Failure sending request")
		return
	}

	result, err = client.GetInstanceProcessModuleSlotResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "GetInstanceProcessModuleSlot", resp, "Failure responding to request")
	}

	return
}

// GetInstanceProcessModuleSlotPreparer prepares the GetInstanceProcessModuleSlot request.
func (client AppsClient) GetInstanceProcessModuleSlotPreparer(ctx context.Context, resourceGroupName string, name string, processID string, baseAddress string, slot string, instanceID string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"baseAddress":       autorest.Encode("path", baseAddress),
		"instanceId":        autorest.Encode("path", instanceID),
		"name":              autorest.Encode("path", name),
		"processId":         autorest.Encode("path", processID),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"slot":              autorest.Encode("path", slot),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2019-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/instances/{instanceId}/processes/{processId}/modules/{baseAddress}", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// GetInstanceProcessModuleSlotSender sends the GetInstanceProcessModuleSlot request. The method will close the
// http.Response Body if it receives an error.
func (client AppsClient) GetInstanceProcessModuleSlotSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// GetInstanceProcessModuleSlotResponder handles the response to the GetInstanceProcessModuleSlot request. The method always
// closes the http.Response Body.
func (client AppsClient) GetInstanceProcessModuleSlotResponder(resp *http.Response) (result ProcessModuleInfo, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusNotFound),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// GetInstanceProcessSlot description for Get process information by its ID for a specific scaled-out instance in a web
// site.
// Parameters:
// resourceGroupName - name of the resource group to which the resource belongs.
// name - site name.
// processID - pID.
// slot - name of the deployment slot. If a slot is not specified, the API returns deployments for the
// production slot.
// instanceID - ID of a specific scaled-out instance. This is the value of the name property in the JSON
// response from "GET api/sites/{siteName}/instances".
func (client AppsClient) GetInstanceProcessSlot(ctx context.Context, resourceGroupName string, name string, processID string, slot string, instanceID string) (result ProcessInfo, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/AppsClient.GetInstanceProcessSlot")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewError("web.AppsClient", "GetInstanceProcessSlot", err.Error())
	}

	req, err := client.GetInstanceProcessSlotPreparer(ctx, resourceGroupName, name, processID, slot, instanceID)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "GetInstanceProcessSlot", nil, "Failure preparing request")
		return
	}

	resp, err := client.GetInstanceProcessSlotSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.AppsClient", "GetInstanceProcessSlot", resp, "Failure sending request")
		return
	}

	result, err = client.GetInstanceProcessSlotResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "GetInstanceProcessSlot", resp, "Failure responding to request")
	}

	return
}

// GetInstanceProcessSlotPreparer prepares the GetInstanceProcessSlot request.
func (client AppsClient) GetInstanceProcessSlotPreparer(ctx context.Context, resourceGroupName string, name string, processID string, slot string, instanceID string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"instanceId":        autorest.Encode("path", instanceID),
		"name":              autorest.Encode("path", name),
		"processId":         autorest.Encode("path", processID),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"slot":              autorest.Encode("path", slot),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2019-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/instances/{instanceId}/processes/{processId}", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// GetInstanceProcessSlotSender sends the GetInstanceProcessSlot request. The method will close the
// http.Response Body if it receives an error.
func (client AppsClient) GetInstanceProcessSlotSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// GetInstanceProcessSlotResponder handles the response to the GetInstanceProcessSlot request. The method always
// closes the http.Response Body.
func (client AppsClient) GetInstanceProcessSlotResponder(resp *http.Response) (result ProcessInfo, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusNotFound),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// GetMigrateMySQLStatus description for Returns the status of MySql in app migration, if one is active, and whether or
// not MySql in app is enabled
// Parameters:
// resourceGroupName - name of the resource group to which the resource belongs.
// name - name of web app.
func (client AppsClient) GetMigrateMySQLStatus(ctx context.Context, resourceGroupName string, name string) (result MigrateMySQLStatus, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/AppsClient.GetMigrateMySQLStatus")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewError("web.AppsClient", "GetMigrateMySQLStatus", err.Error())
	}

	req, err := client.GetMigrateMySQLStatusPreparer(ctx, resourceGroupName, name)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "GetMigrateMySQLStatus", nil, "Failure preparing request")
		return
	}

	resp, err := client.GetMigrateMySQLStatusSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.AppsClient", "GetMigrateMySQLStatus", resp, "Failure sending request")
		return
	}

	result, err = client.GetMigrateMySQLStatusResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "GetMigrateMySQLStatus", resp, "Failure responding to request")
	}

	return
}

// GetMigrateMySQLStatusPreparer prepares the GetMigrateMySQLStatus request.
func (client AppsClient) GetMigrateMySQLStatusPreparer(ctx context.Context, resourceGroupName string, name string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2019-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/migratemysql/status", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// GetMigrateMySQLStatusSender sends the GetMigrateMySQLStatus request. The method will close the
// http.Response Body if it receives an error.
func (client AppsClient) GetMigrateMySQLStatusSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// GetMigrateMySQLStatusResponder handles the response to the GetMigrateMySQLStatus request. The method always
// closes the http.Response Body.
func (client AppsClient) GetMigrateMySQLStatusResponder(resp *http.Response) (result MigrateMySQLStatus, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// GetMigrateMySQLStatusSlot description for Returns the status of MySql in app migration, if one is active, and
// whether or not MySql in app is enabled
// Parameters:
// resourceGroupName - name of the resource group to which the resource belongs.
// name - name of web app.
// slot - name of the deployment slot.
func (client AppsClient) GetMigrateMySQLStatusSlot(ctx context.Context, resourceGroupName string, name string, slot string) (result MigrateMySQLStatus, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/AppsClient.GetMigrateMySQLStatusSlot")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewError("web.AppsClient", "GetMigrateMySQLStatusSlot", err.Error())
	}

	req, err := client.GetMigrateMySQLStatusSlotPreparer(ctx, resourceGroupName, name, slot)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "GetMigrateMySQLStatusSlot", nil, "Failure preparing request")
		return
	}

	resp, err := client.GetMigrateMySQLStatusSlotSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.AppsClient", "GetMigrateMySQLStatusSlot", resp, "Failure sending request")
		return
	}

	result, err = client.GetMigrateMySQLStatusSlotResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "GetMigrateMySQLStatusSlot", resp, "Failure responding to request")
	}

	return
}

// GetMigrateMySQLStatusSlotPreparer prepares the GetMigrateMySQLStatusSlot request.
func (client AppsClient) GetMigrateMySQLStatusSlotPreparer(ctx context.Context, resourceGroupName string, name string, slot string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"slot":              autorest.Encode("path", slot),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2019-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/migratemysql/status", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// GetMigrateMySQLStatusSlotSender sends the GetMigrateMySQLStatusSlot request. The method will close the
// http.Response Body if it receives an error.
func (client AppsClient) GetMigrateMySQLStatusSlotSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// GetMigrateMySQLStatusSlotResponder handles the response to the GetMigrateMySQLStatusSlot request. The method always
// closes the http.Response Body.
func (client AppsClient) GetMigrateMySQLStatusSlotResponder(resp *http.Response) (result MigrateMySQLStatus, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// GetMSDeployLog description for Get the MSDeploy Log for the last MSDeploy operation.
// Parameters:
// resourceGroupName - name of the resource group to which the resource belongs.
// name - name of web app.
func (client AppsClient) GetMSDeployLog(ctx context.Context, resourceGroupName string, name string) (result MSDeployLog, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/AppsClient.GetMSDeployLog")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewError("web.AppsClient", "GetMSDeployLog", err.Error())
	}

	req, err := client.GetMSDeployLogPreparer(ctx, resourceGroupName, name)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "GetMSDeployLog", nil, "Failure preparing request")
		return
	}

	resp, err := client.GetMSDeployLogSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.AppsClient", "GetMSDeployLog", resp, "Failure sending request")
		return
	}

	result, err = client.GetMSDeployLogResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "GetMSDeployLog", resp, "Failure responding to request")
	}

	return
}

// GetMSDeployLogPreparer prepares the GetMSDeployLog request.
func (client AppsClient) GetMSDeployLogPreparer(ctx context.Context, resourceGroupName string, name string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2019-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/extensions/MSDeploy/log", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// GetMSDeployLogSender sends the GetMSDeployLog request. The method will close the
// http.Response Body if it receives an error.
func (client AppsClient) GetMSDeployLogSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// GetMSDeployLogResponder handles the response to the GetMSDeployLog request. The method always
// closes the http.Response Body.
func (client AppsClient) GetMSDeployLogResponder(resp *http.Response) (result MSDeployLog, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusNotFound),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// GetMSDeployLogSlot description for Get the MSDeploy Log for the last MSDeploy operation.
// Parameters:
// resourceGroupName - name of the resource group to which the resource belongs.
// name - name of web app.
// slot - name of web app slot. If not specified then will default to production slot.
func (client AppsClient) GetMSDeployLogSlot(ctx context.Context, resourceGroupName string, name string, slot string) (result MSDeployLog, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/AppsClient.GetMSDeployLogSlot")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewError("web.AppsClient", "GetMSDeployLogSlot", err.Error())
	}

	req, err := client.GetMSDeployLogSlotPreparer(ctx, resourceGroupName, name, slot)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "GetMSDeployLogSlot", nil, "Failure preparing request")
		return
	}

	resp, err := client.GetMSDeployLogSlotSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.AppsClient", "GetMSDeployLogSlot", resp, "Failure sending request")
		return
	}

	result, err = client.GetMSDeployLogSlotResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "GetMSDeployLogSlot", resp, "Failure responding to request")
	}

	return
}

// GetMSDeployLogSlotPreparer prepares the GetMSDeployLogSlot request.
func (client AppsClient) GetMSDeployLogSlotPreparer(ctx context.Context, resourceGroupName string, name string, slot string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"slot":              autorest.Encode("path", slot),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2019-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/extensions/MSDeploy/log", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// GetMSDeployLogSlotSender sends the GetMSDeployLogSlot request. The method will close the
// http.Response Body if it receives an error.
func (client AppsClient) GetMSDeployLogSlotSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// GetMSDeployLogSlotResponder handles the response to the GetMSDeployLogSlot request. The method always
// closes the http.Response Body.
func (client AppsClient) GetMSDeployLogSlotResponder(resp *http.Response) (result MSDeployLog, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusNotFound),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// GetMSDeployStatus description for Get the status of the last MSDeploy operation.
// Parameters:
// resourceGroupName - name of the resource group to which the resource belongs.
// name - name of web app.
func (client AppsClient) GetMSDeployStatus(ctx context.Context, resourceGroupName string, name string) (result MSDeployStatus, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/AppsClient.GetMSDeployStatus")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewError("web.AppsClient", "GetMSDeployStatus", err.Error())
	}

	req, err := client.GetMSDeployStatusPreparer(ctx, resourceGroupName, name)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "GetMSDeployStatus", nil, "Failure preparing request")
		return
	}

	resp, err := client.GetMSDeployStatusSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.AppsClient", "GetMSDeployStatus", resp, "Failure sending request")
		return
	}

	result, err = client.GetMSDeployStatusResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "GetMSDeployStatus", resp, "Failure responding to request")
	}

	return
}

// GetMSDeployStatusPreparer prepares the GetMSDeployStatus request.
func (client AppsClient) GetMSDeployStatusPreparer(ctx context.Context, resourceGroupName string, name string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2019-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/extensions/MSDeploy", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// GetMSDeployStatusSender sends the GetMSDeployStatus request. The method will close the
// http.Response Body if it receives an error.
func (client AppsClient) GetMSDeployStatusSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// GetMSDeployStatusResponder handles the response to the GetMSDeployStatus request. The method always
// closes the http.Response Body.
func (client AppsClient) GetMSDeployStatusResponder(resp *http.Response) (result MSDeployStatus, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// GetMSDeployStatusSlot description for Get the status of the last MSDeploy operation.
// Parameters:
// resourceGroupName - name of the resource group to which the resource belongs.
// name - name of web app.
// slot - name of web app slot. If not specified then will default to production slot.
func (client AppsClient) GetMSDeployStatusSlot(ctx context.Context, resourceGroupName string, name string, slot string) (result MSDeployStatus, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/AppsClient.GetMSDeployStatusSlot")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewError("web.AppsClient", "GetMSDeployStatusSlot", err.Error())
	}

	req, err := client.GetMSDeployStatusSlotPreparer(ctx, resourceGroupName, name, slot)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "GetMSDeployStatusSlot", nil, "Failure preparing request")
		return
	}

	resp, err := client.GetMSDeployStatusSlotSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.AppsClient", "GetMSDeployStatusSlot", resp, "Failure sending request")
		return
	}

	result, err = client.GetMSDeployStatusSlotResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "GetMSDeployStatusSlot", resp, "Failure responding to request")
	}

	return
}

// GetMSDeployStatusSlotPreparer prepares the GetMSDeployStatusSlot request.
func (client AppsClient) GetMSDeployStatusSlotPreparer(ctx context.Context, resourceGroupName string, name string, slot string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"slot":              autorest.Encode("path", slot),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2019-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/extensions/MSDeploy", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// GetMSDeployStatusSlotSender sends the GetMSDeployStatusSlot request. The method will close the
// http.Response Body if it receives an error.
func (client AppsClient) GetMSDeployStatusSlotSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// GetMSDeployStatusSlotResponder handles the response to the GetMSDeployStatusSlot request. The method always
// closes the http.Response Body.
func (client AppsClient) GetMSDeployStatusSlotResponder(resp *http.Response) (result MSDeployStatus, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// GetNetworkTraceOperation description for Gets a named operation for a network trace capturing (or deployment slot,
// if specified).
// Parameters:
// resourceGroupName - name of the resource group to which the resource belongs.
// name - name of the app.
// operationID - GUID of the operation.
func (client AppsClient) GetNetworkTraceOperation(ctx context.Context, resourceGroupName string, name string, operationID string) (result ListNetworkTrace, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/AppsClient.GetNetworkTraceOperation")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewError("web.AppsClient", "GetNetworkTraceOperation", err.Error())
	}

	req, err := client.GetNetworkTraceOperationPreparer(ctx, resourceGroupName, name, operationID)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "GetNetworkTraceOperation", nil, "Failure preparing request")
		return
	}

	resp, err := client.GetNetworkTraceOperationSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.AppsClient", "GetNetworkTraceOperation", resp, "Failure sending request")
		return
	}

	result, err = client.GetNetworkTraceOperationResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "GetNetworkTraceOperation", resp, "Failure responding to request")
	}

	return
}

// GetNetworkTraceOperationPreparer prepares the GetNetworkTraceOperation request.
func (client AppsClient) GetNetworkTraceOperationPreparer(ctx context.Context, resourceGroupName string, name string, operationID string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"operationId":       autorest.Encode("path", operationID),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2019-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/networkTrace/operationresults/{operationId}", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// GetNetworkTraceOperationSender sends the GetNetworkTraceOperation request. The method will close the
// http.Response Body if it receives an error.
func (client AppsClient) GetNetworkTraceOperationSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// GetNetworkTraceOperationResponder handles the response to the GetNetworkTraceOperation request. The method always
// closes the http.Response Body.
func (client AppsClient) GetNetworkTraceOperationResponder(resp *http.Response) (result ListNetworkTrace, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusAccepted),
		autorest.ByUnmarshallingJSON(&result.Value),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// GetNetworkTraceOperationSlot description for Gets a named operation for a network trace capturing (or deployment
// slot, if specified).
// Parameters:
// resourceGroupName - name of the resource group to which the resource belongs.
// name - name of the app.
// operationID - GUID of the operation.
// slot - name of the deployment slot. If a slot is not specified, the API will get an operation for the
// production slot.
func (client AppsClient) GetNetworkTraceOperationSlot(ctx context.Context, resourceGroupName string, name string, operationID string, slot string) (result ListNetworkTrace, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/AppsClient.GetNetworkTraceOperationSlot")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewError("web.AppsClient", "GetNetworkTraceOperationSlot", err.Error())
	}

	req, err := client.GetNetworkTraceOperationSlotPreparer(ctx, resourceGroupName, name, operationID, slot)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "GetNetworkTraceOperationSlot", nil, "Failure preparing request")
		return
	}

	resp, err := client.GetNetworkTraceOperationSlotSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.AppsClient", "GetNetworkTraceOperationSlot", resp, "Failure sending request")
		return
	}

	result, err = client.GetNetworkTraceOperationSlotResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "GetNetworkTraceOperationSlot", resp, "Failure responding to request")
	}

	return
}

// GetNetworkTraceOperationSlotPreparer prepares the GetNetworkTraceOperationSlot request.
func (client AppsClient) GetNetworkTraceOperationSlotPreparer(ctx context.Context, resourceGroupName string, name string, operationID string, slot string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"operationId":       autorest.Encode("path", operationID),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"slot":              autorest.Encode("path", slot),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2019-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/networkTrace/operationresults/{operationId}", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// GetNetworkTraceOperationSlotSender sends the GetNetworkTraceOperationSlot request. The method will close the
// http.Response Body if it receives an error.
func (client AppsClient) GetNetworkTraceOperationSlotSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// GetNetworkTraceOperationSlotResponder handles the response to the GetNetworkTraceOperationSlot request. The method always
// closes the http.Response Body.
func (client AppsClient) GetNetworkTraceOperationSlotResponder(resp *http.Response) (result ListNetworkTrace, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusAccepted),
		autorest.ByUnmarshallingJSON(&result.Value),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// GetNetworkTraceOperationSlotV2 description for Gets a named operation for a network trace capturing (or deployment
// slot, if specified).
// Parameters:
// resourceGroupName - name of the resource group to which the resource belongs.
// name - name of the app.
// operationID - GUID of the operation.
// slot - name of the deployment slot. If a slot is not specified, the API will get an operation for the
// production slot.
func (client AppsClient) GetNetworkTraceOperationSlotV2(ctx context.Context, resourceGroupName string, name string, operationID string, slot string) (result ListNetworkTrace, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/AppsClient.GetNetworkTraceOperationSlotV2")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewError("web.AppsClient", "GetNetworkTraceOperationSlotV2", err.Error())
	}

	req, err := client.GetNetworkTraceOperationSlotV2Preparer(ctx, resourceGroupName, name, operationID, slot)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "GetNetworkTraceOperationSlotV2", nil, "Failure preparing request")
		return
	}

	resp, err := client.GetNetworkTraceOperationSlotV2Sender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.AppsClient", "GetNetworkTraceOperationSlotV2", resp, "Failure sending request")
		return
	}

	result, err = client.GetNetworkTraceOperationSlotV2Responder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "GetNetworkTraceOperationSlotV2", resp, "Failure responding to request")
	}

	return
}

// GetNetworkTraceOperationSlotV2Preparer prepares the GetNetworkTraceOperationSlotV2 request.
func (client AppsClient) GetNetworkTraceOperationSlotV2Preparer(ctx context.Context, resourceGroupName string, name string, operationID string, slot string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"operationId":       autorest.Encode("path", operationID),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"slot":              autorest.Encode("path", slot),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2019-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/networkTraces/current/operationresults/{operationId}", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// GetNetworkTraceOperationSlotV2Sender sends the GetNetworkTraceOperationSlotV2 request. The method will close the
// http.Response Body if it receives an error.
func (client AppsClient) GetNetworkTraceOperationSlotV2Sender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// GetNetworkTraceOperationSlotV2Responder handles the response to the GetNetworkTraceOperationSlotV2 request. The method always
// closes the http.Response Body.
func (client AppsClient) GetNetworkTraceOperationSlotV2Responder(resp *http.Response) (result ListNetworkTrace, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusAccepted),
		autorest.ByUnmarshallingJSON(&result.Value),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// GetNetworkTraceOperationV2 description for Gets a named operation for a network trace capturing (or deployment slot,
// if specified).
// Parameters:
// resourceGroupName - name of the resource group to which the resource belongs.
// name - name of the app.
// operationID - GUID of the operation.
func (client AppsClient) GetNetworkTraceOperationV2(ctx context.Context, resourceGroupName string, name string, operationID string) (result ListNetworkTrace, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/AppsClient.GetNetworkTraceOperationV2")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewError("web.AppsClient", "GetNetworkTraceOperationV2", err.Error())
	}

	req, err := client.GetNetworkTraceOperationV2Preparer(ctx, resourceGroupName, name, operationID)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "GetNetworkTraceOperationV2", nil, "Failure preparing request")
		return
	}

	resp, err := client.GetNetworkTraceOperationV2Sender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.AppsClient", "GetNetworkTraceOperationV2", resp, "Failure sending request")
		return
	}

	result, err = client.GetNetworkTraceOperationV2Responder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "GetNetworkTraceOperationV2", resp, "Failure responding to request")
	}

	return
}

// GetNetworkTraceOperationV2Preparer prepares the GetNetworkTraceOperationV2 request.
func (client AppsClient) GetNetworkTraceOperationV2Preparer(ctx context.Context, resourceGroupName string, name string, operationID string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"operationId":       autorest.Encode("path", operationID),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2019-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/networkTraces/current/operationresults/{operationId}", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// GetNetworkTraceOperationV2Sender sends the GetNetworkTraceOperationV2 request. The method will close the
// http.Response Body if it receives an error.
func (client AppsClient) GetNetworkTraceOperationV2Sender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// GetNetworkTraceOperationV2Responder handles the response to the GetNetworkTraceOperationV2 request. The method always
// closes the http.Response Body.
func (client AppsClient) GetNetworkTraceOperationV2Responder(resp *http.Response) (result ListNetworkTrace, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusAccepted),
		autorest.ByUnmarshallingJSON(&result.Value),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// GetNetworkTraces description for Gets a named operation for a network trace capturing (or deployment slot, if
// specified).
// Parameters:
// resourceGroupName - name of the resource group to which the resource belongs.
// name - name of the app.
// operationID - GUID of the operation.
func (client AppsClient) GetNetworkTraces(ctx context.Context, resourceGroupName string, name string, operationID string) (result ListNetworkTrace, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/AppsClient.GetNetworkTraces")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewError("web.AppsClient", "GetNetworkTraces", err.Error())
	}

	req, err := client.GetNetworkTracesPreparer(ctx, resourceGroupName, name, operationID)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "GetNetworkTraces", nil, "Failure preparing request")
		return
	}

	resp, err := client.GetNetworkTracesSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.AppsClient", "GetNetworkTraces", resp, "Failure sending request")
		return
	}

	result, err = client.GetNetworkTracesResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "GetNetworkTraces", resp, "Failure responding to request")
	}

	return
}

// GetNetworkTracesPreparer prepares the GetNetworkTraces request.
func (client AppsClient) GetNetworkTracesPreparer(ctx context.Context, resourceGroupName string, name string, operationID string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"operationId":       autorest.Encode("path", operationID),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2019-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/networkTrace/{operationId}", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// GetNetworkTracesSender sends the GetNetworkTraces request. The method will close the
// http.Response Body if it receives an error.
func (client AppsClient) GetNetworkTracesSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// GetNetworkTracesResponder handles the response to the GetNetworkTraces request. The method always
// closes the http.Response Body.
func (client AppsClient) GetNetworkTracesResponder(resp *http.Response) (result ListNetworkTrace, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result.Value),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// GetNetworkTracesSlot description for Gets a named operation for a network trace capturing (or deployment slot, if
// specified).
// Parameters:
// resourceGroupName - name of the resource group to which the resource belongs.
// name - name of the app.
// operationID - GUID of the operation.
// slot - name of the deployment slot. If a slot is not specified, the API will get an operation for the
// production slot.
func (client AppsClient) GetNetworkTracesSlot(ctx context.Context, resourceGroupName string, name string, operationID string, slot string) (result ListNetworkTrace, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/AppsClient.GetNetworkTracesSlot")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewError("web.AppsClient", "GetNetworkTracesSlot", err.Error())
	}

	req, err := client.GetNetworkTracesSlotPreparer(ctx, resourceGroupName, name, operationID, slot)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "GetNetworkTracesSlot", nil, "Failure preparing request")
		return
	}

	resp, err := client.GetNetworkTracesSlotSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.AppsClient", "GetNetworkTracesSlot", resp, "Failure sending request")
		return
	}

	result, err = client.GetNetworkTracesSlotResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "GetNetworkTracesSlot", resp, "Failure responding to request")
	}

	return
}

// GetNetworkTracesSlotPreparer prepares the GetNetworkTracesSlot request.
func (client AppsClient) GetNetworkTracesSlotPreparer(ctx context.Context, resourceGroupName string, name string, operationID string, slot string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"operationId":       autorest.Encode("path", operationID),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"slot":              autorest.Encode("path", slot),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2019-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/networkTrace/{operationId}", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// GetNetworkTracesSlotSender sends the GetNetworkTracesSlot request. The method will close the
// http.Response Body if it receives an error.
func (client AppsClient) GetNetworkTracesSlotSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// GetNetworkTracesSlotResponder handles the response to the GetNetworkTracesSlot request. The method always
// closes the http.Response Body.
func (client AppsClient) GetNetworkTracesSlotResponder(resp *http.Response) (result ListNetworkTrace, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result.Value),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// GetNetworkTracesSlotV2 description for Gets a named operation for a network trace capturing (or deployment slot, if
// specified).
// Parameters:
// resourceGroupName - name of the resource group to which the resource belongs.
// name - name of the app.
// operationID - GUID of the operation.
// slot - name of the deployment slot. If a slot is not specified, the API will get an operation for the
// production slot.
func (client AppsClient) GetNetworkTracesSlotV2(ctx context.Context, resourceGroupName string, name string, operationID string, slot string) (result ListNetworkTrace, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/AppsClient.GetNetworkTracesSlotV2")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewError("web.AppsClient", "GetNetworkTracesSlotV2", err.Error())
	}

	req, err := client.GetNetworkTracesSlotV2Preparer(ctx, resourceGroupName, name, operationID, slot)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "GetNetworkTracesSlotV2", nil, "Failure preparing request")
		return
	}

	resp, err := client.GetNetworkTracesSlotV2Sender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.AppsClient", "GetNetworkTracesSlotV2", resp, "Failure sending request")
		return
	}

	result, err = client.GetNetworkTracesSlotV2Responder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "GetNetworkTracesSlotV2", resp, "Failure responding to request")
	}

	return
}

// GetNetworkTracesSlotV2Preparer prepares the GetNetworkTracesSlotV2 request.
func (client AppsClient) GetNetworkTracesSlotV2Preparer(ctx context.Context, resourceGroupName string, name string, operationID string, slot string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"operationId":       autorest.Encode("path", operationID),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"slot":              autorest.Encode("path", slot),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2019-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/networkTraces/{operationId}", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// GetNetworkTracesSlotV2Sender sends the GetNetworkTracesSlotV2 request. The method will close the
// http.Response Body if it receives an error.
func (client AppsClient) GetNetworkTracesSlotV2Sender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// GetNetworkTracesSlotV2Responder handles the response to the GetNetworkTracesSlotV2 request. The method always
// closes the http.Response Body.
func (client AppsClient) GetNetworkTracesSlotV2Responder(resp *http.Response) (result ListNetworkTrace, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result.Value),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// GetNetworkTracesV2 description for Gets a named operation for a network trace capturing (or deployment slot, if
// specified).
// Parameters:
// resourceGroupName - name of the resource group to which the resource belongs.
// name - name of the app.
// operationID - GUID of the operation.
func (client AppsClient) GetNetworkTracesV2(ctx context.Context, resourceGroupName string, name string, operationID string) (result ListNetworkTrace, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/AppsClient.GetNetworkTracesV2")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewError("web.AppsClient", "GetNetworkTracesV2", err.Error())
	}

	req, err := client.GetNetworkTracesV2Preparer(ctx, resourceGroupName, name, operationID)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "GetNetworkTracesV2", nil, "Failure preparing request")
		return
	}

	resp, err := client.GetNetworkTracesV2Sender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.AppsClient", "GetNetworkTracesV2", resp, "Failure sending request")
		return
	}

	result, err = client.GetNetworkTracesV2Responder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "GetNetworkTracesV2", resp, "Failure responding to request")
	}

	return
}

// GetNetworkTracesV2Preparer prepares the GetNetworkTracesV2 request.
func (client AppsClient) GetNetworkTracesV2Preparer(ctx context.Context, resourceGroupName string, name string, operationID string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"operationId":       autorest.Encode("path", operationID),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2019-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/networkTraces/{operationId}", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// GetNetworkTracesV2Sender sends the GetNetworkTracesV2 request. The method will close the
// http.Response Body if it receives an error.
func (client AppsClient) GetNetworkTracesV2Sender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// GetNetworkTracesV2Responder handles the response to the GetNetworkTracesV2 request. The method always
// closes the http.Response Body.
func (client AppsClient) GetNetworkTracesV2Responder(resp *http.Response) (result ListNetworkTrace, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result.Value),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// GetPremierAddOn description for Gets a named add-on of an app.
// Parameters:
// resourceGroupName - name of the resource group to which the resource belongs.
// name - name of the app.
// premierAddOnName - add-on name.
func (client AppsClient) GetPremierAddOn(ctx context.Context, resourceGroupName string, name string, premierAddOnName string) (result PremierAddOn, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/AppsClient.GetPremierAddOn")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewError("web.AppsClient", "GetPremierAddOn", err.Error())
	}

	req, err := client.GetPremierAddOnPreparer(ctx, resourceGroupName, name, premierAddOnName)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "GetPremierAddOn", nil, "Failure preparing request")
		return
	}

	resp, err := client.GetPremierAddOnSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.AppsClient", "GetPremierAddOn", resp, "Failure sending request")
		return
	}

	result, err = client.GetPremierAddOnResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "GetPremierAddOn", resp, "Failure responding to request")
	}

	return
}

// GetPremierAddOnPreparer prepares the GetPremierAddOn request.
func (client AppsClient) GetPremierAddOnPreparer(ctx context.Context, resourceGroupName string, name string, premierAddOnName string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"premierAddOnName":  autorest.Encode("path", premierAddOnName),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2019-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/premieraddons/{premierAddOnName}", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// GetPremierAddOnSender sends the GetPremierAddOn request. The method will close the
// http.Response Body if it receives an error.
func (client AppsClient) GetPremierAddOnSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// GetPremierAddOnResponder handles the response to the GetPremierAddOn request. The method always
// closes the http.Response Body.
func (client AppsClient) GetPremierAddOnResponder(resp *http.Response) (result PremierAddOn, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// GetPremierAddOnSlot description for Gets a named add-on of an app.
// Parameters:
// resourceGroupName - name of the resource group to which the resource belongs.
// name - name of the app.
// premierAddOnName - add-on name.
// slot - name of the deployment slot. If a slot is not specified, the API will get the named add-on for the
// production slot.
func (client AppsClient) GetPremierAddOnSlot(ctx context.Context, resourceGroupName string, name string, premierAddOnName string, slot string) (result PremierAddOn, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/AppsClient.GetPremierAddOnSlot")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewError("web.AppsClient", "GetPremierAddOnSlot", err.Error())
	}

	req, err := client.GetPremierAddOnSlotPreparer(ctx, resourceGroupName, name, premierAddOnName, slot)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "GetPremierAddOnSlot", nil, "Failure preparing request")
		return
	}

	resp, err := client.GetPremierAddOnSlotSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.AppsClient", "GetPremierAddOnSlot", resp, "Failure sending request")
		return
	}

	result, err = client.GetPremierAddOnSlotResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "GetPremierAddOnSlot", resp, "Failure responding to request")
	}

	return
}

// GetPremierAddOnSlotPreparer prepares the GetPremierAddOnSlot request.
func (client AppsClient) GetPremierAddOnSlotPreparer(ctx context.Context, resourceGroupName string, name string, premierAddOnName string, slot string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"premierAddOnName":  autorest.Encode("path", premierAddOnName),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"slot":              autorest.Encode("path", slot),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2019-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/premieraddons/{premierAddOnName}", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// GetPremierAddOnSlotSender sends the GetPremierAddOnSlot request. The method will close the
// http.Response Body if it receives an error.
func (client AppsClient) GetPremierAddOnSlotSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// GetPremierAddOnSlotResponder handles the response to the GetPremierAddOnSlot request. The method always
// closes the http.Response Body.
func (client AppsClient) GetPremierAddOnSlotResponder(resp *http.Response) (result PremierAddOn, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// GetPrivateAccess description for Gets data around private site access enablement and authorized Virtual Networks
// that can access the site.
// Parameters:
// resourceGroupName - name of the resource group to which the resource belongs.
// name - the name of the web app.
func (client AppsClient) GetPrivateAccess(ctx context.Context, resourceGroupName string, name string) (result PrivateAccess, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/AppsClient.GetPrivateAccess")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewError("web.AppsClient", "GetPrivateAccess", err.Error())
	}

	req, err := client.GetPrivateAccessPreparer(ctx, resourceGroupName, name)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "GetPrivateAccess", nil, "Failure preparing request")
		return
	}

	resp, err := client.GetPrivateAccessSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.AppsClient", "GetPrivateAccess", resp, "Failure sending request")
		return
	}

	result, err = client.GetPrivateAccessResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "GetPrivateAccess", resp, "Failure responding to request")
	}

	return
}

// GetPrivateAccessPreparer prepares the GetPrivateAccess request.
func (client AppsClient) GetPrivateAccessPreparer(ctx context.Context, resourceGroupName string, name string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2019-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/privateAccess/virtualNetworks", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// GetPrivateAccessSender sends the GetPrivateAccess request. The method will close the
// http.Response Body if it receives an error.
func (client AppsClient) GetPrivateAccessSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// GetPrivateAccessResponder handles the response to the GetPrivateAccess request. The method always
// closes the http.Response Body.
func (client AppsClient) GetPrivateAccessResponder(resp *http.Response) (result PrivateAccess, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// GetPrivateAccessSlot description for Gets data around private site access enablement and authorized Virtual Networks
// that can access the site.
// Parameters:
// resourceGroupName - name of the resource group to which the resource belongs.
// name - the name of the web app.
// slot - the name of the slot for the web app.
func (client AppsClient) GetPrivateAccessSlot(ctx context.Context, resourceGroupName string, name string, slot string) (result PrivateAccess, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/AppsClient.GetPrivateAccessSlot")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewError("web.AppsClient", "GetPrivateAccessSlot", err.Error())
	}

	req, err := client.GetPrivateAccessSlotPreparer(ctx, resourceGroupName, name, slot)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "GetPrivateAccessSlot", nil, "Failure preparing request")
		return
	}

	resp, err := client.GetPrivateAccessSlotSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.AppsClient", "GetPrivateAccessSlot", resp, "Failure sending request")
		return
	}

	result, err = client.GetPrivateAccessSlotResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "GetPrivateAccessSlot", resp, "Failure responding to request")
	}

	return
}

// GetPrivateAccessSlotPreparer prepares the GetPrivateAccessSlot request.
func (client AppsClient) GetPrivateAccessSlotPreparer(ctx context.Context, resourceGroupName string, name string, slot string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"slot":              autorest.Encode("path", slot),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2019-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/privateAccess/virtualNetworks", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// GetPrivateAccessSlotSender sends the GetPrivateAccessSlot request. The method will close the
// http.Response Body if it receives an error.
func (client AppsClient) GetPrivateAccessSlotSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// GetPrivateAccessSlotResponder handles the response to the GetPrivateAccessSlot request. The method always
// closes the http.Response Body.
func (client AppsClient) GetPrivateAccessSlotResponder(resp *http.Response) (result PrivateAccess, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// GetProcess description for Get process information by its ID for a specific scaled-out instance in a web site.
// Parameters:
// resourceGroupName - name of the resource group to which the resource belongs.
// name - site name.
// processID - pID.
func (client AppsClient) GetProcess(ctx context.Context, resourceGroupName string, name string, processID string) (result ProcessInfo, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/AppsClient.GetProcess")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewError("web.AppsClient", "GetProcess", err.Error())
	}

	req, err := client.GetProcessPreparer(ctx, resourceGroupName, name, processID)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "GetProcess", nil, "Failure preparing request")
		return
	}

	resp, err := client.GetProcessSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.AppsClient", "GetProcess", resp, "Failure sending request")
		return
	}

	result, err = client.GetProcessResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "GetProcess", resp, "Failure responding to request")
	}

	return
}

// GetProcessPreparer prepares the GetProcess request.
func (client AppsClient) GetProcessPreparer(ctx context.Context, resourceGroupName string, name string, processID string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"processId":         autorest.Encode("path", processID),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2019-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/processes/{processId}", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// GetProcessSender sends the GetProcess request. The method will close the
// http.Response Body if it receives an error.
func (client AppsClient) GetProcessSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// GetProcessResponder handles the response to the GetProcess request. The method always
// closes the http.Response Body.
func (client AppsClient) GetProcessResponder(resp *http.Response) (result ProcessInfo, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusNotFound),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// GetProcessDump description for Get a memory dump of a process by its ID for a specific scaled-out instance in a web
// site.
// Parameters:
// resourceGroupName - name of the resource group to which the resource belongs.
// name - site name.
// processID - pID.
func (client AppsClient) GetProcessDump(ctx context.Context, resourceGroupName string, name string, processID string) (result ReadCloser, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/AppsClient.GetProcessDump")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewError("web.AppsClient", "GetProcessDump", err.Error())
	}

	req, err := client.GetProcessDumpPreparer(ctx, resourceGroupName, name, processID)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "GetProcessDump", nil, "Failure preparing request")
		return
	}

	resp, err := client.GetProcessDumpSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.AppsClient", "GetProcessDump", resp, "Failure sending request")
		return
	}

	result, err = client.GetProcessDumpResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "GetProcessDump", resp, "Failure responding to request")
	}

	return
}

// GetProcessDumpPreparer prepares the GetProcessDump request.
func (client AppsClient) GetProcessDumpPreparer(ctx context.Context, resourceGroupName string, name string, processID string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"processId":         autorest.Encode("path", processID),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2019-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/processes/{processId}/dump", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// GetProcessDumpSender sends the GetProcessDump request. The method will close the
// http.Response Body if it receives an error.
func (client AppsClient) GetProcessDumpSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// GetProcessDumpResponder handles the response to the GetProcessDump request. The method always
// closes the http.Response Body.
func (client AppsClient) GetProcessDumpResponder(resp *http.Response) (result ReadCloser, err error) {
	result.Value = &resp.Body
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusNotFound))
	result.Response = autorest.Response{Response: resp}
	return
}

// GetProcessDumpSlot description for Get a memory dump of a process by its ID for a specific scaled-out instance in a
// web site.
// Parameters:
// resourceGroupName - name of the resource group to which the resource belongs.
// name - site name.
// processID - pID.
// slot - name of the deployment slot. If a slot is not specified, the API returns deployments for the
// production slot.
func (client AppsClient) GetProcessDumpSlot(ctx context.Context, resourceGroupName string, name string, processID string, slot string) (result ReadCloser, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/AppsClient.GetProcessDumpSlot")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewError("web.AppsClient", "GetProcessDumpSlot", err.Error())
	}

	req, err := client.GetProcessDumpSlotPreparer(ctx, resourceGroupName, name, processID, slot)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "GetProcessDumpSlot", nil, "Failure preparing request")
		return
	}

	resp, err := client.GetProcessDumpSlotSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.AppsClient", "GetProcessDumpSlot", resp, "Failure sending request")
		return
	}

	result, err = client.GetProcessDumpSlotResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "GetProcessDumpSlot", resp, "Failure responding to request")
	}

	return
}

// GetProcessDumpSlotPreparer prepares the GetProcessDumpSlot request.
func (client AppsClient) GetProcessDumpSlotPreparer(ctx context.Context, resourceGroupName string, name string, processID string, slot string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"processId":         autorest.Encode("path", processID),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"slot":              autorest.Encode("path", slot),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2019-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/processes/{processId}/dump", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// GetProcessDumpSlotSender sends the GetProcessDumpSlot request. The method will close the
// http.Response Body if it receives an error.
func (client AppsClient) GetProcessDumpSlotSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// GetProcessDumpSlotResponder handles the response to the GetProcessDumpSlot request. The method always
// closes the http.Response Body.
func (client AppsClient) GetProcessDumpSlotResponder(resp *http.Response) (result ReadCloser, err error) {
	result.Value = &resp.Body
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusNotFound))
	result.Response = autorest.Response{Response: resp}
	return
}

// GetProcessModule description for Get process information by its ID for a specific scaled-out instance in a web site.
// Parameters:
// resourceGroupName - name of the resource group to which the resource belongs.
// name - site name.
// processID - pID.
// baseAddress - module base address.
func (client AppsClient) GetProcessModule(ctx context.Context, resourceGroupName string, name string, processID string, baseAddress string) (result ProcessModuleInfo, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/AppsClient.GetProcessModule")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewError("web.AppsClient", "GetProcessModule", err.Error())
	}

	req, err := client.GetProcessModulePreparer(ctx, resourceGroupName, name, processID, baseAddress)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "GetProcessModule", nil, "Failure preparing request")
		return
	}

	resp, err := client.GetProcessModuleSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.AppsClient", "GetProcessModule", resp, "Failure sending request")
		return
	}

	result, err = client.GetProcessModuleResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "GetProcessModule", resp, "Failure responding to request")
	}

	return
}

// GetProcessModulePreparer prepares the GetProcessModule request.
func (client AppsClient) GetProcessModulePreparer(ctx context.Context, resourceGroupName string, name string, processID string, baseAddress string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"baseAddress":       autorest.Encode("path", baseAddress),
		"name":              autorest.Encode("path", name),
		"processId":         autorest.Encode("path", processID),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2019-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/processes/{processId}/modules/{baseAddress}", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// GetProcessModuleSender sends the GetProcessModule request. The method will close the
// http.Response Body if it receives an error.
func (client AppsClient) GetProcessModuleSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// GetProcessModuleResponder handles the response to the GetProcessModule request. The method always
// closes the http.Response Body.
func (client AppsClient) GetProcessModuleResponder(resp *http.Response) (result ProcessModuleInfo, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusNotFound),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// GetProcessModuleSlot description for Get process information by its ID for a specific scaled-out instance in a web
// site.
// Parameters:
// resourceGroupName - name of the resource group to which the resource belongs.
// name - site name.
// processID - pID.
// baseAddress - module base address.
// slot - name of the deployment slot. If a slot is not specified, the API returns deployments for the
// production slot.
func (client AppsClient) GetProcessModuleSlot(ctx context.Context, resourceGroupName string, name string, processID string, baseAddress string, slot string) (result ProcessModuleInfo, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/AppsClient.GetProcessModuleSlot")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewError("web.AppsClient", "GetProcessModuleSlot", err.Error())
	}

	req, err := client.GetProcessModuleSlotPreparer(ctx, resourceGroupName, name, processID, baseAddress, slot)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "GetProcessModuleSlot", nil, "Failure preparing request")
		return
	}

	resp, err := client.GetProcessModuleSlotSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.AppsClient", "GetProcessModuleSlot", resp, "Failure sending request")
		return
	}

	result, err = client.GetProcessModuleSlotResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "GetProcessModuleSlot", resp, "Failure responding to request")
	}

	return
}

// GetProcessModuleSlotPreparer prepares the GetProcessModuleSlot request.
func (client AppsClient) GetProcessModuleSlotPreparer(ctx context.Context, resourceGroupName string, name string, processID string, baseAddress string, slot string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"baseAddress":       autorest.Encode("path", baseAddress),
		"name":              autorest.Encode("path", name),
		"processId":         autorest.Encode("path", processID),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"slot":              autorest.Encode("path", slot),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2019-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/processes/{processId}/modules/{baseAddress}", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// GetProcessModuleSlotSender sends the GetProcessModuleSlot request. The method will close the
// http.Response Body if it receives an error.
func (client AppsClient) GetProcessModuleSlotSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// GetProcessModuleSlotResponder handles the response to the GetProcessModuleSlot request. The method always
// closes the http.Response Body.
func (client AppsClient) GetProcessModuleSlotResponder(resp *http.Response) (result ProcessModuleInfo, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusNotFound),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// GetProcessSlot description for Get process information by its ID for a specific scaled-out instance in a web site.
// Parameters:
// resourceGroupName - name of the resource group to which the resource belongs.
// name - site name.
// processID - pID.
// slot - name of the deployment slot. If a slot is not specified, the API returns deployments for the
// production slot.
func (client AppsClient) GetProcessSlot(ctx context.Context, resourceGroupName string, name string, processID string, slot string) (result ProcessInfo, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/AppsClient.GetProcessSlot")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewError("web.AppsClient", "GetProcessSlot", err.Error())
	}

	req, err := client.GetProcessSlotPreparer(ctx, resourceGroupName, name, processID, slot)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "GetProcessSlot", nil, "Failure preparing request")
		return
	}

	resp, err := client.GetProcessSlotSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.AppsClient", "GetProcessSlot", resp, "Failure sending request")
		return
	}

	result, err = client.GetProcessSlotResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "GetProcessSlot", resp, "Failure responding to request")
	}

	return
}

// GetProcessSlotPreparer prepares the GetProcessSlot request.
func (client AppsClient) GetProcessSlotPreparer(ctx context.Context, resourceGroupName string, name string, processID string, slot string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"processId":         autorest.Encode("path", processID),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"slot":              autorest.Encode("path", slot),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2019-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/processes/{processId}", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// GetProcessSlotSender sends the GetProcessSlot request. The method will close the
// http.Response Body if it receives an error.
func (client AppsClient) GetProcessSlotSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// GetProcessSlotResponder handles the response to the GetProcessSlot request. The method always
// closes the http.Response Body.
func (client AppsClient) GetProcessSlotResponder(resp *http.Response) (result ProcessInfo, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusNotFound),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// GetPublicCertificate description for Get the named public certificate for an app (or deployment slot, if specified).
// Parameters:
// resourceGroupName - name of the resource group to which the resource belongs.
// name - name of the app.
// publicCertificateName - public certificate name.
func (client AppsClient) GetPublicCertificate(ctx context.Context, resourceGroupName string, name string, publicCertificateName string) (result PublicCertificate, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/AppsClient.GetPublicCertificate")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewError("web.AppsClient", "GetPublicCertificate", err.Error())
	}

	req, err := client.GetPublicCertificatePreparer(ctx, resourceGroupName, name, publicCertificateName)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "GetPublicCertificate", nil, "Failure preparing request")
		return
	}

	resp, err := client.GetPublicCertificateSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.AppsClient", "GetPublicCertificate", resp, "Failure sending request")
		return
	}

	result, err = client.GetPublicCertificateResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "GetPublicCertificate", resp, "Failure responding to request")
	}

	return
}

// GetPublicCertificatePreparer prepares the GetPublicCertificate request.
func (client AppsClient) GetPublicCertificatePreparer(ctx context.Context, resourceGroupName string, name string, publicCertificateName string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":                  autorest.Encode("path", name),
		"publicCertificateName": autorest.Encode("path", publicCertificateName),
		"resourceGroupName":     autorest.Encode("path", resourceGroupName),
		"subscriptionId":        autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2019-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/publicCertificates/{publicCertificateName}", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// GetPublicCertificateSender sends the GetPublicCertificate request. The method will close the
// http.Response Body if it receives an error.
func (client AppsClient) GetPublicCertificateSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// GetPublicCertificateResponder handles the response to the GetPublicCertificate request. The method always
// closes the http.Response Body.
func (client AppsClient) GetPublicCertificateResponder(resp *http.Response) (result PublicCertificate, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// GetPublicCertificateSlot description for Get the named public certificate for an app (or deployment slot, if
// specified).
// Parameters:
// resourceGroupName - name of the resource group to which the resource belongs.
// name - name of the app.
// slot - name of the deployment slot. If a slot is not specified, the API the named binding for the production
// slot.
// publicCertificateName - public certificate name.
func (client AppsClient) GetPublicCertificateSlot(ctx context.Context, resourceGroupName string, name string, slot string, publicCertificateName string) (result PublicCertificate, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/AppsClient.GetPublicCertificateSlot")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewError("web.AppsClient", "GetPublicCertificateSlot", err.Error())
	}

	req, err := client.GetPublicCertificateSlotPreparer(ctx, resourceGroupName, name, slot, publicCertificateName)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "GetPublicCertificateSlot", nil, "Failure preparing request")
		return
	}

	resp, err := client.GetPublicCertificateSlotSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.AppsClient", "GetPublicCertificateSlot", resp, "Failure sending request")
		return
	}

	result, err = client.GetPublicCertificateSlotResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "GetPublicCertificateSlot", resp, "Failure responding to request")
	}

	return
}

// GetPublicCertificateSlotPreparer prepares the GetPublicCertificateSlot request.
func (client AppsClient) GetPublicCertificateSlotPreparer(ctx context.Context, resourceGroupName string, name string, slot string, publicCertificateName string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":                  autorest.Encode("path", name),
		"publicCertificateName": autorest.Encode("path", publicCertificateName),
		"resourceGroupName":     autorest.Encode("path", resourceGroupName),
		"slot":                  autorest.Encode("path", slot),
		"subscriptionId":        autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2019-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/publicCertificates/{publicCertificateName}", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// GetPublicCertificateSlotSender sends the GetPublicCertificateSlot request. The method will close the
// http.Response Body if it receives an error.
func (client AppsClient) GetPublicCertificateSlotSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// GetPublicCertificateSlotResponder handles the response to the GetPublicCertificateSlot request. The method always
// closes the http.Response Body.
func (client AppsClient) GetPublicCertificateSlotResponder(resp *http.Response) (result PublicCertificate, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// GetRelayServiceConnection description for Gets a hybrid connection configuration by its name.
// Parameters:
// resourceGroupName - name of the resource group to which the resource belongs.
// name - name of the app.
// entityName - name of the hybrid connection.
func (client AppsClient) GetRelayServiceConnection(ctx context.Context, resourceGroupName string, name string, entityName string) (result RelayServiceConnectionEntity, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/AppsClient.GetRelayServiceConnection")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewError("web.AppsClient", "GetRelayServiceConnection", err.Error())
	}

	req, err := client.GetRelayServiceConnectionPreparer(ctx, resourceGroupName, name, entityName)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "GetRelayServiceConnection", nil, "Failure preparing request")
		return
	}

	resp, err := client.GetRelayServiceConnectionSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.AppsClient", "GetRelayServiceConnection", resp, "Failure sending request")
		return
	}

	result, err = client.GetRelayServiceConnectionResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "GetRelayServiceConnection", resp, "Failure responding to request")
	}

	return
}

// GetRelayServiceConnectionPreparer prepares the GetRelayServiceConnection request.
func (client AppsClient) GetRelayServiceConnectionPreparer(ctx context.Context, resourceGroupName string, name string, entityName string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"entityName":        autorest.Encode("path", entityName),
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2019-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/hybridconnection/{entityName}", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// GetRelayServiceConnectionSender sends the GetRelayServiceConnection request. The method will close the
// http.Response Body if it receives an error.
func (client AppsClient) GetRelayServiceConnectionSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// GetRelayServiceConnectionResponder handles the response to the GetRelayServiceConnection request. The method always
// closes the http.Response Body.
func (client AppsClient) GetRelayServiceConnectionResponder(resp *http.Response) (result RelayServiceConnectionEntity, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// GetRelayServiceConnectionSlot description for Gets a hybrid connection configuration by its name.
// Parameters:
// resourceGroupName - name of the resource group to which the resource belongs.
// name - name of the app.
// entityName - name of the hybrid connection.
// slot - name of the deployment slot. If a slot is not specified, the API will get a hybrid connection for the
// production slot.
func (client AppsClient) GetRelayServiceConnectionSlot(ctx context.Context, resourceGroupName string, name string, entityName string, slot string) (result RelayServiceConnectionEntity, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/AppsClient.GetRelayServiceConnectionSlot")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewError("web.AppsClient", "GetRelayServiceConnectionSlot", err.Error())
	}

	req, err := client.GetRelayServiceConnectionSlotPreparer(ctx, resourceGroupName, name, entityName, slot)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "GetRelayServiceConnectionSlot", nil, "Failure preparing request")
		return
	}

	resp, err := client.GetRelayServiceConnectionSlotSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.AppsClient", "GetRelayServiceConnectionSlot", resp, "Failure sending request")
		return
	}

	result, err = client.GetRelayServiceConnectionSlotResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "GetRelayServiceConnectionSlot", resp, "Failure responding to request")
	}

	return
}

// GetRelayServiceConnectionSlotPreparer prepares the GetRelayServiceConnectionSlot request.
func (client AppsClient) GetRelayServiceConnectionSlotPreparer(ctx context.Context, resourceGroupName string, name string, entityName string, slot string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"entityName":        autorest.Encode("path", entityName),
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"slot":              autorest.Encode("path", slot),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2019-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/hybridconnection/{entityName}", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// GetRelayServiceConnectionSlotSender sends the GetRelayServiceConnectionSlot request. The method will close the
// http.Response Body if it receives an error.
func (client AppsClient) GetRelayServiceConnectionSlotSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// GetRelayServiceConnectionSlotResponder handles the response to the GetRelayServiceConnectionSlot request. The method always
// closes the http.Response Body.
func (client AppsClient) GetRelayServiceConnectionSlotResponder(resp *http.Response) (result RelayServiceConnectionEntity, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// GetSiteExtension description for Get site extension information by its ID for a web site, or a deployment slot.
// Parameters:
// resourceGroupName - name of the resource group to which the resource belongs.
// name - site name.
// siteExtensionID - site extension name.
func (client AppsClient) GetSiteExtension(ctx context.Context, resourceGroupName string, name string, siteExtensionID string) (result SiteExtensionInfo, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/AppsClient.GetSiteExtension")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewError("web.AppsClient", "GetSiteExtension", err.Error())
	}

	req, err := client.GetSiteExtensionPreparer(ctx, resourceGroupName, name, siteExtensionID)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "GetSiteExtension", nil, "Failure preparing request")
		return
	}

	resp, err := client.GetSiteExtensionSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.AppsClient", "GetSiteExtension", resp, "Failure sending request")
		return
	}

	result, err = client.GetSiteExtensionResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "GetSiteExtension", resp, "Failure responding to request")
	}

	return
}

// GetSiteExtensionPreparer prepares the GetSiteExtension request.
func (client AppsClient) GetSiteExtensionPreparer(ctx context.Context, resourceGroupName string, name string, siteExtensionID string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"siteExtensionId":   autorest.Encode("path", siteExtensionID),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2019-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/siteextensions/{siteExtensionId}", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// GetSiteExtensionSender sends the GetSiteExtension request. The method will close the
// http.Response Body if it receives an error.
func (client AppsClient) GetSiteExtensionSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// GetSiteExtensionResponder handles the response to the GetSiteExtension request. The method always
// closes the http.Response Body.
func (client AppsClient) GetSiteExtensionResponder(resp *http.Response) (result SiteExtensionInfo, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusNotFound),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// GetSiteExtensionSlot description for Get site extension information by its ID for a web site, or a deployment slot.
// Parameters:
// resourceGroupName - name of the resource group to which the resource belongs.
// name - site name.
// siteExtensionID - site extension name.
// slot - name of the deployment slot. If a slot is not specified, the API uses the production slot.
func (client AppsClient) GetSiteExtensionSlot(ctx context.Context, resourceGroupName string, name string, siteExtensionID string, slot string) (result SiteExtensionInfo, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/AppsClient.GetSiteExtensionSlot")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewError("web.AppsClient", "GetSiteExtensionSlot", err.Error())
	}

	req, err := client.GetSiteExtensionSlotPreparer(ctx, resourceGroupName, name, siteExtensionID, slot)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "GetSiteExtensionSlot", nil, "Failure preparing request")
		return
	}

	resp, err := client.GetSiteExtensionSlotSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.AppsClient", "GetSiteExtensionSlot", resp, "Failure sending request")
		return
	}

	result, err = client.GetSiteExtensionSlotResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "GetSiteExtensionSlot", resp, "Failure responding to request")
	}

	return
}

// GetSiteExtensionSlotPreparer prepares the GetSiteExtensionSlot request.
func (client AppsClient) GetSiteExtensionSlotPreparer(ctx context.Context, resourceGroupName string, name string, siteExtensionID string, slot string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"siteExtensionId":   autorest.Encode("path", siteExtensionID),
		"slot":              autorest.Encode("path", slot),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2019-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/siteextensions/{siteExtensionId}", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// GetSiteExtensionSlotSender sends the GetSiteExtensionSlot request. The method will close the
// http.Response Body if it receives an error.
func (client AppsClient) GetSiteExtensionSlotSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// GetSiteExtensionSlotResponder handles the response to the GetSiteExtensionSlot request. The method always
// closes the http.Response Body.
func (client AppsClient) GetSiteExtensionSlotResponder(resp *http.Response) (result SiteExtensionInfo, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusNotFound),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// GetSitePhpErrorLogFlag description for Gets web app's event logs.
// Parameters:
// resourceGroupName - name of the resource group to which the resource belongs.
// name - name of web app.
func (client AppsClient) GetSitePhpErrorLogFlag(ctx context.Context, resourceGroupName string, name string) (result SitePhpErrorLogFlag, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/AppsClient.GetSitePhpErrorLogFlag")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewError("web.AppsClient", "GetSitePhpErrorLogFlag", err.Error())
	}

	req, err := client.GetSitePhpErrorLogFlagPreparer(ctx, resourceGroupName, name)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "GetSitePhpErrorLogFlag", nil, "Failure preparing request")
		return
	}

	resp, err := client.GetSitePhpErrorLogFlagSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.AppsClient", "GetSitePhpErrorLogFlag", resp, "Failure sending request")
		return
	}

	result, err = client.GetSitePhpErrorLogFlagResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "GetSitePhpErrorLogFlag", resp, "Failure responding to request")
	}

	return
}

// GetSitePhpErrorLogFlagPreparer prepares the GetSitePhpErrorLogFlag request.
func (client AppsClient) GetSitePhpErrorLogFlagPreparer(ctx context.Context, resourceGroupName string, name string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2019-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/phplogging", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// GetSitePhpErrorLogFlagSender sends the GetSitePhpErrorLogFlag request. The method will close the
// http.Response Body if it receives an error.
func (client AppsClient) GetSitePhpErrorLogFlagSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// GetSitePhpErrorLogFlagResponder handles the response to the GetSitePhpErrorLogFlag request. The method always
// closes the http.Response Body.
func (client AppsClient) GetSitePhpErrorLogFlagResponder(resp *http.Response) (result SitePhpErrorLogFlag, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// GetSitePhpErrorLogFlagSlot description for Gets web app's event logs.
// Parameters:
// resourceGroupName - name of the resource group to which the resource belongs.
// name - name of web app.
// slot - name of web app slot. If not specified then will default to production slot.
func (client AppsClient) GetSitePhpErrorLogFlagSlot(ctx context.Context, resourceGroupName string, name string, slot string) (result SitePhpErrorLogFlag, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/AppsClient.GetSitePhpErrorLogFlagSlot")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewError("web.AppsClient", "GetSitePhpErrorLogFlagSlot", err.Error())
	}

	req, err := client.GetSitePhpErrorLogFlagSlotPreparer(ctx, resourceGroupName, name, slot)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "GetSitePhpErrorLogFlagSlot", nil, "Failure preparing request")
		return
	}

	resp, err := client.GetSitePhpErrorLogFlagSlotSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.AppsClient", "GetSitePhpErrorLogFlagSlot", resp, "Failure sending request")
		return
	}

	result, err = client.GetSitePhpErrorLogFlagSlotResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "GetSitePhpErrorLogFlagSlot", resp, "Failure responding to request")
	}

	return
}

// GetSitePhpErrorLogFlagSlotPreparer prepares the GetSitePhpErrorLogFlagSlot request.
func (client AppsClient) GetSitePhpErrorLogFlagSlotPreparer(ctx context.Context, resourceGroupName string, name string, slot string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"slot":              autorest.Encode("path", slot),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2019-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/phplogging", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// GetSitePhpErrorLogFlagSlotSender sends the GetSitePhpErrorLogFlagSlot request. The method will close the
// http.Response Body if it receives an error.
func (client AppsClient) GetSitePhpErrorLogFlagSlotSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// GetSitePhpErrorLogFlagSlotResponder handles the response to the GetSitePhpErrorLogFlagSlot request. The method always
// closes the http.Response Body.
func (client AppsClient) GetSitePhpErrorLogFlagSlotResponder(resp *http.Response) (result SitePhpErrorLogFlag, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// GetSlot description for Gets the details of a web, mobile, or API app.
// Parameters:
// resourceGroupName - name of the resource group to which the resource belongs.
// name - name of the app.
// slot - name of the deployment slot. By default, this API returns the production slot.
func (client AppsClient) GetSlot(ctx context.Context, resourceGroupName string, name string, slot string) (result Site, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/AppsClient.GetSlot")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewError("web.AppsClient", "GetSlot", err.Error())
	}

	req, err := client.GetSlotPreparer(ctx, resourceGroupName, name, slot)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "GetSlot", nil, "Failure preparing request")
		return
	}

	resp, err := client.GetSlotSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.AppsClient", "GetSlot", resp, "Failure sending request")
		return
	}

	result, err = client.GetSlotResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "GetSlot", resp, "Failure responding to request")
	}

	return
}

// GetSlotPreparer prepares the GetSlot request.
func (client AppsClient) GetSlotPreparer(ctx context.Context, resourceGroupName string, name string, slot string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"slot":              autorest.Encode("path", slot),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2019-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// GetSlotSender sends the GetSlot request. The method will close the
// http.Response Body if it receives an error.
func (client AppsClient) GetSlotSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// GetSlotResponder handles the response to the GetSlot request. The method always
// closes the http.Response Body.
func (client AppsClient) GetSlotResponder(resp *http.Response) (result Site, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusNotFound),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// GetSourceControl description for Gets the source control configuration of an app.
// Parameters:
// resourceGroupName - name of the resource group to which the resource belongs.
// name - name of the app.
func (client AppsClient) GetSourceControl(ctx context.Context, resourceGroupName string, name string) (result SiteSourceControl, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/AppsClient.GetSourceControl")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewError("web.AppsClient", "GetSourceControl", err.Error())
	}

	req, err := client.GetSourceControlPreparer(ctx, resourceGroupName, name)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "GetSourceControl", nil, "Failure preparing request")
		return
	}

	resp, err := client.GetSourceControlSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.AppsClient", "GetSourceControl", resp, "Failure sending request")
		return
	}

	result, err = client.GetSourceControlResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "GetSourceControl", resp, "Failure responding to request")
	}

	return
}

// GetSourceControlPreparer prepares the GetSourceControl request.
func (client AppsClient) GetSourceControlPreparer(ctx context.Context, resourceGroupName string, name string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2019-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/sourcecontrols/web", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// GetSourceControlSender sends the GetSourceControl request. The method will close the
// http.Response Body if it receives an error.
func (client AppsClient) GetSourceControlSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// GetSourceControlResponder handles the response to the GetSourceControl request. The method always
// closes the http.Response Body.
func (client AppsClient) GetSourceControlResponder(resp *http.Response) (result SiteSourceControl, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusCreated, http.StatusAccepted),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// GetSourceControlSlot description for Gets the source control configuration of an app.
// Parameters:
// resourceGroupName - name of the resource group to which the resource belongs.
// name - name of the app.
// slot - name of the deployment slot. If a slot is not specified, the API will get the source control
// configuration for the production slot.
func (client AppsClient) GetSourceControlSlot(ctx context.Context, resourceGroupName string, name string, slot string) (result SiteSourceControl, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/AppsClient.GetSourceControlSlot")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewError("web.AppsClient", "GetSourceControlSlot", err.Error())
	}

	req, err := client.GetSourceControlSlotPreparer(ctx, resourceGroupName, name, slot)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "GetSourceControlSlot", nil, "Failure preparing request")
		return
	}

	resp, err := client.GetSourceControlSlotSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.AppsClient", "GetSourceControlSlot", resp, "Failure sending request")
		return
	}

	result, err = client.GetSourceControlSlotResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "GetSourceControlSlot", resp, "Failure responding to request")
	}

	return
}

// GetSourceControlSlotPreparer prepares the GetSourceControlSlot request.
func (client AppsClient) GetSourceControlSlotPreparer(ctx context.Context, resourceGroupName string, name string, slot string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"slot":              autorest.Encode("path", slot),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2019-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/sourcecontrols/web", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// GetSourceControlSlotSender sends the GetSourceControlSlot request. The method will close the
// http.Response Body if it receives an error.
func (client AppsClient) GetSourceControlSlotSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// GetSourceControlSlotResponder handles the response to the GetSourceControlSlot request. The method always
// closes the http.Response Body.
func (client AppsClient) GetSourceControlSlotResponder(resp *http.Response) (result SiteSourceControl, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusCreated, http.StatusAccepted),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// GetSwiftVirtualNetworkConnection description for Gets a Swift Virtual Network connection.
// Parameters:
// resourceGroupName - name of the resource group to which the resource belongs.
// name - name of the app.
func (client AppsClient) GetSwiftVirtualNetworkConnection(ctx context.Context, resourceGroupName string, name string) (result SwiftVirtualNetwork, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/AppsClient.GetSwiftVirtualNetworkConnection")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewError("web.AppsClient", "GetSwiftVirtualNetworkConnection", err.Error())
	}

	req, err := client.GetSwiftVirtualNetworkConnectionPreparer(ctx, resourceGroupName, name)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "GetSwiftVirtualNetworkConnection", nil, "Failure preparing request")
		return
	}

	resp, err := client.GetSwiftVirtualNetworkConnectionSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.AppsClient", "GetSwiftVirtualNetworkConnection", resp, "Failure sending request")
		return
	}

	result, err = client.GetSwiftVirtualNetworkConnectionResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "GetSwiftVirtualNetworkConnection", resp, "Failure responding to request")
	}

	return
}

// GetSwiftVirtualNetworkConnectionPreparer prepares the GetSwiftVirtualNetworkConnection request.
func (client AppsClient) GetSwiftVirtualNetworkConnectionPreparer(ctx context.Context, resourceGroupName string, name string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2019-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/networkConfig/virtualNetwork", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// GetSwiftVirtualNetworkConnectionSender sends the GetSwiftVirtualNetworkConnection request. The method will close the
// http.Response Body if it receives an error.
func (client AppsClient) GetSwiftVirtualNetworkConnectionSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// GetSwiftVirtualNetworkConnectionResponder handles the response to the GetSwiftVirtualNetworkConnection request. The method always
// closes the http.Response Body.
func (client AppsClient) GetSwiftVirtualNetworkConnectionResponder(resp *http.Response) (result SwiftVirtualNetwork, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// GetSwiftVirtualNetworkConnectionSlot description for Gets a Swift Virtual Network connection.
// Parameters:
// resourceGroupName - name of the resource group to which the resource belongs.
// name - name of the app.
// slot - name of the deployment slot. If a slot is not specified, the API will get a gateway for the
// production slot's Virtual Network.
func (client AppsClient) GetSwiftVirtualNetworkConnectionSlot(ctx context.Context, resourceGroupName string, name string, slot string) (result SwiftVirtualNetwork, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/AppsClient.GetSwiftVirtualNetworkConnectionSlot")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewError("web.AppsClient", "GetSwiftVirtualNetworkConnectionSlot", err.Error())
	}

	req, err := client.GetSwiftVirtualNetworkConnectionSlotPreparer(ctx, resourceGroupName, name, slot)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "GetSwiftVirtualNetworkConnectionSlot", nil, "Failure preparing request")
		return
	}

	resp, err := client.GetSwiftVirtualNetworkConnectionSlotSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.AppsClient", "GetSwiftVirtualNetworkConnectionSlot", resp, "Failure sending request")
		return
	}

	result, err = client.GetSwiftVirtualNetworkConnectionSlotResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "GetSwiftVirtualNetworkConnectionSlot", resp, "Failure responding to request")
	}

	return
}

// GetSwiftVirtualNetworkConnectionSlotPreparer prepares the GetSwiftVirtualNetworkConnectionSlot request.
func (client AppsClient) GetSwiftVirtualNetworkConnectionSlotPreparer(ctx context.Context, resourceGroupName string, name string, slot string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"slot":              autorest.Encode("path", slot),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2019-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/networkConfig/virtualNetwork", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// GetSwiftVirtualNetworkConnectionSlotSender sends the GetSwiftVirtualNetworkConnectionSlot request. The method will close the
// http.Response Body if it receives an error.
func (client AppsClient) GetSwiftVirtualNetworkConnectionSlotSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// GetSwiftVirtualNetworkConnectionSlotResponder handles the response to the GetSwiftVirtualNetworkConnectionSlot request. The method always
// closes the http.Response Body.
func (client AppsClient) GetSwiftVirtualNetworkConnectionSlotResponder(resp *http.Response) (result SwiftVirtualNetwork, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// GetTriggeredWebJob description for Gets a triggered web job by its ID for an app, or a deployment slot.
// Parameters:
// resourceGroupName - name of the resource group to which the resource belongs.
// name - site name.
// webJobName - name of Web Job.
func (client AppsClient) GetTriggeredWebJob(ctx context.Context, resourceGroupName string, name string, webJobName string) (result TriggeredWebJob, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/AppsClient.GetTriggeredWebJob")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewError("web.AppsClient", "GetTriggeredWebJob", err.Error())
	}

	req, err := client.GetTriggeredWebJobPreparer(ctx, resourceGroupName, name, webJobName)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "GetTriggeredWebJob", nil, "Failure preparing request")
		return
	}

	resp, err := client.GetTriggeredWebJobSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.AppsClient", "GetTriggeredWebJob", resp, "Failure sending request")
		return
	}

	result, err = client.GetTriggeredWebJobResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "GetTriggeredWebJob", resp, "Failure responding to request")
	}

	return
}

// GetTriggeredWebJobPreparer prepares the GetTriggeredWebJob request.
func (client AppsClient) GetTriggeredWebJobPreparer(ctx context.Context, resourceGroupName string, name string, webJobName string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
		"webJobName":        autorest.Encode("path", webJobName),
	}

	const APIVersion = "2019-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/triggeredwebjobs/{webJobName}", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// GetTriggeredWebJobSender sends the GetTriggeredWebJob request. The method will close the
// http.Response Body if it receives an error.
func (client AppsClient) GetTriggeredWebJobSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// GetTriggeredWebJobResponder handles the response to the GetTriggeredWebJob request. The method always
// closes the http.Response Body.
func (client AppsClient) GetTriggeredWebJobResponder(resp *http.Response) (result TriggeredWebJob, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusNotFound),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// GetTriggeredWebJobHistory description for Gets a triggered web job's history by its ID for an app, , or a deployment
// slot.
// Parameters:
// resourceGroupName - name of the resource group to which the resource belongs.
// name - site name.
// webJobName - name of Web Job.
// ID - history ID.
func (client AppsClient) GetTriggeredWebJobHistory(ctx context.Context, resourceGroupName string, name string, webJobName string, ID string) (result TriggeredJobHistory, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/AppsClient.GetTriggeredWebJobHistory")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewError("web.AppsClient", "GetTriggeredWebJobHistory", err.Error())
	}

	req, err := client.GetTriggeredWebJobHistoryPreparer(ctx, resourceGroupName, name, webJobName, ID)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "GetTriggeredWebJobHistory", nil, "Failure preparing request")
		return
	}

	resp, err := client.GetTriggeredWebJobHistorySender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.AppsClient", "GetTriggeredWebJobHistory", resp, "Failure sending request")
		return
	}

	result, err = client.GetTriggeredWebJobHistoryResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "GetTriggeredWebJobHistory", resp, "Failure responding to request")
	}

	return
}

// GetTriggeredWebJobHistoryPreparer prepares the GetTriggeredWebJobHistory request.
func (client AppsClient) GetTriggeredWebJobHistoryPreparer(ctx context.Context, resourceGroupName string, name string, webJobName string, ID string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"id":                autorest.Encode("path", ID),
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
		"webJobName":        autorest.Encode("path", webJobName),
	}

	const APIVersion = "2019-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/triggeredwebjobs/{webJobName}/history/{id}", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// GetTriggeredWebJobHistorySender sends the GetTriggeredWebJobHistory request. The method will close the
// http.Response Body if it receives an error.
func (client AppsClient) GetTriggeredWebJobHistorySender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// GetTriggeredWebJobHistoryResponder handles the response to the GetTriggeredWebJobHistory request. The method always
// closes the http.Response Body.
func (client AppsClient) GetTriggeredWebJobHistoryResponder(resp *http.Response) (result TriggeredJobHistory, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusNotFound),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// GetTriggeredWebJobHistorySlot description for Gets a triggered web job's history by its ID for an app, , or a
// deployment slot.
// Parameters:
// resourceGroupName - name of the resource group to which the resource belongs.
// name - site name.
// webJobName - name of Web Job.
// ID - history ID.
// slot - name of the deployment slot. If a slot is not specified, the API uses the production slot.
func (client AppsClient) GetTriggeredWebJobHistorySlot(ctx context.Context, resourceGroupName string, name string, webJobName string, ID string, slot string) (result TriggeredJobHistory, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/AppsClient.GetTriggeredWebJobHistorySlot")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewError("web.AppsClient", "GetTriggeredWebJobHistorySlot", err.Error())
	}

	req, err := client.GetTriggeredWebJobHistorySlotPreparer(ctx, resourceGroupName, name, webJobName, ID, slot)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "GetTriggeredWebJobHistorySlot", nil, "Failure preparing request")
		return
	}

	resp, err := client.GetTriggeredWebJobHistorySlotSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.AppsClient", "GetTriggeredWebJobHistorySlot", resp, "Failure sending request")
		return
	}

	result, err = client.GetTriggeredWebJobHistorySlotResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "GetTriggeredWebJobHistorySlot", resp, "Failure responding to request")
	}

	return
}

// GetTriggeredWebJobHistorySlotPreparer prepares the GetTriggeredWebJobHistorySlot request.
func (client AppsClient) GetTriggeredWebJobHistorySlotPreparer(ctx context.Context, resourceGroupName string, name string, webJobName string, ID string, slot string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"id":                autorest.Encode("path", ID),
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"slot":              autorest.Encode("path", slot),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
		"webJobName":        autorest.Encode("path", webJobName),
	}

	const APIVersion = "2019-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/triggeredwebjobs/{webJobName}/history/{id}", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// GetTriggeredWebJobHistorySlotSender sends the GetTriggeredWebJobHistorySlot request. The method will close the
// http.Response Body if it receives an error.
func (client AppsClient) GetTriggeredWebJobHistorySlotSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// GetTriggeredWebJobHistorySlotResponder handles the response to the GetTriggeredWebJobHistorySlot request. The method always
// closes the http.Response Body.
func (client AppsClient) GetTriggeredWebJobHistorySlotResponder(resp *http.Response) (result TriggeredJobHistory, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusNotFound),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// GetTriggeredWebJobSlot description for Gets a triggered web job by its ID for an app, or a deployment slot.
// Parameters:
// resourceGroupName - name of the resource group to which the resource belongs.
// name - site name.
// webJobName - name of Web Job.
// slot - name of the deployment slot. If a slot is not specified, the API uses the production slot.
func (client AppsClient) GetTriggeredWebJobSlot(ctx context.Context, resourceGroupName string, name string, webJobName string, slot string) (result TriggeredWebJob, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/AppsClient.GetTriggeredWebJobSlot")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewError("web.AppsClient", "GetTriggeredWebJobSlot", err.Error())
	}

	req, err := client.GetTriggeredWebJobSlotPreparer(ctx, resourceGroupName, name, webJobName, slot)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "GetTriggeredWebJobSlot", nil, "Failure preparing request")
		return
	}

	resp, err := client.GetTriggeredWebJobSlotSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.AppsClient", "GetTriggeredWebJobSlot", resp, "Failure sending request")
		return
	}

	result, err = client.GetTriggeredWebJobSlotResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "GetTriggeredWebJobSlot", resp, "Failure responding to request")
	}

	return
}

// GetTriggeredWebJobSlotPreparer prepares the GetTriggeredWebJobSlot request.
func (client AppsClient) GetTriggeredWebJobSlotPreparer(ctx context.Context, resourceGroupName string, name string, webJobName string, slot string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"slot":              autorest.Encode("path", slot),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
		"webJobName":        autorest.Encode("path", webJobName),
	}

	const APIVersion = "2019-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/triggeredwebjobs/{webJobName}", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// GetTriggeredWebJobSlotSender sends the GetTriggeredWebJobSlot request. The method will close the
// http.Response Body if it receives an error.
func (client AppsClient) GetTriggeredWebJobSlotSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// GetTriggeredWebJobSlotResponder handles the response to the GetTriggeredWebJobSlot request. The method always
// closes the http.Response Body.
func (client AppsClient) GetTriggeredWebJobSlotResponder(resp *http.Response) (result TriggeredWebJob, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusNotFound),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// GetVnetConnection description for Gets a virtual network the app (or deployment slot) is connected to by name.
// Parameters:
// resourceGroupName - name of the resource group to which the resource belongs.
// name - name of the app.
// vnetName - name of the virtual network.
func (client AppsClient) GetVnetConnection(ctx context.Context, resourceGroupName string, name string, vnetName string) (result VnetInfo, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/AppsClient.GetVnetConnection")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewError("web.AppsClient", "GetVnetConnection", err.Error())
	}

	req, err := client.GetVnetConnectionPreparer(ctx, resourceGroupName, name, vnetName)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "GetVnetConnection", nil, "Failure preparing request")
		return
	}

	resp, err := client.GetVnetConnectionSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.AppsClient", "GetVnetConnection", resp, "Failure sending request")
		return
	}

	result, err = client.GetVnetConnectionResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "GetVnetConnection", resp, "Failure responding to request")
	}

	return
}

// GetVnetConnectionPreparer prepares the GetVnetConnection request.
func (client AppsClient) GetVnetConnectionPreparer(ctx context.Context, resourceGroupName string, name string, vnetName string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
		"vnetName":          autorest.Encode("path", vnetName),
	}

	const APIVersion = "2019-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/virtualNetworkConnections/{vnetName}", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// GetVnetConnectionSender sends the GetVnetConnection request. The method will close the
// http.Response Body if it receives an error.
func (client AppsClient) GetVnetConnectionSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// GetVnetConnectionResponder handles the response to the GetVnetConnection request. The method always
// closes the http.Response Body.
func (client AppsClient) GetVnetConnectionResponder(resp *http.Response) (result VnetInfo, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// GetVnetConnectionGateway description for Gets an app's Virtual Network gateway.
// Parameters:
// resourceGroupName - name of the resource group to which the resource belongs.
// name - name of the app.
// vnetName - name of the Virtual Network.
// gatewayName - name of the gateway. Currently, the only supported string is "primary".
func (client AppsClient) GetVnetConnectionGateway(ctx context.Context, resourceGroupName string, name string, vnetName string, gatewayName string) (result VnetGateway, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/AppsClient.GetVnetConnectionGateway")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewError("web.AppsClient", "GetVnetConnectionGateway", err.Error())
	}

	req, err := client.GetVnetConnectionGatewayPreparer(ctx, resourceGroupName, name, vnetName, gatewayName)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "GetVnetConnectionGateway", nil, "Failure preparing request")
		return
	}

	resp, err := client.GetVnetConnectionGatewaySender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.AppsClient", "GetVnetConnectionGateway", resp, "Failure sending request")
		return
	}

	result, err = client.GetVnetConnectionGatewayResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "GetVnetConnectionGateway", resp, "Failure responding to request")
	}

	return
}

// GetVnetConnectionGatewayPreparer prepares the GetVnetConnectionGateway request.
func (client AppsClient) GetVnetConnectionGatewayPreparer(ctx context.Context, resourceGroupName string, name string, vnetName string, gatewayName string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"gatewayName":       autorest.Encode("path", gatewayName),
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
		"vnetName":          autorest.Encode("path", vnetName),
	}

	const APIVersion = "2019-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/virtualNetworkConnections/{vnetName}/gateways/{gatewayName}", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// GetVnetConnectionGatewaySender sends the GetVnetConnectionGateway request. The method will close the
// http.Response Body if it receives an error.
func (client AppsClient) GetVnetConnectionGatewaySender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// GetVnetConnectionGatewayResponder handles the response to the GetVnetConnectionGateway request. The method always
// closes the http.Response Body.
func (client AppsClient) GetVnetConnectionGatewayResponder(resp *http.Response) (result VnetGateway, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusNotFound),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// GetVnetConnectionGatewaySlot description for Gets an app's Virtual Network gateway.
// Parameters:
// resourceGroupName - name of the resource group to which the resource belongs.
// name - name of the app.
// vnetName - name of the Virtual Network.
// gatewayName - name of the gateway. Currently, the only supported string is "primary".
// slot - name of the deployment slot. If a slot is not specified, the API will get a gateway for the
// production slot's Virtual Network.
func (client AppsClient) GetVnetConnectionGatewaySlot(ctx context.Context, resourceGroupName string, name string, vnetName string, gatewayName string, slot string) (result VnetGateway, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/AppsClient.GetVnetConnectionGatewaySlot")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewError("web.AppsClient", "GetVnetConnectionGatewaySlot", err.Error())
	}

	req, err := client.GetVnetConnectionGatewaySlotPreparer(ctx, resourceGroupName, name, vnetName, gatewayName, slot)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "GetVnetConnectionGatewaySlot", nil, "Failure preparing request")
		return
	}

	resp, err := client.GetVnetConnectionGatewaySlotSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.AppsClient", "GetVnetConnectionGatewaySlot", resp, "Failure sending request")
		return
	}

	result, err = client.GetVnetConnectionGatewaySlotResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "GetVnetConnectionGatewaySlot", resp, "Failure responding to request")
	}

	return
}

// GetVnetConnectionGatewaySlotPreparer prepares the GetVnetConnectionGatewaySlot request.
func (client AppsClient) GetVnetConnectionGatewaySlotPreparer(ctx context.Context, resourceGroupName string, name string, vnetName string, gatewayName string, slot string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"gatewayName":       autorest.Encode("path", gatewayName),
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"slot":              autorest.Encode("path", slot),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
		"vnetName":          autorest.Encode("path", vnetName),
	}

	const APIVersion = "2019-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/virtualNetworkConnections/{vnetName}/gateways/{gatewayName}", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// GetVnetConnectionGatewaySlotSender sends the GetVnetConnectionGatewaySlot request. The method will close the
// http.Response Body if it receives an error.
func (client AppsClient) GetVnetConnectionGatewaySlotSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// GetVnetConnectionGatewaySlotResponder handles the response to the GetVnetConnectionGatewaySlot request. The method always
// closes the http.Response Body.
func (client AppsClient) GetVnetConnectionGatewaySlotResponder(resp *http.Response) (result VnetGateway, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusNotFound),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// GetVnetConnectionSlot description for Gets a virtual network the app (or deployment slot) is connected to by name.
// Parameters:
// resourceGroupName - name of the resource group to which the resource belongs.
// name - name of the app.
// vnetName - name of the virtual network.
// slot - name of the deployment slot. If a slot is not specified, the API will get the named virtual network
// for the production slot.
func (client AppsClient) GetVnetConnectionSlot(ctx context.Context, resourceGroupName string, name string, vnetName string, slot string) (result VnetInfo, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/AppsClient.GetVnetConnectionSlot")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewError("web.AppsClient", "GetVnetConnectionSlot", err.Error())
	}

	req, err := client.GetVnetConnectionSlotPreparer(ctx, resourceGroupName, name, vnetName, slot)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "GetVnetConnectionSlot", nil, "Failure preparing request")
		return
	}

	resp, err := client.GetVnetConnectionSlotSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.AppsClient", "GetVnetConnectionSlot", resp, "Failure sending request")
		return
	}

	result, err = client.GetVnetConnectionSlotResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "GetVnetConnectionSlot", resp, "Failure responding to request")
	}

	return
}

// GetVnetConnectionSlotPreparer prepares the GetVnetConnectionSlot request.
func (client AppsClient) GetVnetConnectionSlotPreparer(ctx context.Context, resourceGroupName string, name string, vnetName string, slot string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"slot":              autorest.Encode("path", slot),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
		"vnetName":          autorest.Encode("path", vnetName),
	}

	const APIVersion = "2019-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/virtualNetworkConnections/{vnetName}", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// GetVnetConnectionSlotSender sends the GetVnetConnectionSlot request. The method will close the
// http.Response Body if it receives an error.
func (client AppsClient) GetVnetConnectionSlotSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// GetVnetConnectionSlotResponder handles the response to the GetVnetConnectionSlot request. The method always
// closes the http.Response Body.
func (client AppsClient) GetVnetConnectionSlotResponder(resp *http.Response) (result VnetInfo, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// GetWebJob description for Get webjob information for an app, or a deployment slot.
// Parameters:
// resourceGroupName - name of the resource group to which the resource belongs.
// name - site name.
// webJobName - name of the web job.
func (client AppsClient) GetWebJob(ctx context.Context, resourceGroupName string, name string, webJobName string) (result Job, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/AppsClient.GetWebJob")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewError("web.AppsClient", "GetWebJob", err.Error())
	}

	req, err := client.GetWebJobPreparer(ctx, resourceGroupName, name, webJobName)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "GetWebJob", nil, "Failure preparing request")
		return
	}

	resp, err := client.GetWebJobSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.AppsClient", "GetWebJob", resp, "Failure sending request")
		return
	}

	result, err = client.GetWebJobResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "GetWebJob", resp, "Failure responding to request")
	}

	return
}

// GetWebJobPreparer prepares the GetWebJob request.
func (client AppsClient) GetWebJobPreparer(ctx context.Context, resourceGroupName string, name string, webJobName string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
		"webJobName":        autorest.Encode("path", webJobName),
	}

	const APIVersion = "2019-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/webjobs/{webJobName}", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// GetWebJobSender sends the GetWebJob request. The method will close the
// http.Response Body if it receives an error.
func (client AppsClient) GetWebJobSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// GetWebJobResponder handles the response to the GetWebJob request. The method always
// closes the http.Response Body.
func (client AppsClient) GetWebJobResponder(resp *http.Response) (result Job, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// GetWebJobSlot description for Get webjob information for an app, or a deployment slot.
// Parameters:
// resourceGroupName - name of the resource group to which the resource belongs.
// name - site name.
// webJobName - name of the web job.
// slot - name of the deployment slot. If a slot is not specified, the API returns deployments for the
// production slot.
func (client AppsClient) GetWebJobSlot(ctx context.Context, resourceGroupName string, name string, webJobName string, slot string) (result Job, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/AppsClient.GetWebJobSlot")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewError("web.AppsClient", "GetWebJobSlot", err.Error())
	}

	req, err := client.GetWebJobSlotPreparer(ctx, resourceGroupName, name, webJobName, slot)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "GetWebJobSlot", nil, "Failure preparing request")
		return
	}

	resp, err := client.GetWebJobSlotSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.AppsClient", "GetWebJobSlot", resp, "Failure sending request")
		return
	}

	result, err = client.GetWebJobSlotResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "GetWebJobSlot", resp, "Failure responding to request")
	}

	return
}

// GetWebJobSlotPreparer prepares the GetWebJobSlot request.
func (client AppsClient) GetWebJobSlotPreparer(ctx context.Context, resourceGroupName string, name string, webJobName string, slot string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"slot":              autorest.Encode("path", slot),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
		"webJobName":        autorest.Encode("path", webJobName),
	}

	const APIVersion = "2019-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/webjobs/{webJobName}", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// GetWebJobSlotSender sends the GetWebJobSlot request. The method will close the
// http.Response Body if it receives an error.
func (client AppsClient) GetWebJobSlotSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// GetWebJobSlotResponder handles the response to the GetWebJobSlot request. The method always
// closes the http.Response Body.
func (client AppsClient) GetWebJobSlotResponder(resp *http.Response) (result Job, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// GetWebSiteContainerLogs description for Gets the last lines of docker logs for the given site
// Parameters:
// resourceGroupName - name of the resource group to which the resource belongs.
// name - name of web app.
func (client AppsClient) GetWebSiteContainerLogs(ctx context.Context, resourceGroupName string, name string) (result ReadCloser, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/AppsClient.GetWebSiteContainerLogs")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewError("web.AppsClient", "GetWebSiteContainerLogs", err.Error())
	}

	req, err := client.GetWebSiteContainerLogsPreparer(ctx, resourceGroupName, name)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "GetWebSiteContainerLogs", nil, "Failure preparing request")
		return
	}

	resp, err := client.GetWebSiteContainerLogsSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.AppsClient", "GetWebSiteContainerLogs", resp, "Failure sending request")
		return
	}

	result, err = client.GetWebSiteContainerLogsResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "GetWebSiteContainerLogs", resp, "Failure responding to request")
	}

	return
}

// GetWebSiteContainerLogsPreparer prepares the GetWebSiteContainerLogs request.
func (client AppsClient) GetWebSiteContainerLogsPreparer(ctx context.Context, resourceGroupName string, name string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2019-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsPost(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/containerlogs", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// GetWebSiteContainerLogsSender sends the GetWebSiteContainerLogs request. The method will close the
// http.Response Body if it receives an error.
func (client AppsClient) GetWebSiteContainerLogsSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// GetWebSiteContainerLogsResponder handles the response to the GetWebSiteContainerLogs request. The method always
// closes the http.Response Body.
func (client AppsClient) GetWebSiteContainerLogsResponder(resp *http.Response) (result ReadCloser, err error) {
	result.Value = &resp.Body
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusNoContent))
	result.Response = autorest.Response{Response: resp}
	return
}

// GetWebSiteContainerLogsSlot description for Gets the last lines of docker logs for the given site
// Parameters:
// resourceGroupName - name of the resource group to which the resource belongs.
// name - name of web app.
// slot - name of web app slot. If not specified then will default to production slot.
func (client AppsClient) GetWebSiteContainerLogsSlot(ctx context.Context, resourceGroupName string, name string, slot string) (result ReadCloser, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/AppsClient.GetWebSiteContainerLogsSlot")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewError("web.AppsClient", "GetWebSiteContainerLogsSlot", err.Error())
	}

	req, err := client.GetWebSiteContainerLogsSlotPreparer(ctx, resourceGroupName, name, slot)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "GetWebSiteContainerLogsSlot", nil, "Failure preparing request")
		return
	}

	resp, err := client.GetWebSiteContainerLogsSlotSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.AppsClient", "GetWebSiteContainerLogsSlot", resp, "Failure sending request")
		return
	}

	result, err = client.GetWebSiteContainerLogsSlotResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "GetWebSiteContainerLogsSlot", resp, "Failure responding to request")
	}

	return
}

// GetWebSiteContainerLogsSlotPreparer prepares the GetWebSiteContainerLogsSlot request.
func (client AppsClient) GetWebSiteContainerLogsSlotPreparer(ctx context.Context, resourceGroupName string, name string, slot string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"slot":              autorest.Encode("path", slot),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2019-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsPost(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/containerlogs", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// GetWebSiteContainerLogsSlotSender sends the GetWebSiteContainerLogsSlot request. The method will close the
// http.Response Body if it receives an error.
func (client AppsClient) GetWebSiteContainerLogsSlotSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// GetWebSiteContainerLogsSlotResponder handles the response to the GetWebSiteContainerLogsSlot request. The method always
// closes the http.Response Body.
func (client AppsClient) GetWebSiteContainerLogsSlotResponder(resp *http.Response) (result ReadCloser, err error) {
	result.Value = &resp.Body
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusNoContent))
	result.Response = autorest.Response{Response: resp}
	return
}

// InstallSiteExtension description for Install site extension on a web site, or a deployment slot.
// Parameters:
// resourceGroupName - name of the resource group to which the resource belongs.
// name - site name.
// siteExtensionID - site extension name.
func (client AppsClient) InstallSiteExtension(ctx context.Context, resourceGroupName string, name string, siteExtensionID string) (result AppsInstallSiteExtensionFuture, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/AppsClient.InstallSiteExtension")
		defer func() {
			sc := -1
			if result.Response() != nil {
				sc = result.Response().StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewError("web.AppsClient", "InstallSiteExtension", err.Error())
	}

	req, err := client.InstallSiteExtensionPreparer(ctx, resourceGroupName, name, siteExtensionID)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "InstallSiteExtension", nil, "Failure preparing request")
		return
	}

	result, err = client.InstallSiteExtensionSender(req)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "InstallSiteExtension", result.Response(), "Failure sending request")
		return
	}

	return
}

// InstallSiteExtensionPreparer prepares the InstallSiteExtension request.
func (client AppsClient) InstallSiteExtensionPreparer(ctx context.Context, resourceGroupName string, name string, siteExtensionID string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"siteExtensionId":   autorest.Encode("path", siteExtensionID),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2019-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsPut(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/siteextensions/{siteExtensionId}", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// InstallSiteExtensionSender sends the InstallSiteExtension request. The method will close the
// http.Response Body if it receives an error.
func (client AppsClient) InstallSiteExtensionSender(req *http.Request) (future AppsInstallSiteExtensionFuture, err error) {
	var resp *http.Response
	resp, err = client.Send(req, azure.DoRetryWithRegistration(client.Client))
	if err != nil {
		return
	}
	future.Future, err = azure.NewFutureFromResponse(resp)
	return
}

// InstallSiteExtensionResponder handles the response to the InstallSiteExtension request. The method always
// closes the http.Response Body.
func (client AppsClient) InstallSiteExtensionResponder(resp *http.Response) (result SiteExtensionInfo, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusCreated, http.StatusTooManyRequests),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// InstallSiteExtensionSlot description for Install site extension on a web site, or a deployment slot.
// Parameters:
// resourceGroupName - name of the resource group to which the resource belongs.
// name - site name.
// siteExtensionID - site extension name.
// slot - name of the deployment slot. If a slot is not specified, the API uses the production slot.
func (client AppsClient) InstallSiteExtensionSlot(ctx context.Context, resourceGroupName string, name string, siteExtensionID string, slot string) (result AppsInstallSiteExtensionSlotFuture, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/AppsClient.InstallSiteExtensionSlot")
		defer func() {
			sc := -1
			if result.Response() != nil {
				sc = result.Response().StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewError("web.AppsClient", "InstallSiteExtensionSlot", err.Error())
	}

	req, err := client.InstallSiteExtensionSlotPreparer(ctx, resourceGroupName, name, siteExtensionID, slot)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "InstallSiteExtensionSlot", nil, "Failure preparing request")
		return
	}

	result, err = client.InstallSiteExtensionSlotSender(req)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "InstallSiteExtensionSlot", result.Response(), "Failure sending request")
		return
	}

	return
}

// InstallSiteExtensionSlotPreparer prepares the InstallSiteExtensionSlot request.
func (client AppsClient) InstallSiteExtensionSlotPreparer(ctx context.Context, resourceGroupName string, name string, siteExtensionID string, slot string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"siteExtensionId":   autorest.Encode("path", siteExtensionID),
		"slot":              autorest.Encode("path", slot),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2019-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsPut(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/siteextensions/{siteExtensionId}", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// InstallSiteExtensionSlotSender sends the InstallSiteExtensionSlot request. The method will close the
// http.Response Body if it receives an error.
func (client AppsClient) InstallSiteExtensionSlotSender(req *http.Request) (future AppsInstallSiteExtensionSlotFuture, err error) {
	var resp *http.Response
	resp, err = client.Send(req, azure.DoRetryWithRegistration(client.Client))
	if err != nil {
		return
	}
	future.Future, err = azure.NewFutureFromResponse(resp)
	return
}

// InstallSiteExtensionSlotResponder handles the response to the InstallSiteExtensionSlot request. The method always
// closes the http.Response Body.
func (client AppsClient) InstallSiteExtensionSlotResponder(resp *http.Response) (result SiteExtensionInfo, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusCreated, http.StatusTooManyRequests),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// IsCloneable description for Shows whether an app can be cloned to another resource group or subscription.
// Parameters:
// resourceGroupName - name of the resource group to which the resource belongs.
// name - name of the app.
func (client AppsClient) IsCloneable(ctx context.Context, resourceGroupName string, name string) (result SiteCloneability, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/AppsClient.IsCloneable")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewError("web.AppsClient", "IsCloneable", err.Error())
	}

	req, err := client.IsCloneablePreparer(ctx, resourceGroupName, name)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "IsCloneable", nil, "Failure preparing request")
		return
	}

	resp, err := client.IsCloneableSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.AppsClient", "IsCloneable", resp, "Failure sending request")
		return
	}

	result, err = client.IsCloneableResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "IsCloneable", resp, "Failure responding to request")
	}

	return
}

// IsCloneablePreparer prepares the IsCloneable request.
func (client AppsClient) IsCloneablePreparer(ctx context.Context, resourceGroupName string, name string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2019-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsPost(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/iscloneable", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// IsCloneableSender sends the IsCloneable request. The method will close the
// http.Response Body if it receives an error.
func (client AppsClient) IsCloneableSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// IsCloneableResponder handles the response to the IsCloneable request. The method always
// closes the http.Response Body.
func (client AppsClient) IsCloneableResponder(resp *http.Response) (result SiteCloneability, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// IsCloneableSlot description for Shows whether an app can be cloned to another resource group or subscription.
// Parameters:
// resourceGroupName - name of the resource group to which the resource belongs.
// name - name of the app.
// slot - name of the deployment slot. By default, this API returns information on the production slot.
func (client AppsClient) IsCloneableSlot(ctx context.Context, resourceGroupName string, name string, slot string) (result SiteCloneability, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/AppsClient.IsCloneableSlot")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewError("web.AppsClient", "IsCloneableSlot", err.Error())
	}

	req, err := client.IsCloneableSlotPreparer(ctx, resourceGroupName, name, slot)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "IsCloneableSlot", nil, "Failure preparing request")
		return
	}

	resp, err := client.IsCloneableSlotSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.AppsClient", "IsCloneableSlot", resp, "Failure sending request")
		return
	}

	result, err = client.IsCloneableSlotResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "IsCloneableSlot", resp, "Failure responding to request")
	}

	return
}

// IsCloneableSlotPreparer prepares the IsCloneableSlot request.
func (client AppsClient) IsCloneableSlotPreparer(ctx context.Context, resourceGroupName string, name string, slot string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"slot":              autorest.Encode("path", slot),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2019-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsPost(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/iscloneable", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// IsCloneableSlotSender sends the IsCloneableSlot request. The method will close the
// http.Response Body if it receives an error.
func (client AppsClient) IsCloneableSlotSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// IsCloneableSlotResponder handles the response to the IsCloneableSlot request. The method always
// closes the http.Response Body.
func (client AppsClient) IsCloneableSlotResponder(resp *http.Response) (result SiteCloneability, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// List description for Get all apps for a subscription.
func (client AppsClient) List(ctx context.Context) (result AppCollectionPage, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/AppsClient.List")
		defer func() {
			sc := -1
			if result.ac.Response.Response != nil {
				sc = result.ac.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	result.fn = client.listNextResults
	req, err := client.ListPreparer(ctx)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "List", nil, "Failure preparing request")
		return
	}

	resp, err := client.ListSender(req)
	if err != nil {
		result.ac.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.AppsClient", "List", resp, "Failure sending request")
		return
	}

	result.ac, err = client.ListResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "List", resp, "Failure responding to request")
	}

	return
}

// ListPreparer prepares the List request.
func (client AppsClient) ListPreparer(ctx context.Context) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"subscriptionId": autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2019-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/providers/Microsoft.Web/sites", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// ListSender sends the List request. The method will close the
// http.Response Body if it receives an error.
func (client AppsClient) ListSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// ListResponder handles the response to the List request. The method always
// closes the http.Response Body.
func (client AppsClient) ListResponder(resp *http.Response) (result AppCollection, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// listNextResults retrieves the next set of results, if any.
func (client AppsClient) listNextResults(ctx context.Context, lastResults AppCollection) (result AppCollection, err error) {
	req, err := lastResults.appCollectionPreparer(ctx)
	if err != nil {
		return result, autorest.NewErrorWithError(err, "web.AppsClient", "listNextResults", nil, "Failure preparing next results request")
	}
	if req == nil {
		return
	}
	resp, err := client.ListSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		return result, autorest.NewErrorWithError(err, "web.AppsClient", "listNextResults", resp, "Failure sending next results request")
	}
	result, err = client.ListResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "listNextResults", resp, "Failure responding to next results request")
	}
	return
}

// ListComplete enumerates all values, automatically crossing page boundaries as required.
func (client AppsClient) ListComplete(ctx context.Context) (result AppCollectionIterator, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/AppsClient.List")
		defer func() {
			sc := -1
			if result.Response().Response.Response != nil {
				sc = result.page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	result.page, err = client.List(ctx)
	return
}

// ListApplicationSettings description for Gets the application settings of an app.
// Parameters:
// resourceGroupName - name of the resource group to which the resource belongs.
// name - name of the app.
func (client AppsClient) ListApplicationSettings(ctx context.Context, resourceGroupName string, name string) (result StringDictionary, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/AppsClient.ListApplicationSettings")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewError("web.AppsClient", "ListApplicationSettings", err.Error())
	}

	req, err := client.ListApplicationSettingsPreparer(ctx, resourceGroupName, name)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "ListApplicationSettings", nil, "Failure preparing request")
		return
	}

	resp, err := client.ListApplicationSettingsSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.AppsClient", "ListApplicationSettings", resp, "Failure sending request")
		return
	}

	result, err = client.ListApplicationSettingsResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "ListApplicationSettings", resp, "Failure responding to request")
	}

	return
}

// ListApplicationSettingsPreparer prepares the ListApplicationSettings request.
func (client AppsClient) ListApplicationSettingsPreparer(ctx context.Context, resourceGroupName string, name string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2019-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsPost(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/config/appsettings/list", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// ListApplicationSettingsSender sends the ListApplicationSettings request. The method will close the
// http.Response Body if it receives an error.
func (client AppsClient) ListApplicationSettingsSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// ListApplicationSettingsResponder handles the response to the ListApplicationSettings request. The method always
// closes the http.Response Body.
func (client AppsClient) ListApplicationSettingsResponder(resp *http.Response) (result StringDictionary, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// ListApplicationSettingsSlot description for Gets the application settings of an app.
// Parameters:
// resourceGroupName - name of the resource group to which the resource belongs.
// name - name of the app.
// slot - name of the deployment slot. If a slot is not specified, the API will get the application settings
// for the production slot.
func (client AppsClient) ListApplicationSettingsSlot(ctx context.Context, resourceGroupName string, name string, slot string) (result StringDictionary, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/AppsClient.ListApplicationSettingsSlot")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewError("web.AppsClient", "ListApplicationSettingsSlot", err.Error())
	}

	req, err := client.ListApplicationSettingsSlotPreparer(ctx, resourceGroupName, name, slot)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "ListApplicationSettingsSlot", nil, "Failure preparing request")
		return
	}

	resp, err := client.ListApplicationSettingsSlotSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.AppsClient", "ListApplicationSettingsSlot", resp, "Failure sending request")
		return
	}

	result, err = client.ListApplicationSettingsSlotResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "ListApplicationSettingsSlot", resp, "Failure responding to request")
	}

	return
}

// ListApplicationSettingsSlotPreparer prepares the ListApplicationSettingsSlot request.
func (client AppsClient) ListApplicationSettingsSlotPreparer(ctx context.Context, resourceGroupName string, name string, slot string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"slot":              autorest.Encode("path", slot),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2019-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsPost(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/config/appsettings/list", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// ListApplicationSettingsSlotSender sends the ListApplicationSettingsSlot request. The method will close the
// http.Response Body if it receives an error.
func (client AppsClient) ListApplicationSettingsSlotSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// ListApplicationSettingsSlotResponder handles the response to the ListApplicationSettingsSlot request. The method always
// closes the http.Response Body.
func (client AppsClient) ListApplicationSettingsSlotResponder(resp *http.Response) (result StringDictionary, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// ListAzureStorageAccounts description for Gets the Azure storage account configurations of an app.
// Parameters:
// resourceGroupName - name of the resource group to which the resource belongs.
// name - name of the app.
func (client AppsClient) ListAzureStorageAccounts(ctx context.Context, resourceGroupName string, name string) (result AzureStoragePropertyDictionaryResource, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/AppsClient.ListAzureStorageAccounts")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewError("web.AppsClient", "ListAzureStorageAccounts", err.Error())
	}

	req, err := client.ListAzureStorageAccountsPreparer(ctx, resourceGroupName, name)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "ListAzureStorageAccounts", nil, "Failure preparing request")
		return
	}

	resp, err := client.ListAzureStorageAccountsSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.AppsClient", "ListAzureStorageAccounts", resp, "Failure sending request")
		return
	}

	result, err = client.ListAzureStorageAccountsResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "ListAzureStorageAccounts", resp, "Failure responding to request")
	}

	return
}

// ListAzureStorageAccountsPreparer prepares the ListAzureStorageAccounts request.
func (client AppsClient) ListAzureStorageAccountsPreparer(ctx context.Context, resourceGroupName string, name string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2019-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsPost(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/config/azurestorageaccounts/list", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// ListAzureStorageAccountsSender sends the ListAzureStorageAccounts request. The method will close the
// http.Response Body if it receives an error.
func (client AppsClient) ListAzureStorageAccountsSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// ListAzureStorageAccountsResponder handles the response to the ListAzureStorageAccounts request. The method always
// closes the http.Response Body.
func (client AppsClient) ListAzureStorageAccountsResponder(resp *http.Response) (result AzureStoragePropertyDictionaryResource, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// ListAzureStorageAccountsSlot description for Gets the Azure storage account configurations of an app.
// Parameters:
// resourceGroupName - name of the resource group to which the resource belongs.
// name - name of the app.
// slot - name of the deployment slot. If a slot is not specified, the API will update the Azure storage
// account configurations for the production slot.
func (client AppsClient) ListAzureStorageAccountsSlot(ctx context.Context, resourceGroupName string, name string, slot string) (result AzureStoragePropertyDictionaryResource, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/AppsClient.ListAzureStorageAccountsSlot")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewError("web.AppsClient", "ListAzureStorageAccountsSlot", err.Error())
	}

	req, err := client.ListAzureStorageAccountsSlotPreparer(ctx, resourceGroupName, name, slot)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "ListAzureStorageAccountsSlot", nil, "Failure preparing request")
		return
	}

	resp, err := client.ListAzureStorageAccountsSlotSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.AppsClient", "ListAzureStorageAccountsSlot", resp, "Failure sending request")
		return
	}

	result, err = client.ListAzureStorageAccountsSlotResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "ListAzureStorageAccountsSlot", resp, "Failure responding to request")
	}

	return
}

// ListAzureStorageAccountsSlotPreparer prepares the ListAzureStorageAccountsSlot request.
func (client AppsClient) ListAzureStorageAccountsSlotPreparer(ctx context.Context, resourceGroupName string, name string, slot string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"slot":              autorest.Encode("path", slot),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2019-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsPost(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/config/azurestorageaccounts/list", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// ListAzureStorageAccountsSlotSender sends the ListAzureStorageAccountsSlot request. The method will close the
// http.Response Body if it receives an error.
func (client AppsClient) ListAzureStorageAccountsSlotSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// ListAzureStorageAccountsSlotResponder handles the response to the ListAzureStorageAccountsSlot request. The method always
// closes the http.Response Body.
func (client AppsClient) ListAzureStorageAccountsSlotResponder(resp *http.Response) (result AzureStoragePropertyDictionaryResource, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// ListBackups description for Gets existing backups of an app.
// Parameters:
// resourceGroupName - name of the resource group to which the resource belongs.
// name - name of the app.
func (client AppsClient) ListBackups(ctx context.Context, resourceGroupName string, name string) (result BackupItemCollectionPage, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/AppsClient.ListBackups")
		defer func() {
			sc := -1
			if result.bic.Response.Response != nil {
				sc = result.bic.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewError("web.AppsClient", "ListBackups", err.Error())
	}

	result.fn = client.listBackupsNextResults
	req, err := client.ListBackupsPreparer(ctx, resourceGroupName, name)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "ListBackups", nil, "Failure preparing request")
		return
	}

	resp, err := client.ListBackupsSender(req)
	if err != nil {
		result.bic.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.AppsClient", "ListBackups", resp, "Failure sending request")
		return
	}

	result.bic, err = client.ListBackupsResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "ListBackups", resp, "Failure responding to request")
	}

	return
}

// ListBackupsPreparer prepares the ListBackups request.
func (client AppsClient) ListBackupsPreparer(ctx context.Context, resourceGroupName string, name string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2019-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/backups", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// ListBackupsSender sends the ListBackups request. The method will close the
// http.Response Body if it receives an error.
func (client AppsClient) ListBackupsSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// ListBackupsResponder handles the response to the ListBackups request. The method always
// closes the http.Response Body.
func (client AppsClient) ListBackupsResponder(resp *http.Response) (result BackupItemCollection, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// listBackupsNextResults retrieves the next set of results, if any.
func (client AppsClient) listBackupsNextResults(ctx context.Context, lastResults BackupItemCollection) (result BackupItemCollection, err error) {
	req, err := lastResults.backupItemCollectionPreparer(ctx)
	if err != nil {
		return result, autorest.NewErrorWithError(err, "web.AppsClient", "listBackupsNextResults", nil, "Failure preparing next results request")
	}
	if req == nil {
		return
	}
	resp, err := client.ListBackupsSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		return result, autorest.NewErrorWithError(err, "web.AppsClient", "listBackupsNextResults", resp, "Failure sending next results request")
	}
	result, err = client.ListBackupsResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "listBackupsNextResults", resp, "Failure responding to next results request")
	}
	return
}

// ListBackupsComplete enumerates all values, automatically crossing page boundaries as required.
func (client AppsClient) ListBackupsComplete(ctx context.Context, resourceGroupName string, name string) (result BackupItemCollectionIterator, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/AppsClient.ListBackups")
		defer func() {
			sc := -1
			if result.Response().Response.Response != nil {
				sc = result.page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	result.page, err = client.ListBackups(ctx, resourceGroupName, name)
	return
}

// ListBackupsSlot description for Gets existing backups of an app.
// Parameters:
// resourceGroupName - name of the resource group to which the resource belongs.
// name - name of the app.
// slot - name of the deployment slot. If a slot is not specified, the API will get backups of the production
// slot.
func (client AppsClient) ListBackupsSlot(ctx context.Context, resourceGroupName string, name string, slot string) (result BackupItemCollectionPage, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/AppsClient.ListBackupsSlot")
		defer func() {
			sc := -1
			if result.bic.Response.Response != nil {
				sc = result.bic.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewError("web.AppsClient", "ListBackupsSlot", err.Error())
	}

	result.fn = client.listBackupsSlotNextResults
	req, err := client.ListBackupsSlotPreparer(ctx, resourceGroupName, name, slot)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "ListBackupsSlot", nil, "Failure preparing request")
		return
	}

	resp, err := client.ListBackupsSlotSender(req)
	if err != nil {
		result.bic.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.AppsClient", "ListBackupsSlot", resp, "Failure sending request")
		return
	}

	result.bic, err = client.ListBackupsSlotResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "ListBackupsSlot", resp, "Failure responding to request")
	}

	return
}

// ListBackupsSlotPreparer prepares the ListBackupsSlot request.
func (client AppsClient) ListBackupsSlotPreparer(ctx context.Context, resourceGroupName string, name string, slot string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"slot":              autorest.Encode("path", slot),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2019-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/backups", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// ListBackupsSlotSender sends the ListBackupsSlot request. The method will close the
// http.Response Body if it receives an error.
func (client AppsClient) ListBackupsSlotSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// ListBackupsSlotResponder handles the response to the ListBackupsSlot request. The method always
// closes the http.Response Body.
func (client AppsClient) ListBackupsSlotResponder(resp *http.Response) (result BackupItemCollection, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// listBackupsSlotNextResults retrieves the next set of results, if any.
func (client AppsClient) listBackupsSlotNextResults(ctx context.Context, lastResults BackupItemCollection) (result BackupItemCollection, err error) {
	req, err := lastResults.backupItemCollectionPreparer(ctx)
	if err != nil {
		return result, autorest.NewErrorWithError(err, "web.AppsClient", "listBackupsSlotNextResults", nil, "Failure preparing next results request")
	}
	if req == nil {
		return
	}
	resp, err := client.ListBackupsSlotSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		return result, autorest.NewErrorWithError(err, "web.AppsClient", "listBackupsSlotNextResults", resp, "Failure sending next results request")
	}
	result, err = client.ListBackupsSlotResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "listBackupsSlotNextResults", resp, "Failure responding to next results request")
	}
	return
}

// ListBackupsSlotComplete enumerates all values, automatically crossing page boundaries as required.
func (client AppsClient) ListBackupsSlotComplete(ctx context.Context, resourceGroupName string, name string, slot string) (result BackupItemCollectionIterator, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/AppsClient.ListBackupsSlot")
		defer func() {
			sc := -1
			if result.Response().Response.Response != nil {
				sc = result.page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	result.page, err = client.ListBackupsSlot(ctx, resourceGroupName, name, slot)
	return
}

// ListBackupStatusSecrets description for Gets status of a web app backup that may be in progress, including secrets
// associated with the backup, such as the Azure Storage SAS URL. Also can be used to update the SAS URL for the backup
// if a new URL is passed in the request body.
// Parameters:
// resourceGroupName - name of the resource group to which the resource belongs.
// name - name of web app.
// backupID - ID of backup.
// request - information on backup request.
func (client AppsClient) ListBackupStatusSecrets(ctx context.Context, resourceGroupName string, name string, backupID string, request BackupRequest) (result BackupItem, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/AppsClient.ListBackupStatusSecrets")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}},
		{TargetValue: request,
			Constraints: []validation.Constraint{{Target: "request.BackupRequestProperties", Name: validation.Null, Rule: false,
				Chain: []validation.Constraint{{Target: "request.BackupRequestProperties.StorageAccountURL", Name: validation.Null, Rule: true, Chain: nil},
					{Target: "request.BackupRequestProperties.BackupSchedule", Name: validation.Null, Rule: false,
						Chain: []validation.Constraint{{Target: "request.BackupRequestProperties.BackupSchedule.FrequencyInterval", Name: validation.Null, Rule: true, Chain: nil},
							{Target: "request.BackupRequestProperties.BackupSchedule.KeepAtLeastOneBackup", Name: validation.Null, Rule: true, Chain: nil},
							{Target: "request.BackupRequestProperties.BackupSchedule.RetentionPeriodInDays", Name: validation.Null, Rule: true, Chain: nil},
						}},
				}}}}}); err != nil {
		return result, validation.NewError("web.AppsClient", "ListBackupStatusSecrets", err.Error())
	}

	req, err := client.ListBackupStatusSecretsPreparer(ctx, resourceGroupName, name, backupID, request)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "ListBackupStatusSecrets", nil, "Failure preparing request")
		return
	}

	resp, err := client.ListBackupStatusSecretsSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.AppsClient", "ListBackupStatusSecrets", resp, "Failure sending request")
		return
	}

	result, err = client.ListBackupStatusSecretsResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "ListBackupStatusSecrets", resp, "Failure responding to request")
	}

	return
}

// ListBackupStatusSecretsPreparer prepares the ListBackupStatusSecrets request.
func (client AppsClient) ListBackupStatusSecretsPreparer(ctx context.Context, resourceGroupName string, name string, backupID string, request BackupRequest) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"backupId":          autorest.Encode("path", backupID),
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2019-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsContentType("application/json; charset=utf-8"),
		autorest.AsPost(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/backups/{backupId}/list", pathParameters),
		autorest.WithJSON(request),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// ListBackupStatusSecretsSender sends the ListBackupStatusSecrets request. The method will close the
// http.Response Body if it receives an error.
func (client AppsClient) ListBackupStatusSecretsSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// ListBackupStatusSecretsResponder handles the response to the ListBackupStatusSecrets request. The method always
// closes the http.Response Body.
func (client AppsClient) ListBackupStatusSecretsResponder(resp *http.Response) (result BackupItem, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// ListBackupStatusSecretsSlot description for Gets status of a web app backup that may be in progress, including
// secrets associated with the backup, such as the Azure Storage SAS URL. Also can be used to update the SAS URL for
// the backup if a new URL is passed in the request body.
// Parameters:
// resourceGroupName - name of the resource group to which the resource belongs.
// name - name of web app.
// backupID - ID of backup.
// request - information on backup request.
// slot - name of web app slot. If not specified then will default to production slot.
func (client AppsClient) ListBackupStatusSecretsSlot(ctx context.Context, resourceGroupName string, name string, backupID string, request BackupRequest, slot string) (result BackupItem, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/AppsClient.ListBackupStatusSecretsSlot")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}},
		{TargetValue: request,
			Constraints: []validation.Constraint{{Target: "request.BackupRequestProperties", Name: validation.Null, Rule: false,
				Chain: []validation.Constraint{{Target: "request.BackupRequestProperties.StorageAccountURL", Name: validation.Null, Rule: true, Chain: nil},
					{Target: "request.BackupRequestProperties.BackupSchedule", Name: validation.Null, Rule: false,
						Chain: []validation.Constraint{{Target: "request.BackupRequestProperties.BackupSchedule.FrequencyInterval", Name: validation.Null, Rule: true, Chain: nil},
							{Target: "request.BackupRequestProperties.BackupSchedule.KeepAtLeastOneBackup", Name: validation.Null, Rule: true, Chain: nil},
							{Target: "request.BackupRequestProperties.BackupSchedule.RetentionPeriodInDays", Name: validation.Null, Rule: true, Chain: nil},
						}},
				}}}}}); err != nil {
		return result, validation.NewError("web.AppsClient", "ListBackupStatusSecretsSlot", err.Error())
	}

	req, err := client.ListBackupStatusSecretsSlotPreparer(ctx, resourceGroupName, name, backupID, request, slot)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "ListBackupStatusSecretsSlot", nil, "Failure preparing request")
		return
	}

	resp, err := client.ListBackupStatusSecretsSlotSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.AppsClient", "ListBackupStatusSecretsSlot", resp, "Failure sending request")
		return
	}

	result, err = client.ListBackupStatusSecretsSlotResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "ListBackupStatusSecretsSlot", resp, "Failure responding to request")
	}

	return
}

// ListBackupStatusSecretsSlotPreparer prepares the ListBackupStatusSecretsSlot request.
func (client AppsClient) ListBackupStatusSecretsSlotPreparer(ctx context.Context, resourceGroupName string, name string, backupID string, request BackupRequest, slot string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"backupId":          autorest.Encode("path", backupID),
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"slot":              autorest.Encode("path", slot),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2019-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsContentType("application/json; charset=utf-8"),
		autorest.AsPost(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/backups/{backupId}/list", pathParameters),
		autorest.WithJSON(request),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// ListBackupStatusSecretsSlotSender sends the ListBackupStatusSecretsSlot request. The method will close the
// http.Response Body if it receives an error.
func (client AppsClient) ListBackupStatusSecretsSlotSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// ListBackupStatusSecretsSlotResponder handles the response to the ListBackupStatusSecretsSlot request. The method always
// closes the http.Response Body.
func (client AppsClient) ListBackupStatusSecretsSlotResponder(resp *http.Response) (result BackupItem, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// ListByResourceGroup description for Gets all web, mobile, and API apps in the specified resource group.
// Parameters:
// resourceGroupName - name of the resource group to which the resource belongs.
// includeSlots - specify <strong>true</strong> to include deployment slots in results. The default is false,
// which only gives you the production slot of all apps.
func (client AppsClient) ListByResourceGroup(ctx context.Context, resourceGroupName string, includeSlots *bool) (result AppCollectionPage, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/AppsClient.ListByResourceGroup")
		defer func() {
			sc := -1
			if result.ac.Response.Response != nil {
				sc = result.ac.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewError("web.AppsClient", "ListByResourceGroup", err.Error())
	}

	result.fn = client.listByResourceGroupNextResults
	req, err := client.ListByResourceGroupPreparer(ctx, resourceGroupName, includeSlots)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "ListByResourceGroup", nil, "Failure preparing request")
		return
	}

	resp, err := client.ListByResourceGroupSender(req)
	if err != nil {
		result.ac.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.AppsClient", "ListByResourceGroup", resp, "Failure sending request")
		return
	}

	result.ac, err = client.ListByResourceGroupResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "ListByResourceGroup", resp, "Failure responding to request")
	}

	return
}

// ListByResourceGroupPreparer prepares the ListByResourceGroup request.
func (client AppsClient) ListByResourceGroupPreparer(ctx context.Context, resourceGroupName string, includeSlots *bool) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2019-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}
	if includeSlots != nil {
		queryParameters["includeSlots"] = autorest.Encode("query", *includeSlots)
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// ListByResourceGroupSender sends the ListByResourceGroup request. The method will close the
// http.Response Body if it receives an error.
func (client AppsClient) ListByResourceGroupSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// ListByResourceGroupResponder handles the response to the ListByResourceGroup request. The method always
// closes the http.Response Body.
func (client AppsClient) ListByResourceGroupResponder(resp *http.Response) (result AppCollection, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// listByResourceGroupNextResults retrieves the next set of results, if any.
func (client AppsClient) listByResourceGroupNextResults(ctx context.Context, lastResults AppCollection) (result AppCollection, err error) {
	req, err := lastResults.appCollectionPreparer(ctx)
	if err != nil {
		return result, autorest.NewErrorWithError(err, "web.AppsClient", "listByResourceGroupNextResults", nil, "Failure preparing next results request")
	}
	if req == nil {
		return
	}
	resp, err := client.ListByResourceGroupSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		return result, autorest.NewErrorWithError(err, "web.AppsClient", "listByResourceGroupNextResults", resp, "Failure sending next results request")
	}
	result, err = client.ListByResourceGroupResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "listByResourceGroupNextResults", resp, "Failure responding to next results request")
	}
	return
}

// ListByResourceGroupComplete enumerates all values, automatically crossing page boundaries as required.
func (client AppsClient) ListByResourceGroupComplete(ctx context.Context, resourceGroupName string, includeSlots *bool) (result AppCollectionIterator, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/AppsClient.ListByResourceGroup")
		defer func() {
			sc := -1
			if result.Response().Response.Response != nil {
				sc = result.page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	result.page, err = client.ListByResourceGroup(ctx, resourceGroupName, includeSlots)
	return
}

// ListConfigurations description for List the configurations of an app
// Parameters:
// resourceGroupName - name of the resource group to which the resource belongs.
// name - name of the app.
func (client AppsClient) ListConfigurations(ctx context.Context, resourceGroupName string, name string) (result SiteConfigResourceCollectionPage, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/AppsClient.ListConfigurations")
		defer func() {
			sc := -1
			if result.scrc.Response.Response != nil {
				sc = result.scrc.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewError("web.AppsClient", "ListConfigurations", err.Error())
	}

	result.fn = client.listConfigurationsNextResults
	req, err := client.ListConfigurationsPreparer(ctx, resourceGroupName, name)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "ListConfigurations", nil, "Failure preparing request")
		return
	}

	resp, err := client.ListConfigurationsSender(req)
	if err != nil {
		result.scrc.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.AppsClient", "ListConfigurations", resp, "Failure sending request")
		return
	}

	result.scrc, err = client.ListConfigurationsResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "ListConfigurations", resp, "Failure responding to request")
	}

	return
}

// ListConfigurationsPreparer prepares the ListConfigurations request.
func (client AppsClient) ListConfigurationsPreparer(ctx context.Context, resourceGroupName string, name string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2019-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/config", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// ListConfigurationsSender sends the ListConfigurations request. The method will close the
// http.Response Body if it receives an error.
func (client AppsClient) ListConfigurationsSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// ListConfigurationsResponder handles the response to the ListConfigurations request. The method always
// closes the http.Response Body.
func (client AppsClient) ListConfigurationsResponder(resp *http.Response) (result SiteConfigResourceCollection, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// listConfigurationsNextResults retrieves the next set of results, if any.
func (client AppsClient) listConfigurationsNextResults(ctx context.Context, lastResults SiteConfigResourceCollection) (result SiteConfigResourceCollection, err error) {
	req, err := lastResults.siteConfigResourceCollectionPreparer(ctx)
	if err != nil {
		return result, autorest.NewErrorWithError(err, "web.AppsClient", "listConfigurationsNextResults", nil, "Failure preparing next results request")
	}
	if req == nil {
		return
	}
	resp, err := client.ListConfigurationsSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		return result, autorest.NewErrorWithError(err, "web.AppsClient", "listConfigurationsNextResults", resp, "Failure sending next results request")
	}
	result, err = client.ListConfigurationsResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "listConfigurationsNextResults", resp, "Failure responding to next results request")
	}
	return
}

// ListConfigurationsComplete enumerates all values, automatically crossing page boundaries as required.
func (client AppsClient) ListConfigurationsComplete(ctx context.Context, resourceGroupName string, name string) (result SiteConfigResourceCollectionIterator, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/AppsClient.ListConfigurations")
		defer func() {
			sc := -1
			if result.Response().Response.Response != nil {
				sc = result.page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	result.page, err = client.ListConfigurations(ctx, resourceGroupName, name)
	return
}

// ListConfigurationSnapshotInfo description for Gets a list of web app configuration snapshots identifiers. Each
// element of the list contains a timestamp and the ID of the snapshot.
// Parameters:
// resourceGroupName - name of the resource group to which the resource belongs.
// name - name of the app.
func (client AppsClient) ListConfigurationSnapshotInfo(ctx context.Context, resourceGroupName string, name string) (result SiteConfigurationSnapshotInfoCollectionPage, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/AppsClient.ListConfigurationSnapshotInfo")
		defer func() {
			sc := -1
			if result.scsic.Response.Response != nil {
				sc = result.scsic.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewError("web.AppsClient", "ListConfigurationSnapshotInfo", err.Error())
	}

	result.fn = client.listConfigurationSnapshotInfoNextResults
	req, err := client.ListConfigurationSnapshotInfoPreparer(ctx, resourceGroupName, name)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "ListConfigurationSnapshotInfo", nil, "Failure preparing request")
		return
	}

	resp, err := client.ListConfigurationSnapshotInfoSender(req)
	if err != nil {
		result.scsic.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.AppsClient", "ListConfigurationSnapshotInfo", resp, "Failure sending request")
		return
	}

	result.scsic, err = client.ListConfigurationSnapshotInfoResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "ListConfigurationSnapshotInfo", resp, "Failure responding to request")
	}

	return
}

// ListConfigurationSnapshotInfoPreparer prepares the ListConfigurationSnapshotInfo request.
func (client AppsClient) ListConfigurationSnapshotInfoPreparer(ctx context.Context, resourceGroupName string, name string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2019-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/config/web/snapshots", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// ListConfigurationSnapshotInfoSender sends the ListConfigurationSnapshotInfo request. The method will close the
// http.Response Body if it receives an error.
func (client AppsClient) ListConfigurationSnapshotInfoSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// ListConfigurationSnapshotInfoResponder handles the response to the ListConfigurationSnapshotInfo request. The method always
// closes the http.Response Body.
func (client AppsClient) ListConfigurationSnapshotInfoResponder(resp *http.Response) (result SiteConfigurationSnapshotInfoCollection, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// listConfigurationSnapshotInfoNextResults retrieves the next set of results, if any.
func (client AppsClient) listConfigurationSnapshotInfoNextResults(ctx context.Context, lastResults SiteConfigurationSnapshotInfoCollection) (result SiteConfigurationSnapshotInfoCollection, err error) {
	req, err := lastResults.siteConfigurationSnapshotInfoCollectionPreparer(ctx)
	if err != nil {
		return result, autorest.NewErrorWithError(err, "web.AppsClient", "listConfigurationSnapshotInfoNextResults", nil, "Failure preparing next results request")
	}
	if req == nil {
		return
	}
	resp, err := client.ListConfigurationSnapshotInfoSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		return result, autorest.NewErrorWithError(err, "web.AppsClient", "listConfigurationSnapshotInfoNextResults", resp, "Failure sending next results request")
	}
	result, err = client.ListConfigurationSnapshotInfoResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "listConfigurationSnapshotInfoNextResults", resp, "Failure responding to next results request")
	}
	return
}

// ListConfigurationSnapshotInfoComplete enumerates all values, automatically crossing page boundaries as required.
func (client AppsClient) ListConfigurationSnapshotInfoComplete(ctx context.Context, resourceGroupName string, name string) (result SiteConfigurationSnapshotInfoCollectionIterator, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/AppsClient.ListConfigurationSnapshotInfo")
		defer func() {
			sc := -1
			if result.Response().Response.Response != nil {
				sc = result.page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	result.page, err = client.ListConfigurationSnapshotInfo(ctx, resourceGroupName, name)
	return
}

// ListConfigurationSnapshotInfoSlot description for Gets a list of web app configuration snapshots identifiers. Each
// element of the list contains a timestamp and the ID of the snapshot.
// Parameters:
// resourceGroupName - name of the resource group to which the resource belongs.
// name - name of the app.
// slot - name of the deployment slot. If a slot is not specified, the API will return configuration for the
// production slot.
func (client AppsClient) ListConfigurationSnapshotInfoSlot(ctx context.Context, resourceGroupName string, name string, slot string) (result SiteConfigurationSnapshotInfoCollectionPage, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/AppsClient.ListConfigurationSnapshotInfoSlot")
		defer func() {
			sc := -1
			if result.scsic.Response.Response != nil {
				sc = result.scsic.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewError("web.AppsClient", "ListConfigurationSnapshotInfoSlot", err.Error())
	}

	result.fn = client.listConfigurationSnapshotInfoSlotNextResults
	req, err := client.ListConfigurationSnapshotInfoSlotPreparer(ctx, resourceGroupName, name, slot)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "ListConfigurationSnapshotInfoSlot", nil, "Failure preparing request")
		return
	}

	resp, err := client.ListConfigurationSnapshotInfoSlotSender(req)
	if err != nil {
		result.scsic.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.AppsClient", "ListConfigurationSnapshotInfoSlot", resp, "Failure sending request")
		return
	}

	result.scsic, err = client.ListConfigurationSnapshotInfoSlotResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "ListConfigurationSnapshotInfoSlot", resp, "Failure responding to request")
	}

	return
}

// ListConfigurationSnapshotInfoSlotPreparer prepares the ListConfigurationSnapshotInfoSlot request.
func (client AppsClient) ListConfigurationSnapshotInfoSlotPreparer(ctx context.Context, resourceGroupName string, name string, slot string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"slot":              autorest.Encode("path", slot),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2019-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/config/web/snapshots", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// ListConfigurationSnapshotInfoSlotSender sends the ListConfigurationSnapshotInfoSlot request. The method will close the
// http.Response Body if it receives an error.
func (client AppsClient) ListConfigurationSnapshotInfoSlotSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// ListConfigurationSnapshotInfoSlotResponder handles the response to the ListConfigurationSnapshotInfoSlot request. The method always
// closes the http.Response Body.
func (client AppsClient) ListConfigurationSnapshotInfoSlotResponder(resp *http.Response) (result SiteConfigurationSnapshotInfoCollection, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// listConfigurationSnapshotInfoSlotNextResults retrieves the next set of results, if any.
func (client AppsClient) listConfigurationSnapshotInfoSlotNextResults(ctx context.Context, lastResults SiteConfigurationSnapshotInfoCollection) (result SiteConfigurationSnapshotInfoCollection, err error) {
	req, err := lastResults.siteConfigurationSnapshotInfoCollectionPreparer(ctx)
	if err != nil {
		return result, autorest.NewErrorWithError(err, "web.AppsClient", "listConfigurationSnapshotInfoSlotNextResults", nil, "Failure preparing next results request")
	}
	if req == nil {
		return
	}
	resp, err := client.ListConfigurationSnapshotInfoSlotSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		return result, autorest.NewErrorWithError(err, "web.AppsClient", "listConfigurationSnapshotInfoSlotNextResults", resp, "Failure sending next results request")
	}
	result, err = client.ListConfigurationSnapshotInfoSlotResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "listConfigurationSnapshotInfoSlotNextResults", resp, "Failure responding to next results request")
	}
	return
}

// ListConfigurationSnapshotInfoSlotComplete enumerates all values, automatically crossing page boundaries as required.
func (client AppsClient) ListConfigurationSnapshotInfoSlotComplete(ctx context.Context, resourceGroupName string, name string, slot string) (result SiteConfigurationSnapshotInfoCollectionIterator, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/AppsClient.ListConfigurationSnapshotInfoSlot")
		defer func() {
			sc := -1
			if result.Response().Response.Response != nil {
				sc = result.page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	result.page, err = client.ListConfigurationSnapshotInfoSlot(ctx, resourceGroupName, name, slot)
	return
}

// ListConfigurationsSlot description for List the configurations of an app
// Parameters:
// resourceGroupName - name of the resource group to which the resource belongs.
// name - name of the app.
// slot - name of the deployment slot. If a slot is not specified, the API will return configuration for the
// production slot.
func (client AppsClient) ListConfigurationsSlot(ctx context.Context, resourceGroupName string, name string, slot string) (result SiteConfigResourceCollectionPage, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/AppsClient.ListConfigurationsSlot")
		defer func() {
			sc := -1
			if result.scrc.Response.Response != nil {
				sc = result.scrc.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewError("web.AppsClient", "ListConfigurationsSlot", err.Error())
	}

	result.fn = client.listConfigurationsSlotNextResults
	req, err := client.ListConfigurationsSlotPreparer(ctx, resourceGroupName, name, slot)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "ListConfigurationsSlot", nil, "Failure preparing request")
		return
	}

	resp, err := client.ListConfigurationsSlotSender(req)
	if err != nil {
		result.scrc.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.AppsClient", "ListConfigurationsSlot", resp, "Failure sending request")
		return
	}

	result.scrc, err = client.ListConfigurationsSlotResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "ListConfigurationsSlot", resp, "Failure responding to request")
	}

	return
}

// ListConfigurationsSlotPreparer prepares the ListConfigurationsSlot request.
func (client AppsClient) ListConfigurationsSlotPreparer(ctx context.Context, resourceGroupName string, name string, slot string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"slot":              autorest.Encode("path", slot),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2019-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/config", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// ListConfigurationsSlotSender sends the ListConfigurationsSlot request. The method will close the
// http.Response Body if it receives an error.
func (client AppsClient) ListConfigurationsSlotSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// ListConfigurationsSlotResponder handles the response to the ListConfigurationsSlot request. The method always
// closes the http.Response Body.
func (client AppsClient) ListConfigurationsSlotResponder(resp *http.Response) (result SiteConfigResourceCollection, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// listConfigurationsSlotNextResults retrieves the next set of results, if any.
func (client AppsClient) listConfigurationsSlotNextResults(ctx context.Context, lastResults SiteConfigResourceCollection) (result SiteConfigResourceCollection, err error) {
	req, err := lastResults.siteConfigResourceCollectionPreparer(ctx)
	if err != nil {
		return result, autorest.NewErrorWithError(err, "web.AppsClient", "listConfigurationsSlotNextResults", nil, "Failure preparing next results request")
	}
	if req == nil {
		return
	}
	resp, err := client.ListConfigurationsSlotSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		return result, autorest.NewErrorWithError(err, "web.AppsClient", "listConfigurationsSlotNextResults", resp, "Failure sending next results request")
	}
	result, err = client.ListConfigurationsSlotResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "listConfigurationsSlotNextResults", resp, "Failure responding to next results request")
	}
	return
}

// ListConfigurationsSlotComplete enumerates all values, automatically crossing page boundaries as required.
func (client AppsClient) ListConfigurationsSlotComplete(ctx context.Context, resourceGroupName string, name string, slot string) (result SiteConfigResourceCollectionIterator, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/AppsClient.ListConfigurationsSlot")
		defer func() {
			sc := -1
			if result.Response().Response.Response != nil {
				sc = result.page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	result.page, err = client.ListConfigurationsSlot(ctx, resourceGroupName, name, slot)
	return
}

// ListConnectionStrings description for Gets the connection strings of an app.
// Parameters:
// resourceGroupName - name of the resource group to which the resource belongs.
// name - name of the app.
func (client AppsClient) ListConnectionStrings(ctx context.Context, resourceGroupName string, name string) (result ConnectionStringDictionary, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/AppsClient.ListConnectionStrings")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewError("web.AppsClient", "ListConnectionStrings", err.Error())
	}

	req, err := client.ListConnectionStringsPreparer(ctx, resourceGroupName, name)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "ListConnectionStrings", nil, "Failure preparing request")
		return
	}

	resp, err := client.ListConnectionStringsSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.AppsClient", "ListConnectionStrings", resp, "Failure sending request")
		return
	}

	result, err = client.ListConnectionStringsResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "ListConnectionStrings", resp, "Failure responding to request")
	}

	return
}

// ListConnectionStringsPreparer prepares the ListConnectionStrings request.
func (client AppsClient) ListConnectionStringsPreparer(ctx context.Context, resourceGroupName string, name string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2019-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsPost(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/config/connectionstrings/list", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// ListConnectionStringsSender sends the ListConnectionStrings request. The method will close the
// http.Response Body if it receives an error.
func (client AppsClient) ListConnectionStringsSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// ListConnectionStringsResponder handles the response to the ListConnectionStrings request. The method always
// closes the http.Response Body.
func (client AppsClient) ListConnectionStringsResponder(resp *http.Response) (result ConnectionStringDictionary, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// ListConnectionStringsSlot description for Gets the connection strings of an app.
// Parameters:
// resourceGroupName - name of the resource group to which the resource belongs.
// name - name of the app.
// slot - name of the deployment slot. If a slot is not specified, the API will get the connection settings for
// the production slot.
func (client AppsClient) ListConnectionStringsSlot(ctx context.Context, resourceGroupName string, name string, slot string) (result ConnectionStringDictionary, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/AppsClient.ListConnectionStringsSlot")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewError("web.AppsClient", "ListConnectionStringsSlot", err.Error())
	}

	req, err := client.ListConnectionStringsSlotPreparer(ctx, resourceGroupName, name, slot)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "ListConnectionStringsSlot", nil, "Failure preparing request")
		return
	}

	resp, err := client.ListConnectionStringsSlotSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.AppsClient", "ListConnectionStringsSlot", resp, "Failure sending request")
		return
	}

	result, err = client.ListConnectionStringsSlotResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "ListConnectionStringsSlot", resp, "Failure responding to request")
	}

	return
}

// ListConnectionStringsSlotPreparer prepares the ListConnectionStringsSlot request.
func (client AppsClient) ListConnectionStringsSlotPreparer(ctx context.Context, resourceGroupName string, name string, slot string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"slot":              autorest.Encode("path", slot),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2019-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsPost(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/config/connectionstrings/list", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// ListConnectionStringsSlotSender sends the ListConnectionStringsSlot request. The method will close the
// http.Response Body if it receives an error.
func (client AppsClient) ListConnectionStringsSlotSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// ListConnectionStringsSlotResponder handles the response to the ListConnectionStringsSlot request. The method always
// closes the http.Response Body.
func (client AppsClient) ListConnectionStringsSlotResponder(resp *http.Response) (result ConnectionStringDictionary, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// ListContinuousWebJobs description for List continuous web jobs for an app, or a deployment slot.
// Parameters:
// resourceGroupName - name of the resource group to which the resource belongs.
// name - site name.
func (client AppsClient) ListContinuousWebJobs(ctx context.Context, resourceGroupName string, name string) (result ContinuousWebJobCollectionPage, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/AppsClient.ListContinuousWebJobs")
		defer func() {
			sc := -1
			if result.cwjc.Response.Response != nil {
				sc = result.cwjc.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewError("web.AppsClient", "ListContinuousWebJobs", err.Error())
	}

	result.fn = client.listContinuousWebJobsNextResults
	req, err := client.ListContinuousWebJobsPreparer(ctx, resourceGroupName, name)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "ListContinuousWebJobs", nil, "Failure preparing request")
		return
	}

	resp, err := client.ListContinuousWebJobsSender(req)
	if err != nil {
		result.cwjc.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.AppsClient", "ListContinuousWebJobs", resp, "Failure sending request")
		return
	}

	result.cwjc, err = client.ListContinuousWebJobsResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "ListContinuousWebJobs", resp, "Failure responding to request")
	}

	return
}

// ListContinuousWebJobsPreparer prepares the ListContinuousWebJobs request.
func (client AppsClient) ListContinuousWebJobsPreparer(ctx context.Context, resourceGroupName string, name string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2019-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/continuouswebjobs", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// ListContinuousWebJobsSender sends the ListContinuousWebJobs request. The method will close the
// http.Response Body if it receives an error.
func (client AppsClient) ListContinuousWebJobsSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// ListContinuousWebJobsResponder handles the response to the ListContinuousWebJobs request. The method always
// closes the http.Response Body.
func (client AppsClient) ListContinuousWebJobsResponder(resp *http.Response) (result ContinuousWebJobCollection, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// listContinuousWebJobsNextResults retrieves the next set of results, if any.
func (client AppsClient) listContinuousWebJobsNextResults(ctx context.Context, lastResults ContinuousWebJobCollection) (result ContinuousWebJobCollection, err error) {
	req, err := lastResults.continuousWebJobCollectionPreparer(ctx)
	if err != nil {
		return result, autorest.NewErrorWithError(err, "web.AppsClient", "listContinuousWebJobsNextResults", nil, "Failure preparing next results request")
	}
	if req == nil {
		return
	}
	resp, err := client.ListContinuousWebJobsSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		return result, autorest.NewErrorWithError(err, "web.AppsClient", "listContinuousWebJobsNextResults", resp, "Failure sending next results request")
	}
	result, err = client.ListContinuousWebJobsResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "listContinuousWebJobsNextResults", resp, "Failure responding to next results request")
	}
	return
}

// ListContinuousWebJobsComplete enumerates all values, automatically crossing page boundaries as required.
func (client AppsClient) ListContinuousWebJobsComplete(ctx context.Context, resourceGroupName string, name string) (result ContinuousWebJobCollectionIterator, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/AppsClient.ListContinuousWebJobs")
		defer func() {
			sc := -1
			if result.Response().Response.Response != nil {
				sc = result.page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	result.page, err = client.ListContinuousWebJobs(ctx, resourceGroupName, name)
	return
}

// ListContinuousWebJobsSlot description for List continuous web jobs for an app, or a deployment slot.
// Parameters:
// resourceGroupName - name of the resource group to which the resource belongs.
// name - site name.
// slot - name of the deployment slot. If a slot is not specified, the API deletes a deployment for the
// production slot.
func (client AppsClient) ListContinuousWebJobsSlot(ctx context.Context, resourceGroupName string, name string, slot string) (result ContinuousWebJobCollectionPage, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/AppsClient.ListContinuousWebJobsSlot")
		defer func() {
			sc := -1
			if result.cwjc.Response.Response != nil {
				sc = result.cwjc.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewError("web.AppsClient", "ListContinuousWebJobsSlot", err.Error())
	}

	result.fn = client.listContinuousWebJobsSlotNextResults
	req, err := client.ListContinuousWebJobsSlotPreparer(ctx, resourceGroupName, name, slot)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "ListContinuousWebJobsSlot", nil, "Failure preparing request")
		return
	}

	resp, err := client.ListContinuousWebJobsSlotSender(req)
	if err != nil {
		result.cwjc.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.AppsClient", "ListContinuousWebJobsSlot", resp, "Failure sending request")
		return
	}

	result.cwjc, err = client.ListContinuousWebJobsSlotResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "ListContinuousWebJobsSlot", resp, "Failure responding to request")
	}

	return
}

// ListContinuousWebJobsSlotPreparer prepares the ListContinuousWebJobsSlot request.
func (client AppsClient) ListContinuousWebJobsSlotPreparer(ctx context.Context, resourceGroupName string, name string, slot string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"slot":              autorest.Encode("path", slot),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2019-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/continuouswebjobs", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// ListContinuousWebJobsSlotSender sends the ListContinuousWebJobsSlot request. The method will close the
// http.Response Body if it receives an error.
func (client AppsClient) ListContinuousWebJobsSlotSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// ListContinuousWebJobsSlotResponder handles the response to the ListContinuousWebJobsSlot request. The method always
// closes the http.Response Body.
func (client AppsClient) ListContinuousWebJobsSlotResponder(resp *http.Response) (result ContinuousWebJobCollection, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// listContinuousWebJobsSlotNextResults retrieves the next set of results, if any.
func (client AppsClient) listContinuousWebJobsSlotNextResults(ctx context.Context, lastResults ContinuousWebJobCollection) (result ContinuousWebJobCollection, err error) {
	req, err := lastResults.continuousWebJobCollectionPreparer(ctx)
	if err != nil {
		return result, autorest.NewErrorWithError(err, "web.AppsClient", "listContinuousWebJobsSlotNextResults", nil, "Failure preparing next results request")
	}
	if req == nil {
		return
	}
	resp, err := client.ListContinuousWebJobsSlotSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		return result, autorest.NewErrorWithError(err, "web.AppsClient", "listContinuousWebJobsSlotNextResults", resp, "Failure sending next results request")
	}
	result, err = client.ListContinuousWebJobsSlotResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "listContinuousWebJobsSlotNextResults", resp, "Failure responding to next results request")
	}
	return
}

// ListContinuousWebJobsSlotComplete enumerates all values, automatically crossing page boundaries as required.
func (client AppsClient) ListContinuousWebJobsSlotComplete(ctx context.Context, resourceGroupName string, name string, slot string) (result ContinuousWebJobCollectionIterator, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/AppsClient.ListContinuousWebJobsSlot")
		defer func() {
			sc := -1
			if result.Response().Response.Response != nil {
				sc = result.page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	result.page, err = client.ListContinuousWebJobsSlot(ctx, resourceGroupName, name, slot)
	return
}

// ListDeploymentLog description for List deployment log for specific deployment for an app, or a deployment slot.
// Parameters:
// resourceGroupName - name of the resource group to which the resource belongs.
// name - name of the app.
// ID - the ID of a specific deployment. This is the value of the name property in the JSON response from "GET
// /api/sites/{siteName}/deployments".
func (client AppsClient) ListDeploymentLog(ctx context.Context, resourceGroupName string, name string, ID string) (result Deployment, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/AppsClient.ListDeploymentLog")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewError("web.AppsClient", "ListDeploymentLog", err.Error())
	}

	req, err := client.ListDeploymentLogPreparer(ctx, resourceGroupName, name, ID)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "ListDeploymentLog", nil, "Failure preparing request")
		return
	}

	resp, err := client.ListDeploymentLogSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.AppsClient", "ListDeploymentLog", resp, "Failure sending request")
		return
	}

	result, err = client.ListDeploymentLogResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "ListDeploymentLog", resp, "Failure responding to request")
	}

	return
}

// ListDeploymentLogPreparer prepares the ListDeploymentLog request.
func (client AppsClient) ListDeploymentLogPreparer(ctx context.Context, resourceGroupName string, name string, ID string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"id":                autorest.Encode("path", ID),
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2019-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/deployments/{id}/log", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// ListDeploymentLogSender sends the ListDeploymentLog request. The method will close the
// http.Response Body if it receives an error.
func (client AppsClient) ListDeploymentLogSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// ListDeploymentLogResponder handles the response to the ListDeploymentLog request. The method always
// closes the http.Response Body.
func (client AppsClient) ListDeploymentLogResponder(resp *http.Response) (result Deployment, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// ListDeploymentLogSlot description for List deployment log for specific deployment for an app, or a deployment slot.
// Parameters:
// resourceGroupName - name of the resource group to which the resource belongs.
// name - name of the app.
// ID - the ID of a specific deployment. This is the value of the name property in the JSON response from "GET
// /api/sites/{siteName}/deployments".
// slot - name of the deployment slot. If a slot is not specified, the API returns deployments for the
// production slot.
func (client AppsClient) ListDeploymentLogSlot(ctx context.Context, resourceGroupName string, name string, ID string, slot string) (result Deployment, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/AppsClient.ListDeploymentLogSlot")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewError("web.AppsClient", "ListDeploymentLogSlot", err.Error())
	}

	req, err := client.ListDeploymentLogSlotPreparer(ctx, resourceGroupName, name, ID, slot)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "ListDeploymentLogSlot", nil, "Failure preparing request")
		return
	}

	resp, err := client.ListDeploymentLogSlotSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.AppsClient", "ListDeploymentLogSlot", resp, "Failure sending request")
		return
	}

	result, err = client.ListDeploymentLogSlotResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "ListDeploymentLogSlot", resp, "Failure responding to request")
	}

	return
}

// ListDeploymentLogSlotPreparer prepares the ListDeploymentLogSlot request.
func (client AppsClient) ListDeploymentLogSlotPreparer(ctx context.Context, resourceGroupName string, name string, ID string, slot string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"id":                autorest.Encode("path", ID),
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"slot":              autorest.Encode("path", slot),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2019-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/deployments/{id}/log", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// ListDeploymentLogSlotSender sends the ListDeploymentLogSlot request. The method will close the
// http.Response Body if it receives an error.
func (client AppsClient) ListDeploymentLogSlotSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// ListDeploymentLogSlotResponder handles the response to the ListDeploymentLogSlot request. The method always
// closes the http.Response Body.
func (client AppsClient) ListDeploymentLogSlotResponder(resp *http.Response) (result Deployment, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// ListDeployments description for List deployments for an app, or a deployment slot.
// Parameters:
// resourceGroupName - name of the resource group to which the resource belongs.
// name - name of the app.
func (client AppsClient) ListDeployments(ctx context.Context, resourceGroupName string, name string) (result DeploymentCollectionPage, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/AppsClient.ListDeployments")
		defer func() {
			sc := -1
			if result.dc.Response.Response != nil {
				sc = result.dc.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewError("web.AppsClient", "ListDeployments", err.Error())
	}

	result.fn = client.listDeploymentsNextResults
	req, err := client.ListDeploymentsPreparer(ctx, resourceGroupName, name)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "ListDeployments", nil, "Failure preparing request")
		return
	}

	resp, err := client.ListDeploymentsSender(req)
	if err != nil {
		result.dc.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.AppsClient", "ListDeployments", resp, "Failure sending request")
		return
	}

	result.dc, err = client.ListDeploymentsResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "ListDeployments", resp, "Failure responding to request")
	}

	return
}

// ListDeploymentsPreparer prepares the ListDeployments request.
func (client AppsClient) ListDeploymentsPreparer(ctx context.Context, resourceGroupName string, name string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2019-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/deployments", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// ListDeploymentsSender sends the ListDeployments request. The method will close the
// http.Response Body if it receives an error.
func (client AppsClient) ListDeploymentsSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// ListDeploymentsResponder handles the response to the ListDeployments request. The method always
// closes the http.Response Body.
func (client AppsClient) ListDeploymentsResponder(resp *http.Response) (result DeploymentCollection, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// listDeploymentsNextResults retrieves the next set of results, if any.
func (client AppsClient) listDeploymentsNextResults(ctx context.Context, lastResults DeploymentCollection) (result DeploymentCollection, err error) {
	req, err := lastResults.deploymentCollectionPreparer(ctx)
	if err != nil {
		return result, autorest.NewErrorWithError(err, "web.AppsClient", "listDeploymentsNextResults", nil, "Failure preparing next results request")
	}
	if req == nil {
		return
	}
	resp, err := client.ListDeploymentsSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		return result, autorest.NewErrorWithError(err, "web.AppsClient", "listDeploymentsNextResults", resp, "Failure sending next results request")
	}
	result, err = client.ListDeploymentsResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "listDeploymentsNextResults", resp, "Failure responding to next results request")
	}
	return
}

// ListDeploymentsComplete enumerates all values, automatically crossing page boundaries as required.
func (client AppsClient) ListDeploymentsComplete(ctx context.Context, resourceGroupName string, name string) (result DeploymentCollectionIterator, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/AppsClient.ListDeployments")
		defer func() {
			sc := -1
			if result.Response().Response.Response != nil {
				sc = result.page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	result.page, err = client.ListDeployments(ctx, resourceGroupName, name)
	return
}

// ListDeploymentsSlot description for List deployments for an app, or a deployment slot.
// Parameters:
// resourceGroupName - name of the resource group to which the resource belongs.
// name - name of the app.
// slot - name of the deployment slot. If a slot is not specified, the API returns deployments for the
// production slot.
func (client AppsClient) ListDeploymentsSlot(ctx context.Context, resourceGroupName string, name string, slot string) (result DeploymentCollectionPage, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/AppsClient.ListDeploymentsSlot")
		defer func() {
			sc := -1
			if result.dc.Response.Response != nil {
				sc = result.dc.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewError("web.AppsClient", "ListDeploymentsSlot", err.Error())
	}

	result.fn = client.listDeploymentsSlotNextResults
	req, err := client.ListDeploymentsSlotPreparer(ctx, resourceGroupName, name, slot)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "ListDeploymentsSlot", nil, "Failure preparing request")
		return
	}

	resp, err := client.ListDeploymentsSlotSender(req)
	if err != nil {
		result.dc.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.AppsClient", "ListDeploymentsSlot", resp, "Failure sending request")
		return
	}

	result.dc, err = client.ListDeploymentsSlotResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "ListDeploymentsSlot", resp, "Failure responding to request")
	}

	return
}

// ListDeploymentsSlotPreparer prepares the ListDeploymentsSlot request.
func (client AppsClient) ListDeploymentsSlotPreparer(ctx context.Context, resourceGroupName string, name string, slot string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"slot":              autorest.Encode("path", slot),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2019-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/deployments", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// ListDeploymentsSlotSender sends the ListDeploymentsSlot request. The method will close the
// http.Response Body if it receives an error.
func (client AppsClient) ListDeploymentsSlotSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// ListDeploymentsSlotResponder handles the response to the ListDeploymentsSlot request. The method always
// closes the http.Response Body.
func (client AppsClient) ListDeploymentsSlotResponder(resp *http.Response) (result DeploymentCollection, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// listDeploymentsSlotNextResults retrieves the next set of results, if any.
func (client AppsClient) listDeploymentsSlotNextResults(ctx context.Context, lastResults DeploymentCollection) (result DeploymentCollection, err error) {
	req, err := lastResults.deploymentCollectionPreparer(ctx)
	if err != nil {
		return result, autorest.NewErrorWithError(err, "web.AppsClient", "listDeploymentsSlotNextResults", nil, "Failure preparing next results request")
	}
	if req == nil {
		return
	}
	resp, err := client.ListDeploymentsSlotSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		return result, autorest.NewErrorWithError(err, "web.AppsClient", "listDeploymentsSlotNextResults", resp, "Failure sending next results request")
	}
	result, err = client.ListDeploymentsSlotResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "listDeploymentsSlotNextResults", resp, "Failure responding to next results request")
	}
	return
}

// ListDeploymentsSlotComplete enumerates all values, automatically crossing page boundaries as required.
func (client AppsClient) ListDeploymentsSlotComplete(ctx context.Context, resourceGroupName string, name string, slot string) (result DeploymentCollectionIterator, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/AppsClient.ListDeploymentsSlot")
		defer func() {
			sc := -1
			if result.Response().Response.Response != nil {
				sc = result.page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	result.page, err = client.ListDeploymentsSlot(ctx, resourceGroupName, name, slot)
	return
}

// ListDomainOwnershipIdentifiers description for Lists ownership identifiers for domain associated with web app.
// Parameters:
// resourceGroupName - name of the resource group to which the resource belongs.
// name - name of the app.
func (client AppsClient) ListDomainOwnershipIdentifiers(ctx context.Context, resourceGroupName string, name string) (result IdentifierCollectionPage, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/AppsClient.ListDomainOwnershipIdentifiers")
		defer func() {
			sc := -1
			if result.ic.Response.Response != nil {
				sc = result.ic.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewError("web.AppsClient", "ListDomainOwnershipIdentifiers", err.Error())
	}

	result.fn = client.listDomainOwnershipIdentifiersNextResults
	req, err := client.ListDomainOwnershipIdentifiersPreparer(ctx, resourceGroupName, name)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "ListDomainOwnershipIdentifiers", nil, "Failure preparing request")
		return
	}

	resp, err := client.ListDomainOwnershipIdentifiersSender(req)
	if err != nil {
		result.ic.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.AppsClient", "ListDomainOwnershipIdentifiers", resp, "Failure sending request")
		return
	}

	result.ic, err = client.ListDomainOwnershipIdentifiersResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "ListDomainOwnershipIdentifiers", resp, "Failure responding to request")
	}

	return
}

// ListDomainOwnershipIdentifiersPreparer prepares the ListDomainOwnershipIdentifiers request.
func (client AppsClient) ListDomainOwnershipIdentifiersPreparer(ctx context.Context, resourceGroupName string, name string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2019-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/domainOwnershipIdentifiers", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// ListDomainOwnershipIdentifiersSender sends the ListDomainOwnershipIdentifiers request. The method will close the
// http.Response Body if it receives an error.
func (client AppsClient) ListDomainOwnershipIdentifiersSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// ListDomainOwnershipIdentifiersResponder handles the response to the ListDomainOwnershipIdentifiers request. The method always
// closes the http.Response Body.
func (client AppsClient) ListDomainOwnershipIdentifiersResponder(resp *http.Response) (result IdentifierCollection, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// listDomainOwnershipIdentifiersNextResults retrieves the next set of results, if any.
func (client AppsClient) listDomainOwnershipIdentifiersNextResults(ctx context.Context, lastResults IdentifierCollection) (result IdentifierCollection, err error) {
	req, err := lastResults.identifierCollectionPreparer(ctx)
	if err != nil {
		return result, autorest.NewErrorWithError(err, "web.AppsClient", "listDomainOwnershipIdentifiersNextResults", nil, "Failure preparing next results request")
	}
	if req == nil {
		return
	}
	resp, err := client.ListDomainOwnershipIdentifiersSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		return result, autorest.NewErrorWithError(err, "web.AppsClient", "listDomainOwnershipIdentifiersNextResults", resp, "Failure sending next results request")
	}
	result, err = client.ListDomainOwnershipIdentifiersResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "listDomainOwnershipIdentifiersNextResults", resp, "Failure responding to next results request")
	}
	return
}

// ListDomainOwnershipIdentifiersComplete enumerates all values, automatically crossing page boundaries as required.
func (client AppsClient) ListDomainOwnershipIdentifiersComplete(ctx context.Context, resourceGroupName string, name string) (result IdentifierCollectionIterator, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/AppsClient.ListDomainOwnershipIdentifiers")
		defer func() {
			sc := -1
			if result.Response().Response.Response != nil {
				sc = result.page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	result.page, err = client.ListDomainOwnershipIdentifiers(ctx, resourceGroupName, name)
	return
}

// ListDomainOwnershipIdentifiersSlot description for Lists ownership identifiers for domain associated with web app.
// Parameters:
// resourceGroupName - name of the resource group to which the resource belongs.
// name - name of the app.
// slot - name of the deployment slot. If a slot is not specified, the API will delete the binding for the
// production slot.
func (client AppsClient) ListDomainOwnershipIdentifiersSlot(ctx context.Context, resourceGroupName string, name string, slot string) (result IdentifierCollectionPage, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/AppsClient.ListDomainOwnershipIdentifiersSlot")
		defer func() {
			sc := -1
			if result.ic.Response.Response != nil {
				sc = result.ic.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewError("web.AppsClient", "ListDomainOwnershipIdentifiersSlot", err.Error())
	}

	result.fn = client.listDomainOwnershipIdentifiersSlotNextResults
	req, err := client.ListDomainOwnershipIdentifiersSlotPreparer(ctx, resourceGroupName, name, slot)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "ListDomainOwnershipIdentifiersSlot", nil, "Failure preparing request")
		return
	}

	resp, err := client.ListDomainOwnershipIdentifiersSlotSender(req)
	if err != nil {
		result.ic.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.AppsClient", "ListDomainOwnershipIdentifiersSlot", resp, "Failure sending request")
		return
	}

	result.ic, err = client.ListDomainOwnershipIdentifiersSlotResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "ListDomainOwnershipIdentifiersSlot", resp, "Failure responding to request")
	}

	return
}

// ListDomainOwnershipIdentifiersSlotPreparer prepares the ListDomainOwnershipIdentifiersSlot request.
func (client AppsClient) ListDomainOwnershipIdentifiersSlotPreparer(ctx context.Context, resourceGroupName string, name string, slot string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"slot":              autorest.Encode("path", slot),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2019-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/domainOwnershipIdentifiers", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// ListDomainOwnershipIdentifiersSlotSender sends the ListDomainOwnershipIdentifiersSlot request. The method will close the
// http.Response Body if it receives an error.
func (client AppsClient) ListDomainOwnershipIdentifiersSlotSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// ListDomainOwnershipIdentifiersSlotResponder handles the response to the ListDomainOwnershipIdentifiersSlot request. The method always
// closes the http.Response Body.
func (client AppsClient) ListDomainOwnershipIdentifiersSlotResponder(resp *http.Response) (result IdentifierCollection, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// listDomainOwnershipIdentifiersSlotNextResults retrieves the next set of results, if any.
func (client AppsClient) listDomainOwnershipIdentifiersSlotNextResults(ctx context.Context, lastResults IdentifierCollection) (result IdentifierCollection, err error) {
	req, err := lastResults.identifierCollectionPreparer(ctx)
	if err != nil {
		return result, autorest.NewErrorWithError(err, "web.AppsClient", "listDomainOwnershipIdentifiersSlotNextResults", nil, "Failure preparing next results request")
	}
	if req == nil {
		return
	}
	resp, err := client.ListDomainOwnershipIdentifiersSlotSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		return result, autorest.NewErrorWithError(err, "web.AppsClient", "listDomainOwnershipIdentifiersSlotNextResults", resp, "Failure sending next results request")
	}
	result, err = client.ListDomainOwnershipIdentifiersSlotResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "listDomainOwnershipIdentifiersSlotNextResults", resp, "Failure responding to next results request")
	}
	return
}

// ListDomainOwnershipIdentifiersSlotComplete enumerates all values, automatically crossing page boundaries as required.
func (client AppsClient) ListDomainOwnershipIdentifiersSlotComplete(ctx context.Context, resourceGroupName string, name string, slot string) (result IdentifierCollectionIterator, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/AppsClient.ListDomainOwnershipIdentifiersSlot")
		defer func() {
			sc := -1
			if result.Response().Response.Response != nil {
				sc = result.page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	result.page, err = client.ListDomainOwnershipIdentifiersSlot(ctx, resourceGroupName, name, slot)
	return
}

// ListFunctionKeys description for Get function keys for a function in a web site, or a deployment slot.
// Parameters:
// resourceGroupName - name of the resource group to which the resource belongs.
// name - site name.
// functionName - function name.
func (client AppsClient) ListFunctionKeys(ctx context.Context, resourceGroupName string, name string, functionName string) (result StringDictionary, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/AppsClient.ListFunctionKeys")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewError("web.AppsClient", "ListFunctionKeys", err.Error())
	}

	req, err := client.ListFunctionKeysPreparer(ctx, resourceGroupName, name, functionName)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "ListFunctionKeys", nil, "Failure preparing request")
		return
	}

	resp, err := client.ListFunctionKeysSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.AppsClient", "ListFunctionKeys", resp, "Failure sending request")
		return
	}

	result, err = client.ListFunctionKeysResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "ListFunctionKeys", resp, "Failure responding to request")
	}

	return
}

// ListFunctionKeysPreparer prepares the ListFunctionKeys request.
func (client AppsClient) ListFunctionKeysPreparer(ctx context.Context, resourceGroupName string, name string, functionName string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"functionName":      autorest.Encode("path", functionName),
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2019-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsPost(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/functions/{functionName}/listkeys", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// ListFunctionKeysSender sends the ListFunctionKeys request. The method will close the
// http.Response Body if it receives an error.
func (client AppsClient) ListFunctionKeysSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// ListFunctionKeysResponder handles the response to the ListFunctionKeys request. The method always
// closes the http.Response Body.
func (client AppsClient) ListFunctionKeysResponder(resp *http.Response) (result StringDictionary, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// ListFunctionKeysSlot description for Get function keys for a function in a web site, or a deployment slot.
// Parameters:
// resourceGroupName - name of the resource group to which the resource belongs.
// name - site name.
// functionName - function name.
// slot - name of the deployment slot.
func (client AppsClient) ListFunctionKeysSlot(ctx context.Context, resourceGroupName string, name string, functionName string, slot string) (result StringDictionary, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/AppsClient.ListFunctionKeysSlot")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewError("web.AppsClient", "ListFunctionKeysSlot", err.Error())
	}

	req, err := client.ListFunctionKeysSlotPreparer(ctx, resourceGroupName, name, functionName, slot)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "ListFunctionKeysSlot", nil, "Failure preparing request")
		return
	}

	resp, err := client.ListFunctionKeysSlotSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.AppsClient", "ListFunctionKeysSlot", resp, "Failure sending request")
		return
	}

	result, err = client.ListFunctionKeysSlotResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "ListFunctionKeysSlot", resp, "Failure responding to request")
	}

	return
}

// ListFunctionKeysSlotPreparer prepares the ListFunctionKeysSlot request.
func (client AppsClient) ListFunctionKeysSlotPreparer(ctx context.Context, resourceGroupName string, name string, functionName string, slot string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"functionName":      autorest.Encode("path", functionName),
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"slot":              autorest.Encode("path", slot),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2019-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsPost(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/functions/{functionName}/listkeys", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// ListFunctionKeysSlotSender sends the ListFunctionKeysSlot request. The method will close the
// http.Response Body if it receives an error.
func (client AppsClient) ListFunctionKeysSlotSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// ListFunctionKeysSlotResponder handles the response to the ListFunctionKeysSlot request. The method always
// closes the http.Response Body.
func (client AppsClient) ListFunctionKeysSlotResponder(resp *http.Response) (result StringDictionary, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// ListFunctions description for List the functions for a web site, or a deployment slot.
// Parameters:
// resourceGroupName - name of the resource group to which the resource belongs.
// name - site name.
func (client AppsClient) ListFunctions(ctx context.Context, resourceGroupName string, name string) (result FunctionEnvelopeCollectionPage, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/AppsClient.ListFunctions")
		defer func() {
			sc := -1
			if result.fec.Response.Response != nil {
				sc = result.fec.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewError("web.AppsClient", "ListFunctions", err.Error())
	}

	result.fn = client.listFunctionsNextResults
	req, err := client.ListFunctionsPreparer(ctx, resourceGroupName, name)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "ListFunctions", nil, "Failure preparing request")
		return
	}

	resp, err := client.ListFunctionsSender(req)
	if err != nil {
		result.fec.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.AppsClient", "ListFunctions", resp, "Failure sending request")
		return
	}

	result.fec, err = client.ListFunctionsResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "ListFunctions", resp, "Failure responding to request")
	}

	return
}

// ListFunctionsPreparer prepares the ListFunctions request.
func (client AppsClient) ListFunctionsPreparer(ctx context.Context, resourceGroupName string, name string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2019-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/functions", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// ListFunctionsSender sends the ListFunctions request. The method will close the
// http.Response Body if it receives an error.
func (client AppsClient) ListFunctionsSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// ListFunctionsResponder handles the response to the ListFunctions request. The method always
// closes the http.Response Body.
func (client AppsClient) ListFunctionsResponder(resp *http.Response) (result FunctionEnvelopeCollection, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusNotFound),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// listFunctionsNextResults retrieves the next set of results, if any.
func (client AppsClient) listFunctionsNextResults(ctx context.Context, lastResults FunctionEnvelopeCollection) (result FunctionEnvelopeCollection, err error) {
	req, err := lastResults.functionEnvelopeCollectionPreparer(ctx)
	if err != nil {
		return result, autorest.NewErrorWithError(err, "web.AppsClient", "listFunctionsNextResults", nil, "Failure preparing next results request")
	}
	if req == nil {
		return
	}
	resp, err := client.ListFunctionsSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		return result, autorest.NewErrorWithError(err, "web.AppsClient", "listFunctionsNextResults", resp, "Failure sending next results request")
	}
	result, err = client.ListFunctionsResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "listFunctionsNextResults", resp, "Failure responding to next results request")
	}
	return
}

// ListFunctionsComplete enumerates all values, automatically crossing page boundaries as required.
func (client AppsClient) ListFunctionsComplete(ctx context.Context, resourceGroupName string, name string) (result FunctionEnvelopeCollectionIterator, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/AppsClient.ListFunctions")
		defer func() {
			sc := -1
			if result.Response().Response.Response != nil {
				sc = result.page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	result.page, err = client.ListFunctions(ctx, resourceGroupName, name)
	return
}

// ListFunctionSecrets description for Get function secrets for a function in a web site, or a deployment slot.
// Parameters:
// resourceGroupName - name of the resource group to which the resource belongs.
// name - site name.
// functionName - function name.
func (client AppsClient) ListFunctionSecrets(ctx context.Context, resourceGroupName string, name string, functionName string) (result FunctionSecrets, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/AppsClient.ListFunctionSecrets")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewError("web.AppsClient", "ListFunctionSecrets", err.Error())
	}

	req, err := client.ListFunctionSecretsPreparer(ctx, resourceGroupName, name, functionName)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "ListFunctionSecrets", nil, "Failure preparing request")
		return
	}

	resp, err := client.ListFunctionSecretsSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.AppsClient", "ListFunctionSecrets", resp, "Failure sending request")
		return
	}

	result, err = client.ListFunctionSecretsResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "ListFunctionSecrets", resp, "Failure responding to request")
	}

	return
}

// ListFunctionSecretsPreparer prepares the ListFunctionSecrets request.
func (client AppsClient) ListFunctionSecretsPreparer(ctx context.Context, resourceGroupName string, name string, functionName string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"functionName":      autorest.Encode("path", functionName),
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2019-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsPost(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/functions/{functionName}/listsecrets", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// ListFunctionSecretsSender sends the ListFunctionSecrets request. The method will close the
// http.Response Body if it receives an error.
func (client AppsClient) ListFunctionSecretsSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// ListFunctionSecretsResponder handles the response to the ListFunctionSecrets request. The method always
// closes the http.Response Body.
func (client AppsClient) ListFunctionSecretsResponder(resp *http.Response) (result FunctionSecrets, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// ListFunctionSecretsSlot description for Get function secrets for a function in a web site, or a deployment slot.
// Parameters:
// resourceGroupName - name of the resource group to which the resource belongs.
// name - site name.
// functionName - function name.
// slot - name of the deployment slot.
func (client AppsClient) ListFunctionSecretsSlot(ctx context.Context, resourceGroupName string, name string, functionName string, slot string) (result FunctionSecrets, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/AppsClient.ListFunctionSecretsSlot")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewError("web.AppsClient", "ListFunctionSecretsSlot", err.Error())
	}

	req, err := client.ListFunctionSecretsSlotPreparer(ctx, resourceGroupName, name, functionName, slot)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "ListFunctionSecretsSlot", nil, "Failure preparing request")
		return
	}

	resp, err := client.ListFunctionSecretsSlotSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.AppsClient", "ListFunctionSecretsSlot", resp, "Failure sending request")
		return
	}

	result, err = client.ListFunctionSecretsSlotResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "ListFunctionSecretsSlot", resp, "Failure responding to request")
	}

	return
}

// ListFunctionSecretsSlotPreparer prepares the ListFunctionSecretsSlot request.
func (client AppsClient) ListFunctionSecretsSlotPreparer(ctx context.Context, resourceGroupName string, name string, functionName string, slot string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"functionName":      autorest.Encode("path", functionName),
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"slot":              autorest.Encode("path", slot),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2019-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsPost(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/functions/{functionName}/listsecrets", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// ListFunctionSecretsSlotSender sends the ListFunctionSecretsSlot request. The method will close the
// http.Response Body if it receives an error.
func (client AppsClient) ListFunctionSecretsSlotSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// ListFunctionSecretsSlotResponder handles the response to the ListFunctionSecretsSlot request. The method always
// closes the http.Response Body.
func (client AppsClient) ListFunctionSecretsSlotResponder(resp *http.Response) (result FunctionSecrets, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// ListHostKeys description for Get host secrets for a function app.
// Parameters:
// resourceGroupName - name of the resource group to which the resource belongs.
// name - site name.
func (client AppsClient) ListHostKeys(ctx context.Context, resourceGroupName string, name string) (result HostKeys, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/AppsClient.ListHostKeys")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewError("web.AppsClient", "ListHostKeys", err.Error())
	}

	req, err := client.ListHostKeysPreparer(ctx, resourceGroupName, name)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "ListHostKeys", nil, "Failure preparing request")
		return
	}

	resp, err := client.ListHostKeysSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.AppsClient", "ListHostKeys", resp, "Failure sending request")
		return
	}

	result, err = client.ListHostKeysResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "ListHostKeys", resp, "Failure responding to request")
	}

	return
}

// ListHostKeysPreparer prepares the ListHostKeys request.
func (client AppsClient) ListHostKeysPreparer(ctx context.Context, resourceGroupName string, name string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2019-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsPost(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/host/default/listkeys", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// ListHostKeysSender sends the ListHostKeys request. The method will close the
// http.Response Body if it receives an error.
func (client AppsClient) ListHostKeysSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// ListHostKeysResponder handles the response to the ListHostKeys request. The method always
// closes the http.Response Body.
func (client AppsClient) ListHostKeysResponder(resp *http.Response) (result HostKeys, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// ListHostKeysSlot description for Get host secrets for a function app.
// Parameters:
// resourceGroupName - name of the resource group to which the resource belongs.
// name - site name.
// slot - name of the deployment slot.
func (client AppsClient) ListHostKeysSlot(ctx context.Context, resourceGroupName string, name string, slot string) (result HostKeys, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/AppsClient.ListHostKeysSlot")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewError("web.AppsClient", "ListHostKeysSlot", err.Error())
	}

	req, err := client.ListHostKeysSlotPreparer(ctx, resourceGroupName, name, slot)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "ListHostKeysSlot", nil, "Failure preparing request")
		return
	}

	resp, err := client.ListHostKeysSlotSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.AppsClient", "ListHostKeysSlot", resp, "Failure sending request")
		return
	}

	result, err = client.ListHostKeysSlotResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "ListHostKeysSlot", resp, "Failure responding to request")
	}

	return
}

// ListHostKeysSlotPreparer prepares the ListHostKeysSlot request.
func (client AppsClient) ListHostKeysSlotPreparer(ctx context.Context, resourceGroupName string, name string, slot string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"slot":              autorest.Encode("path", slot),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2019-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsPost(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/host/default/listkeys", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// ListHostKeysSlotSender sends the ListHostKeysSlot request. The method will close the
// http.Response Body if it receives an error.
func (client AppsClient) ListHostKeysSlotSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// ListHostKeysSlotResponder handles the response to the ListHostKeysSlot request. The method always
// closes the http.Response Body.
func (client AppsClient) ListHostKeysSlotResponder(resp *http.Response) (result HostKeys, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// ListHostNameBindings description for Get hostname bindings for an app or a deployment slot.
// Parameters:
// resourceGroupName - name of the resource group to which the resource belongs.
// name - name of the app.
func (client AppsClient) ListHostNameBindings(ctx context.Context, resourceGroupName string, name string) (result HostNameBindingCollectionPage, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/AppsClient.ListHostNameBindings")
		defer func() {
			sc := -1
			if result.hnbc.Response.Response != nil {
				sc = result.hnbc.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewError("web.AppsClient", "ListHostNameBindings", err.Error())
	}

	result.fn = client.listHostNameBindingsNextResults
	req, err := client.ListHostNameBindingsPreparer(ctx, resourceGroupName, name)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "ListHostNameBindings", nil, "Failure preparing request")
		return
	}

	resp, err := client.ListHostNameBindingsSender(req)
	if err != nil {
		result.hnbc.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.AppsClient", "ListHostNameBindings", resp, "Failure sending request")
		return
	}

	result.hnbc, err = client.ListHostNameBindingsResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "ListHostNameBindings", resp, "Failure responding to request")
	}

	return
}

// ListHostNameBindingsPreparer prepares the ListHostNameBindings request.
func (client AppsClient) ListHostNameBindingsPreparer(ctx context.Context, resourceGroupName string, name string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2019-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/hostNameBindings", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// ListHostNameBindingsSender sends the ListHostNameBindings request. The method will close the
// http.Response Body if it receives an error.
func (client AppsClient) ListHostNameBindingsSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// ListHostNameBindingsResponder handles the response to the ListHostNameBindings request. The method always
// closes the http.Response Body.
func (client AppsClient) ListHostNameBindingsResponder(resp *http.Response) (result HostNameBindingCollection, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// listHostNameBindingsNextResults retrieves the next set of results, if any.
func (client AppsClient) listHostNameBindingsNextResults(ctx context.Context, lastResults HostNameBindingCollection) (result HostNameBindingCollection, err error) {
	req, err := lastResults.hostNameBindingCollectionPreparer(ctx)
	if err != nil {
		return result, autorest.NewErrorWithError(err, "web.AppsClient", "listHostNameBindingsNextResults", nil, "Failure preparing next results request")
	}
	if req == nil {
		return
	}
	resp, err := client.ListHostNameBindingsSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		return result, autorest.NewErrorWithError(err, "web.AppsClient", "listHostNameBindingsNextResults", resp, "Failure sending next results request")
	}
	result, err = client.ListHostNameBindingsResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "listHostNameBindingsNextResults", resp, "Failure responding to next results request")
	}
	return
}

// ListHostNameBindingsComplete enumerates all values, automatically crossing page boundaries as required.
func (client AppsClient) ListHostNameBindingsComplete(ctx context.Context, resourceGroupName string, name string) (result HostNameBindingCollectionIterator, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/AppsClient.ListHostNameBindings")
		defer func() {
			sc := -1
			if result.Response().Response.Response != nil {
				sc = result.page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	result.page, err = client.ListHostNameBindings(ctx, resourceGroupName, name)
	return
}

// ListHostNameBindingsSlot description for Get hostname bindings for an app or a deployment slot.
// Parameters:
// resourceGroupName - name of the resource group to which the resource belongs.
// name - name of the app.
// slot - name of the deployment slot. If a slot is not specified, the API gets hostname bindings for the
// production slot.
func (client AppsClient) ListHostNameBindingsSlot(ctx context.Context, resourceGroupName string, name string, slot string) (result HostNameBindingCollectionPage, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/AppsClient.ListHostNameBindingsSlot")
		defer func() {
			sc := -1
			if result.hnbc.Response.Response != nil {
				sc = result.hnbc.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewError("web.AppsClient", "ListHostNameBindingsSlot", err.Error())
	}

	result.fn = client.listHostNameBindingsSlotNextResults
	req, err := client.ListHostNameBindingsSlotPreparer(ctx, resourceGroupName, name, slot)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "ListHostNameBindingsSlot", nil, "Failure preparing request")
		return
	}

	resp, err := client.ListHostNameBindingsSlotSender(req)
	if err != nil {
		result.hnbc.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.AppsClient", "ListHostNameBindingsSlot", resp, "Failure sending request")
		return
	}

	result.hnbc, err = client.ListHostNameBindingsSlotResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "ListHostNameBindingsSlot", resp, "Failure responding to request")
	}

	return
}

// ListHostNameBindingsSlotPreparer prepares the ListHostNameBindingsSlot request.
func (client AppsClient) ListHostNameBindingsSlotPreparer(ctx context.Context, resourceGroupName string, name string, slot string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"slot":              autorest.Encode("path", slot),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2019-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/hostNameBindings", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// ListHostNameBindingsSlotSender sends the ListHostNameBindingsSlot request. The method will close the
// http.Response Body if it receives an error.
func (client AppsClient) ListHostNameBindingsSlotSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// ListHostNameBindingsSlotResponder handles the response to the ListHostNameBindingsSlot request. The method always
// closes the http.Response Body.
func (client AppsClient) ListHostNameBindingsSlotResponder(resp *http.Response) (result HostNameBindingCollection, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// listHostNameBindingsSlotNextResults retrieves the next set of results, if any.
func (client AppsClient) listHostNameBindingsSlotNextResults(ctx context.Context, lastResults HostNameBindingCollection) (result HostNameBindingCollection, err error) {
	req, err := lastResults.hostNameBindingCollectionPreparer(ctx)
	if err != nil {
		return result, autorest.NewErrorWithError(err, "web.AppsClient", "listHostNameBindingsSlotNextResults", nil, "Failure preparing next results request")
	}
	if req == nil {
		return
	}
	resp, err := client.ListHostNameBindingsSlotSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		return result, autorest.NewErrorWithError(err, "web.AppsClient", "listHostNameBindingsSlotNextResults", resp, "Failure sending next results request")
	}
	result, err = client.ListHostNameBindingsSlotResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "listHostNameBindingsSlotNextResults", resp, "Failure responding to next results request")
	}
	return
}

// ListHostNameBindingsSlotComplete enumerates all values, automatically crossing page boundaries as required.
func (client AppsClient) ListHostNameBindingsSlotComplete(ctx context.Context, resourceGroupName string, name string, slot string) (result HostNameBindingCollectionIterator, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/AppsClient.ListHostNameBindingsSlot")
		defer func() {
			sc := -1
			if result.Response().Response.Response != nil {
				sc = result.page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	result.page, err = client.ListHostNameBindingsSlot(ctx, resourceGroupName, name, slot)
	return
}

// ListHybridConnections description for Retrieves all Service Bus Hybrid Connections used by this Web App.
// Parameters:
// resourceGroupName - name of the resource group to which the resource belongs.
// name - the name of the web app.
func (client AppsClient) ListHybridConnections(ctx context.Context, resourceGroupName string, name string) (result HybridConnection, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/AppsClient.ListHybridConnections")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewError("web.AppsClient", "ListHybridConnections", err.Error())
	}

	req, err := client.ListHybridConnectionsPreparer(ctx, resourceGroupName, name)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "ListHybridConnections", nil, "Failure preparing request")
		return
	}

	resp, err := client.ListHybridConnectionsSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.AppsClient", "ListHybridConnections", resp, "Failure sending request")
		return
	}

	result, err = client.ListHybridConnectionsResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "ListHybridConnections", resp, "Failure responding to request")
	}

	return
}

// ListHybridConnectionsPreparer prepares the ListHybridConnections request.
func (client AppsClient) ListHybridConnectionsPreparer(ctx context.Context, resourceGroupName string, name string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2019-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/hybridConnectionRelays", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// ListHybridConnectionsSender sends the ListHybridConnections request. The method will close the
// http.Response Body if it receives an error.
func (client AppsClient) ListHybridConnectionsSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// ListHybridConnectionsResponder handles the response to the ListHybridConnections request. The method always
// closes the http.Response Body.
func (client AppsClient) ListHybridConnectionsResponder(resp *http.Response) (result HybridConnection, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// ListHybridConnectionsSlot description for Retrieves all Service Bus Hybrid Connections used by this Web App.
// Parameters:
// resourceGroupName - name of the resource group to which the resource belongs.
// name - the name of the web app.
// slot - the name of the slot for the web app.
func (client AppsClient) ListHybridConnectionsSlot(ctx context.Context, resourceGroupName string, name string, slot string) (result HybridConnection, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/AppsClient.ListHybridConnectionsSlot")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewError("web.AppsClient", "ListHybridConnectionsSlot", err.Error())
	}

	req, err := client.ListHybridConnectionsSlotPreparer(ctx, resourceGroupName, name, slot)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "ListHybridConnectionsSlot", nil, "Failure preparing request")
		return
	}

	resp, err := client.ListHybridConnectionsSlotSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.AppsClient", "ListHybridConnectionsSlot", resp, "Failure sending request")
		return
	}

	result, err = client.ListHybridConnectionsSlotResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "ListHybridConnectionsSlot", resp, "Failure responding to request")
	}

	return
}

// ListHybridConnectionsSlotPreparer prepares the ListHybridConnectionsSlot request.
func (client AppsClient) ListHybridConnectionsSlotPreparer(ctx context.Context, resourceGroupName string, name string, slot string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"slot":              autorest.Encode("path", slot),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2019-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/hybridConnectionRelays", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// ListHybridConnectionsSlotSender sends the ListHybridConnectionsSlot request. The method will close the
// http.Response Body if it receives an error.
func (client AppsClient) ListHybridConnectionsSlotSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// ListHybridConnectionsSlotResponder handles the response to the ListHybridConnectionsSlot request. The method always
// closes the http.Response Body.
func (client AppsClient) ListHybridConnectionsSlotResponder(resp *http.Response) (result HybridConnection, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// ListInstanceFunctionsSlot description for List the functions for a web site, or a deployment slot.
// Parameters:
// resourceGroupName - name of the resource group to which the resource belongs.
// name - site name.
// slot - name of the deployment slot.
func (client AppsClient) ListInstanceFunctionsSlot(ctx context.Context, resourceGroupName string, name string, slot string) (result FunctionEnvelopeCollectionPage, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/AppsClient.ListInstanceFunctionsSlot")
		defer func() {
			sc := -1
			if result.fec.Response.Response != nil {
				sc = result.fec.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewError("web.AppsClient", "ListInstanceFunctionsSlot", err.Error())
	}

	result.fn = client.listInstanceFunctionsSlotNextResults
	req, err := client.ListInstanceFunctionsSlotPreparer(ctx, resourceGroupName, name, slot)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "ListInstanceFunctionsSlot", nil, "Failure preparing request")
		return
	}

	resp, err := client.ListInstanceFunctionsSlotSender(req)
	if err != nil {
		result.fec.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.AppsClient", "ListInstanceFunctionsSlot", resp, "Failure sending request")
		return
	}

	result.fec, err = client.ListInstanceFunctionsSlotResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "ListInstanceFunctionsSlot", resp, "Failure responding to request")
	}

	return
}

// ListInstanceFunctionsSlotPreparer prepares the ListInstanceFunctionsSlot request.
func (client AppsClient) ListInstanceFunctionsSlotPreparer(ctx context.Context, resourceGroupName string, name string, slot string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"slot":              autorest.Encode("path", slot),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2019-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/functions", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// ListInstanceFunctionsSlotSender sends the ListInstanceFunctionsSlot request. The method will close the
// http.Response Body if it receives an error.
func (client AppsClient) ListInstanceFunctionsSlotSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// ListInstanceFunctionsSlotResponder handles the response to the ListInstanceFunctionsSlot request. The method always
// closes the http.Response Body.
func (client AppsClient) ListInstanceFunctionsSlotResponder(resp *http.Response) (result FunctionEnvelopeCollection, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusNotFound),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// listInstanceFunctionsSlotNextResults retrieves the next set of results, if any.
func (client AppsClient) listInstanceFunctionsSlotNextResults(ctx context.Context, lastResults FunctionEnvelopeCollection) (result FunctionEnvelopeCollection, err error) {
	req, err := lastResults.functionEnvelopeCollectionPreparer(ctx)
	if err != nil {
		return result, autorest.NewErrorWithError(err, "web.AppsClient", "listInstanceFunctionsSlotNextResults", nil, "Failure preparing next results request")
	}
	if req == nil {
		return
	}
	resp, err := client.ListInstanceFunctionsSlotSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		return result, autorest.NewErrorWithError(err, "web.AppsClient", "listInstanceFunctionsSlotNextResults", resp, "Failure sending next results request")
	}
	result, err = client.ListInstanceFunctionsSlotResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "listInstanceFunctionsSlotNextResults", resp, "Failure responding to next results request")
	}
	return
}

// ListInstanceFunctionsSlotComplete enumerates all values, automatically crossing page boundaries as required.
func (client AppsClient) ListInstanceFunctionsSlotComplete(ctx context.Context, resourceGroupName string, name string, slot string) (result FunctionEnvelopeCollectionIterator, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/AppsClient.ListInstanceFunctionsSlot")
		defer func() {
			sc := -1
			if result.Response().Response.Response != nil {
				sc = result.page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	result.page, err = client.ListInstanceFunctionsSlot(ctx, resourceGroupName, name, slot)
	return
}

// ListInstanceIdentifiers description for Gets all scale-out instances of an app.
// Parameters:
// resourceGroupName - name of the resource group to which the resource belongs.
// name - name of the app.
func (client AppsClient) ListInstanceIdentifiers(ctx context.Context, resourceGroupName string, name string) (result AppInstanceCollectionPage, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/AppsClient.ListInstanceIdentifiers")
		defer func() {
			sc := -1
			if result.aic.Response.Response != nil {
				sc = result.aic.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewError("web.AppsClient", "ListInstanceIdentifiers", err.Error())
	}

	result.fn = client.listInstanceIdentifiersNextResults
	req, err := client.ListInstanceIdentifiersPreparer(ctx, resourceGroupName, name)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "ListInstanceIdentifiers", nil, "Failure preparing request")
		return
	}

	resp, err := client.ListInstanceIdentifiersSender(req)
	if err != nil {
		result.aic.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.AppsClient", "ListInstanceIdentifiers", resp, "Failure sending request")
		return
	}

	result.aic, err = client.ListInstanceIdentifiersResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "ListInstanceIdentifiers", resp, "Failure responding to request")
	}

	return
}

// ListInstanceIdentifiersPreparer prepares the ListInstanceIdentifiers request.
func (client AppsClient) ListInstanceIdentifiersPreparer(ctx context.Context, resourceGroupName string, name string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2019-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/instances", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// ListInstanceIdentifiersSender sends the ListInstanceIdentifiers request. The method will close the
// http.Response Body if it receives an error.
func (client AppsClient) ListInstanceIdentifiersSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// ListInstanceIdentifiersResponder handles the response to the ListInstanceIdentifiers request. The method always
// closes the http.Response Body.
func (client AppsClient) ListInstanceIdentifiersResponder(resp *http.Response) (result AppInstanceCollection, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// listInstanceIdentifiersNextResults retrieves the next set of results, if any.
func (client AppsClient) listInstanceIdentifiersNextResults(ctx context.Context, lastResults AppInstanceCollection) (result AppInstanceCollection, err error) {
	req, err := lastResults.appInstanceCollectionPreparer(ctx)
	if err != nil {
		return result, autorest.NewErrorWithError(err, "web.AppsClient", "listInstanceIdentifiersNextResults", nil, "Failure preparing next results request")
	}
	if req == nil {
		return
	}
	resp, err := client.ListInstanceIdentifiersSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		return result, autorest.NewErrorWithError(err, "web.AppsClient", "listInstanceIdentifiersNextResults", resp, "Failure sending next results request")
	}
	result, err = client.ListInstanceIdentifiersResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "listInstanceIdentifiersNextResults", resp, "Failure responding to next results request")
	}
	return
}

// ListInstanceIdentifiersComplete enumerates all values, automatically crossing page boundaries as required.
func (client AppsClient) ListInstanceIdentifiersComplete(ctx context.Context, resourceGroupName string, name string) (result AppInstanceCollectionIterator, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/AppsClient.ListInstanceIdentifiers")
		defer func() {
			sc := -1
			if result.Response().Response.Response != nil {
				sc = result.page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	result.page, err = client.ListInstanceIdentifiers(ctx, resourceGroupName, name)
	return
}

// ListInstanceIdentifiersSlot description for Gets all scale-out instances of an app.
// Parameters:
// resourceGroupName - name of the resource group to which the resource belongs.
// name - name of the app.
// slot - name of the deployment slot. If a slot is not specified, the API gets the production slot instances.
func (client AppsClient) ListInstanceIdentifiersSlot(ctx context.Context, resourceGroupName string, name string, slot string) (result AppInstanceCollectionPage, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/AppsClient.ListInstanceIdentifiersSlot")
		defer func() {
			sc := -1
			if result.aic.Response.Response != nil {
				sc = result.aic.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewError("web.AppsClient", "ListInstanceIdentifiersSlot", err.Error())
	}

	result.fn = client.listInstanceIdentifiersSlotNextResults
	req, err := client.ListInstanceIdentifiersSlotPreparer(ctx, resourceGroupName, name, slot)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "ListInstanceIdentifiersSlot", nil, "Failure preparing request")
		return
	}

	resp, err := client.ListInstanceIdentifiersSlotSender(req)
	if err != nil {
		result.aic.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.AppsClient", "ListInstanceIdentifiersSlot", resp, "Failure sending request")
		return
	}

	result.aic, err = client.ListInstanceIdentifiersSlotResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "ListInstanceIdentifiersSlot", resp, "Failure responding to request")
	}

	return
}

// ListInstanceIdentifiersSlotPreparer prepares the ListInstanceIdentifiersSlot request.
func (client AppsClient) ListInstanceIdentifiersSlotPreparer(ctx context.Context, resourceGroupName string, name string, slot string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"slot":              autorest.Encode("path", slot),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2019-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/instances", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// ListInstanceIdentifiersSlotSender sends the ListInstanceIdentifiersSlot request. The method will close the
// http.Response Body if it receives an error.
func (client AppsClient) ListInstanceIdentifiersSlotSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// ListInstanceIdentifiersSlotResponder handles the response to the ListInstanceIdentifiersSlot request. The method always
// closes the http.Response Body.
func (client AppsClient) ListInstanceIdentifiersSlotResponder(resp *http.Response) (result AppInstanceCollection, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// listInstanceIdentifiersSlotNextResults retrieves the next set of results, if any.
func (client AppsClient) listInstanceIdentifiersSlotNextResults(ctx context.Context, lastResults AppInstanceCollection) (result AppInstanceCollection, err error) {
	req, err := lastResults.appInstanceCollectionPreparer(ctx)
	if err != nil {
		return result, autorest.NewErrorWithError(err, "web.AppsClient", "listInstanceIdentifiersSlotNextResults", nil, "Failure preparing next results request")
	}
	if req == nil {
		return
	}
	resp, err := client.ListInstanceIdentifiersSlotSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		return result, autorest.NewErrorWithError(err, "web.AppsClient", "listInstanceIdentifiersSlotNextResults", resp, "Failure sending next results request")
	}
	result, err = client.ListInstanceIdentifiersSlotResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "listInstanceIdentifiersSlotNextResults", resp, "Failure responding to next results request")
	}
	return
}

// ListInstanceIdentifiersSlotComplete enumerates all values, automatically crossing page boundaries as required.
func (client AppsClient) ListInstanceIdentifiersSlotComplete(ctx context.Context, resourceGroupName string, name string, slot string) (result AppInstanceCollectionIterator, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/AppsClient.ListInstanceIdentifiersSlot")
		defer func() {
			sc := -1
			if result.Response().Response.Response != nil {
				sc = result.page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	result.page, err = client.ListInstanceIdentifiersSlot(ctx, resourceGroupName, name, slot)
	return
}

// ListInstanceProcesses description for Get list of processes for a web site, or a deployment slot, or for a specific
// scaled-out instance in a web site.
// Parameters:
// resourceGroupName - name of the resource group to which the resource belongs.
// name - site name.
// instanceID - ID of a specific scaled-out instance. This is the value of the name property in the JSON
// response from "GET api/sites/{siteName}/instances".
func (client AppsClient) ListInstanceProcesses(ctx context.Context, resourceGroupName string, name string, instanceID string) (result ProcessInfoCollectionPage, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/AppsClient.ListInstanceProcesses")
		defer func() {
			sc := -1
			if result.pic.Response.Response != nil {
				sc = result.pic.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewError("web.AppsClient", "ListInstanceProcesses", err.Error())
	}

	result.fn = client.listInstanceProcessesNextResults
	req, err := client.ListInstanceProcessesPreparer(ctx, resourceGroupName, name, instanceID)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "ListInstanceProcesses", nil, "Failure preparing request")
		return
	}

	resp, err := client.ListInstanceProcessesSender(req)
	if err != nil {
		result.pic.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.AppsClient", "ListInstanceProcesses", resp, "Failure sending request")
		return
	}

	result.pic, err = client.ListInstanceProcessesResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "ListInstanceProcesses", resp, "Failure responding to request")
	}

	return
}

// ListInstanceProcessesPreparer prepares the ListInstanceProcesses request.
func (client AppsClient) ListInstanceProcessesPreparer(ctx context.Context, resourceGroupName string, name string, instanceID string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"instanceId":        autorest.Encode("path", instanceID),
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2019-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/instances/{instanceId}/processes", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// ListInstanceProcessesSender sends the ListInstanceProcesses request. The method will close the
// http.Response Body if it receives an error.
func (client AppsClient) ListInstanceProcessesSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// ListInstanceProcessesResponder handles the response to the ListInstanceProcesses request. The method always
// closes the http.Response Body.
func (client AppsClient) ListInstanceProcessesResponder(resp *http.Response) (result ProcessInfoCollection, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusNotFound),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// listInstanceProcessesNextResults retrieves the next set of results, if any.
func (client AppsClient) listInstanceProcessesNextResults(ctx context.Context, lastResults ProcessInfoCollection) (result ProcessInfoCollection, err error) {
	req, err := lastResults.processInfoCollectionPreparer(ctx)
	if err != nil {
		return result, autorest.NewErrorWithError(err, "web.AppsClient", "listInstanceProcessesNextResults", nil, "Failure preparing next results request")
	}
	if req == nil {
		return
	}
	resp, err := client.ListInstanceProcessesSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		return result, autorest.NewErrorWithError(err, "web.AppsClient", "listInstanceProcessesNextResults", resp, "Failure sending next results request")
	}
	result, err = client.ListInstanceProcessesResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "listInstanceProcessesNextResults", resp, "Failure responding to next results request")
	}
	return
}

// ListInstanceProcessesComplete enumerates all values, automatically crossing page boundaries as required.
func (client AppsClient) ListInstanceProcessesComplete(ctx context.Context, resourceGroupName string, name string, instanceID string) (result ProcessInfoCollectionIterator, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/AppsClient.ListInstanceProcesses")
		defer func() {
			sc := -1
			if result.Response().Response.Response != nil {
				sc = result.page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	result.page, err = client.ListInstanceProcesses(ctx, resourceGroupName, name, instanceID)
	return
}

// ListInstanceProcessesSlot description for Get list of processes for a web site, or a deployment slot, or for a
// specific scaled-out instance in a web site.
// Parameters:
// resourceGroupName - name of the resource group to which the resource belongs.
// name - site name.
// slot - name of the deployment slot. If a slot is not specified, the API returns deployments for the
// production slot.
// instanceID - ID of a specific scaled-out instance. This is the value of the name property in the JSON
// response from "GET api/sites/{siteName}/instances".
func (client AppsClient) ListInstanceProcessesSlot(ctx context.Context, resourceGroupName string, name string, slot string, instanceID string) (result ProcessInfoCollectionPage, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/AppsClient.ListInstanceProcessesSlot")
		defer func() {
			sc := -1
			if result.pic.Response.Response != nil {
				sc = result.pic.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewError("web.AppsClient", "ListInstanceProcessesSlot", err.Error())
	}

	result.fn = client.listInstanceProcessesSlotNextResults
	req, err := client.ListInstanceProcessesSlotPreparer(ctx, resourceGroupName, name, slot, instanceID)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "ListInstanceProcessesSlot", nil, "Failure preparing request")
		return
	}

	resp, err := client.ListInstanceProcessesSlotSender(req)
	if err != nil {
		result.pic.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.AppsClient", "ListInstanceProcessesSlot", resp, "Failure sending request")
		return
	}

	result.pic, err = client.ListInstanceProcessesSlotResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "ListInstanceProcessesSlot", resp, "Failure responding to request")
	}

	return
}

// ListInstanceProcessesSlotPreparer prepares the ListInstanceProcessesSlot request.
func (client AppsClient) ListInstanceProcessesSlotPreparer(ctx context.Context, resourceGroupName string, name string, slot string, instanceID string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"instanceId":        autorest.Encode("path", instanceID),
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"slot":              autorest.Encode("path", slot),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2019-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/instances/{instanceId}/processes", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// ListInstanceProcessesSlotSender sends the ListInstanceProcessesSlot request. The method will close the
// http.Response Body if it receives an error.
func (client AppsClient) ListInstanceProcessesSlotSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// ListInstanceProcessesSlotResponder handles the response to the ListInstanceProcessesSlot request. The method always
// closes the http.Response Body.
func (client AppsClient) ListInstanceProcessesSlotResponder(resp *http.Response) (result ProcessInfoCollection, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusNotFound),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// listInstanceProcessesSlotNextResults retrieves the next set of results, if any.
func (client AppsClient) listInstanceProcessesSlotNextResults(ctx context.Context, lastResults ProcessInfoCollection) (result ProcessInfoCollection, err error) {
	req, err := lastResults.processInfoCollectionPreparer(ctx)
	if err != nil {
		return result, autorest.NewErrorWithError(err, "web.AppsClient", "listInstanceProcessesSlotNextResults", nil, "Failure preparing next results request")
	}
	if req == nil {
		return
	}
	resp, err := client.ListInstanceProcessesSlotSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		return result, autorest.NewErrorWithError(err, "web.AppsClient", "listInstanceProcessesSlotNextResults", resp, "Failure sending next results request")
	}
	result, err = client.ListInstanceProcessesSlotResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "listInstanceProcessesSlotNextResults", resp, "Failure responding to next results request")
	}
	return
}

// ListInstanceProcessesSlotComplete enumerates all values, automatically crossing page boundaries as required.
func (client AppsClient) ListInstanceProcessesSlotComplete(ctx context.Context, resourceGroupName string, name string, slot string, instanceID string) (result ProcessInfoCollectionIterator, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/AppsClient.ListInstanceProcessesSlot")
		defer func() {
			sc := -1
			if result.Response().Response.Response != nil {
				sc = result.page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	result.page, err = client.ListInstanceProcessesSlot(ctx, resourceGroupName, name, slot, instanceID)
	return
}

// ListInstanceProcessModules description for List module information for a process by its ID for a specific scaled-out
// instance in a web site.
// Parameters:
// resourceGroupName - name of the resource group to which the resource belongs.
// name - site name.
// processID - pID.
// instanceID - ID of a specific scaled-out instance. This is the value of the name property in the JSON
// response from "GET api/sites/{siteName}/instances".
func (client AppsClient) ListInstanceProcessModules(ctx context.Context, resourceGroupName string, name string, processID string, instanceID string) (result ProcessModuleInfoCollectionPage, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/AppsClient.ListInstanceProcessModules")
		defer func() {
			sc := -1
			if result.pmic.Response.Response != nil {
				sc = result.pmic.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewError("web.AppsClient", "ListInstanceProcessModules", err.Error())
	}

	result.fn = client.listInstanceProcessModulesNextResults
	req, err := client.ListInstanceProcessModulesPreparer(ctx, resourceGroupName, name, processID, instanceID)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "ListInstanceProcessModules", nil, "Failure preparing request")
		return
	}

	resp, err := client.ListInstanceProcessModulesSender(req)
	if err != nil {
		result.pmic.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.AppsClient", "ListInstanceProcessModules", resp, "Failure sending request")
		return
	}

	result.pmic, err = client.ListInstanceProcessModulesResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "ListInstanceProcessModules", resp, "Failure responding to request")
	}

	return
}

// ListInstanceProcessModulesPreparer prepares the ListInstanceProcessModules request.
func (client AppsClient) ListInstanceProcessModulesPreparer(ctx context.Context, resourceGroupName string, name string, processID string, instanceID string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"instanceId":        autorest.Encode("path", instanceID),
		"name":              autorest.Encode("path", name),
		"processId":         autorest.Encode("path", processID),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2019-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/instances/{instanceId}/processes/{processId}/modules", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// ListInstanceProcessModulesSender sends the ListInstanceProcessModules request. The method will close the
// http.Response Body if it receives an error.
func (client AppsClient) ListInstanceProcessModulesSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// ListInstanceProcessModulesResponder handles the response to the ListInstanceProcessModules request. The method always
// closes the http.Response Body.
func (client AppsClient) ListInstanceProcessModulesResponder(resp *http.Response) (result ProcessModuleInfoCollection, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusNotFound),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// listInstanceProcessModulesNextResults retrieves the next set of results, if any.
func (client AppsClient) listInstanceProcessModulesNextResults(ctx context.Context, lastResults ProcessModuleInfoCollection) (result ProcessModuleInfoCollection, err error) {
	req, err := lastResults.processModuleInfoCollectionPreparer(ctx)
	if err != nil {
		return result, autorest.NewErrorWithError(err, "web.AppsClient", "listInstanceProcessModulesNextResults", nil, "Failure preparing next results request")
	}
	if req == nil {
		return
	}
	resp, err := client.ListInstanceProcessModulesSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		return result, autorest.NewErrorWithError(err, "web.AppsClient", "listInstanceProcessModulesNextResults", resp, "Failure sending next results request")
	}
	result, err = client.ListInstanceProcessModulesResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "listInstanceProcessModulesNextResults", resp, "Failure responding to next results request")
	}
	return
}

// ListInstanceProcessModulesComplete enumerates all values, automatically crossing page boundaries as required.
func (client AppsClient) ListInstanceProcessModulesComplete(ctx context.Context, resourceGroupName string, name string, processID string, instanceID string) (result ProcessModuleInfoCollectionIterator, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/AppsClient.ListInstanceProcessModules")
		defer func() {
			sc := -1
			if result.Response().Response.Response != nil {
				sc = result.page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	result.page, err = client.ListInstanceProcessModules(ctx, resourceGroupName, name, processID, instanceID)
	return
}

// ListInstanceProcessModulesSlot description for List module information for a process by its ID for a specific
// scaled-out instance in a web site.
// Parameters:
// resourceGroupName - name of the resource group to which the resource belongs.
// name - site name.
// processID - pID.
// slot - name of the deployment slot. If a slot is not specified, the API returns deployments for the
// production slot.
// instanceID - ID of a specific scaled-out instance. This is the value of the name property in the JSON
// response from "GET api/sites/{siteName}/instances".
func (client AppsClient) ListInstanceProcessModulesSlot(ctx context.Context, resourceGroupName string, name string, processID string, slot string, instanceID string) (result ProcessModuleInfoCollectionPage, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/AppsClient.ListInstanceProcessModulesSlot")
		defer func() {
			sc := -1
			if result.pmic.Response.Response != nil {
				sc = result.pmic.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewError("web.AppsClient", "ListInstanceProcessModulesSlot", err.Error())
	}

	result.fn = client.listInstanceProcessModulesSlotNextResults
	req, err := client.ListInstanceProcessModulesSlotPreparer(ctx, resourceGroupName, name, processID, slot, instanceID)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "ListInstanceProcessModulesSlot", nil, "Failure preparing request")
		return
	}

	resp, err := client.ListInstanceProcessModulesSlotSender(req)
	if err != nil {
		result.pmic.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.AppsClient", "ListInstanceProcessModulesSlot", resp, "Failure sending request")
		return
	}

	result.pmic, err = client.ListInstanceProcessModulesSlotResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "ListInstanceProcessModulesSlot", resp, "Failure responding to request")
	}

	return
}

// ListInstanceProcessModulesSlotPreparer prepares the ListInstanceProcessModulesSlot request.
func (client AppsClient) ListInstanceProcessModulesSlotPreparer(ctx context.Context, resourceGroupName string, name string, processID string, slot string, instanceID string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"instanceId":        autorest.Encode("path", instanceID),
		"name":              autorest.Encode("path", name),
		"processId":         autorest.Encode("path", processID),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"slot":              autorest.Encode("path", slot),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2019-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/instances/{instanceId}/processes/{processId}/modules", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// ListInstanceProcessModulesSlotSender sends the ListInstanceProcessModulesSlot request. The method will close the
// http.Response Body if it receives an error.
func (client AppsClient) ListInstanceProcessModulesSlotSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// ListInstanceProcessModulesSlotResponder handles the response to the ListInstanceProcessModulesSlot request. The method always
// closes the http.Response Body.
func (client AppsClient) ListInstanceProcessModulesSlotResponder(resp *http.Response) (result ProcessModuleInfoCollection, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusNotFound),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// listInstanceProcessModulesSlotNextResults retrieves the next set of results, if any.
func (client AppsClient) listInstanceProcessModulesSlotNextResults(ctx context.Context, lastResults ProcessModuleInfoCollection) (result ProcessModuleInfoCollection, err error) {
	req, err := lastResults.processModuleInfoCollectionPreparer(ctx)
	if err != nil {
		return result, autorest.NewErrorWithError(err, "web.AppsClient", "listInstanceProcessModulesSlotNextResults", nil, "Failure preparing next results request")
	}
	if req == nil {
		return
	}
	resp, err := client.ListInstanceProcessModulesSlotSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		return result, autorest.NewErrorWithError(err, "web.AppsClient", "listInstanceProcessModulesSlotNextResults", resp, "Failure sending next results request")
	}
	result, err = client.ListInstanceProcessModulesSlotResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "listInstanceProcessModulesSlotNextResults", resp, "Failure responding to next results request")
	}
	return
}

// ListInstanceProcessModulesSlotComplete enumerates all values, automatically crossing page boundaries as required.
func (client AppsClient) ListInstanceProcessModulesSlotComplete(ctx context.Context, resourceGroupName string, name string, processID string, slot string, instanceID string) (result ProcessModuleInfoCollectionIterator, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/AppsClient.ListInstanceProcessModulesSlot")
		defer func() {
			sc := -1
			if result.Response().Response.Response != nil {
				sc = result.page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	result.page, err = client.ListInstanceProcessModulesSlot(ctx, resourceGroupName, name, processID, slot, instanceID)
	return
}

// ListInstanceProcessThreads description for List the threads in a process by its ID for a specific scaled-out
// instance in a web site.
// Parameters:
// resourceGroupName - name of the resource group to which the resource belongs.
// name - site name.
// processID - pID.
// instanceID - ID of a specific scaled-out instance. This is the value of the name property in the JSON
// response from "GET api/sites/{siteName}/instances".
func (client AppsClient) ListInstanceProcessThreads(ctx context.Context, resourceGroupName string, name string, processID string, instanceID string) (result ProcessThreadInfoCollectionPage, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/AppsClient.ListInstanceProcessThreads")
		defer func() {
			sc := -1
			if result.ptic.Response.Response != nil {
				sc = result.ptic.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewError("web.AppsClient", "ListInstanceProcessThreads", err.Error())
	}

	result.fn = client.listInstanceProcessThreadsNextResults
	req, err := client.ListInstanceProcessThreadsPreparer(ctx, resourceGroupName, name, processID, instanceID)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "ListInstanceProcessThreads", nil, "Failure preparing request")
		return
	}

	resp, err := client.ListInstanceProcessThreadsSender(req)
	if err != nil {
		result.ptic.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.AppsClient", "ListInstanceProcessThreads", resp, "Failure sending request")
		return
	}

	result.ptic, err = client.ListInstanceProcessThreadsResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "ListInstanceProcessThreads", resp, "Failure responding to request")
	}

	return
}

// ListInstanceProcessThreadsPreparer prepares the ListInstanceProcessThreads request.
func (client AppsClient) ListInstanceProcessThreadsPreparer(ctx context.Context, resourceGroupName string, name string, processID string, instanceID string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"instanceId":        autorest.Encode("path", instanceID),
		"name":              autorest.Encode("path", name),
		"processId":         autorest.Encode("path", processID),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2019-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/instances/{instanceId}/processes/{processId}/threads", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// ListInstanceProcessThreadsSender sends the ListInstanceProcessThreads request. The method will close the
// http.Response Body if it receives an error.
func (client AppsClient) ListInstanceProcessThreadsSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// ListInstanceProcessThreadsResponder handles the response to the ListInstanceProcessThreads request. The method always
// closes the http.Response Body.
func (client AppsClient) ListInstanceProcessThreadsResponder(resp *http.Response) (result ProcessThreadInfoCollection, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusNotFound),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// listInstanceProcessThreadsNextResults retrieves the next set of results, if any.
func (client AppsClient) listInstanceProcessThreadsNextResults(ctx context.Context, lastResults ProcessThreadInfoCollection) (result ProcessThreadInfoCollection, err error) {
	req, err := lastResults.processThreadInfoCollectionPreparer(ctx)
	if err != nil {
		return result, autorest.NewErrorWithError(err, "web.AppsClient", "listInstanceProcessThreadsNextResults", nil, "Failure preparing next results request")
	}
	if req == nil {
		return
	}
	resp, err := client.ListInstanceProcessThreadsSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		return result, autorest.NewErrorWithError(err, "web.AppsClient", "listInstanceProcessThreadsNextResults", resp, "Failure sending next results request")
	}
	result, err = client.ListInstanceProcessThreadsResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "listInstanceProcessThreadsNextResults", resp, "Failure responding to next results request")
	}
	return
}

// ListInstanceProcessThreadsComplete enumerates all values, automatically crossing page boundaries as required.
func (client AppsClient) ListInstanceProcessThreadsComplete(ctx context.Context, resourceGroupName string, name string, processID string, instanceID string) (result ProcessThreadInfoCollectionIterator, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/AppsClient.ListInstanceProcessThreads")
		defer func() {
			sc := -1
			if result.Response().Response.Response != nil {
				sc = result.page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	result.page, err = client.ListInstanceProcessThreads(ctx, resourceGroupName, name, processID, instanceID)
	return
}

// ListInstanceProcessThreadsSlot description for List the threads in a process by its ID for a specific scaled-out
// instance in a web site.
// Parameters:
// resourceGroupName - name of the resource group to which the resource belongs.
// name - site name.
// processID - pID.
// slot - name of the deployment slot. If a slot is not specified, the API returns deployments for the
// production slot.
// instanceID - ID of a specific scaled-out instance. This is the value of the name property in the JSON
// response from "GET api/sites/{siteName}/instances".
func (client AppsClient) ListInstanceProcessThreadsSlot(ctx context.Context, resourceGroupName string, name string, processID string, slot string, instanceID string) (result ProcessThreadInfoCollectionPage, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/AppsClient.ListInstanceProcessThreadsSlot")
		defer func() {
			sc := -1
			if result.ptic.Response.Response != nil {
				sc = result.ptic.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewError("web.AppsClient", "ListInstanceProcessThreadsSlot", err.Error())
	}

	result.fn = client.listInstanceProcessThreadsSlotNextResults
	req, err := client.ListInstanceProcessThreadsSlotPreparer(ctx, resourceGroupName, name, processID, slot, instanceID)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "ListInstanceProcessThreadsSlot", nil, "Failure preparing request")
		return
	}

	resp, err := client.ListInstanceProcessThreadsSlotSender(req)
	if err != nil {
		result.ptic.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.AppsClient", "ListInstanceProcessThreadsSlot", resp, "Failure sending request")
		return
	}

	result.ptic, err = client.ListInstanceProcessThreadsSlotResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "ListInstanceProcessThreadsSlot", resp, "Failure responding to request")
	}

	return
}

// ListInstanceProcessThreadsSlotPreparer prepares the ListInstanceProcessThreadsSlot request.
func (client AppsClient) ListInstanceProcessThreadsSlotPreparer(ctx context.Context, resourceGroupName string, name string, processID string, slot string, instanceID string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"instanceId":        autorest.Encode("path", instanceID),
		"name":              autorest.Encode("path", name),
		"processId":         autorest.Encode("path", processID),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"slot":              autorest.Encode("path", slot),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2019-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/instances/{instanceId}/processes/{processId}/threads", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// ListInstanceProcessThreadsSlotSender sends the ListInstanceProcessThreadsSlot request. The method will close the
// http.Response Body if it receives an error.
func (client AppsClient) ListInstanceProcessThreadsSlotSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// ListInstanceProcessThreadsSlotResponder handles the response to the ListInstanceProcessThreadsSlot request. The method always
// closes the http.Response Body.
func (client AppsClient) ListInstanceProcessThreadsSlotResponder(resp *http.Response) (result ProcessThreadInfoCollection, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusNotFound),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// listInstanceProcessThreadsSlotNextResults retrieves the next set of results, if any.
func (client AppsClient) listInstanceProcessThreadsSlotNextResults(ctx context.Context, lastResults ProcessThreadInfoCollection) (result ProcessThreadInfoCollection, err error) {
	req, err := lastResults.processThreadInfoCollectionPreparer(ctx)
	if err != nil {
		return result, autorest.NewErrorWithError(err, "web.AppsClient", "listInstanceProcessThreadsSlotNextResults", nil, "Failure preparing next results request")
	}
	if req == nil {
		return
	}
	resp, err := client.ListInstanceProcessThreadsSlotSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		return result, autorest.NewErrorWithError(err, "web.AppsClient", "listInstanceProcessThreadsSlotNextResults", resp, "Failure sending next results request")
	}
	result, err = client.ListInstanceProcessThreadsSlotResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "listInstanceProcessThreadsSlotNextResults", resp, "Failure responding to next results request")
	}
	return
}

// ListInstanceProcessThreadsSlotComplete enumerates all values, automatically crossing page boundaries as required.
func (client AppsClient) ListInstanceProcessThreadsSlotComplete(ctx context.Context, resourceGroupName string, name string, processID string, slot string, instanceID string) (result ProcessThreadInfoCollectionIterator, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/AppsClient.ListInstanceProcessThreadsSlot")
		defer func() {
			sc := -1
			if result.Response().Response.Response != nil {
				sc = result.page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	result.page, err = client.ListInstanceProcessThreadsSlot(ctx, resourceGroupName, name, processID, slot, instanceID)
	return
}

// ListMetadata description for Gets the metadata of an app.
// Parameters:
// resourceGroupName - name of the resource group to which the resource belongs.
// name - name of the app.
func (client AppsClient) ListMetadata(ctx context.Context, resourceGroupName string, name string) (result StringDictionary, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/AppsClient.ListMetadata")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewError("web.AppsClient", "ListMetadata", err.Error())
	}

	req, err := client.ListMetadataPreparer(ctx, resourceGroupName, name)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "ListMetadata", nil, "Failure preparing request")
		return
	}

	resp, err := client.ListMetadataSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.AppsClient", "ListMetadata", resp, "Failure sending request")
		return
	}

	result, err = client.ListMetadataResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "ListMetadata", resp, "Failure responding to request")
	}

	return
}

// ListMetadataPreparer prepares the ListMetadata request.
func (client AppsClient) ListMetadataPreparer(ctx context.Context, resourceGroupName string, name string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2019-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsPost(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/config/metadata/list", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// ListMetadataSender sends the ListMetadata request. The method will close the
// http.Response Body if it receives an error.
func (client AppsClient) ListMetadataSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// ListMetadataResponder handles the response to the ListMetadata request. The method always
// closes the http.Response Body.
func (client AppsClient) ListMetadataResponder(resp *http.Response) (result StringDictionary, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// ListMetadataSlot description for Gets the metadata of an app.
// Parameters:
// resourceGroupName - name of the resource group to which the resource belongs.
// name - name of the app.
// slot - name of the deployment slot. If a slot is not specified, the API will get the metadata for the
// production slot.
func (client AppsClient) ListMetadataSlot(ctx context.Context, resourceGroupName string, name string, slot string) (result StringDictionary, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/AppsClient.ListMetadataSlot")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewError("web.AppsClient", "ListMetadataSlot", err.Error())
	}

	req, err := client.ListMetadataSlotPreparer(ctx, resourceGroupName, name, slot)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "ListMetadataSlot", nil, "Failure preparing request")
		return
	}

	resp, err := client.ListMetadataSlotSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.AppsClient", "ListMetadataSlot", resp, "Failure sending request")
		return
	}

	result, err = client.ListMetadataSlotResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "ListMetadataSlot", resp, "Failure responding to request")
	}

	return
}

// ListMetadataSlotPreparer prepares the ListMetadataSlot request.
func (client AppsClient) ListMetadataSlotPreparer(ctx context.Context, resourceGroupName string, name string, slot string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"slot":              autorest.Encode("path", slot),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2019-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsPost(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/config/metadata/list", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// ListMetadataSlotSender sends the ListMetadataSlot request. The method will close the
// http.Response Body if it receives an error.
func (client AppsClient) ListMetadataSlotSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// ListMetadataSlotResponder handles the response to the ListMetadataSlot request. The method always
// closes the http.Response Body.
func (client AppsClient) ListMetadataSlotResponder(resp *http.Response) (result StringDictionary, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// ListNetworkFeatures description for Gets all network features used by the app (or deployment slot, if specified).
// Parameters:
// resourceGroupName - name of the resource group to which the resource belongs.
// name - name of the app.
// view - the type of view. This can either be "summary" or "detailed".
func (client AppsClient) ListNetworkFeatures(ctx context.Context, resourceGroupName string, name string, view string) (result NetworkFeatures, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/AppsClient.ListNetworkFeatures")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewError("web.AppsClient", "ListNetworkFeatures", err.Error())
	}

	req, err := client.ListNetworkFeaturesPreparer(ctx, resourceGroupName, name, view)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "ListNetworkFeatures", nil, "Failure preparing request")
		return
	}

	resp, err := client.ListNetworkFeaturesSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.AppsClient", "ListNetworkFeatures", resp, "Failure sending request")
		return
	}

	result, err = client.ListNetworkFeaturesResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "ListNetworkFeatures", resp, "Failure responding to request")
	}

	return
}

// ListNetworkFeaturesPreparer prepares the ListNetworkFeatures request.
func (client AppsClient) ListNetworkFeaturesPreparer(ctx context.Context, resourceGroupName string, name string, view string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
		"view":              autorest.Encode("path", view),
	}

	const APIVersion = "2019-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/networkFeatures/{view}", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// ListNetworkFeaturesSender sends the ListNetworkFeatures request. The method will close the
// http.Response Body if it receives an error.
func (client AppsClient) ListNetworkFeaturesSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// ListNetworkFeaturesResponder handles the response to the ListNetworkFeatures request. The method always
// closes the http.Response Body.
func (client AppsClient) ListNetworkFeaturesResponder(resp *http.Response) (result NetworkFeatures, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusNotFound),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// ListNetworkFeaturesSlot description for Gets all network features used by the app (or deployment slot, if
// specified).
// Parameters:
// resourceGroupName - name of the resource group to which the resource belongs.
// name - name of the app.
// view - the type of view. This can either be "summary" or "detailed".
// slot - name of the deployment slot. If a slot is not specified, the API will get network features for the
// production slot.
func (client AppsClient) ListNetworkFeaturesSlot(ctx context.Context, resourceGroupName string, name string, view string, slot string) (result NetworkFeatures, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/AppsClient.ListNetworkFeaturesSlot")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewError("web.AppsClient", "ListNetworkFeaturesSlot", err.Error())
	}

	req, err := client.ListNetworkFeaturesSlotPreparer(ctx, resourceGroupName, name, view, slot)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "ListNetworkFeaturesSlot", nil, "Failure preparing request")
		return
	}

	resp, err := client.ListNetworkFeaturesSlotSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.AppsClient", "ListNetworkFeaturesSlot", resp, "Failure sending request")
		return
	}

	result, err = client.ListNetworkFeaturesSlotResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "ListNetworkFeaturesSlot", resp, "Failure responding to request")
	}

	return
}

// ListNetworkFeaturesSlotPreparer prepares the ListNetworkFeaturesSlot request.
func (client AppsClient) ListNetworkFeaturesSlotPreparer(ctx context.Context, resourceGroupName string, name string, view string, slot string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"slot":              autorest.Encode("path", slot),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
		"view":              autorest.Encode("path", view),
	}

	const APIVersion = "2019-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/networkFeatures/{view}", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// ListNetworkFeaturesSlotSender sends the ListNetworkFeaturesSlot request. The method will close the
// http.Response Body if it receives an error.
func (client AppsClient) ListNetworkFeaturesSlotSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// ListNetworkFeaturesSlotResponder handles the response to the ListNetworkFeaturesSlot request. The method always
// closes the http.Response Body.
func (client AppsClient) ListNetworkFeaturesSlotResponder(resp *http.Response) (result NetworkFeatures, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusNotFound),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// ListPerfMonCounters description for Gets perfmon counters for web app.
// Parameters:
// resourceGroupName - name of the resource group to which the resource belongs.
// name - name of web app.
// filter - return only usages/metrics specified in the filter. Filter conforms to odata syntax. Example:
// $filter=(startTime eq 2014-01-01T00:00:00Z and endTime eq 2014-12-31T23:59:59Z and timeGrain eq
// duration'[Hour|Minute|Day]'.
func (client AppsClient) ListPerfMonCounters(ctx context.Context, resourceGroupName string, name string, filter string) (result PerfMonCounterCollectionPage, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/AppsClient.ListPerfMonCounters")
		defer func() {
			sc := -1
			if result.pmcc.Response.Response != nil {
				sc = result.pmcc.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewError("web.AppsClient", "ListPerfMonCounters", err.Error())
	}

	result.fn = client.listPerfMonCountersNextResults
	req, err := client.ListPerfMonCountersPreparer(ctx, resourceGroupName, name, filter)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "ListPerfMonCounters", nil, "Failure preparing request")
		return
	}

	resp, err := client.ListPerfMonCountersSender(req)
	if err != nil {
		result.pmcc.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.AppsClient", "ListPerfMonCounters", resp, "Failure sending request")
		return
	}

	result.pmcc, err = client.ListPerfMonCountersResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "ListPerfMonCounters", resp, "Failure responding to request")
	}

	return
}

// ListPerfMonCountersPreparer prepares the ListPerfMonCounters request.
func (client AppsClient) ListPerfMonCountersPreparer(ctx context.Context, resourceGroupName string, name string, filter string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2019-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}
	if len(filter) > 0 {
		queryParameters["$filter"] = filter
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/perfcounters", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// ListPerfMonCountersSender sends the ListPerfMonCounters request. The method will close the
// http.Response Body if it receives an error.
func (client AppsClient) ListPerfMonCountersSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// ListPerfMonCountersResponder handles the response to the ListPerfMonCounters request. The method always
// closes the http.Response Body.
func (client AppsClient) ListPerfMonCountersResponder(resp *http.Response) (result PerfMonCounterCollection, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// listPerfMonCountersNextResults retrieves the next set of results, if any.
func (client AppsClient) listPerfMonCountersNextResults(ctx context.Context, lastResults PerfMonCounterCollection) (result PerfMonCounterCollection, err error) {
	req, err := lastResults.perfMonCounterCollectionPreparer(ctx)
	if err != nil {
		return result, autorest.NewErrorWithError(err, "web.AppsClient", "listPerfMonCountersNextResults", nil, "Failure preparing next results request")
	}
	if req == nil {
		return
	}
	resp, err := client.ListPerfMonCountersSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		return result, autorest.NewErrorWithError(err, "web.AppsClient", "listPerfMonCountersNextResults", resp, "Failure sending next results request")
	}
	result, err = client.ListPerfMonCountersResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "listPerfMonCountersNextResults", resp, "Failure responding to next results request")
	}
	return
}

// ListPerfMonCountersComplete enumerates all values, automatically crossing page boundaries as required.
func (client AppsClient) ListPerfMonCountersComplete(ctx context.Context, resourceGroupName string, name string, filter string) (result PerfMonCounterCollectionIterator, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/AppsClient.ListPerfMonCounters")
		defer func() {
			sc := -1
			if result.Response().Response.Response != nil {
				sc = result.page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	result.page, err = client.ListPerfMonCounters(ctx, resourceGroupName, name, filter)
	return
}

// ListPerfMonCountersSlot description for Gets perfmon counters for web app.
// Parameters:
// resourceGroupName - name of the resource group to which the resource belongs.
// name - name of web app.
// slot - name of web app slot. If not specified then will default to production slot.
// filter - return only usages/metrics specified in the filter. Filter conforms to odata syntax. Example:
// $filter=(startTime eq 2014-01-01T00:00:00Z and endTime eq 2014-12-31T23:59:59Z and timeGrain eq
// duration'[Hour|Minute|Day]'.
func (client AppsClient) ListPerfMonCountersSlot(ctx context.Context, resourceGroupName string, name string, slot string, filter string) (result PerfMonCounterCollectionPage, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/AppsClient.ListPerfMonCountersSlot")
		defer func() {
			sc := -1
			if result.pmcc.Response.Response != nil {
				sc = result.pmcc.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewError("web.AppsClient", "ListPerfMonCountersSlot", err.Error())
	}

	result.fn = client.listPerfMonCountersSlotNextResults
	req, err := client.ListPerfMonCountersSlotPreparer(ctx, resourceGroupName, name, slot, filter)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "ListPerfMonCountersSlot", nil, "Failure preparing request")
		return
	}

	resp, err := client.ListPerfMonCountersSlotSender(req)
	if err != nil {
		result.pmcc.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.AppsClient", "ListPerfMonCountersSlot", resp, "Failure sending request")
		return
	}

	result.pmcc, err = client.ListPerfMonCountersSlotResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "ListPerfMonCountersSlot", resp, "Failure responding to request")
	}

	return
}

// ListPerfMonCountersSlotPreparer prepares the ListPerfMonCountersSlot request.
func (client AppsClient) ListPerfMonCountersSlotPreparer(ctx context.Context, resourceGroupName string, name string, slot string, filter string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"slot":              autorest.Encode("path", slot),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2019-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}
	if len(filter) > 0 {
		queryParameters["$filter"] = filter
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/perfcounters", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// ListPerfMonCountersSlotSender sends the ListPerfMonCountersSlot request. The method will close the
// http.Response Body if it receives an error.
func (client AppsClient) ListPerfMonCountersSlotSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// ListPerfMonCountersSlotResponder handles the response to the ListPerfMonCountersSlot request. The method always
// closes the http.Response Body.
func (client AppsClient) ListPerfMonCountersSlotResponder(resp *http.Response) (result PerfMonCounterCollection, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// listPerfMonCountersSlotNextResults retrieves the next set of results, if any.
func (client AppsClient) listPerfMonCountersSlotNextResults(ctx context.Context, lastResults PerfMonCounterCollection) (result PerfMonCounterCollection, err error) {
	req, err := lastResults.perfMonCounterCollectionPreparer(ctx)
	if err != nil {
		return result, autorest.NewErrorWithError(err, "web.AppsClient", "listPerfMonCountersSlotNextResults", nil, "Failure preparing next results request")
	}
	if req == nil {
		return
	}
	resp, err := client.ListPerfMonCountersSlotSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		return result, autorest.NewErrorWithError(err, "web.AppsClient", "listPerfMonCountersSlotNextResults", resp, "Failure sending next results request")
	}
	result, err = client.ListPerfMonCountersSlotResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "listPerfMonCountersSlotNextResults", resp, "Failure responding to next results request")
	}
	return
}

// ListPerfMonCountersSlotComplete enumerates all values, automatically crossing page boundaries as required.
func (client AppsClient) ListPerfMonCountersSlotComplete(ctx context.Context, resourceGroupName string, name string, slot string, filter string) (result PerfMonCounterCollectionIterator, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/AppsClient.ListPerfMonCountersSlot")
		defer func() {
			sc := -1
			if result.Response().Response.Response != nil {
				sc = result.page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	result.page, err = client.ListPerfMonCountersSlot(ctx, resourceGroupName, name, slot, filter)
	return
}

// ListPremierAddOns description for Gets the premier add-ons of an app.
// Parameters:
// resourceGroupName - name of the resource group to which the resource belongs.
// name - name of the app.
func (client AppsClient) ListPremierAddOns(ctx context.Context, resourceGroupName string, name string) (result PremierAddOn, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/AppsClient.ListPremierAddOns")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewError("web.AppsClient", "ListPremierAddOns", err.Error())
	}

	req, err := client.ListPremierAddOnsPreparer(ctx, resourceGroupName, name)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "ListPremierAddOns", nil, "Failure preparing request")
		return
	}

	resp, err := client.ListPremierAddOnsSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.AppsClient", "ListPremierAddOns", resp, "Failure sending request")
		return
	}

	result, err = client.ListPremierAddOnsResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "ListPremierAddOns", resp, "Failure responding to request")
	}

	return
}

// ListPremierAddOnsPreparer prepares the ListPremierAddOns request.
func (client AppsClient) ListPremierAddOnsPreparer(ctx context.Context, resourceGroupName string, name string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2019-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/premieraddons", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// ListPremierAddOnsSender sends the ListPremierAddOns request. The method will close the
// http.Response Body if it receives an error.
func (client AppsClient) ListPremierAddOnsSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// ListPremierAddOnsResponder handles the response to the ListPremierAddOns request. The method always
// closes the http.Response Body.
func (client AppsClient) ListPremierAddOnsResponder(resp *http.Response) (result PremierAddOn, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// ListPremierAddOnsSlot description for Gets the premier add-ons of an app.
// Parameters:
// resourceGroupName - name of the resource group to which the resource belongs.
// name - name of the app.
// slot - name of the deployment slot. If a slot is not specified, the API will get the premier add-ons for the
// production slot.
func (client AppsClient) ListPremierAddOnsSlot(ctx context.Context, resourceGroupName string, name string, slot string) (result PremierAddOn, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/AppsClient.ListPremierAddOnsSlot")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewError("web.AppsClient", "ListPremierAddOnsSlot", err.Error())
	}

	req, err := client.ListPremierAddOnsSlotPreparer(ctx, resourceGroupName, name, slot)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "ListPremierAddOnsSlot", nil, "Failure preparing request")
		return
	}

	resp, err := client.ListPremierAddOnsSlotSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.AppsClient", "ListPremierAddOnsSlot", resp, "Failure sending request")
		return
	}

	result, err = client.ListPremierAddOnsSlotResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "ListPremierAddOnsSlot", resp, "Failure responding to request")
	}

	return
}

// ListPremierAddOnsSlotPreparer prepares the ListPremierAddOnsSlot request.
func (client AppsClient) ListPremierAddOnsSlotPreparer(ctx context.Context, resourceGroupName string, name string, slot string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"slot":              autorest.Encode("path", slot),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2019-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/premieraddons", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// ListPremierAddOnsSlotSender sends the ListPremierAddOnsSlot request. The method will close the
// http.Response Body if it receives an error.
func (client AppsClient) ListPremierAddOnsSlotSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// ListPremierAddOnsSlotResponder handles the response to the ListPremierAddOnsSlot request. The method always
// closes the http.Response Body.
func (client AppsClient) ListPremierAddOnsSlotResponder(resp *http.Response) (result PremierAddOn, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// ListProcesses description for Get list of processes for a web site, or a deployment slot, or for a specific
// scaled-out instance in a web site.
// Parameters:
// resourceGroupName - name of the resource group to which the resource belongs.
// name - site name.
func (client AppsClient) ListProcesses(ctx context.Context, resourceGroupName string, name string) (result ProcessInfoCollectionPage, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/AppsClient.ListProcesses")
		defer func() {
			sc := -1
			if result.pic.Response.Response != nil {
				sc = result.pic.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewError("web.AppsClient", "ListProcesses", err.Error())
	}

	result.fn = client.listProcessesNextResults
	req, err := client.ListProcessesPreparer(ctx, resourceGroupName, name)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "ListProcesses", nil, "Failure preparing request")
		return
	}

	resp, err := client.ListProcessesSender(req)
	if err != nil {
		result.pic.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.AppsClient", "ListProcesses", resp, "Failure sending request")
		return
	}

	result.pic, err = client.ListProcessesResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "ListProcesses", resp, "Failure responding to request")
	}

	return
}

// ListProcessesPreparer prepares the ListProcesses request.
func (client AppsClient) ListProcessesPreparer(ctx context.Context, resourceGroupName string, name string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2019-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/processes", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// ListProcessesSender sends the ListProcesses request. The method will close the
// http.Response Body if it receives an error.
func (client AppsClient) ListProcessesSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// ListProcessesResponder handles the response to the ListProcesses request. The method always
// closes the http.Response Body.
func (client AppsClient) ListProcessesResponder(resp *http.Response) (result ProcessInfoCollection, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusNotFound),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// listProcessesNextResults retrieves the next set of results, if any.
func (client AppsClient) listProcessesNextResults(ctx context.Context, lastResults ProcessInfoCollection) (result ProcessInfoCollection, err error) {
	req, err := lastResults.processInfoCollectionPreparer(ctx)
	if err != nil {
		return result, autorest.NewErrorWithError(err, "web.AppsClient", "listProcessesNextResults", nil, "Failure preparing next results request")
	}
	if req == nil {
		return
	}
	resp, err := client.ListProcessesSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		return result, autorest.NewErrorWithError(err, "web.AppsClient", "listProcessesNextResults", resp, "Failure sending next results request")
	}
	result, err = client.ListProcessesResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "listProcessesNextResults", resp, "Failure responding to next results request")
	}
	return
}

// ListProcessesComplete enumerates all values, automatically crossing page boundaries as required.
func (client AppsClient) ListProcessesComplete(ctx context.Context, resourceGroupName string, name string) (result ProcessInfoCollectionIterator, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/AppsClient.ListProcesses")
		defer func() {
			sc := -1
			if result.Response().Response.Response != nil {
				sc = result.page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	result.page, err = client.ListProcesses(ctx, resourceGroupName, name)
	return
}

// ListProcessesSlot description for Get list of processes for a web site, or a deployment slot, or for a specific
// scaled-out instance in a web site.
// Parameters:
// resourceGroupName - name of the resource group to which the resource belongs.
// name - site name.
// slot - name of the deployment slot. If a slo