// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package mediapackage

import (
	"fmt"

	"github.com/aws/aws-sdk-go/aws"
	"github.com/aws/aws-sdk-go/aws/awsutil"
	"github.com/aws/aws-sdk-go/aws/request"
	"github.com/aws/aws-sdk-go/private/protocol"
	"github.com/aws/aws-sdk-go/private/protocol/restjson"
)

const opCreateChannel = "CreateChannel"

// CreateChannelRequest generates a "aws/request.Request" representing the
// client's request for the CreateChannel operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateChannel for more information on using the CreateChannel
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateChannelRequest method.
//    req, resp := client.CreateChannelRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/mediapackage-2017-10-12/CreateChannel
func (c *MediaPackage) CreateChannelRequest(input *CreateChannelInput) (req *request.Request, output *CreateChannelOutput) {
	op := &request.Operation{
		Name:       opCreateChannel,
		HTTPMethod: "POST",
		HTTPPath:   "/channels",
	}

	if input == nil {
		input = &CreateChannelInput{}
	}

	output = &CreateChannelOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateChannel API operation for AWS Elemental MediaPackage.
//
// Creates a new Channel.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Elemental MediaPackage's
// API operation CreateChannel for usage and error information.
//
// Returned Error Types:
//   * UnprocessableEntityException
//
//   * InternalServerErrorException
//
//   * ForbiddenException
//
//   * NotFoundException
//
//   * ServiceUnavailableException
//
//   * TooManyRequestsException
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/mediapackage-2017-10-12/CreateChannel
func (c *MediaPackage) CreateChannel(input *CreateChannelInput) (*CreateChannelOutput, error) {
	req, out := c.CreateChannelRequest(input)
	return out, req.Send()
}

// CreateChannelWithContext is the same as CreateChannel with the addition of
// the ability to pass a context and additional request options.
//
// See CreateChannel for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *MediaPackage) CreateChannelWithContext(ctx aws.Context, input *CreateChannelInput, opts ...request.Option) (*CreateChannelOutput, error) {
	req, out := c.CreateChannelRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateHarvestJob = "CreateHarvestJob"

// CreateHarvestJobRequest generates a "aws/request.Request" representing the
// client's request for the CreateHarvestJob operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateHarvestJob for more information on using the CreateHarvestJob
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateHarvestJobRequest method.
//    req, resp := client.CreateHarvestJobRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/mediapackage-2017-10-12/CreateHarvestJob
func (c *MediaPackage) CreateHarvestJobRequest(input *CreateHarvestJobInput) (req *request.Request, output *CreateHarvestJobOutput) {
	op := &request.Operation{
		Name:       opCreateHarvestJob,
		HTTPMethod: "POST",
		HTTPPath:   "/harvest_jobs",
	}

	if input == nil {
		input = &CreateHarvestJobInput{}
	}

	output = &CreateHarvestJobOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateHarvestJob API operation for AWS Elemental MediaPackage.
//
// Creates a new HarvestJob record.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Elemental MediaPackage's
// API operation CreateHarvestJob for usage and error information.
//
// Returned Error Types:
//   * UnprocessableEntityException
//
//   * InternalServerErrorException
//
//   * ForbiddenException
//
//   * NotFoundException
//
//   * ServiceUnavailableException
//
//   * TooManyRequestsException
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/mediapackage-2017-10-12/CreateHarvestJob
func (c *MediaPackage) CreateHarvestJob(input *CreateHarvestJobInput) (*CreateHarvestJobOutput, error) {
	req, out := c.CreateHarvestJobRequest(input)
	return out, req.Send()
}

// CreateHarvestJobWithContext is the same as CreateHarvestJob with the addition of
// the ability to pass a context and additional request options.
//
// See CreateHarvestJob for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *MediaPackage) CreateHarvestJobWithContext(ctx aws.Context, input *CreateHarvestJobInput, opts ...request.Option) (*CreateHarvestJobOutput, error) {
	req, out := c.CreateHarvestJobRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateOriginEndpoint = "CreateOriginEndpoint"

// CreateOriginEndpointRequest generates a "aws/request.Request" representing the
// client's request for the CreateOriginEndpoint operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateOriginEndpoint for more information on using the CreateOriginEndpoint
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateOriginEndpointRequest method.
//    req, resp := client.CreateOriginEndpointRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/mediapackage-2017-10-12/CreateOriginEndpoint
func (c *MediaPackage) CreateOriginEndpointRequest(input *CreateOriginEndpointInput) (req *request.Request, output *CreateOriginEndpointOutput) {
	op := &request.Operation{
		Name:       opCreateOriginEndpoint,
		HTTPMethod: "POST",
		HTTPPath:   "/origin_endpoints",
	}

	if input == nil {
		input = &CreateOriginEndpointInput{}
	}

	output = &CreateOriginEndpointOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateOriginEndpoint API operation for AWS Elemental MediaPackage.
//
// Creates a new OriginEndpoint record.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Elemental MediaPackage's
// API operation CreateOriginEndpoint for usage and error information.
//
// Returned Error Types:
//   * UnprocessableEntityException
//
//   * InternalServerErrorException
//
//   * ForbiddenException
//
//   * NotFoundException
//
//   * ServiceUnavailableException
//
//   * TooManyRequestsException
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/mediapackage-2017-10-12/CreateOriginEndpoint
func (c *MediaPackage) CreateOriginEndpoint(input *CreateOriginEndpointInput) (*CreateOriginEndpointOutput, error) {
	req, out := c.CreateOriginEndpointRequest(input)
	return out, req.Send()
}

// CreateOriginEndpointWithContext is the same as CreateOriginEndpoint with the addition of
// the ability to pass a context and additional request options.
//
// See CreateOriginEndpoint for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *MediaPackage) CreateOriginEndpointWithContext(ctx aws.Context, input *CreateOriginEndpointInput, opts ...request.Option) (*CreateOriginEndpointOutput, error) {
	req, out := c.CreateOriginEndpointRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteChannel = "DeleteChannel"

// DeleteChannelRequest generates a "aws/request.Request" representing the
// client's request for the DeleteChannel operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteChannel for more information on using the DeleteChannel
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteChannelRequest method.
//    req, resp := client.DeleteChannelRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/mediapackage-2017-10-12/DeleteChannel
func (c *MediaPackage) DeleteChannelRequest(input *DeleteChannelInput) (req *request.Request, output *DeleteChannelOutput) {
	op := &request.Operation{
		Name:       opDeleteChannel,
		HTTPMethod: "DELETE",
		HTTPPath:   "/channels/{id}",
	}

	if input == nil {
		input = &DeleteChannelInput{}
	}

	output = &DeleteChannelOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteChannel API operation for AWS Elemental MediaPackage.
//
// Deletes an existing Channel.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Elemental MediaPackage's
// API operation DeleteChannel for usage and error information.
//
// Returned Error Types:
//   * UnprocessableEntityException
//
//   * InternalServerErrorException
//
//   * ForbiddenException
//
//   * NotFoundException
//
//   * ServiceUnavailableException
//
//   * TooManyRequestsException
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/mediapackage-2017-10-12/DeleteChannel
func (c *MediaPackage) DeleteChannel(input *DeleteChannelInput) (*DeleteChannelOutput, error) {
	req, out := c.DeleteChannelRequest(input)
	return out, req.Send()
}

// DeleteChannelWithContext is the same as DeleteChannel with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteChannel for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *MediaPackage) DeleteChannelWithContext(ctx aws.Context, input *DeleteChannelInput, opts ...request.Option) (*DeleteChannelOutput, error) {
	req, out := c.DeleteChannelRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteOriginEndpoint = "DeleteOriginEndpoint"

// DeleteOriginEndpointRequest generates a "aws/request.Request" representing the
// client's request for the DeleteOriginEndpoint operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteOriginEndpoint for more information on using the DeleteOriginEndpoint
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteOriginEndpointRequest method.
//    req, resp := client.DeleteOriginEndpointRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/mediapackage-2017-10-12/DeleteOriginEndpoint
func (c *MediaPackage) DeleteOriginEndpointRequest(input *DeleteOriginEndpointInput) (req *request.Request, output *DeleteOriginEndpointOutput) {
	op := &request.Operation{
		Name:       opDeleteOriginEndpoint,
		HTTPMethod: "DELETE",
		HTTPPath:   "/origin_endpoints/{id}",
	}

	if input == nil {
		input = &DeleteOriginEndpointInput{}
	}

	output = &DeleteOriginEndpointOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteOriginEndpoint API operation for AWS Elemental MediaPackage.
//
// Deletes an existing OriginEndpoint.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Elemental MediaPackage's
// API operation DeleteOriginEndpoint for usage and error information.
//
// Returned Error Types:
//   * UnprocessableEntityException
//
//   * InternalServerErrorException
//
//   * ForbiddenException
//
//   * NotFoundException
//
//   * ServiceUnavailableException
//
//   * TooManyRequestsException
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/mediapackage-2017-10-12/DeleteOriginEndpoint
func (c *MediaPackage) DeleteOriginEndpoint(input *DeleteOriginEndpointInput) (*DeleteOriginEndpointOutput, error) {
	req, out := c.DeleteOriginEndpointRequest(input)
	return out, req.Send()
}

// DeleteOriginEndpointWithContext is the same as DeleteOriginEndpoint with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteOriginEndpoint for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *MediaPackage) DeleteOriginEndpointWithContext(ctx aws.Context, input *DeleteOriginEndpointInput, opts ...request.Option) (*DeleteOriginEndpointOutput, error) {
	req, out := c.DeleteOriginEndpointRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeChannel = "DescribeChannel"

// DescribeChannelRequest generates a "aws/request.Request" representing the
// client's request for the DescribeChannel operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeChannel for more information on using the DescribeChannel
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeChannelRequest method.
//    req, resp := client.DescribeChannelRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/mediapackage-2017-10-12/DescribeChannel
func (c *MediaPackage) DescribeChannelRequest(input *DescribeChannelInput) (req *request.Request, output *DescribeChannelOutput) {
	op := &request.Operation{
		Name:       opDescribeChannel,
		HTTPMethod: "GET",
		HTTPPath:   "/channels/{id}",
	}

	if input == nil {
		input = &DescribeChannelInput{}
	}

	output = &DescribeChannelOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeChannel API operation for AWS Elemental MediaPackage.
//
// Gets details about a Channel.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Elemental MediaPackage's
// API operation DescribeChannel for usage and error information.
//
// Returned Error Types:
//   * UnprocessableEntityException
//
//   * InternalServerErrorException
//
//   * ForbiddenException
//
//   * NotFoundException
//
//   * ServiceUnavailableException
//
//   * TooManyRequestsException
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/mediapackage-2017-10-12/DescribeChannel
func (c *MediaPackage) DescribeChannel(input *DescribeChannelInput) (*DescribeChannelOutput, error) {
	req, out := c.DescribeChannelRequest(input)
	return out, req.Send()
}

// DescribeChannelWithContext is the same as DescribeChannel with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeChannel for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *MediaPackage) DescribeChannelWithContext(ctx aws.Context, input *DescribeChannelInput, opts ...request.Option) (*DescribeChannelOutput, error) {
	req, out := c.DescribeChannelRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeHarvestJob = "DescribeHarvestJob"

// DescribeHarvestJobRequest generates a "aws/request.Request" representing the
// client's request for the DescribeHarvestJob operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeHarvestJob for more information on using the DescribeHarvestJob
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeHarvestJobRequest method.
//    req, resp := client.DescribeHarvestJobRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/mediapackage-2017-10-12/DescribeHarvestJob
func (c *MediaPackage) DescribeHarvestJobRequest(input *DescribeHarvestJobInput) (req *request.Request, output *DescribeHarvestJobOutput) {
	op := &request.Operation{
		Name:       opDescribeHarvestJob,
		HTTPMethod: "GET",
		HTTPPath:   "/harvest_jobs/{id}",
	}

	if input == nil {
		input = &DescribeHarvestJobInput{}
	}

	output = &DescribeHarvestJobOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeHarvestJob API operation for AWS Elemental MediaPackage.
//
// Gets details about an existing HarvestJob.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Elemental MediaPackage's
// API operation DescribeHarvestJob for usage and error information.
//
// Returned Error Types:
//   * UnprocessableEntityException
//
//   * InternalServerErrorException
//
//   * ForbiddenException
//
//   * NotFoundException
//
//   * ServiceUnavailableException
//
//   * TooManyRequestsException
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/mediapackage-2017-10-12/DescribeHarvestJob
func (c *MediaPackage) DescribeHarvestJob(input *DescribeHarvestJobInput) (*DescribeHarvestJobOutput, error) {
	req, out := c.DescribeHarvestJobRequest(input)
	return out, req.Send()
}

// DescribeHarvestJobWithContext is the same as DescribeHarvestJob with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeHarvestJob for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *MediaPackage) DescribeHarvestJobWithContext(ctx aws.Context, input *DescribeHarvestJobInput, opts ...request.Option) (*DescribeHarvestJobOutput, error) {
	req, out := c.DescribeHarvestJobRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeOriginEndpoint = "DescribeOriginEndpoint"

// DescribeOriginEndpointRequest generates a "aws/request.Request" representing the
// client's request for the DescribeOriginEndpoint operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeOriginEndpoint for more information on using the DescribeOriginEndpoint
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeOriginEndpointRequest method.
//    req, resp := client.DescribeOriginEndpointRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/mediapackage-2017-10-12/DescribeOriginEndpoint
func (c *MediaPackage) DescribeOriginEndpointRequest(input *DescribeOriginEndpointInput) (req *request.Request, output *DescribeOriginEndpointOutput) {
	op := &request.Operation{
		Name:       opDescribeOriginEndpoint,
		HTTPMethod: "GET",
		HTTPPath:   "/origin_endpoints/{id}",
	}

	if input == nil {
		input = &DescribeOriginEndpointInput{}
	}

	output = &DescribeOriginEndpointOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeOriginEndpoint API operation for AWS Elemental MediaPackage.
//
// Gets details about an existing OriginEndpoint.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Elemental MediaPackage's
// API operation DescribeOriginEndpoint for usage and error information.
//
// Returned Error Types:
//   * UnprocessableEntityException
//
//   * InternalServerErrorException
//
//   * ForbiddenException
//
//   * NotFoundException
//
//   * ServiceUnavailableException
//
//   * TooManyRequestsException
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/mediapackage-2017-10-12/DescribeOriginEndpoint
func (c *MediaPackage) DescribeOriginEndpoint(input *DescribeOriginEndpointInput) (*DescribeOriginEndpointOutput, error) {
	req, out := c.DescribeOriginEndpointRequest(input)
	return out, req.Send()
}

// DescribeOriginEndpointWithContext is the same as DescribeOriginEndpoint with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeOriginEndpoint for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *MediaPackage) DescribeOriginEndpointWithContext(ctx aws.Context, input *DescribeOriginEndpointInput, opts ...request.Option) (*DescribeOriginEndpointOutput, error) {
	req, out := c.DescribeOriginEndpointRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListChannels = "ListChannels"

// ListChannelsRequest generates a "aws/request.Request" representing the
// client's request for the ListChannels operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListChannels for more information on using the ListChannels
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListChannelsRequest method.
//    req, resp := client.ListChannelsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/mediapackage-2017-10-12/ListChannels
func (c *MediaPackage) ListChannelsRequest(input *ListChannelsInput) (req *request.Request, output *ListChannelsOutput) {
	op := &request.Operation{
		Name:       opListChannels,
		HTTPMethod: "GET",
		HTTPPath:   "/channels",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListChannelsInput{}
	}

	output = &ListChannelsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListChannels API operation for AWS Elemental MediaPackage.
//
// Returns a collection of Channels.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Elemental MediaPackage's
// API operation ListChannels for usage and error information.
//
// Returned Error Types:
//   * UnprocessableEntityException
//
//   * InternalServerErrorException
//
//   * ForbiddenException
//
//   * NotFoundException
//
//   * ServiceUnavailableException
//
//   * TooManyRequestsException
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/mediapackage-2017-10-12/ListChannels
func (c *MediaPackage) ListChannels(input *ListChannelsInput) (*ListChannelsOutput, error) {
	req, out := c.ListChannelsRequest(input)
	return out, req.Send()
}

// ListChannelsWithContext is the same as ListChannels with the addition of
// the ability to pass a context and additional request options.
//
// See ListChannels for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *MediaPackage) ListChannelsWithContext(ctx aws.Context, input *ListChannelsInput, opts ...request.Option) (*ListChannelsOutput, error) {
	req, out := c.ListChannelsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListChannelsPages iterates over the pages of a ListChannels operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListChannels method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListChannels operation.
//    pageNum := 0
//    err := client.ListChannelsPages(params,
//        func(page *mediapackage.ListChannelsOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *MediaPackage) ListChannelsPages(input *ListChannelsInput, fn func(*ListChannelsOutput, bool) bool) error {
	return c.ListChannelsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListChannelsPagesWithContext same as ListChannelsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *MediaPackage) ListChannelsPagesWithContext(ctx aws.Context, input *ListChannelsInput, fn func(*ListChannelsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListChannelsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListChannelsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListChannelsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListHarvestJobs = "ListHarvestJobs"

// ListHarvestJobsRequest generates a "aws/request.Request" representing the
// client's request for the ListHarvestJobs operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListHarvestJobs for more information on using the ListHarvestJobs
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListHarvestJobsRequest method.
//    req, resp := client.ListHarvestJobsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/mediapackage-2017-10-12/ListHarvestJobs
func (c *MediaPackage) ListHarvestJobsRequest(input *ListHarvestJobsInput) (req *request.Request, output *ListHarvestJobsOutput) {
	op := &request.Operation{
		Name:       opListHarvestJobs,
		HTTPMethod: "GET",
		HTTPPath:   "/harvest_jobs",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListHarvestJobsInput{}
	}

	output = &ListHarvestJobsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListHarvestJobs API operation for AWS Elemental MediaPackage.
//
// Returns a collection of HarvestJob records.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Elemental MediaPackage's
// API operation ListHarvestJobs for usage and error information.
//
// Returned Error Types:
//   * UnprocessableEntityException
//
//   * InternalServerErrorException
//
//   * ForbiddenException
//
//   * NotFoundException
//
//   * ServiceUnavailableException
//
//   * TooManyRequestsException
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/mediapackage-2017-10-12/ListHarvestJobs
func (c *MediaPackage) ListHarvestJobs(input *ListHarvestJobsInput) (*ListHarvestJobsOutput, error) {
	req, out := c.ListHarvestJobsRequest(input)
	return out, req.Send()
}

// ListHarvestJobsWithContext is the same as ListHarvestJobs with the addition of
// the ability to pass a context and additional request options.
//
// See ListHarvestJobs for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *MediaPackage) ListHarvestJobsWithContext(ctx aws.Context, input *ListHarvestJobsInput, opts ...request.Option) (*ListHarvestJobsOutput, error) {
	req, out := c.ListHarvestJobsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListHarvestJobsPages iterates over the pages of a ListHarvestJobs operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListHarvestJobs method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListHarvestJobs operation.
//    pageNum := 0
//    err := client.ListHarvestJobsPages(params,
//        func(page *mediapackage.ListHarvestJobsOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *MediaPackage) ListHarvestJobsPages(input *ListHarvestJobsInput, fn func(*ListHarvestJobsOutput, bool) bool) error {
	return c.ListHarvestJobsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListHarvestJobsPagesWithContext same as ListHarvestJobsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *MediaPackage) ListHarvestJobsPagesWithContext(ctx aws.Context, input *ListHarvestJobsInput, fn func(*ListHarvestJobsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListHarvestJobsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListHarvestJobsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListHarvestJobsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListOriginEndpoints = "ListOriginEndpoints"

// ListOriginEndpointsRequest generates a "aws/request.Request" representing the
// client's request for the ListOriginEndpoints operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListOriginEndpoints for more information on using the ListOriginEndpoints
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListOriginEndpointsRequest method.
//    req, resp := client.ListOriginEndpointsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/mediapackage-2017-10-12/ListOriginEndpoints
func (c *MediaPackage) ListOriginEndpointsRequest(input *ListOriginEndpointsInput) (req *request.Request, output *ListOriginEndpointsOutput) {
	op := &request.Operation{
		Name:       opListOriginEndpoints,
		HTTPMethod: "GET",
		HTTPPath:   "/origin_endpoints",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListOriginEndpointsInput{}
	}

	output = &ListOriginEndpointsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListOriginEndpoints API operation for AWS Elemental MediaPackage.
//
// Returns a collection of OriginEndpoint records.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Elemental MediaPackage's
// API operation ListOriginEndpoints for usage and error information.
//
// Returned Error Types:
//   * UnprocessableEntityException
//
//   * InternalServerErrorException
//
//   * ForbiddenException
//
//   * NotFoundException
//
//   * ServiceUnavailableException
//
//   * TooManyRequestsException
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/mediapackage-2017-10-12/ListOriginEndpoints
func (c *MediaPackage) ListOriginEndpoints(input *ListOriginEndpointsInput) (*ListOriginEndpointsOutput, error) {
	req, out := c.ListOriginEndpointsRequest(input)
	return out, req.Send()
}

// ListOriginEndpointsWithContext is the same as ListOriginEndpoints with the addition of
// the ability to pass a context and additional request options.
//
// See ListOriginEndpoints for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *MediaPackage) ListOriginEndpointsWithContext(ctx aws.Context, input *ListOriginEndpointsInput, opts ...request.Option) (*ListOriginEndpointsOutput, error) {
	req, out := c.ListOriginEndpointsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListOriginEndpointsPages iterates over the pages of a ListOriginEndpoints operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListOriginEndpoints method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListOriginEndpoints operation.
//    pageNum := 0
//    err := client.ListOriginEndpointsPages(params,
//        func(page *mediapackage.ListOriginEndpointsOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *MediaPackage) ListOriginEndpointsPages(input *ListOriginEndpointsInput, fn func(*ListOriginEndpointsOutput, bool) bool) error {
	return c.ListOriginEndpointsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListOriginEndpointsPagesWithContext same as ListOriginEndpointsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *MediaPackage) ListOriginEndpointsPagesWithContext(ctx aws.Context, input *ListOriginEndpointsInput, fn func(*ListOriginEndpointsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListOriginEndpointsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListOriginEndpointsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListOriginEndpointsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListTagsForResource = "ListTagsForResource"

// ListTagsForResourceRequest generates a "aws/request.Request" representing the
// client's request for the ListTagsForResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListTagsForResource for more information on using the ListTagsForResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListTagsForResourceRequest method.
//    req, resp := client.ListTagsForResourceRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/mediapackage-2017-10-12/ListTagsForResource
func (c *MediaPackage) ListTagsForResourceRequest(input *ListTagsForResourceInput) (req *request.Request, output *ListTagsForResourceOutput) {
	op := &request.Operation{
		Name:       opListTagsForResource,
		HTTPMethod: "GET",
		HTTPPath:   "/tags/{resource-arn}",
	}

	if input == nil {
		input = &ListTagsForResourceInput{}
	}

	output = &ListTagsForResourceOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListTagsForResource API operation for AWS Elemental MediaPackage.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Elemental MediaPackage's
// API operation ListTagsForResource for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/mediapackage-2017-10-12/ListTagsForResource
func (c *MediaPackage) ListTagsForResource(input *ListTagsForResourceInput) (*ListTagsForResourceOutput, error) {
	req, out := c.ListTagsForResourceRequest(input)
	return out, req.Send()
}

// ListTagsForResourceWithContext is the same as ListTagsForResource with the addition of
// the ability to pass a context and additional request options.
//
// See ListTagsForResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *MediaPackage) ListTagsForResourceWithContext(ctx aws.Context, input *ListTagsForResourceInput, opts ...request.Option) (*ListTagsForResourceOutput, error) {
	req, out := c.ListTagsForResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opRotateChannelCredentials = "RotateChannelCredentials"

// RotateChannelCredentialsRequest generates a "aws/request.Request" representing the
// client's request for the RotateChannelCredentials operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See RotateChannelCredentials for more information on using the RotateChannelCredentials
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the RotateChannelCredentialsRequest method.
//    req, resp := client.RotateChannelCredentialsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/mediapackage-2017-10-12/RotateChannelCredentials
//
// Deprecated: This API is deprecated. Please use RotateIngestEndpointCredentials instead
func (c *MediaPackage) RotateChannelCredentialsRequest(input *RotateChannelCredentialsInput) (req *request.Request, output *RotateChannelCredentialsOutput) {
	if c.Client.Config.Logger != nil {
		c.Client.Config.Logger.Log("This operation, RotateChannelCredentials, has been deprecated")
	}
	op := &request.Operation{
		Name:       opRotateChannelCredentials,
		HTTPMethod: "PUT",
		HTTPPath:   "/channels/{id}/credentials",
	}

	if input == nil {
		input = &RotateChannelCredentialsInput{}
	}

	output = &RotateChannelCredentialsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// RotateChannelCredentials API operation for AWS Elemental MediaPackage.
//
// Changes the Channel's first IngestEndpoint's username and password. WARNING
// - This API is deprecated. Please use RotateIngestEndpointCredentials instead
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Elemental MediaPackage's
// API operation RotateChannelCredentials for usage and error information.
//
// Returned Error Types:
//   * UnprocessableEntityException
//
//   * InternalServerErrorException
//
//   * ForbiddenException
//
//   * NotFoundException
//
//   * ServiceUnavailableException
//
//   * TooManyRequestsException
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/mediapackage-2017-10-12/RotateChannelCredentials
//
// Deprecated: This API is deprecated. Please use RotateIngestEndpointCredentials instead
func (c *MediaPackage) RotateChannelCredentials(input *RotateChannelCredentialsInput) (*RotateChannelCredentialsOutput, error) {
	req, out := c.RotateChannelCredentialsRequest(input)
	return out, req.Send()
}

// RotateChannelCredentialsWithContext is the same as RotateChannelCredentials with the addition of
// the ability to pass a context and additional request options.
//
// See RotateChannelCredentials for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
//
// Deprecated: This API is deprecated. Please use RotateIngestEndpointCredentials instead
func (c *MediaPackage) RotateChannelCredentialsWithContext(ctx aws.Context, input *RotateChannelCredentialsInput, opts ...request.Option) (*RotateChannelCredentialsOutput, error) {
	req, out := c.RotateChannelCredentialsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opRotateIngestEndpointCredentials = "RotateIngestEndpointCredentials"

// RotateIngestEndpointCredentialsRequest generates a "aws/request.Request" representing the
// client's request for the RotateIngestEndpointCredentials operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See RotateIngestEndpointCredentials for more information on using the RotateIngestEndpointCredentials
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the RotateIngestEndpointCredentialsRequest method.
//    req, resp := client.RotateIngestEndpointCredentialsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/mediapackage-2017-10-12/RotateIngestEndpointCredentials
func (c *MediaPackage) RotateIngestEndpointCredentialsRequest(input *RotateIngestEndpointCredentialsInput) (req *request.Request, output *RotateIngestEndpointCredentialsOutput) {
	op := &request.Operation{
		Name:       opRotateIngestEndpointCredentials,
		HTTPMethod: "PUT",
		HTTPPath:   "/channels/{id}/ingest_endpoints/{ingest_endpoint_id}/credentials",
	}

	if input == nil {
		input = &RotateIngestEndpointCredentialsInput{}
	}

	output = &RotateIngestEndpointCredentialsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// RotateIngestEndpointCredentials API operation for AWS Elemental MediaPackage.
//
// Rotate the IngestEndpoint's username and password, as specified by the IngestEndpoint's
// id.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Elemental MediaPackage's
// API operation RotateIngestEndpointCredentials for usage and error information.
//
// Returned Error Types:
//   * UnprocessableEntityException
//
//   * InternalServerErrorException
//
//   * ForbiddenException
//
//   * NotFoundException
//
//   * ServiceUnavailableException
//
//   * TooManyRequestsException
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/mediapackage-2017-10-12/RotateIngestEndpointCredentials
func (c *MediaPackage) RotateIngestEndpointCredentials(input *RotateIngestEndpointCredentialsInput) (*RotateIngestEndpointCredentialsOutput, error) {
	req, out := c.RotateIngestEndpointCredentialsRequest(input)
	return out, req.Send()
}

// RotateIngestEndpointCredentialsWithContext is the same as RotateIngestEndpointCredentials with the addition of
// the ability to pass a context and additional request options.
//
// See RotateIngestEndpointCredentials for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *MediaPackage) RotateIngestEndpointCredentialsWithContext(ctx aws.Context, input *RotateIngestEndpointCredentialsInput, opts ...request.Option) (*RotateIngestEndpointCredentialsOutput, error) {
	req, out := c.RotateIngestEndpointCredentialsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opTagResource = "TagResource"

// TagResourceRequest generates a "aws/request.Request" representing the
// client's request for the TagResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See TagResource for more information on using the TagResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the TagResourceRequest method.
//    req, resp := client.TagResourceRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/mediapackage-2017-10-12/TagResource
func (c *MediaPackage) TagResourceRequest(input *TagResourceInput) (req *request.Request, output *TagResourceOutput) {
	op := &request.Operation{
		Name:       opTagResource,
		HTTPMethod: "POST",
		HTTPPath:   "/tags/{resource-arn}",
	}

	if input == nil {
		input = &TagResourceInput{}
	}

	output = &TagResourceOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// TagResource API operation for AWS Elemental MediaPackage.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Elemental MediaPackage's
// API operation TagResource for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/mediapackage-2017-10-12/TagResource
func (c *MediaPackage) TagResource(input *TagResourceInput) (*TagResourceOutput, error) {
	req, out := c.TagResourceRequest(input)
	return out, req.Send()
}

// TagResourceWithContext is the same as TagResource with the addition of
// the ability to pass a context and additional request options.
//
// See TagResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *MediaPackage) TagResourceWithContext(ctx aws.Context, input *TagResourceInput, opts ...request.Option) (*TagResourceOutput, error) {
	req, out := c.TagResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUntagResource = "UntagResource"

// UntagResourceRequest generates a "aws/request.Request" representing the
// client's request for the UntagResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UntagResource for more information on using the UntagResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UntagResourceRequest method.
//    req, resp := client.UntagResourceRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/mediapackage-2017-10-12/UntagResource
func (c *MediaPackage) UntagResourceRequest(input *UntagResourceInput) (req *request.Request, output *UntagResourceOutput) {
	op := &request.Operation{
		Name:       opUntagResource,
		HTTPMethod: "DELETE",
		HTTPPath:   "/tags/{resource-arn}",
	}

	if input == nil {
		input = &UntagResourceInput{}
	}

	output = &UntagResourceOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// UntagResource API operation for AWS Elemental MediaPackage.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Elemental MediaPackage's
// API operation UntagResource for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/mediapackage-2017-10-12/UntagResource
func (c *MediaPackage) UntagResource(input *UntagResourceInput) (*UntagResourceOutput, error) {
	req, out := c.UntagResourceRequest(input)
	return out, req.Send()
}

// UntagResourceWithContext is the same as UntagResource with the addition of
// the ability to pass a context and additional request options.
//
// See UntagResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *MediaPackage) UntagResourceWithContext(ctx aws.Context, input *UntagResourceInput, opts ...request.Option) (*UntagResourceOutput, error) {
	req, out := c.UntagResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateChannel = "UpdateChannel"

// UpdateChannelRequest generates a "aws/request.Request" representing the
// client's request for the UpdateChannel operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateChannel for more information on using the UpdateChannel
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdateChannelRequest method.
//    req, resp := client.UpdateChannelRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/mediapackage-2017-10-12/UpdateChannel
func (c *MediaPackage) UpdateChannelRequest(input *UpdateChannelInput) (req *request.Request, output *UpdateChannelOutput) {
	op := &request.Operation{
		Name:       opUpdateChannel,
		HTTPMethod: "PUT",
		HTTPPath:   "/channels/{id}",
	}

	if input == nil {
		input = &UpdateChannelInput{}
	}

	output = &UpdateChannelOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateChannel API operation for AWS Elemental MediaPackage.
//
// Updates an existing Channel.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Elemental MediaPackage's
// API operation UpdateChannel for usage and error information.
//
// Returned Error Types:
//   * UnprocessableEntityException
//
//   * InternalServerErrorException
//
//   * ForbiddenException
//
//   * NotFoundException
//
//   * ServiceUnavailableException
//
//   * TooManyRequestsException
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/mediapackage-2017-10-12/UpdateChannel
func (c *MediaPackage) UpdateChannel(input *UpdateChannelInput) (*UpdateChannelOutput, error) {
	req, out := c.UpdateChannelRequest(input)
	return out, req.Send()
}

// UpdateChannelWithContext is the same as UpdateChannel with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateChannel for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *MediaPackage) UpdateChannelWithContext(ctx aws.Context, input *UpdateChannelInput, opts ...request.Option) (*UpdateChannelOutput, error) {
	req, out := c.UpdateChannelRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateOriginEndpoint = "UpdateOriginEndpoint"

// UpdateOriginEndpointRequest generates a "aws/request.Request" representing the
// client's request for the UpdateOriginEndpoint operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateOriginEndpoint for more information on using the UpdateOriginEndpoint
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdateOriginEndpointRequest method.
//    req, resp := client.UpdateOriginEndpointRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/mediapackage-2017-10-12/UpdateOriginEndpoint
func (c *MediaPackage) UpdateOriginEndpointRequest(input *UpdateOriginEndpointInput) (req *request.Request, output *UpdateOriginEndpointOutput) {
	op := &request.Operation{
		Name:       opUpdateOriginEndpoint,
		HTTPMethod: "PUT",
		HTTPPath:   "/origin_endpoints/{id}",
	}

	if input == nil {
		input = &UpdateOriginEndpointInput{}
	}

	output = &UpdateOriginEndpointOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateOriginEndpoint API operation for AWS Elemental MediaPackage.
//
// Updates an existing OriginEndpoint.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Elemental MediaPackage's
// API operation UpdateOriginEndpoint for usage and error information.
//
// Returned Error Types:
//   * UnprocessableEntityException
//
//   * InternalServerErrorException
//
//   * ForbiddenException
//
//   * NotFoundException
//
//   * ServiceUnavailableException
//
//   * TooManyRequestsException
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/mediapackage-2017-10-12/UpdateOriginEndpoint
func (c *MediaPackage) UpdateOriginEndpoint(input *UpdateOriginEndpointInput) (*UpdateOriginEndpointOutput, error) {
	req, out := c.UpdateOriginEndpointRequest(input)
	return out, req.Send()
}

// UpdateOriginEndpointWithContext is the same as UpdateOriginEndpoint with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateOriginEndpoint for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *MediaPackage) UpdateOriginEndpointWithContext(ctx aws.Context, input *UpdateOriginEndpointInput, opts ...request.Option) (*UpdateOriginEndpointOutput, error) {
	req, out := c.UpdateOriginEndpointRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// CDN Authorization credentials
type Authorization struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) for the secret in Secrets Manager that your
	// Content Distribution Network (CDN) uses for authorization to access your
	// endpoint.
	//
	// CdnIdentifierSecret is a required field
	CdnIdentifierSecret *string `locationName:"cdnIdentifierSecret" type:"string" required:"true"`

	// The Amazon Resource Name (ARN) for the IAM role that allows MediaPackage
	// to communicate with AWS Secrets Manager.
	//
	// SecretsRoleArn is a required field
	SecretsRoleArn *string `locationName:"secretsRoleArn" type:"string" required:"true"`
}

// String returns the string representation
func (s Authorization) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Authorization) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Authorization) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "Authorization"}
	if s.CdnIdentifierSecret == nil {
		invalidParams.Add(request.NewErrParamRequired("CdnIdentifierSecret"))
	}
	if s.SecretsRoleArn == nil {
		invalidParams.Add(request.NewErrParamRequired("SecretsRoleArn"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCdnIdentifierSecret sets the CdnIdentifierSecret field's value.
func (s *Authorization) SetCdnIdentifierSecret(v string) *Authorization {
	s.CdnIdentifierSecret = &v
	return s
}

// SetSecretsRoleArn sets the SecretsRoleArn field's value.
func (s *Authorization) SetSecretsRoleArn(v string) *Authorization {
	s.SecretsRoleArn = &v
	return s
}

// A Channel resource configuration.
type Channel struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) assigned to the Channel.
	Arn *string `locationName:"arn" type:"string"`

	// A short text description of the Channel.
	Description *string `locationName:"description" type:"string"`

	// An HTTP Live Streaming (HLS) ingest resource configuration.
	HlsIngest *HlsIngest `locationName:"hlsIngest" type:"structure"`

	// The ID of the Channel.
	Id *string `locationName:"id" type:"string"`

	// A collection of tags associated with a resource
	Tags map[string]*string `locationName:"tags" type:"map"`
}

// String returns the string representation
func (s Channel) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Channel) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *Channel) SetArn(v string) *Channel {
	s.Arn = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *Channel) SetDescription(v string) *Channel {
	s.Description = &v
	return s
}

// SetHlsIngest sets the HlsIngest field's value.
func (s *Channel) SetHlsIngest(v *HlsIngest) *Channel {
	s.HlsIngest = v
	return s
}

// SetId sets the Id field's value.
func (s *Channel) SetId(v string) *Channel {
	s.Id = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *Channel) SetTags(v map[string]*string) *Channel {
	s.Tags = v
	return s
}

// A Common Media Application Format (CMAF) encryption configuration.
type CmafEncryption struct {
	_ struct{} `type:"structure"`

	// Time (in seconds) between each encryption key rotation.
	KeyRotationIntervalSeconds *int64 `locationName:"keyRotationIntervalSeconds" type:"integer"`

	// A configuration for accessing an external Secure Packager and Encoder Key
	// Exchange (SPEKE) service that will provide encryption keys.
	//
	// SpekeKeyProvider is a required field
	SpekeKeyProvider *SpekeKeyProvider `locationName:"spekeKeyProvider" type:"structure" required:"true"`
}

// String returns the string representation
func (s CmafEncryption) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CmafEncryption) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CmafEncryption) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CmafEncryption"}
	if s.SpekeKeyProvider == nil {
		invalidParams.Add(request.NewErrParamRequired("SpekeKeyProvider"))
	}
	if s.SpekeKeyProvider != nil {
		if err := s.SpekeKeyProvider.Validate(); err != nil {
			invalidParams.AddNested("SpekeKeyProvider", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetKeyRotationIntervalSeconds sets the KeyRotationIntervalSeconds field's value.
func (s *CmafEncryption) SetKeyRotationIntervalSeconds(v int64) *CmafEncryption {
	s.KeyRotationIntervalSeconds = &v
	return s
}

// SetSpekeKeyProvider sets the SpekeKeyProvider field's value.
func (s *CmafEncryption) SetSpekeKeyProvider(v *SpekeKeyProvider) *CmafEncryption {
	s.SpekeKeyProvider = v
	return s
}

// A Common Media Application Format (CMAF) packaging configuration.
type CmafPackage struct {
	_ struct{} `type:"structure"`

	// A Common Media Application Format (CMAF) encryption configuration.
	Encryption *CmafEncryption `locationName:"encryption" type:"structure"`

	// A list of HLS manifest configurations
	HlsManifests []*HlsManifest `locationName:"hlsManifests" type:"list"`

	// Duration (in seconds) of each segment. Actual segments will berounded to
	// the nearest multiple of the source segment duration.
	SegmentDurationSeconds *int64 `locationName:"segmentDurationSeconds" type:"integer"`

	// An optional custom string that is prepended to the name of each segment.
	// If not specified, it defaults to the ChannelId.
	SegmentPrefix *string `locationName:"segmentPrefix" type:"string"`

	// A StreamSelection configuration.
	StreamSelection *StreamSelection `locationName:"streamSelection" type:"structure"`
}

// String returns the string representation
func (s CmafPackage) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CmafPackage) GoString() string {
	return s.String()
}

// SetEncryption sets the Encryption field's value.
func (s *CmafPackage) SetEncryption(v *CmafEncryption) *CmafPackage {
	s.Encryption = v
	return s
}

// SetHlsManifests sets the HlsManifests field's value.
func (s *CmafPackage) SetHlsManifests(v []*HlsManifest) *CmafPackage {
	s.HlsManifests = v
	return s
}

// SetSegmentDurationSeconds sets the SegmentDurationSeconds field's value.
func (s *CmafPackage) SetSegmentDurationSeconds(v int64) *CmafPackage {
	s.SegmentDurationSeconds = &v
	return s
}

// SetSegmentPrefix sets the SegmentPrefix field's value.
func (s *CmafPackage) SetSegmentPrefix(v string) *CmafPackage {
	s.SegmentPrefix = &v
	return s
}

// SetStreamSelection sets the StreamSelection field's value.
func (s *CmafPackage) SetStreamSelection(v *StreamSelection) *CmafPackage {
	s.StreamSelection = v
	return s
}

// A Common Media Application Format (CMAF) packaging configuration.
type CmafPackageCreateOrUpdateParameters struct {
	_ struct{} `type:"structure"`

	// A Common Media Application Format (CMAF) encryption configuration.
	Encryption *CmafEncryption `locationName:"encryption" type:"structure"`

	// A list of HLS manifest configurations
	HlsManifests []*HlsManifestCreateOrUpdateParameters `locationName:"hlsManifests" type:"list"`

	// Duration (in seconds) of each segment. Actual segments will berounded to
	// the nearest multiple of the source segment duration.
	SegmentDurationSeconds *int64 `locationName:"segmentDurationSeconds" type:"integer"`

	// An optional custom string that is prepended to the name of each segment.
	// If not specified, it defaults to the ChannelId.
	SegmentPrefix *string `locationName:"segmentPrefix" type:"string"`

	// A StreamSelection configuration.
	StreamSelection *StreamSelection `locationName:"streamSelection" type:"structure"`
}

// String returns the string representation
func (s CmafPackageCreateOrUpdateParameters) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CmafPackageCreateOrUpdateParameters) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CmafPackageCreateOrUpdateParameters) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CmafPackageCreateOrUpdateParameters"}
	if s.Encryption != nil {
		if err := s.Encryption.Validate(); err != nil {
			invalidParams.AddNested("Encryption", err.(request.ErrInvalidParams))
		}
	}
	if s.HlsManifests != nil {
		for i, v := range s.HlsManifests {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "HlsManifests", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetEncryption sets the Encryption field's value.
func (s *CmafPackageCreateOrUpdateParameters) SetEncryption(v *CmafEncryption) *CmafPackageCreateOrUpdateParameters {
	s.Encryption = v
	return s
}

// SetHlsManifests sets the HlsManifests field's value.
func (s *CmafPackageCreateOrUpdateParameters) SetHlsManifests(v []*HlsManifestCreateOrUpdateParameters) *CmafPackageCreateOrUpdateParameters {
	s.HlsManifests = v
	return s
}

// SetSegmentDurationSeconds sets the SegmentDurationSeconds field's value.
func (s *CmafPackageCreateOrUpdateParameters) SetSegmentDurationSeconds(v int64) *CmafPackageCreateOrUpdateParameters {
	s.SegmentDurationSeconds = &v
	return s
}

// SetSegmentPrefix sets the SegmentPrefix field's value.
func (s *CmafPackageCreateOrUpdateParameters) SetSegmentPrefix(v string) *CmafPackageCreateOrUpdateParameters {
	s.SegmentPrefix = &v
	return s
}

// SetStreamSelection sets the StreamSelection field's value.
func (s *CmafPackageCreateOrUpdateParameters) SetStreamSelection(v *StreamSelection) *CmafPackageCreateOrUpdateParameters {
	s.StreamSelection = v
	return s
}

type CreateChannelInput struct {
	_ struct{} `type:"structure"`

	Description *string `locationName:"description" type:"string"`

	// Id is a required field
	Id *string `locationName:"id" type:"string" required:"true"`

	// A collection of tags associated with a resource
	Tags map[string]*string `locationName:"tags" type:"map"`
}

// String returns the string representation
func (s CreateChannelInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateChannelInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateChannelInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateChannelInput"}
	if s.Id == nil {
		invalidParams.Add(request.NewErrParamRequired("Id"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDescription sets the Description field's value.
func (s *CreateChannelInput) SetDescription(v string) *CreateChannelInput {
	s.Description = &v
	return s
}

// SetId sets the Id field's value.
func (s *CreateChannelInput) SetId(v string) *CreateChannelInput {
	s.Id = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateChannelInput) SetTags(v map[string]*string) *CreateChannelInput {
	s.Tags = v
	return s
}

type CreateChannelOutput struct {
	_ struct{} `type:"structure"`

	Arn *string `locationName:"arn" type:"string"`

	Description *string `locationName:"description" type:"string"`

	// An HTTP Live Streaming (HLS) ingest resource configuration.
	HlsIngest *HlsIngest `locationName:"hlsIngest" type:"structure"`

	Id *string `locationName:"id" type:"string"`

	// A collection of tags associated with a resource
	Tags map[string]*string `locationName:"tags" type:"map"`
}

// String returns the string representation
func (s CreateChannelOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateChannelOutput) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *CreateChannelOutput) SetArn(v string) *CreateChannelOutput {
	s.Arn = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *CreateChannelOutput) SetDescription(v string) *CreateChannelOutput {
	s.Description = &v
	return s
}

// SetHlsIngest sets the HlsIngest field's value.
func (s *CreateChannelOutput) SetHlsIngest(v *HlsIngest) *CreateChannelOutput {
	s.HlsIngest = v
	return s
}

// SetId sets the Id field's value.
func (s *CreateChannelOutput) SetId(v string) *CreateChannelOutput {
	s.Id = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateChannelOutput) SetTags(v map[string]*string) *CreateChannelOutput {
	s.Tags = v
	return s
}

type CreateHarvestJobInput struct {
	_ struct{} `type:"structure"`

	// EndTime is a required field
	EndTime *string `locationName:"endTime" type:"string" required:"true"`

	// Id is a required field
	Id *string `locationName:"id" type:"string" required:"true"`

	// OriginEndpointId is a required field
	OriginEndpointId *string `locationName:"originEndpointId" type:"string" required:"true"`

	// Configuration parameters for where in an S3 bucket to place the harvested
	// content
	//
	// S3Destination is a required field
	S3Destination *S3Destination `locationName:"s3Destination" type:"structure" required:"true"`

	// StartTime is a required field
	StartTime *string `locationName:"startTime" type:"string" required:"true"`
}

// String returns the string representation
func (s CreateHarvestJobInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateHarvestJobInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateHarvestJobInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateHarvestJobInput"}
	if s.EndTime == nil {
		invalidParams.Add(request.NewErrParamRequired("EndTime"))
	}
	if s.Id == nil {
		invalidParams.Add(request.NewErrParamRequired("Id"))
	}
	if s.OriginEndpointId == nil {
		invalidParams.Add(request.NewErrParamRequired("OriginEndpointId"))
	}
	if s.S3Destination == nil {
		invalidParams.Add(request.NewErrParamRequired("S3Destination"))
	}
	if s.StartTime == nil {
		invalidParams.Add(request.NewErrParamRequired("StartTime"))
	}
	if s.S3Destination != nil {
		if err := s.S3Destination.Validate(); err != nil {
			invalidParams.AddNested("S3Destination", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetEndTime sets the EndTime field's value.
func (s *CreateHarvestJobInput) SetEndTime(v string) *CreateHarvestJobInput {
	s.EndTime = &v
	return s
}

// SetId sets the Id field's value.
func (s *CreateHarvestJobInput) SetId(v string) *CreateHarvestJobInput {
	s.Id = &v
	return s
}

// SetOriginEndpointId sets the OriginEndpointId field's value.
func (s *CreateHarvestJobInput) SetOriginEndpointId(v string) *CreateHarvestJobInput {
	s.OriginEndpointId = &v
	return s
}

// SetS3Destination sets the S3Destination field's value.
func (s *CreateHarvestJobInput) SetS3Destination(v *S3Destination) *CreateHarvestJobInput {
	s.S3Destination = v
	return s
}

// SetStartTime sets the StartTime field's value.
func (s *CreateHarvestJobInput) SetStartTime(v string) *CreateHarvestJobInput {
	s.StartTime = &v
	return s
}

type CreateHarvestJobOutput struct {
	_ struct{} `type:"structure"`

	Arn *string `locationName:"arn" type:"string"`

	ChannelId *string `locationName:"channelId" type:"string"`

	CreatedAt *string `locationName:"createdAt" type:"string"`

	EndTime *string `locationName:"endTime" type:"string"`

	Id *string `locationName:"id" type:"string"`

	OriginEndpointId *string `locationName:"originEndpointId" type:"string"`

	// Configuration parameters for where in an S3 bucket to place the harvested
	// content
	S3Destination *S3Destination `locationName:"s3Destination" type:"structure"`

	StartTime *string `locationName:"startTime" type:"string"`

	Status *string `locationName:"status" type:"string" enum:"Status"`
}

// String returns the string representation
func (s CreateHarvestJobOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateHarvestJobOutput) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *CreateHarvestJobOutput) SetArn(v string) *CreateHarvestJobOutput {
	s.Arn = &v
	return s
}

// SetChannelId sets the ChannelId field's value.
func (s *CreateHarvestJobOutput) SetChannelId(v string) *CreateHarvestJobOutput {
	s.ChannelId = &v
	return s
}

// SetCreatedAt sets the CreatedAt field's value.
func (s *CreateHarvestJobOutput) SetCreatedAt(v string) *CreateHarvestJobOutput {
	s.CreatedAt = &v
	return s
}

// SetEndTime sets the EndTime field's value.
func (s *CreateHarvestJobOutput) SetEndTime(v string) *CreateHarvestJobOutput {
	s.EndTime = &v
	return s
}

// SetId sets the Id field's value.
func (s *CreateHarvestJobOutput) SetId(v string) *CreateHarvestJobOutput {
	s.Id = &v
	return s
}

// SetOriginEndpointId sets the OriginEndpointId field's value.
func (s *CreateHarvestJobOutput) SetOriginEndpointId(v string) *CreateHarvestJobOutput {
	s.OriginEndpointId = &v
	return s
}

// SetS3Destination sets the S3Destination field's value.
func (s *CreateHarvestJobOutput) SetS3Destination(v *S3Destination) *CreateHarvestJobOutput {
	s.S3Destination = v
	return s
}

// SetStartTime sets the StartTime field's value.
func (s *CreateHarvestJobOutput) SetStartTime(v string) *CreateHarvestJobOutput {
	s.StartTime = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *CreateHarvestJobOutput) SetStatus(v string) *CreateHarvestJobOutput {
	s.Status = &v
	return s
}

type CreateOriginEndpointInput struct {
	_ struct{} `type:"structure"`

	// CDN Authorization credentials
	Authorization *Authorization `locationName:"authorization" type:"structure"`

	// ChannelId is a required field
	ChannelId *string `locationName:"channelId" type:"string" required:"true"`

	// A Common Media Application Format (CMAF) packaging configuration.
	CmafPackage *CmafPackageCreateOrUpdateParameters `locationName:"cmafPackage" type:"structure"`

	// A Dynamic Adaptive Streaming over HTTP (DASH) packaging configuration.
	DashPackage *DashPackage `locationName:"dashPackage" type:"structure"`

	Description *string `locationName:"description" type:"string"`

	// An HTTP Live Streaming (HLS) packaging configuration.
	HlsPackage *HlsPackage `locationName:"hlsPackage" type:"structure"`

	// Id is a required field
	Id *string `locationName:"id" type:"string" required:"true"`

	ManifestName *string `locationName:"manifestName" type:"string"`

	// A Microsoft Smooth Streaming (MSS) packaging configuration.
	MssPackage *MssPackage `locationName:"mssPackage" type:"structure"`

	Origination *string `locationName:"origination" type:"string" enum:"Origination"`

	StartoverWindowSeconds *int64 `locationName:"startoverWindowSeconds" type:"integer"`

	// A collection of tags associated with a resource
	Tags map[string]*string `locationName:"tags" type:"map"`

	TimeDelaySeconds *int64 `locationName:"timeDelaySeconds" type:"integer"`

	Whitelist []*string `locationName:"whitelist" type:"list"`
}

// String returns the string representation
func (s CreateOriginEndpointInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateOriginEndpointInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateOriginEndpointInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateOriginEndpointInput"}
	if s.ChannelId == nil {
		invalidParams.Add(request.NewErrParamRequired("ChannelId"))
	}
	if s.Id == nil {
		invalidParams.Add(request.NewErrParamRequired("Id"))
	}
	if s.Authorization != nil {
		if err := s.Authorization.Validate(); err != nil {
			invalidParams.AddNested("Authorization", err.(request.ErrInvalidParams))
		}
	}
	if s.CmafPackage != nil {
		if err := s.CmafPackage.Validate(); err != nil {
			invalidParams.AddNested("CmafPackage", err.(request.ErrInvalidParams))
		}
	}
	if s.DashPackage != nil {
		if err := s.DashPackage.Validate(); err != nil {
			invalidParams.AddNested("DashPackage", err.(request.ErrInvalidParams))
		}
	}
	if s.HlsPackage != nil {
		if err := s.HlsPackage.Validate(); err != nil {
			invalidParams.AddNested("HlsPackage", err.(request.ErrInvalidParams))
		}
	}
	if s.MssPackage != nil {
		if err := s.MssPackage.Validate(); err != nil {
			invalidParams.AddNested("MssPackage", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAuthorization sets the Authorization field's value.
func (s *CreateOriginEndpointInput) SetAuthorization(v *Authorization) *CreateOriginEndpointInput {
	s.Authorization = v
	return s
}

// SetChannelId sets the ChannelId field's value.
func (s *CreateOriginEndpointInput) SetChannelId(v string) *CreateOriginEndpointInput {
	s.ChannelId = &v
	return s
}

// SetCmafPackage sets the CmafPackage field's value.
func (s *CreateOriginEndpointInput) SetCmafPackage(v *CmafPackageCreateOrUpdateParameters) *CreateOriginEndpointInput {
	s.CmafPackage = v
	return s
}

// SetDashPackage sets the DashPackage field's value.
func (s *CreateOriginEndpointInput) SetDashPackage(v *DashPackage) *CreateOriginEndpointInput {
	s.DashPackage = v
	return s
}

// SetDescription sets the Description field's value.
func (s *CreateOriginEndpointInput) SetDescription(v string) *CreateOriginEndpointInput {
	s.Description = &v
	return s
}

// SetHlsPackage sets the HlsPackage field's value.
func (s *CreateOriginEndpointInput) SetHlsPackage(v *HlsPackage) *CreateOriginEndpointInput {
	s.HlsPackage = v
	return s
}

// SetId sets the Id field's value.
func (s *CreateOriginEndpointInput) SetId(v string) *CreateOriginEndpointInput {
	s.Id = &v
	return s
}

// SetManifestName sets the ManifestName field's value.
func (s *CreateOriginEndpointInput) SetManifestName(v string) *CreateOriginEndpointInput {
	s.ManifestName = &v
	return s
}

// SetMssPackage sets the MssPackage field's value.
func (s *CreateOriginEndpointInput) SetMssPackage(v *MssPackage) *CreateOriginEndpointInput {
	s.MssPackage = v
	return s
}

// SetOrigination sets the Origination field's value.
func (s *CreateOriginEndpointInput) SetOrigination(v string) *CreateOriginEndpointInput {
	s.Origination = &v
	return s
}

// SetStartoverWindowSeconds sets the StartoverWindowSeconds field's value.
func (s *CreateOriginEndpointInput) SetStartoverWindowSeconds(v int64) *CreateOriginEndpointInput {
	s.StartoverWindowSeconds = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateOriginEndpointInput) SetTags(v map[string]*string) *CreateOriginEndpointInput {
	s.Tags = v
	return s
}

// SetTimeDelaySeconds sets the TimeDelaySeconds field's value.
func (s *CreateOriginEndpointInput) SetTimeDelaySeconds(v int64) *CreateOriginEndpointInput {
	s.TimeDelaySeconds = &v
	return s
}

// SetWhitelist sets the Whitelist field's value.
func (s *CreateOriginEndpointInput) SetWhitelist(v []*string) *CreateOriginEndpointInput {
	s.Whitelist = v
	return s
}

type CreateOriginEndpointOutput struct {
	_ struct{} `type:"structure"`

	Arn *string `locationName:"arn" type:"string"`

	// CDN Authorization credentials
	Authorization *Authorization `locationName:"authorization" type:"structure"`

	ChannelId *string `locationName:"channelId" type:"string"`

	// A Common Media Application Format (CMAF) packaging configuration.
	CmafPackage *CmafPackage `locationName:"cmafPackage" type:"structure"`

	// A Dynamic Adaptive Streaming over HTTP (DASH) packaging configuration.
	DashPackage *DashPackage `locationName:"dashPackage" type:"structure"`

	Description *string `locationName:"description" type:"string"`

	// An HTTP Live Streaming (HLS) packaging configuration.
	HlsPackage *HlsPackage `locationName:"hlsPackage" type:"structure"`

	Id *string `locationName:"id" type:"string"`

	ManifestName *string `locationName:"manifestName" type:"string"`

	// A Microsoft Smooth Streaming (MSS) packaging configuration.
	MssPackage *MssPackage `locationName:"mssPackage" type:"structure"`

	Origination *string `locationName:"origination" type:"string" enum:"Origination"`

	StartoverWindowSeconds *int64 `locationName:"startoverWindowSeconds" type:"integer"`

	// A collection of tags associated with a resource
	Tags map[string]*string `locationName:"tags" type:"map"`

	TimeDelaySeconds *int64 `locationName:"timeDelaySeconds" type:"integer"`

	Url *string `locationName:"url" type:"string"`

	Whitelist []*string `locationName:"whitelist" type:"list"`
}

// String returns the string representation
func (s CreateOriginEndpointOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateOriginEndpointOutput) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *CreateOriginEndpointOutput) SetArn(v string) *CreateOriginEndpointOutput {
	s.Arn = &v
	return s
}

// SetAuthorization sets the Authorization field's value.
func (s *CreateOriginEndpointOutput) SetAuthorization(v *Authorization) *CreateOriginEndpointOutput {
	s.Authorization = v
	return s
}

// SetChannelId sets the ChannelId field's value.
func (s *CreateOriginEndpointOutput) SetChannelId(v string) *CreateOriginEndpointOutput {
	s.ChannelId = &v
	return s
}

// SetCmafPackage sets the CmafPackage field's value.
func (s *CreateOriginEndpointOutput) SetCmafPackage(v *CmafPackage) *CreateOriginEndpointOutput {
	s.CmafPackage = v
	return s
}

// SetDashPackage sets the DashPackage field's value.
func (s *CreateOriginEndpointOutput) SetDashPackage(v *DashPackage) *CreateOriginEndpointOutput {
	s.DashPackage = v
	return s
}

// SetDescription sets the Description field's value.
func (s *CreateOriginEndpointOutput) SetDescription(v string) *CreateOriginEndpointOutput {
	s.Description = &v
	return s
}

// SetHlsPackage sets the HlsPackage field's value.
func (s *CreateOriginEndpointOutput) SetHlsPackage(v *HlsPackage) *CreateOriginEndpointOutput {
	s.HlsPackage = v
	return s
}

// SetId sets the Id field's value.
func (s *CreateOriginEndpointOutput) SetId(v string) *CreateOriginEndpointOutput {
	s.Id = &v
	return s
}

// SetManifestName sets the ManifestName field's value.
func (s *CreateOriginEndpointOutput) SetManifestName(v string) *CreateOriginEndpointOutput {
	s.ManifestName = &v
	return s
}

// SetMssPackage sets the MssPackage field's value.
func (s *CreateOriginEndpointOutput) SetMssPackage(v *MssPackage) *CreateOriginEndpointOutput {
	s.MssPackage = v
	return s
}

// SetOrigination sets the Origination field's value.
func (s *CreateOriginEndpointOutput) SetOrigination(v string) *CreateOriginEndpointOutput {
	s.Origination = &v
	return s
}

// SetStartoverWindowSeconds sets the StartoverWindowSeconds field's value.
func (s *CreateOriginEndpointOutput) SetStartoverWindowSeconds(v int64) *CreateOriginEndpointOutput {
	s.StartoverWindowSeconds = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateOriginEndpointOutput) SetTags(v map[string]*string) *CreateOriginEndpointOutput {
	s.Tags = v
	return s
}

// SetTimeDelaySeconds sets the TimeDelaySeconds field's value.
func (s *CreateOriginEndpointOutput) SetTimeDelaySeconds(v int64) *CreateOriginEndpointOutput {
	s.TimeDelaySeconds = &v
	return s
}

// SetUrl sets the Url field's value.
func (s *CreateOriginEndpointOutput) SetUrl(v string) *CreateOriginEndpointOutput {
	s.Url = &v
	return s
}

// SetWhitelist sets the Whitelist field's value.
func (s *CreateOriginEndpointOutput) SetWhitelist(v []*string) *CreateOriginEndpointOutput {
	s.Whitelist = v
	return s
}

// A Dynamic Adaptive Streaming over HTTP (DASH) encryption configuration.
type DashEncryption struct {
	_ struct{} `type:"structure"`

	// Time (in seconds) between each encryption key rotation.
	KeyRotationIntervalSeconds *int64 `locationName:"keyRotationIntervalSeconds" type:"integer"`

	// A configuration for accessing an external Secure Packager and Encoder Key
	// Exchange (SPEKE) service that will provide encryption keys.
	//
	// SpekeKeyProvider is a required field
	SpekeKeyProvider *SpekeKeyProvider `locationName:"spekeKeyProvider" type:"structure" required:"true"`
}

// String returns the string representation
func (s DashEncryption) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DashEncryption) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DashEncryption) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DashEncryption"}
	if s.SpekeKeyProvider == nil {
		invalidParams.Add(request.NewErrParamRequired("SpekeKeyProvider"))
	}
	if s.SpekeKeyProvider != nil {
		if err := s.SpekeKeyProvider.Validate(); err != nil {
			invalidParams.AddNested("SpekeKeyProvider", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetKeyRotationIntervalSeconds sets the KeyRotationIntervalSeconds field's value.
func (s *DashEncryption) SetKeyRotationIntervalSeconds(v int64) *DashEncryption {
	s.KeyRotationIntervalSeconds = &v
	return s
}

// SetSpekeKeyProvider sets the SpekeKeyProvider field's value.
func (s *DashEncryption) SetSpekeKeyProvider(v *SpekeKeyProvider) *DashEncryption {
	s.SpekeKeyProvider = v
	return s
}

// A Dynamic Adaptive Streaming over HTTP (DASH) packaging configuration.
type DashPackage struct {
	_ struct{} `type:"structure"`

	// A list of SCTE-35 message types that are treated as ad markers in the output.
	// If empty, noad markers are output. Specify multiple items to create ad markers
	// for all of the includedmessage types.
	AdTriggers []*string `locationName:"adTriggers" type:"list"`

	// This setting allows the delivery restriction flags on SCTE-35 segmentation
	// descriptors todetermine whether a message signals an ad. Choosing "NONE"
	// means no SCTE-35 messages becomeads. Choosing "RESTRICTED" means SCTE-35
	// messages of the types specified in AdTriggers thatcontain delivery restrictions
	// will be treated as ads. Choosing "UNRESTRICTED" means SCTE-35messages of
	// the types specified in AdTriggers that do not contain delivery restrictions
	// willbe treated as ads. Choosing "BOTH" means all SCTE-35 messages of the
	// types specified inAdTriggers will be treated as ads. Note that Splice Insert
	// messages do not have these flagsand are always treated as ads if specified
	// in AdTriggers.
	AdsOnDeliveryRestrictions *string `locationName:"adsOnDeliveryRestrictions" type:"string" enum:"AdsOnDeliveryRestrictions"`

	// A Dynamic Adaptive Streaming over HTTP (DASH) encryption configuration.
	Encryption *DashEncryption `locationName:"encryption" type:"structure"`

	// Determines the position of some tags in the Media Presentation Description
	// (MPD). When set to FULL, elements like SegmentTemplate and ContentProtection
	// are included in each Representation. When set to COMPACT, duplicate elements
	// are combined and presented at the AdaptationSet level.
	ManifestLayout *string `locationName:"manifestLayout" type:"string" enum:"ManifestLayout"`

	// Time window (in seconds) contained in each manifest.
	ManifestWindowSeconds *int64 `locationName:"manifestWindowSeconds" type:"integer"`

	// Minimum duration (in seconds) that a player will buffer media before starting
	// the presentation.
	MinBufferTimeSeconds *int64 `locationName:"minBufferTimeSeconds" type:"integer"`

	// Minimum duration (in seconds) between potential changes to the Dynamic Adaptive
	// Streaming over HTTP (DASH) Media Presentation Description (MPD).
	MinUpdatePeriodSeconds *int64 `locationName:"minUpdatePeriodSeconds" type:"integer"`

	// A list of triggers that controls when the outgoing Dynamic Adaptive Streaming
	// over HTTP (DASH)Media Presentation Description (MPD) will be partitioned
	// into multiple periods. If empty, the content will notbe partitioned into
	// more than one period. If the list contains "ADS", new periods will be created
	// wherethe Channel source contains SCTE-35 ad markers.
	PeriodTriggers []*string `locationName:"periodTriggers" type:"list"`

	// The Dynamic Adaptive Streaming over HTTP (DASH) profile type. When set to
	// "HBBTV_1_5", HbbTV 1.5 compliant output is enabled.
	Profile *string `locationName:"profile" type:"string" enum:"Profile"`

	// Duration (in seconds) of each segment. Actual segments will berounded to
	// the nearest multiple of the source segment duration.
	SegmentDurationSeconds *int64 `locationName:"segmentDurationSeconds" type:"integer"`

	// Determines the type of SegmentTemplate included in the Media Presentation
	// Description (MPD). When set to NUMBER_WITH_TIMELINE, a full timeline is presented
	// in each SegmentTemplate, with $Number$ media URLs. When set to TIME_WITH_TIMELINE,
	// a full timeline is presented in each SegmentTemplate, with $Time$ media URLs.
	// When set to NUMBER_WITH_DURATION, only a duration is included in each SegmentTemplate,
	// with $Number$ media URLs.
	SegmentTemplateFormat *string `locationName:"segmentTemplateFormat" type:"string" enum:"SegmentTemplateFormat"`

	// A StreamSelection configuration.
	StreamSelection *StreamSelection `locationName:"streamSelection" type:"structure"`

	// Duration (in seconds) to delay live content before presentation.
	SuggestedPresentationDelaySeconds *int64 `locationName:"suggestedPresentationDelaySeconds" type:"integer"`
}

// String returns the string representation
func (s DashPackage) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DashPackage) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DashPackage) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DashPackage"}
	if s.Encryption != nil {
		if err := s.Encryption.Validate(); err != nil {
			invalidParams.AddNested("Encryption", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAdTriggers sets the AdTriggers field's value.
func (s *DashPackage) SetAdTriggers(v []*string) *DashPackage {
	s.AdTriggers = v
	return s
}

// SetAdsOnDeliveryRestrictions sets the AdsOnDeliveryRestrictions field's value.
func (s *DashPackage) SetAdsOnDeliveryRestrictions(v string) *DashPackage {
	s.AdsOnDeliveryRestrictions = &v
	return s
}

// SetEncryption sets the Encryption field's value.
func (s *DashPackage) SetEncryption(v *DashEncryption) *DashPackage {
	s.Encryption = v
	return s
}

// SetManifestLayout sets the ManifestLayout field's value.
func (s *DashPackage) SetManifestLayout(v string) *DashPackage {
	s.ManifestLayout = &v
	return s
}

// SetManifestWindowSeconds sets the ManifestWindowSeconds field's value.
func (s *DashPackage) SetManifestWindowSeconds(v int64) *DashPackage {
	s.ManifestWindowSeconds = &v
	return s
}

// SetMinBufferTimeSeconds sets the MinBufferTimeSeconds field's value.
func (s *DashPackage) SetMinBufferTimeSeconds(v int64) *DashPackage {
	s.MinBufferTimeSeconds = &v
	return s
}

// SetMinUpdatePeriodSeconds sets the MinUpdatePeriodSeconds field's value.
func (s *DashPackage) SetMinUpdatePeriodSeconds(v int64) *DashPackage {
	s.MinUpdatePeriodSeconds = &v
	return s
}

// SetPeriodTriggers sets the PeriodTriggers field's value.
func (s *DashPackage) SetPeriodTriggers(v []*string) *DashPackage {
	s.PeriodTriggers = v
	return s
}

// SetProfile sets the Profile field's value.
func (s *DashPackage) SetProfile(v string) *DashPackage {
	s.Profile = &v
	return s
}

// SetSegmentDurationSeconds sets the SegmentDurationSeconds field's value.
func (s *DashPackage) SetSegmentDurationSeconds(v int64) *DashPackage {
	s.SegmentDurationSeconds = &v
	return s
}

// SetSegmentTemplateFormat sets the SegmentTemplateFormat field's value.
func (s *DashPackage) SetSegmentTemplateFormat(v string) *DashPackage {
	s.SegmentTemplateFormat = &v
	return s
}

// SetStreamSelection sets the StreamSelection field's value.
func (s *DashPackage) SetStreamSelection(v *StreamSelection) *DashPackage {
	s.StreamSelection = v
	return s
}

// SetSuggestedPresentationDelaySeconds sets the SuggestedPresentationDelaySeconds field's value.
func (s *DashPackage) SetSuggestedPresentationDelaySeconds(v int64) *DashPackage {
	s.SuggestedPresentationDelaySeconds = &v
	return s
}

type DeleteChannelInput struct {
	_ struct{} `type:"structure"`

	// Id is a required field
	Id *string `location:"uri" locationName:"id" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteChannelInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteChannelInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteChannelInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteChannelInput"}
	if s.Id == nil {
		invalidParams.Add(request.NewErrParamRequired("Id"))
	}
	if s.Id != nil && len(*s.Id) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Id", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetId sets the Id field's value.
func (s *DeleteChannelInput) SetId(v string) *DeleteChannelInput {
	s.Id = &v
	return s
}

type DeleteChannelOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteChannelOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteChannelOutput) GoString() string {
	return s.String()
}

type DeleteOriginEndpointInput struct {
	_ struct{} `type:"structure"`

	// Id is a required field
	Id *string `location:"uri" locationName:"id" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteOriginEndpointInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteOriginEndpointInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteOriginEndpointInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteOriginEndpointInput"}
	if s.Id == nil {
		invalidParams.Add(request.NewErrParamRequired("Id"))
	}
	if s.Id != nil && len(*s.Id) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Id", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetId sets the Id field's value.
func (s *DeleteOriginEndpointInput) SetId(v string) *DeleteOriginEndpointInput {
	s.Id = &v
	return s
}

type DeleteOriginEndpointOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteOriginEndpointOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteOriginEndpointOutput) GoString() string {
	return s.String()
}

type DescribeChannelInput struct {
	_ struct{} `type:"structure"`

	// Id is a required field
	Id *string `location:"uri" locationName:"id" type:"string" required:"true"`
}

// String returns the string representation
func (s DescribeChannelInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeChannelInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeChannelInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeChannelInput"}
	if s.Id == nil {
		invalidParams.Add(request.NewErrParamRequired("Id"))
	}
	if s.Id != nil && len(*s.Id) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Id", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetId sets the Id field's value.
func (s *DescribeChannelInput) SetId(v string) *DescribeChannelInput {
	s.Id = &v
	return s
}

type DescribeChannelOutput struct {
	_ struct{} `type:"structure"`

	Arn *string `locationName:"arn" type:"string"`

	Description *string `locationName:"description" type:"string"`

	// An HTTP Live Streaming (HLS) ingest resource configuration.
	HlsIngest *HlsIngest `locationName:"hlsIngest" type:"structure"`

	Id *string `locationName:"id" type:"string"`

	// A collection of tags associated with a resource
	Tags map[string]*string `locationName:"tags" type:"map"`
}

// String returns the string representation
func (s DescribeChannelOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeChannelOutput) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *DescribeChannelOutput) SetArn(v string) *DescribeChannelOutput {
	s.Arn = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *DescribeChannelOutput) SetDescription(v string) *DescribeChannelOutput {
	s.Description = &v
	return s
}

// SetHlsIngest sets the HlsIngest field's value.
func (s *DescribeChannelOutput) SetHlsIngest(v *HlsIngest) *DescribeChannelOutput {
	s.HlsIngest = v
	return s
}

// SetId sets the Id field's value.
func (s *DescribeChannelOutput) SetId(v string) *DescribeChannelOutput {
	s.Id = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *DescribeChannelOutput) SetTags(v map[string]*string) *DescribeChannelOutput {
	s.Tags = v
	return s
}

type DescribeHarvestJobInput struct {
	_ struct{} `type:"structure"`

	// Id is a required field
	Id *string `location:"uri" locationName:"id" type:"string" required:"true"`
}

// String returns the string representation
func (s DescribeHarvestJobInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeHarvestJobInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeHarvestJobInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeHarvestJobInput"}
	if s.Id == nil {
		invalidParams.Add(request.NewErrParamRequired("Id"))
	}
	if s.Id != nil && len(*s.Id) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Id", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetId sets the Id field's value.
func (s *DescribeHarvestJobInput) SetId(v string) *DescribeHarvestJobInput {
	s.Id = &v
	return s
}

type DescribeHarvestJobOutput struct {
	_ struct{} `type:"structure"`

	Arn *string `locationName:"arn" type:"string"`

	ChannelId *string `locationName:"channelId" type:"string"`

	CreatedAt *string `locationName:"createdAt" type:"string"`

	EndTime *string `locationName:"endTime" type:"string"`

	Id *string `locationName:"id" type:"string"`

	OriginEndpointId *string `locationName:"originEndpointId" type:"string"`

	// Configuration parameters for where in an S3 bucket to place the harvested
	// content
	S3Destination *S3Destination `locationName:"s3Destination" type:"structure"`

	StartTime *string `locationName:"startTime" type:"string"`

	Status *string `locationName:"status" type:"string" enum:"Status"`
}

// String returns the string representation
func (s DescribeHarvestJobOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeHarvestJobOutput) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *DescribeHarvestJobOutput) SetArn(v string) *DescribeHarvestJobOutput {
	s.Arn = &v
	return s
}

// SetChannelId sets the ChannelId field's value.
func (s *DescribeHarvestJobOutput) SetChannelId(v string) *DescribeHarvestJobOutput {
	s.ChannelId = &v
	return s
}

// SetCreatedAt sets the CreatedAt field's value.
func (s *DescribeHarvestJobOutput) SetCreatedAt(v string) *DescribeHarvestJobOutput {
	s.CreatedAt = &v
	return s
}

// SetEndTime sets the EndTime field's value.
func (s *DescribeHarvestJobOutput) SetEndTime(v string) *DescribeHarvestJobOutput {
	s.EndTime = &v
	return s
}

// SetId sets the Id field's value.
func (s *DescribeHarvestJobOutput) SetId(v string) *DescribeHarvestJobOutput {
	s.Id = &v
	return s
}

// SetOriginEndpointId sets the OriginEndpointId field's value.
func (s *DescribeHarvestJobOutput) SetOriginEndpointId(v string) *DescribeHarvestJobOutput {
	s.OriginEndpointId = &v
	return s
}

// SetS3Destination sets the S3Destination field's value.
func (s *DescribeHarvestJobOutput) SetS3Destination(v *S3Destination) *DescribeHarvestJobOutput {
	s.S3Destination = v
	return s
}

// SetStartTime sets the StartTime field's value.
func (s *DescribeHarvestJobOutput) SetStartTime(v string) *DescribeHarvestJobOutput {
	s.StartTime = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *DescribeHarvestJobOutput) SetStatus(v string) *DescribeHarvestJobOutput {
	s.Status = &v
	return s
}

type DescribeOriginEndpointInput struct {
	_ struct{} `type:"structure"`

	// Id is a required field
	Id *string `location:"uri" locationName:"id" type:"string" required:"true"`
}

// String returns the string representation
func (s DescribeOriginEndpointInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeOriginEndpointInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeOriginEndpointInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeOriginEndpointInput"}
	if s.Id == nil {
		invalidParams.Add(request.NewErrParamRequired("Id"))
	}
	if s.Id != nil && len(*s.Id) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Id", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetId sets the Id field's value.
func (s *DescribeOriginEndpointInput) SetId(v string) *DescribeOriginEndpointInput {
	s.Id = &v
	return s
}

type DescribeOriginEndpointOutput struct {
	_ struct{} `type:"structure"`

	Arn *string `locationName:"arn" type:"string"`

	// CDN Authorization credentials
	Authorization *Authorization `locationName:"authorization" type:"structure"`

	ChannelId *string `locationName:"channelId" type:"string"`

	// A Common Media Application Format (CMAF) packaging configuration.
	CmafPackage *CmafPackage `locationName:"cmafPackage" type:"structure"`

	// A Dynamic Adaptive Streaming over HTTP (DASH) packaging configuration.
	DashPackage *DashPackage `locationName:"dashPackage" type:"structure"`

	Description *string `locationName:"description" type:"string"`

	// An HTTP Live Streaming (HLS) packaging configuration.
	HlsPackage *HlsPackage `locationName:"hlsPackage" type:"structure"`

	Id *string `locationName:"id" type:"string"`

	ManifestName *string `locationName:"manifestName" type:"string"`

	// A Microsoft Smooth Streaming (MSS) packaging configuration.
	MssPackage *MssPackage `locationName:"mssPackage" type:"structure"`

	Origination *string `locationName:"origination" type:"string" enum:"Origination"`

	StartoverWindowSeconds *int64 `locationName:"startoverWindowSeconds" type:"integer"`

	// A collection of tags associated with a resource
	Tags map[string]*string `locationName:"tags" type:"map"`

	TimeDelaySeconds *int64 `locationName:"timeDelaySeconds" type:"integer"`

	Url *string `locationName:"url" type:"string"`

	Whitelist []*string `locationName:"whitelist" type:"list"`
}

// String returns the string representation
func (s DescribeOriginEndpointOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeOriginEndpointOutput) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *DescribeOriginEndpointOutput) SetArn(v string) *DescribeOriginEndpointOutput {
	s.Arn = &v
	return s
}

// SetAuthorization sets the Authorization field's value.
func (s *DescribeOriginEndpointOutput) SetAuthorization(v *Authorization) *DescribeOriginEndpointOutput {
	s.Authorization = v
	return s
}

// SetChannelId sets the ChannelId field's value.
func (s *DescribeOriginEndpointOutput) SetChannelId(v string) *DescribeOriginEndpointOutput {
	s.ChannelId = &v
	return s
}

// SetCmafPackage sets the CmafPackage field's value.
func (s *DescribeOriginEndpointOutput) SetCmafPackage(v *CmafPackage) *DescribeOriginEndpointOutput {
	s.CmafPackage = v
	return s
}

// SetDashPackage sets the DashPackage field's value.
func (s *DescribeOriginEndpointOutput) SetDashPackage(v *DashPackage) *DescribeOriginEndpointOutput {
	s.DashPackage = v
	return s
}

// SetDescription sets the Description field's value.
func (s *DescribeOriginEndpointOutput) SetDescription(v string) *DescribeOriginEndpointOutput {
	s.Description = &v
	return s
}

// SetHlsPackage sets the HlsPackage field's value.
func (s *DescribeOriginEndpointOutput) SetHlsPackage(v *HlsPackage) *DescribeOriginEndpointOutput {
	s.HlsPackage = v
	return s
}

// SetId sets the Id field's value.
func (s *DescribeOriginEndpointOutput) SetId(v string) *DescribeOriginEndpointOutput {
	s.Id = &v
	return s
}

// SetManifestName sets the ManifestName field's value.
func (s *DescribeOriginEndpointOutput) SetManifestName(v string) *DescribeOriginEndpointOutput {
	s.ManifestName = &v
	return s
}

// SetMssPackage sets the MssPackage field's value.
func (s *DescribeOriginEndpointOutput) SetMssPackage(v *MssPackage) *DescribeOriginEndpointOutput {
	s.MssPackage = v
	return s
}

// SetOrigination sets the Origination field's value.
func (s *DescribeOriginEndpointOutput) SetOrigination(v string) *DescribeOriginEndpointOutput {
	s.Origination = &v
	return s
}

// SetStartoverWindowSeconds sets the StartoverWindowSeconds field's value.
func (s *DescribeOriginEndpointOutput) SetStartoverWindowSeconds(v int64) *DescribeOriginEndpointOutput {
	s.StartoverWindowSeconds = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *DescribeOriginEndpointOutput) SetTags(v map[string]*string) *DescribeOriginEndpointOutput {
	s.Tags = v
	return s
}

// SetTimeDelaySeconds sets the TimeDelaySeconds field's value.
func (s *DescribeOriginEndpointOutput) SetTimeDelaySeconds(v int64) *DescribeOriginEndpointOutput {
	s.TimeDelaySeconds = &v
	return s
}

// SetUrl sets the Url field's value.
func (s *DescribeOriginEndpointOutput) SetUrl(v string) *DescribeOriginEndpointOutput {
	s.Url = &v
	return s
}

// SetWhitelist sets the Whitelist field's value.
func (s *DescribeOriginEndpointOutput) SetWhitelist(v []*string) *DescribeOriginEndpointOutput {
	s.Whitelist = v
	return s
}

type ForbiddenException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation
func (s ForbiddenException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ForbiddenException) GoString() string {
	return s.String()
}

func newErrorForbiddenException(v protocol.ResponseMetadata) error {
	return &ForbiddenException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ForbiddenException) Code() string {
	return "ForbiddenException"
}

// Message returns the exception's message.
func (s *ForbiddenException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ForbiddenException) OrigErr() error {
	return nil
}

func (s *ForbiddenException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ForbiddenException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ForbiddenException) RequestID() string {
	return s.RespMetadata.RequestID
}

// A HarvestJob resource configuration
type HarvestJob struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) assigned to the HarvestJob.
	Arn *string `locationName:"arn" type:"string"`

	// The ID of the Channel that the HarvestJob will harvest from.
	ChannelId *string `locationName:"channelId" type:"string"`

	// The time the HarvestJob was submitted
	CreatedAt *string `locationName:"createdAt" type:"string"`

	// The end of the time-window which will be harvested.
	EndTime *string `locationName:"endTime" type:"string"`

	// The ID of the HarvestJob. The ID must be unique within the regionand it cannot
	// be changed after the HarvestJob is submitted.
	Id *string `locationName:"id" type:"string"`

	// The ID of the OriginEndpoint that the HarvestJob will harvest from.This cannot
	// be changed after the HarvestJob is submitted.
	OriginEndpointId *string `locationName:"originEndpointId" type:"string"`

	// Configuration parameters for where in an S3 bucket to place the harvested
	// content
	S3Destination *S3Destination `locationName:"s3Destination" type:"structure"`

	// The start of the time-window which will be harvested.
	StartTime *string `locationName:"startTime" type:"string"`

	// The current status of the HarvestJob. Consider setting up a CloudWatch Event
	// to listen forHarvestJobs as they succeed or fail. In the event of failure,
	// the CloudWatch Event willinclude an explanation of why the HarvestJob failed.
	Status *string `locationName:"status" type:"string" enum:"Status"`
}

// String returns the string representation
func (s HarvestJob) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s HarvestJob) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *HarvestJob) SetArn(v string) *HarvestJob {
	s.Arn = &v
	return s
}

// SetChannelId sets the ChannelId field's value.
func (s *HarvestJob) SetChannelId(v string) *HarvestJob {
	s.ChannelId = &v
	return s
}

// SetCreatedAt sets the CreatedAt field's value.
func (s *HarvestJob) SetCreatedAt(v string) *HarvestJob {
	s.CreatedAt = &v
	return s
}

// SetEndTime sets the EndTime field's value.
func (s *HarvestJob) SetEndTime(v string) *HarvestJob {
	s.EndTime = &v
	return s
}

// SetId sets the Id field's value.
func (s *HarvestJob) SetId(v string) *HarvestJob {
	s.Id = &v
	return s
}

// SetOriginEndpointId sets the OriginEndpointId field's value.
func (s *HarvestJob) SetOriginEndpointId(v string) *HarvestJob {
	s.OriginEndpointId = &v
	return s
}

// SetS3Destination sets the S3Destination field's value.
func (s *HarvestJob) SetS3Destination(v *S3Destination) *HarvestJob {
	s.S3Destination = v
	return s
}

// SetStartTime sets the StartTime field's value.
func (s *HarvestJob) SetStartTime(v string) *HarvestJob {
	s.StartTime = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *HarvestJob) SetStatus(v string) *HarvestJob {
	s.Status = &v
	return s
}

// An HTTP Live Streaming (HLS) encryption configuration.
type HlsEncryption struct {
	_ struct{} `type:"structure"`

	// A constant initialization vector for encryption (optional).When not specified
	// the initialization vector will be periodically rotated.
	ConstantInitializationVector *string `locationName:"constantInitializationVector" type:"string"`

	// The encryption method to use.
	EncryptionMethod *string `locationName:"encryptionMethod" type:"string" enum:"EncryptionMethod"`

	// Interval (in seconds) between each encryption key rotation.
	KeyRotationIntervalSeconds *int64 `locationName:"keyRotationIntervalSeconds" type:"integer"`

	// When enabled, the EXT-X-KEY tag will be repeated in output manifests.
	RepeatExtXKey *bool `locationName:"repeatExtXKey" type:"boolean"`

	// A configuration for accessing an external Secure Packager and Encoder Key
	// Exchange (SPEKE) service that will provide encryption keys.
	//
	// SpekeKeyProvider is a required field
	SpekeKeyProvider *SpekeKeyProvider `locationName:"spekeKeyProvider" type:"structure" required:"true"`
}

// String returns the string representation
func (s HlsEncryption) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s HlsEncryption) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *HlsEncryption) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "HlsEncryption"}
	if s.SpekeKeyProvider == nil {
		invalidParams.Add(request.NewErrParamRequired("SpekeKeyProvider"))
	}
	if s.SpekeKeyProvider != nil {
		if err := s.SpekeKeyProvider.Validate(); err != nil {
			invalidParams.AddNested("SpekeKeyProvider", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetConstantInitializationVector sets the ConstantInitializationVector field's value.
func (s *HlsEncryption) SetConstantInitializationVector(v string) *HlsEncryption {
	s.ConstantInitializationVector = &v
	return s
}

// SetEncryptionMethod sets the EncryptionMethod field's value.
func (s *HlsEncryption) SetEncryptionMethod(v string) *HlsEncryption {
	s.EncryptionMethod = &v
	return s
}

// SetKeyRotationIntervalSeconds sets the KeyRotationIntervalSeconds field's value.
func (s *HlsEncryption) SetKeyRotationIntervalSeconds(v int64) *HlsEncryption {
	s.KeyRotationIntervalSeconds = &v
	return s
}

// SetRepeatExtXKey sets the RepeatExtXKey field's value.
func (s *HlsEncryption) SetRepeatExtXKey(v bool) *HlsEncryption {
	s.RepeatExtXKey = &v
	return s
}

// SetSpekeKeyProvider sets the SpekeKeyProvider field's value.
func (s *HlsEncryption) SetSpekeKeyProvider(v *SpekeKeyProvider) *HlsEncryption {
	s.SpekeKeyProvider = v
	return s
}

// An HTTP Live Streaming (HLS) ingest resource configuration.
type HlsIngest struct {
	_ struct{} `type:"structure"`

	// A list of endpoints to which the source stream should be sent.
	IngestEndpoints []*IngestEndpoint `locationName:"ingestEndpoints" type:"list"`
}

// String returns the string representation
func (s HlsIngest) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s HlsIngest) GoString() string {
	return s.String()
}

// SetIngestEndpoints sets the IngestEndpoints field's value.
func (s *HlsIngest) SetIngestEndpoints(v []*IngestEndpoint) *HlsIngest {
	s.IngestEndpoints = v
	return s
}

// A HTTP Live Streaming (HLS) manifest configuration.
type HlsManifest struct {
	_ struct{} `type:"structure"`

	// This setting controls how ad markers are included in the packaged OriginEndpoint."NONE"
	// will omit all SCTE-35 ad markers from the output."PASSTHROUGH" causes the
	// manifest to contain a copy of the SCTE-35 admarkers (comments) taken directly
	// from the input HTTP Live Streaming (HLS) manifest."SCTE35_ENHANCED" generates
	// ad markers and blackout tags based on SCTE-35messages in the input source.
	AdMarkers *string `locationName:"adMarkers" type:"string" enum:"AdMarkers"`

	// The ID of the manifest. The ID must be unique within the OriginEndpoint and
	// it cannot be changed after it is created.
	//
	// Id is a required field
	Id *string `locationName:"id" type:"string" required:"true"`

	// When enabled, an I-Frame only stream will be included in the output.
	IncludeIframeOnlyStream *bool `locationName:"includeIframeOnlyStream" type:"boolean"`

	// An optional short string appended to the end of the OriginEndpoint URL. If
	// not specified, defaults to the manifestName for the OriginEndpoint.
	ManifestName *string `locationName:"manifestName" type:"string"`

	// The HTTP Live Streaming (HLS) playlist type.When either "EVENT" or "VOD"
	// is specified, a corresponding EXT-X-PLAYLIST-TYPEentry will be included in
	// the media playlist.
	PlaylistType *string `locationName:"playlistType" type:"string" enum:"PlaylistType"`

	// Time window (in seconds) contained in each parent manifest.
	PlaylistWindowSeconds *int64 `locationName:"playlistWindowSeconds" type:"integer"`

	// The interval (in seconds) between each EXT-X-PROGRAM-DATE-TIME taginserted
	// into manifests. Additionally, when an interval is specifiedID3Timed Metadata
	// messages will be generated every 5 seconds using theingest time of the content.If
	// the interval is not specified, or set to 0, thenno EXT-X-PROGRAM-DATE-TIME
	// tags will be inserted into manifests and noID3Timed Metadata messages will
	// be generated. Note that irrespectiveof this parameter, if any ID3 Timed Metadata
	// is found in HTTP Live Streaming (HLS) input,it will be passed through to
	// HLS output.
	ProgramDateTimeIntervalSeconds *int64 `locationName:"programDateTimeIntervalSeconds" type:"integer"`

	// The URL of the packaged OriginEndpoint for consumption.
	Url *string `locationName:"url" type:"string"`
}

// String returns the string representation
func (s HlsManifest) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s HlsManifest) GoString() string {
	return s.String()
}

// SetAdMarkers sets the AdMarkers field's value.
func (s *HlsManifest) SetAdMarkers(v string) *HlsManifest {
	s.AdMarkers = &v
	return s
}

// SetId sets the Id field's value.
func (s *HlsManifest) SetId(v string) *HlsManifest {
	s.Id = &v
	return s
}

// SetIncludeIframeOnlyStream sets the IncludeIframeOnlyStream field's value.
func (s *HlsManifest) SetIncludeIframeOnlyStream(v bool) *HlsManifest {
	s.IncludeIframeOnlyStream = &v
	return s
}

// SetManifestName sets the ManifestName field's value.
func (s *HlsManifest) SetManifestName(v string) *HlsManifest {
	s.ManifestName = &v
	return s
}

// SetPlaylistType sets the PlaylistType field's value.
func (s *HlsManifest) SetPlaylistType(v string) *HlsManifest {
	s.PlaylistType = &v
	return s
}

// SetPlaylistWindowSeconds sets the PlaylistWindowSeconds field's value.
func (s *HlsManifest) SetPlaylistWindowSeconds(v int64) *HlsManifest {
	s.PlaylistWindowSeconds = &v
	return s
}

// SetProgramDateTimeIntervalSeconds sets the ProgramDateTimeIntervalSeconds field's value.
func (s *HlsManifest) SetProgramDateTimeIntervalSeconds(v int64) *HlsManifest {
	s.ProgramDateTimeIntervalSeconds = &v
	return s
}

// SetUrl sets the Url field's value.
func (s *HlsManifest) SetUrl(v string) *HlsManifest {
	s.Url = &v
	return s
}

// A HTTP Live Streaming (HLS) manifest configuration.
type HlsManifestCreateOrUpdateParameters struct {
	_ struct{} `type:"structure"`

	// This setting controls how ad markers are included in the packaged OriginEndpoint."NONE"
	// will omit all SCTE-35 ad markers from the output."PASSTHROUGH" causes the
	// manifest to contain a copy of the SCTE-35 admarkers (comments) taken directly
	// from the input HTTP Live Streaming (HLS) manifest."SCTE35_ENHANCED" generates
	// ad markers and blackout tags based on SCTE-35messages in the input source.
	AdMarkers *string `locationName:"adMarkers" type:"string" enum:"AdMarkers"`

	// A list of SCTE-35 message types that are treated as ad markers in the output.
	// If empty, noad markers are output. Specify multiple items to create ad markers
	// for all of the includedmessage types.
	AdTriggers []*string `locationName:"adTriggers" type:"list"`

	// This setting allows the delivery restriction flags on SCTE-35 segmentation
	// descriptors todetermine whether a message signals an ad. Choosing "NONE"
	// means no SCTE-35 messages becomeads. Choosing "RESTRICTED" means SCTE-35
	// messages of the types specified in AdTriggers thatcontain delivery restrictions
	// will be treated as ads. Choosing "UNRESTRICTED" means SCTE-35messages of
	// the types specified in AdTriggers that do not contain delivery restrictions
	// willbe treated as ads. Choosing "BOTH" means all SCTE-35 messages of the
	// types specified inAdTriggers will be treated as ads. Note that Splice Insert
	// messages do not have these flagsand are always treated as ads if specified
	// in AdTriggers.
	AdsOnDeliveryRestrictions *string `locationName:"adsOnDeliveryRestrictions" type:"string" enum:"AdsOnDeliveryRestrictions"`

	// The ID of the manifest. The ID must be unique within the OriginEndpoint and
	// it cannot be changed after it is created.
	//
	// Id is a required field
	Id *string `locationName:"id" type:"string" required:"true"`

	// When enabled, an I-Frame only stream will be included in the output.
	IncludeIframeOnlyStream *bool `locationName:"includeIframeOnlyStream" type:"boolean"`

	// An optional short string appended to the end of the OriginEndpoint URL. If
	// not specified, defaults to the manifestName for the OriginEndpoint.
	ManifestName *string `locationName:"manifestName" type:"string"`

	// The HTTP Live Streaming (HLS) playlist type.When either "EVENT" or "VOD"
	// is specified, a corresponding EXT-X-PLAYLIST-TYPEentry will be included in
	// the media playlist.
	PlaylistType *string `locationName:"playlistType" type:"string" enum:"PlaylistType"`

	// Time window (in seconds) contained in each parent manifest.
	PlaylistWindowSeconds *int64 `locationName:"playlistWindowSeconds" type:"integer"`

	// The interval (in seconds) between each EXT-X-PROGRAM-DATE-TIME taginserted
	// into manifests. Additionally, when an interval is specifiedID3Timed Metadata
	// messages will be generated every 5 seconds using theingest time of the content.If
	// the interval is not specified, or set to 0, thenno EXT-X-PROGRAM-DATE-TIME
	// tags will be inserted into manifests and noID3Timed Metadata messages will
	// be generated. Note that irrespectiveof this parameter, if any ID3 Timed Metadata
	// is found in HTTP Live Streaming (HLS) input,it will be passed through to
	// HLS output.
	ProgramDateTimeIntervalSeconds *int64 `locationName:"programDateTimeIntervalSeconds" type:"integer"`
}

// String returns the string representation
func (s HlsManifestCreateOrUpdateParameters) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s HlsManifestCreateOrUpdateParameters) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *HlsManifestCreateOrUpdateParameters) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "HlsManifestCreateOrUpdateParameters"}
	if s.Id == nil {
		invalidParams.Add(request.NewErrParamRequired("Id"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAdMarkers sets the AdMarkers field's value.
func (s *HlsManifestCreateOrUpdateParameters) SetAdMarkers(v string) *HlsManifestCreateOrUpdateParameters {
	s.AdMarkers = &v
	return s
}

// SetAdTriggers sets the AdTriggers field's value.
func (s *HlsManifestCreateOrUpdateParameters) SetAdTriggers(v []*string) *HlsManifestCreateOrUpdateParameters {
	s.AdTriggers = v
	return s
}

// SetAdsOnDeliveryRestrictions sets the AdsOnDeliveryRestrictions field's value.
func (s *HlsManifestCreateOrUpdateParameters) SetAdsOnDeliveryRestrictions(v string) *HlsManifestCreateOrUpdateParameters {
	s.AdsOnDeliveryRestrictions = &v
	return s
}

// SetId sets the Id field's value.
func (s *HlsManifestCreateOrUpdateParameters) SetId(v string) *HlsManifestCreateOrUpdateParameters {
	s.Id = &v
	return s
}

// SetIncludeIframeOnlyStream sets the IncludeIframeOnlyStream field's value.
func (s *HlsManifestCreateOrUpdateParameters) SetIncludeIframeOnlyStream(v bool) *HlsManifestCreateOrUpdateParameters {
	s.IncludeIframeOnlyStream = &v
	return s
}

// SetManifestName sets the ManifestName field's value.
func (s *HlsManifestCreateOrUpdateParameters) SetManifestName(v string) *HlsManifestCreateOrUpdateParameters {
	s.ManifestName = &v
	return s
}

// SetPlaylistType sets the PlaylistType field's value.
func (s *HlsManifestCreateOrUpdateParameters) SetPlaylistType(v string) *HlsManifestCreateOrUpdateParameters {
	s.PlaylistType = &v
	return s
}

// SetPlaylistWindowSeconds sets the PlaylistWindowSeconds field's value.
func (s *HlsManifestCreateOrUpdateParameters) SetPlaylistWindowSeconds(v int64) *HlsManifestCreateOrUpdateParameters {
	s.PlaylistWindowSeconds = &v
	return s
}

// SetProgramDateTimeIntervalSeconds sets the ProgramDateTimeIntervalSeconds field's value.
func (s *HlsManifestCreateOrUpdateParameters) SetProgramDateTimeIntervalSeconds(v int64) *HlsManifestCreateOrUpdateParameters {
	s.ProgramDateTimeIntervalSeconds = &v
	return s
}

// An HTTP Live Streaming (HLS) packaging configuration.
type HlsPackage struct {
	_ struct{} `type:"structure"`

	// This setting controls how ad markers are included in the packaged OriginEndpoint."NONE"
	// will omit all SCTE-35 ad markers from the output."PASSTHROUGH" causes the
	// manifest to contain a copy of the SCTE-35 admarkers (comments) taken directly
	// from the input HTTP Live Streaming (HLS) manifest."SCTE35_ENHANCED" generates
	// ad markers and blackout tags based on SCTE-35messages in the input source.
	AdMarkers *string `locationName:"adMarkers" type:"string" enum:"AdMarkers"`

	// A list of SCTE-35 message types that are treated as ad markers in the output.
	// If empty, noad markers are output. Specify multiple items to create ad markers
	// for all of the includedmessage types.
	AdTriggers []*string `locationName:"adTriggers" type:"list"`

	// This setting allows the delivery restriction flags on SCTE-35 segmentation
	// descriptors todetermine whether a message signals an ad. Choosing "NONE"
	// means no SCTE-35 messages becomeads. Choosing "RESTRICTED" means SCTE-35
	// messages of the types specified in AdTriggers thatcontain delivery restrictions
	// will be treated as ads. Choosing "UNRESTRICTED" means SCTE-35messages of
	// the types specified in AdTriggers that do not contain delivery restrictions
	// willbe treated as ads. Choosing "BOTH" means all SCTE-35 messages of the
	// types specified inAdTriggers will be treated as ads. Note that Splice Insert
	// messages do not have these flagsand are always treated as ads if specified
	// in AdTriggers.
	AdsOnDeliveryRestrictions *string `locationName:"adsOnDeliveryRestrictions" type:"string" enum:"AdsOnDeliveryRestrictions"`

	// An HTTP Live Streaming (HLS) encryption configuration.
	Encryption *HlsEncryption `locationName:"encryption" type:"structure"`

	// When enabled, an I-Frame only stream will be included in the output.
	IncludeIframeOnlyStream *bool `locationName:"includeIframeOnlyStream" type:"boolean"`

	// The HTTP Live Streaming (HLS) playlist type.When either "EVENT" or "VOD"
	// is specified, a corresponding EXT-X-PLAYLIST-TYPEentry will be included in
	// the media playlist.
	PlaylistType *string `locationName:"playlistType" type:"string" enum:"PlaylistType"`

	// Time window (in seconds) contained in each parent manifest.
	PlaylistWindowSeconds *int64 `locationName:"playlistWindowSeconds" type:"integer"`

	// The interval (in seconds) between each EXT-X-PROGRAM-DATE-TIME taginserted
	// into manifests. Additionally, when an interval is specifiedID3Timed Metadata
	// messages will be generated every 5 seconds using theingest time of the content.If
	// the interval is not specified, or set to 0, thenno EXT-X-PROGRAM-DATE-TIME
	// tags will be inserted into manifests and noID3Timed Metadata messages will
	// be generated. Note that irrespectiveof this parameter, if any ID3 Timed Metadata
	// is found in HTTP Live Streaming (HLS) input,it will be passed through to
	// HLS output.
	ProgramDateTimeIntervalSeconds *int64 `locationName:"programDateTimeIntervalSeconds" type:"integer"`

	// Duration (in seconds) of each fragment. Actual fragments will berounded to
	// the nearest multiple of the source fragment duration.
	SegmentDurationSeconds *int64 `locationName:"segmentDurationSeconds" type:"integer"`

	// A StreamSelection configuration.
	StreamSelection *StreamSelection `locationName:"streamSelection" type:"structure"`

	// When enabled, audio streams will be placed in rendition groups in the output.
	UseAudioRenditionGroup *bool `locationName:"useAudioRenditionGroup" type:"boolean"`
}

// String returns the string representation
func (s HlsPackage) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s HlsPackage) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *HlsPackage) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "HlsPackage"}
	if s.Encryption != nil {
		if err := s.Encryption.Validate(); err != nil {
			invalidParams.AddNested("Encryption", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAdMarkers sets the AdMarkers field's value.
func (s *HlsPackage) SetAdMarkers(v string) *HlsPackage {
	s.AdMarkers = &v
	return s
}

// SetAdTriggers sets the AdTriggers field's value.
func (s *HlsPackage) SetAdTriggers(v []*string) *HlsPackage {
	s.AdTriggers = v
	return s
}

// SetAdsOnDeliveryRestrictions sets the AdsOnDeliveryRestrictions field's value.
func (s *HlsPackage) SetAdsOnDeliveryRestrictions(v string) *HlsPackage {
	s.AdsOnDeliveryRestrictions = &v
	return s
}

// SetEncryption sets the Encryption field's value.
func (s *HlsPackage) SetEncryption(v *HlsEncryption) *HlsPackage {
	s.Encryption = v
	return s
}

// SetIncludeIframeOnlyStream sets the IncludeIframeOnlyStream field's value.
func (s *HlsPackage) SetIncludeIframeOnlyStream(v bool) *HlsPackage {
	s.IncludeIframeOnlyStream = &v
	return s
}

// SetPlaylistType sets the PlaylistType field's value.
func (s *HlsPackage) SetPlaylistType(v string) *HlsPackage {
	s.PlaylistType = &v
	return s
}

// SetPlaylistWindowSeconds sets the PlaylistWindowSeconds field's value.
func (s *HlsPackage) SetPlaylistWindowSeconds(v int64) *HlsPackage {
	s.PlaylistWindowSeconds = &v
	return s
}

// SetProgramDateTimeIntervalSeconds sets the ProgramDateTimeIntervalSeconds field's value.
func (s *HlsPackage) SetProgramDateTimeIntervalSeconds(v int64) *HlsPackage {
	s.ProgramDateTimeIntervalSeconds = &v
	return s
}

// SetSegmentDurationSeconds sets the SegmentDurationSeconds field's value.
func (s *HlsPackage) SetSegmentDurationSeconds(v int64) *HlsPackage {
	s.SegmentDurationSeconds = &v
	return s
}

// SetStreamSelection sets the StreamSelection field's value.
func (s *HlsPackage) SetStreamSelection(v *StreamSelection) *HlsPackage {
	s.StreamSelection = v
	return s
}

// SetUseAudioRenditionGroup sets the UseAudioRenditionGroup field's value.
func (s *HlsPackage) SetUseAudioRenditionGroup(v bool) *HlsPackage {
	s.UseAudioRenditionGroup = &v
	return s
}

// An endpoint for ingesting source content for a Channel.
type IngestEndpoint struct {
	_ struct{} `type:"structure"`

	// The system generated unique identifier for the IngestEndpoint
	Id *string `locationName:"id" type:"string"`

	// The system generated password for ingest authentication.
	Password *string `locationName:"password" type:"string"`

	// The ingest URL to which the source stream should be sent.
	Url *string `locationName:"url" type:"string"`

	// The system generated username for ingest authentication.
	Username *string `locationName:"username" type:"string"`
}

// String returns the string representation
func (s IngestEndpoint) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s IngestEndpoint) GoString() string {
	return s.String()
}

// SetId sets the Id field's value.
func (s *IngestEndpoint) SetId(v string) *IngestEndpoint {
	s.Id = &v
	return s
}

// SetPassword sets the Password field's value.
func (s *IngestEndpoint) SetPassword(v string) *IngestEndpoint {
	s.Password = &v
	return s
}

// SetUrl sets the Url field's value.
func (s *IngestEndpoint) SetUrl(v string) *IngestEndpoint {
	s.Url = &v
	return s
}

// SetUsername sets the Username field's value.
func (s *IngestEndpoint) SetUsername(v string) *IngestEndpoint {
	s.Username = &v
	return s
}

type InternalServerErrorException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation
func (s InternalServerErrorException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s InternalServerErrorException) GoString() string {
	return s.String()
}

func newErrorInternalServerErrorException(v protocol.ResponseMetadata) error {
	return &InternalServerErrorException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *InternalServerErrorException) Code() string {
	return "InternalServerErrorException"
}

// Message returns the exception's message.
func (s *InternalServerErrorException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *InternalServerErrorException) OrigErr() error {
	return nil
}

func (s *InternalServerErrorException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *InternalServerErrorException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *InternalServerErrorException) RequestID() string {
	return s.RespMetadata.RequestID
}

type ListChannelsInput struct {
	_ struct{} `type:"structure"`

	MaxResults *int64 `location:"querystring" locationName:"maxResults" min:"1" type:"integer"`

	NextToken *string `location:"querystring" locationName:"nextToken" type:"string"`
}

// String returns the string representation
func (s ListChannelsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListChannelsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListChannelsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListChannelsInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListChannelsInput) SetMaxResults(v int64) *ListChannelsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListChannelsInput) SetNextToken(v string) *ListChannelsInput {
	s.NextToken = &v
	return s
}

type ListChannelsOutput struct {
	_ struct{} `type:"structure"`

	Channels []*Channel `locationName:"channels" type:"list"`

	NextToken *string `locationName:"nextToken" type:"string"`
}

// String returns the string representation
func (s ListChannelsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListChannelsOutput) GoString() string {
	return s.String()
}

// SetChannels sets the Channels field's value.
func (s *ListChannelsOutput) SetChannels(v []*Channel) *ListChannelsOutput {
	s.Channels = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListChannelsOutput) SetNextToken(v string) *ListChannelsOutput {
	s.NextToken = &v
	return s
}

type ListHarvestJobsInput struct {
	_ struct{} `type:"structure"`

	IncludeChannelId *string `location:"querystring" locationName:"includeChannelId" type:"string"`

	IncludeStatus *string `location:"querystring" locationName:"includeStatus" type:"string"`

	MaxResults *int64 `location:"querystring" locationName:"maxResults" min:"1" type:"integer"`

	NextToken *string `location:"querystring" locationName:"nextToken" type:"string"`
}

// String returns the string representation
func (s ListHarvestJobsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListHarvestJobsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListHarvestJobsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListHarvestJobsInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetIncludeChannelId sets the IncludeChannelId field's value.
func (s *ListHarvestJobsInput) SetIncludeChannelId(v string) *ListHarvestJobsInput {
	s.IncludeChannelId = &v
	return s
}

// SetIncludeStatus sets the IncludeStatus field's value.
func (s *ListHarvestJobsInput) SetIncludeStatus(v string) *ListHarvestJobsInput {
	s.IncludeStatus = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListHarvestJobsInput) SetMaxResults(v int64) *ListHarvestJobsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListHarvestJobsInput) SetNextToken(v string) *ListHarvestJobsInput {
	s.NextToken = &v
	return s
}

type ListHarvestJobsOutput struct {
	_ struct{} `type:"structure"`

	HarvestJobs []*HarvestJob `locationName:"harvestJobs" type:"list"`

	NextToken *string `locationName:"nextToken" type:"string"`
}

// String returns the string representation
func (s ListHarvestJobsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListHarvestJobsOutput) GoString() string {
	return s.String()
}

// SetHarvestJobs sets the HarvestJobs field's value.
func (s *ListHarvestJobsOutput) SetHarvestJobs(v []*HarvestJob) *ListHarvestJobsOutput {
	s.HarvestJobs = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListHarvestJobsOutput) SetNextToken(v string) *ListHarvestJobsOutput {
	s.NextToken = &v
	return s
}

type ListOriginEndpointsInput struct {
	_ struct{} `type:"structure"`

	ChannelId *string `location:"querystring" locationName:"channelId" type:"string"`

	MaxResults *int64 `location:"querystring" locationName:"maxResults" min:"1" type:"integer"`

	NextToken *string `location:"querystring" locationName:"nextToken" type:"string"`
}

// String returns the string representation
func (s ListOriginEndpointsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListOriginEndpointsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListOriginEndpointsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListOriginEndpointsInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetChannelId sets the ChannelId field's value.
func (s *ListOriginEndpointsInput) SetChannelId(v string) *ListOriginEndpointsInput {
	s.ChannelId = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListOriginEndpointsInput) SetMaxResults(v int64) *ListOriginEndpointsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListOriginEndpointsInput) SetNextToken(v string) *ListOriginEndpointsInput {
	s.NextToken = &v
	return s
}

type ListOriginEndpointsOutput struct {
	_ struct{} `type:"structure"`

	NextToken *string `locationName:"nextToken" type:"string"`

	OriginEndpoints []*OriginEndpoint `locationName:"originEndpoints" type:"list"`
}

// String returns the string representation
func (s ListOriginEndpointsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListOriginEndpointsOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *ListOriginEndpointsOutput) SetNextToken(v string) *ListOriginEndpointsOutput {
	s.NextToken = &v
	return s
}

// SetOriginEndpoints sets the OriginEndpoints field's value.
func (s *ListOriginEndpointsOutput) SetOriginEndpoints(v []*OriginEndpoint) *ListOriginEndpointsOutput {
	s.OriginEndpoints = v
	return s
}

type ListTagsForResourceInput struct {
	_ struct{} `type:"structure"`

	// ResourceArn is a required field
	ResourceArn *string `location:"uri" locationName:"resource-arn" type:"string" required:"true"`
}

// String returns the string representation
func (s ListTagsForResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListTagsForResourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListTagsForResourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListTagsForResourceInput"}
	if s.ResourceArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceArn"))
	}
	if s.ResourceArn != nil && len(*s.ResourceArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceArn", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResourceArn sets the ResourceArn field's value.
func (s *ListTagsForResourceInput) SetResourceArn(v string) *ListTagsForResourceInput {
	s.ResourceArn = &v
	return s
}

type ListTagsForResourceOutput struct {
	_ struct{} `type:"structure"`

	Tags map[string]*string `locationName:"tags" type:"map"`
}

// String returns the string representation
func (s ListTagsForResourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListTagsForResourceOutput) GoString() string {
	return s.String()
}

// SetTags sets the Tags field's value.
func (s *ListTagsForResourceOutput) SetTags(v map[string]*string) *ListTagsForResourceOutput {
	s.Tags = v
	return s
}

// A Microsoft Smooth Streaming (MSS) encryption configuration.
type MssEncryption struct {
	_ struct{} `type:"structure"`

	// A configuration for accessing an external Secure Packager and Encoder Key
	// Exchange (SPEKE) service that will provide encryption keys.
	//
	// SpekeKeyProvider is a required field
	SpekeKeyProvider *SpekeKeyProvider `locationName:"spekeKeyProvider" type:"structure" required:"true"`
}

// String returns the string representation
func (s MssEncryption) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s MssEncryption) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *MssEncryption) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "MssEncryption"}
	if s.SpekeKeyProvider == nil {
		invalidParams.Add(request.NewErrParamRequired("SpekeKeyProvider"))
	}
	if s.SpekeKeyProvider != nil {
		if err := s.SpekeKeyProvider.Validate(); err != nil {
			invalidParams.AddNested("SpekeKeyProvider", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetSpekeKeyProvider sets the SpekeKeyProvider field's value.
func (s *MssEncryption) SetSpekeKeyProvider(v *SpekeKeyProvider) *MssEncryption {
	s.SpekeKeyProvider = v
	return s
}

// A Microsoft Smooth Streaming (MSS) packaging configuration.
type MssPackage struct {
	_ struct{} `type:"structure"`

	// A Microsoft Smooth Streaming (MSS) encryption configuration.
	Encryption *MssEncryption `locationName:"encryption" type:"structure"`

	// The time window (in seconds) contained in each manifest.
	ManifestWindowSeconds *int64 `locationName:"manifestWindowSeconds" type:"integer"`

	// The duration (in seconds) of each segment.
	SegmentDurationSeconds *int64 `locationName:"segmentDurationSeconds" type:"integer"`

	// A StreamSelection configuration.
	StreamSelection *StreamSelection `locationName:"streamSelection" type:"structure"`
}

// String returns the string representation
func (s MssPackage) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s MssPackage) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *MssPackage) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "MssPackage"}
	if s.Encryption != nil {
		if err := s.Encryption.Validate(); err != nil {
			invalidParams.AddNested("Encryption", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetEncryption sets the Encryption field's value.
func (s *MssPackage) SetEncryption(v *MssEncryption) *MssPackage {
	s.Encryption = v
	return s
}

// SetManifestWindowSeconds sets the ManifestWindowSeconds field's value.
func (s *MssPackage) SetManifestWindowSeconds(v int64) *MssPackage {
	s.ManifestWindowSeconds = &v
	return s
}

// SetSegmentDurationSeconds sets the SegmentDurationSeconds field's value.
func (s *MssPackage) SetSegmentDurationSeconds(v int64) *MssPackage {
	s.SegmentDurationSeconds = &v
	return s
}

// SetStreamSelection sets the StreamSelection field's value.
func (s *MssPackage) SetStreamSelection(v *StreamSelection) *MssPackage {
	s.StreamSelection = v
	return s
}

type NotFoundException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation
func (s NotFoundException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s NotFoundException) GoString() string {
	return s.String()
}

func newErrorNotFoundException(v protocol.ResponseMetadata) error {
	return &NotFoundException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *NotFoundException) Code() string {
	return "NotFoundException"
}

// Message returns the exception's message.
func (s *NotFoundException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *NotFoundException) OrigErr() error {
	return nil
}

func (s *NotFoundException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *NotFoundException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *NotFoundException) RequestID() string {
	return s.RespMetadata.RequestID
}

// An OriginEndpoint resource configuration.
type OriginEndpoint struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) assigned to the OriginEndpoint.
	Arn *string `locationName:"arn" type:"string"`

	// CDN Authorization credentials
	Authorization *Authorization `locationName:"authorization" type:"structure"`

	// The ID of the Channel the OriginEndpoint is associated with.
	ChannelId *string `locationName:"channelId" type:"string"`

	// A Common Media Application Format (CMAF) packaging configuration.
	CmafPackage *CmafPackage `locationName:"cmafPackage" type:"structure"`

	// A Dynamic Adaptive Streaming over HTTP (DASH) packaging configuration.
	DashPackage *DashPackage `locationName:"dashPackage" type:"structure"`

	// A short text description of the OriginEndpoint.
	Description *string `locationName:"description" type:"string"`

	// An HTTP Live Streaming (HLS) packaging configuration.
	HlsPackage *HlsPackage `locationName:"hlsPackage" type:"structure"`

	// The ID of the OriginEndpoint.
	Id *string `locationName:"id" type:"string"`

	// A short string appended to the end of the OriginEndpoint URL.
	ManifestName *string `locationName:"manifestName" type:"string"`

	// A Microsoft Smooth Streaming (MSS) packaging configuration.
	MssPackage *MssPackage `locationName:"mssPackage" type:"structure"`

	// Control whether origination of video is allowed for this OriginEndpoint.
	// If set to ALLOW, the OriginEndpointmay by requested, pursuant to any other
	// form of access control. If set to DENY, the OriginEndpoint may not berequested.
	// This can be helpful for Live to VOD harvesting, or for temporarily disabling
	// origination
	Origination *string `locationName:"origination" type:"string" enum:"Origination"`

	// Maximum duration (seconds) of content to retain for startover playback.If
	// not specified, startover playback will be disabled for the OriginEndpoint.
	StartoverWindowSeconds *int64 `locationName:"startoverWindowSeconds" type:"integer"`

	// A collection of tags associated with a resource
	Tags map[string]*string `locationName:"tags" type:"map"`

	// Amount of delay (seconds) to enforce on the playback of live content.If not
	// specified, there will be no time delay in effect for the OriginEndpoint.
	TimeDelaySeconds *int64 `locationName:"timeDelaySeconds" type:"integer"`

	// The URL of the packaged OriginEndpoint for consumption.
	Url *string `locationName:"url" type:"string"`

	// A list of source IP CIDR blocks that will be allowed to access the OriginEndpoint.
	Whitelist []*string `locationName:"whitelist" type:"list"`
}

// String returns the string representation
func (s OriginEndpoint) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s OriginEndpoint) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *OriginEndpoint) SetArn(v string) *OriginEndpoint {
	s.Arn = &v
	return s
}

// SetAuthorization sets the Authorization field's value.
func (s *OriginEndpoint) SetAuthorization(v *Authorization) *OriginEndpoint {
	s.Authorization = v
	return s
}

// SetChannelId sets the ChannelId field's value.
func (s *OriginEndpoint) SetChannelId(v string) *OriginEndpoint {
	s.ChannelId = &v
	return s
}

// SetCmafPackage sets the CmafPackage field's value.
func (s *OriginEndpoint) SetCmafPackage(v *CmafPackage) *OriginEndpoint {
	s.CmafPackage = v
	return s
}

// SetDashPackage sets the DashPackage field's value.
func (s *OriginEndpoint) SetDashPackage(v *DashPackage) *OriginEndpoint {
	s.DashPackage = v
	return s
}

// SetDescription sets the Description field's value.
func (s *OriginEndpoint) SetDescription(v string) *OriginEndpoint {
	s.Description = &v
	return s
}

// SetHlsPackage sets the HlsPackage field's value.
func (s *OriginEndpoint) SetHlsPackage(v *HlsPackage) *OriginEndpoint {
	s.HlsPackage = v
	return s
}

// SetId sets the Id field's value.
func (s *OriginEndpoint) SetId(v string) *OriginEndpoint {
	s.Id = &v
	return s
}

// SetManifestName sets the ManifestName field's value.
func (s *OriginEndpoint) SetManifestName(v string) *OriginEndpoint {
	s.ManifestName = &v
	return s
}

// SetMssPackage sets the MssPackage field's value.
func (s *OriginEndpoint) SetMssPackage(v *MssPackage) *OriginEndpoint {
	s.MssPackage = v
	return s
}

// SetOrigination sets the Origination field's value.
func (s *OriginEndpoint) SetOrigination(v string) *OriginEndpoint {
	s.Origination = &v
	return s
}

// SetStartoverWindowSeconds sets the StartoverWindowSeconds field's value.
func (s *OriginEndpoint) SetStartoverWindowSeconds(v int64) *OriginEndpoint {
	s.StartoverWindowSeconds = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *OriginEndpoint) SetTags(v map[string]*string) *OriginEndpoint {
	s.Tags = v
	return s
}

// SetTimeDelaySeconds sets the TimeDelaySeconds field's value.
func (s *OriginEndpoint) SetTimeDelaySeconds(v int64) *OriginEndpoint {
	s.TimeDelaySeconds = &v
	return s
}

// SetUrl sets the Url field's value.
func (s *OriginEndpoint) SetUrl(v string) *OriginEndpoint {
	s.Url = &v
	return s
}

// SetWhitelist sets the Whitelist field's value.
func (s *OriginEndpoint) SetWhitelist(v []*string) *OriginEndpoint {
	s.Whitelist = v
	return s
}

// Deprecated: RotateChannelCredentialsInput has been deprecated
type RotateChannelCredentialsInput struct {
	_ struct{} `deprecated:"true" type:"structure"`

	// Id is a required field
	Id *string `location:"uri" locationName:"id" type:"string" required:"true"`
}

// String returns the string representation
func (s RotateChannelCredentialsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RotateChannelCredentialsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *RotateChannelCredentialsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "RotateChannelCredentialsInput"}
	if s.Id == nil {
		invalidParams.Add(request.NewErrParamRequired("Id"))
	}
	if s.Id != nil && len(*s.Id) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Id", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetId sets the Id field's value.
func (s *RotateChannelCredentialsInput) SetId(v string) *RotateChannelCredentialsInput {
	s.Id = &v
	return s
}

// Deprecated: RotateChannelCredentialsOutput has been deprecated
type RotateChannelCredentialsOutput struct {
	_ struct{} `deprecated:"true" type:"structure"`

	Arn *string `locationName:"arn" type:"string"`

	Description *string `locationName:"description" type:"string"`

	// An HTTP Live Streaming (HLS) ingest resource configuration.
	HlsIngest *HlsIngest `locationName:"hlsIngest" type:"structure"`

	Id *string `locationName:"id" type:"string"`

	// A collection of tags associated with a resource
	Tags map[string]*string `locationName:"tags" type:"map"`
}

// String returns the string representation
func (s RotateChannelCredentialsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RotateChannelCredentialsOutput) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *RotateChannelCredentialsOutput) SetArn(v string) *RotateChannelCredentialsOutput {
	s.Arn = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *RotateChannelCredentialsOutput) SetDescription(v string) *RotateChannelCredentialsOutput {
	s.Description = &v
	return s
}

// SetHlsIngest sets the HlsIngest field's value.
func (s *RotateChannelCredentialsOutput) SetHlsIngest(v *HlsIngest) *RotateChannelCredentialsOutput {
	s.HlsIngest = v
	return s
}

// SetId sets the Id field's value.
func (s *RotateChannelCredentialsOutput) SetId(v string) *RotateChannelCredentialsOutput {
	s.Id = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *RotateChannelCredentialsOutput) SetTags(v map[string]*string) *RotateChannelCredentialsOutput {
	s.Tags = v
	return s
}

type RotateIngestEndpointCredentialsInput struct {
	_ struct{} `type:"structure"`

	// Id is a required field
	Id *string `location:"uri" locationName:"id" type:"string" required:"true"`

	// IngestEndpointId is a required field
	IngestEndpointId *string `location:"uri" locationName:"ingest_endpoint_id" type:"string" required:"true"`
}

// String returns the string representation
func (s RotateIngestEndpointCredentialsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RotateIngestEndpointCredentialsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *RotateIngestEndpointCredentialsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "RotateIngestEndpointCredentialsInput"}
	if s.Id == nil {
		invalidParams.Add(request.NewErrParamRequired("Id"))
	}
	if s.Id != nil && len(*s.Id) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Id", 1))
	}
	if s.IngestEndpointId == nil {
		invalidParams.Add(request.NewErrParamRequired("IngestEndpointId"))
	}
	if s.IngestEndpointId != nil && len(*s.IngestEndpointId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("IngestEndpointId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetId sets the Id field's value.
func (s *RotateIngestEndpointCredentialsInput) SetId(v string) *RotateIngestEndpointCredentialsInput {
	s.Id = &v
	return s
}

// SetIngestEndpointId sets the IngestEndpointId field's value.
func (s *RotateIngestEndpointCredentialsInput) SetIngestEndpointId(v string) *RotateIngestEndpointCredentialsInput {
	s.IngestEndpointId = &v
	return s
}

type RotateIngestEndpointCredentialsOutput struct {
	_ struct{} `type:"structure"`

	Arn *string `locationName:"arn" type:"string"`

	Description *string `locationName:"description" type:"string"`

	// An HTTP Live Streaming (HLS) ingest resource configuration.
	HlsIngest *HlsIngest `locationName:"hlsIngest" type:"structure"`

	Id *string `locationName:"id" type:"string"`

	// A collection of tags associated with a resource
	Tags map[string]*string `locationName:"tags" type:"map"`
}

// String returns the string representation
func (s RotateIngestEndpointCredentialsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RotateIngestEndpointCredentialsOutput) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *RotateIngestEndpointCredentialsOutput) SetArn(v string) *RotateIngestEndpointCredentialsOutput {
	s.Arn = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *RotateIngestEndpointCredentialsOutput) SetDescription(v string) *RotateIngestEndpointCredentialsOutput {
	s.Description = &v
	return s
}

// SetHlsIngest sets the HlsIngest field's value.
func (s *RotateIngestEndpointCredentialsOutput) SetHlsIngest(v *HlsIngest) *RotateIngestEndpointCredentialsOutput {
	s.HlsIngest = v
	return s
}

// SetId sets the Id field's value.
func (s *RotateIngestEndpointCredentialsOutput) SetId(v string) *RotateIngestEndpointCredentialsOutput {
	s.Id = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *RotateIngestEndpointCredentialsOutput) SetTags(v map[string]*string) *RotateIngestEndpointCredentialsOutput {
	s.Tags = v
	return s
}

// Configuration parameters for where in an S3 bucket to place the harvested
// content
type S3Destination struct {
	_ struct{} `type:"structure"`

	// The name of an S3 bucket within which harvested content will be exported
	//
	// BucketName is a required field
	BucketName *string `locationName:"bucketName" type:"string" required:"true"`

	// The key in the specified S3 bucket where the harvested top-level manifest
	// will be placed.
	//
	// ManifestKey is a required field
	ManifestKey *string `locationName:"manifestKey" type:"string" required:"true"`

	// The IAM role used to write to the specified S3 bucket
	//
	// RoleArn is a required field
	RoleArn *string `locationName:"roleArn" type:"string" required:"true"`
}

// String returns the string representation
func (s S3Destination) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s S3Destination) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *S3Destination) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "S3Destination"}
	if s.BucketName == nil {
		invalidParams.Add(request.NewErrParamRequired("BucketName"))
	}
	if s.ManifestKey == nil {
		invalidParams.Add(request.NewErrParamRequired("ManifestKey"))
	}
	if s.RoleArn == nil {
		invalidParams.Add(request.NewErrParamRequired("RoleArn"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBucketName sets the BucketName field's value.
func (s *S3Destination) SetBucketName(v string) *S3Destination {
	s.BucketName = &v
	return s
}

// SetManifestKey sets the ManifestKey field's value.
func (s *S3Destination) SetManifestKey(v string) *S3Destination {
	s.ManifestKey = &v
	return s
}

// SetRoleArn sets the RoleArn field's value.
func (s *S3Destination) SetRoleArn(v string) *S3Destination {
	s.RoleArn = &v
	return s
}

type ServiceUnavailableException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation
func (s ServiceUnavailableException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ServiceUnavailableException) GoString() string {
	return s.String()
}

func newErrorServiceUnavailableException(v protocol.ResponseMetadata) error {
	return &ServiceUnavailableException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ServiceUnavailableException) Code() string {
	return "ServiceUnavailableException"
}

// Message returns the exception's message.
func (s *ServiceUnavailableException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ServiceUnavailableException) OrigErr() error {
	return nil
}

func (s *ServiceUnavailableException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ServiceUnavailableException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ServiceUnavailableException) RequestID() string {
	return s.RespMetadata.RequestID
}

// A configuration for accessing an external Secure Packager and Encoder Key
// Exchange (SPEKE) service that will provide encryption keys.
type SpekeKeyProvider struct {
	_ struct{} `type:"structure"`

	// An Amazon Resource Name (ARN) of a Certificate Manager certificatethat MediaPackage
	// will use for enforcing secure end-to-end datatransfer with the key provider
	// service.
	CertificateArn *string `locationName:"certificateArn" type:"string"`

	// The resource ID to include in key requests.
	//
	// ResourceId is a required field
	ResourceId *string `locationName:"resourceId" type:"string" required:"true"`

	// An Amazon Resource Name (ARN) of an IAM role that AWS ElementalMediaPackage
	// will assume when accessing the key provider service.
	//
	// RoleArn is a required field
	RoleArn *string `locationName:"roleArn" type:"string" required:"true"`

	// The system IDs to include in key requests.
	//
	// SystemIds is a required field
	SystemIds []*string `locationName:"systemIds" type:"list" required:"true"`

	// The URL of the external key provider service.
	//
	// Url is a required field
	Url *string `locationName:"url" type:"string" required:"true"`
}

// String returns the string representation
func (s SpekeKeyProvider) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s SpekeKeyProvider) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *SpekeKeyProvider) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "SpekeKeyProvider"}
	if s.ResourceId == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceId"))
	}
	if s.RoleArn == nil {
		invalidParams.Add(request.NewErrParamRequired("RoleArn"))
	}
	if s.SystemIds == nil {
		invalidParams.Add(request.NewErrParamRequired("SystemIds"))
	}
	if s.Url == nil {
		invalidParams.Add(request.NewErrParamRequired("Url"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCertificateArn sets the CertificateArn field's value.
func (s *SpekeKeyProvider) SetCertificateArn(v string) *SpekeKeyProvider {
	s.CertificateArn = &v
	return s
}

// SetResourceId sets the ResourceId field's value.
func (s *SpekeKeyProvider) SetResourceId(v string) *SpekeKeyProvider {
	s.ResourceId = &v
	return s
}

// SetRoleArn sets the RoleArn field's value.
func (s *SpekeKeyProvider) SetRoleArn(v string) *SpekeKeyProvider {
	s.RoleArn = &v
	return s
}

// SetSystemIds sets the SystemIds field's value.
func (s *SpekeKeyProvider) SetSystemIds(v []*string) *SpekeKeyProvider {
	s.SystemIds = v
	return s
}

// SetUrl sets the Url field's value.
func (s *SpekeKeyProvider) SetUrl(v string) *SpekeKeyProvider {
	s.Url = &v
	return s
}

// A StreamSelection configuration.
type StreamSelection struct {
	_ struct{} `type:"structure"`

	// The maximum video bitrate (bps) to include in output.
	MaxVideoBitsPerSecond *int64 `locationName:"maxVideoBitsPerSecond" type:"integer"`

	// The minimum video bitrate (bps) to include in output.
	MinVideoBitsPerSecond *int64 `locationName:"minVideoBitsPerSecond" type:"integer"`

	// A directive that determines the order of streams in the output.
	StreamOrder *string `locationName:"streamOrder" type:"string" enum:"StreamOrder"`
}

// String returns the string representation
func (s StreamSelection) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s StreamSelection) GoString() string {
	return s.String()
}

// SetMaxVideoBitsPerSecond sets the MaxVideoBitsPerSecond field's value.
func (s *StreamSelection) SetMaxVideoBitsPerSecond(v int64) *StreamSelection {
	s.MaxVideoBitsPerSecond = &v
	return s
}

// SetMinVideoBitsPerSecond sets the MinVideoBitsPerSecond field's value.
func (s *StreamSelection) SetMinVideoBitsPerSecond(v int64) *StreamSelection {
	s.MinVideoBitsPerSecond = &v
	return s
}

// SetStreamOrder sets the StreamOrder field's value.
func (s *StreamSelection) SetStreamOrder(v string) *StreamSelection {
	s.StreamOrder = &v
	return s
}

type TagResourceInput struct {
	_ struct{} `type:"structure"`

	// ResourceArn is a required field
	ResourceArn *string `location:"uri" locationName:"resource-arn" type:"string" required:"true"`

	// Tags is a required field
	Tags map[string]*string `locationName:"tags" type:"map" required:"true"`
}

// String returns the string representation
func (s TagResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s TagResourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *TagResourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "TagResourceInput"}
	if s.ResourceArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceArn"))
	}
	if s.ResourceArn != nil && len(*s.ResourceArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceArn", 1))
	}
	if s.Tags == nil {
		invalidParams.Add(request.NewErrParamRequired("Tags"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResourceArn sets the ResourceArn field's value.
func (s *TagResourceInput) SetResourceArn(v string) *TagResourceInput {
	s.ResourceArn = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *TagResourceInput) SetTags(v map[string]*string) *TagResourceInput {
	s.Tags = v
	return s
}

type TagResourceOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s TagResourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s TagResourceOutput) GoString() string {
	return s.String()
}

type TooManyRequestsException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation
func (s TooManyRequestsException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s TooManyRequestsException) GoString() string {
	return s.String()
}

func newErrorTooManyRequestsException(v protocol.ResponseMetadata) error {
	return &TooManyRequestsException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *TooManyRequestsException) Code() string {
	return "TooManyRequestsException"
}

// Message returns the exception's message.
func (s *TooManyRequestsException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *TooManyRequestsException) OrigErr() error {
	return nil
}

func (s *TooManyRequestsException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *TooManyRequestsException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *TooManyRequestsException) RequestID() string {
	return s.RespMetadata.RequestID
}

type UnprocessableEntityException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation
func (s UnprocessableEntityException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UnprocessableEntityException) GoString() string {
	return s.String()
}

func newErrorUnprocessableEntityException(v protocol.ResponseMetadata) error {
	return &UnprocessableEntityException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *UnprocessableEntityException) Code() string {
	return "UnprocessableEntityException"
}

// Message returns the exception's message.
func (s *UnprocessableEntityException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *UnprocessableEntityException) OrigErr() error {
	return nil
}

func (s *UnprocessableEntityException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *UnprocessableEntityException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *UnprocessableEntityException) RequestID() string {
	return s.RespMetadata.RequestID
}

type UntagResourceInput struct {
	_ struct{} `type:"structure"`

	// ResourceArn is a required field
	ResourceArn *string `location:"uri" locationName:"resource-arn" type:"string" required:"true"`

	// TagKeys is a required field
	TagKeys []*string `location:"querystring" locationName:"tagKeys" type:"list" required:"true"`
}

// String returns the string representation
func (s UntagResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UntagResourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UntagResourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UntagResourceInput"}
	if s.ResourceArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceArn"))
	}
	if s.ResourceArn != nil && len(*s.ResourceArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceArn", 1))
	}
	if s.TagKeys == nil {
		invalidParams.Add(request.NewErrParamRequired("TagKeys"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResourceArn sets the ResourceArn field's value.
func (s *UntagResourceInput) SetResourceArn(v string) *UntagResourceInput {
	s.ResourceArn = &v
	return s
}

// SetTagKeys sets the TagKeys field's value.
func (s *UntagResourceInput) SetTagKeys(v []*string) *UntagResourceInput {
	s.TagKeys = v
	return s
}

type UntagResourceOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s UntagResourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UntagResourceOutput) GoString() string {
	return s.String()
}

type UpdateChannelInput struct {
	_ struct{} `type:"structure"`

	Description *string `locationName:"description" type:"string"`

	// Id is a required field
	Id *string `location:"uri" locationName:"id" type:"string" required:"true"`
}

// String returns the string representation
func (s UpdateChannelInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateChannelInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateChannelInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateChannelInput"}
	if s.Id == nil {
		invalidParams.Add(request.NewErrParamRequired("Id"))
	}
	if s.Id != nil && len(*s.Id) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Id", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDescription sets the Description field's value.
func (s *UpdateChannelInput) SetDescription(v string) *UpdateChannelInput {
	s.Description = &v
	return s
}

// SetId sets the Id field's value.
func (s *UpdateChannelInput) SetId(v string) *UpdateChannelInput {
	s.Id = &v
	return s
}

type UpdateChannelOutput struct {
	_ struct{} `type:"structure"`

	Arn *string `locationName:"arn" type:"string"`

	Description *string `locationName:"description" type:"string"`

	// An HTTP Live Streaming (HLS) ingest resource configuration.
	HlsIngest *HlsIngest `locationName:"hlsIngest" type:"structure"`

	Id *string `locationName:"id" type:"string"`

	// A collection of tags associated with a resource
	Tags map[string]*string `locationName:"tags" type:"map"`
}

// String returns the string representation
func (s UpdateChannelOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateChannelOutput) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *UpdateChannelOutput) SetArn(v string) *UpdateChannelOutput {
	s.Arn = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *UpdateChannelOutput) SetDescription(v string) *UpdateChannelOutput {
	s.Description = &v
	return s
}

// SetHlsIngest sets the HlsIngest field's value.
func (s *UpdateChannelOutput) SetHlsIngest(v *HlsIngest) *UpdateChannelOutput {
	s.HlsIngest = v
	return s
}

// SetId sets the Id field's value.
func (s *UpdateChannelOutput) SetId(v string) *UpdateChannelOutput {
	s.Id = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *UpdateChannelOutput) SetTags(v map[string]*string) *UpdateChannelOutput {
	s.Tags = v
	return s
}

type UpdateOriginEndpointInput struct {
	_ struct{} `type:"structure"`

	// CDN Authorization credentials
	Authorization *Authorization `locationName:"authorization" type:"structure"`

	// A Common Media Application Format (CMAF) packaging configuration.
	CmafPackage *CmafPackageCreateOrUpdateParameters `locationName:"cmafPackage" type:"structure"`

	// A Dynamic Adaptive Streaming over HTTP (DASH) packaging configuration.
	DashPackage *DashPackage `locationName:"dashPackage" type:"structure"`

	Description *string `locationName:"description" type:"string"`

	// An HTTP Live Streaming (HLS) packaging configuration.
	HlsPackage *HlsPackage `locationName:"hlsPackage" type:"structure"`

	// Id is a required field
	Id *string `location:"uri" locationName:"id" type:"string" required:"true"`

	ManifestName *string `locationName:"manifestName" type:"string"`

	// A Microsoft Smooth Streaming (MSS) packaging configuration.
	MssPackage *MssPackage `locationName:"mssPackage" type:"structure"`

	Origination *string `locationName:"origination" type:"string" enum:"Origination"`

	StartoverWindowSeconds *int64 `locationName:"startoverWindowSeconds" type:"integer"`

	TimeDelaySeconds *int64 `locationName:"timeDelaySeconds" type:"integer"`

	Whitelist []*string `locationName:"whitelist" type:"list"`
}

// String returns the string representation
func (s UpdateOriginEndpointInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateOriginEndpointInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateOriginEndpointInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateOriginEndpointInput"}
	if s.Id == nil {
		invalidParams.Add(request.NewErrParamRequired("Id"))
	}
	if s.Id != nil && len(*s.Id) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Id", 1))
	}
	if s.Authorization != nil {
		if err := s.Authorization.Validate(); err != nil {
			invalidParams.AddNested("Authorization", err.(request.ErrInvalidParams))
		}
	}
	if s.CmafPackage != nil {
		if err := s.CmafPackage.Validate(); err != nil {
			invalidParams.AddNested("CmafPackage", err.(request.ErrInvalidParams))
		}
	}
	if s.DashPackage != nil {
		if err := s.DashPackage.Validate(); err != nil {
			invalidParams.AddNested("DashPackage", err.(request.ErrInvalidParams))
		}
	}
	if s.HlsPackage != nil {
		if err := s.HlsPackage.Validate(); err != nil {
			invalidParams.AddNested("HlsPackage", err.(request.ErrInvalidParams))
		}
	}
	if s.MssPackage != nil {
		if err := s.MssPackage.Validate(); err != nil {
			invalidParams.AddNested("MssPackage", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAuthorization sets the Authorization field's value.
func (s *UpdateOriginEndpointInput) SetAuthorization(v *Authorization) *UpdateOriginEndpointInput {
	s.Authorization = v
	return s
}

// SetCmafPackage sets the CmafPackage field's value.
func (s *UpdateOriginEndpointInput) SetCmafPackage(v *CmafPackageCreateOrUpdateParameters) *UpdateOriginEndpointInput {
	s.CmafPackage = v
	return s
}

// SetDashPackage sets the DashPackage field's value.
func (s *UpdateOriginEndpointInput) SetDashPackage(v *DashPackage) *UpdateOriginEndpointInput {
	s.DashPackage = v
	return s
}

// SetDescription sets the Description field's value.
func (s *UpdateOriginEndpointInput) SetDescription(v string) *UpdateOriginEndpointInput {
	s.Description = &v
	return s
}

// SetHlsPackage sets the HlsPackage field's value.
func (s *UpdateOriginEndpointInput) SetHlsPackage(v *HlsPackage) *UpdateOriginEndpointInput {
	s.HlsPackage = v
	return s
}

// SetId sets the Id field's value.
func (s *UpdateOriginEndpointInput) SetId(v string) *UpdateOriginEndpointInput {
	s.Id = &v
	return s
}

// SetManifestName sets the ManifestName field's value.
func (s *UpdateOriginEndpointInput) SetManifestName(v string) *UpdateOriginEndpointInput {
	s.ManifestName = &v
	return s
}

// SetMssPackage sets the MssPackage field's value.
func (s *UpdateOriginEndpointInput) SetMssPackage(v *MssPackage) *UpdateOriginEndpointInput {
	s.MssPackage = v
	return s
}

// SetOrigination sets the Origination field's value.
func (s *UpdateOriginEndpointInput) SetOrigination(v string) *UpdateOriginEndpointInput {
	s.Origination = &v
	return s
}

// SetStartoverWindowSeconds sets the StartoverWindowSeconds field's value.
func (s *UpdateOriginEndpointInput) SetStartoverWindowSeconds(v int64) *UpdateOriginEndpointInput {
	s.StartoverWindowSeconds = &v
	return s
}

// SetTimeDelaySeconds sets the TimeDelaySeconds field's value.
func (s *UpdateOriginEndpointInput) SetTimeDelaySeconds(v int64) *UpdateOriginEndpointInput {
	s.TimeDelaySeconds = &v
	return s
}

// SetWhitelist sets the Whitelist field's value.
func (s *UpdateOriginEndpointInput) SetWhitelist(v []*string) *UpdateOriginEndpointInput {
	s.Whitelist = v
	return s
}

type UpdateOriginEndpointOutput struct {
	_ struct{} `type:"structure"`

	Arn *string `locationName:"arn" type:"string"`

	// CDN Authorization credentials
	Authorization *Authorization `locationName:"authorization" type:"structure"`

	ChannelId *string `locationName:"channelId" type:"string"`

	// A Common Media Application Format (CMAF) packaging configuration.
	CmafPackage *CmafPackage `locationName:"cmafPackage" type:"structure"`

	// A Dynamic Adaptive Streaming over HTTP (DASH) packaging configuration.
	DashPackage *DashPackage `locationName:"dashPackage" type:"structure"`

	Description *string `locationName:"description" type:"string"`

	// An HTTP Live Streaming (HLS) packaging configuration.
	HlsPackage *HlsPackage `locationName:"hlsPackage" type:"structure"`

	Id *string `locationName:"id" type:"string"`

	ManifestName *string `locationName:"manifestName" type:"string"`

	// A Microsoft Smooth Streaming (MSS) packaging configuration.
	MssPackage *MssPackage `locationName:"mssPackage" type:"structure"`

	Origination *string `locationName:"origination" type:"string" enum:"Origination"`

	StartoverWindowSeconds *int64 `locationName:"startoverWindowSeconds" type:"integer"`

	// A collection of tags associated with a resource
	Tags map[string]*string `locationName:"tags" type:"map"`

	TimeDelaySeconds *int64 `locationName:"timeDelaySeconds" type:"integer"`

	Url *string `locationName:"url" type:"string"`

	Whitelist []*string `locationName:"whitelist" type:"list"`
}

// String returns the string representation
func (s UpdateOriginEndpointOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateOriginEndpointOutput) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *UpdateOriginEndpointOutput) SetArn(v string) *UpdateOriginEndpointOutput {
	s.Arn = &v
	return s
}

// SetAuthorization sets the Authorization field's value.
func (s *UpdateOriginEndpointOutput) SetAuthorization(v *Authorization) *UpdateOriginEndpointOutput {
	s.Authorization = v
	return s
}

// SetChannelId sets the ChannelId field's value.
func (s *UpdateOriginEndpointOutput) SetChannelId(v string) *UpdateOriginEndpointOutput {
	s.ChannelId = &v
	return s
}

// SetCmafPackage sets the CmafPackage field's value.
func (s *UpdateOriginEndpointOutput) SetCmafPackage(v *CmafPackage) *UpdateOriginEndpointOutput {
	s.CmafPackage = v
	return s
}

// SetDashPackage sets the DashPackage field's value.
func (s *UpdateOriginEndpointOutput) SetDashPackage(v *DashPackage) *UpdateOriginEndpointOutput {
	s.DashPackage = v
	return s
}

// SetDescription sets the Description field's value.
func (s *UpdateOriginEndpointOutput) SetDescription(v string) *UpdateOriginEndpointOutput {
	s.Description = &v
	return s
}

// SetHlsPackage sets the HlsPackage field's value.
func (s *UpdateOriginEndpointOutput) SetHlsPackage(v *HlsPackage) *UpdateOriginEndpointOutput {
	s.HlsPackage = v
	return s
}

// SetId sets the Id field's value.
func (s *UpdateOriginEndpointOutput) SetId(v string) *UpdateOriginEndpointOutput {
	s.Id = &v
	return s
}

// SetManifestName sets the ManifestName field's value.
func (s *UpdateOriginEndpointOutput) SetManifestName(v string) *UpdateOriginEndpointOutput {
	s.ManifestName = &v
	return s
}

// SetMssPackage sets the MssPackage field's value.
func (s *UpdateOriginEndpointOutput) SetMssPackage(v *MssPackage) *UpdateOriginEndpointOutput {
	s.MssPackage = v
	return s
}

// SetOrigination sets the Origination field's value.
func (s *UpdateOriginEndpointOutput) SetOrigination(v string) *UpdateOriginEndpointOutput {
	s.Origination = &v
	return s
}

// SetStartoverWindowSeconds sets the StartoverWindowSeconds field's value.
func (s *UpdateOriginEndpointOutput) SetStartoverWindowSeconds(v int64) *UpdateOriginEndpointOutput {
	s.StartoverWindowSeconds = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *UpdateOriginEndpointOutput) SetTags(v map[string]*string) *UpdateOriginEndpointOutput {
	s.Tags = v
	return s
}

// SetTimeDelaySeconds sets the TimeDelaySeconds field's value.
func (s *UpdateOriginEndpointOutput) SetTimeDelaySeconds(v int64) *UpdateOriginEndpointOutput {
	s.TimeDelaySeconds = &v
	return s
}

// SetUrl sets the Url field's value.
func (s *UpdateOriginEndpointOutput) SetUrl(v string) *UpdateOriginEndpointOutput {
	s.Url = &v
	return s
}

// SetWhitelist sets the Whitelist field's value.
func (s *UpdateOriginEndpointOutput) SetWhitelist(v []*string) *UpdateOriginEndpointOutput {
	s.Whitelist = v
	return s
}

const (
	// AdMarkersNone is a AdMarkers enum value
	AdMarkersNone = "NONE"

	// AdMarkersScte35Enhanced is a AdMarkers enum value
	AdMarkersScte35Enhanced = "SCTE35_ENHANCED"

	// AdMarkersPassthrough is a AdMarkers enum value
	AdMarkersPassthrough = "PASSTHROUGH"
)

// This setting allows the delivery restriction flags on SCTE-35 segmentation
// descriptors todetermine whether a message signals an ad. Choosing "NONE"
// means no SCTE-35 messages becomeads. Choosing "RESTRICTED" means SCTE-35
// messages of the types specified in AdTriggers thatcontain delivery restrictions
// will be treated as ads. Choosing "UNRESTRICTED" means SCTE-35messages of
// the types specified in AdTriggers that do not contain delivery restrictions
// willbe treated as ads. Choosing "BOTH" means all SCTE-35 messages of the
// types specified inAdTriggers will be treated as ads. Note that Splice Insert
// messages do not have these flagsand are always treated as ads if specified
// in AdTriggers.
const (
	// AdsOnDeliveryRestrictionsNone is a AdsOnDeliveryRestrictions enum value
	AdsOnDeliveryRestrictionsNone = "NONE"

	// AdsOnDeliveryRestrictionsRestricted is a AdsOnDeliveryRestrictions enum value
	AdsOnDeliveryRestrictionsRestricted = "RESTRICTED"

	// AdsOnDeliveryRestrictionsUnrestricted is a AdsOnDeliveryRestrictions enum value
	AdsOnDeliveryRestrictionsUnrestricted = "UNRESTRICTED"

	// AdsOnDeliveryRestrictionsBoth is a AdsOnDeliveryRestrictions enum value
	AdsOnDeliveryRestrictionsBoth = "BOTH"
)

const (
	// EncryptionMethodAes128 is a EncryptionMethod enum value
	EncryptionMethodAes128 = "AES_128"

	// EncryptionMethodSampleAes is a EncryptionMethod enum value
	EncryptionMethodSampleAes = "SAMPLE_AES"
)

const (
	// ManifestLayoutFull is a ManifestLayout enum value
	ManifestLayoutFull = "FULL"

	// ManifestLayoutCompact is a ManifestLayout enum value
	ManifestLayoutCompact = "COMPACT"
)

const (
	// OriginationAllow is a Origination enum value
	OriginationAllow = "ALLOW"

	// OriginationDeny is a Origination enum value
	OriginationDeny = "DENY"
)

const (
	// PlaylistTypeNone is a PlaylistType enum value
	PlaylistTypeNone = "NONE"

	// PlaylistTypeEvent is a PlaylistType enum value
	PlaylistTypeEvent = "EVENT"

	// PlaylistTypeVod is a PlaylistType enum value
	PlaylistTypeVod = "VOD"
)

const (
	// ProfileNone is a Profile enum value
	ProfileNone = "NONE"

	// ProfileHbbtv15 is a Profile enum value
	ProfileHbbtv15 = "HBBTV_1_5"
)

const (
	// SegmentTemplateFormatNumberWithTimeline is a SegmentTemplateFormat enum value
	SegmentTemplateFormatNumberWithTimeline = "NUMBER_WITH_TIMELINE"

	// SegmentTemplateFormatTimeWithTimeline is a SegmentTemplateFormat enum value
	SegmentTemplateFormatTimeWithTimeline = "TIME_WITH_TIMELINE"

	// SegmentTemplateFormatNumberWithDuration is a SegmentTemplateFormat enum value
	SegmentTemplateFormatNumberWithDuration = "NUMBER_WITH_DURATION"
)

const (
	// StatusInProgress is a Status enum value
	StatusInProgress = "IN_PROGRESS"

	// StatusSucceeded is a Status enum value
	StatusSucceeded = "SUCCEEDED"

	// StatusFailed is a Status enum value
	StatusFailed = "FAILED"
)

const (
	// StreamOrderOriginal is a StreamOrder enum value
	StreamOrderOriginal = "ORIGINAL"

	// StreamOrderVideoBitrateAscending is a StreamOrder enum value
	StreamOrderVideoBitrateAscending = "VIDEO_BITRATE_ASCENDING"

	// StreamOrderVideoBitrateDescending is a StreamOrder enum value
	StreamOrderVideoBitrateDescending = "VIDEO_BITRATE_DESCENDING"
)

const (
	// __AdTriggersElementSpliceInsert is a __AdTriggersElement enum value
	__AdTriggersElementSpliceInsert = "SPLICE_INSERT"

	// __AdTriggersElementBreak is a __AdTriggersElement enum value
	__AdTriggersElementBreak = "BREAK"

	// __AdTriggersElementProviderAdvertisement is a __AdTriggersElement enum value
	__AdTriggersElementProviderAdvertisement = "PROVIDER_ADVERTISEMENT"

	// __AdTriggersElementDistributorAdvertisement is a __AdTriggersElement enum value
	__AdTriggersElementDistributorAdvertisement = "DISTRIBUTOR_ADVERTISEMENT"

	// __AdTriggersElementProviderPlacementOpportunity is a __AdTriggersElement enum value
	__AdTriggersElementProviderPlacementOpportunity = "PROVIDER_PLACEMENT_OPPORTUNITY"

	// __AdTriggersElementDistributorPlacementOpportunity is a __AdTriggersElement enum value
	__AdTriggersElementDistributorPlacementOpportunity = "DISTRIBUTOR_PLACEMENT_OPPORTUNITY"

	// __AdTriggersElementProviderOverlayPlacementOpportunity is a __AdTriggersElement enum value
	__AdTriggersElementProviderOverlayPlacementOpportunity = "PROVIDER_OVERLAY_PLACEMENT_OPPORTUNITY"

	// __AdTriggersElementDistributorOverlayPlacementOpportunity is a __AdTriggersElement enum value
	__AdTriggersElementDistributorOverlayPlacementOpportunity = "DISTRIBUTOR_OVERLAY_PLACEMENT_OPPORTUNITY"
)

const (
	// __PeriodTriggersElementAds is a __PeriodTriggersElement enum value
	__PeriodTriggersElementAds = "ADS"
)
