// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package ec2

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
	"github.com/aws/aws-sdk-go-v2/private/protocol/ec2query"
)

type DeleteVolumeInput struct {
	_ struct{} `type:"structure"`

	// Checks whether you have the required permissions for the action, without
	// actually making the request, and provides an error response. If you have
	// the required permissions, the error response is DryRunOperation. Otherwise,
	// it is UnauthorizedOperation.
	DryRun *bool `locationName:"dryRun" type:"boolean"`

	// The ID of the volume.
	//
	// VolumeId is a required field
	VolumeId *string `type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteVolumeInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteVolumeInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "DeleteVolumeInput"}

	if s.VolumeId == nil {
		invalidParams.Add(aws.NewErrParamRequired("VolumeId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type DeleteVolumeOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteVolumeOutput) String() string {
	return awsutil.Prettify(s)
}

const opDeleteVolume = "DeleteVolume"

// DeleteVolumeRequest returns a request value for making API operation for
// Amazon Elastic Compute Cloud.
//
// Deletes the specified EBS volume. The volume must be in the available state
// (not attached to an instance).
//
// The volume can remain in the deleting state for several minutes.
//
// For more information, see Deleting an Amazon EBS Volume (https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ebs-deleting-volume.html)
// in the Amazon Elastic Compute Cloud User Guide.
//
//    // Example sending a request using DeleteVolumeRequest.
//    req := client.DeleteVolumeRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteVolume
func (c *Client) DeleteVolumeRequest(input *DeleteVolumeInput) DeleteVolumeRequest {
	op := &aws.Operation{
		Name:       opDeleteVolume,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteVolumeInput{}
	}

	req := c.newRequest(op, input, &DeleteVolumeOutput{})
	req.Handlers.Unmarshal.Remove(ec2query.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)
	return DeleteVolumeRequest{Request: req, Input: input, Copy: c.DeleteVolumeRequest}
}

// DeleteVolumeRequest is the request type for the
// DeleteVolume API operation.
type DeleteVolumeRequest struct {
	*aws.Request
	Input *DeleteVolumeInput
	Copy  func(*DeleteVolumeInput) DeleteVolumeRequest
}

// Send marshals and sends the DeleteVolume API request.
func (r DeleteVolumeRequest) Send(ctx context.Context) (*DeleteVolumeResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &DeleteVolumeResponse{
		DeleteVolumeOutput: r.Request.Data.(*DeleteVolumeOutput),
		response:           &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// DeleteVolumeResponse is the response type for the
// DeleteVolume API operation.
type DeleteVolumeResponse struct {
	*DeleteVolumeOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// DeleteVolume request.
func (r *DeleteVolumeResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
