// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package eks

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
)

type UpdateClusterVersionInput struct {
	_ struct{} `type:"structure"`

	// Unique, case-sensitive identifier that you provide to ensure the idempotency
	// of the request.
	ClientRequestToken *string `locationName:"clientRequestToken" type:"string" idempotencyToken:"true"`

	// The name of the Amazon EKS cluster to update.
	//
	// Name is a required field
	Name *string `location:"uri" locationName:"name" type:"string" required:"true"`

	// The desired Kubernetes version following a successful update.
	//
	// Version is a required field
	Version *string `locationName:"version" type:"string" required:"true"`
}

// String returns the string representation
func (s UpdateClusterVersionInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateClusterVersionInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "UpdateClusterVersionInput"}

	if s.Name == nil {
		invalidParams.Add(aws.NewErrParamRequired("Name"))
	}

	if s.Version == nil {
		invalidParams.Add(aws.NewErrParamRequired("Version"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s UpdateClusterVersionInput) MarshalFields(e protocol.FieldEncoder) error {
	e.SetValue(protocol.HeaderTarget, "Content-Type", protocol.StringValue("application/json"), protocol.Metadata{})

	var ClientRequestToken string
	if s.ClientRequestToken != nil {
		ClientRequestToken = *s.ClientRequestToken
	} else {
		ClientRequestToken = protocol.GetIdempotencyToken()
	}
	{
		v := ClientRequestToken

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "clientRequestToken", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Version != nil {
		v := *s.Version

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "version", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Name != nil {
		v := *s.Name

		metadata := protocol.Metadata{}
		e.SetValue(protocol.PathTarget, "name", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

type UpdateClusterVersionOutput struct {
	_ struct{} `type:"structure"`

	// The full description of the specified update
	Update *Update `locationName:"update" type:"structure"`
}

// String returns the string representation
func (s UpdateClusterVersionOutput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s UpdateClusterVersionOutput) MarshalFields(e protocol.FieldEncoder) error {
	if s.Update != nil {
		v := s.Update

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "update", v, metadata)
	}
	return nil
}

const opUpdateClusterVersion = "UpdateClusterVersion"

// UpdateClusterVersionRequest returns a request value for making API operation for
// Amazon Elastic Kubernetes Service.
//
// Updates an Amazon EKS cluster to the specified Kubernetes version. Your cluster
// continues to function during the update. The response output includes an
// update ID that you can use to track the status of your cluster update with
// the DescribeUpdate API operation.
//
// Cluster updates are asynchronous, and they should finish within a few minutes.
// During an update, the cluster status moves to UPDATING (this status transition
// is eventually consistent). When the update is complete (either Failed or
// Successful), the cluster status moves to Active.
//
// If your cluster has managed node groups attached to it, all of your node
// groups’ Kubernetes versions must match the cluster’s Kubernetes version
// in order to update the cluster to a new Kubernetes version.
//
//    // Example sending a request using UpdateClusterVersionRequest.
//    req := client.UpdateClusterVersionRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/eks-2017-11-01/UpdateClusterVersion
func (c *Client) UpdateClusterVersionRequest(input *UpdateClusterVersionInput) UpdateClusterVersionRequest {
	op := &aws.Operation{
		Name:       opUpdateClusterVersion,
		HTTPMethod: "POST",
		HTTPPath:   "/clusters/{name}/updates",
	}

	if input == nil {
		input = &UpdateClusterVersionInput{}
	}

	req := c.newRequest(op, input, &UpdateClusterVersionOutput{})
	return UpdateClusterVersionRequest{Request: req, Input: input, Copy: c.UpdateClusterVersionRequest}
}

// UpdateClusterVersionRequest is the request type for the
// UpdateClusterVersion API operation.
type UpdateClusterVersionRequest struct {
	*aws.Request
	Input *UpdateClusterVersionInput
	Copy  func(*UpdateClusterVersionInput) UpdateClusterVersionRequest
}

// Send marshals and sends the UpdateClusterVersion API request.
func (r UpdateClusterVersionRequest) Send(ctx context.Context) (*UpdateClusterVersionResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &UpdateClusterVersionResponse{
		UpdateClusterVersionOutput: r.Request.Data.(*UpdateClusterVersionOutput),
		response:                   &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// UpdateClusterVersionResponse is the response type for the
// UpdateClusterVersion API operation.
type UpdateClusterVersionResponse struct {
	*UpdateClusterVersionOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// UpdateClusterVersion request.
func (r *UpdateClusterVersionResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
