// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package alexaforbusiness

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type RevokeInvitationInput struct {
	_ struct{} `type:"structure"`

	// The ARN of the enrollment invitation to revoke. Required.
	EnrollmentId *string `type:"string"`

	// The ARN of the user for whom to revoke an enrollment invitation. Required.
	UserArn *string `type:"string"`
}

// String returns the string representation
func (s RevokeInvitationInput) String() string {
	return awsutil.Prettify(s)
}

type RevokeInvitationOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s RevokeInvitationOutput) String() string {
	return awsutil.Prettify(s)
}

const opRevokeInvitation = "RevokeInvitation"

// RevokeInvitationRequest returns a request value for making API operation for
// Alexa For Business.
//
// Revokes an invitation and invalidates the enrollment URL.
//
//    // Example sending a request using RevokeInvitationRequest.
//    req := client.RevokeInvitationRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/RevokeInvitation
func (c *Client) RevokeInvitationRequest(input *RevokeInvitationInput) RevokeInvitationRequest {
	op := &aws.Operation{
		Name:       opRevokeInvitation,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &RevokeInvitationInput{}
	}

	req := c.newRequest(op, input, &RevokeInvitationOutput{})
	return RevokeInvitationRequest{Request: req, Input: input, Copy: c.RevokeInvitationRequest}
}

// RevokeInvitationRequest is the request type for the
// RevokeInvitation API operation.
type RevokeInvitationRequest struct {
	*aws.Request
	Input *RevokeInvitationInput
	Copy  func(*RevokeInvitationInput) RevokeInvitationRequest
}

// Send marshals and sends the RevokeInvitation API request.
func (r RevokeInvitationRequest) Send(ctx context.Context) (*RevokeInvitationResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &RevokeInvitationResponse{
		RevokeInvitationOutput: r.Request.Data.(*RevokeInvitationOutput),
		response:               &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// RevokeInvitationResponse is the response type for the
// RevokeInvitation API operation.
type RevokeInvitationResponse struct {
	*RevokeInvitationOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// RevokeInvitation request.
func (r *RevokeInvitationResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
